{-# LANGUAGE CPP #-}
{-# LANGUAGE TemplateHaskell #-}
module Values where

import Control.Monad (filterM)
import Data.Map as Map (Map, fromList, toList)
import Data.Ratio (Ratio)
import Data.Set as Set (Set, empty, fromList, toList, union)
import GHC.Prim -- ByteArray#, Char#, etc
import Language.Haskell.TH
import Language.Haskell.TH.TypeGraph.Arity (typeArity)
import Language.Haskell.TH.TypeGraph.Edges (typeGraphEdges)
import Language.Haskell.TH.TypeGraph.Expand (E(E), expandType)
import Language.Haskell.TH.TypeGraph.Vertex (TypeGraphVertex(..))
import Language.Haskell.TH.Desugar (withLocalDeclarations)
import Language.Haskell.TH.Instances ()
import Language.Haskell.TH.Syntax
import Test.Hspec hiding (runIO)
import Test.Hspec.Core.Spec (SpecM)

import Common

typeInfoOfType =
    unlines
#if MIN_VERSION_template_haskell(2,10,0)
    [ "TypeInfo:",
      "  typeSet:",
      "    [GHC.Types.Char]",
      "    [Language.Haskell.TH.Syntax.Pred]",
      "    [Language.Haskell.TH.Syntax.TyVarBndr]",
      "    GHC.Base.String",
      "    GHC.Prim.ByteArray#",
      "    GHC.Prim.Char#",
      "    GHC.Prim.Int#",
      "    GHC.Types.Char",
      "    GHC.Types.Int",
      "    GHC.Integer.Type.BigNat",
      "    GHC.Integer.Type.Integer",
      "    Language.Haskell.TH.Syntax.Cxt",
      "    Language.Haskell.TH.Syntax.Kind",
      "    Language.Haskell.TH.Syntax.ModName",
      "    Language.Haskell.TH.Syntax.Name",
      "    Language.Haskell.TH.Syntax.NameFlavour",
      "    Language.Haskell.TH.Syntax.NameSpace",
      "    Language.Haskell.TH.Syntax.OccName",
      "    Language.Haskell.TH.Syntax.PkgName",
      "    Language.Haskell.TH.Syntax.Pred",
      "    Language.Haskell.TH.Syntax.TyLit",
      "    Language.Haskell.TH.Syntax.TyVarBndr",
      "    Language.Haskell.TH.Syntax.Type",
      "    []",
      "  infoMap:",
      "    GHC.Base.String -> type GHC.Base.String = [GHC.Types.Char]",
      "    GHC.Prim.ByteArray# -> Primitive unlifted type constructor 'GHC.Prim.ByteArray#' (arity 0)",
      "    GHC.Prim.Char# -> Primitive unlifted type constructor 'GHC.Prim.Char#' (arity 0)",
      "    GHC.Prim.Int# -> Primitive unlifted type constructor 'GHC.Prim.Int#' (arity 0)",
      "    GHC.Types.Char -> data GHC.Types.Char = GHC.Types.C# GHC.Prim.Char#",
      "    GHC.Types.Int -> data GHC.Types.Int = GHC.Types.I# GHC.Prim.Int#",
      "    GHC.Integer.Type.BigNat -> data GHC.Integer.Type.BigNat",
      "        = GHC.Integer.Type.BN# GHC.Prim.ByteArray#",
      "    GHC.Integer.Type.Integer -> data GHC.Integer.Type.Integer",
      "        = GHC.Integer.Type.S# !GHC.Prim.Int#",
      "        | GHC.Integer.Type.Jp# {-# UNPACK #-} !GHC.Integer.Type.BigNat",
      "        | GHC.Integer.Type.Jn# {-# UNPACK #-} !GHC.Integer.Type.BigNat",
      "    Language.Haskell.TH.Syntax.Cxt -> type Language.Haskell.TH.Syntax.Cxt = [Language.Haskell.TH.Syntax.Pred]",
      "    Language.Haskell.TH.Syntax.Kind -> type Language.Haskell.TH.Syntax.Kind = Language.Haskell.TH.Syntax.Type",
      "    Language.Haskell.TH.Syntax.ModName -> newtype Language.Haskell.TH.Syntax.ModName",
      "      = Language.Haskell.TH.Syntax.ModName GHC.Base.String",
      "    Language.Haskell.TH.Syntax.Name -> data Language.Haskell.TH.Syntax.Name",
      "        = Language.Haskell.TH.Syntax.Name Language.Haskell.TH.Syntax.OccName",
      "                                          Language.Haskell.TH.Syntax.NameFlavour",
      "    Language.Haskell.TH.Syntax.NameFlavour -> data Language.Haskell.TH.Syntax.NameFlavour",
      "        = Language.Haskell.TH.Syntax.NameS",
      "        | Language.Haskell.TH.Syntax.NameQ Language.Haskell.TH.Syntax.ModName",
      "        | Language.Haskell.TH.Syntax.NameU {-# UNPACK #-} !GHC.Types.Int",
      "        | Language.Haskell.TH.Syntax.NameL {-# UNPACK #-} !GHC.Types.Int",
      "        | Language.Haskell.TH.Syntax.NameG Language.Haskell.TH.Syntax.NameSpace",
      "                                           Language.Haskell.TH.Syntax.PkgName",
      "                                           Language.Haskell.TH.Syntax.ModName",
      "    Language.Haskell.TH.Syntax.NameSpace -> data Language.Haskell.TH.Syntax.NameSpace",
      "        = Language.Haskell.TH.Syntax.VarName",
      "        | Language.Haskell.TH.Syntax.DataName",
      "        | Language.Haskell.TH.Syntax.TcClsName",
      "    Language.Haskell.TH.Syntax.OccName -> newtype Language.Haskell.TH.Syntax.OccName",
      "      = Language.Haskell.TH.Syntax.OccName GHC.Base.String",
      "    Language.Haskell.TH.Syntax.PkgName -> newtype Language.Haskell.TH.Syntax.PkgName",
      "      = Language.Haskell.TH.Syntax.PkgName GHC.Base.String",
      "    Language.Haskell.TH.Syntax.Pred -> type Language.Haskell.TH.Syntax.Pred = Language.Haskell.TH.Syntax.Type",
      "    Language.Haskell.TH.Syntax.TyLit -> data Language.Haskell.TH.Syntax.TyLit",
      "        = Language.Haskell.TH.Syntax.NumTyLit GHC.Integer.Type.Integer",
      "        | Language.Haskell.TH.Syntax.StrTyLit GHC.Base.String",
      "    Language.Haskell.TH.Syntax.TyVarBndr -> data Language.Haskell.TH.Syntax.TyVarBndr",
      "        = Language.Haskell.TH.Syntax.PlainTV Language.Haskell.TH.Syntax.Name",
      "        | Language.Haskell.TH.Syntax.KindedTV Language.Haskell.TH.Syntax.Name",
      "                                              Language.Haskell.TH.Syntax.Kind",
      "    Language.Haskell.TH.Syntax.Type -> data Language.Haskell.TH.Syntax.Type",
      "        = Language.Haskell.TH.Syntax.ForallT ([Language.Haskell.TH.Syntax.TyVarBndr])",
      "                                             Language.Haskell.TH.Syntax.Cxt",
      "                                             Language.Haskell.TH.Syntax.Type",
      "        | Language.Haskell.TH.Syntax.AppT Language.Haskell.TH.Syntax.Type",
      "                                          Language.Haskell.TH.Syntax.Type",
      "        | Language.Haskell.TH.Syntax.SigT Language.Haskell.TH.Syntax.Type",
      "                                          Language.Haskell.TH.Syntax.Kind",
      "        | Language.Haskell.TH.Syntax.VarT Language.Haskell.TH.Syntax.Name",
      "        | Language.Haskell.TH.Syntax.ConT Language.Haskell.TH.Syntax.Name",
      "        | Language.Haskell.TH.Syntax.PromotedT Language.Haskell.TH.Syntax.Name",
      "        | Language.Haskell.TH.Syntax.TupleT GHC.Types.Int",
      "        | Language.Haskell.TH.Syntax.UnboxedTupleT GHC.Types.Int",
      "        | Language.Haskell.TH.Syntax.ArrowT",
      "        | Language.Haskell.TH.Syntax.EqualityT",
      "        | Language.Haskell.TH.Syntax.ListT",
      "        | Language.Haskell.TH.Syntax.PromotedTupleT GHC.Types.Int",
      "        | Language.Haskell.TH.Syntax.PromotedNilT",
      "        | Language.Haskell.TH.Syntax.PromotedConsT",
      "        | Language.Haskell.TH.Syntax.StarT",
      "        | Language.Haskell.TH.Syntax.ConstraintT",
      "        | Language.Haskell.TH.Syntax.LitT Language.Haskell.TH.Syntax.TyLit",
      "  expanded:",
      "    [GHC.Types.Char] -> [GHC.Types.Char]",
      "    [Language.Haskell.TH.Syntax.Pred] -> [Language.Haskell.TH.Syntax.Type]",
      "    [Language.Haskell.TH.Syntax.TyVarBndr] -> [Language.Haskell.TH.Syntax.TyVarBndr]",
      "    GHC.Base.String -> [GHC.Types.Char]",
      "    GHC.Prim.ByteArray# -> GHC.Prim.ByteArray#",
      "    GHC.Prim.Char# -> GHC.Prim.Char#",
      "    GHC.Prim.Int# -> GHC.Prim.Int#",
      "    GHC.Types.Char -> GHC.Types.Char",
      "    GHC.Types.Int -> GHC.Types.Int",
      "    GHC.Integer.Type.BigNat -> GHC.Integer.Type.BigNat",
      "    GHC.Integer.Type.Integer -> GHC.Integer.Type.Integer",
      "    Language.Haskell.TH.Syntax.Cxt -> [Language.Haskell.TH.Syntax.Type]",
      "    Language.Haskell.TH.Syntax.Kind -> Language.Haskell.TH.Syntax.Type",
      "    Language.Haskell.TH.Syntax.ModName -> Language.Haskell.TH.Syntax.ModName",
      "    Language.Haskell.TH.Syntax.Name -> Language.Haskell.TH.Syntax.Name",
      "    Language.Haskell.TH.Syntax.NameFlavour -> Language.Haskell.TH.Syntax.NameFlavour",
      "    Language.Haskell.TH.Syntax.NameSpace -> Language.Haskell.TH.Syntax.NameSpace",
      "    Language.Haskell.TH.Syntax.OccName -> Language.Haskell.TH.Syntax.OccName",
      "    Language.Haskell.TH.Syntax.PkgName -> Language.Haskell.TH.Syntax.PkgName",
      "    Language.Haskell.TH.Syntax.Pred -> Language.Haskell.TH.Syntax.Type",
      "    Language.Haskell.TH.Syntax.TyLit -> Language.Haskell.TH.Syntax.TyLit",
      "    Language.Haskell.TH.Syntax.TyVarBndr -> Language.Haskell.TH.Syntax.TyVarBndr",
      "    Language.Haskell.TH.Syntax.Type -> Language.Haskell.TH.Syntax.Type",
      "    [] -> []",
      "  synonyms:",
      "    [GHC.Types.Char] -> fromList [GHC.Base.String]",
      "    [Language.Haskell.TH.Syntax.Type] -> fromList [Language.Haskell.TH.Syntax.Cxt]",
      "    GHC.Types.Char -> fromList [GHC.Types.Char]",
      "    GHC.Types.Int -> fromList [GHC.Types.Int]",
      "    GHC.Integer.Type.BigNat -> fromList [GHC.Integer.Type.BigNat]",
      "    GHC.Integer.Type.Integer -> fromList [GHC.Integer.Type.Integer]",
      "    Language.Haskell.TH.Syntax.ModName -> fromList [Language.Haskell.TH.Syntax.ModName]",
      "    Language.Haskell.TH.Syntax.Name -> fromList [Language.Haskell.TH.Syntax.Name]",
      "    Language.Haskell.TH.Syntax.NameFlavour -> fromList [Language.Haskell.TH.Syntax.NameFlavour]",
      "    Language.Haskell.TH.Syntax.NameSpace -> fromList [Language.Haskell.TH.Syntax.NameSpace]",
      "    Language.Haskell.TH.Syntax.OccName -> fromList [Language.Haskell.TH.Syntax.OccName]",
      "    Language.Haskell.TH.Syntax.PkgName -> fromList [Language.Haskell.TH.Syntax.PkgName]",
      "    Language.Haskell.TH.Syntax.TyLit -> fromList [Language.Haskell.TH.Syntax.TyLit]",
      "    Language.Haskell.TH.Syntax.TyVarBndr -> fromList [Language.Haskell.TH.Syntax.TyVarBndr]",
      "    Language.Haskell.TH.Syntax.Type -> fromList [Language.Haskell.TH.Syntax.Kind,Language.Haskell.TH.Syntax.Pred,Language.Haskell.TH.Syntax.Type]",
      "  fields:",
      "    [GHC.Types.Char] -> fromList [(Language.Haskell.TH.Syntax.ModName,Language.Haskell.TH.Syntax.ModName,Left 1),(Language.Haskell.TH.Syntax.OccName,Language.Haskell.TH.Syntax.OccName,Left 1),(Language.Haskell.TH.Syntax.PkgName,Language.Haskell.TH.Syntax.PkgName,Left 1),(Language.Haskell.TH.Syntax.TyLit,Language.Haskell.TH.Syntax.StrTyLit,Left 1)]",
      "    [Language.Haskell.TH.Syntax.TyVarBndr] -> fromList [(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.ForallT,Left 1)]",
      "    [Language.Haskell.TH.Syntax.Type] -> fromList [(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.ForallT,Left 2)]",
      "    GHC.Prim.ByteArray# -> fromList [(GHC.Integer.Type.BigNat,GHC.Integer.Type.BN#,Left 1)]",
      "    GHC.Prim.Char# -> fromList [(GHC.Types.Char,GHC.Types.C#,Left 1)]",
      "    GHC.Prim.Int# -> fromList [(GHC.Types.Int,GHC.Types.I#,Left 1),(GHC.Integer.Type.Integer,GHC.Integer.Type.S#,Left 1)]",
      "    GHC.Types.Int -> fromList [(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameL,Left 1),(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameU,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.PromotedTupleT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.TupleT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.UnboxedTupleT,Left 1)]",
      "    GHC.Integer.Type.BigNat -> fromList [(GHC.Integer.Type.Integer,GHC.Integer.Type.Jn#,Left 1),(GHC.Integer.Type.Integer,GHC.Integer.Type.Jp#,Left 1)]",
      "    GHC.Integer.Type.Integer -> fromList [(Language.Haskell.TH.Syntax.TyLit,Language.Haskell.TH.Syntax.NumTyLit,Left 1)]",
      "    Language.Haskell.TH.Syntax.ModName -> fromList [(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameG,Left 3),(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameQ,Left 1)]",
      "    Language.Haskell.TH.Syntax.Name -> fromList [(Language.Haskell.TH.Syntax.TyVarBndr,Language.Haskell.TH.Syntax.KindedTV,Left 1),(Language.Haskell.TH.Syntax.TyVarBndr,Language.Haskell.TH.Syntax.PlainTV,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.ConT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.PromotedT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.VarT,Left 1)]",
      "    Language.Haskell.TH.Syntax.NameFlavour -> fromList [(Language.Haskell.TH.Syntax.Name,Language.Haskell.TH.Syntax.Name,Left 2)]",
      "    Language.Haskell.TH.Syntax.NameSpace -> fromList [(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameG,Left 1)]",
      "    Language.Haskell.TH.Syntax.OccName -> fromList [(Language.Haskell.TH.Syntax.Name,Language.Haskell.TH.Syntax.Name,Left 1)]",
      "    Language.Haskell.TH.Syntax.PkgName -> fromList [(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameG,Left 2)]",
      "    Language.Haskell.TH.Syntax.TyLit -> fromList [(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.LitT,Left 1)]",
      "    Language.Haskell.TH.Syntax.Type -> fromList [(Language.Haskell.TH.Syntax.TyVarBndr,Language.Haskell.TH.Syntax.KindedTV,Left 2),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.AppT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.AppT,Left 2),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.ForallT,Left 3),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.SigT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.SigT,Left 2)]" ]
#else
    [ "TypeGraphInfo:",
      "  typeSet:",
      "    [GHC.Types.Char]",
      "    [Language.Haskell.TH.Syntax.Pred]",
      "    [Language.Haskell.TH.Syntax.TyVarBndr]",
      "    [Language.Haskell.TH.Syntax.Type]",
      "    GHC.Base.String",
      "    GHC.Prim.ByteArray#",
      "    GHC.Prim.Char#",
      "    GHC.Prim.Int#",
      "    GHC.Types.Char",
      "    GHC.Types.Int",
      "    GHC.Integer.Type.Integer",
      "    Language.Haskell.TH.Syntax.Cxt",
      "    Language.Haskell.TH.Syntax.Kind",
      "    Language.Haskell.TH.Syntax.ModName",
      "    Language.Haskell.TH.Syntax.Name",
      "    Language.Haskell.TH.Syntax.NameFlavour",
      "    Language.Haskell.TH.Syntax.NameSpace",
      "    Language.Haskell.TH.Syntax.OccName",
      "    Language.Haskell.TH.Syntax.PkgName",
      "    Language.Haskell.TH.Syntax.Pred",
      "    Language.Haskell.TH.Syntax.TyLit",
      "    Language.Haskell.TH.Syntax.TyVarBndr",
      "    Language.Haskell.TH.Syntax.Type",
      "    []",
      "  infoMap:",
      "    GHC.Base.String -> type GHC.Base.String = [GHC.Types.Char]",
      "    GHC.Prim.ByteArray# -> Primitive unlifted type constructor 'GHC.Prim.ByteArray#' (arity 0)",
      "    GHC.Prim.Char# -> Primitive unlifted type constructor 'GHC.Prim.Char#' (arity 0)",
      "    GHC.Prim.Int# -> Primitive unlifted type constructor 'GHC.Prim.Int#' (arity 0)",
      "    GHC.Types.Char -> data GHC.Types.Char = GHC.Types.C# GHC.Prim.Char#",
      "    GHC.Types.Int -> data GHC.Types.Int = GHC.Types.I# GHC.Prim.Int#",
      "    GHC.Integer.Type.Integer -> data GHC.Integer.Type.Integer",
      "        = GHC.Integer.Type.S# GHC.Prim.Int#",
      "        | GHC.Integer.Type.J# GHC.Prim.Int# GHC.Prim.ByteArray#",
      "    Language.Haskell.TH.Syntax.Cxt -> type Language.Haskell.TH.Syntax.Cxt = [Language.Haskell.TH.Syntax.Pred]",
      "    Language.Haskell.TH.Syntax.Kind -> type Language.Haskell.TH.Syntax.Kind = Language.Haskell.TH.Syntax.Type",
      "    Language.Haskell.TH.Syntax.ModName -> newtype Language.Haskell.TH.Syntax.ModName",
      "      = Language.Haskell.TH.Syntax.ModName GHC.Base.String",
      "    Language.Haskell.TH.Syntax.Name -> data Language.Haskell.TH.Syntax.Name",
      "        = Language.Haskell.TH.Syntax.Name Language.Haskell.TH.Syntax.OccName",
      "                                          Language.Haskell.TH.Syntax.NameFlavour",
      "    Language.Haskell.TH.Syntax.NameFlavour -> data Language.Haskell.TH.Syntax.NameFlavour",
      "        = Language.Haskell.TH.Syntax.NameS",
      "        | Language.Haskell.TH.Syntax.NameQ Language.Haskell.TH.Syntax.ModName",
      "        | Language.Haskell.TH.Syntax.NameU GHC.Prim.Int#",
      "        | Language.Haskell.TH.Syntax.NameL GHC.Prim.Int#",
      "        | Language.Haskell.TH.Syntax.NameG Language.Haskell.TH.Syntax.NameSpace",
      "                                           Language.Haskell.TH.Syntax.PkgName",
      "                                           Language.Haskell.TH.Syntax.ModName",
      "    Language.Haskell.TH.Syntax.NameSpace -> data Language.Haskell.TH.Syntax.NameSpace",
      "        = Language.Haskell.TH.Syntax.VarName",
      "        | Language.Haskell.TH.Syntax.DataName",
      "        | Language.Haskell.TH.Syntax.TcClsName",
      "    Language.Haskell.TH.Syntax.OccName -> newtype Language.Haskell.TH.Syntax.OccName",
      "      = Language.Haskell.TH.Syntax.OccName GHC.Base.String",
      "    Language.Haskell.TH.Syntax.PkgName -> newtype Language.Haskell.TH.Syntax.PkgName",
      "      = Language.Haskell.TH.Syntax.PkgName GHC.Base.String",
      "    Language.Haskell.TH.Syntax.Pred -> data Language.Haskell.TH.Syntax.Pred",
      "        = Language.Haskell.TH.Syntax.ClassP Language.Haskell.TH.Syntax.Name",
      "                                            ([Language.Haskell.TH.Syntax.Type])",
      "        | Language.Haskell.TH.Syntax.EqualP Language.Haskell.TH.Syntax.Type",
      "                                            Language.Haskell.TH.Syntax.Type",
      "    Language.Haskell.TH.Syntax.TyLit -> data Language.Haskell.TH.Syntax.TyLit",
      "        = Language.Haskell.TH.Syntax.NumTyLit GHC.Integer.Type.Integer",
      "        | Language.Haskell.TH.Syntax.StrTyLit GHC.Base.String",
      "    Language.Haskell.TH.Syntax.TyVarBndr -> data Language.Haskell.TH.Syntax.TyVarBndr",
      "        = Language.Haskell.TH.Syntax.PlainTV Language.Haskell.TH.Syntax.Name",
      "        | Language.Haskell.TH.Syntax.KindedTV Language.Haskell.TH.Syntax.Name",
      "                                              Language.Haskell.TH.Syntax.Kind",
      "    Language.Haskell.TH.Syntax.Type -> data Language.Haskell.TH.Syntax.Type",
      "        = Language.Haskell.TH.Syntax.ForallT ([Language.Haskell.TH.Syntax.TyVarBndr])",
      "                                             Language.Haskell.TH.Syntax.Cxt",
      "                                             Language.Haskell.TH.Syntax.Type",
      "        | Language.Haskell.TH.Syntax.AppT Language.Haskell.TH.Syntax.Type",
      "                                          Language.Haskell.TH.Syntax.Type",
      "        | Language.Haskell.TH.Syntax.SigT Language.Haskell.TH.Syntax.Type",
      "                                          Language.Haskell.TH.Syntax.Kind",
      "        | Language.Haskell.TH.Syntax.VarT Language.Haskell.TH.Syntax.Name",
      "        | Language.Haskell.TH.Syntax.ConT Language.Haskell.TH.Syntax.Name",
      "        | Language.Haskell.TH.Syntax.PromotedT Language.Haskell.TH.Syntax.Name",
      "        | Language.Haskell.TH.Syntax.TupleT GHC.Types.Int",
      "        | Language.Haskell.TH.Syntax.UnboxedTupleT GHC.Types.Int",
      "        | Language.Haskell.TH.Syntax.ArrowT",
      "        | Language.Haskell.TH.Syntax.ListT",
      "        | Language.Haskell.TH.Syntax.PromotedTupleT GHC.Types.Int",
      "        | Language.Haskell.TH.Syntax.PromotedNilT",
      "        | Language.Haskell.TH.Syntax.PromotedConsT",
      "        | Language.Haskell.TH.Syntax.StarT",
      "        | Language.Haskell.TH.Syntax.ConstraintT",
      "        | Language.Haskell.TH.Syntax.LitT Language.Haskell.TH.Syntax.TyLit",
      "  expanded:",
      "    [GHC.Types.Char] -> [GHC.Types.Char]",
      "    [Language.Haskell.TH.Syntax.Pred] -> [Language.Haskell.TH.Syntax.Pred]",
      "    [Language.Haskell.TH.Syntax.TyVarBndr] -> [Language.Haskell.TH.Syntax.TyVarBndr]",
      "    [Language.Haskell.TH.Syntax.Type] -> [Language.Haskell.TH.Syntax.Type]",
      "    GHC.Base.String -> [GHC.Types.Char]",
      "    GHC.Prim.ByteArray# -> GHC.Prim.ByteArray#",
      "    GHC.Prim.Char# -> GHC.Prim.Char#",
      "    GHC.Prim.Int# -> GHC.Prim.Int#",
      "    GHC.Types.Char -> GHC.Types.Char",
      "    GHC.Types.Int -> GHC.Types.Int",
      "    GHC.Integer.Type.Integer -> GHC.Integer.Type.Integer",
      "    Language.Haskell.TH.Syntax.Cxt -> [Language.Haskell.TH.Syntax.Pred]",
      "    Language.Haskell.TH.Syntax.Kind -> Language.Haskell.TH.Syntax.Type",
      "    Language.Haskell.TH.Syntax.ModName -> Language.Haskell.TH.Syntax.ModName",
      "    Language.Haskell.TH.Syntax.Name -> Language.Haskell.TH.Syntax.Name",
      "    Language.Haskell.TH.Syntax.NameFlavour -> Language.Haskell.TH.Syntax.NameFlavour",
      "    Language.Haskell.TH.Syntax.NameSpace -> Language.Haskell.TH.Syntax.NameSpace",
      "    Language.Haskell.TH.Syntax.OccName -> Language.Haskell.TH.Syntax.OccName",
      "    Language.Haskell.TH.Syntax.PkgName -> Language.Haskell.TH.Syntax.PkgName",
      "    Language.Haskell.TH.Syntax.Pred -> Language.Haskell.TH.Syntax.Pred",
      "    Language.Haskell.TH.Syntax.TyLit -> Language.Haskell.TH.Syntax.TyLit",
      "    Language.Haskell.TH.Syntax.TyVarBndr -> Language.Haskell.TH.Syntax.TyVarBndr",
      "    Language.Haskell.TH.Syntax.Type -> Language.Haskell.TH.Syntax.Type",
      "    [] -> []",
      "  synonyms:",
      "    [GHC.Types.Char] -> fromList [GHC.Base.String]",
      "    [Language.Haskell.TH.Syntax.Pred] -> fromList [Language.Haskell.TH.Syntax.Cxt]",
      "    Language.Haskell.TH.Syntax.Type -> fromList [Language.Haskell.TH.Syntax.Kind]",
      "  fields:",
      "    [GHC.Types.Char] -> fromList [(Language.Haskell.TH.Syntax.ModName,Language.Haskell.TH.Syntax.ModName,Left 1),(Language.Haskell.TH.Syntax.OccName,Language.Haskell.TH.Syntax.OccName,Left 1),(Language.Haskell.TH.Syntax.PkgName,Language.Haskell.TH.Syntax.PkgName,Left 1),(Language.Haskell.TH.Syntax.TyLit,Language.Haskell.TH.Syntax.StrTyLit,Left 1)]",
      "    [Language.Haskell.TH.Syntax.Pred] -> fromList [(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.ForallT,Left 2)]",
      "    [Language.Haskell.TH.Syntax.TyVarBndr] -> fromList [(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.ForallT,Left 1)]",
      "    [Language.Haskell.TH.Syntax.Type] -> fromList [(Language.Haskell.TH.Syntax.Pred,Language.Haskell.TH.Syntax.ClassP,Left 2)]",
      "    GHC.Prim.ByteArray# -> fromList [(GHC.Integer.Type.Integer,GHC.Integer.Type.J#,Left 2)]",
      "    GHC.Prim.Char# -> fromList [(GHC.Types.Char,GHC.Types.C#,Left 1)]",
      "    GHC.Prim.Int# -> fromList [(GHC.Types.Int,GHC.Types.I#,Left 1),(GHC.Integer.Type.Integer,GHC.Integer.Type.J#,Left 1),(GHC.Integer.Type.Integer,GHC.Integer.Type.S#,Left 1),(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameL,Left 1),(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameU,Left 1)]",
      "    GHC.Types.Int -> fromList [(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.PromotedTupleT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.TupleT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.UnboxedTupleT,Left 1)]",
      "    GHC.Integer.Type.Integer -> fromList [(Language.Haskell.TH.Syntax.TyLit,Language.Haskell.TH.Syntax.NumTyLit,Left 1)]",
      "    Language.Haskell.TH.Syntax.ModName -> fromList [(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameG,Left 3),(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameQ,Left 1)]",
      "    Language.Haskell.TH.Syntax.Name -> fromList [(Language.Haskell.TH.Syntax.Pred,Language.Haskell.TH.Syntax.ClassP,Left 1),(Language.Haskell.TH.Syntax.TyVarBndr,Language.Haskell.TH.Syntax.KindedTV,Left 1),(Language.Haskell.TH.Syntax.TyVarBndr,Language.Haskell.TH.Syntax.PlainTV,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.ConT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.PromotedT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.VarT,Left 1)]",
      "    Language.Haskell.TH.Syntax.NameFlavour -> fromList [(Language.Haskell.TH.Syntax.Name,Language.Haskell.TH.Syntax.Name,Left 2)]",
      "    Language.Haskell.TH.Syntax.NameSpace -> fromList [(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameG,Left 1)]",
      "    Language.Haskell.TH.Syntax.OccName -> fromList [(Language.Haskell.TH.Syntax.Name,Language.Haskell.TH.Syntax.Name,Left 1)]",
      "    Language.Haskell.TH.Syntax.PkgName -> fromList [(Language.Haskell.TH.Syntax.NameFlavour,Language.Haskell.TH.Syntax.NameG,Left 2)]",
      "    Language.Haskell.TH.Syntax.TyLit -> fromList [(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.LitT,Left 1)]",
      "    Language.Haskell.TH.Syntax.Type -> fromList [(Language.Haskell.TH.Syntax.Pred,Language.Haskell.TH.Syntax.EqualP,Left 1),(Language.Haskell.TH.Syntax.Pred,Language.Haskell.TH.Syntax.EqualP,Left 2),(Language.Haskell.TH.Syntax.TyVarBndr,Language.Haskell.TH.Syntax.KindedTV,Left 2),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.AppT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.AppT,Left 2),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.ForallT,Left 3),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.SigT,Left 1),(Language.Haskell.TH.Syntax.Type,Language.Haskell.TH.Syntax.SigT,Left 2)]" ]
#endif

subtypesOfType :: Set String
subtypesOfType =
    Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
     "BigNat","BigNat (field Integer.Jn#[1])","BigNat (field Integer.Jp#[1])","ByteArray#","ByteArray# (field BigNat.BN#[1])","Char","Char#","Char# (field Char.C#[1])","Int","Int (field NameFlavour.NameL[1])","Int (field NameFlavour.NameU[1])","Int (field Type.PromotedTupleT[1])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Int#","Int# (field Int.I#[1])","Int# (field Integer.S#[1])","Integer","Integer (field TyLit.NumTyLit[1])","ModName","ModName (field NameFlavour.NameG[3])","ModName (field NameFlavour.NameQ[1])","Name","Name (field TyVarBndr.KindedTV[1])","Name (field TyVarBndr.PlainTV[1])","Name (field Type.ConT[1])","Name (field Type.PromotedT[1])","Name (field Type.VarT[1])","NameFlavour","NameFlavour (field Name.Name[2])","NameSpace","NameSpace (field NameFlavour.NameG[1])","OccName","OccName (field Name.Name[1])","PkgName","PkgName (field NameFlavour.NameG[2])","TyLit","TyLit (field Type.LitT[1])","TyVarBndr","Type (aka Kind, aka Pred)","Type (aka Kind, aka Pred, field TyVarBndr.KindedTV[2])","Type (aka Kind, aka Pred, field Type.AppT[1])","Type (aka Kind, aka Pred, field Type.AppT[2])","Type (aka Kind, aka Pred, field Type.ForallT[3])","Type (aka Kind, aka Pred, field Type.SigT[1])","Type (aka Kind, aka Pred, field Type.SigT[2])","[Char] (aka String)","[Char] (aka String, field ModName.ModName[1])","[Char] (aka String, field OccName.OccName[1])","[Char] (aka String, field PkgName.PkgName[1])","[Char] (aka String, field TyLit.StrTyLit[1])","[TyVarBndr]","[TyVarBndr] (field Type.ForallT[1])","[Type] (aka Cxt)","[Type] (aka Cxt, field Type.ForallT[2])","[]"
#else
     "ByteArray#","ByteArray# (field Integer.J#[2])","Char","Char#","Char# (field Char.C#[1])","Int","Int (field Type.PromotedTupleT[1])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Int#","Int# (field Int.I#[1])","Int# (field Integer.J#[1])","Int# (field Integer.S#[1])","Int# (field NameFlavour.NameL[1])","Int# (field NameFlavour.NameU[1])","Integer","Integer (field TyLit.NumTyLit[1])","ModName","ModName (field NameFlavour.NameG[3])","ModName (field NameFlavour.NameQ[1])","Name","Name (field Pred.ClassP[1])","Name (field TyVarBndr.KindedTV[1])","Name (field TyVarBndr.PlainTV[1])","Name (field Type.ConT[1])","Name (field Type.PromotedT[1])","Name (field Type.VarT[1])","NameFlavour","NameFlavour (field Name.Name[2])","NameSpace","NameSpace (field NameFlavour.NameG[1])","OccName","OccName (field Name.Name[1])","PkgName","PkgName (field NameFlavour.NameG[2])","Pred","TyLit","TyLit (field Type.LitT[1])","TyVarBndr","Type (aka Kind)","Type (aka Kind, field Pred.EqualP[1])","Type (aka Kind, field Pred.EqualP[2])","Type (aka Kind, field TyVarBndr.KindedTV[2])","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Type (aka Kind, field Type.ForallT[3])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","[Char] (aka String)","[Char] (aka String, field ModName.ModName[1])","[Char] (aka String, field OccName.OccName[1])","[Char] (aka String, field PkgName.PkgName[1])","[Char] (aka String, field TyLit.StrTyLit[1])","[Pred] (aka Cxt)","[Pred] (aka Cxt, field Type.ForallT[2])","[TyVarBndr]","[TyVarBndr] (field Type.ForallT[1])","[Type]","[Type] (field Pred.ClassP[2])","[]"
#endif
    ]

simpleTypeEdges :: Set (String, Set String)
simpleTypeEdges =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
     ("BigNat",Set.fromList ["ByteArray#"]),
     ("ByteArray#",Set.fromList []),
     ("Char",Set.fromList ["Char#"]),
     ("Char#",Set.fromList []),
     ("Int",Set.fromList ["Int#"]),
     ("Int#",Set.fromList []),
     ("Integer",Set.fromList ["Int#","BigNat"]),
     ("ModName",Set.fromList ["[Char] (aka String)"]),
     ("Name",Set.fromList ["NameFlavour","OccName"]),
     ("NameFlavour",Set.fromList ["Int","ModName","NameSpace","PkgName"]),
     ("NameSpace",Set.fromList []),
     ("OccName",Set.fromList ["[Char] (aka String)"]),
     ("PkgName",Set.fromList ["[Char] (aka String)"]),
     ("TyLit",Set.fromList ["Integer","[Char] (aka String)"]),
     ("TyVarBndr",Set.fromList ["Name","Type (aka Kind, aka Pred)"]),
     ("Type (aka Kind, aka Pred)",Set.fromList ["[TyVarBndr]","Int","Name","TyLit","[Type] (aka Cxt)"]),
     ("[Char] (aka String)",Set.fromList ["Char","[]"]),
     ("[TyVarBndr]",Set.fromList ["TyVarBndr","[]"]),
     ("[Type] (aka Cxt)",Set.fromList ["[]","Type (aka Kind, aka Pred)"]),
     ("[]",Set.fromList [])
#else
     ("ByteArray#",Set.fromList []),
     ("Char",Set.fromList ["Char#"]),
     ("Char#",Set.fromList []),
     ("Int",Set.fromList ["Int#"]),
     ("Int#",Set.fromList []),
     ("Integer",Set.fromList ["ByteArray#","Int#"]),
     ("ModName",Set.fromList ["[Char] (aka String)"]),
     ("Name",Set.fromList ["NameFlavour","OccName"]),
     ("NameFlavour",Set.fromList ["Int#","ModName","NameSpace","PkgName"]),
     ("NameSpace",Set.fromList []),
     ("OccName",Set.fromList ["[Char] (aka String)"]),
     ("PkgName",Set.fromList ["[Char] (aka String)"]),
     ("Pred",Set.fromList ["[Type]","Name","Type (aka Kind)"]),
     ("TyLit",Set.fromList ["Integer","[Char] (aka String)"]),
     ("TyVarBndr",Set.fromList ["Name","Type (aka Kind)"]),
     ("Type (aka Kind)",Set.fromList ["[TyVarBndr]","Int","Name","TyLit","[Pred] (aka Cxt)"]),
     ("[Char] (aka String)",Set.fromList ["Char","[]"]),
     ("[Pred] (aka Cxt)",Set.fromList ["Pred","[]"]),
     ("[TyVarBndr]",Set.fromList ["TyVarBndr","[]"]),
     ("[Type]",Set.fromList ["[]","Type (aka Kind)"]),
     ("[]",Set.fromList [])
#endif
    ]

typeEdges ::  Set (String, Set String)
typeEdges =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
     ("BigNat",Set.fromList ["ByteArray# (field BigNat.BN#[1])"]),
     ("BigNat (field Integer.Jn#[1])",Set.fromList ["BigNat","ByteArray# (field BigNat.BN#[1])"]),
     ("BigNat (field Integer.Jp#[1])",Set.fromList ["BigNat","ByteArray# (field BigNat.BN#[1])"]),
     ("ByteArray#",Set.fromList []),
     ("ByteArray# (field BigNat.BN#[1])",Set.fromList ["ByteArray#"]),
     ("Char",Set.fromList ["Char# (field Char.C#[1])"]),
     ("Char#",Set.fromList []),
     ("Char# (field Char.C#[1])",Set.fromList ["Char#"]),
     ("Int",Set.fromList ["Int# (field Int.I#[1])"]),
     ("Int (field NameFlavour.NameL[1])",Set.fromList ["Int","Int# (field Int.I#[1])"]),
     ("Int (field NameFlavour.NameU[1])",Set.fromList ["Int","Int# (field Int.I#[1])"]),
     ("Int (field Type.PromotedTupleT[1])",Set.fromList ["Int","Int# (field Int.I#[1])"]),
     ("Int (field Type.TupleT[1])",Set.fromList ["Int","Int# (field Int.I#[1])"]),
     ("Int (field Type.UnboxedTupleT[1])",Set.fromList ["Int","Int# (field Int.I#[1])"]),
     ("Int#",Set.fromList []),
     ("Int# (field Int.I#[1])",Set.fromList ["Int#"]),
     ("Int# (field Integer.S#[1])",Set.fromList ["Int#"]),
     ("Integer",Set.fromList ["BigNat (field Integer.Jn#[1])","BigNat (field Integer.Jp#[1])","Int# (field Integer.S#[1])"]),
     ("Integer (field TyLit.NumTyLit[1])",Set.fromList ["Integer","BigNat (field Integer.Jn#[1])","BigNat (field Integer.Jp#[1])","Int# (field Integer.S#[1])"]),
     ("ModName",Set.fromList ["[Char] (aka String, field ModName.ModName[1])"]),
     ("ModName (field NameFlavour.NameG[3])",Set.fromList ["ModName","[Char] (aka String, field ModName.ModName[1])"]),
     ("ModName (field NameFlavour.NameQ[1])",Set.fromList ["ModName","[Char] (aka String, field ModName.ModName[1])"]),
     ("Name",Set.fromList ["OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field TyVarBndr.KindedTV[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field TyVarBndr.PlainTV[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field Type.ConT[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field Type.PromotedT[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field Type.VarT[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("NameFlavour",Set.fromList ["NameSpace (field NameFlavour.NameG[1])","PkgName (field NameFlavour.NameG[2])","ModName (field NameFlavour.NameG[3])","Int (field NameFlavour.NameL[1])","ModName (field NameFlavour.NameQ[1])","Int (field NameFlavour.NameU[1])"]),
     ("NameFlavour (field Name.Name[2])",Set.fromList ["NameFlavour","NameSpace (field NameFlavour.NameG[1])","PkgName (field NameFlavour.NameG[2])","ModName (field NameFlavour.NameG[3])","Int (field NameFlavour.NameL[1])","ModName (field NameFlavour.NameQ[1])","Int (field NameFlavour.NameU[1])"]),
     ("NameSpace",Set.fromList []),
     ("NameSpace (field NameFlavour.NameG[1])",Set.fromList ["NameSpace"]),
     ("OccName",Set.fromList ["[Char] (aka String, field OccName.OccName[1])"]),
     ("OccName (field Name.Name[1])",Set.fromList ["OccName","[Char] (aka String, field OccName.OccName[1])"]),
     ("PkgName",Set.fromList ["[Char] (aka String, field PkgName.PkgName[1])"]),
     ("PkgName (field NameFlavour.NameG[2])",Set.fromList ["PkgName","[Char] (aka String, field PkgName.PkgName[1])"]),
     ("TyLit",Set.fromList ["Integer (field TyLit.NumTyLit[1])","[Char] (aka String, field TyLit.StrTyLit[1])"]),
     ("TyLit (field Type.LitT[1])",Set.fromList ["TyLit","Integer (field TyLit.NumTyLit[1])","[Char] (aka String, field TyLit.StrTyLit[1])"]),
     ("TyVarBndr",Set.fromList ["Name (field TyVarBndr.KindedTV[1])","Type (aka Kind, aka Pred, field TyVarBndr.KindedTV[2])","Name (field TyVarBndr.PlainTV[1])"]),
     ("Type (aka Kind, aka Pred)",Set.fromList ["Type (aka Kind, aka Pred, field Type.AppT[1])","Type (aka Kind, aka Pred, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Type] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, aka Pred, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, aka Pred, field Type.SigT[1])","Type (aka Kind, aka Pred, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, aka Pred, field TyVarBndr.KindedTV[2])",Set.fromList ["Type (aka Kind, aka Pred)","Type (aka Kind, aka Pred, field Type.AppT[1])","Type (aka Kind, aka Pred, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Type] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, aka Pred, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, aka Pred, field Type.SigT[1])","Type (aka Kind, aka Pred, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, aka Pred, field Type.AppT[1])",Set.fromList ["Type (aka Kind, aka Pred)","Type (aka Kind, aka Pred, field Type.AppT[1])","Type (aka Kind, aka Pred, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Type] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, aka Pred, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, aka Pred, field Type.SigT[1])","Type (aka Kind, aka Pred, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, aka Pred, field Type.AppT[2])",Set.fromList ["Type (aka Kind, aka Pred)","Type (aka Kind, aka Pred, field Type.AppT[1])","Type (aka Kind, aka Pred, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Type] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, aka Pred, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, aka Pred, field Type.SigT[1])","Type (aka Kind, aka Pred, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, aka Pred, field Type.ForallT[3])",Set.fromList ["Type (aka Kind, aka Pred)","Type (aka Kind, aka Pred, field Type.AppT[1])","Type (aka Kind, aka Pred, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Type] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, aka Pred, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, aka Pred, field Type.SigT[1])","Type (aka Kind, aka Pred, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, aka Pred, field Type.SigT[1])",Set.fromList ["Type (aka Kind, aka Pred)","Type (aka Kind, aka Pred, field Type.AppT[1])","Type (aka Kind, aka Pred, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Type] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, aka Pred, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, aka Pred, field Type.SigT[1])","Type (aka Kind, aka Pred, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, aka Pred, field Type.SigT[2])",Set.fromList ["Type (aka Kind, aka Pred)","Type (aka Kind, aka Pred, field Type.AppT[1])","Type (aka Kind, aka Pred, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Type] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, aka Pred, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, aka Pred, field Type.SigT[1])","Type (aka Kind, aka Pred, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("[Char] (aka String)",Set.fromList ["Char","[]"]),
     ("[Char] (aka String, field ModName.ModName[1])",Set.fromList ["Char","[]","[Char] (aka String)"]),
     ("[Char] (aka String, field OccName.OccName[1])",Set.fromList ["Char","[]","[Char] (aka String)"]),
     ("[Char] (aka String, field PkgName.PkgName[1])",Set.fromList ["Char","[]","[Char] (aka String)"]),
     ("[Char] (aka String, field TyLit.StrTyLit[1])",Set.fromList ["Char","[]","[Char] (aka String)"]),
     ("[TyVarBndr]",Set.fromList ["TyVarBndr","[]"]),
     ("[TyVarBndr] (field Type.ForallT[1])",Set.fromList ["[TyVarBndr]","TyVarBndr","[]"]),
     ("[Type] (aka Cxt)",Set.fromList ["[]","Type (aka Kind, aka Pred)"]),
     ("[Type] (aka Cxt, field Type.ForallT[2])",Set.fromList ["[]","[Type] (aka Cxt)","Type (aka Kind, aka Pred)"]),
     ("[]",Set.fromList [])
#else
     ("ByteArray#",Set.fromList []),
     ("ByteArray# (field Integer.J#[2])",Set.fromList ["ByteArray#"]),
     ("Char",Set.fromList ["Char# (field Char.C#[1])"]),
     ("Char#",Set.fromList []),
     ("Char# (field Char.C#[1])",Set.fromList ["Char#"]),
     ("Int",Set.fromList ["Int# (field Int.I#[1])"]),
     ("Int (field Type.PromotedTupleT[1])",Set.fromList ["Int","Int# (field Int.I#[1])"]),
     ("Int (field Type.TupleT[1])",Set.fromList ["Int","Int# (field Int.I#[1])"]),
     ("Int (field Type.UnboxedTupleT[1])",Set.fromList ["Int","Int# (field Int.I#[1])"]),
     ("Int#",Set.fromList []),
     ("Int# (field Int.I#[1])",Set.fromList ["Int#"]),
     ("Int# (field Integer.J#[1])",Set.fromList ["Int#"]),
     ("Int# (field Integer.S#[1])",Set.fromList ["Int#"]),
     ("Int# (field NameFlavour.NameL[1])",Set.fromList ["Int#"]),
     ("Int# (field NameFlavour.NameU[1])",Set.fromList ["Int#"]),
     ("Integer",Set.fromList ["Int# (field Integer.J#[1])","ByteArray# (field Integer.J#[2])","Int# (field Integer.S#[1])"]),
     ("Integer (field TyLit.NumTyLit[1])",Set.fromList ["Integer","Int# (field Integer.J#[1])","ByteArray# (field Integer.J#[2])","Int# (field Integer.S#[1])"]),
     ("ModName",Set.fromList ["[Char] (aka String, field ModName.ModName[1])"]),
     ("ModName (field NameFlavour.NameG[3])",Set.fromList ["ModName","[Char] (aka String, field ModName.ModName[1])"]),
     ("ModName (field NameFlavour.NameQ[1])",Set.fromList ["ModName","[Char] (aka String, field ModName.ModName[1])"]),
     ("Name",Set.fromList ["OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field Pred.ClassP[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field TyVarBndr.KindedTV[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field TyVarBndr.PlainTV[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field Type.ConT[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field Type.PromotedT[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("Name (field Type.VarT[1])",Set.fromList ["Name","OccName (field Name.Name[1])","NameFlavour (field Name.Name[2])"]),
     ("NameFlavour",Set.fromList ["NameSpace (field NameFlavour.NameG[1])","PkgName (field NameFlavour.NameG[2])","ModName (field NameFlavour.NameG[3])","Int# (field NameFlavour.NameL[1])","ModName (field NameFlavour.NameQ[1])","Int# (field NameFlavour.NameU[1])"]),
     ("NameFlavour (field Name.Name[2])",Set.fromList ["NameFlavour","NameSpace (field NameFlavour.NameG[1])","PkgName (field NameFlavour.NameG[2])","ModName (field NameFlavour.NameG[3])","Int# (field NameFlavour.NameL[1])","ModName (field NameFlavour.NameQ[1])","Int# (field NameFlavour.NameU[1])"]),
     ("NameSpace",Set.fromList []),
     ("NameSpace (field NameFlavour.NameG[1])",Set.fromList ["NameSpace"]),
     ("OccName",Set.fromList ["[Char] (aka String, field OccName.OccName[1])"]),
     ("OccName (field Name.Name[1])",Set.fromList ["OccName","[Char] (aka String, field OccName.OccName[1])"]),
     ("PkgName",Set.fromList ["[Char] (aka String, field PkgName.PkgName[1])"]),
     ("PkgName (field NameFlavour.NameG[2])",Set.fromList ["PkgName","[Char] (aka String, field PkgName.PkgName[1])"]),
     ("Pred",Set.fromList ["Name (field Pred.ClassP[1])","[Type] (field Pred.ClassP[2])","Type (aka Kind, field Pred.EqualP[1])","Type (aka Kind, field Pred.EqualP[2])"]),
     ("TyLit",Set.fromList ["Integer (field TyLit.NumTyLit[1])","[Char] (aka String, field TyLit.StrTyLit[1])"]),
     ("TyLit (field Type.LitT[1])",Set.fromList ["TyLit","Integer (field TyLit.NumTyLit[1])","[Char] (aka String, field TyLit.StrTyLit[1])"]),
     ("TyVarBndr",Set.fromList ["Name (field TyVarBndr.KindedTV[1])","Type (aka Kind, field TyVarBndr.KindedTV[2])","Name (field TyVarBndr.PlainTV[1])"]),
     ("Type (aka Kind)",Set.fromList ["Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, field Pred.EqualP[1])",Set.fromList ["Type (aka Kind)","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, field Pred.EqualP[2])",Set.fromList ["Type (aka Kind)","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, field TyVarBndr.KindedTV[2])",Set.fromList ["Type (aka Kind)","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, field Type.AppT[1])",Set.fromList ["Type (aka Kind)","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, field Type.AppT[2])",Set.fromList ["Type (aka Kind)","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, field Type.ForallT[3])",Set.fromList ["Type (aka Kind)","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, field Type.SigT[1])",Set.fromList ["Type (aka Kind)","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("Type (aka Kind, field Type.SigT[2])",Set.fromList ["Type (aka Kind)","Type (aka Kind, field Type.AppT[1])","Type (aka Kind, field Type.AppT[2])","Name (field Type.ConT[1])","[TyVarBndr] (field Type.ForallT[1])","[Pred] (aka Cxt, field Type.ForallT[2])","Type (aka Kind, field Type.ForallT[3])","TyLit (field Type.LitT[1])","Name (field Type.PromotedT[1])","Int (field Type.PromotedTupleT[1])","Type (aka Kind, field Type.SigT[1])","Type (aka Kind, field Type.SigT[2])","Int (field Type.TupleT[1])","Int (field Type.UnboxedTupleT[1])","Name (field Type.VarT[1])"]),
     ("[Char] (aka String)",Set.fromList ["Char","[]"]),
     ("[Char] (aka String, field ModName.ModName[1])",Set.fromList ["Char","[]","[Char] (aka String)"]),
     ("[Char] (aka String, field OccName.OccName[1])",Set.fromList ["Char","[]","[Char] (aka String)"]),
     ("[Char] (aka String, field PkgName.PkgName[1])",Set.fromList ["Char","[]","[Char] (aka String)"]),
     ("[Char] (aka String, field TyLit.StrTyLit[1])",Set.fromList ["Char","[]","[Char] (aka String)"]),
     ("[Pred] (aka Cxt)",Set.fromList ["Pred","[]"]),
     ("[Pred] (aka Cxt, field Type.ForallT[2])",Set.fromList ["Pred","[]","[Pred] (aka Cxt)"]),
     ("[TyVarBndr]",Set.fromList ["TyVarBndr","[]"]),
     ("[TyVarBndr] (field Type.ForallT[1])",Set.fromList ["[TyVarBndr]","TyVarBndr","[]"]),
     ("[Type]",Set.fromList ["[]","Type (aka Kind)"]),
     ("[Type] (field Pred.ClassP[2])",Set.fromList ["[Type]","[]","Type (aka Kind)"]),
     ("[]",Set.fromList [])
#endif
    ]

arity0TypeEdges :: Set (String, Set String)
arity0TypeEdges =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
     ("BigNat",Set.fromList ["ByteArray#"]),
     ("ByteArray#",Set.fromList []),
     ("Char",Set.fromList ["Char#"]),
     ("Char#",Set.fromList []),
     ("Int",Set.fromList ["Int#"]),
     ("Int#",Set.fromList []),
     ("Integer",Set.fromList ["Int#","BigNat"]),
     ("ModName",Set.fromList ["[Char] (aka String)"]),
     ("Name",Set.fromList ["NameFlavour","OccName"]),
     ("NameFlavour",Set.fromList ["Int","ModName","NameSpace","PkgName"]),
     ("NameSpace",Set.fromList []),
     ("OccName",Set.fromList ["[Char] (aka String)"]),
     ("PkgName",Set.fromList ["[Char] (aka String)"]),
     ("TyLit",Set.fromList ["Integer","[Char] (aka String)"]),
     ("TyVarBndr",Set.fromList ["Name","Type (aka Kind, aka Pred)"]),
     ("Type (aka Kind, aka Pred)",Set.fromList ["[TyVarBndr]","Int","Name","TyLit","[Type] (aka Cxt)"]),
     ("[Char] (aka String)",Set.fromList ["Char"]),
     ("[TyVarBndr]",Set.fromList ["TyVarBndr"]),
     ("[Type] (aka Cxt)",Set.fromList ["Type (aka Kind, aka Pred)"])
#else
     ("ByteArray#",Set.fromList []),
     ("Char",Set.fromList ["Char#"]),
     ("Char#",Set.fromList []),
     ("Int",Set.fromList ["Int#"]),
     ("Int#",Set.fromList []),
     ("Integer",Set.fromList ["ByteArray#","Int#"]),
     ("ModName",Set.fromList ["[Char] (aka String)"]),
     ("Name",Set.fromList ["NameFlavour","OccName"]),
     ("NameFlavour",Set.fromList ["Int#","ModName","NameSpace","PkgName"]),
     ("NameSpace",Set.fromList []),
     ("OccName",Set.fromList ["[Char] (aka String)"]),
     ("PkgName",Set.fromList ["[Char] (aka String)"]),
     ("Pred",Set.fromList ["[Type]","Name","Type (aka Kind)"]),
     ("TyLit",Set.fromList ["Integer","[Char] (aka String)"]),
     ("TyVarBndr",Set.fromList ["Name","Type (aka Kind)"]),
     ("Type (aka Kind)",Set.fromList ["[TyVarBndr]","Int","Name","TyLit","[Pred] (aka Cxt)"]),
     ("[Char] (aka String)",Set.fromList ["Char"]),
     ("[Pred] (aka Cxt)",Set.fromList ["Pred"]),
     ("[TyVarBndr]",Set.fromList ["TyVarBndr"]),
     ("[Type]",Set.fromList ["Type (aka Kind)"])
#endif
    ]

arity0TypeEdges' :: Set (String, [String])
arity0TypeEdges' =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
#else
     ("ByteArray#",[]),
     ("Char",[]),
     ("Char#",[]),
     ("Int",[]),
     ("Int#",[]),
     ("Integer",[]),
     ("ModName",["Char","[]","[Char] (aka String)"]),
     ("Name",["Int#","ModName","NameSpace","PkgName","[Char] (aka String)"]),
     ("NameFlavour",["[Char] (aka String)"]),
     ("NameSpace",[]),
     ("OccName",["Char","[]","[Char] (aka String)"]),
     ("PkgName",["Char","[]","[Char] (aka String)"]),
     ("Pred",["[TyVarBndr]","Int","Name","NameFlavour","OccName","TyLit","[]","[Pred] (aka Cxt)","Type (aka Kind)"]),
     ("TyLit",["ByteArray#","Int#","Char","[]","[Char] (aka String)"]),
     ("TyVarBndr",["[TyVarBndr]","Int","Name","NameFlavour","OccName","TyLit","[Pred] (aka Cxt)","Type (aka Kind)"]),
     ("Type (aka Kind)",["[TyVarBndr]","Int#","Int","Integer","Name","NameFlavour","OccName","Pred","TyLit","TyVarBndr","[]","[Char] (aka String)","[Pred] (aka Cxt)","Type (aka Kind)"]),
     ("[Char] (aka String)",["Char#","Char","[]","[Char] (aka String)"]),
     ("[Pred] (aka Cxt)",["[Type]","Name","Pred","[]","[Pred] (aka Cxt)","Type (aka Kind)"]),
     ("[TyVarBndr]",["Name","[]","Type (aka Kind)"]),
     ("[Type]",["[TyVarBndr]","Int","Name","TyLit","[]","[Pred] (aka Cxt)","Type (aka Kind)"])
#endif
    ]

decEdges :: Set (String, [String])
decEdges =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
     ("(,)",[]),
     ("(,) Guard",["Guard","(,)"]),
     ("(,) Name",["Name","(,)"]),
     ("(,) Strict",["Strict","(,)"]),
     ("(,,)",[]),
     ("(,,) Name",["Name","(,,)"]),
     ("(,,) Name Strict",["(,,) Name","Strict"]),
     ("(Guard, Exp)",["(,) Guard","Exp"]),
     ("(Name, Exp) (aka FieldExp)",["(,) Name","Exp"]),
     ("(Name, Pat) (aka FieldPat)",["(,) Name","Pat"]),
     ("(Name, Strict, Type) (aka VarStrictType)",["(,,) Name Strict","Type (aka Kind, aka Pred)"]),
     ("(Strict, Type) (aka StrictType)",["(,) Strict","Type (aka Kind, aka Pred)"]),
     ("AnnTarget",["Name"]),
     ("BigNat",["ByteArray#"]),
     ("Body",["[(Guard, Exp)]","Exp"]),
     ("ByteArray#",[]),
     ("Callconv",[]),
     ("Char",["Char#"]),
     ("Char#",[]),
     ("Clause",["[Dec]","[Pat]","Body"]),
     ("Con",["[(Name, Strict, Type)]","[(Strict, Type)]","[TyVarBndr]","Name","[Type] (aka Cxt)","(Strict, Type) (aka StrictType)"]),
     ("Dec",["Maybe Type","[Clause]","[Con]","[Dec]","[FunDep]","[Name]","[Role]","[TySynEqn]","[TyVarBndr]","Body","Con","FamFlavour","Fixity","Foreign","Name","Pat","Pragma","TySynEqn","[Type] (aka Cxt)","Type (aka Kind, aka Pred)"]),
     ("Exp",["Maybe Exp","[(Guard, Exp)]","[(Name, Exp)]","[Dec]","[Exp]","[Match]","[Pat]","[Stmt]","Lit","Name","Range","Type (aka Kind, aka Pred)"]),
     ("FamFlavour",[]),
     ("Fixity",["Int","FixityDirection"]),
     ("FixityDirection",[]),
     ("Foreign",["Callconv","Name","Safety","[Char] (aka String)","Type (aka Kind, aka Pred)"]),
     ("FunDep",["[Name]"]),
     ("Guard",["[Stmt]","Exp"]),
     ("Inline",[]),
     ("Int",["Int#"]),
     ("Int#",[]),
     ("Integer",["Int#","BigNat"]),
     ("Lit",["[Word8]","Char","Integer","[Char] (aka String)","Ratio Integer (aka Rational)"]),
     ("Match",["[Dec]","Body","Pat"]),
     ("Maybe",["a"]),
     ("Maybe Exp",["Maybe","Exp"]),
     ("Maybe Inline",["Maybe","Inline"]),
     ("Maybe Type",["Maybe","Type (aka Kind, aka Pred)"]),
     ("ModName",["[Char] (aka String)"]),
     ("Name",["NameFlavour","OccName"]),
     ("NameFlavour",["Int","ModName","NameSpace","PkgName"]),
     ("NameSpace",[]),
     ("OccName",["[Char] (aka String)"]),
     ("Pat",["[(Name, Pat)]","[Pat]","Exp","Lit","Name","Type (aka Kind, aka Pred)"]),
     ("Phases",["Int"]),
     ("PkgName",["[Char] (aka String)"]),
     ("Pragma",["Maybe Inline","[RuleBndr]","Int","AnnTarget","Exp","Inline","Name","Phases","RuleMatch","[Char] (aka String)","Type (aka Kind, aka Pred)"]),
     ("Range",["Exp"]),
     ("Ratio",["a"]),
     ("Ratio Integer (aka Rational)",["Ratio","Integer"]),
     ("Role",[]),
     ("RuleBndr",["Name","Type (aka Kind, aka Pred)"]),
     ("RuleMatch",[]),
     ("Safety",[]),
     ("Stmt",["[[Stmt]]","[Dec]","Exp","Pat"]),
     ("Strict",[]),
     ("TyLit",["Integer","[Char] (aka String)"]),
     ("TySynEqn",["[Type] (aka Cxt)","Type (aka Kind, aka Pred)"]),
     ("TyVarBndr",["Name","Type (aka Kind, aka Pred)"]),
     ("Type (aka Kind, aka Pred)",["[TyVarBndr]","Int","Name","TyLit","[Type] (aka Cxt)"]),
     ("Word#",[]),
     ("Word8",["Word#"]),
     ("[(Guard, Exp)]",["(Guard, Exp)","[]"]),
     ("[(Name, Exp)]",["[]","(Name, Exp) (aka FieldExp)"]),
     ("[(Name, Pat)]",["[]","(Name, Pat) (aka FieldPat)"]),
     ("[(Name, Strict, Type)]",["[]","(Name, Strict, Type) (aka VarStrictType)"]),
     ("[(Strict, Type)]",["[]","(Strict, Type) (aka StrictType)"]),
     ("[Char] (aka String)",["Char","[]"]),
     ("[Clause]",["Clause","[]"]),
     ("[Con]",["Con","[]"]),
     ("[Dec]",["Dec","[]"]),
     ("[Exp]",["Exp","[]"]),
     ("[FunDep]",["FunDep","[]"]),
     ("[Match]",["Match","[]"]),
     ("[Name]",["Name","[]"]),
     ("[Pat]",["Pat","[]"]),
     ("[Role]",["Role","[]"]),
     ("[RuleBndr]",["RuleBndr","[]"]),
     ("[Stmt]",["Stmt","[]"]),
     ("[TySynEqn]",["TySynEqn","[]"]),
     ("[TyVarBndr]",["TyVarBndr","[]"]),
     ("[Type] (aka Cxt)",["[]","Type (aka Kind, aka Pred)"]),
     ("[Word8]",["Word8","[]"]),
     ("[[Stmt]]",["[Stmt]","[]"]),
     ("[]",[]),
     ("a",[])
#else
     ("(,)",[]),
     ("(,) Guard",["Guard","(,)"]),
     ("(,) Name",["Name","(,)"]),
     ("(,) Strict",["Strict","(,)"]),
     ("(,,)",[]),
     ("(,,) Name",["Name","(,,)"]),
     ("(,,) Name Strict",["(,,) Name","Strict"]),
     ("(Guard, Exp)",["(,) Guard","Exp"]),
     ("(Name, Exp) (aka FieldExp)",["(,) Name","Exp"]),
     ("(Name, Pat) (aka FieldPat)",["(,) Name","Pat"]),
     ("(Name, Strict, Type) (aka VarStrictType)",["(,,) Name Strict","Type (aka Kind)"]),
     ("(Strict, Type) (aka StrictType)",["(,) Strict","Type (aka Kind)"]),
     ("AnnTarget",["Name"]),
     ("Body",["[(Guard, Exp)]","Exp"]),
     ("ByteArray#",[]),
     ("Callconv",[]),
     ("Char",["Char#"]),
     ("Char#",[]),
     ("Clause",["[Dec]","[Pat]","Body"]),
     ("Con",["[(Name, Strict, Type)]","[(Strict, Type)]","[TyVarBndr]","Name","[Pred] (aka Cxt)","(Strict, Type) (aka StrictType)"]),
     ("Dec",["Maybe Type","[Clause]","[Con]","[Dec]","[FunDep]","[Name]","[Role]","[TySynEqn]","[TyVarBndr]","[Type]","Body","Con","FamFlavour","Fixity","Foreign","Name","Pat","Pragma","TySynEqn","[Pred] (aka Cxt)","Type (aka Kind)"]),
     ("Exp",["Maybe Exp","[(Guard, Exp)]","[(Name, Exp)]","[Dec]","[Exp]","[Match]","[Pat]","[Stmt]","Lit","Name","Range","Type (aka Kind)"]),
     ("FamFlavour",[]),
     ("Fixity",["Int","FixityDirection"]),
     ("FixityDirection",[]),
     ("Foreign",["Callconv","Name","Safety","[Char] (aka String)","Type (aka Kind)"]),
     ("FunDep",["[Name]"]),
     ("Guard",["[Stmt]","Exp"]),
     ("Inline",[]),
     ("Int",["Int#"]),
     ("Int#",[]),
     ("Integer",["ByteArray#","Int#"]),
     ("Lit",["[Word8]","Char","Integer","[Char] (aka String)","Ratio Integer (aka Rational)"]),
     ("Match",["[Dec]","Body","Pat"]),
     ("Maybe",["a"]),
     ("Maybe Exp",["Maybe","Exp"]),
     ("Maybe Inline",["Maybe","Inline"]),
     ("Maybe Type",["Maybe","Type (aka Kind)"]),
     ("ModName",["[Char] (aka String)"]),
     ("Name",["NameFlavour","OccName"]),
     ("NameFlavour",["Int#","ModName","NameSpace","PkgName"]),
     ("NameSpace",[]),
     ("OccName",["[Char] (aka String)"]),
     ("Pat",["[(Name, Pat)]","[Pat]","Exp","Lit","Name","Type (aka Kind)"]),
     ("Phases",["Int"]),
     ("PkgName",["[Char] (aka String)"]),
     ("Pragma",["Maybe Inline","[RuleBndr]","AnnTarget","Exp","Inline","Name","Phases","RuleMatch","[Char] (aka String)","Type (aka Kind)"]),
     ("Pred",["[Type]","Name","Type (aka Kind)"]),
     ("Range",["Exp"]),
     ("Ratio",["a"]),
     ("Ratio Integer (aka Rational)",["Ratio","Integer"]),
     ("Role",[]),
     ("RuleBndr",["Name","Type (aka Kind)"]),
     ("RuleMatch",[]),
     ("Safety",[]),
     ("Stmt",["[[Stmt]]","[Dec]","Exp","Pat"]),
     ("Strict",[]),
     ("TyLit",["Integer","[Char] (aka String)"]),
     ("TySynEqn",["[Type]","Type (aka Kind)"]),
     ("TyVarBndr",["Name","Type (aka Kind)"]),
     ("Type (aka Kind)",["[TyVarBndr]","Int","Name","TyLit","[Pred] (aka Cxt)"]),
     ("Word#",[]),
     ("Word8",["Word#"]),
     ("[(Guard, Exp)]",["(Guard, Exp)","[]"]),
     ("[(Name, Exp)]",["[]","(Name, Exp) (aka FieldExp)"]),
     ("[(Name, Pat)]",["[]","(Name, Pat) (aka FieldPat)"]),
     ("[(Name, Strict, Type)]",["[]","(Name, Strict, Type) (aka VarStrictType)"]),
     ("[(Strict, Type)]",["[]","(Strict, Type) (aka StrictType)"]),
     ("[Char] (aka String)",["Char","[]"]),
     ("[Clause]",["Clause","[]"]),
     ("[Con]",["Con","[]"]),
     ("[Dec]",["Dec","[]"]),
     ("[Exp]",["Exp","[]"]),
     ("[FunDep]",["FunDep","[]"]),
     ("[Match]",["Match","[]"]),
     ("[Name]",["Name","[]"]),
     ("[Pat]",["Pat","[]"]),
     ("[Pred] (aka Cxt)",["Pred","[]"]),
     ("[Role]",["Role","[]"]),
     ("[RuleBndr]",["RuleBndr","[]"]),
     ("[Stmt]",["Stmt","[]"]),
     ("[TySynEqn]",["TySynEqn","[]"]),
     ("[TyVarBndr]",["TyVarBndr","[]"]),
     ("[Type]",["[]","Type (aka Kind)"]),
     ("[Word8]",["Word8","[]"]),
     ("[[Stmt]]",["[Stmt]","[]"]),
     ("[]",[]),
     ("a",[])
#endif
    ]

arity0DecEdges :: Set (String, [String])
arity0DecEdges =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
     ("(Guard, Exp)",["Exp","Guard"]),
     ("(Name, Exp) (aka FieldExp)",["Exp","Name"]),
     ("(Name, Pat) (aka FieldPat)",["Name","Pat"]),
     ("(Name, Strict, Type) (aka VarStrictType)",["Name","Strict","Type (aka Kind, aka Pred)"]),
     ("(Strict, Type) (aka StrictType)",["Strict","Type (aka Kind, aka Pred)"]),
     ("AnnTarget",["Name"]),
     ("BigNat",["ByteArray#"]),
     ("Body",["[(Guard, Exp)]","Exp"]),
     ("ByteArray#",[]),
     ("Callconv",[]),
     ("Char",["Char#"]),
     ("Char#",[]),
     ("Clause",["[Dec]","[Pat]","Body"]),
     ("Con",["[(Name, Strict, Type)]","[(Strict, Type)]","[TyVarBndr]","Name","[Type] (aka Cxt)","(Strict, Type) (aka StrictType)"]),
     ("Dec",["Maybe Type","[Clause]","[Con]","[Dec]","[FunDep]","[Name]","[Role]","[TySynEqn]","[TyVarBndr]","Body","Con","FamFlavour","Fixity","Foreign","Name","Pat","Pragma","TySynEqn","[Type] (aka Cxt)","Type (aka Kind, aka Pred)"]),
     ("Exp",["Maybe Exp","[(Guard, Exp)]","[(Name, Exp)]","[Dec]","[Exp]","[Match]","[Pat]","[Stmt]","Lit","Name","Range","Type (aka Kind, aka Pred)"]),
     ("FamFlavour",[]),
     ("Fixity",["Int","FixityDirection"]),
     ("FixityDirection",[]),
     ("Foreign",["Callconv","Name","Safety","[Char] (aka String)","Type (aka Kind, aka Pred)"]),
     ("FunDep",["[Name]"]),
     ("Guard",["[Stmt]","Exp"]),
     ("Inline",[]),
     ("Int",["Int#"]),
     ("Int#",[]),
     ("Integer",["Int#","BigNat"]),
     ("Lit",["[Word8]","Char","Integer","[Char] (aka String)","Ratio Integer (aka Rational)"]),
     ("Match",["[Dec]","Body","Pat"]),
     ("Maybe Exp",["Exp"]),
     ("Maybe Inline",["Inline"]),
     ("Maybe Type",["Type (aka Kind, aka Pred)"]),
     ("ModName",["[Char] (aka String)"]),
     ("Name",["NameFlavour","OccName"]),
     ("NameFlavour",["Int","ModName","NameSpace","PkgName"]),
     ("NameSpace",[]),
     ("OccName",["[Char] (aka String)"]),
     ("Pat",["[(Name, Pat)]","[Pat]","Exp","Lit","Name","Type (aka Kind, aka Pred)"]),
     ("Phases",["Int"]),
     ("PkgName",["[Char] (aka String)"]),
     ("Pragma",["Maybe Inline","[RuleBndr]","Int","AnnTarget","Exp","Inline","Name","Phases","RuleMatch","[Char] (aka String)","Type (aka Kind, aka Pred)"]),
     ("Range",["Exp"]),
     ("Ratio Integer (aka Rational)",["Integer"]),
     ("Role",[]),
     ("RuleBndr",["Name","Type (aka Kind, aka Pred)"]),
     ("RuleMatch",[]),
     ("Safety",[]),
     ("Stmt",["[[Stmt]]","[Dec]","Exp","Pat"]),
     ("Strict",[]),
     ("TyLit",["Integer","[Char] (aka String)"]),
     ("TySynEqn",["[Type] (aka Cxt)","Type (aka Kind, aka Pred)"]),
     ("TyVarBndr",["Name","Type (aka Kind, aka Pred)"]),
     ("Type (aka Kind, aka Pred)",["[TyVarBndr]","Int","Name","TyLit","[Type] (aka Cxt)"]),
     ("Word#",[]),
     ("Word8",["Word#"]),
     ("[(Guard, Exp)]",["(Guard, Exp)"]),
     ("[(Name, Exp)]",["(Name, Exp) (aka FieldExp)"]),
     ("[(Name, Pat)]",["(Name, Pat) (aka FieldPat)"]),
     ("[(Name, Strict, Type)]",["(Name, Strict, Type) (aka VarStrictType)"]),
     ("[(Strict, Type)]",["(Strict, Type) (aka StrictType)"]),
     ("[Char] (aka String)",["Char"]),
     ("[Clause]",["Clause"]),
     ("[Con]",["Con"]),
     ("[Dec]",["Dec"]),
     ("[Exp]",["Exp"]),
     ("[FunDep]",["FunDep"]),
     ("[Match]",["Match"]),
     ("[Name]",["Name"]),
     ("[Pat]",["Pat"]),
     ("[Role]",["Role"]),
     ("[RuleBndr]",["RuleBndr"]),
     ("[Stmt]",["Stmt"]),
     ("[TySynEqn]",["TySynEqn"]),
     ("[TyVarBndr]",["TyVarBndr"]),
     ("[Type] (aka Cxt)",["Type (aka Kind, aka Pred)"]),
     ("[Word8]",["Word8"]),
     ("[[Stmt]]",["[Stmt]"])
#else
     ("(Guard, Exp)",["Exp","Guard"]),
     ("(Name, Exp) (aka FieldExp)",["Exp","Name"]),
     ("(Name, Pat) (aka FieldPat)",["Name","Pat"]),
     ("(Name, Strict, Type) (aka VarStrictType)",["Name","Strict","Type (aka Kind)"]),
     ("(Strict, Type) (aka StrictType)",["Strict","Type (aka Kind)"]),
     ("AnnTarget",["Name"]),
     ("Body",["[(Guard, Exp)]","Exp"]),
     ("ByteArray#",[]),
     ("Callconv",[]),
     ("Char",["Char#"]),
     ("Char#",[]),
     ("Clause",["[Dec]","[Pat]","Body"]),
     ("Con",["[(Name, Strict, Type)]","[(Strict, Type)]","[TyVarBndr]","Name","[Pred] (aka Cxt)","(Strict, Type) (aka StrictType)"]),
     ("Dec",["Maybe Type","[Clause]","[Con]","[Dec]","[FunDep]","[Name]","[Role]","[TySynEqn]","[TyVarBndr]","[Type]","Body","Con","FamFlavour","Fixity","Foreign","Name","Pat","Pragma","TySynEqn","[Pred] (aka Cxt)","Type (aka Kind)"]),
     ("Exp",["Maybe Exp","[(Guard, Exp)]","[(Name, Exp)]","[Dec]","[Exp]","[Match]","[Pat]","[Stmt]","Lit","Name","Range","Type (aka Kind)"]),
     ("FamFlavour",[]),
     ("Fixity",["Int","FixityDirection"]),
     ("FixityDirection",[]),
     ("Foreign",["Callconv","Name","Safety","[Char] (aka String)","Type (aka Kind)"]),
     ("FunDep",["[Name]"]),
     ("Guard",["[Stmt]","Exp"]),
     ("Inline",[]),
     ("Int",["Int#"]),
     ("Int#",[]),
     ("Integer",["ByteArray#","Int#"]),
     ("Lit",["[Word8]","Char","Integer","[Char] (aka String)","Ratio Integer (aka Rational)"]),
     ("Match",["[Dec]","Body","Pat"]),
     ("Maybe Exp",["Exp"]),
     ("Maybe Inline",["Inline"]),
     ("Maybe Type",["Type (aka Kind)"]),
     ("ModName",["[Char] (aka String)"]),
     ("Name",["NameFlavour","OccName"]),
     ("NameFlavour",["Int#","ModName","NameSpace","PkgName"]),
     ("NameSpace",[]),
     ("OccName",["[Char] (aka String)"]),
     ("Pat",["[(Name, Pat)]","[Pat]","Exp","Lit","Name","Type (aka Kind)"]),
     ("Phases",["Int"]),
     ("PkgName",["[Char] (aka String)"]),
     ("Pragma",["Maybe Inline","[RuleBndr]","AnnTarget","Exp","Inline","Name","Phases","RuleMatch","[Char] (aka String)","Type (aka Kind)"]),
     ("Pred",["[Type]","Name","Type (aka Kind)"]),
     ("Range",["Exp"]),
     ("Ratio Integer (aka Rational)",["Integer"]),
     ("Role",[]),
     ("RuleBndr",["Name","Type (aka Kind)"]),
     ("RuleMatch",[]),
     ("Safety",[]),
     ("Stmt",["[[Stmt]]","[Dec]","Exp","Pat"]),
     ("Strict",[]),
     ("TyLit",["Integer","[Char] (aka String)"]),
     ("TySynEqn",["[Type]","Type (aka Kind)"]),
     ("TyVarBndr",["Name","Type (aka Kind)"]),
     ("Type (aka Kind)",["[TyVarBndr]","Int","Name","TyLit","[Pred] (aka Cxt)"]),
     ("Word#",[]),
     ("Word8",["Word#"]),
     ("[(Guard, Exp)]",["(Guard, Exp)"]),
     ("[(Name, Exp)]",["(Name, Exp) (aka FieldExp)"]),
     ("[(Name, Pat)]",["(Name, Pat) (aka FieldPat)"]),
     ("[(Name, Strict, Type)]",["(Name, Strict, Type) (aka VarStrictType)"]),
     ("[(Strict, Type)]",["(Strict, Type) (aka StrictType)"]),
     ("[Char] (aka String)",["Char"]),
     ("[Clause]",["Clause"]),
     ("[Con]",["Con"]),
     ("[Dec]",["Dec"]),
     ("[Exp]",["Exp"]),
     ("[FunDep]",["FunDep"]),
     ("[Match]",["Match"]),
     ("[Name]",["Name"]),
     ("[Pat]",["Pat"]),
     ("[Pred] (aka Cxt)",["Pred"]),
     ("[Role]",["Role"]),
     ("[RuleBndr]",["RuleBndr"]),
     ("[Stmt]",["Stmt"]),
     ("[TySynEqn]",["TySynEqn"]),
     ("[TyVarBndr]",["TyVarBndr"]),
     ("[Type]",["Type (aka Kind)"]),
     ("[Word8]",["Word8"]),
     ("[[Stmt]]",["[Stmt]"])
#endif
    ]

arity0SubtypesOfDec :: Set String
arity0SubtypesOfDec =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
     "(Guard, Exp)","(Name, Exp) (aka FieldExp)","(Name, Pat) (aka FieldPat)","(Name, Strict, Type) (aka VarStrictType)","(Strict, Type) (aka StrictType)","AnnTarget","BigNat","Body","ByteArray#","Callconv","Char","Char#","Clause","Con","Dec","Exp","FamFlavour","Fixity","FixityDirection","Foreign","FunDep","Guard","Inline","Int","Int#","Integer","Lit","Match","Maybe Exp","Maybe Inline","Maybe Type","ModName","Name","NameFlavour","NameSpace","OccName","Pat","Phases","PkgName","Pragma","Range","Ratio Integer (aka Rational)","Role","RuleBndr","RuleMatch","Safety","Stmt","Strict","TyLit","TySynEqn","TyVarBndr","Type (aka Kind, aka Pred)","Word#","Word8","[(Guard, Exp)]","[(Name, Exp)]","[(Name, Pat)]","[(Name, Strict, Type)]","[(Strict, Type)]","[Char] (aka String)","[Clause]","[Con]","[Dec]","[Exp]","[FunDep]","[Match]","[Name]","[Pat]","[Role]","[RuleBndr]","[Stmt]","[TySynEqn]","[TyVarBndr]","[Type] (aka Cxt)","[Word8]","[[Stmt]]"
#else
     "(Guard, Exp)","(Name, Exp) (aka FieldExp)","(Name, Pat) (aka FieldPat)","(Name, Strict, Type) (aka VarStrictType)","(Strict, Type) (aka StrictType)","AnnTarget","Body","ByteArray#","Callconv","Char","Char#","Clause","Con","Dec","Exp","FamFlavour","Fixity","FixityDirection","Foreign","FunDep","Guard","Inline","Int","Int#","Integer","Lit","Match","Maybe Exp","Maybe Inline","Maybe Type","ModName","Name","NameFlavour","NameSpace","OccName","Pat","Phases","PkgName","Pragma","Pred","Range","Ratio Integer (aka Rational)","Role","RuleBndr","RuleMatch","Safety","Stmt","Strict","TyLit","TySynEqn","TyVarBndr","Type (aka Kind)","Word#","Word8","[(Guard, Exp)]","[(Name, Exp)]","[(Name, Pat)]","[(Name, Strict, Type)]","[(Strict, Type)]","[Char] (aka String)","[Clause]","[Con]","[Dec]","[Exp]","[FunDep]","[Match]","[Name]","[Pat]","[Pred] (aka Cxt)","[Role]","[RuleBndr]","[Stmt]","[TySynEqn]","[TyVarBndr]","[Type]","[Word8]","[[Stmt]]"
#endif
    ]

subtypesOfDec :: Set String
subtypesOfDec =
    union
       arity0SubtypesOfDec
       (Set.fromList
           [ "(,)"
           , "(,) Guard"
           , "(,) Name"
           , "(,) Strict"
           , "(,,)"
           , "(,,) Name"
           , "(,,) Name Strict"
           , "Maybe"
           , "Ratio"
           , "[]"
           , "a"
           ])

simpleSubtypesOfDec :: Set String
simpleSubtypesOfDec =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
              "BigNat",
              "Type (aka Kind, aka Pred)",
              "[Type] (aka Cxt)",
#else
              "Pred",
              "[Pred] (aka Cxt)",
              "Type (aka Kind)",
              "[Type]",
#endif
              "(,)",
              "(,) Guard",
              "(,) Name",
              "(,) Strict",
              "(,,)",
              "(,,) Name",
              "(,,) Name Strict",
              "(Guard, Exp)",
              "(Name, Exp) (aka FieldExp)",
              "(Name, Pat) (aka FieldPat)",
              "(Name, Strict, Type) (aka VarStrictType)",
              "(Strict, Type) (aka StrictType)",
              "AnnTarget",
              "Body",
              "ByteArray#",
              "Callconv",
              "Char",
              "Char#",
              "Clause",
              "Con",
              "Dec",
              "Exp",
              "FamFlavour",
              "Fixity",
              "FixityDirection",
              "Foreign",
              "FunDep",
              "Guard",
              "Inline",
              "Int",
              "Int#",
              "Integer",
              "Lit",
              "Match",
              "Maybe",
              "Maybe Exp",
              "Maybe Inline",
              "Maybe Type",
              "ModName",
              "Name",
              "NameFlavour",
              "NameSpace",
              "OccName",
              "Pat",
              "Phases",
              "PkgName",
              "Pragma",
              "Range",
              "Ratio",
              "Ratio Integer (aka Rational)",
              "Role",
              "RuleBndr",
              "RuleMatch",
              "Safety",
              "Stmt",
              "Strict",
              "TyLit",
              "TySynEqn",
              "TyVarBndr",
              "Word#",
              "Word8",
              "[(Guard, Exp)]",
              "[(Name, Exp)]",
              "[(Name, Pat)]",
              "[(Name, Strict, Type)]",
              "[(Strict, Type)]",
              "[Char] (aka String)",
              "[Clause]",
              "[Con]",
              "[Dec]",
              "[Exp]",
              "[FunDep]",
              "[Match]",
              "[Name]",
              "[Pat]",
              "[Role]",
              "[RuleBndr]",
              "[Stmt]",
              "[TySynEqn]",
              "[TyVarBndr]",
              "[Word8]",
              "[[Stmt]]",
              "[]",
              "a"
    ]

bitsInstances :: Set String
bitsInstances =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
      "instance Bits CChar","instance Bits CInt","instance Bits CIntMax","instance Bits CIntPtr","instance Bits CLLong","instance Bits CLong","instance Bits CPtrdiff","instance Bits CSChar","instance Bits CShort","instance Bits CSigAtomic","instance Bits CSize","instance Bits CUChar","instance Bits CUInt","instance Bits CUIntMax","instance Bits CUIntPtr","instance Bits CULLong","instance Bits CULong","instance Bits CUShort","instance Bits CWchar",
#endif
      "instance Bits Bool","instance Bits Int","instance Bits Integer","instance Bits Word","instance Bits Word16","instance Bits Word32","instance Bits Word64","instance Bits Word8",
      -- These come and go depending on the version of something.
      "instance Bits Int16","instance Bits Int32","instance Bits Int64","instance Bits Int8","instance Bits Natural"
    ]

enumInstances :: Set String
enumInstances =
  Set.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
      "instance Enum (Fixed a)","instance Enum (Proxy s)","instance Enum (f a) => Enum (Alt f a)","instance Enum CChar","instance Enum CClock","instance Enum CDouble","instance Enum CFloat","instance Enum CInt","instance Enum CIntMax","instance Enum CIntPtr","instance Enum CLLong","instance Enum CLong","instance Enum CPtrdiff","instance Enum CSChar","instance Enum CSUSeconds","instance Enum CShort","instance Enum CSigAtomic","instance Enum CSize","instance Enum CTime","instance Enum CUChar","instance Enum CUInt","instance Enum CUIntMax","instance Enum CUIntPtr","instance Enum CULLong","instance Enum CULong","instance Enum CUSeconds","instance Enum CUShort","instance Enum CWchar","instance Enum Day","instance Enum NominalDiffTime",
#endif
      "instance Enum ()","instance Enum Bool","instance Enum Char","instance Enum Double","instance Enum Float","instance Enum Int","instance Enum Int16","instance Enum Int32","instance Enum Int64","instance Enum Int8","instance Enum Integer","instance Enum Natural","instance Enum Ordering","instance Enum Word","instance Enum Word16","instance Enum Word32","instance Enum Word64","instance Enum Word8","instance Integral a => Enum (Ratio a)"
    ]

arrayInstances :: Set String
arrayInstances =
  Set.fromList
    ["instance IArray UArray (FunPtr a)","instance IArray UArray (Ptr a)","instance IArray UArray (StablePtr a)","instance IArray UArray Bool","instance IArray UArray Char","instance IArray UArray Double","instance IArray UArray Float","instance IArray UArray Int","instance IArray UArray Int16","instance IArray UArray Int32","instance IArray UArray Int64","instance IArray UArray Int8","instance IArray UArray Word","instance IArray UArray Word16","instance IArray UArray Word32","instance IArray UArray Word64","instance IArray UArray Word8"]

decTypeSynonyms :: Map (E Type) ((), Set Name)
decTypeSynonyms =
  Map.fromList
    [
#if MIN_VERSION_template_haskell(2,10,0)
     (E (AppT (AppT (AppT (TupleT 3) (ConT ''Name)) (ConT ''Strict)) (ConT ''Type)), ((), Set.fromList [''VarStrictType])),
     (E (AppT (AppT (TupleT 2) (ConT ''Name)) (ConT ''Exp)),                         ((), Set.fromList [''FieldExp])),
     (E (AppT (AppT (TupleT 2) (ConT ''Name)) (ConT ''Pat)),                         ((), Set.fromList [''FieldPat])),
     (E (AppT (AppT (TupleT 2) (ConT ''Strict)) (ConT ''Type)),                      ((), Set.fromList [''StrictType])),
     (E (AppT (ConT ''Ratio) (ConT ''Integer)),                                      ((), Set.fromList [''Rational])),
     (E (AppT ListT (ConT ''Char)),                                                  ((), Set.fromList [''String])),
     (E (AppT ListT (ConT ''Type)),                                                  ((), Set.fromList [''Cxt])),
     (E (ConT ''Type),                                                               ((), Set.fromList [''Kind,''Pred]))
#else
     (E (AppT (AppT (AppT (TupleT 3) (ConT ''Name)) (ConT ''Strict)) (ConT ''Type)), ((), Set.fromList [''VarStrictType])),
     (E (AppT (AppT (TupleT 2) (ConT ''Name)) (ConT ''Exp)),                         ((), Set.fromList [''FieldExp])),
     (E (AppT (AppT (TupleT 2) (ConT ''Name)) (ConT ''Pat)),                         ((), Set.fromList [''FieldPat])),
     (E (AppT (AppT (TupleT 2) (ConT ''Strict)) (ConT ''Type)),                      ((), Set.fromList [''StrictType])),
     (E (AppT (ConT ''Ratio) (ConT ''Integer)),                                      ((), Set.fromList [''Rational])),
     (E (AppT ListT (ConT ''Char)),                                                  ((), Set.fromList [''String])),
     (E (AppT ListT (ConT ''Pred)),                                                  ((), Set.fromList [''Cxt])),
     (E (ConT ''Type),                                                               ((), Set.fromList [''Kind]))
#endif
    ]
