module Data.Thrist.List ( List(..) ) where

import Data.Thrist
import Control.Monad

-- Adapter for creating lists:
--   (Thrist List a a) is isomorphic to [a]

data List :: * -> * -> * where
  El :: a -> List a a

-- It forms a monad
--

newtype List' a = List' (Thrist List a a)

instance Monad List' where
  return a = List' $ Cons (El a) Nil
  List' a >>= f = undefined

{- We need something like:

instance  Monad []  where
    m >>= k             = foldr ((++) . k) [] m
    m >> k              = foldr ((++) . (\ _ -> k)) [] m
    return x            = [x]
    fail _              = []
-}
