{- |
Module      : Data.Hourglass.Compat
License     : BSD-style
Copyright   : (c) 2015 Nicolas DI PRIMA <nicolas@di-prima.fr>

Basic Time conversion compatibility.

This module aims to help conversion between the types from the package time to
the package hourglass.

Example of use (extracted from file Example/Time/Compat.hs):

> import Data.Hourglass as H
> import Time.Compat as C
> import Data.Time as T
>
> transpose :: T.ZonedTime -> H.LocalTime H.DateTime
> transpose oldTime = H.localTime
>   offsetTime
>   (H.DateTime newDate timeofday)
>  where
>   T.ZonedTime (T.LocalTime day tod) (T.TimeZone tzmin _ _) = oldTime
>
>   newDate :: H.Date
>   newDate = C.dateFromMJDEpoch $ T.toModifiedJulianDay day
>
>   timeofday :: H.TimeOfDay
>   timeofday = C.diffTimeToTimeOfDay $ toRational $ T.timeOfDayToTime tod
>
>   offsetTime = H.TimezoneOffset $ fromIntegral tzmin
-}

module Data.Hourglass.Compat
{-# DEPRECATED "Use Time.Compat instead. Will be removed from future versions of this package." #-}
  ( module Time.Compat
  ) where

import Time.Compat
