[![Hackage](https://img.shields.io/hackage/v/tmp-postgres.svg?style=flat)](https://hackage.haskell.org/package/tmp-postgres)
[![Travis CI Status](https://travis-ci.org/jfischoff/tmp-postgres.svg?branch=master)](http://travis-ci.org/jfischoff/tmp-postgres)
# tmp-postgres

`tmp-postgres` provides functions for creating a temporary `postgres` instance.
By default it will create a temporary data directory and
a temporary directory for a UNIX domain socket for `postgres` to listen on.

Here is an example using the expection safe 'with' function:

```haskell
with $ \db -> bracket
  (connectPostgreSQL (toConnectionString db))
  close $
  \conn -> execute_ conn "CREATE TABLE foo (id int)"
```

To extend or override the defaults use `withConfig` (or `startConfig`).

`tmp-postgres` ultimately calls (optionally) `initdb`, `postgres` and
(optionally) `createdb`.

All of the command line, environment variables and configuration files
that are generated by default for the respective executables can be
extended.

In general `tmp-postgres` is useful if you want a clean temporary
`postgres` and do not want to worry about clashing with an existing
postgres instance (or needing to ensure `postgres` is already running).

Here are some different use cases for `tmp-postgres` and their respective
configurations:

* The default 'with' and 'start' functions can be used to make a sandboxed
temporary database for testing.
* By disabling `initdb` one could run a temporary
isolated postgres on a base backup to test a migration.
* By using the 'stopPostgres' and 'withRestart' functions one can test
backup strategies.

WARNING!!
Ubuntu's PostgreSQL installation does not put `initdb` on the `PATH`. We need to add it manually.
The necessary binaries are in the `/usr/lib/postgresql/VERSION/bin/` directory, and should be added to the `PATH`

 > echo "export PATH=$PATH:/usr/lib/postgresql/VERSION/bin/" >> /home/ubuntu/.bashrc

# Installation

## macOS
```
$ brew install postgres
$ stack install tmp-postgres
```

## Ubuntu

Ubuntu's PostgreSQL installation does not put `initdb` on the PATH. We need to add it manually.

```
$ sudo apt-get install postgresql-VERSION
$ echo "export PATH=$PATH:/usr/lib/postgresql/VERSION/bin/" >> /home/ubuntu/.bashrc
$ stack install tmp-postgres
```
