[![Travis CI Status](https://travis-ci.org/jfischoff/tmp-postgres.svg?branch=master)](http://travis-ci.org/jfischoff/tmp-postgres)
# tmp-postgres

`tmp-postgres` provides functions creating a temporary `postgres` instance.
By default it will create a temporary directory for the data,
a random port for listening and a temporary directory for a UNIX
domain socket.

Here is an example using the expection safe 'with' function:

```haskell
 with $ \db -> bracket (connectPostgreSQL (toConnectionString db)) close $ \conn ->
  execute_ conn "CREATE TABLE foo (id int)"
```

To extend or override the defaults use `withConfig` (or `startConfig`).

`tmp-postgres` ultimately calls `initdb`, `postgres` and `createdb`.
All of the command line, environment variables and configuration files
that are generated by default for the respective executables can be
extended or overrided.

All `tmp-postgres` by default is most useful for creating tests by
configuring "tmp-postgres" differently it can be used for other purposes.

* By disabling `initdb` and `createdb` one could run a temporary
postgres on a base backup to test a migration.
* By using the `stopPostgres` and `withRestart` functions one can test
backup strategies.

The level of custom configuration is extensive but with great power comes
ability to screw everything up. `tmp-postgres` doesn't validate any custom
configuration and one can easily create a `Config` that would not allow
postgres to start.

# Installation

## macOS
```
$ brew install postgres
$ stack install tmp-postgres
```

## Ubuntu

Ubuntu's PostgreSQL installation does not put `initdb` on the PATH. We need to add it manually.

```
$ sudo apt-get install postgresql-VERSION
$ echo "export PATH=$PATH:/usr/lib/postgresql/VERSION/bin/" >> /home/ubuntu/.bashrc
$ stack install tmp-postgres
```
