#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 10
#define STATE_COUNT 969
#define SYMBOL_COUNT 275
#define ALIAS_COUNT 1
#define TOKEN_COUNT 123
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 10

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  sym_string_literal = 11,
  sym_null_literal = 12,
  anon_sym_LPAREN = 13,
  anon_sym_AMP = 14,
  anon_sym_RPAREN = 15,
  anon_sym_EQ = 16,
  anon_sym_PLUS_EQ = 17,
  anon_sym_DASH_EQ = 18,
  anon_sym_STAR_EQ = 19,
  anon_sym_SLASH_EQ = 20,
  anon_sym_AMP_EQ = 21,
  anon_sym_PIPE_EQ = 22,
  anon_sym_CARET_EQ = 23,
  anon_sym_PERCENT_EQ = 24,
  anon_sym_LT_LT_EQ = 25,
  anon_sym_GT_GT_EQ = 26,
  anon_sym_GT_GT_GT_EQ = 27,
  anon_sym_GT = 28,
  anon_sym_LT = 29,
  anon_sym_EQ_EQ = 30,
  anon_sym_GT_EQ = 31,
  anon_sym_LT_EQ = 32,
  anon_sym_BANG_EQ = 33,
  anon_sym_AMP_AMP = 34,
  anon_sym_PIPE_PIPE = 35,
  anon_sym_PLUS = 36,
  anon_sym_DASH = 37,
  anon_sym_STAR = 38,
  anon_sym_SLASH = 39,
  anon_sym_PIPE = 40,
  anon_sym_CARET = 41,
  anon_sym_PERCENT = 42,
  anon_sym_LT_LT = 43,
  anon_sym_GT_GT = 44,
  anon_sym_GT_GT_GT = 45,
  anon_sym_instanceof = 46,
  anon_sym_DASH_GT = 47,
  anon_sym_COMMA = 48,
  anon_sym_QMARK = 49,
  anon_sym_COLON = 50,
  anon_sym_BANG = 51,
  anon_sym_TILDE = 52,
  anon_sym_PLUS_PLUS = 53,
  anon_sym_DASH_DASH = 54,
  anon_sym_new = 55,
  anon_sym_LBRACK = 56,
  anon_sym_RBRACK = 57,
  anon_sym_DOT = 58,
  anon_sym_class = 59,
  anon_sym_COLON_COLON = 60,
  anon_sym_extends = 61,
  anon_sym_SEMI = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_assert = 65,
  anon_sym_switch = 66,
  anon_sym_case = 67,
  anon_sym_default = 68,
  anon_sym_do = 69,
  anon_sym_while = 70,
  anon_sym_break = 71,
  anon_sym_continue = 72,
  anon_sym_return = 73,
  anon_sym_synchronized = 74,
  anon_sym_throw = 75,
  anon_sym_try = 76,
  anon_sym_catch = 77,
  anon_sym_finally = 78,
  anon_sym_if = 79,
  anon_sym_else = 80,
  anon_sym_for = 81,
  anon_sym_AT = 82,
  anon_sym_open = 83,
  anon_sym_module = 84,
  anon_sym_requires = 85,
  anon_sym_exports = 86,
  anon_sym_to = 87,
  anon_sym_opens = 88,
  anon_sym_uses = 89,
  anon_sym_provides = 90,
  anon_sym_with = 91,
  anon_sym_transitive = 92,
  anon_sym_static = 93,
  anon_sym_package = 94,
  anon_sym_import = 95,
  anon_sym_enum = 96,
  anon_sym_public = 97,
  anon_sym_protected = 98,
  anon_sym_private = 99,
  anon_sym_abstract = 100,
  anon_sym_final = 101,
  anon_sym_strictfp = 102,
  anon_sym_native = 103,
  anon_sym_transient = 104,
  anon_sym_volatile = 105,
  anon_sym_implements = 106,
  anon_sym_ATinterface = 107,
  anon_sym_interface = 108,
  anon_sym_byte = 109,
  anon_sym_short = 110,
  anon_sym_int = 111,
  anon_sym_long = 112,
  anon_sym_char = 113,
  anon_sym_float = 114,
  anon_sym_double = 115,
  sym_boolean_type = 116,
  sym_void_type = 117,
  anon_sym_DOT_DOT_DOT = 118,
  anon_sym_throws = 119,
  sym_this = 120,
  sym_super = 121,
  sym_comment = 122,
  sym_program = 123,
  sym__literal = 124,
  sym__expression = 125,
  sym_cast_expression = 126,
  sym_assignment_expression = 127,
  sym_binary_expression = 128,
  sym_instanceof_expression = 129,
  sym_lambda_expression = 130,
  sym_inferred_parameters = 131,
  sym_ternary_expression = 132,
  sym_unary_expression = 133,
  sym_update_expression = 134,
  sym__primary = 135,
  sym_array_creation_expression = 136,
  sym_dimensions_expr = 137,
  sym__primary_no_new_array = 138,
  sym_parenthesized_expression = 139,
  sym_class_literal = 140,
  sym_object_creation_expression = 141,
  sym__unqualified_object_creation_expression = 142,
  sym_field_access = 143,
  sym_array_access = 144,
  sym_method_invocation = 145,
  sym_argument_list = 146,
  sym_method_reference = 147,
  sym_type_arguments = 148,
  sym_wildcard = 149,
  sym__wildcard_bounds = 150,
  sym_dimensions = 151,
  sym_block = 152,
  sym_expression_statement = 153,
  sym_labeled_statement = 154,
  sym_assert_statement = 155,
  sym_switch_statement = 156,
  sym_switch_block = 157,
  sym_switch_label = 158,
  sym_do_statement = 159,
  sym_break_statement = 160,
  sym_continue_statement = 161,
  sym_return_statement = 162,
  sym_synchronized_statement = 163,
  sym_throw_statement = 164,
  sym_try_statement = 165,
  sym_catch_clause = 166,
  sym_catch_formal_parameter = 167,
  sym_catch_type = 168,
  sym_finally_clause = 169,
  sym_try_with_resources_statement = 170,
  sym_resource_specification = 171,
  sym_resource = 172,
  sym_if_statement = 173,
  sym_while_statement = 174,
  sym_for_statement = 175,
  sym_for_init = 176,
  sym_enhanced_for_statement = 177,
  sym__annotation = 178,
  sym_marker_annotation = 179,
  sym_annotation = 180,
  sym_annotation_argument_list = 181,
  sym_element_value_pair = 182,
  sym__element_value = 183,
  sym_element_value_array_initializer = 184,
  sym__declaration = 185,
  sym_module_declaration = 186,
  sym_module_directive = 187,
  sym_requires_modifier = 188,
  sym_module_name = 189,
  sym_package_declaration = 190,
  sym_import_declaration = 191,
  sym_asterisk = 192,
  sym_enum_declaration = 193,
  sym_enum_body_declarations = 194,
  sym_enum_constant = 195,
  sym_class_declaration = 196,
  sym_modifiers = 197,
  sym_type_parameters = 198,
  sym_type_parameter = 199,
  sym_type_bound = 200,
  sym_superclass = 201,
  sym_super_interfaces = 202,
  sym_interface_type_list = 203,
  sym_class_body = 204,
  sym_static_initializer = 205,
  sym_constructor_declaration = 206,
  sym_constructor_declarator = 207,
  sym_constructor_body = 208,
  sym_explicit_constructor_invocation = 209,
  sym_scoped_identifier = 210,
  sym_field_declaration = 211,
  sym_interface_declaration = 212,
  sym_annotation_type_declaration = 213,
  sym_annotation_type_body = 214,
  sym_annotation_type_member_declaration = 215,
  sym_annotation_type_element_declaration = 216,
  sym_default_value = 217,
  sym_normal_interface_declaration = 218,
  sym_extends_interfaces = 219,
  sym_interface_body = 220,
  sym_interface_member_declaration = 221,
  sym_constant_declaration = 222,
  sym__variable_declarator_list = 223,
  sym_variable_declarator = 224,
  sym__variable_declarator_id = 225,
  sym_array_initializer = 226,
  sym__type = 227,
  sym__unannotated_type = 228,
  sym_annotated_type = 229,
  sym_scoped_type_identifier = 230,
  sym_generic_type = 231,
  sym_array_type = 232,
  sym_integral_type = 233,
  sym_floating_point_type = 234,
  sym__method_header = 235,
  sym__method_declarator = 236,
  sym_formal_parameters = 237,
  sym_formal_parameter = 238,
  sym_receiver_parameter = 239,
  sym_spread_parameter = 240,
  sym_throws = 241,
  sym_local_variable_declaration_statement = 242,
  sym_local_variable_declaration = 243,
  sym_method_declaration = 244,
  aux_sym_program_repeat1 = 245,
  aux_sym_cast_expression_repeat1 = 246,
  aux_sym_inferred_parameters_repeat1 = 247,
  aux_sym_array_creation_expression_repeat1 = 248,
  aux_sym_dimensions_expr_repeat1 = 249,
  aux_sym_class_literal_repeat1 = 250,
  aux_sym_argument_list_repeat1 = 251,
  aux_sym_type_arguments_repeat1 = 252,
  aux_sym_dimensions_repeat1 = 253,
  aux_sym_switch_block_repeat1 = 254,
  aux_sym_try_statement_repeat1 = 255,
  aux_sym_catch_type_repeat1 = 256,
  aux_sym_resource_specification_repeat1 = 257,
  aux_sym_annotation_argument_list_repeat1 = 258,
  aux_sym_element_value_array_initializer_repeat1 = 259,
  aux_sym_module_declaration_repeat1 = 260,
  aux_sym_module_directive_repeat1 = 261,
  aux_sym_module_directive_repeat2 = 262,
  aux_sym_module_directive_repeat3 = 263,
  aux_sym_import_declaration_repeat1 = 264,
  aux_sym_enum_declaration_repeat1 = 265,
  aux_sym_enum_body_declarations_repeat1 = 266,
  aux_sym_modifiers_repeat1 = 267,
  aux_sym_type_parameters_repeat1 = 268,
  aux_sym_interface_type_list_repeat1 = 269,
  aux_sym_annotation_type_body_repeat1 = 270,
  aux_sym_interface_body_repeat1 = 271,
  aux_sym__variable_declarator_list_repeat1 = 272,
  aux_sym_array_initializer_repeat1 = 273,
  aux_sym_formal_parameters_repeat1 = 274,
  alias_sym_type_identifier = 275,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_AMP] = "&",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_SEMI] = ";",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_assert] = "assert",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_final] = "final",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_implements] = "implements",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_comment] = "comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym__expression] = "_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym__primary] = "_primary",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym__primary_no_new_array] = "_primary_no_new_array",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_block] = "switch_block",
  [sym_switch_label] = "switch_label",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_init] = "for_init",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym__declaration] = "_declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_directive] = "module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_module_name] = "module_name",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_interface_type_list] = "interface_type_list",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym_constructor_declarator] = "constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_interface_declaration] = "interface_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_member_declaration] = "annotation_type_member_declaration",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym_default_value] = "default_value",
  [sym_normal_interface_declaration] = "normal_interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_interface_member_declaration] = "interface_member_declaration",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration_statement] = "local_variable_declaration_statement",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_dimensions_expr_repeat1] = "dimensions_expr_repeat1",
  [aux_sym_class_literal_repeat1] = "class_literal_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_declaration_repeat1] = "module_declaration_repeat1",
  [aux_sym_module_directive_repeat1] = "module_directive_repeat1",
  [aux_sym_module_directive_repeat2] = "module_directive_repeat2",
  [aux_sym_module_directive_repeat3] = "module_directive_repeat3",
  [aux_sym_import_declaration_repeat1] = "import_declaration_repeat1",
  [aux_sym_enum_declaration_repeat1] = "enum_declaration_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_interface_type_list_repeat1] = "interface_type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary] = {
    .visible = false,
    .named = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_no_new_array] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_init] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_module_name] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_member_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_default_value] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_member_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_declarator = 6,
  field_dimensions = 7,
  field_element = 8,
  field_interfaces = 9,
  field_left = 10,
  field_name = 11,
  field_object = 12,
  field_operand = 13,
  field_operator = 14,
  field_parameters = 15,
  field_resources = 16,
  field_right = 17,
  field_superclass = 18,
  field_type = 19,
  field_type_arguments = 20,
  field_type_parameters = 21,
  field_value = 22,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_interfaces] = "interfaces",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 7, .length = 1},
  [8] = {.index = 7, .length = 1},
  [9] = {.index = 8, .length = 2},
  [10] = {.index = 10, .length = 1},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 3},
  [15] = {.index = 18, .length = 3},
  [16] = {.index = 21, .length = 2},
  [18] = {.index = 23, .length = 3},
  [19] = {.index = 26, .length = 2},
  [20] = {.index = 28, .length = 2},
  [21] = {.index = 30, .length = 2},
  [22] = {.index = 32, .length = 2},
  [23] = {.index = 34, .length = 2},
  [24] = {.index = 32, .length = 2},
  [25] = {.index = 34, .length = 2},
  [26] = {.index = 36, .length = 2},
  [27] = {.index = 38, .length = 1},
  [28] = {.index = 15, .length = 3},
  [29] = {.index = 18, .length = 3},
  [31] = {.index = 39, .length = 2},
  [32] = {.index = 39, .length = 2},
  [33] = {.index = 41, .length = 2},
  [34] = {.index = 43, .length = 2},
  [35] = {.index = 45, .length = 2},
  [36] = {.index = 47, .length = 3},
  [38] = {.index = 50, .length = 3},
  [39] = {.index = 53, .length = 3},
  [40] = {.index = 56, .length = 3},
  [41] = {.index = 59, .length = 3},
  [42] = {.index = 62, .length = 3},
  [43] = {.index = 65, .length = 3},
  [44] = {.index = 62, .length = 3},
  [45] = {.index = 65, .length = 3},
  [46] = {.index = 68, .length = 3},
  [47] = {.index = 68, .length = 3},
  [48] = {.index = 47, .length = 3},
  [51] = {.index = 71, .length = 3},
  [52] = {.index = 74, .length = 1},
  [53] = {.index = 75, .length = 2},
  [54] = {.index = 77, .length = 2},
  [55] = {.index = 79, .length = 4},
  [56] = {.index = 83, .length = 3},
  [57] = {.index = 86, .length = 5},
  [58] = {.index = 91, .length = 6},
  [59] = {.index = 97, .length = 4},
  [60] = {.index = 101, .length = 4},
  [61] = {.index = 105, .length = 4},
  [62] = {.index = 109, .length = 4},
  [63] = {.index = 79, .length = 4},
  [64] = {.index = 113, .length = 3},
  [65] = {.index = 116, .length = 3},
  [66] = {.index = 119, .length = 3},
  [67] = {.index = 122, .length = 3},
  [68] = {.index = 125, .length = 3},
  [69] = {.index = 128, .length = 5},
  [70] = {.index = 133, .length = 6},
  [71] = {.index = 139, .length = 2},
  [72] = {.index = 139, .length = 2},
  [73] = {.index = 141, .length = 1},
  [74] = {.index = 142, .length = 5},
  [75] = {.index = 147, .length = 5},
  [76] = {.index = 152, .length = 4},
  [77] = {.index = 156, .length = 2},
  [78] = {.index = 125, .length = 3},
  [80] = {.index = 158, .length = 4},
  [81] = {.index = 162, .length = 4},
  [82] = {.index = 166, .length = 4},
  [83] = {.index = 170, .length = 4},
  [84] = {.index = 174, .length = 1},
  [85] = {.index = 175, .length = 3},
  [86] = {.index = 175, .length = 3},
  [87] = {.index = 178, .length = 5},
  [88] = {.index = 183, .length = 4},
  [89] = {.index = 187, .length = 1},
  [90] = {.index = 188, .length = 2},
  [91] = {.index = 170, .length = 4},
  [92] = {.index = 190, .length = 5},
  [93] = {.index = 195, .length = 5},
  [95] = {.index = 200, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_arguments, 1},
    {field_name, 0},
  [5] =
    {field_operand, 1},
    {field_operator, 0},
  [7] =
    {field_name, 0},
  [8] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [10] =
    {field_declarator, 0},
  [11] =
    {field_dimensions, 1},
    {field_element, 0},
  [13] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [15] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [18] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [21] =
    {field_body, 2},
    {field_parameters, 0},
  [23] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [26] =
    {field_body, 2},
    {field_condition, 1},
  [28] =
    {field_condition, 1},
    {field_consequence, 2},
  [30] =
    {field_body, 2},
    {field_name, 1},
  [32] =
    {field_arguments, 2},
    {field_type, 1},
  [34] =
    {field_dimensions, 2},
    {field_type, 1},
  [36] =
    {field_body, 2},
    {field_resources, 1},
  [38] =
    {field_body, 1},
  [39] =
    {field_dimensions, 1},
    {field_name, 0},
  [41] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [43] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [45] =
    {field_left, 0},
    {field_right, 2},
  [47] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [50] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [53] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [56] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [59] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [62] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [65] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [68] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [71] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [74] =
    {field_declarator, 1},
  [75] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [77] =
    {field_body, 3},
    {field_name, 2},
  [79] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [83] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [86] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [91] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [97] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [101] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [105] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [109] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [113] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [116] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [119] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [122] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [125] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [128] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [133] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [139] =
    {field_name, 0},
    {field_parameters, 1},
  [141] =
    {field_declarator, 1, .inherited = true},
  [142] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [147] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [152] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [156] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [158] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [162] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [166] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [170] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [174] =
    {field_declarator, 2, .inherited = true},
  [175] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [178] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [183] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [187] =
    {field_body, 4},
  [188] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [190] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [195] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [200] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
};

static TSSymbol ts_alias_sequences[96][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [2] = {
    [0] = sym_identifier,
  },
  [6] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = sym_identifier,
  },
  [14] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [17] = {
    [1] = sym_identifier,
  },
  [22] = {
    [1] = alias_sym_type_identifier,
  },
  [23] = {
    [1] = alias_sym_type_identifier,
  },
  [28] = {
    [0] = sym_identifier,
  },
  [29] = {
    [0] = sym_identifier,
  },
  [30] = {
    [2] = alias_sym_type_identifier,
  },
  [31] = {
    [0] = sym_identifier,
  },
  [37] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [42] = {
    [1] = alias_sym_type_identifier,
  },
  [43] = {
    [1] = alias_sym_type_identifier,
  },
  [47] = {
    [2] = alias_sym_type_identifier,
  },
  [48] = {
    [0] = sym_identifier,
  },
  [49] = {
    [3] = alias_sym_type_identifier,
  },
  [50] = {
    [2] = sym_identifier,
  },
  [63] = {
    [0] = sym_identifier,
  },
  [72] = {
    [0] = sym_identifier,
  },
  [78] = {
    [0] = sym_identifier,
  },
  [79] = {
    [3] = sym_identifier,
  },
  [86] = {
    [0] = sym_identifier,
  },
  [91] = {
    [0] = sym_identifier,
  },
  [94] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 0) ADVANCE(46);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(8);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(73);
      if (lookahead == '\'') ADVANCE(20);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(101);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 1:
      if (lookahead == 0) ADVANCE(46);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(8);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '\'') ADVANCE(20);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(136);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(19);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 2:
      if (lookahead == 0) ADVANCE(46);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(8);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '\'') ADVANCE(20);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(19);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 3:
      if (lookahead == 0) ADVANCE(46);
      if (lookahead == '!') ADVANCE(126);
      if (lookahead == '"') ADVANCE(8);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(20);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(126);
      if (lookahead == '"') ADVANCE(8);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(20);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(17);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(108);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(73);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(101);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(19);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(19);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(108);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 10:
      if (lookahead == '\'') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(147);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(146);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(144);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 17:
      if (lookahead == ':') ADVANCE(137);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 20:
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(10);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 25:
      if (lookahead == '_') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(28);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 31:
      if (lookahead == 'f') ADVANCE(27);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(31);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 35:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 36:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 37:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(57);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(55);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 44:
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 45:
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(37);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(47);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(38);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(16);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(35);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(35);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(47);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(35);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(35);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(50);
      if (lookahead == '_') ADVANCE(24);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(36);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(50);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(50);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(54);
      if (lookahead == '_') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(56);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(35);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(23);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(35);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(43);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(26);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(36);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(25);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (lookahead == '_') ADVANCE(43);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_string_literal);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(98);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(95);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(95);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(116);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(115);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(129);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(130);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(147);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '|') ADVANCE(99);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(99);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(86);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(137);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(15);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(32);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(147);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'r') ADVANCE(22);
      if (lookahead == 'y') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'h') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(32);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'i') ADVANCE(34);
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(37);
      if (lookahead == 'm') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'u') ADVANCE(44);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(45);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(47);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 't') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == 'w') ADVANCE(53);
      if (lookahead == 'y') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(60);
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(62);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(70);
      END_STATE();
    case 27:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(72);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(73);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 32:
      if (lookahead == 'p') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 35:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 38:
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 41:
      if (lookahead == 'd') ADVANCE(86);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 43:
      if (lookahead == 'w') ADVANCE(88);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(92);
      if (lookahead == 'o') ADVANCE(93);
      END_STATE();
    case 48:
      if (lookahead == 'b') ADVANCE(94);
      END_STATE();
    case 49:
      if (lookahead == 'q') ADVANCE(95);
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 50:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(98);
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(100);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(101);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'u') ADVANCE(106);
      if (lookahead == 'y') ADVANCE(107);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == 'l') ADVANCE(110);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(119);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 73:
      if (lookahead == 'b') ADVANCE(124);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(126);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(132);
      if (lookahead == 'o') ADVANCE(133);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 85:
      if (lookahead == 'g') ADVANCE(136);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 87:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 90:
      if (lookahead == 'n') ADVANCE(140);
      END_STATE();
    case 91:
      if (lookahead == 'k') ADVANCE(141);
      END_STATE();
    case 92:
      if (lookahead == 'v') ADVANCE(142);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(143);
      if (lookahead == 'v') ADVANCE(144);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 95:
      if (lookahead == 'u') ADVANCE(146);
      END_STATE();
    case 96:
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(150);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 104:
      if (lookahead == 'o') ADVANCE(155);
      END_STATE();
    case 105:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(158);
      END_STATE();
    case 109:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 112:
      if (lookahead == 'h') ADVANCE(162);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 116:
      if (lookahead == 'k') ADVANCE(166);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 119:
      if (lookahead == 'h') ADVANCE(167);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 121:
      if (lookahead == 's') ADVANCE(168);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(169);
      END_STATE();
    case 123:
      if (lookahead == 'u') ADVANCE(170);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 127:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 137:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 138:
      if (lookahead == 'v') ADVANCE(182);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(185);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(187);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(190);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 150:
      if (lookahead == 'c') ADVANCE(193);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(195);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(196);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 155:
      if (lookahead == 'w') ADVANCE(197);
      END_STATE();
    case 156:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(201);
      END_STATE();
    case 164:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(203);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 173:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 177:
      if (lookahead == 'm') ADVANCE(210);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 180:
      if (lookahead == 'f') ADVANCE(213);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 184:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(217);
      END_STATE();
    case 186:
      if (lookahead == 'c') ADVANCE(218);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(219);
      END_STATE();
    case 188:
      if (lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 189:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 192:
      if (lookahead == 'c') ADVANCE(223);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 195:
      if (lookahead == 'h') ADVANCE(225);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(227);
      END_STATE();
    case 198:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 199:
      if (lookahead == 'i') ADVANCE(229);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(230);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 204:
      if (lookahead == 'u') ADVANCE(232);
      END_STATE();
    case 205:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 207:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 208:
      if (lookahead == 's') ADVANCE(235);
      END_STATE();
    case 209:
      if (lookahead == 'y') ADVANCE(236);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(237);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 212:
      if (lookahead == 'c') ADVANCE(238);
      END_STATE();
    case 213:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 219:
      if (lookahead == 'e') ADVANCE(243);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(244);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 224:
      if (lookahead == 'f') ADVANCE(245);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 226:
      if (lookahead == 'o') ADVANCE(246);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(247);
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 229:
      if (lookahead == 'l') ADVANCE(249);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 237:
      if (lookahead == 'n') ADVANCE(252);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 239:
      if (lookahead == 'c') ADVANCE(254);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 243:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 244:
      if (lookahead == 's') ADVANCE(257);
      END_STATE();
    case 245:
      if (lookahead == 'p') ADVANCE(258);
      END_STATE();
    case 246:
      if (lookahead == 'n') ADVANCE(259);
      END_STATE();
    case 247:
      if (lookahead == 'n') ADVANCE(260);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(261);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 252:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 253:
      if (lookahead == 'o') ADVANCE(264);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 255:
      if (lookahead == 'd') ADVANCE(266);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 259:
      if (lookahead == 'i') ADVANCE(267);
      END_STATE();
    case 260:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 261:
      if (lookahead == 'v') ADVANCE(269);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 263:
      if (lookahead == 's') ADVANCE(270);
      END_STATE();
    case 264:
      if (lookahead == 'f') ADVANCE(271);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 267:
      if (lookahead == 'z') ADVANCE(272);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 274:
      if (lookahead == 'd') ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 3},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 5},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 4},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 5},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 4},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 4},
  [17] = {.lex_state = 3},
  [18] = {.lex_state = 5},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 4},
  [23] = {.lex_state = 9},
  [24] = {.lex_state = 3},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 4},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 5},
  [31] = {.lex_state = 9},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 5},
  [34] = {.lex_state = 5},
  [35] = {.lex_state = 3},
  [36] = {.lex_state = 9},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 5},
  [39] = {.lex_state = 5},
  [40] = {.lex_state = 5},
  [41] = {.lex_state = 6},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 6},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 6},
  [50] = {.lex_state = 6},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 5},
  [53] = {.lex_state = 9},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 4},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 4},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 5},
  [63] = {.lex_state = 4},
  [64] = {.lex_state = 9},
  [65] = {.lex_state = 6},
  [66] = {.lex_state = 5},
  [67] = {.lex_state = 5},
  [68] = {.lex_state = 5},
  [69] = {.lex_state = 5},
  [70] = {.lex_state = 3},
  [71] = {.lex_state = 5},
  [72] = {.lex_state = 6},
  [73] = {.lex_state = 4},
  [74] = {.lex_state = 5},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 5},
  [77] = {.lex_state = 5},
  [78] = {.lex_state = 5},
  [79] = {.lex_state = 5},
  [80] = {.lex_state = 5},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 6},
  [83] = {.lex_state = 5},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 5},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 4},
  [88] = {.lex_state = 3},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 6},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 0},
  [100] = {.lex_state = 6},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 3},
  [103] = {.lex_state = 0},
  [104] = {.lex_state = 0},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 6},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 3},
  [109] = {.lex_state = 0},
  [110] = {.lex_state = 6},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 0},
  [113] = {.lex_state = 6},
  [114] = {.lex_state = 4},
  [115] = {.lex_state = 0},
  [116] = {.lex_state = 4},
  [117] = {.lex_state = 0},
  [118] = {.lex_state = 4},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 4},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 4},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 5},
  [127] = {.lex_state = 6},
  [128] = {.lex_state = 5},
  [129] = {.lex_state = 5},
  [130] = {.lex_state = 3},
  [131] = {.lex_state = 5},
  [132] = {.lex_state = 9},
  [133] = {.lex_state = 9},
  [134] = {.lex_state = 0},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 4},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 9},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 4},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 4},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 3},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 4},
  [157] = {.lex_state = 4},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 4},
  [160] = {.lex_state = 4},
  [161] = {.lex_state = 4},
  [162] = {.lex_state = 4},
  [163] = {.lex_state = 6},
  [164] = {.lex_state = 3},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 6},
  [168] = {.lex_state = 6},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 3},
  [171] = {.lex_state = 9},
  [172] = {.lex_state = 5},
  [173] = {.lex_state = 3},
  [174] = {.lex_state = 3},
  [175] = {.lex_state = 5},
  [176] = {.lex_state = 6},
  [177] = {.lex_state = 6},
  [178] = {.lex_state = 6},
  [179] = {.lex_state = 5},
  [180] = {.lex_state = 6},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 5},
  [183] = {.lex_state = 5},
  [184] = {.lex_state = 5},
  [185] = {.lex_state = 6},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 6},
  [188] = {.lex_state = 6},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 5},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 3},
  [193] = {.lex_state = 3},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 3},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 5},
  [200] = {.lex_state = 5},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 5},
  [204] = {.lex_state = 5},
  [205] = {.lex_state = 5},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 5},
  [208] = {.lex_state = 5},
  [209] = {.lex_state = 4},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 5},
  [213] = {.lex_state = 5},
  [214] = {.lex_state = 5},
  [215] = {.lex_state = 5},
  [216] = {.lex_state = 5},
  [217] = {.lex_state = 5},
  [218] = {.lex_state = 3},
  [219] = {.lex_state = 5},
  [220] = {.lex_state = 3},
  [221] = {.lex_state = 4},
  [222] = {.lex_state = 3},
  [223] = {.lex_state = 5},
  [224] = {.lex_state = 5},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 5},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 3},
  [231] = {.lex_state = 5},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 3},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 5},
  [237] = {.lex_state = 4},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 6},
  [240] = {.lex_state = 5},
  [241] = {.lex_state = 7},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 6},
  [244] = {.lex_state = 7},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 5},
  [247] = {.lex_state = 5},
  [248] = {.lex_state = 5},
  [249] = {.lex_state = 3},
  [250] = {.lex_state = 3},
  [251] = {.lex_state = 2},
  [252] = {.lex_state = 5},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 3},
  [255] = {.lex_state = 5},
  [256] = {.lex_state = 4},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 3},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 3},
  [262] = {.lex_state = 3},
  [263] = {.lex_state = 4},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 5},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 6},
  [269] = {.lex_state = 5},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 6},
  [272] = {.lex_state = 5},
  [273] = {.lex_state = 5},
  [274] = {.lex_state = 5},
  [275] = {.lex_state = 5},
  [276] = {.lex_state = 5},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 5},
  [280] = {.lex_state = 3},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 3},
  [284] = {.lex_state = 3},
  [285] = {.lex_state = 6},
  [286] = {.lex_state = 5},
  [287] = {.lex_state = 5},
  [288] = {.lex_state = 5},
  [289] = {.lex_state = 6},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 6},
  [292] = {.lex_state = 6},
  [293] = {.lex_state = 6},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 5},
  [296] = {.lex_state = 5},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 9},
  [301] = {.lex_state = 5},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 5},
  [304] = {.lex_state = 5},
  [305] = {.lex_state = 5},
  [306] = {.lex_state = 9},
  [307] = {.lex_state = 5},
  [308] = {.lex_state = 9},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 6},
  [319] = {.lex_state = 6},
  [320] = {.lex_state = 6},
  [321] = {.lex_state = 6},
  [322] = {.lex_state = 6},
  [323] = {.lex_state = 6},
  [324] = {.lex_state = 6},
  [325] = {.lex_state = 5},
  [326] = {.lex_state = 6},
  [327] = {.lex_state = 5},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 9},
  [331] = {.lex_state = 5},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 5},
  [334] = {.lex_state = 6},
  [335] = {.lex_state = 4},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 5},
  [340] = {.lex_state = 5},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 6},
  [343] = {.lex_state = 9},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 6},
  [346] = {.lex_state = 6},
  [347] = {.lex_state = 6},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 3},
  [358] = {.lex_state = 6},
  [359] = {.lex_state = 4},
  [360] = {.lex_state = 3},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 5},
  [366] = {.lex_state = 5},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 3},
  [369] = {.lex_state = 6},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 3},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 3},
  [374] = {.lex_state = 1},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 3},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 3},
  [389] = {.lex_state = 3},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 3},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 3},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 9},
  [401] = {.lex_state = 6},
  [402] = {.lex_state = 4},
  [403] = {.lex_state = 6},
  [404] = {.lex_state = 6},
  [405] = {.lex_state = 4},
  [406] = {.lex_state = 7},
  [407] = {.lex_state = 6},
  [408] = {.lex_state = 6},
  [409] = {.lex_state = 6},
  [410] = {.lex_state = 6},
  [411] = {.lex_state = 6},
  [412] = {.lex_state = 6},
  [413] = {.lex_state = 4},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 3},
  [416] = {.lex_state = 3},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 3},
  [419] = {.lex_state = 5},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 5},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 5},
  [424] = {.lex_state = 4},
  [425] = {.lex_state = 5},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 5},
  [429] = {.lex_state = 6},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 4},
  [432] = {.lex_state = 3},
  [433] = {.lex_state = 5},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 4},
  [438] = {.lex_state = 6},
  [439] = {.lex_state = 4},
  [440] = {.lex_state = 5},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 3},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 5},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 5},
  [454] = {.lex_state = 4},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 3},
  [458] = {.lex_state = 3},
  [459] = {.lex_state = 5},
  [460] = {.lex_state = 3},
  [461] = {.lex_state = 3},
  [462] = {.lex_state = 3},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 6},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 5},
  [467] = {.lex_state = 6},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 6},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 3},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 3},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 9},
  [480] = {.lex_state = 5},
  [481] = {.lex_state = 5},
  [482] = {.lex_state = 3},
  [483] = {.lex_state = 3},
  [484] = {.lex_state = 6},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 9},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 3},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 3},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 4},
  [497] = {.lex_state = 3},
  [498] = {.lex_state = 3},
  [499] = {.lex_state = 3},
  [500] = {.lex_state = 9},
  [501] = {.lex_state = 3},
  [502] = {.lex_state = 6},
  [503] = {.lex_state = 6},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 5},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 6},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 5},
  [510] = {.lex_state = 6},
  [511] = {.lex_state = 5},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 5},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 5},
  [516] = {.lex_state = 3},
  [517] = {.lex_state = 3},
  [518] = {.lex_state = 5},
  [519] = {.lex_state = 3},
  [520] = {.lex_state = 3},
  [521] = {.lex_state = 5},
  [522] = {.lex_state = 5},
  [523] = {.lex_state = 3},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 5},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 3},
  [528] = {.lex_state = 5},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 5},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 5},
  [539] = {.lex_state = 5},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 5},
  [543] = {.lex_state = 5},
  [544] = {.lex_state = 5},
  [545] = {.lex_state = 5},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 3},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 3},
  [550] = {.lex_state = 3},
  [551] = {.lex_state = 5},
  [552] = {.lex_state = 3},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 3},
  [556] = {.lex_state = 7},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 6},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 6},
  [561] = {.lex_state = 6},
  [562] = {.lex_state = 4},
  [563] = {.lex_state = 5},
  [564] = {.lex_state = 6},
  [565] = {.lex_state = 6},
  [566] = {.lex_state = 6},
  [567] = {.lex_state = 3},
  [568] = {.lex_state = 3},
  [569] = {.lex_state = 3},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 3},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 4},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 6},
  [582] = {.lex_state = 5},
  [583] = {.lex_state = 5},
  [584] = {.lex_state = 3},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 3},
  [587] = {.lex_state = 6},
  [588] = {.lex_state = 4},
  [589] = {.lex_state = 6},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 4},
  [592] = {.lex_state = 3},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 5},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 3},
  [603] = {.lex_state = 4},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 4},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 3},
  [610] = {.lex_state = 5},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 5},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 6},
  [617] = {.lex_state = 3},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 3},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 5},
  [622] = {.lex_state = 5},
  [623] = {.lex_state = 5},
  [624] = {.lex_state = 5},
  [625] = {.lex_state = 5},
  [626] = {.lex_state = 5},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 5},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 5},
  [631] = {.lex_state = 3},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 5},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 3},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 3},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 3},
  [643] = {.lex_state = 6},
  [644] = {.lex_state = 6},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 5},
  [647] = {.lex_state = 5},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 5},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 3},
  [652] = {.lex_state = 3},
  [653] = {.lex_state = 3},
  [654] = {.lex_state = 5},
  [655] = {.lex_state = 3},
  [656] = {.lex_state = 5},
  [657] = {.lex_state = 5},
  [658] = {.lex_state = 5},
  [659] = {.lex_state = 5},
  [660] = {.lex_state = 6},
  [661] = {.lex_state = 5},
  [662] = {.lex_state = 5},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 5},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 3},
  [667] = {.lex_state = 6},
  [668] = {.lex_state = 3},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 5},
  [676] = {.lex_state = 5},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 5},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 3},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 6},
  [690] = {.lex_state = 4},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 7},
  [693] = {.lex_state = 4},
  [694] = {.lex_state = 3},
  [695] = {.lex_state = 3},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 4},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 6},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 5},
  [709] = {.lex_state = 3},
  [710] = {.lex_state = 3},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 6},
  [713] = {.lex_state = 4},
  [714] = {.lex_state = 4},
  [715] = {.lex_state = 6},
  [716] = {.lex_state = 3},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 5},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 6},
  [725] = {.lex_state = 4},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 4},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 6},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 3},
  [736] = {.lex_state = 3},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 5},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 5},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 5},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 3},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 3},
  [757] = {.lex_state = 3},
  [758] = {.lex_state = 3},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 3},
  [761] = {.lex_state = 6},
  [762] = {.lex_state = 5},
  [763] = {.lex_state = 5},
  [764] = {.lex_state = 3},
  [765] = {.lex_state = 5},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 5},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 3},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 6},
  [783] = {.lex_state = 6},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 4},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 3},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 4},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 4},
  [793] = {.lex_state = 3},
  [794] = {.lex_state = 5},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 3},
  [797] = {.lex_state = 3},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 6},
  [800] = {.lex_state = 6},
  [801] = {.lex_state = 3},
  [802] = {.lex_state = 3},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 5},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 5},
  [807] = {.lex_state = 6},
  [808] = {.lex_state = 5},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 3},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 6},
  [813] = {.lex_state = 5},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 5},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 5},
  [821] = {.lex_state = 5},
  [822] = {.lex_state = 5},
  [823] = {.lex_state = 5},
  [824] = {.lex_state = 5},
  [825] = {.lex_state = 5},
  [826] = {.lex_state = 3},
  [827] = {.lex_state = 3},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 3},
  [830] = {.lex_state = 5},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 3},
  [833] = {.lex_state = 5},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 6},
  [840] = {.lex_state = 4},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 4},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 4},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 5},
  [848] = {.lex_state = 3},
  [849] = {.lex_state = 3},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 3},
  [852] = {.lex_state = 3},
  [853] = {.lex_state = 3},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 5},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 3},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 3},
  [877] = {.lex_state = 3},
  [878] = {.lex_state = 3},
  [879] = {.lex_state = 3},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 5},
  [883] = {.lex_state = 5},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 3},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 3},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 3},
  [895] = {.lex_state = 3},
  [896] = {.lex_state = 3},
  [897] = {.lex_state = 3},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 7},
  [900] = {.lex_state = 7},
  [901] = {.lex_state = 7},
  [902] = {.lex_state = 5},
  [903] = {.lex_state = 5},
  [904] = {.lex_state = 7},
  [905] = {.lex_state = 7},
  [906] = {.lex_state = 7},
  [907] = {.lex_state = 5},
  [908] = {.lex_state = 3},
  [909] = {.lex_state = 5},
  [910] = {.lex_state = 7},
  [911] = {.lex_state = 7},
  [912] = {.lex_state = 7},
  [913] = {.lex_state = 5},
  [914] = {.lex_state = 5},
  [915] = {.lex_state = 7},
  [916] = {.lex_state = 7},
  [917] = {.lex_state = 5},
  [918] = {.lex_state = 7},
  [919] = {.lex_state = 5},
  [920] = {.lex_state = 3},
  [921] = {.lex_state = 5},
  [922] = {.lex_state = 7},
  [923] = {.lex_state = 7},
  [924] = {.lex_state = 7},
  [925] = {.lex_state = 7},
  [926] = {.lex_state = 7},
  [927] = {.lex_state = 5},
  [928] = {.lex_state = 5},
  [929] = {.lex_state = 7},
  [930] = {.lex_state = 5},
  [931] = {.lex_state = 7},
  [932] = {.lex_state = 7},
  [933] = {.lex_state = 7},
  [934] = {.lex_state = 5},
  [935] = {.lex_state = 5},
  [936] = {.lex_state = 5},
  [937] = {.lex_state = 3},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 4},
  [940] = {.lex_state = 5},
  [941] = {.lex_state = 3},
  [942] = {.lex_state = 5},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 3},
  [945] = {.lex_state = 5},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 5},
  [949] = {.lex_state = 4},
  [950] = {.lex_state = 5},
  [951] = {.lex_state = 5},
  [952] = {.lex_state = 4},
  [953] = {.lex_state = 5},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 3},
  [956] = {.lex_state = 4},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 5},
  [961] = {.lex_state = 5},
  [962] = {.lex_state = 5},
  [963] = {.lex_state = 5},
  [964] = {.lex_state = 5},
  [965] = {.lex_state = 5},
  [966] = {.lex_state = 5},
  [967] = {.lex_state = 5},
  [968] = {.lex_state = 0},
};

static uint16_t ts_parse_table[STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [sym_string_literal] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
  },
  [1] = {
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_program] = STATE(46),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_assert_statement] = STATE(35),
    [sym__type] = STATE(37),
    [sym_labeled_statement] = STATE(35),
    [sym_class_literal] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_package_declaration] = STATE(35),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_block] = STATE(35),
    [sym_inferred_parameters] = STATE(42),
    [sym_module_declaration] = STATE(35),
    [sym__expression] = STATE(49),
    [sym_while_statement] = STATE(35),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_break_statement] = STATE(35),
    [sym_parenthesized_expression] = STATE(43),
    [sym_local_variable_declaration] = STATE(47),
    [sym_import_declaration] = STATE(35),
    [sym_update_expression] = STATE(49),
    [sym__unannotated_type] = STATE(40),
    [sym__primary] = STATE(41),
    [sym_try_with_resources_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_try_statement] = STATE(35),
    [sym_marker_annotation] = STATE(51),
    [sym_assignment_expression] = STATE(49),
    [sym_annotation] = STATE(51),
    [sym_scoped_identifier] = STATE(52),
    [sym_ternary_expression] = STATE(49),
    [sym_local_variable_declaration_statement] = STATE(35),
    [sym__declaration] = STATE(35),
    [sym__primary_no_new_array] = STATE(43),
    [sym_array_type] = STATE(40),
    [sym_modifiers] = STATE(48),
    [sym_interface_declaration] = STATE(35),
    [sym_method_reference] = STATE(43),
    [sym_continue_statement] = STATE(35),
    [aux_sym_program_repeat1] = STATE(35),
    [sym_enum_declaration] = STATE(35),
    [sym_field_access] = STATE(39),
    [sym_binary_expression] = STATE(49),
    [sym_lambda_expression] = STATE(49),
    [sym_do_statement] = STATE(35),
    [sym_cast_expression] = STATE(49),
    [sym__annotation] = STATE(51),
    [sym_synchronized_statement] = STATE(35),
    [sym_expression_statement] = STATE(35),
    [sym_annotated_type] = STATE(37),
    [sym_array_access] = STATE(39),
    [sym_integral_type] = STATE(30),
    [sym_throw_statement] = STATE(35),
    [sym_array_creation_expression] = STATE(41),
    [sym_class_declaration] = STATE(35),
    [sym_floating_point_type] = STATE(30),
    [sym_generic_type] = STATE(53),
    [sym_enhanced_for_statement] = STATE(35),
    [sym_unary_expression] = STATE(49),
    [sym_if_statement] = STATE(35),
    [sym_formal_parameters] = STATE(42),
    [sym_normal_interface_declaration] = STATE(45),
    [sym__literal] = STATE(43),
    [sym_instanceof_expression] = STATE(49),
    [sym_return_statement] = STATE(35),
    [sym_object_creation_expression] = STATE(43),
    [sym_switch_statement] = STATE(35),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_transient] = ACTIONS(7),
    [sym_super] = ACTIONS(9),
    [sym_true] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(11),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_long] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_static] = ACTIONS(7),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(33),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_double] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_assert] = ACTIONS(53),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_char] = ACTIONS(33),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_false] = ACTIONS(5),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_native] = ACTIONS(7),
    [ts_builtin_sym_end] = ACTIONS(69),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_open] = ACTIONS(77),
    [sym_boolean_type] = ACTIONS(79),
  },
  [2] = {
    [anon_sym_SEMI] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_type_arguments] = STATE(64),
    [sym_argument_list] = STATE(65),
    [aux_sym_class_literal_repeat1] = STATE(66),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_SEMI] = ACTIONS(87),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_module] = ACTIONS(89),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(91),
    [anon_sym_DASH_EQ] = ACTIONS(93),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_AMP_EQ] = ACTIONS(93),
    [anon_sym_CARET_EQ] = ACTIONS(93),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_EQ] = ACTIONS(98),
    [anon_sym_EQ_EQ] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP_AMP] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(100),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [anon_sym_QMARK] = ACTIONS(87),
    [anon_sym_STAR_EQ] = ACTIONS(93),
    [anon_sym_DASH_GT] = ACTIONS(103),
    [anon_sym_PIPE] = ACTIONS(85),
    [anon_sym_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_GT_GT_GT] = ACTIONS(85),
    [anon_sym_open] = ACTIONS(89),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_instanceof] = ACTIONS(85),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_AMP] = ACTIONS(85),
    [anon_sym_PLUS_EQ] = ACTIONS(93),
    [anon_sym_SLASH_EQ] = ACTIONS(93),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_LT_LT_EQ] = ACTIONS(93),
    [anon_sym_PERCENT_EQ] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(107),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_DOT] = ACTIONS(110),
    [anon_sym_PIPE_EQ] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_BANG_EQ] = ACTIONS(87),
  },
  [4] = {
    [sym_scoped_identifier] = STATE(68),
    [anon_sym_open] = ACTIONS(114),
    [sym_identifier] = ACTIONS(116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(114),
  },
  [5] = {
    [sym_floating_point_type] = STATE(30),
    [sym_array_type] = STATE(73),
    [sym_method_invocation] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_update_expression] = STATE(72),
    [sym_array_creation_expression] = STATE(41),
    [sym_instanceof_expression] = STATE(72),
    [sym_marker_annotation] = STATE(74),
    [sym_generic_type] = STATE(53),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym__primary] = STATE(41),
    [sym_array_access] = STATE(39),
    [sym_object_creation_expression] = STATE(43),
    [sym_method_reference] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_parenthesized_expression] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym__literal] = STATE(43),
    [sym_binary_expression] = STATE(72),
    [sym_class_literal] = STATE(43),
    [sym__annotation] = STATE(74),
    [sym_field_access] = STATE(39),
    [sym_cast_expression] = STATE(72),
    [sym_unary_expression] = STATE(72),
    [sym__expression] = STATE(72),
    [sym_lambda_expression] = STATE(72),
    [sym_ternary_expression] = STATE(72),
    [sym_integral_type] = STATE(30),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_scoped_identifier] = STATE(52),
    [sym__type] = STATE(37),
    [sym_assignment_expression] = STATE(72),
    [sym__primary_no_new_array] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(118),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_char] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_open] = ACTIONS(120),
    [sym_true] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
    [sym_void_type] = ACTIONS(55),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [sym_comment] = ACTIONS(3),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_int] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(122),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_short] = ACTIONS(33),
    [sym_false] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(49),
  },
  [6] = {
    [sym_cast_expression] = STATE(75),
    [sym_integral_type] = STATE(30),
    [sym_field_access] = STATE(39),
    [sym_update_expression] = STATE(75),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_object_creation_expression] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym__primary_no_new_array] = STATE(43),
    [sym_unary_expression] = STATE(75),
    [sym__literal] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_method_invocation] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_method_reference] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym__annotation] = STATE(74),
    [sym__type] = STATE(37),
    [sym_annotation] = STATE(74),
    [sym__primary] = STATE(41),
    [sym_ternary_expression] = STATE(75),
    [sym_formal_parameters] = STATE(42),
    [sym_assignment_expression] = STATE(75),
    [sym_scoped_identifier] = STATE(52),
    [sym_generic_type] = STATE(53),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_binary_expression] = STATE(75),
    [sym_lambda_expression] = STATE(75),
    [sym_class_literal] = STATE(43),
    [sym__expression] = STATE(75),
    [sym_array_access] = STATE(39),
    [sym__unannotated_type] = STATE(73),
    [sym_annotated_type] = STATE(37),
    [sym_instanceof_expression] = STATE(75),
    [sym_parenthesized_expression] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
    [sym_comment] = ACTIONS(3),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_identifier] = ACTIONS(124),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_short] = ACTIONS(33),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_false] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_boolean_type] = ACTIONS(79),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [anon_sym_float] = ACTIONS(41),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
  },
  [7] = {
    [sym_formal_parameters] = STATE(42),
    [sym_ternary_expression] = STATE(82),
    [sym_array_creation_expression] = STATE(41),
    [sym__expression] = STATE(82),
    [sym_method_invocation] = STATE(43),
    [sym__literal] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_object_creation_expression] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_lambda_expression] = STATE(82),
    [sym_class_literal] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_assignment_expression] = STATE(82),
    [sym_scoped_identifier] = STATE(52),
    [sym_spread_parameter] = STATE(86),
    [sym_update_expression] = STATE(82),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_marker_annotation] = STATE(903),
    [sym_parenthesized_expression] = STATE(43),
    [sym_array_type] = STATE(80),
    [sym__annotation] = STATE(903),
    [sym_integral_type] = STATE(30),
    [sym_array_access] = STATE(39),
    [sym_cast_expression] = STATE(82),
    [sym__primary_no_new_array] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__type] = STATE(81),
    [sym_receiver_parameter] = STATE(83),
    [sym_instanceof_expression] = STATE(82),
    [sym_floating_point_type] = STATE(30),
    [sym_modifiers] = STATE(84),
    [sym_inferred_parameters] = STATE(42),
    [sym_annotated_type] = STATE(81),
    [sym_method_reference] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(79),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_binary_expression] = STATE(82),
    [sym__unannotated_type] = STATE(80),
    [sym_annotation] = STATE(903),
    [sym_formal_parameter] = STATE(85),
    [sym_unary_expression] = STATE(82),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
    [sym_boolean_type] = ACTIONS(79),
    [sym_string_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [sym_identifier] = ACTIONS(128),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(130),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_final] = ACTIONS(126),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_private] = ACTIONS(126),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_native] = ACTIONS(126),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_this] = ACTIONS(5),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(132),
    [anon_sym_open] = ACTIONS(120),
    [sym_false] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
  },
  [8] = {
    [sym_parenthesized_expression] = STATE(88),
    [anon_sym_LPAREN] = ACTIONS(134),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [anon_sym_DOT] = ACTIONS(136),
    [anon_sym_COLON_COLON] = ACTIONS(138),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_parenthesized_expression] = STATE(90),
    [anon_sym_LPAREN] = ACTIONS(134),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_binary_expression] = STATE(91),
    [sym__primary_no_new_array] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_assignment_expression] = STATE(91),
    [sym_formal_parameters] = STATE(42),
    [sym_array_creation_expression] = STATE(41),
    [sym__primary] = STATE(41),
    [sym_cast_expression] = STATE(91),
    [sym__type] = STATE(37),
    [sym_ternary_expression] = STATE(91),
    [sym__unannotated_type] = STATE(73),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_method_reference] = STATE(43),
    [sym_annotation] = STATE(74),
    [sym_parenthesized_expression] = STATE(43),
    [sym__annotation] = STATE(74),
    [sym_integral_type] = STATE(30),
    [sym__expression] = STATE(91),
    [sym_object_creation_expression] = STATE(43),
    [sym_update_expression] = STATE(91),
    [sym_array_access] = STATE(39),
    [sym_marker_annotation] = STATE(74),
    [sym_lambda_expression] = STATE(91),
    [sym_field_access] = STATE(39),
    [sym_instanceof_expression] = STATE(91),
    [sym_scoped_identifier] = STATE(52),
    [sym__literal] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_array_type] = STATE(73),
    [sym_annotated_type] = STATE(37),
    [sym_scoped_type_identifier] = STATE(36),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_class_literal] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym_unary_expression] = STATE(91),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_double] = ACTIONS(41),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_new] = ACTIONS(19),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_this] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [sym_identifier] = ACTIONS(124),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_float] = ACTIONS(41),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
    [sym_string_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
  },
  [12] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(140),
  },
  [13] = {
    [sym_identifier] = ACTIONS(142),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_type_arguments] = STATE(98),
    [sym_generic_type] = STATE(96),
    [sym_floating_point_type] = STATE(95),
    [sym_integral_type] = STATE(95),
    [sym_scoped_type_identifier] = STATE(97),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(144),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(146),
    [sym_identifier] = ACTIONS(148),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_void_type] = ACTIONS(144),
  },
  [15] = {
    [sym_parenthesized_expression] = STATE(99),
    [anon_sym_LPAREN] = ACTIONS(134),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_instanceof_expression] = STATE(100),
    [sym__primary] = STATE(41),
    [sym__type] = STATE(37),
    [sym__annotation] = STATE(74),
    [sym_update_expression] = STATE(100),
    [sym_array_access] = STATE(39),
    [sym_lambda_expression] = STATE(100),
    [sym_class_literal] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_field_access] = STATE(39),
    [sym_integral_type] = STATE(30),
    [sym_marker_annotation] = STATE(74),
    [sym_binary_expression] = STATE(100),
    [sym_cast_expression] = STATE(100),
    [sym_method_reference] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym__literal] = STATE(43),
    [sym__expression] = STATE(100),
    [sym_annotated_type] = STATE(37),
    [sym_unary_expression] = STATE(100),
    [sym_assignment_expression] = STATE(100),
    [sym_ternary_expression] = STATE(100),
    [sym_annotation] = STATE(74),
    [sym__unannotated_type] = STATE(73),
    [sym_array_creation_expression] = STATE(41),
    [sym_array_type] = STATE(73),
    [sym_object_creation_expression] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__primary_no_new_array] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym_parenthesized_expression] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(30),
    [sym_scoped_identifier] = STATE(52),
    [sym_true] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [sym_false] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_boolean_type] = ACTIONS(79),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_new] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_long] = ACTIONS(33),
    [sym_decimal_integer_literal] = ACTIONS(5),
  },
  [17] = {
    [sym_annotation] = STATE(51),
    [sym_object_creation_expression] = STATE(43),
    [sym__type] = STATE(37),
    [sym__expression] = STATE(49),
    [sym_package_declaration] = STATE(102),
    [sym_while_statement] = STATE(102),
    [sym_return_statement] = STATE(102),
    [sym_module_declaration] = STATE(102),
    [sym_block] = STATE(102),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_formal_parameters] = STATE(42),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_unary_expression] = STATE(49),
    [sym_throw_statement] = STATE(102),
    [sym_inferred_parameters] = STATE(42),
    [sym_try_with_resources_statement] = STATE(102),
    [sym_switch_statement] = STATE(102),
    [sym_array_type] = STATE(40),
    [sym_cast_expression] = STATE(49),
    [sym_continue_statement] = STATE(102),
    [sym_local_variable_declaration] = STATE(47),
    [sym_scoped_identifier] = STATE(52),
    [sym_field_access] = STATE(39),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__declaration] = STATE(102),
    [sym_generic_type] = STATE(53),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_do_statement] = STATE(102),
    [sym__literal] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_if_statement] = STATE(102),
    [sym_assignment_expression] = STATE(49),
    [sym_array_creation_expression] = STATE(41),
    [sym_array_access] = STATE(39),
    [sym_expression_statement] = STATE(102),
    [sym_labeled_statement] = STATE(102),
    [sym_update_expression] = STATE(49),
    [sym_floating_point_type] = STATE(30),
    [sym_enhanced_for_statement] = STATE(102),
    [sym__unannotated_type] = STATE(40),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_synchronized_statement] = STATE(102),
    [sym_marker_annotation] = STATE(51),
    [sym_class_declaration] = STATE(102),
    [sym_modifiers] = STATE(48),
    [sym_assert_statement] = STATE(102),
    [sym_annotated_type] = STATE(37),
    [sym_lambda_expression] = STATE(49),
    [sym_interface_declaration] = STATE(102),
    [sym_method_reference] = STATE(43),
    [aux_sym_program_repeat1] = STATE(102),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_enum_declaration] = STATE(102),
    [sym_for_statement] = STATE(102),
    [sym_method_invocation] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym__annotation] = STATE(51),
    [sym_integral_type] = STATE(30),
    [sym_try_statement] = STATE(102),
    [sym_import_declaration] = STATE(102),
    [sym_break_statement] = STATE(102),
    [sym__primary] = STATE(41),
    [sym_binary_expression] = STATE(49),
    [sym_class_literal] = STATE(43),
    [sym_instanceof_expression] = STATE(49),
    [sym_local_variable_declaration_statement] = STATE(102),
    [sym_ternary_expression] = STATE(49),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(23),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_float] = ACTIONS(41),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [sym_string_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_public] = ACTIONS(7),
    [sym_false] = ACTIONS(5),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(63),
    [sym_true] = ACTIONS(5),
    [anon_sym_return] = ACTIONS(57),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [sym_this] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(150),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_RBRACE] = ACTIONS(152),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_super] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_identifier] = ACTIONS(13),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(65),
  },
  [18] = {
    [anon_sym_AT] = ACTIONS(154),
    [anon_sym_open] = ACTIONS(156),
    [sym_this] = ACTIONS(156),
    [anon_sym_DOT] = ACTIONS(158),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(154),
    [anon_sym_AMP] = ACTIONS(154),
    [sym_identifier] = ACTIONS(156),
    [anon_sym_LBRACK] = ACTIONS(154),
    [anon_sym_COLON_COLON] = ACTIONS(154),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(156),
  },
  [19] = {
    [sym_identifier] = ACTIONS(160),
    [anon_sym_static] = ACTIONS(162),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_scoped_identifier] = STATE(106),
    [anon_sym_open] = ACTIONS(164),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(166),
    [anon_sym_module] = ACTIONS(164),
  },
  [21] = {
    [anon_sym_SEMI] = ACTIONS(168),
    [sym_identifier] = ACTIONS(170),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_lambda_expression] = STATE(110),
    [sym_object_creation_expression] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym_array_type] = STATE(73),
    [sym_binary_expression] = STATE(110),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_annotated_type] = STATE(37),
    [sym_assignment_expression] = STATE(110),
    [sym__type] = STATE(37),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(30),
    [sym_array_access] = STATE(39),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__primary_no_new_array] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_unary_expression] = STATE(110),
    [sym_method_reference] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym__literal] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym_instanceof_expression] = STATE(110),
    [sym_annotation] = STATE(74),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_update_expression] = STATE(110),
    [sym_parenthesized_expression] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym__primary] = STATE(41),
    [sym__annotation] = STATE(74),
    [sym_ternary_expression] = STATE(110),
    [sym_field_access] = STATE(39),
    [sym_array_creation_expression] = STATE(41),
    [sym_cast_expression] = STATE(110),
    [sym__expression] = STATE(110),
    [sym_formal_parameters] = STATE(42),
    [sym_class_literal] = STATE(43),
    [anon_sym_AT] = ACTIONS(118),
    [sym_false] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_string_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_int] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(41),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_identifier] = ACTIONS(124),
    [sym_super] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
  },
  [23] = {
    [anon_sym_DOT_DOT_DOT] = ACTIONS(172),
    [anon_sym_SEMI] = ACTIONS(172),
    [sym_comment] = ACTIONS(3),
    [anon_sym_implements] = ACTIONS(174),
    [anon_sym_LBRACE] = ACTIONS(172),
    [anon_sym_COMMA] = ACTIONS(172),
    [anon_sym_LPAREN] = ACTIONS(172),
    [sym_identifier] = ACTIONS(174),
    [anon_sym_GT] = ACTIONS(172),
    [anon_sym_LBRACK] = ACTIONS(172),
    [anon_sym_COLON_COLON] = ACTIONS(172),
    [sym_this] = ACTIONS(174),
    [anon_sym_PIPE] = ACTIONS(172),
    [anon_sym_open] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(174),
    [anon_sym_AT] = ACTIONS(172),
    [anon_sym_RPAREN] = ACTIONS(172),
    [anon_sym_module] = ACTIONS(174),
    [anon_sym_AMP] = ACTIONS(172),
  },
  [24] = {
    [sym_cast_expression] = STATE(49),
    [sym_field_access] = STATE(39),
    [sym_annotated_type] = STATE(37),
    [sym_while_statement] = STATE(111),
    [sym_class_declaration] = STATE(111),
    [sym_import_declaration] = STATE(111),
    [sym_instanceof_expression] = STATE(49),
    [sym_labeled_statement] = STATE(111),
    [sym_expression_statement] = STATE(111),
    [sym_try_with_resources_statement] = STATE(111),
    [sym__annotation] = STATE(51),
    [sym_do_statement] = STATE(111),
    [sym__declaration] = STATE(111),
    [sym__primary_no_new_array] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym_unary_expression] = STATE(49),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_if_statement] = STATE(111),
    [sym_array_creation_expression] = STATE(41),
    [sym_method_reference] = STATE(43),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_continue_statement] = STATE(111),
    [sym_interface_declaration] = STATE(111),
    [sym_update_expression] = STATE(49),
    [sym_for_statement] = STATE(111),
    [sym_lambda_expression] = STATE(49),
    [sym_marker_annotation] = STATE(51),
    [sym_try_statement] = STATE(111),
    [sym_inferred_parameters] = STATE(42),
    [sym_parenthesized_expression] = STATE(43),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_assignment_expression] = STATE(49),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_scoped_identifier] = STATE(52),
    [sym_annotation] = STATE(51),
    [sym_binary_expression] = STATE(49),
    [sym_switch_statement] = STATE(111),
    [sym_enum_declaration] = STATE(111),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_block] = STATE(111),
    [sym_synchronized_statement] = STATE(111),
    [sym_method_invocation] = STATE(43),
    [sym_assert_statement] = STATE(111),
    [sym_enhanced_for_statement] = STATE(111),
    [sym_module_declaration] = STATE(111),
    [sym_local_variable_declaration] = STATE(47),
    [sym_array_type] = STATE(40),
    [sym__type] = STATE(37),
    [sym_local_variable_declaration_statement] = STATE(111),
    [sym_package_declaration] = STATE(111),
    [sym_class_literal] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__expression] = STATE(49),
    [sym_break_statement] = STATE(111),
    [sym_throw_statement] = STATE(111),
    [sym_integral_type] = STATE(30),
    [sym_ternary_expression] = STATE(49),
    [sym_floating_point_type] = STATE(30),
    [sym_return_statement] = STATE(111),
    [sym__unannotated_type] = STATE(40),
    [sym__primary] = STATE(41),
    [sym_modifiers] = STATE(48),
    [sym_formal_parameters] = STATE(42),
    [sym_generic_type] = STATE(53),
    [sym_array_access] = STATE(39),
    [sym__literal] = STATE(43),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_switch] = ACTIONS(65),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_private] = ACTIONS(7),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_SEMI] = ACTIONS(176),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(17),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(31),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_false] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_native] = ACTIONS(7),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_module] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_final] = ACTIONS(7),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_continue] = ACTIONS(73),
    [sym_this] = ACTIONS(5),
    [anon_sym_static] = ACTIONS(7),
    [sym_true] = ACTIONS(5),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_do] = ACTIONS(45),
    [sym_super] = ACTIONS(9),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_enum] = ACTIONS(67),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_package] = ACTIONS(61),
  },
  [25] = {
    [sym_identifier] = ACTIONS(178),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_parenthesized_expression] = STATE(43),
    [sym__type] = STATE(37),
    [sym_array_access] = STATE(39),
    [sym_marker_annotation] = STATE(74),
    [sym__expression] = STATE(113),
    [sym_array_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym_update_expression] = STATE(113),
    [sym__primary] = STATE(41),
    [sym_instanceof_expression] = STATE(113),
    [sym_class_literal] = STATE(43),
    [sym_assignment_expression] = STATE(113),
    [sym_floating_point_type] = STATE(30),
    [sym_ternary_expression] = STATE(113),
    [sym_method_reference] = STATE(43),
    [sym__literal] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_integral_type] = STATE(30),
    [sym_scoped_identifier] = STATE(52),
    [sym_array_creation_expression] = STATE(41),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_method_invocation] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym__primary_no_new_array] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_binary_expression] = STATE(113),
    [sym_inferred_parameters] = STATE(42),
    [sym_unary_expression] = STATE(113),
    [sym_annotated_type] = STATE(37),
    [sym_generic_type] = STATE(53),
    [sym_formal_parameters] = STATE(42),
    [sym_annotation] = STATE(74),
    [sym_lambda_expression] = STATE(113),
    [sym_object_creation_expression] = STATE(43),
    [sym_cast_expression] = STATE(113),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
    [anon_sym_open] = ACTIONS(120),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(41),
    [sym_false] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_module] = ACTIONS(120),
    [sym_this] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_char] = ACTIONS(33),
    [sym_identifier] = ACTIONS(124),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_null_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_character_literal] = ACTIONS(35),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(47),
  },
  [27] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(180),
  },
  [28] = {
    [sym_identifier] = ACTIONS(182),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [anon_sym_final] = ACTIONS(184),
    [anon_sym_abstract] = ACTIONS(184),
    [anon_sym_long] = ACTIONS(184),
    [anon_sym_ATinterface] = ACTIONS(186),
    [anon_sym_static] = ACTIONS(184),
    [anon_sym_public] = ACTIONS(184),
    [anon_sym_native] = ACTIONS(184),
    [anon_sym_char] = ACTIONS(184),
    [anon_sym_default] = ACTIONS(184),
    [anon_sym_byte] = ACTIONS(184),
    [anon_sym_AT] = ACTIONS(184),
    [sym_boolean_type] = ACTIONS(184),
    [anon_sym_LPAREN] = ACTIONS(188),
    [anon_sym_synchronized] = ACTIONS(184),
    [sym_comment] = ACTIONS(3),
    [anon_sym_strictfp] = ACTIONS(184),
    [anon_sym_interface] = ACTIONS(184),
    [anon_sym_volatile] = ACTIONS(184),
    [anon_sym_enum] = ACTIONS(184),
    [anon_sym_int] = ACTIONS(184),
    [anon_sym_double] = ACTIONS(184),
    [anon_sym_class] = ACTIONS(184),
    [anon_sym_private] = ACTIONS(184),
    [anon_sym_short] = ACTIONS(184),
    [anon_sym_transient] = ACTIONS(184),
    [anon_sym_float] = ACTIONS(184),
    [anon_sym_protected] = ACTIONS(184),
    [sym_void_type] = ACTIONS(184),
    [sym_identifier] = ACTIONS(184),
  },
  [30] = {
    [aux_sym_class_literal_repeat1] = STATE(66),
    [anon_sym_LBRACK] = ACTIONS(190),
    [anon_sym_DOT] = ACTIONS(158),
    [sym_this] = ACTIONS(156),
    [anon_sym_open] = ACTIONS(156),
    [anon_sym_AT] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(154),
    [anon_sym_module] = ACTIONS(156),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(154),
    [anon_sym_AMP] = ACTIONS(154),
    [sym_identifier] = ACTIONS(156),
    [anon_sym_COLON_COLON] = ACTIONS(154),
  },
  [31] = {
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(193),
    [anon_sym_module] = ACTIONS(195),
    [sym_this] = ACTIONS(195),
    [anon_sym_AMP] = ACTIONS(193),
    [anon_sym_open] = ACTIONS(195),
    [sym_identifier] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(193),
    [anon_sym_implements] = ACTIONS(195),
    [anon_sym_LBRACE] = ACTIONS(193),
    [anon_sym_RPAREN] = ACTIONS(193),
    [anon_sym_PIPE] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_DOT] = ACTIONS(195),
    [anon_sym_COMMA] = ACTIONS(193),
    [anon_sym_SEMI] = ACTIONS(193),
  },
  [32] = {
    [sym_resource_specification] = STATE(119),
    [sym_block] = STATE(120),
    [anon_sym_LBRACE] = ACTIONS(197),
    [anon_sym_LPAREN] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [aux_sym_class_literal_repeat1] = STATE(126),
    [sym_argument_list] = STATE(127),
    [anon_sym_LT] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_DASH_EQ] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(205),
    [anon_sym_PIPE_EQ] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(207),
    [anon_sym_PIPE_PIPE] = ACTIONS(209),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_GT_GT_GT] = ACTIONS(201),
    [anon_sym_module] = ACTIONS(211),
    [anon_sym_AMP_EQ] = ACTIONS(203),
    [anon_sym_LT_LT] = ACTIONS(201),
    [anon_sym_QMARK] = ACTIONS(209),
    [anon_sym_DASH_DASH] = ACTIONS(209),
    [anon_sym_GT_GT] = ACTIONS(201),
    [anon_sym_STAR_EQ] = ACTIONS(203),
    [anon_sym_GT_GT_EQ] = ACTIONS(203),
    [anon_sym_PLUS_EQ] = ACTIONS(203),
    [anon_sym_LT_EQ] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_CARET] = ACTIONS(201),
    [anon_sym_STAR] = ACTIONS(201),
    [anon_sym_SLASH] = ACTIONS(201),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_DOT] = ACTIONS(215),
    [anon_sym_CARET_EQ] = ACTIONS(203),
    [anon_sym_PERCENT_EQ] = ACTIONS(203),
    [anon_sym_GT] = ACTIONS(201),
    [anon_sym_BANG_EQ] = ACTIONS(209),
    [anon_sym_PERCENT] = ACTIONS(201),
    [anon_sym_DASH] = ACTIONS(201),
    [anon_sym_EQ_EQ] = ACTIONS(209),
    [anon_sym_PLUS_PLUS] = ACTIONS(209),
    [anon_sym_SLASH_EQ] = ACTIONS(203),
    [anon_sym_GT_EQ] = ACTIONS(209),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_LT_LT_EQ] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(209),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(203),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(201),
    [anon_sym_instanceof] = ACTIONS(209),
  },
  [34] = {
    [sym_scoped_identifier] = STATE(129),
    [sym_argument_list] = STATE(127),
    [aux_sym_class_literal_repeat1] = STATE(126),
    [anon_sym_DASH_DASH] = ACTIONS(209),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_PERCENT] = ACTIONS(201),
    [anon_sym_AMP_AMP] = ACTIONS(209),
    [anon_sym_GT_GT_EQ] = ACTIONS(203),
    [anon_sym_EQ_EQ] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_CARET] = ACTIONS(201),
    [anon_sym_EQ] = ACTIONS(207),
    [anon_sym_DASH_EQ] = ACTIONS(203),
    [anon_sym_STAR] = ACTIONS(201),
    [anon_sym_DOT] = ACTIONS(215),
    [anon_sym_LT_EQ] = ACTIONS(209),
    [anon_sym_DASH] = ACTIONS(201),
    [sym_identifier] = ACTIONS(217),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PERCENT_EQ] = ACTIONS(203),
    [anon_sym_AMP] = ACTIONS(201),
    [anon_sym_GT] = ACTIONS(201),
    [anon_sym_open] = ACTIONS(219),
    [anon_sym_GT_GT_GT] = ACTIONS(201),
    [anon_sym_instanceof] = ACTIONS(201),
    [anon_sym_SLASH_EQ] = ACTIONS(203),
    [anon_sym_GT_GT] = ACTIONS(201),
    [anon_sym_LT_LT_EQ] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(209),
    [anon_sym_PLUS_EQ] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(201),
    [anon_sym_module] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_BANG_EQ] = ACTIONS(209),
    [anon_sym_COLON_COLON] = ACTIONS(205),
    [anon_sym_LT_LT] = ACTIONS(201),
    [anon_sym_PIPE_EQ] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(209),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_AMP_EQ] = ACTIONS(203),
    [anon_sym_GT_EQ] = ACTIONS(209),
    [anon_sym_PLUS_PLUS] = ACTIONS(209),
    [anon_sym_STAR_EQ] = ACTIONS(203),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(203),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_SLASH] = ACTIONS(201),
    [anon_sym_CARET_EQ] = ACTIONS(203),
  },
  [35] = {
    [sym_enum_declaration] = STATE(130),
    [sym_formal_parameters] = STATE(42),
    [sym_local_variable_declaration_statement] = STATE(130),
    [sym_array_type] = STATE(40),
    [sym_while_statement] = STATE(130),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_continue_statement] = STATE(130),
    [sym_ternary_expression] = STATE(49),
    [sym_update_expression] = STATE(49),
    [sym_integral_type] = STATE(30),
    [sym_class_declaration] = STATE(130),
    [sym_method_invocation] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym__type] = STATE(37),
    [sym__primary_no_new_array] = STATE(43),
    [sym_try_with_resources_statement] = STATE(130),
    [sym__literal] = STATE(43),
    [sym_synchronized_statement] = STATE(130),
    [sym_if_statement] = STATE(130),
    [sym_for_statement] = STATE(130),
    [sym_instanceof_expression] = STATE(49),
    [sym_inferred_parameters] = STATE(42),
    [sym_do_statement] = STATE(130),
    [sym_modifiers] = STATE(48),
    [sym_switch_statement] = STATE(130),
    [sym__primary] = STATE(41),
    [sym_parenthesized_expression] = STATE(43),
    [sym_local_variable_declaration] = STATE(47),
    [sym_scoped_identifier] = STATE(52),
    [sym__unannotated_type] = STATE(40),
    [sym_return_statement] = STATE(130),
    [sym_assignment_expression] = STATE(49),
    [sym_array_access] = STATE(39),
    [sym_generic_type] = STATE(53),
    [sym_throw_statement] = STATE(130),
    [aux_sym_program_repeat1] = STATE(130),
    [sym_binary_expression] = STATE(49),
    [sym_expression_statement] = STATE(130),
    [sym_normal_interface_declaration] = STATE(45),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_try_statement] = STATE(130),
    [sym_import_declaration] = STATE(130),
    [sym_lambda_expression] = STATE(49),
    [sym_module_declaration] = STATE(130),
    [sym_field_access] = STATE(39),
    [sym_assert_statement] = STATE(130),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_array_creation_expression] = STATE(41),
    [sym_annotation] = STATE(51),
    [sym_floating_point_type] = STATE(30),
    [sym_package_declaration] = STATE(130),
    [sym__annotation] = STATE(51),
    [sym_interface_declaration] = STATE(130),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_block] = STATE(130),
    [sym__expression] = STATE(49),
    [sym_class_literal] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_labeled_statement] = STATE(130),
    [sym_unary_expression] = STATE(49),
    [sym__declaration] = STATE(130),
    [sym_enhanced_for_statement] = STATE(130),
    [sym_cast_expression] = STATE(49),
    [sym_marker_annotation] = STATE(51),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_break_statement] = STATE(130),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(77),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(7),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_char] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_class] = ACTIONS(29),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_this] = ACTIONS(5),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(51),
    [sym_false] = ACTIONS(5),
    [anon_sym_enum] = ACTIONS(67),
    [sym_true] = ACTIONS(5),
    [anon_sym_assert] = ACTIONS(53),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(45),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_public] = ACTIONS(7),
    [ts_builtin_sym_end] = ACTIONS(221),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_static] = ACTIONS(7),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_try] = ACTIONS(31),
    [sym_identifier] = ACTIONS(13),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(223),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_break] = ACTIONS(25),
  },
  [36] = {
    [sym_type_arguments] = STATE(132),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(154),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_COMMA] = ACTIONS(154),
    [anon_sym_module] = ACTIONS(156),
    [anon_sym_AT] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(154),
    [sym_identifier] = ACTIONS(156),
    [anon_sym_PIPE] = ACTIONS(154),
    [anon_sym_DOT] = ACTIONS(225),
    [sym_this] = ACTIONS(156),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(154),
    [anon_sym_AMP] = ACTIONS(154),
    [anon_sym_SEMI] = ACTIONS(154),
    [anon_sym_LBRACK] = ACTIONS(154),
    [anon_sym_COLON_COLON] = ACTIONS(154),
    [anon_sym_open] = ACTIONS(156),
    [anon_sym_implements] = ACTIONS(156),
  },
  [37] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON_COLON] = ACTIONS(138),
  },
  [38] = {
    [sym_marker_annotation] = STATE(137),
    [sym_generic_type] = STATE(53),
    [sym__annotation] = STATE(137),
    [sym_annotation] = STATE(137),
    [sym_integral_type] = STATE(136),
    [sym__unannotated_type] = STATE(136),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym_array_type] = STATE(136),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_floating_point_type] = STATE(136),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(227),
    [sym_void_type] = ACTIONS(229),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(231),
    [sym_identifier] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_short] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(229),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_module] = ACTIONS(235),
  },
  [39] = {
    [anon_sym_DASH] = ACTIONS(237),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_QMARK] = ACTIONS(239),
    [anon_sym_PERCENT_EQ] = ACTIONS(93),
    [anon_sym_PLUS_EQ] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(239),
    [anon_sym_PIPE] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_COLON] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(239),
    [anon_sym_DASH_DASH] = ACTIONS(239),
    [anon_sym_RBRACK] = ACTIONS(239),
    [anon_sym_instanceof] = ACTIONS(239),
    [anon_sym_STAR_EQ] = ACTIONS(93),
    [anon_sym_COLON_COLON] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(237),
    [anon_sym_PIPE_EQ] = ACTIONS(93),
    [anon_sym_GT_EQ] = ACTIONS(239),
    [anon_sym_GT_GT] = ACTIONS(237),
    [anon_sym_LT_LT] = ACTIONS(237),
    [anon_sym_DOT] = ACTIONS(239),
    [anon_sym_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_GT] = ACTIONS(237),
    [anon_sym_GT_GT_GT] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_BANG_EQ] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(237),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_DASH_EQ] = ACTIONS(93),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_PIPE_PIPE] = ACTIONS(239),
    [anon_sym_SLASH_EQ] = ACTIONS(93),
    [anon_sym_LT_LT_EQ] = ACTIONS(93),
    [anon_sym_CARET_EQ] = ACTIONS(93),
    [anon_sym_LT_EQ] = ACTIONS(239),
    [anon_sym_AMP_EQ] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(237),
    [anon_sym_EQ] = ACTIONS(98),
    [anon_sym_EQ_EQ] = ACTIONS(239),
    [anon_sym_CARET] = ACTIONS(237),
    [anon_sym_PERCENT] = ACTIONS(237),
    [anon_sym_PLUS_PLUS] = ACTIONS(239),
  },
  [40] = {
    [sym__variable_declarator_list] = STATE(146),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_annotation] = STATE(145),
    [sym_dimensions] = STATE(144),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_variable_declarator] = STATE(143),
    [sym_marker_annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(142),
    [sym__annotation] = STATE(145),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(243),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_COLON_COLON] = ACTIONS(245),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(247),
  },
  [41] = {
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_PERCENT] = ACTIONS(251),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_CARET] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(249),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG_EQ] = ACTIONS(251),
    [anon_sym_RPAREN] = ACTIONS(251),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_EQ] = ACTIONS(251),
    [anon_sym_AMP_AMP] = ACTIONS(251),
    [anon_sym_COLON_COLON] = ACTIONS(138),
    [anon_sym_LT_EQ] = ACTIONS(251),
    [anon_sym_PLUS_PLUS] = ACTIONS(251),
    [anon_sym_QMARK] = ACTIONS(251),
    [anon_sym_RBRACK] = ACTIONS(251),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_instanceof] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(249),
    [anon_sym_SLASH] = ACTIONS(249),
    [anon_sym_COLON] = ACTIONS(249),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_GT_GT_GT] = ACTIONS(251),
    [anon_sym_COMMA] = ACTIONS(251),
    [anon_sym_PIPE_PIPE] = ACTIONS(251),
    [anon_sym_DOT] = ACTIONS(253),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_DASH_DASH] = ACTIONS(251),
    [anon_sym_RBRACE] = ACTIONS(251),
    [anon_sym_AMP] = ACTIONS(249),
  },
  [42] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_GT] = ACTIONS(103),
  },
  [43] = {
    [anon_sym_PIPE] = ACTIONS(255),
    [anon_sym_COMMA] = ACTIONS(257),
    [anon_sym_COLON_COLON] = ACTIONS(257),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(255),
    [anon_sym_DOT] = ACTIONS(257),
    [anon_sym_SLASH] = ACTIONS(255),
    [anon_sym_COLON] = ACTIONS(255),
    [anon_sym_RBRACE] = ACTIONS(257),
    [anon_sym_GT_GT] = ACTIONS(255),
    [anon_sym_DASH_DASH] = ACTIONS(257),
    [anon_sym_BANG_EQ] = ACTIONS(257),
    [anon_sym_CARET] = ACTIONS(257),
    [anon_sym_QMARK] = ACTIONS(257),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_LT_EQ] = ACTIONS(257),
    [anon_sym_PLUS_PLUS] = ACTIONS(257),
    [anon_sym_EQ_EQ] = ACTIONS(257),
    [anon_sym_PIPE_PIPE] = ACTIONS(257),
    [anon_sym_SEMI] = ACTIONS(257),
    [anon_sym_AMP_AMP] = ACTIONS(257),
    [anon_sym_PERCENT] = ACTIONS(257),
    [anon_sym_LT_LT] = ACTIONS(257),
    [anon_sym_PLUS] = ACTIONS(255),
    [anon_sym_GT_GT_GT] = ACTIONS(257),
    [anon_sym_RPAREN] = ACTIONS(257),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(255),
    [anon_sym_LT] = ACTIONS(255),
    [anon_sym_GT_EQ] = ACTIONS(257),
    [anon_sym_STAR] = ACTIONS(257),
    [anon_sym_instanceof] = ACTIONS(257),
    [anon_sym_RBRACK] = ACTIONS(257),
  },
  [44] = {
    [sym_annotation] = STATE(149),
    [aux_sym_modifiers_repeat1] = STATE(149),
    [sym_marker_annotation] = STATE(149),
    [sym__annotation] = STATE(149),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_strictfp] = ACTIONS(261),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(17),
    [sym_void_type] = ACTIONS(265),
    [anon_sym_char] = ACTIONS(265),
    [anon_sym_int] = ACTIONS(265),
    [anon_sym_abstract] = ACTIONS(261),
    [anon_sym_short] = ACTIONS(265),
    [anon_sym_interface] = ACTIONS(265),
    [anon_sym_transient] = ACTIONS(261),
    [anon_sym_double] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(261),
    [anon_sym_volatile] = ACTIONS(261),
    [sym_identifier] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(261),
    [anon_sym_native] = ACTIONS(261),
    [sym_boolean_type] = ACTIONS(265),
    [anon_sym_byte] = ACTIONS(265),
    [anon_sym_final] = ACTIONS(261),
    [anon_sym_long] = ACTIONS(265),
    [anon_sym_float] = ACTIONS(265),
    [anon_sym_class] = ACTIONS(265),
    [anon_sym_default] = ACTIONS(261),
    [anon_sym_ATinterface] = ACTIONS(263),
    [anon_sym_synchronized] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [anon_sym_enum] = ACTIONS(265),
  },
  [45] = {
    [anon_sym_DASH] = ACTIONS(267),
    [sym_true] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_native] = ACTIONS(267),
    [sym_boolean_type] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(269),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_else] = ACTIONS(267),
    [anon_sym_for] = ACTIONS(267),
    [sym_decimal_floating_point_literal] = ACTIONS(269),
    [sym_hex_integer_literal] = ACTIONS(267),
    [anon_sym_do] = ACTIONS(267),
    [sym_false] = ACTIONS(267),
    [sym_this] = ACTIONS(267),
    [ts_builtin_sym_end] = ACTIONS(269),
    [anon_sym_continue] = ACTIONS(267),
    [anon_sym_package] = ACTIONS(267),
    [anon_sym_RBRACE] = ACTIONS(269),
    [sym_binary_integer_literal] = ACTIONS(269),
    [anon_sym_transient] = ACTIONS(267),
    [anon_sym_public] = ACTIONS(267),
    [sym_decimal_integer_literal] = ACTIONS(267),
    [sym_octal_integer_literal] = ACTIONS(269),
    [sym_null_literal] = ACTIONS(267),
    [anon_sym_while] = ACTIONS(267),
    [anon_sym_synchronized] = ACTIONS(267),
    [anon_sym_SEMI] = ACTIONS(269),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_enum] = ACTIONS(267),
    [sym_void_type] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_byte] = ACTIONS(267),
    [anon_sym_long] = ACTIONS(267),
    [sym_identifier] = ACTIONS(267),
    [anon_sym_default] = ACTIONS(267),
    [anon_sym_import] = ACTIONS(267),
    [sym_super] = ACTIONS(267),
    [anon_sym_final] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(267),
    [anon_sym_abstract] = ACTIONS(267),
    [anon_sym_new] = ACTIONS(267),
    [anon_sym_assert] = ACTIONS(267),
    [anon_sym_try] = ACTIONS(267),
    [anon_sym_int] = ACTIONS(267),
    [anon_sym_throw] = ACTIONS(267),
    [anon_sym_strictfp] = ACTIONS(267),
    [anon_sym_double] = ACTIONS(267),
    [sym_character_literal] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(269),
    [anon_sym_DASH_DASH] = ACTIONS(269),
    [anon_sym_LT] = ACTIONS(269),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_private] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(269),
    [anon_sym_switch] = ACTIONS(267),
    [anon_sym_ATinterface] = ACTIONS(269),
    [anon_sym_interface] = ACTIONS(267),
    [anon_sym_short] = ACTIONS(267),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_static] = ACTIONS(267),
    [anon_sym_protected] = ACTIONS(267),
    [anon_sym_float] = ACTIONS(267),
    [anon_sym_AT] = ACTIONS(267),
    [sym_string_literal] = ACTIONS(269),
    [anon_sym_volatile] = ACTIONS(267),
    [anon_sym_class] = ACTIONS(267),
    [sym_hex_floating_point_literal] = ACTIONS(267),
    [anon_sym_char] = ACTIONS(267),
  },
  [46] = {
    [ts_builtin_sym_end] = ACTIONS(271),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(273),
  },
  [48] = {
    [sym_array_type] = STATE(155),
    [sym_integral_type] = STATE(155),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(155),
    [sym_floating_point_type] = STATE(155),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(275),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(277),
    [anon_sym_class] = ACTIONS(279),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(281),
    [anon_sym_interface] = ACTIONS(283),
    [sym_void_type] = ACTIONS(275),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
  },
  [49] = {
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(307),
    [anon_sym_AMP] = ACTIONS(309),
  },
  [50] = {
    [anon_sym_BANG_EQ] = ACTIONS(311),
    [anon_sym_PLUS_PLUS] = ACTIONS(311),
    [anon_sym_instanceof] = ACTIONS(311),
    [anon_sym_COLON_COLON] = ACTIONS(311),
    [anon_sym_PERCENT] = ACTIONS(311),
    [anon_sym_AMP_AMP] = ACTIONS(311),
    [anon_sym_COLON] = ACTIONS(313),
    [anon_sym_GT] = ACTIONS(313),
    [anon_sym_PIPE_PIPE] = ACTIONS(311),
    [anon_sym_DASH] = ACTIONS(313),
    [anon_sym_PLUS] = ACTIONS(313),
    [anon_sym_GT_GT] = ACTIONS(313),
    [anon_sym_GT_GT_GT] = ACTIONS(311),
    [anon_sym_DOT] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(311),
    [anon_sym_GT_EQ] = ACTIONS(311),
    [anon_sym_LT] = ACTIONS(313),
    [anon_sym_RBRACE] = ACTIONS(311),
    [anon_sym_CARET] = ACTIONS(311),
    [anon_sym_SEMI] = ACTIONS(311),
    [anon_sym_EQ_EQ] = ACTIONS(311),
    [anon_sym_LT_EQ] = ACTIONS(311),
    [anon_sym_SLASH] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(313),
    [anon_sym_LT_LT] = ACTIONS(311),
    [anon_sym_STAR] = ACTIONS(311),
    [anon_sym_RPAREN] = ACTIONS(311),
    [anon_sym_PIPE] = ACTIONS(313),
    [anon_sym_DASH_DASH] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_QMARK] = ACTIONS(311),
    [anon_sym_RBRACK] = ACTIONS(311),
  },
  [51] = {
    [anon_sym_char] = ACTIONS(315),
    [anon_sym_abstract] = ACTIONS(184),
    [anon_sym_double] = ACTIONS(315),
    [anon_sym_long] = ACTIONS(315),
    [anon_sym_static] = ACTIONS(184),
    [anon_sym_native] = ACTIONS(184),
    [anon_sym_int] = ACTIONS(315),
    [anon_sym_private] = ACTIONS(184),
    [anon_sym_byte] = ACTIONS(315),
    [anon_sym_transient] = ACTIONS(184),
    [anon_sym_strictfp] = ACTIONS(184),
    [sym_boolean_type] = ACTIONS(315),
    [anon_sym_module] = ACTIONS(318),
    [anon_sym_float] = ACTIONS(315),
    [anon_sym_default] = ACTIONS(184),
    [anon_sym_open] = ACTIONS(318),
    [anon_sym_enum] = ACTIONS(184),
    [anon_sym_final] = ACTIONS(184),
    [anon_sym_ATinterface] = ACTIONS(186),
    [sym_comment] = ACTIONS(3),
    [anon_sym_volatile] = ACTIONS(184),
    [anon_sym_synchronized] = ACTIONS(184),
    [anon_sym_public] = ACTIONS(184),
    [anon_sym_class] = ACTIONS(184),
    [sym_identifier] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(315),
    [anon_sym_interface] = ACTIONS(184),
    [anon_sym_package] = ACTIONS(318),
    [anon_sym_short] = ACTIONS(315),
    [sym_void_type] = ACTIONS(315),
    [anon_sym_protected] = ACTIONS(184),
  },
  [52] = {
    [aux_sym_class_literal_repeat1] = STATE(66),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_SEMI] = ACTIONS(87),
    [anon_sym_COMMA] = ACTIONS(87),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_STAR_EQ] = ACTIONS(93),
    [anon_sym_PIPE] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_EQ_EQ] = ACTIONS(87),
    [anon_sym_LT_LT_EQ] = ACTIONS(93),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_QMARK] = ACTIONS(87),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_BANG_EQ] = ACTIONS(87),
    [anon_sym_PERCENT_EQ] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_RBRACK] = ACTIONS(87),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_AMP_AMP] = ACTIONS(87),
    [anon_sym_COLON_COLON] = ACTIONS(138),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_COLON] = ACTIONS(85),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_EQ] = ACTIONS(98),
    [anon_sym_PLUS_EQ] = ACTIONS(93),
    [anon_sym_AMP_EQ] = ACTIONS(93),
    [anon_sym_CARET_EQ] = ACTIONS(93),
    [anon_sym_PIPE_EQ] = ACTIONS(93),
    [anon_sym_GT_GT_GT] = ACTIONS(85),
    [anon_sym_RBRACE] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [anon_sym_AMP] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_instanceof] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_DASH_EQ] = ACTIONS(93),
    [anon_sym_SLASH_EQ] = ACTIONS(93),
    [anon_sym_LBRACK] = ACTIONS(320),
    [anon_sym_DOT] = ACTIONS(322),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(93),
  },
  [53] = {
    [sym_identifier] = ACTIONS(156),
    [anon_sym_module] = ACTIONS(156),
    [anon_sym_implements] = ACTIONS(156),
    [anon_sym_SEMI] = ACTIONS(154),
    [anon_sym_AMP] = ACTIONS(154),
    [anon_sym_LBRACK] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(154),
    [anon_sym_PIPE] = ACTIONS(154),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(225),
    [anon_sym_RPAREN] = ACTIONS(154),
    [anon_sym_COMMA] = ACTIONS(154),
    [anon_sym_COLON_COLON] = ACTIONS(154),
    [anon_sym_AT] = ACTIONS(154),
    [anon_sym_open] = ACTIONS(156),
    [anon_sym_GT] = ACTIONS(154),
    [sym_this] = ACTIONS(156),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(154),
  },
  [54] = {
    [anon_sym_SEMI] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [anon_sym_import] = ACTIONS(326),
    [anon_sym_static] = ACTIONS(326),
    [sym_false] = ACTIONS(326),
    [sym_string_literal] = ACTIONS(328),
    [anon_sym_return] = ACTIONS(326),
    [anon_sym_BANG] = ACTIONS(328),
    [anon_sym_PLUS_PLUS] = ACTIONS(328),
    [anon_sym_class] = ACTIONS(326),
    [anon_sym_switch] = ACTIONS(326),
    [anon_sym_AT] = ACTIONS(326),
    [sym_true] = ACTIONS(326),
    [anon_sym_module] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
    [anon_sym_package] = ACTIONS(326),
    [sym_identifier] = ACTIONS(326),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH] = ACTIONS(326),
    [sym_this] = ACTIONS(326),
    [anon_sym_transient] = ACTIONS(326),
    [anon_sym_if] = ACTIONS(326),
    [anon_sym_public] = ACTIONS(326),
    [anon_sym_assert] = ACTIONS(326),
    [anon_sym_LBRACE] = ACTIONS(328),
    [anon_sym_while] = ACTIONS(326),
    [anon_sym_abstract] = ACTIONS(326),
    [anon_sym_protected] = ACTIONS(326),
    [sym_boolean_type] = ACTIONS(326),
    [anon_sym_continue] = ACTIONS(326),
    [sym_super] = ACTIONS(326),
    [sym_binary_integer_literal] = ACTIONS(328),
    [anon_sym_else] = ACTIONS(326),
    [anon_sym_int] = ACTIONS(326),
    [ts_builtin_sym_end] = ACTIONS(328),
    [anon_sym_short] = ACTIONS(326),
    [anon_sym_volatile] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(326),
    [anon_sym_interface] = ACTIONS(326),
    [anon_sym_open] = ACTIONS(326),
    [anon_sym_char] = ACTIONS(326),
    [anon_sym_long] = ACTIONS(326),
    [anon_sym_synchronized] = ACTIONS(326),
    [anon_sym_float] = ACTIONS(326),
    [anon_sym_double] = ACTIONS(326),
    [anon_sym_try] = ACTIONS(326),
    [anon_sym_do] = ACTIONS(326),
    [anon_sym_byte] = ACTIONS(326),
    [anon_sym_case] = ACTIONS(326),
    [anon_sym_default] = ACTIONS(326),
    [anon_sym_ATinterface] = ACTIONS(328),
    [anon_sym_PLUS] = ACTIONS(326),
    [anon_sym_private] = ACTIONS(326),
    [anon_sym_LPAREN] = ACTIONS(328),
    [sym_void_type] = ACTIONS(326),
    [anon_sym_throw] = ACTIONS(326),
    [sym_hex_floating_point_literal] = ACTIONS(326),
    [sym_decimal_floating_point_literal] = ACTIONS(328),
    [sym_hex_integer_literal] = ACTIONS(326),
    [anon_sym_enum] = ACTIONS(326),
    [sym_octal_integer_literal] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_for] = ACTIONS(326),
    [anon_sym_strictfp] = ACTIONS(326),
    [sym_character_literal] = ACTIONS(328),
    [sym_null_literal] = ACTIONS(326),
    [anon_sym_native] = ACTIONS(326),
    [anon_sym_DASH_DASH] = ACTIONS(328),
    [sym_decimal_integer_literal] = ACTIONS(326),
    [anon_sym_break] = ACTIONS(326),
    [anon_sym_final] = ACTIONS(326),
    [anon_sym_RBRACE] = ACTIONS(328),
  },
  [56] = {
    [sym_class_literal] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_assignment_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym_field_access] = STATE(39),
    [sym_annotation] = STATE(74),
    [sym_array_type] = STATE(73),
    [sym_generic_type] = STATE(53),
    [sym_cast_expression] = STATE(167),
    [sym_ternary_expression] = STATE(167),
    [sym_method_reference] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym__annotation] = STATE(74),
    [sym_floating_point_type] = STATE(30),
    [sym_unary_expression] = STATE(167),
    [sym__type] = STATE(37),
    [sym_method_invocation] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_update_expression] = STATE(167),
    [sym_inferred_parameters] = STATE(42),
    [sym_parenthesized_expression] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_integral_type] = STATE(30),
    [sym_array_creation_expression] = STATE(41),
    [sym_marker_annotation] = STATE(74),
    [sym__primary] = STATE(41),
    [sym_array_access] = STATE(39),
    [sym__unannotated_type] = STATE(73),
    [sym__expression] = STATE(167),
    [sym_instanceof_expression] = STATE(167),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_lambda_expression] = STATE(167),
    [sym_scoped_identifier] = STATE(52),
    [sym_false] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_char] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_float] = ACTIONS(41),
    [sym_string_literal] = ACTIONS(35),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_true] = ACTIONS(5),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
  },
  [57] = {
    [sym_type_arguments] = STATE(169),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_new] = ACTIONS(330),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(146),
  },
  [58] = {
    [sym_annotated_type] = STATE(173),
    [sym_integral_type] = STATE(73),
    [sym__unannotated_type] = STATE(73),
    [sym_wildcard] = STATE(173),
    [aux_sym_dimensions_expr_repeat1] = STATE(172),
    [sym__annotation] = STATE(172),
    [sym_floating_point_type] = STATE(73),
    [sym_marker_annotation] = STATE(172),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__type] = STATE(173),
    [sym_annotation] = STATE(172),
    [sym_generic_type] = STATE(53),
    [sym_array_type] = STATE(73),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_QMARK] = ACTIONS(332),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_byte] = ACTIONS(33),
    [sym_void_type] = ACTIONS(334),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(336),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(334),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
  },
  [59] = {
    [sym_if_statement] = STATE(174),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_throw_statement] = STATE(174),
    [sym_parenthesized_expression] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_normal_interface_declaration] = STATE(45),
    [sym__primary_no_new_array] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_method_invocation] = STATE(43),
    [sym_break_statement] = STATE(174),
    [sym_formal_parameters] = STATE(42),
    [sym__literal] = STATE(43),
    [sym_unary_expression] = STATE(49),
    [sym_cast_expression] = STATE(49),
    [sym__unannotated_type] = STATE(40),
    [sym_synchronized_statement] = STATE(174),
    [sym_for_statement] = STATE(174),
    [sym_ternary_expression] = STATE(49),
    [sym_interface_declaration] = STATE(174),
    [sym_local_variable_declaration] = STATE(47),
    [sym_module_declaration] = STATE(174),
    [sym_while_statement] = STATE(174),
    [sym_class_declaration] = STATE(174),
    [sym__expression] = STATE(49),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_lambda_expression] = STATE(49),
    [sym_block] = STATE(174),
    [sym__primary] = STATE(41),
    [sym_floating_point_type] = STATE(30),
    [sym_array_access] = STATE(39),
    [sym_enhanced_for_statement] = STATE(174),
    [sym_scoped_identifier] = STATE(52),
    [sym_object_creation_expression] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_continue_statement] = STATE(174),
    [sym_labeled_statement] = STATE(174),
    [sym_modifiers] = STATE(48),
    [sym__type] = STATE(37),
    [sym_try_with_resources_statement] = STATE(174),
    [sym_switch_statement] = STATE(174),
    [sym_generic_type] = STATE(53),
    [sym_marker_annotation] = STATE(51),
    [sym_enum_declaration] = STATE(174),
    [sym__declaration] = STATE(174),
    [sym_import_declaration] = STATE(174),
    [sym_try_statement] = STATE(174),
    [sym_package_declaration] = STATE(174),
    [sym__annotation] = STATE(51),
    [sym_assignment_expression] = STATE(49),
    [sym_class_literal] = STATE(43),
    [sym_do_statement] = STATE(174),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_return_statement] = STATE(174),
    [sym_method_reference] = STATE(43),
    [sym_array_type] = STATE(40),
    [sym_expression_statement] = STATE(174),
    [sym_local_variable_declaration_statement] = STATE(174),
    [sym_update_expression] = STATE(49),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_assert_statement] = STATE(174),
    [sym_instanceof_expression] = STATE(49),
    [sym_integral_type] = STATE(30),
    [sym_binary_expression] = STATE(49),
    [sym_annotation] = STATE(51),
    [sym_field_access] = STATE(39),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_while] = ACTIONS(63),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_private] = ACTIONS(7),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(45),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_strictfp] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_string_literal] = ACTIONS(35),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_enum] = ACTIONS(67),
    [sym_identifier] = ACTIONS(13),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(17),
    [sym_super] = ACTIONS(9),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_float] = ACTIONS(41),
    [sym_false] = ACTIONS(5),
    [anon_sym_abstract] = ACTIONS(7),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_default] = ACTIONS(7),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_break] = ACTIONS(25),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_this] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(43),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_TILDE] = ACTIONS(37),
  },
  [60] = {
    [sym_array_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_generic_type] = STATE(53),
    [sym_lambda_expression] = STATE(176),
    [sym_array_access] = STATE(39),
    [sym_field_access] = STATE(39),
    [sym_method_reference] = STATE(43),
    [sym__expression] = STATE(176),
    [sym__annotation] = STATE(74),
    [sym_instanceof_expression] = STATE(176),
    [sym_parenthesized_expression] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym_class_literal] = STATE(43),
    [sym_binary_expression] = STATE(176),
    [sym_floating_point_type] = STATE(30),
    [sym_scoped_identifier] = STATE(52),
    [sym_array_creation_expression] = STATE(41),
    [sym_update_expression] = STATE(176),
    [sym_inferred_parameters] = STATE(42),
    [sym_method_invocation] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_annotated_type] = STATE(37),
    [sym_cast_expression] = STATE(176),
    [sym_integral_type] = STATE(30),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__type] = STATE(37),
    [sym__unannotated_type] = STATE(73),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_ternary_expression] = STATE(176),
    [sym_annotation] = STATE(74),
    [sym_assignment_expression] = STATE(176),
    [sym_formal_parameters] = STATE(42),
    [sym__primary_no_new_array] = STATE(43),
    [sym_unary_expression] = STATE(176),
    [sym__literal] = STATE(43),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_new] = ACTIONS(19),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_double] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_int] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_RBRACK] = ACTIONS(340),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [sym_identifier] = ACTIONS(124),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [sym_void_type] = ACTIONS(55),
    [sym_null_literal] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
  },
  [61] = {
    [sym_annotation] = STATE(74),
    [sym_ternary_expression] = STATE(178),
    [sym_formal_parameters] = STATE(42),
    [sym__unannotated_type] = STATE(73),
    [sym_assignment_expression] = STATE(178),
    [sym_cast_expression] = STATE(178),
    [sym_update_expression] = STATE(178),
    [sym_class_literal] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym__expression] = STATE(178),
    [sym_array_creation_expression] = STATE(41),
    [sym_marker_annotation] = STATE(74),
    [sym_scoped_identifier] = STATE(52),
    [sym_method_invocation] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_lambda_expression] = STATE(178),
    [sym_method_reference] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym__type] = STATE(37),
    [sym__literal] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_instanceof_expression] = STATE(178),
    [sym_unary_expression] = STATE(178),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_object_creation_expression] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_floating_point_type] = STATE(30),
    [sym__annotation] = STATE(74),
    [sym__primary] = STATE(41),
    [sym_parenthesized_expression] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_inferred_parameters] = STATE(42),
    [sym_binary_expression] = STATE(178),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(120),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_short] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_RPAREN] = ACTIONS(342),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_module] = ACTIONS(120),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_super] = ACTIONS(9),
    [sym_this] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
  },
  [62] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(184),
    [sym_marker_annotation] = STATE(184),
    [sym__annotation] = STATE(184),
    [sym__unqualified_object_creation_expression] = STATE(185),
    [sym_annotation] = STATE(184),
    [sym_type_arguments] = STATE(186),
    [anon_sym_AT] = ACTIONS(118),
    [sym_super] = ACTIONS(344),
    [anon_sym_new] = ACTIONS(346),
    [sym_identifier] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(350),
    [anon_sym_class] = ACTIONS(352),
  },
  [63] = {
    [sym__unannotated_type] = STATE(73),
    [sym_annotation] = STATE(74),
    [sym_unary_expression] = STATE(187),
    [sym_class_literal] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_inferred_parameters] = STATE(42),
    [sym__primary] = STATE(41),
    [sym_lambda_expression] = STATE(187),
    [sym_method_reference] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_ternary_expression] = STATE(187),
    [sym_update_expression] = STATE(187),
    [sym_assignment_expression] = STATE(187),
    [sym__primary_no_new_array] = STATE(43),
    [sym_binary_expression] = STATE(187),
    [sym_block] = STATE(188),
    [sym__literal] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_scoped_identifier] = STATE(52),
    [sym_object_creation_expression] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_instanceof_expression] = STATE(187),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_array_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__expression] = STATE(187),
    [sym__type] = STATE(37),
    [sym_integral_type] = STATE(30),
    [sym_array_creation_expression] = STATE(41),
    [sym_array_access] = STATE(39),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_field_access] = STATE(39),
    [sym_marker_annotation] = STATE(74),
    [sym_formal_parameters] = STATE(42),
    [sym_cast_expression] = STATE(187),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(41),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_long] = ACTIONS(33),
    [sym_identifier] = ACTIONS(124),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [sym_boolean_type] = ACTIONS(79),
    [sym_void_type] = ACTIONS(55),
    [sym_this] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [sym_false] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
  },
  [64] = {
    [anon_sym_module] = ACTIONS(354),
    [anon_sym_LBRACK] = ACTIONS(356),
    [anon_sym_AMP] = ACTIONS(356),
    [anon_sym_implements] = ACTIONS(354),
    [anon_sym_DOT] = ACTIONS(354),
    [anon_sym_GT] = ACTIONS(356),
    [anon_sym_COMMA] = ACTIONS(356),
    [anon_sym_COLON_COLON] = ACTIONS(356),
    [sym_identifier] = ACTIONS(354),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(356),
    [sym_this] = ACTIONS(354),
    [anon_sym_LPAREN] = ACTIONS(356),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(356),
    [anon_sym_RPAREN] = ACTIONS(356),
    [anon_sym_PIPE] = ACTIONS(356),
    [anon_sym_LBRACE] = ACTIONS(356),
    [anon_sym_open] = ACTIONS(354),
    [anon_sym_SEMI] = ACTIONS(356),
  },
  [65] = {
    [anon_sym_CARET] = ACTIONS(358),
    [anon_sym_PLUS_PLUS] = ACTIONS(358),
    [anon_sym_AMP_AMP] = ACTIONS(358),
    [anon_sym_GT_GT] = ACTIONS(360),
    [anon_sym_GT_EQ] = ACTIONS(358),
    [anon_sym_COMMA] = ACTIONS(358),
    [anon_sym_PIPE_PIPE] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_LT_LT] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_DASH_DASH] = ACTIONS(358),
    [anon_sym_COLON] = ACTIONS(360),
    [anon_sym_AMP] = ACTIONS(360),
    [anon_sym_STAR] = ACTIONS(358),
    [anon_sym_PLUS] = ACTIONS(360),
    [anon_sym_GT_GT_GT] = ACTIONS(358),
    [anon_sym_instanceof] = ACTIONS(358),
    [anon_sym_RBRACK] = ACTIONS(358),
    [anon_sym_EQ_EQ] = ACTIONS(358),
    [anon_sym_LT_EQ] = ACTIONS(358),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_LT] = ACTIONS(360),
    [anon_sym_COLON_COLON] = ACTIONS(358),
    [anon_sym_DOT] = ACTIONS(358),
    [anon_sym_RBRACE] = ACTIONS(358),
    [anon_sym_QMARK] = ACTIONS(358),
    [anon_sym_BANG_EQ] = ACTIONS(358),
    [anon_sym_DASH] = ACTIONS(360),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SLASH] = ACTIONS(360),
    [anon_sym_PERCENT] = ACTIONS(358),
    [anon_sym_LBRACK] = ACTIONS(358),
  },
  [66] = {
    [aux_sym_class_literal_repeat1] = STATE(190),
    [anon_sym_LBRACK] = ACTIONS(362),
    [anon_sym_DOT] = ACTIONS(364),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(366),
    [anon_sym_DOT] = ACTIONS(368),
  },
  [68] = {
    [anon_sym_SEMI] = ACTIONS(370),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(372),
  },
  [69] = {
    [sym_argument_list] = STATE(127),
    [aux_sym_class_literal_repeat1] = STATE(126),
    [anon_sym_BANG_EQ] = ACTIONS(209),
    [anon_sym_GT_GT] = ACTIONS(201),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(203),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SLASH] = ACTIONS(201),
    [anon_sym_PERCENT] = ACTIONS(201),
    [anon_sym_DASH_DASH] = ACTIONS(209),
    [anon_sym_AMP_EQ] = ACTIONS(203),
    [anon_sym_COLON] = ACTIONS(201),
    [anon_sym_EQ] = ACTIONS(207),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_SLASH_EQ] = ACTIONS(203),
    [anon_sym_STAR_EQ] = ACTIONS(203),
    [anon_sym_EQ_EQ] = ACTIONS(209),
    [anon_sym_PLUS_PLUS] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_GT_GT_GT] = ACTIONS(201),
    [anon_sym_STAR] = ACTIONS(201),
    [anon_sym_DASH] = ACTIONS(201),
    [anon_sym_PLUS_EQ] = ACTIONS(203),
    [anon_sym_RBRACK] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_RBRACE] = ACTIONS(209),
    [anon_sym_GT_GT_EQ] = ACTIONS(203),
    [anon_sym_DASH_EQ] = ACTIONS(203),
    [anon_sym_CARET] = ACTIONS(201),
    [anon_sym_DOT] = ACTIONS(215),
    [anon_sym_GT] = ACTIONS(201),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(209),
    [anon_sym_instanceof] = ACTIONS(209),
    [anon_sym_QMARK] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(201),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(201),
    [anon_sym_AMP_AMP] = ACTIONS(209),
    [anon_sym_LT_LT] = ACTIONS(201),
    [anon_sym_PIPE_EQ] = ACTIONS(203),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_CARET_EQ] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(205),
    [anon_sym_PERCENT_EQ] = ACTIONS(203),
    [anon_sym_LT_LT_EQ] = ACTIONS(203),
  },
  [70] = {
    [anon_sym_DASH] = ACTIONS(374),
    [anon_sym_if] = ACTIONS(374),
    [anon_sym_ATinterface] = ACTIONS(376),
    [anon_sym_strictfp] = ACTIONS(374),
    [anon_sym_transient] = ACTIONS(374),
    [sym_hex_floating_point_literal] = ACTIONS(374),
    [anon_sym_double] = ACTIONS(374),
    [sym_boolean_type] = ACTIONS(374),
    [anon_sym_throw] = ACTIONS(374),
    [anon_sym_synchronized] = ACTIONS(374),
    [anon_sym_case] = ACTIONS(374),
    [anon_sym_interface] = ACTIONS(374),
    [anon_sym_else] = ACTIONS(374),
    [anon_sym_public] = ACTIONS(374),
    [anon_sym_break] = ACTIONS(374),
    [anon_sym_byte] = ACTIONS(374),
    [anon_sym_int] = ACTIONS(374),
    [sym_this] = ACTIONS(374),
    [sym_decimal_floating_point_literal] = ACTIONS(376),
    [sym_super] = ACTIONS(374),
    [anon_sym_volatile] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_long] = ACTIONS(374),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_AT] = ACTIONS(374),
    [anon_sym_float] = ACTIONS(374),
    [anon_sym_protected] = ACTIONS(374),
    [anon_sym_SEMI] = ACTIONS(376),
    [anon_sym_final] = ACTIONS(374),
    [sym_false] = ACTIONS(374),
    [anon_sym_switch] = ACTIONS(374),
    [anon_sym_do] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(376),
    [sym_void_type] = ACTIONS(374),
    [anon_sym_continue] = ACTIONS(374),
    [anon_sym_char] = ACTIONS(374),
    [sym_comment] = ACTIONS(3),
    [sym_null_literal] = ACTIONS(374),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_open] = ACTIONS(374),
    [anon_sym_PLUS] = ACTIONS(374),
    [anon_sym_short] = ACTIONS(374),
    [sym_string_literal] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(376),
    [anon_sym_native] = ACTIONS(374),
    [sym_true] = ACTIONS(374),
    [anon_sym_package] = ACTIONS(374),
    [sym_identifier] = ACTIONS(374),
    [anon_sym_try] = ACTIONS(374),
    [anon_sym_private] = ACTIONS(374),
    [ts_builtin_sym_end] = ACTIONS(376),
    [anon_sym_abstract] = ACTIONS(374),
    [anon_sym_TILDE] = ACTIONS(376),
    [sym_binary_integer_literal] = ACTIONS(376),
    [anon_sym_new] = ACTIONS(374),
    [anon_sym_while] = ACTIONS(374),
    [sym_octal_integer_literal] = ACTIONS(376),
    [sym_hex_integer_literal] = ACTIONS(374),
    [anon_sym_return] = ACTIONS(374),
    [anon_sym_BANG] = ACTIONS(376),
    [anon_sym_default] = ACTIONS(374),
    [anon_sym_DASH_DASH] = ACTIONS(376),
    [anon_sym_module] = ACTIONS(374),
    [sym_decimal_integer_literal] = ACTIONS(374),
    [anon_sym_static] = ACTIONS(374),
    [anon_sym_enum] = ACTIONS(374),
    [sym_character_literal] = ACTIONS(376),
    [anon_sym_class] = ACTIONS(374),
    [anon_sym_assert] = ACTIONS(374),
  },
  [71] = {
    [sym_type_arguments] = STATE(64),
    [aux_sym_class_literal_repeat1] = STATE(66),
    [sym_argument_list] = STATE(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_GT_GT_GT] = ACTIONS(85),
    [anon_sym_EQ] = ACTIONS(98),
    [anon_sym_DASH_EQ] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_DOT] = ACTIONS(110),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_QMARK] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_module] = ACTIONS(89),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_PERCENT_EQ] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_open] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_SLASH_EQ] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(107),
    [anon_sym_STAR_EQ] = ACTIONS(93),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_EQ_EQ] = ACTIONS(87),
    [anon_sym_SEMI] = ACTIONS(87),
    [anon_sym_PIPE_EQ] = ACTIONS(93),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_instanceof] = ACTIONS(85),
    [anon_sym_RBRACK] = ACTIONS(87),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_AMP] = ACTIONS(85),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_LT_LT_EQ] = ACTIONS(93),
    [anon_sym_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_COMMA] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(85),
    [anon_sym_DASH_GT] = ACTIONS(103),
    [anon_sym_AMP_EQ] = ACTIONS(93),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_PLUS_EQ] = ACTIONS(93),
    [anon_sym_LBRACK] = ACTIONS(100),
    [anon_sym_CARET_EQ] = ACTIONS(93),
    [anon_sym_RBRACE] = ACTIONS(87),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_BANG_EQ] = ACTIONS(87),
  },
  [72] = {
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_SEMI] = ACTIONS(378),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_CARET] = ACTIONS(295),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(297),
  },
  [73] = {
    [sym_dimensions] = STATE(144),
    [sym__annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_annotation] = STATE(145),
    [anon_sym_COLON_COLON] = ACTIONS(245),
    [anon_sym_implements] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_RPAREN] = ACTIONS(245),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_COMMA] = ACTIONS(245),
    [anon_sym_AMP] = ACTIONS(245),
    [anon_sym_GT] = ACTIONS(245),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(245),
  },
  [74] = {
    [sym_array_type] = STATE(136),
    [sym_generic_type] = STATE(53),
    [sym_annotation] = STATE(137),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__unannotated_type] = STATE(136),
    [sym_floating_point_type] = STATE(136),
    [sym__annotation] = STATE(137),
    [sym_marker_annotation] = STATE(137),
    [sym_integral_type] = STATE(136),
    [sym_boolean_type] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_void_type] = ACTIONS(229),
    [anon_sym_char] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
  },
  [75] = {
    [anon_sym_PLUS] = ACTIONS(380),
    [anon_sym_SLASH] = ACTIONS(380),
    [anon_sym_RPAREN] = ACTIONS(382),
    [anon_sym_DASH] = ACTIONS(380),
    [sym_comment] = ACTIONS(3),
    [anon_sym_instanceof] = ACTIONS(382),
    [anon_sym_GT] = ACTIONS(380),
    [anon_sym_CARET] = ACTIONS(382),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(382),
    [anon_sym_QMARK] = ACTIONS(382),
    [anon_sym_SEMI] = ACTIONS(382),
    [anon_sym_PERCENT] = ACTIONS(382),
    [anon_sym_AMP] = ACTIONS(380),
    [anon_sym_LT_LT] = ACTIONS(382),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_COMMA] = ACTIONS(382),
    [anon_sym_AMP_AMP] = ACTIONS(382),
    [anon_sym_RBRACE] = ACTIONS(382),
    [anon_sym_PIPE] = ACTIONS(380),
    [anon_sym_BANG_EQ] = ACTIONS(382),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_LT_EQ] = ACTIONS(382),
    [anon_sym_GT_EQ] = ACTIONS(382),
    [anon_sym_COLON] = ACTIONS(382),
    [anon_sym_GT_GT_GT] = ACTIONS(382),
    [anon_sym_PIPE_PIPE] = ACTIONS(382),
    [anon_sym_GT_GT] = ACTIONS(380),
    [anon_sym_EQ_EQ] = ACTIONS(382),
    [anon_sym_RBRACK] = ACTIONS(382),
  },
  [76] = {
    [anon_sym_LBRACE] = ACTIONS(384),
    [anon_sym_LBRACK] = ACTIONS(384),
    [anon_sym_SEMI] = ACTIONS(384),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_GT] = ACTIONS(384),
    [anon_sym_AT] = ACTIONS(384),
    [anon_sym_throws] = ACTIONS(384),
  },
  [77] = {
    [sym_argument_list] = STATE(65),
    [sym_type_arguments] = STATE(64),
    [aux_sym_class_literal_repeat1] = STATE(66),
    [aux_sym_inferred_parameters_repeat1] = STATE(198),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_PIPE] = ACTIONS(85),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_open] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(107),
    [anon_sym_AMP_AMP] = ACTIONS(87),
    [anon_sym_DASH_EQ] = ACTIONS(93),
    [anon_sym_EQ_EQ] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [anon_sym_AMP] = ACTIONS(386),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_RPAREN] = ACTIONS(389),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_EQ] = ACTIONS(98),
    [anon_sym_LBRACK] = ACTIONS(100),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_module] = ACTIONS(89),
    [anon_sym_DOT] = ACTIONS(393),
    [sym_this] = ACTIONS(89),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_AMP_EQ] = ACTIONS(93),
    [anon_sym_COMMA] = ACTIONS(395),
    [anon_sym_instanceof] = ACTIONS(85),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_STAR_EQ] = ACTIONS(93),
    [anon_sym_PLUS_EQ] = ACTIONS(93),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_GT_GT_GT] = ACTIONS(85),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_PIPE_EQ] = ACTIONS(93),
    [anon_sym_LT_LT_EQ] = ACTIONS(93),
    [anon_sym_CARET_EQ] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_BANG_EQ] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_PERCENT_EQ] = ACTIONS(93),
    [anon_sym_QMARK] = ACTIONS(87),
    [anon_sym_SLASH_EQ] = ACTIONS(93),
    [anon_sym_DASH_GT] = ACTIONS(103),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_STAR] = ACTIONS(85),
  },
  [78] = {
    [sym__annotation] = STATE(902),
    [sym_scoped_type_identifier] = STATE(36),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym__unannotated_type] = STATE(200),
    [sym_spread_parameter] = STATE(201),
    [sym_integral_type] = STATE(200),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(200),
    [sym_annotation] = STATE(902),
    [sym_array_type] = STATE(200),
    [sym_modifiers] = STATE(202),
    [sym_marker_annotation] = STATE(902),
    [anon_sym_default] = ACTIONS(126),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [sym_void_type] = ACTIONS(397),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(397),
    [anon_sym_int] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
  },
  [79] = {
    [sym_floating_point_type] = STATE(203),
    [sym__annotation] = STATE(137),
    [sym_array_type] = STATE(203),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_marker_annotation] = STATE(137),
    [sym_integral_type] = STATE(203),
    [sym_annotation] = STATE(137),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(203),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(401),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(41),
    [sym_void_type] = ACTIONS(401),
  },
  [80] = {
    [sym__annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(207),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym_identifier] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_COLON_COLON] = ACTIONS(245),
    [anon_sym_AMP] = ACTIONS(245),
    [anon_sym_RPAREN] = ACTIONS(245),
    [anon_sym_module] = ACTIONS(405),
    [anon_sym_open] = ACTIONS(405),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(407),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(409),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [81] = {
    [aux_sym_cast_expression_repeat1] = STATE(210),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(411),
    [anon_sym_RPAREN] = ACTIONS(413),
    [anon_sym_COLON_COLON] = ACTIONS(138),
  },
  [82] = {
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_RPAREN] = ACTIONS(415),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(293),
  },
  [83] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_floating_point_type] = STATE(213),
    [sym_annotation] = STATE(902),
    [sym_formal_parameter] = STATE(214),
    [sym_array_type] = STATE(213),
    [sym__annotation] = STATE(902),
    [sym_spread_parameter] = STATE(201),
    [sym_marker_annotation] = STATE(902),
    [sym_modifiers] = STATE(84),
    [sym__unannotated_type] = STATE(213),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_generic_type] = STATE(53),
    [sym_integral_type] = STATE(213),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_protected] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_char] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(126),
    [sym_void_type] = ACTIONS(417),
    [sym_boolean_type] = ACTIONS(417),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(419),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
  },
  [84] = {
    [sym__unannotated_type] = STATE(215),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_generic_type] = STATE(53),
    [sym_integral_type] = STATE(215),
    [sym_floating_point_type] = STATE(215),
    [sym_array_type] = STATE(215),
    [anon_sym_float] = ACTIONS(41),
    [sym_identifier] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_void_type] = ACTIONS(421),
    [anon_sym_char] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(421),
    [anon_sym_short] = ACTIONS(33),
  },
  [85] = {
    [sym_integral_type] = STATE(200),
    [sym_array_type] = STATE(200),
    [sym_annotation] = STATE(902),
    [sym__unannotated_type] = STATE(200),
    [sym_spread_parameter] = STATE(201),
    [sym_marker_annotation] = STATE(902),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_generic_type] = STATE(53),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__annotation] = STATE(902),
    [sym_floating_point_type] = STATE(200),
    [aux_sym_formal_parameters_repeat1] = STATE(217),
    [sym_modifiers] = STATE(202),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_native] = ACTIONS(126),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_float] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(397),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_final] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_short] = ACTIONS(33),
    [sym_void_type] = ACTIONS(397),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
  },
  [86] = {
    [anon_sym_RPAREN] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_class_literal] = STATE(43),
    [sym_update_expression] = STATE(82),
    [sym_array_type] = STATE(73),
    [sym__primary_no_new_array] = STATE(43),
    [sym_assignment_expression] = STATE(82),
    [sym_unary_expression] = STATE(82),
    [sym_formal_parameters] = STATE(42),
    [sym_lambda_expression] = STATE(82),
    [sym_scoped_identifier] = STATE(52),
    [sym_integral_type] = STATE(30),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_array_creation_expression] = STATE(41),
    [sym_binary_expression] = STATE(82),
    [sym__literal] = STATE(43),
    [sym_instanceof_expression] = STATE(82),
    [sym_object_creation_expression] = STATE(43),
    [sym_annotation] = STATE(74),
    [sym_method_invocation] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__primary] = STATE(41),
    [sym_array_access] = STATE(39),
    [sym__type] = STATE(37),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_parenthesized_expression] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_ternary_expression] = STATE(82),
    [sym__unannotated_type] = STATE(73),
    [sym_annotated_type] = STATE(37),
    [sym_generic_type] = STATE(53),
    [sym__annotation] = STATE(74),
    [sym__expression] = STATE(82),
    [sym_cast_expression] = STATE(82),
    [sym_method_reference] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym_floating_point_type] = STATE(30),
    [sym_true] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_void_type] = ACTIONS(55),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_module] = ACTIONS(120),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(79),
    [sym_character_literal] = ACTIONS(35),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [sym_false] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_short] = ACTIONS(33),
  },
  [88] = {
    [sym_normal_interface_declaration] = STATE(45),
    [sym__primary] = STATE(41),
    [sym_enum_declaration] = STATE(218),
    [sym_do_statement] = STATE(218),
    [sym__unannotated_type] = STATE(40),
    [sym_try_statement] = STATE(218),
    [sym_update_expression] = STATE(49),
    [sym_lambda_expression] = STATE(49),
    [sym_parenthesized_expression] = STATE(43),
    [sym_if_statement] = STATE(218),
    [sym_instanceof_expression] = STATE(49),
    [sym__primary_no_new_array] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym_switch_statement] = STATE(218),
    [sym_annotated_type] = STATE(37),
    [sym_annotation] = STATE(51),
    [sym_unary_expression] = STATE(49),
    [sym_for_statement] = STATE(218),
    [sym_throw_statement] = STATE(218),
    [sym_field_access] = STATE(39),
    [sym_scoped_identifier] = STATE(52),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_annotation_type_declaration] = STATE(45),
    [sym__annotation] = STATE(51),
    [sym_modifiers] = STATE(48),
    [sym__declaration] = STATE(218),
    [sym_synchronized_statement] = STATE(218),
    [sym__expression] = STATE(49),
    [sym_try_with_resources_statement] = STATE(218),
    [sym_assignment_expression] = STATE(49),
    [sym_labeled_statement] = STATE(218),
    [sym_class_literal] = STATE(43),
    [sym_array_type] = STATE(40),
    [sym_formal_parameters] = STATE(42),
    [sym_enhanced_for_statement] = STATE(218),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_return_statement] = STATE(218),
    [sym_interface_declaration] = STATE(218),
    [sym__literal] = STATE(43),
    [sym_cast_expression] = STATE(49),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_inferred_parameters] = STATE(42),
    [sym_floating_point_type] = STATE(30),
    [sym_binary_expression] = STATE(49),
    [sym_continue_statement] = STATE(218),
    [sym_block] = STATE(218),
    [sym_generic_type] = STATE(53),
    [sym_while_statement] = STATE(218),
    [sym_local_variable_declaration_statement] = STATE(218),
    [sym_array_access] = STATE(39),
    [sym_assert_statement] = STATE(218),
    [sym_expression_statement] = STATE(218),
    [sym_class_declaration] = STATE(218),
    [sym_import_declaration] = STATE(218),
    [sym_module_declaration] = STATE(218),
    [sym_method_invocation] = STATE(43),
    [sym_package_declaration] = STATE(218),
    [sym_local_variable_declaration] = STATE(47),
    [sym_break_statement] = STATE(218),
    [sym_object_creation_expression] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_ternary_expression] = STATE(49),
    [sym_array_creation_expression] = STATE(41),
    [sym__type] = STATE(37),
    [sym_marker_annotation] = STATE(51),
    [sym_integral_type] = STATE(30),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_SEMI] = ACTIONS(425),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_enum] = ACTIONS(67),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_module] = ACTIONS(21),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_while] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(31),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_protected] = ACTIONS(7),
    [sym_false] = ACTIONS(5),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_throw] = ACTIONS(27),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_super] = ACTIONS(9),
    [sym_true] = ACTIONS(5),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_default] = ACTIONS(7),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(7),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(13),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_switch] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_do] = ACTIONS(45),
    [sym_this] = ACTIONS(5),
    [anon_sym_return] = ACTIONS(57),
    [sym_comment] = ACTIONS(3),
    [anon_sym_abstract] = ACTIONS(7),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_DASH_DASH] = ACTIONS(15),
  },
  [89] = {
    [sym_type_arguments] = STATE(186),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(146),
    [sym_identifier] = ACTIONS(427),
  },
  [90] = {
    [sym_annotation] = STATE(51),
    [sym__primary] = STATE(41),
    [sym_expression_statement] = STATE(220),
    [sym_binary_expression] = STATE(49),
    [sym_parenthesized_expression] = STATE(43),
    [sym_local_variable_declaration] = STATE(47),
    [sym_class_declaration] = STATE(220),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_import_declaration] = STATE(220),
    [sym_enhanced_for_statement] = STATE(220),
    [sym_enum_declaration] = STATE(220),
    [sym_field_access] = STATE(39),
    [sym__expression] = STATE(49),
    [sym_array_type] = STATE(40),
    [sym_synchronized_statement] = STATE(220),
    [sym_if_statement] = STATE(220),
    [sym__declaration] = STATE(220),
    [sym__annotation] = STATE(51),
    [sym_floating_point_type] = STATE(30),
    [sym_method_invocation] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_try_statement] = STATE(220),
    [sym_module_declaration] = STATE(220),
    [sym__primary_no_new_array] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_continue_statement] = STATE(220),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_labeled_statement] = STATE(220),
    [sym_class_literal] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym_try_with_resources_statement] = STATE(220),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_return_statement] = STATE(220),
    [sym_scoped_identifier] = STATE(52),
    [sym_object_creation_expression] = STATE(43),
    [sym_unary_expression] = STATE(49),
    [sym_instanceof_expression] = STATE(49),
    [sym_method_reference] = STATE(43),
    [sym_throw_statement] = STATE(220),
    [sym_for_statement] = STATE(220),
    [sym_ternary_expression] = STATE(49),
    [sym_while_statement] = STATE(220),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_formal_parameters] = STATE(42),
    [sym_do_statement] = STATE(220),
    [sym_lambda_expression] = STATE(49),
    [sym_array_access] = STATE(39),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_assert_statement] = STATE(220),
    [sym_break_statement] = STATE(220),
    [sym_switch_statement] = STATE(220),
    [sym__type] = STATE(37),
    [sym_block] = STATE(220),
    [sym__unannotated_type] = STATE(40),
    [sym_cast_expression] = STATE(49),
    [sym_update_expression] = STATE(49),
    [sym_local_variable_declaration_statement] = STATE(220),
    [sym_array_creation_expression] = STATE(41),
    [sym_modifiers] = STATE(48),
    [sym_marker_annotation] = STATE(51),
    [sym_interface_declaration] = STATE(220),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_annotated_type] = STATE(37),
    [sym_package_declaration] = STATE(220),
    [sym_inferred_parameters] = STATE(42),
    [sym_assignment_expression] = STATE(49),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_static] = ACTIONS(7),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_false] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(429),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(19),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(57),
    [sym_super] = ACTIONS(9),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_synchronized] = ACTIONS(71),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(31),
    [sym_boolean_type] = ACTIONS(79),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_final] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_true] = ACTIONS(5),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_protected] = ACTIONS(7),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_this] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(7),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
  },
  [91] = {
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_PIPE] = ACTIONS(291),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_COLON] = ACTIONS(431),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_SEMI] = ACTIONS(433),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(295),
  },
  [92] = {
    [sym_type_parameters] = STATE(227),
    [sym_super_interfaces] = STATE(228),
    [sym_superclass] = STATE(229),
    [sym_class_body] = STATE(230),
    [anon_sym_extends] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(437),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_implements] = ACTIONS(441),
  },
  [93] = {
    [sym_type_parameters] = STATE(233),
    [sym_extends_interfaces] = STATE(235),
    [sym_interface_body] = STATE(234),
    [anon_sym_LBRACE] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
    [anon_sym_extends] = ACTIONS(445),
    [anon_sym_LT] = ACTIONS(437),
  },
  [94] = {
    [sym_dimensions_expr] = STATE(241),
    [sym_argument_list] = STATE(239),
    [sym__annotation] = STATE(240),
    [aux_sym_array_creation_expression_repeat1] = STATE(241),
    [sym_marker_annotation] = STATE(240),
    [sym_dimensions] = STATE(238),
    [sym_annotation] = STATE(240),
    [aux_sym_dimensions_expr_repeat1] = STATE(240),
    [sym_type_arguments] = STATE(64),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [anon_sym_DOT] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LT] = ACTIONS(146),
  },
  [95] = {
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_marker_annotation] = STATE(240),
    [sym_dimensions_expr] = STATE(244),
    [sym__annotation] = STATE(240),
    [sym_dimensions] = STATE(242),
    [sym_argument_list] = STATE(243),
    [aux_sym_array_creation_expression_repeat1] = STATE(244),
    [aux_sym_dimensions_expr_repeat1] = STATE(240),
    [sym_annotation] = STATE(240),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(449),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(112),
  },
  [96] = {
    [sym_dimensions_expr] = STATE(244),
    [sym_argument_list] = STATE(243),
    [sym_dimensions] = STATE(242),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(240),
    [sym_annotation] = STATE(240),
    [aux_sym_dimensions_expr_repeat1] = STATE(240),
    [sym_marker_annotation] = STATE(240),
    [aux_sym_array_creation_expression_repeat1] = STATE(244),
    [anon_sym_LBRACK] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_DOT] = ACTIONS(451),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_type_arguments] = STATE(132),
    [sym_dimensions] = STATE(242),
    [sym_marker_annotation] = STATE(240),
    [sym_dimensions_expr] = STATE(244),
    [sym_argument_list] = STATE(243),
    [aux_sym_array_creation_expression_repeat1] = STATE(244),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(240),
    [aux_sym_dimensions_expr_repeat1] = STATE(240),
    [sym_annotation] = STATE(240),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(112),
  },
  [98] = {
    [sym_integral_type] = STATE(245),
    [sym_generic_type] = STATE(248),
    [sym_scoped_type_identifier] = STATE(247),
    [sym_floating_point_type] = STATE(245),
    [sym_void_type] = ACTIONS(453),
    [anon_sym_byte] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(453),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
  },
  [99] = {
    [sym_switch_block] = STATE(250),
    [anon_sym_LBRACE] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_PIPE] = ACTIONS(380),
    [anon_sym_LT_EQ] = ACTIONS(382),
    [anon_sym_RBRACK] = ACTIONS(382),
    [anon_sym_PIPE_PIPE] = ACTIONS(382),
    [anon_sym_PERCENT] = ACTIONS(382),
    [anon_sym_GT_GT] = ACTIONS(380),
    [anon_sym_STAR] = ACTIONS(382),
    [anon_sym_SEMI] = ACTIONS(382),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP_AMP] = ACTIONS(382),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(382),
    [anon_sym_COLON] = ACTIONS(382),
    [anon_sym_RBRACE] = ACTIONS(382),
    [anon_sym_instanceof] = ACTIONS(382),
    [anon_sym_AMP] = ACTIONS(380),
    [anon_sym_RPAREN] = ACTIONS(382),
    [anon_sym_GT_EQ] = ACTIONS(382),
    [anon_sym_CARET] = ACTIONS(382),
    [anon_sym_SLASH] = ACTIONS(380),
    [anon_sym_COMMA] = ACTIONS(382),
    [anon_sym_BANG_EQ] = ACTIONS(382),
    [anon_sym_QMARK] = ACTIONS(382),
    [anon_sym_PLUS] = ACTIONS(380),
    [anon_sym_EQ_EQ] = ACTIONS(382),
    [anon_sym_DASH] = ACTIONS(380),
    [anon_sym_GT_GT_GT] = ACTIONS(382),
    [anon_sym_GT] = ACTIONS(380),
    [anon_sym_LT] = ACTIONS(380),
  },
  [101] = {
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_import] = ACTIONS(459),
    [anon_sym_LT] = ACTIONS(459),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_LPAREN] = ACTIONS(461),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_public] = ACTIONS(459),
    [anon_sym_else] = ACTIONS(459),
    [anon_sym_transient] = ACTIONS(459),
    [anon_sym_PERCENT] = ACTIONS(461),
    [sym_character_literal] = ACTIONS(461),
    [anon_sym_LT_LT] = ACTIONS(461),
    [anon_sym_private] = ACTIONS(459),
    [anon_sym_double] = ACTIONS(459),
    [anon_sym_do] = ACTIONS(459),
    [anon_sym_STAR] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_char] = ACTIONS(459),
    [sym_octal_integer_literal] = ACTIONS(461),
    [anon_sym_case] = ACTIONS(459),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_GT_GT] = ACTIONS(459),
    [sym_decimal_integer_literal] = ACTIONS(459),
    [sym_boolean_type] = ACTIONS(459),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_continue] = ACTIONS(459),
    [sym_null_literal] = ACTIONS(459),
    [anon_sym_ATinterface] = ACTIONS(461),
    [anon_sym_throw] = ACTIONS(459),
    [anon_sym_switch] = ACTIONS(459),
    [sym_false] = ACTIONS(459),
    [anon_sym_static] = ACTIONS(459),
    [anon_sym_RPAREN] = ACTIONS(461),
    [anon_sym_LBRACE] = ACTIONS(461),
    [anon_sym_return] = ACTIONS(459),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_instanceof] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_assert] = ACTIONS(459),
    [anon_sym_AMP] = ACTIONS(459),
    [sym_this] = ACTIONS(459),
    [anon_sym_GT_GT_GT] = ACTIONS(461),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_int] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_binary_integer_literal] = ACTIONS(461),
    [anon_sym_float] = ACTIONS(459),
    [sym_true] = ACTIONS(459),
    [anon_sym_RBRACE] = ACTIONS(461),
    [anon_sym_open] = ACTIONS(459),
    [anon_sym_enum] = ACTIONS(459),
    [sym_void_type] = ACTIONS(459),
    [anon_sym_final] = ACTIONS(459),
    [sym_super] = ACTIONS(459),
    [sym_hex_floating_point_literal] = ACTIONS(459),
    [anon_sym_SLASH] = ACTIONS(459),
    [anon_sym_byte] = ACTIONS(459),
    [anon_sym_default] = ACTIONS(459),
    [anon_sym_class] = ACTIONS(459),
    [anon_sym_synchronized] = ACTIONS(459),
    [anon_sym_short] = ACTIONS(459),
    [anon_sym_RBRACK] = ACTIONS(461),
    [anon_sym_volatile] = ACTIONS(459),
    [anon_sym_GT] = ACTIONS(459),
    [anon_sym_CARET] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(459),
    [anon_sym_protected] = ACTIONS(459),
    [anon_sym_COMMA] = ACTIONS(461),
    [anon_sym_interface] = ACTIONS(459),
    [sym_decimal_floating_point_literal] = ACTIONS(461),
    [anon_sym_TILDE] = ACTIONS(461),
    [anon_sym_strictfp] = ACTIONS(459),
    [anon_sym_PIPE] = ACTIONS(459),
    [anon_sym_AT] = ACTIONS(459),
    [sym_hex_integer_literal] = ACTIONS(459),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(459),
    [anon_sym_try] = ACTIONS(459),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_long] = ACTIONS(459),
    [anon_sym_package] = ACTIONS(459),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_abstract] = ACTIONS(459),
    [anon_sym_break] = ACTIONS(459),
    [anon_sym_native] = ACTIONS(459),
    [anon_sym_while] = ACTIONS(459),
    [sym_identifier] = ACTIONS(459),
    [sym_string_literal] = ACTIONS(461),
    [ts_builtin_sym_end] = ACTIONS(461),
    [anon_sym_COLON] = ACTIONS(461),
    [anon_sym_SEMI] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_module] = ACTIONS(459),
  },
  [102] = {
    [sym__unannotated_type] = STATE(40),
    [sym_local_variable_declaration_statement] = STATE(130),
    [sym__expression] = STATE(49),
    [sym__declaration] = STATE(130),
    [sym_generic_type] = STATE(53),
    [sym_field_access] = STATE(39),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__primary_no_new_array] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_lambda_expression] = STATE(49),
    [sym_module_declaration] = STATE(130),
    [sym_scoped_identifier] = STATE(52),
    [sym_modifiers] = STATE(48),
    [sym_enum_declaration] = STATE(130),
    [sym_annotation] = STATE(51),
    [sym_return_statement] = STATE(130),
    [sym_break_statement] = STATE(130),
    [sym_assert_statement] = STATE(130),
    [sym_do_statement] = STATE(130),
    [sym_inferred_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(51),
    [sym_array_access] = STATE(39),
    [sym_throw_statement] = STATE(130),
    [sym_try_statement] = STATE(130),
    [sym_method_reference] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_if_statement] = STATE(130),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__annotation] = STATE(51),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_synchronized_statement] = STATE(130),
    [sym_import_declaration] = STATE(130),
    [sym_unary_expression] = STATE(49),
    [sym__literal] = STATE(43),
    [sym_assignment_expression] = STATE(49),
    [sym_continue_statement] = STATE(130),
    [sym_local_variable_declaration] = STATE(47),
    [sym_labeled_statement] = STATE(130),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_expression_statement] = STATE(130),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [aux_sym_program_repeat1] = STATE(130),
    [sym_ternary_expression] = STATE(49),
    [sym_update_expression] = STATE(49),
    [sym_object_creation_expression] = STATE(43),
    [sym_block] = STATE(130),
    [sym_integral_type] = STATE(30),
    [sym_annotated_type] = STATE(37),
    [sym_try_with_resources_statement] = STATE(130),
    [sym_class_declaration] = STATE(130),
    [sym_for_statement] = STATE(130),
    [sym_class_literal] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_instanceof_expression] = STATE(49),
    [sym_while_statement] = STATE(130),
    [sym_interface_declaration] = STATE(130),
    [sym_switch_statement] = STATE(130),
    [sym_cast_expression] = STATE(49),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_array_type] = STATE(40),
    [sym_formal_parameters] = STATE(42),
    [sym__type] = STATE(37),
    [sym_package_declaration] = STATE(130),
    [sym_binary_expression] = STATE(49),
    [sym_enhanced_for_statement] = STATE(130),
    [sym_method_invocation] = STATE(43),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_continue] = ACTIONS(73),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(63),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_static] = ACTIONS(7),
    [sym_super] = ACTIONS(9),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_do] = ACTIONS(45),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_RBRACE] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(223),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_default] = ACTIONS(7),
    [sym_this] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_ATinterface] = ACTIONS(59),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_true] = ACTIONS(5),
    [anon_sym_native] = ACTIONS(7),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_char] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_return] = ACTIONS(57),
    [sym_false] = ACTIONS(5),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_void_type] = ACTIONS(55),
  },
  [103] = {
    [anon_sym_class] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_identifier] = ACTIONS(467),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [aux_sym_import_declaration_repeat1] = STATE(255),
    [anon_sym_DOT] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(471),
  },
  [106] = {
    [sym_annotation_argument_list] = STATE(257),
    [anon_sym_protected] = ACTIONS(473),
    [anon_sym_module] = ACTIONS(473),
    [anon_sym_native] = ACTIONS(473),
    [anon_sym_interface] = ACTIONS(473),
    [anon_sym_enum] = ACTIONS(473),
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_double] = ACTIONS(473),
    [anon_sym_short] = ACTIONS(473),
    [sym_void_type] = ACTIONS(473),
    [anon_sym_class] = ACTIONS(473),
    [anon_sym_package] = ACTIONS(473),
    [anon_sym_int] = ACTIONS(473),
    [anon_sym_float] = ACTIONS(473),
    [anon_sym_char] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_open] = ACTIONS(473),
    [sym_boolean_type] = ACTIONS(473),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_long] = ACTIONS(473),
    [anon_sym_transient] = ACTIONS(473),
    [anon_sym_ATinterface] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
    [anon_sym_abstract] = ACTIONS(473),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_byte] = ACTIONS(473),
    [anon_sym_volatile] = ACTIONS(473),
    [anon_sym_strictfp] = ACTIONS(473),
    [anon_sym_AT] = ACTIONS(473),
    [anon_sym_LT] = ACTIONS(477),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_synchronized] = ACTIONS(473),
    [anon_sym_private] = ACTIONS(473),
    [anon_sym_final] = ACTIONS(473),
    [anon_sym_public] = ACTIONS(473),
  },
  [107] = {
    [anon_sym_DOT] = ACTIONS(368),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_null_literal] = ACTIONS(479),
    [anon_sym_long] = ACTIONS(479),
    [anon_sym_ATinterface] = ACTIONS(481),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_short] = ACTIONS(479),
    [sym_character_literal] = ACTIONS(481),
    [sym_true] = ACTIONS(479),
    [anon_sym_LPAREN] = ACTIONS(481),
    [anon_sym_else] = ACTIONS(479),
    [sym_false] = ACTIONS(479),
    [anon_sym_byte] = ACTIONS(479),
    [anon_sym_module] = ACTIONS(479),
    [sym_octal_integer_literal] = ACTIONS(481),
    [anon_sym_open] = ACTIONS(479),
    [anon_sym_public] = ACTIONS(479),
    [ts_builtin_sym_end] = ACTIONS(481),
    [sym_decimal_integer_literal] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_DASH_DASH] = ACTIONS(481),
    [anon_sym_class] = ACTIONS(479),
    [anon_sym_try] = ACTIONS(479),
    [anon_sym_native] = ACTIONS(479),
    [anon_sym_while] = ACTIONS(479),
    [anon_sym_switch] = ACTIONS(479),
    [anon_sym_do] = ACTIONS(479),
    [anon_sym_package] = ACTIONS(479),
    [anon_sym_assert] = ACTIONS(479),
    [anon_sym_default] = ACTIONS(479),
    [sym_decimal_floating_point_literal] = ACTIONS(481),
    [anon_sym_transient] = ACTIONS(479),
    [anon_sym_double] = ACTIONS(479),
    [anon_sym_char] = ACTIONS(479),
    [anon_sym_strictfp] = ACTIONS(479),
    [anon_sym_throw] = ACTIONS(479),
    [anon_sym_volatile] = ACTIONS(479),
    [anon_sym_float] = ACTIONS(479),
    [anon_sym_return] = ACTIONS(479),
    [anon_sym_LBRACE] = ACTIONS(481),
    [sym_void_type] = ACTIONS(479),
    [sym_string_literal] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(481),
    [anon_sym_for] = ACTIONS(479),
    [sym_super] = ACTIONS(479),
    [anon_sym_AT] = ACTIONS(479),
    [anon_sym_case] = ACTIONS(479),
    [anon_sym_break] = ACTIONS(479),
    [anon_sym_enum] = ACTIONS(479),
    [anon_sym_protected] = ACTIONS(479),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_continue] = ACTIONS(479),
    [anon_sym_int] = ACTIONS(479),
    [anon_sym_SEMI] = ACTIONS(481),
    [sym_hex_floating_point_literal] = ACTIONS(479),
    [sym_hex_integer_literal] = ACTIONS(479),
    [sym_binary_integer_literal] = ACTIONS(481),
    [anon_sym_new] = ACTIONS(479),
    [anon_sym_abstract] = ACTIONS(479),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_if] = ACTIONS(479),
    [sym_boolean_type] = ACTIONS(479),
    [anon_sym_interface] = ACTIONS(479),
    [anon_sym_synchronized] = ACTIONS(479),
    [anon_sym_private] = ACTIONS(479),
    [anon_sym_PLUS_PLUS] = ACTIONS(481),
    [sym_this] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(481),
    [anon_sym_import] = ACTIONS(479),
    [anon_sym_final] = ACTIONS(479),
    [sym_identifier] = ACTIONS(479),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [anon_sym_SEMI] = ACTIONS(483),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [anon_sym_LT] = ACTIONS(485),
    [anon_sym_COMMA] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(485),
    [anon_sym_BANG_EQ] = ACTIONS(487),
    [anon_sym_QMARK] = ACTIONS(487),
    [anon_sym_DASH_DASH] = ACTIONS(487),
    [anon_sym_AMP] = ACTIONS(485),
    [anon_sym_AMP_AMP] = ACTIONS(487),
    [anon_sym_STAR] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(487),
    [anon_sym_RBRACK] = ACTIONS(487),
    [anon_sym_SEMI] = ACTIONS(487),
    [anon_sym_PERCENT] = ACTIONS(487),
    [anon_sym_LT_EQ] = ACTIONS(487),
    [anon_sym_GT_EQ] = ACTIONS(487),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_GT_GT] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_GT_GT_GT] = ACTIONS(487),
    [anon_sym_RPAREN] = ACTIONS(487),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(487),
    [anon_sym_instanceof] = ACTIONS(487),
    [anon_sym_EQ_EQ] = ACTIONS(487),
    [anon_sym_COLON] = ACTIONS(487),
    [anon_sym_PIPE] = ACTIONS(485),
    [anon_sym_CARET] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(485),
    [anon_sym_PIPE_PIPE] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_while] = ACTIONS(489),
  },
  [112] = {
    [sym_annotation_type_body] = STATE(261),
    [anon_sym_LBRACE] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_SEMI] = ACTIONS(493),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
  },
  [114] = {
    [sym_update_expression] = STATE(268),
    [sym_field_access] = STATE(39),
    [sym_modifiers] = STATE(265),
    [sym__literal] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_cast_expression] = STATE(268),
    [sym_array_type] = STATE(266),
    [sym_formal_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(903),
    [sym_object_creation_expression] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_array_access] = STATE(39),
    [sym_unary_expression] = STATE(268),
    [sym_instanceof_expression] = STATE(268),
    [sym_local_variable_declaration] = STATE(267),
    [sym_annotation] = STATE(903),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym__unannotated_type] = STATE(266),
    [sym_scoped_identifier] = STATE(52),
    [sym_inferred_parameters] = STATE(42),
    [sym_for_init] = STATE(264),
    [sym_floating_point_type] = STATE(30),
    [sym_lambda_expression] = STATE(268),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_annotated_type] = STATE(37),
    [sym__expression] = STATE(268),
    [sym_method_invocation] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_class_literal] = STATE(43),
    [sym_ternary_expression] = STATE(268),
    [sym_assignment_expression] = STATE(268),
    [sym_integral_type] = STATE(30),
    [sym_array_creation_expression] = STATE(41),
    [sym_method_reference] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__annotation] = STATE(903),
    [sym__type] = STATE(37),
    [sym_generic_type] = STATE(53),
    [sym_binary_expression] = STATE(268),
    [sym_comment] = ACTIONS(3),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_static] = ACTIONS(126),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(495),
    [sym_true] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_final] = ACTIONS(126),
    [sym_string_literal] = ACTIONS(35),
    [sym_boolean_type] = ACTIONS(79),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_long] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_new] = ACTIONS(19),
    [sym_super] = ACTIONS(9),
    [anon_sym_volatile] = ACTIONS(126),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_module] = ACTIONS(120),
    [sym_decimal_integer_literal] = ACTIONS(5),
  },
  [115] = {
    [sym_super_interfaces] = STATE(270),
    [sym_comment] = ACTIONS(3),
    [anon_sym_implements] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(497),
  },
  [116] = {
    [sym_ternary_expression] = STATE(271),
    [sym_class_literal] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym_object_creation_expression] = STATE(43),
    [sym_assignment_expression] = STATE(271),
    [sym_inferred_parameters] = STATE(42),
    [sym_array_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym__primary_no_new_array] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_parenthesized_expression] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_binary_expression] = STATE(271),
    [sym_method_reference] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym__primary] = STATE(41),
    [sym_unary_expression] = STATE(271),
    [sym_update_expression] = STATE(271),
    [sym_floating_point_type] = STATE(30),
    [sym_integral_type] = STATE(30),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_array_creation_expression] = STATE(41),
    [sym__type] = STATE(37),
    [sym_lambda_expression] = STATE(271),
    [sym_instanceof_expression] = STATE(271),
    [sym__literal] = STATE(43),
    [sym_annotation] = STATE(74),
    [sym_formal_parameters] = STATE(42),
    [sym_array_access] = STATE(39),
    [sym_cast_expression] = STATE(271),
    [sym_annotated_type] = STATE(37),
    [sym__expression] = STATE(271),
    [sym_method_invocation] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_generic_type] = STATE(53),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_open] = ACTIONS(120),
    [sym_null_literal] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [sym_identifier] = ACTIONS(124),
    [sym_string_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
  },
  [117] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(340),
  },
  [118] = {
    [sym_array_creation_expression] = STATE(275),
    [sym__primary] = STATE(275),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_parenthesized_expression] = STATE(43),
    [sym_array_type] = STATE(274),
    [sym__annotation] = STATE(903),
    [sym__type] = STATE(37),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_resource] = STATE(278),
    [sym_marker_annotation] = STATE(903),
    [sym_class_literal] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_modifiers] = STATE(277),
    [sym_method_invocation] = STATE(43),
    [sym_annotation] = STATE(903),
    [sym_field_access] = STATE(279),
    [sym_method_reference] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_scoped_identifier] = STATE(276),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_object_creation_expression] = STATE(43),
    [sym_array_access] = STATE(43),
    [sym__unannotated_type] = STATE(274),
    [sym_floating_point_type] = STATE(30),
    [sym__literal] = STATE(43),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_integral_type] = STATE(30),
    [sym_annotated_type] = STATE(37),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_volatile] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [sym_super] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(499),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_module] = ACTIONS(501),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(134),
    [anon_sym_long] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(126),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(501),
    [anon_sym_float] = ACTIONS(41),
    [sym_true] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_final] = ACTIONS(126),
    [sym_null_literal] = ACTIONS(5),
  },
  [119] = {
    [sym_block] = STATE(280),
    [anon_sym_LBRACE] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [aux_sym_try_statement_repeat1] = STATE(284),
    [sym_finally_clause] = STATE(283),
    [sym_catch_clause] = STATE(284),
    [anon_sym_catch] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [sym_formal_parameters] = STATE(42),
    [sym_array_creation_expression] = STATE(41),
    [sym_assignment_expression] = STATE(285),
    [sym_array_access] = STATE(39),
    [sym_annotated_type] = STATE(37),
    [sym__literal] = STATE(43),
    [sym__expression] = STATE(285),
    [sym_annotation] = STATE(74),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_update_expression] = STATE(285),
    [sym_floating_point_type] = STATE(30),
    [sym__primary_no_new_array] = STATE(43),
    [sym_unary_expression] = STATE(285),
    [sym_generic_type] = STATE(53),
    [sym_field_access] = STATE(39),
    [sym_object_creation_expression] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_binary_expression] = STATE(285),
    [sym_class_literal] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym_ternary_expression] = STATE(285),
    [sym_cast_expression] = STATE(285),
    [sym__type] = STATE(37),
    [sym_scoped_identifier] = STATE(52),
    [sym_lambda_expression] = STATE(285),
    [sym_array_type] = STATE(73),
    [sym_method_reference] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__primary] = STATE(41),
    [sym_instanceof_expression] = STATE(285),
    [sym_method_invocation] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym_integral_type] = STATE(30),
    [sym__annotation] = STATE(74),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_this] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_string_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_true] = ACTIONS(5),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_super] = ACTIONS(9),
    [sym_false] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [sym_boolean_type] = ACTIONS(79),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_module] = ACTIONS(120),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_binary_integer_literal] = ACTIONS(35),
  },
  [122] = {
    [sym__unqualified_object_creation_expression] = STATE(291),
    [sym_type_arguments] = STATE(290),
    [anon_sym_class] = ACTIONS(509),
    [sym_identifier] = ACTIONS(511),
    [sym_super] = ACTIONS(513),
    [anon_sym_LT] = ACTIONS(146),
    [sym_this] = ACTIONS(515),
    [sym_comment] = ACTIONS(3),
    [anon_sym_new] = ACTIONS(346),
  },
  [123] = {
    [sym_integral_type] = STATE(30),
    [sym_ternary_expression] = STATE(292),
    [sym_generic_type] = STATE(53),
    [sym__annotation] = STATE(74),
    [sym__primary] = STATE(41),
    [sym_parenthesized_expression] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_assignment_expression] = STATE(292),
    [sym_array_type] = STATE(73),
    [sym__expression] = STATE(292),
    [sym_cast_expression] = STATE(292),
    [sym_instanceof_expression] = STATE(292),
    [sym_object_creation_expression] = STATE(43),
    [sym_class_literal] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_method_reference] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym_field_access] = STATE(39),
    [sym_lambda_expression] = STATE(292),
    [sym_update_expression] = STATE(292),
    [sym_marker_annotation] = STATE(74),
    [sym_formal_parameters] = STATE(42),
    [sym_unary_expression] = STATE(292),
    [sym_inferred_parameters] = STATE(42),
    [sym__literal] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_array_creation_expression] = STATE(41),
    [sym__unannotated_type] = STATE(73),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__type] = STATE(37),
    [sym_floating_point_type] = STATE(30),
    [sym_annotated_type] = STATE(37),
    [sym_binary_expression] = STATE(292),
    [sym_annotation] = STATE(74),
    [sym_array_access] = STATE(39),
    [anon_sym_int] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [sym_false] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(340),
    [sym_boolean_type] = ACTIONS(79),
    [sym_this] = ACTIONS(5),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_char] = ACTIONS(33),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_super] = ACTIONS(9),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_AT] = ACTIONS(118),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_true] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(47),
  },
  [124] = {
    [sym_type_arguments] = STATE(294),
    [sym_identifier] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
    [anon_sym_new] = ACTIONS(517),
  },
  [125] = {
    [sym_scoped_identifier] = STATE(295),
    [sym_identifier] = ACTIONS(519),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(521),
    [anon_sym_module] = ACTIONS(521),
  },
  [126] = {
    [aux_sym_class_literal_repeat1] = STATE(190),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(362),
    [anon_sym_DOT] = ACTIONS(523),
  },
  [127] = {
    [anon_sym_RBRACK] = ACTIONS(525),
    [anon_sym_GT] = ACTIONS(527),
    [anon_sym_LT] = ACTIONS(527),
    [anon_sym_CARET] = ACTIONS(525),
    [anon_sym_GT_GT] = ACTIONS(527),
    [anon_sym_GT_GT_GT] = ACTIONS(525),
    [anon_sym_RPAREN] = ACTIONS(525),
    [anon_sym_EQ_EQ] = ACTIONS(525),
    [anon_sym_PLUS_PLUS] = ACTIONS(525),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_BANG_EQ] = ACTIONS(525),
    [anon_sym_SLASH] = ACTIONS(527),
    [anon_sym_QMARK] = ACTIONS(525),
    [anon_sym_COLON_COLON] = ACTIONS(525),
    [anon_sym_PERCENT] = ACTIONS(525),
    [anon_sym_LT_LT] = ACTIONS(525),
    [anon_sym_COLON] = ACTIONS(527),
    [anon_sym_LT_EQ] = ACTIONS(525),
    [anon_sym_DOT] = ACTIONS(525),
    [anon_sym_GT_EQ] = ACTIONS(525),
    [anon_sym_AMP_AMP] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(527),
    [anon_sym_SEMI] = ACTIONS(525),
    [anon_sym_STAR] = ACTIONS(525),
    [anon_sym_DASH] = ACTIONS(527),
    [anon_sym_LBRACK] = ACTIONS(525),
    [anon_sym_instanceof] = ACTIONS(525),
    [anon_sym_PIPE_PIPE] = ACTIONS(525),
    [anon_sym_COMMA] = ACTIONS(525),
    [anon_sym_PIPE] = ACTIONS(527),
    [anon_sym_AMP] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(525),
  },
  [128] = {
    [anon_sym_LBRACE] = ACTIONS(529),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(368),
  },
  [129] = {
    [anon_sym_LBRACE] = ACTIONS(531),
    [anon_sym_DOT] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [sym_synchronized_statement] = STATE(130),
    [sym_floating_point_type] = STATE(30),
    [sym_throw_statement] = STATE(130),
    [sym_array_creation_expression] = STATE(41),
    [sym__primary_no_new_array] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym_annotation_type_declaration] = STATE(45),
    [sym__annotation] = STATE(51),
    [sym_enum_declaration] = STATE(130),
    [sym_do_statement] = STATE(130),
    [sym_block] = STATE(130),
    [sym_array_type] = STATE(40),
    [sym_class_literal] = STATE(43),
    [sym_switch_statement] = STATE(130),
    [sym_lambda_expression] = STATE(49),
    [sym_ternary_expression] = STATE(49),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym__unannotated_type] = STATE(40),
    [sym_method_reference] = STATE(43),
    [sym_expression_statement] = STATE(130),
    [sym__primary] = STATE(41),
    [sym_interface_declaration] = STATE(130),
    [sym__type] = STATE(37),
    [sym_package_declaration] = STATE(130),
    [sym_local_variable_declaration_statement] = STATE(130),
    [sym_assignment_expression] = STATE(49),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_modifiers] = STATE(48),
    [sym_if_statement] = STATE(130),
    [aux_sym_program_repeat1] = STATE(130),
    [sym_local_variable_declaration] = STATE(47),
    [sym_continue_statement] = STATE(130),
    [sym_import_declaration] = STATE(130),
    [sym_integral_type] = STATE(30),
    [sym_try_statement] = STATE(130),
    [sym_formal_parameters] = STATE(42),
    [sym__expression] = STATE(49),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_annotated_type] = STATE(37),
    [sym_assert_statement] = STATE(130),
    [sym_labeled_statement] = STATE(130),
    [sym_annotation] = STATE(51),
    [sym_cast_expression] = STATE(49),
    [sym_field_access] = STATE(39),
    [sym_enhanced_for_statement] = STATE(130),
    [sym_binary_expression] = STATE(49),
    [sym__declaration] = STATE(130),
    [sym_class_declaration] = STATE(130),
    [sym_parenthesized_expression] = STATE(43),
    [sym_break_statement] = STATE(130),
    [sym_try_with_resources_statement] = STATE(130),
    [sym_for_statement] = STATE(130),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_update_expression] = STATE(49),
    [sym_while_statement] = STATE(130),
    [sym_generic_type] = STATE(53),
    [sym_return_statement] = STATE(130),
    [sym_module_declaration] = STATE(130),
    [sym_instanceof_expression] = STATE(49),
    [sym_array_access] = STATE(39),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_method_invocation] = STATE(43),
    [sym_unary_expression] = STATE(49),
    [sym_inferred_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(51),
    [sym__literal] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [anon_sym_return] = ACTIONS(533),
    [sym_null_literal] = ACTIONS(536),
    [anon_sym_TILDE] = ACTIONS(539),
    [sym_string_literal] = ACTIONS(542),
    [anon_sym_try] = ACTIONS(545),
    [anon_sym_char] = ACTIONS(548),
    [anon_sym_for] = ACTIONS(551),
    [sym_decimal_integer_literal] = ACTIONS(536),
    [anon_sym_PLUS] = ACTIONS(554),
    [anon_sym_byte] = ACTIONS(548),
    [sym_boolean_type] = ACTIONS(557),
    [sym_octal_integer_literal] = ACTIONS(542),
    [anon_sym_DASH_DASH] = ACTIONS(560),
    [sym_identifier] = ACTIONS(563),
    [sym_comment] = ACTIONS(3),
    [anon_sym_protected] = ACTIONS(566),
    [anon_sym_open] = ACTIONS(569),
    [anon_sym_throw] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(566),
    [anon_sym_class] = ACTIONS(575),
    [anon_sym_short] = ACTIONS(548),
    [anon_sym_enum] = ACTIONS(578),
    [sym_void_type] = ACTIONS(581),
    [anon_sym_private] = ACTIONS(566),
    [sym_character_literal] = ACTIONS(542),
    [anon_sym_while] = ACTIONS(584),
    [sym_hex_integer_literal] = ACTIONS(536),
    [anon_sym_strictfp] = ACTIONS(566),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_default] = ACTIONS(566),
    [anon_sym_import] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(593),
    [sym_binary_integer_literal] = ACTIONS(542),
    [anon_sym_do] = ACTIONS(595),
    [sym_true] = ACTIONS(536),
    [anon_sym_DASH] = ACTIONS(554),
    [anon_sym_PLUS_PLUS] = ACTIONS(560),
    [anon_sym_module] = ACTIONS(598),
    [anon_sym_interface] = ACTIONS(601),
    [ts_builtin_sym_end] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(604),
    [sym_decimal_floating_point_literal] = ACTIONS(542),
    [anon_sym_long] = ACTIONS(548),
    [anon_sym_transient] = ACTIONS(566),
    [sym_super] = ACTIONS(607),
    [anon_sym_package] = ACTIONS(610),
    [anon_sym_final] = ACTIONS(566),
    [sym_this] = ACTIONS(536),
    [sym_false] = ACTIONS(536),
    [anon_sym_continue] = ACTIONS(613),
    [anon_sym_assert] = ACTIONS(616),
    [anon_sym_break] = ACTIONS(619),
    [anon_sym_BANG] = ACTIONS(539),
    [anon_sym_LPAREN] = ACTIONS(622),
    [anon_sym_volatile] = ACTIONS(566),
    [anon_sym_switch] = ACTIONS(625),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(566),
    [anon_sym_double] = ACTIONS(631),
    [anon_sym_native] = ACTIONS(566),
    [sym_hex_floating_point_literal] = ACTIONS(536),
    [anon_sym_float] = ACTIONS(631),
    [anon_sym_synchronized] = ACTIONS(634),
    [anon_sym_int] = ACTIONS(548),
    [anon_sym_if] = ACTIONS(637),
    [anon_sym_ATinterface] = ACTIONS(640),
    [anon_sym_AT] = ACTIONS(643),
    [anon_sym_static] = ACTIONS(566),
  },
  [131] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(301),
    [sym_annotation] = STATE(301),
    [sym_marker_annotation] = STATE(301),
    [sym__annotation] = STATE(301),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(646),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [anon_sym_open] = ACTIONS(648),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(650),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(650),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_implements] = ACTIONS(648),
    [sym_identifier] = ACTIONS(648),
    [anon_sym_DOT] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [anon_sym_COLON_COLON] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_module] = ACTIONS(648),
    [anon_sym_SEMI] = ACTIONS(650),
    [sym_this] = ACTIONS(648),
  },
  [133] = {
    [sym_type_arguments] = STATE(64),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_open] = ACTIONS(89),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_PIPE] = ACTIONS(105),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_LBRACE] = ACTIONS(105),
    [anon_sym_COLON_COLON] = ACTIONS(105),
    [anon_sym_implements] = ACTIONS(89),
    [sym_this] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(105),
    [anon_sym_GT] = ACTIONS(105),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(105),
    [anon_sym_module] = ACTIONS(89),
    [anon_sym_RPAREN] = ACTIONS(105),
  },
  [134] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(654),
  },
  [135] = {
    [sym_scoped_identifier] = STATE(304),
    [sym_identifier] = ACTIONS(656),
    [anon_sym_module] = ACTIONS(658),
    [anon_sym_open] = ACTIONS(658),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [sym_dimensions] = STATE(144),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [anon_sym_COLON_COLON] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACE] = ACTIONS(660),
    [anon_sym_COMMA] = ACTIONS(660),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_RPAREN] = ACTIONS(660),
    [anon_sym_SEMI] = ACTIONS(660),
    [anon_sym_GT] = ACTIONS(660),
    [anon_sym_AMP] = ACTIONS(660),
    [sym_comment] = ACTIONS(3),
    [anon_sym_implements] = ACTIONS(660),
  },
  [137] = {
    [sym_marker_annotation] = STATE(137),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym_annotation] = STATE(137),
    [sym__annotation] = STATE(137),
    [anon_sym_QMARK] = ACTIONS(662),
    [anon_sym_module] = ACTIONS(664),
    [anon_sym_double] = ACTIONS(664),
    [anon_sym_char] = ACTIONS(664),
    [sym_identifier] = ACTIONS(664),
    [anon_sym_long] = ACTIONS(664),
    [anon_sym_package] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(666),
    [sym_boolean_type] = ACTIONS(664),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(664),
    [anon_sym_byte] = ACTIONS(664),
    [sym_void_type] = ACTIONS(664),
    [anon_sym_LBRACK] = ACTIONS(662),
    [anon_sym_open] = ACTIONS(664),
    [anon_sym_int] = ACTIONS(664),
    [anon_sym_float] = ACTIONS(664),
  },
  [138] = {
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_dimensions] = STATE(305),
    [sym_annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_RPAREN] = ACTIONS(669),
    [anon_sym_COLON] = ACTIONS(669),
    [anon_sym_SEMI] = ACTIONS(669),
    [anon_sym_EQ] = ACTIONS(669),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(669),
    [anon_sym_AT] = ACTIONS(118),
  },
  [139] = {
    [anon_sym_RBRACK] = ACTIONS(671),
    [sym_comment] = ACTIONS(3),
  },
  [140] = {
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym_dimensions] = STATE(307),
    [anon_sym_COMMA] = ACTIONS(673),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(673),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_RPAREN] = ACTIONS(673),
    [anon_sym_COLON] = ACTIONS(673),
    [anon_sym_EQ] = ACTIONS(673),
  },
  [141] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(308),
    [anon_sym_long] = ACTIONS(675),
    [anon_sym_public] = ACTIONS(675),
    [sym_boolean_type] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_transient] = ACTIONS(675),
    [anon_sym_AMP] = ACTIONS(677),
    [anon_sym_EQ] = ACTIONS(677),
    [anon_sym_abstract] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_int] = ACTIONS(675),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_COMMA] = ACTIONS(677),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_short] = ACTIONS(675),
    [anon_sym_implements] = ACTIONS(675),
    [anon_sym_open] = ACTIONS(675),
    [anon_sym_RPAREN] = ACTIONS(677),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_byte] = ACTIONS(675),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(677),
    [anon_sym_final] = ACTIONS(675),
    [anon_sym_volatile] = ACTIONS(675),
    [anon_sym_double] = ACTIONS(675),
    [anon_sym_DOT] = ACTIONS(675),
    [anon_sym_COLON_COLON] = ACTIONS(677),
    [sym_identifier] = ACTIONS(675),
    [anon_sym_synchronized] = ACTIONS(675),
    [anon_sym_strictfp] = ACTIONS(675),
    [anon_sym_COLON] = ACTIONS(675),
    [anon_sym_GT] = ACTIONS(677),
    [anon_sym_SEMI] = ACTIONS(677),
    [sym_void_type] = ACTIONS(675),
    [sym_this] = ACTIONS(675),
    [anon_sym_default] = ACTIONS(675),
    [anon_sym_char] = ACTIONS(675),
    [anon_sym_private] = ACTIONS(675),
    [anon_sym_throws] = ACTIONS(675),
    [anon_sym_protected] = ACTIONS(675),
    [anon_sym_native] = ACTIONS(675),
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(675),
    [anon_sym_PIPE] = ACTIONS(677),
  },
  [142] = {
    [anon_sym_EQ] = ACTIONS(679),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(681),
    [anon_sym_SEMI] = ACTIONS(681),
    [anon_sym_COMMA] = ACTIONS(681),
  },
  [143] = {
    [aux_sym__variable_declarator_list_repeat1] = STATE(311),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(683),
    [anon_sym_COMMA] = ACTIONS(685),
  },
  [144] = {
    [anon_sym_COLON_COLON] = ACTIONS(687),
    [anon_sym_SEMI] = ACTIONS(687),
    [anon_sym_GT] = ACTIONS(687),
    [anon_sym_module] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(687),
    [sym_identifier] = ACTIONS(689),
    [anon_sym_RPAREN] = ACTIONS(687),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(687),
    [sym_this] = ACTIONS(689),
    [anon_sym_PIPE] = ACTIONS(687),
    [anon_sym_implements] = ACTIONS(689),
    [anon_sym_COMMA] = ACTIONS(687),
    [anon_sym_LBRACK] = ACTIONS(687),
    [anon_sym_open] = ACTIONS(689),
    [anon_sym_AMP] = ACTIONS(687),
    [anon_sym_LBRACE] = ACTIONS(687),
  },
  [145] = {
    [sym_marker_annotation] = STATE(137),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym__annotation] = STATE(137),
    [sym_annotation] = STATE(137),
    [anon_sym_LBRACK] = ACTIONS(691),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
  },
  [146] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(693),
  },
  [147] = {
    [sym_type_arguments] = STATE(186),
    [sym__unqualified_object_creation_expression] = STATE(185),
    [anon_sym_new] = ACTIONS(346),
    [sym_identifier] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(146),
  },
  [148] = {
    [sym_generic_type] = STATE(53),
    [sym_field_access] = STATE(39),
    [sym_integral_type] = STATE(30),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_inferred_parameters] = STATE(42),
    [sym_cast_expression] = STATE(176),
    [sym_scoped_identifier] = STATE(52),
    [sym_annotated_type] = STATE(37),
    [sym_floating_point_type] = STATE(30),
    [sym__literal] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(74),
    [sym_method_invocation] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym__type] = STATE(37),
    [sym_array_access] = STATE(39),
    [sym_ternary_expression] = STATE(176),
    [sym_class_literal] = STATE(43),
    [sym_lambda_expression] = STATE(176),
    [sym_object_creation_expression] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_array_type] = STATE(73),
    [sym__expression] = STATE(176),
    [sym_update_expression] = STATE(176),
    [sym_assignment_expression] = STATE(176),
    [sym_annotation] = STATE(74),
    [sym__primary_no_new_array] = STATE(43),
    [sym_binary_expression] = STATE(176),
    [sym_instanceof_expression] = STATE(176),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_unary_expression] = STATE(176),
    [sym__annotation] = STATE(74),
    [sym__primary] = STATE(41),
    [sym_true] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_double] = ACTIONS(41),
    [sym_character_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_this] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [sym_false] = ACTIONS(5),
  },
  [149] = {
    [sym_marker_annotation] = STATE(149),
    [sym_annotation] = STATE(149),
    [aux_sym_modifiers_repeat1] = STATE(149),
    [sym__annotation] = STATE(149),
    [anon_sym_static] = ACTIONS(697),
    [anon_sym_volatile] = ACTIONS(697),
    [anon_sym_native] = ACTIONS(697),
    [anon_sym_AT] = ACTIONS(700),
    [anon_sym_synchronized] = ACTIONS(697),
    [anon_sym_strictfp] = ACTIONS(697),
    [anon_sym_default] = ACTIONS(697),
    [anon_sym_class] = ACTIONS(703),
    [anon_sym_short] = ACTIONS(703),
    [anon_sym_private] = ACTIONS(697),
    [sym_void_type] = ACTIONS(703),
    [anon_sym_abstract] = ACTIONS(697),
    [anon_sym_int] = ACTIONS(703),
    [anon_sym_ATinterface] = ACTIONS(705),
    [anon_sym_protected] = ACTIONS(697),
    [anon_sym_char] = ACTIONS(703),
    [anon_sym_LT] = ACTIONS(705),
    [anon_sym_enum] = ACTIONS(703),
    [sym_comment] = ACTIONS(3),
    [anon_sym_byte] = ACTIONS(703),
    [sym_boolean_type] = ACTIONS(703),
    [anon_sym_public] = ACTIONS(697),
    [anon_sym_float] = ACTIONS(703),
    [anon_sym_interface] = ACTIONS(703),
    [anon_sym_long] = ACTIONS(703),
    [anon_sym_transient] = ACTIONS(697),
    [anon_sym_double] = ACTIONS(703),
    [sym_identifier] = ACTIONS(703),
    [anon_sym_final] = ACTIONS(697),
  },
  [150] = {
    [anon_sym_case] = ACTIONS(707),
    [anon_sym_RBRACE] = ACTIONS(709),
    [anon_sym_continue] = ACTIONS(707),
    [anon_sym_TILDE] = ACTIONS(709),
    [sym_octal_integer_literal] = ACTIONS(709),
    [anon_sym_double] = ACTIONS(707),
    [sym_hex_floating_point_literal] = ACTIONS(707),
    [anon_sym_ATinterface] = ACTIONS(709),
    [sym_binary_integer_literal] = ACTIONS(709),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_float] = ACTIONS(707),
    [anon_sym_PLUS] = ACTIONS(707),
    [anon_sym_return] = ACTIONS(707),
    [anon_sym_strictfp] = ACTIONS(707),
    [anon_sym_transient] = ACTIONS(707),
    [anon_sym_public] = ACTIONS(707),
    [anon_sym_open] = ACTIONS(707),
    [anon_sym_DASH_DASH] = ACTIONS(709),
    [ts_builtin_sym_end] = ACTIONS(709),
    [anon_sym_final] = ACTIONS(707),
    [sym_this] = ACTIONS(707),
    [sym_super] = ACTIONS(707),
    [sym_true] = ACTIONS(707),
    [sym_character_literal] = ACTIONS(709),
    [anon_sym_int] = ACTIONS(707),
    [anon_sym_try] = ACTIONS(707),
    [anon_sym_for] = ACTIONS(707),
    [anon_sym_AT] = ACTIONS(707),
    [anon_sym_byte] = ACTIONS(707),
    [anon_sym_assert] = ACTIONS(707),
    [anon_sym_break] = ACTIONS(707),
    [anon_sym_module] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(709),
    [anon_sym_enum] = ACTIONS(707),
    [anon_sym_do] = ACTIONS(707),
    [sym_identifier] = ACTIONS(707),
    [sym_hex_integer_literal] = ACTIONS(707),
    [anon_sym_PLUS_PLUS] = ACTIONS(709),
    [anon_sym_new] = ACTIONS(707),
    [anon_sym_throw] = ACTIONS(707),
    [anon_sym_protected] = ACTIONS(707),
    [anon_sym_short] = ACTIONS(707),
    [sym_boolean_type] = ACTIONS(707),
    [anon_sym_static] = ACTIONS(707),
    [anon_sym_char] = ACTIONS(707),
    [sym_decimal_integer_literal] = ACTIONS(707),
    [anon_sym_class] = ACTIONS(707),
    [anon_sym_package] = ACTIONS(707),
    [sym_void_type] = ACTIONS(707),
    [anon_sym_volatile] = ACTIONS(707),
    [anon_sym_else] = ACTIONS(707),
    [sym_string_literal] = ACTIONS(709),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_interface] = ACTIONS(707),
    [anon_sym_SEMI] = ACTIONS(709),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_switch] = ACTIONS(707),
    [anon_sym_import] = ACTIONS(707),
    [anon_sym_synchronized] = ACTIONS(707),
    [sym_comment] = ACTIONS(3),
    [anon_sym_default] = ACTIONS(707),
    [anon_sym_DASH] = ACTIONS(707),
    [anon_sym_long] = ACTIONS(707),
    [sym_false] = ACTIONS(707),
    [anon_sym_BANG] = ACTIONS(709),
    [anon_sym_private] = ACTIONS(707),
    [anon_sym_abstract] = ACTIONS(707),
    [anon_sym_native] = ACTIONS(707),
    [sym_decimal_floating_point_literal] = ACTIONS(709),
    [sym_null_literal] = ACTIONS(707),
  },
  [151] = {
    [sym_identifier] = ACTIONS(711),
    [sym_comment] = ACTIONS(3),
  },
  [152] = {
    [sym_identifier] = ACTIONS(713),
    [sym_comment] = ACTIONS(3),
  },
  [153] = {
    [sym_identifier] = ACTIONS(715),
    [sym_comment] = ACTIONS(3),
  },
  [154] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(717),
  },
  [155] = {
    [sym_annotation] = STATE(145),
    [sym__variable_declarator_list] = STATE(317),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym__variable_declarator_id] = STATE(142),
    [sym_variable_declarator] = STATE(143),
    [sym__annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(247),
    [anon_sym_open] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
  },
  [156] = {
    [sym_method_reference] = STATE(43),
    [sym_instanceof_expression] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assignment_expression] = STATE(318),
    [sym_marker_annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym__annotation] = STATE(74),
    [sym_lambda_expression] = STATE(318),
    [sym_field_access] = STATE(39),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_ternary_expression] = STATE(318),
    [sym_formal_parameters] = STATE(42),
    [sym__primary_no_new_array] = STATE(43),
    [sym__type] = STATE(37),
    [sym_generic_type] = STATE(53),
    [sym_annotation] = STATE(74),
    [sym_class_literal] = STATE(43),
    [sym_cast_expression] = STATE(318),
    [sym_array_access] = STATE(39),
    [sym_scoped_identifier] = STATE(52),
    [sym_array_creation_expression] = STATE(41),
    [sym_array_type] = STATE(73),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__primary] = STATE(41),
    [sym__unannotated_type] = STATE(73),
    [sym_parenthesized_expression] = STATE(43),
    [sym_unary_expression] = STATE(318),
    [sym_object_creation_expression] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_integral_type] = STATE(30),
    [sym_floating_point_type] = STATE(30),
    [sym__literal] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_update_expression] = STATE(318),
    [sym_binary_expression] = STATE(318),
    [sym_method_invocation] = STATE(43),
    [anon_sym_float] = ACTIONS(41),
    [sym_super] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_false] = ACTIONS(5),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [sym_void_type] = ACTIONS(55),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_double] = ACTIONS(41),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(120),
    [sym_boolean_type] = ACTIONS(79),
  },
  [157] = {
    [sym__annotation] = STATE(74),
    [sym_array_creation_expression] = STATE(41),
    [sym_assignment_expression] = STATE(319),
    [sym_scoped_identifier] = STATE(52),
    [sym_marker_annotation] = STATE(74),
    [sym_field_access] = STATE(39),
    [sym__primary_no_new_array] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_integral_type] = STATE(30),
    [sym_array_access] = STATE(39),
    [sym_annotation] = STATE(74),
    [sym_parenthesized_expression] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym_update_expression] = STATE(319),
    [sym_binary_expression] = STATE(319),
    [sym__expression] = STATE(319),
    [sym_generic_type] = STATE(53),
    [sym_ternary_expression] = STATE(319),
    [sym__primary] = STATE(41),
    [sym__unannotated_type] = STATE(73),
    [sym__type] = STATE(37),
    [sym_method_reference] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_cast_expression] = STATE(319),
    [sym_inferred_parameters] = STATE(42),
    [sym_lambda_expression] = STATE(319),
    [sym_floating_point_type] = STATE(30),
    [sym_class_literal] = STATE(43),
    [sym_instanceof_expression] = STATE(319),
    [sym_scoped_type_identifier] = STATE(36),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_unary_expression] = STATE(319),
    [sym_object_creation_expression] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__literal] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_open] = ACTIONS(120),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_character_literal] = ACTIONS(35),
    [sym_true] = ACTIONS(5),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(33),
    [sym_false] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_float] = ACTIONS(41),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
  },
  [158] = {
    [sym_annotation] = STATE(907),
    [sym_array_type] = STATE(906),
    [sym__unannotated_type] = STATE(906),
    [sym_annotated_type] = STATE(320),
    [sym__annotation] = STATE(907),
    [sym_marker_annotation] = STATE(907),
    [aux_sym_dimensions_expr_repeat1] = STATE(907),
    [sym__type] = STATE(320),
    [sym_integral_type] = STATE(906),
    [sym_generic_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(901),
    [sym_floating_point_type] = STATE(906),
    [anon_sym_double] = ACTIONS(719),
    [anon_sym_short] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_float] = ACTIONS(719),
    [anon_sym_long] = ACTIONS(721),
    [anon_sym_char] = ACTIONS(721),
    [anon_sym_byte] = ACTIONS(721),
    [sym_identifier] = ACTIONS(723),
    [sym_void_type] = ACTIONS(725),
    [anon_sym_int] = ACTIONS(721),
    [sym_boolean_type] = ACTIONS(725),
  },
  [159] = {
    [sym_object_creation_expression] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotation] = STATE(74),
    [sym_scoped_identifier] = STATE(52),
    [sym_inferred_parameters] = STATE(42),
    [sym_class_literal] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_assignment_expression] = STATE(321),
    [sym_method_invocation] = STATE(43),
    [sym_lambda_expression] = STATE(321),
    [sym_update_expression] = STATE(321),
    [sym__primary] = STATE(41),
    [sym_binary_expression] = STATE(321),
    [sym_method_reference] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym_ternary_expression] = STATE(321),
    [sym_generic_type] = STATE(53),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_annotated_type] = STATE(37),
    [sym__type] = STATE(37),
    [sym_unary_expression] = STATE(321),
    [sym__unannotated_type] = STATE(73),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_array_type] = STATE(73),
    [sym_instanceof_expression] = STATE(321),
    [sym_array_creation_expression] = STATE(41),
    [sym_cast_expression] = STATE(321),
    [sym_array_access] = STATE(39),
    [sym_field_access] = STATE(39),
    [sym__primary_no_new_array] = STATE(43),
    [sym__annotation] = STATE(74),
    [sym_floating_point_type] = STATE(30),
    [sym_parenthesized_expression] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym__expression] = STATE(321),
    [anon_sym_new] = ACTIONS(19),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_false] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_true] = ACTIONS(5),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_open] = ACTIONS(120),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_double] = ACTIONS(41),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_module] = ACTIONS(120),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [sym_boolean_type] = ACTIONS(79),
  },
  [160] = {
    [sym_scoped_identifier] = STATE(52),
    [sym_integral_type] = STATE(30),
    [sym_array_access] = STATE(39),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_parenthesized_expression] = STATE(43),
    [sym_generic_type] = STATE(53),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_formal_parameters] = STATE(42),
    [sym_lambda_expression] = STATE(322),
    [sym_instanceof_expression] = STATE(322),
    [sym_field_access] = STATE(39),
    [sym__primary] = STATE(41),
    [sym_update_expression] = STATE(322),
    [sym__primary_no_new_array] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym__annotation] = STATE(74),
    [sym_annotation] = STATE(74),
    [sym_class_literal] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_annotated_type] = STATE(37),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_binary_expression] = STATE(322),
    [sym_cast_expression] = STATE(322),
    [sym__expression] = STATE(322),
    [sym_object_creation_expression] = STATE(43),
    [sym__type] = STATE(37),
    [sym_unary_expression] = STATE(322),
    [sym__literal] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_assignment_expression] = STATE(322),
    [sym_array_creation_expression] = STATE(41),
    [sym_inferred_parameters] = STATE(42),
    [sym_method_reference] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_ternary_expression] = STATE(322),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_null_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_module] = ACTIONS(120),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_long] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_int] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_new] = ACTIONS(19),
    [sym_void_type] = ACTIONS(55),
    [sym_true] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_this] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_binary_integer_literal] = ACTIONS(35),
  },
  [161] = {
    [sym__expression] = STATE(323),
    [sym_class_literal] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym_annotated_type] = STATE(37),
    [sym_binary_expression] = STATE(323),
    [sym_ternary_expression] = STATE(323),
    [sym_assignment_expression] = STATE(323),
    [sym_unary_expression] = STATE(323),
    [sym_parenthesized_expression] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym__unannotated_type] = STATE(73),
    [sym_lambda_expression] = STATE(323),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_field_access] = STATE(39),
    [sym_marker_annotation] = STATE(74),
    [sym_floating_point_type] = STATE(30),
    [sym_method_reference] = STATE(43),
    [sym__type] = STATE(37),
    [sym__annotation] = STATE(74),
    [sym__primary_no_new_array] = STATE(43),
    [sym_instanceof_expression] = STATE(323),
    [sym_formal_parameters] = STATE(42),
    [sym__primary] = STATE(41),
    [sym_generic_type] = STATE(53),
    [sym_scoped_identifier] = STATE(52),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_array_access] = STATE(39),
    [sym_array_creation_expression] = STATE(41),
    [sym_array_type] = STATE(73),
    [sym_annotation] = STATE(74),
    [sym_cast_expression] = STATE(323),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_update_expression] = STATE(323),
    [sym_method_invocation] = STATE(43),
    [sym_character_literal] = ACTIONS(35),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(33),
    [sym_void_type] = ACTIONS(55),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_byte] = ACTIONS(33),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_char] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_short] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_false] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_double] = ACTIONS(41),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
  },
  [162] = {
    [sym_lambda_expression] = STATE(324),
    [sym_annotation] = STATE(74),
    [sym_instanceof_expression] = STATE(324),
    [sym_method_reference] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_generic_type] = STATE(53),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym_class_literal] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [sym_field_access] = STATE(39),
    [sym__primary_no_new_array] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym__primary] = STATE(41),
    [sym__annotation] = STATE(74),
    [sym_assignment_expression] = STATE(324),
    [sym_object_creation_expression] = STATE(43),
    [sym_ternary_expression] = STATE(324),
    [sym_floating_point_type] = STATE(30),
    [sym_update_expression] = STATE(324),
    [sym_array_type] = STATE(73),
    [sym_formal_parameters] = STATE(42),
    [sym__expression] = STATE(324),
    [sym_binary_expression] = STATE(324),
    [sym_integral_type] = STATE(30),
    [sym_annotated_type] = STATE(37),
    [sym_cast_expression] = STATE(324),
    [sym_method_invocation] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_unary_expression] = STATE(324),
    [sym__type] = STATE(37),
    [sym_character_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_boolean_type] = ACTIONS(79),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_void_type] = ACTIONS(55),
    [sym_true] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_char] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [anon_sym_float] = ACTIONS(41),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_open] = ACTIONS(120),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_module] = ACTIONS(120),
    [sym_comment] = ACTIONS(3),
    [sym_string_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [sym_hex_integer_literal] = ACTIONS(5),
  },
  [163] = {
    [anon_sym_AMP] = ACTIONS(485),
    [anon_sym_DASH_DASH] = ACTIONS(487),
    [anon_sym_EQ_EQ] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(485),
    [anon_sym_GT_GT] = ACTIONS(485),
    [anon_sym_SEMI] = ACTIONS(487),
    [anon_sym_COMMA] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(487),
    [anon_sym_GT_GT_GT] = ACTIONS(487),
    [anon_sym_instanceof] = ACTIONS(487),
    [anon_sym_AMP_AMP] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(487),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_PIPE_PIPE] = ACTIONS(487),
    [anon_sym_PIPE] = ACTIONS(485),
    [anon_sym_LT_LT] = ACTIONS(487),
    [anon_sym_BANG_EQ] = ACTIONS(487),
    [anon_sym_STAR] = ACTIONS(487),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_GT_EQ] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_COLON] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(485),
    [anon_sym_CARET] = ACTIONS(487),
    [anon_sym_PERCENT] = ACTIONS(487),
    [anon_sym_QMARK] = ACTIONS(487),
    [anon_sym_RBRACK] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(487),
  },
  [164] = {
    [anon_sym_private] = ACTIONS(727),
    [anon_sym_for] = ACTIONS(727),
    [anon_sym_ATinterface] = ACTIONS(729),
    [anon_sym_short] = ACTIONS(727),
    [sym_hex_floating_point_literal] = ACTIONS(727),
    [anon_sym_volatile] = ACTIONS(727),
    [anon_sym_PLUS] = ACTIONS(727),
    [anon_sym_LBRACE] = ACTIONS(729),
    [anon_sym_do] = ACTIONS(727),
    [anon_sym_DASH_DASH] = ACTIONS(729),
    [anon_sym_if] = ACTIONS(727),
    [anon_sym_transient] = ACTIONS(727),
    [anon_sym_byte] = ACTIONS(727),
    [sym_identifier] = ACTIONS(727),
    [sym_decimal_integer_literal] = ACTIONS(727),
    [anon_sym_assert] = ACTIONS(727),
    [anon_sym_LPAREN] = ACTIONS(729),
    [anon_sym_BANG] = ACTIONS(729),
    [anon_sym_class] = ACTIONS(727),
    [sym_super] = ACTIONS(727),
    [anon_sym_PLUS_PLUS] = ACTIONS(729),
    [anon_sym_abstract] = ACTIONS(727),
    [anon_sym_throw] = ACTIONS(727),
    [anon_sym_double] = ACTIONS(727),
    [anon_sym_final] = ACTIONS(727),
    [anon_sym_native] = ACTIONS(727),
    [anon_sym_while] = ACTIONS(727),
    [ts_builtin_sym_end] = ACTIONS(729),
    [anon_sym_float] = ACTIONS(727),
    [anon_sym_TILDE] = ACTIONS(729),
    [anon_sym_protected] = ACTIONS(727),
    [anon_sym_new] = ACTIONS(727),
    [anon_sym_return] = ACTIONS(727),
    [sym_void_type] = ACTIONS(727),
    [anon_sym_case] = ACTIONS(727),
    [sym_false] = ACTIONS(727),
    [anon_sym_continue] = ACTIONS(727),
    [anon_sym_else] = ACTIONS(727),
    [sym_decimal_floating_point_literal] = ACTIONS(729),
    [sym_octal_integer_literal] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(729),
    [anon_sym_long] = ACTIONS(727),
    [sym_comment] = ACTIONS(3),
    [sym_null_literal] = ACTIONS(727),
    [sym_hex_integer_literal] = ACTIONS(727),
    [anon_sym_synchronized] = ACTIONS(727),
    [sym_true] = ACTIONS(727),
    [anon_sym_break] = ACTIONS(727),
    [anon_sym_package] = ACTIONS(727),
    [sym_character_literal] = ACTIONS(729),
    [anon_sym_strictfp] = ACTIONS(727),
    [anon_sym_try] = ACTIONS(727),
    [anon_sym_open] = ACTIONS(727),
    [anon_sym_DASH] = ACTIONS(727),
    [sym_this] = ACTIONS(727),
    [anon_sym_switch] = ACTIONS(727),
    [anon_sym_RBRACE] = ACTIONS(729),
    [anon_sym_AT] = ACTIONS(727),
    [anon_sym_module] = ACTIONS(727),
    [anon_sym_import] = ACTIONS(727),
    [sym_boolean_type] = ACTIONS(727),
    [anon_sym_default] = ACTIONS(727),
    [anon_sym_interface] = ACTIONS(727),
    [sym_string_literal] = ACTIONS(729),
    [sym_binary_integer_literal] = ACTIONS(729),
    [anon_sym_static] = ACTIONS(727),
    [anon_sym_public] = ACTIONS(727),
    [anon_sym_enum] = ACTIONS(727),
    [anon_sym_int] = ACTIONS(727),
    [anon_sym_char] = ACTIONS(727),
  },
  [165] = {
    [sym__unqualified_object_creation_expression] = STATE(185),
    [sym_type_arguments] = STATE(186),
    [anon_sym_new] = ACTIONS(346),
    [anon_sym_class] = ACTIONS(352),
    [sym_identifier] = ACTIONS(731),
    [sym_super] = ACTIONS(344),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(350),
  },
  [166] = {
    [anon_sym_return] = ACTIONS(733),
    [anon_sym_protected] = ACTIONS(733),
    [sym_decimal_integer_literal] = ACTIONS(733),
    [anon_sym_LBRACE] = ACTIONS(735),
    [anon_sym_char] = ACTIONS(733),
    [anon_sym_DASH] = ACTIONS(733),
    [anon_sym_default] = ACTIONS(733),
    [sym_void_type] = ACTIONS(733),
    [sym_identifier] = ACTIONS(733),
    [anon_sym_enum] = ACTIONS(733),
    [sym_true] = ACTIONS(733),
    [sym_decimal_floating_point_literal] = ACTIONS(735),
    [anon_sym_while] = ACTIONS(733),
    [anon_sym_short] = ACTIONS(733),
    [anon_sym_volatile] = ACTIONS(733),
    [anon_sym_do] = ACTIONS(733),
    [anon_sym_break] = ACTIONS(733),
    [anon_sym_assert] = ACTIONS(733),
    [anon_sym_double] = ACTIONS(733),
    [anon_sym_BANG] = ACTIONS(735),
    [anon_sym_static] = ACTIONS(733),
    [sym_octal_integer_literal] = ACTIONS(735),
    [anon_sym_TILDE] = ACTIONS(735),
    [anon_sym_native] = ACTIONS(733),
    [anon_sym_byte] = ACTIONS(733),
    [anon_sym_if] = ACTIONS(733),
    [anon_sym_continue] = ACTIONS(733),
    [anon_sym_private] = ACTIONS(733),
    [anon_sym_public] = ACTIONS(733),
    [ts_builtin_sym_end] = ACTIONS(735),
    [anon_sym_throw] = ACTIONS(733),
    [sym_comment] = ACTIONS(3),
    [anon_sym_else] = ACTIONS(733),
    [anon_sym_PLUS_PLUS] = ACTIONS(735),
    [anon_sym_abstract] = ACTIONS(733),
    [anon_sym_transient] = ACTIONS(733),
    [sym_character_literal] = ACTIONS(735),
    [sym_string_literal] = ACTIONS(735),
    [anon_sym_new] = ACTIONS(733),
    [anon_sym_float] = ACTIONS(733),
    [anon_sym_RBRACE] = ACTIONS(735),
    [sym_binary_integer_literal] = ACTIONS(735),
    [anon_sym_PLUS] = ACTIONS(733),
    [anon_sym_interface] = ACTIONS(733),
    [sym_boolean_type] = ACTIONS(733),
    [sym_null_literal] = ACTIONS(733),
    [anon_sym_final] = ACTIONS(733),
    [anon_sym_synchronized] = ACTIONS(733),
    [anon_sym_strictfp] = ACTIONS(733),
    [anon_sym_class] = ACTIONS(733),
    [anon_sym_package] = ACTIONS(733),
    [anon_sym_SEMI] = ACTIONS(735),
    [anon_sym_int] = ACTIONS(733),
    [anon_sym_ATinterface] = ACTIONS(735),
    [anon_sym_LPAREN] = ACTIONS(735),
    [anon_sym_module] = ACTIONS(733),
    [anon_sym_import] = ACTIONS(733),
    [anon_sym_DASH_DASH] = ACTIONS(735),
    [anon_sym_switch] = ACTIONS(733),
    [anon_sym_long] = ACTIONS(733),
    [anon_sym_for] = ACTIONS(733),
    [sym_hex_floating_point_literal] = ACTIONS(733),
    [sym_this] = ACTIONS(733),
    [sym_false] = ACTIONS(733),
    [sym_hex_integer_literal] = ACTIONS(733),
    [anon_sym_try] = ACTIONS(733),
    [sym_super] = ACTIONS(733),
    [anon_sym_case] = ACTIONS(733),
    [anon_sym_open] = ACTIONS(733),
    [anon_sym_AT] = ACTIONS(733),
  },
  [167] = {
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_RPAREN] = ACTIONS(737),
    [anon_sym_SLASH] = ACTIONS(299),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(737),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_RBRACE] = ACTIONS(737),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_COLON] = ACTIONS(737),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_SEMI] = ACTIONS(737),
    [anon_sym_RBRACK] = ACTIONS(737),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(291),
  },
  [168] = {
    [anon_sym_QMARK] = ACTIONS(739),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(739),
    [anon_sym_SLASH] = ACTIONS(741),
    [anon_sym_DOT] = ACTIONS(739),
    [anon_sym_LT_LT] = ACTIONS(739),
    [anon_sym_GT_GT_GT] = ACTIONS(739),
    [anon_sym_LT] = ACTIONS(741),
    [anon_sym_PIPE_PIPE] = ACTIONS(739),
    [anon_sym_PLUS] = ACTIONS(741),
    [anon_sym_AMP_AMP] = ACTIONS(739),
    [anon_sym_PIPE] = ACTIONS(741),
    [anon_sym_instanceof] = ACTIONS(739),
    [anon_sym_COLON_COLON] = ACTIONS(739),
    [anon_sym_RPAREN] = ACTIONS(739),
    [anon_sym_COLON] = ACTIONS(741),
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ_EQ] = ACTIONS(739),
    [anon_sym_RBRACK] = ACTIONS(739),
    [anon_sym_DASH] = ACTIONS(741),
    [anon_sym_GT_GT] = ACTIONS(741),
    [anon_sym_GT] = ACTIONS(741),
    [anon_sym_COMMA] = ACTIONS(739),
    [anon_sym_AMP] = ACTIONS(741),
    [anon_sym_LT_EQ] = ACTIONS(739),
    [anon_sym_BANG_EQ] = ACTIONS(739),
    [anon_sym_STAR] = ACTIONS(739),
    [anon_sym_RBRACE] = ACTIONS(739),
    [anon_sym_PERCENT] = ACTIONS(739),
    [anon_sym_CARET] = ACTIONS(739),
    [anon_sym_PLUS_PLUS] = ACTIONS(739),
    [anon_sym_GT_EQ] = ACTIONS(739),
    [anon_sym_DASH_DASH] = ACTIONS(739),
  },
  [169] = {
    [sym_identifier] = ACTIONS(743),
    [sym_comment] = ACTIONS(3),
    [anon_sym_new] = ACTIONS(743),
  },
  [170] = {
    [sym__wildcard_bounds] = STATE(328),
    [sym_comment] = ACTIONS(3),
    [sym_super] = ACTIONS(745),
    [anon_sym_COMMA] = ACTIONS(747),
    [anon_sym_GT] = ACTIONS(747),
    [anon_sym_extends] = ACTIONS(745),
  },
  [171] = {
    [anon_sym_COLON_COLON] = ACTIONS(749),
    [anon_sym_float] = ACTIONS(751),
    [anon_sym_char] = ACTIONS(751),
    [anon_sym_new] = ACTIONS(751),
    [sym_boolean_type] = ACTIONS(751),
    [anon_sym_byte] = ACTIONS(751),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(749),
    [anon_sym_open] = ACTIONS(751),
    [anon_sym_long] = ACTIONS(751),
    [sym_this] = ACTIONS(751),
    [sym_super] = ACTIONS(751),
    [anon_sym_PIPE] = ACTIONS(749),
    [anon_sym_LPAREN] = ACTIONS(749),
    [anon_sym_AT] = ACTIONS(749),
    [anon_sym_short] = ACTIONS(751),
    [anon_sym_DOT] = ACTIONS(751),
    [anon_sym_module] = ACTIONS(751),
    [sym_comment] = ACTIONS(3),
    [sym_void_type] = ACTIONS(751),
    [anon_sym_AMP] = ACTIONS(749),
    [anon_sym_LBRACE] = ACTIONS(749),
    [anon_sym_implements] = ACTIONS(751),
    [anon_sym_RPAREN] = ACTIONS(749),
    [anon_sym_COMMA] = ACTIONS(749),
    [anon_sym_SEMI] = ACTIONS(749),
    [anon_sym_int] = ACTIONS(751),
    [anon_sym_GT] = ACTIONS(749),
    [sym_identifier] = ACTIONS(751),
    [anon_sym_double] = ACTIONS(751),
    [anon_sym_LBRACK] = ACTIONS(749),
  },
  [172] = {
    [sym_generic_type] = STATE(53),
    [sym_marker_annotation] = STATE(137),
    [sym_floating_point_type] = STATE(136),
    [sym__annotation] = STATE(137),
    [sym_array_type] = STATE(136),
    [sym_annotation] = STATE(137),
    [sym__unannotated_type] = STATE(136),
    [sym_integral_type] = STATE(136),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_byte] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(229),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(753),
    [sym_void_type] = ACTIONS(229),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
  },
  [173] = {
    [aux_sym_type_arguments_repeat1] = STATE(332),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(755),
    [anon_sym_COMMA] = ACTIONS(757),
  },
  [174] = {
    [anon_sym_PLUS] = ACTIONS(759),
    [anon_sym_AT] = ACTIONS(759),
    [anon_sym_open] = ACTIONS(759),
    [anon_sym_do] = ACTIONS(759),
    [anon_sym_protected] = ACTIONS(759),
    [anon_sym_interface] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(759),
    [sym_string_literal] = ACTIONS(761),
    [anon_sym_assert] = ACTIONS(759),
    [anon_sym_SEMI] = ACTIONS(761),
    [anon_sym_for] = ACTIONS(759),
    [anon_sym_LBRACE] = ACTIONS(761),
    [sym_this] = ACTIONS(759),
    [anon_sym_double] = ACTIONS(759),
    [anon_sym_case] = ACTIONS(759),
    [anon_sym_int] = ACTIONS(759),
    [anon_sym_default] = ACTIONS(759),
    [anon_sym_transient] = ACTIONS(759),
    [anon_sym_ATinterface] = ACTIONS(761),
    [anon_sym_if] = ACTIONS(759),
    [sym_identifier] = ACTIONS(759),
    [sym_decimal_integer_literal] = ACTIONS(759),
    [sym_hex_floating_point_literal] = ACTIONS(759),
    [anon_sym_throw] = ACTIONS(759),
    [sym_comment] = ACTIONS(3),
    [sym_character_literal] = ACTIONS(761),
    [anon_sym_byte] = ACTIONS(759),
    [anon_sym_return] = ACTIONS(759),
    [anon_sym_private] = ACTIONS(759),
    [anon_sym_public] = ACTIONS(759),
    [anon_sym_DASH_DASH] = ACTIONS(761),
    [anon_sym_float] = ACTIONS(759),
    [anon_sym_long] = ACTIONS(759),
    [anon_sym_short] = ACTIONS(759),
    [anon_sym_LPAREN] = ACTIONS(761),
    [anon_sym_continue] = ACTIONS(759),
    [anon_sym_TILDE] = ACTIONS(761),
    [anon_sym_package] = ACTIONS(759),
    [anon_sym_enum] = ACTIONS(759),
    [anon_sym_native] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(759),
    [sym_false] = ACTIONS(759),
    [anon_sym_try] = ACTIONS(759),
    [anon_sym_char] = ACTIONS(759),
    [anon_sym_synchronized] = ACTIONS(759),
    [sym_binary_integer_literal] = ACTIONS(761),
    [sym_decimal_floating_point_literal] = ACTIONS(761),
    [sym_void_type] = ACTIONS(759),
    [anon_sym_switch] = ACTIONS(759),
    [anon_sym_RBRACE] = ACTIONS(761),
    [anon_sym_volatile] = ACTIONS(759),
    [sym_hex_integer_literal] = ACTIONS(759),
    [anon_sym_break] = ACTIONS(759),
    [anon_sym_static] = ACTIONS(759),
    [sym_octal_integer_literal] = ACTIONS(761),
    [anon_sym_BANG] = ACTIONS(761),
    [anon_sym_else] = ACTIONS(759),
    [anon_sym_PLUS_PLUS] = ACTIONS(761),
    [ts_builtin_sym_end] = ACTIONS(761),
    [anon_sym_final] = ACTIONS(759),
    [anon_sym_abstract] = ACTIONS(759),
    [sym_true] = ACTIONS(759),
    [sym_null_literal] = ACTIONS(759),
    [anon_sym_DASH] = ACTIONS(759),
    [anon_sym_class] = ACTIONS(759),
    [anon_sym_new] = ACTIONS(759),
    [anon_sym_strictfp] = ACTIONS(759),
    [sym_boolean_type] = ACTIONS(759),
    [sym_super] = ACTIONS(759),
    [anon_sym_module] = ACTIONS(759),
  },
  [175] = {
    [anon_sym_DOT] = ACTIONS(763),
    [anon_sym_LBRACK] = ACTIONS(763),
    [sym_comment] = ACTIONS(3),
  },
  [176] = {
    [anon_sym_RBRACK] = ACTIONS(765),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_GT_EQ] = ACTIONS(293),
  },
  [177] = {
    [anon_sym_COLON_COLON] = ACTIONS(767),
    [anon_sym_STAR] = ACTIONS(767),
    [anon_sym_PLUS_PLUS] = ACTIONS(767),
    [anon_sym_GT_EQ] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(767),
    [anon_sym_instanceof] = ACTIONS(767),
    [anon_sym_RPAREN] = ACTIONS(767),
    [anon_sym_COMMA] = ACTIONS(767),
    [anon_sym_GT] = ACTIONS(769),
    [anon_sym_AMP_AMP] = ACTIONS(767),
    [anon_sym_PLUS] = ACTIONS(769),
    [anon_sym_GT_GT] = ACTIONS(769),
    [anon_sym_PERCENT] = ACTIONS(767),
    [anon_sym_LT_LT] = ACTIONS(767),
    [anon_sym_QMARK] = ACTIONS(767),
    [anon_sym_COLON] = ACTIONS(769),
    [anon_sym_EQ_EQ] = ACTIONS(767),
    [anon_sym_RBRACK] = ACTIONS(767),
    [anon_sym_GT_GT_GT] = ACTIONS(767),
    [anon_sym_LT] = ACTIONS(769),
    [anon_sym_PIPE] = ACTIONS(769),
    [anon_sym_LBRACK] = ACTIONS(767),
    [anon_sym_LT_EQ] = ACTIONS(767),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(767),
    [anon_sym_DASH] = ACTIONS(769),
    [anon_sym_AMP] = ACTIONS(769),
    [anon_sym_DOT] = ACTIONS(767),
    [anon_sym_DASH_DASH] = ACTIONS(767),
    [anon_sym_BANG_EQ] = ACTIONS(767),
    [anon_sym_SLASH] = ACTIONS(769),
    [anon_sym_CARET] = ACTIONS(767),
    [anon_sym_SEMI] = ACTIONS(767),
    [anon_sym_RBRACE] = ACTIONS(767),
  },
  [178] = {
    [aux_sym_argument_list_repeat1] = STATE(336),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_COMMA] = ACTIONS(771),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_RPAREN] = ACTIONS(773),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_SLASH] = ACTIONS(299),
    [sym_comment] = ACTIONS(3),
  },
  [179] = {
    [anon_sym_LT] = ACTIONS(775),
    [anon_sym_PLUS_EQ] = ACTIONS(777),
    [anon_sym_LBRACK] = ACTIONS(777),
    [anon_sym_GT_GT_GT] = ACTIONS(775),
    [anon_sym_SLASH] = ACTIONS(775),
    [anon_sym_PERCENT_EQ] = ACTIONS(777),
    [anon_sym_GT_GT_EQ] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_COLON] = ACTIONS(775),
    [anon_sym_STAR_EQ] = ACTIONS(777),
    [anon_sym_PIPE_EQ] = ACTIONS(777),
    [anon_sym_PLUS] = ACTIONS(775),
    [anon_sym_PIPE_PIPE] = ACTIONS(777),
    [anon_sym_AMP_AMP] = ACTIONS(777),
    [anon_sym_GT_GT] = ACTIONS(775),
    [anon_sym_EQ_EQ] = ACTIONS(777),
    [anon_sym_LT_EQ] = ACTIONS(777),
    [anon_sym_LT_LT] = ACTIONS(775),
    [anon_sym_PIPE] = ACTIONS(775),
    [anon_sym_COLON_COLON] = ACTIONS(777),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(777),
    [anon_sym_RBRACE] = ACTIONS(777),
    [anon_sym_EQ] = ACTIONS(775),
    [anon_sym_GT_EQ] = ACTIONS(777),
    [anon_sym_COMMA] = ACTIONS(777),
    [anon_sym_CARET_EQ] = ACTIONS(777),
    [anon_sym_DASH] = ACTIONS(775),
    [anon_sym_CARET] = ACTIONS(775),
    [anon_sym_PERCENT] = ACTIONS(775),
    [anon_sym_DASH_DASH] = ACTIONS(777),
    [anon_sym_instanceof] = ACTIONS(777),
    [anon_sym_AMP_EQ] = ACTIONS(777),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(777),
    [anon_sym_QMARK] = ACTIONS(777),
    [anon_sym_PLUS_PLUS] = ACTIONS(777),
    [anon_sym_SLASH_EQ] = ACTIONS(777),
    [anon_sym_BANG_EQ] = ACTIONS(777),
    [anon_sym_LT_LT_EQ] = ACTIONS(777),
    [anon_sym_DASH_EQ] = ACTIONS(777),
    [anon_sym_GT] = ACTIONS(775),
    [anon_sym_SEMI] = ACTIONS(777),
    [anon_sym_RPAREN] = ACTIONS(777),
    [anon_sym_DOT] = ACTIONS(777),
    [anon_sym_AMP] = ACTIONS(775),
  },
  [180] = {
    [anon_sym_GT_GT] = ACTIONS(779),
    [anon_sym_RBRACK] = ACTIONS(781),
    [anon_sym_LBRACK] = ACTIONS(781),
    [anon_sym_AMP] = ACTIONS(779),
    [anon_sym_DOT] = ACTIONS(781),
    [anon_sym_PLUS] = ACTIONS(779),
    [anon_sym_LT_EQ] = ACTIONS(781),
    [anon_sym_QMARK] = ACTIONS(781),
    [anon_sym_PLUS_PLUS] = ACTIONS(781),
    [anon_sym_COMMA] = ACTIONS(781),
    [anon_sym_RBRACE] = ACTIONS(781),
    [anon_sym_CARET] = ACTIONS(781),
    [anon_sym_RPAREN] = ACTIONS(781),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(779),
    [anon_sym_SLASH] = ACTIONS(779),
    [anon_sym_PIPE] = ACTIONS(779),
    [anon_sym_BANG_EQ] = ACTIONS(781),
    [anon_sym_PIPE_PIPE] = ACTIONS(781),
    [anon_sym_STAR] = ACTIONS(781),
    [anon_sym_PERCENT] = ACTIONS(781),
    [anon_sym_GT] = ACTIONS(779),
    [anon_sym_AMP_AMP] = ACTIONS(781),
    [anon_sym_LT_LT] = ACTIONS(781),
    [anon_sym_GT_EQ] = ACTIONS(781),
    [anon_sym_GT_GT_GT] = ACTIONS(781),
    [anon_sym_EQ_EQ] = ACTIONS(781),
    [anon_sym_COLON_COLON] = ACTIONS(781),
    [anon_sym_DASH_DASH] = ACTIONS(781),
    [anon_sym_SEMI] = ACTIONS(781),
    [anon_sym_DASH] = ACTIONS(779),
    [anon_sym_instanceof] = ACTIONS(781),
    [anon_sym_COLON] = ACTIONS(779),
  },
  [181] = {
    [sym_type_arguments] = STATE(98),
    [sym_floating_point_type] = STATE(338),
    [sym_generic_type] = STATE(339),
    [sym_scoped_type_identifier] = STATE(340),
    [sym_integral_type] = STATE(338),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [sym_identifier] = ACTIONS(783),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
    [sym_void_type] = ACTIONS(785),
    [sym_boolean_type] = ACTIONS(785),
  },
  [182] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(787),
  },
  [183] = {
    [sym_argument_list] = STATE(342),
    [anon_sym_DASH_EQ] = ACTIONS(789),
    [anon_sym_PIPE_EQ] = ACTIONS(789),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_SLASH] = ACTIONS(791),
    [anon_sym_QMARK] = ACTIONS(789),
    [anon_sym_PLUS_EQ] = ACTIONS(789),
    [anon_sym_EQ] = ACTIONS(791),
    [anon_sym_GT_EQ] = ACTIONS(789),
    [anon_sym_CARET] = ACTIONS(791),
    [anon_sym_COMMA] = ACTIONS(789),
    [anon_sym_instanceof] = ACTIONS(791),
    [anon_sym_AMP_AMP] = ACTIONS(789),
    [anon_sym_PERCENT_EQ] = ACTIONS(789),
    [anon_sym_EQ_EQ] = ACTIONS(789),
    [anon_sym_DOT] = ACTIONS(793),
    [anon_sym_RBRACK] = ACTIONS(789),
    [anon_sym_GT_GT_EQ] = ACTIONS(789),
    [anon_sym_PLUS_PLUS] = ACTIONS(789),
    [anon_sym_PIPE_PIPE] = ACTIONS(789),
    [anon_sym_PERCENT] = ACTIONS(791),
    [sym_identifier] = ACTIONS(796),
    [anon_sym_COLON] = ACTIONS(791),
    [anon_sym_GT_GT_GT] = ACTIONS(791),
    [anon_sym_COLON_COLON] = ACTIONS(793),
    [anon_sym_LT_LT] = ACTIONS(791),
    [anon_sym_module] = ACTIONS(796),
    [anon_sym_LT] = ACTIONS(798),
    [anon_sym_LT_EQ] = ACTIONS(789),
    [anon_sym_PIPE] = ACTIONS(791),
    [anon_sym_CARET_EQ] = ACTIONS(789),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_AMP] = ACTIONS(791),
    [anon_sym_LBRACK] = ACTIONS(793),
    [anon_sym_LT_LT_EQ] = ACTIONS(789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(791),
    [anon_sym_STAR] = ACTIONS(791),
    [anon_sym_GT_GT] = ACTIONS(791),
    [anon_sym_AT] = ACTIONS(801),
    [anon_sym_RBRACE] = ACTIONS(789),
    [anon_sym_STAR_EQ] = ACTIONS(789),
    [anon_sym_RPAREN] = ACTIONS(789),
    [anon_sym_AMP_EQ] = ACTIONS(789),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(789),
    [anon_sym_BANG_EQ] = ACTIONS(789),
    [anon_sym_SEMI] = ACTIONS(789),
    [anon_sym_open] = ACTIONS(796),
    [anon_sym_DASH_DASH] = ACTIONS(789),
    [anon_sym_SLASH_EQ] = ACTIONS(789),
    [anon_sym_DASH] = ACTIONS(791),
  },
  [184] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym__annotation] = STATE(137),
    [sym_annotation] = STATE(137),
    [sym_marker_annotation] = STATE(137),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(803),
  },
  [185] = {
    [anon_sym_BANG_EQ] = ACTIONS(805),
    [anon_sym_DOT] = ACTIONS(805),
    [anon_sym_GT_EQ] = ACTIONS(805),
    [anon_sym_COLON_COLON] = ACTIONS(805),
    [anon_sym_QMARK] = ACTIONS(805),
    [anon_sym_LBRACK] = ACTIONS(805),
    [anon_sym_PERCENT] = ACTIONS(805),
    [anon_sym_AMP_AMP] = ACTIONS(805),
    [anon_sym_PIPE_PIPE] = ACTIONS(805),
    [anon_sym_EQ_EQ] = ACTIONS(805),
    [anon_sym_PLUS_PLUS] = ACTIONS(805),
    [anon_sym_LT_EQ] = ACTIONS(805),
    [anon_sym_PLUS] = ACTIONS(807),
    [anon_sym_GT_GT] = ACTIONS(807),
    [anon_sym_COLON] = ACTIONS(807),
    [anon_sym_RPAREN] = ACTIONS(805),
    [anon_sym_instanceof] = ACTIONS(805),
    [anon_sym_COMMA] = ACTIONS(805),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(805),
    [anon_sym_LT] = ACTIONS(807),
    [anon_sym_SLASH] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(805),
    [anon_sym_GT] = ACTIONS(807),
    [anon_sym_RBRACK] = ACTIONS(805),
    [anon_sym_DASH] = ACTIONS(807),
    [anon_sym_DASH_DASH] = ACTIONS(805),
    [anon_sym_PIPE] = ACTIONS(807),
    [anon_sym_GT_GT_GT] = ACTIONS(805),
    [anon_sym_AMP] = ACTIONS(807),
    [anon_sym_STAR] = ACTIONS(805),
    [anon_sym_CARET] = ACTIONS(805),
    [anon_sym_LT_LT] = ACTIONS(805),
  },
  [186] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(809),
  },
  [187] = {
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_RBRACE] = ACTIONS(811),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_COMMA] = ACTIONS(811),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_RBRACK] = ACTIONS(811),
    [anon_sym_GT] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_COLON] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(811),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
  },
  [188] = {
    [anon_sym_BANG_EQ] = ACTIONS(811),
    [anon_sym_GT_EQ] = ACTIONS(811),
    [anon_sym_instanceof] = ACTIONS(811),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_DASH_DASH] = ACTIONS(811),
    [anon_sym_DASH] = ACTIONS(813),
    [anon_sym_RBRACK] = ACTIONS(811),
    [anon_sym_RBRACE] = ACTIONS(811),
    [anon_sym_PLUS_PLUS] = ACTIONS(811),
    [anon_sym_EQ_EQ] = ACTIONS(811),
    [anon_sym_STAR] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(813),
    [anon_sym_QMARK] = ACTIONS(811),
    [anon_sym_PLUS] = ACTIONS(813),
    [anon_sym_PERCENT] = ACTIONS(811),
    [anon_sym_LT_LT] = ACTIONS(811),
    [anon_sym_LT_EQ] = ACTIONS(811),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SLASH] = ACTIONS(813),
    [anon_sym_COMMA] = ACTIONS(811),
    [anon_sym_PIPE] = ACTIONS(813),
    [anon_sym_COLON] = ACTIONS(811),
    [anon_sym_GT] = ACTIONS(813),
    [anon_sym_GT_GT] = ACTIONS(813),
    [anon_sym_SEMI] = ACTIONS(811),
    [anon_sym_CARET] = ACTIONS(811),
    [anon_sym_LT] = ACTIONS(813),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [anon_sym_GT_GT_GT] = ACTIONS(811),
  },
  [189] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_class] = ACTIONS(815),
  },
  [190] = {
    [aux_sym_class_literal_repeat1] = STATE(190),
    [anon_sym_LBRACK] = ACTIONS(817),
    [anon_sym_DOT] = ACTIONS(763),
    [sym_comment] = ACTIONS(3),
  },
  [191] = {
    [sym_identifier] = ACTIONS(820),
    [sym_comment] = ACTIONS(3),
  },
  [192] = {
    [anon_sym_private] = ACTIONS(822),
    [anon_sym_transient] = ACTIONS(822),
    [sym_decimal_floating_point_literal] = ACTIONS(824),
    [anon_sym_return] = ACTIONS(822),
    [anon_sym_final] = ACTIONS(822),
    [anon_sym_strictfp] = ACTIONS(822),
    [sym_octal_integer_literal] = ACTIONS(824),
    [anon_sym_float] = ACTIONS(822),
    [anon_sym_public] = ACTIONS(822),
    [anon_sym_else] = ACTIONS(822),
    [anon_sym_int] = ACTIONS(822),
    [sym_boolean_type] = ACTIONS(822),
    [anon_sym_DASH_DASH] = ACTIONS(824),
    [sym_binary_integer_literal] = ACTIONS(824),
    [sym_hex_floating_point_literal] = ACTIONS(822),
    [anon_sym_if] = ACTIONS(822),
    [sym_this] = ACTIONS(822),
    [anon_sym_protected] = ACTIONS(822),
    [anon_sym_for] = ACTIONS(822),
    [anon_sym_switch] = ACTIONS(822),
    [sym_null_literal] = ACTIONS(822),
    [anon_sym_try] = ACTIONS(822),
    [sym_hex_integer_literal] = ACTIONS(822),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(824),
    [anon_sym_double] = ACTIONS(822),
    [anon_sym_DASH] = ACTIONS(822),
    [anon_sym_do] = ACTIONS(822),
    [anon_sym_throw] = ACTIONS(822),
    [anon_sym_SEMI] = ACTIONS(824),
    [anon_sym_abstract] = ACTIONS(822),
    [anon_sym_interface] = ACTIONS(822),
    [sym_void_type] = ACTIONS(822),
    [anon_sym_while] = ACTIONS(822),
    [anon_sym_import] = ACTIONS(822),
    [ts_builtin_sym_end] = ACTIONS(824),
    [anon_sym_default] = ACTIONS(822),
    [anon_sym_break] = ACTIONS(822),
    [sym_true] = ACTIONS(822),
    [anon_sym_volatile] = ACTIONS(822),
    [anon_sym_enum] = ACTIONS(822),
    [anon_sym_short] = ACTIONS(822),
    [sym_identifier] = ACTIONS(822),
    [anon_sym_PLUS] = ACTIONS(822),
    [anon_sym_assert] = ACTIONS(822),
    [sym_decimal_integer_literal] = ACTIONS(822),
    [sym_string_literal] = ACTIONS(824),
    [anon_sym_AT] = ACTIONS(822),
    [anon_sym_case] = ACTIONS(822),
    [sym_super] = ACTIONS(822),
    [sym_false] = ACTIONS(822),
    [anon_sym_module] = ACTIONS(822),
    [anon_sym_char] = ACTIONS(822),
    [sym_character_literal] = ACTIONS(824),
    [anon_sym_synchronized] = ACTIONS(822),
    [anon_sym_package] = ACTIONS(822),
    [anon_sym_BANG] = ACTIONS(824),
    [anon_sym_byte] = ACTIONS(822),
    [anon_sym_PLUS_PLUS] = ACTIONS(824),
    [anon_sym_new] = ACTIONS(822),
    [anon_sym_LPAREN] = ACTIONS(824),
    [anon_sym_TILDE] = ACTIONS(824),
    [anon_sym_RBRACE] = ACTIONS(824),
    [anon_sym_long] = ACTIONS(822),
    [anon_sym_native] = ACTIONS(822),
    [anon_sym_continue] = ACTIONS(822),
    [anon_sym_open] = ACTIONS(822),
    [anon_sym_static] = ACTIONS(822),
    [anon_sym_class] = ACTIONS(822),
    [anon_sym_ATinterface] = ACTIONS(824),
  },
  [193] = {
    [anon_sym_interface] = ACTIONS(826),
    [anon_sym_AT] = ACTIONS(826),
    [anon_sym_switch] = ACTIONS(826),
    [anon_sym_synchronized] = ACTIONS(826),
    [anon_sym_assert] = ACTIONS(826),
    [anon_sym_DASH_DASH] = ACTIONS(828),
    [anon_sym_PLUS_PLUS] = ACTIONS(828),
    [anon_sym_SEMI] = ACTIONS(828),
    [sym_super] = ACTIONS(826),
    [anon_sym_if] = ACTIONS(826),
    [sym_decimal_integer_literal] = ACTIONS(826),
    [anon_sym_module] = ACTIONS(826),
    [anon_sym_package] = ACTIONS(826),
    [anon_sym_new] = ACTIONS(826),
    [anon_sym_abstract] = ACTIONS(826),
    [anon_sym_byte] = ACTIONS(826),
    [anon_sym_return] = ACTIONS(826),
    [anon_sym_double] = ACTIONS(826),
    [sym_character_literal] = ACTIONS(828),
    [anon_sym_final] = ACTIONS(826),
    [anon_sym_TILDE] = ACTIONS(828),
    [anon_sym_try] = ACTIONS(826),
    [anon_sym_native] = ACTIONS(826),
    [anon_sym_volatile] = ACTIONS(826),
    [sym_hex_floating_point_literal] = ACTIONS(826),
    [anon_sym_BANG] = ACTIONS(828),
    [anon_sym_PLUS] = ACTIONS(826),
    [anon_sym_protected] = ACTIONS(826),
    [anon_sym_else] = ACTIONS(826),
    [anon_sym_class] = ACTIONS(826),
    [anon_sym_continue] = ACTIONS(826),
    [sym_hex_integer_literal] = ACTIONS(826),
    [anon_sym_default] = ACTIONS(826),
    [anon_sym_int] = ACTIONS(826),
    [anon_sym_transient] = ACTIONS(826),
    [sym_string_literal] = ACTIONS(828),
    [anon_sym_DASH] = ACTIONS(826),
    [anon_sym_do] = ACTIONS(826),
    [anon_sym_long] = ACTIONS(826),
    [anon_sym_float] = ACTIONS(826),
    [sym_boolean_type] = ACTIONS(826),
    [anon_sym_enum] = ACTIONS(826),
    [sym_identifier] = ACTIONS(826),
    [anon_sym_case] = ACTIONS(826),
    [ts_builtin_sym_end] = ACTIONS(828),
    [sym_void_type] = ACTIONS(826),
    [sym_true] = ACTIONS(826),
    [anon_sym_while] = ACTIONS(826),
    [sym_decimal_floating_point_literal] = ACTIONS(828),
    [anon_sym_RBRACE] = ACTIONS(828),
    [anon_sym_for] = ACTIONS(826),
    [anon_sym_static] = ACTIONS(826),
    [anon_sym_break] = ACTIONS(826),
    [anon_sym_open] = ACTIONS(826),
    [anon_sym_short] = ACTIONS(826),
    [anon_sym_public] = ACTIONS(826),
    [anon_sym_private] = ACTIONS(826),
    [anon_sym_char] = ACTIONS(826),
    [sym_this] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
    [sym_null_literal] = ACTIONS(826),
    [sym_octal_integer_literal] = ACTIONS(828),
    [anon_sym_throw] = ACTIONS(826),
    [sym_false] = ACTIONS(826),
    [anon_sym_import] = ACTIONS(826),
    [anon_sym_strictfp] = ACTIONS(826),
    [sym_binary_integer_literal] = ACTIONS(828),
    [anon_sym_LPAREN] = ACTIONS(828),
    [anon_sym_LBRACE] = ACTIONS(828),
    [anon_sym_ATinterface] = ACTIONS(828),
  },
  [194] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(830),
  },
  [195] = {
    [sym_false] = ACTIONS(832),
    [sym_string_literal] = ACTIONS(834),
    [anon_sym_LBRACE] = ACTIONS(834),
    [ts_builtin_sym_end] = ACTIONS(834),
    [anon_sym_final] = ACTIONS(832),
    [sym_decimal_integer_literal] = ACTIONS(832),
    [anon_sym_enum] = ACTIONS(832),
    [sym_identifier] = ACTIONS(832),
    [anon_sym_DASH_DASH] = ACTIONS(834),
    [anon_sym_do] = ACTIONS(832),
    [anon_sym_AT] = ACTIONS(832),
    [anon_sym_byte] = ACTIONS(832),
    [anon_sym_SEMI] = ACTIONS(834),
    [anon_sym_import] = ACTIONS(832),
    [anon_sym_while] = ACTIONS(832),
    [anon_sym_public] = ACTIONS(832),
    [anon_sym_strictfp] = ACTIONS(832),
    [anon_sym_else] = ACTIONS(832),
    [sym_binary_integer_literal] = ACTIONS(834),
    [anon_sym_return] = ACTIONS(832),
    [sym_decimal_floating_point_literal] = ACTIONS(834),
    [anon_sym_try] = ACTIONS(832),
    [anon_sym_interface] = ACTIONS(832),
    [sym_character_literal] = ACTIONS(834),
    [anon_sym_synchronized] = ACTIONS(832),
    [anon_sym_new] = ACTIONS(832),
    [anon_sym_for] = ACTIONS(832),
    [anon_sym_TILDE] = ACTIONS(834),
    [anon_sym_class] = ACTIONS(832),
    [anon_sym_char] = ACTIONS(832),
    [anon_sym_case] = ACTIONS(832),
    [anon_sym_PLUS_PLUS] = ACTIONS(834),
    [anon_sym_volatile] = ACTIONS(832),
    [sym_super] = ACTIONS(832),
    [anon_sym_BANG] = ACTIONS(834),
    [sym_true] = ACTIONS(832),
    [sym_octal_integer_literal] = ACTIONS(834),
    [sym_hex_floating_point_literal] = ACTIONS(832),
    [anon_sym_default] = ACTIONS(832),
    [anon_sym_abstract] = ACTIONS(832),
    [anon_sym_short] = ACTIONS(832),
    [anon_sym_float] = ACTIONS(832),
    [anon_sym_assert] = ACTIONS(832),
    [anon_sym_if] = ACTIONS(832),
    [sym_boolean_type] = ACTIONS(832),
    [anon_sym_DASH] = ACTIONS(832),
    [anon_sym_int] = ACTIONS(832),
    [sym_comment] = ACTIONS(3),
    [anon_sym_switch] = ACTIONS(832),
    [anon_sym_throw] = ACTIONS(832),
    [sym_null_literal] = ACTIONS(832),
    [sym_void_type] = ACTIONS(832),
    [anon_sym_continue] = ACTIONS(832),
    [anon_sym_package] = ACTIONS(832),
    [anon_sym_break] = ACTIONS(832),
    [anon_sym_open] = ACTIONS(832),
    [sym_hex_integer_literal] = ACTIONS(832),
    [anon_sym_module] = ACTIONS(832),
    [anon_sym_protected] = ACTIONS(832),
    [anon_sym_transient] = ACTIONS(832),
    [anon_sym_PLUS] = ACTIONS(832),
    [anon_sym_ATinterface] = ACTIONS(834),
    [anon_sym_long] = ACTIONS(832),
    [anon_sym_RBRACE] = ACTIONS(834),
    [anon_sym_private] = ACTIONS(832),
    [anon_sym_double] = ACTIONS(832),
    [sym_this] = ACTIONS(832),
    [anon_sym_static] = ACTIONS(832),
    [anon_sym_LPAREN] = ACTIONS(834),
    [anon_sym_native] = ACTIONS(832),
  },
  [196] = {
    [sym_identifier] = ACTIONS(836),
    [sym_comment] = ACTIONS(3),
  },
  [197] = {
    [anon_sym_DASH_GT] = ACTIONS(838),
    [sym_comment] = ACTIONS(3),
  },
  [198] = {
    [aux_sym_inferred_parameters_repeat1] = STATE(350),
    [anon_sym_COMMA] = ACTIONS(395),
    [anon_sym_RPAREN] = ACTIONS(840),
    [sym_comment] = ACTIONS(3),
  },
  [199] = {
    [anon_sym_DASH_GT] = ACTIONS(842),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(842),
    [anon_sym_AT] = ACTIONS(842),
    [anon_sym_LBRACE] = ACTIONS(842),
    [anon_sym_LBRACK] = ACTIONS(842),
    [anon_sym_throws] = ACTIONS(842),
  },
  [200] = {
    [sym_annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_marker_annotation] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym__annotation] = STATE(145),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(409),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [201] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(844),
  },
  [202] = {
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(352),
    [sym_array_type] = STATE(352),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(352),
    [sym_floating_point_type] = STATE(352),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(233),
    [sym_boolean_type] = ACTIONS(846),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_void_type] = ACTIONS(846),
    [anon_sym_int] = ACTIONS(33),
  },
  [203] = {
    [sym_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_dimensions] = STATE(144),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [anon_sym_AMP] = ACTIONS(660),
    [sym_identifier] = ACTIONS(848),
    [anon_sym_COLON_COLON] = ACTIONS(660),
    [sym_this] = ACTIONS(850),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_RPAREN] = ACTIONS(660),
  },
  [204] = {
    [sym_dimensions] = STATE(307),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_RPAREN] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(852),
    [anon_sym_float] = ACTIONS(852),
    [anon_sym_abstract] = ACTIONS(852),
    [anon_sym_AT] = ACTIONS(854),
    [anon_sym_short] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(673),
    [anon_sym_protected] = ACTIONS(852),
    [anon_sym_private] = ACTIONS(852),
    [sym_void_type] = ACTIONS(852),
    [anon_sym_transient] = ACTIONS(852),
    [anon_sym_long] = ACTIONS(852),
    [anon_sym_synchronized] = ACTIONS(852),
    [anon_sym_char] = ACTIONS(852),
    [anon_sym_strictfp] = ACTIONS(852),
    [anon_sym_native] = ACTIONS(852),
    [anon_sym_double] = ACTIONS(852),
    [anon_sym_static] = ACTIONS(852),
    [anon_sym_default] = ACTIONS(852),
    [anon_sym_final] = ACTIONS(852),
    [anon_sym_byte] = ACTIONS(852),
    [anon_sym_int] = ACTIONS(852),
    [sym_boolean_type] = ACTIONS(852),
    [anon_sym_DOT] = ACTIONS(857),
    [anon_sym_volatile] = ACTIONS(852),
    [sym_identifier] = ACTIONS(852),
  },
  [205] = {
    [anon_sym_volatile] = ACTIONS(859),
    [anon_sym_native] = ACTIONS(859),
    [anon_sym_byte] = ACTIONS(859),
    [sym_boolean_type] = ACTIONS(859),
    [sym_identifier] = ACTIONS(859),
    [anon_sym_double] = ACTIONS(859),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(861),
    [anon_sym_final] = ACTIONS(859),
    [anon_sym_short] = ACTIONS(859),
    [sym_void_type] = ACTIONS(859),
    [anon_sym_strictfp] = ACTIONS(859),
    [anon_sym_COMMA] = ACTIONS(861),
    [anon_sym_protected] = ACTIONS(859),
    [anon_sym_float] = ACTIONS(859),
    [anon_sym_AT] = ACTIONS(861),
    [anon_sym_char] = ACTIONS(859),
    [anon_sym_private] = ACTIONS(859),
    [anon_sym_static] = ACTIONS(859),
    [anon_sym_long] = ACTIONS(859),
    [anon_sym_default] = ACTIONS(859),
    [anon_sym_int] = ACTIONS(859),
    [anon_sym_abstract] = ACTIONS(859),
    [anon_sym_public] = ACTIONS(859),
    [anon_sym_synchronized] = ACTIONS(859),
    [anon_sym_transient] = ACTIONS(859),
  },
  [206] = {
    [sym_variable_declarator] = STATE(356),
    [sym__variable_declarator_id] = STATE(142),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_open] = ACTIONS(243),
    [sym_identifier] = ACTIONS(247),
    [sym_comment] = ACTIONS(3),
  },
  [207] = {
    [anon_sym_native] = ACTIONS(863),
    [anon_sym_char] = ACTIONS(863),
    [sym_identifier] = ACTIONS(863),
    [sym_comment] = ACTIONS(3),
    [anon_sym_abstract] = ACTIONS(863),
    [anon_sym_AT] = ACTIONS(865),
    [anon_sym_static] = ACTIONS(863),
    [anon_sym_synchronized] = ACTIONS(863),
    [anon_sym_private] = ACTIONS(863),
    [anon_sym_transient] = ACTIONS(863),
    [anon_sym_volatile] = ACTIONS(863),
    [anon_sym_byte] = ACTIONS(863),
    [anon_sym_short] = ACTIONS(863),
    [anon_sym_RPAREN] = ACTIONS(865),
    [anon_sym_final] = ACTIONS(863),
    [anon_sym_strictfp] = ACTIONS(863),
    [anon_sym_int] = ACTIONS(863),
    [anon_sym_double] = ACTIONS(863),
    [anon_sym_default] = ACTIONS(863),
    [anon_sym_protected] = ACTIONS(863),
    [sym_boolean_type] = ACTIONS(863),
    [anon_sym_COMMA] = ACTIONS(865),
    [anon_sym_public] = ACTIONS(863),
    [sym_void_type] = ACTIONS(863),
    [anon_sym_float] = ACTIONS(863),
    [anon_sym_long] = ACTIONS(863),
  },
  [208] = {
    [sym__unannotated_type] = STATE(73),
    [sym_annotated_type] = STATE(357),
    [sym_annotation] = STATE(74),
    [sym_integral_type] = STATE(73),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [sym__type] = STATE(357),
    [sym_array_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_byte] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(334),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(41),
    [sym_void_type] = ACTIONS(334),
    [anon_sym_char] = ACTIONS(33),
  },
  [209] = {
    [sym_unary_expression] = STATE(358),
    [sym__expression] = STATE(358),
    [sym_formal_parameters] = STATE(42),
    [sym__primary_no_new_array] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_object_creation_expression] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_method_invocation] = STATE(43),
    [sym__type] = STATE(37),
    [sym_binary_expression] = STATE(358),
    [sym_instanceof_expression] = STATE(358),
    [sym_lambda_expression] = STATE(358),
    [sym_array_type] = STATE(73),
    [sym_assignment_expression] = STATE(358),
    [sym_parenthesized_expression] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_annotation] = STATE(74),
    [sym_update_expression] = STATE(358),
    [sym__annotation] = STATE(74),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_scoped_identifier] = STATE(52),
    [sym_array_access] = STATE(39),
    [sym_field_access] = STATE(39),
    [sym__primary] = STATE(41),
    [sym__literal] = STATE(43),
    [sym_class_literal] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_floating_point_type] = STATE(30),
    [sym__unannotated_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym_cast_expression] = STATE(358),
    [sym_ternary_expression] = STATE(358),
    [sym_integral_type] = STATE(30),
    [sym_method_reference] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_character_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_module] = ACTIONS(120),
    [sym_super] = ACTIONS(9),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(120),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_double] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(49),
  },
  [210] = {
    [aux_sym_cast_expression_repeat1] = STATE(360),
    [anon_sym_AMP] = ACTIONS(411),
    [anon_sym_RPAREN] = ACTIONS(867),
    [sym_comment] = ACTIONS(3),
  },
  [211] = {
    [anon_sym_char] = ACTIONS(869),
    [anon_sym_COLON] = ACTIONS(869),
    [anon_sym_RBRACK] = ACTIONS(871),
    [anon_sym_import] = ACTIONS(869),
    [anon_sym_DASH_DASH] = ACTIONS(871),
    [anon_sym_final] = ACTIONS(869),
    [sym_false] = ACTIONS(869),
    [anon_sym_throw] = ACTIONS(869),
    [anon_sym_int] = ACTIONS(869),
    [anon_sym_CARET] = ACTIONS(871),
    [anon_sym_BANG] = ACTIONS(869),
    [anon_sym_static] = ACTIONS(869),
    [sym_hex_floating_point_literal] = ACTIONS(869),
    [sym_true] = ACTIONS(869),
    [anon_sym_protected] = ACTIONS(869),
    [anon_sym_SLASH] = ACTIONS(869),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_synchronized] = ACTIONS(869),
    [anon_sym_new] = ACTIONS(869),
    [sym_hex_integer_literal] = ACTIONS(869),
    [anon_sym_transient] = ACTIONS(869),
    [anon_sym_while] = ACTIONS(869),
    [anon_sym_LBRACK] = ACTIONS(871),
    [anon_sym_GT_EQ] = ACTIONS(871),
    [sym_this] = ACTIONS(869),
    [anon_sym_instanceof] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(869),
    [anon_sym_do] = ACTIONS(869),
    [anon_sym_private] = ACTIONS(869),
    [anon_sym_volatile] = ACTIONS(869),
    [anon_sym_LPAREN] = ACTIONS(871),
    [anon_sym_AMP_AMP] = ACTIONS(871),
    [anon_sym_DASH] = ACTIONS(869),
    [anon_sym_STAR] = ACTIONS(871),
    [anon_sym_ATinterface] = ACTIONS(871),
    [anon_sym_short] = ACTIONS(869),
    [sym_character_literal] = ACTIONS(871),
    [anon_sym_public] = ACTIONS(869),
    [anon_sym_switch] = ACTIONS(869),
    [sym_identifier] = ACTIONS(869),
    [anon_sym_GT] = ACTIONS(869),
    [anon_sym_DOT] = ACTIONS(869),
    [anon_sym_AT] = ACTIONS(869),
    [anon_sym_module] = ACTIONS(869),
    [anon_sym_break] = ACTIONS(869),
    [anon_sym_LBRACE] = ACTIONS(871),
    [sym_string_literal] = ACTIONS(871),
    [anon_sym_strictfp] = ACTIONS(869),
    [anon_sym_for] = ACTIONS(869),
    [anon_sym_COMMA] = ACTIONS(871),
    [anon_sym_RBRACE] = ACTIONS(871),
    [anon_sym_double] = ACTIONS(869),
    [anon_sym_QMARK] = ACTIONS(871),
    [anon_sym_package] = ACTIONS(869),
    [sym_void_type] = ACTIONS(869),
    [anon_sym_float] = ACTIONS(869),
    [anon_sym_long] = ACTIONS(869),
    [anon_sym_open] = ACTIONS(869),
    [anon_sym_AMP] = ACTIONS(869),
    [anon_sym_COLON_COLON] = ACTIONS(871),
    [anon_sym_if] = ACTIONS(869),
    [anon_sym_abstract] = ACTIONS(869),
    [anon_sym_byte] = ACTIONS(869),
    [sym_comment] = ACTIONS(3),
    [sym_binary_integer_literal] = ACTIONS(871),
    [anon_sym_LT_LT] = ACTIONS(871),
    [anon_sym_LT] = ACTIONS(869),
    [anon_sym_EQ_EQ] = ACTIONS(871),
    [anon_sym_class] = ACTIONS(869),
    [sym_null_literal] = ACTIONS(869),
    [anon_sym_GT_GT] = ACTIONS(869),
    [anon_sym_BANG_EQ] = ACTIONS(871),
    [sym_super] = ACTIONS(869),
    [anon_sym_return] = ACTIONS(869),
    [anon_sym_native] = ACTIONS(869),
    [anon_sym_LT_EQ] = ACTIONS(871),
    [anon_sym_interface] = ACTIONS(869),
    [sym_decimal_integer_literal] = ACTIONS(869),
    [anon_sym_PERCENT] = ACTIONS(871),
    [sym_decimal_floating_point_literal] = ACTIONS(871),
    [anon_sym_continue] = ACTIONS(869),
    [anon_sym_default] = ACTIONS(869),
    [sym_boolean_type] = ACTIONS(869),
    [sym_octal_integer_literal] = ACTIONS(871),
    [anon_sym_PIPE_PIPE] = ACTIONS(871),
    [anon_sym_enum] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(871),
    [anon_sym_PLUS_PLUS] = ACTIONS(871),
    [anon_sym_assert] = ACTIONS(869),
    [anon_sym_GT_GT_GT] = ACTIONS(871),
    [anon_sym_SEMI] = ACTIONS(871),
    [anon_sym_TILDE] = ACTIONS(871),
    [anon_sym_try] = ACTIONS(869),
  },
  [212] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(200),
    [sym__annotation] = STATE(902),
    [sym_marker_annotation] = STATE(902),
    [sym_annotation] = STATE(902),
    [sym_floating_point_type] = STATE(200),
    [sym_modifiers] = STATE(202),
    [sym_spread_parameter] = STATE(361),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_array_type] = STATE(200),
    [sym_integral_type] = STATE(200),
    [sym_void_type] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(844),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_synchronized] = ACTIONS(126),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(397),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_char] = ACTIONS(33),
  },
  [213] = {
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym__variable_declarator_id] = STATE(207),
    [sym_dimensions] = STATE(144),
    [sym_annotation] = STATE(145),
    [anon_sym_module] = ACTIONS(405),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(409),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_open] = ACTIONS(405),
    [sym_identifier] = ACTIONS(873),
  },
  [214] = {
    [sym_floating_point_type] = STATE(200),
    [sym_annotation] = STATE(902),
    [sym__unannotated_type] = STATE(200),
    [sym_integral_type] = STATE(200),
    [sym_modifiers] = STATE(202),
    [sym__annotation] = STATE(902),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_array_type] = STATE(200),
    [sym_spread_parameter] = STATE(361),
    [sym_marker_annotation] = STATE(902),
    [aux_sym_formal_parameters_repeat1] = STATE(363),
    [sym_generic_type] = STATE(53),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(875),
    [sym_void_type] = ACTIONS(397),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(233),
    [sym_boolean_type] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(844),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
  },
  [215] = {
    [sym_marker_annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(365),
    [sym_dimensions] = STATE(144),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_annotation] = STATE(145),
    [anon_sym_open] = ACTIONS(405),
    [sym_identifier] = ACTIONS(873),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(877),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_module] = ACTIONS(405),
    [sym_comment] = ACTIONS(3),
  },
  [216] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(213),
    [sym__annotation] = STATE(902),
    [sym_modifiers] = STATE(84),
    [sym_array_type] = STATE(213),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_generic_type] = STATE(53),
    [sym_marker_annotation] = STATE(902),
    [sym_floating_point_type] = STATE(213),
    [sym_spread_parameter] = STATE(361),
    [sym_formal_parameter] = STATE(366),
    [sym_annotation] = STATE(902),
    [sym__unannotated_type] = STATE(213),
    [sym_void_type] = ACTIONS(417),
    [anon_sym_RPAREN] = ACTIONS(844),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(417),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_double] = ACTIONS(41),
  },
  [217] = {
    [sym_spread_parameter] = STATE(361),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_modifiers] = STATE(202),
    [sym_annotation] = STATE(902),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(200),
    [sym__annotation] = STATE(902),
    [sym_array_type] = STATE(200),
    [sym_integral_type] = STATE(200),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [aux_sym_formal_parameters_repeat1] = STATE(367),
    [sym__unannotated_type] = STATE(200),
    [sym_marker_annotation] = STATE(902),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_private] = ACTIONS(126),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_COMMA] = ACTIONS(875),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [sym_void_type] = ACTIONS(397),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(844),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
  },
  [218] = {
    [anon_sym_PLUS_PLUS] = ACTIONS(879),
    [anon_sym_throw] = ACTIONS(881),
    [anon_sym_double] = ACTIONS(881),
    [anon_sym_case] = ACTIONS(881),
    [anon_sym_module] = ACTIONS(881),
    [anon_sym_ATinterface] = ACTIONS(879),
    [anon_sym_if] = ACTIONS(881),
    [sym_hex_integer_literal] = ACTIONS(881),
    [anon_sym_new] = ACTIONS(881),
    [sym_boolean_type] = ACTIONS(881),
    [anon_sym_DASH] = ACTIONS(881),
    [anon_sym_continue] = ACTIONS(881),
    [sym_decimal_integer_literal] = ACTIONS(881),
    [anon_sym_long] = ACTIONS(881),
    [anon_sym_static] = ACTIONS(881),
    [anon_sym_interface] = ACTIONS(881),
    [anon_sym_do] = ACTIONS(881),
    [anon_sym_protected] = ACTIONS(881),
    [anon_sym_LBRACE] = ACTIONS(879),
    [anon_sym_public] = ACTIONS(881),
    [anon_sym_default] = ACTIONS(881),
    [anon_sym_break] = ACTIONS(881),
    [anon_sym_try] = ACTIONS(881),
    [anon_sym_strictfp] = ACTIONS(881),
    [anon_sym_BANG] = ACTIONS(879),
    [sym_void_type] = ACTIONS(881),
    [anon_sym_import] = ACTIONS(881),
    [anon_sym_package] = ACTIONS(881),
    [anon_sym_LPAREN] = ACTIONS(879),
    [anon_sym_RBRACE] = ACTIONS(879),
    [anon_sym_TILDE] = ACTIONS(879),
    [sym_decimal_floating_point_literal] = ACTIONS(879),
    [anon_sym_while] = ACTIONS(881),
    [sym_null_literal] = ACTIONS(881),
    [anon_sym_transient] = ACTIONS(881),
    [sym_identifier] = ACTIONS(881),
    [anon_sym_char] = ACTIONS(881),
    [anon_sym_PLUS] = ACTIONS(881),
    [sym_octal_integer_literal] = ACTIONS(879),
    [ts_builtin_sym_end] = ACTIONS(879),
    [anon_sym_class] = ACTIONS(881),
    [anon_sym_volatile] = ACTIONS(881),
    [anon_sym_switch] = ACTIONS(881),
    [sym_super] = ACTIONS(881),
    [anon_sym_int] = ACTIONS(881),
    [anon_sym_native] = ACTIONS(881),
    [anon_sym_return] = ACTIONS(881),
    [anon_sym_AT] = ACTIONS(881),
    [anon_sym_final] = ACTIONS(881),
    [sym_hex_floating_point_literal] = ACTIONS(881),
    [sym_character_literal] = ACTIONS(879),
    [anon_sym_abstract] = ACTIONS(881),
    [sym_this] = ACTIONS(881),
    [sym_string_literal] = ACTIONS(879),
    [anon_sym_DASH_DASH] = ACTIONS(879),
    [anon_sym_short] = ACTIONS(881),
    [anon_sym_else] = ACTIONS(881),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(879),
    [sym_binary_integer_literal] = ACTIONS(879),
    [anon_sym_assert] = ACTIONS(881),
    [anon_sym_byte] = ACTIONS(881),
    [sym_false] = ACTIONS(881),
    [anon_sym_float] = ACTIONS(881),
    [anon_sym_synchronized] = ACTIONS(881),
    [anon_sym_open] = ACTIONS(881),
    [anon_sym_private] = ACTIONS(881),
    [sym_true] = ACTIONS(881),
    [anon_sym_enum] = ACTIONS(881),
    [anon_sym_for] = ACTIONS(881),
  },
  [219] = {
    [sym_argument_list] = STATE(342),
    [anon_sym_LT_LT] = ACTIONS(775),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_GT] = ACTIONS(775),
    [anon_sym_COMMA] = ACTIONS(777),
    [anon_sym_LBRACK] = ACTIONS(777),
    [anon_sym_GT_GT] = ACTIONS(775),
    [anon_sym_COLON_COLON] = ACTIONS(777),
    [anon_sym_SEMI] = ACTIONS(777),
    [anon_sym_PIPE_EQ] = ACTIONS(777),
    [anon_sym_QMARK] = ACTIONS(777),
    [anon_sym_PERCENT] = ACTIONS(775),
    [anon_sym_AMP_EQ] = ACTIONS(777),
    [anon_sym_LT] = ACTIONS(775),
    [anon_sym_PLUS] = ACTIONS(775),
    [anon_sym_PLUS_EQ] = ACTIONS(777),
    [anon_sym_PIPE] = ACTIONS(775),
    [anon_sym_CARET] = ACTIONS(775),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_LT_EQ] = ACTIONS(777),
    [anon_sym_RPAREN] = ACTIONS(777),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(777),
    [anon_sym_LT_LT_EQ] = ACTIONS(777),
    [anon_sym_instanceof] = ACTIONS(777),
    [anon_sym_SLASH] = ACTIONS(775),
    [anon_sym_EQ_EQ] = ACTIONS(777),
    [anon_sym_COLON] = ACTIONS(775),
    [anon_sym_SLASH_EQ] = ACTIONS(777),
    [anon_sym_GT_GT_GT] = ACTIONS(775),
    [anon_sym_DASH_EQ] = ACTIONS(777),
    [anon_sym_RBRACK] = ACTIONS(777),
    [anon_sym_AMP_AMP] = ACTIONS(777),
    [anon_sym_DOT] = ACTIONS(777),
    [anon_sym_AMP] = ACTIONS(775),
    [anon_sym_DASH_DASH] = ACTIONS(777),
    [anon_sym_PLUS_PLUS] = ACTIONS(777),
    [anon_sym_CARET_EQ] = ACTIONS(777),
    [anon_sym_RBRACE] = ACTIONS(777),
    [anon_sym_STAR_EQ] = ACTIONS(777),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PERCENT_EQ] = ACTIONS(777),
    [anon_sym_GT_EQ] = ACTIONS(777),
    [anon_sym_PIPE_PIPE] = ACTIONS(777),
    [anon_sym_GT_GT_EQ] = ACTIONS(777),
    [anon_sym_DASH] = ACTIONS(775),
    [anon_sym_BANG_EQ] = ACTIONS(777),
    [anon_sym_EQ] = ACTIONS(775),
  },
  [220] = {
    [anon_sym_enum] = ACTIONS(883),
    [anon_sym_DASH] = ACTIONS(883),
    [anon_sym_PLUS_PLUS] = ACTIONS(885),
    [anon_sym_AT] = ACTIONS(883),
    [sym_character_literal] = ACTIONS(885),
    [anon_sym_break] = ACTIONS(883),
    [sym_super] = ACTIONS(883),
    [anon_sym_SEMI] = ACTIONS(885),
    [anon_sym_assert] = ACTIONS(883),
    [anon_sym_byte] = ACTIONS(883),
    [sym_true] = ACTIONS(883),
    [anon_sym_synchronized] = ACTIONS(883),
    [anon_sym_float] = ACTIONS(883),
    [anon_sym_strictfp] = ACTIONS(883),
    [anon_sym_DASH_DASH] = ACTIONS(885),
    [anon_sym_continue] = ACTIONS(883),
    [anon_sym_volatile] = ACTIONS(883),
    [anon_sym_double] = ACTIONS(883),
    [anon_sym_LPAREN] = ACTIONS(885),
    [sym_hex_floating_point_literal] = ACTIONS(883),
    [anon_sym_interface] = ACTIONS(883),
    [anon_sym_transient] = ACTIONS(883),
    [anon_sym_switch] = ACTIONS(883),
    [anon_sym_if] = ACTIONS(883),
    [anon_sym_while] = ACTIONS(883),
    [sym_this] = ACTIONS(883),
    [anon_sym_TILDE] = ACTIONS(885),
    [sym_hex_integer_literal] = ACTIONS(883),
    [sym_binary_integer_literal] = ACTIONS(885),
    [anon_sym_RBRACE] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(883),
    [sym_comment] = ACTIONS(3),
    [anon_sym_static] = ACTIONS(883),
    [anon_sym_BANG] = ACTIONS(885),
    [anon_sym_final] = ACTIONS(883),
    [anon_sym_class] = ACTIONS(883),
    [sym_decimal_floating_point_literal] = ACTIONS(885),
    [sym_octal_integer_literal] = ACTIONS(885),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_import] = ACTIONS(883),
    [sym_false] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_short] = ACTIONS(883),
    [ts_builtin_sym_end] = ACTIONS(885),
    [anon_sym_new] = ACTIONS(883),
    [anon_sym_try] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_abstract] = ACTIONS(883),
    [anon_sym_ATinterface] = ACTIONS(885),
    [anon_sym_int] = ACTIONS(883),
    [sym_boolean_type] = ACTIONS(883),
    [sym_void_type] = ACTIONS(883),
    [anon_sym_package] = ACTIONS(883),
    [anon_sym_long] = ACTIONS(883),
    [anon_sym_else] = ACTIONS(887),
    [anon_sym_case] = ACTIONS(883),
    [anon_sym_open] = ACTIONS(883),
    [anon_sym_PLUS] = ACTIONS(883),
    [sym_identifier] = ACTIONS(883),
    [anon_sym_char] = ACTIONS(883),
    [anon_sym_throw] = ACTIONS(883),
    [anon_sym_native] = ACTIONS(883),
    [sym_string_literal] = ACTIONS(885),
    [anon_sym_module] = ACTIONS(883),
    [sym_decimal_integer_literal] = ACTIONS(883),
    [anon_sym_do] = ACTIONS(883),
    [sym_null_literal] = ACTIONS(883),
    [anon_sym_LBRACE] = ACTIONS(885),
    [anon_sym_default] = ACTIONS(883),
    [anon_sym_for] = ACTIONS(883),
  },
  [221] = {
    [sym_marker_annotation] = STATE(74),
    [sym_array_creation_expression] = STATE(41),
    [sym__type] = STATE(37),
    [sym__expression] = STATE(369),
    [sym_update_expression] = STATE(369),
    [sym_annotated_type] = STATE(37),
    [sym_object_creation_expression] = STATE(43),
    [sym_unary_expression] = STATE(369),
    [sym__unannotated_type] = STATE(73),
    [sym_annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym_array_type] = STATE(73),
    [sym_class_literal] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_lambda_expression] = STATE(369),
    [sym_integral_type] = STATE(30),
    [sym_floating_point_type] = STATE(30),
    [sym_assignment_expression] = STATE(369),
    [sym_scoped_identifier] = STATE(52),
    [sym_binary_expression] = STATE(369),
    [sym_method_invocation] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_field_access] = STATE(39),
    [sym__annotation] = STATE(74),
    [sym_ternary_expression] = STATE(369),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_method_reference] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym__literal] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_parenthesized_expression] = STATE(43),
    [sym_instanceof_expression] = STATE(369),
    [sym_formal_parameters] = STATE(42),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_cast_expression] = STATE(369),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_int] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_byte] = ACTIONS(33),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_AT] = ACTIONS(118),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_comment] = ACTIONS(3),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_true] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_super] = ACTIONS(9),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_char] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
  },
  [222] = {
    [sym_boolean_type] = ACTIONS(889),
    [anon_sym_open] = ACTIONS(889),
    [anon_sym_else] = ACTIONS(889),
    [anon_sym_char] = ACTIONS(889),
    [sym_character_literal] = ACTIONS(891),
    [ts_builtin_sym_end] = ACTIONS(891),
    [sym_comment] = ACTIONS(3),
    [anon_sym_native] = ACTIONS(889),
    [anon_sym_AT] = ACTIONS(889),
    [anon_sym_byte] = ACTIONS(889),
    [anon_sym_strictfp] = ACTIONS(889),
    [anon_sym_switch] = ACTIONS(889),
    [anon_sym_if] = ACTIONS(889),
    [sym_string_literal] = ACTIONS(891),
    [anon_sym_return] = ACTIONS(889),
    [anon_sym_while] = ACTIONS(889),
    [anon_sym_class] = ACTIONS(889),
    [anon_sym_assert] = ACTIONS(889),
    [anon_sym_synchronized] = ACTIONS(889),
    [anon_sym_throw] = ACTIONS(889),
    [anon_sym_static] = ACTIONS(889),
    [anon_sym_interface] = ACTIONS(889),
    [anon_sym_long] = ACTIONS(889),
    [anon_sym_double] = ACTIONS(889),
    [sym_this] = ACTIONS(889),
    [sym_super] = ACTIONS(889),
    [sym_true] = ACTIONS(889),
    [anon_sym_import] = ACTIONS(889),
    [sym_decimal_integer_literal] = ACTIONS(889),
    [anon_sym_PLUS_PLUS] = ACTIONS(891),
    [anon_sym_do] = ACTIONS(889),
    [sym_hex_floating_point_literal] = ACTIONS(889),
    [sym_octal_integer_literal] = ACTIONS(891),
    [anon_sym_int] = ACTIONS(889),
    [anon_sym_case] = ACTIONS(889),
    [sym_identifier] = ACTIONS(889),
    [sym_decimal_floating_point_literal] = ACTIONS(891),
    [anon_sym_transient] = ACTIONS(889),
    [sym_hex_integer_literal] = ACTIONS(889),
    [anon_sym_LBRACE] = ACTIONS(891),
    [sym_null_literal] = ACTIONS(889),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_TILDE] = ACTIONS(891),
    [anon_sym_continue] = ACTIONS(889),
    [anon_sym_package] = ACTIONS(889),
    [anon_sym_LPAREN] = ACTIONS(891),
    [anon_sym_abstract] = ACTIONS(889),
    [anon_sym_volatile] = ACTIONS(889),
    [anon_sym_RBRACE] = ACTIONS(891),
    [anon_sym_ATinterface] = ACTIONS(891),
    [anon_sym_module] = ACTIONS(889),
    [anon_sym_DASH_DASH] = ACTIONS(891),
    [anon_sym_protected] = ACTIONS(889),
    [anon_sym_try] = ACTIONS(889),
    [anon_sym_BANG] = ACTIONS(891),
    [sym_false] = ACTIONS(889),
    [anon_sym_new] = ACTIONS(889),
    [anon_sym_private] = ACTIONS(889),
    [anon_sym_PLUS] = ACTIONS(889),
    [anon_sym_SEMI] = ACTIONS(891),
    [sym_binary_integer_literal] = ACTIONS(891),
    [anon_sym_DASH] = ACTIONS(889),
    [anon_sym_float] = ACTIONS(889),
    [sym_void_type] = ACTIONS(889),
    [anon_sym_for] = ACTIONS(889),
    [anon_sym_default] = ACTIONS(889),
    [anon_sym_enum] = ACTIONS(889),
    [anon_sym_public] = ACTIONS(889),
    [anon_sym_short] = ACTIONS(889),
    [anon_sym_final] = ACTIONS(889),
  },
  [223] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_annotated_type] = STATE(370),
    [sym__unannotated_type] = STATE(73),
    [sym_annotation] = STATE(74),
    [sym_marker_annotation] = STATE(74),
    [sym__type] = STATE(370),
    [sym_generic_type] = STATE(53),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_floating_point_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym_array_type] = STATE(73),
    [sym_integral_type] = STATE(73),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [sym_void_type] = ACTIONS(334),
    [sym_boolean_type] = ACTIONS(334),
    [sym_comment] = ACTIONS(3),
    [anon_sym_int] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
  },
  [224] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym__annotation] = STATE(372),
    [sym_type_parameter] = STATE(373),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(893),
  },
  [225] = {
    [sym_normal_interface_declaration] = STATE(45),
    [aux_sym_enum_body_declarations_repeat1] = STATE(379),
    [sym_block] = STATE(379),
    [sym_field_declaration] = STATE(379),
    [sym_constructor_declaration] = STATE(379),
    [sym_marker_annotation] = STATE(44),
    [sym_annotation] = STATE(44),
    [sym__unannotated_type] = STATE(381),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_method_declaration] = STATE(379),
    [sym_array_type] = STATE(381),
    [sym__annotation] = STATE(44),
    [sym_type_parameters] = STATE(382),
    [sym__method_header] = STATE(378),
    [sym_integral_type] = STATE(381),
    [sym_enum_declaration] = STATE(379),
    [sym_interface_declaration] = STATE(379),
    [sym_scoped_type_identifier] = STATE(36),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_class_declaration] = STATE(379),
    [sym_static_initializer] = STATE(379),
    [sym_generic_type] = STATE(53),
    [sym_constructor_declarator] = STATE(377),
    [sym_modifiers] = STATE(380),
    [sym_floating_point_type] = STATE(381),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_native] = ACTIONS(7),
    [sym_void_type] = ACTIONS(895),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_static] = ACTIONS(897),
    [anon_sym_SEMI] = ACTIONS(899),
    [anon_sym_short] = ACTIONS(33),
    [sym_identifier] = ACTIONS(901),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_strictfp] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(903),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_synchronized] = ACTIONS(7),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_boolean_type] = ACTIONS(895),
  },
  [226] = {
    [sym_floating_point_type] = STATE(73),
    [sym_interface_type_list] = STATE(384),
    [sym_generic_type] = STATE(53),
    [sym_integral_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [sym__type] = STATE(383),
    [sym_annotated_type] = STATE(383),
    [sym__annotation] = STATE(74),
    [sym_annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__unannotated_type] = STATE(73),
    [sym_array_type] = STATE(73),
    [sym_boolean_type] = ACTIONS(334),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_void_type] = ACTIONS(334),
    [sym_identifier] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(41),
  },
  [227] = {
    [sym_super_interfaces] = STATE(387),
    [sym_class_body] = STATE(386),
    [sym_superclass] = STATE(385),
    [anon_sym_implements] = ACTIONS(441),
    [anon_sym_extends] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
  },
  [228] = {
    [sym_class_body] = STATE(388),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(439),
  },
  [229] = {
    [sym_class_body] = STATE(389),
    [sym_super_interfaces] = STATE(390),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_implements] = ACTIONS(441),
  },
  [230] = {
    [sym_null_literal] = ACTIONS(905),
    [anon_sym_else] = ACTIONS(905),
    [anon_sym_TILDE] = ACTIONS(907),
    [anon_sym_BANG] = ACTIONS(907),
    [anon_sym_class] = ACTIONS(905),
    [sym_void_type] = ACTIONS(905),
    [sym_string_literal] = ACTIONS(907),
    [sym_this] = ACTIONS(905),
    [anon_sym_new] = ACTIONS(905),
    [anon_sym_LT] = ACTIONS(907),
    [anon_sym_package] = ACTIONS(905),
    [sym_hex_integer_literal] = ACTIONS(905),
    [sym_true] = ACTIONS(905),
    [anon_sym_AT] = ACTIONS(905),
    [anon_sym_do] = ACTIONS(905),
    [anon_sym_public] = ACTIONS(905),
    [anon_sym_for] = ACTIONS(905),
    [anon_sym_DASH_DASH] = ACTIONS(907),
    [anon_sym_open] = ACTIONS(905),
    [anon_sym_final] = ACTIONS(905),
    [sym_decimal_floating_point_literal] = ACTIONS(907),
    [anon_sym_float] = ACTIONS(905),
    [anon_sym_byte] = ACTIONS(905),
    [sym_false] = ACTIONS(905),
    [anon_sym_LBRACE] = ACTIONS(907),
    [anon_sym_short] = ACTIONS(905),
    [anon_sym_return] = ACTIONS(905),
    [anon_sym_PLUS] = ACTIONS(905),
    [sym_identifier] = ACTIONS(905),
    [anon_sym_default] = ACTIONS(905),
    [anon_sym_throw] = ACTIONS(905),
    [anon_sym_long] = ACTIONS(905),
    [anon_sym_char] = ACTIONS(905),
    [anon_sym_volatile] = ACTIONS(905),
    [anon_sym_DASH] = ACTIONS(905),
    [anon_sym_abstract] = ACTIONS(905),
    [sym_character_literal] = ACTIONS(907),
    [anon_sym_break] = ACTIONS(905),
    [ts_builtin_sym_end] = ACTIONS(907),
    [anon_sym_PLUS_PLUS] = ACTIONS(907),
    [anon_sym_RBRACE] = ACTIONS(907),
    [anon_sym_static] = ACTIONS(905),
    [sym_boolean_type] = ACTIONS(905),
    [anon_sym_case] = ACTIONS(905),
    [anon_sym_strictfp] = ACTIONS(905),
    [anon_sym_try] = ACTIONS(905),
    [sym_hex_floating_point_literal] = ACTIONS(905),
    [anon_sym_synchronized] = ACTIONS(905),
    [sym_binary_integer_literal] = ACTIONS(907),
    [anon_sym_LPAREN] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
    [anon_sym_import] = ACTIONS(905),
    [sym_decimal_integer_literal] = ACTIONS(905),
    [anon_sym_while] = ACTIONS(905),
    [anon_sym_int] = ACTIONS(905),
    [anon_sym_protected] = ACTIONS(905),
    [anon_sym_interface] = ACTIONS(905),
    [anon_sym_SEMI] = ACTIONS(907),
    [anon_sym_ATinterface] = ACTIONS(907),
    [anon_sym_continue] = ACTIONS(905),
    [anon_sym_enum] = ACTIONS(905),
    [anon_sym_assert] = ACTIONS(905),
    [anon_sym_switch] = ACTIONS(905),
    [anon_sym_private] = ACTIONS(905),
    [anon_sym_native] = ACTIONS(905),
    [anon_sym_transient] = ACTIONS(905),
    [anon_sym_module] = ACTIONS(905),
    [sym_octal_integer_literal] = ACTIONS(907),
    [anon_sym_if] = ACTIONS(905),
    [anon_sym_double] = ACTIONS(905),
    [sym_super] = ACTIONS(905),
  },
  [231] = {
    [sym_integral_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [sym_annotated_type] = STATE(383),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_floating_point_type] = STATE(73),
    [sym_array_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym__type] = STATE(383),
    [sym__unannotated_type] = STATE(73),
    [sym_generic_type] = STATE(53),
    [sym_interface_type_list] = STATE(391),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotation] = STATE(74),
    [anon_sym_long] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(334),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [sym_void_type] = ACTIONS(334),
  },
  [232] = {
    [sym_annotation_type_declaration] = STATE(45),
    [sym_annotation] = STATE(44),
    [sym__method_header] = STATE(378),
    [sym_enum_declaration] = STATE(393),
    [sym_interface_declaration] = STATE(393),
    [sym_constant_declaration] = STATE(393),
    [sym_type_parameters] = STATE(396),
    [sym_marker_annotation] = STATE(44),
    [sym_array_type] = STATE(397),
    [sym_class_declaration] = STATE(393),
    [sym_integral_type] = STATE(397),
    [sym_modifiers] = STATE(394),
    [sym__annotation] = STATE(44),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_generic_type] = STATE(53),
    [aux_sym_interface_body_repeat1] = STATE(395),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_interface_member_declaration] = STATE(395),
    [sym_floating_point_type] = STATE(397),
    [sym__unannotated_type] = STATE(397),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_method_declaration] = STATE(393),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(909),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_void_type] = ACTIONS(911),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_private] = ACTIONS(7),
    [sym_boolean_type] = ACTIONS(911),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_interface] = ACTIONS(39),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_default] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_synchronized] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(913),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(7),
  },
  [233] = {
    [sym_interface_body] = STATE(398),
    [sym_extends_interfaces] = STATE(399),
    [anon_sym_extends] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
  },
  [234] = {
    [anon_sym_PLUS] = ACTIONS(915),
    [anon_sym_BANG] = ACTIONS(917),
    [anon_sym_ATinterface] = ACTIONS(917),
    [anon_sym_RBRACE] = ACTIONS(917),
    [anon_sym_int] = ACTIONS(915),
    [anon_sym_LBRACE] = ACTIONS(917),
    [ts_builtin_sym_end] = ACTIONS(917),
    [sym_binary_integer_literal] = ACTIONS(917),
    [anon_sym_abstract] = ACTIONS(915),
    [anon_sym_PLUS_PLUS] = ACTIONS(917),
    [sym_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(915),
    [anon_sym_break] = ACTIONS(915),
    [anon_sym_for] = ACTIONS(915),
    [anon_sym_float] = ACTIONS(915),
    [anon_sym_SEMI] = ACTIONS(917),
    [sym_string_literal] = ACTIONS(917),
    [anon_sym_TILDE] = ACTIONS(917),
    [sym_decimal_integer_literal] = ACTIONS(915),
    [anon_sym_char] = ACTIONS(915),
    [anon_sym_case] = ACTIONS(915),
    [sym_hex_floating_point_literal] = ACTIONS(915),
    [anon_sym_while] = ACTIONS(915),
    [sym_boolean_type] = ACTIONS(915),
    [sym_hex_integer_literal] = ACTIONS(915),
    [sym_identifier] = ACTIONS(915),
    [anon_sym_LPAREN] = ACTIONS(917),
    [anon_sym_DASH] = ACTIONS(915),
    [anon_sym_byte] = ACTIONS(915),
    [anon_sym_switch] = ACTIONS(915),
    [anon_sym_private] = ACTIONS(915),
    [anon_sym_long] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(915),
    [sym_character_literal] = ACTIONS(917),
    [anon_sym_strictfp] = ACTIONS(915),
    [anon_sym_volatile] = ACTIONS(915),
    [anon_sym_assert] = ACTIONS(915),
    [anon_sym_native] = ACTIONS(915),
    [anon_sym_class] = ACTIONS(915),
    [sym_octal_integer_literal] = ACTIONS(917),
    [anon_sym_static] = ACTIONS(915),
    [sym_super] = ACTIONS(915),
    [anon_sym_short] = ACTIONS(915),
    [anon_sym_protected] = ACTIONS(915),
    [anon_sym_final] = ACTIONS(915),
    [anon_sym_LT] = ACTIONS(917),
    [anon_sym_interface] = ACTIONS(915),
    [anon_sym_do] = ACTIONS(915),
    [anon_sym_package] = ACTIONS(915),
    [anon_sym_public] = ACTIONS(915),
    [anon_sym_throw] = ACTIONS(915),
    [anon_sym_enum] = ACTIONS(915),
    [anon_sym_DASH_DASH] = ACTIONS(917),
    [anon_sym_new] = ACTIONS(915),
    [sym_void_type] = ACTIONS(915),
    [anon_sym_continue] = ACTIONS(915),
    [sym_decimal_floating_point_literal] = ACTIONS(917),
    [anon_sym_else] = ACTIONS(915),
    [anon_sym_import] = ACTIONS(915),
    [anon_sym_transient] = ACTIONS(915),
    [anon_sym_default] = ACTIONS(915),
    [anon_sym_try] = ACTIONS(915),
    [sym_this] = ACTIONS(915),
    [sym_true] = ACTIONS(915),
    [anon_sym_return] = ACTIONS(915),
    [anon_sym_module] = ACTIONS(915),
    [anon_sym_open] = ACTIONS(915),
    [anon_sym_double] = ACTIONS(915),
    [anon_sym_synchronized] = ACTIONS(915),
    [sym_null_literal] = ACTIONS(915),
  },
  [235] = {
    [sym_interface_body] = STATE(398),
    [anon_sym_LBRACE] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
  },
  [236] = {
    [sym_marker_annotation] = STATE(184),
    [sym_annotation] = STATE(184),
    [aux_sym_dimensions_expr_repeat1] = STATE(184),
    [sym__annotation] = STATE(184),
    [sym_identifier] = ACTIONS(919),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
  },
  [237] = {
    [sym_binary_expression] = STATE(401),
    [sym_field_access] = STATE(39),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__type] = STATE(37),
    [sym_ternary_expression] = STATE(401),
    [sym_scoped_identifier] = STATE(52),
    [sym__primary] = STATE(41),
    [sym__literal] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_array_creation_expression] = STATE(41),
    [sym_unary_expression] = STATE(401),
    [sym_marker_annotation] = STATE(74),
    [sym__expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym_annotation] = STATE(74),
    [sym_assignment_expression] = STATE(401),
    [sym_method_invocation] = STATE(43),
    [sym_lambda_expression] = STATE(401),
    [sym__annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym_annotated_type] = STATE(37),
    [sym_parenthesized_expression] = STATE(43),
    [sym_class_literal] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_method_reference] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__unannotated_type] = STATE(73),
    [sym_formal_parameters] = STATE(42),
    [sym_integral_type] = STATE(30),
    [sym_generic_type] = STATE(53),
    [sym__primary_no_new_array] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_object_creation_expression] = STATE(43),
    [sym_cast_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [anon_sym_open] = ACTIONS(120),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_super] = ACTIONS(9),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(671),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(118),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [sym_true] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_void_type] = ACTIONS(55),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [sym_false] = ACTIONS(5),
    [sym_boolean_type] = ACTIONS(79),
    [sym_this] = ACTIONS(5),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_hex_integer_literal] = ACTIONS(5),
  },
  [238] = {
    [sym_array_initializer] = STATE(403),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(921),
  },
  [239] = {
    [sym_class_body] = STATE(404),
    [anon_sym_LT] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_RBRACK] = ACTIONS(925),
    [anon_sym_RBRACE] = ACTIONS(925),
    [anon_sym_PLUS_PLUS] = ACTIONS(925),
    [anon_sym_PERCENT] = ACTIONS(925),
    [anon_sym_DASH_DASH] = ACTIONS(925),
    [anon_sym_DASH] = ACTIONS(923),
    [anon_sym_STAR] = ACTIONS(925),
    [anon_sym_GT_GT] = ACTIONS(923),
    [anon_sym_RPAREN] = ACTIONS(925),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_QMARK] = ACTIONS(925),
    [anon_sym_GT] = ACTIONS(923),
    [anon_sym_SLASH] = ACTIONS(923),
    [anon_sym_COLON_COLON] = ACTIONS(925),
    [anon_sym_SEMI] = ACTIONS(925),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_GT_GT] = ACTIONS(925),
    [anon_sym_instanceof] = ACTIONS(925),
    [anon_sym_LT_EQ] = ACTIONS(925),
    [anon_sym_AMP] = ACTIONS(923),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_CARET] = ACTIONS(925),
    [anon_sym_LT_LT] = ACTIONS(925),
    [anon_sym_GT_EQ] = ACTIONS(925),
    [anon_sym_LBRACK] = ACTIONS(925),
    [anon_sym_COMMA] = ACTIONS(925),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_BANG_EQ] = ACTIONS(925),
    [anon_sym_EQ_EQ] = ACTIONS(925),
    [anon_sym_COLON] = ACTIONS(923),
    [anon_sym_DOT] = ACTIONS(925),
  },
  [240] = {
    [sym_annotation] = STATE(137),
    [sym_marker_annotation] = STATE(137),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym__annotation] = STATE(137),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(927),
  },
  [241] = {
    [sym_marker_annotation] = STATE(967),
    [sym_dimensions] = STATE(407),
    [sym__annotation] = STATE(967),
    [sym_dimensions_expr] = STATE(406),
    [sym_annotation] = STATE(967),
    [aux_sym_array_creation_expression_repeat1] = STATE(406),
    [aux_sym_dimensions_expr_repeat1] = STATE(967),
    [aux_sym_dimensions_repeat1] = STATE(915),
    [anon_sym_GT] = ACTIONS(929),
    [anon_sym_GT_GT_GT] = ACTIONS(931),
    [anon_sym_RBRACK] = ACTIONS(931),
    [anon_sym_PIPE] = ACTIONS(929),
    [anon_sym_PLUS_PLUS] = ACTIONS(931),
    [anon_sym_CARET] = ACTIONS(931),
    [anon_sym_COMMA] = ACTIONS(931),
    [anon_sym_PLUS] = ACTIONS(929),
    [anon_sym_DASH] = ACTIONS(929),
    [anon_sym_LT_EQ] = ACTIONS(931),
    [anon_sym_STAR] = ACTIONS(931),
    [anon_sym_SEMI] = ACTIONS(931),
    [anon_sym_AMP] = ACTIONS(929),
    [anon_sym_BANG_EQ] = ACTIONS(931),
    [anon_sym_LBRACK] = ACTIONS(933),
    [anon_sym_RPAREN] = ACTIONS(931),
    [anon_sym_LT] = ACTIONS(929),
    [anon_sym_SLASH] = ACTIONS(929),
    [anon_sym_RBRACE] = ACTIONS(931),
    [anon_sym_GT_EQ] = ACTIONS(931),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_COLON_COLON] = ACTIONS(931),
    [anon_sym_PERCENT] = ACTIONS(931),
    [anon_sym_LT_LT] = ACTIONS(931),
    [anon_sym_GT_GT] = ACTIONS(929),
    [anon_sym_AMP_AMP] = ACTIONS(931),
    [anon_sym_PIPE_PIPE] = ACTIONS(931),
    [anon_sym_DASH_DASH] = ACTIONS(931),
    [anon_sym_DOT] = ACTIONS(931),
    [anon_sym_instanceof] = ACTIONS(931),
    [sym_comment] = ACTIONS(3),
    [anon_sym_QMARK] = ACTIONS(931),
    [anon_sym_EQ_EQ] = ACTIONS(931),
    [anon_sym_COLON] = ACTIONS(929),
  },
  [242] = {
    [sym_array_initializer] = STATE(408),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(921),
  },
  [243] = {
    [sym_class_body] = STATE(409),
    [anon_sym_RPAREN] = ACTIONS(935),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_PLUS] = ACTIONS(937),
    [anon_sym_CARET] = ACTIONS(935),
    [anon_sym_PERCENT] = ACTIONS(935),
    [anon_sym_DOT] = ACTIONS(935),
    [anon_sym_DASH] = ACTIONS(937),
    [anon_sym_COLON_COLON] = ACTIONS(935),
    [anon_sym_AMP_AMP] = ACTIONS(935),
    [anon_sym_GT] = ACTIONS(937),
    [anon_sym_instanceof] = ACTIONS(935),
    [anon_sym_SLASH] = ACTIONS(937),
    [anon_sym_LT] = ACTIONS(937),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(935),
    [anon_sym_QMARK] = ACTIONS(935),
    [anon_sym_DASH_DASH] = ACTIONS(935),
    [anon_sym_LT_LT] = ACTIONS(935),
    [anon_sym_LBRACK] = ACTIONS(935),
    [anon_sym_EQ_EQ] = ACTIONS(935),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_COLON] = ACTIONS(937),
    [anon_sym_COMMA] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_GT_GT] = ACTIONS(937),
    [anon_sym_AMP] = ACTIONS(937),
    [anon_sym_BANG_EQ] = ACTIONS(935),
    [anon_sym_STAR] = ACTIONS(935),
    [anon_sym_LT_EQ] = ACTIONS(935),
    [anon_sym_GT_EQ] = ACTIONS(935),
    [anon_sym_GT_GT_GT] = ACTIONS(935),
    [anon_sym_RBRACE] = ACTIONS(935),
    [anon_sym_SEMI] = ACTIONS(935),
    [anon_sym_RBRACK] = ACTIONS(935),
  },
  [244] = {
    [sym__annotation] = STATE(967),
    [aux_sym_array_creation_expression_repeat1] = STATE(406),
    [sym_marker_annotation] = STATE(967),
    [sym_dimensions_expr] = STATE(406),
    [aux_sym_dimensions_expr_repeat1] = STATE(967),
    [aux_sym_dimensions_repeat1] = STATE(915),
    [sym_dimensions] = STATE(410),
    [sym_annotation] = STATE(967),
    [anon_sym_GT_EQ] = ACTIONS(939),
    [anon_sym_BANG_EQ] = ACTIONS(939),
    [anon_sym_DOT] = ACTIONS(939),
    [anon_sym_COLON_COLON] = ACTIONS(939),
    [anon_sym_PIPE] = ACTIONS(941),
    [anon_sym_instanceof] = ACTIONS(939),
    [anon_sym_DASH_DASH] = ACTIONS(939),
    [anon_sym_PLUS_PLUS] = ACTIONS(939),
    [anon_sym_GT_GT] = ACTIONS(941),
    [anon_sym_PERCENT] = ACTIONS(939),
    [anon_sym_SLASH] = ACTIONS(941),
    [anon_sym_QMARK] = ACTIONS(939),
    [anon_sym_PLUS] = ACTIONS(941),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(941),
    [anon_sym_LT_LT] = ACTIONS(939),
    [anon_sym_LT_EQ] = ACTIONS(939),
    [anon_sym_LT] = ACTIONS(941),
    [anon_sym_RPAREN] = ACTIONS(939),
    [anon_sym_EQ_EQ] = ACTIONS(939),
    [anon_sym_STAR] = ACTIONS(939),
    [anon_sym_PIPE_PIPE] = ACTIONS(939),
    [anon_sym_LBRACK] = ACTIONS(933),
    [anon_sym_RBRACE] = ACTIONS(939),
    [anon_sym_GT_GT_GT] = ACTIONS(939),
    [anon_sym_COMMA] = ACTIONS(939),
    [anon_sym_GT] = ACTIONS(941),
    [anon_sym_SEMI] = ACTIONS(939),
    [anon_sym_RBRACK] = ACTIONS(939),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_DASH] = ACTIONS(941),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_CARET] = ACTIONS(939),
  },
  [245] = {
    [sym_argument_list] = STATE(411),
    [anon_sym_LPAREN] = ACTIONS(112),
    [sym_comment] = ACTIONS(3),
  },
  [246] = {
    [sym_type_arguments] = STATE(64),
    [sym_argument_list] = STATE(412),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_DOT] = ACTIONS(447),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
  },
  [247] = {
    [sym_type_arguments] = STATE(132),
    [sym_argument_list] = STATE(411),
    [anon_sym_LPAREN] = ACTIONS(112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_DOT] = ACTIONS(451),
  },
  [248] = {
    [sym_argument_list] = STATE(411),
    [anon_sym_DOT] = ACTIONS(451),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(112),
  },
  [249] = {
    [sym_unary_expression] = STATE(49),
    [sym_while_statement] = STATE(416),
    [sym__declaration] = STATE(416),
    [sym_expression_statement] = STATE(416),
    [sym_block] = STATE(416),
    [sym_instanceof_expression] = STATE(49),
    [sym_try_with_resources_statement] = STATE(416),
    [aux_sym_switch_block_repeat1] = STATE(416),
    [sym_throw_statement] = STATE(416),
    [sym_formal_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(51),
    [sym_synchronized_statement] = STATE(416),
    [sym_modifiers] = STATE(48),
    [sym_switch_label] = STATE(416),
    [sym_try_statement] = STATE(416),
    [sym__primary_no_new_array] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym__type] = STATE(37),
    [sym_class_declaration] = STATE(416),
    [sym_package_declaration] = STATE(416),
    [sym_method_invocation] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_parenthesized_expression] = STATE(43),
    [sym_cast_expression] = STATE(49),
    [sym_labeled_statement] = STATE(416),
    [sym_local_variable_declaration_statement] = STATE(416),
    [sym_assignment_expression] = STATE(49),
    [sym_lambda_expression] = STATE(49),
    [sym_switch_statement] = STATE(416),
    [sym_do_statement] = STATE(416),
    [sym_generic_type] = STATE(53),
    [sym__expression] = STATE(49),
    [sym_array_creation_expression] = STATE(41),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_binary_expression] = STATE(49),
    [sym_if_statement] = STATE(416),
    [sym_continue_statement] = STATE(416),
    [sym_annotated_type] = STATE(37),
    [sym_break_statement] = STATE(416),
    [sym_module_declaration] = STATE(416),
    [sym__primary] = STATE(41),
    [sym__annotation] = STATE(51),
    [sym_update_expression] = STATE(49),
    [sym_return_statement] = STATE(416),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_field_access] = STATE(39),
    [sym_enhanced_for_statement] = STATE(416),
    [sym_import_declaration] = STATE(416),
    [sym_for_statement] = STATE(416),
    [sym_annotation] = STATE(51),
    [sym_floating_point_type] = STATE(30),
    [sym_local_variable_declaration] = STATE(47),
    [sym__literal] = STATE(43),
    [sym_enum_declaration] = STATE(416),
    [sym_interface_declaration] = STATE(416),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_assert_statement] = STATE(416),
    [sym_integral_type] = STATE(30),
    [sym_method_reference] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_class_literal] = STATE(43),
    [sym__unannotated_type] = STATE(40),
    [sym_array_access] = STATE(39),
    [sym_array_type] = STATE(40),
    [sym_scoped_identifier] = STATE(52),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_ternary_expression] = STATE(49),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_long] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_double] = ACTIONS(41),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(41),
    [sym_super] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(43),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(943),
    [anon_sym_synchronized] = ACTIONS(71),
    [sym_this] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_case] = ACTIONS(945),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(29),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_enum] = ACTIONS(67),
    [sym_character_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_strictfp] = ACTIONS(7),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_true] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_false] = ACTIONS(5),
    [anon_sym_private] = ACTIONS(7),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_default] = ACTIONS(947),
    [anon_sym_RBRACE] = ACTIONS(949),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_open] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
  },
  [250] = {
    [anon_sym_ATinterface] = ACTIONS(951),
    [anon_sym_byte] = ACTIONS(953),
    [anon_sym_LBRACE] = ACTIONS(951),
    [anon_sym_BANG] = ACTIONS(951),
    [anon_sym_char] = ACTIONS(953),
    [anon_sym_double] = ACTIONS(953),
    [anon_sym_native] = ACTIONS(953),
    [anon_sym_interface] = ACTIONS(953),
    [anon_sym_int] = ACTIONS(953),
    [anon_sym_module] = ACTIONS(953),
    [anon_sym_import] = ACTIONS(953),
    [anon_sym_default] = ACTIONS(953),
    [sym_string_literal] = ACTIONS(951),
    [anon_sym_open] = ACTIONS(953),
    [anon_sym_synchronized] = ACTIONS(953),
    [anon_sym_final] = ACTIONS(953),
    [sym_decimal_floating_point_literal] = ACTIONS(951),
    [anon_sym_do] = ACTIONS(953),
    [sym_binary_integer_literal] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(951),
    [anon_sym_abstract] = ACTIONS(953),
    [anon_sym_if] = ACTIONS(953),
    [anon_sym_continue] = ACTIONS(953),
    [anon_sym_TILDE] = ACTIONS(951),
    [anon_sym_private] = ACTIONS(953),
    [anon_sym_switch] = ACTIONS(953),
    [anon_sym_float] = ACTIONS(953),
    [anon_sym_PLUS] = ACTIONS(953),
    [anon_sym_break] = ACTIONS(953),
    [anon_sym_DASH] = ACTIONS(953),
    [anon_sym_volatile] = ACTIONS(953),
    [sym_this] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(953),
    [sym_void_type] = ACTIONS(953),
    [anon_sym_RBRACE] = ACTIONS(951),
    [sym_decimal_integer_literal] = ACTIONS(953),
    [sym_false] = ACTIONS(953),
    [anon_sym_SEMI] = ACTIONS(951),
    [anon_sym_package] = ACTIONS(953),
    [anon_sym_assert] = ACTIONS(953),
    [ts_builtin_sym_end] = ACTIONS(951),
    [anon_sym_case] = ACTIONS(953),
    [sym_octal_integer_literal] = ACTIONS(951),
    [anon_sym_try] = ACTIONS(953),
    [anon_sym_public] = ACTIONS(953),
    [sym_null_literal] = ACTIONS(953),
    [sym_hex_integer_literal] = ACTIONS(953),
    [anon_sym_throw] = ACTIONS(953),
    [sym_identifier] = ACTIONS(953),
    [anon_sym_else] = ACTIONS(953),
    [anon_sym_static] = ACTIONS(953),
    [anon_sym_protected] = ACTIONS(953),
    [anon_sym_new] = ACTIONS(953),
    [sym_character_literal] = ACTIONS(951),
    [anon_sym_strictfp] = ACTIONS(953),
    [anon_sym_PLUS_PLUS] = ACTIONS(951),
    [anon_sym_transient] = ACTIONS(953),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(953),
    [anon_sym_long] = ACTIONS(953),
    [sym_boolean_type] = ACTIONS(953),
    [sym_hex_floating_point_literal] = ACTIONS(953),
    [sym_true] = ACTIONS(953),
    [anon_sym_return] = ACTIONS(953),
    [anon_sym_AT] = ACTIONS(953),
    [anon_sym_DASH_DASH] = ACTIONS(951),
    [sym_super] = ACTIONS(953),
    [anon_sym_class] = ACTIONS(953),
    [anon_sym_for] = ACTIONS(953),
    [anon_sym_enum] = ACTIONS(953),
  },
  [251] = {
    [anon_sym_import] = ACTIONS(955),
    [anon_sym_native] = ACTIONS(955),
    [sym_binary_integer_literal] = ACTIONS(957),
    [anon_sym_float] = ACTIONS(955),
    [anon_sym_return] = ACTIONS(955),
    [anon_sym_new] = ACTIONS(955),
    [anon_sym_throw] = ACTIONS(955),
    [anon_sym_RBRACE] = ACTIONS(957),
    [anon_sym_DASH_DASH] = ACTIONS(957),
    [anon_sym_open] = ACTIONS(955),
    [anon_sym_BANG_EQ] = ACTIONS(957),
    [sym_string_literal] = ACTIONS(957),
    [anon_sym_assert] = ACTIONS(955),
    [anon_sym_SLASH] = ACTIONS(955),
    [anon_sym_QMARK] = ACTIONS(957),
    [anon_sym_break] = ACTIONS(955),
    [anon_sym_private] = ACTIONS(955),
    [anon_sym_interface] = ACTIONS(955),
    [anon_sym_RPAREN] = ACTIONS(957),
    [anon_sym_switch] = ACTIONS(955),
    [anon_sym_GT_GT_GT] = ACTIONS(957),
    [anon_sym_if] = ACTIONS(955),
    [anon_sym_PLUS] = ACTIONS(955),
    [anon_sym_module] = ACTIONS(955),
    [anon_sym_ATinterface] = ACTIONS(957),
    [anon_sym_final] = ACTIONS(955),
    [anon_sym_try] = ACTIONS(955),
    [sym_identifier] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(957),
    [anon_sym_synchronized] = ACTIONS(955),
    [anon_sym_instanceof] = ACTIONS(955),
    [anon_sym_strictfp] = ACTIONS(955),
    [anon_sym_LT_EQ] = ACTIONS(957),
    [sym_decimal_floating_point_literal] = ACTIONS(957),
    [anon_sym_COLON] = ACTIONS(957),
    [anon_sym_LT_LT] = ACTIONS(957),
    [anon_sym_DASH] = ACTIONS(955),
    [anon_sym_char] = ACTIONS(955),
    [sym_void_type] = ACTIONS(955),
    [sym_this] = ACTIONS(955),
    [anon_sym_GT_EQ] = ACTIONS(957),
    [anon_sym_long] = ACTIONS(955),
    [anon_sym_EQ_EQ] = ACTIONS(957),
    [anon_sym_AMP] = ACTIONS(955),
    [anon_sym_transient] = ACTIONS(955),
    [sym_false] = ACTIONS(955),
    [anon_sym_PIPE] = ACTIONS(955),
    [sym_hex_floating_point_literal] = ACTIONS(955),
    [anon_sym_else] = ACTIONS(955),
    [sym_null_literal] = ACTIONS(955),
    [anon_sym_PLUS_PLUS] = ACTIONS(957),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_GT] = ACTIONS(955),
    [anon_sym_for] = ACTIONS(955),
    [anon_sym_TILDE] = ACTIONS(957),
    [anon_sym_case] = ACTIONS(955),
    [sym_decimal_integer_literal] = ACTIONS(955),
    [anon_sym_COMMA] = ACTIONS(957),
    [anon_sym_AT] = ACTIONS(955),
    [anon_sym_abstract] = ACTIONS(955),
    [anon_sym_short] = ACTIONS(955),
    [anon_sym_public] = ACTIONS(955),
    [anon_sym_CARET] = ACTIONS(957),
    [anon_sym_enum] = ACTIONS(955),
    [sym_true] = ACTIONS(955),
    [anon_sym_LPAREN] = ACTIONS(957),
    [anon_sym_RBRACK] = ACTIONS(957),
    [sym_character_literal] = ACTIONS(957),
    [anon_sym_double] = ACTIONS(955),
    [anon_sym_continue] = ACTIONS(955),
    [anon_sym_STAR] = ACTIONS(957),
    [sym_octal_integer_literal] = ACTIONS(957),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_PERCENT] = ACTIONS(957),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(955),
    [anon_sym_class] = ACTIONS(955),
    [anon_sym_byte] = ACTIONS(955),
    [anon_sym_LT] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(957),
    [sym_hex_integer_literal] = ACTIONS(955),
    [anon_sym_volatile] = ACTIONS(955),
    [sym_super] = ACTIONS(955),
    [ts_builtin_sym_end] = ACTIONS(957),
    [anon_sym_default] = ACTIONS(955),
    [sym_boolean_type] = ACTIONS(955),
    [anon_sym_GT_GT] = ACTIONS(955),
    [anon_sym_int] = ACTIONS(955),
    [anon_sym_LBRACE] = ACTIONS(957),
    [anon_sym_do] = ACTIONS(955),
    [anon_sym_protected] = ACTIONS(955),
    [anon_sym_package] = ACTIONS(955),
    [anon_sym_static] = ACTIONS(955),
  },
  [252] = {
    [aux_sym_import_declaration_repeat1] = STATE(419),
    [anon_sym_SEMI] = ACTIONS(959),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(961),
  },
  [253] = {
    [sym_asterisk] = STATE(422),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(963),
    [sym_identifier] = ACTIONS(965),
  },
  [254] = {
    [anon_sym_native] = ACTIONS(967),
    [anon_sym_DASH_DASH] = ACTIONS(969),
    [anon_sym_byte] = ACTIONS(967),
    [anon_sym_abstract] = ACTIONS(967),
    [anon_sym_TILDE] = ACTIONS(969),
    [sym_character_literal] = ACTIONS(969),
    [anon_sym_RBRACE] = ACTIONS(969),
    [anon_sym_else] = ACTIONS(967),
    [anon_sym_switch] = ACTIONS(967),
    [anon_sym_case] = ACTIONS(967),
    [ts_builtin_sym_end] = ACTIONS(969),
    [sym_binary_integer_literal] = ACTIONS(969),
    [anon_sym_do] = ACTIONS(967),
    [anon_sym_long] = ACTIONS(967),
    [sym_null_literal] = ACTIONS(967),
    [anon_sym_import] = ACTIONS(967),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(967),
    [anon_sym_float] = ACTIONS(967),
    [sym_super] = ACTIONS(967),
    [anon_sym_private] = ACTIONS(967),
    [anon_sym_transient] = ACTIONS(967),
    [sym_decimal_integer_literal] = ACTIONS(967),
    [sym_hex_integer_literal] = ACTIONS(967),
    [anon_sym_interface] = ACTIONS(967),
    [anon_sym_break] = ACTIONS(967),
    [anon_sym_synchronized] = ACTIONS(967),
    [sym_string_literal] = ACTIONS(969),
    [anon_sym_double] = ACTIONS(967),
    [sym_hex_floating_point_literal] = ACTIONS(967),
    [anon_sym_default] = ACTIONS(967),
    [anon_sym_enum] = ACTIONS(967),
    [anon_sym_while] = ACTIONS(967),
    [anon_sym_final] = ACTIONS(967),
    [anon_sym_volatile] = ACTIONS(967),
    [anon_sym_try] = ACTIONS(967),
    [anon_sym_strictfp] = ACTIONS(967),
    [anon_sym_protected] = ACTIONS(967),
    [anon_sym_int] = ACTIONS(967),
    [anon_sym_if] = ACTIONS(967),
    [sym_decimal_floating_point_literal] = ACTIONS(969),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_continue] = ACTIONS(967),
    [anon_sym_class] = ACTIONS(967),
    [sym_octal_integer_literal] = ACTIONS(969),
    [anon_sym_assert] = ACTIONS(967),
    [anon_sym_short] = ACTIONS(967),
    [anon_sym_throw] = ACTIONS(967),
    [sym_true] = ACTIONS(967),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_AT] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_return] = ACTIONS(967),
    [anon_sym_module] = ACTIONS(967),
    [anon_sym_package] = ACTIONS(967),
    [sym_identifier] = ACTIONS(967),
    [anon_sym_PLUS_PLUS] = ACTIONS(969),
    [anon_sym_ATinterface] = ACTIONS(969),
    [sym_this] = ACTIONS(967),
    [sym_false] = ACTIONS(967),
    [anon_sym_char] = ACTIONS(967),
    [anon_sym_LBRACE] = ACTIONS(969),
    [anon_sym_for] = ACTIONS(967),
    [sym_void_type] = ACTIONS(967),
    [anon_sym_static] = ACTIONS(967),
    [anon_sym_SEMI] = ACTIONS(969),
    [anon_sym_open] = ACTIONS(967),
    [anon_sym_LPAREN] = ACTIONS(969),
    [anon_sym_public] = ACTIONS(967),
    [anon_sym_new] = ACTIONS(967),
  },
  [255] = {
    [aux_sym_import_declaration_repeat1] = STATE(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(959),
    [anon_sym_DOT] = ACTIONS(961),
  },
  [256] = {
    [sym__primary] = STATE(41),
    [sym__annotation] = STATE(428),
    [sym_element_value_array_initializer] = STATE(427),
    [sym__expression] = STATE(429),
    [sym__literal] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_parenthesized_expression] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym_inferred_parameters] = STATE(42),
    [sym_method_reference] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym__element_value] = STATE(427),
    [sym_object_creation_expression] = STATE(43),
    [sym_lambda_expression] = STATE(429),
    [sym_scoped_identifier] = STATE(52),
    [sym_class_literal] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_marker_annotation] = STATE(428),
    [sym_annotation] = STATE(428),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotated_type] = STATE(37),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_array_creation_expression] = STATE(41),
    [sym_formal_parameters] = STATE(42),
    [sym_cast_expression] = STATE(429),
    [sym__type] = STATE(37),
    [sym_array_access] = STATE(39),
    [sym_assignment_expression] = STATE(429),
    [sym_generic_type] = STATE(53),
    [sym__primary_no_new_array] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_element_value_pair] = STATE(430),
    [sym_instanceof_expression] = STATE(429),
    [sym__unannotated_type] = STATE(73),
    [sym_unary_expression] = STATE(429),
    [sym_method_invocation] = STATE(43),
    [sym_ternary_expression] = STATE(429),
    [sym_update_expression] = STATE(429),
    [sym_binary_expression] = STATE(429),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_false] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(971),
    [anon_sym_double] = ACTIONS(41),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_RPAREN] = ACTIONS(973),
    [anon_sym_float] = ACTIONS(41),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_identifier] = ACTIONS(975),
    [sym_super] = ACTIONS(9),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_char] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(120),
    [sym_string_literal] = ACTIONS(35),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
  },
  [257] = {
    [anon_sym_long] = ACTIONS(977),
    [anon_sym_strictfp] = ACTIONS(977),
    [anon_sym_ATinterface] = ACTIONS(979),
    [anon_sym_private] = ACTIONS(977),
    [sym_boolean_type] = ACTIONS(977),
    [anon_sym_volatile] = ACTIONS(977),
    [sym_void_type] = ACTIONS(977),
    [anon_sym_enum] = ACTIONS(977),
    [anon_sym_char] = ACTIONS(977),
    [anon_sym_final] = ACTIONS(977),
    [anon_sym_module] = ACTIONS(977),
    [anon_sym_native] = ACTIONS(977),
    [anon_sym_short] = ACTIONS(977),
    [anon_sym_default] = ACTIONS(977),
    [anon_sym_LT] = ACTIONS(979),
    [anon_sym_int] = ACTIONS(977),
    [anon_sym_AT] = ACTIONS(977),
    [anon_sym_byte] = ACTIONS(977),
    [anon_sym_open] = ACTIONS(977),
    [anon_sym_synchronized] = ACTIONS(977),
    [anon_sym_transient] = ACTIONS(977),
    [anon_sym_double] = ACTIONS(977),
    [sym_identifier] = ACTIONS(977),
    [anon_sym_class] = ACTIONS(977),
    [anon_sym_protected] = ACTIONS(977),
    [anon_sym_public] = ACTIONS(977),
    [anon_sym_interface] = ACTIONS(977),
    [anon_sym_abstract] = ACTIONS(977),
    [anon_sym_static] = ACTIONS(977),
    [sym_comment] = ACTIONS(3),
    [anon_sym_package] = ACTIONS(977),
    [anon_sym_float] = ACTIONS(977),
  },
  [258] = {
    [sym_boolean_type] = ACTIONS(981),
    [anon_sym_enum] = ACTIONS(981),
    [anon_sym_float] = ACTIONS(981),
    [ts_builtin_sym_end] = ACTIONS(983),
    [anon_sym_try] = ACTIONS(981),
    [sym_character_literal] = ACTIONS(983),
    [anon_sym_RBRACE] = ACTIONS(983),
    [anon_sym_strictfp] = ACTIONS(981),
    [anon_sym_static] = ACTIONS(981),
    [anon_sym_LBRACE] = ACTIONS(983),
    [anon_sym_continue] = ACTIONS(981),
    [sym_false] = ACTIONS(981),
    [anon_sym_LPAREN] = ACTIONS(983),
    [anon_sym_if] = ACTIONS(981),
    [sym_hex_integer_literal] = ACTIONS(981),
    [anon_sym_double] = ACTIONS(981),
    [anon_sym_DASH] = ACTIONS(981),
    [sym_hex_floating_point_literal] = ACTIONS(981),
    [anon_sym_abstract] = ACTIONS(981),
    [sym_super] = ACTIONS(981),
    [anon_sym_assert] = ACTIONS(981),
    [anon_sym_module] = ACTIONS(981),
    [sym_identifier] = ACTIONS(981),
    [sym_decimal_floating_point_literal] = ACTIONS(983),
    [anon_sym_SEMI] = ACTIONS(983),
    [anon_sym_case] = ACTIONS(981),
    [anon_sym_interface] = ACTIONS(981),
    [anon_sym_throw] = ACTIONS(981),
    [anon_sym_native] = ACTIONS(981),
    [anon_sym_private] = ACTIONS(981),
    [anon_sym_protected] = ACTIONS(981),
    [anon_sym_long] = ACTIONS(981),
    [anon_sym_synchronized] = ACTIONS(981),
    [anon_sym_for] = ACTIONS(981),
    [anon_sym_BANG] = ACTIONS(983),
    [sym_string_literal] = ACTIONS(983),
    [anon_sym_PLUS_PLUS] = ACTIONS(983),
    [anon_sym_new] = ACTIONS(981),
    [anon_sym_class] = ACTIONS(981),
    [anon_sym_open] = ACTIONS(981),
    [anon_sym_import] = ACTIONS(981),
    [anon_sym_final] = ACTIONS(981),
    [sym_binary_integer_literal] = ACTIONS(983),
    [sym_this] = ACTIONS(981),
    [anon_sym_do] = ACTIONS(981),
    [anon_sym_package] = ACTIONS(981),
    [anon_sym_return] = ACTIONS(981),
    [anon_sym_else] = ACTIONS(981),
    [sym_decimal_integer_literal] = ACTIONS(981),
    [sym_comment] = ACTIONS(3),
    [sym_null_literal] = ACTIONS(981),
    [anon_sym_char] = ACTIONS(981),
    [sym_octal_integer_literal] = ACTIONS(983),
    [anon_sym_int] = ACTIONS(981),
    [anon_sym_transient] = ACTIONS(981),
    [anon_sym_public] = ACTIONS(981),
    [anon_sym_short] = ACTIONS(981),
    [anon_sym_AT] = ACTIONS(981),
    [anon_sym_while] = ACTIONS(981),
    [anon_sym_ATinterface] = ACTIONS(983),
    [sym_void_type] = ACTIONS(981),
    [anon_sym_default] = ACTIONS(981),
    [anon_sym_TILDE] = ACTIONS(983),
    [anon_sym_DASH_DASH] = ACTIONS(983),
    [sym_true] = ACTIONS(981),
    [anon_sym_switch] = ACTIONS(981),
    [anon_sym_break] = ACTIONS(981),
    [anon_sym_PLUS] = ACTIONS(981),
    [anon_sym_volatile] = ACTIONS(981),
    [anon_sym_byte] = ACTIONS(981),
  },
  [259] = {
    [anon_sym_LPAREN] = ACTIONS(985),
    [sym_comment] = ACTIONS(3),
  },
  [260] = {
    [sym_interface_declaration] = STATE(434),
    [sym_modifiers] = STATE(435),
    [sym_integral_type] = STATE(433),
    [sym_array_type] = STATE(433),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_marker_annotation] = STATE(44),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_generic_type] = STATE(53),
    [sym__annotation] = STATE(44),
    [sym_floating_point_type] = STATE(433),
    [sym_annotation] = STATE(44),
    [sym_annotation_type_declaration] = STATE(45),
    [sym__unannotated_type] = STATE(433),
    [sym_scoped_type_identifier] = STATE(36),
    [aux_sym_annotation_type_body_repeat1] = STATE(436),
    [sym_class_declaration] = STATE(434),
    [sym_annotation_type_element_declaration] = STATE(434),
    [sym_annotation_type_member_declaration] = STATE(436),
    [sym_constant_declaration] = STATE(434),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_class] = ACTIONS(29),
    [sym_boolean_type] = ACTIONS(987),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(989),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_synchronized] = ACTIONS(7),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_public] = ACTIONS(7),
    [sym_void_type] = ACTIONS(987),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_byte] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_ATinterface] = ACTIONS(59),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(17),
  },
  [261] = {
    [anon_sym_short] = ACTIONS(991),
    [sym_boolean_type] = ACTIONS(991),
    [anon_sym_AT] = ACTIONS(991),
    [anon_sym_abstract] = ACTIONS(991),
    [anon_sym_TILDE] = ACTIONS(993),
    [anon_sym_module] = ACTIONS(991),
    [anon_sym_strictfp] = ACTIONS(991),
    [anon_sym_LPAREN] = ACTIONS(993),
    [anon_sym_PLUS] = ACTIONS(991),
    [sym_hex_floating_point_literal] = ACTIONS(991),
    [anon_sym_float] = ACTIONS(991),
    [anon_sym_open] = ACTIONS(991),
    [anon_sym_volatile] = ACTIONS(991),
    [anon_sym_DASH_DASH] = ACTIONS(993),
    [sym_string_literal] = ACTIONS(993),
    [anon_sym_double] = ACTIONS(991),
    [sym_hex_integer_literal] = ACTIONS(991),
    [anon_sym_private] = ACTIONS(991),
    [sym_void_type] = ACTIONS(991),
    [anon_sym_SEMI] = ACTIONS(993),
    [sym_decimal_floating_point_literal] = ACTIONS(993),
    [anon_sym_import] = ACTIONS(991),
    [anon_sym_LT] = ACTIONS(993),
    [anon_sym_for] = ACTIONS(991),
    [anon_sym_transient] = ACTIONS(991),
    [anon_sym_synchronized] = ACTIONS(991),
    [sym_decimal_integer_literal] = ACTIONS(991),
    [sym_this] = ACTIONS(991),
    [anon_sym_PLUS_PLUS] = ACTIONS(993),
    [ts_builtin_sym_end] = ACTIONS(993),
    [anon_sym_protected] = ACTIONS(991),
    [anon_sym_final] = ACTIONS(991),
    [sym_identifier] = ACTIONS(991),
    [anon_sym_public] = ACTIONS(991),
    [anon_sym_break] = ACTIONS(991),
    [anon_sym_static] = ACTIONS(991),
    [anon_sym_case] = ACTIONS(991),
    [anon_sym_long] = ACTIONS(991),
    [anon_sym_do] = ACTIONS(991),
    [anon_sym_enum] = ACTIONS(991),
    [anon_sym_BANG] = ACTIONS(993),
    [anon_sym_while] = ACTIONS(991),
    [sym_true] = ACTIONS(991),
    [anon_sym_switch] = ACTIONS(991),
    [anon_sym_LBRACE] = ACTIONS(993),
    [anon_sym_package] = ACTIONS(991),
    [anon_sym_ATinterface] = ACTIONS(993),
    [anon_sym_continue] = ACTIONS(991),
    [anon_sym_new] = ACTIONS(991),
    [sym_octal_integer_literal] = ACTIONS(993),
    [anon_sym_int] = ACTIONS(991),
    [anon_sym_char] = ACTIONS(991),
    [sym_comment] = ACTIONS(3),
    [sym_binary_integer_literal] = ACTIONS(993),
    [anon_sym_try] = ACTIONS(991),
    [anon_sym_native] = ACTIONS(991),
    [sym_null_literal] = ACTIONS(991),
    [anon_sym_else] = ACTIONS(991),
    [anon_sym_assert] = ACTIONS(991),
    [sym_character_literal] = ACTIONS(993),
    [sym_super] = ACTIONS(991),
    [anon_sym_default] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(991),
    [anon_sym_throw] = ACTIONS(991),
    [sym_false] = ACTIONS(991),
    [anon_sym_interface] = ACTIONS(991),
    [anon_sym_RBRACE] = ACTIONS(993),
    [anon_sym_byte] = ACTIONS(991),
    [anon_sym_DASH] = ACTIONS(991),
    [anon_sym_class] = ACTIONS(991),
    [anon_sym_return] = ACTIONS(991),
  },
  [262] = {
    [anon_sym_abstract] = ACTIONS(995),
    [anon_sym_for] = ACTIONS(995),
    [anon_sym_double] = ACTIONS(995),
    [anon_sym_private] = ACTIONS(995),
    [anon_sym_ATinterface] = ACTIONS(997),
    [anon_sym_open] = ACTIONS(995),
    [sym_true] = ACTIONS(995),
    [sym_character_literal] = ACTIONS(997),
    [anon_sym_TILDE] = ACTIONS(997),
    [anon_sym_switch] = ACTIONS(995),
    [sym_hex_integer_literal] = ACTIONS(995),
    [anon_sym_transient] = ACTIONS(995),
    [anon_sym_long] = ACTIONS(995),
    [anon_sym_package] = ACTIONS(995),
    [anon_sym_import] = ACTIONS(995),
    [anon_sym_case] = ACTIONS(995),
    [anon_sym_RBRACE] = ACTIONS(997),
    [anon_sym_enum] = ACTIONS(995),
    [anon_sym_DASH] = ACTIONS(995),
    [sym_super] = ACTIONS(995),
    [anon_sym_new] = ACTIONS(995),
    [anon_sym_return] = ACTIONS(995),
    [anon_sym_PLUS_PLUS] = ACTIONS(997),
    [anon_sym_final] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(995),
    [anon_sym_float] = ACTIONS(995),
    [sym_boolean_type] = ACTIONS(995),
    [anon_sym_protected] = ACTIONS(995),
    [anon_sym_PLUS] = ACTIONS(995),
    [anon_sym_interface] = ACTIONS(995),
    [sym_false] = ACTIONS(995),
    [anon_sym_strictfp] = ACTIONS(995),
    [anon_sym_AT] = ACTIONS(995),
    [sym_string_literal] = ACTIONS(997),
    [anon_sym_break] = ACTIONS(995),
    [anon_sym_short] = ACTIONS(995),
    [anon_sym_else] = ACTIONS(995),
    [sym_octal_integer_literal] = ACTIONS(997),
    [anon_sym_native] = ACTIONS(995),
    [anon_sym_int] = ACTIONS(995),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(997),
    [sym_decimal_floating_point_literal] = ACTIONS(997),
    [anon_sym_public] = ACTIONS(995),
    [anon_sym_synchronized] = ACTIONS(995),
    [anon_sym_module] = ACTIONS(995),
    [anon_sym_do] = ACTIONS(995),
    [anon_sym_char] = ACTIONS(995),
    [sym_identifier] = ACTIONS(995),
    [anon_sym_class] = ACTIONS(995),
    [anon_sym_SEMI] = ACTIONS(997),
    [sym_hex_floating_point_literal] = ACTIONS(995),
    [sym_null_literal] = ACTIONS(995),
    [sym_decimal_integer_literal] = ACTIONS(995),
    [anon_sym_if] = ACTIONS(995),
    [anon_sym_LBRACE] = ACTIONS(997),
    [anon_sym_byte] = ACTIONS(995),
    [anon_sym_default] = ACTIONS(995),
    [sym_binary_integer_literal] = ACTIONS(997),
    [anon_sym_volatile] = ACTIONS(995),
    [anon_sym_continue] = ACTIONS(995),
    [anon_sym_try] = ACTIONS(995),
    [sym_this] = ACTIONS(995),
    [ts_builtin_sym_end] = ACTIONS(997),
    [anon_sym_DASH_DASH] = ACTIONS(997),
    [anon_sym_throw] = ACTIONS(995),
    [anon_sym_LPAREN] = ACTIONS(997),
    [anon_sym_assert] = ACTIONS(995),
    [anon_sym_static] = ACTIONS(995),
    [sym_void_type] = ACTIONS(995),
  },
  [263] = {
    [sym_floating_point_type] = STATE(30),
    [sym_parenthesized_expression] = STATE(43),
    [sym_assignment_expression] = STATE(438),
    [sym_scoped_identifier] = STATE(52),
    [sym_binary_expression] = STATE(438),
    [sym_annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_inferred_parameters] = STATE(42),
    [sym__type] = STATE(37),
    [sym_array_access] = STATE(39),
    [sym_ternary_expression] = STATE(438),
    [sym_method_reference] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_cast_expression] = STATE(438),
    [sym__literal] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(73),
    [sym_field_access] = STATE(39),
    [sym_formal_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(74),
    [sym__primary_no_new_array] = STATE(43),
    [sym__annotation] = STATE(74),
    [sym_class_literal] = STATE(43),
    [sym_update_expression] = STATE(438),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_array_type] = STATE(73),
    [sym_array_creation_expression] = STATE(41),
    [sym_method_invocation] = STATE(43),
    [sym_unary_expression] = STATE(438),
    [sym__primary] = STATE(41),
    [sym_lambda_expression] = STATE(438),
    [sym_integral_type] = STATE(30),
    [sym_object_creation_expression] = STATE(43),
    [sym__expression] = STATE(438),
    [sym_instanceof_expression] = STATE(438),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(999),
    [anon_sym_long] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_false] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_void_type] = ACTIONS(55),
    [sym_this] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [sym_identifier] = ACTIONS(124),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(33),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_true] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(118),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
  },
  [264] = {
    [anon_sym_SEMI] = ACTIONS(1001),
    [sym_comment] = ACTIONS(3),
  },
  [265] = {
    [sym_generic_type] = STATE(53),
    [sym_integral_type] = STATE(440),
    [sym__unannotated_type] = STATE(440),
    [sym_array_type] = STATE(440),
    [sym_floating_point_type] = STATE(440),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(1003),
    [sym_void_type] = ACTIONS(1003),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
  },
  [266] = {
    [sym_dimensions] = STATE(144),
    [sym__variable_declarator_list] = STATE(146),
    [sym_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__variable_declarator_id] = STATE(441),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_variable_declarator] = STATE(143),
    [sym_marker_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [anon_sym_COLON_COLON] = ACTIONS(245),
    [anon_sym_open] = ACTIONS(243),
    [anon_sym_module] = ACTIONS(243),
    [sym_identifier] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [267] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1005),
  },
  [268] = {
    [aux_sym_argument_list_repeat1] = STATE(442),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_COMMA] = ACTIONS(771),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_SEMI] = ACTIONS(1005),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(289),
  },
  [269] = {
    [sym_modifiers] = STATE(449),
    [sym_enum_body_declarations] = STATE(448),
    [sym_annotation] = STATE(902),
    [sym_enum_constant] = STATE(447),
    [sym_marker_annotation] = STATE(902),
    [sym__annotation] = STATE(902),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_COMMA] = ACTIONS(1007),
    [sym_identifier] = ACTIONS(1009),
    [anon_sym_volatile] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_RBRACE] = ACTIONS(1011),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_final] = ACTIONS(126),
  },
  [270] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1015),
  },
  [271] = {
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_RPAREN] = ACTIONS(1017),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(287),
  },
  [272] = {
    [aux_sym_class_literal_repeat1] = STATE(126),
    [sym_argument_list] = STATE(127),
    [anon_sym_COLON_COLON] = ACTIONS(205),
    [anon_sym_DOT] = ACTIONS(215),
    [anon_sym_RPAREN] = ACTIONS(1019),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_SEMI] = ACTIONS(1019),
  },
  [273] = {
    [aux_sym_class_literal_repeat1] = STATE(66),
    [sym_type_arguments] = STATE(64),
    [sym_argument_list] = STATE(65),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_open] = ACTIONS(89),
    [anon_sym_DOT] = ACTIONS(1021),
    [anon_sym_module] = ACTIONS(89),
    [anon_sym_SEMI] = ACTIONS(1023),
    [anon_sym_AT] = ACTIONS(105),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(100),
    [anon_sym_RPAREN] = ACTIONS(1023),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(146),
  },
  [274] = {
    [sym_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_dimensions] = STATE(144),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(452),
    [sym__annotation] = STATE(145),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_COLON_COLON] = ACTIONS(245),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(243),
    [sym_identifier] = ACTIONS(247),
  },
  [275] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON_COLON] = ACTIONS(138),
    [anon_sym_DOT] = ACTIONS(253),
  },
  [276] = {
    [aux_sym_class_literal_repeat1] = STATE(66),
    [anon_sym_SEMI] = ACTIONS(1023),
    [anon_sym_LBRACK] = ACTIONS(320),
    [anon_sym_RPAREN] = ACTIONS(1023),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON_COLON] = ACTIONS(138),
    [anon_sym_DOT] = ACTIONS(322),
  },
  [277] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(453),
    [sym_generic_type] = STATE(53),
    [sym_array_type] = STATE(453),
    [sym__unannotated_type] = STATE(453),
    [sym_floating_point_type] = STATE(453),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(1025),
    [sym_void_type] = ACTIONS(1025),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
  },
  [278] = {
    [aux_sym_resource_specification_repeat1] = STATE(456),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1027),
    [anon_sym_RPAREN] = ACTIONS(1029),
  },
  [279] = {
    [anon_sym_SEMI] = ACTIONS(1023),
    [anon_sym_DOT] = ACTIONS(239),
    [anon_sym_LBRACK] = ACTIONS(239),
    [anon_sym_COLON_COLON] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1023),
  },
  [280] = {
    [aux_sym_try_statement_repeat1] = STATE(458),
    [sym_catch_clause] = STATE(458),
    [sym_finally_clause] = STATE(457),
    [anon_sym_static] = ACTIONS(1031),
    [anon_sym_byte] = ACTIONS(1031),
    [anon_sym_synchronized] = ACTIONS(1031),
    [anon_sym_TILDE] = ACTIONS(1033),
    [anon_sym_BANG] = ACTIONS(1033),
    [anon_sym_SEMI] = ACTIONS(1033),
    [anon_sym_while] = ACTIONS(1031),
    [anon_sym_try] = ACTIONS(1031),
    [anon_sym_continue] = ACTIONS(1031),
    [anon_sym_import] = ACTIONS(1031),
    [anon_sym_final] = ACTIONS(1031),
    [anon_sym_throw] = ACTIONS(1031),
    [anon_sym_for] = ACTIONS(1031),
    [anon_sym_volatile] = ACTIONS(1031),
    [anon_sym_char] = ACTIONS(1031),
    [anon_sym_break] = ACTIONS(1031),
    [anon_sym_module] = ACTIONS(1031),
    [anon_sym_abstract] = ACTIONS(1031),
    [anon_sym_LBRACE] = ACTIONS(1033),
    [anon_sym_enum] = ACTIONS(1031),
    [anon_sym_native] = ACTIONS(1031),
    [anon_sym_DASH_DASH] = ACTIONS(1033),
    [anon_sym_int] = ACTIONS(1031),
    [anon_sym_double] = ACTIONS(1031),
    [sym_boolean_type] = ACTIONS(1031),
    [anon_sym_LPAREN] = ACTIONS(1033),
    [anon_sym_catch] = ACTIONS(1035),
    [sym_this] = ACTIONS(1031),
    [anon_sym_short] = ACTIONS(1031),
    [anon_sym_default] = ACTIONS(1031),
    [ts_builtin_sym_end] = ACTIONS(1033),
    [sym_hex_floating_point_literal] = ACTIONS(1031),
    [anon_sym_case] = ACTIONS(1031),
    [anon_sym_new] = ACTIONS(1031),
    [anon_sym_class] = ACTIONS(1031),
    [sym_binary_integer_literal] = ACTIONS(1033),
    [sym_true] = ACTIONS(1031),
    [anon_sym_PLUS] = ACTIONS(1031),
    [sym_octal_integer_literal] = ACTIONS(1033),
    [anon_sym_return] = ACTIONS(1031),
    [sym_character_literal] = ACTIONS(1033),
    [sym_false] = ACTIONS(1031),
    [sym_null_literal] = ACTIONS(1031),
    [anon_sym_PLUS_PLUS] = ACTIONS(1033),
    [anon_sym_else] = ACTIONS(1031),
    [anon_sym_public] = ACTIONS(1031),
    [anon_sym_interface] = ACTIONS(1031),
    [anon_sym_open] = ACTIONS(1031),
    [anon_sym_DASH] = ACTIONS(1031),
    [anon_sym_do] = ACTIONS(1031),
    [anon_sym_float] = ACTIONS(1031),
    [sym_comment] = ACTIONS(3),
    [sym_string_literal] = ACTIONS(1033),
    [sym_hex_integer_literal] = ACTIONS(1031),
    [anon_sym_package] = ACTIONS(1031),
    [sym_void_type] = ACTIONS(1031),
    [anon_sym_long] = ACTIONS(1031),
    [anon_sym_finally] = ACTIONS(1037),
    [anon_sym_AT] = ACTIONS(1031),
    [anon_sym_assert] = ACTIONS(1031),
    [anon_sym_strictfp] = ACTIONS(1031),
    [sym_super] = ACTIONS(1031),
    [anon_sym_RBRACE] = ACTIONS(1033),
    [sym_identifier] = ACTIONS(1031),
    [anon_sym_if] = ACTIONS(1031),
    [anon_sym_switch] = ACTIONS(1031),
    [anon_sym_protected] = ACTIONS(1031),
    [anon_sym_ATinterface] = ACTIONS(1033),
    [sym_decimal_integer_literal] = ACTIONS(1031),
    [anon_sym_transient] = ACTIONS(1031),
    [anon_sym_private] = ACTIONS(1031),
    [sym_decimal_floating_point_literal] = ACTIONS(1033),
  },
  [281] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(1039),
  },
  [282] = {
    [sym_block] = STATE(460),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(75),
  },
  [283] = {
    [sym_true] = ACTIONS(1041),
    [anon_sym_TILDE] = ACTIONS(1043),
    [anon_sym_else] = ACTIONS(1041),
    [sym_void_type] = ACTIONS(1041),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_transient] = ACTIONS(1041),
    [sym_this] = ACTIONS(1041),
    [anon_sym_enum] = ACTIONS(1041),
    [sym_identifier] = ACTIONS(1041),
    [anon_sym_continue] = ACTIONS(1041),
    [anon_sym_throw] = ACTIONS(1041),
    [sym_binary_integer_literal] = ACTIONS(1043),
    [anon_sym_static] = ACTIONS(1041),
    [sym_decimal_integer_literal] = ACTIONS(1041),
    [anon_sym_synchronized] = ACTIONS(1041),
    [anon_sym_volatile] = ACTIONS(1041),
    [sym_decimal_floating_point_literal] = ACTIONS(1043),
    [anon_sym_SEMI] = ACTIONS(1043),
    [anon_sym_int] = ACTIONS(1041),
    [anon_sym_PLUS_PLUS] = ACTIONS(1043),
    [sym_character_literal] = ACTIONS(1043),
    [anon_sym_class] = ACTIONS(1041),
    [anon_sym_LPAREN] = ACTIONS(1043),
    [anon_sym_PLUS] = ACTIONS(1041),
    [anon_sym_interface] = ACTIONS(1041),
    [anon_sym_long] = ACTIONS(1041),
    [sym_super] = ACTIONS(1041),
    [anon_sym_do] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1041),
    [anon_sym_abstract] = ACTIONS(1041),
    [anon_sym_protected] = ACTIONS(1041),
    [anon_sym_RBRACE] = ACTIONS(1043),
    [anon_sym_switch] = ACTIONS(1041),
    [sym_false] = ACTIONS(1041),
    [sym_octal_integer_literal] = ACTIONS(1043),
    [anon_sym_LBRACE] = ACTIONS(1043),
    [sym_string_literal] = ACTIONS(1043),
    [anon_sym_if] = ACTIONS(1041),
    [anon_sym_package] = ACTIONS(1041),
    [anon_sym_final] = ACTIONS(1041),
    [anon_sym_native] = ACTIONS(1041),
    [anon_sym_short] = ACTIONS(1041),
    [anon_sym_break] = ACTIONS(1041),
    [sym_hex_floating_point_literal] = ACTIONS(1041),
    [anon_sym_module] = ACTIONS(1041),
    [anon_sym_import] = ACTIONS(1041),
    [ts_builtin_sym_end] = ACTIONS(1043),
    [anon_sym_try] = ACTIONS(1041),
    [anon_sym_char] = ACTIONS(1041),
    [anon_sym_double] = ACTIONS(1041),
    [anon_sym_open] = ACTIONS(1041),
    [anon_sym_assert] = ACTIONS(1041),
    [sym_null_literal] = ACTIONS(1041),
    [anon_sym_BANG] = ACTIONS(1043),
    [anon_sym_DASH_DASH] = ACTIONS(1043),
    [anon_sym_default] = ACTIONS(1041),
    [sym_hex_integer_literal] = ACTIONS(1041),
    [anon_sym_public] = ACTIONS(1041),
    [anon_sym_strictfp] = ACTIONS(1041),
    [anon_sym_ATinterface] = ACTIONS(1043),
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(1041),
    [anon_sym_AT] = ACTIONS(1041),
    [sym_boolean_type] = ACTIONS(1041),
    [anon_sym_byte] = ACTIONS(1041),
    [anon_sym_DASH] = ACTIONS(1041),
    [anon_sym_private] = ACTIONS(1041),
    [anon_sym_new] = ACTIONS(1041),
    [anon_sym_case] = ACTIONS(1041),
    [anon_sym_return] = ACTIONS(1041),
  },
  [284] = {
    [aux_sym_try_statement_repeat1] = STATE(462),
    [sym_catch_clause] = STATE(462),
    [sym_finally_clause] = STATE(461),
    [anon_sym_while] = ACTIONS(1041),
    [anon_sym_break] = ACTIONS(1041),
    [anon_sym_continue] = ACTIONS(1041),
    [anon_sym_synchronized] = ACTIONS(1041),
    [anon_sym_LPAREN] = ACTIONS(1043),
    [anon_sym_new] = ACTIONS(1041),
    [anon_sym_final] = ACTIONS(1041),
    [sym_super] = ACTIONS(1041),
    [sym_comment] = ACTIONS(3),
    [anon_sym_byte] = ACTIONS(1041),
    [sym_hex_floating_point_literal] = ACTIONS(1041),
    [sym_binary_integer_literal] = ACTIONS(1043),
    [anon_sym_PLUS] = ACTIONS(1041),
    [anon_sym_static] = ACTIONS(1041),
    [anon_sym_else] = ACTIONS(1041),
    [sym_string_literal] = ACTIONS(1043),
    [sym_this] = ACTIONS(1041),
    [anon_sym_if] = ACTIONS(1041),
    [anon_sym_AT] = ACTIONS(1041),
    [anon_sym_open] = ACTIONS(1041),
    [anon_sym_protected] = ACTIONS(1041),
    [sym_octal_integer_literal] = ACTIONS(1043),
    [anon_sym_ATinterface] = ACTIONS(1043),
    [anon_sym_class] = ACTIONS(1041),
    [anon_sym_abstract] = ACTIONS(1041),
    [anon_sym_PLUS_PLUS] = ACTIONS(1043),
    [anon_sym_short] = ACTIONS(1041),
    [sym_identifier] = ACTIONS(1041),
    [anon_sym_strictfp] = ACTIONS(1041),
    [anon_sym_float] = ACTIONS(1041),
    [anon_sym_DASH] = ACTIONS(1041),
    [anon_sym_private] = ACTIONS(1041),
    [sym_hex_integer_literal] = ACTIONS(1041),
    [anon_sym_assert] = ACTIONS(1041),
    [anon_sym_TILDE] = ACTIONS(1043),
    [anon_sym_double] = ACTIONS(1041),
    [anon_sym_volatile] = ACTIONS(1041),
    [anon_sym_import] = ACTIONS(1041),
    [anon_sym_do] = ACTIONS(1041),
    [anon_sym_interface] = ACTIONS(1041),
    [anon_sym_module] = ACTIONS(1041),
    [anon_sym_char] = ACTIONS(1041),
    [sym_false] = ACTIONS(1041),
    [ts_builtin_sym_end] = ACTIONS(1043),
    [anon_sym_throw] = ACTIONS(1041),
    [anon_sym_default] = ACTIONS(1041),
    [sym_null_literal] = ACTIONS(1041),
    [sym_void_type] = ACTIONS(1041),
    [sym_true] = ACTIONS(1041),
    [sym_decimal_floating_point_literal] = ACTIONS(1043),
    [anon_sym_enum] = ACTIONS(1041),
    [sym_boolean_type] = ACTIONS(1041),
    [anon_sym_int] = ACTIONS(1041),
    [anon_sym_long] = ACTIONS(1041),
    [anon_sym_SEMI] = ACTIONS(1043),
    [anon_sym_BANG] = ACTIONS(1043),
    [anon_sym_switch] = ACTIONS(1041),
    [anon_sym_return] = ACTIONS(1041),
    [anon_sym_case] = ACTIONS(1041),
    [anon_sym_DASH_DASH] = ACTIONS(1043),
    [anon_sym_package] = ACTIONS(1041),
    [anon_sym_try] = ACTIONS(1041),
    [anon_sym_RBRACE] = ACTIONS(1043),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_LBRACE] = ACTIONS(1043),
    [anon_sym_transient] = ACTIONS(1041),
    [anon_sym_native] = ACTIONS(1041),
    [anon_sym_finally] = ACTIONS(1037),
    [sym_decimal_integer_literal] = ACTIONS(1041),
    [sym_character_literal] = ACTIONS(1043),
    [anon_sym_public] = ACTIONS(1041),
    [anon_sym_catch] = ACTIONS(1035),
  },
  [285] = {
    [anon_sym_COLON] = ACTIONS(1045),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_SEMI] = ACTIONS(1045),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_RPAREN] = ACTIONS(1045),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_RBRACE] = ACTIONS(1045),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_COMMA] = ACTIONS(1045),
    [anon_sym_RBRACK] = ACTIONS(1045),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(285),
  },
  [286] = {
    [anon_sym_BANG_EQ] = ACTIONS(1047),
    [anon_sym_AMP_AMP] = ACTIONS(1047),
    [anon_sym_PIPE] = ACTIONS(1049),
    [anon_sym_SLASH_EQ] = ACTIONS(1047),
    [anon_sym_CARET_EQ] = ACTIONS(1047),
    [anon_sym_COLON] = ACTIONS(1049),
    [anon_sym_PERCENT_EQ] = ACTIONS(1047),
    [anon_sym_GT] = ACTIONS(1049),
    [anon_sym_DASH_DASH] = ACTIONS(1047),
    [anon_sym_GT_GT_GT] = ACTIONS(1049),
    [anon_sym_PIPE_EQ] = ACTIONS(1047),
    [anon_sym_SEMI] = ACTIONS(1047),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(1047),
    [anon_sym_instanceof] = ACTIONS(1047),
    [anon_sym_STAR_EQ] = ACTIONS(1047),
    [anon_sym_PERCENT] = ACTIONS(1049),
    [anon_sym_PLUS] = ACTIONS(1049),
    [anon_sym_DOT] = ACTIONS(1047),
    [anon_sym_CARET] = ACTIONS(1049),
    [anon_sym_EQ_EQ] = ACTIONS(1047),
    [anon_sym_RPAREN] = ACTIONS(1047),
    [anon_sym_PIPE_PIPE] = ACTIONS(1047),
    [anon_sym_PLUS_EQ] = ACTIONS(1047),
    [anon_sym_RBRACK] = ACTIONS(1047),
    [anon_sym_DASH] = ACTIONS(1049),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1047),
    [anon_sym_LBRACK] = ACTIONS(1047),
    [anon_sym_AMP_EQ] = ACTIONS(1047),
    [anon_sym_LT_LT_EQ] = ACTIONS(1047),
    [anon_sym_AMP] = ACTIONS(1049),
    [anon_sym_GT_EQ] = ACTIONS(1047),
    [anon_sym_STAR] = ACTIONS(1049),
    [anon_sym_QMARK] = ACTIONS(1047),
    [anon_sym_GT_GT_EQ] = ACTIONS(1047),
    [anon_sym_LT] = ACTIONS(1049),
    [anon_sym_COLON_COLON] = ACTIONS(1047),
    [anon_sym_SLASH] = ACTIONS(1049),
    [anon_sym_EQ] = ACTIONS(1049),
    [anon_sym_RBRACE] = ACTIONS(1047),
    [anon_sym_GT_GT] = ACTIONS(1049),
    [anon_sym_COMMA] = ACTIONS(1047),
    [anon_sym_LT_EQ] = ACTIONS(1047),
    [anon_sym_LT_LT] = ACTIONS(1049),
    [anon_sym_DASH_EQ] = ACTIONS(1047),
  },
  [287] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(1051),
  },
  [288] = {
    [sym_argument_list] = STATE(464),
    [anon_sym_GT_GT_GT] = ACTIONS(1053),
    [anon_sym_GT_GT] = ACTIONS(1053),
    [anon_sym_LBRACK] = ACTIONS(1055),
    [anon_sym_SEMI] = ACTIONS(1055),
    [anon_sym_PIPE_EQ] = ACTIONS(1055),
    [anon_sym_DASH_EQ] = ACTIONS(1055),
    [anon_sym_AMP_EQ] = ACTIONS(1055),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1055),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_PERCENT_EQ] = ACTIONS(1055),
    [anon_sym_PLUS_EQ] = ACTIONS(1055),
    [anon_sym_DASH_DASH] = ACTIONS(1055),
    [anon_sym_GT_GT_EQ] = ACTIONS(1055),
    [anon_sym_LT] = ACTIONS(1053),
    [anon_sym_LT_EQ] = ACTIONS(1055),
    [anon_sym_PERCENT] = ACTIONS(1053),
    [anon_sym_COLON_COLON] = ACTIONS(1055),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1053),
    [anon_sym_CARET] = ACTIONS(1053),
    [anon_sym_PIPE] = ACTIONS(1053),
    [anon_sym_GT_EQ] = ACTIONS(1055),
    [anon_sym_STAR_EQ] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(1053),
    [anon_sym_AMP] = ACTIONS(1053),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_LT_LT] = ACTIONS(1053),
    [anon_sym_RBRACK] = ACTIONS(1055),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1055),
    [anon_sym_PLUS_PLUS] = ACTIONS(1055),
    [anon_sym_RPAREN] = ACTIONS(1055),
    [anon_sym_RBRACE] = ACTIONS(1055),
    [anon_sym_PIPE_PIPE] = ACTIONS(1055),
    [anon_sym_CARET_EQ] = ACTIONS(1055),
    [anon_sym_LT_LT_EQ] = ACTIONS(1055),
    [anon_sym_STAR] = ACTIONS(1053),
    [anon_sym_COMMA] = ACTIONS(1055),
    [anon_sym_EQ] = ACTIONS(1053),
    [anon_sym_GT] = ACTIONS(1053),
    [anon_sym_DASH] = ACTIONS(1053),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_SLASH_EQ] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(1053),
  },
  [289] = {
    [anon_sym_AMP] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1059),
    [anon_sym_PERCENT] = ACTIONS(1059),
    [anon_sym_PLUS_PLUS] = ACTIONS(1059),
    [anon_sym_SEMI] = ACTIONS(1059),
    [anon_sym_PIPE_PIPE] = ACTIONS(1059),
    [anon_sym_RBRACE] = ACTIONS(1059),
    [anon_sym_EQ_EQ] = ACTIONS(1059),
    [anon_sym_RBRACK] = ACTIONS(1059),
    [anon_sym_DASH] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1059),
    [anon_sym_PLUS] = ACTIONS(1057),
    [anon_sym_CARET] = ACTIONS(1059),
    [anon_sym_GT_EQ] = ACTIONS(1059),
    [anon_sym_RPAREN] = ACTIONS(1059),
    [anon_sym_QMARK] = ACTIONS(1059),
    [anon_sym_COLON] = ACTIONS(1057),
    [anon_sym_GT] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1057),
    [anon_sym_DOT] = ACTIONS(1059),
    [anon_sym_LT] = ACTIONS(1057),
    [anon_sym_LBRACK] = ACTIONS(1059),
    [anon_sym_BANG_EQ] = ACTIONS(1059),
    [anon_sym_SLASH] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1057),
    [anon_sym_COLON_COLON] = ACTIONS(1059),
    [anon_sym_AMP_AMP] = ACTIONS(1059),
    [anon_sym_STAR] = ACTIONS(1059),
    [anon_sym_GT_GT_GT] = ACTIONS(1059),
    [anon_sym_DASH_DASH] = ACTIONS(1059),
    [anon_sym_COMMA] = ACTIONS(1059),
    [sym_comment] = ACTIONS(3),
    [anon_sym_instanceof] = ACTIONS(1059),
  },
  [290] = {
    [sym_identifier] = ACTIONS(1061),
    [sym_comment] = ACTIONS(3),
  },
  [291] = {
    [anon_sym_LT_EQ] = ACTIONS(1063),
    [anon_sym_AMP_AMP] = ACTIONS(1063),
    [anon_sym_BANG_EQ] = ACTIONS(1063),
    [anon_sym_PIPE_PIPE] = ACTIONS(1063),
    [anon_sym_GT_GT_GT] = ACTIONS(1063),
    [anon_sym_LBRACK] = ACTIONS(1063),
    [anon_sym_COLON] = ACTIONS(1065),
    [anon_sym_PERCENT] = ACTIONS(1063),
    [anon_sym_DASH_DASH] = ACTIONS(1063),
    [anon_sym_COLON_COLON] = ACTIONS(1063),
    [anon_sym_STAR] = ACTIONS(1063),
    [anon_sym_SLASH] = ACTIONS(1065),
    [anon_sym_SEMI] = ACTIONS(1063),
    [anon_sym_GT_EQ] = ACTIONS(1063),
    [anon_sym_GT] = ACTIONS(1065),
    [anon_sym_RPAREN] = ACTIONS(1063),
    [anon_sym_CARET] = ACTIONS(1063),
    [anon_sym_LT] = ACTIONS(1065),
    [anon_sym_AMP] = ACTIONS(1065),
    [anon_sym_EQ_EQ] = ACTIONS(1063),
    [anon_sym_DOT] = ACTIONS(1063),
    [anon_sym_COMMA] = ACTIONS(1063),
    [anon_sym_DASH] = ACTIONS(1065),
    [anon_sym_PLUS_PLUS] = ACTIONS(1063),
    [anon_sym_PLUS] = ACTIONS(1065),
    [anon_sym_GT_GT] = ACTIONS(1065),
    [anon_sym_QMARK] = ACTIONS(1063),
    [anon_sym_RBRACK] = ACTIONS(1063),
    [anon_sym_PIPE] = ACTIONS(1065),
    [anon_sym_LT_LT] = ACTIONS(1063),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1063),
    [anon_sym_instanceof] = ACTIONS(1063),
  },
  [292] = {
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_RBRACK] = ACTIONS(1067),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(293),
  },
  [293] = {
    [anon_sym_CARET] = ACTIONS(1069),
    [anon_sym_GT_EQ] = ACTIONS(1069),
    [anon_sym_STAR] = ACTIONS(1069),
    [anon_sym_DOT] = ACTIONS(1069),
    [anon_sym_RPAREN] = ACTIONS(1069),
    [anon_sym_LT] = ACTIONS(1071),
    [anon_sym_GT] = ACTIONS(1071),
    [anon_sym_COMMA] = ACTIONS(1069),
    [anon_sym_RBRACE] = ACTIONS(1069),
    [anon_sym_GT_GT_GT] = ACTIONS(1069),
    [anon_sym_PIPE_PIPE] = ACTIONS(1069),
    [anon_sym_PLUS_PLUS] = ACTIONS(1069),
    [anon_sym_instanceof] = ACTIONS(1069),
    [anon_sym_GT_GT] = ACTIONS(1071),
    [anon_sym_PLUS] = ACTIONS(1071),
    [anon_sym_SLASH] = ACTIONS(1071),
    [anon_sym_AMP] = ACTIONS(1071),
    [anon_sym_DASH_DASH] = ACTIONS(1069),
    [anon_sym_LT_LT] = ACTIONS(1069),
    [anon_sym_LT_EQ] = ACTIONS(1069),
    [anon_sym_AMP_AMP] = ACTIONS(1069),
    [anon_sym_DASH] = ACTIONS(1071),
    [anon_sym_PIPE] = ACTIONS(1071),
    [anon_sym_EQ_EQ] = ACTIONS(1069),
    [anon_sym_BANG_EQ] = ACTIONS(1069),
    [anon_sym_PERCENT] = ACTIONS(1069),
    [anon_sym_LBRACK] = ACTIONS(1069),
    [anon_sym_RBRACK] = ACTIONS(1069),
    [anon_sym_COLON_COLON] = ACTIONS(1069),
    [anon_sym_COLON] = ACTIONS(1071),
    [anon_sym_QMARK] = ACTIONS(1069),
    [anon_sym_SEMI] = ACTIONS(1069),
    [sym_comment] = ACTIONS(3),
  },
  [294] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(1073),
    [anon_sym_new] = ACTIONS(1073),
  },
  [295] = {
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_LBRACE] = ACTIONS(1075),
    [sym_comment] = ACTIONS(3),
  },
  [296] = {
    [anon_sym_LBRACE] = ACTIONS(1077),
    [anon_sym_DOT] = ACTIONS(368),
    [sym_comment] = ACTIONS(3),
  },
  [297] = {
    [anon_sym_class] = ACTIONS(1079),
    [sym_comment] = ACTIONS(3),
  },
  [298] = {
    [sym_module_directive] = STATE(476),
    [aux_sym_module_declaration_repeat1] = STATE(476),
    [sym_comment] = ACTIONS(3),
    [anon_sym_provides] = ACTIONS(1081),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_RBRACE] = ACTIONS(1085),
    [anon_sym_requires] = ACTIONS(1087),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_exports] = ACTIONS(1089),
  },
  [299] = {
    [aux_sym_module_declaration_repeat1] = STATE(478),
    [sym_module_directive] = STATE(478),
    [anon_sym_uses] = ACTIONS(1083),
    [sym_comment] = ACTIONS(3),
    [anon_sym_requires] = ACTIONS(1087),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_RBRACE] = ACTIONS(1091),
    [anon_sym_provides] = ACTIONS(1081),
    [anon_sym_opens] = ACTIONS(1089),
  },
  [300] = {
    [anon_sym_implements] = ACTIONS(1093),
    [anon_sym_LBRACK] = ACTIONS(1095),
    [anon_sym_PIPE] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1095),
    [anon_sym_AT] = ACTIONS(1095),
    [anon_sym_LT] = ACTIONS(1095),
    [anon_sym_LBRACE] = ACTIONS(1095),
    [anon_sym_COLON_COLON] = ACTIONS(1095),
    [anon_sym_module] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_COMMA] = ACTIONS(1095),
    [sym_this] = ACTIONS(1093),
    [anon_sym_open] = ACTIONS(1093),
    [anon_sym_DOT] = ACTIONS(1093),
    [anon_sym_GT] = ACTIONS(1095),
    [anon_sym_AMP] = ACTIONS(1095),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1095),
    [sym_identifier] = ACTIONS(1093),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1095),
  },
  [301] = {
    [sym_annotation] = STATE(137),
    [sym__annotation] = STATE(137),
    [sym_marker_annotation] = STATE(137),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(1097),
  },
  [302] = {
    [sym_scoped_identifier] = STATE(481),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(1099),
    [anon_sym_module] = ACTIONS(1099),
    [sym_identifier] = ACTIONS(1101),
  },
  [303] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1103),
    [anon_sym_DOT] = ACTIONS(368),
  },
  [304] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_SEMI] = ACTIONS(1105),
  },
  [305] = {
    [anon_sym_volatile] = ACTIONS(1107),
    [anon_sym_abstract] = ACTIONS(1107),
    [anon_sym_SEMI] = ACTIONS(1109),
    [sym_void_type] = ACTIONS(1107),
    [anon_sym_default] = ACTIONS(1107),
    [anon_sym_int] = ACTIONS(1107),
    [anon_sym_private] = ACTIONS(1107),
    [anon_sym_COMMA] = ACTIONS(1109),
    [anon_sym_byte] = ACTIONS(1107),
    [anon_sym_synchronized] = ACTIONS(1107),
    [anon_sym_public] = ACTIONS(1107),
    [sym_boolean_type] = ACTIONS(1107),
    [anon_sym_AT] = ACTIONS(1109),
    [anon_sym_transient] = ACTIONS(1107),
    [anon_sym_native] = ACTIONS(1107),
    [anon_sym_float] = ACTIONS(1107),
    [anon_sym_final] = ACTIONS(1107),
    [anon_sym_RPAREN] = ACTIONS(1109),
    [anon_sym_protected] = ACTIONS(1107),
    [anon_sym_short] = ACTIONS(1107),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(1107),
    [sym_identifier] = ACTIONS(1107),
    [anon_sym_char] = ACTIONS(1107),
    [anon_sym_static] = ACTIONS(1107),
    [anon_sym_long] = ACTIONS(1107),
    [anon_sym_COLON] = ACTIONS(1109),
    [anon_sym_EQ] = ACTIONS(1109),
    [anon_sym_strictfp] = ACTIONS(1107),
  },
  [306] = {
    [anon_sym_protected] = ACTIONS(1111),
    [anon_sym_static] = ACTIONS(1111),
    [sym_boolean_type] = ACTIONS(1111),
    [sym_this] = ACTIONS(1111),
    [anon_sym_module] = ACTIONS(1111),
    [anon_sym_strictfp] = ACTIONS(1111),
    [anon_sym_COLON_COLON] = ACTIONS(1113),
    [anon_sym_AT] = ACTIONS(1113),
    [anon_sym_native] = ACTIONS(1111),
    [anon_sym_int] = ACTIONS(1111),
    [anon_sym_public] = ACTIONS(1111),
    [anon_sym_DOT] = ACTIONS(1111),
    [anon_sym_throws] = ACTIONS(1111),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1113),
    [anon_sym_open] = ACTIONS(1111),
    [anon_sym_float] = ACTIONS(1111),
    [anon_sym_abstract] = ACTIONS(1111),
    [anon_sym_PIPE] = ACTIONS(1113),
    [anon_sym_COLON] = ACTIONS(1111),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1113),
    [anon_sym_double] = ACTIONS(1111),
    [anon_sym_default] = ACTIONS(1111),
    [anon_sym_long] = ACTIONS(1111),
    [sym_identifier] = ACTIONS(1111),
    [anon_sym_EQ] = ACTIONS(1113),
    [anon_sym_synchronized] = ACTIONS(1111),
    [anon_sym_transient] = ACTIONS(1111),
    [anon_sym_implements] = ACTIONS(1111),
    [anon_sym_short] = ACTIONS(1111),
    [anon_sym_LBRACK] = ACTIONS(1113),
    [sym_void_type] = ACTIONS(1111),
    [anon_sym_volatile] = ACTIONS(1111),
    [anon_sym_private] = ACTIONS(1111),
    [anon_sym_final] = ACTIONS(1111),
    [anon_sym_byte] = ACTIONS(1111),
    [anon_sym_GT] = ACTIONS(1113),
    [anon_sym_RPAREN] = ACTIONS(1113),
    [anon_sym_COMMA] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1113),
    [anon_sym_AMP] = ACTIONS(1113),
    [anon_sym_char] = ACTIONS(1111),
  },
  [307] = {
    [anon_sym_final] = ACTIONS(1115),
    [anon_sym_static] = ACTIONS(1115),
    [sym_boolean_type] = ACTIONS(1115),
    [anon_sym_protected] = ACTIONS(1115),
    [sym_comment] = ACTIONS(3),
    [anon_sym_default] = ACTIONS(1115),
    [anon_sym_RPAREN] = ACTIONS(1117),
    [anon_sym_public] = ACTIONS(1115),
    [anon_sym_SEMI] = ACTIONS(1117),
    [anon_sym_AT] = ACTIONS(1117),
    [anon_sym_long] = ACTIONS(1115),
    [anon_sym_synchronized] = ACTIONS(1115),
    [anon_sym_native] = ACTIONS(1115),
    [sym_void_type] = ACTIONS(1115),
    [anon_sym_transient] = ACTIONS(1115),
    [anon_sym_private] = ACTIONS(1115),
    [anon_sym_abstract] = ACTIONS(1115),
    [anon_sym_short] = ACTIONS(1115),
    [anon_sym_float] = ACTIONS(1115),
    [anon_sym_volatile] = ACTIONS(1115),
    [anon_sym_COLON] = ACTIONS(1117),
    [anon_sym_strictfp] = ACTIONS(1115),
    [anon_sym_EQ] = ACTIONS(1117),
    [anon_sym_double] = ACTIONS(1115),
    [anon_sym_int] = ACTIONS(1115),
    [anon_sym_byte] = ACTIONS(1115),
    [sym_identifier] = ACTIONS(1115),
    [anon_sym_COMMA] = ACTIONS(1117),
    [anon_sym_char] = ACTIONS(1115),
  },
  [308] = {
    [sym_annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(308),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym__annotation] = STATE(145),
    [anon_sym_AT] = ACTIONS(1119),
    [anon_sym_RPAREN] = ACTIONS(1113),
    [anon_sym_volatile] = ACTIONS(1111),
    [anon_sym_AMP] = ACTIONS(1113),
    [anon_sym_short] = ACTIONS(1111),
    [sym_comment] = ACTIONS(3),
    [anon_sym_public] = ACTIONS(1111),
    [anon_sym_transient] = ACTIONS(1111),
    [anon_sym_SEMI] = ACTIONS(1113),
    [anon_sym_final] = ACTIONS(1111),
    [anon_sym_COLON] = ACTIONS(1111),
    [anon_sym_module] = ACTIONS(1111),
    [anon_sym_LBRACK] = ACTIONS(1122),
    [sym_this] = ACTIONS(1111),
    [anon_sym_DOT] = ACTIONS(1111),
    [anon_sym_double] = ACTIONS(1111),
    [anon_sym_float] = ACTIONS(1111),
    [sym_void_type] = ACTIONS(1111),
    [anon_sym_open] = ACTIONS(1111),
    [anon_sym_COLON_COLON] = ACTIONS(1113),
    [anon_sym_byte] = ACTIONS(1111),
    [anon_sym_static] = ACTIONS(1111),
    [anon_sym_COMMA] = ACTIONS(1113),
    [anon_sym_protected] = ACTIONS(1111),
    [anon_sym_EQ] = ACTIONS(1113),
    [anon_sym_private] = ACTIONS(1111),
    [anon_sym_default] = ACTIONS(1111),
    [anon_sym_long] = ACTIONS(1111),
    [anon_sym_throws] = ACTIONS(1111),
    [anon_sym_strictfp] = ACTIONS(1111),
    [anon_sym_char] = ACTIONS(1111),
    [sym_boolean_type] = ACTIONS(1111),
    [anon_sym_LBRACE] = ACTIONS(1113),
    [sym_identifier] = ACTIONS(1111),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1113),
    [anon_sym_native] = ACTIONS(1111),
    [anon_sym_int] = ACTIONS(1111),
    [anon_sym_synchronized] = ACTIONS(1111),
    [anon_sym_abstract] = ACTIONS(1111),
    [anon_sym_implements] = ACTIONS(1111),
    [anon_sym_PIPE] = ACTIONS(1113),
    [anon_sym_GT] = ACTIONS(1113),
  },
  [309] = {
    [sym_array_initializer] = STATE(485),
    [sym_update_expression] = STATE(484),
    [sym_scoped_identifier] = STATE(52),
    [sym_assignment_expression] = STATE(484),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__unannotated_type] = STATE(73),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_annotated_type] = STATE(37),
    [sym_array_type] = STATE(73),
    [sym__primary_no_new_array] = STATE(43),
    [sym_annotation] = STATE(74),
    [sym_instanceof_expression] = STATE(484),
    [sym_generic_type] = STATE(53),
    [sym_array_creation_expression] = STATE(41),
    [sym_class_literal] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym_ternary_expression] = STATE(484),
    [sym__type] = STATE(37),
    [sym_inferred_parameters] = STATE(42),
    [sym_formal_parameters] = STATE(42),
    [sym_array_access] = STATE(39),
    [sym__expression] = STATE(484),
    [sym__annotation] = STATE(74),
    [sym_field_access] = STATE(39),
    [sym__literal] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_cast_expression] = STATE(484),
    [sym_binary_expression] = STATE(484),
    [sym_object_creation_expression] = STATE(43),
    [sym_unary_expression] = STATE(484),
    [sym__primary] = STATE(41),
    [sym_lambda_expression] = STATE(484),
    [sym_floating_point_type] = STATE(30),
    [sym_integral_type] = STATE(30),
    [sym_marker_annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_new] = ACTIONS(19),
    [sym_super] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(921),
    [sym_true] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_AT] = ACTIONS(118),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_this] = ACTIONS(5),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_short] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
  },
  [310] = {
    [sym_variable_declarator] = STATE(486),
    [sym__variable_declarator_id] = STATE(142),
    [sym_identifier] = ACTIONS(247),
    [anon_sym_open] = ACTIONS(243),
    [anon_sym_module] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
  },
  [311] = {
    [aux_sym__variable_declarator_list_repeat1] = STATE(487),
    [anon_sym_SEMI] = ACTIONS(1125),
    [anon_sym_COMMA] = ACTIONS(685),
    [sym_comment] = ACTIONS(3),
  },
  [312] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(1127),
  },
  [313] = {
    [sym_super_interfaces] = STATE(489),
    [anon_sym_LBRACE] = ACTIONS(1015),
    [sym_comment] = ACTIONS(3),
    [anon_sym_implements] = ACTIONS(441),
  },
  [314] = {
    [sym_annotation_type_body] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
  },
  [315] = {
    [sym_extends_interfaces] = STATE(399),
    [sym_interface_body] = STATE(398),
    [sym_type_parameters] = STATE(491),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(443),
    [anon_sym_extends] = ACTIONS(445),
    [anon_sym_LT] = ACTIONS(437),
  },
  [316] = {
    [sym_super_interfaces] = STATE(495),
    [sym_superclass] = STATE(492),
    [sym_class_body] = STATE(493),
    [sym_type_parameters] = STATE(494),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_extends] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_implements] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
  },
  [317] = {
    [anon_sym_SEMI] = ACTIONS(1129),
    [sym_comment] = ACTIONS(3),
  },
  [318] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_COLON] = ACTIONS(1131),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_RPAREN] = ACTIONS(1131),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_PIPE_PIPE] = ACTIONS(1131),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_CARET] = ACTIONS(1131),
    [anon_sym_SEMI] = ACTIONS(1131),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_COMMA] = ACTIONS(1131),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_RBRACE] = ACTIONS(1131),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(1131),
    [anon_sym_RBRACK] = ACTIONS(1131),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
  },
  [319] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1131),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(1131),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_RBRACK] = ACTIONS(1131),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_PIPE_PIPE] = ACTIONS(1131),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_CARET] = ACTIONS(1131),
    [anon_sym_QMARK] = ACTIONS(1131),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_RPAREN] = ACTIONS(1131),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_COMMA] = ACTIONS(1131),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_AMP_AMP] = ACTIONS(1131),
    [anon_sym_SEMI] = ACTIONS(1131),
  },
  [320] = {
    [anon_sym_GT_GT] = ACTIONS(1135),
    [anon_sym_PERCENT] = ACTIONS(1137),
    [anon_sym_SEMI] = ACTIONS(1137),
    [anon_sym_BANG_EQ] = ACTIONS(1137),
    [anon_sym_GT] = ACTIONS(1135),
    [anon_sym_STAR] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1135),
    [anon_sym_LT] = ACTIONS(1135),
    [anon_sym_LT_EQ] = ACTIONS(1137),
    [anon_sym_PIPE_PIPE] = ACTIONS(1137),
    [anon_sym_AMP_AMP] = ACTIONS(1137),
    [anon_sym_DASH] = ACTIONS(1135),
    [anon_sym_GT_GT_GT] = ACTIONS(1137),
    [anon_sym_LT_LT] = ACTIONS(1137),
    [anon_sym_instanceof] = ACTIONS(1137),
    [anon_sym_PLUS_PLUS] = ACTIONS(1137),
    [anon_sym_COMMA] = ACTIONS(1137),
    [anon_sym_RBRACE] = ACTIONS(1137),
    [anon_sym_AMP] = ACTIONS(1135),
    [anon_sym_PIPE] = ACTIONS(1135),
    [anon_sym_QMARK] = ACTIONS(1137),
    [anon_sym_DASH_DASH] = ACTIONS(1137),
    [anon_sym_COLON] = ACTIONS(1137),
    [anon_sym_GT_EQ] = ACTIONS(1137),
    [anon_sym_EQ_EQ] = ACTIONS(1137),
    [anon_sym_PLUS] = ACTIONS(1135),
    [anon_sym_CARET] = ACTIONS(1137),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(1137),
    [anon_sym_RPAREN] = ACTIONS(1137),
  },
  [321] = {
    [anon_sym_LT_EQ] = ACTIONS(1131),
    [anon_sym_PIPE_PIPE] = ACTIONS(1131),
    [anon_sym_LT] = ACTIONS(1133),
    [anon_sym_COLON] = ACTIONS(1131),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_DASH] = ACTIONS(1133),
    [anon_sym_BANG_EQ] = ACTIONS(1131),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(1133),
    [anon_sym_RBRACE] = ACTIONS(1131),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_RPAREN] = ACTIONS(1131),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_COMMA] = ACTIONS(1131),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(1131),
    [anon_sym_CARET] = ACTIONS(1131),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_EQ_EQ] = ACTIONS(1131),
    [anon_sym_QMARK] = ACTIONS(1131),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_EQ] = ACTIONS(1131),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_SEMI] = ACTIONS(1131),
    [anon_sym_RBRACK] = ACTIONS(1131),
    [anon_sym_PLUS] = ACTIONS(1133),
    [anon_sym_instanceof] = ACTIONS(1131),
  },
  [322] = {
    [anon_sym_BANG_EQ] = ACTIONS(1131),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_GT_GT_GT] = ACTIONS(1131),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_PLUS] = ACTIONS(1133),
    [anon_sym_GT_GT] = ACTIONS(1133),
    [anon_sym_PIPE_PIPE] = ACTIONS(1131),
    [anon_sym_LT_LT] = ACTIONS(1131),
    [anon_sym_QMARK] = ACTIONS(1131),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_RBRACK] = ACTIONS(1131),
    [anon_sym_RBRACE] = ACTIONS(1131),
    [anon_sym_SLASH] = ACTIONS(1133),
    [anon_sym_GT] = ACTIONS(1133),
    [anon_sym_PERCENT] = ACTIONS(1131),
    [anon_sym_GT_EQ] = ACTIONS(1131),
    [anon_sym_COLON] = ACTIONS(1131),
    [anon_sym_COMMA] = ACTIONS(1131),
    [anon_sym_LT_EQ] = ACTIONS(1131),
    [anon_sym_CARET] = ACTIONS(1131),
    [anon_sym_SEMI] = ACTIONS(1131),
    [anon_sym_EQ_EQ] = ACTIONS(1131),
    [anon_sym_instanceof] = ACTIONS(1131),
    [anon_sym_RPAREN] = ACTIONS(1131),
    [anon_sym_PIPE] = ACTIONS(1133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP_AMP] = ACTIONS(1131),
    [anon_sym_DASH] = ACTIONS(1133),
    [anon_sym_LT] = ACTIONS(1133),
    [anon_sym_STAR] = ACTIONS(1131),
  },
  [323] = {
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_GT_GT] = ACTIONS(299),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(1139),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
  },
  [324] = {
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_SEMI] = ACTIONS(1131),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_COMMA] = ACTIONS(1131),
    [anon_sym_PLUS] = ACTIONS(1133),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_AMP_AMP] = ACTIONS(1131),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(1131),
    [anon_sym_CARET] = ACTIONS(1131),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PIPE_PIPE] = ACTIONS(1131),
    [anon_sym_RBRACK] = ACTIONS(1131),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(1131),
    [anon_sym_DASH] = ACTIONS(1133),
    [anon_sym_COLON] = ACTIONS(1131),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_RPAREN] = ACTIONS(1131),
    [anon_sym_LT] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_instanceof] = ACTIONS(303),
  },
  [325] = {
    [sym_argument_list] = STATE(342),
    [anon_sym_PERCENT] = ACTIONS(791),
    [anon_sym_STAR_EQ] = ACTIONS(789),
    [anon_sym_DASH_DASH] = ACTIONS(789),
    [anon_sym_PLUS_PLUS] = ACTIONS(789),
    [anon_sym_EQ] = ACTIONS(791),
    [anon_sym_SLASH_EQ] = ACTIONS(789),
    [anon_sym_BANG_EQ] = ACTIONS(789),
    [anon_sym_LBRACK] = ACTIONS(789),
    [anon_sym_LT] = ACTIONS(791),
    [anon_sym_GT_EQ] = ACTIONS(789),
    [anon_sym_RPAREN] = ACTIONS(789),
    [anon_sym_LT_LT] = ACTIONS(791),
    [anon_sym_PLUS_EQ] = ACTIONS(789),
    [anon_sym_DASH_EQ] = ACTIONS(789),
    [anon_sym_AMP] = ACTIONS(791),
    [anon_sym_AMP_AMP] = ACTIONS(789),
    [anon_sym_PIPE_PIPE] = ACTIONS(789),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_COLON_COLON] = ACTIONS(789),
    [anon_sym_PIPE] = ACTIONS(791),
    [anon_sym_GT_GT_EQ] = ACTIONS(789),
    [anon_sym_instanceof] = ACTIONS(789),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(789),
    [anon_sym_EQ_EQ] = ACTIONS(789),
    [anon_sym_SEMI] = ACTIONS(789),
    [anon_sym_DOT] = ACTIONS(789),
    [anon_sym_LT_LT_EQ] = ACTIONS(789),
    [anon_sym_STAR] = ACTIONS(791),
    [anon_sym_GT_GT] = ACTIONS(791),
    [anon_sym_RBRACK] = ACTIONS(789),
    [anon_sym_CARET_EQ] = ACTIONS(789),
    [anon_sym_LT_EQ] = ACTIONS(789),
    [anon_sym_CARET] = ACTIONS(791),
    [anon_sym_QMARK] = ACTIONS(789),
    [anon_sym_AMP_EQ] = ACTIONS(789),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_PIPE_EQ] = ACTIONS(789),
    [anon_sym_PERCENT_EQ] = ACTIONS(789),
    [anon_sym_COLON] = ACTIONS(791),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(789),
    [anon_sym_RBRACE] = ACTIONS(789),
    [anon_sym_GT] = ACTIONS(791),
    [anon_sym_SLASH] = ACTIONS(791),
    [anon_sym_GT_GT_GT] = ACTIONS(791),
    [anon_sym_PLUS] = ACTIONS(791),
  },
  [326] = {
    [anon_sym_GT_EQ] = ACTIONS(1141),
    [anon_sym_DOT] = ACTIONS(1141),
    [anon_sym_AMP_AMP] = ACTIONS(1141),
    [anon_sym_AMP] = ACTIONS(1143),
    [anon_sym_RBRACK] = ACTIONS(1141),
    [anon_sym_LT_LT] = ACTIONS(1141),
    [anon_sym_PIPE_PIPE] = ACTIONS(1141),
    [anon_sym_CARET] = ACTIONS(1141),
    [anon_sym_DASH_DASH] = ACTIONS(1141),
    [anon_sym_PERCENT] = ACTIONS(1141),
    [anon_sym_COLON] = ACTIONS(1143),
    [anon_sym_instanceof] = ACTIONS(1141),
    [anon_sym_LBRACK] = ACTIONS(1141),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1141),
    [anon_sym_COMMA] = ACTIONS(1141),
    [anon_sym_RBRACE] = ACTIONS(1141),
    [anon_sym_STAR] = ACTIONS(1141),
    [anon_sym_DASH] = ACTIONS(1143),
    [anon_sym_PIPE] = ACTIONS(1143),
    [anon_sym_LT_EQ] = ACTIONS(1141),
    [anon_sym_QMARK] = ACTIONS(1141),
    [anon_sym_SEMI] = ACTIONS(1141),
    [anon_sym_EQ_EQ] = ACTIONS(1141),
    [anon_sym_SLASH] = ACTIONS(1143),
    [anon_sym_LT] = ACTIONS(1143),
    [anon_sym_GT_GT] = ACTIONS(1143),
    [anon_sym_GT] = ACTIONS(1143),
    [anon_sym_BANG_EQ] = ACTIONS(1141),
    [anon_sym_GT_GT_GT] = ACTIONS(1141),
    [anon_sym_PLUS] = ACTIONS(1143),
    [anon_sym_PLUS_PLUS] = ACTIONS(1141),
    [anon_sym_COLON_COLON] = ACTIONS(1141),
  },
  [327] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__type] = STATE(497),
    [sym_generic_type] = STATE(53),
    [sym_annotation] = STATE(74),
    [sym_floating_point_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [sym_array_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotated_type] = STATE(497),
    [sym__unannotated_type] = STATE(73),
    [sym_integral_type] = STATE(73),
    [anon_sym_byte] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(334),
    [sym_void_type] = ACTIONS(334),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(233),
  },
  [328] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1145),
    [anon_sym_GT] = ACTIONS(1145),
  },
  [329] = {
    [sym__wildcard_bounds] = STATE(498),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(1145),
    [sym_super] = ACTIONS(745),
    [anon_sym_extends] = ACTIONS(745),
    [anon_sym_COMMA] = ACTIONS(1145),
  },
  [330] = {
    [anon_sym_double] = ACTIONS(1147),
    [anon_sym_open] = ACTIONS(1147),
    [anon_sym_GT] = ACTIONS(1149),
    [sym_identifier] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(1149),
    [anon_sym_short] = ACTIONS(1147),
    [anon_sym_implements] = ACTIONS(1147),
    [sym_boolean_type] = ACTIONS(1147),
    [anon_sym_SEMI] = ACTIONS(1149),
    [anon_sym_char] = ACTIONS(1147),
    [sym_super] = ACTIONS(1147),
    [anon_sym_RPAREN] = ACTIONS(1149),
    [sym_void_type] = ACTIONS(1147),
    [sym_this] = ACTIONS(1147),
    [anon_sym_long] = ACTIONS(1147),
    [anon_sym_LBRACE] = ACTIONS(1149),
    [anon_sym_COMMA] = ACTIONS(1149),
    [anon_sym_LBRACK] = ACTIONS(1149),
    [sym_comment] = ACTIONS(3),
    [anon_sym_new] = ACTIONS(1147),
    [anon_sym_byte] = ACTIONS(1147),
    [anon_sym_PIPE] = ACTIONS(1149),
    [anon_sym_COLON_COLON] = ACTIONS(1149),
    [anon_sym_AMP] = ACTIONS(1149),
    [anon_sym_AT] = ACTIONS(1149),
    [anon_sym_int] = ACTIONS(1147),
    [anon_sym_DOT] = ACTIONS(1147),
    [anon_sym_module] = ACTIONS(1147),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1149),
    [anon_sym_float] = ACTIONS(1147),
  },
  [331] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(172),
    [sym_wildcard] = STATE(499),
    [sym_integral_type] = STATE(73),
    [sym_annotation] = STATE(172),
    [sym__unannotated_type] = STATE(73),
    [sym_floating_point_type] = STATE(73),
    [sym__annotation] = STATE(172),
    [sym_array_type] = STATE(73),
    [sym_generic_type] = STATE(53),
    [sym_marker_annotation] = STATE(172),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotated_type] = STATE(499),
    [sym__type] = STATE(499),
    [anon_sym_AT] = ACTIONS(118),
    [sym_void_type] = ACTIONS(334),
    [anon_sym_double] = ACTIONS(41),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_QMARK] = ACTIONS(332),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(334),
    [anon_sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_byte] = ACTIONS(33),
  },
  [332] = {
    [aux_sym_type_arguments_repeat1] = STATE(501),
    [anon_sym_COMMA] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(1151),
    [sym_comment] = ACTIONS(3),
  },
  [333] = {
    [anon_sym_PERCENT] = ACTIONS(1153),
    [anon_sym_RPAREN] = ACTIONS(1155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1155),
    [anon_sym_COLON] = ACTIONS(1153),
    [anon_sym_AMP] = ACTIONS(1153),
    [anon_sym_PLUS] = ACTIONS(1153),
    [anon_sym_LT_LT] = ACTIONS(1153),
    [anon_sym_GT_EQ] = ACTIONS(1155),
    [anon_sym_GT_GT_EQ] = ACTIONS(1155),
    [anon_sym_AMP_EQ] = ACTIONS(1155),
    [anon_sym_DOT] = ACTIONS(1155),
    [anon_sym_EQ_EQ] = ACTIONS(1155),
    [anon_sym_PERCENT_EQ] = ACTIONS(1155),
    [anon_sym_STAR_EQ] = ACTIONS(1155),
    [anon_sym_STAR] = ACTIONS(1153),
    [anon_sym_SEMI] = ACTIONS(1155),
    [anon_sym_COMMA] = ACTIONS(1155),
    [anon_sym_PLUS_EQ] = ACTIONS(1155),
    [anon_sym_RBRACK] = ACTIONS(1155),
    [anon_sym_PIPE_PIPE] = ACTIONS(1155),
    [anon_sym_CARET] = ACTIONS(1153),
    [anon_sym_GT_GT_GT] = ACTIONS(1153),
    [anon_sym_AMP_AMP] = ACTIONS(1155),
    [anon_sym_COLON_COLON] = ACTIONS(1155),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH] = ACTIONS(1153),
    [anon_sym_DASH_DASH] = ACTIONS(1155),
    [anon_sym_EQ] = ACTIONS(1153),
    [anon_sym_LBRACK] = ACTIONS(1155),
    [anon_sym_CARET_EQ] = ACTIONS(1155),
    [anon_sym_PLUS_PLUS] = ACTIONS(1155),
    [anon_sym_LT_LT_EQ] = ACTIONS(1155),
    [anon_sym_PIPE_EQ] = ACTIONS(1155),
    [anon_sym_BANG_EQ] = ACTIONS(1155),
    [anon_sym_RBRACE] = ACTIONS(1155),
    [anon_sym_instanceof] = ACTIONS(1155),
    [anon_sym_QMARK] = ACTIONS(1155),
    [anon_sym_LT_EQ] = ACTIONS(1155),
    [anon_sym_GT] = ACTIONS(1153),
    [anon_sym_GT_GT] = ACTIONS(1153),
    [anon_sym_DASH_EQ] = ACTIONS(1155),
    [anon_sym_LT] = ACTIONS(1153),
    [anon_sym_PIPE] = ACTIONS(1153),
    [anon_sym_SLASH_EQ] = ACTIONS(1155),
    [anon_sym_SLASH] = ACTIONS(1153),
  },
  [334] = {
    [anon_sym_DOT] = ACTIONS(1157),
    [anon_sym_DASH_DASH] = ACTIONS(1157),
    [anon_sym_PERCENT] = ACTIONS(1157),
    [anon_sym_LT_EQ] = ACTIONS(1157),
    [anon_sym_GT_GT_GT] = ACTIONS(1157),
    [anon_sym_AMP_AMP] = ACTIONS(1157),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_LT] = ACTIONS(1157),
    [anon_sym_GT_EQ] = ACTIONS(1157),
    [anon_sym_SLASH] = ACTIONS(1159),
    [anon_sym_LBRACK] = ACTIONS(1157),
    [anon_sym_RBRACE] = ACTIONS(1157),
    [anon_sym_instanceof] = ACTIONS(1157),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_BANG_EQ] = ACTIONS(1157),
    [anon_sym_PIPE_PIPE] = ACTIONS(1157),
    [anon_sym_STAR] = ACTIONS(1157),
    [anon_sym_RPAREN] = ACTIONS(1157),
    [anon_sym_CARET] = ACTIONS(1157),
    [anon_sym_QMARK] = ACTIONS(1157),
    [anon_sym_PLUS_PLUS] = ACTIONS(1157),
    [anon_sym_COLON_COLON] = ACTIONS(1157),
    [anon_sym_LBRACE] = ACTIONS(1157),
    [anon_sym_COMMA] = ACTIONS(1157),
    [anon_sym_GT] = ACTIONS(1159),
    [anon_sym_COLON] = ACTIONS(1159),
    [anon_sym_PLUS] = ACTIONS(1159),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_DASH] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(1157),
    [anon_sym_SEMI] = ACTIONS(1157),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_RBRACK] = ACTIONS(1157),
  },
  [335] = {
    [sym__primary_no_new_array] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_array_type] = STATE(73),
    [sym_annotated_type] = STATE(37),
    [sym_cast_expression] = STATE(502),
    [sym_method_reference] = STATE(43),
    [sym_update_expression] = STATE(502),
    [sym_unary_expression] = STATE(502),
    [sym_field_access] = STATE(39),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_object_creation_expression] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym_assignment_expression] = STATE(502),
    [sym_class_literal] = STATE(43),
    [sym_lambda_expression] = STATE(502),
    [sym__expression] = STATE(502),
    [sym__primary] = STATE(41),
    [sym_parenthesized_expression] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym__annotation] = STATE(74),
    [sym_binary_expression] = STATE(502),
    [sym_integral_type] = STATE(30),
    [sym_annotation] = STATE(74),
    [sym_array_creation_expression] = STATE(41),
    [sym_method_invocation] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym__type] = STATE(37),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_ternary_expression] = STATE(502),
    [sym_floating_point_type] = STATE(30),
    [sym__literal] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_generic_type] = STATE(53),
    [sym_instanceof_expression] = STATE(502),
    [sym_formal_parameters] = STATE(42),
    [sym__unannotated_type] = STATE(73),
    [sym_true] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_short] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_this] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_boolean_type] = ACTIONS(79),
    [sym_null_literal] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(120),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_double] = ACTIONS(41),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_char] = ACTIONS(33),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_new] = ACTIONS(19),
  },
  [336] = {
    [aux_sym_argument_list_repeat1] = STATE(504),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(771),
    [anon_sym_RPAREN] = ACTIONS(1161),
  },
  [337] = {
    [sym_type_arguments] = STATE(64),
    [sym_argument_list] = STATE(239),
    [anon_sym_DOT] = ACTIONS(447),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(112),
  },
  [338] = {
    [sym_argument_list] = STATE(243),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(112),
  },
  [339] = {
    [sym_argument_list] = STATE(243),
    [anon_sym_DOT] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(112),
    [sym_comment] = ACTIONS(3),
  },
  [340] = {
    [sym_argument_list] = STATE(243),
    [sym_type_arguments] = STATE(132),
    [anon_sym_DOT] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
  },
  [341] = {
    [sym_type_arguments] = STATE(506),
    [sym_identifier] = ACTIONS(1163),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(146),
  },
  [342] = {
    [anon_sym_GT_EQ] = ACTIONS(1165),
    [anon_sym_COLON_COLON] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1165),
    [anon_sym_GT] = ACTIONS(1167),
    [anon_sym_LT] = ACTIONS(1167),
    [anon_sym_instanceof] = ACTIONS(1165),
    [anon_sym_GT_GT] = ACTIONS(1167),
    [anon_sym_STAR] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(1165),
    [anon_sym_COMMA] = ACTIONS(1165),
    [anon_sym_LBRACK] = ACTIONS(1165),
    [anon_sym_PIPE_PIPE] = ACTIONS(1165),
    [anon_sym_CARET] = ACTIONS(1165),
    [anon_sym_LT_EQ] = ACTIONS(1165),
    [anon_sym_QMARK] = ACTIONS(1165),
    [anon_sym_PIPE] = ACTIONS(1167),
    [anon_sym_GT_GT_GT] = ACTIONS(1165),
    [anon_sym_RBRACK] = ACTIONS(1165),
    [anon_sym_LT_LT] = ACTIONS(1165),
    [anon_sym_EQ_EQ] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1167),
    [anon_sym_PLUS] = ACTIONS(1167),
    [anon_sym_PLUS_PLUS] = ACTIONS(1165),
    [anon_sym_DASH_DASH] = ACTIONS(1165),
    [anon_sym_AMP_AMP] = ACTIONS(1165),
    [anon_sym_DOT] = ACTIONS(1165),
    [anon_sym_COLON] = ACTIONS(1167),
    [anon_sym_SLASH] = ACTIONS(1167),
    [anon_sym_BANG_EQ] = ACTIONS(1165),
    [anon_sym_RPAREN] = ACTIONS(1165),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1165),
    [anon_sym_AMP] = ACTIONS(1167),
  },
  [343] = {
    [sym_this] = ACTIONS(1169),
    [sym_identifier] = ACTIONS(1169),
    [anon_sym_LT] = ACTIONS(1171),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(1171),
    [anon_sym_open] = ACTIONS(1169),
    [anon_sym_RPAREN] = ACTIONS(1171),
    [anon_sym_COLON_COLON] = ACTIONS(1171),
    [anon_sym_implements] = ACTIONS(1169),
    [anon_sym_module] = ACTIONS(1169),
    [anon_sym_LBRACK] = ACTIONS(1171),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1171),
    [anon_sym_AMP] = ACTIONS(1171),
    [anon_sym_LPAREN] = ACTIONS(1171),
    [anon_sym_LBRACE] = ACTIONS(1171),
    [anon_sym_PIPE] = ACTIONS(1171),
    [anon_sym_DOT] = ACTIONS(1169),
    [anon_sym_COMMA] = ACTIONS(1171),
    [anon_sym_SEMI] = ACTIONS(1171),
    [anon_sym_AT] = ACTIONS(1171),
  },
  [344] = {
    [sym_argument_list] = STATE(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(112),
  },
  [345] = {
    [anon_sym_BANG_EQ] = ACTIONS(1173),
    [anon_sym_AMP] = ACTIONS(1175),
    [anon_sym_CARET] = ACTIONS(1173),
    [anon_sym_COMMA] = ACTIONS(1173),
    [anon_sym_DASH_DASH] = ACTIONS(1173),
    [anon_sym_DOT] = ACTIONS(1173),
    [anon_sym_PIPE] = ACTIONS(1175),
    [anon_sym_LBRACK] = ACTIONS(1173),
    [anon_sym_PIPE_PIPE] = ACTIONS(1173),
    [anon_sym_instanceof] = ACTIONS(1173),
    [anon_sym_PERCENT] = ACTIONS(1173),
    [anon_sym_LT_LT] = ACTIONS(1173),
    [anon_sym_QMARK] = ACTIONS(1173),
    [anon_sym_COLON_COLON] = ACTIONS(1173),
    [anon_sym_SLASH] = ACTIONS(1175),
    [anon_sym_LT_EQ] = ACTIONS(1173),
    [anon_sym_RBRACK] = ACTIONS(1173),
    [anon_sym_PLUS] = ACTIONS(1175),
    [anon_sym_GT_GT_GT] = ACTIONS(1173),
    [anon_sym_COLON] = ACTIONS(1175),
    [anon_sym_SEMI] = ACTIONS(1173),
    [anon_sym_STAR] = ACTIONS(1173),
    [anon_sym_LT] = ACTIONS(1175),
    [anon_sym_GT] = ACTIONS(1175),
    [anon_sym_RPAREN] = ACTIONS(1173),
    [anon_sym_GT_GT] = ACTIONS(1175),
    [anon_sym_AMP_AMP] = ACTIONS(1173),
    [anon_sym_RBRACE] = ACTIONS(1173),
    [anon_sym_EQ_EQ] = ACTIONS(1173),
    [anon_sym_GT_EQ] = ACTIONS(1173),
    [anon_sym_PLUS_PLUS] = ACTIONS(1173),
    [anon_sym_DASH] = ACTIONS(1175),
    [sym_comment] = ACTIONS(3),
  },
  [346] = {
    [anon_sym_private] = ACTIONS(1053),
    [anon_sym_COMMA] = ACTIONS(1055),
    [anon_sym_interface] = ACTIONS(1053),
    [anon_sym_int] = ACTIONS(1053),
    [anon_sym_open] = ACTIONS(1053),
    [anon_sym_strictfp] = ACTIONS(1053),
    [anon_sym_public] = ACTIONS(1053),
    [anon_sym_abstract] = ACTIONS(1053),
    [anon_sym_LBRACE] = ACTIONS(1055),
    [anon_sym_synchronized] = ACTIONS(1053),
    [anon_sym_LT] = ACTIONS(1055),
    [anon_sym_ATinterface] = ACTIONS(1055),
    [anon_sym_byte] = ACTIONS(1053),
    [sym_identifier] = ACTIONS(1053),
    [anon_sym_short] = ACTIONS(1053),
    [anon_sym_SEMI] = ACTIONS(1055),
    [anon_sym_float] = ACTIONS(1053),
    [anon_sym_char] = ACTIONS(1053),
    [sym_boolean_type] = ACTIONS(1053),
    [anon_sym_AT] = ACTIONS(1053),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_LPAREN] = ACTIONS(1055),
    [anon_sym_double] = ACTIONS(1053),
    [anon_sym_enum] = ACTIONS(1053),
    [anon_sym_final] = ACTIONS(1053),
    [anon_sym_protected] = ACTIONS(1053),
    [anon_sym_package] = ACTIONS(1053),
    [anon_sym_static] = ACTIONS(1053),
    [sym_void_type] = ACTIONS(1053),
    [anon_sym_module] = ACTIONS(1053),
    [anon_sym_to] = ACTIONS(1053),
    [anon_sym_long] = ACTIONS(1053),
    [anon_sym_default] = ACTIONS(1053),
    [anon_sym_class] = ACTIONS(1053),
    [anon_sym_native] = ACTIONS(1053),
    [anon_sym_with] = ACTIONS(1053),
    [anon_sym_transient] = ACTIONS(1053),
    [anon_sym_volatile] = ACTIONS(1053),
  },
  [347] = {
    [anon_sym_final] = ACTIONS(791),
    [anon_sym_enum] = ACTIONS(791),
    [anon_sym_private] = ACTIONS(791),
    [anon_sym_SEMI] = ACTIONS(789),
    [anon_sym_synchronized] = ACTIONS(791),
    [anon_sym_AT] = ACTIONS(791),
    [anon_sym_protected] = ACTIONS(791),
    [anon_sym_int] = ACTIONS(791),
    [anon_sym_double] = ACTIONS(791),
    [anon_sym_float] = ACTIONS(791),
    [anon_sym_strictfp] = ACTIONS(791),
    [anon_sym_LBRACE] = ACTIONS(789),
    [anon_sym_with] = ACTIONS(791),
    [anon_sym_default] = ACTIONS(791),
    [anon_sym_public] = ACTIONS(791),
    [anon_sym_long] = ACTIONS(791),
    [anon_sym_transient] = ACTIONS(791),
    [sym_comment] = ACTIONS(3),
    [anon_sym_native] = ACTIONS(791),
    [anon_sym_module] = ACTIONS(791),
    [anon_sym_package] = ACTIONS(791),
    [anon_sym_volatile] = ACTIONS(791),
    [anon_sym_LPAREN] = ACTIONS(789),
    [anon_sym_DOT] = ACTIONS(789),
    [sym_void_type] = ACTIONS(791),
    [sym_identifier] = ACTIONS(791),
    [anon_sym_interface] = ACTIONS(791),
    [anon_sym_static] = ACTIONS(791),
    [anon_sym_ATinterface] = ACTIONS(789),
    [anon_sym_LT] = ACTIONS(789),
    [anon_sym_COMMA] = ACTIONS(789),
    [anon_sym_class] = ACTIONS(791),
    [anon_sym_abstract] = ACTIONS(791),
    [anon_sym_byte] = ACTIONS(791),
    [anon_sym_char] = ACTIONS(791),
    [anon_sym_short] = ACTIONS(791),
    [sym_boolean_type] = ACTIONS(791),
    [anon_sym_open] = ACTIONS(791),
    [anon_sym_to] = ACTIONS(791),
  },
  [348] = {
    [anon_sym_RPAREN] = ACTIONS(1177),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1177),
  },
  [349] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_GT] = ACTIONS(1179),
  },
  [350] = {
    [aux_sym_inferred_parameters_repeat1] = STATE(350),
    [anon_sym_RPAREN] = ACTIONS(1177),
    [anon_sym_COMMA] = ACTIONS(1181),
    [sym_comment] = ACTIONS(3),
  },
  [351] = {
    [anon_sym_AT] = ACTIONS(1184),
    [anon_sym_throws] = ACTIONS(1184),
    [anon_sym_LBRACK] = ACTIONS(1184),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_GT] = ACTIONS(1184),
    [anon_sym_LBRACE] = ACTIONS(1184),
    [anon_sym_SEMI] = ACTIONS(1184),
  },
  [352] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(877),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [353] = {
    [sym_boolean_type] = ACTIONS(1186),
    [sym_void_type] = ACTIONS(1186),
    [sym_comment] = ACTIONS(3),
    [anon_sym_public] = ACTIONS(1186),
    [anon_sym_abstract] = ACTIONS(1186),
    [anon_sym_float] = ACTIONS(1186),
    [anon_sym_static] = ACTIONS(1186),
    [sym_identifier] = ACTIONS(1186),
    [anon_sym_char] = ACTIONS(1186),
    [anon_sym_AT] = ACTIONS(1188),
    [anon_sym_native] = ACTIONS(1186),
    [anon_sym_private] = ACTIONS(1186),
    [anon_sym_long] = ACTIONS(1186),
    [anon_sym_double] = ACTIONS(1186),
    [anon_sym_COMMA] = ACTIONS(1188),
    [anon_sym_protected] = ACTIONS(1186),
    [anon_sym_short] = ACTIONS(1186),
    [anon_sym_volatile] = ACTIONS(1186),
    [anon_sym_int] = ACTIONS(1186),
    [anon_sym_final] = ACTIONS(1186),
    [anon_sym_default] = ACTIONS(1186),
    [anon_sym_synchronized] = ACTIONS(1186),
    [anon_sym_transient] = ACTIONS(1186),
    [anon_sym_byte] = ACTIONS(1186),
    [anon_sym_RPAREN] = ACTIONS(1188),
    [anon_sym_strictfp] = ACTIONS(1186),
  },
  [354] = {
    [anon_sym_DOT] = ACTIONS(1190),
    [sym_comment] = ACTIONS(3),
  },
  [355] = {
    [sym_this] = ACTIONS(1192),
    [sym_comment] = ACTIONS(3),
  },
  [356] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1194),
  },
  [357] = {
    [anon_sym_AMP] = ACTIONS(1196),
    [anon_sym_COMMA] = ACTIONS(1196),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(1196),
    [anon_sym_RPAREN] = ACTIONS(1196),
  },
  [358] = {
    [anon_sym_DASH_DASH] = ACTIONS(1198),
    [anon_sym_GT_GT_GT] = ACTIONS(1198),
    [anon_sym_PERCENT] = ACTIONS(1198),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(1198),
    [anon_sym_EQ_EQ] = ACTIONS(1198),
    [anon_sym_AMP_AMP] = ACTIONS(1198),
    [anon_sym_SLASH] = ACTIONS(1200),
    [anon_sym_GT] = ACTIONS(1200),
    [anon_sym_AMP] = ACTIONS(1200),
    [anon_sym_instanceof] = ACTIONS(1198),
    [anon_sym_LT_EQ] = ACTIONS(1198),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_STAR] = ACTIONS(1198),
    [anon_sym_LT] = ACTIONS(1200),
    [anon_sym_COMMA] = ACTIONS(1198),
    [anon_sym_RPAREN] = ACTIONS(1198),
    [anon_sym_GT_GT] = ACTIONS(1200),
    [anon_sym_GT_EQ] = ACTIONS(1198),
    [anon_sym_LT_LT] = ACTIONS(1198),
    [anon_sym_COLON] = ACTIONS(1198),
    [anon_sym_PIPE] = ACTIONS(1200),
    [anon_sym_PIPE_PIPE] = ACTIONS(1198),
    [anon_sym_RBRACK] = ACTIONS(1198),
    [anon_sym_PLUS] = ACTIONS(1200),
    [anon_sym_BANG_EQ] = ACTIONS(1198),
    [anon_sym_CARET] = ACTIONS(1198),
    [anon_sym_RBRACE] = ACTIONS(1198),
    [anon_sym_SEMI] = ACTIONS(1198),
    [anon_sym_QMARK] = ACTIONS(1198),
  },
  [359] = {
    [sym_array_access] = STATE(39),
    [sym__type] = STATE(37),
    [sym_parenthesized_expression] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_method_reference] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym__primary_no_new_array] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym_assignment_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym__unannotated_type] = STATE(73),
    [sym_update_expression] = STATE(510),
    [sym_generic_type] = STATE(53),
    [sym_marker_annotation] = STATE(74),
    [sym_object_creation_expression] = STATE(43),
    [sym_binary_expression] = STATE(510),
    [sym_annotation] = STATE(74),
    [sym_class_literal] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_field_access] = STATE(39),
    [sym__annotation] = STATE(74),
    [sym_floating_point_type] = STATE(30),
    [sym_inferred_parameters] = STATE(42),
    [sym__primary] = STATE(41),
    [sym_lambda_expression] = STATE(510),
    [sym_method_invocation] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_scoped_identifier] = STATE(52),
    [sym_ternary_expression] = STATE(510),
    [sym_scoped_type_identifier] = STATE(36),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_formal_parameters] = STATE(42),
    [sym__expression] = STATE(510),
    [sym_cast_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_int] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_boolean_type] = ACTIONS(79),
    [sym_false] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_true] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_character_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_AT] = ACTIONS(118),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_null_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_super] = ACTIONS(9),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_new] = ACTIONS(19),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_long] = ACTIONS(33),
    [sym_decimal_integer_literal] = ACTIONS(5),
  },
  [360] = {
    [aux_sym_cast_expression_repeat1] = STATE(360),
    [anon_sym_AMP] = ACTIONS(1202),
    [anon_sym_RPAREN] = ACTIONS(1196),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1196),
    [anon_sym_GT] = ACTIONS(1196),
  },
  [361] = {
    [anon_sym_RPAREN] = ACTIONS(1205),
    [sym_comment] = ACTIONS(3),
  },
  [362] = {
    [sym_spread_parameter] = STATE(512),
    [sym_array_type] = STATE(213),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotation] = STATE(902),
    [sym_marker_annotation] = STATE(902),
    [sym_formal_parameter] = STATE(366),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym__annotation] = STATE(902),
    [sym_floating_point_type] = STATE(213),
    [sym_integral_type] = STATE(213),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(213),
    [sym_modifiers] = STATE(84),
    [sym_identifier] = ACTIONS(233),
    [sym_void_type] = ACTIONS(417),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(1205),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_private] = ACTIONS(126),
    [sym_boolean_type] = ACTIONS(417),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
  },
  [363] = {
    [sym_array_type] = STATE(200),
    [sym_floating_point_type] = STATE(200),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_integral_type] = STATE(200),
    [sym_annotation] = STATE(902),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__annotation] = STATE(902),
    [sym_marker_annotation] = STATE(902),
    [sym_modifiers] = STATE(202),
    [sym_spread_parameter] = STATE(512),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(200),
    [aux_sym_formal_parameters_repeat1] = STATE(367),
    [anon_sym_COMMA] = ACTIONS(1207),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
    [sym_void_type] = ACTIONS(397),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_final] = ACTIONS(126),
    [sym_boolean_type] = ACTIONS(397),
    [anon_sym_float] = ACTIONS(41),
    [sym_identifier] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(1205),
    [anon_sym_transient] = ACTIONS(126),
  },
  [364] = {
    [sym__variable_declarator_id] = STATE(142),
    [sym_variable_declarator] = STATE(514),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(243),
    [sym_identifier] = ACTIONS(247),
    [anon_sym_module] = ACTIONS(243),
  },
  [365] = {
    [sym_void_type] = ACTIONS(1209),
    [anon_sym_volatile] = ACTIONS(1209),
    [anon_sym_short] = ACTIONS(1209),
    [anon_sym_protected] = ACTIONS(1209),
    [sym_boolean_type] = ACTIONS(1209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(1209),
    [anon_sym_strictfp] = ACTIONS(1209),
    [anon_sym_char] = ACTIONS(1209),
    [anon_sym_default] = ACTIONS(1209),
    [anon_sym_AT] = ACTIONS(1211),
    [anon_sym_final] = ACTIONS(1209),
    [anon_sym_double] = ACTIONS(1209),
    [sym_identifier] = ACTIONS(1209),
    [anon_sym_native] = ACTIONS(1209),
    [anon_sym_public] = ACTIONS(1209),
    [anon_sym_byte] = ACTIONS(1209),
    [anon_sym_synchronized] = ACTIONS(1209),
    [anon_sym_abstract] = ACTIONS(1209),
    [anon_sym_int] = ACTIONS(1209),
    [anon_sym_static] = ACTIONS(1209),
    [anon_sym_transient] = ACTIONS(1209),
    [anon_sym_COMMA] = ACTIONS(1211),
    [anon_sym_private] = ACTIONS(1209),
    [anon_sym_RPAREN] = ACTIONS(1211),
    [anon_sym_long] = ACTIONS(1209),
  },
  [366] = {
    [anon_sym_long] = ACTIONS(1213),
    [sym_identifier] = ACTIONS(1213),
    [anon_sym_RPAREN] = ACTIONS(1215),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(1213),
    [anon_sym_private] = ACTIONS(1213),
    [anon_sym_native] = ACTIONS(1213),
    [anon_sym_static] = ACTIONS(1213),
    [anon_sym_synchronized] = ACTIONS(1213),
    [anon_sym_COMMA] = ACTIONS(1215),
    [anon_sym_default] = ACTIONS(1213),
    [anon_sym_int] = ACTIONS(1213),
    [anon_sym_strictfp] = ACTIONS(1213),
    [anon_sym_public] = ACTIONS(1213),
    [anon_sym_transient] = ACTIONS(1213),
    [anon_sym_float] = ACTIONS(1213),
    [anon_sym_char] = ACTIONS(1213),
    [anon_sym_abstract] = ACTIONS(1213),
    [anon_sym_final] = ACTIONS(1213),
    [sym_boolean_type] = ACTIONS(1213),
    [anon_sym_AT] = ACTIONS(1215),
    [anon_sym_byte] = ACTIONS(1213),
    [anon_sym_volatile] = ACTIONS(1213),
    [anon_sym_protected] = ACTIONS(1213),
    [anon_sym_short] = ACTIONS(1213),
    [sym_void_type] = ACTIONS(1213),
  },
  [367] = {
    [aux_sym_formal_parameters_repeat1] = STATE(367),
    [anon_sym_final] = ACTIONS(1213),
    [anon_sym_native] = ACTIONS(1213),
    [anon_sym_synchronized] = ACTIONS(1213),
    [anon_sym_abstract] = ACTIONS(1213),
    [anon_sym_byte] = ACTIONS(1213),
    [anon_sym_char] = ACTIONS(1213),
    [sym_comment] = ACTIONS(3),
    [anon_sym_default] = ACTIONS(1213),
    [anon_sym_protected] = ACTIONS(1213),
    [anon_sym_transient] = ACTIONS(1213),
    [anon_sym_float] = ACTIONS(1213),
    [anon_sym_double] = ACTIONS(1213),
    [anon_sym_public] = ACTIONS(1213),
    [anon_sym_AT] = ACTIONS(1215),
    [anon_sym_RPAREN] = ACTIONS(1215),
    [anon_sym_strictfp] = ACTIONS(1213),
    [anon_sym_short] = ACTIONS(1213),
    [sym_void_type] = ACTIONS(1213),
    [anon_sym_private] = ACTIONS(1213),
    [anon_sym_volatile] = ACTIONS(1213),
    [anon_sym_COMMA] = ACTIONS(1217),
    [anon_sym_static] = ACTIONS(1213),
    [anon_sym_int] = ACTIONS(1213),
    [anon_sym_long] = ACTIONS(1213),
    [sym_boolean_type] = ACTIONS(1213),
    [sym_identifier] = ACTIONS(1213),
  },
  [368] = {
    [sym_unary_expression] = STATE(49),
    [sym_ternary_expression] = STATE(49),
    [sym_try_statement] = STATE(516),
    [sym_enum_declaration] = STATE(516),
    [sym_assignment_expression] = STATE(49),
    [sym_switch_statement] = STATE(516),
    [sym__declaration] = STATE(516),
    [sym_package_declaration] = STATE(516),
    [sym_modifiers] = STATE(48),
    [sym_array_access] = STATE(39),
    [sym_object_creation_expression] = STATE(43),
    [sym_cast_expression] = STATE(49),
    [sym_instanceof_expression] = STATE(49),
    [sym_block] = STATE(516),
    [sym_labeled_statement] = STATE(516),
    [sym_import_declaration] = STATE(516),
    [sym__literal] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_while_statement] = STATE(516),
    [sym_synchronized_statement] = STATE(516),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_module_declaration] = STATE(516),
    [sym_scoped_identifier] = STATE(52),
    [sym_throw_statement] = STATE(516),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_parenthesized_expression] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_expression_statement] = STATE(516),
    [sym_interface_declaration] = STATE(516),
    [sym_method_invocation] = STATE(43),
    [sym_binary_expression] = STATE(49),
    [sym__primary_no_new_array] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_method_reference] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_assert_statement] = STATE(516),
    [sym_integral_type] = STATE(30),
    [sym_field_access] = STATE(39),
    [sym_continue_statement] = STATE(516),
    [sym__annotation] = STATE(51),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_local_variable_declaration_statement] = STATE(516),
    [sym_do_statement] = STATE(516),
    [sym_local_variable_declaration] = STATE(47),
    [sym_return_statement] = STATE(516),
    [sym_annotation] = STATE(51),
    [sym_inferred_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(51),
    [sym_formal_parameters] = STATE(42),
    [sym_array_type] = STATE(40),
    [sym_array_creation_expression] = STATE(41),
    [sym_class_literal] = STATE(43),
    [sym_enhanced_for_statement] = STATE(516),
    [sym_update_expression] = STATE(49),
    [sym__expression] = STATE(49),
    [sym_normal_interface_declaration] = STATE(45),
    [sym__unannotated_type] = STATE(40),
    [sym_try_with_resources_statement] = STATE(516),
    [sym_for_statement] = STATE(516),
    [sym_annotated_type] = STATE(37),
    [sym_if_statement] = STATE(516),
    [sym_lambda_expression] = STATE(49),
    [sym_break_statement] = STATE(516),
    [sym__type] = STATE(37),
    [sym_floating_point_type] = STATE(30),
    [sym_class_declaration] = STATE(516),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(1220),
    [anon_sym_module] = ACTIONS(21),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_float] = ACTIONS(41),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_synchronized] = ACTIONS(71),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_strictfp] = ACTIONS(7),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_false] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_public] = ACTIONS(7),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_double] = ACTIONS(41),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(23),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_throw] = ACTIONS(27),
    [sym_this] = ACTIONS(5),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(39),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_return] = ACTIONS(57),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_open] = ACTIONS(77),
    [sym_true] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
  },
  [369] = {
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_SEMI] = ACTIONS(1222),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(291),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_DASH_DASH] = ACTIONS(289),
  },
  [370] = {
    [anon_sym_LBRACE] = ACTIONS(1224),
    [anon_sym_implements] = ACTIONS(1224),
    [sym_comment] = ACTIONS(3),
  },
  [371] = {
    [sym_type_bound] = STATE(519),
    [anon_sym_extends] = ACTIONS(1226),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1228),
    [anon_sym_GT] = ACTIONS(1228),
  },
  [372] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym__annotation] = STATE(137),
    [sym_marker_annotation] = STATE(137),
    [sym_annotation] = STATE(137),
    [sym_identifier] = ACTIONS(1230),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
  },
  [373] = {
    [aux_sym_type_parameters_repeat1] = STATE(523),
    [anon_sym_GT] = ACTIONS(1232),
    [anon_sym_COMMA] = ACTIONS(1234),
    [sym_comment] = ACTIONS(3),
  },
  [374] = {
    [anon_sym_BANG_EQ] = ACTIONS(1236),
    [sym_true] = ACTIONS(1238),
    [anon_sym_double] = ACTIONS(1238),
    [anon_sym_CARET] = ACTIONS(1236),
    [sym_void_type] = ACTIONS(1238),
    [anon_sym_interface] = ACTIONS(1238),
    [anon_sym_LT_EQ] = ACTIONS(1236),
    [anon_sym_continue] = ACTIONS(1238),
    [anon_sym_module] = ACTIONS(1238),
    [anon_sym_static] = ACTIONS(1238),
    [anon_sym_return] = ACTIONS(1238),
    [anon_sym_PLUS_PLUS] = ACTIONS(1236),
    [anon_sym_long] = ACTIONS(1238),
    [anon_sym_instanceof] = ACTIONS(1238),
    [anon_sym_import] = ACTIONS(1238),
    [anon_sym_EQ_EQ] = ACTIONS(1236),
    [anon_sym_COLON_COLON] = ACTIONS(1236),
    [anon_sym_PLUS] = ACTIONS(1238),
    [anon_sym_synchronized] = ACTIONS(1238),
    [anon_sym_GT_EQ] = ACTIONS(1236),
    [anon_sym_DASH] = ACTIONS(1238),
    [anon_sym_RPAREN] = ACTIONS(1236),
    [sym_super] = ACTIONS(1238),
    [anon_sym_SLASH] = ACTIONS(1238),
    [sym_decimal_integer_literal] = ACTIONS(1238),
    [anon_sym_int] = ACTIONS(1238),
    [anon_sym_else] = ACTIONS(1238),
    [anon_sym_default] = ACTIONS(1238),
    [anon_sym_volatile] = ACTIONS(1238),
    [sym_this] = ACTIONS(1238),
    [sym_hex_integer_literal] = ACTIONS(1238),
    [anon_sym_DOT] = ACTIONS(1238),
    [sym_boolean_type] = ACTIONS(1238),
    [anon_sym_AT] = ACTIONS(1238),
    [anon_sym_throw] = ACTIONS(1238),
    [anon_sym_short] = ACTIONS(1238),
    [anon_sym_LPAREN] = ACTIONS(1236),
    [anon_sym_protected] = ACTIONS(1238),
    [anon_sym_PIPE_PIPE] = ACTIONS(1236),
    [anon_sym_assert] = ACTIONS(1238),
    [anon_sym_COMMA] = ACTIONS(1236),
    [anon_sym_COLON] = ACTIONS(1238),
    [anon_sym_TILDE] = ACTIONS(1236),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(1236),
    [anon_sym_GT] = ACTIONS(1238),
    [ts_builtin_sym_end] = ACTIONS(1236),
    [anon_sym_char] = ACTIONS(1238),
    [anon_sym_RBRACE] = ACTIONS(1236),
    [anon_sym_do] = ACTIONS(1238),
    [anon_sym_break] = ACTIONS(1238),
    [anon_sym_package] = ACTIONS(1238),
    [anon_sym_LT] = ACTIONS(1238),
    [sym_false] = ACTIONS(1238),
    [anon_sym_AMP_AMP] = ACTIONS(1236),
    [anon_sym_PIPE] = ACTIONS(1238),
    [anon_sym_PERCENT] = ACTIONS(1236),
    [anon_sym_GT_GT] = ACTIONS(1238),
    [sym_null_literal] = ACTIONS(1238),
    [anon_sym_STAR] = ACTIONS(1236),
    [anon_sym_final] = ACTIONS(1238),
    [sym_character_literal] = ACTIONS(1236),
    [anon_sym_BANG] = ACTIONS(1238),
    [sym_binary_integer_literal] = ACTIONS(1236),
    [sym_octal_integer_literal] = ACTIONS(1236),
    [anon_sym_DASH_DASH] = ACTIONS(1236),
    [anon_sym_private] = ACTIONS(1238),
    [anon_sym_float] = ACTIONS(1238),
    [sym_decimal_floating_point_literal] = ACTIONS(1236),
    [anon_sym_byte] = ACTIONS(1238),
    [anon_sym_LBRACE] = ACTIONS(1236),
    [anon_sym_case] = ACTIONS(1238),
    [anon_sym_enum] = ACTIONS(1238),
    [anon_sym_switch] = ACTIONS(1238),
    [anon_sym_SEMI] = ACTIONS(1236),
    [anon_sym_open] = ACTIONS(1238),
    [anon_sym_for] = ACTIONS(1238),
    [anon_sym_new] = ACTIONS(1238),
    [anon_sym_native] = ACTIONS(1238),
    [anon_sym_public] = ACTIONS(1238),
    [anon_sym_class] = ACTIONS(1238),
    [anon_sym_abstract] = ACTIONS(1238),
    [anon_sym_transient] = ACTIONS(1238),
    [anon_sym_AMP] = ACTIONS(1238),
    [anon_sym_while] = ACTIONS(1238),
    [anon_sym_ATinterface] = ACTIONS(1236),
    [anon_sym_try] = ACTIONS(1238),
    [anon_sym_RBRACK] = ACTIONS(1236),
    [anon_sym_strictfp] = ACTIONS(1238),
    [anon_sym_LT_LT] = ACTIONS(1236),
    [anon_sym_QMARK] = ACTIONS(1236),
    [sym_hex_floating_point_literal] = ACTIONS(1238),
    [sym_identifier] = ACTIONS(1238),
    [sym_string_literal] = ACTIONS(1236),
    [anon_sym_if] = ACTIONS(1238),
    [anon_sym_GT_GT_GT] = ACTIONS(1236),
  },
  [375] = {
    [sym_block] = STATE(524),
    [anon_sym_transient] = ACTIONS(184),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(184),
    [anon_sym_double] = ACTIONS(184),
    [anon_sym_volatile] = ACTIONS(184),
    [anon_sym_private] = ACTIONS(184),
    [anon_sym_protected] = ACTIONS(184),
    [anon_sym_short] = ACTIONS(184),
    [sym_comment] = ACTIONS(3),
    [anon_sym_final] = ACTIONS(184),
    [anon_sym_native] = ACTIONS(184),
    [sym_identifier] = ACTIONS(184),
    [anon_sym_abstract] = ACTIONS(184),
    [anon_sym_static] = ACTIONS(184),
    [anon_sym_strictfp] = ACTIONS(184),
    [anon_sym_float] = ACTIONS(184),
    [anon_sym_byte] = ACTIONS(184),
    [anon_sym_long] = ACTIONS(184),
    [sym_boolean_type] = ACTIONS(184),
    [anon_sym_public] = ACTIONS(184),
    [anon_sym_synchronized] = ACTIONS(184),
    [anon_sym_default] = ACTIONS(184),
    [anon_sym_interface] = ACTIONS(184),
    [anon_sym_char] = ACTIONS(184),
    [anon_sym_enum] = ACTIONS(184),
    [anon_sym_class] = ACTIONS(184),
    [anon_sym_ATinterface] = ACTIONS(186),
    [anon_sym_int] = ACTIONS(184),
    [sym_void_type] = ACTIONS(184),
    [anon_sym_LT] = ACTIONS(186),
  },
  [376] = {
    [sym_type_arguments] = STATE(64),
    [sym_formal_parameters] = STATE(526),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_open] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_module] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LPAREN] = ACTIONS(1240),
    [anon_sym_DOT] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(146),
  },
  [377] = {
    [sym_throws] = STATE(529),
    [sym_constructor_body] = STATE(530),
    [anon_sym_LBRACE] = ACTIONS(1242),
    [anon_sym_throws] = ACTIONS(1244),
    [sym_comment] = ACTIONS(3),
  },
  [378] = {
    [sym_block] = STATE(532),
    [anon_sym_SEMI] = ACTIONS(1246),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [379] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_field_declaration] = STATE(534),
    [sym__annotation] = STATE(44),
    [sym_enum_declaration] = STATE(534),
    [sym_class_declaration] = STATE(534),
    [sym__method_header] = STATE(378),
    [sym_array_type] = STATE(381),
    [sym__unannotated_type] = STATE(381),
    [sym_modifiers] = STATE(380),
    [sym_method_declaration] = STATE(534),
    [sym_annotation] = STATE(44),
    [sym_constructor_declarator] = STATE(377),
    [sym_integral_type] = STATE(381),
    [sym_interface_declaration] = STATE(534),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_marker_annotation] = STATE(44),
    [aux_sym_enum_body_declarations_repeat1] = STATE(534),
    [sym_type_parameters] = STATE(382),
    [sym_constructor_declaration] = STATE(534),
    [sym_generic_type] = STATE(53),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_floating_point_type] = STATE(381),
    [sym_block] = STATE(534),
    [sym_static_initializer] = STATE(534),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_ATinterface] = ACTIONS(59),
    [sym_identifier] = ACTIONS(901),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(895),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_synchronized] = ACTIONS(7),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_static] = ACTIONS(897),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(1248),
    [sym_void_type] = ACTIONS(895),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(1250),
  },
  [380] = {
    [sym__unannotated_type] = STATE(535),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_type_parameters] = STATE(382),
    [sym_integral_type] = STATE(535),
    [sym_constructor_declarator] = STATE(536),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(535),
    [sym_array_type] = STATE(535),
    [sym__method_header] = STATE(537),
    [anon_sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_enum] = ACTIONS(277),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(283),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(281),
    [anon_sym_class] = ACTIONS(279),
    [sym_void_type] = ACTIONS(1252),
    [sym_boolean_type] = ACTIONS(1252),
    [sym_identifier] = ACTIONS(901),
  },
  [381] = {
    [sym_marker_annotation] = STATE(145),
    [sym_variable_declarator] = STATE(143),
    [sym__variable_declarator_list] = STATE(541),
    [sym__method_declarator] = STATE(540),
    [sym_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym__variable_declarator_id] = STATE(142),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(1254),
    [anon_sym_open] = ACTIONS(1256),
    [anon_sym_module] = ACTIONS(1256),
  },
  [382] = {
    [sym_marker_annotation] = STATE(543),
    [sym__unannotated_type] = STATE(544),
    [sym_array_type] = STATE(544),
    [sym_floating_point_type] = STATE(544),
    [sym_generic_type] = STATE(53),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__annotation] = STATE(543),
    [aux_sym_dimensions_expr_repeat1] = STATE(543),
    [sym_integral_type] = STATE(544),
    [sym_annotation] = STATE(543),
    [sym_void_type] = ACTIONS(1258),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [sym_identifier] = ACTIONS(1260),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_byte] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(1258),
  },
  [383] = {
    [aux_sym_interface_type_list_repeat1] = STATE(546),
    [anon_sym_LBRACE] = ACTIONS(1262),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1264),
  },
  [384] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1266),
  },
  [385] = {
    [sym_super_interfaces] = STATE(548),
    [sym_class_body] = STATE(547),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_implements] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
  },
  [386] = {
    [anon_sym_DASH_DASH] = ACTIONS(1268),
    [anon_sym_new] = ACTIONS(1270),
    [anon_sym_SEMI] = ACTIONS(1268),
    [sym_identifier] = ACTIONS(1270),
    [anon_sym_static] = ACTIONS(1270),
    [anon_sym_double] = ACTIONS(1270),
    [anon_sym_LBRACE] = ACTIONS(1268),
    [sym_octal_integer_literal] = ACTIONS(1268),
    [anon_sym_class] = ACTIONS(1270),
    [anon_sym_switch] = ACTIONS(1270),
    [anon_sym_public] = ACTIONS(1270),
    [anon_sym_case] = ACTIONS(1270),
    [anon_sym_PLUS_PLUS] = ACTIONS(1268),
    [sym_character_literal] = ACTIONS(1268),
    [anon_sym_BANG] = ACTIONS(1268),
    [anon_sym_private] = ACTIONS(1270),
    [sym_string_literal] = ACTIONS(1268),
    [anon_sym_else] = ACTIONS(1270),
    [anon_sym_long] = ACTIONS(1270),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(1270),
    [anon_sym_import] = ACTIONS(1270),
    [sym_this] = ACTIONS(1270),
    [anon_sym_TILDE] = ACTIONS(1268),
    [anon_sym_short] = ACTIONS(1270),
    [anon_sym_AT] = ACTIONS(1270),
    [anon_sym_native] = ACTIONS(1270),
    [ts_builtin_sym_end] = ACTIONS(1268),
    [anon_sym_assert] = ACTIONS(1270),
    [sym_null_literal] = ACTIONS(1270),
    [sym_hex_integer_literal] = ACTIONS(1270),
    [anon_sym_abstract] = ACTIONS(1270),
    [anon_sym_RBRACE] = ACTIONS(1268),
    [anon_sym_while] = ACTIONS(1270),
    [anon_sym_strictfp] = ACTIONS(1270),
    [sym_decimal_floating_point_literal] = ACTIONS(1268),
    [anon_sym_transient] = ACTIONS(1270),
    [anon_sym_final] = ACTIONS(1270),
    [anon_sym_enum] = ACTIONS(1270),
    [anon_sym_LT] = ACTIONS(1268),
    [sym_binary_integer_literal] = ACTIONS(1268),
    [anon_sym_try] = ACTIONS(1270),
    [anon_sym_LPAREN] = ACTIONS(1268),
    [anon_sym_for] = ACTIONS(1270),
    [anon_sym_package] = ACTIONS(1270),
    [sym_false] = ACTIONS(1270),
    [anon_sym_break] = ACTIONS(1270),
    [anon_sym_do] = ACTIONS(1270),
    [anon_sym_throw] = ACTIONS(1270),
    [anon_sym_DASH] = ACTIONS(1270),
    [anon_sym_int] = ACTIONS(1270),
    [anon_sym_byte] = ACTIONS(1270),
    [anon_sym_float] = ACTIONS(1270),
    [anon_sym_default] = ACTIONS(1270),
    [anon_sym_interface] = ACTIONS(1270),
    [anon_sym_synchronized] = ACTIONS(1270),
    [anon_sym_char] = ACTIONS(1270),
    [anon_sym_ATinterface] = ACTIONS(1268),
    [sym_decimal_integer_literal] = ACTIONS(1270),
    [anon_sym_protected] = ACTIONS(1270),
    [sym_void_type] = ACTIONS(1270),
    [sym_boolean_type] = ACTIONS(1270),
    [anon_sym_PLUS] = ACTIONS(1270),
    [anon_sym_continue] = ACTIONS(1270),
    [anon_sym_volatile] = ACTIONS(1270),
    [anon_sym_return] = ACTIONS(1270),
    [anon_sym_if] = ACTIONS(1270),
    [anon_sym_module] = ACTIONS(1270),
    [sym_super] = ACTIONS(1270),
    [sym_hex_floating_point_literal] = ACTIONS(1270),
    [anon_sym_open] = ACTIONS(1270),
  },
  [387] = {
    [sym_class_body] = STATE(549),
    [anon_sym_LBRACE] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
  },
  [388] = {
    [sym_boolean_type] = ACTIONS(1272),
    [anon_sym_char] = ACTIONS(1272),
    [anon_sym_public] = ACTIONS(1272),
    [anon_sym_module] = ACTIONS(1272),
    [anon_sym_default] = ACTIONS(1272),
    [anon_sym_static] = ACTIONS(1272),
    [anon_sym_abstract] = ACTIONS(1272),
    [sym_super] = ACTIONS(1272),
    [anon_sym_TILDE] = ACTIONS(1274),
    [anon_sym_continue] = ACTIONS(1272),
    [anon_sym_for] = ACTIONS(1272),
    [sym_hex_floating_point_literal] = ACTIONS(1272),
    [anon_sym_enum] = ACTIONS(1272),
    [anon_sym_short] = ACTIONS(1272),
    [anon_sym_break] = ACTIONS(1272),
    [sym_false] = ACTIONS(1272),
    [sym_decimal_floating_point_literal] = ACTIONS(1274),
    [ts_builtin_sym_end] = ACTIONS(1274),
    [anon_sym_private] = ACTIONS(1272),
    [anon_sym_float] = ACTIONS(1272),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1274),
    [anon_sym_LBRACE] = ACTIONS(1274),
    [anon_sym_int] = ACTIONS(1272),
    [anon_sym_ATinterface] = ACTIONS(1274),
    [sym_identifier] = ACTIONS(1272),
    [anon_sym_assert] = ACTIONS(1272),
    [anon_sym_throw] = ACTIONS(1272),
    [anon_sym_long] = ACTIONS(1272),
    [anon_sym_import] = ACTIONS(1272),
    [anon_sym_case] = ACTIONS(1272),
    [anon_sym_volatile] = ACTIONS(1272),
    [anon_sym_strictfp] = ACTIONS(1272),
    [anon_sym_return] = ACTIONS(1272),
    [anon_sym_DASH] = ACTIONS(1272),
    [anon_sym_native] = ACTIONS(1272),
    [anon_sym_DASH_DASH] = ACTIONS(1274),
    [anon_sym_if] = ACTIONS(1272),
    [sym_this] = ACTIONS(1272),
    [sym_binary_integer_literal] = ACTIONS(1274),
    [anon_sym_switch] = ACTIONS(1272),
    [anon_sym_package] = ACTIONS(1272),
    [anon_sym_LT] = ACTIONS(1274),
    [anon_sym_try] = ACTIONS(1272),
    [sym_true] = ACTIONS(1272),
    [anon_sym_open] = ACTIONS(1272),
    [anon_sym_SEMI] = ACTIONS(1274),
    [sym_character_literal] = ACTIONS(1274),
    [sym_void_type] = ACTIONS(1272),
    [sym_decimal_integer_literal] = ACTIONS(1272),
    [anon_sym_transient] = ACTIONS(1272),
    [sym_octal_integer_literal] = ACTIONS(1274),
    [anon_sym_synchronized] = ACTIONS(1272),
    [anon_sym_protected] = ACTIONS(1272),
    [anon_sym_BANG] = ACTIONS(1274),
    [anon_sym_PLUS] = ACTIONS(1272),
    [anon_sym_new] = ACTIONS(1272),
    [anon_sym_AT] = ACTIONS(1272),
    [sym_hex_integer_literal] = ACTIONS(1272),
    [sym_string_literal] = ACTIONS(1274),
    [anon_sym_final] = ACTIONS(1272),
    [anon_sym_interface] = ACTIONS(1272),
    [anon_sym_PLUS_PLUS] = ACTIONS(1274),
    [anon_sym_class] = ACTIONS(1272),
    [anon_sym_while] = ACTIONS(1272),
    [anon_sym_double] = ACTIONS(1272),
    [anon_sym_else] = ACTIONS(1272),
    [anon_sym_LPAREN] = ACTIONS(1274),
    [anon_sym_do] = ACTIONS(1272),
    [sym_null_literal] = ACTIONS(1272),
    [anon_sym_byte] = ACTIONS(1272),
  },
  [389] = {
    [anon_sym_long] = ACTIONS(1276),
    [anon_sym_while] = ACTIONS(1276),
    [anon_sym_int] = ACTIONS(1276),
    [anon_sym_switch] = ACTIONS(1276),
    [sym_decimal_integer_literal] = ACTIONS(1276),
    [anon_sym_LBRACE] = ACTIONS(1278),
    [anon_sym_DASH_DASH] = ACTIONS(1278),
    [anon_sym_private] = ACTIONS(1276),
    [anon_sym_module] = ACTIONS(1276),
    [anon_sym_default] = ACTIONS(1276),
    [anon_sym_break] = ACTIONS(1276),
    [sym_hex_integer_literal] = ACTIONS(1276),
    [anon_sym_do] = ACTIONS(1276),
    [anon_sym_else] = ACTIONS(1276),
    [ts_builtin_sym_end] = ACTIONS(1278),
    [anon_sym_BANG] = ACTIONS(1278),
    [anon_sym_open] = ACTIONS(1276),
    [anon_sym_ATinterface] = ACTIONS(1278),
    [anon_sym_public] = ACTIONS(1276),
    [anon_sym_final] = ACTIONS(1276),
    [sym_hex_floating_point_literal] = ACTIONS(1276),
    [sym_string_literal] = ACTIONS(1278),
    [anon_sym_enum] = ACTIONS(1276),
    [anon_sym_volatile] = ACTIONS(1276),
    [anon_sym_import] = ACTIONS(1276),
    [anon_sym_try] = ACTIONS(1276),
    [anon_sym_continue] = ACTIONS(1276),
    [anon_sym_SEMI] = ACTIONS(1278),
    [anon_sym_transient] = ACTIONS(1276),
    [anon_sym_abstract] = ACTIONS(1276),
    [sym_this] = ACTIONS(1276),
    [sym_void_type] = ACTIONS(1276),
    [anon_sym_protected] = ACTIONS(1276),
    [sym_false] = ACTIONS(1276),
    [anon_sym_PLUS_PLUS] = ACTIONS(1278),
    [anon_sym_new] = ACTIONS(1276),
    [anon_sym_static] = ACTIONS(1276),
    [anon_sym_strictfp] = ACTIONS(1276),
    [anon_sym_DASH] = ACTIONS(1276),
    [anon_sym_class] = ACTIONS(1276),
    [anon_sym_if] = ACTIONS(1276),
    [anon_sym_short] = ACTIONS(1276),
    [anon_sym_interface] = ACTIONS(1276),
    [sym_super] = ACTIONS(1276),
    [sym_octal_integer_literal] = ACTIONS(1278),
    [anon_sym_RBRACE] = ACTIONS(1278),
    [anon_sym_byte] = ACTIONS(1276),
    [sym_decimal_floating_point_literal] = ACTIONS(1278),
    [sym_true] = ACTIONS(1276),
    [anon_sym_LT] = ACTIONS(1278),
    [anon_sym_TILDE] = ACTIONS(1278),
    [sym_identifier] = ACTIONS(1276),
    [anon_sym_char] = ACTIONS(1276),
    [anon_sym_assert] = ACTIONS(1276),
    [anon_sym_synchronized] = ACTIONS(1276),
    [anon_sym_for] = ACTIONS(1276),
    [anon_sym_AT] = ACTIONS(1276),
    [sym_boolean_type] = ACTIONS(1276),
    [anon_sym_case] = ACTIONS(1276),
    [anon_sym_return] = ACTIONS(1276),
    [anon_sym_double] = ACTIONS(1276),
    [anon_sym_LPAREN] = ACTIONS(1278),
    [sym_null_literal] = ACTIONS(1276),
    [anon_sym_throw] = ACTIONS(1276),
    [anon_sym_float] = ACTIONS(1276),
    [sym_character_literal] = ACTIONS(1278),
    [anon_sym_PLUS] = ACTIONS(1276),
    [anon_sym_package] = ACTIONS(1276),
    [anon_sym_native] = ACTIONS(1276),
    [sym_binary_integer_literal] = ACTIONS(1278),
    [sym_comment] = ACTIONS(3),
  },
  [390] = {
    [sym_class_body] = STATE(550),
    [anon_sym_LBRACE] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
  },
  [391] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1280),
  },
  [392] = {
    [anon_sym_abstract] = ACTIONS(1282),
    [anon_sym_float] = ACTIONS(1282),
    [sym_boolean_type] = ACTIONS(1282),
    [anon_sym_double] = ACTIONS(1282),
    [anon_sym_throw] = ACTIONS(1282),
    [anon_sym_synchronized] = ACTIONS(1282),
    [anon_sym_assert] = ACTIONS(1282),
    [anon_sym_char] = ACTIONS(1282),
    [anon_sym_DASH] = ACTIONS(1282),
    [anon_sym_private] = ACTIONS(1282),
    [anon_sym_switch] = ACTIONS(1282),
    [anon_sym_continue] = ACTIONS(1282),
    [anon_sym_ATinterface] = ACTIONS(1284),
    [sym_null_literal] = ACTIONS(1282),
    [sym_octal_integer_literal] = ACTIONS(1284),
    [anon_sym_package] = ACTIONS(1282),
    [anon_sym_final] = ACTIONS(1282),
    [anon_sym_long] = ACTIONS(1282),
    [anon_sym_BANG] = ACTIONS(1284),
    [anon_sym_strictfp] = ACTIONS(1282),
    [anon_sym_try] = ACTIONS(1282),
    [anon_sym_transient] = ACTIONS(1282),
    [anon_sym_native] = ACTIONS(1282),
    [sym_binary_integer_literal] = ACTIONS(1284),
    [anon_sym_short] = ACTIONS(1282),
    [anon_sym_protected] = ACTIONS(1282),
    [sym_character_literal] = ACTIONS(1284),
    [anon_sym_LBRACE] = ACTIONS(1284),
    [ts_builtin_sym_end] = ACTIONS(1284),
    [anon_sym_if] = ACTIONS(1282),
    [anon_sym_interface] = ACTIONS(1282),
    [anon_sym_RBRACE] = ACTIONS(1284),
    [anon_sym_break] = ACTIONS(1282),
    [sym_comment] = ACTIONS(3),
    [anon_sym_volatile] = ACTIONS(1282),
    [anon_sym_byte] = ACTIONS(1282),
    [anon_sym_open] = ACTIONS(1282),
    [anon_sym_int] = ACTIONS(1282),
    [anon_sym_import] = ACTIONS(1282),
    [anon_sym_PLUS_PLUS] = ACTIONS(1284),
    [anon_sym_case] = ACTIONS(1282),
    [anon_sym_PLUS] = ACTIONS(1282),
    [anon_sym_class] = ACTIONS(1282),
    [anon_sym_else] = ACTIONS(1282),
    [anon_sym_DASH_DASH] = ACTIONS(1284),
    [sym_hex_integer_literal] = ACTIONS(1282),
    [anon_sym_TILDE] = ACTIONS(1284),
    [sym_identifier] = ACTIONS(1282),
    [sym_true] = ACTIONS(1282),
    [anon_sym_SEMI] = ACTIONS(1284),
    [anon_sym_return] = ACTIONS(1282),
    [anon_sym_for] = ACTIONS(1282),
    [anon_sym_enum] = ACTIONS(1282),
    [anon_sym_AT] = ACTIONS(1282),
    [anon_sym_do] = ACTIONS(1282),
    [anon_sym_new] = ACTIONS(1282),
    [sym_false] = ACTIONS(1282),
    [anon_sym_default] = ACTIONS(1282),
    [sym_decimal_floating_point_literal] = ACTIONS(1284),
    [anon_sym_module] = ACTIONS(1282),
    [sym_super] = ACTIONS(1282),
    [anon_sym_LT] = ACTIONS(1284),
    [sym_hex_floating_point_literal] = ACTIONS(1282),
    [sym_void_type] = ACTIONS(1282),
    [sym_this] = ACTIONS(1282),
    [sym_decimal_integer_literal] = ACTIONS(1282),
    [sym_string_literal] = ACTIONS(1284),
    [anon_sym_static] = ACTIONS(1282),
    [anon_sym_public] = ACTIONS(1282),
    [anon_sym_LPAREN] = ACTIONS(1284),
    [anon_sym_while] = ACTIONS(1282),
  },
  [393] = {
    [anon_sym_SEMI] = ACTIONS(1286),
    [anon_sym_private] = ACTIONS(1288),
    [anon_sym_long] = ACTIONS(1288),
    [anon_sym_volatile] = ACTIONS(1288),
    [anon_sym_ATinterface] = ACTIONS(1286),
    [anon_sym_protected] = ACTIONS(1288),
    [sym_comment] = ACTIONS(3),
    [anon_sym_strictfp] = ACTIONS(1288),
    [anon_sym_transient] = ACTIONS(1288),
    [anon_sym_char] = ACTIONS(1288),
    [anon_sym_public] = ACTIONS(1288),
    [anon_sym_default] = ACTIONS(1288),
    [anon_sym_abstract] = ACTIONS(1288),
    [anon_sym_RBRACE] = ACTIONS(1286),
    [anon_sym_short] = ACTIONS(1288),
    [anon_sym_synchronized] = ACTIONS(1288),
    [sym_identifier] = ACTIONS(1288),
    [anon_sym_LT] = ACTIONS(1286),
    [anon_sym_final] = ACTIONS(1288),
    [anon_sym_static] = ACTIONS(1288),
    [anon_sym_byte] = ACTIONS(1288),
    [anon_sym_enum] = ACTIONS(1288),
    [anon_sym_float] = ACTIONS(1288),
    [anon_sym_native] = ACTIONS(1288),
    [anon_sym_AT] = ACTIONS(1288),
    [anon_sym_int] = ACTIONS(1288),
    [sym_boolean_type] = ACTIONS(1288),
    [sym_void_type] = ACTIONS(1288),
    [anon_sym_interface] = ACTIONS(1288),
    [anon_sym_class] = ACTIONS(1288),
    [anon_sym_double] = ACTIONS(1288),
  },
  [394] = {
    [sym__unannotated_type] = STATE(551),
    [sym_generic_type] = STATE(53),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__method_header] = STATE(537),
    [sym_array_type] = STATE(551),
    [sym_floating_point_type] = STATE(551),
    [sym_type_parameters] = STATE(396),
    [sym_integral_type] = STATE(551),
    [sym_identifier] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(283),
    [anon_sym_enum] = ACTIONS(277),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(1290),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_ATinterface] = ACTIONS(281),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_char] = ACTIONS(33),
    [sym_void_type] = ACTIONS(1290),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_class] = ACTIONS(279),
  },
  [395] = {
    [aux_sym_interface_body_repeat1] = STATE(553),
    [sym_enum_declaration] = STATE(393),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_interface_declaration] = STATE(393),
    [sym__annotation] = STATE(44),
    [sym__unannotated_type] = STATE(397),
    [sym_integral_type] = STATE(397),
    [sym_class_declaration] = STATE(393),
    [sym_interface_member_declaration] = STATE(553),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_generic_type] = STATE(53),
    [sym__method_header] = STATE(378),
    [sym_marker_annotation] = STATE(44),
    [sym_array_type] = STATE(397),
    [sym_constant_declaration] = STATE(393),
    [sym_type_parameters] = STATE(396),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_method_declaration] = STATE(393),
    [sym_modifiers] = STATE(394),
    [sym_annotation] = STATE(44),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_floating_point_type] = STATE(397),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_SEMI] = ACTIONS(913),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_short] = ACTIONS(33),
    [sym_void_type] = ACTIONS(911),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_interface] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(7),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_synchronized] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_double] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(911),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(1292),
  },
  [396] = {
    [sym_generic_type] = STATE(53),
    [sym__annotation] = STATE(543),
    [sym_integral_type] = STATE(544),
    [sym_marker_annotation] = STATE(543),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotation] = STATE(543),
    [sym_array_type] = STATE(544),
    [sym__unannotated_type] = STATE(544),
    [sym_floating_point_type] = STATE(544),
    [aux_sym_dimensions_expr_repeat1] = STATE(543),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [sym_void_type] = ACTIONS(1258),
    [sym_boolean_type] = ACTIONS(1258),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
  },
  [397] = {
    [sym_annotation] = STATE(145),
    [sym__method_declarator] = STATE(540),
    [sym__annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(142),
    [sym_marker_annotation] = STATE(145),
    [sym__variable_declarator_list] = STATE(554),
    [sym_dimensions] = STATE(144),
    [sym_variable_declarator] = STATE(143),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_identifier] = ACTIONS(1254),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(1256),
    [anon_sym_module] = ACTIONS(1256),
  },
  [398] = {
    [anon_sym_continue] = ACTIONS(1294),
    [anon_sym_do] = ACTIONS(1294),
    [anon_sym_DASH_DASH] = ACTIONS(1296),
    [anon_sym_package] = ACTIONS(1294),
    [anon_sym_public] = ACTIONS(1294),
    [anon_sym_volatile] = ACTIONS(1294),
    [anon_sym_else] = ACTIONS(1294),
    [sym_octal_integer_literal] = ACTIONS(1296),
    [anon_sym_throw] = ACTIONS(1294),
    [anon_sym_char] = ACTIONS(1294),
    [sym_this] = ACTIONS(1294),
    [anon_sym_transient] = ACTIONS(1294),
    [anon_sym_for] = ACTIONS(1294),
    [anon_sym_int] = ACTIONS(1294),
    [sym_comment] = ACTIONS(3),
    [sym_hex_floating_point_literal] = ACTIONS(1294),
    [anon_sym_short] = ACTIONS(1294),
    [sym_binary_integer_literal] = ACTIONS(1296),
    [sym_string_literal] = ACTIONS(1296),
    [anon_sym_break] = ACTIONS(1294),
    [sym_super] = ACTIONS(1294),
    [sym_true] = ACTIONS(1294),
    [anon_sym_ATinterface] = ACTIONS(1296),
    [sym_void_type] = ACTIONS(1294),
    [sym_decimal_integer_literal] = ACTIONS(1294),
    [anon_sym_try] = ACTIONS(1294),
    [sym_hex_integer_literal] = ACTIONS(1294),
    [anon_sym_byte] = ACTIONS(1294),
    [sym_decimal_floating_point_literal] = ACTIONS(1296),
    [sym_character_literal] = ACTIONS(1296),
    [anon_sym_SEMI] = ACTIONS(1296),
    [anon_sym_float] = ACTIONS(1294),
    [anon_sym_BANG] = ACTIONS(1296),
    [anon_sym_double] = ACTIONS(1294),
    [sym_null_literal] = ACTIONS(1294),
    [anon_sym_synchronized] = ACTIONS(1294),
    [anon_sym_LBRACE] = ACTIONS(1296),
    [anon_sym_switch] = ACTIONS(1294),
    [anon_sym_AT] = ACTIONS(1294),
    [sym_false] = ACTIONS(1294),
    [anon_sym_import] = ACTIONS(1294),
    [anon_sym_TILDE] = ACTIONS(1296),
    [anon_sym_native] = ACTIONS(1294),
    [anon_sym_protected] = ACTIONS(1294),
    [anon_sym_case] = ACTIONS(1294),
    [anon_sym_return] = ACTIONS(1294),
    [sym_identifier] = ACTIONS(1294),
    [anon_sym_PLUS_PLUS] = ACTIONS(1296),
    [anon_sym_enum] = ACTIONS(1294),
    [anon_sym_assert] = ACTIONS(1294),
    [anon_sym_module] = ACTIONS(1294),
    [anon_sym_interface] = ACTIONS(1294),
    [anon_sym_new] = ACTIONS(1294),
    [anon_sym_default] = ACTIONS(1294),
    [ts_builtin_sym_end] = ACTIONS(1296),
    [anon_sym_LT] = ACTIONS(1296),
    [sym_boolean_type] = ACTIONS(1294),
    [anon_sym_open] = ACTIONS(1294),
    [anon_sym_strictfp] = ACTIONS(1294),
    [anon_sym_DASH] = ACTIONS(1294),
    [anon_sym_class] = ACTIONS(1294),
    [anon_sym_long] = ACTIONS(1294),
    [anon_sym_RBRACE] = ACTIONS(1296),
    [anon_sym_if] = ACTIONS(1294),
    [anon_sym_LPAREN] = ACTIONS(1296),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_private] = ACTIONS(1294),
    [anon_sym_abstract] = ACTIONS(1294),
    [anon_sym_final] = ACTIONS(1294),
    [anon_sym_static] = ACTIONS(1294),
    [anon_sym_PLUS] = ACTIONS(1294),
  },
  [399] = {
    [sym_interface_body] = STATE(555),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(443),
  },
  [400] = {
    [anon_sym_LBRACE] = ACTIONS(801),
    [anon_sym_open] = ACTIONS(796),
    [anon_sym_GT] = ACTIONS(801),
    [anon_sym_LBRACK] = ACTIONS(801),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(801),
    [anon_sym_PIPE] = ACTIONS(801),
    [anon_sym_SEMI] = ACTIONS(801),
    [anon_sym_module] = ACTIONS(796),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_DOT] = ACTIONS(796),
    [sym_identifier] = ACTIONS(796),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(801),
    [anon_sym_COMMA] = ACTIONS(801),
    [anon_sym_LT] = ACTIONS(801),
    [anon_sym_implements] = ACTIONS(796),
    [sym_this] = ACTIONS(796),
    [anon_sym_AMP] = ACTIONS(801),
    [anon_sym_AT] = ACTIONS(801),
    [anon_sym_COLON_COLON] = ACTIONS(801),
  },
  [401] = {
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_RBRACK] = ACTIONS(1298),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [sym_comment] = ACTIONS(3),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
  },
  [402] = {
    [sym_generic_type] = STATE(53),
    [sym_ternary_expression] = STATE(560),
    [sym_scoped_identifier] = STATE(52),
    [sym_annotation] = STATE(74),
    [sym__annotation] = STATE(74),
    [sym__expression] = STATE(560),
    [sym_method_reference] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_instanceof_expression] = STATE(560),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_method_invocation] = STATE(43),
    [sym_array_initializer] = STATE(559),
    [sym_formal_parameters] = STATE(42),
    [sym_integral_type] = STATE(30),
    [sym_floating_point_type] = STATE(30),
    [sym_binary_expression] = STATE(560),
    [sym_object_creation_expression] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_cast_expression] = STATE(560),
    [sym_lambda_expression] = STATE(560),
    [sym__primary_no_new_array] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_parenthesized_expression] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_unary_expression] = STATE(560),
    [sym__type] = STATE(37),
    [sym_marker_annotation] = STATE(74),
    [sym_assignment_expression] = STATE(560),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotated_type] = STATE(37),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_class_literal] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_field_access] = STATE(39),
    [sym_inferred_parameters] = STATE(42),
    [sym_update_expression] = STATE(560),
    [sym__unannotated_type] = STATE(73),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_char] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_this] = ACTIONS(5),
    [anon_sym_RBRACE] = ACTIONS(1300),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_module] = ACTIONS(120),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(118),
    [sym_character_literal] = ACTIONS(35),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_LBRACE] = ACTIONS(921),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [anon_sym_COMMA] = ACTIONS(1302),
    [anon_sym_open] = ACTIONS(120),
  },
  [403] = {
    [anon_sym_AMP] = ACTIONS(1304),
    [anon_sym_LT] = ACTIONS(1304),
    [anon_sym_BANG_EQ] = ACTIONS(1306),
    [anon_sym_STAR] = ACTIONS(1306),
    [anon_sym_PLUS_PLUS] = ACTIONS(1306),
    [anon_sym_AMP_AMP] = ACTIONS(1306),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_EQ] = ACTIONS(1306),
    [anon_sym_GT] = ACTIONS(1304),
    [anon_sym_SEMI] = ACTIONS(1306),
    [anon_sym_EQ_EQ] = ACTIONS(1306),
    [anon_sym_CARET] = ACTIONS(1306),
    [anon_sym_LT_LT] = ACTIONS(1306),
    [anon_sym_DASH_DASH] = ACTIONS(1306),
    [anon_sym_SLASH] = ACTIONS(1304),
    [anon_sym_PLUS] = ACTIONS(1304),
    [anon_sym_LT_EQ] = ACTIONS(1306),
    [anon_sym_COMMA] = ACTIONS(1306),
    [anon_sym_GT_GT_GT] = ACTIONS(1306),
    [anon_sym_DASH] = ACTIONS(1304),
    [anon_sym_COLON_COLON] = ACTIONS(1306),
    [anon_sym_RBRACK] = ACTIONS(1306),
    [anon_sym_PERCENT] = ACTIONS(1306),
    [anon_sym_QMARK] = ACTIONS(1306),
    [anon_sym_COLON] = ACTIONS(1304),
    [anon_sym_instanceof] = ACTIONS(1306),
    [anon_sym_PIPE] = ACTIONS(1304),
    [anon_sym_DOT] = ACTIONS(1306),
    [anon_sym_GT_GT] = ACTIONS(1304),
    [anon_sym_RPAREN] = ACTIONS(1306),
    [anon_sym_PIPE_PIPE] = ACTIONS(1306),
    [anon_sym_RBRACE] = ACTIONS(1306),
  },
  [404] = {
    [anon_sym_BANG_EQ] = ACTIONS(1308),
    [anon_sym_SEMI] = ACTIONS(1308),
    [anon_sym_DASH_DASH] = ACTIONS(1308),
    [anon_sym_PIPE] = ACTIONS(1310),
    [anon_sym_AMP] = ACTIONS(1310),
    [anon_sym_LT_EQ] = ACTIONS(1308),
    [anon_sym_DOT] = ACTIONS(1308),
    [anon_sym_STAR] = ACTIONS(1308),
    [anon_sym_GT_GT_GT] = ACTIONS(1308),
    [anon_sym_LT_LT] = ACTIONS(1308),
    [anon_sym_AMP_AMP] = ACTIONS(1308),
    [anon_sym_PLUS] = ACTIONS(1310),
    [anon_sym_LT] = ACTIONS(1310),
    [anon_sym_instanceof] = ACTIONS(1308),
    [anon_sym_LBRACK] = ACTIONS(1308),
    [anon_sym_RPAREN] = ACTIONS(1308),
    [anon_sym_COLON] = ACTIONS(1310),
    [anon_sym_PLUS_PLUS] = ACTIONS(1308),
    [anon_sym_GT_EQ] = ACTIONS(1308),
    [anon_sym_GT] = ACTIONS(1310),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1308),
    [anon_sym_GT_GT] = ACTIONS(1310),
    [anon_sym_EQ_EQ] = ACTIONS(1308),
    [anon_sym_SLASH] = ACTIONS(1310),
    [anon_sym_PERCENT] = ACTIONS(1308),
    [anon_sym_PIPE_PIPE] = ACTIONS(1308),
    [anon_sym_QMARK] = ACTIONS(1308),
    [anon_sym_CARET] = ACTIONS(1308),
    [anon_sym_RBRACK] = ACTIONS(1308),
    [anon_sym_DASH] = ACTIONS(1310),
    [anon_sym_RBRACE] = ACTIONS(1308),
    [anon_sym_COLON_COLON] = ACTIONS(1308),
  },
  [405] = {
    [sym_cast_expression] = STATE(561),
    [sym_assignment_expression] = STATE(561),
    [sym__annotation] = STATE(74),
    [sym__type] = STATE(37),
    [sym_instanceof_expression] = STATE(561),
    [sym_object_creation_expression] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_formal_parameters] = STATE(42),
    [sym_integral_type] = STATE(30),
    [sym_parenthesized_expression] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym__literal] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_update_expression] = STATE(561),
    [sym_array_access] = STATE(39),
    [sym_marker_annotation] = STATE(74),
    [sym_method_invocation] = STATE(43),
    [sym_annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym_unary_expression] = STATE(561),
    [sym__primary] = STATE(41),
    [sym_array_type] = STATE(73),
    [sym_array_creation_expression] = STATE(41),
    [sym_class_literal] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_lambda_expression] = STATE(561),
    [sym_ternary_expression] = STATE(561),
    [sym__primary_no_new_array] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_scoped_identifier] = STATE(52),
    [sym_annotated_type] = STATE(37),
    [sym_binary_expression] = STATE(561),
    [sym__expression] = STATE(561),
    [sym_field_access] = STATE(39),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_boolean_type] = ACTIONS(79),
    [sym_null_literal] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_this] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_RBRACK] = ACTIONS(1127),
    [anon_sym_new] = ACTIONS(19),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_void_type] = ACTIONS(55),
    [sym_identifier] = ACTIONS(124),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_int] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [sym_false] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_true] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
  },
  [406] = {
    [aux_sym_array_creation_expression_repeat1] = STATE(406),
    [sym_annotation] = STATE(563),
    [sym__annotation] = STATE(563),
    [aux_sym_dimensions_expr_repeat1] = STATE(563),
    [sym_marker_annotation] = STATE(563),
    [sym_dimensions_expr] = STATE(406),
    [anon_sym_DASH_DASH] = ACTIONS(1312),
    [anon_sym_BANG_EQ] = ACTIONS(1312),
    [anon_sym_COMMA] = ACTIONS(1312),
    [anon_sym_AT] = ACTIONS(1314),
    [anon_sym_GT_GT_GT] = ACTIONS(1312),
    [anon_sym_COLON_COLON] = ACTIONS(1312),
    [anon_sym_LBRACK] = ACTIONS(1317),
    [anon_sym_PLUS_PLUS] = ACTIONS(1312),
    [anon_sym_LT_EQ] = ACTIONS(1312),
    [anon_sym_GT] = ACTIONS(1320),
    [anon_sym_STAR] = ACTIONS(1312),
    [anon_sym_CARET] = ACTIONS(1312),
    [anon_sym_RBRACK] = ACTIONS(1312),
    [anon_sym_SLASH] = ACTIONS(1320),
    [anon_sym_RPAREN] = ACTIONS(1312),
    [anon_sym_LT_LT] = ACTIONS(1312),
    [anon_sym_GT_GT] = ACTIONS(1320),
    [anon_sym_COLON] = ACTIONS(1320),
    [anon_sym_LT] = ACTIONS(1320),
    [anon_sym_PLUS] = ACTIONS(1320),
    [anon_sym_GT_EQ] = ACTIONS(1312),
    [anon_sym_PIPE_PIPE] = ACTIONS(1312),
    [anon_sym_instanceof] = ACTIONS(1312),
    [anon_sym_DASH] = ACTIONS(1320),
    [anon_sym_DOT] = ACTIONS(1312),
    [anon_sym_RBRACE] = ACTIONS(1312),
    [anon_sym_AMP] = ACTIONS(1320),
    [anon_sym_AMP_AMP] = ACTIONS(1312),
    [anon_sym_EQ_EQ] = ACTIONS(1312),
    [anon_sym_SEMI] = ACTIONS(1312),
    [anon_sym_PIPE] = ACTIONS(1320),
    [anon_sym_PERCENT] = ACTIONS(1312),
    [sym_comment] = ACTIONS(3),
    [anon_sym_QMARK] = ACTIONS(1312),
  },
  [407] = {
    [anon_sym_AMP] = ACTIONS(1322),
    [anon_sym_SEMI] = ACTIONS(1324),
    [anon_sym_GT] = ACTIONS(1322),
    [anon_sym_STAR] = ACTIONS(1324),
    [anon_sym_COLON] = ACTIONS(1322),
    [anon_sym_DASH_DASH] = ACTIONS(1324),
    [anon_sym_RBRACK] = ACTIONS(1324),
    [anon_sym_GT_GT_GT] = ACTIONS(1324),
    [anon_sym_LT_LT] = ACTIONS(1324),
    [anon_sym_SLASH] = ACTIONS(1322),
    [anon_sym_BANG_EQ] = ACTIONS(1324),
    [sym_comment] = ACTIONS(3),
    [anon_sym_instanceof] = ACTIONS(1324),
    [anon_sym_GT_EQ] = ACTIONS(1324),
    [anon_sym_EQ_EQ] = ACTIONS(1324),
    [anon_sym_PIPE] = ACTIONS(1322),
    [anon_sym_RBRACE] = ACTIONS(1324),
    [anon_sym_DASH] = ACTIONS(1322),
    [anon_sym_AMP_AMP] = ACTIONS(1324),
    [anon_sym_PLUS] = ACTIONS(1322),
    [anon_sym_COLON_COLON] = ACTIONS(1324),
    [anon_sym_CARET] = ACTIONS(1324),
    [anon_sym_LT_EQ] = ACTIONS(1324),
    [anon_sym_QMARK] = ACTIONS(1324),
    [anon_sym_PIPE_PIPE] = ACTIONS(1324),
    [anon_sym_PLUS_PLUS] = ACTIONS(1324),
    [anon_sym_LT] = ACTIONS(1322),
    [anon_sym_PERCENT] = ACTIONS(1324),
    [anon_sym_GT_GT] = ACTIONS(1322),
    [anon_sym_RPAREN] = ACTIONS(1324),
    [anon_sym_DOT] = ACTIONS(1324),
    [anon_sym_COMMA] = ACTIONS(1324),
  },
  [408] = {
    [anon_sym_LT_EQ] = ACTIONS(1326),
    [anon_sym_LT] = ACTIONS(1328),
    [anon_sym_COLON_COLON] = ACTIONS(1326),
    [anon_sym_DASH_DASH] = ACTIONS(1326),
    [anon_sym_PIPE_PIPE] = ACTIONS(1326),
    [anon_sym_DASH] = ACTIONS(1328),
    [anon_sym_AMP_AMP] = ACTIONS(1326),
    [anon_sym_AMP] = ACTIONS(1328),
    [anon_sym_PERCENT] = ACTIONS(1326),
    [anon_sym_PLUS] = ACTIONS(1328),
    [anon_sym_LT_LT] = ACTIONS(1326),
    [anon_sym_DOT] = ACTIONS(1326),
    [anon_sym_GT_EQ] = ACTIONS(1326),
    [sym_comment] = ACTIONS(3),
    [anon_sym_CARET] = ACTIONS(1326),
    [anon_sym_PLUS_PLUS] = ACTIONS(1326),
    [anon_sym_PIPE] = ACTIONS(1328),
    [anon_sym_RPAREN] = ACTIONS(1326),
    [anon_sym_RBRACE] = ACTIONS(1326),
    [anon_sym_STAR] = ACTIONS(1326),
    [anon_sym_COMMA] = ACTIONS(1326),
    [anon_sym_instanceof] = ACTIONS(1326),
    [anon_sym_EQ_EQ] = ACTIONS(1326),
    [anon_sym_SEMI] = ACTIONS(1326),
    [anon_sym_GT_GT] = ACTIONS(1328),
    [anon_sym_QMARK] = ACTIONS(1326),
    [anon_sym_GT_GT_GT] = ACTIONS(1326),
    [anon_sym_GT] = ACTIONS(1328),
    [anon_sym_BANG_EQ] = ACTIONS(1326),
    [anon_sym_COLON] = ACTIONS(1328),
    [anon_sym_SLASH] = ACTIONS(1328),
    [anon_sym_RBRACK] = ACTIONS(1326),
  },
  [409] = {
    [anon_sym_COLON] = ACTIONS(1330),
    [anon_sym_PIPE_PIPE] = ACTIONS(1332),
    [anon_sym_STAR] = ACTIONS(1332),
    [anon_sym_GT_EQ] = ACTIONS(1332),
    [anon_sym_BANG_EQ] = ACTIONS(1332),
    [anon_sym_AMP] = ACTIONS(1330),
    [anon_sym_PLUS_PLUS] = ACTIONS(1332),
    [anon_sym_COLON_COLON] = ACTIONS(1332),
    [anon_sym_LT_LT] = ACTIONS(1332),
    [anon_sym_CARET] = ACTIONS(1332),
    [anon_sym_PLUS] = ACTIONS(1330),
    [anon_sym_LBRACK] = ACTIONS(1332),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1332),
    [anon_sym_LT] = ACTIONS(1330),
    [anon_sym_SEMI] = ACTIONS(1332),
    [anon_sym_DOT] = ACTIONS(1332),
    [anon_sym_GT_GT_GT] = ACTIONS(1332),
    [anon_sym_COMMA] = ACTIONS(1332),
    [anon_sym_GT] = ACTIONS(1330),
    [anon_sym_EQ_EQ] = ACTIONS(1332),
    [anon_sym_QMARK] = ACTIONS(1332),
    [anon_sym_DASH_DASH] = ACTIONS(1332),
    [anon_sym_GT_GT] = ACTIONS(1330),
    [anon_sym_PERCENT] = ACTIONS(1332),
    [anon_sym_LT_EQ] = ACTIONS(1332),
    [anon_sym_AMP_AMP] = ACTIONS(1332),
    [anon_sym_PIPE] = ACTIONS(1330),
    [anon_sym_SLASH] = ACTIONS(1330),
    [anon_sym_instanceof] = ACTIONS(1332),
    [anon_sym_DASH] = ACTIONS(1330),
    [anon_sym_RBRACK] = ACTIONS(1332),
    [anon_sym_RPAREN] = ACTIONS(1332),
  },
  [410] = {
    [anon_sym_QMARK] = ACTIONS(1334),
    [anon_sym_DOT] = ACTIONS(1334),
    [anon_sym_SEMI] = ACTIONS(1334),
    [anon_sym_COLON] = ACTIONS(1336),
    [anon_sym_BANG_EQ] = ACTIONS(1334),
    [anon_sym_PLUS_PLUS] = ACTIONS(1334),
    [anon_sym_PLUS] = ACTIONS(1336),
    [anon_sym_GT_GT_GT] = ACTIONS(1334),
    [anon_sym_STAR] = ACTIONS(1334),
    [anon_sym_LT] = ACTIONS(1336),
    [anon_sym_AMP] = ACTIONS(1336),
    [anon_sym_DASH_DASH] = ACTIONS(1334),
    [anon_sym_GT] = ACTIONS(1336),
    [anon_sym_GT_GT] = ACTIONS(1336),
    [anon_sym_LT_LT] = ACTIONS(1334),
    [anon_sym_PIPE_PIPE] = ACTIONS(1334),
    [sym_comment] = ACTIONS(3),
    [anon_sym_CARET] = ACTIONS(1334),
    [anon_sym_RBRACK] = ACTIONS(1334),
    [anon_sym_COMMA] = ACTIONS(1334),
    [anon_sym_RBRACE] = ACTIONS(1334),
    [anon_sym_LT_EQ] = ACTIONS(1334),
    [anon_sym_RPAREN] = ACTIONS(1334),
    [anon_sym_PERCENT] = ACTIONS(1334),
    [anon_sym_COLON_COLON] = ACTIONS(1334),
    [anon_sym_GT_EQ] = ACTIONS(1334),
    [anon_sym_AMP_AMP] = ACTIONS(1334),
    [anon_sym_DASH] = ACTIONS(1336),
    [anon_sym_PIPE] = ACTIONS(1336),
    [anon_sym_SLASH] = ACTIONS(1336),
    [anon_sym_instanceof] = ACTIONS(1334),
    [anon_sym_EQ_EQ] = ACTIONS(1334),
  },
  [411] = {
    [sym_class_body] = STATE(564),
    [anon_sym_GT] = ACTIONS(1338),
    [anon_sym_AMP] = ACTIONS(1338),
    [anon_sym_SEMI] = ACTIONS(1340),
    [anon_sym_DOT] = ACTIONS(1340),
    [anon_sym_LT_EQ] = ACTIONS(1340),
    [anon_sym_COLON] = ACTIONS(1338),
    [anon_sym_COMMA] = ACTIONS(1340),
    [anon_sym_LT] = ACTIONS(1338),
    [anon_sym_RBRACK] = ACTIONS(1340),
    [anon_sym_RPAREN] = ACTIONS(1340),
    [anon_sym_RBRACE] = ACTIONS(1340),
    [anon_sym_BANG_EQ] = ACTIONS(1340),
    [anon_sym_QMARK] = ACTIONS(1340),
    [anon_sym_PLUS_PLUS] = ACTIONS(1340),
    [anon_sym_GT_EQ] = ACTIONS(1340),
    [anon_sym_PERCENT] = ACTIONS(1340),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1340),
    [anon_sym_CARET] = ACTIONS(1340),
    [anon_sym_COLON_COLON] = ACTIONS(1340),
    [anon_sym_PLUS] = ACTIONS(1338),
    [anon_sym_instanceof] = ACTIONS(1340),
    [anon_sym_AMP_AMP] = ACTIONS(1340),
    [anon_sym_LT_LT] = ACTIONS(1340),
    [anon_sym_DASH_DASH] = ACTIONS(1340),
    [anon_sym_EQ_EQ] = ACTIONS(1340),
    [anon_sym_PIPE] = ACTIONS(1338),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_GT_GT] = ACTIONS(1338),
    [anon_sym_DASH] = ACTIONS(1338),
    [anon_sym_STAR] = ACTIONS(1340),
    [anon_sym_LBRACK] = ACTIONS(1340),
    [anon_sym_GT_GT_GT] = ACTIONS(1340),
    [anon_sym_SLASH] = ACTIONS(1338),
  },
  [412] = {
    [sym_class_body] = STATE(565),
    [anon_sym_GT_EQ] = ACTIONS(1342),
    [anon_sym_COMMA] = ACTIONS(1342),
    [anon_sym_PIPE] = ACTIONS(1344),
    [anon_sym_LT_LT] = ACTIONS(1342),
    [anon_sym_DASH_DASH] = ACTIONS(1342),
    [anon_sym_GT_GT_GT] = ACTIONS(1342),
    [anon_sym_GT_GT] = ACTIONS(1344),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(1342),
    [anon_sym_AMP_AMP] = ACTIONS(1342),
    [anon_sym_PLUS] = ACTIONS(1344),
    [anon_sym_PLUS_PLUS] = ACTIONS(1342),
    [anon_sym_DOT] = ACTIONS(1342),
    [anon_sym_COLON_COLON] = ACTIONS(1342),
    [anon_sym_RPAREN] = ACTIONS(1342),
    [anon_sym_COLON] = ACTIONS(1344),
    [anon_sym_RBRACK] = ACTIONS(1342),
    [anon_sym_LT] = ACTIONS(1344),
    [anon_sym_EQ_EQ] = ACTIONS(1342),
    [anon_sym_SLASH] = ACTIONS(1344),
    [anon_sym_AMP] = ACTIONS(1344),
    [anon_sym_DASH] = ACTIONS(1344),
    [anon_sym_CARET] = ACTIONS(1342),
    [anon_sym_QMARK] = ACTIONS(1342),
    [anon_sym_RBRACE] = ACTIONS(1342),
    [anon_sym_PIPE_PIPE] = ACTIONS(1342),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_SEMI] = ACTIONS(1342),
    [anon_sym_LT_EQ] = ACTIONS(1342),
    [anon_sym_BANG_EQ] = ACTIONS(1342),
    [anon_sym_GT] = ACTIONS(1344),
    [anon_sym_instanceof] = ACTIONS(1342),
    [anon_sym_PERCENT] = ACTIONS(1342),
    [anon_sym_STAR] = ACTIONS(1342),
  },
  [413] = {
    [sym_array_access] = STATE(39),
    [sym__primary_no_new_array] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_floating_point_type] = STATE(30),
    [sym_generic_type] = STATE(53),
    [sym_annotated_type] = STATE(37),
    [sym__literal] = STATE(43),
    [sym_annotation] = STATE(74),
    [sym_method_invocation] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_binary_expression] = STATE(566),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_scoped_identifier] = STATE(52),
    [sym_object_creation_expression] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_method_reference] = STATE(43),
    [sym_cast_expression] = STATE(566),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_parenthesized_expression] = STATE(43),
    [sym_assignment_expression] = STATE(566),
    [sym_class_literal] = STATE(43),
    [sym__primary] = STATE(41),
    [sym__annotation] = STATE(74),
    [sym_array_creation_expression] = STATE(41),
    [sym_integral_type] = STATE(30),
    [sym_array_type] = STATE(73),
    [sym_unary_expression] = STATE(566),
    [sym_formal_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(74),
    [sym_update_expression] = STATE(566),
    [sym_inferred_parameters] = STATE(42),
    [sym_instanceof_expression] = STATE(566),
    [sym_ternary_expression] = STATE(566),
    [sym_lambda_expression] = STATE(566),
    [sym__expression] = STATE(566),
    [sym__type] = STATE(37),
    [sym_identifier] = ACTIONS(124),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(41),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_false] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_boolean_type] = ACTIONS(79),
    [sym_this] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [sym_void_type] = ACTIONS(55),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(118),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_super] = ACTIONS(9),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(33),
    [sym_character_literal] = ACTIONS(35),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
  },
  [414] = {
    [sym_identifier] = ACTIONS(184),
    [anon_sym_float] = ACTIONS(184),
    [anon_sym_double] = ACTIONS(184),
    [anon_sym_int] = ACTIONS(184),
    [anon_sym_final] = ACTIONS(184),
    [sym_comment] = ACTIONS(3),
    [anon_sym_strictfp] = ACTIONS(184),
    [anon_sym_static] = ACTIONS(184),
    [anon_sym_protected] = ACTIONS(184),
    [anon_sym_interface] = ACTIONS(184),
    [anon_sym_synchronized] = ACTIONS(184),
    [anon_sym_enum] = ACTIONS(184),
    [anon_sym_native] = ACTIONS(184),
    [anon_sym_byte] = ACTIONS(184),
    [anon_sym_default] = ACTIONS(184),
    [anon_sym_volatile] = ACTIONS(184),
    [sym_void_type] = ACTIONS(184),
    [anon_sym_public] = ACTIONS(184),
    [anon_sym_private] = ACTIONS(184),
    [anon_sym_ATinterface] = ACTIONS(186),
    [anon_sym_long] = ACTIONS(184),
    [anon_sym_COLON] = ACTIONS(1346),
    [anon_sym_short] = ACTIONS(184),
    [anon_sym_AT] = ACTIONS(184),
    [anon_sym_transient] = ACTIONS(184),
    [anon_sym_abstract] = ACTIONS(184),
    [anon_sym_char] = ACTIONS(184),
    [sym_boolean_type] = ACTIONS(184),
    [anon_sym_class] = ACTIONS(184),
  },
  [415] = {
    [sym_hex_floating_point_literal] = ACTIONS(1348),
    [anon_sym_assert] = ACTIONS(1348),
    [sym_identifier] = ACTIONS(1348),
    [anon_sym_private] = ACTIONS(1348),
    [anon_sym_import] = ACTIONS(1348),
    [anon_sym_module] = ACTIONS(1348),
    [anon_sym_break] = ACTIONS(1348),
    [anon_sym_while] = ACTIONS(1348),
    [anon_sym_switch] = ACTIONS(1348),
    [anon_sym_synchronized] = ACTIONS(1348),
    [anon_sym_LBRACE] = ACTIONS(1350),
    [anon_sym_try] = ACTIONS(1348),
    [anon_sym_final] = ACTIONS(1348),
    [anon_sym_continue] = ACTIONS(1348),
    [anon_sym_double] = ACTIONS(1348),
    [sym_string_literal] = ACTIONS(1350),
    [sym_hex_integer_literal] = ACTIONS(1348),
    [sym_decimal_floating_point_literal] = ACTIONS(1350),
    [anon_sym_public] = ACTIONS(1348),
    [anon_sym_TILDE] = ACTIONS(1350),
    [sym_void_type] = ACTIONS(1348),
    [anon_sym_float] = ACTIONS(1348),
    [sym_boolean_type] = ACTIONS(1348),
    [anon_sym_default] = ACTIONS(1348),
    [sym_octal_integer_literal] = ACTIONS(1350),
    [anon_sym_for] = ACTIONS(1348),
    [anon_sym_new] = ACTIONS(1348),
    [anon_sym_static] = ACTIONS(1348),
    [anon_sym_open] = ACTIONS(1348),
    [anon_sym_protected] = ACTIONS(1348),
    [anon_sym_long] = ACTIONS(1348),
    [sym_super] = ACTIONS(1348),
    [sym_decimal_integer_literal] = ACTIONS(1348),
    [sym_binary_integer_literal] = ACTIONS(1350),
    [anon_sym_RBRACE] = ACTIONS(1350),
    [anon_sym_if] = ACTIONS(1348),
    [anon_sym_byte] = ACTIONS(1348),
    [anon_sym_enum] = ACTIONS(1348),
    [anon_sym_interface] = ACTIONS(1348),
    [anon_sym_case] = ACTIONS(1348),
    [anon_sym_do] = ACTIONS(1348),
    [ts_builtin_sym_end] = ACTIONS(1350),
    [anon_sym_throw] = ACTIONS(1348),
    [sym_true] = ACTIONS(1348),
    [anon_sym_abstract] = ACTIONS(1348),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH] = ACTIONS(1348),
    [anon_sym_package] = ACTIONS(1348),
    [sym_null_literal] = ACTIONS(1348),
    [anon_sym_LPAREN] = ACTIONS(1350),
    [sym_false] = ACTIONS(1348),
    [anon_sym_AT] = ACTIONS(1348),
    [anon_sym_volatile] = ACTIONS(1348),
    [anon_sym_class] = ACTIONS(1348),
    [anon_sym_native] = ACTIONS(1348),
    [anon_sym_short] = ACTIONS(1348),
    [sym_this] = ACTIONS(1348),
    [anon_sym_else] = ACTIONS(1348),
    [anon_sym_PLUS] = ACTIONS(1348),
    [anon_sym_strictfp] = ACTIONS(1348),
    [anon_sym_BANG] = ACTIONS(1350),
    [anon_sym_ATinterface] = ACTIONS(1350),
    [sym_character_literal] = ACTIONS(1350),
    [anon_sym_PLUS_PLUS] = ACTIONS(1350),
    [anon_sym_char] = ACTIONS(1348),
    [anon_sym_transient] = ACTIONS(1348),
    [anon_sym_DASH_DASH] = ACTIONS(1350),
    [anon_sym_int] = ACTIONS(1348),
    [anon_sym_SEMI] = ACTIONS(1350),
    [anon_sym_return] = ACTIONS(1348),
  },
  [416] = {
    [sym_annotated_type] = STATE(37),
    [sym_binary_expression] = STATE(49),
    [sym_throw_statement] = STATE(569),
    [sym_instanceof_expression] = STATE(49),
    [sym__declaration] = STATE(569),
    [sym_ternary_expression] = STATE(49),
    [sym_integral_type] = STATE(30),
    [sym_switch_statement] = STATE(569),
    [sym_do_statement] = STATE(569),
    [sym_marker_annotation] = STATE(51),
    [sym__primary_no_new_array] = STATE(43),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_try_statement] = STATE(569),
    [sym_method_invocation] = STATE(43),
    [sym_switch_label] = STATE(569),
    [sym_assignment_expression] = STATE(49),
    [sym_synchronized_statement] = STATE(569),
    [sym_scoped_identifier] = STATE(52),
    [aux_sym_switch_block_repeat1] = STATE(569),
    [sym_labeled_statement] = STATE(569),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_expression_statement] = STATE(569),
    [sym_enhanced_for_statement] = STATE(569),
    [sym__primary] = STATE(41),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__expression] = STATE(49),
    [sym_local_variable_declaration] = STATE(47),
    [sym_annotation] = STATE(51),
    [sym_floating_point_type] = STATE(30),
    [sym_lambda_expression] = STATE(49),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_module_declaration] = STATE(569),
    [sym__type] = STATE(37),
    [sym_generic_type] = STATE(53),
    [sym_class_declaration] = STATE(569),
    [sym_block] = STATE(569),
    [sym_update_expression] = STATE(49),
    [sym__annotation] = STATE(51),
    [sym_unary_expression] = STATE(49),
    [sym_array_creation_expression] = STATE(41),
    [sym_field_access] = STATE(39),
    [sym_array_access] = STATE(39),
    [sym_package_declaration] = STATE(569),
    [sym_interface_declaration] = STATE(569),
    [sym_return_statement] = STATE(569),
    [sym_array_type] = STATE(40),
    [sym_import_declaration] = STATE(569),
    [sym_continue_statement] = STATE(569),
    [sym_if_statement] = STATE(569),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_local_variable_declaration_statement] = STATE(569),
    [sym_assert_statement] = STATE(569),
    [sym_cast_expression] = STATE(49),
    [sym_enum_declaration] = STATE(569),
    [sym_break_statement] = STATE(569),
    [sym_modifiers] = STATE(48),
    [sym_class_literal] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_for_statement] = STATE(569),
    [sym_object_creation_expression] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_try_with_resources_statement] = STATE(569),
    [sym_while_statement] = STATE(569),
    [sym_formal_parameters] = STATE(42),
    [sym__unannotated_type] = STATE(40),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_RBRACE] = ACTIONS(1352),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_case] = ACTIONS(945),
    [anon_sym_byte] = ACTIONS(33),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_native] = ACTIONS(7),
    [sym_null_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(73),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_synchronized] = ACTIONS(71),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(17),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(947),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_module] = ACTIONS(21),
    [sym_string_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_try] = ACTIONS(31),
    [sym_true] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_transient] = ACTIONS(7),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_SEMI] = ACTIONS(1354),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_super] = ACTIONS(9),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(37),
  },
  [417] = {
    [sym_asterisk] = STATE(570),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(965),
    [anon_sym_STAR] = ACTIONS(963),
  },
  [418] = {
    [anon_sym_try] = ACTIONS(1356),
    [anon_sym_throw] = ACTIONS(1356),
    [anon_sym_assert] = ACTIONS(1356),
    [anon_sym_enum] = ACTIONS(1356),
    [anon_sym_ATinterface] = ACTIONS(1358),
    [anon_sym_float] = ACTIONS(1356),
    [anon_sym_case] = ACTIONS(1356),
    [anon_sym_volatile] = ACTIONS(1356),
    [anon_sym_PLUS_PLUS] = ACTIONS(1358),
    [anon_sym_public] = ACTIONS(1356),
    [anon_sym_do] = ACTIONS(1356),
    [sym_character_literal] = ACTIONS(1358),
    [sym_hex_floating_point_literal] = ACTIONS(1356),
    [sym_octal_integer_literal] = ACTIONS(1358),
    [anon_sym_import] = ACTIONS(1356),
    [anon_sym_for] = ACTIONS(1356),
    [anon_sym_RBRACE] = ACTIONS(1358),
    [anon_sym_synchronized] = ACTIONS(1356),
    [anon_sym_abstract] = ACTIONS(1356),
    [anon_sym_SEMI] = ACTIONS(1358),
    [anon_sym_break] = ACTIONS(1356),
    [anon_sym_open] = ACTIONS(1356),
    [anon_sym_private] = ACTIONS(1356),
    [anon_sym_final] = ACTIONS(1356),
    [anon_sym_AT] = ACTIONS(1356),
    [anon_sym_transient] = ACTIONS(1356),
    [anon_sym_while] = ACTIONS(1356),
    [sym_null_literal] = ACTIONS(1356),
    [anon_sym_else] = ACTIONS(1356),
    [sym_false] = ACTIONS(1356),
    [sym_void_type] = ACTIONS(1356),
    [anon_sym_short] = ACTIONS(1356),
    [anon_sym_int] = ACTIONS(1356),
    [anon_sym_long] = ACTIONS(1356),
    [anon_sym_interface] = ACTIONS(1356),
    [sym_super] = ACTIONS(1356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_new] = ACTIONS(1356),
    [anon_sym_if] = ACTIONS(1356),
    [ts_builtin_sym_end] = ACTIONS(1358),
    [anon_sym_switch] = ACTIONS(1356),
    [anon_sym_LBRACE] = ACTIONS(1358),
    [anon_sym_byte] = ACTIONS(1356),
    [sym_decimal_floating_point_literal] = ACTIONS(1358),
    [sym_binary_integer_literal] = ACTIONS(1358),
    [anon_sym_DASH] = ACTIONS(1356),
    [anon_sym_TILDE] = ACTIONS(1358),
    [anon_sym_static] = ACTIONS(1356),
    [anon_sym_strictfp] = ACTIONS(1356),
    [anon_sym_default] = ACTIONS(1356),
    [anon_sym_native] = ACTIONS(1356),
    [anon_sym_double] = ACTIONS(1356),
    [sym_hex_integer_literal] = ACTIONS(1356),
    [anon_sym_PLUS] = ACTIONS(1356),
    [sym_string_literal] = ACTIONS(1358),
    [anon_sym_char] = ACTIONS(1356),
    [sym_this] = ACTIONS(1356),
    [anon_sym_DASH_DASH] = ACTIONS(1358),
    [anon_sym_protected] = ACTIONS(1356),
    [anon_sym_BANG] = ACTIONS(1358),
    [anon_sym_return] = ACTIONS(1356),
    [anon_sym_package] = ACTIONS(1356),
    [anon_sym_continue] = ACTIONS(1356),
    [sym_boolean_type] = ACTIONS(1356),
    [anon_sym_LPAREN] = ACTIONS(1358),
    [anon_sym_class] = ACTIONS(1356),
    [anon_sym_module] = ACTIONS(1356),
    [sym_true] = ACTIONS(1356),
    [sym_identifier] = ACTIONS(1356),
    [sym_decimal_integer_literal] = ACTIONS(1356),
  },
  [419] = {
    [aux_sym_import_declaration_repeat1] = STATE(423),
    [anon_sym_SEMI] = ACTIONS(1360),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(1362),
  },
  [420] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1364),
  },
  [421] = {
    [anon_sym_SEMI] = ACTIONS(1366),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(1366),
  },
  [422] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1360),
  },
  [423] = {
    [aux_sym_import_declaration_repeat1] = STATE(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(1368),
    [anon_sym_SEMI] = ACTIONS(1366),
  },
  [424] = {
    [sym_marker_annotation] = STATE(428),
    [sym_ternary_expression] = STATE(429),
    [sym__literal] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_assignment_expression] = STATE(429),
    [sym_instanceof_expression] = STATE(429),
    [sym_formal_parameters] = STATE(42),
    [sym_unary_expression] = STATE(429),
    [sym_method_invocation] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_array_type] = STATE(73),
    [sym_binary_expression] = STATE(429),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_element_value_array_initializer] = STATE(576),
    [sym_update_expression] = STATE(429),
    [sym__type] = STATE(37),
    [sym_integral_type] = STATE(30),
    [sym_floating_point_type] = STATE(30),
    [sym_inferred_parameters] = STATE(42),
    [sym_field_access] = STATE(39),
    [sym__element_value] = STATE(576),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_cast_expression] = STATE(429),
    [sym_parenthesized_expression] = STATE(43),
    [sym__expression] = STATE(429),
    [sym_scoped_identifier] = STATE(52),
    [sym_class_literal] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_array_creation_expression] = STATE(41),
    [sym__annotation] = STATE(428),
    [sym_annotated_type] = STATE(37),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_object_creation_expression] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_lambda_expression] = STATE(429),
    [sym_annotation] = STATE(428),
    [sym_generic_type] = STATE(53),
    [anon_sym_char] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [sym_null_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_false] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(971),
    [anon_sym_COMMA] = ACTIONS(1371),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_identifier] = ACTIONS(124),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_super] = ACTIONS(9),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(1373),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_module] = ACTIONS(120),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
  },
  [425] = {
    [sym_type_arguments] = STATE(64),
    [sym_argument_list] = STATE(65),
    [aux_sym_class_literal_repeat1] = STATE(66),
    [anon_sym_AMP] = ACTIONS(85),
    [anon_sym_STAR_EQ] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP_AMP] = ACTIONS(87),
    [anon_sym_DASH_EQ] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_PIPE] = ACTIONS(85),
    [anon_sym_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_LBRACK] = ACTIONS(100),
    [anon_sym_EQ] = ACTIONS(1375),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_AMP_EQ] = ACTIONS(93),
    [anon_sym_instanceof] = ACTIONS(87),
    [anon_sym_CARET_EQ] = ACTIONS(93),
    [anon_sym_DASH_GT] = ACTIONS(103),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH_EQ] = ACTIONS(93),
    [anon_sym_BANG_EQ] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_LT_LT_EQ] = ACTIONS(93),
    [anon_sym_EQ_EQ] = ACTIONS(87),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(107),
    [anon_sym_GT_GT_GT] = ACTIONS(85),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(110),
    [anon_sym_PIPE_EQ] = ACTIONS(93),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_QMARK] = ACTIONS(87),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_PERCENT_EQ] = ACTIONS(93),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_PLUS_EQ] = ACTIONS(93),
  },
  [426] = {
    [anon_sym_public] = ACTIONS(1377),
    [anon_sym_LT] = ACTIONS(1379),
    [anon_sym_static] = ACTIONS(1377),
    [anon_sym_protected] = ACTIONS(1377),
    [sym_void_type] = ACTIONS(1377),
    [anon_sym_float] = ACTIONS(1377),
    [sym_identifier] = ACTIONS(1377),
    [anon_sym_long] = ACTIONS(1377),
    [anon_sym_default] = ACTIONS(1377),
    [anon_sym_byte] = ACTIONS(1377),
    [anon_sym_abstract] = ACTIONS(1377),
    [anon_sym_native] = ACTIONS(1377),
    [anon_sym_double] = ACTIONS(1377),
    [sym_boolean_type] = ACTIONS(1377),
    [anon_sym_int] = ACTIONS(1377),
    [anon_sym_class] = ACTIONS(1377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_interface] = ACTIONS(1377),
    [anon_sym_char] = ACTIONS(1377),
    [anon_sym_module] = ACTIONS(1377),
    [anon_sym_strictfp] = ACTIONS(1377),
    [anon_sym_private] = ACTIONS(1377),
    [anon_sym_synchronized] = ACTIONS(1377),
    [anon_sym_ATinterface] = ACTIONS(1379),
    [anon_sym_transient] = ACTIONS(1377),
    [anon_sym_open] = ACTIONS(1377),
    [anon_sym_short] = ACTIONS(1377),
    [anon_sym_volatile] = ACTIONS(1377),
    [anon_sym_enum] = ACTIONS(1377),
    [anon_sym_AT] = ACTIONS(1377),
    [anon_sym_package] = ACTIONS(1377),
    [anon_sym_final] = ACTIONS(1377),
  },
  [427] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1381),
  },
  [428] = {
    [sym_boolean_type] = ACTIONS(318),
    [anon_sym_long] = ACTIONS(318),
    [anon_sym_double] = ACTIONS(318),
    [anon_sym_RBRACE] = ACTIONS(1383),
    [anon_sym_int] = ACTIONS(318),
    [anon_sym_float] = ACTIONS(318),
    [sym_identifier] = ACTIONS(318),
    [anon_sym_RPAREN] = ACTIONS(1383),
    [anon_sym_short] = ACTIONS(318),
    [anon_sym_char] = ACTIONS(318),
    [sym_void_type] = ACTIONS(318),
    [anon_sym_COMMA] = ACTIONS(1383),
    [anon_sym_SEMI] = ACTIONS(1383),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(1385),
    [anon_sym_byte] = ACTIONS(318),
  },
  [429] = {
    [anon_sym_RPAREN] = ACTIONS(1383),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_RBRACE] = ACTIONS(1383),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_COMMA] = ACTIONS(1383),
    [anon_sym_PIPE] = ACTIONS(291),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(1383),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_BANG_EQ] = ACTIONS(293),
  },
  [430] = {
    [aux_sym_annotation_argument_list_repeat1] = STATE(580),
    [anon_sym_RPAREN] = ACTIONS(1381),
    [anon_sym_COMMA] = ACTIONS(1387),
    [sym_comment] = ACTIONS(3),
  },
  [431] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_method_invocation] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_field_access] = STATE(39),
    [sym_marker_annotation] = STATE(74),
    [sym__expression] = STATE(581),
    [sym_update_expression] = STATE(581),
    [sym_array_access] = STATE(39),
    [sym_annotated_type] = STATE(37),
    [sym__annotation] = STATE(74),
    [sym_method_reference] = STATE(43),
    [sym_binary_expression] = STATE(581),
    [sym__primary] = STATE(41),
    [sym_assignment_expression] = STATE(581),
    [sym_inferred_parameters] = STATE(42),
    [sym_unary_expression] = STATE(581),
    [sym_formal_parameters] = STATE(42),
    [sym_array_creation_expression] = STATE(41),
    [sym__type] = STATE(37),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_floating_point_type] = STATE(30),
    [sym_annotation] = STATE(74),
    [sym_ternary_expression] = STATE(581),
    [sym__literal] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_integral_type] = STATE(30),
    [sym_cast_expression] = STATE(581),
    [sym_class_literal] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_instanceof_expression] = STATE(581),
    [sym_generic_type] = STATE(53),
    [sym_lambda_expression] = STATE(581),
    [sym_parenthesized_expression] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym_super] = ACTIONS(9),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_new] = ACTIONS(19),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_identifier] = ACTIONS(124),
    [sym_this] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_byte] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_char] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_AT] = ACTIONS(118),
    [sym_false] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
  },
  [432] = {
    [anon_sym_return] = ACTIONS(1389),
    [sym_identifier] = ACTIONS(1389),
    [sym_decimal_integer_literal] = ACTIONS(1389),
    [sym_octal_integer_literal] = ACTIONS(1391),
    [anon_sym_transient] = ACTIONS(1389),
    [anon_sym_do] = ACTIONS(1389),
    [anon_sym_import] = ACTIONS(1389),
    [sym_hex_floating_point_literal] = ACTIONS(1389),
    [anon_sym_synchronized] = ACTIONS(1389),
    [anon_sym_if] = ACTIONS(1389),
    [anon_sym_TILDE] = ACTIONS(1391),
    [anon_sym_class] = ACTIONS(1389),
    [anon_sym_protected] = ACTIONS(1389),
    [anon_sym_LBRACE] = ACTIONS(1391),
    [sym_void_type] = ACTIONS(1389),
    [anon_sym_module] = ACTIONS(1389),
    [anon_sym_float] = ACTIONS(1389),
    [anon_sym_case] = ACTIONS(1389),
    [anon_sym_private] = ACTIONS(1389),
    [sym_this] = ACTIONS(1389),
    [anon_sym_abstract] = ACTIONS(1389),
    [sym_string_literal] = ACTIONS(1391),
    [sym_null_literal] = ACTIONS(1389),
    [anon_sym_while] = ACTIONS(1389),
    [anon_sym_static] = ACTIONS(1389),
    [anon_sym_public] = ACTIONS(1389),
    [sym_boolean_type] = ACTIONS(1389),
    [sym_true] = ACTIONS(1389),
    [anon_sym_BANG] = ACTIONS(1391),
    [anon_sym_assert] = ACTIONS(1389),
    [anon_sym_strictfp] = ACTIONS(1389),
    [ts_builtin_sym_end] = ACTIONS(1391),
    [anon_sym_default] = ACTIONS(1389),
    [sym_binary_integer_literal] = ACTIONS(1391),
    [sym_hex_integer_literal] = ACTIONS(1389),
    [anon_sym_LPAREN] = ACTIONS(1391),
    [anon_sym_SEMI] = ACTIONS(1391),
    [sym_decimal_floating_point_literal] = ACTIONS(1391),
    [anon_sym_byte] = ACTIONS(1389),
    [anon_sym_new] = ACTIONS(1389),
    [anon_sym_AT] = ACTIONS(1389),
    [sym_super] = ACTIONS(1389),
    [anon_sym_ATinterface] = ACTIONS(1391),
    [anon_sym_PLUS] = ACTIONS(1389),
    [anon_sym_enum] = ACTIONS(1389),
    [sym_comment] = ACTIONS(3),
    [anon_sym_interface] = ACTIONS(1389),
    [anon_sym_char] = ACTIONS(1389),
    [anon_sym_switch] = ACTIONS(1389),
    [anon_sym_native] = ACTIONS(1389),
    [anon_sym_DASH] = ACTIONS(1389),
    [sym_character_literal] = ACTIONS(1391),
    [anon_sym_PLUS_PLUS] = ACTIONS(1391),
    [anon_sym_DASH_DASH] = ACTIONS(1391),
    [anon_sym_for] = ACTIONS(1389),
    [anon_sym_final] = ACTIONS(1389),
    [anon_sym_short] = ACTIONS(1389),
    [anon_sym_RBRACE] = ACTIONS(1391),
    [sym_false] = ACTIONS(1389),
    [anon_sym_throw] = ACTIONS(1389),
    [anon_sym_open] = ACTIONS(1389),
    [anon_sym_volatile] = ACTIONS(1389),
    [anon_sym_long] = ACTIONS(1389),
    [anon_sym_break] = ACTIONS(1389),
    [anon_sym_package] = ACTIONS(1389),
    [anon_sym_try] = ACTIONS(1389),
    [anon_sym_else] = ACTIONS(1389),
    [anon_sym_LT] = ACTIONS(1391),
    [anon_sym_double] = ACTIONS(1389),
    [anon_sym_int] = ACTIONS(1389),
    [anon_sym_continue] = ACTIONS(1389),
  },
  [433] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym__variable_declarator_id] = STATE(142),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__variable_declarator_list] = STATE(554),
    [sym__annotation] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym_variable_declarator] = STATE(143),
    [sym_marker_annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(1393),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(243),
  },
  [434] = {
    [anon_sym_final] = ACTIONS(1395),
    [anon_sym_interface] = ACTIONS(1395),
    [anon_sym_int] = ACTIONS(1395),
    [sym_identifier] = ACTIONS(1395),
    [anon_sym_protected] = ACTIONS(1395),
    [anon_sym_byte] = ACTIONS(1395),
    [anon_sym_double] = ACTIONS(1395),
    [anon_sym_private] = ACTIONS(1395),
    [anon_sym_short] = ACTIONS(1395),
    [anon_sym_char] = ACTIONS(1395),
    [anon_sym_default] = ACTIONS(1395),
    [sym_boolean_type] = ACTIONS(1395),
    [anon_sym_ATinterface] = ACTIONS(1397),
    [anon_sym_long] = ACTIONS(1395),
    [anon_sym_volatile] = ACTIONS(1395),
    [anon_sym_public] = ACTIONS(1395),
    [anon_sym_static] = ACTIONS(1395),
    [anon_sym_transient] = ACTIONS(1395),
    [anon_sym_float] = ACTIONS(1395),
    [anon_sym_AT] = ACTIONS(1395),
    [anon_sym_class] = ACTIONS(1395),
    [anon_sym_synchronized] = ACTIONS(1395),
    [anon_sym_RBRACE] = ACTIONS(1397),
    [anon_sym_abstract] = ACTIONS(1395),
    [anon_sym_strictfp] = ACTIONS(1395),
    [anon_sym_native] = ACTIONS(1395),
    [sym_void_type] = ACTIONS(1395),
    [sym_comment] = ACTIONS(3),
  },
  [435] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(583),
    [sym__unannotated_type] = STATE(583),
    [sym_array_type] = STATE(583),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(583),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(41),
    [sym_void_type] = ACTIONS(1399),
    [anon_sym_ATinterface] = ACTIONS(281),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_interface] = ACTIONS(283),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(1399),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_class] = ACTIONS(279),
  },
  [436] = {
    [sym__unannotated_type] = STATE(433),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_generic_type] = STATE(53),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_annotation] = STATE(44),
    [sym_constant_declaration] = STATE(434),
    [sym__annotation] = STATE(44),
    [sym_floating_point_type] = STATE(433),
    [sym_integral_type] = STATE(433),
    [sym_marker_annotation] = STATE(44),
    [sym_annotation_type_element_declaration] = STATE(434),
    [sym_modifiers] = STATE(435),
    [sym_annotation_type_member_declaration] = STATE(585),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_class_declaration] = STATE(434),
    [sym_interface_declaration] = STATE(434),
    [sym_array_type] = STATE(433),
    [aux_sym_annotation_type_body_repeat1] = STATE(585),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_transient] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_synchronized] = ACTIONS(7),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_long] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(987),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_class] = ACTIONS(29),
    [sym_void_type] = ACTIONS(987),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(1401),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
  },
  [437] = {
    [sym__primary_no_new_array] = STATE(43),
    [sym_object_creation_expression] = STATE(43),
    [sym__type] = STATE(37),
    [sym_binary_expression] = STATE(587),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_assignment_expression] = STATE(587),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__primary] = STATE(41),
    [sym_formal_parameters] = STATE(42),
    [sym_cast_expression] = STATE(587),
    [sym_floating_point_type] = STATE(30),
    [sym__literal] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_array_access] = STATE(39),
    [sym_field_access] = STATE(39),
    [sym_array_type] = STATE(73),
    [sym_annotation] = STATE(74),
    [sym_update_expression] = STATE(587),
    [sym_array_creation_expression] = STATE(41),
    [sym_instanceof_expression] = STATE(587),
    [sym_marker_annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym_lambda_expression] = STATE(587),
    [sym__unannotated_type] = STATE(73),
    [sym_parenthesized_expression] = STATE(43),
    [sym_ternary_expression] = STATE(587),
    [sym_generic_type] = STATE(53),
    [sym_class_literal] = STATE(43),
    [sym_unary_expression] = STATE(587),
    [sym_method_reference] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__annotation] = STATE(74),
    [sym__expression] = STATE(587),
    [sym_integral_type] = STATE(30),
    [sym_this] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_double] = ACTIONS(41),
    [sym_null_literal] = ACTIONS(5),
    [sym_identifier] = ACTIONS(124),
    [sym_boolean_type] = ACTIONS(79),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_super] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(1403),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_short] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_byte] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [sym_character_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(118),
    [sym_true] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
  },
  [438] = {
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(1405),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(297),
  },
  [439] = {
    [sym_unary_expression] = STATE(589),
    [sym_floating_point_type] = STATE(30),
    [sym_method_reference] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym_annotation] = STATE(74),
    [sym_array_creation_expression] = STATE(41),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_binary_expression] = STATE(589),
    [sym_lambda_expression] = STATE(589),
    [sym_integral_type] = STATE(30),
    [sym__expression] = STATE(589),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_assignment_expression] = STATE(589),
    [sym__literal] = STATE(43),
    [sym__type] = STATE(37),
    [sym_parenthesized_expression] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym_array_access] = STATE(39),
    [sym_method_invocation] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_cast_expression] = STATE(589),
    [sym__unannotated_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym_formal_parameters] = STATE(42),
    [sym_instanceof_expression] = STATE(589),
    [sym_update_expression] = STATE(589),
    [sym_object_creation_expression] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_annotated_type] = STATE(37),
    [sym_ternary_expression] = STATE(589),
    [sym__primary] = STATE(41),
    [sym_generic_type] = STATE(53),
    [sym_class_literal] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__primary_no_new_array] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_super] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(120),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_int] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_identifier] = ACTIONS(124),
    [sym_comment] = ACTIONS(3),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(1405),
    [sym_this] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_true] = ACTIONS(5),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_false] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(41),
  },
  [440] = {
    [sym__annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(590),
    [sym_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_dimensions] = STATE(144),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_variable_declarator] = STATE(143),
    [sym__variable_declarator_list] = STATE(317),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_open] = ACTIONS(243),
    [anon_sym_LBRACK] = ACTIONS(241),
    [sym_identifier] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
  },
  [441] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(681),
    [anon_sym_SEMI] = ACTIONS(681),
    [anon_sym_COLON] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(679),
  },
  [442] = {
    [aux_sym_argument_list_repeat1] = STATE(504),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(771),
    [anon_sym_SEMI] = ACTIONS(1409),
  },
  [443] = {
    [sym_enum_body_declarations] = STATE(593),
    [anon_sym_SEMI] = ACTIONS(1013),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1411),
  },
  [444] = {
    [sym_argument_list] = STATE(595),
    [sym_class_body] = STATE(594),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_RBRACE] = ACTIONS(1413),
    [anon_sym_SEMI] = ACTIONS(1413),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(1413),
  },
  [445] = {
    [sym_constructor_declarator] = STATE(377),
    [sym_generic_type] = STATE(53),
    [sym_marker_annotation] = STATE(44),
    [sym_field_declaration] = STATE(596),
    [sym_interface_declaration] = STATE(596),
    [sym_floating_point_type] = STATE(381),
    [sym_static_initializer] = STATE(596),
    [sym_array_type] = STATE(381),
    [sym_block] = STATE(596),
    [sym_method_declaration] = STATE(596),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_modifiers] = STATE(380),
    [sym_class_declaration] = STATE(596),
    [sym_integral_type] = STATE(381),
    [sym_type_parameters] = STATE(382),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_constructor_declaration] = STATE(596),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_enum_declaration] = STATE(596),
    [sym__annotation] = STATE(44),
    [sym_annotation] = STATE(44),
    [aux_sym_enum_body_declarations_repeat1] = STATE(596),
    [sym__unannotated_type] = STATE(381),
    [sym__method_header] = STATE(378),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_void_type] = ACTIONS(895),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(1415),
    [sym_boolean_type] = ACTIONS(895),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_static] = ACTIONS(897),
    [anon_sym_class] = ACTIONS(29),
    [sym_comment] = ACTIONS(3),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_synchronized] = ACTIONS(7),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(437),
    [sym_identifier] = ACTIONS(901),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(1417),
    [anon_sym_interface] = ACTIONS(39),
  },
  [446] = {
    [anon_sym_if] = ACTIONS(1419),
    [sym_this] = ACTIONS(1419),
    [anon_sym_class] = ACTIONS(1419),
    [anon_sym_long] = ACTIONS(1419),
    [anon_sym_case] = ACTIONS(1419),
    [anon_sym_AT] = ACTIONS(1419),
    [anon_sym_char] = ACTIONS(1419),
    [anon_sym_BANG] = ACTIONS(1421),
    [anon_sym_enum] = ACTIONS(1419),
    [anon_sym_for] = ACTIONS(1419),
    [anon_sym_PLUS_PLUS] = ACTIONS(1421),
    [anon_sym_module] = ACTIONS(1419),
    [anon_sym_throw] = ACTIONS(1419),
    [sym_decimal_integer_literal] = ACTIONS(1419),
    [anon_sym_continue] = ACTIONS(1419),
    [anon_sym_while] = ACTIONS(1419),
    [sym_true] = ACTIONS(1419),
    [anon_sym_SEMI] = ACTIONS(1421),
    [anon_sym_PLUS] = ACTIONS(1419),
    [anon_sym_default] = ACTIONS(1419),
    [sym_null_literal] = ACTIONS(1419),
    [anon_sym_short] = ACTIONS(1419),
    [sym_octal_integer_literal] = ACTIONS(1421),
    [anon_sym_double] = ACTIONS(1419),
    [anon_sym_switch] = ACTIONS(1419),
    [ts_builtin_sym_end] = ACTIONS(1421),
    [anon_sym_transient] = ACTIONS(1419),
    [anon_sym_protected] = ACTIONS(1419),
    [anon_sym_strictfp] = ACTIONS(1419),
    [anon_sym_DASH] = ACTIONS(1419),
    [sym_hex_floating_point_literal] = ACTIONS(1419),
    [anon_sym_DASH_DASH] = ACTIONS(1421),
    [sym_decimal_floating_point_literal] = ACTIONS(1421),
    [sym_identifier] = ACTIONS(1419),
    [anon_sym_open] = ACTIONS(1419),
    [sym_hex_integer_literal] = ACTIONS(1419),
    [anon_sym_synchronized] = ACTIONS(1419),
    [anon_sym_static] = ACTIONS(1419),
    [sym_void_type] = ACTIONS(1419),
    [anon_sym_public] = ACTIONS(1419),
    [anon_sym_try] = ACTIONS(1419),
    [anon_sym_native] = ACTIONS(1419),
    [anon_sym_TILDE] = ACTIONS(1421),
    [anon_sym_else] = ACTIONS(1419),
    [anon_sym_new] = ACTIONS(1419),
    [anon_sym_float] = ACTIONS(1419),
    [anon_sym_return] = ACTIONS(1419),
    [anon_sym_RBRACE] = ACTIONS(1421),
    [anon_sym_break] = ACTIONS(1419),
    [sym_binary_integer_literal] = ACTIONS(1421),
    [anon_sym_LPAREN] = ACTIONS(1421),
    [anon_sym_interface] = ACTIONS(1419),
    [anon_sym_assert] = ACTIONS(1419),
    [anon_sym_package] = ACTIONS(1419),
    [sym_super] = ACTIONS(1419),
    [anon_sym_LBRACE] = ACTIONS(1421),
    [sym_false] = ACTIONS(1419),
    [anon_sym_abstract] = ACTIONS(1419),
    [anon_sym_import] = ACTIONS(1419),
    [anon_sym_final] = ACTIONS(1419),
    [anon_sym_ATinterface] = ACTIONS(1421),
    [sym_boolean_type] = ACTIONS(1419),
    [anon_sym_byte] = ACTIONS(1419),
    [anon_sym_int] = ACTIONS(1419),
    [anon_sym_LT] = ACTIONS(1421),
    [sym_comment] = ACTIONS(3),
    [anon_sym_volatile] = ACTIONS(1419),
    [sym_character_literal] = ACTIONS(1421),
    [sym_string_literal] = ACTIONS(1421),
    [anon_sym_do] = ACTIONS(1419),
    [anon_sym_private] = ACTIONS(1419),
  },
  [447] = {
    [sym_enum_body_declarations] = STATE(593),
    [aux_sym_enum_declaration_repeat1] = STATE(598),
    [anon_sym_COMMA] = ACTIONS(1423),
    [anon_sym_RBRACE] = ACTIONS(1411),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1013),
  },
  [448] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1411),
  },
  [449] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(1425),
  },
  [450] = {
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_modifiers] = STATE(449),
    [sym__annotation] = STATE(902),
    [sym_enum_body_declarations] = STATE(593),
    [sym_enum_constant] = STATE(601),
    [sym_marker_annotation] = STATE(902),
    [sym_annotation] = STATE(902),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_private] = ACTIONS(126),
    [sym_identifier] = ACTIONS(1009),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(1427),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_strictfp] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_RBRACE] = ACTIONS(1411),
  },
  [451] = {
    [sym_block] = STATE(602),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(75),
  },
  [452] = {
    [anon_sym_EQ] = ACTIONS(1429),
    [sym_comment] = ACTIONS(3),
  },
  [453] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_dimensions] = STATE(144),
    [sym_marker_annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(604),
    [sym__annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [anon_sym_LBRACK] = ACTIONS(241),
    [sym_identifier] = ACTIONS(247),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(243),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_module] = ACTIONS(243),
  },
  [454] = {
    [sym_scoped_identifier] = STATE(276),
    [sym__unannotated_type] = STATE(274),
    [sym_annotated_type] = STATE(37),
    [sym_annotation] = STATE(903),
    [sym_array_creation_expression] = STATE(275),
    [sym_integral_type] = STATE(30),
    [sym_modifiers] = STATE(277),
    [sym_array_type] = STATE(274),
    [sym_method_reference] = STATE(43),
    [sym_resource] = STATE(606),
    [sym__literal] = STATE(43),
    [sym__annotation] = STATE(903),
    [sym__type] = STATE(37),
    [sym_object_creation_expression] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_marker_annotation] = STATE(903),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_generic_type] = STATE(53),
    [sym_class_literal] = STATE(43),
    [sym_field_access] = STATE(279),
    [sym__primary_no_new_array] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_method_invocation] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym__primary] = STATE(275),
    [sym_floating_point_type] = STATE(30),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_array_access] = STATE(43),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(1431),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(501),
    [sym_false] = ACTIONS(5),
    [sym_identifier] = ACTIONS(503),
    [sym_string_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(126),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_static] = ACTIONS(126),
    [sym_true] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(501),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_strictfp] = ACTIONS(126),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [anon_sym_final] = ACTIONS(126),
    [sym_character_literal] = ACTIONS(35),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(79),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(134),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
  },
  [455] = {
    [anon_sym_LBRACE] = ACTIONS(1433),
    [sym_comment] = ACTIONS(3),
  },
  [456] = {
    [aux_sym_resource_specification_repeat1] = STATE(608),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1435),
    [anon_sym_RPAREN] = ACTIONS(1431),
  },
  [457] = {
    [anon_sym_switch] = ACTIONS(1437),
    [anon_sym_module] = ACTIONS(1437),
    [sym_void_type] = ACTIONS(1437),
    [anon_sym_volatile] = ACTIONS(1437),
    [sym_true] = ACTIONS(1437),
    [sym_octal_integer_literal] = ACTIONS(1439),
    [anon_sym_BANG] = ACTIONS(1439),
    [anon_sym_interface] = ACTIONS(1437),
    [anon_sym_DASH_DASH] = ACTIONS(1439),
    [anon_sym_abstract] = ACTIONS(1437),
    [anon_sym_protected] = ACTIONS(1437),
    [anon_sym_byte] = ACTIONS(1437),
    [anon_sym_RBRACE] = ACTIONS(1439),
    [anon_sym_try] = ACTIONS(1437),
    [sym_false] = ACTIONS(1437),
    [anon_sym_short] = ACTIONS(1437),
    [sym_decimal_integer_literal] = ACTIONS(1437),
    [anon_sym_LBRACE] = ACTIONS(1439),
    [anon_sym_LPAREN] = ACTIONS(1439),
    [anon_sym_for] = ACTIONS(1437),
    [anon_sym_continue] = ACTIONS(1437),
    [anon_sym_private] = ACTIONS(1437),
    [sym_comment] = ACTIONS(3),
    [sym_string_literal] = ACTIONS(1439),
    [anon_sym_new] = ACTIONS(1437),
    [anon_sym_transient] = ACTIONS(1437),
    [sym_hex_floating_point_literal] = ACTIONS(1437),
    [anon_sym_if] = ACTIONS(1437),
    [anon_sym_return] = ACTIONS(1437),
    [sym_null_literal] = ACTIONS(1437),
    [anon_sym_TILDE] = ACTIONS(1439),
    [anon_sym_class] = ACTIONS(1437),
    [anon_sym_SEMI] = ACTIONS(1439),
    [anon_sym_synchronized] = ACTIONS(1437),
    [anon_sym_AT] = ACTIONS(1437),
    [anon_sym_enum] = ACTIONS(1437),
    [anon_sym_open] = ACTIONS(1437),
    [anon_sym_ATinterface] = ACTIONS(1439),
    [anon_sym_DASH] = ACTIONS(1437),
    [anon_sym_int] = ACTIONS(1437),
    [anon_sym_while] = ACTIONS(1437),
    [anon_sym_double] = ACTIONS(1437),
    [anon_sym_public] = ACTIONS(1437),
    [sym_binary_integer_literal] = ACTIONS(1439),
    [anon_sym_package] = ACTIONS(1437),
    [anon_sym_native] = ACTIONS(1437),
    [sym_super] = ACTIONS(1437),
    [anon_sym_break] = ACTIONS(1437),
    [anon_sym_float] = ACTIONS(1437),
    [anon_sym_else] = ACTIONS(1437),
    [anon_sym_char] = ACTIONS(1437),
    [anon_sym_assert] = ACTIONS(1437),
    [anon_sym_import] = ACTIONS(1437),
    [anon_sym_default] = ACTIONS(1437),
    [ts_builtin_sym_end] = ACTIONS(1439),
    [anon_sym_PLUS] = ACTIONS(1437),
    [anon_sym_throw] = ACTIONS(1437),
    [sym_hex_integer_literal] = ACTIONS(1437),
    [anon_sym_long] = ACTIONS(1437),
    [sym_this] = ACTIONS(1437),
    [anon_sym_case] = ACTIONS(1437),
    [anon_sym_strictfp] = ACTIONS(1437),
    [anon_sym_PLUS_PLUS] = ACTIONS(1439),
    [sym_boolean_type] = ACTIONS(1437),
    [anon_sym_final] = ACTIONS(1437),
    [anon_sym_static] = ACTIONS(1437),
    [sym_identifier] = ACTIONS(1437),
    [sym_decimal_floating_point_literal] = ACTIONS(1439),
    [anon_sym_do] = ACTIONS(1437),
    [sym_character_literal] = ACTIONS(1439),
  },
  [458] = {
    [sym_catch_clause] = STATE(462),
    [sym_finally_clause] = STATE(609),
    [aux_sym_try_statement_repeat1] = STATE(462),
    [anon_sym_default] = ACTIONS(1437),
    [sym_false] = ACTIONS(1437),
    [sym_this] = ACTIONS(1437),
    [anon_sym_int] = ACTIONS(1437),
    [sym_comment] = ACTIONS(3),
    [sym_hex_floating_point_literal] = ACTIONS(1437),
    [sym_decimal_integer_literal] = ACTIONS(1437),
    [sym_decimal_floating_point_literal] = ACTIONS(1439),
    [sym_true] = ACTIONS(1437),
    [sym_null_literal] = ACTIONS(1437),
    [anon_sym_volatile] = ACTIONS(1437),
    [anon_sym_try] = ACTIONS(1437),
    [anon_sym_TILDE] = ACTIONS(1439),
    [anon_sym_case] = ACTIONS(1437),
    [anon_sym_switch] = ACTIONS(1437),
    [sym_hex_integer_literal] = ACTIONS(1437),
    [anon_sym_assert] = ACTIONS(1437),
    [anon_sym_native] = ACTIONS(1437),
    [anon_sym_double] = ACTIONS(1437),
    [anon_sym_while] = ACTIONS(1437),
    [anon_sym_catch] = ACTIONS(1035),
    [anon_sym_byte] = ACTIONS(1437),
    [anon_sym_short] = ACTIONS(1437),
    [ts_builtin_sym_end] = ACTIONS(1439),
    [anon_sym_for] = ACTIONS(1437),
    [anon_sym_RBRACE] = ACTIONS(1439),
    [anon_sym_package] = ACTIONS(1437),
    [anon_sym_enum] = ACTIONS(1437),
    [anon_sym_static] = ACTIONS(1437),
    [anon_sym_import] = ACTIONS(1437),
    [anon_sym_final] = ACTIONS(1437),
    [sym_octal_integer_literal] = ACTIONS(1439),
    [anon_sym_PLUS] = ACTIONS(1437),
    [anon_sym_SEMI] = ACTIONS(1439),
    [sym_binary_integer_literal] = ACTIONS(1439),
    [anon_sym_open] = ACTIONS(1437),
    [sym_super] = ACTIONS(1437),
    [anon_sym_new] = ACTIONS(1437),
    [anon_sym_LPAREN] = ACTIONS(1439),
    [anon_sym_ATinterface] = ACTIONS(1439),
    [anon_sym_long] = ACTIONS(1437),
    [sym_boolean_type] = ACTIONS(1437),
    [anon_sym_class] = ACTIONS(1437),
    [anon_sym_module] = ACTIONS(1437),
    [anon_sym_public] = ACTIONS(1437),
    [sym_void_type] = ACTIONS(1437),
    [anon_sym_do] = ACTIONS(1437),
    [anon_sym_char] = ACTIONS(1437),
    [sym_string_literal] = ACTIONS(1439),
    [anon_sym_transient] = ACTIONS(1437),
    [anon_sym_if] = ACTIONS(1437),
    [anon_sym_interface] = ACTIONS(1437),
    [anon_sym_BANG] = ACTIONS(1439),
    [anon_sym_throw] = ACTIONS(1437),
    [anon_sym_synchronized] = ACTIONS(1437),
    [anon_sym_float] = ACTIONS(1437),
    [sym_identifier] = ACTIONS(1437),
    [anon_sym_finally] = ACTIONS(1037),
    [anon_sym_LBRACE] = ACTIONS(1439),
    [anon_sym_strictfp] = ACTIONS(1437),
    [sym_character_literal] = ACTIONS(1439),
    [anon_sym_break] = ACTIONS(1437),
    [anon_sym_continue] = ACTIONS(1437),
    [anon_sym_DASH_DASH] = ACTIONS(1439),
    [anon_sym_private] = ACTIONS(1437),
    [anon_sym_else] = ACTIONS(1437),
    [anon_sym_AT] = ACTIONS(1437),
    [anon_sym_protected] = ACTIONS(1437),
    [anon_sym_DASH] = ACTIONS(1437),
    [anon_sym_PLUS_PLUS] = ACTIONS(1439),
    [anon_sym_abstract] = ACTIONS(1437),
    [anon_sym_return] = ACTIONS(1437),
  },
  [459] = {
    [sym__unannotated_type] = STATE(610),
    [sym_generic_type] = STATE(53),
    [sym_marker_annotation] = STATE(902),
    [sym_array_type] = STATE(610),
    [sym__annotation] = STATE(902),
    [sym_floating_point_type] = STATE(610),
    [sym_modifiers] = STATE(612),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(610),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_catch_type] = STATE(613),
    [sym_annotation] = STATE(902),
    [sym_catch_formal_parameter] = STATE(611),
    [anon_sym_private] = ACTIONS(126),
    [sym_boolean_type] = ACTIONS(1441),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [sym_void_type] = ACTIONS(1441),
  },
  [460] = {
    [anon_sym_ATinterface] = ACTIONS(1443),
    [anon_sym_native] = ACTIONS(1445),
    [anon_sym_PLUS_PLUS] = ACTIONS(1443),
    [anon_sym_PLUS] = ACTIONS(1445),
    [sym_octal_integer_literal] = ACTIONS(1443),
    [anon_sym_DASH] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1443),
    [anon_sym_synchronized] = ACTIONS(1445),
    [anon_sym_package] = ACTIONS(1445),
    [anon_sym_protected] = ACTIONS(1445),
    [anon_sym_volatile] = ACTIONS(1445),
    [sym_identifier] = ACTIONS(1445),
    [anon_sym_module] = ACTIONS(1445),
    [anon_sym_if] = ACTIONS(1445),
    [anon_sym_private] = ACTIONS(1445),
    [anon_sym_byte] = ACTIONS(1445),
    [anon_sym_TILDE] = ACTIONS(1443),
    [sym_hex_integer_literal] = ACTIONS(1445),
    [anon_sym_throw] = ACTIONS(1445),
    [ts_builtin_sym_end] = ACTIONS(1443),
    [anon_sym_short] = ACTIONS(1445),
    [sym_super] = ACTIONS(1445),
    [anon_sym_float] = ACTIONS(1445),
    [anon_sym_char] = ACTIONS(1445),
    [anon_sym_while] = ACTIONS(1445),
    [anon_sym_static] = ACTIONS(1445),
    [anon_sym_class] = ACTIONS(1445),
    [anon_sym_do] = ACTIONS(1445),
    [anon_sym_break] = ACTIONS(1445),
    [anon_sym_enum] = ACTIONS(1445),
    [anon_sym_return] = ACTIONS(1445),
    [anon_sym_try] = ACTIONS(1445),
    [anon_sym_transient] = ACTIONS(1445),
    [sym_boolean_type] = ACTIONS(1445),
    [sym_comment] = ACTIONS(3),
    [anon_sym_switch] = ACTIONS(1445),
    [anon_sym_open] = ACTIONS(1445),
    [anon_sym_int] = ACTIONS(1445),
    [sym_null_literal] = ACTIONS(1445),
    [anon_sym_import] = ACTIONS(1445),
    [sym_binary_integer_literal] = ACTIONS(1443),
    [anon_sym_SEMI] = ACTIONS(1443),
    [anon_sym_final] = ACTIONS(1445),
    [anon_sym_BANG] = ACTIONS(1443),
    [sym_decimal_floating_point_literal] = ACTIONS(1443),
    [sym_hex_floating_point_literal] = ACTIONS(1445),
    [sym_character_literal] = ACTIONS(1443),
    [sym_decimal_integer_literal] = ACTIONS(1445),
    [sym_this] = ACTIONS(1445),
    [sym_string_literal] = ACTIONS(1443),
    [sym_true] = ACTIONS(1445),
    [anon_sym_DASH_DASH] = ACTIONS(1443),
    [sym_void_type] = ACTIONS(1445),
    [anon_sym_public] = ACTIONS(1445),
    [anon_sym_AT] = ACTIONS(1445),
    [anon_sym_abstract] = ACTIONS(1445),
    [anon_sym_interface] = ACTIONS(1445),
    [anon_sym_else] = ACTIONS(1445),
    [anon_sym_long] = ACTIONS(1445),
    [anon_sym_RBRACE] = ACTIONS(1443),
    [sym_false] = ACTIONS(1445),
    [anon_sym_new] = ACTIONS(1445),
    [anon_sym_continue] = ACTIONS(1445),
    [anon_sym_case] = ACTIONS(1445),
    [anon_sym_for] = ACTIONS(1445),
    [anon_sym_LPAREN] = ACTIONS(1443),
    [anon_sym_default] = ACTIONS(1445),
    [anon_sym_assert] = ACTIONS(1445),
    [anon_sym_double] = ACTIONS(1445),
    [anon_sym_strictfp] = ACTIONS(1445),
  },
  [461] = {
    [anon_sym_class] = ACTIONS(1447),
    [anon_sym_break] = ACTIONS(1447),
    [anon_sym_enum] = ACTIONS(1447),
    [anon_sym_transient] = ACTIONS(1447),
    [anon_sym_TILDE] = ACTIONS(1449),
    [anon_sym_public] = ACTIONS(1447),
    [anon_sym_SEMI] = ACTIONS(1449),
    [anon_sym_short] = ACTIONS(1447),
    [anon_sym_return] = ACTIONS(1447),
    [anon_sym_AT] = ACTIONS(1447),
    [anon_sym_final] = ACTIONS(1447),
    [sym_void_type] = ACTIONS(1447),
    [sym_this] = ACTIONS(1447),
    [sym_super] = ACTIONS(1447),
    [sym_identifier] = ACTIONS(1447),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_DASH] = ACTIONS(1449),
    [sym_string_literal] = ACTIONS(1449),
    [anon_sym_switch] = ACTIONS(1447),
    [anon_sym_protected] = ACTIONS(1447),
    [anon_sym_abstract] = ACTIONS(1447),
    [anon_sym_strictfp] = ACTIONS(1447),
    [anon_sym_native] = ACTIONS(1447),
    [anon_sym_import] = ACTIONS(1447),
    [anon_sym_long] = ACTIONS(1447),
    [anon_sym_package] = ACTIONS(1447),
    [anon_sym_module] = ACTIONS(1447),
    [anon_sym_LPAREN] = ACTIONS(1449),
    [anon_sym_BANG] = ACTIONS(1449),
    [sym_binary_integer_literal] = ACTIONS(1449),
    [anon_sym_PLUS] = ACTIONS(1447),
    [anon_sym_open] = ACTIONS(1447),
    [anon_sym_double] = ACTIONS(1447),
    [anon_sym_while] = ACTIONS(1447),
    [sym_null_literal] = ACTIONS(1447),
    [anon_sym_PLUS_PLUS] = ACTIONS(1449),
    [anon_sym_DASH] = ACTIONS(1447),
    [anon_sym_synchronized] = ACTIONS(1447),
    [sym_hex_floating_point_literal] = ACTIONS(1447),
    [anon_sym_default] = ACTIONS(1447),
    [anon_sym_LBRACE] = ACTIONS(1449),
    [anon_sym_for] = ACTIONS(1447),
    [anon_sym_case] = ACTIONS(1447),
    [anon_sym_private] = ACTIONS(1447),
    [anon_sym_volatile] = ACTIONS(1447),
    [anon_sym_int] = ACTIONS(1447),
    [anon_sym_try] = ACTIONS(1447),
    [anon_sym_byte] = ACTIONS(1447),
    [anon_sym_float] = ACTIONS(1447),
    [sym_true] = ACTIONS(1447),
    [anon_sym_RBRACE] = ACTIONS(1449),
    [anon_sym_do] = ACTIONS(1447),
    [anon_sym_else] = ACTIONS(1447),
    [anon_sym_interface] = ACTIONS(1447),
    [anon_sym_char] = ACTIONS(1447),
    [anon_sym_continue] = ACTIONS(1447),
    [anon_sym_ATinterface] = ACTIONS(1449),
    [sym_false] = ACTIONS(1447),
    [anon_sym_new] = ACTIONS(1447),
    [anon_sym_assert] = ACTIONS(1447),
    [sym_hex_integer_literal] = ACTIONS(1447),
    [sym_character_literal] = ACTIONS(1449),
    [anon_sym_static] = ACTIONS(1447),
    [sym_octal_integer_literal] = ACTIONS(1449),
    [ts_builtin_sym_end] = ACTIONS(1449),
    [anon_sym_throw] = ACTIONS(1447),
    [sym_decimal_integer_literal] = ACTIONS(1447),
    [sym_decimal_floating_point_literal] = ACTIONS(1449),
    [anon_sym_if] = ACTIONS(1447),
    [sym_boolean_type] = ACTIONS(1447),
  },
  [462] = {
    [sym_catch_clause] = STATE(462),
    [aux_sym_try_statement_repeat1] = STATE(462),
    [anon_sym_abstract] = ACTIONS(1451),
    [anon_sym_double] = ACTIONS(1451),
    [anon_sym_byte] = ACTIONS(1451),
    [anon_sym_switch] = ACTIONS(1451),
    [anon_sym_class] = ACTIONS(1451),
    [anon_sym_final] = ACTIONS(1451),
    [sym_void_type] = ACTIONS(1451),
    [ts_builtin_sym_end] = ACTIONS(1453),
    [sym_comment] = ACTIONS(3),
    [anon_sym_ATinterface] = ACTIONS(1453),
    [sym_hex_floating_point_literal] = ACTIONS(1451),
    [anon_sym_protected] = ACTIONS(1451),
    [anon_sym_catch] = ACTIONS(1455),
    [sym_binary_integer_literal] = ACTIONS(1453),
    [sym_null_literal] = ACTIONS(1451),
    [anon_sym_float] = ACTIONS(1451),
    [anon_sym_new] = ACTIONS(1451),
    [anon_sym_finally] = ACTIONS(1451),
    [sym_decimal_floating_point_literal] = ACTIONS(1453),
    [anon_sym_TILDE] = ACTIONS(1453),
    [anon_sym_synchronized] = ACTIONS(1451),
    [anon_sym_continue] = ACTIONS(1451),
    [anon_sym_throw] = ACTIONS(1451),
    [anon_sym_short] = ACTIONS(1451),
    [anon_sym_DASH] = ACTIONS(1451),
    [sym_false] = ACTIONS(1451),
    [sym_identifier] = ACTIONS(1451),
    [anon_sym_assert] = ACTIONS(1451),
    [anon_sym_break] = ACTIONS(1451),
    [anon_sym_public] = ACTIONS(1451),
    [sym_true] = ACTIONS(1451),
    [anon_sym_DASH_DASH] = ACTIONS(1453),
    [anon_sym_if] = ACTIONS(1451),
    [anon_sym_for] = ACTIONS(1451),
    [anon_sym_private] = ACTIONS(1451),
    [anon_sym_SEMI] = ACTIONS(1453),
    [anon_sym_LBRACE] = ACTIONS(1453),
    [anon_sym_while] = ACTIONS(1451),
    [anon_sym_module] = ACTIONS(1451),
    [anon_sym_static] = ACTIONS(1451),
    [anon_sym_PLUS_PLUS] = ACTIONS(1453),
    [anon_sym_PLUS] = ACTIONS(1451),
    [anon_sym_do] = ACTIONS(1451),
    [anon_sym_return] = ACTIONS(1451),
    [anon_sym_package] = ACTIONS(1451),
    [anon_sym_char] = ACTIONS(1451),
    [anon_sym_native] = ACTIONS(1451),
    [anon_sym_default] = ACTIONS(1451),
    [anon_sym_open] = ACTIONS(1451),
    [anon_sym_BANG] = ACTIONS(1453),
    [anon_sym_int] = ACTIONS(1451),
    [anon_sym_volatile] = ACTIONS(1451),
    [sym_this] = ACTIONS(1451),
    [anon_sym_interface] = ACTIONS(1451),
    [anon_sym_case] = ACTIONS(1451),
    [anon_sym_else] = ACTIONS(1451),
    [anon_sym_LPAREN] = ACTIONS(1453),
    [anon_sym_long] = ACTIONS(1451),
    [anon_sym_import] = ACTIONS(1451),
    [sym_decimal_integer_literal] = ACTIONS(1451),
    [anon_sym_RBRACE] = ACTIONS(1453),
    [sym_super] = ACTIONS(1451),
    [sym_boolean_type] = ACTIONS(1451),
    [sym_string_literal] = ACTIONS(1453),
    [sym_character_literal] = ACTIONS(1453),
    [anon_sym_transient] = ACTIONS(1451),
    [anon_sym_AT] = ACTIONS(1451),
    [anon_sym_try] = ACTIONS(1451),
    [sym_hex_integer_literal] = ACTIONS(1451),
    [anon_sym_strictfp] = ACTIONS(1451),
    [sym_octal_integer_literal] = ACTIONS(1453),
    [anon_sym_enum] = ACTIONS(1451),
  },
  [463] = {
    [sym_type_arguments] = STATE(615),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(1458),
    [anon_sym_LT] = ACTIONS(146),
  },
  [464] = {
    [anon_sym_GT_EQ] = ACTIONS(1460),
    [anon_sym_GT] = ACTIONS(1462),
    [anon_sym_AMP_AMP] = ACTIONS(1460),
    [anon_sym_GT_GT] = ACTIONS(1462),
    [anon_sym_RPAREN] = ACTIONS(1460),
    [anon_sym_BANG_EQ] = ACTIONS(1460),
    [anon_sym_EQ_EQ] = ACTIONS(1460),
    [anon_sym_instanceof] = ACTIONS(1460),
    [anon_sym_COLON] = ACTIONS(1462),
    [anon_sym_DASH] = ACTIONS(1462),
    [anon_sym_COMMA] = ACTIONS(1460),
    [anon_sym_PIPE_PIPE] = ACTIONS(1460),
    [anon_sym_RBRACK] = ACTIONS(1460),
    [anon_sym_RBRACE] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1460),
    [anon_sym_LT_LT] = ACTIONS(1460),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PERCENT] = ACTIONS(1460),
    [anon_sym_PIPE] = ACTIONS(1462),
    [anon_sym_SEMI] = ACTIONS(1460),
    [anon_sym_STAR] = ACTIONS(1460),
    [anon_sym_PLUS_PLUS] = ACTIONS(1460),
    [anon_sym_AMP] = ACTIONS(1462),
    [anon_sym_QMARK] = ACTIONS(1460),
    [anon_sym_LBRACK] = ACTIONS(1460),
    [anon_sym_DOT] = ACTIONS(1460),
    [anon_sym_DASH_DASH] = ACTIONS(1460),
    [anon_sym_LT_EQ] = ACTIONS(1460),
    [anon_sym_PLUS] = ACTIONS(1462),
    [anon_sym_CARET] = ACTIONS(1460),
    [anon_sym_LT] = ACTIONS(1462),
    [anon_sym_SLASH] = ACTIONS(1462),
    [anon_sym_GT_GT_GT] = ACTIONS(1460),
  },
  [465] = {
    [sym_argument_list] = STATE(616),
    [anon_sym_LPAREN] = ACTIONS(112),
    [sym_comment] = ACTIONS(3),
  },
  [466] = {
    [anon_sym_PIPE_PIPE] = ACTIONS(1464),
    [anon_sym_COLON_COLON] = ACTIONS(1464),
    [anon_sym_EQ] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(1466),
    [anon_sym_PIPE] = ACTIONS(1466),
    [anon_sym_STAR] = ACTIONS(1466),
    [anon_sym_GT_GT_GT] = ACTIONS(1466),
    [anon_sym_SEMI] = ACTIONS(1464),
    [anon_sym_STAR_EQ] = ACTIONS(1464),
    [anon_sym_SLASH] = ACTIONS(1466),
    [anon_sym_instanceof] = ACTIONS(1464),
    [anon_sym_DASH_DASH] = ACTIONS(1464),
    [anon_sym_LT_LT] = ACTIONS(1466),
    [anon_sym_COLON] = ACTIONS(1466),
    [anon_sym_RBRACE] = ACTIONS(1464),
    [anon_sym_PERCENT_EQ] = ACTIONS(1464),
    [anon_sym_GT_GT] = ACTIONS(1466),
    [anon_sym_COMMA] = ACTIONS(1464),
    [anon_sym_AMP_EQ] = ACTIONS(1464),
    [anon_sym_DOT] = ACTIONS(1464),
    [anon_sym_DASH] = ACTIONS(1466),
    [anon_sym_PERCENT] = ACTIONS(1466),
    [anon_sym_CARET_EQ] = ACTIONS(1464),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1464),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_EQ] = ACTIONS(1464),
    [anon_sym_AMP_AMP] = ACTIONS(1464),
    [anon_sym_BANG_EQ] = ACTIONS(1464),
    [anon_sym_SLASH_EQ] = ACTIONS(1464),
    [anon_sym_LBRACK] = ACTIONS(1464),
    [anon_sym_EQ_EQ] = ACTIONS(1464),
    [anon_sym_RPAREN] = ACTIONS(1464),
    [anon_sym_AMP] = ACTIONS(1466),
    [anon_sym_PLUS_EQ] = ACTIONS(1464),
    [anon_sym_RBRACK] = ACTIONS(1464),
    [anon_sym_LT_EQ] = ACTIONS(1464),
    [anon_sym_LT_LT_EQ] = ACTIONS(1464),
    [anon_sym_GT_EQ] = ACTIONS(1464),
    [anon_sym_QMARK] = ACTIONS(1464),
    [anon_sym_GT_GT_EQ] = ACTIONS(1464),
    [anon_sym_LT] = ACTIONS(1466),
    [anon_sym_DASH_EQ] = ACTIONS(1464),
    [anon_sym_GT] = ACTIONS(1466),
    [anon_sym_PLUS] = ACTIONS(1466),
    [anon_sym_PLUS_PLUS] = ACTIONS(1464),
  },
  [467] = {
    [anon_sym_PIPE] = ACTIONS(1468),
    [anon_sym_COLON_COLON] = ACTIONS(1470),
    [anon_sym_SLASH] = ACTIONS(1468),
    [anon_sym_GT] = ACTIONS(1468),
    [anon_sym_AMP] = ACTIONS(1468),
    [anon_sym_RBRACE] = ACTIONS(1470),
    [anon_sym_EQ_EQ] = ACTIONS(1470),
    [anon_sym_PERCENT] = ACTIONS(1470),
    [anon_sym_instanceof] = ACTIONS(1470),
    [anon_sym_SEMI] = ACTIONS(1470),
    [anon_sym_RBRACK] = ACTIONS(1470),
    [anon_sym_PLUS] = ACTIONS(1468),
    [anon_sym_LBRACK] = ACTIONS(1470),
    [anon_sym_LT] = ACTIONS(1468),
    [anon_sym_PIPE_PIPE] = ACTIONS(1470),
    [anon_sym_STAR] = ACTIONS(1470),
    [anon_sym_GT_GT_GT] = ACTIONS(1470),
    [anon_sym_RPAREN] = ACTIONS(1470),
    [anon_sym_LT_LT] = ACTIONS(1470),
    [anon_sym_QMARK] = ACTIONS(1470),
    [anon_sym_COMMA] = ACTIONS(1470),
    [anon_sym_BANG_EQ] = ACTIONS(1470),
    [anon_sym_GT_EQ] = ACTIONS(1470),
    [anon_sym_DASH] = ACTIONS(1468),
    [anon_sym_PLUS_PLUS] = ACTIONS(1470),
    [anon_sym_CARET] = ACTIONS(1470),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_GT] = ACTIONS(1468),
    [anon_sym_COLON] = ACTIONS(1468),
    [anon_sym_DASH_DASH] = ACTIONS(1470),
    [anon_sym_LT_EQ] = ACTIONS(1470),
    [anon_sym_DOT] = ACTIONS(1470),
    [anon_sym_AMP_AMP] = ACTIONS(1470),
  },
  [468] = {
    [aux_sym_module_declaration_repeat1] = STATE(618),
    [sym_module_directive] = STATE(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1472),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_requires] = ACTIONS(1087),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_provides] = ACTIONS(1081),
  },
  [469] = {
    [sym_module_directive] = STATE(620),
    [aux_sym_module_declaration_repeat1] = STATE(620),
    [sym_comment] = ACTIONS(3),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_requires] = ACTIONS(1087),
    [anon_sym_provides] = ACTIONS(1081),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_RBRACE] = ACTIONS(1474),
  },
  [470] = {
    [anon_sym_AMP_AMP] = ACTIONS(1476),
    [anon_sym_DASH] = ACTIONS(1478),
    [anon_sym_PIPE] = ACTIONS(1478),
    [anon_sym_QMARK] = ACTIONS(1476),
    [anon_sym_RBRACE] = ACTIONS(1476),
    [anon_sym_GT_EQ] = ACTIONS(1476),
    [anon_sym_PLUS] = ACTIONS(1478),
    [anon_sym_GT_GT_GT] = ACTIONS(1476),
    [anon_sym_PLUS_PLUS] = ACTIONS(1476),
    [anon_sym_SEMI] = ACTIONS(1476),
    [anon_sym_COMMA] = ACTIONS(1476),
    [anon_sym_COLON] = ACTIONS(1478),
    [anon_sym_DOT] = ACTIONS(1476),
    [anon_sym_PERCENT] = ACTIONS(1476),
    [anon_sym_LT] = ACTIONS(1478),
    [anon_sym_AMP] = ACTIONS(1478),
    [anon_sym_COLON_COLON] = ACTIONS(1476),
    [anon_sym_STAR] = ACTIONS(1476),
    [anon_sym_CARET] = ACTIONS(1476),
    [anon_sym_instanceof] = ACTIONS(1476),
    [anon_sym_GT] = ACTIONS(1478),
    [anon_sym_RPAREN] = ACTIONS(1476),
    [anon_sym_LT_LT] = ACTIONS(1476),
    [anon_sym_LT_EQ] = ACTIONS(1476),
    [anon_sym_DASH_DASH] = ACTIONS(1476),
    [anon_sym_RBRACK] = ACTIONS(1476),
    [anon_sym_PIPE_PIPE] = ACTIONS(1476),
    [anon_sym_SLASH] = ACTIONS(1478),
    [anon_sym_LBRACK] = ACTIONS(1476),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG_EQ] = ACTIONS(1476),
    [anon_sym_EQ_EQ] = ACTIONS(1476),
    [anon_sym_GT_GT] = ACTIONS(1478),
  },
  [471] = {
    [sym_scoped_identifier] = STATE(622),
    [sym_identifier] = ACTIONS(1480),
    [anon_sym_module] = ACTIONS(1482),
    [anon_sym_open] = ACTIONS(1482),
    [sym_comment] = ACTIONS(3),
  },
  [472] = {
    [sym_scoped_identifier] = STATE(624),
    [anon_sym_open] = ACTIONS(1484),
    [anon_sym_module] = ACTIONS(1484),
    [sym_identifier] = ACTIONS(1486),
    [sym_comment] = ACTIONS(3),
  },
  [473] = {
    [sym_scoped_identifier] = STATE(626),
    [anon_sym_open] = ACTIONS(1488),
    [sym_identifier] = ACTIONS(1490),
    [anon_sym_module] = ACTIONS(1488),
    [sym_comment] = ACTIONS(3),
  },
  [474] = {
    [sym_module_name] = STATE(630),
    [aux_sym_module_directive_repeat1] = STATE(629),
    [sym_requires_modifier] = STATE(629),
    [anon_sym_static] = ACTIONS(1492),
    [sym_identifier] = ACTIONS(1494),
    [anon_sym_transitive] = ACTIONS(1492),
    [sym_comment] = ACTIONS(3),
  },
  [475] = {
    [anon_sym_LPAREN] = ACTIONS(1496),
    [anon_sym_int] = ACTIONS(1498),
    [sym_this] = ACTIONS(1498),
    [anon_sym_RBRACE] = ACTIONS(1496),
    [anon_sym_public] = ACTIONS(1498),
    [anon_sym_PLUS_PLUS] = ACTIONS(1496),
    [sym_decimal_integer_literal] = ACTIONS(1498),
    [anon_sym_new] = ACTIONS(1498),
    [anon_sym_class] = ACTIONS(1498),
    [anon_sym_for] = ACTIONS(1498),
    [anon_sym_private] = ACTIONS(1498),
    [sym_octal_integer_literal] = ACTIONS(1496),
    [anon_sym_LBRACE] = ACTIONS(1496),
    [anon_sym_final] = ACTIONS(1498),
    [anon_sym_volatile] = ACTIONS(1498),
    [anon_sym_native] = ACTIONS(1498),
    [sym_void_type] = ACTIONS(1498),
    [anon_sym_protected] = ACTIONS(1498),
    [sym_boolean_type] = ACTIONS(1498),
    [sym_super] = ACTIONS(1498),
    [ts_builtin_sym_end] = ACTIONS(1496),
    [sym_string_literal] = ACTIONS(1496),
    [sym_comment] = ACTIONS(3),
    [anon_sym_switch] = ACTIONS(1498),
    [anon_sym_else] = ACTIONS(1498),
    [anon_sym_AT] = ACTIONS(1498),
    [anon_sym_byte] = ACTIONS(1498),
    [anon_sym_enum] = ACTIONS(1498),
    [anon_sym_assert] = ACTIONS(1498),
    [sym_decimal_floating_point_literal] = ACTIONS(1496),
    [anon_sym_BANG] = ACTIONS(1496),
    [anon_sym_import] = ACTIONS(1498),
    [anon_sym_strictfp] = ACTIONS(1498),
    [anon_sym_float] = ACTIONS(1498),
    [anon_sym_static] = ACTIONS(1498),
    [sym_character_literal] = ACTIONS(1496),
    [anon_sym_package] = ACTIONS(1498),
    [anon_sym_DASH_DASH] = ACTIONS(1496),
    [anon_sym_DASH] = ACTIONS(1498),
    [sym_identifier] = ACTIONS(1498),
    [sym_true] = ACTIONS(1498),
    [anon_sym_default] = ACTIONS(1498),
    [anon_sym_interface] = ACTIONS(1498),
    [anon_sym_case] = ACTIONS(1498),
    [anon_sym_PLUS] = ACTIONS(1498),
    [sym_hex_integer_literal] = ACTIONS(1498),
    [anon_sym_do] = ACTIONS(1498),
    [anon_sym_ATinterface] = ACTIONS(1496),
    [anon_sym_long] = ACTIONS(1498),
    [anon_sym_char] = ACTIONS(1498),
    [sym_hex_floating_point_literal] = ACTIONS(1498),
    [anon_sym_continue] = ACTIONS(1498),
    [anon_sym_synchronized] = ACTIONS(1498),
    [anon_sym_throw] = ACTIONS(1498),
    [sym_null_literal] = ACTIONS(1498),
    [anon_sym_try] = ACTIONS(1498),
    [anon_sym_module] = ACTIONS(1498),
    [anon_sym_short] = ACTIONS(1498),
    [anon_sym_TILDE] = ACTIONS(1496),
    [sym_false] = ACTIONS(1498),
    [anon_sym_break] = ACTIONS(1498),
    [anon_sym_while] = ACTIONS(1498),
    [anon_sym_double] = ACTIONS(1498),
    [anon_sym_if] = ACTIONS(1498),
    [sym_binary_integer_literal] = ACTIONS(1496),
    [anon_sym_SEMI] = ACTIONS(1496),
    [anon_sym_abstract] = ACTIONS(1498),
    [anon_sym_open] = ACTIONS(1498),
    [anon_sym_return] = ACTIONS(1498),
    [anon_sym_transient] = ACTIONS(1498),
  },
  [476] = {
    [aux_sym_module_declaration_repeat1] = STATE(632),
    [sym_module_directive] = STATE(632),
    [sym_comment] = ACTIONS(3),
    [anon_sym_requires] = ACTIONS(1087),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_RBRACE] = ACTIONS(1500),
    [anon_sym_provides] = ACTIONS(1081),
  },
  [477] = {
    [sym_true] = ACTIONS(1502),
    [anon_sym_continue] = ACTIONS(1502),
    [sym_identifier] = ACTIONS(1502),
    [anon_sym_do] = ACTIONS(1502),
    [anon_sym_char] = ACTIONS(1502),
    [anon_sym_volatile] = ACTIONS(1502),
    [anon_sym_long] = ACTIONS(1502),
    [anon_sym_PLUS_PLUS] = ACTIONS(1504),
    [anon_sym_strictfp] = ACTIONS(1502),
    [sym_decimal_integer_literal] = ACTIONS(1502),
    [anon_sym_package] = ACTIONS(1502),
    [anon_sym_if] = ACTIONS(1502),
    [anon_sym_double] = ACTIONS(1502),
    [anon_sym_throw] = ACTIONS(1502),
    [anon_sym_new] = ACTIONS(1502),
    [anon_sym_float] = ACTIONS(1502),
    [anon_sym_synchronized] = ACTIONS(1502),
    [anon_sym_DASH] = ACTIONS(1502),
    [sym_character_literal] = ACTIONS(1504),
    [sym_boolean_type] = ACTIONS(1502),
    [anon_sym_byte] = ACTIONS(1502),
    [anon_sym_open] = ACTIONS(1502),
    [anon_sym_class] = ACTIONS(1502),
    [anon_sym_ATinterface] = ACTIONS(1504),
    [sym_octal_integer_literal] = ACTIONS(1504),
    [anon_sym_break] = ACTIONS(1502),
    [anon_sym_import] = ACTIONS(1502),
    [anon_sym_protected] = ACTIONS(1502),
    [anon_sym_module] = ACTIONS(1502),
    [anon_sym_LBRACE] = ACTIONS(1504),
    [anon_sym_final] = ACTIONS(1502),
    [sym_super] = ACTIONS(1502),
    [anon_sym_default] = ACTIONS(1502),
    [anon_sym_else] = ACTIONS(1502),
    [anon_sym_transient] = ACTIONS(1502),
    [anon_sym_AT] = ACTIONS(1502),
    [sym_comment] = ACTIONS(3),
    [anon_sym_private] = ACTIONS(1502),
    [anon_sym_static] = ACTIONS(1502),
    [anon_sym_int] = ACTIONS(1502),
    [sym_decimal_floating_point_literal] = ACTIONS(1504),
    [sym_false] = ACTIONS(1502),
    [anon_sym_TILDE] = ACTIONS(1504),
    [anon_sym_DASH_DASH] = ACTIONS(1504),
    [anon_sym_abstract] = ACTIONS(1502),
    [anon_sym_short] = ACTIONS(1502),
    [sym_null_literal] = ACTIONS(1502),
    [anon_sym_BANG] = ACTIONS(1504),
    [anon_sym_SEMI] = ACTIONS(1504),
    [anon_sym_while] = ACTIONS(1502),
    [sym_this] = ACTIONS(1502),
    [anon_sym_LPAREN] = ACTIONS(1504),
    [sym_hex_integer_literal] = ACTIONS(1502),
    [anon_sym_native] = ACTIONS(1502),
    [anon_sym_assert] = ACTIONS(1502),
    [anon_sym_return] = ACTIONS(1502),
    [anon_sym_RBRACE] = ACTIONS(1504),
    [ts_builtin_sym_end] = ACTIONS(1504),
    [sym_void_type] = ACTIONS(1502),
    [anon_sym_PLUS] = ACTIONS(1502),
    [anon_sym_enum] = ACTIONS(1502),
    [anon_sym_public] = ACTIONS(1502),
    [sym_binary_integer_literal] = ACTIONS(1504),
    [sym_hex_floating_point_literal] = ACTIONS(1502),
    [anon_sym_case] = ACTIONS(1502),
    [anon_sym_interface] = ACTIONS(1502),
    [anon_sym_try] = ACTIONS(1502),
    [anon_sym_switch] = ACTIONS(1502),
    [anon_sym_for] = ACTIONS(1502),
    [sym_string_literal] = ACTIONS(1504),
  },
  [478] = {
    [aux_sym_module_declaration_repeat1] = STATE(632),
    [sym_module_directive] = STATE(632),
    [anon_sym_requires] = ACTIONS(1087),
    [anon_sym_RBRACE] = ACTIONS(1472),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_provides] = ACTIONS(1081),
    [anon_sym_exports] = ACTIONS(1089),
    [sym_comment] = ACTIONS(3),
  },
  [479] = {
    [anon_sym_PIPE] = ACTIONS(1506),
    [anon_sym_GT] = ACTIONS(1506),
    [anon_sym_COLON_COLON] = ACTIONS(1506),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(1508),
    [anon_sym_DOT] = ACTIONS(1508),
    [anon_sym_RPAREN] = ACTIONS(1506),
    [anon_sym_LPAREN] = ACTIONS(1506),
    [anon_sym_COMMA] = ACTIONS(1506),
    [anon_sym_SEMI] = ACTIONS(1506),
    [anon_sym_LBRACK] = ACTIONS(1506),
    [sym_this] = ACTIONS(1508),
    [anon_sym_implements] = ACTIONS(1508),
    [anon_sym_LBRACE] = ACTIONS(1506),
    [anon_sym_open] = ACTIONS(1508),
    [sym_identifier] = ACTIONS(1508),
    [anon_sym_AT] = ACTIONS(1506),
    [anon_sym_AMP] = ACTIONS(1506),
    [anon_sym_LT] = ACTIONS(1506),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1506),
  },
  [480] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(1510),
  },
  [481] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1512),
    [anon_sym_DOT] = ACTIONS(372),
  },
  [482] = {
    [anon_sym_long] = ACTIONS(1514),
    [anon_sym_DASH_DASH] = ACTIONS(1516),
    [anon_sym_double] = ACTIONS(1514),
    [anon_sym_synchronized] = ACTIONS(1514),
    [anon_sym_native] = ACTIONS(1514),
    [anon_sym_short] = ACTIONS(1514),
    [anon_sym_return] = ACTIONS(1514),
    [anon_sym_private] = ACTIONS(1514),
    [sym_comment] = ACTIONS(3),
    [anon_sym_assert] = ACTIONS(1514),
    [sym_string_literal] = ACTIONS(1516),
    [sym_binary_integer_literal] = ACTIONS(1516),
    [anon_sym_char] = ACTIONS(1514),
    [sym_void_type] = ACTIONS(1514),
    [anon_sym_if] = ACTIONS(1514),
    [anon_sym_SEMI] = ACTIONS(1516),
    [anon_sym_break] = ACTIONS(1514),
    [anon_sym_module] = ACTIONS(1514),
    [anon_sym_byte] = ACTIONS(1514),
    [anon_sym_package] = ACTIONS(1514),
    [anon_sym_try] = ACTIONS(1514),
    [anon_sym_static] = ACTIONS(1514),
    [anon_sym_DASH] = ACTIONS(1514),
    [sym_octal_integer_literal] = ACTIONS(1516),
    [sym_decimal_integer_literal] = ACTIONS(1514),
    [anon_sym_while] = ACTIONS(1514),
    [anon_sym_BANG] = ACTIONS(1516),
    [anon_sym_public] = ACTIONS(1514),
    [sym_character_literal] = ACTIONS(1516),
    [anon_sym_protected] = ACTIONS(1514),
    [anon_sym_for] = ACTIONS(1514),
    [anon_sym_case] = ACTIONS(1514),
    [sym_false] = ACTIONS(1514),
    [anon_sym_do] = ACTIONS(1514),
    [sym_hex_floating_point_literal] = ACTIONS(1514),
    [anon_sym_LPAREN] = ACTIONS(1516),
    [anon_sym_PLUS] = ACTIONS(1514),
    [anon_sym_int] = ACTIONS(1514),
    [anon_sym_throw] = ACTIONS(1514),
    [anon_sym_LBRACE] = ACTIONS(1516),
    [anon_sym_class] = ACTIONS(1514),
    [sym_true] = ACTIONS(1514),
    [anon_sym_float] = ACTIONS(1514),
    [sym_boolean_type] = ACTIONS(1514),
    [anon_sym_RBRACE] = ACTIONS(1516),
    [sym_super] = ACTIONS(1514),
    [ts_builtin_sym_end] = ACTIONS(1516),
    [anon_sym_final] = ACTIONS(1514),
    [anon_sym_transient] = ACTIONS(1514),
    [sym_null_literal] = ACTIONS(1514),
    [anon_sym_switch] = ACTIONS(1514),
    [anon_sym_PLUS_PLUS] = ACTIONS(1516),
    [anon_sym_open] = ACTIONS(1514),
    [anon_sym_TILDE] = ACTIONS(1516),
    [anon_sym_strictfp] = ACTIONS(1514),
    [sym_this] = ACTIONS(1514),
    [anon_sym_volatile] = ACTIONS(1514),
    [anon_sym_ATinterface] = ACTIONS(1516),
    [anon_sym_AT] = ACTIONS(1514),
    [anon_sym_interface] = ACTIONS(1514),
    [anon_sym_abstract] = ACTIONS(1514),
    [anon_sym_import] = ACTIONS(1514),
    [sym_identifier] = ACTIONS(1514),
    [sym_hex_integer_literal] = ACTIONS(1514),
    [anon_sym_default] = ACTIONS(1514),
    [anon_sym_continue] = ACTIONS(1514),
    [anon_sym_else] = ACTIONS(1514),
    [anon_sym_enum] = ACTIONS(1514),
    [anon_sym_new] = ACTIONS(1514),
    [sym_decimal_floating_point_literal] = ACTIONS(1516),
  },
  [483] = {
    [anon_sym_module] = ACTIONS(1518),
    [anon_sym_int] = ACTIONS(1518),
    [anon_sym_throw] = ACTIONS(1518),
    [anon_sym_byte] = ACTIONS(1518),
    [anon_sym_switch] = ACTIONS(1518),
    [anon_sym_LBRACE] = ACTIONS(1520),
    [anon_sym_do] = ACTIONS(1518),
    [sym_null_literal] = ACTIONS(1518),
    [anon_sym_AT] = ACTIONS(1518),
    [anon_sym_DASH_DASH] = ACTIONS(1520),
    [anon_sym_long] = ACTIONS(1518),
    [anon_sym_float] = ACTIONS(1518),
    [sym_comment] = ACTIONS(3),
    [anon_sym_private] = ACTIONS(1518),
    [anon_sym_char] = ACTIONS(1518),
    [anon_sym_default] = ACTIONS(1518),
    [anon_sym_strictfp] = ACTIONS(1518),
    [anon_sym_double] = ACTIONS(1518),
    [sym_this] = ACTIONS(1518),
    [sym_character_literal] = ACTIONS(1520),
    [anon_sym_open] = ACTIONS(1518),
    [anon_sym_PLUS] = ACTIONS(1518),
    [sym_hex_integer_literal] = ACTIONS(1518),
    [anon_sym_ATinterface] = ACTIONS(1520),
    [anon_sym_static] = ACTIONS(1518),
    [sym_identifier] = ACTIONS(1518),
    [anon_sym_for] = ACTIONS(1518),
    [anon_sym_volatile] = ACTIONS(1518),
    [sym_void_type] = ACTIONS(1518),
    [anon_sym_class] = ACTIONS(1518),
    [anon_sym_if] = ACTIONS(1518),
    [anon_sym_SEMI] = ACTIONS(1520),
    [sym_true] = ACTIONS(1518),
    [sym_hex_floating_point_literal] = ACTIONS(1518),
    [anon_sym_import] = ACTIONS(1518),
    [anon_sym_TILDE] = ACTIONS(1520),
    [anon_sym_abstract] = ACTIONS(1518),
    [anon_sym_LPAREN] = ACTIONS(1520),
    [anon_sym_new] = ACTIONS(1518),
    [anon_sym_assert] = ACTIONS(1518),
    [anon_sym_public] = ACTIONS(1518),
    [sym_super] = ACTIONS(1518),
    [anon_sym_while] = ACTIONS(1518),
    [sym_boolean_type] = ACTIONS(1518),
    [anon_sym_RBRACE] = ACTIONS(1520),
    [sym_decimal_floating_point_literal] = ACTIONS(1520),
    [anon_sym_synchronized] = ACTIONS(1518),
    [anon_sym_native] = ACTIONS(1518),
    [anon_sym_enum] = ACTIONS(1518),
    [anon_sym_protected] = ACTIONS(1518),
    [sym_binary_integer_literal] = ACTIONS(1520),
    [sym_octal_integer_literal] = ACTIONS(1520),
    [anon_sym_continue] = ACTIONS(1518),
    [anon_sym_transient] = ACTIONS(1518),
    [anon_sym_case] = ACTIONS(1518),
    [anon_sym_interface] = ACTIONS(1518),
    [ts_builtin_sym_end] = ACTIONS(1520),
    [sym_false] = ACTIONS(1518),
    [anon_sym_return] = ACTIONS(1518),
    [anon_sym_final] = ACTIONS(1518),
    [anon_sym_package] = ACTIONS(1518),
    [anon_sym_else] = ACTIONS(1518),
    [anon_sym_break] = ACTIONS(1518),
    [sym_string_literal] = ACTIONS(1520),
    [sym_decimal_integer_literal] = ACTIONS(1518),
    [anon_sym_DASH] = ACTIONS(1518),
    [anon_sym_short] = ACTIONS(1518),
    [anon_sym_PLUS_PLUS] = ACTIONS(1520),
    [anon_sym_try] = ACTIONS(1518),
    [anon_sym_BANG] = ACTIONS(1520),
  },
  [484] = {
    [anon_sym_COMMA] = ACTIONS(1522),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_SEMI] = ACTIONS(1522),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_instanceof] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_RPAREN] = ACTIONS(1522),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(293),
  },
  [485] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1522),
    [anon_sym_COMMA] = ACTIONS(1522),
    [anon_sym_SEMI] = ACTIONS(1522),
  },
  [486] = {
    [anon_sym_SEMI] = ACTIONS(1524),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1524),
  },
  [487] = {
    [aux_sym__variable_declarator_list_repeat1] = STATE(487),
    [anon_sym_SEMI] = ACTIONS(1526),
    [anon_sym_COMMA] = ACTIONS(1528),
    [sym_comment] = ACTIONS(3),
  },
  [488] = {
    [anon_sym_RPAREN] = ACTIONS(1531),
    [anon_sym_volatile] = ACTIONS(1533),
    [anon_sym_synchronized] = ACTIONS(1533),
    [anon_sym_SEMI] = ACTIONS(1531),
    [sym_void_type] = ACTIONS(1533),
    [anon_sym_EQ] = ACTIONS(1531),
    [anon_sym_AMP] = ACTIONS(1531),
    [anon_sym_DOT] = ACTIONS(1533),
    [anon_sym_LBRACE] = ACTIONS(1531),
    [anon_sym_short] = ACTIONS(1533),
    [anon_sym_LBRACK] = ACTIONS(1531),
    [anon_sym_module] = ACTIONS(1533),
    [anon_sym_byte] = ACTIONS(1533),
    [anon_sym_implements] = ACTIONS(1533),
    [anon_sym_COLON] = ACTIONS(1533),
    [anon_sym_final] = ACTIONS(1533),
    [anon_sym_static] = ACTIONS(1533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_public] = ACTIONS(1533),
    [anon_sym_float] = ACTIONS(1533),
    [anon_sym_strictfp] = ACTIONS(1533),
    [sym_identifier] = ACTIONS(1533),
    [anon_sym_COMMA] = ACTIONS(1531),
    [anon_sym_abstract] = ACTIONS(1533),
    [anon_sym_default] = ACTIONS(1533),
    [anon_sym_throws] = ACTIONS(1533),
    [anon_sym_char] = ACTIONS(1533),
    [sym_this] = ACTIONS(1533),
    [anon_sym_int] = ACTIONS(1533),
    [anon_sym_AT] = ACTIONS(1531),
    [anon_sym_transient] = ACTIONS(1533),
    [anon_sym_long] = ACTIONS(1533),
    [anon_sym_double] = ACTIONS(1533),
    [anon_sym_GT] = ACTIONS(1531),
    [sym_boolean_type] = ACTIONS(1533),
    [anon_sym_protected] = ACTIONS(1533),
    [anon_sym_PIPE] = ACTIONS(1531),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1531),
    [anon_sym_native] = ACTIONS(1533),
    [anon_sym_COLON_COLON] = ACTIONS(1531),
    [anon_sym_open] = ACTIONS(1533),
    [anon_sym_private] = ACTIONS(1533),
  },
  [489] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1535),
  },
  [490] = {
    [anon_sym_while] = ACTIONS(1537),
    [anon_sym_char] = ACTIONS(1537),
    [anon_sym_DASH_DASH] = ACTIONS(1539),
    [anon_sym_TILDE] = ACTIONS(1539),
    [anon_sym_DASH] = ACTIONS(1537),
    [anon_sym_short] = ACTIONS(1537),
    [anon_sym_case] = ACTIONS(1537),
    [anon_sym_static] = ACTIONS(1537),
    [anon_sym_volatile] = ACTIONS(1537),
    [anon_sym_enum] = ACTIONS(1537),
    [anon_sym_ATinterface] = ACTIONS(1539),
    [anon_sym_byte] = ACTIONS(1537),
    [anon_sym_else] = ACTIONS(1537),
    [anon_sym_for] = ACTIONS(1537),
    [sym_character_literal] = ACTIONS(1539),
    [anon_sym_break] = ACTIONS(1537),
    [anon_sym_LT] = ACTIONS(1539),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(1537),
    [sym_hex_integer_literal] = ACTIONS(1537),
    [sym_super] = ACTIONS(1537),
    [sym_identifier] = ACTIONS(1537),
    [sym_decimal_floating_point_literal] = ACTIONS(1539),
    [sym_false] = ACTIONS(1537),
    [sym_hex_floating_point_literal] = ACTIONS(1537),
    [ts_builtin_sym_end] = ACTIONS(1539),
    [anon_sym_try] = ACTIONS(1537),
    [anon_sym_strictfp] = ACTIONS(1537),
    [sym_string_literal] = ACTIONS(1539),
    [anon_sym_package] = ACTIONS(1537),
    [anon_sym_public] = ACTIONS(1537),
    [sym_binary_integer_literal] = ACTIONS(1539),
    [sym_boolean_type] = ACTIONS(1537),
    [anon_sym_assert] = ACTIONS(1537),
    [anon_sym_PLUS] = ACTIONS(1537),
    [sym_octal_integer_literal] = ACTIONS(1539),
    [anon_sym_private] = ACTIONS(1537),
    [anon_sym_long] = ACTIONS(1537),
    [sym_decimal_integer_literal] = ACTIONS(1537),
    [anon_sym_default] = ACTIONS(1537),
    [anon_sym_module] = ACTIONS(1537),
    [anon_sym_final] = ACTIONS(1537),
    [anon_sym_native] = ACTIONS(1537),
    [anon_sym_PLUS_PLUS] = ACTIONS(1539),
    [anon_sym_open] = ACTIONS(1537),
    [anon_sym_protected] = ACTIONS(1537),
    [anon_sym_do] = ACTIONS(1537),
    [anon_sym_interface] = ACTIONS(1537),
    [sym_null_literal] = ACTIONS(1537),
    [anon_sym_class] = ACTIONS(1537),
    [anon_sym_continue] = ACTIONS(1537),
    [anon_sym_throw] = ACTIONS(1537),
    [anon_sym_transient] = ACTIONS(1537),
    [anon_sym_switch] = ACTIONS(1537),
    [anon_sym_return] = ACTIONS(1537),
    [anon_sym_float] = ACTIONS(1537),
    [sym_true] = ACTIONS(1537),
    [anon_sym_if] = ACTIONS(1537),
    [sym_void_type] = ACTIONS(1537),
    [anon_sym_LPAREN] = ACTIONS(1539),
    [anon_sym_import] = ACTIONS(1537),
    [anon_sym_abstract] = ACTIONS(1537),
    [anon_sym_SEMI] = ACTIONS(1539),
    [anon_sym_AT] = ACTIONS(1537),
    [anon_sym_new] = ACTIONS(1537),
    [anon_sym_LBRACE] = ACTIONS(1539),
    [anon_sym_int] = ACTIONS(1537),
    [anon_sym_synchronized] = ACTIONS(1537),
    [anon_sym_BANG] = ACTIONS(1539),
    [anon_sym_double] = ACTIONS(1537),
    [anon_sym_RBRACE] = ACTIONS(1539),
  },
  [491] = {
    [sym_interface_body] = STATE(555),
    [sym_extends_interfaces] = STATE(636),
    [anon_sym_LBRACE] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
    [anon_sym_extends] = ACTIONS(445),
  },
  [492] = {
    [sym_super_interfaces] = STATE(638),
    [sym_class_body] = STATE(637),
    [anon_sym_implements] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(439),
  },
  [493] = {
    [anon_sym_DASH] = ACTIONS(1541),
    [anon_sym_assert] = ACTIONS(1541),
    [sym_null_literal] = ACTIONS(1541),
    [anon_sym_float] = ACTIONS(1541),
    [sym_string_literal] = ACTIONS(1543),
    [anon_sym_int] = ACTIONS(1541),
    [anon_sym_DASH_DASH] = ACTIONS(1543),
    [anon_sym_short] = ACTIONS(1541),
    [anon_sym_public] = ACTIONS(1541),
    [anon_sym_throw] = ACTIONS(1541),
    [sym_decimal_integer_literal] = ACTIONS(1541),
    [anon_sym_switch] = ACTIONS(1541),
    [anon_sym_try] = ACTIONS(1541),
    [anon_sym_AT] = ACTIONS(1541),
    [anon_sym_volatile] = ACTIONS(1541),
    [anon_sym_ATinterface] = ACTIONS(1543),
    [sym_void_type] = ACTIONS(1541),
    [sym_hex_floating_point_literal] = ACTIONS(1541),
    [anon_sym_LT] = ACTIONS(1543),
    [anon_sym_PLUS] = ACTIONS(1541),
    [anon_sym_for] = ACTIONS(1541),
    [sym_hex_integer_literal] = ACTIONS(1541),
    [anon_sym_long] = ACTIONS(1541),
    [anon_sym_LPAREN] = ACTIONS(1543),
    [anon_sym_abstract] = ACTIONS(1541),
    [ts_builtin_sym_end] = ACTIONS(1543),
    [anon_sym_RBRACE] = ACTIONS(1543),
    [anon_sym_case] = ACTIONS(1541),
    [anon_sym_return] = ACTIONS(1541),
    [sym_this] = ACTIONS(1541),
    [anon_sym_transient] = ACTIONS(1541),
    [anon_sym_break] = ACTIONS(1541),
    [anon_sym_SEMI] = ACTIONS(1543),
    [anon_sym_final] = ACTIONS(1541),
    [anon_sym_strictfp] = ACTIONS(1541),
    [anon_sym_interface] = ACTIONS(1541),
    [anon_sym_while] = ACTIONS(1541),
    [anon_sym_continue] = ACTIONS(1541),
    [anon_sym_private] = ACTIONS(1541),
    [sym_character_literal] = ACTIONS(1543),
    [sym_octal_integer_literal] = ACTIONS(1543),
    [anon_sym_package] = ACTIONS(1541),
    [anon_sym_native] = ACTIONS(1541),
    [sym_super] = ACTIONS(1541),
    [anon_sym_char] = ACTIONS(1541),
    [anon_sym_double] = ACTIONS(1541),
    [anon_sym_static] = ACTIONS(1541),
    [sym_false] = ACTIONS(1541),
    [anon_sym_do] = ACTIONS(1541),
    [sym_true] = ACTIONS(1541),
    [anon_sym_else] = ACTIONS(1541),
    [sym_comment] = ACTIONS(3),
    [anon_sym_TILDE] = ACTIONS(1543),
    [anon_sym_import] = ACTIONS(1541),
    [anon_sym_BANG] = ACTIONS(1543),
    [anon_sym_enum] = ACTIONS(1541),
    [anon_sym_module] = ACTIONS(1541),
    [anon_sym_default] = ACTIONS(1541),
    [anon_sym_PLUS_PLUS] = ACTIONS(1543),
    [anon_sym_class] = ACTIONS(1541),
    [anon_sym_synchronized] = ACTIONS(1541),
    [anon_sym_LBRACE] = ACTIONS(1543),
    [sym_binary_integer_literal] = ACTIONS(1543),
    [anon_sym_protected] = ACTIONS(1541),
    [sym_boolean_type] = ACTIONS(1541),
    [anon_sym_new] = ACTIONS(1541),
    [sym_decimal_floating_point_literal] = ACTIONS(1543),
    [anon_sym_open] = ACTIONS(1541),
    [anon_sym_byte] = ACTIONS(1541),
    [sym_identifier] = ACTIONS(1541),
    [anon_sym_if] = ACTIONS(1541),
  },
  [494] = {
    [sym_class_body] = STATE(639),
    [sym_superclass] = STATE(640),
    [sym_super_interfaces] = STATE(641),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_extends] = ACTIONS(435),
    [anon_sym_implements] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
  },
  [495] = {
    [sym_class_body] = STATE(642),
    [anon_sym_LBRACE] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
  },
  [496] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_generic_type] = STATE(53),
    [sym_update_expression] = STATE(643),
    [sym__literal] = STATE(43),
    [sym_class_literal] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_parenthesized_expression] = STATE(43),
    [sym_binary_expression] = STATE(643),
    [sym__expression] = STATE(643),
    [sym_method_invocation] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_formal_parameters] = STATE(42),
    [sym_annotated_type] = STATE(37),
    [sym_lambda_expression] = STATE(643),
    [sym__unannotated_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_array_access] = STATE(39),
    [sym_integral_type] = STATE(30),
    [sym__type] = STATE(37),
    [sym__primary] = STATE(41),
    [sym_object_creation_expression] = STATE(43),
    [sym_instanceof_expression] = STATE(643),
    [sym_ternary_expression] = STATE(643),
    [sym_cast_expression] = STATE(643),
    [sym_array_creation_expression] = STATE(41),
    [sym_unary_expression] = STATE(643),
    [sym_array_type] = STATE(73),
    [sym_scoped_identifier] = STATE(52),
    [sym_method_reference] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(74),
    [sym_assignment_expression] = STATE(643),
    [sym_annotation] = STATE(74),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_float] = ACTIONS(41),
    [sym_super] = ACTIONS(9),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [sym_false] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_string_literal] = ACTIONS(35),
    [sym_true] = ACTIONS(5),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(41),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_open] = ACTIONS(120),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_module] = ACTIONS(120),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_new] = ACTIONS(19),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_short] = ACTIONS(33),
  },
  [497] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(1545),
    [anon_sym_COMMA] = ACTIONS(1545),
  },
  [498] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(1547),
    [anon_sym_COMMA] = ACTIONS(1547),
  },
  [499] = {
    [anon_sym_GT] = ACTIONS(1549),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1549),
  },
  [500] = {
    [anon_sym_module] = ACTIONS(1551),
    [anon_sym_char] = ACTIONS(1551),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(1551),
    [anon_sym_long] = ACTIONS(1551),
    [anon_sym_RPAREN] = ACTIONS(1553),
    [anon_sym_implements] = ACTIONS(1551),
    [anon_sym_int] = ACTIONS(1551),
    [anon_sym_GT] = ACTIONS(1553),
    [anon_sym_AMP] = ACTIONS(1553),
    [anon_sym_open] = ACTIONS(1551),
    [anon_sym_byte] = ACTIONS(1551),
    [anon_sym_LBRACE] = ACTIONS(1553),
    [anon_sym_LBRACK] = ACTIONS(1553),
    [sym_void_type] = ACTIONS(1551),
    [anon_sym_COMMA] = ACTIONS(1553),
    [sym_boolean_type] = ACTIONS(1551),
    [anon_sym_COLON_COLON] = ACTIONS(1553),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1553),
    [anon_sym_short] = ACTIONS(1551),
    [anon_sym_AT] = ACTIONS(1553),
    [anon_sym_new] = ACTIONS(1551),
    [anon_sym_SEMI] = ACTIONS(1553),
    [sym_super] = ACTIONS(1551),
    [anon_sym_double] = ACTIONS(1551),
    [anon_sym_PIPE] = ACTIONS(1553),
    [sym_this] = ACTIONS(1551),
    [anon_sym_float] = ACTIONS(1551),
    [anon_sym_DOT] = ACTIONS(1551),
    [anon_sym_LPAREN] = ACTIONS(1553),
  },
  [501] = {
    [aux_sym_type_arguments_repeat1] = STATE(501),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(1549),
    [anon_sym_COMMA] = ACTIONS(1555),
  },
  [502] = {
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_COMMA] = ACTIONS(1558),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_SLASH] = ACTIONS(299),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_RPAREN] = ACTIONS(1558),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_SEMI] = ACTIONS(1558),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(291),
  },
  [503] = {
    [anon_sym_GT_GT] = ACTIONS(1560),
    [anon_sym_COLON_COLON] = ACTIONS(1562),
    [anon_sym_LT_EQ] = ACTIONS(1562),
    [anon_sym_STAR] = ACTIONS(1562),
    [anon_sym_SLASH] = ACTIONS(1560),
    [anon_sym_PERCENT] = ACTIONS(1562),
    [anon_sym_LBRACK] = ACTIONS(1562),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT_LT] = ACTIONS(1562),
    [anon_sym_LBRACE] = ACTIONS(1562),
    [anon_sym_DASH] = ACTIONS(1560),
    [anon_sym_RBRACE] = ACTIONS(1562),
    [anon_sym_EQ_EQ] = ACTIONS(1562),
    [anon_sym_instanceof] = ACTIONS(1562),
    [anon_sym_RBRACK] = ACTIONS(1562),
    [anon_sym_QMARK] = ACTIONS(1562),
    [anon_sym_GT_EQ] = ACTIONS(1562),
    [anon_sym_COLON] = ACTIONS(1560),
    [anon_sym_SEMI] = ACTIONS(1562),
    [anon_sym_CARET] = ACTIONS(1562),
    [anon_sym_PIPE_PIPE] = ACTIONS(1562),
    [anon_sym_AMP] = ACTIONS(1560),
    [anon_sym_PLUS] = ACTIONS(1560),
    [anon_sym_PIPE] = ACTIONS(1560),
    [anon_sym_AMP_AMP] = ACTIONS(1562),
    [anon_sym_GT] = ACTIONS(1560),
    [anon_sym_DOT] = ACTIONS(1562),
    [anon_sym_COMMA] = ACTIONS(1562),
    [anon_sym_LT] = ACTIONS(1560),
    [anon_sym_GT_GT_GT] = ACTIONS(1562),
    [anon_sym_DASH_DASH] = ACTIONS(1562),
    [anon_sym_PLUS_PLUS] = ACTIONS(1562),
    [anon_sym_BANG_EQ] = ACTIONS(1562),
    [anon_sym_RPAREN] = ACTIONS(1562),
  },
  [504] = {
    [aux_sym_argument_list_repeat1] = STATE(504),
    [anon_sym_COMMA] = ACTIONS(1564),
    [anon_sym_RPAREN] = ACTIONS(1558),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1558),
  },
  [505] = {
    [sym_argument_list] = STATE(644),
    [anon_sym_QMARK] = ACTIONS(1567),
    [anon_sym_COLON_COLON] = ACTIONS(1567),
    [anon_sym_instanceof] = ACTIONS(1567),
    [anon_sym_GT_GT_GT] = ACTIONS(1569),
    [anon_sym_COMMA] = ACTIONS(1567),
    [anon_sym_PIPE_EQ] = ACTIONS(1567),
    [anon_sym_LBRACK] = ACTIONS(1567),
    [anon_sym_SEMI] = ACTIONS(1567),
    [anon_sym_CARET_EQ] = ACTIONS(1567),
    [anon_sym_LT_LT] = ACTIONS(1569),
    [anon_sym_BANG_EQ] = ACTIONS(1567),
    [anon_sym_LT_EQ] = ACTIONS(1567),
    [anon_sym_PLUS] = ACTIONS(1569),
    [anon_sym_PIPE] = ACTIONS(1569),
    [anon_sym_DASH_DASH] = ACTIONS(1567),
    [anon_sym_GT_EQ] = ACTIONS(1567),
    [anon_sym_EQ] = ACTIONS(1569),
    [anon_sym_DOT] = ACTIONS(1567),
    [anon_sym_RPAREN] = ACTIONS(1567),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1567),
    [anon_sym_STAR] = ACTIONS(1569),
    [anon_sym_PIPE_PIPE] = ACTIONS(1567),
    [anon_sym_PLUS_PLUS] = ACTIONS(1567),
    [anon_sym_STAR_EQ] = ACTIONS(1567),
    [anon_sym_GT_GT_EQ] = ACTIONS(1567),
    [anon_sym_PERCENT] = ACTIONS(1569),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1569),
    [anon_sym_GT] = ACTIONS(1569),
    [anon_sym_AMP_AMP] = ACTIONS(1567),
    [anon_sym_LT] = ACTIONS(1569),
    [anon_sym_DASH] = ACTIONS(1569),
    [anon_sym_RBRACK] = ACTIONS(1567),
    [anon_sym_AMP] = ACTIONS(1569),
    [anon_sym_EQ_EQ] = ACTIONS(1567),
    [anon_sym_SLASH] = ACTIONS(1569),
    [anon_sym_CARET] = ACTIONS(1569),
    [anon_sym_RBRACE] = ACTIONS(1567),
    [anon_sym_PERCENT_EQ] = ACTIONS(1567),
    [anon_sym_GT_GT] = ACTIONS(1569),
    [anon_sym_DASH_EQ] = ACTIONS(1567),
    [anon_sym_SLASH_EQ] = ACTIONS(1567),
    [anon_sym_PLUS_EQ] = ACTIONS(1567),
    [anon_sym_LT_LT_EQ] = ACTIONS(1567),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_AMP_EQ] = ACTIONS(1567),
  },
  [506] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(1571),
  },
  [507] = {
    [anon_sym_LBRACK] = ACTIONS(1573),
    [anon_sym_GT] = ACTIONS(1575),
    [anon_sym_RPAREN] = ACTIONS(1573),
    [anon_sym_AMP_AMP] = ACTIONS(1573),
    [anon_sym_SEMI] = ACTIONS(1573),
    [anon_sym_EQ_EQ] = ACTIONS(1573),
    [anon_sym_LT_LT] = ACTIONS(1573),
    [anon_sym_PLUS] = ACTIONS(1575),
    [anon_sym_DASH] = ACTIONS(1575),
    [anon_sym_PLUS_PLUS] = ACTIONS(1573),
    [anon_sym_SLASH] = ACTIONS(1575),
    [anon_sym_LT] = ACTIONS(1575),
    [anon_sym_PERCENT] = ACTIONS(1573),
    [anon_sym_RBRACK] = ACTIONS(1573),
    [anon_sym_GT_GT] = ACTIONS(1575),
    [anon_sym_BANG_EQ] = ACTIONS(1573),
    [anon_sym_RBRACE] = ACTIONS(1573),
    [anon_sym_STAR] = ACTIONS(1573),
    [anon_sym_LT_EQ] = ACTIONS(1573),
    [anon_sym_PIPE] = ACTIONS(1575),
    [anon_sym_COLON] = ACTIONS(1575),
    [anon_sym_PIPE_PIPE] = ACTIONS(1573),
    [anon_sym_DASH_DASH] = ACTIONS(1573),
    [anon_sym_CARET] = ACTIONS(1573),
    [anon_sym_DOT] = ACTIONS(1573),
    [anon_sym_COMMA] = ACTIONS(1573),
    [anon_sym_QMARK] = ACTIONS(1573),
    [anon_sym_COLON_COLON] = ACTIONS(1573),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_GT_GT] = ACTIONS(1573),
    [anon_sym_AMP] = ACTIONS(1575),
    [anon_sym_instanceof] = ACTIONS(1573),
    [anon_sym_GT_EQ] = ACTIONS(1573),
  },
  [508] = {
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(1577),
  },
  [509] = {
    [anon_sym_protected] = ACTIONS(1579),
    [anon_sym_abstract] = ACTIONS(1579),
    [anon_sym_native] = ACTIONS(1579),
    [anon_sym_final] = ACTIONS(1579),
    [anon_sym_byte] = ACTIONS(1579),
    [anon_sym_strictfp] = ACTIONS(1579),
    [anon_sym_short] = ACTIONS(1579),
    [anon_sym_int] = ACTIONS(1579),
    [anon_sym_long] = ACTIONS(1579),
    [anon_sym_char] = ACTIONS(1579),
    [sym_identifier] = ACTIONS(1579),
    [anon_sym_transient] = ACTIONS(1579),
    [anon_sym_RPAREN] = ACTIONS(1581),
    [anon_sym_public] = ACTIONS(1579),
    [anon_sym_volatile] = ACTIONS(1579),
    [anon_sym_private] = ACTIONS(1579),
    [anon_sym_double] = ACTIONS(1579),
    [anon_sym_static] = ACTIONS(1579),
    [anon_sym_float] = ACTIONS(1579),
    [anon_sym_AT] = ACTIONS(1581),
    [anon_sym_synchronized] = ACTIONS(1579),
    [sym_boolean_type] = ACTIONS(1579),
    [anon_sym_COMMA] = ACTIONS(1581),
    [sym_void_type] = ACTIONS(1579),
    [sym_comment] = ACTIONS(3),
    [anon_sym_default] = ACTIONS(1579),
  },
  [510] = {
    [anon_sym_GT_EQ] = ACTIONS(1583),
    [anon_sym_RPAREN] = ACTIONS(1583),
    [anon_sym_EQ_EQ] = ACTIONS(1583),
    [anon_sym_DASH] = ACTIONS(1585),
    [anon_sym_PLUS] = ACTIONS(1585),
    [anon_sym_LT_LT] = ACTIONS(1583),
    [anon_sym_COMMA] = ACTIONS(1583),
    [anon_sym_BANG_EQ] = ACTIONS(1583),
    [anon_sym_CARET] = ACTIONS(1583),
    [anon_sym_PIPE_PIPE] = ACTIONS(1583),
    [anon_sym_AMP] = ACTIONS(1585),
    [anon_sym_GT] = ACTIONS(1585),
    [anon_sym_PIPE] = ACTIONS(1585),
    [anon_sym_GT_GT] = ACTIONS(1585),
    [anon_sym_QMARK] = ACTIONS(1583),
    [anon_sym_RBRACK] = ACTIONS(1583),
    [anon_sym_GT_GT_GT] = ACTIONS(1583),
    [anon_sym_instanceof] = ACTIONS(1583),
    [anon_sym_COLON] = ACTIONS(1583),
    [anon_sym_STAR] = ACTIONS(1583),
    [anon_sym_LT_EQ] = ACTIONS(1583),
    [anon_sym_AMP_AMP] = ACTIONS(1583),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(1585),
    [anon_sym_SEMI] = ACTIONS(1583),
    [anon_sym_SLASH] = ACTIONS(1585),
    [anon_sym_PLUS_PLUS] = ACTIONS(1583),
    [anon_sym_PERCENT] = ACTIONS(1583),
    [anon_sym_RBRACE] = ACTIONS(1583),
    [anon_sym_DASH_DASH] = ACTIONS(1583),
  },
  [511] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(1587),
    [anon_sym_AT] = ACTIONS(1587),
    [anon_sym_SEMI] = ACTIONS(1587),
    [anon_sym_LBRACE] = ACTIONS(1587),
    [anon_sym_throws] = ACTIONS(1587),
    [anon_sym_DASH_GT] = ACTIONS(1587),
  },
  [512] = {
    [anon_sym_RPAREN] = ACTIONS(1589),
    [sym_comment] = ACTIONS(3),
  },
  [513] = {
    [sym_modifiers] = STATE(84),
    [sym_generic_type] = STATE(53),
    [sym_array_type] = STATE(213),
    [sym_formal_parameter] = STATE(366),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__annotation] = STATE(902),
    [sym_spread_parameter] = STATE(648),
    [sym__unannotated_type] = STATE(213),
    [sym_floating_point_type] = STATE(213),
    [sym_integral_type] = STATE(213),
    [sym_annotation] = STATE(902),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_marker_annotation] = STATE(902),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [sym_void_type] = ACTIONS(417),
    [sym_comment] = ACTIONS(3),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(1589),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [sym_boolean_type] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
  },
  [514] = {
    [anon_sym_RPAREN] = ACTIONS(1591),
    [sym_comment] = ACTIONS(3),
  },
  [515] = {
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_annotation] = STATE(902),
    [sym_marker_annotation] = STATE(902),
    [sym_modifiers] = STATE(650),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_formal_parameter] = STATE(366),
    [sym_generic_type] = STATE(53),
    [sym_integral_type] = STATE(649),
    [sym_floating_point_type] = STATE(649),
    [sym__unannotated_type] = STATE(649),
    [sym_array_type] = STATE(649),
    [sym__annotation] = STATE(902),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [sym_boolean_type] = ACTIONS(1593),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
    [sym_void_type] = ACTIONS(1593),
  },
  [516] = {
    [anon_sym_DASH_DASH] = ACTIONS(1595),
    [anon_sym_assert] = ACTIONS(1597),
    [sym_hex_integer_literal] = ACTIONS(1597),
    [sym_false] = ACTIONS(1597),
    [sym_super] = ACTIONS(1597),
    [sym_decimal_integer_literal] = ACTIONS(1597),
    [anon_sym_public] = ACTIONS(1597),
    [anon_sym_transient] = ACTIONS(1597),
    [anon_sym_byte] = ACTIONS(1597),
    [anon_sym_break] = ACTIONS(1597),
    [anon_sym_char] = ACTIONS(1597),
    [anon_sym_throw] = ACTIONS(1597),
    [anon_sym_do] = ACTIONS(1597),
    [anon_sym_try] = ACTIONS(1597),
    [anon_sym_package] = ACTIONS(1597),
    [anon_sym_abstract] = ACTIONS(1597),
    [anon_sym_enum] = ACTIONS(1597),
    [sym_boolean_type] = ACTIONS(1597),
    [anon_sym_LPAREN] = ACTIONS(1595),
    [anon_sym_double] = ACTIONS(1597),
    [anon_sym_AT] = ACTIONS(1597),
    [anon_sym_BANG] = ACTIONS(1595),
    [anon_sym_TILDE] = ACTIONS(1595),
    [anon_sym_interface] = ACTIONS(1597),
    [anon_sym_strictfp] = ACTIONS(1597),
    [anon_sym_DASH] = ACTIONS(1597),
    [anon_sym_float] = ACTIONS(1597),
    [anon_sym_switch] = ACTIONS(1597),
    [anon_sym_new] = ACTIONS(1597),
    [anon_sym_while] = ACTIONS(1597),
    [anon_sym_private] = ACTIONS(1597),
    [anon_sym_final] = ACTIONS(1597),
    [anon_sym_volatile] = ACTIONS(1597),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(1597),
    [sym_void_type] = ACTIONS(1597),
    [sym_hex_floating_point_literal] = ACTIONS(1597),
    [sym_true] = ACTIONS(1597),
    [anon_sym_LBRACE] = ACTIONS(1595),
    [anon_sym_protected] = ACTIONS(1597),
    [anon_sym_int] = ACTIONS(1597),
    [anon_sym_module] = ACTIONS(1597),
    [anon_sym_default] = ACTIONS(1597),
    [anon_sym_SEMI] = ACTIONS(1595),
    [sym_binary_integer_literal] = ACTIONS(1595),
    [ts_builtin_sym_end] = ACTIONS(1595),
    [anon_sym_return] = ACTIONS(1597),
    [anon_sym_class] = ACTIONS(1597),
    [sym_octal_integer_literal] = ACTIONS(1595),
    [anon_sym_short] = ACTIONS(1597),
    [sym_string_literal] = ACTIONS(1595),
    [anon_sym_else] = ACTIONS(1597),
    [sym_character_literal] = ACTIONS(1595),
    [anon_sym_open] = ACTIONS(1597),
    [anon_sym_PLUS] = ACTIONS(1597),
    [anon_sym_static] = ACTIONS(1597),
    [anon_sym_long] = ACTIONS(1597),
    [anon_sym_RBRACE] = ACTIONS(1595),
    [anon_sym_PLUS_PLUS] = ACTIONS(1595),
    [anon_sym_native] = ACTIONS(1597),
    [sym_this] = ACTIONS(1597),
    [sym_decimal_floating_point_literal] = ACTIONS(1595),
    [sym_null_literal] = ACTIONS(1597),
    [anon_sym_synchronized] = ACTIONS(1597),
    [anon_sym_if] = ACTIONS(1597),
    [anon_sym_for] = ACTIONS(1597),
    [anon_sym_import] = ACTIONS(1597),
    [anon_sym_ATinterface] = ACTIONS(1595),
    [anon_sym_continue] = ACTIONS(1597),
    [anon_sym_case] = ACTIONS(1597),
  },
  [517] = {
    [sym_boolean_type] = ACTIONS(1599),
    [anon_sym_LPAREN] = ACTIONS(1601),
    [anon_sym_class] = ACTIONS(1599),
    [anon_sym_AT] = ACTIONS(1599),
    [anon_sym_if] = ACTIONS(1599),
    [anon_sym_open] = ACTIONS(1599),
    [anon_sym_native] = ACTIONS(1599),
    [sym_character_literal] = ACTIONS(1601),
    [anon_sym_new] = ACTIONS(1599),
    [anon_sym_public] = ACTIONS(1599),
    [anon_sym_short] = ACTIONS(1599),
    [anon_sym_DASH_DASH] = ACTIONS(1601),
    [anon_sym_int] = ACTIONS(1599),
    [anon_sym_SEMI] = ACTIONS(1601),
    [anon_sym_long] = ACTIONS(1599),
    [anon_sym_case] = ACTIONS(1599),
    [anon_sym_byte] = ACTIONS(1599),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1601),
    [anon_sym_continue] = ACTIONS(1599),
    [anon_sym_return] = ACTIONS(1599),
    [sym_this] = ACTIONS(1599),
    [anon_sym_interface] = ACTIONS(1599),
    [anon_sym_final] = ACTIONS(1599),
    [sym_hex_floating_point_literal] = ACTIONS(1599),
    [anon_sym_package] = ACTIONS(1599),
    [sym_super] = ACTIONS(1599),
    [anon_sym_TILDE] = ACTIONS(1601),
    [sym_binary_integer_literal] = ACTIONS(1601),
    [anon_sym_synchronized] = ACTIONS(1599),
    [anon_sym_throw] = ACTIONS(1599),
    [anon_sym_strictfp] = ACTIONS(1599),
    [sym_string_literal] = ACTIONS(1601),
    [sym_null_literal] = ACTIONS(1599),
    [anon_sym_while] = ACTIONS(1599),
    [anon_sym_else] = ACTIONS(1599),
    [anon_sym_switch] = ACTIONS(1599),
    [anon_sym_PLUS] = ACTIONS(1599),
    [anon_sym_default] = ACTIONS(1599),
    [anon_sym_double] = ACTIONS(1599),
    [sym_hex_integer_literal] = ACTIONS(1599),
    [anon_sym_assert] = ACTIONS(1599),
    [anon_sym_abstract] = ACTIONS(1599),
    [anon_sym_volatile] = ACTIONS(1599),
    [anon_sym_try] = ACTIONS(1599),
    [anon_sym_for] = ACTIONS(1599),
    [anon_sym_DASH] = ACTIONS(1599),
    [sym_octal_integer_literal] = ACTIONS(1601),
    [sym_decimal_floating_point_literal] = ACTIONS(1601),
    [anon_sym_module] = ACTIONS(1599),
    [anon_sym_transient] = ACTIONS(1599),
    [anon_sym_enum] = ACTIONS(1599),
    [sym_true] = ACTIONS(1599),
    [anon_sym_LBRACE] = ACTIONS(1601),
    [anon_sym_import] = ACTIONS(1599),
    [anon_sym_break] = ACTIONS(1599),
    [ts_builtin_sym_end] = ACTIONS(1601),
    [anon_sym_char] = ACTIONS(1599),
    [anon_sym_ATinterface] = ACTIONS(1601),
    [anon_sym_do] = ACTIONS(1599),
    [sym_void_type] = ACTIONS(1599),
    [anon_sym_BANG] = ACTIONS(1601),
    [anon_sym_float] = ACTIONS(1599),
    [anon_sym_static] = ACTIONS(1599),
    [anon_sym_PLUS_PLUS] = ACTIONS(1601),
    [anon_sym_protected] = ACTIONS(1599),
    [anon_sym_private] = ACTIONS(1599),
    [sym_decimal_integer_literal] = ACTIONS(1599),
    [sym_identifier] = ACTIONS(1599),
    [sym_false] = ACTIONS(1599),
  },
  [518] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym__type] = STATE(651),
    [sym_annotated_type] = STATE(651),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_generic_type] = STATE(53),
    [sym__annotation] = STATE(74),
    [sym_integral_type] = STATE(73),
    [sym_floating_point_type] = STATE(73),
    [sym_annotation] = STATE(74),
    [sym_marker_annotation] = STATE(74),
    [sym_array_type] = STATE(73),
    [sym__unannotated_type] = STATE(73),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_byte] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(334),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [sym_void_type] = ACTIONS(334),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_float] = ACTIONS(41),
  },
  [519] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(1603),
    [anon_sym_COMMA] = ACTIONS(1603),
  },
  [520] = {
    [sym_type_bound] = STATE(652),
    [anon_sym_COMMA] = ACTIONS(1603),
    [anon_sym_GT] = ACTIONS(1603),
    [anon_sym_extends] = ACTIONS(1226),
    [sym_comment] = ACTIONS(3),
  },
  [521] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(1605),
    [sym_boolean_type] = ACTIONS(1605),
    [sym_void_type] = ACTIONS(1605),
    [anon_sym_AT] = ACTIONS(1607),
    [anon_sym_extends] = ACTIONS(1605),
    [anon_sym_byte] = ACTIONS(1605),
    [anon_sym_double] = ACTIONS(1605),
    [anon_sym_implements] = ACTIONS(1605),
    [anon_sym_short] = ACTIONS(1605),
    [anon_sym_int] = ACTIONS(1605),
    [anon_sym_char] = ACTIONS(1605),
    [anon_sym_LBRACE] = ACTIONS(1607),
    [sym_identifier] = ACTIONS(1605),
    [anon_sym_long] = ACTIONS(1605),
  },
  [522] = {
    [sym_marker_annotation] = STATE(372),
    [sym__annotation] = STATE(372),
    [aux_sym_dimensions_expr_repeat1] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym_type_parameter] = STATE(653),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(893),
  },
  [523] = {
    [aux_sym_type_parameters_repeat1] = STATE(655),
    [anon_sym_GT] = ACTIONS(1609),
    [anon_sym_COMMA] = ACTIONS(1234),
    [sym_comment] = ACTIONS(3),
  },
  [524] = {
    [anon_sym_float] = ACTIONS(1611),
    [sym_identifier] = ACTIONS(1611),
    [anon_sym_public] = ACTIONS(1611),
    [anon_sym_int] = ACTIONS(1611),
    [anon_sym_strictfp] = ACTIONS(1611),
    [anon_sym_private] = ACTIONS(1611),
    [sym_void_type] = ACTIONS(1611),
    [anon_sym_LT] = ACTIONS(1613),
    [anon_sym_long] = ACTIONS(1611),
    [anon_sym_abstract] = ACTIONS(1611),
    [anon_sym_enum] = ACTIONS(1611),
    [anon_sym_RBRACE] = ACTIONS(1613),
    [anon_sym_interface] = ACTIONS(1611),
    [anon_sym_SEMI] = ACTIONS(1613),
    [anon_sym_LBRACE] = ACTIONS(1613),
    [anon_sym_ATinterface] = ACTIONS(1613),
    [anon_sym_byte] = ACTIONS(1611),
    [anon_sym_class] = ACTIONS(1611),
    [sym_comment] = ACTIONS(3),
    [anon_sym_char] = ACTIONS(1611),
    [anon_sym_default] = ACTIONS(1611),
    [anon_sym_AT] = ACTIONS(1611),
    [anon_sym_final] = ACTIONS(1611),
    [anon_sym_volatile] = ACTIONS(1611),
    [anon_sym_protected] = ACTIONS(1611),
    [sym_boolean_type] = ACTIONS(1611),
    [anon_sym_transient] = ACTIONS(1611),
    [anon_sym_double] = ACTIONS(1611),
    [anon_sym_short] = ACTIONS(1611),
    [anon_sym_native] = ACTIONS(1611),
    [anon_sym_synchronized] = ACTIONS(1611),
    [anon_sym_static] = ACTIONS(1611),
  },
  [525] = {
    [sym_modifiers] = STATE(84),
    [sym__unannotated_type] = STATE(656),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_array_type] = STATE(656),
    [sym_receiver_parameter] = STATE(83),
    [aux_sym_dimensions_expr_repeat1] = STATE(657),
    [sym_spread_parameter] = STATE(86),
    [sym_generic_type] = STATE(53),
    [sym_formal_parameter] = STATE(85),
    [sym_annotation] = STATE(903),
    [sym_integral_type] = STATE(656),
    [sym_floating_point_type] = STATE(656),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__annotation] = STATE(903),
    [sym_marker_annotation] = STATE(903),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [sym_boolean_type] = ACTIONS(1615),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_final] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [sym_void_type] = ACTIONS(1615),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(132),
    [anon_sym_COMMA] = ACTIONS(130),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(126),
  },
  [526] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1617),
    [anon_sym_throws] = ACTIONS(1617),
  },
  [527] = {
    [sym_for_statement] = STATE(668),
    [sym_annotation] = STATE(51),
    [sym_field_access] = STATE(39),
    [sym_method_invocation] = STATE(43),
    [sym_marker_annotation] = STATE(51),
    [sym_floating_point_type] = STATE(30),
    [sym_labeled_statement] = STATE(668),
    [sym_while_statement] = STATE(668),
    [sym_do_statement] = STATE(668),
    [sym_array_access] = STATE(39),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_import_declaration] = STATE(668),
    [sym_inferred_parameters] = STATE(42),
    [sym_modifiers] = STATE(48),
    [sym_switch_statement] = STATE(668),
    [sym_package_declaration] = STATE(668),
    [sym_class_literal] = STATE(43),
    [sym__annotation] = STATE(51),
    [sym_throw_statement] = STATE(668),
    [sym__unannotated_type] = STATE(40),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__type] = STATE(37),
    [sym_local_variable_declaration_statement] = STATE(668),
    [sym_try_with_resources_statement] = STATE(668),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_interface_declaration] = STATE(668),
    [sym_expression_statement] = STATE(668),
    [sym_binary_expression] = STATE(49),
    [sym_if_statement] = STATE(668),
    [sym_block] = STATE(668),
    [sym_type_arguments] = STATE(665),
    [sym_return_statement] = STATE(668),
    [sym_method_reference] = STATE(43),
    [sym_enhanced_for_statement] = STATE(668),
    [sym_annotated_type] = STATE(37),
    [sym_cast_expression] = STATE(49),
    [sym_assert_statement] = STATE(668),
    [sym_array_creation_expression] = STATE(667),
    [sym_continue_statement] = STATE(668),
    [sym_ternary_expression] = STATE(49),
    [sym_break_statement] = STATE(668),
    [sym_module_declaration] = STATE(668),
    [sym_object_creation_expression] = STATE(43),
    [sym_assignment_expression] = STATE(49),
    [sym__primary] = STATE(667),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [aux_sym_program_repeat1] = STATE(668),
    [sym__literal] = STATE(43),
    [sym_lambda_expression] = STATE(49),
    [sym_update_expression] = STATE(49),
    [sym_synchronized_statement] = STATE(668),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__declaration] = STATE(668),
    [sym_class_declaration] = STATE(668),
    [sym__expression] = STATE(49),
    [sym_local_variable_declaration] = STATE(47),
    [sym__primary_no_new_array] = STATE(43),
    [sym_array_type] = STATE(40),
    [sym_generic_type] = STATE(53),
    [sym_scoped_identifier] = STATE(664),
    [sym_unary_expression] = STATE(49),
    [sym_integral_type] = STATE(30),
    [sym_try_statement] = STATE(668),
    [sym_parenthesized_expression] = STATE(43),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_enum_declaration] = STATE(668),
    [sym_formal_parameters] = STATE(42),
    [sym_instanceof_expression] = STATE(49),
    [sym_explicit_constructor_invocation] = STATE(666),
    [anon_sym_byte] = ACTIONS(33),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_interface] = ACTIONS(39),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_final] = ACTIONS(7),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_RBRACE] = ACTIONS(1619),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_strictfp] = ACTIONS(7),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_public] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_open] = ACTIONS(1621),
    [sym_this] = ACTIONS(1623),
    [anon_sym_module] = ACTIONS(1625),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_native] = ACTIONS(7),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_char] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(67),
    [sym_false] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_abstract] = ACTIONS(7),
    [sym_true] = ACTIONS(5),
    [sym_super] = ACTIONS(1627),
    [anon_sym_SEMI] = ACTIONS(1629),
    [anon_sym_int] = ACTIONS(33),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_short] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(45),
    [sym_identifier] = ACTIONS(1631),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(29),
  },
  [528] = {
    [sym__unannotated_type] = STATE(73),
    [sym_integral_type] = STATE(73),
    [sym_array_type] = STATE(73),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotated_type] = STATE(669),
    [sym_annotation] = STATE(74),
    [sym_generic_type] = STATE(53),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__annotation] = STATE(74),
    [sym__type] = STATE(669),
    [sym_floating_point_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(334),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_short] = ACTIONS(33),
    [sym_void_type] = ACTIONS(334),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
  },
  [529] = {
    [sym_constructor_body] = STATE(670),
    [anon_sym_LBRACE] = ACTIONS(1242),
    [sym_comment] = ACTIONS(3),
  },
  [530] = {
    [anon_sym_class] = ACTIONS(1633),
    [anon_sym_LBRACE] = ACTIONS(1635),
    [anon_sym_int] = ACTIONS(1633),
    [anon_sym_SEMI] = ACTIONS(1635),
    [anon_sym_float] = ACTIONS(1633),
    [anon_sym_abstract] = ACTIONS(1633),
    [anon_sym_LT] = ACTIONS(1635),
    [anon_sym_default] = ACTIONS(1633),
    [anon_sym_native] = ACTIONS(1633),
    [anon_sym_interface] = ACTIONS(1633),
    [anon_sym_synchronized] = ACTIONS(1633),
    [anon_sym_byte] = ACTIONS(1633),
    [anon_sym_ATinterface] = ACTIONS(1635),
    [anon_sym_strictfp] = ACTIONS(1633),
    [anon_sym_short] = ACTIONS(1633),
    [anon_sym_char] = ACTIONS(1633),
    [anon_sym_static] = ACTIONS(1633),
    [anon_sym_AT] = ACTIONS(1633),
    [anon_sym_transient] = ACTIONS(1633),
    [anon_sym_public] = ACTIONS(1633),
    [sym_identifier] = ACTIONS(1633),
    [sym_void_type] = ACTIONS(1633),
    [anon_sym_protected] = ACTIONS(1633),
    [anon_sym_final] = ACTIONS(1633),
    [anon_sym_RBRACE] = ACTIONS(1635),
    [anon_sym_enum] = ACTIONS(1633),
    [anon_sym_double] = ACTIONS(1633),
    [anon_sym_private] = ACTIONS(1633),
    [anon_sym_long] = ACTIONS(1633),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(1633),
    [anon_sym_volatile] = ACTIONS(1633),
  },
  [531] = {
    [anon_sym_protected] = ACTIONS(1637),
    [anon_sym_native] = ACTIONS(1637),
    [anon_sym_interface] = ACTIONS(1637),
    [anon_sym_float] = ACTIONS(1637),
    [anon_sym_short] = ACTIONS(1637),
    [anon_sym_LT] = ACTIONS(1639),
    [anon_sym_char] = ACTIONS(1637),
    [anon_sym_strictfp] = ACTIONS(1637),
    [anon_sym_static] = ACTIONS(1637),
    [anon_sym_volatile] = ACTIONS(1637),
    [anon_sym_private] = ACTIONS(1637),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(1637),
    [anon_sym_synchronized] = ACTIONS(1637),
    [anon_sym_public] = ACTIONS(1637),
    [anon_sym_int] = ACTIONS(1637),
    [anon_sym_RBRACE] = ACTIONS(1639),
    [anon_sym_SEMI] = ACTIONS(1639),
    [anon_sym_ATinterface] = ACTIONS(1639),
    [anon_sym_transient] = ACTIONS(1637),
    [anon_sym_long] = ACTIONS(1637),
    [anon_sym_default] = ACTIONS(1637),
    [anon_sym_byte] = ACTIONS(1637),
    [anon_sym_class] = ACTIONS(1637),
    [sym_identifier] = ACTIONS(1637),
    [anon_sym_double] = ACTIONS(1637),
    [anon_sym_AT] = ACTIONS(1637),
    [anon_sym_enum] = ACTIONS(1637),
    [anon_sym_abstract] = ACTIONS(1637),
    [anon_sym_LBRACE] = ACTIONS(1639),
    [anon_sym_final] = ACTIONS(1637),
    [sym_void_type] = ACTIONS(1637),
  },
  [532] = {
    [anon_sym_short] = ACTIONS(1641),
    [anon_sym_long] = ACTIONS(1641),
    [anon_sym_private] = ACTIONS(1641),
    [anon_sym_SEMI] = ACTIONS(1643),
    [anon_sym_enum] = ACTIONS(1641),
    [anon_sym_protected] = ACTIONS(1641),
    [anon_sym_char] = ACTIONS(1641),
    [anon_sym_int] = ACTIONS(1641),
    [anon_sym_LT] = ACTIONS(1643),
    [anon_sym_float] = ACTIONS(1641),
    [anon_sym_double] = ACTIONS(1641),
    [sym_boolean_type] = ACTIONS(1641),
    [anon_sym_interface] = ACTIONS(1641),
    [sym_identifier] = ACTIONS(1641),
    [anon_sym_default] = ACTIONS(1641),
    [anon_sym_class] = ACTIONS(1641),
    [sym_void_type] = ACTIONS(1641),
    [anon_sym_public] = ACTIONS(1641),
    [anon_sym_AT] = ACTIONS(1641),
    [anon_sym_transient] = ACTIONS(1641),
    [anon_sym_LBRACE] = ACTIONS(1643),
    [anon_sym_strictfp] = ACTIONS(1641),
    [anon_sym_abstract] = ACTIONS(1641),
    [anon_sym_volatile] = ACTIONS(1641),
    [anon_sym_ATinterface] = ACTIONS(1643),
    [anon_sym_native] = ACTIONS(1641),
    [anon_sym_static] = ACTIONS(1641),
    [anon_sym_final] = ACTIONS(1641),
    [anon_sym_synchronized] = ACTIONS(1641),
    [sym_comment] = ACTIONS(3),
    [anon_sym_byte] = ACTIONS(1641),
    [anon_sym_RBRACE] = ACTIONS(1643),
  },
  [533] = {
    [anon_sym_short] = ACTIONS(1645),
    [anon_sym_GT_GT_GT] = ACTIONS(1647),
    [anon_sym_float] = ACTIONS(1645),
    [anon_sym_byte] = ACTIONS(1645),
    [anon_sym_case] = ACTIONS(1645),
    [anon_sym_for] = ACTIONS(1645),
    [anon_sym_GT_EQ] = ACTIONS(1647),
    [anon_sym_static] = ACTIONS(1645),
    [anon_sym_interface] = ACTIONS(1645),
    [anon_sym_PLUS] = ACTIONS(1645),
    [sym_null_literal] = ACTIONS(1645),
    [sym_binary_integer_literal] = ACTIONS(1647),
    [anon_sym_PIPE_PIPE] = ACTIONS(1647),
    [anon_sym_AT] = ACTIONS(1645),
    [anon_sym_open] = ACTIONS(1645),
    [anon_sym_AMP_AMP] = ACTIONS(1647),
    [anon_sym_transient] = ACTIONS(1645),
    [anon_sym_LT_LT] = ACTIONS(1647),
    [anon_sym_instanceof] = ACTIONS(1645),
    [anon_sym_COMMA] = ACTIONS(1647),
    [anon_sym_break] = ACTIONS(1645),
    [sym_hex_floating_point_literal] = ACTIONS(1645),
    [anon_sym_else] = ACTIONS(1645),
    [anon_sym_PLUS_PLUS] = ACTIONS(1647),
    [anon_sym_import] = ACTIONS(1645),
    [anon_sym_ATinterface] = ACTIONS(1647),
    [anon_sym_volatile] = ACTIONS(1645),
    [anon_sym_RPAREN] = ACTIONS(1647),
    [anon_sym_return] = ACTIONS(1645),
    [anon_sym_EQ_EQ] = ACTIONS(1647),
    [anon_sym_synchronized] = ACTIONS(1645),
    [anon_sym_package] = ACTIONS(1645),
    [sym_super] = ACTIONS(1645),
    [anon_sym_strictfp] = ACTIONS(1645),
    [anon_sym_LT_EQ] = ACTIONS(1647),
    [anon_sym_AMP] = ACTIONS(1645),
    [anon_sym_class] = ACTIONS(1645),
    [anon_sym_TILDE] = ACTIONS(1647),
    [anon_sym_DASH_DASH] = ACTIONS(1647),
    [anon_sym_PIPE] = ACTIONS(1645),
    [sym_octal_integer_literal] = ACTIONS(1647),
    [anon_sym_QMARK] = ACTIONS(1647),
    [anon_sym_DOT] = ACTIONS(1645),
    [anon_sym_GT] = ACTIONS(1645),
    [anon_sym_CARET] = ACTIONS(1647),
    [anon_sym_RBRACE] = ACTIONS(1647),
    [anon_sym_while] = ACTIONS(1645),
    [anon_sym_default] = ACTIONS(1645),
    [sym_hex_integer_literal] = ACTIONS(1645),
    [sym_false] = ACTIONS(1645),
    [anon_sym_SLASH] = ACTIONS(1645),
    [anon_sym_char] = ACTIONS(1645),
    [anon_sym_do] = ACTIONS(1645),
    [sym_character_literal] = ACTIONS(1647),
    [anon_sym_long] = ACTIONS(1645),
    [ts_builtin_sym_end] = ACTIONS(1647),
    [anon_sym_try] = ACTIONS(1645),
    [anon_sym_BANG_EQ] = ACTIONS(1647),
    [anon_sym_int] = ACTIONS(1645),
    [sym_void_type] = ACTIONS(1645),
    [anon_sym_GT_GT] = ACTIONS(1645),
    [anon_sym_module] = ACTIONS(1645),
    [anon_sym_LPAREN] = ACTIONS(1647),
    [anon_sym_continue] = ACTIONS(1645),
    [anon_sym_COLON_COLON] = ACTIONS(1647),
    [anon_sym_LT] = ACTIONS(1645),
    [anon_sym_SEMI] = ACTIONS(1647),
    [anon_sym_throw] = ACTIONS(1645),
    [anon_sym_new] = ACTIONS(1645),
    [anon_sym_protected] = ACTIONS(1645),
    [sym_this] = ACTIONS(1645),
    [anon_sym_private] = ACTIONS(1645),
    [anon_sym_RBRACK] = ACTIONS(1647),
    [anon_sym_assert] = ACTIONS(1645),
    [anon_sym_native] = ACTIONS(1645),
    [anon_sym_COLON] = ACTIONS(1645),
    [sym_decimal_floating_point_literal] = ACTIONS(1647),
    [anon_sym_BANG] = ACTIONS(1645),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(1645),
    [sym_true] = ACTIONS(1645),
    [anon_sym_abstract] = ACTIONS(1645),
    [anon_sym_STAR] = ACTIONS(1647),
    [anon_sym_public] = ACTIONS(1645),
    [anon_sym_switch] = ACTIONS(1645),
    [sym_boolean_type] = ACTIONS(1645),
    [sym_identifier] = ACTIONS(1645),
    [anon_sym_PERCENT] = ACTIONS(1647),
    [anon_sym_LBRACE] = ACTIONS(1647),
    [anon_sym_if] = ACTIONS(1645),
    [anon_sym_LBRACK] = ACTIONS(1647),
    [anon_sym_DASH] = ACTIONS(1645),
    [anon_sym_enum] = ACTIONS(1645),
    [anon_sym_final] = ACTIONS(1645),
    [anon_sym_double] = ACTIONS(1645),
    [sym_string_literal] = ACTIONS(1647),
  },
  [534] = {
    [sym_block] = STATE(534),
    [sym_field_declaration] = STATE(534),
    [sym_constructor_declaration] = STATE(534),
    [sym_marker_annotation] = STATE(44),
    [sym_annotation] = STATE(44),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_method_declaration] = STATE(534),
    [sym__unannotated_type] = STATE(381),
    [sym_static_initializer] = STATE(534),
    [sym__method_header] = STATE(378),
    [sym_generic_type] = STATE(53),
    [sym_array_type] = STATE(381),
    [sym_integral_type] = STATE(381),
    [sym__annotation] = STATE(44),
    [sym_constructor_declarator] = STATE(377),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_type_parameters] = STATE(382),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_class_declaration] = STATE(534),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_interface_declaration] = STATE(534),
    [aux_sym_enum_body_declarations_repeat1] = STATE(534),
    [sym_enum_declaration] = STATE(534),
    [sym_modifiers] = STATE(380),
    [sym_floating_point_type] = STATE(381),
    [anon_sym_class] = ACTIONS(1649),
    [sym_identifier] = ACTIONS(1652),
    [anon_sym_protected] = ACTIONS(1655),
    [anon_sym_volatile] = ACTIONS(1655),
    [anon_sym_interface] = ACTIONS(1658),
    [anon_sym_double] = ACTIONS(1661),
    [anon_sym_default] = ACTIONS(1655),
    [anon_sym_byte] = ACTIONS(1664),
    [anon_sym_synchronized] = ACTIONS(1655),
    [anon_sym_SEMI] = ACTIONS(1667),
    [anon_sym_LBRACE] = ACTIONS(1670),
    [anon_sym_int] = ACTIONS(1664),
    [anon_sym_final] = ACTIONS(1655),
    [anon_sym_RBRACE] = ACTIONS(1673),
    [anon_sym_private] = ACTIONS(1655),
    [anon_sym_AT] = ACTIONS(1675),
    [sym_boolean_type] = ACTIONS(1678),
    [sym_void_type] = ACTIONS(1678),
    [sym_comment] = ACTIONS(3),
    [anon_sym_ATinterface] = ACTIONS(1681),
    [anon_sym_native] = ACTIONS(1655),
    [anon_sym_long] = ACTIONS(1664),
    [anon_sym_float] = ACTIONS(1661),
    [anon_sym_abstract] = ACTIONS(1655),
    [anon_sym_public] = ACTIONS(1655),
    [anon_sym_short] = ACTIONS(1664),
    [anon_sym_transient] = ACTIONS(1655),
    [anon_sym_strictfp] = ACTIONS(1655),
    [anon_sym_LT] = ACTIONS(1684),
    [anon_sym_enum] = ACTIONS(1687),
    [anon_sym_static] = ACTIONS(1690),
    [anon_sym_char] = ACTIONS(1664),
  },
  [535] = {
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_marker_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym__method_declarator] = STATE(540),
    [sym__variable_declarator_list] = STATE(671),
    [sym_dimensions] = STATE(144),
    [sym_variable_declarator] = STATE(143),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym__variable_declarator_id] = STATE(142),
    [sym_annotation] = STATE(145),
    [anon_sym_module] = ACTIONS(1256),
    [sym_identifier] = ACTIONS(1254),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(1256),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [536] = {
    [sym_throws] = STATE(672),
    [sym_constructor_body] = STATE(670),
    [anon_sym_LBRACE] = ACTIONS(1242),
    [anon_sym_throws] = ACTIONS(1244),
    [sym_comment] = ACTIONS(3),
  },
  [537] = {
    [sym_block] = STATE(674),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1693),
  },
  [538] = {
    [sym__annotation] = STATE(145),
    [sym_dimensions] = STATE(307),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_marker_annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [sym_formal_parameters] = STATE(675),
    [anon_sym_EQ] = ACTIONS(673),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(673),
    [anon_sym_LPAREN] = ACTIONS(1240),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_COMMA] = ACTIONS(673),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [539] = {
    [sym_formal_parameters] = STATE(676),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(305),
    [anon_sym_COMMA] = ACTIONS(669),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ] = ACTIONS(669),
    [anon_sym_SEMI] = ACTIONS(669),
    [anon_sym_LPAREN] = ACTIONS(1240),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [540] = {
    [sym_throws] = STATE(677),
    [anon_sym_SEMI] = ACTIONS(1695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_throws] = ACTIONS(1244),
    [anon_sym_LBRACE] = ACTIONS(1695),
  },
  [541] = {
    [anon_sym_SEMI] = ACTIONS(1697),
    [sym_comment] = ACTIONS(3),
  },
  [542] = {
    [sym_type_arguments] = STATE(64),
    [sym_formal_parameters] = STATE(679),
    [anon_sym_LPAREN] = ACTIONS(1240),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_open] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_module] = ACTIONS(89),
    [anon_sym_DOT] = ACTIONS(447),
  },
  [543] = {
    [sym_marker_annotation] = STATE(137),
    [sym_generic_type] = STATE(53),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotation] = STATE(137),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym_integral_type] = STATE(680),
    [sym__unannotated_type] = STATE(680),
    [sym_array_type] = STATE(680),
    [sym__annotation] = STATE(137),
    [sym_floating_point_type] = STATE(680),
    [anon_sym_long] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [sym_void_type] = ACTIONS(1699),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_double] = ACTIONS(41),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(1699),
  },
  [544] = {
    [sym_annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(145),
    [sym__method_declarator] = STATE(683),
    [anon_sym_module] = ACTIONS(1701),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_open] = ACTIONS(1701),
    [sym_identifier] = ACTIONS(1703),
  },
  [545] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(73),
    [sym_annotation] = STATE(74),
    [sym__annotation] = STATE(74),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__type] = STATE(684),
    [sym_annotated_type] = STATE(684),
    [sym_array_type] = STATE(73),
    [sym_integral_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [sym_floating_point_type] = STATE(73),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [sym_void_type] = ACTIONS(334),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_char] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_double] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(334),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
  },
  [546] = {
    [aux_sym_interface_type_list_repeat1] = STATE(685),
    [anon_sym_LBRACE] = ACTIONS(1705),
    [anon_sym_COMMA] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
  },
  [547] = {
    [anon_sym_transient] = ACTIONS(1707),
    [anon_sym_protected] = ACTIONS(1707),
    [anon_sym_do] = ACTIONS(1707),
    [sym_binary_integer_literal] = ACTIONS(1709),
    [sym_super] = ACTIONS(1707),
    [anon_sym_volatile] = ACTIONS(1707),
    [anon_sym_case] = ACTIONS(1707),
    [sym_identifier] = ACTIONS(1707),
    [anon_sym_short] = ACTIONS(1707),
    [anon_sym_else] = ACTIONS(1707),
    [anon_sym_LT] = ACTIONS(1709),
    [sym_void_type] = ACTIONS(1707),
    [sym_false] = ACTIONS(1707),
    [anon_sym_RBRACE] = ACTIONS(1709),
    [anon_sym_try] = ACTIONS(1707),
    [anon_sym_enum] = ACTIONS(1707),
    [anon_sym_module] = ACTIONS(1707),
    [sym_null_literal] = ACTIONS(1707),
    [anon_sym_LPAREN] = ACTIONS(1709),
    [anon_sym_SEMI] = ACTIONS(1709),
    [anon_sym_PLUS_PLUS] = ACTIONS(1709),
    [anon_sym_default] = ACTIONS(1707),
    [anon_sym_return] = ACTIONS(1707),
    [anon_sym_synchronized] = ACTIONS(1707),
    [anon_sym_open] = ACTIONS(1707),
    [sym_decimal_floating_point_literal] = ACTIONS(1709),
    [anon_sym_strictfp] = ACTIONS(1707),
    [anon_sym_long] = ACTIONS(1707),
    [anon_sym_assert] = ACTIONS(1707),
    [sym_this] = ACTIONS(1707),
    [sym_character_literal] = ACTIONS(1709),
    [anon_sym_byte] = ACTIONS(1707),
    [sym_hex_floating_point_literal] = ACTIONS(1707),
    [anon_sym_native] = ACTIONS(1707),
    [anon_sym_DASH] = ACTIONS(1707),
    [anon_sym_static] = ACTIONS(1707),
    [sym_boolean_type] = ACTIONS(1707),
    [anon_sym_if] = ACTIONS(1707),
    [anon_sym_break] = ACTIONS(1707),
    [anon_sym_DASH_DASH] = ACTIONS(1709),
    [anon_sym_for] = ACTIONS(1707),
    [anon_sym_BANG] = ACTIONS(1709),
    [sym_decimal_integer_literal] = ACTIONS(1707),
    [anon_sym_PLUS] = ACTIONS(1707),
    [anon_sym_TILDE] = ACTIONS(1709),
    [anon_sym_new] = ACTIONS(1707),
    [anon_sym_class] = ACTIONS(1707),
    [anon_sym_throw] = ACTIONS(1707),
    [anon_sym_final] = ACTIONS(1707),
    [anon_sym_char] = ACTIONS(1707),
    [ts_builtin_sym_end] = ACTIONS(1709),
    [sym_octal_integer_literal] = ACTIONS(1709),
    [anon_sym_continue] = ACTIONS(1707),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(1707),
    [anon_sym_int] = ACTIONS(1707),
    [anon_sym_while] = ACTIONS(1707),
    [anon_sym_float] = ACTIONS(1707),
    [anon_sym_switch] = ACTIONS(1707),
    [anon_sym_AT] = ACTIONS(1707),
    [anon_sym_LBRACE] = ACTIONS(1709),
    [anon_sym_package] = ACTIONS(1707),
    [anon_sym_ATinterface] = ACTIONS(1709),
    [sym_string_literal] = ACTIONS(1709),
    [anon_sym_double] = ACTIONS(1707),
    [sym_hex_integer_literal] = ACTIONS(1707),
    [anon_sym_public] = ACTIONS(1707),
    [anon_sym_interface] = ACTIONS(1707),
    [anon_sym_import] = ACTIONS(1707),
    [anon_sym_private] = ACTIONS(1707),
    [anon_sym_abstract] = ACTIONS(1707),
  },
  [548] = {
    [sym_class_body] = STATE(686),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(439),
  },
  [549] = {
    [anon_sym_new] = ACTIONS(1711),
    [anon_sym_try] = ACTIONS(1711),
    [anon_sym_protected] = ACTIONS(1711),
    [anon_sym_public] = ACTIONS(1711),
    [sym_false] = ACTIONS(1711),
    [anon_sym_final] = ACTIONS(1711),
    [anon_sym_native] = ACTIONS(1711),
    [anon_sym_for] = ACTIONS(1711),
    [anon_sym_AT] = ACTIONS(1711),
    [anon_sym_LBRACE] = ACTIONS(1713),
    [anon_sym_switch] = ACTIONS(1711),
    [anon_sym_char] = ACTIONS(1711),
    [anon_sym_case] = ACTIONS(1711),
    [anon_sym_LPAREN] = ACTIONS(1713),
    [anon_sym_class] = ACTIONS(1711),
    [anon_sym_SEMI] = ACTIONS(1713),
    [anon_sym_byte] = ACTIONS(1711),
    [anon_sym_float] = ACTIONS(1711),
    [anon_sym_do] = ACTIONS(1711),
    [anon_sym_volatile] = ACTIONS(1711),
    [anon_sym_while] = ACTIONS(1711),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1713),
    [sym_character_literal] = ACTIONS(1713),
    [anon_sym_ATinterface] = ACTIONS(1713),
    [anon_sym_import] = ACTIONS(1711),
    [anon_sym_synchronized] = ACTIONS(1711),
    [anon_sym_enum] = ACTIONS(1711),
    [anon_sym_short] = ACTIONS(1711),
    [sym_true] = ACTIONS(1711),
    [sym_string_literal] = ACTIONS(1713),
    [anon_sym_long] = ACTIONS(1711),
    [sym_hex_floating_point_literal] = ACTIONS(1711),
    [anon_sym_if] = ACTIONS(1711),
    [ts_builtin_sym_end] = ACTIONS(1713),
    [sym_decimal_floating_point_literal] = ACTIONS(1713),
    [anon_sym_static] = ACTIONS(1711),
    [sym_octal_integer_literal] = ACTIONS(1713),
    [anon_sym_package] = ACTIONS(1711),
    [anon_sym_return] = ACTIONS(1711),
    [sym_void_type] = ACTIONS(1711),
    [sym_null_literal] = ACTIONS(1711),
    [anon_sym_default] = ACTIONS(1711),
    [anon_sym_BANG] = ACTIONS(1713),
    [sym_identifier] = ACTIONS(1711),
    [anon_sym_PLUS_PLUS] = ACTIONS(1713),
    [anon_sym_DASH_DASH] = ACTIONS(1713),
    [sym_decimal_integer_literal] = ACTIONS(1711),
    [anon_sym_assert] = ACTIONS(1711),
    [anon_sym_module] = ACTIONS(1711),
    [anon_sym_continue] = ACTIONS(1711),
    [anon_sym_DASH] = ACTIONS(1711),
    [anon_sym_abstract] = ACTIONS(1711),
    [anon_sym_TILDE] = ACTIONS(1713),
    [anon_sym_double] = ACTIONS(1711),
    [anon_sym_else] = ACTIONS(1711),
    [anon_sym_int] = ACTIONS(1711),
    [anon_sym_LT] = ACTIONS(1713),
    [sym_this] = ACTIONS(1711),
    [anon_sym_open] = ACTIONS(1711),
    [anon_sym_strictfp] = ACTIONS(1711),
    [anon_sym_private] = ACTIONS(1711),
    [anon_sym_throw] = ACTIONS(1711),
    [anon_sym_transient] = ACTIONS(1711),
    [anon_sym_break] = ACTIONS(1711),
    [anon_sym_interface] = ACTIONS(1711),
    [anon_sym_PLUS] = ACTIONS(1711),
    [sym_boolean_type] = ACTIONS(1711),
    [sym_super] = ACTIONS(1711),
    [sym_binary_integer_literal] = ACTIONS(1713),
    [sym_hex_integer_literal] = ACTIONS(1711),
  },
  [550] = {
    [anon_sym_TILDE] = ACTIONS(1715),
    [anon_sym_long] = ACTIONS(1717),
    [anon_sym_synchronized] = ACTIONS(1717),
    [sym_true] = ACTIONS(1717),
    [anon_sym_continue] = ACTIONS(1717),
    [anon_sym_throw] = ACTIONS(1717),
    [anon_sym_new] = ACTIONS(1717),
    [anon_sym_open] = ACTIONS(1717),
    [anon_sym_import] = ACTIONS(1717),
    [anon_sym_AT] = ACTIONS(1717),
    [anon_sym_abstract] = ACTIONS(1717),
    [sym_binary_integer_literal] = ACTIONS(1715),
    [anon_sym_for] = ACTIONS(1717),
    [sym_decimal_integer_literal] = ACTIONS(1717),
    [sym_null_literal] = ACTIONS(1717),
    [ts_builtin_sym_end] = ACTIONS(1715),
    [anon_sym_BANG] = ACTIONS(1715),
    [anon_sym_LPAREN] = ACTIONS(1715),
    [anon_sym_byte] = ACTIONS(1717),
    [anon_sym_LT] = ACTIONS(1715),
    [sym_super] = ACTIONS(1717),
    [anon_sym_final] = ACTIONS(1717),
    [anon_sym_do] = ACTIONS(1717),
    [anon_sym_float] = ACTIONS(1717),
    [anon_sym_volatile] = ACTIONS(1717),
    [anon_sym_PLUS] = ACTIONS(1717),
    [sym_this] = ACTIONS(1717),
    [anon_sym_switch] = ACTIONS(1717),
    [anon_sym_assert] = ACTIONS(1717),
    [anon_sym_SEMI] = ACTIONS(1715),
    [sym_string_literal] = ACTIONS(1715),
    [sym_character_literal] = ACTIONS(1715),
    [anon_sym_module] = ACTIONS(1717),
    [sym_identifier] = ACTIONS(1717),
    [anon_sym_enum] = ACTIONS(1717),
    [sym_void_type] = ACTIONS(1717),
    [sym_comment] = ACTIONS(3),
    [anon_sym_private] = ACTIONS(1717),
    [sym_octal_integer_literal] = ACTIONS(1715),
    [anon_sym_strictfp] = ACTIONS(1717),
    [anon_sym_case] = ACTIONS(1717),
    [anon_sym_LBRACE] = ACTIONS(1715),
    [anon_sym_default] = ACTIONS(1717),
    [sym_hex_floating_point_literal] = ACTIONS(1717),
    [anon_sym_PLUS_PLUS] = ACTIONS(1715),
    [anon_sym_double] = ACTIONS(1717),
    [anon_sym_while] = ACTIONS(1717),
    [anon_sym_ATinterface] = ACTIONS(1715),
    [anon_sym_DASH_DASH] = ACTIONS(1715),
    [anon_sym_package] = ACTIONS(1717),
    [anon_sym_transient] = ACTIONS(1717),
    [anon_sym_DASH] = ACTIONS(1717),
    [anon_sym_try] = ACTIONS(1717),
    [anon_sym_break] = ACTIONS(1717),
    [anon_sym_class] = ACTIONS(1717),
    [anon_sym_return] = ACTIONS(1717),
    [anon_sym_if] = ACTIONS(1717),
    [anon_sym_short] = ACTIONS(1717),
    [anon_sym_char] = ACTIONS(1717),
    [sym_false] = ACTIONS(1717),
    [anon_sym_public] = ACTIONS(1717),
    [anon_sym_native] = ACTIONS(1717),
    [sym_hex_integer_literal] = ACTIONS(1717),
    [anon_sym_RBRACE] = ACTIONS(1715),
    [anon_sym_int] = ACTIONS(1717),
    [anon_sym_interface] = ACTIONS(1717),
    [anon_sym_protected] = ACTIONS(1717),
    [anon_sym_else] = ACTIONS(1717),
    [sym_decimal_floating_point_literal] = ACTIONS(1715),
    [sym_boolean_type] = ACTIONS(1717),
    [anon_sym_static] = ACTIONS(1717),
  },
  [551] = {
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_variable_declarator] = STATE(143),
    [sym_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym__variable_declarator_list] = STATE(687),
    [sym__method_declarator] = STATE(540),
    [sym_marker_annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(142),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(144),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_module] = ACTIONS(1256),
    [sym_identifier] = ACTIONS(1254),
    [anon_sym_open] = ACTIONS(1256),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [552] = {
    [anon_sym_continue] = ACTIONS(1719),
    [anon_sym_private] = ACTIONS(1719),
    [anon_sym_byte] = ACTIONS(1719),
    [sym_this] = ACTIONS(1719),
    [sym_decimal_integer_literal] = ACTIONS(1719),
    [anon_sym_strictfp] = ACTIONS(1719),
    [anon_sym_class] = ACTIONS(1719),
    [anon_sym_char] = ACTIONS(1719),
    [sym_character_literal] = ACTIONS(1721),
    [anon_sym_return] = ACTIONS(1719),
    [anon_sym_BANG] = ACTIONS(1721),
    [sym_void_type] = ACTIONS(1719),
    [anon_sym_interface] = ACTIONS(1719),
    [anon_sym_enum] = ACTIONS(1719),
    [anon_sym_open] = ACTIONS(1719),
    [ts_builtin_sym_end] = ACTIONS(1721),
    [sym_hex_floating_point_literal] = ACTIONS(1719),
    [sym_hex_integer_literal] = ACTIONS(1719),
    [sym_decimal_floating_point_literal] = ACTIONS(1721),
    [anon_sym_TILDE] = ACTIONS(1721),
    [anon_sym_short] = ACTIONS(1719),
    [anon_sym_new] = ACTIONS(1719),
    [anon_sym_transient] = ACTIONS(1719),
    [anon_sym_default] = ACTIONS(1719),
    [anon_sym_LBRACE] = ACTIONS(1721),
    [sym_false] = ACTIONS(1719),
    [anon_sym_DASH] = ACTIONS(1719),
    [anon_sym_PLUS_PLUS] = ACTIONS(1721),
    [anon_sym_SEMI] = ACTIONS(1721),
    [anon_sym_while] = ACTIONS(1719),
    [anon_sym_abstract] = ACTIONS(1719),
    [anon_sym_throw] = ACTIONS(1719),
    [anon_sym_protected] = ACTIONS(1719),
    [anon_sym_int] = ACTIONS(1719),
    [anon_sym_native] = ACTIONS(1719),
    [anon_sym_if] = ACTIONS(1719),
    [sym_boolean_type] = ACTIONS(1719),
    [anon_sym_break] = ACTIONS(1719),
    [anon_sym_LT] = ACTIONS(1721),
    [sym_string_literal] = ACTIONS(1721),
    [anon_sym_module] = ACTIONS(1719),
    [anon_sym_LPAREN] = ACTIONS(1721),
    [anon_sym_assert] = ACTIONS(1719),
    [anon_sym_volatile] = ACTIONS(1719),
    [sym_super] = ACTIONS(1719),
    [anon_sym_case] = ACTIONS(1719),
    [anon_sym_ATinterface] = ACTIONS(1721),
    [anon_sym_package] = ACTIONS(1719),
    [sym_true] = ACTIONS(1719),
    [sym_identifier] = ACTIONS(1719),
    [anon_sym_switch] = ACTIONS(1719),
    [sym_binary_integer_literal] = ACTIONS(1721),
    [sym_octal_integer_literal] = ACTIONS(1721),
    [anon_sym_PLUS] = ACTIONS(1719),
    [anon_sym_DASH_DASH] = ACTIONS(1721),
    [anon_sym_public] = ACTIONS(1719),
    [anon_sym_do] = ACTIONS(1719),
    [anon_sym_AT] = ACTIONS(1719),
    [sym_null_literal] = ACTIONS(1719),
    [anon_sym_static] = ACTIONS(1719),
    [anon_sym_for] = ACTIONS(1719),
    [anon_sym_synchronized] = ACTIONS(1719),
    [anon_sym_float] = ACTIONS(1719),
    [anon_sym_long] = ACTIONS(1719),
    [anon_sym_final] = ACTIONS(1719),
    [anon_sym_RBRACE] = ACTIONS(1721),
    [anon_sym_import] = ACTIONS(1719),
    [anon_sym_else] = ACTIONS(1719),
    [anon_sym_double] = ACTIONS(1719),
    [sym_comment] = ACTIONS(3),
    [anon_sym_try] = ACTIONS(1719),
  },
  [553] = {
    [sym_normal_interface_declaration] = STATE(45),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__unannotated_type] = STATE(397),
    [sym__method_header] = STATE(378),
    [sym_enum_declaration] = STATE(393),
    [sym_constant_declaration] = STATE(393),
    [sym__annotation] = STATE(44),
    [sym_floating_point_type] = STATE(397),
    [sym_type_parameters] = STATE(396),
    [sym_marker_annotation] = STATE(44),
    [sym_integral_type] = STATE(397),
    [sym_method_declaration] = STATE(393),
    [sym_annotation_type_declaration] = STATE(45),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_interface_declaration] = STATE(393),
    [sym_interface_member_declaration] = STATE(553),
    [sym_class_declaration] = STATE(393),
    [sym_array_type] = STATE(397),
    [sym_annotation] = STATE(44),
    [sym_modifiers] = STATE(394),
    [aux_sym_interface_body_repeat1] = STATE(553),
    [sym_generic_type] = STATE(53),
    [anon_sym_enum] = ACTIONS(1723),
    [anon_sym_abstract] = ACTIONS(1726),
    [anon_sym_static] = ACTIONS(1726),
    [anon_sym_strictfp] = ACTIONS(1726),
    [anon_sym_ATinterface] = ACTIONS(1729),
    [anon_sym_float] = ACTIONS(1732),
    [anon_sym_synchronized] = ACTIONS(1726),
    [anon_sym_LT] = ACTIONS(1735),
    [anon_sym_native] = ACTIONS(1726),
    [anon_sym_byte] = ACTIONS(1738),
    [anon_sym_long] = ACTIONS(1738),
    [sym_boolean_type] = ACTIONS(1741),
    [sym_comment] = ACTIONS(3),
    [sym_void_type] = ACTIONS(1741),
    [anon_sym_public] = ACTIONS(1726),
    [anon_sym_interface] = ACTIONS(1744),
    [anon_sym_double] = ACTIONS(1732),
    [anon_sym_class] = ACTIONS(1747),
    [anon_sym_protected] = ACTIONS(1726),
    [sym_identifier] = ACTIONS(1750),
    [anon_sym_private] = ACTIONS(1726),
    [anon_sym_final] = ACTIONS(1726),
    [anon_sym_RBRACE] = ACTIONS(1753),
    [anon_sym_transient] = ACTIONS(1726),
    [anon_sym_int] = ACTIONS(1738),
    [anon_sym_SEMI] = ACTIONS(1755),
    [anon_sym_default] = ACTIONS(1726),
    [anon_sym_volatile] = ACTIONS(1726),
    [anon_sym_short] = ACTIONS(1738),
    [anon_sym_char] = ACTIONS(1738),
    [anon_sym_AT] = ACTIONS(1758),
  },
  [554] = {
    [anon_sym_SEMI] = ACTIONS(1761),
    [sym_comment] = ACTIONS(3),
  },
  [555] = {
    [anon_sym_int] = ACTIONS(1763),
    [sym_decimal_integer_literal] = ACTIONS(1763),
    [anon_sym_else] = ACTIONS(1763),
    [anon_sym_transient] = ACTIONS(1763),
    [anon_sym_package] = ACTIONS(1763),
    [anon_sym_enum] = ACTIONS(1763),
    [anon_sym_throw] = ACTIONS(1763),
    [anon_sym_long] = ACTIONS(1763),
    [anon_sym_native] = ACTIONS(1763),
    [anon_sym_abstract] = ACTIONS(1763),
    [anon_sym_case] = ACTIONS(1763),
    [anon_sym_DASH] = ACTIONS(1763),
    [anon_sym_final] = ACTIONS(1763),
    [anon_sym_return] = ACTIONS(1763),
    [sym_binary_integer_literal] = ACTIONS(1765),
    [anon_sym_static] = ACTIONS(1763),
    [anon_sym_private] = ACTIONS(1763),
    [anon_sym_LT] = ACTIONS(1765),
    [anon_sym_BANG] = ACTIONS(1765),
    [sym_this] = ACTIONS(1763),
    [anon_sym_assert] = ACTIONS(1763),
    [anon_sym_class] = ACTIONS(1763),
    [anon_sym_if] = ACTIONS(1763),
    [sym_comment] = ACTIONS(3),
    [sym_hex_floating_point_literal] = ACTIONS(1763),
    [anon_sym_for] = ACTIONS(1763),
    [sym_string_literal] = ACTIONS(1765),
    [anon_sym_short] = ACTIONS(1763),
    [anon_sym_double] = ACTIONS(1763),
    [anon_sym_new] = ACTIONS(1763),
    [anon_sym_volatile] = ACTIONS(1763),
    [sym_void_type] = ACTIONS(1763),
    [anon_sym_public] = ACTIONS(1763),
    [anon_sym_PLUS] = ACTIONS(1763),
    [sym_null_literal] = ACTIONS(1763),
    [sym_super] = ACTIONS(1763),
    [anon_sym_while] = ACTIONS(1763),
    [sym_decimal_floating_point_literal] = ACTIONS(1765),
    [sym_true] = ACTIONS(1763),
    [anon_sym_PLUS_PLUS] = ACTIONS(1765),
    [anon_sym_do] = ACTIONS(1763),
    [sym_identifier] = ACTIONS(1763),
    [anon_sym_synchronized] = ACTIONS(1763),
    [sym_character_literal] = ACTIONS(1765),
    [anon_sym_protected] = ACTIONS(1763),
    [anon_sym_strictfp] = ACTIONS(1763),
    [ts_builtin_sym_end] = ACTIONS(1765),
    [anon_sym_DASH_DASH] = ACTIONS(1765),
    [anon_sym_LPAREN] = ACTIONS(1765),
    [anon_sym_SEMI] = ACTIONS(1765),
    [anon_sym_TILDE] = ACTIONS(1765),
    [anon_sym_LBRACE] = ACTIONS(1765),
    [anon_sym_module] = ACTIONS(1763),
    [anon_sym_break] = ACTIONS(1763),
    [anon_sym_byte] = ACTIONS(1763),
    [anon_sym_char] = ACTIONS(1763),
    [sym_octal_integer_literal] = ACTIONS(1765),
    [sym_hex_integer_literal] = ACTIONS(1763),
    [anon_sym_open] = ACTIONS(1763),
    [sym_false] = ACTIONS(1763),
    [anon_sym_AT] = ACTIONS(1763),
    [anon_sym_float] = ACTIONS(1763),
    [anon_sym_switch] = ACTIONS(1763),
    [anon_sym_RBRACE] = ACTIONS(1765),
    [sym_boolean_type] = ACTIONS(1763),
    [anon_sym_ATinterface] = ACTIONS(1765),
    [anon_sym_import] = ACTIONS(1763),
    [anon_sym_continue] = ACTIONS(1763),
    [anon_sym_try] = ACTIONS(1763),
    [anon_sym_default] = ACTIONS(1763),
    [anon_sym_interface] = ACTIONS(1763),
  },
  [556] = {
    [anon_sym_BANG_EQ] = ACTIONS(1767),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(1767),
    [anon_sym_AMP_AMP] = ACTIONS(1767),
    [anon_sym_instanceof] = ACTIONS(1767),
    [anon_sym_PLUS_PLUS] = ACTIONS(1767),
    [anon_sym_RBRACE] = ACTIONS(1767),
    [anon_sym_QMARK] = ACTIONS(1767),
    [anon_sym_PLUS] = ACTIONS(1769),
    [anon_sym_LT_EQ] = ACTIONS(1767),
    [anon_sym_LBRACK] = ACTIONS(1767),
    [anon_sym_GT] = ACTIONS(1769),
    [anon_sym_SLASH] = ACTIONS(1769),
    [anon_sym_GT_GT_GT] = ACTIONS(1767),
    [anon_sym_PERCENT] = ACTIONS(1767),
    [anon_sym_PIPE] = ACTIONS(1769),
    [anon_sym_DASH] = ACTIONS(1769),
    [anon_sym_AT] = ACTIONS(1767),
    [anon_sym_GT_EQ] = ACTIONS(1767),
    [anon_sym_COMMA] = ACTIONS(1767),
    [anon_sym_GT_GT] = ACTIONS(1769),
    [anon_sym_STAR] = ACTIONS(1767),
    [anon_sym_EQ_EQ] = ACTIONS(1767),
    [anon_sym_DOT] = ACTIONS(1767),
    [anon_sym_LT] = ACTIONS(1769),
    [anon_sym_AMP] = ACTIONS(1769),
    [anon_sym_COLON_COLON] = ACTIONS(1767),
    [anon_sym_COLON] = ACTIONS(1769),
    [anon_sym_DASH_DASH] = ACTIONS(1767),
    [anon_sym_PIPE_PIPE] = ACTIONS(1767),
    [anon_sym_CARET] = ACTIONS(1767),
    [anon_sym_RPAREN] = ACTIONS(1767),
    [anon_sym_SEMI] = ACTIONS(1767),
    [anon_sym_LT_LT] = ACTIONS(1767),
  },
  [557] = {
    [anon_sym_RBRACE] = ACTIONS(1771),
    [sym_comment] = ACTIONS(3),
  },
  [558] = {
    [anon_sym_DASH] = ACTIONS(1773),
    [anon_sym_RPAREN] = ACTIONS(1775),
    [anon_sym_AMP] = ACTIONS(1773),
    [anon_sym_QMARK] = ACTIONS(1775),
    [anon_sym_DOT] = ACTIONS(1775),
    [anon_sym_SEMI] = ACTIONS(1775),
    [anon_sym_COMMA] = ACTIONS(1775),
    [anon_sym_CARET] = ACTIONS(1775),
    [anon_sym_COLON_COLON] = ACTIONS(1775),
    [anon_sym_STAR] = ACTIONS(1775),
    [anon_sym_EQ_EQ] = ACTIONS(1775),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_DASH] = ACTIONS(1775),
    [anon_sym_AMP_AMP] = ACTIONS(1775),
    [anon_sym_PIPE_PIPE] = ACTIONS(1775),
    [anon_sym_instanceof] = ACTIONS(1775),
    [anon_sym_LT_LT] = ACTIONS(1775),
    [anon_sym_GT_GT_GT] = ACTIONS(1775),
    [anon_sym_PIPE] = ACTIONS(1773),
    [anon_sym_GT_EQ] = ACTIONS(1775),
    [anon_sym_PLUS] = ACTIONS(1773),
    [anon_sym_COLON] = ACTIONS(1773),
    [anon_sym_SLASH] = ACTIONS(1773),
    [anon_sym_PLUS_PLUS] = ACTIONS(1775),
    [anon_sym_PERCENT] = ACTIONS(1775),
    [anon_sym_GT] = ACTIONS(1773),
    [anon_sym_RBRACE] = ACTIONS(1775),
    [anon_sym_RBRACK] = ACTIONS(1775),
    [anon_sym_BANG_EQ] = ACTIONS(1775),
    [anon_sym_GT_GT] = ACTIONS(1773),
    [anon_sym_LT] = ACTIONS(1773),
    [anon_sym_LT_EQ] = ACTIONS(1775),
  },
  [559] = {
    [aux_sym_array_initializer_repeat1] = STATE(691),
    [anon_sym_COMMA] = ACTIONS(1777),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1771),
  },
  [560] = {
    [aux_sym_array_initializer_repeat1] = STATE(691),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_RBRACE] = ACTIONS(1771),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_COMMA] = ACTIONS(1777),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
  },
  [561] = {
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(1779),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_AMP] = ACTIONS(309),
  },
  [562] = {
    [sym_array_access] = STATE(39),
    [sym_annotated_type] = STATE(37),
    [sym_cast_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(42),
    [sym__annotation] = STATE(74),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_floating_point_type] = STATE(30),
    [sym__expression] = STATE(401),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(30),
    [sym_object_creation_expression] = STATE(43),
    [sym_unary_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym__type] = STATE(37),
    [sym_field_access] = STATE(39),
    [sym_scoped_identifier] = STATE(52),
    [sym__primary] = STATE(41),
    [sym_ternary_expression] = STATE(401),
    [sym_formal_parameters] = STATE(42),
    [sym__primary_no_new_array] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym_binary_expression] = STATE(401),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym__literal] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym_parenthesized_expression] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_method_reference] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_update_expression] = STATE(401),
    [sym_array_type] = STATE(73),
    [sym_assignment_expression] = STATE(401),
    [sym__unannotated_type] = STATE(73),
    [sym_class_literal] = STATE(43),
    [sym_instanceof_expression] = STATE(401),
    [sym_annotation] = STATE(74),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_null_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_open] = ACTIONS(120),
    [sym_super] = ACTIONS(9),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_module] = ACTIONS(120),
    [sym_false] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(33),
    [sym_string_literal] = ACTIONS(35),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(79),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_character_literal] = ACTIONS(35),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_this] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
  },
  [563] = {
    [sym_marker_annotation] = STATE(137),
    [sym__annotation] = STATE(137),
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym_annotation] = STATE(137),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(1781),
    [sym_comment] = ACTIONS(3),
  },
  [564] = {
    [anon_sym_LT] = ACTIONS(1783),
    [anon_sym_DASH] = ACTIONS(1783),
    [anon_sym_RBRACK] = ACTIONS(1785),
    [anon_sym_RBRACE] = ACTIONS(1785),
    [anon_sym_AMP] = ACTIONS(1783),
    [anon_sym_EQ_EQ] = ACTIONS(1785),
    [anon_sym_LBRACK] = ACTIONS(1785),
    [anon_sym_DOT] = ACTIONS(1785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP_AMP] = ACTIONS(1785),
    [anon_sym_PERCENT] = ACTIONS(1785),
    [anon_sym_instanceof] = ACTIONS(1785),
    [anon_sym_GT_EQ] = ACTIONS(1785),
    [anon_sym_PLUS_PLUS] = ACTIONS(1785),
    [anon_sym_STAR] = ACTIONS(1785),
    [anon_sym_SEMI] = ACTIONS(1785),
    [anon_sym_CARET] = ACTIONS(1785),
    [anon_sym_PIPE] = ACTIONS(1783),
    [anon_sym_PLUS] = ACTIONS(1783),
    [anon_sym_COLON_COLON] = ACTIONS(1785),
    [anon_sym_SLASH] = ACTIONS(1783),
    [anon_sym_GT_GT] = ACTIONS(1783),
    [anon_sym_PIPE_PIPE] = ACTIONS(1785),
    [anon_sym_LT_LT] = ACTIONS(1785),
    [anon_sym_COMMA] = ACTIONS(1785),
    [anon_sym_GT] = ACTIONS(1783),
    [anon_sym_QMARK] = ACTIONS(1785),
    [anon_sym_DASH_DASH] = ACTIONS(1785),
    [anon_sym_LT_EQ] = ACTIONS(1785),
    [anon_sym_BANG_EQ] = ACTIONS(1785),
    [anon_sym_GT_GT_GT] = ACTIONS(1785),
    [anon_sym_RPAREN] = ACTIONS(1785),
    [anon_sym_COLON] = ACTIONS(1783),
  },
  [565] = {
    [anon_sym_instanceof] = ACTIONS(1787),
    [anon_sym_LT_LT] = ACTIONS(1787),
    [anon_sym_GT_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1787),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_GT_GT_GT] = ACTIONS(1787),
    [anon_sym_CARET] = ACTIONS(1787),
    [anon_sym_PLUS] = ACTIONS(1789),
    [anon_sym_GT] = ACTIONS(1789),
    [anon_sym_PERCENT] = ACTIONS(1787),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_COLON] = ACTIONS(1789),
    [anon_sym_BANG_EQ] = ACTIONS(1787),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1789),
    [anon_sym_GT_EQ] = ACTIONS(1787),
    [anon_sym_DASH_DASH] = ACTIONS(1787),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COLON_COLON] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_EQ_EQ] = ACTIONS(1787),
    [anon_sym_RBRACE] = ACTIONS(1787),
    [anon_sym_LT] = ACTIONS(1789),
    [anon_sym_LT_EQ] = ACTIONS(1787),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1787),
    [anon_sym_QMARK] = ACTIONS(1787),
    [anon_sym_PLUS_PLUS] = ACTIONS(1787),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_SLASH] = ACTIONS(1789),
    [anon_sym_DOT] = ACTIONS(1787),
  },
  [566] = {
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_LT_LT] = ACTIONS(285),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_COLON] = ACTIONS(1791),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
  },
  [567] = {
    [anon_sym_throw] = ACTIONS(1793),
    [anon_sym_do] = ACTIONS(1793),
    [anon_sym_short] = ACTIONS(1793),
    [anon_sym_ATinterface] = ACTIONS(1795),
    [anon_sym_float] = ACTIONS(1793),
    [sym_octal_integer_literal] = ACTIONS(1795),
    [anon_sym_long] = ACTIONS(1793),
    [anon_sym_break] = ACTIONS(1793),
    [anon_sym_TILDE] = ACTIONS(1795),
    [sym_decimal_floating_point_literal] = ACTIONS(1795),
    [anon_sym_protected] = ACTIONS(1793),
    [sym_boolean_type] = ACTIONS(1793),
    [anon_sym_interface] = ACTIONS(1793),
    [anon_sym_synchronized] = ACTIONS(1793),
    [anon_sym_if] = ACTIONS(1793),
    [sym_null_literal] = ACTIONS(1793),
    [anon_sym_transient] = ACTIONS(1793),
    [anon_sym_try] = ACTIONS(1793),
    [anon_sym_char] = ACTIONS(1793),
    [anon_sym_case] = ACTIONS(1793),
    [sym_binary_integer_literal] = ACTIONS(1795),
    [anon_sym_static] = ACTIONS(1793),
    [anon_sym_PLUS] = ACTIONS(1793),
    [anon_sym_switch] = ACTIONS(1793),
    [sym_decimal_integer_literal] = ACTIONS(1793),
    [anon_sym_SEMI] = ACTIONS(1795),
    [anon_sym_for] = ACTIONS(1793),
    [anon_sym_public] = ACTIONS(1793),
    [anon_sym_int] = ACTIONS(1793),
    [sym_false] = ACTIONS(1793),
    [sym_super] = ACTIONS(1793),
    [anon_sym_strictfp] = ACTIONS(1793),
    [sym_string_literal] = ACTIONS(1795),
    [anon_sym_double] = ACTIONS(1793),
    [sym_this] = ACTIONS(1793),
    [anon_sym_native] = ACTIONS(1793),
    [anon_sym_PLUS_PLUS] = ACTIONS(1795),
    [anon_sym_AT] = ACTIONS(1793),
    [anon_sym_assert] = ACTIONS(1793),
    [anon_sym_package] = ACTIONS(1793),
    [sym_hex_floating_point_literal] = ACTIONS(1793),
    [anon_sym_default] = ACTIONS(1793),
    [anon_sym_final] = ACTIONS(1793),
    [anon_sym_BANG] = ACTIONS(1795),
    [anon_sym_new] = ACTIONS(1793),
    [anon_sym_open] = ACTIONS(1793),
    [sym_character_literal] = ACTIONS(1795),
    [anon_sym_class] = ACTIONS(1793),
    [anon_sym_return] = ACTIONS(1793),
    [anon_sym_enum] = ACTIONS(1793),
    [anon_sym_private] = ACTIONS(1793),
    [anon_sym_byte] = ACTIONS(1793),
    [anon_sym_RBRACE] = ACTIONS(1795),
    [anon_sym_continue] = ACTIONS(1793),
    [sym_comment] = ACTIONS(3),
    [sym_void_type] = ACTIONS(1793),
    [anon_sym_import] = ACTIONS(1793),
    [anon_sym_volatile] = ACTIONS(1793),
    [sym_identifier] = ACTIONS(1793),
    [sym_hex_integer_literal] = ACTIONS(1793),
    [anon_sym_LBRACE] = ACTIONS(1795),
    [sym_true] = ACTIONS(1793),
    [anon_sym_LPAREN] = ACTIONS(1795),
    [anon_sym_while] = ACTIONS(1793),
    [anon_sym_DASH_DASH] = ACTIONS(1795),
    [anon_sym_abstract] = ACTIONS(1793),
    [anon_sym_module] = ACTIONS(1793),
    [anon_sym_DASH] = ACTIONS(1793),
  },
  [568] = {
    [sym_binary_integer_literal] = ACTIONS(1797),
    [ts_builtin_sym_end] = ACTIONS(1797),
    [sym_decimal_floating_point_literal] = ACTIONS(1797),
    [anon_sym_final] = ACTIONS(1799),
    [anon_sym_break] = ACTIONS(1799),
    [anon_sym_new] = ACTIONS(1799),
    [anon_sym_AT] = ACTIONS(1799),
    [sym_void_type] = ACTIONS(1799),
    [anon_sym_RBRACE] = ACTIONS(1797),
    [anon_sym_abstract] = ACTIONS(1799),
    [anon_sym_import] = ACTIONS(1799),
    [anon_sym_package] = ACTIONS(1799),
    [anon_sym_short] = ACTIONS(1799),
    [anon_sym_DASH] = ACTIONS(1799),
    [anon_sym_enum] = ACTIONS(1799),
    [anon_sym_TILDE] = ACTIONS(1797),
    [anon_sym_while] = ACTIONS(1799),
    [anon_sym_char] = ACTIONS(1799),
    [anon_sym_transient] = ACTIONS(1799),
    [sym_octal_integer_literal] = ACTIONS(1797),
    [anon_sym_protected] = ACTIONS(1799),
    [anon_sym_continue] = ACTIONS(1799),
    [sym_string_literal] = ACTIONS(1797),
    [anon_sym_try] = ACTIONS(1799),
    [sym_boolean_type] = ACTIONS(1799),
    [anon_sym_int] = ACTIONS(1799),
    [anon_sym_SEMI] = ACTIONS(1797),
    [sym_super] = ACTIONS(1799),
    [anon_sym_class] = ACTIONS(1799),
    [anon_sym_case] = ACTIONS(1799),
    [anon_sym_if] = ACTIONS(1799),
    [anon_sym_open] = ACTIONS(1799),
    [sym_decimal_integer_literal] = ACTIONS(1799),
    [anon_sym_float] = ACTIONS(1799),
    [sym_character_literal] = ACTIONS(1797),
    [anon_sym_PLUS] = ACTIONS(1799),
    [anon_sym_for] = ACTIONS(1799),
    [anon_sym_byte] = ACTIONS(1799),
    [anon_sym_else] = ACTIONS(1799),
    [anon_sym_private] = ACTIONS(1799),
    [anon_sym_LPAREN] = ACTIONS(1797),
    [anon_sym_assert] = ACTIONS(1799),
    [sym_null_literal] = ACTIONS(1799),
    [anon_sym_static] = ACTIONS(1799),
    [anon_sym_ATinterface] = ACTIONS(1797),
    [anon_sym_interface] = ACTIONS(1799),
    [sym_true] = ACTIONS(1799),
    [sym_false] = ACTIONS(1799),
    [anon_sym_double] = ACTIONS(1799),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_DASH] = ACTIONS(1797),
    [anon_sym_BANG] = ACTIONS(1797),
    [anon_sym_LBRACE] = ACTIONS(1797),
    [anon_sym_default] = ACTIONS(1799),
    [anon_sym_PLUS_PLUS] = ACTIONS(1797),
    [anon_sym_synchronized] = ACTIONS(1799),
    [sym_hex_floating_point_literal] = ACTIONS(1799),
    [anon_sym_switch] = ACTIONS(1799),
    [anon_sym_throw] = ACTIONS(1799),
    [anon_sym_strictfp] = ACTIONS(1799),
    [anon_sym_volatile] = ACTIONS(1799),
    [anon_sym_do] = ACTIONS(1799),
    [anon_sym_public] = ACTIONS(1799),
    [anon_sym_native] = ACTIONS(1799),
    [sym_hex_integer_literal] = ACTIONS(1799),
    [anon_sym_module] = ACTIONS(1799),
    [anon_sym_long] = ACTIONS(1799),
    [anon_sym_return] = ACTIONS(1799),
    [sym_identifier] = ACTIONS(1799),
    [sym_this] = ACTIONS(1799),
  },
  [569] = {
    [sym_switch_statement] = STATE(569),
    [sym_while_statement] = STATE(569),
    [sym_try_statement] = STATE(569),
    [sym_local_variable_declaration] = STATE(47),
    [sym_formal_parameters] = STATE(42),
    [sym_cast_expression] = STATE(49),
    [aux_sym_switch_block_repeat1] = STATE(569),
    [sym_object_creation_expression] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_instanceof_expression] = STATE(49),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_try_with_resources_statement] = STATE(569),
    [sym_generic_type] = STATE(53),
    [sym_class_declaration] = STATE(569),
    [sym_do_statement] = STATE(569),
    [sym_throw_statement] = STATE(569),
    [sym_return_statement] = STATE(569),
    [sym_module_declaration] = STATE(569),
    [sym_field_access] = STATE(39),
    [sym_floating_point_type] = STATE(30),
    [sym_lambda_expression] = STATE(49),
    [sym_unary_expression] = STATE(49),
    [sym_local_variable_declaration_statement] = STATE(569),
    [sym__declaration] = STATE(569),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_if_statement] = STATE(569),
    [sym__primary_no_new_array] = STATE(43),
    [sym_expression_statement] = STATE(569),
    [sym_continue_statement] = STATE(569),
    [sym_integral_type] = STATE(30),
    [sym__literal] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_update_expression] = STATE(49),
    [sym_for_statement] = STATE(569),
    [sym__annotation] = STATE(51),
    [sym__unannotated_type] = STATE(40),
    [sym_break_statement] = STATE(569),
    [sym_annotation_type_declaration] = STATE(45),
    [sym__type] = STATE(37),
    [sym_labeled_statement] = STATE(569),
    [sym_method_reference] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_class_literal] = STATE(43),
    [sym_ternary_expression] = STATE(49),
    [sym_scoped_identifier] = STATE(52),
    [sym_annotated_type] = STATE(37),
    [sym__expression] = STATE(49),
    [sym_array_creation_expression] = STATE(41),
    [sym_enum_declaration] = STATE(569),
    [sym_interface_declaration] = STATE(569),
    [sym_assignment_expression] = STATE(49),
    [sym_import_declaration] = STATE(569),
    [sym_marker_annotation] = STATE(51),
    [sym__primary] = STATE(41),
    [sym_enhanced_for_statement] = STATE(569),
    [sym_array_type] = STATE(40),
    [sym_inferred_parameters] = STATE(42),
    [sym_package_declaration] = STATE(569),
    [sym_annotation] = STATE(51),
    [sym_method_invocation] = STATE(43),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_synchronized_statement] = STATE(569),
    [sym_assert_statement] = STATE(569),
    [sym_switch_label] = STATE(569),
    [sym_modifiers] = STATE(48),
    [sym_block] = STATE(569),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_binary_expression] = STATE(49),
    [sym_void_type] = ACTIONS(1801),
    [anon_sym_transient] = ACTIONS(1804),
    [anon_sym_class] = ACTIONS(1807),
    [anon_sym_DASH] = ACTIONS(1810),
    [sym_super] = ACTIONS(1813),
    [anon_sym_PLUS_PLUS] = ACTIONS(1816),
    [anon_sym_throw] = ACTIONS(1819),
    [sym_boolean_type] = ACTIONS(1822),
    [anon_sym_long] = ACTIONS(1825),
    [anon_sym_assert] = ACTIONS(1828),
    [sym_true] = ACTIONS(1831),
    [anon_sym_import] = ACTIONS(1834),
    [anon_sym_protected] = ACTIONS(1804),
    [anon_sym_package] = ACTIONS(1837),
    [anon_sym_LPAREN] = ACTIONS(1840),
    [sym_null_literal] = ACTIONS(1831),
    [sym_decimal_floating_point_literal] = ACTIONS(1843),
    [sym_binary_integer_literal] = ACTIONS(1843),
    [sym_string_literal] = ACTIONS(1843),
    [anon_sym_int] = ACTIONS(1825),
    [sym_comment] = ACTIONS(3),
    [anon_sym_while] = ACTIONS(1846),
    [anon_sym_ATinterface] = ACTIONS(1849),
    [anon_sym_AT] = ACTIONS(1852),
    [anon_sym_if] = ACTIONS(1855),
    [anon_sym_abstract] = ACTIONS(1804),
    [anon_sym_module] = ACTIONS(1858),
    [anon_sym_LBRACE] = ACTIONS(1861),
    [anon_sym_new] = ACTIONS(1864),
    [anon_sym_try] = ACTIONS(1867),
    [anon_sym_return] = ACTIONS(1870),
    [anon_sym_default] = ACTIONS(1873),
    [anon_sym_synchronized] = ACTIONS(1876),
    [anon_sym_volatile] = ACTIONS(1804),
    [sym_hex_floating_point_literal] = ACTIONS(1831),
    [sym_identifier] = ACTIONS(1879),
    [anon_sym_TILDE] = ACTIONS(1882),
    [sym_false] = ACTIONS(1831),
    [anon_sym_PLUS] = ACTIONS(1810),
    [anon_sym_RBRACE] = ACTIONS(1885),
    [anon_sym_native] = ACTIONS(1804),
    [anon_sym_DASH_DASH] = ACTIONS(1816),
    [anon_sym_case] = ACTIONS(1887),
    [anon_sym_enum] = ACTIONS(1890),
    [anon_sym_do] = ACTIONS(1893),
    [anon_sym_private] = ACTIONS(1804),
    [anon_sym_BANG] = ACTIONS(1882),
    [anon_sym_continue] = ACTIONS(1896),
    [anon_sym_final] = ACTIONS(1804),
    [anon_sym_for] = ACTIONS(1899),
    [sym_octal_integer_literal] = ACTIONS(1843),
    [anon_sym_interface] = ACTIONS(1902),
    [anon_sym_short] = ACTIONS(1825),
    [anon_sym_char] = ACTIONS(1825),
    [sym_decimal_integer_literal] = ACTIONS(1831),
    [anon_sym_strictfp] = ACTIONS(1804),
    [anon_sym_byte] = ACTIONS(1825),
    [anon_sym_break] = ACTIONS(1905),
    [anon_sym_float] = ACTIONS(1908),
    [sym_this] = ACTIONS(1831),
    [anon_sym_public] = ACTIONS(1804),
    [sym_hex_integer_literal] = ACTIONS(1831),
    [anon_sym_switch] = ACTIONS(1911),
    [anon_sym_static] = ACTIONS(1804),
    [sym_character_literal] = ACTIONS(1843),
    [anon_sym_double] = ACTIONS(1908),
    [anon_sym_open] = ACTIONS(1914),
    [anon_sym_SEMI] = ACTIONS(1917),
  },
  [570] = {
    [anon_sym_SEMI] = ACTIONS(1920),
    [sym_comment] = ACTIONS(3),
  },
  [571] = {
    [sym_asterisk] = STATE(696),
    [sym_identifier] = ACTIONS(965),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(963),
  },
  [572] = {
    [sym_identifier] = ACTIONS(1922),
    [sym_hex_integer_literal] = ACTIONS(1922),
    [anon_sym_DASH] = ACTIONS(1922),
    [sym_character_literal] = ACTIONS(1924),
    [sym_boolean_type] = ACTIONS(1922),
    [sym_string_literal] = ACTIONS(1924),
    [anon_sym_LBRACE] = ACTIONS(1924),
    [anon_sym_TILDE] = ACTIONS(1924),
    [anon_sym_DASH_DASH] = ACTIONS(1924),
    [anon_sym_switch] = ACTIONS(1922),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(1922),
    [anon_sym_final] = ACTIONS(1922),
    [anon_sym_private] = ACTIONS(1922),
    [sym_decimal_floating_point_literal] = ACTIONS(1924),
    [sym_super] = ACTIONS(1922),
    [ts_builtin_sym_end] = ACTIONS(1924),
    [anon_sym_case] = ACTIONS(1922),
    [anon_sym_char] = ACTIONS(1922),
    [anon_sym_volatile] = ACTIONS(1922),
    [anon_sym_assert] = ACTIONS(1922),
    [anon_sym_package] = ACTIONS(1922),
    [anon_sym_short] = ACTIONS(1922),
    [anon_sym_while] = ACTIONS(1922),
    [anon_sym_enum] = ACTIONS(1922),
    [anon_sym_int] = ACTIONS(1922),
    [anon_sym_default] = ACTIONS(1922),
    [anon_sym_abstract] = ACTIONS(1922),
    [anon_sym_RBRACE] = ACTIONS(1924),
    [anon_sym_ATinterface] = ACTIONS(1924),
    [anon_sym_throw] = ACTIONS(1922),
    [anon_sym_try] = ACTIONS(1922),
    [sym_null_literal] = ACTIONS(1922),
    [anon_sym_strictfp] = ACTIONS(1922),
    [anon_sym_PLUS_PLUS] = ACTIONS(1924),
    [anon_sym_return] = ACTIONS(1922),
    [sym_true] = ACTIONS(1922),
    [anon_sym_static] = ACTIONS(1922),
    [anon_sym_protected] = ACTIONS(1922),
    [anon_sym_long] = ACTIONS(1922),
    [anon_sym_transient] = ACTIONS(1922),
    [anon_sym_public] = ACTIONS(1922),
    [anon_sym_byte] = ACTIONS(1922),
    [sym_void_type] = ACTIONS(1922),
    [anon_sym_do] = ACTIONS(1922),
    [anon_sym_LPAREN] = ACTIONS(1924),
    [anon_sym_SEMI] = ACTIONS(1924),
    [anon_sym_break] = ACTIONS(1922),
    [anon_sym_synchronized] = ACTIONS(1922),
    [anon_sym_if] = ACTIONS(1922),
    [sym_false] = ACTIONS(1922),
    [anon_sym_module] = ACTIONS(1922),
    [anon_sym_class] = ACTIONS(1922),
    [anon_sym_interface] = ACTIONS(1922),
    [anon_sym_PLUS] = ACTIONS(1922),
    [anon_sym_BANG] = ACTIONS(1924),
    [sym_decimal_integer_literal] = ACTIONS(1922),
    [anon_sym_double] = ACTIONS(1922),
    [sym_binary_integer_literal] = ACTIONS(1924),
    [anon_sym_else] = ACTIONS(1922),
    [anon_sym_for] = ACTIONS(1922),
    [anon_sym_native] = ACTIONS(1922),
    [sym_octal_integer_literal] = ACTIONS(1924),
    [anon_sym_new] = ACTIONS(1922),
    [anon_sym_AT] = ACTIONS(1922),
    [anon_sym_float] = ACTIONS(1922),
    [sym_hex_floating_point_literal] = ACTIONS(1922),
    [anon_sym_continue] = ACTIONS(1922),
    [anon_sym_import] = ACTIONS(1922),
    [anon_sym_open] = ACTIONS(1922),
  },
  [573] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(965),
  },
  [574] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(1926),
  },
  [575] = {
    [anon_sym_RPAREN] = ACTIONS(1928),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1928),
    [anon_sym_SEMI] = ACTIONS(1928),
    [anon_sym_RBRACE] = ACTIONS(1928),
  },
  [576] = {
    [aux_sym_element_value_array_initializer_repeat1] = STATE(699),
    [anon_sym_RBRACE] = ACTIONS(1926),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1930),
  },
  [577] = {
    [sym_instanceof_expression] = STATE(701),
    [sym_element_value_array_initializer] = STATE(700),
    [sym_assignment_expression] = STATE(701),
    [sym_annotation] = STATE(428),
    [sym_array_creation_expression] = STATE(41),
    [sym_marker_annotation] = STATE(428),
    [sym_ternary_expression] = STATE(701),
    [sym_object_creation_expression] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym__expression] = STATE(701),
    [sym__element_value] = STATE(700),
    [sym_method_reference] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym__primary_no_new_array] = STATE(43),
    [sym_inferred_parameters] = STATE(42),
    [sym_lambda_expression] = STATE(701),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_field_access] = STATE(39),
    [sym_parenthesized_expression] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym_floating_point_type] = STATE(30),
    [sym_class_literal] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym__primary] = STATE(41),
    [sym_method_invocation] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_binary_expression] = STATE(701),
    [sym_integral_type] = STATE(30),
    [sym__annotation] = STATE(428),
    [sym_unary_expression] = STATE(701),
    [sym_update_expression] = STATE(701),
    [sym__type] = STATE(37),
    [sym_annotated_type] = STATE(37),
    [sym_array_access] = STATE(39),
    [sym_cast_expression] = STATE(701),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACE] = ACTIONS(971),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
    [anon_sym_open] = ACTIONS(120),
    [sym_false] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_super] = ACTIONS(9),
    [anon_sym_byte] = ACTIONS(33),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_identifier] = ACTIONS(124),
    [sym_void_type] = ACTIONS(55),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
  },
  [578] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_char] = ACTIONS(1932),
    [anon_sym_transient] = ACTIONS(1932),
    [anon_sym_default] = ACTIONS(1932),
    [anon_sym_float] = ACTIONS(1932),
    [anon_sym_class] = ACTIONS(1932),
    [anon_sym_final] = ACTIONS(1932),
    [anon_sym_abstract] = ACTIONS(1932),
    [anon_sym_public] = ACTIONS(1932),
    [anon_sym_AT] = ACTIONS(1932),
    [anon_sym_short] = ACTIONS(1932),
    [anon_sym_native] = ACTIONS(1932),
    [anon_sym_interface] = ACTIONS(1932),
    [sym_identifier] = ACTIONS(1932),
    [anon_sym_LT] = ACTIONS(1934),
    [sym_void_type] = ACTIONS(1932),
    [anon_sym_module] = ACTIONS(1932),
    [anon_sym_double] = ACTIONS(1932),
    [anon_sym_byte] = ACTIONS(1932),
    [anon_sym_volatile] = ACTIONS(1932),
    [anon_sym_ATinterface] = ACTIONS(1934),
    [anon_sym_enum] = ACTIONS(1932),
    [anon_sym_open] = ACTIONS(1932),
    [anon_sym_package] = ACTIONS(1932),
    [anon_sym_private] = ACTIONS(1932),
    [anon_sym_synchronized] = ACTIONS(1932),
    [sym_boolean_type] = ACTIONS(1932),
    [anon_sym_protected] = ACTIONS(1932),
    [anon_sym_int] = ACTIONS(1932),
    [anon_sym_long] = ACTIONS(1932),
    [anon_sym_static] = ACTIONS(1932),
    [anon_sym_strictfp] = ACTIONS(1932),
  },
  [579] = {
    [sym_element_value_pair] = STATE(703),
    [sym_identifier] = ACTIONS(1936),
    [sym_comment] = ACTIONS(3),
  },
  [580] = {
    [aux_sym_annotation_argument_list_repeat1] = STATE(705),
    [anon_sym_COMMA] = ACTIONS(1387),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1938),
  },
  [581] = {
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_RPAREN] = ACTIONS(1940),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_PIPE] = ACTIONS(291),
  },
  [582] = {
    [sym_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym_dimensions] = STATE(307),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [anon_sym_LBRACK] = ACTIONS(241),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ] = ACTIONS(673),
    [anon_sym_COMMA] = ACTIONS(673),
    [anon_sym_SEMI] = ACTIONS(673),
    [anon_sym_LPAREN] = ACTIONS(1942),
    [anon_sym_AT] = ACTIONS(118),
  },
  [583] = {
    [sym__variable_declarator_list] = STATE(687),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym_variable_declarator] = STATE(143),
    [sym__variable_declarator_id] = STATE(142),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_annotation] = STATE(145),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(243),
    [anon_sym_AT] = ACTIONS(118),
    [sym_identifier] = ACTIONS(1944),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [584] = {
    [anon_sym_short] = ACTIONS(1946),
    [sym_binary_integer_literal] = ACTIONS(1948),
    [anon_sym_assert] = ACTIONS(1946),
    [anon_sym_static] = ACTIONS(1946),
    [anon_sym_TILDE] = ACTIONS(1948),
    [anon_sym_switch] = ACTIONS(1946),
    [sym_hex_floating_point_literal] = ACTIONS(1946),
    [sym_null_literal] = ACTIONS(1946),
    [anon_sym_open] = ACTIONS(1946),
    [anon_sym_final] = ACTIONS(1946),
    [anon_sym_while] = ACTIONS(1946),
    [sym_true] = ACTIONS(1946),
    [anon_sym_LPAREN] = ACTIONS(1948),
    [anon_sym_LBRACE] = ACTIONS(1948),
    [anon_sym_byte] = ACTIONS(1946),
    [anon_sym_transient] = ACTIONS(1946),
    [sym_identifier] = ACTIONS(1946),
    [anon_sym_LT] = ACTIONS(1948),
    [anon_sym_PLUS] = ACTIONS(1946),
    [anon_sym_enum] = ACTIONS(1946),
    [anon_sym_continue] = ACTIONS(1946),
    [anon_sym_for] = ACTIONS(1946),
    [sym_boolean_type] = ACTIONS(1946),
    [anon_sym_char] = ACTIONS(1946),
    [anon_sym_SEMI] = ACTIONS(1948),
    [anon_sym_long] = ACTIONS(1946),
    [anon_sym_DASH] = ACTIONS(1946),
    [anon_sym_float] = ACTIONS(1946),
    [ts_builtin_sym_end] = ACTIONS(1948),
    [anon_sym_PLUS_PLUS] = ACTIONS(1948),
    [sym_false] = ACTIONS(1946),
    [anon_sym_volatile] = ACTIONS(1946),
    [anon_sym_int] = ACTIONS(1946),
    [anon_sym_throw] = ACTIONS(1946),
    [anon_sym_native] = ACTIONS(1946),
    [anon_sym_new] = ACTIONS(1946),
    [anon_sym_double] = ACTIONS(1946),
    [anon_sym_case] = ACTIONS(1946),
    [anon_sym_synchronized] = ACTIONS(1946),
    [anon_sym_interface] = ACTIONS(1946),
    [anon_sym_if] = ACTIONS(1946),
    [anon_sym_strictfp] = ACTIONS(1946),
    [sym_this] = ACTIONS(1946),
    [anon_sym_DASH_DASH] = ACTIONS(1948),
    [sym_super] = ACTIONS(1946),
    [anon_sym_AT] = ACTIONS(1946),
    [anon_sym_break] = ACTIONS(1946),
    [anon_sym_try] = ACTIONS(1946),
    [anon_sym_import] = ACTIONS(1946),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(1948),
    [anon_sym_do] = ACTIONS(1946),
    [sym_decimal_floating_point_literal] = ACTIONS(1948),
    [anon_sym_public] = ACTIONS(1946),
    [sym_decimal_integer_literal] = ACTIONS(1946),
    [anon_sym_default] = ACTIONS(1946),
    [anon_sym_module] = ACTIONS(1946),
    [sym_character_literal] = ACTIONS(1948),
    [anon_sym_class] = ACTIONS(1946),
    [anon_sym_protected] = ACTIONS(1946),
    [sym_string_literal] = ACTIONS(1948),
    [anon_sym_abstract] = ACTIONS(1946),
    [anon_sym_package] = ACTIONS(1946),
    [anon_sym_ATinterface] = ACTIONS(1948),
    [sym_hex_integer_literal] = ACTIONS(1946),
    [sym_octal_integer_literal] = ACTIONS(1948),
    [anon_sym_private] = ACTIONS(1946),
    [sym_void_type] = ACTIONS(1946),
    [anon_sym_else] = ACTIONS(1946),
    [anon_sym_RBRACE] = ACTIONS(1948),
    [anon_sym_return] = ACTIONS(1946),
  },
  [585] = {
    [sym_marker_annotation] = STATE(44),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_annotation_type_element_declaration] = STATE(434),
    [sym_interface_declaration] = STATE(434),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_annotation_type_member_declaration] = STATE(585),
    [sym_annotation_type_declaration] = STATE(45),
    [aux_sym_annotation_type_body_repeat1] = STATE(585),
    [sym_annotation] = STATE(44),
    [sym_integral_type] = STATE(433),
    [sym_constant_declaration] = STATE(434),
    [sym_array_type] = STATE(433),
    [sym_class_declaration] = STATE(434),
    [sym_floating_point_type] = STATE(433),
    [sym__unannotated_type] = STATE(433),
    [sym_modifiers] = STATE(435),
    [sym_generic_type] = STATE(53),
    [sym__annotation] = STATE(44),
    [anon_sym_RBRACE] = ACTIONS(1950),
    [anon_sym_private] = ACTIONS(1952),
    [anon_sym_ATinterface] = ACTIONS(1955),
    [anon_sym_short] = ACTIONS(1958),
    [anon_sym_default] = ACTIONS(1952),
    [anon_sym_float] = ACTIONS(1961),
    [anon_sym_abstract] = ACTIONS(1952),
    [anon_sym_static] = ACTIONS(1952),
    [anon_sym_final] = ACTIONS(1952),
    [anon_sym_double] = ACTIONS(1961),
    [anon_sym_protected] = ACTIONS(1952),
    [anon_sym_interface] = ACTIONS(1964),
    [anon_sym_int] = ACTIONS(1958),
    [anon_sym_byte] = ACTIONS(1958),
    [anon_sym_transient] = ACTIONS(1952),
    [anon_sym_synchronized] = ACTIONS(1952),
    [sym_comment] = ACTIONS(3),
    [sym_boolean_type] = ACTIONS(1967),
    [anon_sym_char] = ACTIONS(1958),
    [anon_sym_strictfp] = ACTIONS(1952),
    [sym_identifier] = ACTIONS(1970),
    [anon_sym_native] = ACTIONS(1952),
    [anon_sym_volatile] = ACTIONS(1952),
    [anon_sym_long] = ACTIONS(1958),
    [sym_void_type] = ACTIONS(1967),
    [anon_sym_AT] = ACTIONS(1973),
    [anon_sym_public] = ACTIONS(1952),
    [anon_sym_class] = ACTIONS(1976),
  },
  [586] = {
    [sym_expression_statement] = STATE(709),
    [sym_instanceof_expression] = STATE(49),
    [sym_if_statement] = STATE(709),
    [sym_continue_statement] = STATE(709),
    [sym_marker_annotation] = STATE(51),
    [sym_local_variable_declaration_statement] = STATE(709),
    [sym_cast_expression] = STATE(49),
    [sym_annotated_type] = STATE(37),
    [sym_return_statement] = STATE(709),
    [sym_synchronized_statement] = STATE(709),
    [sym_ternary_expression] = STATE(49),
    [sym_import_declaration] = STATE(709),
    [sym_array_type] = STATE(40),
    [sym_labeled_statement] = STATE(709),
    [sym_annotation] = STATE(51),
    [sym_method_invocation] = STATE(43),
    [sym_do_statement] = STATE(709),
    [sym__unannotated_type] = STATE(40),
    [sym__primary] = STATE(41),
    [sym__annotation] = STATE(51),
    [sym__expression] = STATE(49),
    [sym_parenthesized_expression] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym_enhanced_for_statement] = STATE(709),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_module_declaration] = STATE(709),
    [sym__primary_no_new_array] = STATE(43),
    [sym_update_expression] = STATE(49),
    [sym_lambda_expression] = STATE(49),
    [sym_field_access] = STATE(39),
    [sym__literal] = STATE(43),
    [sym_try_with_resources_statement] = STATE(709),
    [sym_binary_expression] = STATE(49),
    [sym_for_statement] = STATE(709),
    [sym_class_declaration] = STATE(709),
    [sym__type] = STATE(37),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_throw_statement] = STATE(709),
    [sym_modifiers] = STATE(48),
    [sym__declaration] = STATE(709),
    [sym_assert_statement] = STATE(709),
    [sym_floating_point_type] = STATE(30),
    [sym_unary_expression] = STATE(49),
    [sym_enum_declaration] = STATE(709),
    [sym_formal_parameters] = STATE(42),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_array_creation_expression] = STATE(41),
    [sym_package_declaration] = STATE(709),
    [sym_object_creation_expression] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym_inferred_parameters] = STATE(42),
    [sym_while_statement] = STATE(709),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_switch_statement] = STATE(709),
    [sym_assignment_expression] = STATE(49),
    [sym_break_statement] = STATE(709),
    [sym_method_reference] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_interface_declaration] = STATE(709),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_local_variable_declaration] = STATE(47),
    [sym_block] = STATE(709),
    [sym_class_literal] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_try_statement] = STATE(709),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(67),
    [sym_null_literal] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_char] = ACTIONS(33),
    [sym_false] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(33),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(17),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [sym_true] = ACTIONS(5),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_static] = ACTIONS(7),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(43),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_SEMI] = ACTIONS(1979),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(7),
    [sym_identifier] = ACTIONS(13),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(7),
    [sym_this] = ACTIONS(5),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_double] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_new] = ACTIONS(19),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_try] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_super] = ACTIONS(9),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(7),
  },
  [587] = {
    [aux_sym_argument_list_repeat1] = STATE(711),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_RPAREN] = ACTIONS(1981),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_LT_LT] = ACTIONS(285),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_COMMA] = ACTIONS(771),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
  },
  [588] = {
    [sym_array_access] = STATE(39),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_lambda_expression] = STATE(712),
    [sym_marker_annotation] = STATE(74),
    [sym_array_creation_expression] = STATE(41),
    [sym_floating_point_type] = STATE(30),
    [sym__type] = STATE(37),
    [sym_parenthesized_expression] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym_object_creation_expression] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym__unannotated_type] = STATE(73),
    [sym_scoped_identifier] = STATE(52),
    [sym_generic_type] = STATE(53),
    [sym_inferred_parameters] = STATE(42),
    [sym_method_reference] = STATE(43),
    [sym_cast_expression] = STATE(712),
    [sym_integral_type] = STATE(30),
    [sym_instanceof_expression] = STATE(712),
    [sym_ternary_expression] = STATE(712),
    [sym__expression] = STATE(712),
    [sym_field_access] = STATE(39),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_unary_expression] = STATE(712),
    [sym_binary_expression] = STATE(712),
    [sym__primary_no_new_array] = STATE(43),
    [sym_update_expression] = STATE(712),
    [sym__primary] = STATE(41),
    [sym_annotation] = STATE(74),
    [sym_assignment_expression] = STATE(712),
    [sym_array_type] = STATE(73),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_class_literal] = STATE(43),
    [sym_method_invocation] = STATE(43),
    [sym__annotation] = STATE(74),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_double] = ACTIONS(41),
    [sym_identifier] = ACTIONS(124),
    [sym_void_type] = ACTIONS(55),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_byte] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_short] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(1981),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(47),
  },
  [589] = {
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(1983),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_PERCENT] = ACTIONS(285),
  },
  [590] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(681),
    [anon_sym_EQ] = ACTIONS(679),
    [anon_sym_COMMA] = ACTIONS(681),
    [anon_sym_COLON] = ACTIONS(1985),
  },
  [591] = {
    [sym_object_creation_expression] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__type] = STATE(37),
    [sym__literal] = STATE(43),
    [sym__primary_no_new_array] = STATE(43),
    [sym_binary_expression] = STATE(715),
    [sym_array_type] = STATE(73),
    [sym__annotation] = STATE(74),
    [sym_method_invocation] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_scoped_identifier] = STATE(52),
    [sym_marker_annotation] = STATE(74),
    [sym_lambda_expression] = STATE(715),
    [sym_annotation] = STATE(74),
    [sym_method_reference] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_ternary_expression] = STATE(715),
    [sym__unannotated_type] = STATE(73),
    [sym_formal_parameters] = STATE(42),
    [sym_update_expression] = STATE(715),
    [sym_parenthesized_expression] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_instanceof_expression] = STATE(715),
    [sym_floating_point_type] = STATE(30),
    [sym_inferred_parameters] = STATE(42),
    [sym_cast_expression] = STATE(715),
    [sym__expression] = STATE(715),
    [sym_integral_type] = STATE(30),
    [sym_class_literal] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_unary_expression] = STATE(715),
    [sym_assignment_expression] = STATE(715),
    [sym_field_access] = STATE(39),
    [sym_generic_type] = STATE(53),
    [sym_annotated_type] = STATE(37),
    [sym_array_creation_expression] = STATE(41),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_int] = ACTIONS(33),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_new] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(118),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_char] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_character_literal] = ACTIONS(35),
    [sym_string_literal] = ACTIONS(35),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_float] = ACTIONS(41),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
  },
  [592] = {
    [anon_sym_static] = ACTIONS(1987),
    [anon_sym_int] = ACTIONS(1987),
    [sym_hex_integer_literal] = ACTIONS(1987),
    [anon_sym_public] = ACTIONS(1987),
    [anon_sym_char] = ACTIONS(1987),
    [anon_sym_case] = ACTIONS(1987),
    [anon_sym_BANG] = ACTIONS(1989),
    [anon_sym_DASH] = ACTIONS(1987),
    [anon_sym_PLUS] = ACTIONS(1987),
    [anon_sym_continue] = ACTIONS(1987),
    [anon_sym_enum] = ACTIONS(1987),
    [anon_sym_final] = ACTIONS(1987),
    [anon_sym_double] = ACTIONS(1987),
    [sym_boolean_type] = ACTIONS(1987),
    [anon_sym_while] = ACTIONS(1987),
    [ts_builtin_sym_end] = ACTIONS(1989),
    [anon_sym_LT] = ACTIONS(1989),
    [anon_sym_module] = ACTIONS(1987),
    [anon_sym_open] = ACTIONS(1987),
    [anon_sym_short] = ACTIONS(1987),
    [sym_void_type] = ACTIONS(1987),
    [anon_sym_RBRACE] = ACTIONS(1989),
    [sym_null_literal] = ACTIONS(1987),
    [anon_sym_return] = ACTIONS(1987),
    [anon_sym_try] = ACTIONS(1987),
    [anon_sym_LBRACE] = ACTIONS(1989),
    [anon_sym_if] = ACTIONS(1987),
    [anon_sym_interface] = ACTIONS(1987),
    [sym_false] = ACTIONS(1987),
    [sym_super] = ACTIONS(1987),
    [anon_sym_long] = ACTIONS(1987),
    [sym_hex_floating_point_literal] = ACTIONS(1987),
    [anon_sym_SEMI] = ACTIONS(1989),
    [anon_sym_default] = ACTIONS(1987),
    [sym_comment] = ACTIONS(3),
    [sym_octal_integer_literal] = ACTIONS(1989),
    [anon_sym_for] = ACTIONS(1987),
    [anon_sym_abstract] = ACTIONS(1987),
    [sym_character_literal] = ACTIONS(1989),
    [anon_sym_LPAREN] = ACTIONS(1989),
    [anon_sym_private] = ACTIONS(1987),
    [anon_sym_native] = ACTIONS(1987),
    [anon_sym_switch] = ACTIONS(1987),
    [sym_identifier] = ACTIONS(1987),
    [anon_sym_volatile] = ACTIONS(1987),
    [anon_sym_class] = ACTIONS(1987),
    [anon_sym_ATinterface] = ACTIONS(1989),
    [anon_sym_TILDE] = ACTIONS(1989),
    [anon_sym_import] = ACTIONS(1987),
    [anon_sym_transient] = ACTIONS(1987),
    [anon_sym_throw] = ACTIONS(1987),
    [sym_decimal_floating_point_literal] = ACTIONS(1989),
    [sym_true] = ACTIONS(1987),
    [sym_string_literal] = ACTIONS(1989),
    [anon_sym_PLUS_PLUS] = ACTIONS(1989),
    [anon_sym_synchronized] = ACTIONS(1987),
    [anon_sym_float] = ACTIONS(1987),
    [anon_sym_new] = ACTIONS(1987),
    [sym_this] = ACTIONS(1987),
    [anon_sym_DASH_DASH] = ACTIONS(1989),
    [anon_sym_else] = ACTIONS(1987),
    [sym_decimal_integer_literal] = ACTIONS(1987),
    [anon_sym_do] = ACTIONS(1987),
    [anon_sym_AT] = ACTIONS(1987),
    [anon_sym_assert] = ACTIONS(1987),
    [anon_sym_package] = ACTIONS(1987),
    [anon_sym_byte] = ACTIONS(1987),
    [sym_binary_integer_literal] = ACTIONS(1989),
    [anon_sym_protected] = ACTIONS(1987),
    [anon_sym_strictfp] = ACTIONS(1987),
    [anon_sym_break] = ACTIONS(1987),
  },
  [593] = {
    [anon_sym_RBRACE] = ACTIONS(1991),
    [sym_comment] = ACTIONS(3),
  },
  [594] = {
    [anon_sym_COMMA] = ACTIONS(1993),
    [anon_sym_RBRACE] = ACTIONS(1993),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1993),
  },
  [595] = {
    [sym_class_body] = STATE(717),
    [anon_sym_COMMA] = ACTIONS(1993),
    [anon_sym_SEMI] = ACTIONS(1993),
    [anon_sym_RBRACE] = ACTIONS(1993),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(439),
  },
  [596] = {
    [sym_type_parameters] = STATE(382),
    [sym_generic_type] = STATE(53),
    [sym_constructor_declaration] = STATE(534),
    [sym_enum_declaration] = STATE(534),
    [sym__annotation] = STATE(44),
    [sym_marker_annotation] = STATE(44),
    [sym_floating_point_type] = STATE(381),
    [sym_annotation_type_declaration] = STATE(45),
    [sym__method_header] = STATE(378),
    [sym_annotation] = STATE(44),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(381),
    [sym_constructor_declarator] = STATE(377),
    [aux_sym_enum_body_declarations_repeat1] = STATE(534),
    [sym_class_declaration] = STATE(534),
    [sym_modifiers] = STATE(380),
    [sym_block] = STATE(534),
    [sym_field_declaration] = STATE(534),
    [sym_array_type] = STATE(381),
    [sym_static_initializer] = STATE(534),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_method_declaration] = STATE(534),
    [sym_interface_declaration] = STATE(534),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym__unannotated_type] = STATE(381),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_synchronized] = ACTIONS(7),
    [anon_sym_default] = ACTIONS(7),
    [sym_void_type] = ACTIONS(895),
    [anon_sym_RBRACE] = ACTIONS(1995),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1250),
    [anon_sym_double] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(895),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(29),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_static] = ACTIONS(897),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_long] = ACTIONS(33),
    [sym_identifier] = ACTIONS(901),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_abstract] = ACTIONS(7),
  },
  [597] = {
    [sym_annotation] = STATE(902),
    [sym_modifiers] = STATE(449),
    [sym_enum_body_declarations] = STATE(718),
    [sym_marker_annotation] = STATE(902),
    [sym_enum_constant] = STATE(719),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym__annotation] = STATE(902),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_RBRACE] = ACTIONS(1991),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [sym_identifier] = ACTIONS(1009),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_final] = ACTIONS(126),
  },
  [598] = {
    [sym_enum_body_declarations] = STATE(718),
    [aux_sym_enum_declaration_repeat1] = STATE(721),
    [anon_sym_RBRACE] = ACTIONS(1991),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_COMMA] = ACTIONS(1997),
    [sym_comment] = ACTIONS(3),
  },
  [599] = {
    [sym_class_body] = STATE(717),
    [sym_argument_list] = STATE(722),
    [anon_sym_LPAREN] = ACTIONS(112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(1993),
    [anon_sym_RBRACE] = ACTIONS(1993),
    [anon_sym_SEMI] = ACTIONS(1993),
    [anon_sym_LBRACE] = ACTIONS(439),
  },
  [600] = {
    [sym_enum_body_declarations] = STATE(718),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_RBRACE] = ACTIONS(1991),
    [sym_comment] = ACTIONS(3),
  },
  [601] = {
    [sym_enum_body_declarations] = STATE(718),
    [aux_sym_enum_declaration_repeat1] = STATE(723),
    [anon_sym_RBRACE] = ACTIONS(1991),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_COMMA] = ACTIONS(1997),
  },
  [602] = {
    [anon_sym_for] = ACTIONS(1999),
    [anon_sym_LPAREN] = ACTIONS(2001),
    [anon_sym_TILDE] = ACTIONS(2001),
    [anon_sym_try] = ACTIONS(1999),
    [anon_sym_throw] = ACTIONS(1999),
    [sym_decimal_floating_point_literal] = ACTIONS(2001),
    [anon_sym_switch] = ACTIONS(1999),
    [sym_this] = ACTIONS(1999),
    [anon_sym_int] = ACTIONS(1999),
    [anon_sym_short] = ACTIONS(1999),
    [anon_sym_interface] = ACTIONS(1999),
    [anon_sym_new] = ACTIONS(1999),
    [anon_sym_synchronized] = ACTIONS(1999),
    [anon_sym_assert] = ACTIONS(1999),
    [anon_sym_continue] = ACTIONS(1999),
    [sym_octal_integer_literal] = ACTIONS(2001),
    [anon_sym_open] = ACTIONS(1999),
    [sym_false] = ACTIONS(1999),
    [anon_sym_DASH_DASH] = ACTIONS(2001),
    [anon_sym_protected] = ACTIONS(1999),
    [anon_sym_abstract] = ACTIONS(1999),
    [sym_null_literal] = ACTIONS(1999),
    [anon_sym_if] = ACTIONS(1999),
    [sym_hex_integer_literal] = ACTIONS(1999),
    [anon_sym_default] = ACTIONS(1999),
    [anon_sym_PLUS] = ACTIONS(1999),
    [anon_sym_do] = ACTIONS(1999),
    [anon_sym_static] = ACTIONS(1999),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(1999),
    [anon_sym_SEMI] = ACTIONS(2001),
    [sym_true] = ACTIONS(1999),
    [anon_sym_transient] = ACTIONS(1999),
    [anon_sym_byte] = ACTIONS(1999),
    [anon_sym_PLUS_PLUS] = ACTIONS(2001),
    [sym_character_literal] = ACTIONS(2001),
    [anon_sym_while] = ACTIONS(1999),
    [sym_super] = ACTIONS(1999),
    [ts_builtin_sym_end] = ACTIONS(2001),
    [anon_sym_AT] = ACTIONS(1999),
    [anon_sym_else] = ACTIONS(1999),
    [anon_sym_private] = ACTIONS(1999),
    [anon_sym_public] = ACTIONS(1999),
    [sym_void_type] = ACTIONS(1999),
    [anon_sym_BANG] = ACTIONS(2001),
    [anon_sym_case] = ACTIONS(1999),
    [anon_sym_double] = ACTIONS(1999),
    [sym_binary_integer_literal] = ACTIONS(2001),
    [anon_sym_return] = ACTIONS(1999),
    [anon_sym_char] = ACTIONS(1999),
    [anon_sym_strictfp] = ACTIONS(1999),
    [anon_sym_break] = ACTIONS(1999),
    [anon_sym_DASH] = ACTIONS(1999),
    [sym_string_literal] = ACTIONS(2001),
    [anon_sym_package] = ACTIONS(1999),
    [sym_boolean_type] = ACTIONS(1999),
    [anon_sym_import] = ACTIONS(1999),
    [anon_sym_enum] = ACTIONS(1999),
    [sym_decimal_integer_literal] = ACTIONS(1999),
    [anon_sym_float] = ACTIONS(1999),
    [anon_sym_long] = ACTIONS(1999),
    [sym_hex_floating_point_literal] = ACTIONS(1999),
    [anon_sym_native] = ACTIONS(1999),
    [anon_sym_RBRACE] = ACTIONS(2001),
    [anon_sym_volatile] = ACTIONS(1999),
    [sym_identifier] = ACTIONS(1999),
    [anon_sym_class] = ACTIONS(1999),
    [anon_sym_ATinterface] = ACTIONS(2001),
    [anon_sym_LBRACE] = ACTIONS(2001),
    [anon_sym_final] = ACTIONS(1999),
  },
  [603] = {
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_inferred_parameters] = STATE(42),
    [sym_floating_point_type] = STATE(30),
    [sym__primary_no_new_array] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym_lambda_expression] = STATE(724),
    [sym_assignment_expression] = STATE(724),
    [sym_parenthesized_expression] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym_field_access] = STATE(39),
    [sym_method_invocation] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_class_literal] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_method_reference] = STATE(43),
    [sym_instanceof_expression] = STATE(724),
    [sym_object_creation_expression] = STATE(43),
    [sym_binary_expression] = STATE(724),
    [sym_generic_type] = STATE(53),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_array_type] = STATE(73),
    [sym_array_creation_expression] = STATE(41),
    [sym__primary] = STATE(41),
    [sym_array_access] = STATE(39),
    [sym__expression] = STATE(724),
    [sym_update_expression] = STATE(724),
    [sym_formal_parameters] = STATE(42),
    [sym__type] = STATE(37),
    [sym_annotation] = STATE(74),
    [sym__unannotated_type] = STATE(73),
    [sym_ternary_expression] = STATE(724),
    [sym_unary_expression] = STATE(724),
    [sym_cast_expression] = STATE(724),
    [sym_integral_type] = STATE(30),
    [sym__annotation] = STATE(74),
    [sym_binary_integer_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [sym_character_literal] = ACTIONS(35),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(120),
    [sym_void_type] = ACTIONS(55),
    [sym_true] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_new] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_false] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_PLUS] = ACTIONS(49),
  },
  [604] = {
    [anon_sym_EQ] = ACTIONS(2003),
    [sym_comment] = ACTIONS(3),
  },
  [605] = {
    [anon_sym_LBRACE] = ACTIONS(2005),
    [sym_comment] = ACTIONS(3),
  },
  [606] = {
    [anon_sym_RPAREN] = ACTIONS(2007),
    [anon_sym_SEMI] = ACTIONS(2007),
    [sym_comment] = ACTIONS(3),
  },
  [607] = {
    [sym_class_literal] = STATE(43),
    [sym__unannotated_type] = STATE(274),
    [sym__primary_no_new_array] = STATE(43),
    [sym_scoped_identifier] = STATE(276),
    [sym_integral_type] = STATE(30),
    [sym_generic_type] = STATE(53),
    [sym__annotation] = STATE(903),
    [sym_method_invocation] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_marker_annotation] = STATE(903),
    [sym_object_creation_expression] = STATE(43),
    [sym__type] = STATE(37),
    [sym_resource] = STATE(606),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_array_access] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym_array_creation_expression] = STATE(275),
    [sym_floating_point_type] = STATE(30),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_method_reference] = STATE(43),
    [sym_modifiers] = STATE(277),
    [sym_annotated_type] = STATE(37),
    [sym_annotation] = STATE(903),
    [sym_array_type] = STATE(274),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_field_access] = STATE(279),
    [sym__primary] = STATE(275),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_short] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(35),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(126),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_synchronized] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_new] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(134),
    [sym_this] = ACTIONS(5),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(126),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_long] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_RPAREN] = ACTIONS(2009),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(501),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [sym_true] = ACTIONS(5),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_int] = ACTIONS(33),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_double] = ACTIONS(41),
    [sym_character_literal] = ACTIONS(35),
    [sym_false] = ACTIONS(5),
    [anon_sym_volatile] = ACTIONS(126),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_open] = ACTIONS(501),
  },
  [608] = {
    [aux_sym_resource_specification_repeat1] = STATE(608),
    [anon_sym_RPAREN] = ACTIONS(2007),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(2011),
  },
  [609] = {
    [anon_sym_volatile] = ACTIONS(2014),
    [anon_sym_module] = ACTIONS(2014),
    [anon_sym_long] = ACTIONS(2014),
    [anon_sym_default] = ACTIONS(2014),
    [anon_sym_TILDE] = ACTIONS(2016),
    [anon_sym_break] = ACTIONS(2014),
    [sym_decimal_integer_literal] = ACTIONS(2014),
    [anon_sym_LBRACE] = ACTIONS(2016),
    [anon_sym_try] = ACTIONS(2014),
    [anon_sym_double] = ACTIONS(2014),
    [anon_sym_new] = ACTIONS(2014),
    [sym_binary_integer_literal] = ACTIONS(2016),
    [sym_decimal_floating_point_literal] = ACTIONS(2016),
    [anon_sym_DASH] = ACTIONS(2014),
    [sym_true] = ACTIONS(2014),
    [anon_sym_class] = ACTIONS(2014),
    [anon_sym_open] = ACTIONS(2014),
    [anon_sym_return] = ACTIONS(2014),
    [anon_sym_DASH_DASH] = ACTIONS(2016),
    [anon_sym_package] = ACTIONS(2014),
    [anon_sym_SEMI] = ACTIONS(2016),
    [anon_sym_import] = ACTIONS(2014),
    [anon_sym_interface] = ACTIONS(2014),
    [anon_sym_static] = ACTIONS(2014),
    [sym_string_literal] = ACTIONS(2016),
    [anon_sym_short] = ACTIONS(2014),
    [anon_sym_protected] = ACTIONS(2014),
    [anon_sym_byte] = ACTIONS(2014),
    [anon_sym_ATinterface] = ACTIONS(2016),
    [sym_void_type] = ACTIONS(2014),
    [anon_sym_synchronized] = ACTIONS(2014),
    [anon_sym_assert] = ACTIONS(2014),
    [anon_sym_enum] = ACTIONS(2014),
    [anon_sym_RBRACE] = ACTIONS(2016),
    [sym_false] = ACTIONS(2014),
    [sym_identifier] = ACTIONS(2014),
    [anon_sym_throw] = ACTIONS(2014),
    [anon_sym_strictfp] = ACTIONS(2014),
    [sym_boolean_type] = ACTIONS(2014),
    [ts_builtin_sym_end] = ACTIONS(2016),
    [anon_sym_else] = ACTIONS(2014),
    [anon_sym_char] = ACTIONS(2014),
    [anon_sym_case] = ACTIONS(2014),
    [anon_sym_LPAREN] = ACTIONS(2016),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_float] = ACTIONS(2014),
    [anon_sym_native] = ACTIONS(2014),
    [anon_sym_final] = ACTIONS(2014),
    [sym_hex_integer_literal] = ACTIONS(2014),
    [sym_super] = ACTIONS(2014),
    [anon_sym_AT] = ACTIONS(2014),
    [anon_sym_PLUS] = ACTIONS(2014),
    [sym_hex_floating_point_literal] = ACTIONS(2014),
    [anon_sym_for] = ACTIONS(2014),
    [sym_null_literal] = ACTIONS(2014),
    [anon_sym_PLUS_PLUS] = ACTIONS(2016),
    [anon_sym_switch] = ACTIONS(2014),
    [anon_sym_abstract] = ACTIONS(2014),
    [sym_comment] = ACTIONS(3),
    [anon_sym_do] = ACTIONS(2014),
    [sym_octal_integer_literal] = ACTIONS(2016),
    [anon_sym_int] = ACTIONS(2014),
    [anon_sym_while] = ACTIONS(2014),
    [anon_sym_if] = ACTIONS(2014),
    [anon_sym_continue] = ACTIONS(2014),
    [anon_sym_public] = ACTIONS(2014),
    [sym_character_literal] = ACTIONS(2016),
    [anon_sym_transient] = ACTIONS(2014),
    [sym_this] = ACTIONS(2014),
    [anon_sym_private] = ACTIONS(2014),
  },
  [610] = {
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [aux_sym_catch_type_repeat1] = STATE(729),
    [sym_dimensions] = STATE(144),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(2018),
    [anon_sym_module] = ACTIONS(2018),
    [anon_sym_PIPE] = ACTIONS(2020),
    [anon_sym_LBRACK] = ACTIONS(241),
    [sym_identifier] = ACTIONS(2018),
    [anon_sym_AT] = ACTIONS(118),
  },
  [611] = {
    [anon_sym_RPAREN] = ACTIONS(2022),
    [sym_comment] = ACTIONS(3),
  },
  [612] = {
    [sym_catch_type] = STATE(731),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(610),
    [sym__unannotated_type] = STATE(610),
    [sym_array_type] = STATE(610),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(610),
    [anon_sym_int] = ACTIONS(33),
    [sym_void_type] = ACTIONS(1441),
    [sym_boolean_type] = ACTIONS(1441),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
  },
  [613] = {
    [sym__variable_declarator_id] = STATE(732),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_open] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(247),
  },
  [614] = {
    [sym_argument_list] = STATE(733),
    [anon_sym_PIPE_PIPE] = ACTIONS(2024),
    [anon_sym_STAR] = ACTIONS(2026),
    [anon_sym_AMP_EQ] = ACTIONS(2024),
    [anon_sym_EQ_EQ] = ACTIONS(2024),
    [anon_sym_GT_GT] = ACTIONS(2026),
    [anon_sym_PIPE] = ACTIONS(2026),
    [anon_sym_PLUS_PLUS] = ACTIONS(2024),
    [anon_sym_STAR_EQ] = ACTIONS(2024),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_COLON] = ACTIONS(2026),
    [anon_sym_COLON_COLON] = ACTIONS(2024),
    [anon_sym_DOT] = ACTIONS(2024),
    [anon_sym_LT] = ACTIONS(2026),
    [anon_sym_LT_LT] = ACTIONS(2026),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SLASH_EQ] = ACTIONS(2024),
    [anon_sym_LT_LT_EQ] = ACTIONS(2024),
    [anon_sym_RBRACK] = ACTIONS(2024),
    [anon_sym_CARET_EQ] = ACTIONS(2024),
    [anon_sym_EQ] = ACTIONS(2026),
    [anon_sym_LT_EQ] = ACTIONS(2024),
    [anon_sym_PLUS_EQ] = ACTIONS(2024),
    [anon_sym_SLASH] = ACTIONS(2026),
    [anon_sym_COMMA] = ACTIONS(2024),
    [anon_sym_GT_EQ] = ACTIONS(2024),
    [anon_sym_instanceof] = ACTIONS(2024),
    [anon_sym_SEMI] = ACTIONS(2024),
    [anon_sym_QMARK] = ACTIONS(2024),
    [anon_sym_DASH_DASH] = ACTIONS(2024),
    [anon_sym_BANG_EQ] = ACTIONS(2024),
    [anon_sym_RPAREN] = ACTIONS(2024),
    [anon_sym_RBRACE] = ACTIONS(2024),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(2024),
    [anon_sym_PLUS] = ACTIONS(2026),
    [anon_sym_GT] = ACTIONS(2026),
    [anon_sym_AMP_AMP] = ACTIONS(2024),
    [anon_sym_CARET] = ACTIONS(2026),
    [anon_sym_DASH] = ACTIONS(2026),
    [anon_sym_DASH_EQ] = ACTIONS(2024),
    [anon_sym_PERCENT_EQ] = ACTIONS(2024),
    [anon_sym_GT_GT_GT] = ACTIONS(2026),
    [anon_sym_PIPE_EQ] = ACTIONS(2024),
    [anon_sym_LBRACK] = ACTIONS(2024),
    [anon_sym_AMP] = ACTIONS(2026),
    [anon_sym_PERCENT] = ACTIONS(2026),
    [anon_sym_GT_GT_EQ] = ACTIONS(2024),
  },
  [615] = {
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(2028),
  },
  [616] = {
    [anon_sym_DASH] = ACTIONS(2030),
    [anon_sym_GT_GT] = ACTIONS(2030),
    [anon_sym_PIPE] = ACTIONS(2030),
    [anon_sym_CARET] = ACTIONS(2032),
    [anon_sym_PLUS_PLUS] = ACTIONS(2032),
    [anon_sym_GT_EQ] = ACTIONS(2032),
    [anon_sym_DASH_DASH] = ACTIONS(2032),
    [anon_sym_RPAREN] = ACTIONS(2032),
    [anon_sym_COMMA] = ACTIONS(2032),
    [anon_sym_LBRACK] = ACTIONS(2032),
    [anon_sym_SLASH] = ACTIONS(2030),
    [anon_sym_COLON_COLON] = ACTIONS(2032),
    [anon_sym_AMP_AMP] = ACTIONS(2032),
    [anon_sym_EQ_EQ] = ACTIONS(2032),
    [anon_sym_SEMI] = ACTIONS(2032),
    [anon_sym_BANG_EQ] = ACTIONS(2032),
    [anon_sym_GT_GT_GT] = ACTIONS(2032),
    [anon_sym_STAR] = ACTIONS(2032),
    [anon_sym_LT] = ACTIONS(2030),
    [anon_sym_PLUS] = ACTIONS(2030),
    [anon_sym_PERCENT] = ACTIONS(2032),
    [anon_sym_GT] = ACTIONS(2030),
    [anon_sym_QMARK] = ACTIONS(2032),
    [anon_sym_COLON] = ACTIONS(2030),
    [anon_sym_AMP] = ACTIONS(2030),
    [anon_sym_instanceof] = ACTIONS(2032),
    [anon_sym_LT_LT] = ACTIONS(2032),
    [anon_sym_RBRACK] = ACTIONS(2032),
    [anon_sym_DOT] = ACTIONS(2032),
    [anon_sym_PIPE_PIPE] = ACTIONS(2032),
    [anon_sym_LT_EQ] = ACTIONS(2032),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(2032),
  },
  [617] = {
    [anon_sym_case] = ACTIONS(2034),
    [anon_sym_AT] = ACTIONS(2034),
    [anon_sym_TILDE] = ACTIONS(2036),
    [anon_sym_BANG] = ACTIONS(2036),
    [anon_sym_double] = ACTIONS(2034),
    [anon_sym_native] = ACTIONS(2034),
    [anon_sym_RBRACE] = ACTIONS(2036),
    [anon_sym_PLUS] = ACTIONS(2034),
    [sym_comment] = ACTIONS(3),
    [ts_builtin_sym_end] = ACTIONS(2036),
    [anon_sym_LBRACE] = ACTIONS(2036),
    [sym_string_literal] = ACTIONS(2036),
    [anon_sym_DASH_DASH] = ACTIONS(2036),
    [anon_sym_default] = ACTIONS(2034),
    [anon_sym_static] = ACTIONS(2034),
    [anon_sym_transient] = ACTIONS(2034),
    [sym_character_literal] = ACTIONS(2036),
    [anon_sym_float] = ACTIONS(2034),
    [anon_sym_final] = ACTIONS(2034),
    [anon_sym_long] = ACTIONS(2034),
    [anon_sym_switch] = ACTIONS(2034),
    [anon_sym_for] = ACTIONS(2034),
    [anon_sym_import] = ACTIONS(2034),
    [anon_sym_package] = ACTIONS(2034),
    [sym_true] = ACTIONS(2034),
    [anon_sym_module] = ACTIONS(2034),
    [anon_sym_class] = ACTIONS(2034),
    [sym_decimal_floating_point_literal] = ACTIONS(2036),
    [sym_hex_integer_literal] = ACTIONS(2034),
    [anon_sym_PLUS_PLUS] = ACTIONS(2036),
    [anon_sym_byte] = ACTIONS(2034),
    [sym_octal_integer_literal] = ACTIONS(2036),
    [anon_sym_while] = ACTIONS(2034),
    [anon_sym_break] = ACTIONS(2034),
    [anon_sym_ATinterface] = ACTIONS(2036),
    [sym_this] = ACTIONS(2034),
    [sym_void_type] = ACTIONS(2034),
    [anon_sym_assert] = ACTIONS(2034),
    [anon_sym_continue] = ACTIONS(2034),
    [sym_false] = ACTIONS(2034),
    [sym_hex_floating_point_literal] = ACTIONS(2034),
    [sym_decimal_integer_literal] = ACTIONS(2034),
    [anon_sym_try] = ACTIONS(2034),
    [anon_sym_abstract] = ACTIONS(2034),
    [anon_sym_strictfp] = ACTIONS(2034),
    [sym_binary_integer_literal] = ACTIONS(2036),
    [anon_sym_enum] = ACTIONS(2034),
    [anon_sym_SEMI] = ACTIONS(2036),
    [anon_sym_int] = ACTIONS(2034),
    [sym_super] = ACTIONS(2034),
    [anon_sym_if] = ACTIONS(2034),
    [anon_sym_synchronized] = ACTIONS(2034),
    [anon_sym_protected] = ACTIONS(2034),
    [anon_sym_private] = ACTIONS(2034),
    [sym_identifier] = ACTIONS(2034),
    [anon_sym_char] = ACTIONS(2034),
    [sym_null_literal] = ACTIONS(2034),
    [anon_sym_public] = ACTIONS(2034),
    [anon_sym_volatile] = ACTIONS(2034),
    [anon_sym_open] = ACTIONS(2034),
    [anon_sym_new] = ACTIONS(2034),
    [anon_sym_return] = ACTIONS(2034),
    [anon_sym_DASH] = ACTIONS(2034),
    [anon_sym_else] = ACTIONS(2034),
    [anon_sym_do] = ACTIONS(2034),
    [anon_sym_throw] = ACTIONS(2034),
    [anon_sym_interface] = ACTIONS(2034),
    [anon_sym_short] = ACTIONS(2034),
    [anon_sym_LPAREN] = ACTIONS(2036),
    [sym_boolean_type] = ACTIONS(2034),
  },
  [618] = {
    [sym_module_directive] = STATE(632),
    [aux_sym_module_declaration_repeat1] = STATE(632),
    [anon_sym_RBRACE] = ACTIONS(2038),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_provides] = ACTIONS(1081),
    [sym_comment] = ACTIONS(3),
    [anon_sym_requires] = ACTIONS(1087),
  },
  [619] = {
    [anon_sym_class] = ACTIONS(2040),
    [anon_sym_default] = ACTIONS(2040),
    [anon_sym_abstract] = ACTIONS(2040),
    [sym_null_literal] = ACTIONS(2040),
    [anon_sym_DASH_DASH] = ACTIONS(2042),
    [anon_sym_if] = ACTIONS(2040),
    [sym_hex_integer_literal] = ACTIONS(2040),
    [anon_sym_AT] = ACTIONS(2040),
    [anon_sym_public] = ACTIONS(2040),
    [anon_sym_static] = ACTIONS(2040),
    [anon_sym_open] = ACTIONS(2040),
    [anon_sym_case] = ACTIONS(2040),
    [anon_sym_synchronized] = ACTIONS(2040),
    [ts_builtin_sym_end] = ACTIONS(2042),
    [sym_decimal_floating_point_literal] = ACTIONS(2042),
    [anon_sym_return] = ACTIONS(2040),
    [anon_sym_transient] = ACTIONS(2040),
    [anon_sym_import] = ACTIONS(2040),
    [anon_sym_new] = ACTIONS(2040),
    [anon_sym_int] = ACTIONS(2040),
    [anon_sym_break] = ACTIONS(2040),
    [anon_sym_long] = ACTIONS(2040),
    [sym_false] = ACTIONS(2040),
    [anon_sym_try] = ACTIONS(2040),
    [anon_sym_native] = ACTIONS(2040),
    [anon_sym_PLUS] = ACTIONS(2040),
    [sym_boolean_type] = ACTIONS(2040),
    [anon_sym_DASH] = ACTIONS(2040),
    [anon_sym_byte] = ACTIONS(2040),
    [anon_sym_continue] = ACTIONS(2040),
    [anon_sym_short] = ACTIONS(2040),
    [anon_sym_switch] = ACTIONS(2040),
    [anon_sym_else] = ACTIONS(2040),
    [sym_decimal_integer_literal] = ACTIONS(2040),
    [anon_sym_strictfp] = ACTIONS(2040),
    [anon_sym_SEMI] = ACTIONS(2042),
    [sym_comment] = ACTIONS(3),
    [sym_super] = ACTIONS(2040),
    [anon_sym_while] = ACTIONS(2040),
    [anon_sym_private] = ACTIONS(2040),
    [anon_sym_PLUS_PLUS] = ACTIONS(2042),
    [sym_true] = ACTIONS(2040),
    [anon_sym_BANG] = ACTIONS(2042),
    [anon_sym_protected] = ACTIONS(2040),
    [sym_string_literal] = ACTIONS(2042),
    [anon_sym_char] = ACTIONS(2040),
    [anon_sym_volatile] = ACTIONS(2040),
    [anon_sym_module] = ACTIONS(2040),
    [sym_binary_integer_literal] = ACTIONS(2042),
    [anon_sym_LBRACE] = ACTIONS(2042),
    [anon_sym_do] = ACTIONS(2040),
    [anon_sym_throw] = ACTIONS(2040),
    [sym_void_type] = ACTIONS(2040),
    [sym_this] = ACTIONS(2040),
    [anon_sym_package] = ACTIONS(2040),
    [anon_sym_final] = ACTIONS(2040),
    [anon_sym_assert] = ACTIONS(2040),
    [anon_sym_interface] = ACTIONS(2040),
    [anon_sym_for] = ACTIONS(2040),
    [sym_character_literal] = ACTIONS(2042),
    [anon_sym_enum] = ACTIONS(2040),
    [anon_sym_ATinterface] = ACTIONS(2042),
    [sym_identifier] = ACTIONS(2040),
    [anon_sym_LPAREN] = ACTIONS(2042),
    [anon_sym_float] = ACTIONS(2040),
    [sym_octal_integer_literal] = ACTIONS(2042),
    [anon_sym_TILDE] = ACTIONS(2042),
    [anon_sym_double] = ACTIONS(2040),
    [anon_sym_RBRACE] = ACTIONS(2042),
    [sym_hex_floating_point_literal] = ACTIONS(2040),
  },
  [620] = {
    [sym_module_directive] = STATE(632),
    [aux_sym_module_declaration_repeat1] = STATE(632),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_provides] = ACTIONS(1081),
    [anon_sym_requires] = ACTIONS(1087),
    [anon_sym_RBRACE] = ACTIONS(2044),
    [sym_comment] = ACTIONS(3),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_opens] = ACTIONS(1089),
  },
  [621] = {
    [anon_sym_DOT] = ACTIONS(368),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(2046),
  },
  [622] = {
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_SEMI] = ACTIONS(2048),
    [sym_comment] = ACTIONS(3),
  },
  [623] = {
    [aux_sym_module_directive_repeat2] = STATE(741),
    [sym_module_name] = STATE(742),
    [anon_sym_DOT] = ACTIONS(368),
    [anon_sym_COMMA] = ACTIONS(2050),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(2046),
    [anon_sym_to] = ACTIONS(2052),
    [sym_identifier] = ACTIONS(1494),
  },
  [624] = {
    [aux_sym_module_directive_repeat2] = STATE(745),
    [sym_module_name] = STATE(744),
    [anon_sym_to] = ACTIONS(2054),
    [anon_sym_SEMI] = ACTIONS(2048),
    [sym_identifier] = ACTIONS(1494),
    [anon_sym_COMMA] = ACTIONS(2050),
    [anon_sym_DOT] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
  },
  [625] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(368),
    [anon_sym_with] = ACTIONS(2056),
  },
  [626] = {
    [anon_sym_DOT] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_with] = ACTIONS(2058),
  },
  [627] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_static] = ACTIONS(2060),
    [sym_identifier] = ACTIONS(2060),
    [anon_sym_transitive] = ACTIONS(2060),
  },
  [628] = {
    [anon_sym_SEMI] = ACTIONS(2062),
    [anon_sym_DOT] = ACTIONS(2062),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(2062),
  },
  [629] = {
    [sym_module_name] = STATE(748),
    [aux_sym_module_directive_repeat1] = STATE(749),
    [sym_requires_modifier] = STATE(749),
    [sym_identifier] = ACTIONS(1494),
    [sym_comment] = ACTIONS(3),
    [anon_sym_static] = ACTIONS(1492),
    [anon_sym_transitive] = ACTIONS(1492),
  },
  [630] = {
    [anon_sym_DOT] = ACTIONS(2064),
    [anon_sym_SEMI] = ACTIONS(2048),
    [sym_comment] = ACTIONS(3),
  },
  [631] = {
    [anon_sym_LPAREN] = ACTIONS(2066),
    [sym_this] = ACTIONS(2068),
    [anon_sym_protected] = ACTIONS(2068),
    [anon_sym_synchronized] = ACTIONS(2068),
    [anon_sym_enum] = ACTIONS(2068),
    [anon_sym_ATinterface] = ACTIONS(2066),
    [sym_binary_integer_literal] = ACTIONS(2066),
    [sym_void_type] = ACTIONS(2068),
    [anon_sym_else] = ACTIONS(2068),
    [anon_sym_assert] = ACTIONS(2068),
    [anon_sym_double] = ACTIONS(2068),
    [anon_sym_char] = ACTIONS(2068),
    [anon_sym_PLUS] = ACTIONS(2068),
    [anon_sym_class] = ACTIONS(2068),
    [anon_sym_final] = ACTIONS(2068),
    [anon_sym_AT] = ACTIONS(2068),
    [anon_sym_RBRACE] = ACTIONS(2066),
    [anon_sym_DASH] = ACTIONS(2068),
    [anon_sym_continue] = ACTIONS(2068),
    [anon_sym_long] = ACTIONS(2068),
    [anon_sym_float] = ACTIONS(2068),
    [sym_character_literal] = ACTIONS(2066),
    [anon_sym_volatile] = ACTIONS(2068),
    [anon_sym_while] = ACTIONS(2068),
    [anon_sym_short] = ACTIONS(2068),
    [anon_sym_static] = ACTIONS(2068),
    [anon_sym_byte] = ACTIONS(2068),
    [anon_sym_try] = ACTIONS(2068),
    [anon_sym_DASH_DASH] = ACTIONS(2066),
    [sym_decimal_integer_literal] = ACTIONS(2068),
    [anon_sym_TILDE] = ACTIONS(2066),
    [anon_sym_break] = ACTIONS(2068),
    [anon_sym_private] = ACTIONS(2068),
    [anon_sym_case] = ACTIONS(2068),
    [anon_sym_LBRACE] = ACTIONS(2066),
    [ts_builtin_sym_end] = ACTIONS(2066),
    [anon_sym_native] = ACTIONS(2068),
    [anon_sym_do] = ACTIONS(2068),
    [anon_sym_SEMI] = ACTIONS(2066),
    [anon_sym_return] = ACTIONS(2068),
    [anon_sym_default] = ACTIONS(2068),
    [sym_octal_integer_literal] = ACTIONS(2066),
    [anon_sym_new] = ACTIONS(2068),
    [anon_sym_abstract] = ACTIONS(2068),
    [sym_true] = ACTIONS(2068),
    [sym_false] = ACTIONS(2068),
    [anon_sym_BANG] = ACTIONS(2066),
    [sym_null_literal] = ACTIONS(2068),
    [anon_sym_strictfp] = ACTIONS(2068),
    [anon_sym_import] = ACTIONS(2068),
    [anon_sym_public] = ACTIONS(2068),
    [sym_boolean_type] = ACTIONS(2068),
    [sym_super] = ACTIONS(2068),
    [sym_hex_integer_literal] = ACTIONS(2068),
    [anon_sym_throw] = ACTIONS(2068),
    [anon_sym_open] = ACTIONS(2068),
    [anon_sym_switch] = ACTIONS(2068),
    [anon_sym_module] = ACTIONS(2068),
    [anon_sym_int] = ACTIONS(2068),
    [sym_decimal_floating_point_literal] = ACTIONS(2066),
    [anon_sym_PLUS_PLUS] = ACTIONS(2066),
    [sym_string_literal] = ACTIONS(2066),
    [sym_hex_floating_point_literal] = ACTIONS(2068),
    [anon_sym_if] = ACTIONS(2068),
    [anon_sym_package] = ACTIONS(2068),
    [anon_sym_interface] = ACTIONS(2068),
    [anon_sym_transient] = ACTIONS(2068),
    [anon_sym_for] = ACTIONS(2068),
    [sym_identifier] = ACTIONS(2068),
    [sym_comment] = ACTIONS(3),
  },
  [632] = {
    [sym_module_directive] = STATE(632),
    [aux_sym_module_declaration_repeat1] = STATE(632),
    [anon_sym_exports] = ACTIONS(2070),
    [anon_sym_uses] = ACTIONS(2073),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(2076),
    [anon_sym_provides] = ACTIONS(2078),
    [anon_sym_opens] = ACTIONS(2070),
    [anon_sym_requires] = ACTIONS(2081),
  },
  [633] = {
    [sym_module_directive] = STATE(752),
    [aux_sym_module_declaration_repeat1] = STATE(752),
    [anon_sym_RBRACE] = ACTIONS(2084),
    [sym_comment] = ACTIONS(3),
    [anon_sym_provides] = ACTIONS(1081),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_requires] = ACTIONS(1087),
  },
  [634] = {
    [aux_sym_module_declaration_repeat1] = STATE(753),
    [sym_module_directive] = STATE(753),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_requires] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_provides] = ACTIONS(1081),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_RBRACE] = ACTIONS(2038),
  },
  [635] = {
    [sym_enum_constant] = STATE(755),
    [sym__annotation] = STATE(902),
    [sym_enum_body_declarations] = STATE(718),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_marker_annotation] = STATE(902),
    [sym_annotation] = STATE(902),
    [sym_modifiers] = STATE(449),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [sym_comment] = ACTIONS(3),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_private] = ACTIONS(126),
    [sym_identifier] = ACTIONS(1009),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(2086),
    [anon_sym_RBRACE] = ACTIONS(1991),
  },
  [636] = {
    [sym_interface_body] = STATE(756),
    [anon_sym_LBRACE] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
  },
  [637] = {
    [anon_sym_synchronized] = ACTIONS(2088),
    [anon_sym_else] = ACTIONS(2088),
    [sym_character_literal] = ACTIONS(2090),
    [sym_identifier] = ACTIONS(2088),
    [anon_sym_byte] = ACTIONS(2088),
    [anon_sym_public] = ACTIONS(2088),
    [anon_sym_RBRACE] = ACTIONS(2090),
    [anon_sym_package] = ACTIONS(2088),
    [sym_true] = ACTIONS(2088),
    [anon_sym_return] = ACTIONS(2088),
    [anon_sym_assert] = ACTIONS(2088),
    [anon_sym_AT] = ACTIONS(2088),
    [anon_sym_TILDE] = ACTIONS(2090),
    [sym_octal_integer_literal] = ACTIONS(2090),
    [sym_hex_floating_point_literal] = ACTIONS(2088),
    [anon_sym_PLUS_PLUS] = ACTIONS(2090),
    [anon_sym_float] = ACTIONS(2088),
    [anon_sym_LT] = ACTIONS(2090),
    [sym_binary_integer_literal] = ACTIONS(2090),
    [anon_sym_LPAREN] = ACTIONS(2090),
    [sym_this] = ACTIONS(2088),
    [sym_decimal_floating_point_literal] = ACTIONS(2090),
    [anon_sym_protected] = ACTIONS(2088),
    [anon_sym_strictfp] = ACTIONS(2088),
    [anon_sym_abstract] = ACTIONS(2088),
    [anon_sym_final] = ACTIONS(2088),
    [anon_sym_enum] = ACTIONS(2088),
    [sym_void_type] = ACTIONS(2088),
    [anon_sym_open] = ACTIONS(2088),
    [anon_sym_interface] = ACTIONS(2088),
    [anon_sym_private] = ACTIONS(2088),
    [sym_boolean_type] = ACTIONS(2088),
    [anon_sym_static] = ACTIONS(2088),
    [sym_string_literal] = ACTIONS(2090),
    [anon_sym_new] = ACTIONS(2088),
    [anon_sym_native] = ACTIONS(2088),
    [anon_sym_long] = ACTIONS(2088),
    [anon_sym_short] = ACTIONS(2088),
    [sym_false] = ACTIONS(2088),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_DASH] = ACTIONS(2090),
    [anon_sym_case] = ACTIONS(2088),
    [anon_sym_module] = ACTIONS(2088),
    [sym_decimal_integer_literal] = ACTIONS(2088),
    [anon_sym_while] = ACTIONS(2088),
    [anon_sym_transient] = ACTIONS(2088),
    [anon_sym_continue] = ACTIONS(2088),
    [anon_sym_if] = ACTIONS(2088),
    [anon_sym_for] = ACTIONS(2088),
    [anon_sym_double] = ACTIONS(2088),
    [anon_sym_char] = ACTIONS(2088),
    [anon_sym_do] = ACTIONS(2088),
    [sym_null_literal] = ACTIONS(2088),
    [anon_sym_BANG] = ACTIONS(2090),
    [sym_super] = ACTIONS(2088),
    [ts_builtin_sym_end] = ACTIONS(2090),
    [sym_hex_integer_literal] = ACTIONS(2088),
    [anon_sym_int] = ACTIONS(2088),
    [anon_sym_import] = ACTIONS(2088),
    [anon_sym_class] = ACTIONS(2088),
    [anon_sym_throw] = ACTIONS(2088),
    [anon_sym_break] = ACTIONS(2088),
    [anon_sym_switch] = ACTIONS(2088),
    [anon_sym_ATinterface] = ACTIONS(2090),
    [anon_sym_default] = ACTIONS(2088),
    [anon_sym_SEMI] = ACTIONS(2090),
    [anon_sym_DASH] = ACTIONS(2088),
    [anon_sym_try] = ACTIONS(2088),
    [anon_sym_LBRACE] = ACTIONS(2090),
    [anon_sym_volatile] = ACTIONS(2088),
    [anon_sym_PLUS] = ACTIONS(2088),
  },
  [638] = {
    [sym_class_body] = STATE(757),
    [anon_sym_LBRACE] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
  },
  [639] = {
    [anon_sym_SEMI] = ACTIONS(2092),
    [sym_this] = ACTIONS(2094),
    [anon_sym_package] = ACTIONS(2094),
    [anon_sym_private] = ACTIONS(2094),
    [sym_hex_floating_point_literal] = ACTIONS(2094),
    [anon_sym_ATinterface] = ACTIONS(2092),
    [sym_binary_integer_literal] = ACTIONS(2092),
    [sym_octal_integer_literal] = ACTIONS(2092),
    [anon_sym_PLUS_PLUS] = ACTIONS(2092),
    [sym_boolean_type] = ACTIONS(2094),
    [anon_sym_default] = ACTIONS(2094),
    [anon_sym_break] = ACTIONS(2094),
    [anon_sym_throw] = ACTIONS(2094),
    [anon_sym_DASH_DASH] = ACTIONS(2092),
    [anon_sym_float] = ACTIONS(2094),
    [anon_sym_double] = ACTIONS(2094),
    [sym_super] = ACTIONS(2094),
    [anon_sym_PLUS] = ACTIONS(2094),
    [anon_sym_return] = ACTIONS(2094),
    [anon_sym_class] = ACTIONS(2094),
    [anon_sym_else] = ACTIONS(2094),
    [anon_sym_RBRACE] = ACTIONS(2092),
    [anon_sym_module] = ACTIONS(2094),
    [anon_sym_final] = ACTIONS(2094),
    [anon_sym_assert] = ACTIONS(2094),
    [anon_sym_switch] = ACTIONS(2094),
    [anon_sym_enum] = ACTIONS(2094),
    [anon_sym_long] = ACTIONS(2094),
    [sym_string_literal] = ACTIONS(2092),
    [sym_null_literal] = ACTIONS(2094),
    [anon_sym_try] = ACTIONS(2094),
    [anon_sym_for] = ACTIONS(2094),
    [anon_sym_synchronized] = ACTIONS(2094),
    [anon_sym_continue] = ACTIONS(2094),
    [anon_sym_LPAREN] = ACTIONS(2092),
    [anon_sym_open] = ACTIONS(2094),
    [anon_sym_strictfp] = ACTIONS(2094),
    [sym_identifier] = ACTIONS(2094),
    [sym_decimal_floating_point_literal] = ACTIONS(2092),
    [anon_sym_protected] = ACTIONS(2094),
    [anon_sym_abstract] = ACTIONS(2094),
    [anon_sym_AT] = ACTIONS(2094),
    [anon_sym_interface] = ACTIONS(2094),
    [sym_comment] = ACTIONS(3),
    [anon_sym_if] = ACTIONS(2094),
    [anon_sym_public] = ACTIONS(2094),
    [sym_true] = ACTIONS(2094),
    [anon_sym_BANG] = ACTIONS(2092),
    [anon_sym_short] = ACTIONS(2094),
    [anon_sym_case] = ACTIONS(2094),
    [anon_sym_char] = ACTIONS(2094),
    [anon_sym_transient] = ACTIONS(2094),
    [sym_false] = ACTIONS(2094),
    [anon_sym_volatile] = ACTIONS(2094),
    [anon_sym_LBRACE] = ACTIONS(2092),
    [anon_sym_LT] = ACTIONS(2092),
    [anon_sym_DASH] = ACTIONS(2094),
    [sym_void_type] = ACTIONS(2094),
    [sym_hex_integer_literal] = ACTIONS(2094),
    [anon_sym_int] = ACTIONS(2094),
    [anon_sym_byte] = ACTIONS(2094),
    [sym_character_literal] = ACTIONS(2092),
    [anon_sym_native] = ACTIONS(2094),
    [ts_builtin_sym_end] = ACTIONS(2092),
    [anon_sym_new] = ACTIONS(2094),
    [anon_sym_import] = ACTIONS(2094),
    [anon_sym_static] = ACTIONS(2094),
    [anon_sym_TILDE] = ACTIONS(2092),
    [anon_sym_while] = ACTIONS(2094),
    [anon_sym_do] = ACTIONS(2094),
    [sym_decimal_integer_literal] = ACTIONS(2094),
  },
  [640] = {
    [sym_class_body] = STATE(758),
    [sym_super_interfaces] = STATE(759),
    [sym_comment] = ACTIONS(3),
    [anon_sym_implements] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(439),
  },
  [641] = {
    [sym_class_body] = STATE(760),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(439),
  },
  [642] = {
    [sym_hex_integer_literal] = ACTIONS(2096),
    [sym_false] = ACTIONS(2096),
    [anon_sym_if] = ACTIONS(2096),
    [anon_sym_transient] = ACTIONS(2096),
    [anon_sym_double] = ACTIONS(2096),
    [anon_sym_do] = ACTIONS(2096),
    [sym_decimal_integer_literal] = ACTIONS(2096),
    [anon_sym_new] = ACTIONS(2096),
    [sym_null_literal] = ACTIONS(2096),
    [sym_void_type] = ACTIONS(2096),
    [anon_sym_char] = ACTIONS(2096),
    [anon_sym_synchronized] = ACTIONS(2096),
    [anon_sym_break] = ACTIONS(2096),
    [anon_sym_ATinterface] = ACTIONS(2098),
    [anon_sym_try] = ACTIONS(2096),
    [anon_sym_LBRACE] = ACTIONS(2098),
    [ts_builtin_sym_end] = ACTIONS(2098),
    [anon_sym_RBRACE] = ACTIONS(2098),
    [anon_sym_int] = ACTIONS(2096),
    [anon_sym_private] = ACTIONS(2096),
    [anon_sym_DASH] = ACTIONS(2096),
    [anon_sym_protected] = ACTIONS(2096),
    [anon_sym_while] = ACTIONS(2096),
    [anon_sym_strictfp] = ACTIONS(2096),
    [anon_sym_package] = ACTIONS(2096),
    [anon_sym_long] = ACTIONS(2096),
    [anon_sym_byte] = ACTIONS(2096),
    [anon_sym_switch] = ACTIONS(2096),
    [anon_sym_native] = ACTIONS(2096),
    [anon_sym_LPAREN] = ACTIONS(2098),
    [anon_sym_import] = ACTIONS(2096),
    [anon_sym_case] = ACTIONS(2096),
    [anon_sym_for] = ACTIONS(2096),
    [anon_sym_default] = ACTIONS(2096),
    [anon_sym_BANG] = ACTIONS(2098),
    [sym_this] = ACTIONS(2096),
    [sym_hex_floating_point_literal] = ACTIONS(2096),
    [anon_sym_LT] = ACTIONS(2098),
    [anon_sym_AT] = ACTIONS(2096),
    [anon_sym_return] = ACTIONS(2096),
    [anon_sym_continue] = ACTIONS(2096),
    [anon_sym_static] = ACTIONS(2096),
    [anon_sym_enum] = ACTIONS(2096),
    [sym_boolean_type] = ACTIONS(2096),
    [anon_sym_abstract] = ACTIONS(2096),
    [anon_sym_throw] = ACTIONS(2096),
    [sym_binary_integer_literal] = ACTIONS(2098),
    [anon_sym_public] = ACTIONS(2096),
    [sym_super] = ACTIONS(2096),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(2096),
    [anon_sym_float] = ACTIONS(2096),
    [anon_sym_PLUS_PLUS] = ACTIONS(2098),
    [anon_sym_PLUS] = ACTIONS(2096),
    [anon_sym_DASH_DASH] = ACTIONS(2098),
    [anon_sym_assert] = ACTIONS(2096),
    [sym_identifier] = ACTIONS(2096),
    [anon_sym_volatile] = ACTIONS(2096),
    [anon_sym_interface] = ACTIONS(2096),
    [anon_sym_TILDE] = ACTIONS(2098),
    [anon_sym_final] = ACTIONS(2096),
    [anon_sym_else] = ACTIONS(2096),
    [sym_octal_integer_literal] = ACTIONS(2098),
    [anon_sym_class] = ACTIONS(2096),
    [anon_sym_short] = ACTIONS(2096),
    [sym_true] = ACTIONS(2096),
    [sym_decimal_floating_point_literal] = ACTIONS(2098),
    [sym_character_literal] = ACTIONS(2098),
    [anon_sym_module] = ACTIONS(2096),
    [sym_string_literal] = ACTIONS(2098),
    [anon_sym_SEMI] = ACTIONS(2098),
  },
  [643] = {
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_RBRACE] = ACTIONS(2100),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_COMMA] = ACTIONS(2100),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_RPAREN] = ACTIONS(2100),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_SEMI] = ACTIONS(2100),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_RBRACK] = ACTIONS(2100),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_COLON] = ACTIONS(2100),
    [sym_comment] = ACTIONS(3),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(299),
  },
  [644] = {
    [anon_sym_DOT] = ACTIONS(2102),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_PLUS] = ACTIONS(2102),
    [anon_sym_LT_EQ] = ACTIONS(2102),
    [anon_sym_LT_LT] = ACTIONS(2102),
    [anon_sym_SEMI] = ACTIONS(2102),
    [anon_sym_LBRACK] = ACTIONS(2102),
    [anon_sym_COLON_COLON] = ACTIONS(2102),
    [anon_sym_GT] = ACTIONS(2104),
    [anon_sym_EQ_EQ] = ACTIONS(2102),
    [anon_sym_RBRACK] = ACTIONS(2102),
    [anon_sym_AMP_AMP] = ACTIONS(2102),
    [anon_sym_GT_GT_GT] = ACTIONS(2102),
    [anon_sym_BANG_EQ] = ACTIONS(2102),
    [anon_sym_RPAREN] = ACTIONS(2102),
    [anon_sym_QMARK] = ACTIONS(2102),
    [anon_sym_RBRACE] = ACTIONS(2102),
    [anon_sym_LT] = ACTIONS(2104),
    [anon_sym_GT_EQ] = ACTIONS(2102),
    [anon_sym_COMMA] = ACTIONS(2102),
    [anon_sym_AMP] = ACTIONS(2104),
    [anon_sym_PLUS] = ACTIONS(2104),
    [anon_sym_instanceof] = ACTIONS(2102),
    [anon_sym_PIPE_PIPE] = ACTIONS(2102),
    [anon_sym_PIPE] = ACTIONS(2104),
    [anon_sym_CARET] = ACTIONS(2102),
    [anon_sym_GT_GT] = ACTIONS(2104),
    [anon_sym_DASH_DASH] = ACTIONS(2102),
    [anon_sym_SLASH] = ACTIONS(2104),
    [anon_sym_DASH] = ACTIONS(2104),
    [anon_sym_STAR] = ACTIONS(2102),
    [anon_sym_PERCENT] = ACTIONS(2102),
    [anon_sym_COLON] = ACTIONS(2104),
  },
  [645] = {
    [sym_argument_list] = STATE(761),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(112),
  },
  [646] = {
    [anon_sym_abstract] = ACTIONS(2106),
    [anon_sym_private] = ACTIONS(2106),
    [anon_sym_AT] = ACTIONS(2108),
    [anon_sym_long] = ACTIONS(2106),
    [anon_sym_RPAREN] = ACTIONS(2108),
    [anon_sym_default] = ACTIONS(2106),
    [anon_sym_transient] = ACTIONS(2106),
    [anon_sym_byte] = ACTIONS(2106),
    [anon_sym_float] = ACTIONS(2106),
    [anon_sym_char] = ACTIONS(2106),
    [anon_sym_double] = ACTIONS(2106),
    [sym_boolean_type] = ACTIONS(2106),
    [sym_identifier] = ACTIONS(2106),
    [anon_sym_native] = ACTIONS(2106),
    [sym_comment] = ACTIONS(3),
    [anon_sym_volatile] = ACTIONS(2106),
    [anon_sym_COMMA] = ACTIONS(2108),
    [anon_sym_final] = ACTIONS(2106),
    [anon_sym_protected] = ACTIONS(2106),
    [anon_sym_short] = ACTIONS(2106),
    [anon_sym_public] = ACTIONS(2106),
    [sym_void_type] = ACTIONS(2106),
    [anon_sym_synchronized] = ACTIONS(2106),
    [anon_sym_int] = ACTIONS(2106),
    [anon_sym_strictfp] = ACTIONS(2106),
    [anon_sym_static] = ACTIONS(2106),
  },
  [647] = {
    [anon_sym_DASH_GT] = ACTIONS(2110),
    [anon_sym_AT] = ACTIONS(2110),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(2110),
    [anon_sym_throws] = ACTIONS(2110),
    [anon_sym_SEMI] = ACTIONS(2110),
    [anon_sym_LBRACK] = ACTIONS(2110),
  },
  [648] = {
    [anon_sym_RPAREN] = ACTIONS(2112),
    [sym_comment] = ACTIONS(3),
  },
  [649] = {
    [sym_annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(207),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym_marker_annotation] = STATE(145),
    [sym_identifier] = ACTIONS(873),
    [anon_sym_open] = ACTIONS(405),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [650] = {
    [sym__unannotated_type] = STATE(763),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_array_type] = STATE(763),
    [sym_generic_type] = STATE(53),
    [sym_floating_point_type] = STATE(763),
    [sym_integral_type] = STATE(763),
    [sym_identifier] = ACTIONS(233),
    [sym_void_type] = ACTIONS(2114),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_double] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(2114),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_byte] = ACTIONS(33),
  },
  [651] = {
    [aux_sym_cast_expression_repeat1] = STATE(764),
    [anon_sym_COMMA] = ACTIONS(2116),
    [anon_sym_GT] = ACTIONS(2116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(411),
  },
  [652] = {
    [anon_sym_GT] = ACTIONS(2118),
    [anon_sym_COMMA] = ACTIONS(2118),
    [sym_comment] = ACTIONS(3),
  },
  [653] = {
    [anon_sym_COMMA] = ACTIONS(2120),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(2120),
  },
  [654] = {
    [anon_sym_short] = ACTIONS(2122),
    [sym_void_type] = ACTIONS(2122),
    [sym_identifier] = ACTIONS(2122),
    [anon_sym_char] = ACTIONS(2122),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(2122),
    [anon_sym_byte] = ACTIONS(2122),
    [anon_sym_LBRACE] = ACTIONS(2124),
    [anon_sym_float] = ACTIONS(2122),
    [anon_sym_implements] = ACTIONS(2122),
    [anon_sym_int] = ACTIONS(2122),
    [sym_boolean_type] = ACTIONS(2122),
    [anon_sym_extends] = ACTIONS(2122),
    [anon_sym_AT] = ACTIONS(2124),
    [anon_sym_long] = ACTIONS(2122),
  },
  [655] = {
    [aux_sym_type_parameters_repeat1] = STATE(655),
    [anon_sym_COMMA] = ACTIONS(2126),
    [anon_sym_GT] = ACTIONS(2120),
    [sym_comment] = ACTIONS(3),
  },
  [656] = {
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym_marker_annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(207),
    [sym_annotation] = STATE(145),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(409),
    [sym_identifier] = ACTIONS(403),
    [sym_this] = ACTIONS(407),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_module] = ACTIONS(405),
    [anon_sym_open] = ACTIONS(405),
    [sym_comment] = ACTIONS(3),
  },
  [657] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(137),
    [sym_array_type] = STATE(765),
    [sym_floating_point_type] = STATE(765),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(765),
    [sym_annotation] = STATE(137),
    [sym__annotation] = STATE(137),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_integral_type] = STATE(765),
    [sym_marker_annotation] = STATE(137),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_long] = ACTIONS(33),
    [sym_void_type] = ACTIONS(2129),
    [sym_boolean_type] = ACTIONS(2129),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_byte] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(233),
  },
  [658] = {
    [sym_argument_list] = STATE(127),
    [aux_sym_class_literal_repeat1] = STATE(126),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_COLON_COLON] = ACTIONS(205),
    [anon_sym_CARET] = ACTIONS(201),
    [anon_sym_CARET_EQ] = ACTIONS(203),
    [anon_sym_GT_GT] = ACTIONS(201),
    [anon_sym_module] = ACTIONS(211),
    [anon_sym_instanceof] = ACTIONS(209),
    [anon_sym_EQ_EQ] = ACTIONS(209),
    [anon_sym_GT_GT_EQ] = ACTIONS(203),
    [anon_sym_GT_EQ] = ACTIONS(209),
    [anon_sym_DASH_EQ] = ACTIONS(203),
    [anon_sym_STAR_EQ] = ACTIONS(203),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_SLASH_EQ] = ACTIONS(203),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_LT_LT_EQ] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(209),
    [anon_sym_QMARK] = ACTIONS(209),
    [anon_sym_PIPE_EQ] = ACTIONS(203),
    [anon_sym_PLUS_PLUS] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(209),
    [anon_sym_PERCENT_EQ] = ACTIONS(203),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(203),
    [anon_sym_DOT] = ACTIONS(2131),
    [anon_sym_BANG_EQ] = ACTIONS(209),
    [anon_sym_DASH] = ACTIONS(201),
    [anon_sym_STAR] = ACTIONS(201),
    [anon_sym_LT_LT] = ACTIONS(201),
    [anon_sym_AMP_EQ] = ACTIONS(203),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PERCENT] = ACTIONS(201),
    [anon_sym_DASH_DASH] = ACTIONS(209),
    [anon_sym_EQ] = ACTIONS(207),
    [anon_sym_SLASH] = ACTIONS(201),
    [anon_sym_GT] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_AMP_AMP] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(201),
    [anon_sym_GT_GT_GT] = ACTIONS(201),
    [anon_sym_PLUS_EQ] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(201),
  },
  [659] = {
    [sym_argument_list] = STATE(767),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_DOT] = ACTIONS(136),
    [anon_sym_COLON_COLON] = ACTIONS(138),
    [sym_comment] = ACTIONS(3),
  },
  [660] = {
    [sym_argument_list] = STATE(767),
    [anon_sym_LT_EQ] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(237),
    [anon_sym_QMARK] = ACTIONS(239),
    [anon_sym_DASH] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_CARET] = ACTIONS(239),
    [anon_sym_PERCENT] = ACTIONS(239),
    [anon_sym_EQ_EQ] = ACTIONS(239),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_LT_LT] = ACTIONS(239),
    [anon_sym_LBRACK] = ACTIONS(239),
    [anon_sym_AMP] = ACTIONS(237),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_EQ] = ACTIONS(239),
    [anon_sym_AMP_AMP] = ACTIONS(239),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_COLON_COLON] = ACTIONS(239),
    [anon_sym_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(237),
    [anon_sym_DASH_DASH] = ACTIONS(239),
    [anon_sym_DOT] = ACTIONS(239),
    [anon_sym_BANG_EQ] = ACTIONS(239),
    [anon_sym_PIPE_PIPE] = ACTIONS(239),
    [anon_sym_GT_GT_GT] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_GT_GT] = ACTIONS(237),
    [anon_sym_instanceof] = ACTIONS(239),
    [anon_sym_LT] = ACTIONS(237),
    [anon_sym_PLUS_PLUS] = ACTIONS(239),
  },
  [661] = {
    [aux_sym_class_literal_repeat1] = STATE(126),
    [sym_argument_list] = STATE(127),
    [sym_scoped_identifier] = STATE(129),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_COLON_COLON] = ACTIONS(205),
    [anon_sym_LT_LT] = ACTIONS(201),
    [anon_sym_STAR_EQ] = ACTIONS(203),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(203),
    [anon_sym_PERCENT] = ACTIONS(201),
    [anon_sym_EQ_EQ] = ACTIONS(209),
    [anon_sym_GT_GT_GT] = ACTIONS(201),
    [anon_sym_GT] = ACTIONS(201),
    [anon_sym_DASH] = ACTIONS(201),
    [anon_sym_instanceof] = ACTIONS(201),
    [anon_sym_GT_GT_EQ] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(207),
    [anon_sym_SLASH_EQ] = ACTIONS(203),
    [anon_sym_GT_EQ] = ACTIONS(209),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_PERCENT_EQ] = ACTIONS(203),
    [anon_sym_CARET_EQ] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(209),
    [anon_sym_module] = ACTIONS(219),
    [anon_sym_DASH_EQ] = ACTIONS(203),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PLUS_EQ] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_STAR] = ACTIONS(201),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_BANG_EQ] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(209),
    [anon_sym_PLUS_PLUS] = ACTIONS(209),
    [anon_sym_LT_LT_EQ] = ACTIONS(203),
    [anon_sym_LT_EQ] = ACTIONS(209),
    [anon_sym_AMP_EQ] = ACTIONS(203),
    [anon_sym_PIPE_EQ] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(209),
    [anon_sym_LT] = ACTIONS(201),
    [sym_identifier] = ACTIONS(217),
    [anon_sym_GT_GT] = ACTIONS(201),
    [anon_sym_DOT] = ACTIONS(2131),
    [anon_sym_AMP] = ACTIONS(201),
    [anon_sym_CARET] = ACTIONS(201),
    [anon_sym_open] = ACTIONS(219),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(201),
    [anon_sym_DASH_DASH] = ACTIONS(209),
  },
  [662] = {
    [aux_sym_class_literal_repeat1] = STATE(66),
    [sym_type_arguments] = STATE(64),
    [sym_argument_list] = STATE(65),
    [anon_sym_STAR_EQ] = ACTIONS(93),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_GT_GT_GT] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_BANG_EQ] = ACTIONS(87),
    [anon_sym_module] = ACTIONS(89),
    [anon_sym_open] = ACTIONS(89),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_COLON] = ACTIONS(91),
    [anon_sym_AMP_AMP] = ACTIONS(87),
    [anon_sym_SLASH_EQ] = ACTIONS(93),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_LT_LT_EQ] = ACTIONS(93),
    [anon_sym_PERCENT_EQ] = ACTIONS(93),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(100),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_instanceof] = ACTIONS(85),
    [anon_sym_LT] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_PIPE] = ACTIONS(85),
    [anon_sym_DASH_EQ] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(2133),
    [anon_sym_QMARK] = ACTIONS(87),
    [anon_sym_CARET_EQ] = ACTIONS(93),
    [anon_sym_PLUS_EQ] = ACTIONS(93),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [anon_sym_PIPE_EQ] = ACTIONS(93),
    [anon_sym_DASH_GT] = ACTIONS(103),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(87),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_AMP_EQ] = ACTIONS(93),
    [anon_sym_SEMI] = ACTIONS(87),
    [anon_sym_EQ] = ACTIONS(98),
    [anon_sym_CARET] = ACTIONS(85),
  },
  [663] = {
    [anon_sym_interface] = ACTIONS(2135),
    [anon_sym_synchronized] = ACTIONS(2135),
    [anon_sym_protected] = ACTIONS(2135),
    [anon_sym_volatile] = ACTIONS(2135),
    [anon_sym_default] = ACTIONS(2135),
    [anon_sym_SEMI] = ACTIONS(2137),
    [anon_sym_abstract] = ACTIONS(2135),
    [anon_sym_float] = ACTIONS(2135),
    [anon_sym_int] = ACTIONS(2135),
    [sym_identifier] = ACTIONS(2135),
    [anon_sym_class] = ACTIONS(2135),
    [anon_sym_transient] = ACTIONS(2135),
    [anon_sym_final] = ACTIONS(2135),
    [anon_sym_private] = ACTIONS(2135),
    [anon_sym_LT] = ACTIONS(2137),
    [anon_sym_ATinterface] = ACTIONS(2137),
    [anon_sym_byte] = ACTIONS(2135),
    [anon_sym_short] = ACTIONS(2135),
    [anon_sym_strictfp] = ACTIONS(2135),
    [sym_boolean_type] = ACTIONS(2135),
    [anon_sym_long] = ACTIONS(2135),
    [sym_comment] = ACTIONS(3),
    [anon_sym_double] = ACTIONS(2135),
    [anon_sym_LBRACE] = ACTIONS(2137),
    [anon_sym_char] = ACTIONS(2135),
    [anon_sym_AT] = ACTIONS(2135),
    [anon_sym_static] = ACTIONS(2135),
    [anon_sym_public] = ACTIONS(2135),
    [anon_sym_native] = ACTIONS(2135),
    [anon_sym_enum] = ACTIONS(2135),
    [sym_void_type] = ACTIONS(2135),
    [anon_sym_RBRACE] = ACTIONS(2137),
  },
  [664] = {
    [aux_sym_class_literal_repeat1] = STATE(66),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_STAR_EQ] = ACTIONS(93),
    [anon_sym_SLASH_EQ] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(87),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_PLUS_EQ] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(85),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_LT_LT_EQ] = ACTIONS(93),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_QMARK] = ACTIONS(87),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_EQ_EQ] = ACTIONS(87),
    [anon_sym_BANG_EQ] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(85),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_GT_GT_GT] = ACTIONS(85),
    [anon_sym_AMP_EQ] = ACTIONS(93),
    [anon_sym_LBRACK] = ACTIONS(320),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(2139),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [anon_sym_EQ] = ACTIONS(98),
    [anon_sym_DASH_EQ] = ACTIONS(93),
    [anon_sym_COLON_COLON] = ACTIONS(138),
    [anon_sym_CARET_EQ] = ACTIONS(93),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(93),
    [anon_sym_instanceof] = ACTIONS(87),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_PIPE_EQ] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(87),
    [anon_sym_PERCENT_EQ] = ACTIONS(93),
  },
  [665] = {
    [sym_this] = ACTIONS(2141),
    [sym_super] = ACTIONS(2141),
    [sym_comment] = ACTIONS(3),
  },
  [666] = {
    [sym_scoped_type_identifier] = STATE(36),
    [sym_floating_point_type] = STATE(30),
    [sym__primary] = STATE(41),
    [sym_import_declaration] = STATE(772),
    [sym_method_invocation] = STATE(43),
    [sym_labeled_statement] = STATE(772),
    [sym__primary_no_new_array] = STATE(43),
    [sym_try_with_resources_statement] = STATE(772),
    [sym_instanceof_expression] = STATE(49),
    [sym_interface_declaration] = STATE(772),
    [sym_parenthesized_expression] = STATE(43),
    [sym_assignment_expression] = STATE(49),
    [sym_lambda_expression] = STATE(49),
    [sym_module_declaration] = STATE(772),
    [sym_field_access] = STATE(39),
    [sym__type] = STATE(37),
    [sym_annotation] = STATE(51),
    [sym_if_statement] = STATE(772),
    [sym_array_access] = STATE(39),
    [sym_annotated_type] = STATE(37),
    [sym_array_creation_expression] = STATE(41),
    [sym_method_reference] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_package_declaration] = STATE(772),
    [sym_try_statement] = STATE(772),
    [sym_inferred_parameters] = STATE(42),
    [sym_do_statement] = STATE(772),
    [sym_class_literal] = STATE(43),
    [sym_cast_expression] = STATE(49),
    [aux_sym_program_repeat1] = STATE(772),
    [sym_continue_statement] = STATE(772),
    [sym_while_statement] = STATE(772),
    [sym_object_creation_expression] = STATE(43),
    [sym_block] = STATE(772),
    [sym_switch_statement] = STATE(772),
    [sym__unannotated_type] = STATE(40),
    [sym_unary_expression] = STATE(49),
    [sym_local_variable_declaration] = STATE(47),
    [sym_array_type] = STATE(40),
    [sym_formal_parameters] = STATE(42),
    [sym_generic_type] = STATE(53),
    [sym_for_statement] = STATE(772),
    [sym_expression_statement] = STATE(772),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_binary_expression] = STATE(49),
    [sym_ternary_expression] = STATE(49),
    [sym_enum_declaration] = STATE(772),
    [sym_scoped_identifier] = STATE(52),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_class_declaration] = STATE(772),
    [sym__expression] = STATE(49),
    [sym_enhanced_for_statement] = STATE(772),
    [sym_return_statement] = STATE(772),
    [sym_break_statement] = STATE(772),
    [sym_throw_statement] = STATE(772),
    [sym_integral_type] = STATE(30),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__annotation] = STATE(51),
    [sym_marker_annotation] = STATE(51),
    [sym_local_variable_declaration_statement] = STATE(772),
    [sym_modifiers] = STATE(48),
    [sym__declaration] = STATE(772),
    [sym_assert_statement] = STATE(772),
    [sym_synchronized_statement] = STATE(772),
    [sym_update_expression] = STATE(49),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_this] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_native] = ACTIONS(7),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(2143),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_comment] = ACTIONS(3),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(2145),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_identifier] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_assert] = ACTIONS(53),
    [sym_super] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(51),
    [sym_false] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_transient] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_final] = ACTIONS(7),
    [sym_character_literal] = ACTIONS(35),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(17),
    [sym_true] = ACTIONS(5),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(71),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(23),
  },
  [667] = {
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_DOT] = ACTIONS(2147),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_instanceof] = ACTIONS(251),
    [anon_sym_AMP_AMP] = ACTIONS(251),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_AMP] = ACTIONS(249),
    [anon_sym_LT_EQ] = ACTIONS(251),
    [anon_sym_CARET] = ACTIONS(251),
    [anon_sym_DASH_DASH] = ACTIONS(251),
    [anon_sym_PERCENT] = ACTIONS(251),
    [anon_sym_BANG_EQ] = ACTIONS(251),
    [anon_sym_GT_EQ] = ACTIONS(251),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_PIPE_PIPE] = ACTIONS(251),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_COLON_COLON] = ACTIONS(138),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(249),
    [anon_sym_GT_GT_GT] = ACTIONS(251),
    [anon_sym_QMARK] = ACTIONS(251),
    [anon_sym_PLUS_PLUS] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(249),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(251),
  },
  [668] = {
    [sym_break_statement] = STATE(130),
    [sym_method_reference] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_if_statement] = STATE(130),
    [sym_throw_statement] = STATE(130),
    [sym__annotation] = STATE(51),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_assignment_expression] = STATE(49),
    [sym_formal_parameters] = STATE(42),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_expression_statement] = STATE(130),
    [sym_inferred_parameters] = STATE(42),
    [sym_module_declaration] = STATE(130),
    [sym_try_with_resources_statement] = STATE(130),
    [sym__primary_no_new_array] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_synchronized_statement] = STATE(130),
    [sym_block] = STATE(130),
    [sym_parenthesized_expression] = STATE(43),
    [sym_continue_statement] = STATE(130),
    [sym_class_literal] = STATE(43),
    [sym__unannotated_type] = STATE(40),
    [sym_binary_expression] = STATE(49),
    [sym_local_variable_declaration] = STATE(47),
    [aux_sym_program_repeat1] = STATE(130),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_object_creation_expression] = STATE(43),
    [sym_scoped_identifier] = STATE(52),
    [sym_try_statement] = STATE(130),
    [sym_unary_expression] = STATE(49),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_for_statement] = STATE(130),
    [sym__declaration] = STATE(130),
    [sym_return_statement] = STATE(130),
    [sym_package_declaration] = STATE(130),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_instanceof_expression] = STATE(49),
    [sym_class_declaration] = STATE(130),
    [sym_lambda_expression] = STATE(49),
    [sym_local_variable_declaration_statement] = STATE(130),
    [sym_import_declaration] = STATE(130),
    [sym_field_access] = STATE(39),
    [sym_marker_annotation] = STATE(51),
    [sym_floating_point_type] = STATE(30),
    [sym_generic_type] = STATE(53),
    [sym_enhanced_for_statement] = STATE(130),
    [sym__type] = STATE(37),
    [sym__expression] = STATE(49),
    [sym_annotated_type] = STATE(37),
    [sym_ternary_expression] = STATE(49),
    [sym_switch_statement] = STATE(130),
    [sym_do_statement] = STATE(130),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_cast_expression] = STATE(49),
    [sym_annotation] = STATE(51),
    [sym_integral_type] = STATE(30),
    [sym_interface_declaration] = STATE(130),
    [sym_modifiers] = STATE(48),
    [sym__literal] = STATE(43),
    [sym_enum_declaration] = STATE(130),
    [sym_array_access] = STATE(39),
    [sym_array_type] = STATE(40),
    [sym_method_invocation] = STATE(43),
    [sym_while_statement] = STATE(130),
    [sym_assert_statement] = STATE(130),
    [sym_update_expression] = STATE(49),
    [sym_labeled_statement] = STATE(130),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_SEMI] = ACTIONS(223),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_long] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_module] = ACTIONS(21),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_for] = ACTIONS(23),
    [sym_null_literal] = ACTIONS(5),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_RBRACE] = ACTIONS(2145),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(57),
    [sym_false] = ACTIONS(5),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_double] = ACTIONS(41),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_transient] = ACTIONS(7),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(79),
    [sym_true] = ACTIONS(5),
    [anon_sym_enum] = ACTIONS(67),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_super] = ACTIONS(9),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_default] = ACTIONS(7),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_this] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(63),
    [sym_character_literal] = ACTIONS(35),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_strictfp] = ACTIONS(7),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(15),
  },
  [669] = {
    [aux_sym_interface_type_list_repeat1] = STATE(774),
    [anon_sym_LBRACE] = ACTIONS(2149),
    [anon_sym_SEMI] = ACTIONS(2149),
    [anon_sym_COMMA] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
  },
  [670] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(2151),
    [anon_sym_public] = ACTIONS(2153),
    [anon_sym_class] = ACTIONS(2153),
    [anon_sym_LBRACE] = ACTIONS(2151),
    [anon_sym_short] = ACTIONS(2153),
    [anon_sym_RBRACE] = ACTIONS(2151),
    [anon_sym_double] = ACTIONS(2153),
    [anon_sym_strictfp] = ACTIONS(2153),
    [anon_sym_char] = ACTIONS(2153),
    [anon_sym_long] = ACTIONS(2153),
    [anon_sym_protected] = ACTIONS(2153),
    [anon_sym_float] = ACTIONS(2153),
    [anon_sym_abstract] = ACTIONS(2153),
    [anon_sym_volatile] = ACTIONS(2153),
    [sym_identifier] = ACTIONS(2153),
    [anon_sym_default] = ACTIONS(2153),
    [sym_boolean_type] = ACTIONS(2153),
    [anon_sym_synchronized] = ACTIONS(2153),
    [anon_sym_transient] = ACTIONS(2153),
    [anon_sym_AT] = ACTIONS(2153),
    [anon_sym_static] = ACTIONS(2153),
    [anon_sym_enum] = ACTIONS(2153),
    [anon_sym_final] = ACTIONS(2153),
    [anon_sym_private] = ACTIONS(2153),
    [anon_sym_ATinterface] = ACTIONS(2151),
    [anon_sym_interface] = ACTIONS(2153),
    [anon_sym_byte] = ACTIONS(2153),
    [anon_sym_int] = ACTIONS(2153),
    [sym_void_type] = ACTIONS(2153),
    [anon_sym_native] = ACTIONS(2153),
    [anon_sym_SEMI] = ACTIONS(2151),
  },
  [671] = {
    [anon_sym_SEMI] = ACTIONS(2155),
    [sym_comment] = ACTIONS(3),
  },
  [672] = {
    [sym_constructor_body] = STATE(776),
    [anon_sym_LBRACE] = ACTIONS(1242),
    [sym_comment] = ACTIONS(3),
  },
  [673] = {
    [anon_sym_default] = ACTIONS(2157),
    [anon_sym_private] = ACTIONS(2157),
    [anon_sym_int] = ACTIONS(2157),
    [anon_sym_strictfp] = ACTIONS(2157),
    [anon_sym_interface] = ACTIONS(2157),
    [anon_sym_float] = ACTIONS(2157),
    [sym_boolean_type] = ACTIONS(2157),
    [anon_sym_LBRACE] = ACTIONS(2159),
    [anon_sym_long] = ACTIONS(2157),
    [anon_sym_short] = ACTIONS(2157),
    [anon_sym_class] = ACTIONS(2157),
    [anon_sym_LT] = ACTIONS(2159),
    [anon_sym_char] = ACTIONS(2157),
    [sym_identifier] = ACTIONS(2157),
    [anon_sym_abstract] = ACTIONS(2157),
    [anon_sym_protected] = ACTIONS(2157),
    [anon_sym_ATinterface] = ACTIONS(2159),
    [anon_sym_RBRACE] = ACTIONS(2159),
    [anon_sym_enum] = ACTIONS(2157),
    [anon_sym_double] = ACTIONS(2157),
    [anon_sym_native] = ACTIONS(2157),
    [anon_sym_byte] = ACTIONS(2157),
    [anon_sym_final] = ACTIONS(2157),
    [anon_sym_AT] = ACTIONS(2157),
    [anon_sym_SEMI] = ACTIONS(2159),
    [anon_sym_public] = ACTIONS(2157),
    [sym_comment] = ACTIONS(3),
    [anon_sym_synchronized] = ACTIONS(2157),
    [anon_sym_static] = ACTIONS(2157),
    [sym_void_type] = ACTIONS(2157),
    [anon_sym_transient] = ACTIONS(2157),
    [anon_sym_volatile] = ACTIONS(2157),
  },
  [674] = {
    [anon_sym_interface] = ACTIONS(2161),
    [anon_sym_transient] = ACTIONS(2161),
    [anon_sym_int] = ACTIONS(2161),
    [anon_sym_abstract] = ACTIONS(2161),
    [anon_sym_native] = ACTIONS(2161),
    [sym_void_type] = ACTIONS(2161),
    [anon_sym_AT] = ACTIONS(2161),
    [anon_sym_public] = ACTIONS(2161),
    [anon_sym_double] = ACTIONS(2161),
    [sym_boolean_type] = ACTIONS(2161),
    [sym_identifier] = ACTIONS(2161),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(2163),
    [anon_sym_LBRACE] = ACTIONS(2163),
    [anon_sym_private] = ACTIONS(2161),
    [anon_sym_final] = ACTIONS(2161),
    [anon_sym_strictfp] = ACTIONS(2161),
    [anon_sym_short] = ACTIONS(2161),
    [anon_sym_LT] = ACTIONS(2163),
    [anon_sym_class] = ACTIONS(2161),
    [anon_sym_SEMI] = ACTIONS(2163),
    [anon_sym_char] = ACTIONS(2161),
    [anon_sym_float] = ACTIONS(2161),
    [anon_sym_long] = ACTIONS(2161),
    [anon_sym_static] = ACTIONS(2161),
    [anon_sym_synchronized] = ACTIONS(2161),
    [anon_sym_volatile] = ACTIONS(2161),
    [anon_sym_default] = ACTIONS(2161),
    [anon_sym_ATinterface] = ACTIONS(2163),
    [anon_sym_enum] = ACTIONS(2161),
    [anon_sym_protected] = ACTIONS(2161),
    [anon_sym_byte] = ACTIONS(2161),
  },
  [675] = {
    [sym_dimensions] = STATE(777),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_SEMI] = ACTIONS(2165),
    [anon_sym_throws] = ACTIONS(2165),
    [anon_sym_LBRACE] = ACTIONS(2165),
    [anon_sym_LBRACK] = ACTIONS(241),
    [sym_comment] = ACTIONS(3),
  },
  [676] = {
    [sym_dimensions] = STATE(778),
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(2167),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_throws] = ACTIONS(2167),
    [anon_sym_LBRACE] = ACTIONS(2167),
  },
  [677] = {
    [anon_sym_SEMI] = ACTIONS(2169),
    [anon_sym_LBRACE] = ACTIONS(2169),
    [sym_comment] = ACTIONS(3),
  },
  [678] = {
    [anon_sym_SEMI] = ACTIONS(2171),
    [anon_sym_LT] = ACTIONS(2171),
    [anon_sym_class] = ACTIONS(2173),
    [anon_sym_default] = ACTIONS(2173),
    [anon_sym_ATinterface] = ACTIONS(2171),
    [anon_sym_native] = ACTIONS(2173),
    [anon_sym_final] = ACTIONS(2173),
    [anon_sym_interface] = ACTIONS(2173),
    [sym_void_type] = ACTIONS(2173),
    [anon_sym_int] = ACTIONS(2173),
    [anon_sym_public] = ACTIONS(2173),
    [anon_sym_float] = ACTIONS(2173),
    [anon_sym_transient] = ACTIONS(2173),
    [anon_sym_protected] = ACTIONS(2173),
    [anon_sym_RBRACE] = ACTIONS(2171),
    [sym_comment] = ACTIONS(3),
    [anon_sym_static] = ACTIONS(2173),
    [anon_sym_byte] = ACTIONS(2173),
    [anon_sym_volatile] = ACTIONS(2173),
    [anon_sym_double] = ACTIONS(2173),
    [anon_sym_short] = ACTIONS(2173),
    [anon_sym_private] = ACTIONS(2173),
    [anon_sym_strictfp] = ACTIONS(2173),
    [anon_sym_abstract] = ACTIONS(2173),
    [sym_boolean_type] = ACTIONS(2173),
    [anon_sym_synchronized] = ACTIONS(2173),
    [anon_sym_AT] = ACTIONS(2173),
    [sym_identifier] = ACTIONS(2173),
    [anon_sym_long] = ACTIONS(2173),
    [anon_sym_enum] = ACTIONS(2173),
    [anon_sym_LBRACE] = ACTIONS(2171),
    [anon_sym_char] = ACTIONS(2173),
  },
  [679] = {
    [anon_sym_LBRACE] = ACTIONS(2175),
    [sym_comment] = ACTIONS(3),
    [anon_sym_throws] = ACTIONS(2175),
  },
  [680] = {
    [sym_dimensions] = STATE(144),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym__method_declarator] = STATE(779),
    [sym_annotation] = STATE(145),
    [sym_marker_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [anon_sym_module] = ACTIONS(1701),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(1701),
    [sym_identifier] = ACTIONS(1703),
    [anon_sym_LBRACK] = ACTIONS(241),
  },
  [681] = {
    [sym_formal_parameters] = STATE(676),
    [anon_sym_LPAREN] = ACTIONS(1240),
    [sym_comment] = ACTIONS(3),
  },
  [682] = {
    [sym_formal_parameters] = STATE(675),
    [anon_sym_LPAREN] = ACTIONS(1240),
    [sym_comment] = ACTIONS(3),
  },
  [683] = {
    [sym_throws] = STATE(780),
    [anon_sym_throws] = ACTIONS(1244),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(2177),
    [anon_sym_SEMI] = ACTIONS(2177),
  },
  [684] = {
    [anon_sym_COMMA] = ACTIONS(2179),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(2179),
    [anon_sym_SEMI] = ACTIONS(2179),
  },
  [685] = {
    [aux_sym_interface_type_list_repeat1] = STATE(685),
    [anon_sym_SEMI] = ACTIONS(2179),
    [anon_sym_LBRACE] = ACTIONS(2179),
    [anon_sym_COMMA] = ACTIONS(2181),
    [sym_comment] = ACTIONS(3),
  },
  [686] = {
    [sym_binary_integer_literal] = ACTIONS(2184),
    [anon_sym_LPAREN] = ACTIONS(2184),
    [anon_sym_PLUS_PLUS] = ACTIONS(2184),
    [anon_sym_while] = ACTIONS(2186),
    [sym_false] = ACTIONS(2186),
    [anon_sym_break] = ACTIONS(2186),
    [anon_sym_PLUS] = ACTIONS(2186),
    [anon_sym_DASH] = ACTIONS(2186),
    [anon_sym_enum] = ACTIONS(2186),
    [sym_string_literal] = ACTIONS(2184),
    [anon_sym_private] = ACTIONS(2186),
    [anon_sym_double] = ACTIONS(2186),
    [anon_sym_synchronized] = ACTIONS(2186),
    [anon_sym_switch] = ACTIONS(2186),
    [anon_sym_transient] = ACTIONS(2186),
    [anon_sym_else] = ACTIONS(2186),
    [anon_sym_assert] = ACTIONS(2186),
    [anon_sym_int] = ACTIONS(2186),
    [anon_sym_DASH_DASH] = ACTIONS(2184),
    [anon_sym_case] = ACTIONS(2186),
    [anon_sym_new] = ACTIONS(2186),
    [anon_sym_protected] = ACTIONS(2186),
    [anon_sym_if] = ACTIONS(2186),
    [sym_boolean_type] = ACTIONS(2186),
    [sym_this] = ACTIONS(2186),
    [anon_sym_for] = ACTIONS(2186),
    [anon_sym_return] = ACTIONS(2186),
    [anon_sym_final] = ACTIONS(2186),
    [anon_sym_LBRACE] = ACTIONS(2184),
    [anon_sym_throw] = ACTIONS(2186),
    [anon_sym_try] = ACTIONS(2186),
    [anon_sym_default] = ACTIONS(2186),
    [anon_sym_strictfp] = ACTIONS(2186),
    [sym_decimal_integer_literal] = ACTIONS(2186),
    [anon_sym_static] = ACTIONS(2186),
    [anon_sym_byte] = ACTIONS(2186),
    [anon_sym_TILDE] = ACTIONS(2184),
    [anon_sym_import] = ACTIONS(2186),
    [anon_sym_char] = ACTIONS(2186),
    [sym_hex_floating_point_literal] = ACTIONS(2186),
    [anon_sym_abstract] = ACTIONS(2186),
    [anon_sym_AT] = ACTIONS(2186),
    [anon_sym_native] = ACTIONS(2186),
    [anon_sym_volatile] = ACTIONS(2186),
    [anon_sym_public] = ACTIONS(2186),
    [anon_sym_do] = ACTIONS(2186),
    [sym_hex_integer_literal] = ACTIONS(2186),
    [anon_sym_open] = ACTIONS(2186),
    [anon_sym_short] = ACTIONS(2186),
    [anon_sym_interface] = ACTIONS(2186),
    [anon_sym_float] = ACTIONS(2186),
    [sym_void_type] = ACTIONS(2186),
    [sym_true] = ACTIONS(2186),
    [anon_sym_SEMI] = ACTIONS(2184),
    [anon_sym_ATinterface] = ACTIONS(2184),
    [sym_identifier] = ACTIONS(2186),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(2184),
    [anon_sym_class] = ACTIONS(2186),
    [anon_sym_continue] = ACTIONS(2186),
    [anon_sym_module] = ACTIONS(2186),
    [anon_sym_package] = ACTIONS(2186),
    [sym_octal_integer_literal] = ACTIONS(2184),
    [anon_sym_RBRACE] = ACTIONS(2184),
    [anon_sym_LT] = ACTIONS(2184),
    [ts_builtin_sym_end] = ACTIONS(2184),
    [sym_character_literal] = ACTIONS(2184),
    [sym_decimal_floating_point_literal] = ACTIONS(2184),
    [sym_super] = ACTIONS(2186),
    [sym_null_literal] = ACTIONS(2186),
    [anon_sym_long] = ACTIONS(2186),
  },
  [687] = {
    [anon_sym_SEMI] = ACTIONS(2188),
    [sym_comment] = ACTIONS(3),
  },
  [688] = {
    [anon_sym_static] = ACTIONS(2190),
    [sym_comment] = ACTIONS(3),
    [anon_sym_short] = ACTIONS(2190),
    [anon_sym_synchronized] = ACTIONS(2190),
    [anon_sym_double] = ACTIONS(2190),
    [anon_sym_long] = ACTIONS(2190),
    [anon_sym_abstract] = ACTIONS(2190),
    [anon_sym_float] = ACTIONS(2190),
    [sym_void_type] = ACTIONS(2190),
    [anon_sym_transient] = ACTIONS(2190),
    [anon_sym_strictfp] = ACTIONS(2190),
    [anon_sym_ATinterface] = ACTIONS(2192),
    [anon_sym_byte] = ACTIONS(2190),
    [anon_sym_AT] = ACTIONS(2190),
    [anon_sym_class] = ACTIONS(2190),
    [anon_sym_interface] = ACTIONS(2190),
    [anon_sym_LT] = ACTIONS(2192),
    [anon_sym_enum] = ACTIONS(2190),
    [anon_sym_public] = ACTIONS(2190),
    [anon_sym_SEMI] = ACTIONS(2192),
    [anon_sym_RBRACE] = ACTIONS(2192),
    [anon_sym_native] = ACTIONS(2190),
    [anon_sym_protected] = ACTIONS(2190),
    [anon_sym_int] = ACTIONS(2190),
    [anon_sym_default] = ACTIONS(2190),
    [anon_sym_volatile] = ACTIONS(2190),
    [anon_sym_final] = ACTIONS(2190),
    [anon_sym_private] = ACTIONS(2190),
    [sym_boolean_type] = ACTIONS(2190),
    [sym_identifier] = ACTIONS(2190),
    [anon_sym_char] = ACTIONS(2190),
  },
  [689] = {
    [anon_sym_RBRACK] = ACTIONS(2194),
    [anon_sym_instanceof] = ACTIONS(2194),
    [anon_sym_CARET] = ACTIONS(2194),
    [anon_sym_DOT] = ACTIONS(2194),
    [anon_sym_PIPE_PIPE] = ACTIONS(2194),
    [anon_sym_LT] = ACTIONS(2196),
    [anon_sym_PIPE] = ACTIONS(2196),
    [anon_sym_RBRACE] = ACTIONS(2194),
    [anon_sym_COLON_COLON] = ACTIONS(2194),
    [anon_sym_AMP_AMP] = ACTIONS(2194),
    [anon_sym_COLON] = ACTIONS(2196),
    [anon_sym_BANG_EQ] = ACTIONS(2194),
    [anon_sym_EQ_EQ] = ACTIONS(2194),
    [anon_sym_RPAREN] = ACTIONS(2194),
    [anon_sym_DASH] = ACTIONS(2196),
    [anon_sym_GT_GT_GT] = ACTIONS(2194),
    [anon_sym_GT_EQ] = ACTIONS(2194),
    [anon_sym_AMP] = ACTIONS(2196),
    [anon_sym_PERCENT] = ACTIONS(2194),
    [anon_sym_PLUS] = ACTIONS(2196),
    [anon_sym_STAR] = ACTIONS(2194),
    [anon_sym_SEMI] = ACTIONS(2194),
    [anon_sym_LT_LT] = ACTIONS(2194),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_DASH] = ACTIONS(2194),
    [anon_sym_PLUS_PLUS] = ACTIONS(2194),
    [anon_sym_GT] = ACTIONS(2196),
    [anon_sym_GT_GT] = ACTIONS(2196),
    [anon_sym_COMMA] = ACTIONS(2194),
    [anon_sym_LT_EQ] = ACTIONS(2194),
    [anon_sym_QMARK] = ACTIONS(2194),
    [anon_sym_SLASH] = ACTIONS(2196),
  },
  [690] = {
    [sym_field_access] = STATE(39),
    [sym_generic_type] = STATE(53),
    [sym__literal] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_marker_annotation] = STATE(74),
    [sym_binary_expression] = STATE(783),
    [sym_object_creation_expression] = STATE(43),
    [sym__expression] = STATE(783),
    [sym_array_initializer] = STATE(784),
    [sym_annotation] = STATE(74),
    [sym_integral_type] = STATE(30),
    [sym__type] = STATE(37),
    [sym__primary_no_new_array] = STATE(43),
    [sym_cast_expression] = STATE(783),
    [sym_array_creation_expression] = STATE(41),
    [sym_update_expression] = STATE(783),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_parenthesized_expression] = STATE(43),
    [sym_unary_expression] = STATE(783),
    [sym_method_invocation] = STATE(43),
    [sym_ternary_expression] = STATE(783),
    [sym_instanceof_expression] = STATE(783),
    [sym_formal_parameters] = STATE(42),
    [sym_annotated_type] = STATE(37),
    [sym_array_access] = STATE(39),
    [sym_inferred_parameters] = STATE(42),
    [sym_floating_point_type] = STATE(30),
    [sym__annotation] = STATE(74),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_assignment_expression] = STATE(783),
    [sym_scoped_identifier] = STATE(52),
    [sym_class_literal] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_method_reference] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym__primary] = STATE(41),
    [sym_lambda_expression] = STATE(783),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(118),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_RBRACE] = ACTIONS(2198),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_byte] = ACTIONS(33),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_short] = ACTIONS(33),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(921),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_float] = ACTIONS(41),
    [sym_false] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [sym_super] = ACTIONS(9),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_true] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(5),
  },
  [691] = {
    [aux_sym_array_initializer_repeat1] = STATE(786),
    [anon_sym_RBRACE] = ACTIONS(2198),
    [anon_sym_COMMA] = ACTIONS(2200),
    [sym_comment] = ACTIONS(3),
  },
  [692] = {
    [anon_sym_PIPE] = ACTIONS(2202),
    [anon_sym_RBRACE] = ACTIONS(2204),
    [anon_sym_GT_GT_GT] = ACTIONS(2204),
    [anon_sym_LT_EQ] = ACTIONS(2204),
    [anon_sym_COLON_COLON] = ACTIONS(2204),
    [anon_sym_SEMI] = ACTIONS(2204),
    [anon_sym_QMARK] = ACTIONS(2204),
    [anon_sym_LBRACK] = ACTIONS(2204),
    [anon_sym_AMP] = ACTIONS(2202),
    [anon_sym_DASH_DASH] = ACTIONS(2204),
    [anon_sym_LT] = ACTIONS(2202),
    [anon_sym_EQ_EQ] = ACTIONS(2204),
    [anon_sym_DASH] = ACTIONS(2202),
    [anon_sym_PERCENT] = ACTIONS(2204),
    [anon_sym_GT_GT] = ACTIONS(2202),
    [anon_sym_PLUS_PLUS] = ACTIONS(2204),
    [anon_sym_AMP_AMP] = ACTIONS(2204),
    [anon_sym_instanceof] = ACTIONS(2204),
    [anon_sym_COLON] = ACTIONS(2202),
    [anon_sym_RPAREN] = ACTIONS(2204),
    [anon_sym_RBRACK] = ACTIONS(2204),
    [anon_sym_DOT] = ACTIONS(2204),
    [anon_sym_STAR] = ACTIONS(2204),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG_EQ] = ACTIONS(2204),
    [anon_sym_PLUS] = ACTIONS(2202),
    [anon_sym_PIPE_PIPE] = ACTIONS(2204),
    [anon_sym_AT] = ACTIONS(2204),
    [anon_sym_SLASH] = ACTIONS(2202),
    [anon_sym_GT] = ACTIONS(2202),
    [anon_sym_GT_EQ] = ACTIONS(2204),
    [anon_sym_COMMA] = ACTIONS(2204),
    [anon_sym_CARET] = ACTIONS(2204),
    [anon_sym_LT_LT] = ACTIONS(2204),
  },
  [693] = {
    [sym_cast_expression] = STATE(561),
    [sym_integral_type] = STATE(30),
    [sym_update_expression] = STATE(561),
    [sym_annotation] = STATE(74),
    [sym_inferred_parameters] = STATE(42),
    [sym_array_type] = STATE(73),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_binary_expression] = STATE(561),
    [sym_instanceof_expression] = STATE(561),
    [sym_method_invocation] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_formal_parameters] = STATE(42),
    [sym__primary] = STATE(41),
    [sym_field_access] = STATE(39),
    [sym_generic_type] = STATE(53),
    [sym_ternary_expression] = STATE(561),
    [sym__annotation] = STATE(74),
    [sym_lambda_expression] = STATE(561),
    [sym_method_reference] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym__type] = STATE(37),
    [sym_scoped_identifier] = STATE(52),
    [sym_unary_expression] = STATE(561),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym__literal] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym__expression] = STATE(561),
    [sym_assignment_expression] = STATE(561),
    [sym__primary_no_new_array] = STATE(43),
    [sym_annotated_type] = STATE(37),
    [sym_floating_point_type] = STATE(30),
    [sym_array_creation_expression] = STATE(41),
    [sym_object_creation_expression] = STATE(43),
    [sym_class_literal] = STATE(43),
    [sym_array_access] = STATE(39),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_TILDE] = ACTIONS(37),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_int] = ACTIONS(33),
    [sym_true] = ACTIONS(5),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_boolean_type] = ACTIONS(79),
    [sym_character_literal] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
    [sym_null_literal] = ACTIONS(5),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_char] = ACTIONS(33),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_module] = ACTIONS(120),
    [sym_false] = ACTIONS(5),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_float] = ACTIONS(41),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(47),
  },
  [694] = {
    [anon_sym_for] = ACTIONS(2206),
    [anon_sym_if] = ACTIONS(2206),
    [anon_sym_PLUS_PLUS] = ACTIONS(2208),
    [anon_sym_case] = ACTIONS(2206),
    [anon_sym_protected] = ACTIONS(2206),
    [anon_sym_short] = ACTIONS(2206),
    [anon_sym_native] = ACTIONS(2206),
    [sym_this] = ACTIONS(2206),
    [anon_sym_package] = ACTIONS(2206),
    [anon_sym_switch] = ACTIONS(2206),
    [anon_sym_volatile] = ACTIONS(2206),
    [sym_false] = ACTIONS(2206),
    [sym_hex_floating_point_literal] = ACTIONS(2206),
    [anon_sym_module] = ACTIONS(2206),
    [sym_octal_integer_literal] = ACTIONS(2208),
    [sym_super] = ACTIONS(2206),
    [anon_sym_ATinterface] = ACTIONS(2208),
    [sym_hex_integer_literal] = ACTIONS(2206),
    [anon_sym_LBRACE] = ACTIONS(2208),
    [anon_sym_while] = ACTIONS(2206),
    [anon_sym_break] = ACTIONS(2206),
    [anon_sym_strictfp] = ACTIONS(2206),
    [anon_sym_long] = ACTIONS(2206),
    [anon_sym_DASH_DASH] = ACTIONS(2208),
    [anon_sym_PLUS] = ACTIONS(2206),
    [anon_sym_import] = ACTIONS(2206),
    [anon_sym_assert] = ACTIONS(2206),
    [anon_sym_DASH] = ACTIONS(2206),
    [sym_identifier] = ACTIONS(2206),
    [sym_void_type] = ACTIONS(2206),
    [sym_decimal_integer_literal] = ACTIONS(2206),
    [anon_sym_abstract] = ACTIONS(2206),
    [anon_sym_static] = ACTIONS(2206),
    [sym_decimal_floating_point_literal] = ACTIONS(2208),
    [anon_sym_LPAREN] = ACTIONS(2208),
    [anon_sym_BANG] = ACTIONS(2208),
    [anon_sym_throw] = ACTIONS(2206),
    [anon_sym_new] = ACTIONS(2206),
    [anon_sym_enum] = ACTIONS(2206),
    [anon_sym_continue] = ACTIONS(2206),
    [anon_sym_float] = ACTIONS(2206),
    [anon_sym_TILDE] = ACTIONS(2208),
    [sym_boolean_type] = ACTIONS(2206),
    [anon_sym_char] = ACTIONS(2206),
    [anon_sym_synchronized] = ACTIONS(2206),
    [anon_sym_AT] = ACTIONS(2206),
    [anon_sym_SEMI] = ACTIONS(2208),
    [anon_sym_final] = ACTIONS(2206),
    [anon_sym_double] = ACTIONS(2206),
    [anon_sym_transient] = ACTIONS(2206),
    [anon_sym_return] = ACTIONS(2206),
    [anon_sym_class] = ACTIONS(2206),
    [sym_true] = ACTIONS(2206),
    [sym_character_literal] = ACTIONS(2208),
    [anon_sym_try] = ACTIONS(2206),
    [sym_comment] = ACTIONS(3),
    [anon_sym_do] = ACTIONS(2206),
    [anon_sym_public] = ACTIONS(2206),
    [sym_null_literal] = ACTIONS(2206),
    [anon_sym_byte] = ACTIONS(2206),
    [anon_sym_int] = ACTIONS(2206),
    [sym_string_literal] = ACTIONS(2208),
    [anon_sym_default] = ACTIONS(2206),
    [sym_binary_integer_literal] = ACTIONS(2208),
    [anon_sym_RBRACE] = ACTIONS(2208),
    [anon_sym_private] = ACTIONS(2206),
    [anon_sym_interface] = ACTIONS(2206),
    [anon_sym_open] = ACTIONS(2206),
  },
  [695] = {
    [anon_sym_package] = ACTIONS(2210),
    [anon_sym_short] = ACTIONS(2210),
    [anon_sym_break] = ACTIONS(2210),
    [anon_sym_open] = ACTIONS(2210),
    [anon_sym_throw] = ACTIONS(2210),
    [sym_identifier] = ACTIONS(2210),
    [anon_sym_do] = ACTIONS(2210),
    [anon_sym_AT] = ACTIONS(2210),
    [sym_string_literal] = ACTIONS(2212),
    [anon_sym_return] = ACTIONS(2210),
    [anon_sym_SEMI] = ACTIONS(2212),
    [anon_sym_LBRACE] = ACTIONS(2212),
    [anon_sym_public] = ACTIONS(2210),
    [sym_boolean_type] = ACTIONS(2210),
    [anon_sym_LPAREN] = ACTIONS(2212),
    [sym_this] = ACTIONS(2210),
    [sym_hex_integer_literal] = ACTIONS(2210),
    [sym_octal_integer_literal] = ACTIONS(2212),
    [sym_false] = ACTIONS(2210),
    [anon_sym_TILDE] = ACTIONS(2212),
    [sym_decimal_integer_literal] = ACTIONS(2210),
    [anon_sym_final] = ACTIONS(2210),
    [anon_sym_int] = ACTIONS(2210),
    [anon_sym_protected] = ACTIONS(2210),
    [anon_sym_synchronized] = ACTIONS(2210),
    [sym_hex_floating_point_literal] = ACTIONS(2210),
    [anon_sym_else] = ACTIONS(2210),
    [anon_sym_volatile] = ACTIONS(2210),
    [anon_sym_transient] = ACTIONS(2210),
    [anon_sym_long] = ACTIONS(2210),
    [anon_sym_case] = ACTIONS(2210),
    [anon_sym_while] = ACTIONS(2210),
    [anon_sym_BANG] = ACTIONS(2212),
    [anon_sym_import] = ACTIONS(2210),
    [anon_sym_switch] = ACTIONS(2210),
    [anon_sym_default] = ACTIONS(2210),
    [sym_true] = ACTIONS(2210),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(2212),
    [anon_sym_abstract] = ACTIONS(2210),
    [anon_sym_char] = ACTIONS(2210),
    [anon_sym_DASH_DASH] = ACTIONS(2212),
    [sym_character_literal] = ACTIONS(2212),
    [anon_sym_new] = ACTIONS(2210),
    [ts_builtin_sym_end] = ACTIONS(2212),
    [sym_null_literal] = ACTIONS(2210),
    [anon_sym_PLUS_PLUS] = ACTIONS(2212),
    [anon_sym_if] = ACTIONS(2210),
    [anon_sym_native] = ACTIONS(2210),
    [anon_sym_double] = ACTIONS(2210),
    [anon_sym_class] = ACTIONS(2210),
    [anon_sym_private] = ACTIONS(2210),
    [anon_sym_float] = ACTIONS(2210),
    [anon_sym_module] = ACTIONS(2210),
    [anon_sym_strictfp] = ACTIONS(2210),
    [anon_sym_ATinterface] = ACTIONS(2212),
    [sym_decimal_floating_point_literal] = ACTIONS(2212),
    [anon_sym_interface] = ACTIONS(2210),
    [sym_void_type] = ACTIONS(2210),
    [sym_binary_integer_literal] = ACTIONS(2212),
    [anon_sym_byte] = ACTIONS(2210),
    [anon_sym_PLUS] = ACTIONS(2210),
    [sym_super] = ACTIONS(2210),
    [anon_sym_assert] = ACTIONS(2210),
    [anon_sym_enum] = ACTIONS(2210),
    [anon_sym_try] = ACTIONS(2210),
    [anon_sym_DASH] = ACTIONS(2210),
    [anon_sym_continue] = ACTIONS(2210),
    [anon_sym_static] = ACTIONS(2210),
    [anon_sym_for] = ACTIONS(2210),
  },
  [696] = {
    [anon_sym_SEMI] = ACTIONS(2214),
    [sym_comment] = ACTIONS(3),
  },
  [697] = {
    [anon_sym_COMMA] = ACTIONS(2216),
    [anon_sym_RPAREN] = ACTIONS(2216),
    [anon_sym_SEMI] = ACTIONS(2216),
    [anon_sym_RBRACE] = ACTIONS(2216),
    [sym_comment] = ACTIONS(3),
  },
  [698] = {
    [sym_cast_expression] = STATE(429),
    [sym__element_value] = STATE(789),
    [sym_parenthesized_expression] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym__primary_no_new_array] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_floating_point_type] = STATE(30),
    [sym__literal] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__type] = STATE(37),
    [sym_instanceof_expression] = STATE(429),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_array_type] = STATE(73),
    [sym_unary_expression] = STATE(429),
    [sym__annotation] = STATE(428),
    [sym_field_access] = STATE(39),
    [sym__expression] = STATE(429),
    [sym_annotation] = STATE(428),
    [sym_scoped_identifier] = STATE(52),
    [sym_annotated_type] = STATE(37),
    [sym_integral_type] = STATE(30),
    [sym_inferred_parameters] = STATE(42),
    [sym_marker_annotation] = STATE(428),
    [sym_lambda_expression] = STATE(429),
    [sym_generic_type] = STATE(53),
    [sym_object_creation_expression] = STATE(43),
    [sym_ternary_expression] = STATE(429),
    [sym_update_expression] = STATE(429),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_array_access] = STATE(39),
    [sym_binary_expression] = STATE(429),
    [sym_class_literal] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_method_invocation] = STATE(43),
    [sym_assignment_expression] = STATE(429),
    [sym_array_creation_expression] = STATE(41),
    [sym_element_value_array_initializer] = STATE(789),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(971),
    [sym_character_literal] = ACTIONS(35),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [sym_string_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(33),
    [sym_false] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [sym_null_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [sym_super] = ACTIONS(9),
    [anon_sym_long] = ACTIONS(33),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_double] = ACTIONS(41),
    [sym_true] = ACTIONS(5),
    [anon_sym_RBRACE] = ACTIONS(2218),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_identifier] = ACTIONS(124),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_char] = ACTIONS(33),
    [sym_decimal_integer_literal] = ACTIONS(5),
  },
  [699] = {
    [aux_sym_element_value_array_initializer_repeat1] = STATE(791),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(2220),
    [anon_sym_RBRACE] = ACTIONS(2218),
  },
  [700] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(2222),
    [anon_sym_COMMA] = ACTIONS(2222),
  },
  [701] = {
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_COMMA] = ACTIONS(1383),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_QMARK] = ACTIONS(301),
    [sym_comment] = ACTIONS(3),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(1383),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(297),
  },
  [702] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ] = ACTIONS(2224),
  },
  [703] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(2226),
    [anon_sym_RPAREN] = ACTIONS(2226),
  },
  [704] = {
    [anon_sym_short] = ACTIONS(2228),
    [anon_sym_float] = ACTIONS(2228),
    [anon_sym_final] = ACTIONS(2228),
    [anon_sym_transient] = ACTIONS(2228),
    [sym_identifier] = ACTIONS(2228),
    [anon_sym_class] = ACTIONS(2228),
    [sym_comment] = ACTIONS(3),
    [anon_sym_native] = ACTIONS(2228),
    [anon_sym_synchronized] = ACTIONS(2228),
    [anon_sym_package] = ACTIONS(2228),
    [anon_sym_public] = ACTIONS(2228),
    [anon_sym_private] = ACTIONS(2228),
    [sym_void_type] = ACTIONS(2228),
    [anon_sym_char] = ACTIONS(2228),
    [anon_sym_AT] = ACTIONS(2228),
    [anon_sym_LT] = ACTIONS(2230),
    [anon_sym_default] = ACTIONS(2228),
    [anon_sym_byte] = ACTIONS(2228),
    [anon_sym_ATinterface] = ACTIONS(2230),
    [anon_sym_enum] = ACTIONS(2228),
    [anon_sym_int] = ACTIONS(2228),
    [anon_sym_double] = ACTIONS(2228),
    [anon_sym_open] = ACTIONS(2228),
    [anon_sym_protected] = ACTIONS(2228),
    [sym_boolean_type] = ACTIONS(2228),
    [anon_sym_static] = ACTIONS(2228),
    [anon_sym_module] = ACTIONS(2228),
    [anon_sym_abstract] = ACTIONS(2228),
    [anon_sym_strictfp] = ACTIONS(2228),
    [anon_sym_volatile] = ACTIONS(2228),
    [anon_sym_long] = ACTIONS(2228),
    [anon_sym_interface] = ACTIONS(2228),
  },
  [705] = {
    [aux_sym_annotation_argument_list_repeat1] = STATE(705),
    [anon_sym_COMMA] = ACTIONS(2232),
    [anon_sym_RPAREN] = ACTIONS(2226),
    [sym_comment] = ACTIONS(3),
  },
  [706] = {
    [anon_sym_SEMI] = ACTIONS(2235),
    [sym_comment] = ACTIONS(3),
  },
  [707] = {
    [anon_sym_RPAREN] = ACTIONS(2237),
    [sym_comment] = ACTIONS(3),
  },
  [708] = {
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_dimensions] = STATE(307),
    [sym_annotation] = STATE(145),
    [sym__annotation] = STATE(145),
    [anon_sym_SEMI] = ACTIONS(673),
    [anon_sym_COMMA] = ACTIONS(673),
    [anon_sym_EQ] = ACTIONS(673),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LPAREN] = ACTIONS(2239),
    [anon_sym_LBRACK] = ACTIONS(241),
    [sym_comment] = ACTIONS(3),
  },
  [709] = {
    [anon_sym_strictfp] = ACTIONS(2241),
    [anon_sym_volatile] = ACTIONS(2241),
    [anon_sym_SEMI] = ACTIONS(2243),
    [anon_sym_do] = ACTIONS(2241),
    [anon_sym_ATinterface] = ACTIONS(2243),
    [anon_sym_char] = ACTIONS(2241),
    [sym_character_literal] = ACTIONS(2243),
    [sym_null_literal] = ACTIONS(2241),
    [anon_sym_return] = ACTIONS(2241),
    [anon_sym_package] = ACTIONS(2241),
    [anon_sym_synchronized] = ACTIONS(2241),
    [anon_sym_try] = ACTIONS(2241),
    [anon_sym_while] = ACTIONS(2241),
    [anon_sym_continue] = ACTIONS(2241),
    [sym_boolean_type] = ACTIONS(2241),
    [anon_sym_LBRACE] = ACTIONS(2243),
    [anon_sym_final] = ACTIONS(2241),
    [anon_sym_assert] = ACTIONS(2241),
    [anon_sym_import] = ACTIONS(2241),
    [anon_sym_throw] = ACTIONS(2241),
    [anon_sym_abstract] = ACTIONS(2241),
    [anon_sym_break] = ACTIONS(2241),
    [anon_sym_LPAREN] = ACTIONS(2243),
    [sym_decimal_integer_literal] = ACTIONS(2241),
    [anon_sym_else] = ACTIONS(2241),
    [sym_false] = ACTIONS(2241),
    [anon_sym_PLUS_PLUS] = ACTIONS(2243),
    [sym_hex_integer_literal] = ACTIONS(2241),
    [anon_sym_new] = ACTIONS(2241),
    [anon_sym_default] = ACTIONS(2241),
    [anon_sym_class] = ACTIONS(2241),
    [sym_void_type] = ACTIONS(2241),
    [anon_sym_BANG] = ACTIONS(2243),
    [sym_this] = ACTIONS(2241),
    [anon_sym_public] = ACTIONS(2241),
    [anon_sym_TILDE] = ACTIONS(2243),
    [anon_sym_static] = ACTIONS(2241),
    [sym_hex_floating_point_literal] = ACTIONS(2241),
    [anon_sym_open] = ACTIONS(2241),
    [anon_sym_module] = ACTIONS(2241),
    [anon_sym_AT] = ACTIONS(2241),
    [anon_sym_case] = ACTIONS(2241),
    [sym_identifier] = ACTIONS(2241),
    [anon_sym_byte] = ACTIONS(2241),
    [sym_string_literal] = ACTIONS(2243),
    [anon_sym_transient] = ACTIONS(2241),
    [sym_octal_integer_literal] = ACTIONS(2243),
    [anon_sym_long] = ACTIONS(2241),
    [anon_sym_DASH] = ACTIONS(2241),
    [sym_super] = ACTIONS(2241),
    [sym_true] = ACTIONS(2241),
    [anon_sym_float] = ACTIONS(2241),
    [anon_sym_interface] = ACTIONS(2241),
    [sym_binary_integer_literal] = ACTIONS(2243),
    [anon_sym_DASH_DASH] = ACTIONS(2243),
    [anon_sym_for] = ACTIONS(2241),
    [sym_decimal_floating_point_literal] = ACTIONS(2243),
    [anon_sym_private] = ACTIONS(2241),
    [anon_sym_short] = ACTIONS(2241),
    [anon_sym_if] = ACTIONS(2241),
    [anon_sym_protected] = ACTIONS(2241),
    [anon_sym_RBRACE] = ACTIONS(2243),
    [anon_sym_enum] = ACTIONS(2241),
    [sym_comment] = ACTIONS(3),
    [anon_sym_native] = ACTIONS(2241),
    [anon_sym_double] = ACTIONS(2241),
    [anon_sym_PLUS] = ACTIONS(2241),
    [anon_sym_int] = ACTIONS(2241),
    [anon_sym_switch] = ACTIONS(2241),
    [ts_builtin_sym_end] = ACTIONS(2243),
  },
  [710] = {
    [sym_if_statement] = STATE(796),
    [sym_unary_expression] = STATE(49),
    [sym_break_statement] = STATE(796),
    [sym_array_type] = STATE(40),
    [sym_synchronized_statement] = STATE(796),
    [sym_formal_parameters] = STATE(42),
    [sym__literal] = STATE(43),
    [sym_integral_type] = STATE(30),
    [sym_local_variable_declaration_statement] = STATE(796),
    [sym_while_statement] = STATE(796),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_method_reference] = STATE(43),
    [sym_modifiers] = STATE(48),
    [sym_array_access] = STATE(39),
    [sym__declaration] = STATE(796),
    [sym__primary] = STATE(41),
    [sym_labeled_statement] = STATE(796),
    [sym_local_variable_declaration] = STATE(47),
    [sym_assert_statement] = STATE(796),
    [sym_enhanced_for_statement] = STATE(796),
    [sym__expression] = STATE(49),
    [sym_update_expression] = STATE(49),
    [sym_throw_statement] = STATE(796),
    [sym_annotated_type] = STATE(37),
    [sym_annotation] = STATE(51),
    [sym_inferred_parameters] = STATE(42),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_binary_expression] = STATE(49),
    [sym_class_literal] = STATE(43),
    [sym_switch_statement] = STATE(796),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_field_access] = STATE(39),
    [sym_interface_declaration] = STATE(796),
    [sym_scoped_identifier] = STATE(52),
    [sym_generic_type] = STATE(53),
    [sym_return_statement] = STATE(796),
    [sym_class_declaration] = STATE(796),
    [sym__unannotated_type] = STATE(40),
    [sym_lambda_expression] = STATE(49),
    [sym_enum_declaration] = STATE(796),
    [sym_do_statement] = STATE(796),
    [sym_parenthesized_expression] = STATE(43),
    [sym_continue_statement] = STATE(796),
    [sym_import_declaration] = STATE(796),
    [sym_package_declaration] = STATE(796),
    [sym_annotation_type_declaration] = STATE(45),
    [sym__type] = STATE(37),
    [sym_module_declaration] = STATE(796),
    [sym_instanceof_expression] = STATE(49),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_array_creation_expression] = STATE(41),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_object_creation_expression] = STATE(43),
    [sym_cast_expression] = STATE(49),
    [sym_assignment_expression] = STATE(49),
    [sym_block] = STATE(796),
    [sym__primary_no_new_array] = STATE(43),
    [sym_marker_annotation] = STATE(51),
    [sym_method_invocation] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_try_statement] = STATE(796),
    [sym_ternary_expression] = STATE(49),
    [sym_try_with_resources_statement] = STATE(796),
    [sym_for_statement] = STATE(796),
    [sym_expression_statement] = STATE(796),
    [sym__annotation] = STATE(51),
    [sym_comment] = ACTIONS(3),
    [anon_sym_public] = ACTIONS(7),
    [anon_sym_double] = ACTIONS(41),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_break] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_native] = ACTIONS(7),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_throw] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(57),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_default] = ACTIONS(7),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_new] = ACTIONS(19),
    [anon_sym_long] = ACTIONS(33),
    [sym_character_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_for] = ACTIONS(23),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_SEMI] = ACTIONS(2245),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_volatile] = ACTIONS(7),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_short] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_true] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_enum] = ACTIONS(67),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_static] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_char] = ACTIONS(33),
  },
  [711] = {
    [aux_sym_argument_list_repeat1] = STATE(504),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(771),
    [anon_sym_RPAREN] = ACTIONS(2247),
  },
  [712] = {
    [aux_sym_argument_list_repeat1] = STATE(798),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_COMMA] = ACTIONS(771),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(2247),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(299),
  },
  [713] = {
    [sym__literal] = STATE(43),
    [sym_formal_parameters] = STATE(42),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_field_access] = STATE(39),
    [sym_parenthesized_expression] = STATE(43),
    [sym_unary_expression] = STATE(799),
    [sym__primary_no_new_array] = STATE(43),
    [sym__primary] = STATE(41),
    [sym_lambda_expression] = STATE(799),
    [sym_marker_annotation] = STATE(74),
    [sym__unannotated_type] = STATE(73),
    [sym_binary_expression] = STATE(799),
    [sym_array_type] = STATE(73),
    [sym_assignment_expression] = STATE(799),
    [sym_method_invocation] = STATE(43),
    [sym_class_literal] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_array_creation_expression] = STATE(41),
    [sym_inferred_parameters] = STATE(42),
    [sym_scoped_identifier] = STATE(52),
    [sym_object_creation_expression] = STATE(43),
    [sym__expression] = STATE(799),
    [sym_integral_type] = STATE(30),
    [sym_generic_type] = STATE(53),
    [sym__type] = STATE(37),
    [sym_method_reference] = STATE(43),
    [sym_ternary_expression] = STATE(799),
    [sym_annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_floating_point_type] = STATE(30),
    [sym_cast_expression] = STATE(799),
    [sym_instanceof_expression] = STATE(799),
    [sym_update_expression] = STATE(799),
    [sym_annotated_type] = STATE(37),
    [sym__annotation] = STATE(74),
    [sym_array_access] = STATE(39),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_null_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_AT] = ACTIONS(118),
    [sym_this] = ACTIONS(5),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(49),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_true] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(79),
    [sym_super] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(35),
    [sym_identifier] = ACTIONS(124),
    [sym_string_literal] = ACTIONS(35),
    [sym_void_type] = ACTIONS(55),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_byte] = ACTIONS(33),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_RPAREN] = ACTIONS(2247),
    [anon_sym_float] = ACTIONS(41),
    [sym_false] = ACTIONS(5),
    [anon_sym_long] = ACTIONS(33),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(49),
  },
  [714] = {
    [sym_formal_parameters] = STATE(42),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_array_access] = STATE(39),
    [sym__primary] = STATE(41),
    [sym_object_creation_expression] = STATE(43),
    [sym_marker_annotation] = STATE(74),
    [sym_parenthesized_expression] = STATE(43),
    [sym_lambda_expression] = STATE(800),
    [sym_integral_type] = STATE(30),
    [sym_instanceof_expression] = STATE(800),
    [sym_unary_expression] = STATE(800),
    [sym_class_literal] = STATE(43),
    [sym__type] = STATE(37),
    [sym_scoped_identifier] = STATE(52),
    [sym_assignment_expression] = STATE(800),
    [sym_array_creation_expression] = STATE(41),
    [sym_ternary_expression] = STATE(800),
    [sym__annotation] = STATE(74),
    [sym_cast_expression] = STATE(800),
    [sym_method_invocation] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_annotated_type] = STATE(37),
    [sym_update_expression] = STATE(800),
    [sym__primary_no_new_array] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_floating_point_type] = STATE(30),
    [sym__literal] = STATE(43),
    [sym_annotation] = STATE(74),
    [sym__expression] = STATE(800),
    [sym_generic_type] = STATE(53),
    [sym_array_type] = STATE(73),
    [sym_binary_expression] = STATE(800),
    [sym_method_reference] = STATE(43),
    [sym__unannotated_type] = STATE(73),
    [sym_inferred_parameters] = STATE(42),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_octal_integer_literal] = ACTIONS(35),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [anon_sym_new] = ACTIONS(19),
    [sym_super] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_long] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(120),
    [sym_null_literal] = ACTIONS(5),
    [sym_this] = ACTIONS(5),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_identifier] = ACTIONS(124),
    [sym_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(5),
    [sym_true] = ACTIONS(5),
    [anon_sym_short] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_byte] = ACTIONS(33),
    [sym_character_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_int] = ACTIONS(33),
  },
  [715] = {
    [anon_sym_STAR] = ACTIONS(285),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_RPAREN] = ACTIONS(2249),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_PIPE] = ACTIONS(291),
  },
  [716] = {
    [anon_sym_DASH_DASH] = ACTIONS(2251),
    [anon_sym_open] = ACTIONS(2253),
    [sym_true] = ACTIONS(2253),
    [sym_comment] = ACTIONS(3),
    [anon_sym_float] = ACTIONS(2253),
    [anon_sym_try] = ACTIONS(2253),
    [anon_sym_transient] = ACTIONS(2253),
    [anon_sym_while] = ACTIONS(2253),
    [sym_string_literal] = ACTIONS(2251),
    [anon_sym_default] = ACTIONS(2253),
    [anon_sym_interface] = ACTIONS(2253),
    [sym_hex_integer_literal] = ACTIONS(2253),
    [anon_sym_package] = ACTIONS(2253),
    [anon_sym_char] = ACTIONS(2253),
    [anon_sym_continue] = ACTIONS(2253),
    [anon_sym_short] = ACTIONS(2253),
    [anon_sym_new] = ACTIONS(2253),
    [anon_sym_SEMI] = ACTIONS(2251),
    [anon_sym_protected] = ACTIONS(2253),
    [anon_sym_for] = ACTIONS(2253),
    [anon_sym_LBRACE] = ACTIONS(2251),
    [anon_sym_break] = ACTIONS(2253),
    [anon_sym_static] = ACTIONS(2253),
    [anon_sym_int] = ACTIONS(2253),
    [sym_decimal_integer_literal] = ACTIONS(2253),
    [anon_sym_return] = ACTIONS(2253),
    [sym_false] = ACTIONS(2253),
    [anon_sym_synchronized] = ACTIONS(2253),
    [anon_sym_enum] = ACTIONS(2253),
    [anon_sym_import] = ACTIONS(2253),
    [sym_octal_integer_literal] = ACTIONS(2251),
    [anon_sym_public] = ACTIONS(2253),
    [anon_sym_volatile] = ACTIONS(2253),
    [anon_sym_throw] = ACTIONS(2253),
    [sym_null_literal] = ACTIONS(2253),
    [anon_sym_double] = ACTIONS(2253),
    [sym_this] = ACTIONS(2253),
    [anon_sym_case] = ACTIONS(2253),
    [sym_void_type] = ACTIONS(2253),
    [sym_decimal_floating_point_literal] = ACTIONS(2251),
    [anon_sym_PLUS_PLUS] = ACTIONS(2251),
    [anon_sym_AT] = ACTIONS(2253),
    [sym_super] = ACTIONS(2253),
    [anon_sym_long] = ACTIONS(2253),
    [sym_character_literal] = ACTIONS(2251),
    [anon_sym_abstract] = ACTIONS(2253),
    [anon_sym_native] = ACTIONS(2253),
    [anon_sym_if] = ACTIONS(2253),
    [anon_sym_strictfp] = ACTIONS(2253),
    [anon_sym_BANG] = ACTIONS(2251),
    [anon_sym_do] = ACTIONS(2253),
    [anon_sym_LPAREN] = ACTIONS(2251),
    [anon_sym_PLUS] = ACTIONS(2253),
    [anon_sym_final] = ACTIONS(2253),
    [anon_sym_assert] = ACTIONS(2253),
    [sym_identifier] = ACTIONS(2253),
    [sym_binary_integer_literal] = ACTIONS(2251),
    [ts_builtin_sym_end] = ACTIONS(2251),
    [sym_hex_floating_point_literal] = ACTIONS(2253),
    [anon_sym_TILDE] = ACTIONS(2251),
    [anon_sym_class] = ACTIONS(2253),
    [anon_sym_byte] = ACTIONS(2253),
    [sym_boolean_type] = ACTIONS(2253),
    [anon_sym_switch] = ACTIONS(2253),
    [anon_sym_module] = ACTIONS(2253),
    [anon_sym_private] = ACTIONS(2253),
    [anon_sym_ATinterface] = ACTIONS(2251),
    [anon_sym_else] = ACTIONS(2253),
    [anon_sym_RBRACE] = ACTIONS(2251),
    [anon_sym_LT] = ACTIONS(2251),
    [anon_sym_DASH] = ACTIONS(2253),
  },
  [717] = {
    [anon_sym_SEMI] = ACTIONS(2255),
    [anon_sym_RBRACE] = ACTIONS(2255),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(2255),
  },
  [718] = {
    [anon_sym_RBRACE] = ACTIONS(2257),
    [sym_comment] = ACTIONS(3),
  },
  [719] = {
    [anon_sym_COMMA] = ACTIONS(2259),
    [anon_sym_SEMI] = ACTIONS(2259),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(2259),
  },
  [720] = {
    [sym_marker_annotation] = STATE(902),
    [sym_modifiers] = STATE(449),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym_enum_constant] = STATE(719),
    [sym_enum_body_declarations] = STATE(803),
    [sym__annotation] = STATE(902),
    [sym_annotation] = STATE(902),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_RBRACE] = ACTIONS(2257),
    [anon_sym_private] = ACTIONS(126),
    [sym_identifier] = ACTIONS(1009),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_synchronized] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_SEMI] = ACTIONS(1013),
    [sym_comment] = ACTIONS(3),
  },
  [721] = {
    [aux_sym_enum_declaration_repeat1] = STATE(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(2259),
    [anon_sym_COMMA] = ACTIONS(2261),
    [anon_sym_RBRACE] = ACTIONS(2259),
  },
  [722] = {
    [sym_class_body] = STATE(805),
    [anon_sym_LBRACE] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(2255),
    [anon_sym_SEMI] = ACTIONS(2255),
    [anon_sym_RBRACE] = ACTIONS(2255),
  },
  [723] = {
    [aux_sym_enum_declaration_repeat1] = STATE(721),
    [sym_enum_body_declarations] = STATE(803),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(2257),
    [anon_sym_COMMA] = ACTIONS(2264),
    [anon_sym_SEMI] = ACTIONS(1013),
  },
  [724] = {
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(287),
    [sym_comment] = ACTIONS(3),
    [anon_sym_CARET] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_DASH_DASH] = ACTIONS(289),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PLUS_PLUS] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(285),
    [anon_sym_RPAREN] = ACTIONS(2266),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_SEMI] = ACTIONS(2266),
    [anon_sym_AMP_AMP] = ACTIONS(305),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_GT_GT_GT] = ACTIONS(285),
    [anon_sym_instanceof] = ACTIONS(303),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_PERCENT] = ACTIONS(285),
    [anon_sym_GT_GT] = ACTIONS(299),
  },
  [725] = {
    [sym_marker_annotation] = STATE(74),
    [sym_cast_expression] = STATE(807),
    [sym_annotation] = STATE(74),
    [sym_binary_expression] = STATE(807),
    [sym_class_literal] = STATE(43),
    [sym_generic_type] = STATE(53),
    [sym__expression] = STATE(807),
    [sym_annotated_type] = STATE(37),
    [sym__primary] = STATE(41),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_field_access] = STATE(39),
    [sym_array_access] = STATE(39),
    [sym_instanceof_expression] = STATE(807),
    [sym_object_creation_expression] = STATE(43),
    [sym_unary_expression] = STATE(807),
    [sym__annotation] = STATE(74),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_method_reference] = STATE(43),
    [sym_array_type] = STATE(73),
    [sym_array_creation_expression] = STATE(41),
    [sym__unannotated_type] = STATE(73),
    [sym__type] = STATE(37),
    [sym_parenthesized_expression] = STATE(43),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_update_expression] = STATE(807),
    [sym_integral_type] = STATE(30),
    [sym__primary_no_new_array] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [sym_method_invocation] = STATE(43),
    [sym_ternary_expression] = STATE(807),
    [sym_formal_parameters] = STATE(42),
    [sym_assignment_expression] = STATE(807),
    [sym_lambda_expression] = STATE(807),
    [sym_scoped_identifier] = STATE(52),
    [sym_inferred_parameters] = STATE(42),
    [anon_sym_LPAREN] = ACTIONS(47),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [sym_true] = ACTIONS(5),
    [sym_false] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_open] = ACTIONS(120),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_module] = ACTIONS(120),
    [anon_sym_new] = ACTIONS(19),
    [sym_comment] = ACTIONS(3),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_long] = ACTIONS(33),
    [sym_super] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(49),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_BANG] = ACTIONS(37),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [sym_identifier] = ACTIONS(124),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_null_literal] = ACTIONS(5),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_boolean_type] = ACTIONS(79),
    [sym_this] = ACTIONS(5),
  },
  [726] = {
    [anon_sym_LBRACE] = ACTIONS(2268),
    [sym_comment] = ACTIONS(3),
  },
  [727] = {
    [sym_annotated_type] = STATE(37),
    [sym_generic_type] = STATE(53),
    [sym_resource] = STATE(606),
    [sym_array_access] = STATE(43),
    [sym__primary] = STATE(275),
    [sym_object_creation_expression] = STATE(43),
    [sym_marker_annotation] = STATE(903),
    [sym_integral_type] = STATE(30),
    [sym_class_literal] = STATE(43),
    [sym_floating_point_type] = STATE(30),
    [aux_sym_modifiers_repeat1] = STATE(902),
    [sym__type] = STATE(37),
    [sym__primary_no_new_array] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym__literal] = STATE(43),
    [sym_array_creation_expression] = STATE(275),
    [sym_field_access] = STATE(279),
    [aux_sym_dimensions_expr_repeat1] = STATE(74),
    [sym_scoped_identifier] = STATE(276),
    [sym__unannotated_type] = STATE(274),
    [sym_modifiers] = STATE(277),
    [sym_array_type] = STATE(274),
    [sym_annotation] = STATE(903),
    [sym_method_invocation] = STATE(43),
    [sym_parenthesized_expression] = STATE(43),
    [sym__annotation] = STATE(903),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [anon_sym_new] = ACTIONS(499),
    [anon_sym_long] = ACTIONS(33),
    [sym_this] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(134),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_synchronized] = ACTIONS(126),
    [sym_hex_integer_literal] = ACTIONS(5),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_public] = ACTIONS(126),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_abstract] = ACTIONS(126),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_static] = ACTIONS(126),
    [sym_false] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
    [sym_true] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(501),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_double] = ACTIONS(41),
    [sym_super] = ACTIONS(9),
    [anon_sym_int] = ACTIONS(33),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [sym_character_literal] = ACTIONS(35),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [sym_string_literal] = ACTIONS(35),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_float] = ACTIONS(41),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_open] = ACTIONS(501),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_char] = ACTIONS(33),
    [sym_boolean_type] = ACTIONS(79),
  },
  [728] = {
    [sym_floating_point_type] = STATE(808),
    [sym_integral_type] = STATE(808),
    [sym_array_type] = STATE(808),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(808),
    [sym_scoped_type_identifier] = STATE(36),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_float] = ACTIONS(41),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_double] = ACTIONS(41),
    [anon_sym_char] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_long] = ACTIONS(33),
    [sym_identifier] = ACTIONS(233),
    [sym_void_type] = ACTIONS(2270),
    [sym_boolean_type] = ACTIONS(2270),
    [anon_sym_byte] = ACTIONS(33),
  },
  [729] = {
    [aux_sym_catch_type_repeat1] = STATE(809),
    [anon_sym_open] = ACTIONS(2272),
    [sym_identifier] = ACTIONS(2272),
    [anon_sym_PIPE] = ACTIONS(2020),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(2272),
  },
  [730] = {
    [sym_block] = STATE(810),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(197),
  },
  [731] = {
    [sym__variable_declarator_id] = STATE(811),
    [anon_sym_open] = ACTIONS(243),
    [sym_identifier] = ACTIONS(247),
    [anon_sym_module] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
  },
  [732] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(2274),
  },
  [733] = {
    [anon_sym_AMP_AMP] = ACTIONS(2276),
    [anon_sym_COLON_COLON] = ACTIONS(2276),
    [anon_sym_STAR] = ACTIONS(2276),
    [anon_sym_GT_GT_GT] = ACTIONS(2276),
    [anon_sym_COLON] = ACTIONS(2278),
    [anon_sym_RPAREN] = ACTIONS(2276),
    [anon_sym_PIPE] = ACTIONS(2278),
    [anon_sym_PERCENT] = ACTIONS(2276),
    [anon_sym_RBRACE] = ACTIONS(2276),
    [anon_sym_EQ_EQ] = ACTIONS(2276),
    [anon_sym_DASH_DASH] = ACTIONS(2276),
    [anon_sym_LT_EQ] = ACTIONS(2276),
    [anon_sym_GT_EQ] = ACTIONS(2276),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(2276),
    [anon_sym_COMMA] = ACTIONS(2276),
    [anon_sym_DOT] = ACTIONS(2276),
    [anon_sym_LT] = ACTIONS(2278),
    [anon_sym_LT_LT] = ACTIONS(2276),
    [anon_sym_LBRACK] = ACTIONS(2276),
    [anon_sym_PLUS_PLUS] = ACTIONS(2276),
    [anon_sym_GT] = ACTIONS(2278),
    [anon_sym_SLASH] = ACTIONS(2278),
    [anon_sym_GT_GT] = ACTIONS(2278),
    [anon_sym_SEMI] = ACTIONS(2276),
    [anon_sym_AMP] = ACTIONS(2278),
    [anon_sym_DASH] = ACTIONS(2278),
    [anon_sym_PLUS] = ACTIONS(2278),
    [anon_sym_BANG_EQ] = ACTIONS(2276),
    [anon_sym_PIPE_PIPE] = ACTIONS(2276),
    [anon_sym_CARET] = ACTIONS(2276),
    [anon_sym_QMARK] = ACTIONS(2276),
    [anon_sym_instanceof] = ACTIONS(2276),
  },
  [734] = {
    [sym_argument_list] = STATE(812),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(112),
  },
  [735] = {
    [anon_sym_double] = ACTIONS(2280),
    [anon_sym_if] = ACTIONS(2280),
    [anon_sym_char] = ACTIONS(2280),
    [anon_sym_class] = ACTIONS(2280),
    [anon_sym_float] = ACTIONS(2280),
    [sym_false] = ACTIONS(2280),
    [sym_binary_integer_literal] = ACTIONS(2282),
    [anon_sym_break] = ACTIONS(2280),
    [anon_sym_case] = ACTIONS(2280),
    [anon_sym_abstract] = ACTIONS(2280),
    [anon_sym_PLUS_PLUS] = ACTIONS(2282),
    [anon_sym_byte] = ACTIONS(2280),
    [anon_sym_long] = ACTIONS(2280),
    [sym_identifier] = ACTIONS(2280),
    [anon_sym_SEMI] = ACTIONS(2282),
    [anon_sym_DASH] = ACTIONS(2280),
    [anon_sym_package] = ACTIONS(2280),
    [anon_sym_AT] = ACTIONS(2280),
    [anon_sym_import] = ACTIONS(2280),
    [anon_sym_BANG] = ACTIONS(2282),
    [sym_decimal_floating_point_literal] = ACTIONS(2282),
    [anon_sym_new] = ACTIONS(2280),
    [sym_null_literal] = ACTIONS(2280),
    [anon_sym_switch] = ACTIONS(2280),
    [anon_sym_private] = ACTIONS(2280),
    [sym_super] = ACTIONS(2280),
    [sym_true] = ACTIONS(2280),
    [anon_sym_for] = ACTIONS(2280),
    [anon_sym_short] = ACTIONS(2280),
    [anon_sym_continue] = ACTIONS(2280),
    [sym_character_literal] = ACTIONS(2282),
    [anon_sym_strictfp] = ACTIONS(2280),
    [anon_sym_public] = ACTIONS(2280),
    [anon_sym_volatile] = ACTIONS(2280),
    [anon_sym_synchronized] = ACTIONS(2280),
    [anon_sym_throw] = ACTIONS(2280),
    [anon_sym_ATinterface] = ACTIONS(2282),
    [anon_sym_open] = ACTIONS(2280),
    [sym_void_type] = ACTIONS(2280),
    [sym_this] = ACTIONS(2280),
    [anon_sym_LBRACE] = ACTIONS(2282),
    [anon_sym_default] = ACTIONS(2280),
    [anon_sym_final] = ACTIONS(2280),
    [sym_hex_integer_literal] = ACTIONS(2280),
    [anon_sym_TILDE] = ACTIONS(2282),
    [anon_sym_DASH_DASH] = ACTIONS(2282),
    [anon_sym_PLUS] = ACTIONS(2280),
    [anon_sym_try] = ACTIONS(2280),
    [anon_sym_LPAREN] = ACTIONS(2282),
    [anon_sym_enum] = ACTIONS(2280),
    [anon_sym_return] = ACTIONS(2280),
    [sym_decimal_integer_literal] = ACTIONS(2280),
    [ts_builtin_sym_end] = ACTIONS(2282),
    [anon_sym_else] = ACTIONS(2280),
    [sym_string_literal] = ACTIONS(2282),
    [anon_sym_do] = ACTIONS(2280),
    [anon_sym_native] = ACTIONS(2280),
    [anon_sym_int] = ACTIONS(2280),
    [anon_sym_while] = ACTIONS(2280),
    [anon_sym_protected] = ACTIONS(2280),
    [sym_hex_floating_point_literal] = ACTIONS(2280),
    [anon_sym_assert] = ACTIONS(2280),
    [anon_sym_module] = ACTIONS(2280),
    [anon_sym_static] = ACTIONS(2280),
    [anon_sym_transient] = ACTIONS(2280),
    [sym_octal_integer_literal] = ACTIONS(2282),
    [sym_boolean_type] = ACTIONS(2280),
    [anon_sym_RBRACE] = ACTIONS(2282),
    [sym_comment] = ACTIONS(3),
    [anon_sym_interface] = ACTIONS(2280),
  },
  [736] = {
    [anon_sym_package] = ACTIONS(2284),
    [anon_sym_strictfp] = ACTIONS(2284),
    [anon_sym_int] = ACTIONS(2284),
    [anon_sym_module] = ACTIONS(2284),
    [anon_sym_DASH] = ACTIONS(2284),
    [anon_sym_TILDE] = ACTIONS(2286),
    [anon_sym_continue] = ACTIONS(2284),
    [anon_sym_short] = ACTIONS(2284),
    [anon_sym_else] = ACTIONS(2284),
    [anon_sym_PLUS] = ACTIONS(2284),
    [anon_sym_ATinterface] = ACTIONS(2286),
    [anon_sym_SEMI] = ACTIONS(2286),
    [anon_sym_private] = ACTIONS(2284),
    [sym_binary_integer_literal] = ACTIONS(2286),
    [anon_sym_DASH_DASH] = ACTIONS(2286),
    [anon_sym_for] = ACTIONS(2284),
    [anon_sym_public] = ACTIONS(2284),
    [anon_sym_BANG] = ACTIONS(2286),
    [anon_sym_byte] = ACTIONS(2284),
    [anon_sym_transient] = ACTIONS(2284),
    [anon_sym_float] = ACTIONS(2284),
    [anon_sym_double] = ACTIONS(2284),
    [sym_void_type] = ACTIONS(2284),
    [anon_sym_import] = ACTIONS(2284),
    [anon_sym_open] = ACTIONS(2284),
    [anon_sym_static] = ACTIONS(2284),
    [anon_sym_final] = ACTIONS(2284),
    [ts_builtin_sym_end] = ACTIONS(2286),
    [anon_sym_volatile] = ACTIONS(2284),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(2286),
    [anon_sym_if] = ACTIONS(2284),
    [anon_sym_while] = ACTIONS(2284),
    [anon_sym_protected] = ACTIONS(2284),
    [anon_sym_synchronized] = ACTIONS(2284),
    [anon_sym_do] = ACTIONS(2284),
    [anon_sym_class] = ACTIONS(2284),
    [sym_null_literal] = ACTIONS(2284),
    [anon_sym_PLUS_PLUS] = ACTIONS(2286),
    [anon_sym_return] = ACTIONS(2284),
    [sym_this] = ACTIONS(2284),
    [anon_sym_RBRACE] = ACTIONS(2286),
    [sym_hex_floating_point_literal] = ACTIONS(2284),
    [sym_super] = ACTIONS(2284),
    [anon_sym_long] = ACTIONS(2284),
    [sym_string_literal] = ACTIONS(2286),
    [sym_identifier] = ACTIONS(2284),
    [sym_hex_integer_literal] = ACTIONS(2284),
    [sym_decimal_floating_point_literal] = ACTIONS(2286),
    [anon_sym_native] = ACTIONS(2284),
    [anon_sym_switch] = ACTIONS(2284),
    [sym_true] = ACTIONS(2284),
    [anon_sym_assert] = ACTIONS(2284),
    [anon_sym_new] = ACTIONS(2284),
    [anon_sym_abstract] = ACTIONS(2284),
    [anon_sym_default] = ACTIONS(2284),
    [anon_sym_LPAREN] = ACTIONS(2286),
    [sym_boolean_type] = ACTIONS(2284),
    [anon_sym_char] = ACTIONS(2284),
    [sym_character_literal] = ACTIONS(2286),
    [anon_sym_throw] = ACTIONS(2284),
    [sym_false] = ACTIONS(2284),
    [anon_sym_AT] = ACTIONS(2284),
    [anon_sym_try] = ACTIONS(2284),
    [anon_sym_break] = ACTIONS(2284),
    [anon_sym_case] = ACTIONS(2284),
    [anon_sym_interface] = ACTIONS(2284),
    [sym_decimal_integer_literal] = ACTIONS(2284),
    [sym_octal_integer_literal] = ACTIONS(2286),
    [anon_sym_enum] = ACTIONS(2284),
  },
  [737] = {
    [anon_sym_RBRACE] = ACTIONS(2288),
    [anon_sym_exports] = ACTIONS(2288),
    [anon_sym_requires] = ACTIONS(2288),
    [anon_sym_opens] = ACTIONS(2288),
    [anon_sym_provides] = ACTIONS(2288),
    [sym_comment] = ACTIONS(3),
    [anon_sym_uses] = ACTIONS(2288),
  },
  [738] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_uses] = ACTIONS(2290),
    [anon_sym_RBRACE] = ACTIONS(2290),
    [anon_sym_requires] = ACTIONS(2290),
    [anon_sym_opens] = ACTIONS(2290),
    [anon_sym_provides] = ACTIONS(2290),
    [anon_sym_exports] = ACTIONS(2290),
  },
  [739] = {
    [sym_module_name] = STATE(813),
    [sym_identifier] = ACTIONS(2292),
    [sym_comment] = ACTIONS(3),
  },
  [740] = {
    [sym_module_name] = STATE(815),
    [aux_sym_module_directive_repeat2] = STATE(816),
    [sym_identifier] = ACTIONS(2292),
    [anon_sym_COMMA] = ACTIONS(2050),
    [anon_sym_SEMI] = ACTIONS(2294),
    [sym_comment] = ACTIONS(3),
  },
  [741] = {
    [aux_sym_module_directive_repeat2] = STATE(817),
    [anon_sym_SEMI] = ACTIONS(2294),
    [anon_sym_COMMA] = ACTIONS(2050),
    [sym_comment] = ACTIONS(3),
  },
  [742] = {
    [aux_sym_module_directive_repeat2] = STATE(816),
    [anon_sym_COMMA] = ACTIONS(2050),
    [anon_sym_DOT] = ACTIONS(2064),
    [anon_sym_SEMI] = ACTIONS(2294),
    [sym_comment] = ACTIONS(3),
  },
  [743] = {
    [aux_sym_module_directive_repeat2] = STATE(819),
    [sym_module_name] = STATE(820),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(2292),
    [anon_sym_SEMI] = ACTIONS(2296),
    [anon_sym_COMMA] = ACTIONS(2050),
  },
  [744] = {
    [aux_sym_module_directive_repeat2] = STATE(819),
    [anon_sym_COMMA] = ACTIONS(2050),
    [anon_sym_SEMI] = ACTIONS(2296),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(2064),
  },
  [745] = {
    [aux_sym_module_directive_repeat2] = STATE(817),
    [sym_comment] = ACTIONS(3),
    [anon_sym_COMMA] = ACTIONS(2050),
    [anon_sym_SEMI] = ACTIONS(2296),
  },
  [746] = {
    [sym_scoped_identifier] = STATE(822),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(2298),
    [sym_identifier] = ACTIONS(2300),
    [anon_sym_module] = ACTIONS(2298),
  },
  [747] = {
    [sym_scoped_identifier] = STATE(823),
    [sym_identifier] = ACTIONS(2302),
    [anon_sym_open] = ACTIONS(2304),
    [anon_sym_module] = ACTIONS(2304),
    [sym_comment] = ACTIONS(3),
  },
  [748] = {
    [anon_sym_SEMI] = ACTIONS(2296),
    [anon_sym_DOT] = ACTIONS(2064),
    [sym_comment] = ACTIONS(3),
  },
  [749] = {
    [sym_requires_modifier] = STATE(749),
    [aux_sym_module_directive_repeat1] = STATE(749),
    [anon_sym_transitive] = ACTIONS(2306),
    [sym_comment] = ACTIONS(3),
    [anon_sym_static] = ACTIONS(2306),
    [sym_identifier] = ACTIONS(2309),
  },
  [750] = {
    [sym_identifier] = ACTIONS(2311),
    [sym_comment] = ACTIONS(3),
  },
  [751] = {
    [anon_sym_while] = ACTIONS(2313),
    [anon_sym_SEMI] = ACTIONS(2315),
    [anon_sym_abstract] = ACTIONS(2313),
    [sym_comment] = ACTIONS(3),
    [anon_sym_native] = ACTIONS(2313),
    [sym_hex_integer_literal] = ACTIONS(2313),
    [anon_sym_transient] = ACTIONS(2313),
    [anon_sym_class] = ACTIONS(2313),
    [anon_sym_BANG] = ACTIONS(2315),
    [anon_sym_default] = ACTIONS(2313),
    [anon_sym_protected] = ACTIONS(2313),
    [anon_sym_volatile] = ACTIONS(2313),
    [sym_boolean_type] = ACTIONS(2313),
    [anon_sym_PLUS_PLUS] = ACTIONS(2315),
    [anon_sym_LBRACE] = ACTIONS(2315),
    [anon_sym_static] = ACTIONS(2313),
    [anon_sym_private] = ACTIONS(2313),
    [anon_sym_long] = ACTIONS(2313),
    [sym_binary_integer_literal] = ACTIONS(2315),
    [anon_sym_DASH_DASH] = ACTIONS(2315),
    [anon_sym_interface] = ACTIONS(2313),
    [sym_null_literal] = ACTIONS(2313),
    [anon_sym_strictfp] = ACTIONS(2313),
    [sym_decimal_integer_literal] = ACTIONS(2313),
    [anon_sym_open] = ACTIONS(2313),
    [sym_character_literal] = ACTIONS(2315),
    [anon_sym_break] = ACTIONS(2313),
    [anon_sym_for] = ACTIONS(2313),
    [anon_sym_float] = ACTIONS(2313),
    [anon_sym_do] = ACTIONS(2313),
    [anon_sym_return] = ACTIONS(2313),
    [anon_sym_char] = ACTIONS(2313),
    [sym_decimal_floating_point_literal] = ACTIONS(2315),
    [sym_identifier] = ACTIONS(2313),
    [anon_sym_TILDE] = ACTIONS(2315),
    [anon_sym_byte] = ACTIONS(2313),
    [sym_true] = ACTIONS(2313),
    [anon_sym_assert] = ACTIONS(2313),
    [anon_sym_package] = ACTIONS(2313),
    [sym_super] = ACTIONS(2313),
    [anon_sym_else] = ACTIONS(2313),
    [anon_sym_final] = ACTIONS(2313),
    [ts_builtin_sym_end] = ACTIONS(2315),
    [anon_sym_public] = ACTIONS(2313),
    [sym_string_literal] = ACTIONS(2315),
    [sym_this] = ACTIONS(2313),
    [anon_sym_double] = ACTIONS(2313),
    [anon_sym_if] = ACTIONS(2313),
    [anon_sym_short] = ACTIONS(2313),
    [anon_sym_synchronized] = ACTIONS(2313),
    [anon_sym_continue] = ACTIONS(2313),
    [anon_sym_new] = ACTIONS(2313),
    [anon_sym_ATinterface] = ACTIONS(2315),
    [sym_void_type] = ACTIONS(2313),
    [anon_sym_RBRACE] = ACTIONS(2315),
    [anon_sym_throw] = ACTIONS(2313),
    [sym_hex_floating_point_literal] = ACTIONS(2313),
    [anon_sym_LPAREN] = ACTIONS(2315),
    [anon_sym_PLUS] = ACTIONS(2313),
    [anon_sym_int] = ACTIONS(2313),
    [anon_sym_case] = ACTIONS(2313),
    [anon_sym_AT] = ACTIONS(2313),
    [sym_false] = ACTIONS(2313),
    [anon_sym_import] = ACTIONS(2313),
    [anon_sym_DASH] = ACTIONS(2313),
    [anon_sym_enum] = ACTIONS(2313),
    [anon_sym_switch] = ACTIONS(2313),
    [sym_octal_integer_literal] = ACTIONS(2315),
    [anon_sym_module] = ACTIONS(2313),
    [anon_sym_try] = ACTIONS(2313),
  },
  [752] = {
    [sym_module_directive] = STATE(632),
    [aux_sym_module_declaration_repeat1] = STATE(632),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_provides] = ACTIONS(1081),
    [anon_sym_requires] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(2317),
    [anon_sym_uses] = ACTIONS(1083),
    [anon_sym_opens] = ACTIONS(1089),
  },
  [753] = {
    [sym_module_directive] = STATE(632),
    [aux_sym_module_declaration_repeat1] = STATE(632),
    [anon_sym_requires] = ACTIONS(1087),
    [anon_sym_RBRACE] = ACTIONS(2319),
    [anon_sym_provides] = ACTIONS(1081),
    [sym_comment] = ACTIONS(3),
    [anon_sym_exports] = ACTIONS(1089),
    [anon_sym_opens] = ACTIONS(1089),
    [anon_sym_uses] = ACTIONS(1083),
  },
  [754] = {
    [sym_enum_body_declarations] = STATE(803),
    [anon_sym_SEMI] = ACTIONS(1013),
    [sym_comment] = ACTIONS(3),
    [anon_sym_RBRACE] = ACTIONS(2257),
  },
  [755] = {
    [sym_enum_body_declarations] = STATE(803),
    [aux_sym_enum_declaration_repeat1] = STATE(828),
    [anon_sym_RBRACE] = ACTIONS(2257),
    [anon_sym_COMMA] = ACTIONS(2264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1013),
  },
  [756] = {
    [anon_sym_transient] = ACTIONS(2321),
    [anon_sym_int] = ACTIONS(2321),
    [anon_sym_import] = ACTIONS(2321),
    [anon_sym_enum] = ACTIONS(2321),
    [anon_sym_throw] = ACTIONS(2321),
    [anon_sym_return] = ACTIONS(2321),
    [anon_sym_byte] = ACTIONS(2321),
    [sym_character_literal] = ACTIONS(2323),
    [anon_sym_LPAREN] = ACTIONS(2323),
    [anon_sym_else] = ACTIONS(2321),
    [sym_this] = ACTIONS(2321),
    [sym_decimal_floating_point_literal] = ACTIONS(2323),
    [sym_null_literal] = ACTIONS(2321),
    [sym_decimal_integer_literal] = ACTIONS(2321),
    [anon_sym_volatile] = ACTIONS(2321),
    [sym_void_type] = ACTIONS(2321),
    [anon_sym_native] = ACTIONS(2321),
    [anon_sym_synchronized] = ACTIONS(2321),
    [sym_hex_integer_literal] = ACTIONS(2321),
    [anon_sym_float] = ACTIONS(2321),
    [anon_sym_new] = ACTIONS(2321),
    [anon_sym_assert] = ACTIONS(2321),
    [anon_sym_double] = ACTIONS(2321),
    [anon_sym_long] = ACTIONS(2321),
    [anon_sym_LT] = ACTIONS(2323),
    [anon_sym_do] = ACTIONS(2321),
    [anon_sym_PLUS_PLUS] = ACTIONS(2323),
    [anon_sym_SEMI] = ACTIONS(2323),
    [anon_sym_if] = ACTIONS(2321),
    [anon_sym_continue] = ACTIONS(2321),
    [anon_sym_AT] = ACTIONS(2321),
    [anon_sym_abstract] = ACTIONS(2321),
    [anon_sym_ATinterface] = ACTIONS(2323),
    [anon_sym_interface] = ACTIONS(2321),
    [anon_sym_PLUS] = ACTIONS(2321),
    [anon_sym_class] = ACTIONS(2321),
    [sym_comment] = ACTIONS(3),
    [anon_sym_protected] = ACTIONS(2321),
    [anon_sym_public] = ACTIONS(2321),
    [sym_true] = ACTIONS(2321),
    [ts_builtin_sym_end] = ACTIONS(2323),
    [anon_sym_DASH] = ACTIONS(2321),
    [anon_sym_default] = ACTIONS(2321),
    [anon_sym_BANG] = ACTIONS(2323),
    [anon_sym_module] = ACTIONS(2321),
    [anon_sym_final] = ACTIONS(2321),
    [sym_false] = ACTIONS(2321),
    [sym_super] = ACTIONS(2321),
    [anon_sym_private] = ACTIONS(2321),
    [anon_sym_while] = ACTIONS(2321),
    [sym_octal_integer_literal] = ACTIONS(2323),
    [anon_sym_package] = ACTIONS(2321),
    [sym_binary_integer_literal] = ACTIONS(2323),
    [sym_string_literal] = ACTIONS(2323),
    [sym_identifier] = ACTIONS(2321),
    [sym_boolean_type] = ACTIONS(2321),
    [anon_sym_short] = ACTIONS(2321),
    [anon_sym_char] = ACTIONS(2321),
    [anon_sym_for] = ACTIONS(2321),
    [anon_sym_DASH_DASH] = ACTIONS(2323),
    [anon_sym_switch] = ACTIONS(2321),
    [anon_sym_break] = ACTIONS(2321),
    [anon_sym_open] = ACTIONS(2321),
    [anon_sym_case] = ACTIONS(2321),
    [sym_hex_floating_point_literal] = ACTIONS(2321),
    [anon_sym_LBRACE] = ACTIONS(2323),
    [anon_sym_try] = ACTIONS(2321),
    [anon_sym_strictfp] = ACTIONS(2321),
    [anon_sym_TILDE] = ACTIONS(2323),
    [anon_sym_RBRACE] = ACTIONS(2323),
    [anon_sym_static] = ACTIONS(2321),
  },
  [757] = {
    [anon_sym_if] = ACTIONS(2325),
    [anon_sym_PLUS] = ACTIONS(2325),
    [anon_sym_PLUS_PLUS] = ACTIONS(2327),
    [anon_sym_AT] = ACTIONS(2325),
    [anon_sym_short] = ACTIONS(2325),
    [anon_sym_while] = ACTIONS(2325),
    [anon_sym_module] = ACTIONS(2325),
    [anon_sym_ATinterface] = ACTIONS(2327),
    [anon_sym_open] = ACTIONS(2325),
    [sym_binary_integer_literal] = ACTIONS(2327),
    [ts_builtin_sym_end] = ACTIONS(2327),
    [sym_identifier] = ACTIONS(2325),
    [anon_sym_LBRACE] = ACTIONS(2327),
    [anon_sym_new] = ACTIONS(2325),
    [sym_string_literal] = ACTIONS(2327),
    [sym_null_literal] = ACTIONS(2325),
    [anon_sym_LPAREN] = ACTIONS(2327),
    [anon_sym_break] = ACTIONS(2325),
    [anon_sym_DASH] = ACTIONS(2325),
    [anon_sym_do] = ACTIONS(2325),
    [anon_sym_TILDE] = ACTIONS(2327),
    [anon_sym_final] = ACTIONS(2325),
    [anon_sym_float] = ACTIONS(2325),
    [anon_sym_assert] = ACTIONS(2325),
    [sym_void_type] = ACTIONS(2325),
    [anon_sym_LT] = ACTIONS(2327),
    [anon_sym_default] = ACTIONS(2325),
    [sym_false] = ACTIONS(2325),
    [anon_sym_private] = ACTIONS(2325),
    [anon_sym_byte] = ACTIONS(2325),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(2327),
    [anon_sym_for] = ACTIONS(2325),
    [anon_sym_enum] = ACTIONS(2325),
    [anon_sym_transient] = ACTIONS(2325),
    [anon_sym_return] = ACTIONS(2325),
    [anon_sym_class] = ACTIONS(2325),
    [anon_sym_try] = ACTIONS(2325),
    [anon_sym_import] = ACTIONS(2325),
    [anon_sym_switch] = ACTIONS(2325),
    [anon_sym_RBRACE] = ACTIONS(2327),
    [anon_sym_abstract] = ACTIONS(2325),
    [sym_hex_floating_point_literal] = ACTIONS(2325),
    [anon_sym_double] = ACTIONS(2325),
    [anon_sym_static] = ACTIONS(2325),
    [sym_this] = ACTIONS(2325),
    [sym_character_literal] = ACTIONS(2327),
    [anon_sym_interface] = ACTIONS(2325),
    [anon_sym_protected] = ACTIONS(2325),
    [anon_sym_package] = ACTIONS(2325),
    [anon_sym_long] = ACTIONS(2325),
    [anon_sym_char] = ACTIONS(2325),
    [anon_sym_int] = ACTIONS(2325),
    [anon_sym_strictfp] = ACTIONS(2325),
    [anon_sym_public] = ACTIONS(2325),
    [anon_sym_continue] = ACTIONS(2325),
    [anon_sym_throw] = ACTIONS(2325),
    [sym_true] = ACTIONS(2325),
    [sym_octal_integer_literal] = ACTIONS(2327),
    [sym_super] = ACTIONS(2325),
    [sym_hex_integer_literal] = ACTIONS(2325),
    [sym_decimal_floating_point_literal] = ACTIONS(2327),
    [anon_sym_else] = ACTIONS(2325),
    [anon_sym_native] = ACTIONS(2325),
    [anon_sym_BANG] = ACTIONS(2327),
    [anon_sym_synchronized] = ACTIONS(2325),
    [anon_sym_DASH_DASH] = ACTIONS(2327),
    [sym_decimal_integer_literal] = ACTIONS(2325),
    [sym_boolean_type] = ACTIONS(2325),
    [anon_sym_volatile] = ACTIONS(2325),
    [anon_sym_case] = ACTIONS(2325),
  },
  [758] = {
    [anon_sym_PLUS] = ACTIONS(2329),
    [anon_sym_LBRACE] = ACTIONS(2331),
    [sym_character_literal] = ACTIONS(2331),
    [sym_super] = ACTIONS(2329),
    [sym_comment] = ACTIONS(3),
    [anon_sym_package] = ACTIONS(2329),
    [sym_this] = ACTIONS(2329),
    [anon_sym_double] = ACTIONS(2329),
    [anon_sym_ATinterface] = ACTIONS(2331),
    [anon_sym_DASH] = ACTIONS(2329),
    [anon_sym_AT] = ACTIONS(2329),
    [sym_octal_integer_literal] = ACTIONS(2331),
    [anon_sym_synchronized] = ACTIONS(2329),
    [sym_false] = ACTIONS(2329),
    [anon_sym_enum] = ACTIONS(2329),
    [anon_sym_case] = ACTIONS(2329),
    [anon_sym_throw] = ACTIONS(2329),
    [anon_sym_continue] = ACTIONS(2329),
    [sym_hex_integer_literal] = ACTIONS(2329),
    [sym_decimal_integer_literal] = ACTIONS(2329),
    [anon_sym_TILDE] = ACTIONS(2331),
    [anon_sym_LPAREN] = ACTIONS(2331),
    [sym_boolean_type] = ACTIONS(2329),
    [anon_sym_private] = ACTIONS(2329),
    [anon_sym_if] = ACTIONS(2329),
    [anon_sym_public] = ACTIONS(2329),
    [anon_sym_default] = ACTIONS(2329),
    [anon_sym_while] = ACTIONS(2329),
    [anon_sym_open] = ACTIONS(2329),
    [anon_sym_short] = ACTIONS(2329),
    [anon_sym_class] = ACTIONS(2329),
    [sym_void_type] = ACTIONS(2329),
    [sym_string_literal] = ACTIONS(2331),
    [sym_true] = ACTIONS(2329),
    [anon_sym_float] = ACTIONS(2329),
    [anon_sym_PLUS_PLUS] = ACTIONS(2331),
    [anon_sym_return] = ACTIONS(2329),
    [anon_sym_SEMI] = ACTIONS(2331),
    [anon_sym_volatile] = ACTIONS(2329),
    [anon_sym_BANG] = ACTIONS(2331),
    [anon_sym_long] = ACTIONS(2329),
    [anon_sym_do] = ACTIONS(2329),
    [anon_sym_final] = ACTIONS(2329),
    [anon_sym_new] = ACTIONS(2329),
    [anon_sym_protected] = ACTIONS(2329),
    [anon_sym_abstract] = ACTIONS(2329),
    [anon_sym_RBRACE] = ACTIONS(2331),
    [anon_sym_int] = ACTIONS(2329),
    [anon_sym_else] = ACTIONS(2329),
    [anon_sym_static] = ACTIONS(2329),
    [anon_sym_DASH_DASH] = ACTIONS(2331),
    [anon_sym_assert] = ACTIONS(2329),
    [anon_sym_strictfp] = ACTIONS(2329),
    [anon_sym_byte] = ACTIONS(2329),
    [anon_sym_switch] = ACTIONS(2329),
    [anon_sym_break] = ACTIONS(2329),
    [anon_sym_module] = ACTIONS(2329),
    [anon_sym_import] = ACTIONS(2329),
    [anon_sym_native] = ACTIONS(2329),
    [anon_sym_char] = ACTIONS(2329),
    [sym_binary_integer_literal] = ACTIONS(2331),
    [anon_sym_for] = ACTIONS(2329),
    [anon_sym_transient] = ACTIONS(2329),
    [sym_identifier] = ACTIONS(2329),
    [ts_builtin_sym_end] = ACTIONS(2331),
    [sym_null_literal] = ACTIONS(2329),
    [sym_decimal_floating_point_literal] = ACTIONS(2331),
    [sym_hex_floating_point_literal] = ACTIONS(2329),
    [anon_sym_interface] = ACTIONS(2329),
    [anon_sym_LT] = ACTIONS(2331),
    [anon_sym_try] = ACTIONS(2329),
  },
  [759] = {
    [sym_class_body] = STATE(829),
    [anon_sym_LBRACE] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
  },
  [760] = {
    [anon_sym_return] = ACTIONS(2333),
    [anon_sym_short] = ACTIONS(2333),
    [sym_boolean_type] = ACTIONS(2333),
    [sym_this] = ACTIONS(2333),
    [anon_sym_int] = ACTIONS(2333),
    [anon_sym_while] = ACTIONS(2333),
    [sym_character_literal] = ACTIONS(2335),
    [sym_null_literal] = ACTIONS(2333),
    [anon_sym_try] = ACTIONS(2333),
    [anon_sym_LPAREN] = ACTIONS(2335),
    [sym_octal_integer_literal] = ACTIONS(2335),
    [sym_binary_integer_literal] = ACTIONS(2335),
    [anon_sym_default] = ACTIONS(2333),
    [anon_sym_module] = ACTIONS(2333),
    [anon_sym_continue] = ACTIONS(2333),
    [anon_sym_protected] = ACTIONS(2333),
    [anon_sym_native] = ACTIONS(2333),
    [anon_sym_volatile] = ACTIONS(2333),
    [anon_sym_static] = ACTIONS(2333),
    [sym_super] = ACTIONS(2333),
    [anon_sym_double] = ACTIONS(2333),
    [ts_builtin_sym_end] = ACTIONS(2335),
    [anon_sym_LBRACE] = ACTIONS(2335),
    [anon_sym_public] = ACTIONS(2333),
    [anon_sym_class] = ACTIONS(2333),
    [sym_void_type] = ACTIONS(2333),
    [anon_sym_transient] = ACTIONS(2333),
    [anon_sym_for] = ACTIONS(2333),
    [anon_sym_byte] = ACTIONS(2333),
    [anon_sym_if] = ACTIONS(2333),
    [anon_sym_abstract] = ACTIONS(2333),
    [anon_sym_case] = ACTIONS(2333),
    [sym_hex_floating_point_literal] = ACTIONS(2333),
    [anon_sym_ATinterface] = ACTIONS(2335),
    [anon_sym_assert] = ACTIONS(2333),
    [sym_decimal_floating_point_literal] = ACTIONS(2335),
    [anon_sym_DASH_DASH] = ACTIONS(2335),
    [anon_sym_do] = ACTIONS(2333),
    [anon_sym_private] = ACTIONS(2333),
    [anon_sym_TILDE] = ACTIONS(2335),
    [anon_sym_float] = ACTIONS(2333),
    [sym_hex_integer_literal] = ACTIONS(2333),
    [sym_comment] = ACTIONS(3),
    [anon_sym_package] = ACTIONS(2333),
    [sym_decimal_integer_literal] = ACTIONS(2333),
    [sym_identifier] = ACTIONS(2333),
    [anon_sym_long] = ACTIONS(2333),
    [anon_sym_switch] = ACTIONS(2333),
    [anon_sym_RBRACE] = ACTIONS(2335),
    [sym_true] = ACTIONS(2333),
    [sym_string_literal] = ACTIONS(2335),
    [anon_sym_PLUS_PLUS] = ACTIONS(2335),
    [anon_sym_else] = ACTIONS(2333),
    [anon_sym_import] = ACTIONS(2333),
    [anon_sym_char] = ACTIONS(2333),
    [anon_sym_new] = ACTIONS(2333),
    [anon_sym_open] = ACTIONS(2333),
    [anon_sym_LT] = ACTIONS(2335),
    [anon_sym_interface] = ACTIONS(2333),
    [sym_false] = ACTIONS(2333),
    [anon_sym_BANG] = ACTIONS(2335),
    [anon_sym_DASH] = ACTIONS(2333),
    [anon_sym_final] = ACTIONS(2333),
    [anon_sym_PLUS] = ACTIONS(2333),
    [anon_sym_enum] = ACTIONS(2333),
    [anon_sym_throw] = ACTIONS(2333),
    [anon_sym_AT] = ACTIONS(2333),
    [anon_sym_strictfp] = ACTIONS(2333),
    [anon_sym_synchronized] = ACTIONS(2333),
    [anon_sym_break] = ACTIONS(2333),
    [anon_sym_SEMI] = ACTIONS(2335),
  },
  [761] = {
    [anon_sym_EQ_EQ] = ACTIONS(2337),
    [anon_sym_DASH] = ACTIONS(2339),
    [anon_sym_RPAREN] = ACTIONS(2337),
    [anon_sym_RBRACK] = ACTIONS(2337),
    [anon_sym_LT_LT] = ACTIONS(2337),
    [anon_sym_GT_GT_GT] = ACTIONS(2337),
    [anon_sym_SLASH] = ACTIONS(2339),
    [anon_sym_instanceof] = ACTIONS(2337),
    [anon_sym_DOT] = ACTIONS(2337),
    [anon_sym_GT_EQ] = ACTIONS(2337),
    [anon_sym_DASH_DASH] = ACTIONS(2337),
    [anon_sym_RBRACE] = ACTIONS(2337),
    [anon_sym_COLON_COLON] = ACTIONS(2337),
    [anon_sym_PIPE] = ACTIONS(2339),
    [anon_sym_COLON] = ACTIONS(2339),
    [anon_sym_PLUS] = ACTIONS(2339),
    [anon_sym_LT] = ACTIONS(2339),
    [anon_sym_AMP_AMP] = ACTIONS(2337),
    [anon_sym_SEMI] = ACTIONS(2337),
    [anon_sym_BANG_EQ] = ACTIONS(2337),
    [sym_comment] = ACTIONS(3),
    [anon_sym_GT_GT] = ACTIONS(2339),
    [anon_sym_PLUS_PLUS] = ACTIONS(2337),
    [anon_sym_LT_EQ] = ACTIONS(2337),
    [anon_sym_QMARK] = ACTIONS(2337),
    [anon_sym_LBRACK] = ACTIONS(2337),
    [anon_sym_AMP] = ACTIONS(2339),
    [anon_sym_GT] = ACTIONS(2339),
    [anon_sym_PIPE_PIPE] = ACTIONS(2337),
    [anon_sym_PERCENT] = ACTIONS(2337),
    [anon_sym_COMMA] = ACTIONS(2337),
    [anon_sym_STAR] = ACTIONS(2337),
    [anon_sym_CARET] = ACTIONS(2337),
  },
  [762] = {
    [anon_sym_DASH_GT] = ACTIONS(2341),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(2341),
    [anon_sym_SEMI] = ACTIONS(2341),
    [anon_sym_AT] = ACTIONS(2341),
    [anon_sym_LBRACE] = ACTIONS(2341),
    [anon_sym_throws] = ACTIONS(2341),
  },
  [763] = {
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_dimensions] = STATE(144),
    [sym_marker_annotation] = STATE(145),
    [sym_annotation] = STATE(145),
    [sym__variable_declarator_id] = STATE(365),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [anon_sym_module] = ACTIONS(405),
    [sym_identifier] = ACTIONS(873),
    [anon_sym_AT] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(241),
    [sym_comment] = ACTIONS(3),
    [anon_sym_open] = ACTIONS(405),
  },
  [764] = {
    [aux_sym_cast_expression_repeat1] = STATE(360),
    [anon_sym_AMP] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(2343),
    [anon_sym_COMMA] = ACTIONS(2343),
    [sym_comment] = ACTIONS(3),
  },
  [765] = {
    [sym_marker_annotation] = STATE(145),
    [aux_sym_dimensions_expr_repeat1] = STATE(145),
    [sym_dimensions] = STATE(144),
    [sym__annotation] = STATE(145),
    [aux_sym_dimensions_repeat1] = STATE(141),
    [sym_annotation] = STATE(145),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(850),
    [sym_identifier] = ACTIONS(848),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(118),
  },
  [766] = {
    [sym__unqualified_object_creation_expression] = STATE(291),
    [sym_type_arguments] = STATE(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_new] = ACTIONS(346),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_class] = ACTIONS(509),
    [sym_super] = ACTIONS(2345),
    [sym_identifier] = ACTIONS(511),
    [sym_this] = ACTIONS(515),
  },
  [767] = {
    [anon_sym_SEMI] = ACTIONS(2347),
    [sym_comment] = ACTIONS(3),
  },
  [768] = {
    [aux_sym_dimensions_expr_repeat1] = STATE(184),
    [sym__annotation] = STATE(184),
    [sym_marker_annotation] = STATE(184),
    [sym_annotation] = STATE(184),
    [sym_type_arguments] = STATE(834),
    [sym__unqualified_object_creation_expression] = STATE(185),
    [sym_super] = ACTIONS(2349),
    [sym_identifier] = ACTIONS(348),
    [anon_sym_class] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(118),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_new] = ACTIONS(346),
    [sym_this] = ACTIONS(350),
  },
  [769] = {
    [sym__unqualified_object_creation_expression] = STATE(185),
    [sym_type_arguments] = STATE(834),
    [anon_sym_class] = ACTIONS(352),
    [sym_super] = ACTIONS(2349),
    [sym_comment] = ACTIONS(3),
    [sym_this] = ACTIONS(350),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_new] = ACTIONS(346),
    [sym_identifier] = ACTIONS(731),
  },
  [770] = {
    [sym_argument_list] = STATE(835),
    [anon_sym_LPAREN] = ACTIONS(112),
    [sym_comment] = ACTIONS(3),
  },
  [771] = {
    [anon_sym_char] = ACTIONS(2351),
    [anon_sym_native] = ACTIONS(2351),
    [anon_sym_RBRACE] = ACTIONS(2353),
    [anon_sym_abstract] = ACTIONS(2351),
    [anon_sym_synchronized] = ACTIONS(2351),
    [anon_sym_strictfp] = ACTIONS(2351),
    [anon_sym_byte] = ACTIONS(2351),
    [anon_sym_class] = ACTIONS(2351),
    [anon_sym_interface] = ACTIONS(2351),
    [anon_sym_private] = ACTIONS(2351),
    [anon_sym_static] = ACTIONS(2351),
    [anon_sym_AT] = ACTIONS(2351),
    [anon_sym_ATinterface] = ACTIONS(2353),
    [anon_sym_long] = ACTIONS(2351),
    [anon_sym_short] = ACTIONS(2351),
    [anon_sym_protected] = ACTIONS(2351),
    [anon_sym_LBRACE] = ACTIONS(2353),
    [anon_sym_default] = ACTIONS(2351),
    [anon_sym_int] = ACTIONS(2351),
    [anon_sym_final] = ACTIONS(2351),
    [anon_sym_enum] = ACTIONS(2351),
    [anon_sym_volatile] = ACTIONS(2351),
    [anon_sym_public] = ACTIONS(2351),
    [anon_sym_float] = ACTIONS(2351),
    [anon_sym_double] = ACTIONS(2351),
    [sym_boolean_type] = ACTIONS(2351),
    [sym_identifier] = ACTIONS(2351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(2353),
    [sym_void_type] = ACTIONS(2351),
    [anon_sym_LT] = ACTIONS(2353),
    [anon_sym_transient] = ACTIONS(2351),
  },
  [772] = {
    [sym_expression_statement] = STATE(130),
    [sym_do_statement] = STATE(130),
    [sym_normal_interface_declaration] = STATE(45),
    [sym_object_creation_expression] = STATE(43),
    [sym_field_access] = STATE(39),
    [sym_lambda_expression] = STATE(49),
    [sym__declaration] = STATE(130),
    [sym_inferred_parameters] = STATE(42),
    [sym_array_access] = STATE(39),
    [sym_unary_expression] = STATE(49),
    [sym__literal] = STATE(43),
    [sym_scoped_type_identifier] = STATE(36),
    [sym_assignment_expression] = STATE(49),
    [sym__unqualified_object_creation_expression] = STATE(50),
    [sym_block] = STATE(130),
    [sym__type] = STATE(37),
    [sym_parenthesized_expression] = STATE(43),
    [sym_throw_statement] = STATE(130),
    [sym_continue_statement] = STATE(130),
    [sym_ternary_expression] = STATE(49),
    [sym_break_statement] = STATE(130),
    [aux_sym_program_repeat1] = STATE(130),
    [sym_cast_expression] = STATE(49),
    [sym_method_invocation] = STATE(43),
    [sym_method_reference] = STATE(43),
    [sym_array_creation_expression] = STATE(41),
    [sym_local_variable_declaration_statement] = STATE(130),
    [sym_while_statement] = STATE(130),
    [sym__expression] = STATE(49),
    [sym_integral_type] = STATE(30),
    [sym_formal_parameters] = STATE(42),
    [sym_synchronized_statement] = STATE(130),
    [sym_binary_expression] = STATE(49),
    [sym_enhanced_for_statement] = STATE(130),
    [sym_instanceof_expression] = STATE(49),
    [sym_return_statement] = STATE(130),
    [aux_sym_modifiers_repeat1] = STATE(44),
    [sym_module_declaration] = STATE(130),
    [sym_labeled_statement] = STATE(130),
    [sym_enum_declaration] = STATE(130),
    [sym_interface_declaration] = STATE(130),
    [sym_class_declaration] = STATE(130),
    [sym__annotation] = STATE(51),
    [sym_floating_point_type] = STATE(30),
    [sym_update_expression] = STATE(49),
    [sym_try_statement] = STATE(130),
    [sym_modifiers] = STATE(48),
    [sym_class_literal] = STATE(43),
    [aux_sym_dimensions_expr_repeat1] = STATE(38),
    [sym_assert_statement] = STATE(130),
    [sym_switch_statement] = STATE(130),
    [sym__primary_no_new_array] = STATE(43),
    [sym_array_type] = STATE(40),
    [sym_annotation_type_declaration] = STATE(45),
    [sym_if_statement] = STATE(130),
    [sym_annotated_type] = STATE(37),
    [sym_annotation] = STATE(51),
    [sym_import_declaration] = STATE(130),
    [sym_for_statement] = STATE(130),
    [sym_try_with_resources_statement] = STATE(130),
    [sym_scoped_identifier] = STATE(52),
    [sym_local_variable_declaration] = STATE(47),
    [sym_generic_type] = STATE(53),
    [sym__unannotated_type] = STATE(40),
    [sym_package_declaration] = STATE(130),
    [sym__primary] = STATE(41),
    [sym_marker_annotation] = STATE(51),
    [anon_sym_native] = ACTIONS(7),
    [anon_sym_if] = ACTIONS(43),
    [sym_boolean_type] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(33),
    [sym_octal_integer_literal] = ACTIONS(35),
    [anon_sym_new] = ACTIONS(19),
    [sym_hex_floating_point_literal] = ACTIONS(5),
    [anon_sym_import] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(7),
    [anon_sym_DASH_DASH] = ACTIONS(15),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_throw] = ACTIONS(27),
    [sym_binary_integer_literal] = ACTIONS(35),
    [anon_sym_strictfp] = ACTIONS(7),
    [anon_sym_assert] = ACTIONS(53),
    [sym_identifier] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(15),
    [sym_comment] = ACTIONS(3),
    [anon_sym_private] = ACTIONS(7),
    [anon_sym_short] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(59),
    [anon_sym_break] = ACTIONS(25),
    [sym_true] = ACTIONS(5),
    [anon_sym_transient] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_default] = ACTIONS(7),
    [sym_decimal_floating_point_literal] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_RBRACE] = ACTIONS(2355),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(223),
    [anon_sym_public] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_synchronized] = ACTIONS(71),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(37),
    [anon_sym_long] = ACTIONS(33),
    [sym_hex_integer_literal] = ACTIONS(5),
    [anon_sym_abstract] = ACTIONS(7),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_do] = ACTIONS(45),
    [anon_sym_protected] = ACTIONS(7),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_final] = ACTIONS(7),
    [anon_sym_interface] = ACTIONS(39),
    [sym_void_type] = ACTIONS(55),
    [anon_sym_double] = ACTIONS(41),
    [sym_string_literal] = ACTIONS(35),
    [sym_super] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_char] = ACTIONS(33),
    [anon_sym_while] = ACTIONS(63),
    [sym_null_literal] = ACTIONS(5),
    [anon_sym_static] = ACTIONS(7),
    [anon_sym_module] = ACTIONS(21),
    [sym_false] = ACTIONS(5),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_open] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(41),
    [sym_this] = ACTIONS(5),
  },
  [773] = {
    [sym_type_arguments] = STATE(186),
    [sym__unqualified_object_creation_expression] = STATE(185),
    [anon_sym_new] = ACTIONS(346),
    [anon_sym_LT] = ACTIONS(146),
    [sym_comment] = ACTIONS(3),
    [sym_super] = ACTIONS(2357),
    [sym_identifier] = ACTIONS(695),
  },
  [774] = {
    [aux_sym_interface_type_list_repeat1] = STATE(685),
    [anon_sym_COMMA] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(2359),
    [anon_sym_LBRACE] = ACTIONS(2359),
  },
  [775] = {
    [anon_sym_LT] = ACTIONS(2361),
    [anon_sym_private] = ACTIONS(2363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_public] = ACTIONS(2363),
    [anon_sym_int] = ACTIONS(2363),
    [sym_void_type] = ACTIONS(2363),
    [anon_sym_final] = ACTIONS(2363),
    [anon_sym_abstract] = ACTIONS(2363),
    [anon_sym_strictfp] = ACTIONS(2363),
    [anon_sym_double] = ACTIONS(2363),
    [anon_sym_interface] = ACTIONS(2363),
    [anon_sym_ATinterface] = ACTIONS(2361),
    [anon_sym_protected] = ACTIONS(2363),
    [anon_sym_LBRACE] = ACTIONS(2361),
    [anon_sym_volatile] = ACTIONS(2363),
    [anon_sym_SEMI] = ACTIONS(2361),
    [anon_sym_short] = ACTIONS(2363),
    [anon_sym_class] = ACTIONS(2363),
    [anon_sym_char] = ACTIONS(2363),
    [anon_sym_static] = ACTIONS(2363),
    [anon_sym_native] = ACTIONS(2363),
    [anon_sym_long] = ACTIONS(2363),
    [anon_sym_float] = ACTIONS(2363),
    [anon_sym_byte] = ACTIONS(2363),
    [anon_sym_AT] = ACTIONS(2363),
    [anon_sym_RBRACE] = ACTIONS(2361),
    [anon_sym_synchronized] = ACTIONS(2363),
    [anon_sym_enum] = ACTIONS(2363),
    [anon_sym_transient] = ACTIONS(2363),
    [sym_identifier] = ACTIONS(2363),
    [sym_boolean_type] = ACTIONS(2363),
    [anon_sym_default] = ACTIONS(2363),
  },
  [776] = {
    [anon_sym_final] = ACTIONS(2365),
    [anon_sym_long] = ACTIONS(2365),
    [anon_sym_strictfp] = ACTIONS(2365),
    [anon_sym_LBRACE] = ACTIONS(2367),
    [anon_sym_default] = ACTIONS(2365),
    [anon_sym_ATinterface] = ACTIONS(2367),
    [anon_sym_short] = ACTIONS(2365),
    [anon_sym_protected] = ACTIONS(2365),
    [anon_sym_publ