#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 969
#define LARGE_STATE_COUNT 200
#define SYMBOL_COUNT 274
#define ALIAS_COUNT 1
#define TOKEN_COUNT 123
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 10

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  sym_string_literal = 11,
  sym_null_literal = 12,
  anon_sym_LPAREN = 13,
  anon_sym_AMP = 14,
  anon_sym_RPAREN = 15,
  anon_sym_EQ = 16,
  anon_sym_PLUS_EQ = 17,
  anon_sym_DASH_EQ = 18,
  anon_sym_STAR_EQ = 19,
  anon_sym_SLASH_EQ = 20,
  anon_sym_AMP_EQ = 21,
  anon_sym_PIPE_EQ = 22,
  anon_sym_CARET_EQ = 23,
  anon_sym_PERCENT_EQ = 24,
  anon_sym_LT_LT_EQ = 25,
  anon_sym_GT_GT_EQ = 26,
  anon_sym_GT_GT_GT_EQ = 27,
  anon_sym_GT = 28,
  anon_sym_LT = 29,
  anon_sym_EQ_EQ = 30,
  anon_sym_GT_EQ = 31,
  anon_sym_LT_EQ = 32,
  anon_sym_BANG_EQ = 33,
  anon_sym_AMP_AMP = 34,
  anon_sym_PIPE_PIPE = 35,
  anon_sym_PLUS = 36,
  anon_sym_DASH = 37,
  anon_sym_STAR = 38,
  anon_sym_SLASH = 39,
  anon_sym_PIPE = 40,
  anon_sym_CARET = 41,
  anon_sym_PERCENT = 42,
  anon_sym_LT_LT = 43,
  anon_sym_GT_GT = 44,
  anon_sym_GT_GT_GT = 45,
  anon_sym_instanceof = 46,
  anon_sym_DASH_GT = 47,
  anon_sym_COMMA = 48,
  anon_sym_QMARK = 49,
  anon_sym_COLON = 50,
  anon_sym_BANG = 51,
  anon_sym_TILDE = 52,
  anon_sym_PLUS_PLUS = 53,
  anon_sym_DASH_DASH = 54,
  anon_sym_new = 55,
  anon_sym_LBRACK = 56,
  anon_sym_RBRACK = 57,
  anon_sym_DOT = 58,
  anon_sym_class = 59,
  anon_sym_COLON_COLON = 60,
  anon_sym_extends = 61,
  anon_sym_SEMI = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_assert = 65,
  anon_sym_switch = 66,
  anon_sym_case = 67,
  anon_sym_default = 68,
  anon_sym_do = 69,
  anon_sym_while = 70,
  anon_sym_break = 71,
  anon_sym_continue = 72,
  anon_sym_return = 73,
  anon_sym_synchronized = 74,
  anon_sym_throw = 75,
  anon_sym_try = 76,
  anon_sym_catch = 77,
  anon_sym_finally = 78,
  anon_sym_if = 79,
  anon_sym_else = 80,
  anon_sym_for = 81,
  anon_sym_AT = 82,
  anon_sym_open = 83,
  anon_sym_module = 84,
  anon_sym_requires = 85,
  anon_sym_exports = 86,
  anon_sym_to = 87,
  anon_sym_opens = 88,
  anon_sym_uses = 89,
  anon_sym_provides = 90,
  anon_sym_with = 91,
  anon_sym_transitive = 92,
  anon_sym_static = 93,
  anon_sym_package = 94,
  anon_sym_import = 95,
  anon_sym_enum = 96,
  anon_sym_public = 97,
  anon_sym_protected = 98,
  anon_sym_private = 99,
  anon_sym_abstract = 100,
  anon_sym_final = 101,
  anon_sym_strictfp = 102,
  anon_sym_native = 103,
  anon_sym_transient = 104,
  anon_sym_volatile = 105,
  anon_sym_implements = 106,
  anon_sym_ATinterface = 107,
  anon_sym_interface = 108,
  anon_sym_byte = 109,
  anon_sym_short = 110,
  anon_sym_int = 111,
  anon_sym_long = 112,
  anon_sym_char = 113,
  anon_sym_float = 114,
  anon_sym_double = 115,
  sym_boolean_type = 116,
  sym_void_type = 117,
  anon_sym_DOT_DOT_DOT = 118,
  anon_sym_throws = 119,
  sym_this = 120,
  sym_super = 121,
  sym_comment = 122,
  sym_program = 123,
  sym__literal = 124,
  sym__expression = 125,
  sym_cast_expression = 126,
  sym_assignment_expression = 127,
  sym_binary_expression = 128,
  sym_instanceof_expression = 129,
  sym_lambda_expression = 130,
  sym_inferred_parameters = 131,
  sym_ternary_expression = 132,
  sym_unary_expression = 133,
  sym_update_expression = 134,
  sym__primary = 135,
  sym_array_creation_expression = 136,
  sym_dimensions_expr = 137,
  sym_parenthesized_expression = 138,
  sym_class_literal = 139,
  sym_object_creation_expression = 140,
  sym__unqualified_object_creation_expression = 141,
  sym_field_access = 142,
  sym_array_access = 143,
  sym_method_invocation = 144,
  sym_argument_list = 145,
  sym_method_reference = 146,
  sym_type_arguments = 147,
  sym_wildcard = 148,
  sym__wildcard_bounds = 149,
  sym_dimensions = 150,
  sym__statement = 151,
  sym_block = 152,
  sym_expression_statement = 153,
  sym_labeled_statement = 154,
  sym_assert_statement = 155,
  sym_switch_statement = 156,
  sym_switch_block = 157,
  sym_switch_label = 158,
  sym_do_statement = 159,
  sym_break_statement = 160,
  sym_continue_statement = 161,
  sym_return_statement = 162,
  sym_synchronized_statement = 163,
  sym_throw_statement = 164,
  sym_try_statement = 165,
  sym_catch_clause = 166,
  sym_catch_formal_parameter = 167,
  sym_catch_type = 168,
  sym_finally_clause = 169,
  sym_try_with_resources_statement = 170,
  sym_resource_specification = 171,
  sym_resource = 172,
  sym_if_statement = 173,
  sym_while_statement = 174,
  sym_for_statement = 175,
  sym_for_init = 176,
  sym_enhanced_for_statement = 177,
  sym__annotation = 178,
  sym_marker_annotation = 179,
  sym_annotation = 180,
  sym_annotation_argument_list = 181,
  sym_element_value_pair = 182,
  sym__element_value = 183,
  sym_element_value_array_initializer = 184,
  sym__declaration = 185,
  sym_module_declaration = 186,
  sym_module_directive = 187,
  sym_requires_modifier = 188,
  sym_module_name = 189,
  sym_package_declaration = 190,
  sym_import_declaration = 191,
  sym_asterisk = 192,
  sym_enum_declaration = 193,
  sym_enum_body = 194,
  sym_enum_body_declarations = 195,
  sym_enum_constant = 196,
  sym_class_declaration = 197,
  sym_modifiers = 198,
  sym_type_parameters = 199,
  sym_type_parameter = 200,
  sym_type_bound = 201,
  sym_superclass = 202,
  sym_super_interfaces = 203,
  sym_interface_type_list = 204,
  sym_class_body = 205,
  sym_static_initializer = 206,
  sym_constructor_declaration = 207,
  sym__constructor_declarator = 208,
  sym_constructor_body = 209,
  sym_explicit_constructor_invocation = 210,
  sym_scoped_identifier = 211,
  sym_field_declaration = 212,
  sym_annotation_type_declaration = 213,
  sym_annotation_type_body = 214,
  sym_annotation_type_element_declaration = 215,
  sym__default_value = 216,
  sym_interface_declaration = 217,
  sym_extends_interfaces = 218,
  sym_interface_body = 219,
  sym_constant_declaration = 220,
  sym__variable_declarator_list = 221,
  sym_variable_declarator = 222,
  sym__variable_declarator_id = 223,
  sym_array_initializer = 224,
  sym__type = 225,
  sym__unannotated_type = 226,
  sym_annotated_type = 227,
  sym_scoped_type_identifier = 228,
  sym_generic_type = 229,
  sym_array_type = 230,
  sym_integral_type = 231,
  sym_floating_point_type = 232,
  sym__method_header = 233,
  sym__method_declarator = 234,
  sym_formal_parameters = 235,
  sym_formal_parameter = 236,
  sym_receiver_parameter = 237,
  sym_spread_parameter = 238,
  sym_throws = 239,
  sym_local_variable_declaration_statement = 240,
  sym_local_variable_declaration = 241,
  sym_method_declaration = 242,
  aux_sym_program_repeat1 = 243,
  aux_sym_cast_expression_repeat1 = 244,
  aux_sym_inferred_parameters_repeat1 = 245,
  aux_sym_array_creation_expression_repeat1 = 246,
  aux_sym_dimensions_expr_repeat1 = 247,
  aux_sym_class_literal_repeat1 = 248,
  aux_sym_argument_list_repeat1 = 249,
  aux_sym_type_arguments_repeat1 = 250,
  aux_sym_dimensions_repeat1 = 251,
  aux_sym_switch_block_repeat1 = 252,
  aux_sym_try_statement_repeat1 = 253,
  aux_sym_catch_type_repeat1 = 254,
  aux_sym_resource_specification_repeat1 = 255,
  aux_sym_annotation_argument_list_repeat1 = 256,
  aux_sym_element_value_array_initializer_repeat1 = 257,
  aux_sym_module_declaration_repeat1 = 258,
  aux_sym_module_directive_repeat1 = 259,
  aux_sym_module_directive_repeat2 = 260,
  aux_sym_module_directive_repeat3 = 261,
  aux_sym_import_declaration_repeat1 = 262,
  aux_sym_enum_body_repeat1 = 263,
  aux_sym_enum_body_declarations_repeat1 = 264,
  aux_sym_modifiers_repeat1 = 265,
  aux_sym_type_parameters_repeat1 = 266,
  aux_sym_type_bound_repeat1 = 267,
  aux_sym_interface_type_list_repeat1 = 268,
  aux_sym_annotation_type_body_repeat1 = 269,
  aux_sym_interface_body_repeat1 = 270,
  aux_sym__variable_declarator_list_repeat1 = 271,
  aux_sym_array_initializer_repeat1 = 272,
  aux_sym_formal_parameters_repeat1 = 273,
  alias_sym_type_identifier = 274,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_AMP] = "&",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_SEMI] = ";",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_assert] = "assert",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_final] = "final",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_implements] = "implements",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_comment] = "comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym__expression] = "_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym__primary] = "_primary",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym__statement] = "_statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_block] = "switch_block",
  [sym_switch_label] = "switch_label",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_init] = "for_init",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym__declaration] = "_declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_directive] = "module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_module_name] = "module_name",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_interface_type_list] = "interface_type_list",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym__default_value] = "_default_value",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration_statement] = "local_variable_declaration_statement",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_dimensions_expr_repeat1] = "dimensions_expr_repeat1",
  [aux_sym_class_literal_repeat1] = "class_literal_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_declaration_repeat1] = "module_declaration_repeat1",
  [aux_sym_module_directive_repeat1] = "module_directive_repeat1",
  [aux_sym_module_directive_repeat2] = "module_directive_repeat2",
  [aux_sym_module_directive_repeat3] = "module_directive_repeat3",
  [aux_sym_import_declaration_repeat1] = "import_declaration_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_interface_type_list_repeat1] = "interface_type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_octal_integer_literal] = sym_octal_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_hex_floating_point_literal] = sym_hex_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_character_literal] = sym_character_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_exports] = anon_sym_exports,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_opens] = anon_sym_opens,
  [anon_sym_uses] = anon_sym_uses,
  [anon_sym_provides] = anon_sym_provides,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_throws] = anon_sym_throws,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_comment] = sym_comment,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym__expression] = sym__expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_inferred_parameters] = sym_inferred_parameters,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym__primary] = sym__primary,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_method_reference] = sym_method_reference,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym__statement] = sym__statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_label] = sym_switch_label,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_synchronized_statement] = sym_synchronized_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_try_with_resources_statement] = sym_try_with_resources_statement,
  [sym_resource_specification] = sym_resource_specification,
  [sym_resource] = sym_resource,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_init] = sym_for_init,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym__declaration] = sym__declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_module_directive] = sym_module_directive,
  [sym_requires_modifier] = sym_requires_modifier,
  [sym_module_name] = sym_module_name,
  [sym_package_declaration] = sym_package_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym_asterisk] = sym_asterisk,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_interface_type_list] = sym_interface_type_list,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_annotation_type_declaration] = sym_annotation_type_declaration,
  [sym_annotation_type_body] = sym_annotation_type_body,
  [sym_annotation_type_element_declaration] = sym_annotation_type_element_declaration,
  [sym__default_value] = sym__default_value,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_throws] = sym_throws,
  [sym_local_variable_declaration_statement] = sym_local_variable_declaration_statement,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_dimensions_expr_repeat1] = aux_sym_dimensions_expr_repeat1,
  [aux_sym_class_literal_repeat1] = aux_sym_class_literal_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_resource_specification_repeat1] = aux_sym_resource_specification_repeat1,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_module_declaration_repeat1] = aux_sym_module_declaration_repeat1,
  [aux_sym_module_directive_repeat1] = aux_sym_module_directive_repeat1,
  [aux_sym_module_directive_repeat2] = aux_sym_module_directive_repeat2,
  [aux_sym_module_directive_repeat3] = aux_sym_module_directive_repeat3,
  [aux_sym_import_declaration_repeat1] = aux_sym_import_declaration_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_interface_type_list_repeat1] = aux_sym_interface_type_list_repeat1,
  [aux_sym_annotation_type_body_repeat1] = aux_sym_annotation_type_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary] = {
    .visible = false,
    .named = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_init] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_module_name] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__default_value] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_constructor = 7,
  field_declarator = 8,
  field_dimensions = 9,
  field_element = 10,
  field_field = 11,
  field_index = 12,
  field_interfaces = 13,
  field_key = 14,
  field_left = 15,
  field_name = 16,
  field_object = 17,
  field_operand = 18,
  field_operator = 19,
  field_parameters = 20,
  field_resources = 21,
  field_right = 22,
  field_superclass = 23,
  field_type = 24,
  field_type_arguments = 25,
  field_type_paramaters = 26,
  field_type_parameters = 27,
  field_value = 28,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_paramaters] = "type_paramaters",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[133] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 1},
  [13] = {.index = 14, .length = 2},
  [14] = {.index = 16, .length = 3},
  [15] = {.index = 19, .length = 2},
  [16] = {.index = 21, .length = 2},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 21, .length = 2},
  [19] = {.index = 23, .length = 2},
  [20] = {.index = 25, .length = 2},
  [21] = {.index = 27, .length = 1},
  [22] = {.index = 28, .length = 2},
  [23] = {.index = 30, .length = 2},
  [24] = {.index = 32, .length = 2},
  [25] = {.index = 34, .length = 3},
  [26] = {.index = 37, .length = 2},
  [27] = {.index = 39, .length = 3},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 34, .length = 3},
  [31] = {.index = 42, .length = 2},
  [33] = {.index = 39, .length = 3},
  [34] = {.index = 44, .length = 2},
  [35] = {.index = 46, .length = 2},
  [36] = {.index = 48, .length = 2},
  [37] = {.index = 48, .length = 2},
  [38] = {.index = 50, .length = 2},
  [40] = {.index = 52, .length = 3},
  [41] = {.index = 55, .length = 1},
  [42] = {.index = 56, .length = 2},
  [43] = {.index = 58, .length = 2},
  [44] = {.index = 60, .length = 3},
  [45] = {.index = 63, .length = 3},
  [46] = {.index = 60, .length = 3},
  [47] = {.index = 63, .length = 3},
  [48] = {.index = 66, .length = 3},
  [49] = {.index = 66, .length = 3},
  [50] = {.index = 69, .length = 3},
  [51] = {.index = 72, .length = 3},
  [52] = {.index = 75, .length = 3},
  [53] = {.index = 78, .length = 2},
  [54] = {.index = 80, .length = 3},
  [55] = {.index = 83, .length = 2},
  [56] = {.index = 80, .length = 3},
  [57] = {.index = 78, .length = 2},
  [59] = {.index = 85, .length = 2},
  [60] = {.index = 87, .length = 1},
  [61] = {.index = 88, .length = 2},
  [62] = {.index = 90, .length = 3},
  [65] = {.index = 93, .length = 3},
  [66] = {.index = 96, .length = 2},
  [67] = {.index = 98, .length = 4},
  [68] = {.index = 102, .length = 4},
  [69] = {.index = 106, .length = 5},
  [70] = {.index = 111, .length = 6},
  [71] = {.index = 117, .length = 4},
  [72] = {.index = 121, .length = 4},
  [73] = {.index = 125, .length = 4},
  [74] = {.index = 129, .length = 3},
  [75] = {.index = 132, .length = 2},
  [76] = {.index = 134, .length = 4},
  [77] = {.index = 138, .length = 2},
  [78] = {.index = 140, .length = 3},
  [79] = {.index = 134, .length = 4},
  [80] = {.index = 132, .length = 2},
  [81] = {.index = 143, .length = 3},
  [82] = {.index = 146, .length = 3},
  [83] = {.index = 149, .length = 3},
  [84] = {.index = 152, .length = 3},
  [85] = {.index = 155, .length = 2},
  [86] = {.index = 157, .length = 4},
  [87] = {.index = 161, .length = 5},
  [88] = {.index = 166, .length = 6},
  [89] = {.index = 172, .length = 3},
  [90] = {.index = 175, .length = 5},
  [91] = {.index = 96, .length = 2},
  [92] = {.index = 180, .length = 5},
  [93] = {.index = 185, .length = 4},
  [94] = {.index = 189, .length = 2},
  [95] = {.index = 191, .length = 2},
  [96] = {.index = 193, .length = 3},
  [97] = {.index = 196, .length = 3},
  [98] = {.index = 193, .length = 3},
  [99] = {.index = 199, .length = 4},
  [100] = {.index = 203, .length = 4},
  [101] = {.index = 207, .length = 4},
  [102] = {.index = 211, .length = 3},
  [104] = {.index = 214, .length = 4},
  [105] = {.index = 218, .length = 5},
  [106] = {.index = 223, .length = 3},
  [107] = {.index = 223, .length = 3},
  [108] = {.index = 226, .length = 4},
  [109] = {.index = 230, .length = 1},
  [110] = {.index = 231, .length = 2},
  [111] = {.index = 233, .length = 4},
  [112] = {.index = 237, .length = 3},
  [113] = {.index = 233, .length = 4},
  [114] = {.index = 240, .length = 5},
  [115] = {.index = 245, .length = 2},
  [116] = {.index = 247, .length = 5},
  [118] = {.index = 252, .length = 2},
  [119] = {.index = 254, .length = 3},
  [120] = {.index = 257, .length = 5},
  [121] = {.index = 262, .length = 2},
  [122] = {.index = 264, .length = 1},
  [123] = {.index = 265, .length = 3},
  [124] = {.index = 268, .length = 3},
  [125] = {.index = 271, .length = 3},
  [126] = {.index = 271, .length = 3},
  [127] = {.index = 274, .length = 3},
  [128] = {.index = 277, .length = 3},
  [129] = {.index = 280, .length = 4},
  [130] = {.index = 284, .length = 4},
  [131] = {.index = 284, .length = 4},
  [132] = {.index = 288, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [13] =
    {field_declarator, 0},
  [14] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [16] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [19] =
    {field_arguments, 2},
    {field_type, 1},
  [21] =
    {field_dimensions, 2},
    {field_type, 1},
  [23] =
    {field_body, 2},
    {field_name, 1},
  [25] =
    {field_body, 2},
    {field_condition, 1},
  [27] =
    {field_body, 1},
  [28] =
    {field_body, 2},
    {field_resources, 1},
  [30] =
    {field_condition, 1},
    {field_consequence, 2},
  [32] =
    {field_arguments, 2},
    {field_name, 1},
  [34] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [37] =
    {field_field, 2},
    {field_object, 0},
  [39] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [42] =
    {field_body, 2},
    {field_parameters, 0},
  [44] =
    {field_left, 0},
    {field_right, 2},
  [46] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [48] =
    {field_dimensions, 1},
    {field_name, 0},
  [50] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [52] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [55] =
    {field_type, 1},
  [56] =
    {field_type, 1},
    {field_value, 3},
  [58] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [60] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [63] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [66] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [69] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [72] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [75] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [78] =
    {field_array, 0},
    {field_index, 2},
  [80] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [83] =
    {field_body, 3},
    {field_name, 1},
  [85] =
    {field_body, 3},
    {field_name, 2},
  [87] =
    {field_declarator, 1},
  [88] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [90] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [93] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [96] =
    {field_name, 0},
    {field_parameters, 1},
  [98] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_paramaters, 0, .inherited = true},
  [102] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [106] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [111] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [117] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [121] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [125] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [129] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [132] =
    {field_field, 4},
    {field_object, 0},
  [134] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [138] =
    {field_body, 1},
    {field_name, 0},
  [140] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [143] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [146] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [149] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [152] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [155] =
    {field_body, 4},
    {field_name, 2},
  [157] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_paramaters, 1, .inherited = true},
  [161] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [166] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [172] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_paramaters, 0},
  [175] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [180] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [185] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [189] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [191] =
    {field_key, 0},
    {field_value, 2},
  [193] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [196] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [199] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [203] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [207] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [211] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [214] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_paramaters, 1, .inherited = true},
  [218] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [223] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [226] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [230] =
    {field_body, 4},
  [231] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [233] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [237] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [240] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [245] =
    {field_arguments, 1},
    {field_constructor, 0},
  [247] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [252] =
    {field_name, 1},
    {field_type, 0},
  [254] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [257] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [262] =
    {field_name, 2},
    {field_type, 1},
  [264] =
    {field_value, 1},
  [265] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
  [268] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 4, .inherited = true},
  [271] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [274] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
  [277] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 5, .inherited = true},
  [280] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
    {field_value, 5, .inherited = true},
  [284] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [288] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
    {field_value, 6, .inherited = true},
};

static TSSymbol ts_alias_sequences[133][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = alias_sym_type_identifier,
  },
  [6] = {
    [0] = sym_identifier,
  },
  [8] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_type_identifier,
  },
  [18] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [0] = sym_identifier,
  },
  [26] = {
    [0] = sym_identifier,
  },
  [27] = {
    [0] = sym_identifier,
  },
  [28] = {
    [1] = sym_identifier,
  },
  [32] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [36] = {
    [0] = sym_identifier,
  },
  [39] = {
    [2] = alias_sym_type_identifier,
  },
  [46] = {
    [1] = alias_sym_type_identifier,
  },
  [47] = {
    [1] = alias_sym_type_identifier,
  },
  [49] = {
    [2] = alias_sym_type_identifier,
  },
  [53] = {
    [0] = sym_identifier,
  },
  [54] = {
    [0] = sym_identifier,
  },
  [58] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [63] = {
    [3] = alias_sym_type_identifier,
  },
  [64] = {
    [2] = sym_identifier,
  },
  [75] = {
    [0] = sym_identifier,
  },
  [76] = {
    [0] = sym_identifier,
  },
  [91] = {
    [0] = sym_identifier,
  },
  [96] = {
    [0] = sym_identifier,
  },
  [103] = {
    [3] = sym_identifier,
  },
  [106] = {
    [0] = sym_identifier,
  },
  [111] = {
    [0] = sym_identifier,
  },
  [117] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [125] = {
    [0] = sym_identifier,
  },
  [130] = {
    [0] = sym_identifier,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(126);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(108);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(108);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 6:
      if (lookahead == '\'') ADVANCE(67);
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(147);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(146);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(144);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 16:
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(6);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 18:
      if (lookahead == '_') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 19:
      if (lookahead == '_') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 20:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(26);
      END_STATE();
    case 25:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(23);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 30:
      if (lookahead == 't') ADVANCE(25);
      END_STATE();
    case 31:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 32:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 33:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(56);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(54);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 40:
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 41:
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 42:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(136);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 43:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(35);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 44:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(126);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(35);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(33);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(46);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(34);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(13);
      if (lookahead == '_') ADVANCE(17);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(31);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(46);
      if (lookahead == '_') ADVANCE(17);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(31);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(53);
      if (lookahead == '_') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(55);
      if (lookahead == '_') ADVANCE(33);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(18);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(19);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_string_literal);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(97);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(97);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(94);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(94);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(116);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(115);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(129);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(130);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(147);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '|') ADVANCE(98);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(98);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(85);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(137);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(28);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(147);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'r') ADVANCE(22);
      if (lookahead == 'y') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'h') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(32);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'i') ADVANCE(34);
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(37);
      if (lookahead == 'm') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'u') ADVANCE(44);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(45);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(47);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 't') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == 'w') ADVANCE(53);
      if (lookahead == 'y') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(60);
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(62);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(70);
      END_STATE();
    case 27:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(72);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(73);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 32:
      if (lookahead == 'p') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 35:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 38:
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 41:
      if (lookahead == 'd') ADVANCE(86);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 43:
      if (lookahead == 'w') ADVANCE(88);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(92);
      if (lookahead == 'o') ADVANCE(93);
      END_STATE();
    case 48:
      if (lookahead == 'b') ADVANCE(94);
      END_STATE();
    case 49:
      if (lookahead == 'q') ADVANCE(95);
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 50:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(98);
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(100);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(101);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'u') ADVANCE(106);
      if (lookahead == 'y') ADVANCE(107);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == 'l') ADVANCE(110);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(119);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 73:
      if (lookahead == 'b') ADVANCE(124);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(126);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(132);
      if (lookahead == 'o') ADVANCE(133);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 85:
      if (lookahead == 'g') ADVANCE(136);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 87:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 90:
      if (lookahead == 'n') ADVANCE(140);
      END_STATE();
    case 91:
      if (lookahead == 'k') ADVANCE(141);
      END_STATE();
    case 92:
      if (lookahead == 'v') ADVANCE(142);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(143);
      if (lookahead == 'v') ADVANCE(144);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 95:
      if (lookahead == 'u') ADVANCE(146);
      END_STATE();
    case 96:
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(150);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 104:
      if (lookahead == 'o') ADVANCE(155);
      END_STATE();
    case 105:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(158);
      END_STATE();
    case 109:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 112:
      if (lookahead == 'h') ADVANCE(162);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 116:
      if (lookahead == 'k') ADVANCE(166);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 119:
      if (lookahead == 'h') ADVANCE(167);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 121:
      if (lookahead == 's') ADVANCE(168);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(169);
      END_STATE();
    case 123:
      if (lookahead == 'u') ADVANCE(170);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 127:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 137:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 138:
      if (lookahead == 'v') ADVANCE(182);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(185);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(187);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(190);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 150:
      if (lookahead == 'c') ADVANCE(193);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(195);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(196);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 155:
      if (lookahead == 'w') ADVANCE(197);
      END_STATE();
    case 156:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(201);
      END_STATE();
    case 164:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(203);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 173:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 177:
      if (lookahead == 'm') ADVANCE(210);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 180:
      if (lookahead == 'f') ADVANCE(213);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 184:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(217);
      END_STATE();
    case 186:
      if (lookahead == 'c') ADVANCE(218);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(219);
      END_STATE();
    case 188:
      if (lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 189:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 192:
      if (lookahead == 'c') ADVANCE(223);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 195:
      if (lookahead == 'h') ADVANCE(225);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(227);
      END_STATE();
    case 198:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 199:
      if (lookahead == 'i') ADVANCE(229);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(230);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 204:
      if (lookahead == 'u') ADVANCE(232);
      END_STATE();
    case 205:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 207:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 208:
      if (lookahead == 's') ADVANCE(235);
      END_STATE();
    case 209:
      if (lookahead == 'y') ADVANCE(236);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(237);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 212:
      if (lookahead == 'c') ADVANCE(238);
      END_STATE();
    case 213:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 219:
      if (lookahead == 'e') ADVANCE(243);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(244);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 224:
      if (lookahead == 'f') ADVANCE(245);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 226:
      if (lookahead == 'o') ADVANCE(246);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(247);
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 229:
      if (lookahead == 'l') ADVANCE(249);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 237:
      if (lookahead == 'n') ADVANCE(252);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 239:
      if (lookahead == 'c') ADVANCE(254);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 243:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 244:
      if (lookahead == 's') ADVANCE(257);
      END_STATE();
    case 245:
      if (lookahead == 'p') ADVANCE(258);
      END_STATE();
    case 246:
      if (lookahead == 'n') ADVANCE(259);
      END_STATE();
    case 247:
      if (lookahead == 'n') ADVANCE(260);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(261);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 252:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 253:
      if (lookahead == 'o') ADVANCE(264);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 255:
      if (lookahead == 'd') ADVANCE(266);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 259:
      if (lookahead == 'i') ADVANCE(267);
      END_STATE();
    case 260:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 261:
      if (lookahead == 'v') ADVANCE(269);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 263:
      if (lookahead == 's') ADVANCE(270);
      END_STATE();
    case 264:
      if (lookahead == 'f') ADVANCE(271);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 267:
      if (lookahead == 'z') ADVANCE(272);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 274:
      if (lookahead == 'd') ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 44},
  [2] = {.lex_state = 44},
  [3] = {.lex_state = 44},
  [4] = {.lex_state = 44},
  [5] = {.lex_state = 44},
  [6] = {.lex_state = 44},
  [7] = {.lex_state = 44},
  [8] = {.lex_state = 44},
  [9] = {.lex_state = 44},
  [10] = {.lex_state = 44},
  [11] = {.lex_state = 44},
  [12] = {.lex_state = 44},
  [13] = {.lex_state = 44},
  [14] = {.lex_state = 44},
  [15] = {.lex_state = 44},
  [16] = {.lex_state = 44},
  [17] = {.lex_state = 44},
  [18] = {.lex_state = 44},
  [19] = {.lex_state = 44},
  [20] = {.lex_state = 44},
  [21] = {.lex_state = 44},
  [22] = {.lex_state = 44},
  [23] = {.lex_state = 44},
  [24] = {.lex_state = 44},
  [25] = {.lex_state = 44},
  [26] = {.lex_state = 44},
  [27] = {.lex_state = 42},
  [28] = {.lex_state = 42},
  [29] = {.lex_state = 42},
  [30] = {.lex_state = 43},
  [31] = {.lex_state = 43},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 44},
  [35] = {.lex_state = 44},
  [36] = {.lex_state = 44},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 1},
  [40] = {.lex_state = 44},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 44},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 44},
  [54] = {.lex_state = 44},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 44},
  [57] = {.lex_state = 44},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 44},
  [60] = {.lex_state = 44},
  [61] = {.lex_state = 44},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 44},
  [68] = {.lex_state = 44},
  [69] = {.lex_state = 44},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 44},
  [72] = {.lex_state = 44},
  [73] = {.lex_state = 44},
  [74] = {.lex_state = 44},
  [75] = {.lex_state = 44},
  [76] = {.lex_state = 44},
  [77] = {.lex_state = 44},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 44},
  [80] = {.lex_state = 44},
  [81] = {.lex_state = 44},
  [82] = {.lex_state = 44},
  [83] = {.lex_state = 44},
  [84] = {.lex_state = 44},
  [85] = {.lex_state = 44},
  [86] = {.lex_state = 44},
  [87] = {.lex_state = 44},
  [88] = {.lex_state = 44},
  [89] = {.lex_state = 44},
  [90] = {.lex_state = 44},
  [91] = {.lex_state = 44},
  [92] = {.lex_state = 44},
  [93] = {.lex_state = 44},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 44},
  [97] = {.lex_state = 44},
  [98] = {.lex_state = 44},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 44},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 44},
  [103] = {.lex_state = 44},
  [104] = {.lex_state = 44},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 44},
  [107] = {.lex_state = 44},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 44},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 44},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 44},
  [118] = {.lex_state = 44},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 44},
  [122] = {.lex_state = 44},
  [123] = {.lex_state = 44},
  [124] = {.lex_state = 44},
  [125] = {.lex_state = 44},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 1},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 44},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 44},
  [136] = {.lex_state = 44},
  [137] = {.lex_state = 44},
  [138] = {.lex_state = 44},
  [139] = {.lex_state = 44},
  [140] = {.lex_state = 44},
  [141] = {.lex_state = 44},
  [142] = {.lex_state = 44},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 44},
  [145] = {.lex_state = 44},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 44},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 44},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 44},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 44},
  [154] = {.lex_state = 44},
  [155] = {.lex_state = 44},
  [156] = {.lex_state = 44},
  [157] = {.lex_state = 44},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 44},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 44},
  [162] = {.lex_state = 44},
  [163] = {.lex_state = 44},
  [164] = {.lex_state = 44},
  [165] = {.lex_state = 44},
  [166] = {.lex_state = 44},
  [167] = {.lex_state = 44},
  [168] = {.lex_state = 44},
  [169] = {.lex_state = 44},
  [170] = {.lex_state = 44},
  [171] = {.lex_state = 44},
  [172] = {.lex_state = 44},
  [173] = {.lex_state = 44},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 44},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 44},
  [180] = {.lex_state = 44},
  [181] = {.lex_state = 44},
  [182] = {.lex_state = 44},
  [183] = {.lex_state = 44},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 44},
  [186] = {.lex_state = 44},
  [187] = {.lex_state = 44},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 44},
  [192] = {.lex_state = 44},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 44},
  [195] = {.lex_state = 44},
  [196] = {.lex_state = 44},
  [197] = {.lex_state = 44},
  [198] = {.lex_state = 44},
  [199] = {.lex_state = 44},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 2},
  [206] = {.lex_state = 2},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 2},
  [211] = {.lex_state = 2},
  [212] = {.lex_state = 2},
  [213] = {.lex_state = 2},
  [214] = {.lex_state = 2},
  [215] = {.lex_state = 2},
  [216] = {.lex_state = 2},
  [217] = {.lex_state = 2},
  [218] = {.lex_state = 2},
  [219] = {.lex_state = 5},
  [220] = {.lex_state = 2},
  [221] = {.lex_state = 2},
  [222] = {.lex_state = 5},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 2},
  [225] = {.lex_state = 2},
  [226] = {.lex_state = 2},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 2},
  [229] = {.lex_state = 2},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 2},
  [232] = {.lex_state = 2},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 2},
  [235] = {.lex_state = 2},
  [236] = {.lex_state = 5},
  [237] = {.lex_state = 3},
  [238] = {.lex_state = 5},
  [239] = {.lex_state = 3},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 2},
  [242] = {.lex_state = 3},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 7},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 3},
  [248] = {.lex_state = 3},
  [249] = {.lex_state = 7},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 3},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 3},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 2},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 3},
  [263] = {.lex_state = 3},
  [264] = {.lex_state = 2},
  [265] = {.lex_state = 3},
  [266] = {.lex_state = 2},
  [267] = {.lex_state = 7},
  [268] = {.lex_state = 3},
  [269] = {.lex_state = 3},
  [270] = {.lex_state = 2},
  [271] = {.lex_state = 3},
  [272] = {.lex_state = 3},
  [273] = {.lex_state = 3},
  [274] = {.lex_state = 3},
  [275] = {.lex_state = 3},
  [276] = {.lex_state = 3},
  [277] = {.lex_state = 3},
  [278] = {.lex_state = 3},
  [279] = {.lex_state = 3},
  [280] = {.lex_state = 3},
  [281] = {.lex_state = 3},
  [282] = {.lex_state = 3},
  [283] = {.lex_state = 3},
  [284] = {.lex_state = 3},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 3},
  [288] = {.lex_state = 3},
  [289] = {.lex_state = 3},
  [290] = {.lex_state = 3},
  [291] = {.lex_state = 3},
  [292] = {.lex_state = 3},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 3},
  [295] = {.lex_state = 3},
  [296] = {.lex_state = 3},
  [297] = {.lex_state = 3},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 3},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 3},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 3},
  [309] = {.lex_state = 3},
  [310] = {.lex_state = 3},
  [311] = {.lex_state = 3},
  [312] = {.lex_state = 3},
  [313] = {.lex_state = 3},
  [314] = {.lex_state = 3},
  [315] = {.lex_state = 3},
  [316] = {.lex_state = 3},
  [317] = {.lex_state = 3},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 3},
  [322] = {.lex_state = 3},
  [323] = {.lex_state = 3},
  [324] = {.lex_state = 3},
  [325] = {.lex_state = 3},
  [326] = {.lex_state = 3},
  [327] = {.lex_state = 3},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 3},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 3},
  [357] = {.lex_state = 3},
  [358] = {.lex_state = 3},
  [359] = {.lex_state = 3},
  [360] = {.lex_state = 3},
  [361] = {.lex_state = 3},
  [362] = {.lex_state = 3},
  [363] = {.lex_state = 3},
  [364] = {.lex_state = 3},
  [365] = {.lex_state = 3},
  [366] = {.lex_state = 3},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 3},
  [369] = {.lex_state = 3},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 3},
  [372] = {.lex_state = 3},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 3},
  [375] = {.lex_state = 3},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 1},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 3},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 1},
  [391] = {.lex_state = 3},
  [392] = {.lex_state = 1},
  [393] = {.lex_state = 3},
  [394] = {.lex_state = 3},
  [395] = {.lex_state = 3},
  [396] = {.lex_state = 3},
  [397] = {.lex_state = 3},
  [398] = {.lex_state = 1},
  [399] = {.lex_state = 3},
  [400] = {.lex_state = 1},
  [401] = {.lex_state = 3},
  [402] = {.lex_state = 3},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 3},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 3},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 1},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 1},
  [411] = {.lex_state = 3},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 3},
  [414] = {.lex_state = 3},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 3},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 3},
  [419] = {.lex_state = 3},
  [420] = {.lex_state = 3},
  [421] = {.lex_state = 3},
  [422] = {.lex_state = 1},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 3},
  [425] = {.lex_state = 3},
  [426] = {.lex_state = 3},
  [427] = {.lex_state = 3},
  [428] = {.lex_state = 3},
  [429] = {.lex_state = 3},
  [430] = {.lex_state = 3},
  [431] = {.lex_state = 3},
  [432] = {.lex_state = 1},
  [433] = {.lex_state = 3},
  [434] = {.lex_state = 3},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 3},
  [437] = {.lex_state = 3},
  [438] = {.lex_state = 1},
  [439] = {.lex_state = 1},
  [440] = {.lex_state = 1},
  [441] = {.lex_state = 1},
  [442] = {.lex_state = 1},
  [443] = {.lex_state = 1},
  [444] = {.lex_state = 1},
  [445] = {.lex_state = 1},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 1},
  [448] = {.lex_state = 1},
  [449] = {.lex_state = 1},
  [450] = {.lex_state = 1},
  [451] = {.lex_state = 1},
  [452] = {.lex_state = 1},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 1},
  [455] = {.lex_state = 1},
  [456] = {.lex_state = 1},
  [457] = {.lex_state = 1},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 1},
  [460] = {.lex_state = 1},
  [461] = {.lex_state = 5},
  [462] = {.lex_state = 5},
  [463] = {.lex_state = 5},
  [464] = {.lex_state = 5},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 5},
  [467] = {.lex_state = 5},
  [468] = {.lex_state = 5},
  [469] = {.lex_state = 5},
  [470] = {.lex_state = 5},
  [471] = {.lex_state = 5},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 5},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 1},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 2},
  [488] = {.lex_state = 1},
  [489] = {.lex_state = 1},
  [490] = {.lex_state = 2},
  [491] = {.lex_state = 2},
  [492] = {.lex_state = 2},
  [493] = {.lex_state = 1},
  [494] = {.lex_state = 1},
  [495] = {.lex_state = 1},
  [496] = {.lex_state = 1},
  [497] = {.lex_state = 1},
  [498] = {.lex_state = 2},
  [499] = {.lex_state = 1},
  [500] = {.lex_state = 1},
  [501] = {.lex_state = 1},
  [502] = {.lex_state = 1},
  [503] = {.lex_state = 1},
  [504] = {.lex_state = 1},
  [505] = {.lex_state = 1},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 1},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 2},
  [510] = {.lex_state = 1},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 1},
  [513] = {.lex_state = 1},
  [514] = {.lex_state = 1},
  [515] = {.lex_state = 1},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 2},
  [518] = {.lex_state = 1},
  [519] = {.lex_state = 1},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 2},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 2},
  [527] = {.lex_state = 2},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 2},
  [532] = {.lex_state = 1},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 1},
  [535] = {.lex_state = 1},
  [536] = {.lex_state = 1},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 1},
  [539] = {.lex_state = 2},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 2},
  [542] = {.lex_state = 2},
  [543] = {.lex_state = 1},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 1},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 2},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 2},
  [567] = {.lex_state = 1},
  [568] = {.lex_state = 2},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 1},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 1},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 1},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 1},
  [579] = {.lex_state = 1},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 2},
  [582] = {.lex_state = 1},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 1},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 1},
  [591] = {.lex_state = 1},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 1},
  [597] = {.lex_state = 1},
  [598] = {.lex_state = 1},
  [599] = {.lex_state = 1},
  [600] = {.lex_state = 1},
  [601] = {.lex_state = 1},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 1},
  [605] = {.lex_state = 1},
  [606] = {.lex_state = 1},
  [607] = {.lex_state = 1},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 1},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 44},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 2},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 2},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 2},
  [627] = {.lex_state = 2},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 44},
  [632] = {.lex_state = 2},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 44},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 44},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 44},
  [656] = {.lex_state = 2},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 2},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 2},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 2},
  [669] = {.lex_state = 2},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 2},
  [676] = {.lex_state = 2},
  [677] = {.lex_state = 2},
  [678] = {.lex_state = 2},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 44},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 44},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 44},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 2},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 2},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 44},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 2},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 2},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 2},
  [714] = {.lex_state = 2},
  [715] = {.lex_state = 2},
  [716] = {.lex_state = 44},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 2},
  [729] = {.lex_state = 2},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 44},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 44},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 2},
  [747] = {.lex_state = 2},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 44},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 2},
  [753] = {.lex_state = 2},
  [754] = {.lex_state = 44},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 2},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 2},
  [760] = {.lex_state = 2},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 2},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 2},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 44},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 44},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 2},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 2},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 2},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 2},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 2},
  [801] = {.lex_state = 44},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 2},
  [804] = {.lex_state = 2},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 2},
  [808] = {.lex_state = 2},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 2},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 2},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 2},
  [821] = {.lex_state = 44},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 44},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 2},
  [826] = {.lex_state = 2},
  [827] = {.lex_state = 44},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 2},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 44},
  [852] = {.lex_state = 44},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 44},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 2},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 2},
  [862] = {.lex_state = 2},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 2},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 2},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 2},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 2},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 2},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 2},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [sym_string_literal] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(946),
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(10),
    [sym_block] = STATE(10),
    [sym_expression_statement] = STATE(10),
    [sym_labeled_statement] = STATE(10),
    [sym_assert_statement] = STATE(10),
    [sym_switch_statement] = STATE(10),
    [sym_do_statement] = STATE(10),
    [sym_break_statement] = STATE(10),
    [sym_continue_statement] = STATE(10),
    [sym_return_statement] = STATE(10),
    [sym_synchronized_statement] = STATE(10),
    [sym_throw_statement] = STATE(10),
    [sym_try_statement] = STATE(10),
    [sym_try_with_resources_statement] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_enhanced_for_statement] = STATE(10),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(10),
    [sym_module_declaration] = STATE(10),
    [sym_package_declaration] = STATE(10),
    [sym_import_declaration] = STATE(10),
    [sym_enum_declaration] = STATE(10),
    [sym_class_declaration] = STATE(10),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(10),
    [sym_interface_declaration] = STATE(10),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(10),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__literal] = STATE(391),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(391),
    [sym_array_creation_expression] = STATE(391),
    [sym_parenthesized_expression] = STATE(391),
    [sym_class_literal] = STATE(391),
    [sym_object_creation_expression] = STATE(391),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(391),
    [sym_method_reference] = STATE(391),
    [sym_type_arguments] = STATE(850),
    [sym__statement] = STATE(14),
    [sym_block] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_assert_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_synchronized_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_try_with_resources_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_enhanced_for_statement] = STATE(14),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(14),
    [sym_module_declaration] = STATE(14),
    [sym_package_declaration] = STATE(14),
    [sym_import_declaration] = STATE(14),
    [sym_enum_declaration] = STATE(14),
    [sym_class_declaration] = STATE(14),
    [sym_modifiers] = STATE(458),
    [sym_explicit_constructor_invocation] = STATE(13),
    [sym_scoped_identifier] = STATE(241),
    [sym_annotation_type_declaration] = STATE(14),
    [sym_interface_declaration] = STATE(14),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(14),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(81),
    [sym_decimal_integer_literal] = ACTIONS(83),
    [sym_hex_integer_literal] = ACTIONS(83),
    [sym_octal_integer_literal] = ACTIONS(85),
    [sym_binary_integer_literal] = ACTIONS(85),
    [sym_decimal_floating_point_literal] = ACTIONS(85),
    [sym_hex_floating_point_literal] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_character_literal] = ACTIONS(85),
    [sym_string_literal] = ACTIONS(85),
    [sym_null_literal] = ACTIONS(83),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LT] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(91),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(97),
    [sym_super] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(3),
    [sym_block] = STATE(3),
    [sym_expression_statement] = STATE(3),
    [sym_labeled_statement] = STATE(3),
    [sym_assert_statement] = STATE(3),
    [sym_switch_statement] = STATE(3),
    [sym_switch_label] = STATE(3),
    [sym_do_statement] = STATE(3),
    [sym_break_statement] = STATE(3),
    [sym_continue_statement] = STATE(3),
    [sym_return_statement] = STATE(3),
    [sym_synchronized_statement] = STATE(3),
    [sym_throw_statement] = STATE(3),
    [sym_try_statement] = STATE(3),
    [sym_try_with_resources_statement] = STATE(3),
    [sym_if_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_enhanced_for_statement] = STATE(3),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(3),
    [sym_module_declaration] = STATE(3),
    [sym_package_declaration] = STATE(3),
    [sym_import_declaration] = STATE(3),
    [sym_enum_declaration] = STATE(3),
    [sym_class_declaration] = STATE(3),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(3),
    [sym_interface_declaration] = STATE(3),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(3),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_switch_block_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(101),
    [sym_decimal_integer_literal] = ACTIONS(104),
    [sym_hex_integer_literal] = ACTIONS(104),
    [sym_octal_integer_literal] = ACTIONS(107),
    [sym_binary_integer_literal] = ACTIONS(107),
    [sym_decimal_floating_point_literal] = ACTIONS(107),
    [sym_hex_floating_point_literal] = ACTIONS(104),
    [sym_true] = ACTIONS(104),
    [sym_false] = ACTIONS(104),
    [sym_character_literal] = ACTIONS(107),
    [sym_string_literal] = ACTIONS(107),
    [sym_null_literal] = ACTIONS(104),
    [anon_sym_LPAREN] = ACTIONS(110),
    [anon_sym_PLUS] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(116),
    [anon_sym_TILDE] = ACTIONS(116),
    [anon_sym_PLUS_PLUS] = ACTIONS(119),
    [anon_sym_DASH_DASH] = ACTIONS(119),
    [anon_sym_new] = ACTIONS(122),
    [anon_sym_class] = ACTIONS(125),
    [anon_sym_SEMI] = ACTIONS(128),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_RBRACE] = ACTIONS(134),
    [anon_sym_assert] = ACTIONS(136),
    [anon_sym_switch] = ACTIONS(139),
    [anon_sym_case] = ACTIONS(142),
    [anon_sym_default] = ACTIONS(145),
    [anon_sym_do] = ACTIONS(148),
    [anon_sym_while] = ACTIONS(151),
    [anon_sym_break] = ACTIONS(154),
    [anon_sym_continue] = ACTIONS(157),
    [anon_sym_return] = ACTIONS(160),
    [anon_sym_synchronized] = ACTIONS(163),
    [anon_sym_throw] = ACTIONS(166),
    [anon_sym_try] = ACTIONS(169),
    [anon_sym_if] = ACTIONS(172),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_AT] = ACTIONS(178),
    [anon_sym_open] = ACTIONS(181),
    [anon_sym_module] = ACTIONS(184),
    [anon_sym_static] = ACTIONS(187),
    [anon_sym_package] = ACTIONS(190),
    [anon_sym_import] = ACTIONS(193),
    [anon_sym_enum] = ACTIONS(196),
    [anon_sym_public] = ACTIONS(187),
    [anon_sym_protected] = ACTIONS(187),
    [anon_sym_private] = ACTIONS(187),
    [anon_sym_abstract] = ACTIONS(187),
    [anon_sym_final] = ACTIONS(187),
    [anon_sym_strictfp] = ACTIONS(187),
    [anon_sym_native] = ACTIONS(187),
    [anon_sym_transient] = ACTIONS(187),
    [anon_sym_volatile] = ACTIONS(187),
    [anon_sym_ATinterface] = ACTIONS(199),
    [anon_sym_interface] = ACTIONS(202),
    [anon_sym_byte] = ACTIONS(205),
    [anon_sym_short] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(205),
    [anon_sym_long] = ACTIONS(205),
    [anon_sym_char] = ACTIONS(205),
    [anon_sym_float] = ACTIONS(208),
    [anon_sym_double] = ACTIONS(208),
    [sym_boolean_type] = ACTIONS(211),
    [sym_void_type] = ACTIONS(214),
    [sym_this] = ACTIONS(104),
    [sym_super] = ACTIONS(217),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(5),
    [sym_block] = STATE(5),
    [sym_expression_statement] = STATE(5),
    [sym_labeled_statement] = STATE(5),
    [sym_assert_statement] = STATE(5),
    [sym_switch_statement] = STATE(5),
    [sym_switch_label] = STATE(5),
    [sym_do_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_synchronized_statement] = STATE(5),
    [sym_throw_statement] = STATE(5),
    [sym_try_statement] = STATE(5),
    [sym_try_with_resources_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_enhanced_for_statement] = STATE(5),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(5),
    [sym_module_declaration] = STATE(5),
    [sym_package_declaration] = STATE(5),
    [sym_import_declaration] = STATE(5),
    [sym_enum_declaration] = STATE(5),
    [sym_class_declaration] = STATE(5),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(5),
    [sym_interface_declaration] = STATE(5),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(5),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_switch_block_repeat1] = STATE(5),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(220),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(224),
    [anon_sym_default] = ACTIONS(226),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(3),
    [sym_block] = STATE(3),
    [sym_expression_statement] = STATE(3),
    [sym_labeled_statement] = STATE(3),
    [sym_assert_statement] = STATE(3),
    [sym_switch_statement] = STATE(3),
    [sym_switch_label] = STATE(3),
    [sym_do_statement] = STATE(3),
    [sym_break_statement] = STATE(3),
    [sym_continue_statement] = STATE(3),
    [sym_return_statement] = STATE(3),
    [sym_synchronized_statement] = STATE(3),
    [sym_throw_statement] = STATE(3),
    [sym_try_statement] = STATE(3),
    [sym_try_with_resources_statement] = STATE(3),
    [sym_if_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_enhanced_for_statement] = STATE(3),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(3),
    [sym_module_declaration] = STATE(3),
    [sym_package_declaration] = STATE(3),
    [sym_import_declaration] = STATE(3),
    [sym_enum_declaration] = STATE(3),
    [sym_class_declaration] = STATE(3),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(3),
    [sym_interface_declaration] = STATE(3),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(3),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_switch_block_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(230),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(224),
    [anon_sym_default] = ACTIONS(226),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(6),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [ts_builtin_sym_end] = ACTIONS(232),
    [sym_identifier] = ACTIONS(234),
    [sym_decimal_integer_literal] = ACTIONS(237),
    [sym_hex_integer_literal] = ACTIONS(237),
    [sym_octal_integer_literal] = ACTIONS(240),
    [sym_binary_integer_literal] = ACTIONS(240),
    [sym_decimal_floating_point_literal] = ACTIONS(240),
    [sym_hex_floating_point_literal] = ACTIONS(237),
    [sym_true] = ACTIONS(237),
    [sym_false] = ACTIONS(237),
    [sym_character_literal] = ACTIONS(240),
    [sym_string_literal] = ACTIONS(240),
    [sym_null_literal] = ACTIONS(237),
    [anon_sym_LPAREN] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(249),
    [anon_sym_TILDE] = ACTIONS(249),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_new] = ACTIONS(255),
    [anon_sym_class] = ACTIONS(258),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_RBRACE] = ACTIONS(232),
    [anon_sym_assert] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(270),
    [anon_sym_default] = ACTIONS(273),
    [anon_sym_do] = ACTIONS(276),
    [anon_sym_while] = ACTIONS(279),
    [anon_sym_break] = ACTIONS(282),
    [anon_sym_continue] = ACTIONS(285),
    [anon_sym_return] = ACTIONS(288),
    [anon_sym_synchronized] = ACTIONS(291),
    [anon_sym_throw] = ACTIONS(294),
    [anon_sym_try] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(300),
    [anon_sym_for] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(306),
    [anon_sym_open] = ACTIONS(309),
    [anon_sym_module] = ACTIONS(312),
    [anon_sym_static] = ACTIONS(273),
    [anon_sym_package] = ACTIONS(315),
    [anon_sym_import] = ACTIONS(318),
    [anon_sym_enum] = ACTIONS(321),
    [anon_sym_public] = ACTIONS(273),
    [anon_sym_protected] = ACTIONS(273),
    [anon_sym_private] = ACTIONS(273),
    [anon_sym_abstract] = ACTIONS(273),
    [anon_sym_final] = ACTIONS(273),
    [anon_sym_strictfp] = ACTIONS(273),
    [anon_sym_native] = ACTIONS(273),
    [anon_sym_transient] = ACTIONS(273),
    [anon_sym_volatile] = ACTIONS(273),
    [anon_sym_ATinterface] = ACTIONS(324),
    [anon_sym_interface] = ACTIONS(327),
    [anon_sym_byte] = ACTIONS(330),
    [anon_sym_short] = ACTIONS(330),
    [anon_sym_int] = ACTIONS(330),
    [anon_sym_long] = ACTIONS(330),
    [anon_sym_char] = ACTIONS(330),
    [anon_sym_float] = ACTIONS(333),
    [anon_sym_double] = ACTIONS(333),
    [sym_boolean_type] = ACTIONS(336),
    [sym_void_type] = ACTIONS(339),
    [sym_this] = ACTIONS(237),
    [sym_super] = ACTIONS(342),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(6),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(345),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(347),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(7),
    [sym_block] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_assert_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_synchronized_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_try_with_resources_statement] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_enhanced_for_statement] = STATE(7),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(7),
    [sym_module_declaration] = STATE(7),
    [sym_package_declaration] = STATE(7),
    [sym_import_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_class_declaration] = STATE(7),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(7),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(351),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(6),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(345),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(353),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(6),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [ts_builtin_sym_end] = ACTIONS(355),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(345),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(6),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(345),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(357),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(11),
    [sym_block] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_assert_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_synchronized_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_try_with_resources_statement] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_enhanced_for_statement] = STATE(11),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(11),
    [sym_module_declaration] = STATE(11),
    [sym_package_declaration] = STATE(11),
    [sym_import_declaration] = STATE(11),
    [sym_enum_declaration] = STATE(11),
    [sym_class_declaration] = STATE(11),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(11),
    [sym_interface_declaration] = STATE(11),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(11),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(361),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(9),
    [sym_block] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_assert_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_synchronized_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_try_with_resources_statement] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_enhanced_for_statement] = STATE(9),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(9),
    [sym_module_declaration] = STATE(9),
    [sym_package_declaration] = STATE(9),
    [sym_import_declaration] = STATE(9),
    [sym_enum_declaration] = STATE(9),
    [sym_class_declaration] = STATE(9),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(9),
    [sym_interface_declaration] = STATE(9),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(9),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(365),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(6),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(345),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(365),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(137),
    [sym_block] = STATE(137),
    [sym_expression_statement] = STATE(137),
    [sym_labeled_statement] = STATE(137),
    [sym_assert_statement] = STATE(137),
    [sym_switch_statement] = STATE(137),
    [sym_do_statement] = STATE(137),
    [sym_break_statement] = STATE(137),
    [sym_continue_statement] = STATE(137),
    [sym_return_statement] = STATE(137),
    [sym_synchronized_statement] = STATE(137),
    [sym_throw_statement] = STATE(137),
    [sym_try_statement] = STATE(137),
    [sym_try_with_resources_statement] = STATE(137),
    [sym_if_statement] = STATE(137),
    [sym_while_statement] = STATE(137),
    [sym_for_statement] = STATE(137),
    [sym_enhanced_for_statement] = STATE(137),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(137),
    [sym_module_declaration] = STATE(137),
    [sym_package_declaration] = STATE(137),
    [sym_import_declaration] = STATE(137),
    [sym_enum_declaration] = STATE(137),
    [sym_class_declaration] = STATE(137),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(137),
    [sym_interface_declaration] = STATE(137),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(137),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(367),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(154),
    [sym_block] = STATE(154),
    [sym_expression_statement] = STATE(154),
    [sym_labeled_statement] = STATE(154),
    [sym_assert_statement] = STATE(154),
    [sym_switch_statement] = STATE(154),
    [sym_do_statement] = STATE(154),
    [sym_break_statement] = STATE(154),
    [sym_continue_statement] = STATE(154),
    [sym_return_statement] = STATE(154),
    [sym_synchronized_statement] = STATE(154),
    [sym_throw_statement] = STATE(154),
    [sym_try_statement] = STATE(154),
    [sym_try_with_resources_statement] = STATE(154),
    [sym_if_statement] = STATE(154),
    [sym_while_statement] = STATE(154),
    [sym_for_statement] = STATE(154),
    [sym_enhanced_for_statement] = STATE(154),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(154),
    [sym_module_declaration] = STATE(154),
    [sym_package_declaration] = STATE(154),
    [sym_import_declaration] = STATE(154),
    [sym_enum_declaration] = STATE(154),
    [sym_class_declaration] = STATE(154),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(154),
    [sym_interface_declaration] = STATE(154),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(154),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(369),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(180),
    [sym_block] = STATE(180),
    [sym_expression_statement] = STATE(180),
    [sym_labeled_statement] = STATE(180),
    [sym_assert_statement] = STATE(180),
    [sym_switch_statement] = STATE(180),
    [sym_do_statement] = STATE(180),
    [sym_break_statement] = STATE(180),
    [sym_continue_statement] = STATE(180),
    [sym_return_statement] = STATE(180),
    [sym_synchronized_statement] = STATE(180),
    [sym_throw_statement] = STATE(180),
    [sym_try_statement] = STATE(180),
    [sym_try_with_resources_statement] = STATE(180),
    [sym_if_statement] = STATE(180),
    [sym_while_statement] = STATE(180),
    [sym_for_statement] = STATE(180),
    [sym_enhanced_for_statement] = STATE(180),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(180),
    [sym_module_declaration] = STATE(180),
    [sym_package_declaration] = STATE(180),
    [sym_import_declaration] = STATE(180),
    [sym_enum_declaration] = STATE(180),
    [sym_class_declaration] = STATE(180),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(180),
    [sym_interface_declaration] = STATE(180),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(180),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(371),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(139),
    [sym_block] = STATE(139),
    [sym_expression_statement] = STATE(139),
    [sym_labeled_statement] = STATE(139),
    [sym_assert_statement] = STATE(139),
    [sym_switch_statement] = STATE(139),
    [sym_do_statement] = STATE(139),
    [sym_break_statement] = STATE(139),
    [sym_continue_statement] = STATE(139),
    [sym_return_statement] = STATE(139),
    [sym_synchronized_statement] = STATE(139),
    [sym_throw_statement] = STATE(139),
    [sym_try_statement] = STATE(139),
    [sym_try_with_resources_statement] = STATE(139),
    [sym_if_statement] = STATE(139),
    [sym_while_statement] = STATE(139),
    [sym_for_statement] = STATE(139),
    [sym_enhanced_for_statement] = STATE(139),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(139),
    [sym_module_declaration] = STATE(139),
    [sym_package_declaration] = STATE(139),
    [sym_import_declaration] = STATE(139),
    [sym_enum_declaration] = STATE(139),
    [sym_class_declaration] = STATE(139),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(139),
    [sym_interface_declaration] = STATE(139),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(139),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(373),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(170),
    [sym_block] = STATE(170),
    [sym_expression_statement] = STATE(170),
    [sym_labeled_statement] = STATE(170),
    [sym_assert_statement] = STATE(170),
    [sym_switch_statement] = STATE(170),
    [sym_do_statement] = STATE(170),
    [sym_break_statement] = STATE(170),
    [sym_continue_statement] = STATE(170),
    [sym_return_statement] = STATE(170),
    [sym_synchronized_statement] = STATE(170),
    [sym_throw_statement] = STATE(170),
    [sym_try_statement] = STATE(170),
    [sym_try_with_resources_statement] = STATE(170),
    [sym_if_statement] = STATE(170),
    [sym_while_statement] = STATE(170),
    [sym_for_statement] = STATE(170),
    [sym_enhanced_for_statement] = STATE(170),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(170),
    [sym_module_declaration] = STATE(170),
    [sym_package_declaration] = STATE(170),
    [sym_import_declaration] = STATE(170),
    [sym_enum_declaration] = STATE(170),
    [sym_class_declaration] = STATE(170),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(170),
    [sym_interface_declaration] = STATE(170),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(170),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(171),
    [sym_block] = STATE(171),
    [sym_expression_statement] = STATE(171),
    [sym_labeled_statement] = STATE(171),
    [sym_assert_statement] = STATE(171),
    [sym_switch_statement] = STATE(171),
    [sym_do_statement] = STATE(171),
    [sym_break_statement] = STATE(171),
    [sym_continue_statement] = STATE(171),
    [sym_return_statement] = STATE(171),
    [sym_synchronized_statement] = STATE(171),
    [sym_throw_statement] = STATE(171),
    [sym_try_statement] = STATE(171),
    [sym_try_with_resources_statement] = STATE(171),
    [sym_if_statement] = STATE(171),
    [sym_while_statement] = STATE(171),
    [sym_for_statement] = STATE(171),
    [sym_enhanced_for_statement] = STATE(171),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(171),
    [sym_module_declaration] = STATE(171),
    [sym_package_declaration] = STATE(171),
    [sym_import_declaration] = STATE(171),
    [sym_enum_declaration] = STATE(171),
    [sym_class_declaration] = STATE(171),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(171),
    [sym_interface_declaration] = STATE(171),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(171),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(141),
    [sym_block] = STATE(141),
    [sym_expression_statement] = STATE(141),
    [sym_labeled_statement] = STATE(141),
    [sym_assert_statement] = STATE(141),
    [sym_switch_statement] = STATE(141),
    [sym_do_statement] = STATE(141),
    [sym_break_statement] = STATE(141),
    [sym_continue_statement] = STATE(141),
    [sym_return_statement] = STATE(141),
    [sym_synchronized_statement] = STATE(141),
    [sym_throw_statement] = STATE(141),
    [sym_try_statement] = STATE(141),
    [sym_try_with_resources_statement] = STATE(141),
    [sym_if_statement] = STATE(141),
    [sym_while_statement] = STATE(141),
    [sym_for_statement] = STATE(141),
    [sym_enhanced_for_statement] = STATE(141),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(141),
    [sym_module_declaration] = STATE(141),
    [sym_package_declaration] = STATE(141),
    [sym_import_declaration] = STATE(141),
    [sym_enum_declaration] = STATE(141),
    [sym_class_declaration] = STATE(141),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(141),
    [sym_interface_declaration] = STATE(141),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(141),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(110),
    [sym_block] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_labeled_statement] = STATE(110),
    [sym_assert_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_synchronized_statement] = STATE(110),
    [sym_throw_statement] = STATE(110),
    [sym_try_statement] = STATE(110),
    [sym_try_with_resources_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_enhanced_for_statement] = STATE(110),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(110),
    [sym_module_declaration] = STATE(110),
    [sym_package_declaration] = STATE(110),
    [sym_import_declaration] = STATE(110),
    [sym_enum_declaration] = STATE(110),
    [sym_class_declaration] = STATE(110),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(110),
    [sym_interface_declaration] = STATE(110),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(110),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(381),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(936),
    [sym_block] = STATE(936),
    [sym_expression_statement] = STATE(936),
    [sym_labeled_statement] = STATE(936),
    [sym_assert_statement] = STATE(936),
    [sym_switch_statement] = STATE(936),
    [sym_do_statement] = STATE(936),
    [sym_break_statement] = STATE(936),
    [sym_continue_statement] = STATE(936),
    [sym_return_statement] = STATE(936),
    [sym_synchronized_statement] = STATE(936),
    [sym_throw_statement] = STATE(936),
    [sym_try_statement] = STATE(936),
    [sym_try_with_resources_statement] = STATE(936),
    [sym_if_statement] = STATE(936),
    [sym_while_statement] = STATE(936),
    [sym_for_statement] = STATE(936),
    [sym_enhanced_for_statement] = STATE(936),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(936),
    [sym_module_declaration] = STATE(936),
    [sym_package_declaration] = STATE(936),
    [sym_import_declaration] = STATE(936),
    [sym_enum_declaration] = STATE(936),
    [sym_class_declaration] = STATE(936),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(936),
    [sym_interface_declaration] = STATE(936),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(936),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(383),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(115),
    [sym_block] = STATE(115),
    [sym_expression_statement] = STATE(115),
    [sym_labeled_statement] = STATE(115),
    [sym_assert_statement] = STATE(115),
    [sym_switch_statement] = STATE(115),
    [sym_do_statement] = STATE(115),
    [sym_break_statement] = STATE(115),
    [sym_continue_statement] = STATE(115),
    [sym_return_statement] = STATE(115),
    [sym_synchronized_statement] = STATE(115),
    [sym_throw_statement] = STATE(115),
    [sym_try_statement] = STATE(115),
    [sym_try_with_resources_statement] = STATE(115),
    [sym_if_statement] = STATE(115),
    [sym_while_statement] = STATE(115),
    [sym_for_statement] = STATE(115),
    [sym_enhanced_for_statement] = STATE(115),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(115),
    [sym_module_declaration] = STATE(115),
    [sym_package_declaration] = STATE(115),
    [sym_import_declaration] = STATE(115),
    [sym_enum_declaration] = STATE(115),
    [sym_class_declaration] = STATE(115),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(115),
    [sym_interface_declaration] = STATE(115),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(115),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(133),
    [sym_block] = STATE(133),
    [sym_expression_statement] = STATE(133),
    [sym_labeled_statement] = STATE(133),
    [sym_assert_statement] = STATE(133),
    [sym_switch_statement] = STATE(133),
    [sym_do_statement] = STATE(133),
    [sym_break_statement] = STATE(133),
    [sym_continue_statement] = STATE(133),
    [sym_return_statement] = STATE(133),
    [sym_synchronized_statement] = STATE(133),
    [sym_throw_statement] = STATE(133),
    [sym_try_statement] = STATE(133),
    [sym_try_with_resources_statement] = STATE(133),
    [sym_if_statement] = STATE(133),
    [sym_while_statement] = STATE(133),
    [sym_for_statement] = STATE(133),
    [sym_enhanced_for_statement] = STATE(133),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(133),
    [sym_module_declaration] = STATE(133),
    [sym_package_declaration] = STATE(133),
    [sym_import_declaration] = STATE(133),
    [sym_enum_declaration] = STATE(133),
    [sym_class_declaration] = STATE(133),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(133),
    [sym_interface_declaration] = STATE(133),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(133),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(387),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__statement] = STATE(164),
    [sym_block] = STATE(164),
    [sym_expression_statement] = STATE(164),
    [sym_labeled_statement] = STATE(164),
    [sym_assert_statement] = STATE(164),
    [sym_switch_statement] = STATE(164),
    [sym_do_statement] = STATE(164),
    [sym_break_statement] = STATE(164),
    [sym_continue_statement] = STATE(164),
    [sym_return_statement] = STATE(164),
    [sym_synchronized_statement] = STATE(164),
    [sym_throw_statement] = STATE(164),
    [sym_try_statement] = STATE(164),
    [sym_try_with_resources_statement] = STATE(164),
    [sym_if_statement] = STATE(164),
    [sym_while_statement] = STATE(164),
    [sym_for_statement] = STATE(164),
    [sym_enhanced_for_statement] = STATE(164),
    [sym__annotation] = STATE(352),
    [sym_marker_annotation] = STATE(352),
    [sym_annotation] = STATE(352),
    [sym__declaration] = STATE(164),
    [sym_module_declaration] = STATE(164),
    [sym_package_declaration] = STATE(164),
    [sym_import_declaration] = STATE(164),
    [sym_enum_declaration] = STATE(164),
    [sym_class_declaration] = STATE(164),
    [sym_modifiers] = STATE(458),
    [sym_scoped_identifier] = STATE(224),
    [sym_annotation_type_declaration] = STATE(164),
    [sym_interface_declaration] = STATE(164),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(489),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(489),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration_statement] = STATE(164),
    [sym_local_variable_declaration] = STATE(941),
    [aux_sym_dimensions_expr_repeat1] = STATE(422),
    [aux_sym_modifiers_repeat1] = STATE(285),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [ts_builtin_sym_end] = ACTIONS(391),
    [sym_identifier] = ACTIONS(393),
    [sym_decimal_integer_literal] = ACTIONS(393),
    [sym_hex_integer_literal] = ACTIONS(393),
    [sym_octal_integer_literal] = ACTIONS(391),
    [sym_binary_integer_literal] = ACTIONS(391),
    [sym_decimal_floating_point_literal] = ACTIONS(391),
    [sym_hex_floating_point_literal] = ACTIONS(393),
    [sym_true] = ACTIONS(393),
    [sym_false] = ACTIONS(393),
    [sym_character_literal] = ACTIONS(391),
    [sym_string_literal] = ACTIONS(391),
    [sym_null_literal] = ACTIONS(393),
    [anon_sym_LPAREN] = ACTIONS(391),
    [anon_sym_AMP] = ACTIONS(393),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_GT] = ACTIONS(393),
    [anon_sym_LT] = ACTIONS(393),
    [anon_sym_EQ_EQ] = ACTIONS(391),
    [anon_sym_GT_EQ] = ACTIONS(391),
    [anon_sym_LT_EQ] = ACTIONS(391),
    [anon_sym_BANG_EQ] = ACTIONS(391),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_PIPE_PIPE] = ACTIONS(391),
    [anon_sym_PLUS] = ACTIONS(393),
    [anon_sym_DASH] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(391),
    [anon_sym_SLASH] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(393),
    [anon_sym_CARET] = ACTIONS(391),
    [anon_sym_PERCENT] = ACTIONS(391),
    [anon_sym_LT_LT] = ACTIONS(391),
    [anon_sym_GT_GT] = ACTIONS(393),
    [anon_sym_GT_GT_GT] = ACTIONS(391),
    [anon_sym_instanceof] = ACTIONS(393),
    [anon_sym_COMMA] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_COLON] = ACTIONS(393),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(391),
    [anon_sym_PLUS_PLUS] = ACTIONS(391),
    [anon_sym_DASH_DASH] = ACTIONS(391),
    [anon_sym_new] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(391),
    [anon_sym_RBRACK] = ACTIONS(391),
    [anon_sym_DOT] = ACTIONS(393),
    [anon_sym_class] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(391),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_RBRACE] = ACTIONS(391),
    [anon_sym_assert] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(393),
    [anon_sym_case] = ACTIONS(393),
    [anon_sym_default] = ACTIONS(393),
    [anon_sym_do] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(393),
    [anon_sym_break] = ACTIONS(393),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_return] = ACTIONS(393),
    [anon_sym_synchronized] = ACTIONS(393),
    [anon_sym_throw] = ACTIONS(393),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_else] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(393),
    [anon_sym_AT] = ACTIONS(393),
    [anon_sym_open] = ACTIONS(393),
    [anon_sym_module] = ACTIONS(393),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_package] = ACTIONS(393),
    [anon_sym_import] = ACTIONS(393),
    [anon_sym_enum] = ACTIONS(393),
    [anon_sym_public] = ACTIONS(393),
    [anon_sym_protected] = ACTIONS(393),
    [anon_sym_private] = ACTIONS(393),
    [anon_sym_abstract] = ACTIONS(393),
    [anon_sym_final] = ACTIONS(393),
    [anon_sym_strictfp] = ACTIONS(393),
    [anon_sym_native] = ACTIONS(393),
    [anon_sym_transient] = ACTIONS(393),
    [anon_sym_volatile] = ACTIONS(393),
    [anon_sym_ATinterface] = ACTIONS(391),
    [anon_sym_interface] = ACTIONS(393),
    [anon_sym_byte] = ACTIONS(393),
    [anon_sym_short] = ACTIONS(393),
    [anon_sym_int] = ACTIONS(393),
    [anon_sym_long] = ACTIONS(393),
    [anon_sym_char] = ACTIONS(393),
    [anon_sym_float] = ACTIONS(393),
    [anon_sym_double] = ACTIONS(393),
    [sym_boolean_type] = ACTIONS(393),
    [sym_void_type] = ACTIONS(393),
    [sym_this] = ACTIONS(393),
    [sym_super] = ACTIONS(393),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [ts_builtin_sym_end] = ACTIONS(395),
    [sym_identifier] = ACTIONS(397),
    [sym_decimal_integer_literal] = ACTIONS(397),
    [sym_hex_integer_literal] = ACTIONS(397),
    [sym_octal_integer_literal] = ACTIONS(395),
    [sym_binary_integer_literal] = ACTIONS(395),
    [sym_decimal_floating_point_literal] = ACTIONS(395),
    [sym_hex_floating_point_literal] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_character_literal] = ACTIONS(395),
    [sym_string_literal] = ACTIONS(395),
    [sym_null_literal] = ACTIONS(397),
    [anon_sym_LPAREN] = ACTIONS(395),
    [anon_sym_AMP] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(395),
    [anon_sym_GT] = ACTIONS(397),
    [anon_sym_LT] = ACTIONS(397),
    [anon_sym_EQ_EQ] = ACTIONS(395),
    [anon_sym_GT_EQ] = ACTIONS(395),
    [anon_sym_LT_EQ] = ACTIONS(395),
    [anon_sym_BANG_EQ] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(395),
    [anon_sym_PIPE_PIPE] = ACTIONS(395),
    [anon_sym_PLUS] = ACTIONS(397),
    [anon_sym_DASH] = ACTIONS(397),
    [anon_sym_STAR] = ACTIONS(395),
    [anon_sym_SLASH] = ACTIONS(397),
    [anon_sym_PIPE] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(395),
    [anon_sym_PERCENT] = ACTIONS(395),
    [anon_sym_LT_LT] = ACTIONS(395),
    [anon_sym_GT_GT] = ACTIONS(397),
    [anon_sym_GT_GT_GT] = ACTIONS(395),
    [anon_sym_instanceof] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(395),
    [anon_sym_QMARK] = ACTIONS(395),
    [anon_sym_COLON] = ACTIONS(397),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(395),
    [anon_sym_DASH_DASH] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_LBRACK] = ACTIONS(395),
    [anon_sym_RBRACK] = ACTIONS(395),
    [anon_sym_DOT] = ACTIONS(397),
    [anon_sym_class] = ACTIONS(397),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_RBRACE] = ACTIONS(395),
    [anon_sym_assert] = ACTIONS(397),
    [anon_sym_switch] = ACTIONS(397),
    [anon_sym_case] = ACTIONS(397),
    [anon_sym_default] = ACTIONS(397),
    [anon_sym_do] = ACTIONS(397),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_break] = ACTIONS(397),
    [anon_sym_continue] = ACTIONS(397),
    [anon_sym_return] = ACTIONS(397),
    [anon_sym_synchronized] = ACTIONS(397),
    [anon_sym_throw] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(397),
    [anon_sym_if] = ACTIONS(397),
    [anon_sym_else] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(397),
    [anon_sym_open] = ACTIONS(397),
    [anon_sym_module] = ACTIONS(397),
    [anon_sym_static] = ACTIONS(397),
    [anon_sym_package] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(397),
    [anon_sym_enum] = ACTIONS(397),
    [anon_sym_public] = ACTIONS(397),
    [anon_sym_protected] = ACTIONS(397),
    [anon_sym_private] = ACTIONS(397),
    [anon_sym_abstract] = ACTIONS(397),
    [anon_sym_final] = ACTIONS(397),
    [anon_sym_strictfp] = ACTIONS(397),
    [anon_sym_native] = ACTIONS(397),
    [anon_sym_transient] = ACTIONS(397),
    [anon_sym_volatile] = ACTIONS(397),
    [anon_sym_ATinterface] = ACTIONS(395),
    [anon_sym_interface] = ACTIONS(397),
    [anon_sym_byte] = ACTIONS(397),
    [anon_sym_short] = ACTIONS(397),
    [anon_sym_int] = ACTIONS(397),
    [anon_sym_long] = ACTIONS(397),
    [anon_sym_char] = ACTIONS(397),
    [anon_sym_float] = ACTIONS(397),
    [anon_sym_double] = ACTIONS(397),
    [sym_boolean_type] = ACTIONS(397),
    [sym_void_type] = ACTIONS(397),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_identifier] = ACTIONS(399),
    [sym_decimal_integer_literal] = ACTIONS(399),
    [sym_hex_integer_literal] = ACTIONS(399),
    [sym_octal_integer_literal] = ACTIONS(401),
    [sym_binary_integer_literal] = ACTIONS(401),
    [sym_decimal_floating_point_literal] = ACTIONS(401),
    [sym_hex_floating_point_literal] = ACTIONS(399),
    [sym_true] = ACTIONS(399),
    [sym_false] = ACTIONS(399),
    [sym_character_literal] = ACTIONS(401),
    [sym_string_literal] = ACTIONS(401),
    [sym_null_literal] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(401),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_RPAREN] = ACTIONS(401),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_EQ_EQ] = ACTIONS(401),
    [anon_sym_GT_EQ] = ACTIONS(401),
    [anon_sym_LT_EQ] = ACTIONS(401),
    [anon_sym_BANG_EQ] = ACTIONS(401),
    [anon_sym_AMP_AMP] = ACTIONS(401),
    [anon_sym_PIPE_PIPE] = ACTIONS(401),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_STAR] = ACTIONS(401),
    [anon_sym_SLASH] = ACTIONS(399),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_CARET] = ACTIONS(401),
    [anon_sym_PERCENT] = ACTIONS(401),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(399),
    [anon_sym_GT_GT_GT] = ACTIONS(401),
    [anon_sym_instanceof] = ACTIONS(399),
    [anon_sym_COMMA] = ACTIONS(401),
    [anon_sym_QMARK] = ACTIONS(401),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_PLUS_PLUS] = ACTIONS(401),
    [anon_sym_DASH_DASH] = ACTIONS(401),
    [anon_sym_new] = ACTIONS(399),
    [anon_sym_LBRACK] = ACTIONS(401),
    [anon_sym_RBRACK] = ACTIONS(401),
    [anon_sym_DOT] = ACTIONS(399),
    [anon_sym_class] = ACTIONS(399),
    [anon_sym_COLON_COLON] = ACTIONS(401),
    [anon_sym_SEMI] = ACTIONS(401),
    [anon_sym_LBRACE] = ACTIONS(401),
    [anon_sym_RBRACE] = ACTIONS(401),
    [anon_sym_assert] = ACTIONS(399),
    [anon_sym_switch] = ACTIONS(399),
    [anon_sym_default] = ACTIONS(399),
    [anon_sym_do] = ACTIONS(399),
    [anon_sym_while] = ACTIONS(399),
    [anon_sym_break] = ACTIONS(399),
    [anon_sym_continue] = ACTIONS(399),
    [anon_sym_return] = ACTIONS(399),
    [anon_sym_synchronized] = ACTIONS(399),
    [anon_sym_throw] = ACTIONS(399),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_if] = ACTIONS(399),
    [anon_sym_for] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_open] = ACTIONS(399),
    [anon_sym_module] = ACTIONS(399),
    [anon_sym_static] = ACTIONS(399),
    [anon_sym_package] = ACTIONS(399),
    [anon_sym_import] = ACTIONS(399),
    [anon_sym_enum] = ACTIONS(399),
    [anon_sym_public] = ACTIONS(399),
    [anon_sym_protected] = ACTIONS(399),
    [anon_sym_private] = ACTIONS(399),
    [anon_sym_abstract] = ACTIONS(399),
    [anon_sym_final] = ACTIONS(399),
    [anon_sym_strictfp] = ACTIONS(399),
    [anon_sym_native] = ACTIONS(399),
    [anon_sym_transient] = ACTIONS(399),
    [anon_sym_volatile] = ACTIONS(399),
    [anon_sym_ATinterface] = ACTIONS(401),
    [anon_sym_interface] = ACTIONS(399),
    [anon_sym_byte] = ACTIONS(399),
    [anon_sym_short] = ACTIONS(399),
    [anon_sym_int] = ACTIONS(399),
    [anon_sym_long] = ACTIONS(399),
    [anon_sym_char] = ACTIONS(399),
    [anon_sym_float] = ACTIONS(399),
    [anon_sym_double] = ACTIONS(399),
    [sym_boolean_type] = ACTIONS(399),
    [sym_void_type] = ACTIONS(399),
    [sym_this] = ACTIONS(399),
    [sym_super] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [ts_builtin_sym_end] = ACTIONS(403),
    [sym_identifier] = ACTIONS(405),
    [sym_decimal_integer_literal] = ACTIONS(405),
    [sym_hex_integer_literal] = ACTIONS(405),
    [sym_octal_integer_literal] = ACTIONS(403),
    [sym_binary_integer_literal] = ACTIONS(403),
    [sym_decimal_floating_point_literal] = ACTIONS(403),
    [sym_hex_floating_point_literal] = ACTIONS(405),
    [sym_true] = ACTIONS(405),
    [sym_false] = ACTIONS(405),
    [sym_character_literal] = ACTIONS(403),
    [sym_string_literal] = ACTIONS(403),
    [sym_null_literal] = ACTIONS(405),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(405),
    [anon_sym_RPAREN] = ACTIONS(403),
    [anon_sym_GT] = ACTIONS(405),
    [anon_sym_LT] = ACTIONS(405),
    [anon_sym_EQ_EQ] = ACTIONS(403),
    [anon_sym_GT_EQ] = ACTIONS(403),
    [anon_sym_LT_EQ] = ACTIONS(403),
    [anon_sym_BANG_EQ] = ACTIONS(403),
    [anon_sym_AMP_AMP] = ACTIONS(403),
    [anon_sym_PIPE_PIPE] = ACTIONS(403),
    [anon_sym_PLUS] = ACTIONS(405),
    [anon_sym_DASH] = ACTIONS(405),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_SLASH] = ACTIONS(405),
    [anon_sym_PIPE] = ACTIONS(405),
    [anon_sym_CARET] = ACTIONS(403),
    [anon_sym_PERCENT] = ACTIONS(403),
    [anon_sym_LT_LT] = ACTIONS(403),
    [anon_sym_GT_GT] = ACTIONS(405),
    [anon_sym_GT_GT_GT] = ACTIONS(403),
    [anon_sym_instanceof] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(403),
    [anon_sym_QMARK] = ACTIONS(403),
    [anon_sym_COLON] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_new] = ACTIONS(405),
    [anon_sym_RBRACK] = ACTIONS(403),
    [anon_sym_class] = ACTIONS(405),
    [anon_sym_SEMI] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(403),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_assert] = ACTIONS(405),
    [anon_sym_switch] = ACTIONS(405),
    [anon_sym_case] = ACTIONS(405),
    [anon_sym_default] = ACTIONS(405),
    [anon_sym_do] = ACTIONS(405),
    [anon_sym_while] = ACTIONS(405),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(405),
    [anon_sym_return] = ACTIONS(405),
    [anon_sym_synchronized] = ACTIONS(405),
    [anon_sym_throw] = ACTIONS(405),
    [anon_sym_try] = ACTIONS(405),
    [anon_sym_if] = ACTIONS(405),
    [anon_sym_else] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(405),
    [anon_sym_open] = ACTIONS(405),
    [anon_sym_module] = ACTIONS(405),
    [anon_sym_static] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(405),
    [anon_sym_import] = ACTIONS(405),
    [anon_sym_enum] = ACTIONS(405),
    [anon_sym_public] = ACTIONS(405),
    [anon_sym_protected] = ACTIONS(405),
    [anon_sym_private] = ACTIONS(405),
    [anon_sym_abstract] = ACTIONS(405),
    [anon_sym_final] = ACTIONS(405),
    [anon_sym_strictfp] = ACTIONS(405),
    [anon_sym_native] = ACTIONS(405),
    [anon_sym_transient] = ACTIONS(405),
    [anon_sym_volatile] = ACTIONS(405),
    [anon_sym_ATinterface] = ACTIONS(403),
    [anon_sym_interface] = ACTIONS(405),
    [anon_sym_byte] = ACTIONS(405),
    [anon_sym_short] = ACTIONS(405),
    [anon_sym_int] = ACTIONS(405),
    [anon_sym_long] = ACTIONS(405),
    [anon_sym_char] = ACTIONS(405),
    [anon_sym_float] = ACTIONS(405),
    [anon_sym_double] = ACTIONS(405),
    [sym_boolean_type] = ACTIONS(405),
    [sym_void_type] = ACTIONS(405),
    [sym_this] = ACTIONS(405),
    [sym_super] = ACTIONS(405),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [ts_builtin_sym_end] = ACTIONS(407),
    [sym_identifier] = ACTIONS(409),
    [sym_decimal_integer_literal] = ACTIONS(409),
    [sym_hex_integer_literal] = ACTIONS(409),
    [sym_octal_integer_literal] = ACTIONS(407),
    [sym_binary_integer_literal] = ACTIONS(407),
    [sym_decimal_floating_point_literal] = ACTIONS(407),
    [sym_hex_floating_point_literal] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_character_literal] = ACTIONS(407),
    [sym_string_literal] = ACTIONS(407),
    [sym_null_literal] = ACTIONS(409),
    [anon_sym_LPAREN] = ACTIONS(407),
    [anon_sym_AMP] = ACTIONS(409),
    [anon_sym_RPAREN] = ACTIONS(407),
    [anon_sym_GT] = ACTIONS(409),
    [anon_sym_LT] = ACTIONS(409),
    [anon_sym_EQ_EQ] = ACTIONS(407),
    [anon_sym_GT_EQ] = ACTIONS(407),
    [anon_sym_LT_EQ] = ACTIONS(407),
    [anon_sym_BANG_EQ] = ACTIONS(407),
    [anon_sym_AMP_AMP] = ACTIONS(407),
    [anon_sym_PIPE_PIPE] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_STAR] = ACTIONS(407),
    [anon_sym_SLASH] = ACTIONS(409),
    [anon_sym_PIPE] = ACTIONS(409),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_PERCENT] = ACTIONS(407),
    [anon_sym_LT_LT] = ACTIONS(407),
    [anon_sym_GT_GT] = ACTIONS(409),
    [anon_sym_GT_GT_GT] = ACTIONS(407),
    [anon_sym_instanceof] = ACTIONS(409),
    [anon_sym_COMMA] = ACTIONS(407),
    [anon_sym_QMARK] = ACTIONS(407),
    [anon_sym_COLON] = ACTIONS(407),
    [anon_sym_BANG] = ACTIONS(409),
    [anon_sym_TILDE] = ACTIONS(407),
    [anon_sym_PLUS_PLUS] = ACTIONS(407),
    [anon_sym_DASH_DASH] = ACTIONS(407),
    [anon_sym_new] = ACTIONS(409),
    [anon_sym_RBRACK] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_SEMI] = ACTIONS(407),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_RBRACE] = ACTIONS(407),
    [anon_sym_assert] = ACTIONS(409),
    [anon_sym_switch] = ACTIONS(409),
    [anon_sym_case] = ACTIONS(409),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_do] = ACTIONS(409),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_break] = ACTIONS(409),
    [anon_sym_continue] = ACTIONS(409),
    [anon_sym_return] = ACTIONS(409),
    [anon_sym_synchronized] = ACTIONS(409),
    [anon_sym_throw] = ACTIONS(409),
    [anon_sym_try] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_else] = ACTIONS(409),
    [anon_sym_for] = ACTIONS(409),
    [anon_sym_AT] = ACTIONS(409),
    [anon_sym_open] = ACTIONS(409),
    [anon_sym_module] = ACTIONS(409),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_package] = ACTIONS(409),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_enum] = ACTIONS(409),
    [anon_sym_public] = ACTIONS(409),
    [anon_sym_protected] = ACTIONS(409),
    [anon_sym_private] = ACTIONS(409),
    [anon_sym_abstract] = ACTIONS(409),
    [anon_sym_final] = ACTIONS(409),
    [anon_sym_strictfp] = ACTIONS(409),
    [anon_sym_native] = ACTIONS(409),
    [anon_sym_transient] = ACTIONS(409),
    [anon_sym_volatile] = ACTIONS(409),
    [anon_sym_ATinterface] = ACTIONS(407),
    [anon_sym_interface] = ACTIONS(409),
    [anon_sym_byte] = ACTIONS(409),
    [anon_sym_short] = ACTIONS(409),
    [anon_sym_int] = ACTIONS(409),
    [anon_sym_long] = ACTIONS(409),
    [anon_sym_char] = ACTIONS(409),
    [anon_sym_float] = ACTIONS(409),
    [anon_sym_double] = ACTIONS(409),
    [sym_boolean_type] = ACTIONS(409),
    [sym_void_type] = ACTIONS(409),
    [sym_this] = ACTIONS(409),
    [sym_super] = ACTIONS(409),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(429),
    [sym_cast_expression] = STATE(429),
    [sym_assignment_expression] = STATE(429),
    [sym_binary_expression] = STATE(429),
    [sym_instanceof_expression] = STATE(429),
    [sym_lambda_expression] = STATE(429),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(429),
    [sym_unary_expression] = STATE(429),
    [sym_update_expression] = STATE(429),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(438),
    [sym_marker_annotation] = STATE(438),
    [sym_annotation] = STATE(438),
    [sym_modifiers] = STATE(485),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(645),
    [sym__unannotated_type] = STATE(474),
    [sym_annotated_type] = STATE(645),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(474),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_formal_parameter] = STATE(251),
    [sym_receiver_parameter] = STATE(245),
    [sym_spread_parameter] = STATE(939),
    [aux_sym_dimensions_expr_repeat1] = STATE(453),
    [aux_sym_modifiers_repeat1] = STATE(390),
    [sym_identifier] = ACTIONS(411),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(415),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_default] = ACTIONS(417),
    [anon_sym_synchronized] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_public] = ACTIONS(417),
    [anon_sym_protected] = ACTIONS(417),
    [anon_sym_private] = ACTIONS(417),
    [anon_sym_abstract] = ACTIONS(417),
    [anon_sym_final] = ACTIONS(417),
    [anon_sym_strictfp] = ACTIONS(417),
    [anon_sym_native] = ACTIONS(417),
    [anon_sym_transient] = ACTIONS(417),
    [anon_sym_volatile] = ACTIONS(417),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(393),
    [sym_cast_expression] = STATE(393),
    [sym_assignment_expression] = STATE(393),
    [sym_binary_expression] = STATE(393),
    [sym_instanceof_expression] = STATE(393),
    [sym_lambda_expression] = STATE(393),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(393),
    [sym_unary_expression] = STATE(393),
    [sym_update_expression] = STATE(393),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym_for_init] = STATE(884),
    [sym__annotation] = STATE(438),
    [sym_marker_annotation] = STATE(438),
    [sym_annotation] = STATE(438),
    [sym_modifiers] = STATE(486),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(493),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(493),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [sym_local_variable_declaration] = STATE(880),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(390),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(425),
    [anon_sym_default] = ACTIONS(417),
    [anon_sym_synchronized] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_public] = ACTIONS(417),
    [anon_sym_protected] = ACTIONS(417),
    [anon_sym_private] = ACTIONS(417),
    [anon_sym_abstract] = ACTIONS(417),
    [anon_sym_final] = ACTIONS(417),
    [anon_sym_strictfp] = ACTIONS(417),
    [anon_sym_native] = ACTIONS(417),
    [anon_sym_transient] = ACTIONS(417),
    [anon_sym_volatile] = ACTIONS(417),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_catch_clause] = STATE(35),
    [sym_finally_clause] = STATE(183),
    [aux_sym_try_statement_repeat1] = STATE(35),
    [ts_builtin_sym_end] = ACTIONS(427),
    [sym_identifier] = ACTIONS(429),
    [sym_decimal_integer_literal] = ACTIONS(429),
    [sym_hex_integer_literal] = ACTIONS(429),
    [sym_octal_integer_literal] = ACTIONS(427),
    [sym_binary_integer_literal] = ACTIONS(427),
    [sym_decimal_floating_point_literal] = ACTIONS(427),
    [sym_hex_floating_point_literal] = ACTIONS(429),
    [sym_true] = ACTIONS(429),
    [sym_false] = ACTIONS(429),
    [sym_character_literal] = ACTIONS(427),
    [sym_string_literal] = ACTIONS(427),
    [sym_null_literal] = ACTIONS(429),
    [anon_sym_LPAREN] = ACTIONS(427),
    [anon_sym_PLUS] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(427),
    [anon_sym_PLUS_PLUS] = ACTIONS(427),
    [anon_sym_DASH_DASH] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(429),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_LBRACE] = ACTIONS(427),
    [anon_sym_RBRACE] = ACTIONS(427),
    [anon_sym_assert] = ACTIONS(429),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_case] = ACTIONS(429),
    [anon_sym_default] = ACTIONS(429),
    [anon_sym_do] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(429),
    [anon_sym_break] = ACTIONS(429),
    [anon_sym_continue] = ACTIONS(429),
    [anon_sym_return] = ACTIONS(429),
    [anon_sym_synchronized] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(429),
    [anon_sym_try] = ACTIONS(429),
    [anon_sym_catch] = ACTIONS(431),
    [anon_sym_finally] = ACTIONS(433),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_else] = ACTIONS(429),
    [anon_sym_for] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(429),
    [anon_sym_open] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(429),
    [anon_sym_static] = ACTIONS(429),
    [anon_sym_package] = ACTIONS(429),
    [anon_sym_import] = ACTIONS(429),
    [anon_sym_enum] = ACTIONS(429),
    [anon_sym_public] = ACTIONS(429),
    [anon_sym_protected] = ACTIONS(429),
    [anon_sym_private] = ACTIONS(429),
    [anon_sym_abstract] = ACTIONS(429),
    [anon_sym_final] = ACTIONS(429),
    [anon_sym_strictfp] = ACTIONS(429),
    [anon_sym_native] = ACTIONS(429),
    [anon_sym_transient] = ACTIONS(429),
    [anon_sym_volatile] = ACTIONS(429),
    [anon_sym_ATinterface] = ACTIONS(427),
    [anon_sym_interface] = ACTIONS(429),
    [anon_sym_byte] = ACTIONS(429),
    [anon_sym_short] = ACTIONS(429),
    [anon_sym_int] = ACTIONS(429),
    [anon_sym_long] = ACTIONS(429),
    [anon_sym_char] = ACTIONS(429),
    [anon_sym_float] = ACTIONS(429),
    [anon_sym_double] = ACTIONS(429),
    [sym_boolean_type] = ACTIONS(429),
    [sym_void_type] = ACTIONS(429),
    [sym_this] = ACTIONS(429),
    [sym_super] = ACTIONS(429),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_catch_clause] = STATE(40),
    [sym_finally_clause] = STATE(166),
    [aux_sym_try_statement_repeat1] = STATE(40),
    [ts_builtin_sym_end] = ACTIONS(435),
    [sym_identifier] = ACTIONS(437),
    [sym_decimal_integer_literal] = ACTIONS(437),
    [sym_hex_integer_literal] = ACTIONS(437),
    [sym_octal_integer_literal] = ACTIONS(435),
    [sym_binary_integer_literal] = ACTIONS(435),
    [sym_decimal_floating_point_literal] = ACTIONS(435),
    [sym_hex_floating_point_literal] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_character_literal] = ACTIONS(435),
    [sym_string_literal] = ACTIONS(435),
    [sym_null_literal] = ACTIONS(437),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_PLUS] = ACTIONS(437),
    [anon_sym_DASH] = ACTIONS(437),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(435),
    [anon_sym_DASH_DASH] = ACTIONS(435),
    [anon_sym_new] = ACTIONS(437),
    [anon_sym_class] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_assert] = ACTIONS(437),
    [anon_sym_switch] = ACTIONS(437),
    [anon_sym_case] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(437),
    [anon_sym_do] = ACTIONS(437),
    [anon_sym_while] = ACTIONS(437),
    [anon_sym_break] = ACTIONS(437),
    [anon_sym_continue] = ACTIONS(437),
    [anon_sym_return] = ACTIONS(437),
    [anon_sym_synchronized] = ACTIONS(437),
    [anon_sym_throw] = ACTIONS(437),
    [anon_sym_try] = ACTIONS(437),
    [anon_sym_catch] = ACTIONS(431),
    [anon_sym_finally] = ACTIONS(433),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_else] = ACTIONS(437),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_open] = ACTIONS(437),
    [anon_sym_module] = ACTIONS(437),
    [anon_sym_static] = ACTIONS(437),
    [anon_sym_package] = ACTIONS(437),
    [anon_sym_import] = ACTIONS(437),
    [anon_sym_enum] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(437),
    [anon_sym_protected] = ACTIONS(437),
    [anon_sym_private] = ACTIONS(437),
    [anon_sym_abstract] = ACTIONS(437),
    [anon_sym_final] = ACTIONS(437),
    [anon_sym_strictfp] = ACTIONS(437),
    [anon_sym_native] = ACTIONS(437),
    [anon_sym_transient] = ACTIONS(437),
    [anon_sym_volatile] = ACTIONS(437),
    [anon_sym_ATinterface] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(437),
    [anon_sym_byte] = ACTIONS(437),
    [anon_sym_short] = ACTIONS(437),
    [anon_sym_int] = ACTIONS(437),
    [anon_sym_long] = ACTIONS(437),
    [anon_sym_char] = ACTIONS(437),
    [anon_sym_float] = ACTIONS(437),
    [anon_sym_double] = ACTIONS(437),
    [sym_boolean_type] = ACTIONS(437),
    [sym_void_type] = ACTIONS(437),
    [sym_this] = ACTIONS(437),
    [sym_super] = ACTIONS(437),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_catch_clause] = STATE(40),
    [sym_finally_clause] = STATE(186),
    [aux_sym_try_statement_repeat1] = STATE(40),
    [ts_builtin_sym_end] = ACTIONS(439),
    [sym_identifier] = ACTIONS(441),
    [sym_decimal_integer_literal] = ACTIONS(441),
    [sym_hex_integer_literal] = ACTIONS(441),
    [sym_octal_integer_literal] = ACTIONS(439),
    [sym_binary_integer_literal] = ACTIONS(439),
    [sym_decimal_floating_point_literal] = ACTIONS(439),
    [sym_hex_floating_point_literal] = ACTIONS(441),
    [sym_true] = ACTIONS(441),
    [sym_false] = ACTIONS(441),
    [sym_character_literal] = ACTIONS(439),
    [sym_string_literal] = ACTIONS(439),
    [sym_null_literal] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(439),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_new] = ACTIONS(441),
    [anon_sym_class] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_RBRACE] = ACTIONS(439),
    [anon_sym_assert] = ACTIONS(441),
    [anon_sym_switch] = ACTIONS(441),
    [anon_sym_case] = ACTIONS(441),
    [anon_sym_default] = ACTIONS(441),
    [anon_sym_do] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(441),
    [anon_sym_return] = ACTIONS(441),
    [anon_sym_synchronized] = ACTIONS(441),
    [anon_sym_throw] = ACTIONS(441),
    [anon_sym_try] = ACTIONS(441),
    [anon_sym_catch] = ACTIONS(431),
    [anon_sym_finally] = ACTIONS(433),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_else] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(441),
    [anon_sym_module] = ACTIONS(441),
    [anon_sym_static] = ACTIONS(441),
    [anon_sym_package] = ACTIONS(441),
    [anon_sym_import] = ACTIONS(441),
    [anon_sym_enum] = ACTIONS(441),
    [anon_sym_public] = ACTIONS(441),
    [anon_sym_protected] = ACTIONS(441),
    [anon_sym_private] = ACTIONS(441),
    [anon_sym_abstract] = ACTIONS(441),
    [anon_sym_final] = ACTIONS(441),
    [anon_sym_strictfp] = ACTIONS(441),
    [anon_sym_native] = ACTIONS(441),
    [anon_sym_transient] = ACTIONS(441),
    [anon_sym_volatile] = ACTIONS(441),
    [anon_sym_ATinterface] = ACTIONS(439),
    [anon_sym_interface] = ACTIONS(441),
    [anon_sym_byte] = ACTIONS(441),
    [anon_sym_short] = ACTIONS(441),
    [anon_sym_int] = ACTIONS(441),
    [anon_sym_long] = ACTIONS(441),
    [anon_sym_char] = ACTIONS(441),
    [anon_sym_float] = ACTIONS(441),
    [anon_sym_double] = ACTIONS(441),
    [sym_boolean_type] = ACTIONS(441),
    [sym_void_type] = ACTIONS(441),
    [sym_this] = ACTIONS(441),
    [sym_super] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym_element_value_pair] = STATE(774),
    [sym__element_value] = STATE(958),
    [sym_element_value_array_initializer] = STATE(958),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(443),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym__element_value] = STATE(735),
    [sym_element_value_array_initializer] = STATE(735),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(449),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_RBRACE] = ACTIONS(451),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym_element_value_pair] = STATE(768),
    [sym__element_value] = STATE(968),
    [sym_element_value_array_initializer] = STATE(968),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(443),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_catch_clause] = STATE(40),
    [aux_sym_try_statement_repeat1] = STATE(40),
    [ts_builtin_sym_end] = ACTIONS(455),
    [sym_identifier] = ACTIONS(457),
    [sym_decimal_integer_literal] = ACTIONS(457),
    [sym_hex_integer_literal] = ACTIONS(457),
    [sym_octal_integer_literal] = ACTIONS(455),
    [sym_binary_integer_literal] = ACTIONS(455),
    [sym_decimal_floating_point_literal] = ACTIONS(455),
    [sym_hex_floating_point_literal] = ACTIONS(457),
    [sym_true] = ACTIONS(457),
    [sym_false] = ACTIONS(457),
    [sym_character_literal] = ACTIONS(455),
    [sym_string_literal] = ACTIONS(455),
    [sym_null_literal] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_TILDE] = ACTIONS(455),
    [anon_sym_PLUS_PLUS] = ACTIONS(455),
    [anon_sym_DASH_DASH] = ACTIONS(455),
    [anon_sym_new] = ACTIONS(457),
    [anon_sym_class] = ACTIONS(457),
    [anon_sym_SEMI] = ACTIONS(455),
    [anon_sym_LBRACE] = ACTIONS(455),
    [anon_sym_RBRACE] = ACTIONS(455),
    [anon_sym_assert] = ACTIONS(457),
    [anon_sym_switch] = ACTIONS(457),
    [anon_sym_case] = ACTIONS(457),
    [anon_sym_default] = ACTIONS(457),
    [anon_sym_do] = ACTIONS(457),
    [anon_sym_while] = ACTIONS(457),
    [anon_sym_break] = ACTIONS(457),
    [anon_sym_continue] = ACTIONS(457),
    [anon_sym_return] = ACTIONS(457),
    [anon_sym_synchronized] = ACTIONS(457),
    [anon_sym_throw] = ACTIONS(457),
    [anon_sym_try] = ACTIONS(457),
    [anon_sym_catch] = ACTIONS(459),
    [anon_sym_finally] = ACTIONS(457),
    [anon_sym_if] = ACTIONS(457),
    [anon_sym_else] = ACTIONS(457),
    [anon_sym_for] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(457),
    [anon_sym_open] = ACTIONS(457),
    [anon_sym_module] = ACTIONS(457),
    [anon_sym_static] = ACTIONS(457),
    [anon_sym_package] = ACTIONS(457),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_enum] = ACTIONS(457),
    [anon_sym_public] = ACTIONS(457),
    [anon_sym_protected] = ACTIONS(457),
    [anon_sym_private] = ACTIONS(457),
    [anon_sym_abstract] = ACTIONS(457),
    [anon_sym_final] = ACTIONS(457),
    [anon_sym_strictfp] = ACTIONS(457),
    [anon_sym_native] = ACTIONS(457),
    [anon_sym_transient] = ACTIONS(457),
    [anon_sym_volatile] = ACTIONS(457),
    [anon_sym_ATinterface] = ACTIONS(455),
    [anon_sym_interface] = ACTIONS(457),
    [anon_sym_byte] = ACTIONS(457),
    [anon_sym_short] = ACTIONS(457),
    [anon_sym_int] = ACTIONS(457),
    [anon_sym_long] = ACTIONS(457),
    [anon_sym_char] = ACTIONS(457),
    [anon_sym_float] = ACTIONS(457),
    [anon_sym_double] = ACTIONS(457),
    [sym_boolean_type] = ACTIONS(457),
    [sym_void_type] = ACTIONS(457),
    [sym_this] = ACTIONS(457),
    [sym_super] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym__element_value] = STATE(798),
    [sym_element_value_array_initializer] = STATE(798),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_RBRACE] = ACTIONS(462),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym__element_value] = STATE(798),
    [sym_element_value_array_initializer] = STATE(798),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(396),
    [sym_cast_expression] = STATE(396),
    [sym_assignment_expression] = STATE(396),
    [sym_binary_expression] = STATE(396),
    [sym_instanceof_expression] = STATE(396),
    [sym_lambda_expression] = STATE(396),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(396),
    [sym_unary_expression] = STATE(396),
    [sym_update_expression] = STATE(396),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym_array_initializer] = STATE(702),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(466),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(413),
    [sym_cast_expression] = STATE(413),
    [sym_assignment_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_instanceof_expression] = STATE(413),
    [sym_lambda_expression] = STATE(413),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym_array_initializer] = STATE(784),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(472),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym__element_value] = STATE(843),
    [sym_element_value_array_initializer] = STATE(843),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(414),
    [sym_cast_expression] = STATE(414),
    [sym_assignment_expression] = STATE(414),
    [sym_binary_expression] = STATE(414),
    [sym_instanceof_expression] = STATE(414),
    [sym_lambda_expression] = STATE(414),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(414),
    [sym_unary_expression] = STATE(414),
    [sym_update_expression] = STATE(414),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym__element_value] = STATE(843),
    [sym_element_value_array_initializer] = STATE(843),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(413),
    [sym_cast_expression] = STATE(413),
    [sym_assignment_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_instanceof_expression] = STATE(413),
    [sym_lambda_expression] = STATE(413),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym_array_initializer] = STATE(784),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(474),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym__element_value] = STATE(798),
    [sym_element_value_array_initializer] = STATE(798),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(488),
    [sym_marker_annotation] = STATE(488),
    [sym_annotation] = STATE(488),
    [sym__element_value] = STATE(883),
    [sym_element_value_array_initializer] = STATE(883),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(361),
    [sym_cast_expression] = STATE(361),
    [sym_assignment_expression] = STATE(361),
    [sym_binary_expression] = STATE(361),
    [sym_instanceof_expression] = STATE(361),
    [sym_lambda_expression] = STATE(361),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(361),
    [sym_unary_expression] = STATE(361),
    [sym_update_expression] = STATE(361),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym_block] = STATE(360),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(407),
    [sym_identifier] = ACTIONS(409),
    [sym_decimal_integer_literal] = ACTIONS(409),
    [sym_hex_integer_literal] = ACTIONS(409),
    [sym_octal_integer_literal] = ACTIONS(407),
    [sym_binary_integer_literal] = ACTIONS(407),
    [sym_decimal_floating_point_literal] = ACTIONS(407),
    [sym_hex_floating_point_literal] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_character_literal] = ACTIONS(407),
    [sym_string_literal] = ACTIONS(407),
    [sym_null_literal] = ACTIONS(409),
    [anon_sym_LPAREN] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(407),
    [anon_sym_TILDE] = ACTIONS(407),
    [anon_sym_PLUS_PLUS] = ACTIONS(407),
    [anon_sym_DASH_DASH] = ACTIONS(407),
    [anon_sym_new] = ACTIONS(409),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_SEMI] = ACTIONS(407),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_RBRACE] = ACTIONS(407),
    [anon_sym_assert] = ACTIONS(409),
    [anon_sym_switch] = ACTIONS(409),
    [anon_sym_case] = ACTIONS(409),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_do] = ACTIONS(409),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_break] = ACTIONS(409),
    [anon_sym_continue] = ACTIONS(409),
    [anon_sym_return] = ACTIONS(409),
    [anon_sym_synchronized] = ACTIONS(409),
    [anon_sym_throw] = ACTIONS(409),
    [anon_sym_try] = ACTIONS(409),
    [anon_sym_catch] = ACTIONS(409),
    [anon_sym_finally] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_else] = ACTIONS(409),
    [anon_sym_for] = ACTIONS(409),
    [anon_sym_AT] = ACTIONS(409),
    [anon_sym_open] = ACTIONS(409),
    [anon_sym_module] = ACTIONS(409),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_package] = ACTIONS(409),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_enum] = ACTIONS(409),
    [anon_sym_public] = ACTIONS(409),
    [anon_sym_protected] = ACTIONS(409),
    [anon_sym_private] = ACTIONS(409),
    [anon_sym_abstract] = ACTIONS(409),
    [anon_sym_final] = ACTIONS(409),
    [anon_sym_strictfp] = ACTIONS(409),
    [anon_sym_native] = ACTIONS(409),
    [anon_sym_transient] = ACTIONS(409),
    [anon_sym_volatile] = ACTIONS(409),
    [anon_sym_ATinterface] = ACTIONS(407),
    [anon_sym_interface] = ACTIONS(409),
    [anon_sym_byte] = ACTIONS(409),
    [anon_sym_short] = ACTIONS(409),
    [anon_sym_int] = ACTIONS(409),
    [anon_sym_long] = ACTIONS(409),
    [anon_sym_char] = ACTIONS(409),
    [anon_sym_float] = ACTIONS(409),
    [anon_sym_double] = ACTIONS(409),
    [sym_boolean_type] = ACTIONS(409),
    [sym_void_type] = ACTIONS(409),
    [sym_this] = ACTIONS(409),
    [sym_super] = ACTIONS(409),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(394),
    [sym_cast_expression] = STATE(394),
    [sym_assignment_expression] = STATE(394),
    [sym_binary_expression] = STATE(394),
    [sym_instanceof_expression] = STATE(394),
    [sym_lambda_expression] = STATE(394),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(394),
    [sym_unary_expression] = STATE(394),
    [sym_update_expression] = STATE(394),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym_array_initializer] = STATE(720),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(403),
    [sym_identifier] = ACTIONS(405),
    [sym_decimal_integer_literal] = ACTIONS(405),
    [sym_hex_integer_literal] = ACTIONS(405),
    [sym_octal_integer_literal] = ACTIONS(403),
    [sym_binary_integer_literal] = ACTIONS(403),
    [sym_decimal_floating_point_literal] = ACTIONS(403),
    [sym_hex_floating_point_literal] = ACTIONS(405),
    [sym_true] = ACTIONS(405),
    [sym_false] = ACTIONS(405),
    [sym_character_literal] = ACTIONS(403),
    [sym_string_literal] = ACTIONS(403),
    [sym_null_literal] = ACTIONS(405),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_PLUS] = ACTIONS(405),
    [anon_sym_DASH] = ACTIONS(405),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_new] = ACTIONS(405),
    [anon_sym_class] = ACTIONS(405),
    [anon_sym_SEMI] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(403),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_assert] = ACTIONS(405),
    [anon_sym_switch] = ACTIONS(405),
    [anon_sym_case] = ACTIONS(405),
    [anon_sym_default] = ACTIONS(405),
    [anon_sym_do] = ACTIONS(405),
    [anon_sym_while] = ACTIONS(405),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(405),
    [anon_sym_return] = ACTIONS(405),
    [anon_sym_synchronized] = ACTIONS(405),
    [anon_sym_throw] = ACTIONS(405),
    [anon_sym_try] = ACTIONS(405),
    [anon_sym_catch] = ACTIONS(405),
    [anon_sym_finally] = ACTIONS(405),
    [anon_sym_if] = ACTIONS(405),
    [anon_sym_else] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(405),
    [anon_sym_open] = ACTIONS(405),
    [anon_sym_module] = ACTIONS(405),
    [anon_sym_static] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(405),
    [anon_sym_import] = ACTIONS(405),
    [anon_sym_enum] = ACTIONS(405),
    [anon_sym_public] = ACTIONS(405),
    [anon_sym_protected] = ACTIONS(405),
    [anon_sym_private] = ACTIONS(405),
    [anon_sym_abstract] = ACTIONS(405),
    [anon_sym_final] = ACTIONS(405),
    [anon_sym_strictfp] = ACTIONS(405),
    [anon_sym_native] = ACTIONS(405),
    [anon_sym_transient] = ACTIONS(405),
    [anon_sym_volatile] = ACTIONS(405),
    [anon_sym_ATinterface] = ACTIONS(403),
    [anon_sym_interface] = ACTIONS(405),
    [anon_sym_byte] = ACTIONS(405),
    [anon_sym_short] = ACTIONS(405),
    [anon_sym_int] = ACTIONS(405),
    [anon_sym_long] = ACTIONS(405),
    [anon_sym_char] = ACTIONS(405),
    [anon_sym_float] = ACTIONS(405),
    [anon_sym_double] = ACTIONS(405),
    [sym_boolean_type] = ACTIONS(405),
    [sym_void_type] = ACTIONS(405),
    [sym_this] = ACTIONS(405),
    [sym_super] = ACTIONS(405),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [ts_builtin_sym_end] = ACTIONS(476),
    [sym_identifier] = ACTIONS(478),
    [sym_decimal_integer_literal] = ACTIONS(478),
    [sym_hex_integer_literal] = ACTIONS(478),
    [sym_octal_integer_literal] = ACTIONS(476),
    [sym_binary_integer_literal] = ACTIONS(476),
    [sym_decimal_floating_point_literal] = ACTIONS(476),
    [sym_hex_floating_point_literal] = ACTIONS(478),
    [sym_true] = ACTIONS(478),
    [sym_false] = ACTIONS(478),
    [sym_character_literal] = ACTIONS(476),
    [sym_string_literal] = ACTIONS(476),
    [sym_null_literal] = ACTIONS(478),
    [anon_sym_LPAREN] = ACTIONS(476),
    [anon_sym_PLUS] = ACTIONS(478),
    [anon_sym_DASH] = ACTIONS(478),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_PLUS_PLUS] = ACTIONS(476),
    [anon_sym_DASH_DASH] = ACTIONS(476),
    [anon_sym_new] = ACTIONS(478),
    [anon_sym_class] = ACTIONS(478),
    [anon_sym_SEMI] = ACTIONS(476),
    [anon_sym_LBRACE] = ACTIONS(476),
    [anon_sym_RBRACE] = ACTIONS(476),
    [anon_sym_assert] = ACTIONS(478),
    [anon_sym_switch] = ACTIONS(478),
    [anon_sym_case] = ACTIONS(478),
    [anon_sym_default] = ACTIONS(478),
    [anon_sym_do] = ACTIONS(478),
    [anon_sym_while] = ACTIONS(478),
    [anon_sym_break] = ACTIONS(478),
    [anon_sym_continue] = ACTIONS(478),
    [anon_sym_return] = ACTIONS(478),
    [anon_sym_synchronized] = ACTIONS(478),
    [anon_sym_throw] = ACTIONS(478),
    [anon_sym_try] = ACTIONS(478),
    [anon_sym_catch] = ACTIONS(478),
    [anon_sym_finally] = ACTIONS(478),
    [anon_sym_if] = ACTIONS(478),
    [anon_sym_else] = ACTIONS(478),
    [anon_sym_for] = ACTIONS(478),
    [anon_sym_AT] = ACTIONS(478),
    [anon_sym_open] = ACTIONS(478),
    [anon_sym_module] = ACTIONS(478),
    [anon_sym_static] = ACTIONS(478),
    [anon_sym_package] = ACTIONS(478),
    [anon_sym_import] = ACTIONS(478),
    [anon_sym_enum] = ACTIONS(478),
    [anon_sym_public] = ACTIONS(478),
    [anon_sym_protected] = ACTIONS(478),
    [anon_sym_private] = ACTIONS(478),
    [anon_sym_abstract] = ACTIONS(478),
    [anon_sym_final] = ACTIONS(478),
    [anon_sym_strictfp] = ACTIONS(478),
    [anon_sym_native] = ACTIONS(478),
    [anon_sym_transient] = ACTIONS(478),
    [anon_sym_volatile] = ACTIONS(478),
    [anon_sym_ATinterface] = ACTIONS(476),
    [anon_sym_interface] = ACTIONS(478),
    [anon_sym_byte] = ACTIONS(478),
    [anon_sym_short] = ACTIONS(478),
    [anon_sym_int] = ACTIONS(478),
    [anon_sym_long] = ACTIONS(478),
    [anon_sym_char] = ACTIONS(478),
    [anon_sym_float] = ACTIONS(478),
    [anon_sym_double] = ACTIONS(478),
    [sym_boolean_type] = ACTIONS(478),
    [sym_void_type] = ACTIONS(478),
    [sym_this] = ACTIONS(478),
    [sym_super] = ACTIONS(478),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(413),
    [sym_cast_expression] = STATE(413),
    [sym_assignment_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_instanceof_expression] = STATE(413),
    [sym_lambda_expression] = STATE(413),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym_array_initializer] = STATE(784),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [ts_builtin_sym_end] = ACTIONS(480),
    [sym_identifier] = ACTIONS(482),
    [sym_decimal_integer_literal] = ACTIONS(482),
    [sym_hex_integer_literal] = ACTIONS(482),
    [sym_octal_integer_literal] = ACTIONS(480),
    [sym_binary_integer_literal] = ACTIONS(480),
    [sym_decimal_floating_point_literal] = ACTIONS(480),
    [sym_hex_floating_point_literal] = ACTIONS(482),
    [sym_true] = ACTIONS(482),
    [sym_false] = ACTIONS(482),
    [sym_character_literal] = ACTIONS(480),
    [sym_string_literal] = ACTIONS(480),
    [sym_null_literal] = ACTIONS(482),
    [anon_sym_LPAREN] = ACTIONS(480),
    [anon_sym_LT] = ACTIONS(480),
    [anon_sym_PLUS] = ACTIONS(482),
    [anon_sym_DASH] = ACTIONS(482),
    [anon_sym_BANG] = ACTIONS(480),
    [anon_sym_TILDE] = ACTIONS(480),
    [anon_sym_PLUS_PLUS] = ACTIONS(480),
    [anon_sym_DASH_DASH] = ACTIONS(480),
    [anon_sym_new] = ACTIONS(482),
    [anon_sym_class] = ACTIONS(482),
    [anon_sym_SEMI] = ACTIONS(480),
    [anon_sym_LBRACE] = ACTIONS(480),
    [anon_sym_RBRACE] = ACTIONS(480),
    [anon_sym_assert] = ACTIONS(482),
    [anon_sym_switch] = ACTIONS(482),
    [anon_sym_case] = ACTIONS(482),
    [anon_sym_default] = ACTIONS(482),
    [anon_sym_do] = ACTIONS(482),
    [anon_sym_while] = ACTIONS(482),
    [anon_sym_break] = ACTIONS(482),
    [anon_sym_continue] = ACTIONS(482),
    [anon_sym_return] = ACTIONS(482),
    [anon_sym_synchronized] = ACTIONS(482),
    [anon_sym_throw] = ACTIONS(482),
    [anon_sym_try] = ACTIONS(482),
    [anon_sym_if] = ACTIONS(482),
    [anon_sym_else] = ACTIONS(482),
    [anon_sym_for] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(482),
    [anon_sym_open] = ACTIONS(482),
    [anon_sym_module] = ACTIONS(482),
    [anon_sym_static] = ACTIONS(482),
    [anon_sym_package] = ACTIONS(482),
    [anon_sym_import] = ACTIONS(482),
    [anon_sym_enum] = ACTIONS(482),
    [anon_sym_public] = ACTIONS(482),
    [anon_sym_protected] = ACTIONS(482),
    [anon_sym_private] = ACTIONS(482),
    [anon_sym_abstract] = ACTIONS(482),
    [anon_sym_final] = ACTIONS(482),
    [anon_sym_strictfp] = ACTIONS(482),
    [anon_sym_native] = ACTIONS(482),
    [anon_sym_transient] = ACTIONS(482),
    [anon_sym_volatile] = ACTIONS(482),
    [anon_sym_ATinterface] = ACTIONS(480),
    [anon_sym_interface] = ACTIONS(482),
    [anon_sym_byte] = ACTIONS(482),
    [anon_sym_short] = ACTIONS(482),
    [anon_sym_int] = ACTIONS(482),
    [anon_sym_long] = ACTIONS(482),
    [anon_sym_char] = ACTIONS(482),
    [anon_sym_float] = ACTIONS(482),
    [anon_sym_double] = ACTIONS(482),
    [sym_boolean_type] = ACTIONS(482),
    [sym_void_type] = ACTIONS(482),
    [sym_this] = ACTIONS(482),
    [sym_super] = ACTIONS(482),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [ts_builtin_sym_end] = ACTIONS(484),
    [sym_identifier] = ACTIONS(486),
    [sym_decimal_integer_literal] = ACTIONS(486),
    [sym_hex_integer_literal] = ACTIONS(486),
    [sym_octal_integer_literal] = ACTIONS(484),
    [sym_binary_integer_literal] = ACTIONS(484),
    [sym_decimal_floating_point_literal] = ACTIONS(484),
    [sym_hex_floating_point_literal] = ACTIONS(486),
    [sym_true] = ACTIONS(486),
    [sym_false] = ACTIONS(486),
    [sym_character_literal] = ACTIONS(484),
    [sym_string_literal] = ACTIONS(484),
    [sym_null_literal] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(484),
    [anon_sym_LT] = ACTIONS(484),
    [anon_sym_PLUS] = ACTIONS(486),
    [anon_sym_DASH] = ACTIONS(486),
    [anon_sym_BANG] = ACTIONS(484),
    [anon_sym_TILDE] = ACTIONS(484),
    [anon_sym_PLUS_PLUS] = ACTIONS(484),
    [anon_sym_DASH_DASH] = ACTIONS(484),
    [anon_sym_new] = ACTIONS(486),
    [anon_sym_class] = ACTIONS(486),
    [anon_sym_SEMI] = ACTIONS(484),
    [anon_sym_LBRACE] = ACTIONS(484),
    [anon_sym_RBRACE] = ACTIONS(484),
    [anon_sym_assert] = ACTIONS(486),
    [anon_sym_switch] = ACTIONS(486),
    [anon_sym_case] = ACTIONS(486),
    [anon_sym_default] = ACTIONS(486),
    [anon_sym_do] = ACTIONS(486),
    [anon_sym_while] = ACTIONS(486),
    [anon_sym_break] = ACTIONS(486),
    [anon_sym_continue] = ACTIONS(486),
    [anon_sym_return] = ACTIONS(486),
    [anon_sym_synchronized] = ACTIONS(486),
    [anon_sym_throw] = ACTIONS(486),
    [anon_sym_try] = ACTIONS(486),
    [anon_sym_if] = ACTIONS(486),
    [anon_sym_else] = ACTIONS(486),
    [anon_sym_for] = ACTIONS(486),
    [anon_sym_AT] = ACTIONS(486),
    [anon_sym_open] = ACTIONS(486),
    [anon_sym_module] = ACTIONS(486),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_package] = ACTIONS(486),
    [anon_sym_import] = ACTIONS(486),
    [anon_sym_enum] = ACTIONS(486),
    [anon_sym_public] = ACTIONS(486),
    [anon_sym_protected] = ACTIONS(486),
    [anon_sym_private] = ACTIONS(486),
    [anon_sym_abstract] = ACTIONS(486),
    [anon_sym_final] = ACTIONS(486),
    [anon_sym_strictfp] = ACTIONS(486),
    [anon_sym_native] = ACTIONS(486),
    [anon_sym_transient] = ACTIONS(486),
    [anon_sym_volatile] = ACTIONS(486),
    [anon_sym_ATinterface] = ACTIONS(484),
    [anon_sym_interface] = ACTIONS(486),
    [anon_sym_byte] = ACTIONS(486),
    [anon_sym_short] = ACTIONS(486),
    [anon_sym_int] = ACTIONS(486),
    [anon_sym_long] = ACTIONS(486),
    [anon_sym_char] = ACTIONS(486),
    [anon_sym_float] = ACTIONS(486),
    [anon_sym_double] = ACTIONS(486),
    [sym_boolean_type] = ACTIONS(486),
    [sym_void_type] = ACTIONS(486),
    [sym_this] = ACTIONS(486),
    [sym_super] = ACTIONS(486),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(436),
    [sym_cast_expression] = STATE(436),
    [sym_assignment_expression] = STATE(436),
    [sym_binary_expression] = STATE(436),
    [sym_instanceof_expression] = STATE(436),
    [sym_lambda_expression] = STATE(436),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(436),
    [sym_unary_expression] = STATE(436),
    [sym_update_expression] = STATE(436),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(488),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [ts_builtin_sym_end] = ACTIONS(490),
    [sym_identifier] = ACTIONS(492),
    [sym_decimal_integer_literal] = ACTIONS(492),
    [sym_hex_integer_literal] = ACTIONS(492),
    [sym_octal_integer_literal] = ACTIONS(490),
    [sym_binary_integer_literal] = ACTIONS(490),
    [sym_decimal_floating_point_literal] = ACTIONS(490),
    [sym_hex_floating_point_literal] = ACTIONS(492),
    [sym_true] = ACTIONS(492),
    [sym_false] = ACTIONS(492),
    [sym_character_literal] = ACTIONS(490),
    [sym_string_literal] = ACTIONS(490),
    [sym_null_literal] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(490),
    [anon_sym_LT] = ACTIONS(490),
    [anon_sym_PLUS] = ACTIONS(492),
    [anon_sym_DASH] = ACTIONS(492),
    [anon_sym_BANG] = ACTIONS(490),
    [anon_sym_TILDE] = ACTIONS(490),
    [anon_sym_PLUS_PLUS] = ACTIONS(490),
    [anon_sym_DASH_DASH] = ACTIONS(490),
    [anon_sym_new] = ACTIONS(492),
    [anon_sym_class] = ACTIONS(492),
    [anon_sym_SEMI] = ACTIONS(490),
    [anon_sym_LBRACE] = ACTIONS(490),
    [anon_sym_RBRACE] = ACTIONS(490),
    [anon_sym_assert] = ACTIONS(492),
    [anon_sym_switch] = ACTIONS(492),
    [anon_sym_case] = ACTIONS(492),
    [anon_sym_default] = ACTIONS(492),
    [anon_sym_do] = ACTIONS(492),
    [anon_sym_while] = ACTIONS(492),
    [anon_sym_break] = ACTIONS(492),
    [anon_sym_continue] = ACTIONS(492),
    [anon_sym_return] = ACTIONS(492),
    [anon_sym_synchronized] = ACTIONS(492),
    [anon_sym_throw] = ACTIONS(492),
    [anon_sym_try] = ACTIONS(492),
    [anon_sym_if] = ACTIONS(492),
    [anon_sym_else] = ACTIONS(492),
    [anon_sym_for] = ACTIONS(492),
    [anon_sym_AT] = ACTIONS(492),
    [anon_sym_open] = ACTIONS(492),
    [anon_sym_module] = ACTIONS(492),
    [anon_sym_static] = ACTIONS(492),
    [anon_sym_package] = ACTIONS(492),
    [anon_sym_import] = ACTIONS(492),
    [anon_sym_enum] = ACTIONS(492),
    [anon_sym_public] = ACTIONS(492),
    [anon_sym_protected] = ACTIONS(492),
    [anon_sym_private] = ACTIONS(492),
    [anon_sym_abstract] = ACTIONS(492),
    [anon_sym_final] = ACTIONS(492),
    [anon_sym_strictfp] = ACTIONS(492),
    [anon_sym_native] = ACTIONS(492),
    [anon_sym_transient] = ACTIONS(492),
    [anon_sym_volatile] = ACTIONS(492),
    [anon_sym_ATinterface] = ACTIONS(490),
    [anon_sym_interface] = ACTIONS(492),
    [anon_sym_byte] = ACTIONS(492),
    [anon_sym_short] = ACTIONS(492),
    [anon_sym_int] = ACTIONS(492),
    [anon_sym_long] = ACTIONS(492),
    [anon_sym_char] = ACTIONS(492),
    [anon_sym_float] = ACTIONS(492),
    [anon_sym_double] = ACTIONS(492),
    [sym_boolean_type] = ACTIONS(492),
    [sym_void_type] = ACTIONS(492),
    [sym_this] = ACTIONS(492),
    [sym_super] = ACTIONS(492),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [ts_builtin_sym_end] = ACTIONS(494),
    [sym_identifier] = ACTIONS(496),
    [sym_decimal_integer_literal] = ACTIONS(496),
    [sym_hex_integer_literal] = ACTIONS(496),
    [sym_octal_integer_literal] = ACTIONS(494),
    [sym_binary_integer_literal] = ACTIONS(494),
    [sym_decimal_floating_point_literal] = ACTIONS(494),
    [sym_hex_floating_point_literal] = ACTIONS(496),
    [sym_true] = ACTIONS(496),
    [sym_false] = ACTIONS(496),
    [sym_character_literal] = ACTIONS(494),
    [sym_string_literal] = ACTIONS(494),
    [sym_null_literal] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_LT] = ACTIONS(494),
    [anon_sym_PLUS] = ACTIONS(496),
    [anon_sym_DASH] = ACTIONS(496),
    [anon_sym_BANG] = ACTIONS(494),
    [anon_sym_TILDE] = ACTIONS(494),
    [anon_sym_PLUS_PLUS] = ACTIONS(494),
    [anon_sym_DASH_DASH] = ACTIONS(494),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_class] = ACTIONS(496),
    [anon_sym_SEMI] = ACTIONS(494),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(494),
    [anon_sym_assert] = ACTIONS(496),
    [anon_sym_switch] = ACTIONS(496),
    [anon_sym_case] = ACTIONS(496),
    [anon_sym_default] = ACTIONS(496),
    [anon_sym_do] = ACTIONS(496),
    [anon_sym_while] = ACTIONS(496),
    [anon_sym_break] = ACTIONS(496),
    [anon_sym_continue] = ACTIONS(496),
    [anon_sym_return] = ACTIONS(496),
    [anon_sym_synchronized] = ACTIONS(496),
    [anon_sym_throw] = ACTIONS(496),
    [anon_sym_try] = ACTIONS(496),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_else] = ACTIONS(496),
    [anon_sym_for] = ACTIONS(496),
    [anon_sym_AT] = ACTIONS(496),
    [anon_sym_open] = ACTIONS(496),
    [anon_sym_module] = ACTIONS(496),
    [anon_sym_static] = ACTIONS(496),
    [anon_sym_package] = ACTIONS(496),
    [anon_sym_import] = ACTIONS(496),
    [anon_sym_enum] = ACTIONS(496),
    [anon_sym_public] = ACTIONS(496),
    [anon_sym_protected] = ACTIONS(496),
    [anon_sym_private] = ACTIONS(496),
    [anon_sym_abstract] = ACTIONS(496),
    [anon_sym_final] = ACTIONS(496),
    [anon_sym_strictfp] = ACTIONS(496),
    [anon_sym_native] = ACTIONS(496),
    [anon_sym_transient] = ACTIONS(496),
    [anon_sym_volatile] = ACTIONS(496),
    [anon_sym_ATinterface] = ACTIONS(494),
    [anon_sym_interface] = ACTIONS(496),
    [anon_sym_byte] = ACTIONS(496),
    [anon_sym_short] = ACTIONS(496),
    [anon_sym_int] = ACTIONS(496),
    [anon_sym_long] = ACTIONS(496),
    [anon_sym_char] = ACTIONS(496),
    [anon_sym_float] = ACTIONS(496),
    [anon_sym_double] = ACTIONS(496),
    [sym_boolean_type] = ACTIONS(496),
    [sym_void_type] = ACTIONS(496),
    [sym_this] = ACTIONS(496),
    [sym_super] = ACTIONS(496),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [ts_builtin_sym_end] = ACTIONS(498),
    [sym_identifier] = ACTIONS(500),
    [sym_decimal_integer_literal] = ACTIONS(500),
    [sym_hex_integer_literal] = ACTIONS(500),
    [sym_octal_integer_literal] = ACTIONS(498),
    [sym_binary_integer_literal] = ACTIONS(498),
    [sym_decimal_floating_point_literal] = ACTIONS(498),
    [sym_hex_floating_point_literal] = ACTIONS(500),
    [sym_true] = ACTIONS(500),
    [sym_false] = ACTIONS(500),
    [sym_character_literal] = ACTIONS(498),
    [sym_string_literal] = ACTIONS(498),
    [sym_null_literal] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(498),
    [anon_sym_LT] = ACTIONS(498),
    [anon_sym_PLUS] = ACTIONS(500),
    [anon_sym_DASH] = ACTIONS(500),
    [anon_sym_BANG] = ACTIONS(498),
    [anon_sym_TILDE] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(498),
    [anon_sym_DASH_DASH] = ACTIONS(498),
    [anon_sym_new] = ACTIONS(500),
    [anon_sym_class] = ACTIONS(500),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym_LBRACE] = ACTIONS(498),
    [anon_sym_RBRACE] = ACTIONS(498),
    [anon_sym_assert] = ACTIONS(500),
    [anon_sym_switch] = ACTIONS(500),
    [anon_sym_case] = ACTIONS(500),
    [anon_sym_default] = ACTIONS(500),
    [anon_sym_do] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(500),
    [anon_sym_break] = ACTIONS(500),
    [anon_sym_continue] = ACTIONS(500),
    [anon_sym_return] = ACTIONS(500),
    [anon_sym_synchronized] = ACTIONS(500),
    [anon_sym_throw] = ACTIONS(500),
    [anon_sym_try] = ACTIONS(500),
    [anon_sym_if] = ACTIONS(500),
    [anon_sym_else] = ACTIONS(500),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_AT] = ACTIONS(500),
    [anon_sym_open] = ACTIONS(500),
    [anon_sym_module] = ACTIONS(500),
    [anon_sym_static] = ACTIONS(500),
    [anon_sym_package] = ACTIONS(500),
    [anon_sym_import] = ACTIONS(500),
    [anon_sym_enum] = ACTIONS(500),
    [anon_sym_public] = ACTIONS(500),
    [anon_sym_protected] = ACTIONS(500),
    [anon_sym_private] = ACTIONS(500),
    [anon_sym_abstract] = ACTIONS(500),
    [anon_sym_final] = ACTIONS(500),
    [anon_sym_strictfp] = ACTIONS(500),
    [anon_sym_native] = ACTIONS(500),
    [anon_sym_transient] = ACTIONS(500),
    [anon_sym_volatile] = ACTIONS(500),
    [anon_sym_ATinterface] = ACTIONS(498),
    [anon_sym_interface] = ACTIONS(500),
    [anon_sym_byte] = ACTIONS(500),
    [anon_sym_short] = ACTIONS(500),
    [anon_sym_int] = ACTIONS(500),
    [anon_sym_long] = ACTIONS(500),
    [anon_sym_char] = ACTIONS(500),
    [anon_sym_float] = ACTIONS(500),
    [anon_sym_double] = ACTIONS(500),
    [sym_boolean_type] = ACTIONS(500),
    [sym_void_type] = ACTIONS(500),
    [sym_this] = ACTIONS(500),
    [sym_super] = ACTIONS(500),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(395),
    [sym_cast_expression] = STATE(395),
    [sym_assignment_expression] = STATE(395),
    [sym_binary_expression] = STATE(395),
    [sym_instanceof_expression] = STATE(395),
    [sym_lambda_expression] = STATE(395),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(395),
    [sym_unary_expression] = STATE(395),
    [sym_update_expression] = STATE(395),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(502),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(430),
    [sym_cast_expression] = STATE(430),
    [sym_assignment_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_instanceof_expression] = STATE(430),
    [sym_lambda_expression] = STATE(430),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(504),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(397),
    [sym_cast_expression] = STATE(397),
    [sym_assignment_expression] = STATE(397),
    [sym_binary_expression] = STATE(397),
    [sym_instanceof_expression] = STATE(397),
    [sym_lambda_expression] = STATE(397),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(397),
    [sym_unary_expression] = STATE(397),
    [sym_update_expression] = STATE(397),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(506),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(425),
    [sym_cast_expression] = STATE(425),
    [sym_assignment_expression] = STATE(425),
    [sym_binary_expression] = STATE(425),
    [sym_instanceof_expression] = STATE(425),
    [sym_lambda_expression] = STATE(425),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(425),
    [sym_unary_expression] = STATE(425),
    [sym_update_expression] = STATE(425),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(436),
    [sym_cast_expression] = STATE(436),
    [sym_assignment_expression] = STATE(436),
    [sym_binary_expression] = STATE(436),
    [sym_instanceof_expression] = STATE(436),
    [sym_lambda_expression] = STATE(436),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(436),
    [sym_unary_expression] = STATE(436),
    [sym_update_expression] = STATE(436),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(510),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [ts_builtin_sym_end] = ACTIONS(512),
    [sym_identifier] = ACTIONS(514),
    [sym_decimal_integer_literal] = ACTIONS(514),
    [sym_hex_integer_literal] = ACTIONS(514),
    [sym_octal_integer_literal] = ACTIONS(512),
    [sym_binary_integer_literal] = ACTIONS(512),
    [sym_decimal_floating_point_literal] = ACTIONS(512),
    [sym_hex_floating_point_literal] = ACTIONS(514),
    [sym_true] = ACTIONS(514),
    [sym_false] = ACTIONS(514),
    [sym_character_literal] = ACTIONS(512),
    [sym_string_literal] = ACTIONS(512),
    [sym_null_literal] = ACTIONS(514),
    [anon_sym_LPAREN] = ACTIONS(512),
    [anon_sym_LT] = ACTIONS(512),
    [anon_sym_PLUS] = ACTIONS(514),
    [anon_sym_DASH] = ACTIONS(514),
    [anon_sym_BANG] = ACTIONS(512),
    [anon_sym_TILDE] = ACTIONS(512),
    [anon_sym_PLUS_PLUS] = ACTIONS(512),
    [anon_sym_DASH_DASH] = ACTIONS(512),
    [anon_sym_new] = ACTIONS(514),
    [anon_sym_class] = ACTIONS(514),
    [anon_sym_SEMI] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(512),
    [anon_sym_RBRACE] = ACTIONS(512),
    [anon_sym_assert] = ACTIONS(514),
    [anon_sym_switch] = ACTIONS(514),
    [anon_sym_case] = ACTIONS(514),
    [anon_sym_default] = ACTIONS(514),
    [anon_sym_do] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(514),
    [anon_sym_break] = ACTIONS(514),
    [anon_sym_continue] = ACTIONS(514),
    [anon_sym_return] = ACTIONS(514),
    [anon_sym_synchronized] = ACTIONS(514),
    [anon_sym_throw] = ACTIONS(514),
    [anon_sym_try] = ACTIONS(514),
    [anon_sym_if] = ACTIONS(514),
    [anon_sym_else] = ACTIONS(514),
    [anon_sym_for] = ACTIONS(514),
    [anon_sym_AT] = ACTIONS(514),
    [anon_sym_open] = ACTIONS(514),
    [anon_sym_module] = ACTIONS(514),
    [anon_sym_static] = ACTIONS(514),
    [anon_sym_package] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_enum] = ACTIONS(514),
    [anon_sym_public] = ACTIONS(514),
    [anon_sym_protected] = ACTIONS(514),
    [anon_sym_private] = ACTIONS(514),
    [anon_sym_abstract] = ACTIONS(514),
    [anon_sym_final] = ACTIONS(514),
    [anon_sym_strictfp] = ACTIONS(514),
    [anon_sym_native] = ACTIONS(514),
    [anon_sym_transient] = ACTIONS(514),
    [anon_sym_volatile] = ACTIONS(514),
    [anon_sym_ATinterface] = ACTIONS(512),
    [anon_sym_interface] = ACTIONS(514),
    [anon_sym_byte] = ACTIONS(514),
    [anon_sym_short] = ACTIONS(514),
    [anon_sym_int] = ACTIONS(514),
    [anon_sym_long] = ACTIONS(514),
    [anon_sym_char] = ACTIONS(514),
    [anon_sym_float] = ACTIONS(514),
    [anon_sym_double] = ACTIONS(514),
    [sym_boolean_type] = ACTIONS(514),
    [sym_void_type] = ACTIONS(514),
    [sym_this] = ACTIONS(514),
    [sym_super] = ACTIONS(514),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [ts_builtin_sym_end] = ACTIONS(516),
    [sym_identifier] = ACTIONS(518),
    [sym_decimal_integer_literal] = ACTIONS(518),
    [sym_hex_integer_literal] = ACTIONS(518),
    [sym_octal_integer_literal] = ACTIONS(516),
    [sym_binary_integer_literal] = ACTIONS(516),
    [sym_decimal_floating_point_literal] = ACTIONS(516),
    [sym_hex_floating_point_literal] = ACTIONS(518),
    [sym_true] = ACTIONS(518),
    [sym_false] = ACTIONS(518),
    [sym_character_literal] = ACTIONS(516),
    [sym_string_literal] = ACTIONS(516),
    [sym_null_literal] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(516),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_PLUS] = ACTIONS(518),
    [anon_sym_DASH] = ACTIONS(518),
    [anon_sym_BANG] = ACTIONS(516),
    [anon_sym_TILDE] = ACTIONS(516),
    [anon_sym_PLUS_PLUS] = ACTIONS(516),
    [anon_sym_DASH_DASH] = ACTIONS(516),
    [anon_sym_new] = ACTIONS(518),
    [anon_sym_class] = ACTIONS(518),
    [anon_sym_SEMI] = ACTIONS(516),
    [anon_sym_LBRACE] = ACTIONS(516),
    [anon_sym_RBRACE] = ACTIONS(516),
    [anon_sym_assert] = ACTIONS(518),
    [anon_sym_switch] = ACTIONS(518),
    [anon_sym_case] = ACTIONS(518),
    [anon_sym_default] = ACTIONS(518),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_while] = ACTIONS(518),
    [anon_sym_break] = ACTIONS(518),
    [anon_sym_continue] = ACTIONS(518),
    [anon_sym_return] = ACTIONS(518),
    [anon_sym_synchronized] = ACTIONS(518),
    [anon_sym_throw] = ACTIONS(518),
    [anon_sym_try] = ACTIONS(518),
    [anon_sym_if] = ACTIONS(518),
    [anon_sym_else] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_AT] = ACTIONS(518),
    [anon_sym_open] = ACTIONS(518),
    [anon_sym_module] = ACTIONS(518),
    [anon_sym_static] = ACTIONS(518),
    [anon_sym_package] = ACTIONS(518),
    [anon_sym_import] = ACTIONS(518),
    [anon_sym_enum] = ACTIONS(518),
    [anon_sym_public] = ACTIONS(518),
    [anon_sym_protected] = ACTIONS(518),
    [anon_sym_private] = ACTIONS(518),
    [anon_sym_abstract] = ACTIONS(518),
    [anon_sym_final] = ACTIONS(518),
    [anon_sym_strictfp] = ACTIONS(518),
    [anon_sym_native] = ACTIONS(518),
    [anon_sym_transient] = ACTIONS(518),
    [anon_sym_volatile] = ACTIONS(518),
    [anon_sym_ATinterface] = ACTIONS(516),
    [anon_sym_interface] = ACTIONS(518),
    [anon_sym_byte] = ACTIONS(518),
    [anon_sym_short] = ACTIONS(518),
    [anon_sym_int] = ACTIONS(518),
    [anon_sym_long] = ACTIONS(518),
    [anon_sym_char] = ACTIONS(518),
    [anon_sym_float] = ACTIONS(518),
    [anon_sym_double] = ACTIONS(518),
    [sym_boolean_type] = ACTIONS(518),
    [sym_void_type] = ACTIONS(518),
    [sym_this] = ACTIONS(518),
    [sym_super] = ACTIONS(518),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [ts_builtin_sym_end] = ACTIONS(520),
    [sym_identifier] = ACTIONS(522),
    [sym_decimal_integer_literal] = ACTIONS(522),
    [sym_hex_integer_literal] = ACTIONS(522),
    [sym_octal_integer_literal] = ACTIONS(520),
    [sym_binary_integer_literal] = ACTIONS(520),
    [sym_decimal_floating_point_literal] = ACTIONS(520),
    [sym_hex_floating_point_literal] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_character_literal] = ACTIONS(520),
    [sym_string_literal] = ACTIONS(520),
    [sym_null_literal] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(520),
    [anon_sym_LT] = ACTIONS(520),
    [anon_sym_PLUS] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(522),
    [anon_sym_BANG] = ACTIONS(520),
    [anon_sym_TILDE] = ACTIONS(520),
    [anon_sym_PLUS_PLUS] = ACTIONS(520),
    [anon_sym_DASH_DASH] = ACTIONS(520),
    [anon_sym_new] = ACTIONS(522),
    [anon_sym_class] = ACTIONS(522),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_RBRACE] = ACTIONS(520),
    [anon_sym_assert] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_case] = ACTIONS(522),
    [anon_sym_default] = ACTIONS(522),
    [anon_sym_do] = ACTIONS(522),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(522),
    [anon_sym_continue] = ACTIONS(522),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_synchronized] = ACTIONS(522),
    [anon_sym_throw] = ACTIONS(522),
    [anon_sym_try] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_else] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_AT] = ACTIONS(522),
    [anon_sym_open] = ACTIONS(522),
    [anon_sym_module] = ACTIONS(522),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_package] = ACTIONS(522),
    [anon_sym_import] = ACTIONS(522),
    [anon_sym_enum] = ACTIONS(522),
    [anon_sym_public] = ACTIONS(522),
    [anon_sym_protected] = ACTIONS(522),
    [anon_sym_private] = ACTIONS(522),
    [anon_sym_abstract] = ACTIONS(522),
    [anon_sym_final] = ACTIONS(522),
    [anon_sym_strictfp] = ACTIONS(522),
    [anon_sym_native] = ACTIONS(522),
    [anon_sym_transient] = ACTIONS(522),
    [anon_sym_volatile] = ACTIONS(522),
    [anon_sym_ATinterface] = ACTIONS(520),
    [anon_sym_interface] = ACTIONS(522),
    [anon_sym_byte] = ACTIONS(522),
    [anon_sym_short] = ACTIONS(522),
    [anon_sym_int] = ACTIONS(522),
    [anon_sym_long] = ACTIONS(522),
    [anon_sym_char] = ACTIONS(522),
    [anon_sym_float] = ACTIONS(522),
    [anon_sym_double] = ACTIONS(522),
    [sym_boolean_type] = ACTIONS(522),
    [sym_void_type] = ACTIONS(522),
    [sym_this] = ACTIONS(522),
    [sym_super] = ACTIONS(522),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(418),
    [sym_cast_expression] = STATE(418),
    [sym_assignment_expression] = STATE(418),
    [sym_binary_expression] = STATE(418),
    [sym_instanceof_expression] = STATE(418),
    [sym_lambda_expression] = STATE(418),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(418),
    [sym_unary_expression] = STATE(418),
    [sym_update_expression] = STATE(418),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(524),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [ts_builtin_sym_end] = ACTIONS(526),
    [sym_identifier] = ACTIONS(528),
    [sym_decimal_integer_literal] = ACTIONS(528),
    [sym_hex_integer_literal] = ACTIONS(528),
    [sym_octal_integer_literal] = ACTIONS(526),
    [sym_binary_integer_literal] = ACTIONS(526),
    [sym_decimal_floating_point_literal] = ACTIONS(526),
    [sym_hex_floating_point_literal] = ACTIONS(528),
    [sym_true] = ACTIONS(528),
    [sym_false] = ACTIONS(528),
    [sym_character_literal] = ACTIONS(526),
    [sym_string_literal] = ACTIONS(526),
    [sym_null_literal] = ACTIONS(528),
    [anon_sym_LPAREN] = ACTIONS(526),
    [anon_sym_LT] = ACTIONS(526),
    [anon_sym_PLUS] = ACTIONS(528),
    [anon_sym_DASH] = ACTIONS(528),
    [anon_sym_BANG] = ACTIONS(526),
    [anon_sym_TILDE] = ACTIONS(526),
    [anon_sym_PLUS_PLUS] = ACTIONS(526),
    [anon_sym_DASH_DASH] = ACTIONS(526),
    [anon_sym_new] = ACTIONS(528),
    [anon_sym_class] = ACTIONS(528),
    [anon_sym_SEMI] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(526),
    [anon_sym_RBRACE] = ACTIONS(526),
    [anon_sym_assert] = ACTIONS(528),
    [anon_sym_switch] = ACTIONS(528),
    [anon_sym_case] = ACTIONS(528),
    [anon_sym_default] = ACTIONS(528),
    [anon_sym_do] = ACTIONS(528),
    [anon_sym_while] = ACTIONS(528),
    [anon_sym_break] = ACTIONS(528),
    [anon_sym_continue] = ACTIONS(528),
    [anon_sym_return] = ACTIONS(528),
    [anon_sym_synchronized] = ACTIONS(528),
    [anon_sym_throw] = ACTIONS(528),
    [anon_sym_try] = ACTIONS(528),
    [anon_sym_if] = ACTIONS(528),
    [anon_sym_else] = ACTIONS(528),
    [anon_sym_for] = ACTIONS(528),
    [anon_sym_AT] = ACTIONS(528),
    [anon_sym_open] = ACTIONS(528),
    [anon_sym_module] = ACTIONS(528),
    [anon_sym_static] = ACTIONS(528),
    [anon_sym_package] = ACTIONS(528),
    [anon_sym_import] = ACTIONS(528),
    [anon_sym_enum] = ACTIONS(528),
    [anon_sym_public] = ACTIONS(528),
    [anon_sym_protected] = ACTIONS(528),
    [anon_sym_private] = ACTIONS(528),
    [anon_sym_abstract] = ACTIONS(528),
    [anon_sym_final] = ACTIONS(528),
    [anon_sym_strictfp] = ACTIONS(528),
    [anon_sym_native] = ACTIONS(528),
    [anon_sym_transient] = ACTIONS(528),
    [anon_sym_volatile] = ACTIONS(528),
    [anon_sym_ATinterface] = ACTIONS(526),
    [anon_sym_interface] = ACTIONS(528),
    [anon_sym_byte] = ACTIONS(528),
    [anon_sym_short] = ACTIONS(528),
    [anon_sym_int] = ACTIONS(528),
    [anon_sym_long] = ACTIONS(528),
    [anon_sym_char] = ACTIONS(528),
    [anon_sym_float] = ACTIONS(528),
    [anon_sym_double] = ACTIONS(528),
    [sym_boolean_type] = ACTIONS(528),
    [sym_void_type] = ACTIONS(528),
    [sym_this] = ACTIONS(528),
    [sym_super] = ACTIONS(528),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(530),
    [sym_identifier] = ACTIONS(532),
    [sym_decimal_integer_literal] = ACTIONS(532),
    [sym_hex_integer_literal] = ACTIONS(532),
    [sym_octal_integer_literal] = ACTIONS(530),
    [sym_binary_integer_literal] = ACTIONS(530),
    [sym_decimal_floating_point_literal] = ACTIONS(530),
    [sym_hex_floating_point_literal] = ACTIONS(532),
    [sym_true] = ACTIONS(532),
    [sym_false] = ACTIONS(532),
    [sym_character_literal] = ACTIONS(530),
    [sym_string_literal] = ACTIONS(530),
    [sym_null_literal] = ACTIONS(532),
    [anon_sym_LPAREN] = ACTIONS(530),
    [anon_sym_LT] = ACTIONS(530),
    [anon_sym_PLUS] = ACTIONS(532),
    [anon_sym_DASH] = ACTIONS(532),
    [anon_sym_BANG] = ACTIONS(530),
    [anon_sym_TILDE] = ACTIONS(530),
    [anon_sym_PLUS_PLUS] = ACTIONS(530),
    [anon_sym_DASH_DASH] = ACTIONS(530),
    [anon_sym_new] = ACTIONS(532),
    [anon_sym_class] = ACTIONS(532),
    [anon_sym_SEMI] = ACTIONS(530),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_assert] = ACTIONS(532),
    [anon_sym_switch] = ACTIONS(532),
    [anon_sym_case] = ACTIONS(532),
    [anon_sym_default] = ACTIONS(532),
    [anon_sym_do] = ACTIONS(532),
    [anon_sym_while] = ACTIONS(532),
    [anon_sym_break] = ACTIONS(532),
    [anon_sym_continue] = ACTIONS(532),
    [anon_sym_return] = ACTIONS(532),
    [anon_sym_synchronized] = ACTIONS(532),
    [anon_sym_throw] = ACTIONS(532),
    [anon_sym_try] = ACTIONS(532),
    [anon_sym_if] = ACTIONS(532),
    [anon_sym_else] = ACTIONS(532),
    [anon_sym_for] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(532),
    [anon_sym_open] = ACTIONS(532),
    [anon_sym_module] = ACTIONS(532),
    [anon_sym_static] = ACTIONS(532),
    [anon_sym_package] = ACTIONS(532),
    [anon_sym_import] = ACTIONS(532),
    [anon_sym_enum] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(532),
    [anon_sym_protected] = ACTIONS(532),
    [anon_sym_private] = ACTIONS(532),
    [anon_sym_abstract] = ACTIONS(532),
    [anon_sym_final] = ACTIONS(532),
    [anon_sym_strictfp] = ACTIONS(532),
    [anon_sym_native] = ACTIONS(532),
    [anon_sym_transient] = ACTIONS(532),
    [anon_sym_volatile] = ACTIONS(532),
    [anon_sym_ATinterface] = ACTIONS(530),
    [anon_sym_interface] = ACTIONS(532),
    [anon_sym_byte] = ACTIONS(532),
    [anon_sym_short] = ACTIONS(532),
    [anon_sym_int] = ACTIONS(532),
    [anon_sym_long] = ACTIONS(532),
    [anon_sym_char] = ACTIONS(532),
    [anon_sym_float] = ACTIONS(532),
    [anon_sym_double] = ACTIONS(532),
    [sym_boolean_type] = ACTIONS(532),
    [sym_void_type] = ACTIONS(532),
    [sym_this] = ACTIONS(532),
    [sym_super] = ACTIONS(532),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(534),
    [sym_identifier] = ACTIONS(536),
    [sym_decimal_integer_literal] = ACTIONS(536),
    [sym_hex_integer_literal] = ACTIONS(536),
    [sym_octal_integer_literal] = ACTIONS(534),
    [sym_binary_integer_literal] = ACTIONS(534),
    [sym_decimal_floating_point_literal] = ACTIONS(534),
    [sym_hex_floating_point_literal] = ACTIONS(536),
    [sym_true] = ACTIONS(536),
    [sym_false] = ACTIONS(536),
    [sym_character_literal] = ACTIONS(534),
    [sym_string_literal] = ACTIONS(534),
    [sym_null_literal] = ACTIONS(536),
    [anon_sym_LPAREN] = ACTIONS(534),
    [anon_sym_LT] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(536),
    [anon_sym_DASH] = ACTIONS(536),
    [anon_sym_BANG] = ACTIONS(534),
    [anon_sym_TILDE] = ACTIONS(534),
    [anon_sym_PLUS_PLUS] = ACTIONS(534),
    [anon_sym_DASH_DASH] = ACTIONS(534),
    [anon_sym_new] = ACTIONS(536),
    [anon_sym_class] = ACTIONS(536),
    [anon_sym_SEMI] = ACTIONS(534),
    [anon_sym_LBRACE] = ACTIONS(534),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_assert] = ACTIONS(536),
    [anon_sym_switch] = ACTIONS(536),
    [anon_sym_case] = ACTIONS(536),
    [anon_sym_default] = ACTIONS(536),
    [anon_sym_do] = ACTIONS(536),
    [anon_sym_while] = ACTIONS(536),
    [anon_sym_break] = ACTIONS(536),
    [anon_sym_continue] = ACTIONS(536),
    [anon_sym_return] = ACTIONS(536),
    [anon_sym_synchronized] = ACTIONS(536),
    [anon_sym_throw] = ACTIONS(536),
    [anon_sym_try] = ACTIONS(536),
    [anon_sym_if] = ACTIONS(536),
    [anon_sym_else] = ACTIONS(536),
    [anon_sym_for] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(536),
    [anon_sym_open] = ACTIONS(536),
    [anon_sym_module] = ACTIONS(536),
    [anon_sym_static] = ACTIONS(536),
    [anon_sym_package] = ACTIONS(536),
    [anon_sym_import] = ACTIONS(536),
    [anon_sym_enum] = ACTIONS(536),
    [anon_sym_public] = ACTIONS(536),
    [anon_sym_protected] = ACTIONS(536),
    [anon_sym_private] = ACTIONS(536),
    [anon_sym_abstract] = ACTIONS(536),
    [anon_sym_final] = ACTIONS(536),
    [anon_sym_strictfp] = ACTIONS(536),
    [anon_sym_native] = ACTIONS(536),
    [anon_sym_transient] = ACTIONS(536),
    [anon_sym_volatile] = ACTIONS(536),
    [anon_sym_ATinterface] = ACTIONS(534),
    [anon_sym_interface] = ACTIONS(536),
    [anon_sym_byte] = ACTIONS(536),
    [anon_sym_short] = ACTIONS(536),
    [anon_sym_int] = ACTIONS(536),
    [anon_sym_long] = ACTIONS(536),
    [anon_sym_char] = ACTIONS(536),
    [anon_sym_float] = ACTIONS(536),
    [anon_sym_double] = ACTIONS(536),
    [sym_boolean_type] = ACTIONS(536),
    [sym_void_type] = ACTIONS(536),
    [sym_this] = ACTIONS(536),
    [sym_super] = ACTIONS(536),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(538),
    [sym_identifier] = ACTIONS(540),
    [sym_decimal_integer_literal] = ACTIONS(540),
    [sym_hex_integer_literal] = ACTIONS(540),
    [sym_octal_integer_literal] = ACTIONS(538),
    [sym_binary_integer_literal] = ACTIONS(538),
    [sym_decimal_floating_point_literal] = ACTIONS(538),
    [sym_hex_floating_point_literal] = ACTIONS(540),
    [sym_true] = ACTIONS(540),
    [sym_false] = ACTIONS(540),
    [sym_character_literal] = ACTIONS(538),
    [sym_string_literal] = ACTIONS(538),
    [sym_null_literal] = ACTIONS(540),
    [anon_sym_LPAREN] = ACTIONS(538),
    [anon_sym_LT] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(540),
    [anon_sym_DASH] = ACTIONS(540),
    [anon_sym_BANG] = ACTIONS(538),
    [anon_sym_TILDE] = ACTIONS(538),
    [anon_sym_PLUS_PLUS] = ACTIONS(538),
    [anon_sym_DASH_DASH] = ACTIONS(538),
    [anon_sym_new] = ACTIONS(540),
    [anon_sym_class] = ACTIONS(540),
    [anon_sym_SEMI] = ACTIONS(538),
    [anon_sym_LBRACE] = ACTIONS(538),
    [anon_sym_RBRACE] = ACTIONS(538),
    [anon_sym_assert] = ACTIONS(540),
    [anon_sym_switch] = ACTIONS(540),
    [anon_sym_case] = ACTIONS(540),
    [anon_sym_default] = ACTIONS(540),
    [anon_sym_do] = ACTIONS(540),
    [anon_sym_while] = ACTIONS(540),
    [anon_sym_break] = ACTIONS(540),
    [anon_sym_continue] = ACTIONS(540),
    [anon_sym_return] = ACTIONS(540),
    [anon_sym_synchronized] = ACTIONS(540),
    [anon_sym_throw] = ACTIONS(540),
    [anon_sym_try] = ACTIONS(540),
    [anon_sym_if] = ACTIONS(540),
    [anon_sym_else] = ACTIONS(540),
    [anon_sym_for] = ACTIONS(540),
    [anon_sym_AT] = ACTIONS(540),
    [anon_sym_open] = ACTIONS(540),
    [anon_sym_module] = ACTIONS(540),
    [anon_sym_static] = ACTIONS(540),
    [anon_sym_package] = ACTIONS(540),
    [anon_sym_import] = ACTIONS(540),
    [anon_sym_enum] = ACTIONS(540),
    [anon_sym_public] = ACTIONS(540),
    [anon_sym_protected] = ACTIONS(540),
    [anon_sym_private] = ACTIONS(540),
    [anon_sym_abstract] = ACTIONS(540),
    [anon_sym_final] = ACTIONS(540),
    [anon_sym_strictfp] = ACTIONS(540),
    [anon_sym_native] = ACTIONS(540),
    [anon_sym_transient] = ACTIONS(540),
    [anon_sym_volatile] = ACTIONS(540),
    [anon_sym_ATinterface] = ACTIONS(538),
    [anon_sym_interface] = ACTIONS(540),
    [anon_sym_byte] = ACTIONS(540),
    [anon_sym_short] = ACTIONS(540),
    [anon_sym_int] = ACTIONS(540),
    [anon_sym_long] = ACTIONS(540),
    [anon_sym_char] = ACTIONS(540),
    [anon_sym_float] = ACTIONS(540),
    [anon_sym_double] = ACTIONS(540),
    [sym_boolean_type] = ACTIONS(540),
    [sym_void_type] = ACTIONS(540),
    [sym_this] = ACTIONS(540),
    [sym_super] = ACTIONS(540),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(542),
    [sym_identifier] = ACTIONS(544),
    [sym_decimal_integer_literal] = ACTIONS(544),
    [sym_hex_integer_literal] = ACTIONS(544),
    [sym_octal_integer_literal] = ACTIONS(542),
    [sym_binary_integer_literal] = ACTIONS(542),
    [sym_decimal_floating_point_literal] = ACTIONS(542),
    [sym_hex_floating_point_literal] = ACTIONS(544),
    [sym_true] = ACTIONS(544),
    [sym_false] = ACTIONS(544),
    [sym_character_literal] = ACTIONS(542),
    [sym_string_literal] = ACTIONS(542),
    [sym_null_literal] = ACTIONS(544),
    [anon_sym_LPAREN] = ACTIONS(542),
    [anon_sym_LT] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(544),
    [anon_sym_DASH] = ACTIONS(544),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_TILDE] = ACTIONS(542),
    [anon_sym_PLUS_PLUS] = ACTIONS(542),
    [anon_sym_DASH_DASH] = ACTIONS(542),
    [anon_sym_new] = ACTIONS(544),
    [anon_sym_class] = ACTIONS(544),
    [anon_sym_SEMI] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(542),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_assert] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(544),
    [anon_sym_case] = ACTIONS(544),
    [anon_sym_default] = ACTIONS(544),
    [anon_sym_do] = ACTIONS(544),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(544),
    [anon_sym_return] = ACTIONS(544),
    [anon_sym_synchronized] = ACTIONS(544),
    [anon_sym_throw] = ACTIONS(544),
    [anon_sym_try] = ACTIONS(544),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_else] = ACTIONS(544),
    [anon_sym_for] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_open] = ACTIONS(544),
    [anon_sym_module] = ACTIONS(544),
    [anon_sym_static] = ACTIONS(544),
    [anon_sym_package] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(544),
    [anon_sym_enum] = ACTIONS(544),
    [anon_sym_public] = ACTIONS(544),
    [anon_sym_protected] = ACTIONS(544),
    [anon_sym_private] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(544),
    [anon_sym_final] = ACTIONS(544),
    [anon_sym_strictfp] = ACTIONS(544),
    [anon_sym_native] = ACTIONS(544),
    [anon_sym_transient] = ACTIONS(544),
    [anon_sym_volatile] = ACTIONS(544),
    [anon_sym_ATinterface] = ACTIONS(542),
    [anon_sym_interface] = ACTIONS(544),
    [anon_sym_byte] = ACTIONS(544),
    [anon_sym_short] = ACTIONS(544),
    [anon_sym_int] = ACTIONS(544),
    [anon_sym_long] = ACTIONS(544),
    [anon_sym_char] = ACTIONS(544),
    [anon_sym_float] = ACTIONS(544),
    [anon_sym_double] = ACTIONS(544),
    [sym_boolean_type] = ACTIONS(544),
    [sym_void_type] = ACTIONS(544),
    [sym_this] = ACTIONS(544),
    [sym_super] = ACTIONS(544),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(546),
    [sym_identifier] = ACTIONS(548),
    [sym_decimal_integer_literal] = ACTIONS(548),
    [sym_hex_integer_literal] = ACTIONS(548),
    [sym_octal_integer_literal] = ACTIONS(546),
    [sym_binary_integer_literal] = ACTIONS(546),
    [sym_decimal_floating_point_literal] = ACTIONS(546),
    [sym_hex_floating_point_literal] = ACTIONS(548),
    [sym_true] = ACTIONS(548),
    [sym_false] = ACTIONS(548),
    [sym_character_literal] = ACTIONS(546),
    [sym_string_literal] = ACTIONS(546),
    [sym_null_literal] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(546),
    [anon_sym_LT] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(548),
    [anon_sym_DASH] = ACTIONS(548),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_TILDE] = ACTIONS(546),
    [anon_sym_PLUS_PLUS] = ACTIONS(546),
    [anon_sym_DASH_DASH] = ACTIONS(546),
    [anon_sym_new] = ACTIONS(548),
    [anon_sym_class] = ACTIONS(548),
    [anon_sym_SEMI] = ACTIONS(546),
    [anon_sym_LBRACE] = ACTIONS(546),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_assert] = ACTIONS(548),
    [anon_sym_switch] = ACTIONS(548),
    [anon_sym_case] = ACTIONS(548),
    [anon_sym_default] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(548),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_break] = ACTIONS(548),
    [anon_sym_continue] = ACTIONS(548),
    [anon_sym_return] = ACTIONS(548),
    [anon_sym_synchronized] = ACTIONS(548),
    [anon_sym_throw] = ACTIONS(548),
    [anon_sym_try] = ACTIONS(548),
    [anon_sym_if] = ACTIONS(548),
    [anon_sym_else] = ACTIONS(548),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(548),
    [anon_sym_open] = ACTIONS(548),
    [anon_sym_module] = ACTIONS(548),
    [anon_sym_static] = ACTIONS(548),
    [anon_sym_package] = ACTIONS(548),
    [anon_sym_import] = ACTIONS(548),
    [anon_sym_enum] = ACTIONS(548),
    [anon_sym_public] = ACTIONS(548),
    [anon_sym_protected] = ACTIONS(548),
    [anon_sym_private] = ACTIONS(548),
    [anon_sym_abstract] = ACTIONS(548),
    [anon_sym_final] = ACTIONS(548),
    [anon_sym_strictfp] = ACTIONS(548),
    [anon_sym_native] = ACTIONS(548),
    [anon_sym_transient] = ACTIONS(548),
    [anon_sym_volatile] = ACTIONS(548),
    [anon_sym_ATinterface] = ACTIONS(546),
    [anon_sym_interface] = ACTIONS(548),
    [anon_sym_byte] = ACTIONS(548),
    [anon_sym_short] = ACTIONS(548),
    [anon_sym_int] = ACTIONS(548),
    [anon_sym_long] = ACTIONS(548),
    [anon_sym_char] = ACTIONS(548),
    [anon_sym_float] = ACTIONS(548),
    [anon_sym_double] = ACTIONS(548),
    [sym_boolean_type] = ACTIONS(548),
    [sym_void_type] = ACTIONS(548),
    [sym_this] = ACTIONS(548),
    [sym_super] = ACTIONS(548),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(550),
    [sym_identifier] = ACTIONS(552),
    [sym_decimal_integer_literal] = ACTIONS(552),
    [sym_hex_integer_literal] = ACTIONS(552),
    [sym_octal_integer_literal] = ACTIONS(550),
    [sym_binary_integer_literal] = ACTIONS(550),
    [sym_decimal_floating_point_literal] = ACTIONS(550),
    [sym_hex_floating_point_literal] = ACTIONS(552),
    [sym_true] = ACTIONS(552),
    [sym_false] = ACTIONS(552),
    [sym_character_literal] = ACTIONS(550),
    [sym_string_literal] = ACTIONS(550),
    [sym_null_literal] = ACTIONS(552),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_LT] = ACTIONS(550),
    [anon_sym_PLUS] = ACTIONS(552),
    [anon_sym_DASH] = ACTIONS(552),
    [anon_sym_BANG] = ACTIONS(550),
    [anon_sym_TILDE] = ACTIONS(550),
    [anon_sym_PLUS_PLUS] = ACTIONS(550),
    [anon_sym_DASH_DASH] = ACTIONS(550),
    [anon_sym_new] = ACTIONS(552),
    [anon_sym_class] = ACTIONS(552),
    [anon_sym_SEMI] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(550),
    [anon_sym_RBRACE] = ACTIONS(550),
    [anon_sym_assert] = ACTIONS(552),
    [anon_sym_switch] = ACTIONS(552),
    [anon_sym_case] = ACTIONS(552),
    [anon_sym_default] = ACTIONS(552),
    [anon_sym_do] = ACTIONS(552),
    [anon_sym_while] = ACTIONS(552),
    [anon_sym_break] = ACTIONS(552),
    [anon_sym_continue] = ACTIONS(552),
    [anon_sym_return] = ACTIONS(552),
    [anon_sym_synchronized] = ACTIONS(552),
    [anon_sym_throw] = ACTIONS(552),
    [anon_sym_try] = ACTIONS(552),
    [anon_sym_if] = ACTIONS(552),
    [anon_sym_else] = ACTIONS(552),
    [anon_sym_for] = ACTIONS(552),
    [anon_sym_AT] = ACTIONS(552),
    [anon_sym_open] = ACTIONS(552),
    [anon_sym_module] = ACTIONS(552),
    [anon_sym_static] = ACTIONS(552),
    [anon_sym_package] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(552),
    [anon_sym_enum] = ACTIONS(552),
    [anon_sym_public] = ACTIONS(552),
    [anon_sym_protected] = ACTIONS(552),
    [anon_sym_private] = ACTIONS(552),
    [anon_sym_abstract] = ACTIONS(552),
    [anon_sym_final] = ACTIONS(552),
    [anon_sym_strictfp] = ACTIONS(552),
    [anon_sym_native] = ACTIONS(552),
    [anon_sym_transient] = ACTIONS(552),
    [anon_sym_volatile] = ACTIONS(552),
    [anon_sym_ATinterface] = ACTIONS(550),
    [anon_sym_interface] = ACTIONS(552),
    [anon_sym_byte] = ACTIONS(552),
    [anon_sym_short] = ACTIONS(552),
    [anon_sym_int] = ACTIONS(552),
    [anon_sym_long] = ACTIONS(552),
    [anon_sym_char] = ACTIONS(552),
    [anon_sym_float] = ACTIONS(552),
    [anon_sym_double] = ACTIONS(552),
    [sym_boolean_type] = ACTIONS(552),
    [sym_void_type] = ACTIONS(552),
    [sym_this] = ACTIONS(552),
    [sym_super] = ACTIONS(552),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(430),
    [sym_cast_expression] = STATE(430),
    [sym_assignment_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_instanceof_expression] = STATE(430),
    [sym_lambda_expression] = STATE(430),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(554),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(556),
    [sym_identifier] = ACTIONS(558),
    [sym_decimal_integer_literal] = ACTIONS(558),
    [sym_hex_integer_literal] = ACTIONS(558),
    [sym_octal_integer_literal] = ACTIONS(556),
    [sym_binary_integer_literal] = ACTIONS(556),
    [sym_decimal_floating_point_literal] = ACTIONS(556),
    [sym_hex_floating_point_literal] = ACTIONS(558),
    [sym_true] = ACTIONS(558),
    [sym_false] = ACTIONS(558),
    [sym_character_literal] = ACTIONS(556),
    [sym_string_literal] = ACTIONS(556),
    [sym_null_literal] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(556),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(558),
    [anon_sym_DASH] = ACTIONS(558),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_TILDE] = ACTIONS(556),
    [anon_sym_PLUS_PLUS] = ACTIONS(556),
    [anon_sym_DASH_DASH] = ACTIONS(556),
    [anon_sym_new] = ACTIONS(558),
    [anon_sym_class] = ACTIONS(558),
    [anon_sym_SEMI] = ACTIONS(556),
    [anon_sym_LBRACE] = ACTIONS(556),
    [anon_sym_RBRACE] = ACTIONS(556),
    [anon_sym_assert] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(558),
    [anon_sym_case] = ACTIONS(558),
    [anon_sym_default] = ACTIONS(558),
    [anon_sym_do] = ACTIONS(558),
    [anon_sym_while] = ACTIONS(558),
    [anon_sym_break] = ACTIONS(558),
    [anon_sym_continue] = ACTIONS(558),
    [anon_sym_return] = ACTIONS(558),
    [anon_sym_synchronized] = ACTIONS(558),
    [anon_sym_throw] = ACTIONS(558),
    [anon_sym_try] = ACTIONS(558),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_else] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(558),
    [anon_sym_AT] = ACTIONS(558),
    [anon_sym_open] = ACTIONS(558),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_static] = ACTIONS(558),
    [anon_sym_package] = ACTIONS(558),
    [anon_sym_import] = ACTIONS(558),
    [anon_sym_enum] = ACTIONS(558),
    [anon_sym_public] = ACTIONS(558),
    [anon_sym_protected] = ACTIONS(558),
    [anon_sym_private] = ACTIONS(558),
    [anon_sym_abstract] = ACTIONS(558),
    [anon_sym_final] = ACTIONS(558),
    [anon_sym_strictfp] = ACTIONS(558),
    [anon_sym_native] = ACTIONS(558),
    [anon_sym_transient] = ACTIONS(558),
    [anon_sym_volatile] = ACTIONS(558),
    [anon_sym_ATinterface] = ACTIONS(556),
    [anon_sym_interface] = ACTIONS(558),
    [anon_sym_byte] = ACTIONS(558),
    [anon_sym_short] = ACTIONS(558),
    [anon_sym_int] = ACTIONS(558),
    [anon_sym_long] = ACTIONS(558),
    [anon_sym_char] = ACTIONS(558),
    [anon_sym_float] = ACTIONS(558),
    [anon_sym_double] = ACTIONS(558),
    [sym_boolean_type] = ACTIONS(558),
    [sym_void_type] = ACTIONS(558),
    [sym_this] = ACTIONS(558),
    [sym_super] = ACTIONS(558),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(560),
    [sym_identifier] = ACTIONS(562),
    [sym_decimal_integer_literal] = ACTIONS(562),
    [sym_hex_integer_literal] = ACTIONS(562),
    [sym_octal_integer_literal] = ACTIONS(560),
    [sym_binary_integer_literal] = ACTIONS(560),
    [sym_decimal_floating_point_literal] = ACTIONS(560),
    [sym_hex_floating_point_literal] = ACTIONS(562),
    [sym_true] = ACTIONS(562),
    [sym_false] = ACTIONS(562),
    [sym_character_literal] = ACTIONS(560),
    [sym_string_literal] = ACTIONS(560),
    [sym_null_literal] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(560),
    [anon_sym_PLUS] = ACTIONS(562),
    [anon_sym_DASH] = ACTIONS(562),
    [anon_sym_BANG] = ACTIONS(560),
    [anon_sym_TILDE] = ACTIONS(560),
    [anon_sym_PLUS_PLUS] = ACTIONS(560),
    [anon_sym_DASH_DASH] = ACTIONS(560),
    [anon_sym_new] = ACTIONS(562),
    [anon_sym_class] = ACTIONS(562),
    [anon_sym_SEMI] = ACTIONS(560),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_RBRACE] = ACTIONS(560),
    [anon_sym_assert] = ACTIONS(562),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_case] = ACTIONS(562),
    [anon_sym_default] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(562),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_break] = ACTIONS(562),
    [anon_sym_continue] = ACTIONS(562),
    [anon_sym_return] = ACTIONS(562),
    [anon_sym_synchronized] = ACTIONS(562),
    [anon_sym_throw] = ACTIONS(562),
    [anon_sym_try] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_else] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_AT] = ACTIONS(562),
    [anon_sym_open] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_package] = ACTIONS(562),
    [anon_sym_import] = ACTIONS(562),
    [anon_sym_enum] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_abstract] = ACTIONS(562),
    [anon_sym_final] = ACTIONS(562),
    [anon_sym_strictfp] = ACTIONS(562),
    [anon_sym_native] = ACTIONS(562),
    [anon_sym_transient] = ACTIONS(562),
    [anon_sym_volatile] = ACTIONS(562),
    [anon_sym_ATinterface] = ACTIONS(560),
    [anon_sym_interface] = ACTIONS(562),
    [anon_sym_byte] = ACTIONS(562),
    [anon_sym_short] = ACTIONS(562),
    [anon_sym_int] = ACTIONS(562),
    [anon_sym_long] = ACTIONS(562),
    [anon_sym_char] = ACTIONS(562),
    [anon_sym_float] = ACTIONS(562),
    [anon_sym_double] = ACTIONS(562),
    [sym_boolean_type] = ACTIONS(562),
    [sym_void_type] = ACTIONS(562),
    [sym_this] = ACTIONS(562),
    [sym_super] = ACTIONS(562),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(564),
    [sym_identifier] = ACTIONS(566),
    [sym_decimal_integer_literal] = ACTIONS(566),
    [sym_hex_integer_literal] = ACTIONS(566),
    [sym_octal_integer_literal] = ACTIONS(564),
    [sym_binary_integer_literal] = ACTIONS(564),
    [sym_decimal_floating_point_literal] = ACTIONS(564),
    [sym_hex_floating_point_literal] = ACTIONS(566),
    [sym_true] = ACTIONS(566),
    [sym_false] = ACTIONS(566),
    [sym_character_literal] = ACTIONS(564),
    [sym_string_literal] = ACTIONS(564),
    [sym_null_literal] = ACTIONS(566),
    [anon_sym_LPAREN] = ACTIONS(564),
    [anon_sym_LT] = ACTIONS(564),
    [anon_sym_PLUS] = ACTIONS(566),
    [anon_sym_DASH] = ACTIONS(566),
    [anon_sym_BANG] = ACTIONS(564),
    [anon_sym_TILDE] = ACTIONS(564),
    [anon_sym_PLUS_PLUS] = ACTIONS(564),
    [anon_sym_DASH_DASH] = ACTIONS(564),
    [anon_sym_new] = ACTIONS(566),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_SEMI] = ACTIONS(564),
    [anon_sym_LBRACE] = ACTIONS(564),
    [anon_sym_RBRACE] = ACTIONS(564),
    [anon_sym_assert] = ACTIONS(566),
    [anon_sym_switch] = ACTIONS(566),
    [anon_sym_case] = ACTIONS(566),
    [anon_sym_default] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_break] = ACTIONS(566),
    [anon_sym_continue] = ACTIONS(566),
    [anon_sym_return] = ACTIONS(566),
    [anon_sym_synchronized] = ACTIONS(566),
    [anon_sym_throw] = ACTIONS(566),
    [anon_sym_try] = ACTIONS(566),
    [anon_sym_if] = ACTIONS(566),
    [anon_sym_else] = ACTIONS(566),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_AT] = ACTIONS(566),
    [anon_sym_open] = ACTIONS(566),
    [anon_sym_module] = ACTIONS(566),
    [anon_sym_static] = ACTIONS(566),
    [anon_sym_package] = ACTIONS(566),
    [anon_sym_import] = ACTIONS(566),
    [anon_sym_enum] = ACTIONS(566),
    [anon_sym_public] = ACTIONS(566),
    [anon_sym_protected] = ACTIONS(566),
    [anon_sym_private] = ACTIONS(566),
    [anon_sym_abstract] = ACTIONS(566),
    [anon_sym_final] = ACTIONS(566),
    [anon_sym_strictfp] = ACTIONS(566),
    [anon_sym_native] = ACTIONS(566),
    [anon_sym_transient] = ACTIONS(566),
    [anon_sym_volatile] = ACTIONS(566),
    [anon_sym_ATinterface] = ACTIONS(564),
    [anon_sym_interface] = ACTIONS(566),
    [anon_sym_byte] = ACTIONS(566),
    [anon_sym_short] = ACTIONS(566),
    [anon_sym_int] = ACTIONS(566),
    [anon_sym_long] = ACTIONS(566),
    [anon_sym_char] = ACTIONS(566),
    [anon_sym_float] = ACTIONS(566),
    [anon_sym_double] = ACTIONS(566),
    [sym_boolean_type] = ACTIONS(566),
    [sym_void_type] = ACTIONS(566),
    [sym_this] = ACTIONS(566),
    [sym_super] = ACTIONS(566),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [ts_builtin_sym_end] = ACTIONS(568),
    [sym_identifier] = ACTIONS(570),
    [sym_decimal_integer_literal] = ACTIONS(570),
    [sym_hex_integer_literal] = ACTIONS(570),
    [sym_octal_integer_literal] = ACTIONS(568),
    [sym_binary_integer_literal] = ACTIONS(568),
    [sym_decimal_floating_point_literal] = ACTIONS(568),
    [sym_hex_floating_point_literal] = ACTIONS(570),
    [sym_true] = ACTIONS(570),
    [sym_false] = ACTIONS(570),
    [sym_character_literal] = ACTIONS(568),
    [sym_string_literal] = ACTIONS(568),
    [sym_null_literal] = ACTIONS(570),
    [anon_sym_LPAREN] = ACTIONS(568),
    [anon_sym_LT] = ACTIONS(568),
    [anon_sym_PLUS] = ACTIONS(570),
    [anon_sym_DASH] = ACTIONS(570),
    [anon_sym_BANG] = ACTIONS(568),
    [anon_sym_TILDE] = ACTIONS(568),
    [anon_sym_PLUS_PLUS] = ACTIONS(568),
    [anon_sym_DASH_DASH] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_class] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(568),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_RBRACE] = ACTIONS(568),
    [anon_sym_assert] = ACTIONS(570),
    [anon_sym_switch] = ACTIONS(570),
    [anon_sym_case] = ACTIONS(570),
    [anon_sym_default] = ACTIONS(570),
    [anon_sym_do] = ACTIONS(570),
    [anon_sym_while] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(570),
    [anon_sym_continue] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(570),
    [anon_sym_synchronized] = ACTIONS(570),
    [anon_sym_throw] = ACTIONS(570),
    [anon_sym_try] = ACTIONS(570),
    [anon_sym_if] = ACTIONS(570),
    [anon_sym_else] = ACTIONS(570),
    [anon_sym_for] = ACTIONS(570),
    [anon_sym_AT] = ACTIONS(570),
    [anon_sym_open] = ACTIONS(570),
    [anon_sym_module] = ACTIONS(570),
    [anon_sym_static] = ACTIONS(570),
    [anon_sym_package] = ACTIONS(570),
    [anon_sym_import] = ACTIONS(570),
    [anon_sym_enum] = ACTIONS(570),
    [anon_sym_public] = ACTIONS(570),
    [anon_sym_protected] = ACTIONS(570),
    [anon_sym_private] = ACTIONS(570),
    [anon_sym_abstract] = ACTIONS(570),
    [anon_sym_final] = ACTIONS(570),
    [anon_sym_strictfp] = ACTIONS(570),
    [anon_sym_native] = ACTIONS(570),
    [anon_sym_transient] = ACTIONS(570),
    [anon_sym_volatile] = ACTIONS(570),
    [anon_sym_ATinterface] = ACTIONS(568),
    [anon_sym_interface] = ACTIONS(570),
    [anon_sym_byte] = ACTIONS(570),
    [anon_sym_short] = ACTIONS(570),
    [anon_sym_int] = ACTIONS(570),
    [anon_sym_long] = ACTIONS(570),
    [anon_sym_char] = ACTIONS(570),
    [anon_sym_float] = ACTIONS(570),
    [anon_sym_double] = ACTIONS(570),
    [sym_boolean_type] = ACTIONS(570),
    [sym_void_type] = ACTIONS(570),
    [sym_this] = ACTIONS(570),
    [sym_super] = ACTIONS(570),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [ts_builtin_sym_end] = ACTIONS(572),
    [sym_identifier] = ACTIONS(574),
    [sym_decimal_integer_literal] = ACTIONS(574),
    [sym_hex_integer_literal] = ACTIONS(574),
    [sym_octal_integer_literal] = ACTIONS(572),
    [sym_binary_integer_literal] = ACTIONS(572),
    [sym_decimal_floating_point_literal] = ACTIONS(572),
    [sym_hex_floating_point_literal] = ACTIONS(574),
    [sym_true] = ACTIONS(574),
    [sym_false] = ACTIONS(574),
    [sym_character_literal] = ACTIONS(572),
    [sym_string_literal] = ACTIONS(572),
    [sym_null_literal] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(572),
    [anon_sym_LT] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(574),
    [anon_sym_DASH] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(572),
    [anon_sym_TILDE] = ACTIONS(572),
    [anon_sym_PLUS_PLUS] = ACTIONS(572),
    [anon_sym_DASH_DASH] = ACTIONS(572),
    [anon_sym_new] = ACTIONS(574),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(572),
    [anon_sym_RBRACE] = ACTIONS(572),
    [anon_sym_assert] = ACTIONS(574),
    [anon_sym_switch] = ACTIONS(574),
    [anon_sym_case] = ACTIONS(574),
    [anon_sym_default] = ACTIONS(574),
    [anon_sym_do] = ACTIONS(574),
    [anon_sym_while] = ACTIONS(574),
    [anon_sym_break] = ACTIONS(574),
    [anon_sym_continue] = ACTIONS(574),
    [anon_sym_return] = ACTIONS(574),
    [anon_sym_synchronized] = ACTIONS(574),
    [anon_sym_throw] = ACTIONS(574),
    [anon_sym_try] = ACTIONS(574),
    [anon_sym_if] = ACTIONS(574),
    [anon_sym_else] = ACTIONS(574),
    [anon_sym_for] = ACTIONS(574),
    [anon_sym_AT] = ACTIONS(574),
    [anon_sym_open] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(574),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_package] = ACTIONS(574),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_enum] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(574),
    [anon_sym_final] = ACTIONS(574),
    [anon_sym_strictfp] = ACTIONS(574),
    [anon_sym_native] = ACTIONS(574),
    [anon_sym_transient] = ACTIONS(574),
    [anon_sym_volatile] = ACTIONS(574),
    [anon_sym_ATinterface] = ACTIONS(572),
    [anon_sym_interface] = ACTIONS(574),
    [anon_sym_byte] = ACTIONS(574),
    [anon_sym_short] = ACTIONS(574),
    [anon_sym_int] = ACTIONS(574),
    [anon_sym_long] = ACTIONS(574),
    [anon_sym_char] = ACTIONS(574),
    [anon_sym_float] = ACTIONS(574),
    [anon_sym_double] = ACTIONS(574),
    [sym_boolean_type] = ACTIONS(574),
    [sym_void_type] = ACTIONS(574),
    [sym_this] = ACTIONS(574),
    [sym_super] = ACTIONS(574),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [ts_builtin_sym_end] = ACTIONS(576),
    [sym_identifier] = ACTIONS(578),
    [sym_decimal_integer_literal] = ACTIONS(578),
    [sym_hex_integer_literal] = ACTIONS(578),
    [sym_octal_integer_literal] = ACTIONS(576),
    [sym_binary_integer_literal] = ACTIONS(576),
    [sym_decimal_floating_point_literal] = ACTIONS(576),
    [sym_hex_floating_point_literal] = ACTIONS(578),
    [sym_true] = ACTIONS(578),
    [sym_false] = ACTIONS(578),
    [sym_character_literal] = ACTIONS(576),
    [sym_string_literal] = ACTIONS(576),
    [sym_null_literal] = ACTIONS(578),
    [anon_sym_LPAREN] = ACTIONS(576),
    [anon_sym_LT] = ACTIONS(576),
    [anon_sym_PLUS] = ACTIONS(578),
    [anon_sym_DASH] = ACTIONS(578),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_PLUS_PLUS] = ACTIONS(576),
    [anon_sym_DASH_DASH] = ACTIONS(576),
    [anon_sym_new] = ACTIONS(578),
    [anon_sym_class] = ACTIONS(578),
    [anon_sym_SEMI] = ACTIONS(576),
    [anon_sym_LBRACE] = ACTIONS(576),
    [anon_sym_RBRACE] = ACTIONS(576),
    [anon_sym_assert] = ACTIONS(578),
    [anon_sym_switch] = ACTIONS(578),
    [anon_sym_case] = ACTIONS(578),
    [anon_sym_default] = ACTIONS(578),
    [anon_sym_do] = ACTIONS(578),
    [anon_sym_while] = ACTIONS(578),
    [anon_sym_break] = ACTIONS(578),
    [anon_sym_continue] = ACTIONS(578),
    [anon_sym_return] = ACTIONS(578),
    [anon_sym_synchronized] = ACTIONS(578),
    [anon_sym_throw] = ACTIONS(578),
    [anon_sym_try] = ACTIONS(578),
    [anon_sym_if] = ACTIONS(578),
    [anon_sym_else] = ACTIONS(578),
    [anon_sym_for] = ACTIONS(578),
    [anon_sym_AT] = ACTIONS(578),
    [anon_sym_open] = ACTIONS(578),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_static] = ACTIONS(578),
    [anon_sym_package] = ACTIONS(578),
    [anon_sym_import] = ACTIONS(578),
    [anon_sym_enum] = ACTIONS(578),
    [anon_sym_public] = ACTIONS(578),
    [anon_sym_protected] = ACTIONS(578),
    [anon_sym_private] = ACTIONS(578),
    [anon_sym_abstract] = ACTIONS(578),
    [anon_sym_final] = ACTIONS(578),
    [anon_sym_strictfp] = ACTIONS(578),
    [anon_sym_native] = ACTIONS(578),
    [anon_sym_transient] = ACTIONS(578),
    [anon_sym_volatile] = ACTIONS(578),
    [anon_sym_ATinterface] = ACTIONS(576),
    [anon_sym_interface] = ACTIONS(578),
    [anon_sym_byte] = ACTIONS(578),
    [anon_sym_short] = ACTIONS(578),
    [anon_sym_int] = ACTIONS(578),
    [anon_sym_long] = ACTIONS(578),
    [anon_sym_char] = ACTIONS(578),
    [anon_sym_float] = ACTIONS(578),
    [anon_sym_double] = ACTIONS(578),
    [sym_boolean_type] = ACTIONS(578),
    [sym_void_type] = ACTIONS(578),
    [sym_this] = ACTIONS(578),
    [sym_super] = ACTIONS(578),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [ts_builtin_sym_end] = ACTIONS(580),
    [sym_identifier] = ACTIONS(582),
    [sym_decimal_integer_literal] = ACTIONS(582),
    [sym_hex_integer_literal] = ACTIONS(582),
    [sym_octal_integer_literal] = ACTIONS(580),
    [sym_binary_integer_literal] = ACTIONS(580),
    [sym_decimal_floating_point_literal] = ACTIONS(580),
    [sym_hex_floating_point_literal] = ACTIONS(582),
    [sym_true] = ACTIONS(582),
    [sym_false] = ACTIONS(582),
    [sym_character_literal] = ACTIONS(580),
    [sym_string_literal] = ACTIONS(580),
    [sym_null_literal] = ACTIONS(582),
    [anon_sym_LPAREN] = ACTIONS(580),
    [anon_sym_LT] = ACTIONS(580),
    [anon_sym_PLUS] = ACTIONS(582),
    [anon_sym_DASH] = ACTIONS(582),
    [anon_sym_BANG] = ACTIONS(580),
    [anon_sym_TILDE] = ACTIONS(580),
    [anon_sym_PLUS_PLUS] = ACTIONS(580),
    [anon_sym_DASH_DASH] = ACTIONS(580),
    [anon_sym_new] = ACTIONS(582),
    [anon_sym_class] = ACTIONS(582),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_LBRACE] = ACTIONS(580),
    [anon_sym_RBRACE] = ACTIONS(580),
    [anon_sym_assert] = ACTIONS(582),
    [anon_sym_switch] = ACTIONS(582),
    [anon_sym_case] = ACTIONS(582),
    [anon_sym_default] = ACTIONS(582),
    [anon_sym_do] = ACTIONS(582),
    [anon_sym_while] = ACTIONS(582),
    [anon_sym_break] = ACTIONS(582),
    [anon_sym_continue] = ACTIONS(582),
    [anon_sym_return] = ACTIONS(582),
    [anon_sym_synchronized] = ACTIONS(582),
    [anon_sym_throw] = ACTIONS(582),
    [anon_sym_try] = ACTIONS(582),
    [anon_sym_if] = ACTIONS(582),
    [anon_sym_else] = ACTIONS(582),
    [anon_sym_for] = ACTIONS(582),
    [anon_sym_AT] = ACTIONS(582),
    [anon_sym_open] = ACTIONS(582),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_static] = ACTIONS(582),
    [anon_sym_package] = ACTIONS(582),
    [anon_sym_import] = ACTIONS(582),
    [anon_sym_enum] = ACTIONS(582),
    [anon_sym_public] = ACTIONS(582),
    [anon_sym_protected] = ACTIONS(582),
    [anon_sym_private] = ACTIONS(582),
    [anon_sym_abstract] = ACTIONS(582),
    [anon_sym_final] = ACTIONS(582),
    [anon_sym_strictfp] = ACTIONS(582),
    [anon_sym_native] = ACTIONS(582),
    [anon_sym_transient] = ACTIONS(582),
    [anon_sym_volatile] = ACTIONS(582),
    [anon_sym_ATinterface] = ACTIONS(580),
    [anon_sym_interface] = ACTIONS(582),
    [anon_sym_byte] = ACTIONS(582),
    [anon_sym_short] = ACTIONS(582),
    [anon_sym_int] = ACTIONS(582),
    [anon_sym_long] = ACTIONS(582),
    [anon_sym_char] = ACTIONS(582),
    [anon_sym_float] = ACTIONS(582),
    [anon_sym_double] = ACTIONS(582),
    [sym_boolean_type] = ACTIONS(582),
    [sym_void_type] = ACTIONS(582),
    [sym_this] = ACTIONS(582),
    [sym_super] = ACTIONS(582),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [ts_builtin_sym_end] = ACTIONS(584),
    [sym_identifier] = ACTIONS(586),
    [sym_decimal_integer_literal] = ACTIONS(586),
    [sym_hex_integer_literal] = ACTIONS(586),
    [sym_octal_integer_literal] = ACTIONS(584),
    [sym_binary_integer_literal] = ACTIONS(584),
    [sym_decimal_floating_point_literal] = ACTIONS(584),
    [sym_hex_floating_point_literal] = ACTIONS(586),
    [sym_true] = ACTIONS(586),
    [sym_false] = ACTIONS(586),
    [sym_character_literal] = ACTIONS(584),
    [sym_string_literal] = ACTIONS(584),
    [sym_null_literal] = ACTIONS(586),
    [anon_sym_LPAREN] = ACTIONS(584),
    [anon_sym_LT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(586),
    [anon_sym_DASH] = ACTIONS(586),
    [anon_sym_BANG] = ACTIONS(584),
    [anon_sym_TILDE] = ACTIONS(584),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_new] = ACTIONS(586),
    [anon_sym_class] = ACTIONS(586),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(584),
    [anon_sym_assert] = ACTIONS(586),
    [anon_sym_switch] = ACTIONS(586),
    [anon_sym_case] = ACTIONS(586),
    [anon_sym_default] = ACTIONS(586),
    [anon_sym_do] = ACTIONS(586),
    [anon_sym_while] = ACTIONS(586),
    [anon_sym_break] = ACTIONS(586),
    [anon_sym_continue] = ACTIONS(586),
    [anon_sym_return] = ACTIONS(586),
    [anon_sym_synchronized] = ACTIONS(586),
    [anon_sym_throw] = ACTIONS(586),
    [anon_sym_try] = ACTIONS(586),
    [anon_sym_if] = ACTIONS(586),
    [anon_sym_else] = ACTIONS(586),
    [anon_sym_for] = ACTIONS(586),
    [anon_sym_AT] = ACTIONS(586),
    [anon_sym_open] = ACTIONS(586),
    [anon_sym_module] = ACTIONS(586),
    [anon_sym_static] = ACTIONS(586),
    [anon_sym_package] = ACTIONS(586),
    [anon_sym_import] = ACTIONS(586),
    [anon_sym_enum] = ACTIONS(586),
    [anon_sym_public] = ACTIONS(586),
    [anon_sym_protected] = ACTIONS(586),
    [anon_sym_private] = ACTIONS(586),
    [anon_sym_abstract] = ACTIONS(586),
    [anon_sym_final] = ACTIONS(586),
    [anon_sym_strictfp] = ACTIONS(586),
    [anon_sym_native] = ACTIONS(586),
    [anon_sym_transient] = ACTIONS(586),
    [anon_sym_volatile] = ACTIONS(586),
    [anon_sym_ATinterface] = ACTIONS(584),
    [anon_sym_interface] = ACTIONS(586),
    [anon_sym_byte] = ACTIONS(586),
    [anon_sym_short] = ACTIONS(586),
    [anon_sym_int] = ACTIONS(586),
    [anon_sym_long] = ACTIONS(586),
    [anon_sym_char] = ACTIONS(586),
    [anon_sym_float] = ACTIONS(586),
    [anon_sym_double] = ACTIONS(586),
    [sym_boolean_type] = ACTIONS(586),
    [sym_void_type] = ACTIONS(586),
    [sym_this] = ACTIONS(586),
    [sym_super] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [ts_builtin_sym_end] = ACTIONS(588),
    [sym_identifier] = ACTIONS(590),
    [sym_decimal_integer_literal] = ACTIONS(590),
    [sym_hex_integer_literal] = ACTIONS(590),
    [sym_octal_integer_literal] = ACTIONS(588),
    [sym_binary_integer_literal] = ACTIONS(588),
    [sym_decimal_floating_point_literal] = ACTIONS(588),
    [sym_hex_floating_point_literal] = ACTIONS(590),
    [sym_true] = ACTIONS(590),
    [sym_false] = ACTIONS(590),
    [sym_character_literal] = ACTIONS(588),
    [sym_string_literal] = ACTIONS(588),
    [sym_null_literal] = ACTIONS(590),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(590),
    [anon_sym_DASH] = ACTIONS(590),
    [anon_sym_BANG] = ACTIONS(588),
    [anon_sym_TILDE] = ACTIONS(588),
    [anon_sym_PLUS_PLUS] = ACTIONS(588),
    [anon_sym_DASH_DASH] = ACTIONS(588),
    [anon_sym_new] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(590),
    [anon_sym_SEMI] = ACTIONS(588),
    [anon_sym_LBRACE] = ACTIONS(588),
    [anon_sym_RBRACE] = ACTIONS(588),
    [anon_sym_assert] = ACTIONS(590),
    [anon_sym_switch] = ACTIONS(590),
    [anon_sym_case] = ACTIONS(590),
    [anon_sym_default] = ACTIONS(590),
    [anon_sym_do] = ACTIONS(590),
    [anon_sym_while] = ACTIONS(590),
    [anon_sym_break] = ACTIONS(590),
    [anon_sym_continue] = ACTIONS(590),
    [anon_sym_return] = ACTIONS(590),
    [anon_sym_synchronized] = ACTIONS(590),
    [anon_sym_throw] = ACTIONS(590),
    [anon_sym_try] = ACTIONS(590),
    [anon_sym_if] = ACTIONS(590),
    [anon_sym_else] = ACTIONS(590),
    [anon_sym_for] = ACTIONS(590),
    [anon_sym_AT] = ACTIONS(590),
    [anon_sym_open] = ACTIONS(590),
    [anon_sym_module] = ACTIONS(590),
    [anon_sym_static] = ACTIONS(590),
    [anon_sym_package] = ACTIONS(590),
    [anon_sym_import] = ACTIONS(590),
    [anon_sym_enum] = ACTIONS(590),
    [anon_sym_public] = ACTIONS(590),
    [anon_sym_protected] = ACTIONS(590),
    [anon_sym_private] = ACTIONS(590),
    [anon_sym_abstract] = ACTIONS(590),
    [anon_sym_final] = ACTIONS(590),
    [anon_sym_strictfp] = ACTIONS(590),
    [anon_sym_native] = ACTIONS(590),
    [anon_sym_transient] = ACTIONS(590),
    [anon_sym_volatile] = ACTIONS(590),
    [anon_sym_ATinterface] = ACTIONS(588),
    [anon_sym_interface] = ACTIONS(590),
    [anon_sym_byte] = ACTIONS(590),
    [anon_sym_short] = ACTIONS(590),
    [anon_sym_int] = ACTIONS(590),
    [anon_sym_long] = ACTIONS(590),
    [anon_sym_char] = ACTIONS(590),
    [anon_sym_float] = ACTIONS(590),
    [anon_sym_double] = ACTIONS(590),
    [sym_boolean_type] = ACTIONS(590),
    [sym_void_type] = ACTIONS(590),
    [sym_this] = ACTIONS(590),
    [sym_super] = ACTIONS(590),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [ts_builtin_sym_end] = ACTIONS(592),
    [sym_identifier] = ACTIONS(594),
    [sym_decimal_integer_literal] = ACTIONS(594),
    [sym_hex_integer_literal] = ACTIONS(594),
    [sym_octal_integer_literal] = ACTIONS(592),
    [sym_binary_integer_literal] = ACTIONS(592),
    [sym_decimal_floating_point_literal] = ACTIONS(592),
    [sym_hex_floating_point_literal] = ACTIONS(594),
    [sym_true] = ACTIONS(594),
    [sym_false] = ACTIONS(594),
    [sym_character_literal] = ACTIONS(592),
    [sym_string_literal] = ACTIONS(592),
    [sym_null_literal] = ACTIONS(594),
    [anon_sym_LPAREN] = ACTIONS(592),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(594),
    [anon_sym_DASH] = ACTIONS(594),
    [anon_sym_BANG] = ACTIONS(592),
    [anon_sym_TILDE] = ACTIONS(592),
    [anon_sym_PLUS_PLUS] = ACTIONS(592),
    [anon_sym_DASH_DASH] = ACTIONS(592),
    [anon_sym_new] = ACTIONS(594),
    [anon_sym_class] = ACTIONS(594),
    [anon_sym_SEMI] = ACTIONS(592),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_RBRACE] = ACTIONS(592),
    [anon_sym_assert] = ACTIONS(594),
    [anon_sym_switch] = ACTIONS(594),
    [anon_sym_case] = ACTIONS(594),
    [anon_sym_default] = ACTIONS(594),
    [anon_sym_do] = ACTIONS(594),
    [anon_sym_while] = ACTIONS(594),
    [anon_sym_break] = ACTIONS(594),
    [anon_sym_continue] = ACTIONS(594),
    [anon_sym_return] = ACTIONS(594),
    [anon_sym_synchronized] = ACTIONS(594),
    [anon_sym_throw] = ACTIONS(594),
    [anon_sym_try] = ACTIONS(594),
    [anon_sym_if] = ACTIONS(594),
    [anon_sym_else] = ACTIONS(594),
    [anon_sym_for] = ACTIONS(594),
    [anon_sym_AT] = ACTIONS(594),
    [anon_sym_open] = ACTIONS(594),
    [anon_sym_module] = ACTIONS(594),
    [anon_sym_static] = ACTIONS(594),
    [anon_sym_package] = ACTIONS(594),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_enum] = ACTIONS(594),
    [anon_sym_public] = ACTIONS(594),
    [anon_sym_protected] = ACTIONS(594),
    [anon_sym_private] = ACTIONS(594),
    [anon_sym_abstract] = ACTIONS(594),
    [anon_sym_final] = ACTIONS(594),
    [anon_sym_strictfp] = ACTIONS(594),
    [anon_sym_native] = ACTIONS(594),
    [anon_sym_transient] = ACTIONS(594),
    [anon_sym_volatile] = ACTIONS(594),
    [anon_sym_ATinterface] = ACTIONS(592),
    [anon_sym_interface] = ACTIONS(594),
    [anon_sym_byte] = ACTIONS(594),
    [anon_sym_short] = ACTIONS(594),
    [anon_sym_int] = ACTIONS(594),
    [anon_sym_long] = ACTIONS(594),
    [anon_sym_char] = ACTIONS(594),
    [anon_sym_float] = ACTIONS(594),
    [anon_sym_double] = ACTIONS(594),
    [sym_boolean_type] = ACTIONS(594),
    [sym_void_type] = ACTIONS(594),
    [sym_this] = ACTIONS(594),
    [sym_super] = ACTIONS(594),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [ts_builtin_sym_end] = ACTIONS(596),
    [sym_identifier] = ACTIONS(598),
    [sym_decimal_integer_literal] = ACTIONS(598),
    [sym_hex_integer_literal] = ACTIONS(598),
    [sym_octal_integer_literal] = ACTIONS(596),
    [sym_binary_integer_literal] = ACTIONS(596),
    [sym_decimal_floating_point_literal] = ACTIONS(596),
    [sym_hex_floating_point_literal] = ACTIONS(598),
    [sym_true] = ACTIONS(598),
    [sym_false] = ACTIONS(598),
    [sym_character_literal] = ACTIONS(596),
    [sym_string_literal] = ACTIONS(596),
    [sym_null_literal] = ACTIONS(598),
    [anon_sym_LPAREN] = ACTIONS(596),
    [anon_sym_LT] = ACTIONS(596),
    [anon_sym_PLUS] = ACTIONS(598),
    [anon_sym_DASH] = ACTIONS(598),
    [anon_sym_BANG] = ACTIONS(596),
    [anon_sym_TILDE] = ACTIONS(596),
    [anon_sym_PLUS_PLUS] = ACTIONS(596),
    [anon_sym_DASH_DASH] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_class] = ACTIONS(598),
    [anon_sym_SEMI] = ACTIONS(596),
    [anon_sym_LBRACE] = ACTIONS(596),
    [anon_sym_RBRACE] = ACTIONS(596),
    [anon_sym_assert] = ACTIONS(598),
    [anon_sym_switch] = ACTIONS(598),
    [anon_sym_case] = ACTIONS(598),
    [anon_sym_default] = ACTIONS(598),
    [anon_sym_do] = ACTIONS(598),
    [anon_sym_while] = ACTIONS(598),
    [anon_sym_break] = ACTIONS(598),
    [anon_sym_continue] = ACTIONS(598),
    [anon_sym_return] = ACTIONS(598),
    [anon_sym_synchronized] = ACTIONS(598),
    [anon_sym_throw] = ACTIONS(598),
    [anon_sym_try] = ACTIONS(598),
    [anon_sym_if] = ACTIONS(598),
    [anon_sym_else] = ACTIONS(598),
    [anon_sym_for] = ACTIONS(598),
    [anon_sym_AT] = ACTIONS(598),
    [anon_sym_open] = ACTIONS(598),
    [anon_sym_module] = ACTIONS(598),
    [anon_sym_static] = ACTIONS(598),
    [anon_sym_package] = ACTIONS(598),
    [anon_sym_import] = ACTIONS(598),
    [anon_sym_enum] = ACTIONS(598),
    [anon_sym_public] = ACTIONS(598),
    [anon_sym_protected] = ACTIONS(598),
    [anon_sym_private] = ACTIONS(598),
    [anon_sym_abstract] = ACTIONS(598),
    [anon_sym_final] = ACTIONS(598),
    [anon_sym_strictfp] = ACTIONS(598),
    [anon_sym_native] = ACTIONS(598),
    [anon_sym_transient] = ACTIONS(598),
    [anon_sym_volatile] = ACTIONS(598),
    [anon_sym_ATinterface] = ACTIONS(596),
    [anon_sym_interface] = ACTIONS(598),
    [anon_sym_byte] = ACTIONS(598),
    [anon_sym_short] = ACTIONS(598),
    [anon_sym_int] = ACTIONS(598),
    [anon_sym_long] = ACTIONS(598),
    [anon_sym_char] = ACTIONS(598),
    [anon_sym_float] = ACTIONS(598),
    [anon_sym_double] = ACTIONS(598),
    [sym_boolean_type] = ACTIONS(598),
    [sym_void_type] = ACTIONS(598),
    [sym_this] = ACTIONS(598),
    [sym_super] = ACTIONS(598),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [ts_builtin_sym_end] = ACTIONS(600),
    [sym_identifier] = ACTIONS(602),
    [sym_decimal_integer_literal] = ACTIONS(602),
    [sym_hex_integer_literal] = ACTIONS(602),
    [sym_octal_integer_literal] = ACTIONS(600),
    [sym_binary_integer_literal] = ACTIONS(600),
    [sym_decimal_floating_point_literal] = ACTIONS(600),
    [sym_hex_floating_point_literal] = ACTIONS(602),
    [sym_true] = ACTIONS(602),
    [sym_false] = ACTIONS(602),
    [sym_character_literal] = ACTIONS(600),
    [sym_string_literal] = ACTIONS(600),
    [sym_null_literal] = ACTIONS(602),
    [anon_sym_LPAREN] = ACTIONS(600),
    [anon_sym_LT] = ACTIONS(600),
    [anon_sym_PLUS] = ACTIONS(602),
    [anon_sym_DASH] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(600),
    [anon_sym_TILDE] = ACTIONS(600),
    [anon_sym_PLUS_PLUS] = ACTIONS(600),
    [anon_sym_DASH_DASH] = ACTIONS(600),
    [anon_sym_new] = ACTIONS(602),
    [anon_sym_class] = ACTIONS(602),
    [anon_sym_SEMI] = ACTIONS(600),
    [anon_sym_LBRACE] = ACTIONS(600),
    [anon_sym_RBRACE] = ACTIONS(600),
    [anon_sym_assert] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(602),
    [anon_sym_case] = ACTIONS(602),
    [anon_sym_default] = ACTIONS(602),
    [anon_sym_do] = ACTIONS(602),
    [anon_sym_while] = ACTIONS(602),
    [anon_sym_break] = ACTIONS(602),
    [anon_sym_continue] = ACTIONS(602),
    [anon_sym_return] = ACTIONS(602),
    [anon_sym_synchronized] = ACTIONS(602),
    [anon_sym_throw] = ACTIONS(602),
    [anon_sym_try] = ACTIONS(602),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_else] = ACTIONS(602),
    [anon_sym_for] = ACTIONS(602),
    [anon_sym_AT] = ACTIONS(602),
    [anon_sym_open] = ACTIONS(602),
    [anon_sym_module] = ACTIONS(602),
    [anon_sym_static] = ACTIONS(602),
    [anon_sym_package] = ACTIONS(602),
    [anon_sym_import] = ACTIONS(602),
    [anon_sym_enum] = ACTIONS(602),
    [anon_sym_public] = ACTIONS(602),
    [anon_sym_protected] = ACTIONS(602),
    [anon_sym_private] = ACTIONS(602),
    [anon_sym_abstract] = ACTIONS(602),
    [anon_sym_final] = ACTIONS(602),
    [anon_sym_strictfp] = ACTIONS(602),
    [anon_sym_native] = ACTIONS(602),
    [anon_sym_transient] = ACTIONS(602),
    [anon_sym_volatile] = ACTIONS(602),
    [anon_sym_ATinterface] = ACTIONS(600),
    [anon_sym_interface] = ACTIONS(602),
    [anon_sym_byte] = ACTIONS(602),
    [anon_sym_short] = ACTIONS(602),
    [anon_sym_int] = ACTIONS(602),
    [anon_sym_long] = ACTIONS(602),
    [anon_sym_char] = ACTIONS(602),
    [anon_sym_float] = ACTIONS(602),
    [anon_sym_double] = ACTIONS(602),
    [sym_boolean_type] = ACTIONS(602),
    [sym_void_type] = ACTIONS(602),
    [sym_this] = ACTIONS(602),
    [sym_super] = ACTIONS(602),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [ts_builtin_sym_end] = ACTIONS(604),
    [sym_identifier] = ACTIONS(606),
    [sym_decimal_integer_literal] = ACTIONS(606),
    [sym_hex_integer_literal] = ACTIONS(606),
    [sym_octal_integer_literal] = ACTIONS(604),
    [sym_binary_integer_literal] = ACTIONS(604),
    [sym_decimal_floating_point_literal] = ACTIONS(604),
    [sym_hex_floating_point_literal] = ACTIONS(606),
    [sym_true] = ACTIONS(606),
    [sym_false] = ACTIONS(606),
    [sym_character_literal] = ACTIONS(604),
    [sym_string_literal] = ACTIONS(604),
    [sym_null_literal] = ACTIONS(606),
    [anon_sym_LPAREN] = ACTIONS(604),
    [anon_sym_LT] = ACTIONS(604),
    [anon_sym_PLUS] = ACTIONS(606),
    [anon_sym_DASH] = ACTIONS(606),
    [anon_sym_BANG] = ACTIONS(604),
    [anon_sym_TILDE] = ACTIONS(604),
    [anon_sym_PLUS_PLUS] = ACTIONS(604),
    [anon_sym_DASH_DASH] = ACTIONS(604),
    [anon_sym_new] = ACTIONS(606),
    [anon_sym_class] = ACTIONS(606),
    [anon_sym_SEMI] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(604),
    [anon_sym_RBRACE] = ACTIONS(604),
    [anon_sym_assert] = ACTIONS(606),
    [anon_sym_switch] = ACTIONS(606),
    [anon_sym_case] = ACTIONS(606),
    [anon_sym_default] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(606),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_break] = ACTIONS(606),
    [anon_sym_continue] = ACTIONS(606),
    [anon_sym_return] = ACTIONS(606),
    [anon_sym_synchronized] = ACTIONS(606),
    [anon_sym_throw] = ACTIONS(606),
    [anon_sym_try] = ACTIONS(606),
    [anon_sym_if] = ACTIONS(606),
    [anon_sym_else] = ACTIONS(606),
    [anon_sym_for] = ACTIONS(606),
    [anon_sym_AT] = ACTIONS(606),
    [anon_sym_open] = ACTIONS(606),
    [anon_sym_module] = ACTIONS(606),
    [anon_sym_static] = ACTIONS(606),
    [anon_sym_package] = ACTIONS(606),
    [anon_sym_import] = ACTIONS(606),
    [anon_sym_enum] = ACTIONS(606),
    [anon_sym_public] = ACTIONS(606),
    [anon_sym_protected] = ACTIONS(606),
    [anon_sym_private] = ACTIONS(606),
    [anon_sym_abstract] = ACTIONS(606),
    [anon_sym_final] = ACTIONS(606),
    [anon_sym_strictfp] = ACTIONS(606),
    [anon_sym_native] = ACTIONS(606),
    [anon_sym_transient] = ACTIONS(606),
    [anon_sym_volatile] = ACTIONS(606),
    [anon_sym_ATinterface] = ACTIONS(604),
    [anon_sym_interface] = ACTIONS(606),
    [anon_sym_byte] = ACTIONS(606),
    [anon_sym_short] = ACTIONS(606),
    [anon_sym_int] = ACTIONS(606),
    [anon_sym_long] = ACTIONS(606),
    [anon_sym_char] = ACTIONS(606),
    [anon_sym_float] = ACTIONS(606),
    [anon_sym_double] = ACTIONS(606),
    [sym_boolean_type] = ACTIONS(606),
    [sym_void_type] = ACTIONS(606),
    [sym_this] = ACTIONS(606),
    [sym_super] = ACTIONS(606),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(608),
    [sym_identifier] = ACTIONS(610),
    [sym_decimal_integer_literal] = ACTIONS(610),
    [sym_hex_integer_literal] = ACTIONS(610),
    [sym_octal_integer_literal] = ACTIONS(608),
    [sym_binary_integer_literal] = ACTIONS(608),
    [sym_decimal_floating_point_literal] = ACTIONS(608),
    [sym_hex_floating_point_literal] = ACTIONS(610),
    [sym_true] = ACTIONS(610),
    [sym_false] = ACTIONS(610),
    [sym_character_literal] = ACTIONS(608),
    [sym_string_literal] = ACTIONS(608),
    [sym_null_literal] = ACTIONS(610),
    [anon_sym_LPAREN] = ACTIONS(608),
    [anon_sym_LT] = ACTIONS(608),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_DASH] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(608),
    [anon_sym_PLUS_PLUS] = ACTIONS(608),
    [anon_sym_DASH_DASH] = ACTIONS(608),
    [anon_sym_new] = ACTIONS(610),
    [anon_sym_class] = ACTIONS(610),
    [anon_sym_SEMI] = ACTIONS(608),
    [anon_sym_LBRACE] = ACTIONS(608),
    [anon_sym_RBRACE] = ACTIONS(608),
    [anon_sym_assert] = ACTIONS(610),
    [anon_sym_switch] = ACTIONS(610),
    [anon_sym_case] = ACTIONS(610),
    [anon_sym_default] = ACTIONS(610),
    [anon_sym_do] = ACTIONS(610),
    [anon_sym_while] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(610),
    [anon_sym_continue] = ACTIONS(610),
    [anon_sym_return] = ACTIONS(610),
    [anon_sym_synchronized] = ACTIONS(610),
    [anon_sym_throw] = ACTIONS(610),
    [anon_sym_try] = ACTIONS(610),
    [anon_sym_if] = ACTIONS(610),
    [anon_sym_else] = ACTIONS(610),
    [anon_sym_for] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_open] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_package] = ACTIONS(610),
    [anon_sym_import] = ACTIONS(610),
    [anon_sym_enum] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_abstract] = ACTIONS(610),
    [anon_sym_final] = ACTIONS(610),
    [anon_sym_strictfp] = ACTIONS(610),
    [anon_sym_native] = ACTIONS(610),
    [anon_sym_transient] = ACTIONS(610),
    [anon_sym_volatile] = ACTIONS(610),
    [anon_sym_ATinterface] = ACTIONS(608),
    [anon_sym_interface] = ACTIONS(610),
    [anon_sym_byte] = ACTIONS(610),
    [anon_sym_short] = ACTIONS(610),
    [anon_sym_int] = ACTIONS(610),
    [anon_sym_long] = ACTIONS(610),
    [anon_sym_char] = ACTIONS(610),
    [anon_sym_float] = ACTIONS(610),
    [anon_sym_double] = ACTIONS(610),
    [sym_boolean_type] = ACTIONS(610),
    [sym_void_type] = ACTIONS(610),
    [sym_this] = ACTIONS(610),
    [sym_super] = ACTIONS(610),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [ts_builtin_sym_end] = ACTIONS(612),
    [sym_identifier] = ACTIONS(614),
    [sym_decimal_integer_literal] = ACTIONS(614),
    [sym_hex_integer_literal] = ACTIONS(614),
    [sym_octal_integer_literal] = ACTIONS(612),
    [sym_binary_integer_literal] = ACTIONS(612),
    [sym_decimal_floating_point_literal] = ACTIONS(612),
    [sym_hex_floating_point_literal] = ACTIONS(614),
    [sym_true] = ACTIONS(614),
    [sym_false] = ACTIONS(614),
    [sym_character_literal] = ACTIONS(612),
    [sym_string_literal] = ACTIONS(612),
    [sym_null_literal] = ACTIONS(614),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(614),
    [anon_sym_DASH] = ACTIONS(614),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(612),
    [anon_sym_DASH_DASH] = ACTIONS(612),
    [anon_sym_new] = ACTIONS(614),
    [anon_sym_class] = ACTIONS(614),
    [anon_sym_SEMI] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(612),
    [anon_sym_RBRACE] = ACTIONS(612),
    [anon_sym_assert] = ACTIONS(614),
    [anon_sym_switch] = ACTIONS(614),
    [anon_sym_case] = ACTIONS(614),
    [anon_sym_default] = ACTIONS(614),
    [anon_sym_do] = ACTIONS(614),
    [anon_sym_while] = ACTIONS(614),
    [anon_sym_break] = ACTIONS(614),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_return] = ACTIONS(614),
    [anon_sym_synchronized] = ACTIONS(614),
    [anon_sym_throw] = ACTIONS(614),
    [anon_sym_try] = ACTIONS(614),
    [anon_sym_if] = ACTIONS(614),
    [anon_sym_else] = ACTIONS(614),
    [anon_sym_for] = ACTIONS(614),
    [anon_sym_AT] = ACTIONS(614),
    [anon_sym_open] = ACTIONS(614),
    [anon_sym_module] = ACTIONS(614),
    [anon_sym_static] = ACTIONS(614),
    [anon_sym_package] = ACTIONS(614),
    [anon_sym_import] = ACTIONS(614),
    [anon_sym_enum] = ACTIONS(614),
    [anon_sym_public] = ACTIONS(614),
    [anon_sym_protected] = ACTIONS(614),
    [anon_sym_private] = ACTIONS(614),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_final] = ACTIONS(614),
    [anon_sym_strictfp] = ACTIONS(614),
    [anon_sym_native] = ACTIONS(614),
    [anon_sym_transient] = ACTIONS(614),
    [anon_sym_volatile] = ACTIONS(614),
    [anon_sym_ATinterface] = ACTIONS(612),
    [anon_sym_interface] = ACTIONS(614),
    [anon_sym_byte] = ACTIONS(614),
    [anon_sym_short] = ACTIONS(614),
    [anon_sym_int] = ACTIONS(614),
    [anon_sym_long] = ACTIONS(614),
    [anon_sym_char] = ACTIONS(614),
    [anon_sym_float] = ACTIONS(614),
    [anon_sym_double] = ACTIONS(614),
    [sym_boolean_type] = ACTIONS(614),
    [sym_void_type] = ACTIONS(614),
    [sym_this] = ACTIONS(614),
    [sym_super] = ACTIONS(614),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(616),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(424),
    [sym_cast_expression] = STATE(424),
    [sym_assignment_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_instanceof_expression] = STATE(424),
    [sym_lambda_expression] = STATE(424),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(618),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [ts_builtin_sym_end] = ACTIONS(620),
    [sym_identifier] = ACTIONS(622),
    [sym_decimal_integer_literal] = ACTIONS(622),
    [sym_hex_integer_literal] = ACTIONS(622),
    [sym_octal_integer_literal] = ACTIONS(620),
    [sym_binary_integer_literal] = ACTIONS(620),
    [sym_decimal_floating_point_literal] = ACTIONS(620),
    [sym_hex_floating_point_literal] = ACTIONS(622),
    [sym_true] = ACTIONS(622),
    [sym_false] = ACTIONS(622),
    [sym_character_literal] = ACTIONS(620),
    [sym_string_literal] = ACTIONS(620),
    [sym_null_literal] = ACTIONS(622),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(622),
    [anon_sym_DASH] = ACTIONS(622),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(620),
    [anon_sym_PLUS_PLUS] = ACTIONS(620),
    [anon_sym_DASH_DASH] = ACTIONS(620),
    [anon_sym_new] = ACTIONS(622),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_RBRACE] = ACTIONS(620),
    [anon_sym_assert] = ACTIONS(622),
    [anon_sym_switch] = ACTIONS(622),
    [anon_sym_case] = ACTIONS(622),
    [anon_sym_default] = ACTIONS(622),
    [anon_sym_do] = ACTIONS(622),
    [anon_sym_while] = ACTIONS(622),
    [anon_sym_break] = ACTIONS(622),
    [anon_sym_continue] = ACTIONS(622),
    [anon_sym_return] = ACTIONS(622),
    [anon_sym_synchronized] = ACTIONS(622),
    [anon_sym_throw] = ACTIONS(622),
    [anon_sym_try] = ACTIONS(622),
    [anon_sym_if] = ACTIONS(622),
    [anon_sym_else] = ACTIONS(622),
    [anon_sym_for] = ACTIONS(622),
    [anon_sym_AT] = ACTIONS(622),
    [anon_sym_open] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(622),
    [anon_sym_static] = ACTIONS(622),
    [anon_sym_package] = ACTIONS(622),
    [anon_sym_import] = ACTIONS(622),
    [anon_sym_enum] = ACTIONS(622),
    [anon_sym_public] = ACTIONS(622),
    [anon_sym_protected] = ACTIONS(622),
    [anon_sym_private] = ACTIONS(622),
    [anon_sym_abstract] = ACTIONS(622),
    [anon_sym_final] = ACTIONS(622),
    [anon_sym_strictfp] = ACTIONS(622),
    [anon_sym_native] = ACTIONS(622),
    [anon_sym_transient] = ACTIONS(622),
    [anon_sym_volatile] = ACTIONS(622),
    [anon_sym_ATinterface] = ACTIONS(620),
    [anon_sym_interface] = ACTIONS(622),
    [anon_sym_byte] = ACTIONS(622),
    [anon_sym_short] = ACTIONS(622),
    [anon_sym_int] = ACTIONS(622),
    [anon_sym_long] = ACTIONS(622),
    [anon_sym_char] = ACTIONS(622),
    [anon_sym_float] = ACTIONS(622),
    [anon_sym_double] = ACTIONS(622),
    [sym_boolean_type] = ACTIONS(622),
    [sym_void_type] = ACTIONS(622),
    [sym_this] = ACTIONS(622),
    [sym_super] = ACTIONS(622),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [ts_builtin_sym_end] = ACTIONS(624),
    [sym_identifier] = ACTIONS(626),
    [sym_decimal_integer_literal] = ACTIONS(626),
    [sym_hex_integer_literal] = ACTIONS(626),
    [sym_octal_integer_literal] = ACTIONS(624),
    [sym_binary_integer_literal] = ACTIONS(624),
    [sym_decimal_floating_point_literal] = ACTIONS(624),
    [sym_hex_floating_point_literal] = ACTIONS(626),
    [sym_true] = ACTIONS(626),
    [sym_false] = ACTIONS(626),
    [sym_character_literal] = ACTIONS(624),
    [sym_string_literal] = ACTIONS(624),
    [sym_null_literal] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(624),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(626),
    [anon_sym_DASH] = ACTIONS(626),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(624),
    [anon_sym_PLUS_PLUS] = ACTIONS(624),
    [anon_sym_DASH_DASH] = ACTIONS(624),
    [anon_sym_new] = ACTIONS(626),
    [anon_sym_class] = ACTIONS(626),
    [anon_sym_SEMI] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(624),
    [anon_sym_RBRACE] = ACTIONS(624),
    [anon_sym_assert] = ACTIONS(626),
    [anon_sym_switch] = ACTIONS(626),
    [anon_sym_case] = ACTIONS(626),
    [anon_sym_default] = ACTIONS(626),
    [anon_sym_do] = ACTIONS(626),
    [anon_sym_while] = ACTIONS(626),
    [anon_sym_break] = ACTIONS(626),
    [anon_sym_continue] = ACTIONS(626),
    [anon_sym_return] = ACTIONS(626),
    [anon_sym_synchronized] = ACTIONS(626),
    [anon_sym_throw] = ACTIONS(626),
    [anon_sym_try] = ACTIONS(626),
    [anon_sym_if] = ACTIONS(626),
    [anon_sym_else] = ACTIONS(626),
    [anon_sym_for] = ACTIONS(626),
    [anon_sym_AT] = ACTIONS(626),
    [anon_sym_open] = ACTIONS(626),
    [anon_sym_module] = ACTIONS(626),
    [anon_sym_static] = ACTIONS(626),
    [anon_sym_package] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(626),
    [anon_sym_enum] = ACTIONS(626),
    [anon_sym_public] = ACTIONS(626),
    [anon_sym_protected] = ACTIONS(626),
    [anon_sym_private] = ACTIONS(626),
    [anon_sym_abstract] = ACTIONS(626),
    [anon_sym_final] = ACTIONS(626),
    [anon_sym_strictfp] = ACTIONS(626),
    [anon_sym_native] = ACTIONS(626),
    [anon_sym_transient] = ACTIONS(626),
    [anon_sym_volatile] = ACTIONS(626),
    [anon_sym_ATinterface] = ACTIONS(624),
    [anon_sym_interface] = ACTIONS(626),
    [anon_sym_byte] = ACTIONS(626),
    [anon_sym_short] = ACTIONS(626),
    [anon_sym_int] = ACTIONS(626),
    [anon_sym_long] = ACTIONS(626),
    [anon_sym_char] = ACTIONS(626),
    [anon_sym_float] = ACTIONS(626),
    [anon_sym_double] = ACTIONS(626),
    [sym_boolean_type] = ACTIONS(626),
    [sym_void_type] = ACTIONS(626),
    [sym_this] = ACTIONS(626),
    [sym_super] = ACTIONS(626),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [ts_builtin_sym_end] = ACTIONS(628),
    [sym_identifier] = ACTIONS(630),
    [sym_decimal_integer_literal] = ACTIONS(630),
    [sym_hex_integer_literal] = ACTIONS(630),
    [sym_octal_integer_literal] = ACTIONS(628),
    [sym_binary_integer_literal] = ACTIONS(628),
    [sym_decimal_floating_point_literal] = ACTIONS(628),
    [sym_hex_floating_point_literal] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_character_literal] = ACTIONS(628),
    [sym_string_literal] = ACTIONS(628),
    [sym_null_literal] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_LT] = ACTIONS(628),
    [anon_sym_PLUS] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_BANG] = ACTIONS(628),
    [anon_sym_TILDE] = ACTIONS(628),
    [anon_sym_PLUS_PLUS] = ACTIONS(628),
    [anon_sym_DASH_DASH] = ACTIONS(628),
    [anon_sym_new] = ACTIONS(630),
    [anon_sym_class] = ACTIONS(630),
    [anon_sym_SEMI] = ACTIONS(628),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_RBRACE] = ACTIONS(628),
    [anon_sym_assert] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_case] = ACTIONS(630),
    [anon_sym_default] = ACTIONS(630),
    [anon_sym_do] = ACTIONS(630),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_break] = ACTIONS(630),
    [anon_sym_continue] = ACTIONS(630),
    [anon_sym_return] = ACTIONS(630),
    [anon_sym_synchronized] = ACTIONS(630),
    [anon_sym_throw] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_else] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(630),
    [anon_sym_open] = ACTIONS(630),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_package] = ACTIONS(630),
    [anon_sym_import] = ACTIONS(630),
    [anon_sym_enum] = ACTIONS(630),
    [anon_sym_public] = ACTIONS(630),
    [anon_sym_protected] = ACTIONS(630),
    [anon_sym_private] = ACTIONS(630),
    [anon_sym_abstract] = ACTIONS(630),
    [anon_sym_final] = ACTIONS(630),
    [anon_sym_strictfp] = ACTIONS(630),
    [anon_sym_native] = ACTIONS(630),
    [anon_sym_transient] = ACTIONS(630),
    [anon_sym_volatile] = ACTIONS(630),
    [anon_sym_ATinterface] = ACTIONS(628),
    [anon_sym_interface] = ACTIONS(630),
    [anon_sym_byte] = ACTIONS(630),
    [anon_sym_short] = ACTIONS(630),
    [anon_sym_int] = ACTIONS(630),
    [anon_sym_long] = ACTIONS(630),
    [anon_sym_char] = ACTIONS(630),
    [anon_sym_float] = ACTIONS(630),
    [anon_sym_double] = ACTIONS(630),
    [sym_boolean_type] = ACTIONS(630),
    [sym_void_type] = ACTIONS(630),
    [sym_this] = ACTIONS(630),
    [sym_super] = ACTIONS(630),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(402),
    [sym_cast_expression] = STATE(402),
    [sym_assignment_expression] = STATE(402),
    [sym_binary_expression] = STATE(402),
    [sym_instanceof_expression] = STATE(402),
    [sym_lambda_expression] = STATE(402),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(402),
    [sym_unary_expression] = STATE(402),
    [sym_update_expression] = STATE(402),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [ts_builtin_sym_end] = ACTIONS(634),
    [sym_identifier] = ACTIONS(636),
    [sym_decimal_integer_literal] = ACTIONS(636),
    [sym_hex_integer_literal] = ACTIONS(636),
    [sym_octal_integer_literal] = ACTIONS(634),
    [sym_binary_integer_literal] = ACTIONS(634),
    [sym_decimal_floating_point_literal] = ACTIONS(634),
    [sym_hex_floating_point_literal] = ACTIONS(636),
    [sym_true] = ACTIONS(636),
    [sym_false] = ACTIONS(636),
    [sym_character_literal] = ACTIONS(634),
    [sym_string_literal] = ACTIONS(634),
    [sym_null_literal] = ACTIONS(636),
    [anon_sym_LPAREN] = ACTIONS(634),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(636),
    [anon_sym_DASH] = ACTIONS(636),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_new] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(636),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(634),
    [anon_sym_assert] = ACTIONS(636),
    [anon_sym_switch] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_default] = ACTIONS(636),
    [anon_sym_do] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_break] = ACTIONS(636),
    [anon_sym_continue] = ACTIONS(636),
    [anon_sym_return] = ACTIONS(636),
    [anon_sym_synchronized] = ACTIONS(636),
    [anon_sym_throw] = ACTIONS(636),
    [anon_sym_try] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_else] = ACTIONS(636),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(636),
    [anon_sym_open] = ACTIONS(636),
    [anon_sym_module] = ACTIONS(636),
    [anon_sym_static] = ACTIONS(636),
    [anon_sym_package] = ACTIONS(636),
    [anon_sym_import] = ACTIONS(636),
    [anon_sym_enum] = ACTIONS(636),
    [anon_sym_public] = ACTIONS(636),
    [anon_sym_protected] = ACTIONS(636),
    [anon_sym_private] = ACTIONS(636),
    [anon_sym_abstract] = ACTIONS(636),
    [anon_sym_final] = ACTIONS(636),
    [anon_sym_strictfp] = ACTIONS(636),
    [anon_sym_native] = ACTIONS(636),
    [anon_sym_transient] = ACTIONS(636),
    [anon_sym_volatile] = ACTIONS(636),
    [anon_sym_ATinterface] = ACTIONS(634),
    [anon_sym_interface] = ACTIONS(636),
    [anon_sym_byte] = ACTIONS(636),
    [anon_sym_short] = ACTIONS(636),
    [anon_sym_int] = ACTIONS(636),
    [anon_sym_long] = ACTIONS(636),
    [anon_sym_char] = ACTIONS(636),
    [anon_sym_float] = ACTIONS(636),
    [anon_sym_double] = ACTIONS(636),
    [sym_boolean_type] = ACTIONS(636),
    [sym_void_type] = ACTIONS(636),
    [sym_this] = ACTIONS(636),
    [sym_super] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(434),
    [sym_cast_expression] = STATE(434),
    [sym_assignment_expression] = STATE(434),
    [sym_binary_expression] = STATE(434),
    [sym_instanceof_expression] = STATE(434),
    [sym_lambda_expression] = STATE(434),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(434),
    [sym_unary_expression] = STATE(434),
    [sym_update_expression] = STATE(434),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [ts_builtin_sym_end] = ACTIONS(640),
    [sym_identifier] = ACTIONS(642),
    [sym_decimal_integer_literal] = ACTIONS(642),
    [sym_hex_integer_literal] = ACTIONS(642),
    [sym_octal_integer_literal] = ACTIONS(640),
    [sym_binary_integer_literal] = ACTIONS(640),
    [sym_decimal_floating_point_literal] = ACTIONS(640),
    [sym_hex_floating_point_literal] = ACTIONS(642),
    [sym_true] = ACTIONS(642),
    [sym_false] = ACTIONS(642),
    [sym_character_literal] = ACTIONS(640),
    [sym_string_literal] = ACTIONS(640),
    [sym_null_literal] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(640),
    [anon_sym_LT] = ACTIONS(640),
    [anon_sym_PLUS] = ACTIONS(642),
    [anon_sym_DASH] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(640),
    [anon_sym_PLUS_PLUS] = ACTIONS(640),
    [anon_sym_DASH_DASH] = ACTIONS(640),
    [anon_sym_new] = ACTIONS(642),
    [anon_sym_class] = ACTIONS(642),
    [anon_sym_SEMI] = ACTIONS(640),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_RBRACE] = ACTIONS(640),
    [anon_sym_assert] = ACTIONS(642),
    [anon_sym_switch] = ACTIONS(642),
    [anon_sym_case] = ACTIONS(642),
    [anon_sym_default] = ACTIONS(642),
    [anon_sym_do] = ACTIONS(642),
    [anon_sym_while] = ACTIONS(642),
    [anon_sym_break] = ACTIONS(642),
    [anon_sym_continue] = ACTIONS(642),
    [anon_sym_return] = ACTIONS(642),
    [anon_sym_synchronized] = ACTIONS(642),
    [anon_sym_throw] = ACTIONS(642),
    [anon_sym_try] = ACTIONS(642),
    [anon_sym_if] = ACTIONS(642),
    [anon_sym_else] = ACTIONS(642),
    [anon_sym_for] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(642),
    [anon_sym_open] = ACTIONS(642),
    [anon_sym_module] = ACTIONS(642),
    [anon_sym_static] = ACTIONS(642),
    [anon_sym_package] = ACTIONS(642),
    [anon_sym_import] = ACTIONS(642),
    [anon_sym_enum] = ACTIONS(642),
    [anon_sym_public] = ACTIONS(642),
    [anon_sym_protected] = ACTIONS(642),
    [anon_sym_private] = ACTIONS(642),
    [anon_sym_abstract] = ACTIONS(642),
    [anon_sym_final] = ACTIONS(642),
    [anon_sym_strictfp] = ACTIONS(642),
    [anon_sym_native] = ACTIONS(642),
    [anon_sym_transient] = ACTIONS(642),
    [anon_sym_volatile] = ACTIONS(642),
    [anon_sym_ATinterface] = ACTIONS(640),
    [anon_sym_interface] = ACTIONS(642),
    [anon_sym_byte] = ACTIONS(642),
    [anon_sym_short] = ACTIONS(642),
    [anon_sym_int] = ACTIONS(642),
    [anon_sym_long] = ACTIONS(642),
    [anon_sym_char] = ACTIONS(642),
    [anon_sym_float] = ACTIONS(642),
    [anon_sym_double] = ACTIONS(642),
    [sym_boolean_type] = ACTIONS(642),
    [sym_void_type] = ACTIONS(642),
    [sym_this] = ACTIONS(642),
    [sym_super] = ACTIONS(642),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [ts_builtin_sym_end] = ACTIONS(644),
    [sym_identifier] = ACTIONS(646),
    [sym_decimal_integer_literal] = ACTIONS(646),
    [sym_hex_integer_literal] = ACTIONS(646),
    [sym_octal_integer_literal] = ACTIONS(644),
    [sym_binary_integer_literal] = ACTIONS(644),
    [sym_decimal_floating_point_literal] = ACTIONS(644),
    [sym_hex_floating_point_literal] = ACTIONS(646),
    [sym_true] = ACTIONS(646),
    [sym_false] = ACTIONS(646),
    [sym_character_literal] = ACTIONS(644),
    [sym_string_literal] = ACTIONS(644),
    [sym_null_literal] = ACTIONS(646),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_LT] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(646),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_TILDE] = ACTIONS(644),
    [anon_sym_PLUS_PLUS] = ACTIONS(644),
    [anon_sym_DASH_DASH] = ACTIONS(644),
    [anon_sym_new] = ACTIONS(646),
    [anon_sym_class] = ACTIONS(646),
    [anon_sym_SEMI] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(644),
    [anon_sym_RBRACE] = ACTIONS(644),
    [anon_sym_assert] = ACTIONS(646),
    [anon_sym_switch] = ACTIONS(646),
    [anon_sym_case] = ACTIONS(646),
    [anon_sym_default] = ACTIONS(646),
    [anon_sym_do] = ACTIONS(646),
    [anon_sym_while] = ACTIONS(646),
    [anon_sym_break] = ACTIONS(646),
    [anon_sym_continue] = ACTIONS(646),
    [anon_sym_return] = ACTIONS(646),
    [anon_sym_synchronized] = ACTIONS(646),
    [anon_sym_throw] = ACTIONS(646),
    [anon_sym_try] = ACTIONS(646),
    [anon_sym_if] = ACTIONS(646),
    [anon_sym_else] = ACTIONS(646),
    [anon_sym_for] = ACTIONS(646),
    [anon_sym_AT] = ACTIONS(646),
    [anon_sym_open] = ACTIONS(646),
    [anon_sym_module] = ACTIONS(646),
    [anon_sym_static] = ACTIONS(646),
    [anon_sym_package] = ACTIONS(646),
    [anon_sym_import] = ACTIONS(646),
    [anon_sym_enum] = ACTIONS(646),
    [anon_sym_public] = ACTIONS(646),
    [anon_sym_protected] = ACTIONS(646),
    [anon_sym_private] = ACTIONS(646),
    [anon_sym_abstract] = ACTIONS(646),
    [anon_sym_final] = ACTIONS(646),
    [anon_sym_strictfp] = ACTIONS(646),
    [anon_sym_native] = ACTIONS(646),
    [anon_sym_transient] = ACTIONS(646),
    [anon_sym_volatile] = ACTIONS(646),
    [anon_sym_ATinterface] = ACTIONS(644),
    [anon_sym_interface] = ACTIONS(646),
    [anon_sym_byte] = ACTIONS(646),
    [anon_sym_short] = ACTIONS(646),
    [anon_sym_int] = ACTIONS(646),
    [anon_sym_long] = ACTIONS(646),
    [anon_sym_char] = ACTIONS(646),
    [anon_sym_float] = ACTIONS(646),
    [anon_sym_double] = ACTIONS(646),
    [sym_boolean_type] = ACTIONS(646),
    [sym_void_type] = ACTIONS(646),
    [sym_this] = ACTIONS(646),
    [sym_super] = ACTIONS(646),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [ts_builtin_sym_end] = ACTIONS(648),
    [sym_identifier] = ACTIONS(650),
    [sym_decimal_integer_literal] = ACTIONS(650),
    [sym_hex_integer_literal] = ACTIONS(650),
    [sym_octal_integer_literal] = ACTIONS(648),
    [sym_binary_integer_literal] = ACTIONS(648),
    [sym_decimal_floating_point_literal] = ACTIONS(648),
    [sym_hex_floating_point_literal] = ACTIONS(650),
    [sym_true] = ACTIONS(650),
    [sym_false] = ACTIONS(650),
    [sym_character_literal] = ACTIONS(648),
    [sym_string_literal] = ACTIONS(648),
    [sym_null_literal] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(648),
    [anon_sym_TILDE] = ACTIONS(648),
    [anon_sym_PLUS_PLUS] = ACTIONS(648),
    [anon_sym_DASH_DASH] = ACTIONS(648),
    [anon_sym_new] = ACTIONS(650),
    [anon_sym_class] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(648),
    [anon_sym_RBRACE] = ACTIONS(648),
    [anon_sym_assert] = ACTIONS(650),
    [anon_sym_switch] = ACTIONS(650),
    [anon_sym_case] = ACTIONS(650),
    [anon_sym_default] = ACTIONS(650),
    [anon_sym_do] = ACTIONS(650),
    [anon_sym_while] = ACTIONS(650),
    [anon_sym_break] = ACTIONS(650),
    [anon_sym_continue] = ACTIONS(650),
    [anon_sym_return] = ACTIONS(650),
    [anon_sym_synchronized] = ACTIONS(650),
    [anon_sym_throw] = ACTIONS(650),
    [anon_sym_try] = ACTIONS(650),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_else] = ACTIONS(650),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_open] = ACTIONS(650),
    [anon_sym_module] = ACTIONS(650),
    [anon_sym_static] = ACTIONS(650),
    [anon_sym_package] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(650),
    [anon_sym_enum] = ACTIONS(650),
    [anon_sym_public] = ACTIONS(650),
    [anon_sym_protected] = ACTIONS(650),
    [anon_sym_private] = ACTIONS(650),
    [anon_sym_abstract] = ACTIONS(650),
    [anon_sym_final] = ACTIONS(650),
    [anon_sym_strictfp] = ACTIONS(650),
    [anon_sym_native] = ACTIONS(650),
    [anon_sym_transient] = ACTIONS(650),
    [anon_sym_volatile] = ACTIONS(650),
    [anon_sym_ATinterface] = ACTIONS(648),
    [anon_sym_interface] = ACTIONS(650),
    [anon_sym_byte] = ACTIONS(650),
    [anon_sym_short] = ACTIONS(650),
    [anon_sym_int] = ACTIONS(650),
    [anon_sym_long] = ACTIONS(650),
    [anon_sym_char] = ACTIONS(650),
    [anon_sym_float] = ACTIONS(650),
    [anon_sym_double] = ACTIONS(650),
    [sym_boolean_type] = ACTIONS(650),
    [sym_void_type] = ACTIONS(650),
    [sym_this] = ACTIONS(650),
    [sym_super] = ACTIONS(650),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(428),
    [sym_cast_expression] = STATE(428),
    [sym_assignment_expression] = STATE(428),
    [sym_binary_expression] = STATE(428),
    [sym_instanceof_expression] = STATE(428),
    [sym_lambda_expression] = STATE(428),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(428),
    [sym_unary_expression] = STATE(428),
    [sym_update_expression] = STATE(428),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [ts_builtin_sym_end] = ACTIONS(652),
    [sym_identifier] = ACTIONS(654),
    [sym_decimal_integer_literal] = ACTIONS(654),
    [sym_hex_integer_literal] = ACTIONS(654),
    [sym_octal_integer_literal] = ACTIONS(652),
    [sym_binary_integer_literal] = ACTIONS(652),
    [sym_decimal_floating_point_literal] = ACTIONS(652),
    [sym_hex_floating_point_literal] = ACTIONS(654),
    [sym_true] = ACTIONS(654),
    [sym_false] = ACTIONS(654),
    [sym_character_literal] = ACTIONS(652),
    [sym_string_literal] = ACTIONS(652),
    [sym_null_literal] = ACTIONS(654),
    [anon_sym_LPAREN] = ACTIONS(652),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(654),
    [anon_sym_DASH] = ACTIONS(654),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(652),
    [anon_sym_DASH_DASH] = ACTIONS(652),
    [anon_sym_new] = ACTIONS(654),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_SEMI] = ACTIONS(652),
    [anon_sym_LBRACE] = ACTIONS(652),
    [anon_sym_RBRACE] = ACTIONS(652),
    [anon_sym_assert] = ACTIONS(654),
    [anon_sym_switch] = ACTIONS(654),
    [anon_sym_case] = ACTIONS(654),
    [anon_sym_default] = ACTIONS(654),
    [anon_sym_do] = ACTIONS(654),
    [anon_sym_while] = ACTIONS(654),
    [anon_sym_break] = ACTIONS(654),
    [anon_sym_continue] = ACTIONS(654),
    [anon_sym_return] = ACTIONS(654),
    [anon_sym_synchronized] = ACTIONS(654),
    [anon_sym_throw] = ACTIONS(654),
    [anon_sym_try] = ACTIONS(654),
    [anon_sym_if] = ACTIONS(654),
    [anon_sym_else] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(654),
    [anon_sym_open] = ACTIONS(654),
    [anon_sym_module] = ACTIONS(654),
    [anon_sym_static] = ACTIONS(654),
    [anon_sym_package] = ACTIONS(654),
    [anon_sym_import] = ACTIONS(654),
    [anon_sym_enum] = ACTIONS(654),
    [anon_sym_public] = ACTIONS(654),
    [anon_sym_protected] = ACTIONS(654),
    [anon_sym_private] = ACTIONS(654),
    [anon_sym_abstract] = ACTIONS(654),
    [anon_sym_final] = ACTIONS(654),
    [anon_sym_strictfp] = ACTIONS(654),
    [anon_sym_native] = ACTIONS(654),
    [anon_sym_transient] = ACTIONS(654),
    [anon_sym_volatile] = ACTIONS(654),
    [anon_sym_ATinterface] = ACTIONS(652),
    [anon_sym_interface] = ACTIONS(654),
    [anon_sym_byte] = ACTIONS(654),
    [anon_sym_short] = ACTIONS(654),
    [anon_sym_int] = ACTIONS(654),
    [anon_sym_long] = ACTIONS(654),
    [anon_sym_char] = ACTIONS(654),
    [anon_sym_float] = ACTIONS(654),
    [anon_sym_double] = ACTIONS(654),
    [sym_boolean_type] = ACTIONS(654),
    [sym_void_type] = ACTIONS(654),
    [sym_this] = ACTIONS(654),
    [sym_super] = ACTIONS(654),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(656),
    [sym_identifier] = ACTIONS(658),
    [sym_decimal_integer_literal] = ACTIONS(658),
    [sym_hex_integer_literal] = ACTIONS(658),
    [sym_octal_integer_literal] = ACTIONS(656),
    [sym_binary_integer_literal] = ACTIONS(656),
    [sym_decimal_floating_point_literal] = ACTIONS(656),
    [sym_hex_floating_point_literal] = ACTIONS(658),
    [sym_true] = ACTIONS(658),
    [sym_false] = ACTIONS(658),
    [sym_character_literal] = ACTIONS(656),
    [sym_string_literal] = ACTIONS(656),
    [sym_null_literal] = ACTIONS(658),
    [anon_sym_LPAREN] = ACTIONS(656),
    [anon_sym_LT] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_BANG] = ACTIONS(656),
    [anon_sym_TILDE] = ACTIONS(656),
    [anon_sym_PLUS_PLUS] = ACTIONS(656),
    [anon_sym_DASH_DASH] = ACTIONS(656),
    [anon_sym_new] = ACTIONS(658),
    [anon_sym_class] = ACTIONS(658),
    [anon_sym_SEMI] = ACTIONS(656),
    [anon_sym_LBRACE] = ACTIONS(656),
    [anon_sym_RBRACE] = ACTIONS(656),
    [anon_sym_assert] = ACTIONS(658),
    [anon_sym_switch] = ACTIONS(658),
    [anon_sym_case] = ACTIONS(658),
    [anon_sym_default] = ACTIONS(658),
    [anon_sym_do] = ACTIONS(658),
    [anon_sym_while] = ACTIONS(658),
    [anon_sym_break] = ACTIONS(658),
    [anon_sym_continue] = ACTIONS(658),
    [anon_sym_return] = ACTIONS(658),
    [anon_sym_synchronized] = ACTIONS(658),
    [anon_sym_throw] = ACTIONS(658),
    [anon_sym_try] = ACTIONS(658),
    [anon_sym_if] = ACTIONS(658),
    [anon_sym_else] = ACTIONS(658),
    [anon_sym_for] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(658),
    [anon_sym_open] = ACTIONS(658),
    [anon_sym_module] = ACTIONS(658),
    [anon_sym_static] = ACTIONS(658),
    [anon_sym_package] = ACTIONS(658),
    [anon_sym_import] = ACTIONS(658),
    [anon_sym_enum] = ACTIONS(658),
    [anon_sym_public] = ACTIONS(658),
    [anon_sym_protected] = ACTIONS(658),
    [anon_sym_private] = ACTIONS(658),
    [anon_sym_abstract] = ACTIONS(658),
    [anon_sym_final] = ACTIONS(658),
    [anon_sym_strictfp] = ACTIONS(658),
    [anon_sym_native] = ACTIONS(658),
    [anon_sym_transient] = ACTIONS(658),
    [anon_sym_volatile] = ACTIONS(658),
    [anon_sym_ATinterface] = ACTIONS(656),
    [anon_sym_interface] = ACTIONS(658),
    [anon_sym_byte] = ACTIONS(658),
    [anon_sym_short] = ACTIONS(658),
    [anon_sym_int] = ACTIONS(658),
    [anon_sym_long] = ACTIONS(658),
    [anon_sym_char] = ACTIONS(658),
    [anon_sym_float] = ACTIONS(658),
    [anon_sym_double] = ACTIONS(658),
    [sym_boolean_type] = ACTIONS(658),
    [sym_void_type] = ACTIONS(658),
    [sym_this] = ACTIONS(658),
    [sym_super] = ACTIONS(658),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(428),
    [sym_cast_expression] = STATE(428),
    [sym_assignment_expression] = STATE(428),
    [sym_binary_expression] = STATE(428),
    [sym_instanceof_expression] = STATE(428),
    [sym_lambda_expression] = STATE(428),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(428),
    [sym_unary_expression] = STATE(428),
    [sym_update_expression] = STATE(428),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(420),
    [sym_cast_expression] = STATE(420),
    [sym_assignment_expression] = STATE(420),
    [sym_binary_expression] = STATE(420),
    [sym_instanceof_expression] = STATE(420),
    [sym_lambda_expression] = STATE(420),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(420),
    [sym_unary_expression] = STATE(420),
    [sym_update_expression] = STATE(420),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(660),
    [sym_identifier] = ACTIONS(662),
    [sym_decimal_integer_literal] = ACTIONS(662),
    [sym_hex_integer_literal] = ACTIONS(662),
    [sym_octal_integer_literal] = ACTIONS(660),
    [sym_binary_integer_literal] = ACTIONS(660),
    [sym_decimal_floating_point_literal] = ACTIONS(660),
    [sym_hex_floating_point_literal] = ACTIONS(662),
    [sym_true] = ACTIONS(662),
    [sym_false] = ACTIONS(662),
    [sym_character_literal] = ACTIONS(660),
    [sym_string_literal] = ACTIONS(660),
    [sym_null_literal] = ACTIONS(662),
    [anon_sym_LPAREN] = ACTIONS(660),
    [anon_sym_PLUS] = ACTIONS(662),
    [anon_sym_DASH] = ACTIONS(662),
    [anon_sym_BANG] = ACTIONS(660),
    [anon_sym_TILDE] = ACTIONS(660),
    [anon_sym_PLUS_PLUS] = ACTIONS(660),
    [anon_sym_DASH_DASH] = ACTIONS(660),
    [anon_sym_new] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(662),
    [anon_sym_SEMI] = ACTIONS(660),
    [anon_sym_LBRACE] = ACTIONS(660),
    [anon_sym_RBRACE] = ACTIONS(660),
    [anon_sym_assert] = ACTIONS(662),
    [anon_sym_switch] = ACTIONS(662),
    [anon_sym_case] = ACTIONS(662),
    [anon_sym_default] = ACTIONS(662),
    [anon_sym_do] = ACTIONS(662),
    [anon_sym_while] = ACTIONS(662),
    [anon_sym_break] = ACTIONS(662),
    [anon_sym_continue] = ACTIONS(662),
    [anon_sym_return] = ACTIONS(662),
    [anon_sym_synchronized] = ACTIONS(662),
    [anon_sym_throw] = ACTIONS(662),
    [anon_sym_try] = ACTIONS(662),
    [anon_sym_if] = ACTIONS(662),
    [anon_sym_else] = ACTIONS(662),
    [anon_sym_for] = ACTIONS(662),
    [anon_sym_AT] = ACTIONS(662),
    [anon_sym_open] = ACTIONS(662),
    [anon_sym_module] = ACTIONS(662),
    [anon_sym_static] = ACTIONS(662),
    [anon_sym_package] = ACTIONS(662),
    [anon_sym_import] = ACTIONS(662),
    [anon_sym_enum] = ACTIONS(662),
    [anon_sym_public] = ACTIONS(662),
    [anon_sym_protected] = ACTIONS(662),
    [anon_sym_private] = ACTIONS(662),
    [anon_sym_abstract] = ACTIONS(662),
    [anon_sym_final] = ACTIONS(662),
    [anon_sym_strictfp] = ACTIONS(662),
    [anon_sym_native] = ACTIONS(662),
    [anon_sym_transient] = ACTIONS(662),
    [anon_sym_volatile] = ACTIONS(662),
    [anon_sym_ATinterface] = ACTIONS(660),
    [anon_sym_interface] = ACTIONS(662),
    [anon_sym_byte] = ACTIONS(662),
    [anon_sym_short] = ACTIONS(662),
    [anon_sym_int] = ACTIONS(662),
    [anon_sym_long] = ACTIONS(662),
    [anon_sym_char] = ACTIONS(662),
    [anon_sym_float] = ACTIONS(662),
    [anon_sym_double] = ACTIONS(662),
    [sym_boolean_type] = ACTIONS(662),
    [sym_void_type] = ACTIONS(662),
    [sym_this] = ACTIONS(662),
    [sym_super] = ACTIONS(662),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(375),
    [sym_cast_expression] = STATE(375),
    [sym_assignment_expression] = STATE(375),
    [sym_binary_expression] = STATE(375),
    [sym_instanceof_expression] = STATE(375),
    [sym_lambda_expression] = STATE(375),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(375),
    [sym_unary_expression] = STATE(375),
    [sym_update_expression] = STATE(375),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(437),
    [sym_cast_expression] = STATE(437),
    [sym_assignment_expression] = STATE(437),
    [sym_binary_expression] = STATE(437),
    [sym_instanceof_expression] = STATE(437),
    [sym_lambda_expression] = STATE(437),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(437),
    [sym_unary_expression] = STATE(437),
    [sym_update_expression] = STATE(437),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(366),
    [sym_cast_expression] = STATE(366),
    [sym_assignment_expression] = STATE(366),
    [sym_binary_expression] = STATE(366),
    [sym_instanceof_expression] = STATE(366),
    [sym_lambda_expression] = STATE(366),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(366),
    [sym_unary_expression] = STATE(366),
    [sym_update_expression] = STATE(366),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(364),
    [sym_cast_expression] = STATE(364),
    [sym_assignment_expression] = STATE(364),
    [sym_binary_expression] = STATE(364),
    [sym_instanceof_expression] = STATE(364),
    [sym_lambda_expression] = STATE(364),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(364),
    [sym_unary_expression] = STATE(364),
    [sym_update_expression] = STATE(364),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(664),
    [sym_identifier] = ACTIONS(666),
    [sym_decimal_integer_literal] = ACTIONS(666),
    [sym_hex_integer_literal] = ACTIONS(666),
    [sym_octal_integer_literal] = ACTIONS(664),
    [sym_binary_integer_literal] = ACTIONS(664),
    [sym_decimal_floating_point_literal] = ACTIONS(664),
    [sym_hex_floating_point_literal] = ACTIONS(666),
    [sym_true] = ACTIONS(666),
    [sym_false] = ACTIONS(666),
    [sym_character_literal] = ACTIONS(664),
    [sym_string_literal] = ACTIONS(664),
    [sym_null_literal] = ACTIONS(666),
    [anon_sym_LPAREN] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(666),
    [anon_sym_DASH] = ACTIONS(666),
    [anon_sym_BANG] = ACTIONS(664),
    [anon_sym_TILDE] = ACTIONS(664),
    [anon_sym_PLUS_PLUS] = ACTIONS(664),
    [anon_sym_DASH_DASH] = ACTIONS(664),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_class] = ACTIONS(666),
    [anon_sym_SEMI] = ACTIONS(664),
    [anon_sym_LBRACE] = ACTIONS(664),
    [anon_sym_RBRACE] = ACTIONS(664),
    [anon_sym_assert] = ACTIONS(666),
    [anon_sym_switch] = ACTIONS(666),
    [anon_sym_case] = ACTIONS(666),
    [anon_sym_default] = ACTIONS(666),
    [anon_sym_do] = ACTIONS(666),
    [anon_sym_while] = ACTIONS(666),
    [anon_sym_break] = ACTIONS(666),
    [anon_sym_continue] = ACTIONS(666),
    [anon_sym_return] = ACTIONS(666),
    [anon_sym_synchronized] = ACTIONS(666),
    [anon_sym_throw] = ACTIONS(666),
    [anon_sym_try] = ACTIONS(666),
    [anon_sym_if] = ACTIONS(666),
    [anon_sym_else] = ACTIONS(666),
    [anon_sym_for] = ACTIONS(666),
    [anon_sym_AT] = ACTIONS(666),
    [anon_sym_open] = ACTIONS(666),
    [anon_sym_module] = ACTIONS(666),
    [anon_sym_static] = ACTIONS(666),
    [anon_sym_package] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(666),
    [anon_sym_enum] = ACTIONS(666),
    [anon_sym_public] = ACTIONS(666),
    [anon_sym_protected] = ACTIONS(666),
    [anon_sym_private] = ACTIONS(666),
    [anon_sym_abstract] = ACTIONS(666),
    [anon_sym_final] = ACTIONS(666),
    [anon_sym_strictfp] = ACTIONS(666),
    [anon_sym_native] = ACTIONS(666),
    [anon_sym_transient] = ACTIONS(666),
    [anon_sym_volatile] = ACTIONS(666),
    [anon_sym_ATinterface] = ACTIONS(664),
    [anon_sym_interface] = ACTIONS(666),
    [anon_sym_byte] = ACTIONS(666),
    [anon_sym_short] = ACTIONS(666),
    [anon_sym_int] = ACTIONS(666),
    [anon_sym_long] = ACTIONS(666),
    [anon_sym_char] = ACTIONS(666),
    [anon_sym_float] = ACTIONS(666),
    [anon_sym_double] = ACTIONS(666),
    [sym_boolean_type] = ACTIONS(666),
    [sym_void_type] = ACTIONS(666),
    [sym_this] = ACTIONS(666),
    [sym_super] = ACTIONS(666),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(430),
    [sym_cast_expression] = STATE(430),
    [sym_assignment_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_instanceof_expression] = STATE(430),
    [sym_lambda_expression] = STATE(430),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(668),
    [sym_identifier] = ACTIONS(670),
    [sym_decimal_integer_literal] = ACTIONS(670),
    [sym_hex_integer_literal] = ACTIONS(670),
    [sym_octal_integer_literal] = ACTIONS(668),
    [sym_binary_integer_literal] = ACTIONS(668),
    [sym_decimal_floating_point_literal] = ACTIONS(668),
    [sym_hex_floating_point_literal] = ACTIONS(670),
    [sym_true] = ACTIONS(670),
    [sym_false] = ACTIONS(670),
    [sym_character_literal] = ACTIONS(668),
    [sym_string_literal] = ACTIONS(668),
    [sym_null_literal] = ACTIONS(670),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(670),
    [anon_sym_DASH] = ACTIONS(670),
    [anon_sym_BANG] = ACTIONS(668),
    [anon_sym_TILDE] = ACTIONS(668),
    [anon_sym_PLUS_PLUS] = ACTIONS(668),
    [anon_sym_DASH_DASH] = ACTIONS(668),
    [anon_sym_new] = ACTIONS(670),
    [anon_sym_class] = ACTIONS(670),
    [anon_sym_SEMI] = ACTIONS(668),
    [anon_sym_LBRACE] = ACTIONS(668),
    [anon_sym_RBRACE] = ACTIONS(668),
    [anon_sym_assert] = ACTIONS(670),
    [anon_sym_switch] = ACTIONS(670),
    [anon_sym_case] = ACTIONS(670),
    [anon_sym_default] = ACTIONS(670),
    [anon_sym_do] = ACTIONS(670),
    [anon_sym_while] = ACTIONS(670),
    [anon_sym_break] = ACTIONS(670),
    [anon_sym_continue] = ACTIONS(670),
    [anon_sym_return] = ACTIONS(670),
    [anon_sym_synchronized] = ACTIONS(670),
    [anon_sym_throw] = ACTIONS(670),
    [anon_sym_try] = ACTIONS(670),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_else] = ACTIONS(670),
    [anon_sym_for] = ACTIONS(670),
    [anon_sym_AT] = ACTIONS(670),
    [anon_sym_open] = ACTIONS(670),
    [anon_sym_module] = ACTIONS(670),
    [anon_sym_static] = ACTIONS(670),
    [anon_sym_package] = ACTIONS(670),
    [anon_sym_import] = ACTIONS(670),
    [anon_sym_enum] = ACTIONS(670),
    [anon_sym_public] = ACTIONS(670),
    [anon_sym_protected] = ACTIONS(670),
    [anon_sym_private] = ACTIONS(670),
    [anon_sym_abstract] = ACTIONS(670),
    [anon_sym_final] = ACTIONS(670),
    [anon_sym_strictfp] = ACTIONS(670),
    [anon_sym_native] = ACTIONS(670),
    [anon_sym_transient] = ACTIONS(670),
    [anon_sym_volatile] = ACTIONS(670),
    [anon_sym_ATinterface] = ACTIONS(668),
    [anon_sym_interface] = ACTIONS(670),
    [anon_sym_byte] = ACTIONS(670),
    [anon_sym_short] = ACTIONS(670),
    [anon_sym_int] = ACTIONS(670),
    [anon_sym_long] = ACTIONS(670),
    [anon_sym_char] = ACTIONS(670),
    [anon_sym_float] = ACTIONS(670),
    [anon_sym_double] = ACTIONS(670),
    [sym_boolean_type] = ACTIONS(670),
    [sym_void_type] = ACTIONS(670),
    [sym_this] = ACTIONS(670),
    [sym_super] = ACTIONS(670),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(672),
    [sym_identifier] = ACTIONS(674),
    [sym_decimal_integer_literal] = ACTIONS(674),
    [sym_hex_integer_literal] = ACTIONS(674),
    [sym_octal_integer_literal] = ACTIONS(672),
    [sym_binary_integer_literal] = ACTIONS(672),
    [sym_decimal_floating_point_literal] = ACTIONS(672),
    [sym_hex_floating_point_literal] = ACTIONS(674),
    [sym_true] = ACTIONS(674),
    [sym_false] = ACTIONS(674),
    [sym_character_literal] = ACTIONS(672),
    [sym_string_literal] = ACTIONS(672),
    [sym_null_literal] = ACTIONS(674),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_BANG] = ACTIONS(672),
    [anon_sym_TILDE] = ACTIONS(672),
    [anon_sym_PLUS_PLUS] = ACTIONS(672),
    [anon_sym_DASH_DASH] = ACTIONS(672),
    [anon_sym_new] = ACTIONS(674),
    [anon_sym_class] = ACTIONS(674),
    [anon_sym_SEMI] = ACTIONS(672),
    [anon_sym_LBRACE] = ACTIONS(672),
    [anon_sym_RBRACE] = ACTIONS(672),
    [anon_sym_assert] = ACTIONS(674),
    [anon_sym_switch] = ACTIONS(674),
    [anon_sym_case] = ACTIONS(674),
    [anon_sym_default] = ACTIONS(674),
    [anon_sym_do] = ACTIONS(674),
    [anon_sym_while] = ACTIONS(674),
    [anon_sym_break] = ACTIONS(674),
    [anon_sym_continue] = ACTIONS(674),
    [anon_sym_return] = ACTIONS(674),
    [anon_sym_synchronized] = ACTIONS(674),
    [anon_sym_throw] = ACTIONS(674),
    [anon_sym_try] = ACTIONS(674),
    [anon_sym_if] = ACTIONS(674),
    [anon_sym_else] = ACTIONS(674),
    [anon_sym_for] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(674),
    [anon_sym_open] = ACTIONS(674),
    [anon_sym_module] = ACTIONS(674),
    [anon_sym_static] = ACTIONS(674),
    [anon_sym_package] = ACTIONS(674),
    [anon_sym_import] = ACTIONS(674),
    [anon_sym_enum] = ACTIONS(674),
    [anon_sym_public] = ACTIONS(674),
    [anon_sym_protected] = ACTIONS(674),
    [anon_sym_private] = ACTIONS(674),
    [anon_sym_abstract] = ACTIONS(674),
    [anon_sym_final] = ACTIONS(674),
    [anon_sym_strictfp] = ACTIONS(674),
    [anon_sym_native] = ACTIONS(674),
    [anon_sym_transient] = ACTIONS(674),
    [anon_sym_volatile] = ACTIONS(674),
    [anon_sym_ATinterface] = ACTIONS(672),
    [anon_sym_interface] = ACTIONS(674),
    [anon_sym_byte] = ACTIONS(674),
    [anon_sym_short] = ACTIONS(674),
    [anon_sym_int] = ACTIONS(674),
    [anon_sym_long] = ACTIONS(674),
    [anon_sym_char] = ACTIONS(674),
    [anon_sym_float] = ACTIONS(674),
    [anon_sym_double] = ACTIONS(674),
    [sym_boolean_type] = ACTIONS(674),
    [sym_void_type] = ACTIONS(674),
    [sym_this] = ACTIONS(674),
    [sym_super] = ACTIONS(674),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(404),
    [sym_cast_expression] = STATE(404),
    [sym_assignment_expression] = STATE(404),
    [sym_binary_expression] = STATE(404),
    [sym_instanceof_expression] = STATE(404),
    [sym_lambda_expression] = STATE(404),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(404),
    [sym_unary_expression] = STATE(404),
    [sym_update_expression] = STATE(404),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(419),
    [sym_cast_expression] = STATE(419),
    [sym_assignment_expression] = STATE(419),
    [sym_binary_expression] = STATE(419),
    [sym_instanceof_expression] = STATE(419),
    [sym_lambda_expression] = STATE(419),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(419),
    [sym_unary_expression] = STATE(419),
    [sym_update_expression] = STATE(419),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(676),
    [sym_identifier] = ACTIONS(678),
    [sym_decimal_integer_literal] = ACTIONS(678),
    [sym_hex_integer_literal] = ACTIONS(678),
    [sym_octal_integer_literal] = ACTIONS(676),
    [sym_binary_integer_literal] = ACTIONS(676),
    [sym_decimal_floating_point_literal] = ACTIONS(676),
    [sym_hex_floating_point_literal] = ACTIONS(678),
    [sym_true] = ACTIONS(678),
    [sym_false] = ACTIONS(678),
    [sym_character_literal] = ACTIONS(676),
    [sym_string_literal] = ACTIONS(676),
    [sym_null_literal] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(676),
    [anon_sym_PLUS] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(678),
    [anon_sym_BANG] = ACTIONS(676),
    [anon_sym_TILDE] = ACTIONS(676),
    [anon_sym_PLUS_PLUS] = ACTIONS(676),
    [anon_sym_DASH_DASH] = ACTIONS(676),
    [anon_sym_new] = ACTIONS(678),
    [anon_sym_class] = ACTIONS(678),
    [anon_sym_SEMI] = ACTIONS(676),
    [anon_sym_LBRACE] = ACTIONS(676),
    [anon_sym_RBRACE] = ACTIONS(676),
    [anon_sym_assert] = ACTIONS(678),
    [anon_sym_switch] = ACTIONS(678),
    [anon_sym_case] = ACTIONS(678),
    [anon_sym_default] = ACTIONS(678),
    [anon_sym_do] = ACTIONS(678),
    [anon_sym_while] = ACTIONS(678),
    [anon_sym_break] = ACTIONS(678),
    [anon_sym_continue] = ACTIONS(678),
    [anon_sym_return] = ACTIONS(678),
    [anon_sym_synchronized] = ACTIONS(678),
    [anon_sym_throw] = ACTIONS(678),
    [anon_sym_try] = ACTIONS(678),
    [anon_sym_if] = ACTIONS(678),
    [anon_sym_else] = ACTIONS(678),
    [anon_sym_for] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(678),
    [anon_sym_open] = ACTIONS(678),
    [anon_sym_module] = ACTIONS(678),
    [anon_sym_static] = ACTIONS(678),
    [anon_sym_package] = ACTIONS(678),
    [anon_sym_import] = ACTIONS(678),
    [anon_sym_enum] = ACTIONS(678),
    [anon_sym_public] = ACTIONS(678),
    [anon_sym_protected] = ACTIONS(678),
    [anon_sym_private] = ACTIONS(678),
    [anon_sym_abstract] = ACTIONS(678),
    [anon_sym_final] = ACTIONS(678),
    [anon_sym_strictfp] = ACTIONS(678),
    [anon_sym_native] = ACTIONS(678),
    [anon_sym_transient] = ACTIONS(678),
    [anon_sym_volatile] = ACTIONS(678),
    [anon_sym_ATinterface] = ACTIONS(676),
    [anon_sym_interface] = ACTIONS(678),
    [anon_sym_byte] = ACTIONS(678),
    [anon_sym_short] = ACTIONS(678),
    [anon_sym_int] = ACTIONS(678),
    [anon_sym_long] = ACTIONS(678),
    [anon_sym_char] = ACTIONS(678),
    [anon_sym_float] = ACTIONS(678),
    [anon_sym_double] = ACTIONS(678),
    [sym_boolean_type] = ACTIONS(678),
    [sym_void_type] = ACTIONS(678),
    [sym_this] = ACTIONS(678),
    [sym_super] = ACTIONS(678),
    [sym_comment] = ACTIONS(3),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(680),
    [sym_identifier] = ACTIONS(682),
    [sym_decimal_integer_literal] = ACTIONS(682),
    [sym_hex_integer_literal] = ACTIONS(682),
    [sym_octal_integer_literal] = ACTIONS(680),
    [sym_binary_integer_literal] = ACTIONS(680),
    [sym_decimal_floating_point_literal] = ACTIONS(680),
    [sym_hex_floating_point_literal] = ACTIONS(682),
    [sym_true] = ACTIONS(682),
    [sym_false] = ACTIONS(682),
    [sym_character_literal] = ACTIONS(680),
    [sym_string_literal] = ACTIONS(680),
    [sym_null_literal] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(680),
    [anon_sym_PLUS] = ACTIONS(682),
    [anon_sym_DASH] = ACTIONS(682),
    [anon_sym_BANG] = ACTIONS(680),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_new] = ACTIONS(682),
    [anon_sym_class] = ACTIONS(682),
    [anon_sym_SEMI] = ACTIONS(680),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_RBRACE] = ACTIONS(680),
    [anon_sym_assert] = ACTIONS(682),
    [anon_sym_switch] = ACTIONS(682),
    [anon_sym_case] = ACTIONS(682),
    [anon_sym_default] = ACTIONS(682),
    [anon_sym_do] = ACTIONS(682),
    [anon_sym_while] = ACTIONS(682),
    [anon_sym_break] = ACTIONS(682),
    [anon_sym_continue] = ACTIONS(682),
    [anon_sym_return] = ACTIONS(682),
    [anon_sym_synchronized] = ACTIONS(682),
    [anon_sym_throw] = ACTIONS(682),
    [anon_sym_try] = ACTIONS(682),
    [anon_sym_if] = ACTIONS(682),
    [anon_sym_else] = ACTIONS(682),
    [anon_sym_for] = ACTIONS(682),
    [anon_sym_AT] = ACTIONS(682),
    [anon_sym_open] = ACTIONS(682),
    [anon_sym_module] = ACTIONS(682),
    [anon_sym_static] = ACTIONS(682),
    [anon_sym_package] = ACTIONS(682),
    [anon_sym_import] = ACTIONS(682),
    [anon_sym_enum] = ACTIONS(682),
    [anon_sym_public] = ACTIONS(682),
    [anon_sym_protected] = ACTIONS(682),
    [anon_sym_private] = ACTIONS(682),
    [anon_sym_abstract] = ACTIONS(682),
    [anon_sym_final] = ACTIONS(682),
    [anon_sym_strictfp] = ACTIONS(682),
    [anon_sym_native] = ACTIONS(682),
    [anon_sym_transient] = ACTIONS(682),
    [anon_sym_volatile] = ACTIONS(682),
    [anon_sym_ATinterface] = ACTIONS(680),
    [anon_sym_interface] = ACTIONS(682),
    [anon_sym_byte] = ACTIONS(682),
    [anon_sym_short] = ACTIONS(682),
    [anon_sym_int] = ACTIONS(682),
    [anon_sym_long] = ACTIONS(682),
    [anon_sym_char] = ACTIONS(682),
    [anon_sym_float] = ACTIONS(682),
    [anon_sym_double] = ACTIONS(682),
    [sym_boolean_type] = ACTIONS(682),
    [sym_void_type] = ACTIONS(682),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(682),
    [sym_comment] = ACTIONS(3),
  },
  [123] = {
    [ts_builtin_sym_end] = ACTIONS(684),
    [sym_identifier] = ACTIONS(686),
    [sym_decimal_integer_literal] = ACTIONS(686),
    [sym_hex_integer_literal] = ACTIONS(686),
    [sym_octal_integer_literal] = ACTIONS(684),
    [sym_binary_integer_literal] = ACTIONS(684),
    [sym_decimal_floating_point_literal] = ACTIONS(684),
    [sym_hex_floating_point_literal] = ACTIONS(686),
    [sym_true] = ACTIONS(686),
    [sym_false] = ACTIONS(686),
    [sym_character_literal] = ACTIONS(684),
    [sym_string_literal] = ACTIONS(684),
    [sym_null_literal] = ACTIONS(686),
    [anon_sym_LPAREN] = ACTIONS(684),
    [anon_sym_PLUS] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(686),
    [anon_sym_BANG] = ACTIONS(684),
    [anon_sym_TILDE] = ACTIONS(684),
    [anon_sym_PLUS_PLUS] = ACTIONS(684),
    [anon_sym_DASH_DASH] = ACTIONS(684),
    [anon_sym_new] = ACTIONS(686),
    [anon_sym_class] = ACTIONS(686),
    [anon_sym_SEMI] = ACTIONS(684),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_RBRACE] = ACTIONS(684),
    [anon_sym_assert] = ACTIONS(686),
    [anon_sym_switch] = ACTIONS(686),
    [anon_sym_case] = ACTIONS(686),
    [anon_sym_default] = ACTIONS(686),
    [anon_sym_do] = ACTIONS(686),
    [anon_sym_while] = ACTIONS(686),
    [anon_sym_break] = ACTIONS(686),
    [anon_sym_continue] = ACTIONS(686),
    [anon_sym_return] = ACTIONS(686),
    [anon_sym_synchronized] = ACTIONS(686),
    [anon_sym_throw] = ACTIONS(686),
    [anon_sym_try] = ACTIONS(686),
    [anon_sym_if] = ACTIONS(686),
    [anon_sym_else] = ACTIONS(686),
    [anon_sym_for] = ACTIONS(686),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_open] = ACTIONS(686),
    [anon_sym_module] = ACTIONS(686),
    [anon_sym_static] = ACTIONS(686),
    [anon_sym_package] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(686),
    [anon_sym_enum] = ACTIONS(686),
    [anon_sym_public] = ACTIONS(686),
    [anon_sym_protected] = ACTIONS(686),
    [anon_sym_private] = ACTIONS(686),
    [anon_sym_abstract] = ACTIONS(686),
    [anon_sym_final] = ACTIONS(686),
    [anon_sym_strictfp] = ACTIONS(686),
    [anon_sym_native] = ACTIONS(686),
    [anon_sym_transient] = ACTIONS(686),
    [anon_sym_volatile] = ACTIONS(686),
    [anon_sym_ATinterface] = ACTIONS(684),
    [anon_sym_interface] = ACTIONS(686),
    [anon_sym_byte] = ACTIONS(686),
    [anon_sym_short] = ACTIONS(686),
    [anon_sym_int] = ACTIONS(686),
    [anon_sym_long] = ACTIONS(686),
    [anon_sym_char] = ACTIONS(686),
    [anon_sym_float] = ACTIONS(686),
    [anon_sym_double] = ACTIONS(686),
    [sym_boolean_type] = ACTIONS(686),
    [sym_void_type] = ACTIONS(686),
    [sym_this] = ACTIONS(686),
    [sym_super] = ACTIONS(686),
    [sym_comment] = ACTIONS(3),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(688),
    [sym_identifier] = ACTIONS(690),
    [sym_decimal_integer_literal] = ACTIONS(690),
    [sym_hex_integer_literal] = ACTIONS(690),
    [sym_octal_integer_literal] = ACTIONS(688),
    [sym_binary_integer_literal] = ACTIONS(688),
    [sym_decimal_floating_point_literal] = ACTIONS(688),
    [sym_hex_floating_point_literal] = ACTIONS(690),
    [sym_true] = ACTIONS(690),
    [sym_false] = ACTIONS(690),
    [sym_character_literal] = ACTIONS(688),
    [sym_string_literal] = ACTIONS(688),
    [sym_null_literal] = ACTIONS(690),
    [anon_sym_LPAREN] = ACTIONS(688),
    [anon_sym_PLUS] = ACTIONS(690),
    [anon_sym_DASH] = ACTIONS(690),
    [anon_sym_BANG] = ACTIONS(688),
    [anon_sym_TILDE] = ACTIONS(688),
    [anon_sym_PLUS_PLUS] = ACTIONS(688),
    [anon_sym_DASH_DASH] = ACTIONS(688),
    [anon_sym_new] = ACTIONS(690),
    [anon_sym_class] = ACTIONS(690),
    [anon_sym_SEMI] = ACTIONS(688),
    [anon_sym_LBRACE] = ACTIONS(688),
    [anon_sym_RBRACE] = ACTIONS(688),
    [anon_sym_assert] = ACTIONS(690),
    [anon_sym_switch] = ACTIONS(690),
    [anon_sym_case] = ACTIONS(690),
    [anon_sym_default] = ACTIONS(690),
    [anon_sym_do] = ACTIONS(690),
    [anon_sym_while] = ACTIONS(690),
    [anon_sym_break] = ACTIONS(690),
    [anon_sym_continue] = ACTIONS(690),
    [anon_sym_return] = ACTIONS(690),
    [anon_sym_synchronized] = ACTIONS(690),
    [anon_sym_throw] = ACTIONS(690),
    [anon_sym_try] = ACTIONS(690),
    [anon_sym_if] = ACTIONS(690),
    [anon_sym_else] = ACTIONS(690),
    [anon_sym_for] = ACTIONS(690),
    [anon_sym_AT] = ACTIONS(690),
    [anon_sym_open] = ACTIONS(690),
    [anon_sym_module] = ACTIONS(690),
    [anon_sym_static] = ACTIONS(690),
    [anon_sym_package] = ACTIONS(690),
    [anon_sym_import] = ACTIONS(690),
    [anon_sym_enum] = ACTIONS(690),
    [anon_sym_public] = ACTIONS(690),
    [anon_sym_protected] = ACTIONS(690),
    [anon_sym_private] = ACTIONS(690),
    [anon_sym_abstract] = ACTIONS(690),
    [anon_sym_final] = ACTIONS(690),
    [anon_sym_strictfp] = ACTIONS(690),
    [anon_sym_native] = ACTIONS(690),
    [anon_sym_transient] = ACTIONS(690),
    [anon_sym_volatile] = ACTIONS(690),
    [anon_sym_ATinterface] = ACTIONS(688),
    [anon_sym_interface] = ACTIONS(690),
    [anon_sym_byte] = ACTIONS(690),
    [anon_sym_short] = ACTIONS(690),
    [anon_sym_int] = ACTIONS(690),
    [anon_sym_long] = ACTIONS(690),
    [anon_sym_char] = ACTIONS(690),
    [anon_sym_float] = ACTIONS(690),
    [anon_sym_double] = ACTIONS(690),
    [sym_boolean_type] = ACTIONS(690),
    [sym_void_type] = ACTIONS(690),
    [sym_this] = ACTIONS(690),
    [sym_super] = ACTIONS(690),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(692),
    [sym_identifier] = ACTIONS(694),
    [sym_decimal_integer_literal] = ACTIONS(694),
    [sym_hex_integer_literal] = ACTIONS(694),
    [sym_octal_integer_literal] = ACTIONS(692),
    [sym_binary_integer_literal] = ACTIONS(692),
    [sym_decimal_floating_point_literal] = ACTIONS(692),
    [sym_hex_floating_point_literal] = ACTIONS(694),
    [sym_true] = ACTIONS(694),
    [sym_false] = ACTIONS(694),
    [sym_character_literal] = ACTIONS(692),
    [sym_string_literal] = ACTIONS(692),
    [sym_null_literal] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(692),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(692),
    [anon_sym_TILDE] = ACTIONS(692),
    [anon_sym_PLUS_PLUS] = ACTIONS(692),
    [anon_sym_DASH_DASH] = ACTIONS(692),
    [anon_sym_new] = ACTIONS(694),
    [anon_sym_class] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(692),
    [anon_sym_LBRACE] = ACTIONS(692),
    [anon_sym_RBRACE] = ACTIONS(692),
    [anon_sym_assert] = ACTIONS(694),
    [anon_sym_switch] = ACTIONS(694),
    [anon_sym_case] = ACTIONS(694),
    [anon_sym_default] = ACTIONS(694),
    [anon_sym_do] = ACTIONS(694),
    [anon_sym_while] = ACTIONS(694),
    [anon_sym_break] = ACTIONS(694),
    [anon_sym_continue] = ACTIONS(694),
    [anon_sym_return] = ACTIONS(694),
    [anon_sym_synchronized] = ACTIONS(694),
    [anon_sym_throw] = ACTIONS(694),
    [anon_sym_try] = ACTIONS(694),
    [anon_sym_if] = ACTIONS(694),
    [anon_sym_else] = ACTIONS(694),
    [anon_sym_for] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_open] = ACTIONS(694),
    [anon_sym_module] = ACTIONS(694),
    [anon_sym_static] = ACTIONS(694),
    [anon_sym_package] = ACTIONS(694),
    [anon_sym_import] = ACTIONS(694),
    [anon_sym_enum] = ACTIONS(694),
    [anon_sym_public] = ACTIONS(694),
    [anon_sym_protected] = ACTIONS(694),
    [anon_sym_private] = ACTIONS(694),
    [anon_sym_abstract] = ACTIONS(694),
    [anon_sym_final] = ACTIONS(694),
    [anon_sym_strictfp] = ACTIONS(694),
    [anon_sym_native] = ACTIONS(694),
    [anon_sym_transient] = ACTIONS(694),
    [anon_sym_volatile] = ACTIONS(694),
    [anon_sym_ATinterface] = ACTIONS(692),
    [anon_sym_interface] = ACTIONS(694),
    [anon_sym_byte] = ACTIONS(694),
    [anon_sym_short] = ACTIONS(694),
    [anon_sym_int] = ACTIONS(694),
    [anon_sym_long] = ACTIONS(694),
    [anon_sym_char] = ACTIONS(694),
    [anon_sym_float] = ACTIONS(694),
    [anon_sym_double] = ACTIONS(694),
    [sym_boolean_type] = ACTIONS(694),
    [sym_void_type] = ACTIONS(694),
    [sym_this] = ACTIONS(694),
    [sym_super] = ACTIONS(694),
    [sym_comment] = ACTIONS(3),
  },
  [126] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(372),
    [sym_cast_expression] = STATE(372),
    [sym_assignment_expression] = STATE(372),
    [sym_binary_expression] = STATE(372),
    [sym_instanceof_expression] = STATE(372),
    [sym_lambda_expression] = STATE(372),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(372),
    [sym_unary_expression] = STATE(372),
    [sym_update_expression] = STATE(372),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(355),
    [sym_cast_expression] = STATE(355),
    [sym_assignment_expression] = STATE(355),
    [sym_binary_expression] = STATE(355),
    [sym_instanceof_expression] = STATE(355),
    [sym_lambda_expression] = STATE(355),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(355),
    [sym_unary_expression] = STATE(355),
    [sym_update_expression] = STATE(355),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [128] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(357),
    [sym_cast_expression] = STATE(357),
    [sym_assignment_expression] = STATE(357),
    [sym_binary_expression] = STATE(357),
    [sym_instanceof_expression] = STATE(357),
    [sym_lambda_expression] = STATE(357),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(357),
    [sym_unary_expression] = STATE(357),
    [sym_update_expression] = STATE(357),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [129] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(358),
    [sym_cast_expression] = STATE(358),
    [sym_assignment_expression] = STATE(358),
    [sym_binary_expression] = STATE(358),
    [sym_instanceof_expression] = STATE(358),
    [sym_lambda_expression] = STATE(358),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(358),
    [sym_unary_expression] = STATE(358),
    [sym_update_expression] = STATE(358),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(356),
    [sym_cast_expression] = STATE(356),
    [sym_assignment_expression] = STATE(356),
    [sym_binary_expression] = STATE(356),
    [sym_instanceof_expression] = STATE(356),
    [sym_lambda_expression] = STATE(356),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(356),
    [sym_unary_expression] = STATE(356),
    [sym_update_expression] = STATE(356),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [131] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(365),
    [sym_cast_expression] = STATE(365),
    [sym_assignment_expression] = STATE(365),
    [sym_binary_expression] = STATE(365),
    [sym_instanceof_expression] = STATE(365),
    [sym_lambda_expression] = STATE(365),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(365),
    [sym_unary_expression] = STATE(365),
    [sym_update_expression] = STATE(365),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(369),
    [sym_cast_expression] = STATE(369),
    [sym_assignment_expression] = STATE(369),
    [sym_binary_expression] = STATE(369),
    [sym_instanceof_expression] = STATE(369),
    [sym_lambda_expression] = STATE(369),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(369),
    [sym_unary_expression] = STATE(369),
    [sym_update_expression] = STATE(369),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [133] = {
    [ts_builtin_sym_end] = ACTIONS(696),
    [sym_identifier] = ACTIONS(698),
    [sym_decimal_integer_literal] = ACTIONS(698),
    [sym_hex_integer_literal] = ACTIONS(698),
    [sym_octal_integer_literal] = ACTIONS(696),
    [sym_binary_integer_literal] = ACTIONS(696),
    [sym_decimal_floating_point_literal] = ACTIONS(696),
    [sym_hex_floating_point_literal] = ACTIONS(698),
    [sym_true] = ACTIONS(698),
    [sym_false] = ACTIONS(698),
    [sym_character_literal] = ACTIONS(696),
    [sym_string_literal] = ACTIONS(696),
    [sym_null_literal] = ACTIONS(698),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(698),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_PLUS_PLUS] = ACTIONS(696),
    [anon_sym_DASH_DASH] = ACTIONS(696),
    [anon_sym_new] = ACTIONS(698),
    [anon_sym_class] = ACTIONS(698),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_assert] = ACTIONS(698),
    [anon_sym_switch] = ACTIONS(698),
    [anon_sym_case] = ACTIONS(698),
    [anon_sym_default] = ACTIONS(698),
    [anon_sym_do] = ACTIONS(698),
    [anon_sym_while] = ACTIONS(698),
    [anon_sym_break] = ACTIONS(698),
    [anon_sym_continue] = ACTIONS(698),
    [anon_sym_return] = ACTIONS(698),
    [anon_sym_synchronized] = ACTIONS(698),
    [anon_sym_throw] = ACTIONS(698),
    [anon_sym_try] = ACTIONS(698),
    [anon_sym_if] = ACTIONS(698),
    [anon_sym_else] = ACTIONS(698),
    [anon_sym_for] = ACTIONS(698),
    [anon_sym_AT] = ACTIONS(698),
    [anon_sym_open] = ACTIONS(698),
    [anon_sym_module] = ACTIONS(698),
    [anon_sym_static] = ACTIONS(698),
    [anon_sym_package] = ACTIONS(698),
    [anon_sym_import] = ACTIONS(698),
    [anon_sym_enum] = ACTIONS(698),
    [anon_sym_public] = ACTIONS(698),
    [anon_sym_protected] = ACTIONS(698),
    [anon_sym_private] = ACTIONS(698),
    [anon_sym_abstract] = ACTIONS(698),
    [anon_sym_final] = ACTIONS(698),
    [anon_sym_strictfp] = ACTIONS(698),
    [anon_sym_native] = ACTIONS(698),
    [anon_sym_transient] = ACTIONS(698),
    [anon_sym_volatile] = ACTIONS(698),
    [anon_sym_ATinterface] = ACTIONS(696),
    [anon_sym_interface] = ACTIONS(698),
    [anon_sym_byte] = ACTIONS(698),
    [anon_sym_short] = ACTIONS(698),
    [anon_sym_int] = ACTIONS(698),
    [anon_sym_long] = ACTIONS(698),
    [anon_sym_char] = ACTIONS(698),
    [anon_sym_float] = ACTIONS(698),
    [anon_sym_double] = ACTIONS(698),
    [sym_boolean_type] = ACTIONS(698),
    [sym_void_type] = ACTIONS(698),
    [sym_this] = ACTIONS(698),
    [sym_super] = ACTIONS(698),
    [sym_comment] = ACTIONS(3),
  },
  [134] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(427),
    [sym_cast_expression] = STATE(427),
    [sym_assignment_expression] = STATE(427),
    [sym_binary_expression] = STATE(427),
    [sym_instanceof_expression] = STATE(427),
    [sym_lambda_expression] = STATE(427),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(427),
    [sym_unary_expression] = STATE(427),
    [sym_update_expression] = STATE(427),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [135] = {
    [ts_builtin_sym_end] = ACTIONS(700),
    [sym_identifier] = ACTIONS(702),
    [sym_decimal_integer_literal] = ACTIONS(702),
    [sym_hex_integer_literal] = ACTIONS(702),
    [sym_octal_integer_literal] = ACTIONS(700),
    [sym_binary_integer_literal] = ACTIONS(700),
    [sym_decimal_floating_point_literal] = ACTIONS(700),
    [sym_hex_floating_point_literal] = ACTIONS(702),
    [sym_true] = ACTIONS(702),
    [sym_false] = ACTIONS(702),
    [sym_character_literal] = ACTIONS(700),
    [sym_string_literal] = ACTIONS(700),
    [sym_null_literal] = ACTIONS(702),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(702),
    [anon_sym_DASH] = ACTIONS(702),
    [anon_sym_BANG] = ACTIONS(700),
    [anon_sym_TILDE] = ACTIONS(700),
    [anon_sym_PLUS_PLUS] = ACTIONS(700),
    [anon_sym_DASH_DASH] = ACTIONS(700),
    [anon_sym_new] = ACTIONS(702),
    [anon_sym_class] = ACTIONS(702),
    [anon_sym_SEMI] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(700),
    [anon_sym_RBRACE] = ACTIONS(700),
    [anon_sym_assert] = ACTIONS(702),
    [anon_sym_switch] = ACTIONS(702),
    [anon_sym_case] = ACTIONS(702),
    [anon_sym_default] = ACTIONS(702),
    [anon_sym_do] = ACTIONS(702),
    [anon_sym_while] = ACTIONS(702),
    [anon_sym_break] = ACTIONS(702),
    [anon_sym_continue] = ACTIONS(702),
    [anon_sym_return] = ACTIONS(702),
    [anon_sym_synchronized] = ACTIONS(702),
    [anon_sym_throw] = ACTIONS(702),
    [anon_sym_try] = ACTIONS(702),
    [anon_sym_if] = ACTIONS(702),
    [anon_sym_else] = ACTIONS(702),
    [anon_sym_for] = ACTIONS(702),
    [anon_sym_AT] = ACTIONS(702),
    [anon_sym_open] = ACTIONS(702),
    [anon_sym_module] = ACTIONS(702),
    [anon_sym_static] = ACTIONS(702),
    [anon_sym_package] = ACTIONS(702),
    [anon_sym_import] = ACTIONS(702),
    [anon_sym_enum] = ACTIONS(702),
    [anon_sym_public] = ACTIONS(702),
    [anon_sym_protected] = ACTIONS(702),
    [anon_sym_private] = ACTIONS(702),
    [anon_sym_abstract] = ACTIONS(702),
    [anon_sym_final] = ACTIONS(702),
    [anon_sym_strictfp] = ACTIONS(702),
    [anon_sym_native] = ACTIONS(702),
    [anon_sym_transient] = ACTIONS(702),
    [anon_sym_volatile] = ACTIONS(702),
    [anon_sym_ATinterface] = ACTIONS(700),
    [anon_sym_interface] = ACTIONS(702),
    [anon_sym_byte] = ACTIONS(702),
    [anon_sym_short] = ACTIONS(702),
    [anon_sym_int] = ACTIONS(702),
    [anon_sym_long] = ACTIONS(702),
    [anon_sym_char] = ACTIONS(702),
    [anon_sym_float] = ACTIONS(702),
    [anon_sym_double] = ACTIONS(702),
    [sym_boolean_type] = ACTIONS(702),
    [sym_void_type] = ACTIONS(702),
    [sym_this] = ACTIONS(702),
    [sym_super] = ACTIONS(702),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(704),
    [sym_identifier] = ACTIONS(706),
    [sym_decimal_integer_literal] = ACTIONS(706),
    [sym_hex_integer_literal] = ACTIONS(706),
    [sym_octal_integer_literal] = ACTIONS(704),
    [sym_binary_integer_literal] = ACTIONS(704),
    [sym_decimal_floating_point_literal] = ACTIONS(704),
    [sym_hex_floating_point_literal] = ACTIONS(706),
    [sym_true] = ACTIONS(706),
    [sym_false] = ACTIONS(706),
    [sym_character_literal] = ACTIONS(704),
    [sym_string_literal] = ACTIONS(704),
    [sym_null_literal] = ACTIONS(706),
    [anon_sym_LPAREN] = ACTIONS(704),
    [anon_sym_PLUS] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(706),
    [anon_sym_BANG] = ACTIONS(704),
    [anon_sym_TILDE] = ACTIONS(704),
    [anon_sym_PLUS_PLUS] = ACTIONS(704),
    [anon_sym_DASH_DASH] = ACTIONS(704),
    [anon_sym_new] = ACTIONS(706),
    [anon_sym_class] = ACTIONS(706),
    [anon_sym_SEMI] = ACTIONS(704),
    [anon_sym_LBRACE] = ACTIONS(704),
    [anon_sym_RBRACE] = ACTIONS(704),
    [anon_sym_assert] = ACTIONS(706),
    [anon_sym_switch] = ACTIONS(706),
    [anon_sym_case] = ACTIONS(706),
    [anon_sym_default] = ACTIONS(706),
    [anon_sym_do] = ACTIONS(706),
    [anon_sym_while] = ACTIONS(706),
    [anon_sym_break] = ACTIONS(706),
    [anon_sym_continue] = ACTIONS(706),
    [anon_sym_return] = ACTIONS(706),
    [anon_sym_synchronized] = ACTIONS(706),
    [anon_sym_throw] = ACTIONS(706),
    [anon_sym_try] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(706),
    [anon_sym_else] = ACTIONS(706),
    [anon_sym_for] = ACTIONS(706),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_open] = ACTIONS(706),
    [anon_sym_module] = ACTIONS(706),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_package] = ACTIONS(706),
    [anon_sym_import] = ACTIONS(706),
    [anon_sym_enum] = ACTIONS(706),
    [anon_sym_public] = ACTIONS(706),
    [anon_sym_protected] = ACTIONS(706),
    [anon_sym_private] = ACTIONS(706),
    [anon_sym_abstract] = ACTIONS(706),
    [anon_sym_final] = ACTIONS(706),
    [anon_sym_strictfp] = ACTIONS(706),
    [anon_sym_native] = ACTIONS(706),
    [anon_sym_transient] = ACTIONS(706),
    [anon_sym_volatile] = ACTIONS(706),
    [anon_sym_ATinterface] = ACTIONS(704),
    [anon_sym_interface] = ACTIONS(706),
    [anon_sym_byte] = ACTIONS(706),
    [anon_sym_short] = ACTIONS(706),
    [anon_sym_int] = ACTIONS(706),
    [anon_sym_long] = ACTIONS(706),
    [anon_sym_char] = ACTIONS(706),
    [anon_sym_float] = ACTIONS(706),
    [anon_sym_double] = ACTIONS(706),
    [sym_boolean_type] = ACTIONS(706),
    [sym_void_type] = ACTIONS(706),
    [sym_this] = ACTIONS(706),
    [sym_super] = ACTIONS(706),
    [sym_comment] = ACTIONS(3),
  },
  [137] = {
    [ts_builtin_sym_end] = ACTIONS(708),
    [sym_identifier] = ACTIONS(710),
    [sym_decimal_integer_literal] = ACTIONS(710),
    [sym_hex_integer_literal] = ACTIONS(710),
    [sym_octal_integer_literal] = ACTIONS(708),
    [sym_binary_integer_literal] = ACTIONS(708),
    [sym_decimal_floating_point_literal] = ACTIONS(708),
    [sym_hex_floating_point_literal] = ACTIONS(710),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_character_literal] = ACTIONS(708),
    [sym_string_literal] = ACTIONS(708),
    [sym_null_literal] = ACTIONS(710),
    [anon_sym_LPAREN] = ACTIONS(708),
    [anon_sym_PLUS] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(710),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(708),
    [anon_sym_PLUS_PLUS] = ACTIONS(708),
    [anon_sym_DASH_DASH] = ACTIONS(708),
    [anon_sym_new] = ACTIONS(710),
    [anon_sym_class] = ACTIONS(710),
    [anon_sym_SEMI] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(708),
    [anon_sym_RBRACE] = ACTIONS(708),
    [anon_sym_assert] = ACTIONS(710),
    [anon_sym_switch] = ACTIONS(710),
    [anon_sym_case] = ACTIONS(710),
    [anon_sym_default] = ACTIONS(710),
    [anon_sym_do] = ACTIONS(710),
    [anon_sym_while] = ACTIONS(710),
    [anon_sym_break] = ACTIONS(710),
    [anon_sym_continue] = ACTIONS(710),
    [anon_sym_return] = ACTIONS(710),
    [anon_sym_synchronized] = ACTIONS(710),
    [anon_sym_throw] = ACTIONS(710),
    [anon_sym_try] = ACTIONS(710),
    [anon_sym_if] = ACTIONS(710),
    [anon_sym_else] = ACTIONS(710),
    [anon_sym_for] = ACTIONS(710),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_open] = ACTIONS(710),
    [anon_sym_module] = ACTIONS(710),
    [anon_sym_static] = ACTIONS(710),
    [anon_sym_package] = ACTIONS(710),
    [anon_sym_import] = ACTIONS(710),
    [anon_sym_enum] = ACTIONS(710),
    [anon_sym_public] = ACTIONS(710),
    [anon_sym_protected] = ACTIONS(710),
    [anon_sym_private] = ACTIONS(710),
    [anon_sym_abstract] = ACTIONS(710),
    [anon_sym_final] = ACTIONS(710),
    [anon_sym_strictfp] = ACTIONS(710),
    [anon_sym_native] = ACTIONS(710),
    [anon_sym_transient] = ACTIONS(710),
    [anon_sym_volatile] = ACTIONS(710),
    [anon_sym_ATinterface] = ACTIONS(708),
    [anon_sym_interface] = ACTIONS(710),
    [anon_sym_byte] = ACTIONS(710),
    [anon_sym_short] = ACTIONS(710),
    [anon_sym_int] = ACTIONS(710),
    [anon_sym_long] = ACTIONS(710),
    [anon_sym_char] = ACTIONS(710),
    [anon_sym_float] = ACTIONS(710),
    [anon_sym_double] = ACTIONS(710),
    [sym_boolean_type] = ACTIONS(710),
    [sym_void_type] = ACTIONS(710),
    [sym_this] = ACTIONS(710),
    [sym_super] = ACTIONS(710),
    [sym_comment] = ACTIONS(3),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(712),
    [sym_identifier] = ACTIONS(714),
    [sym_decimal_integer_literal] = ACTIONS(714),
    [sym_hex_integer_literal] = ACTIONS(714),
    [sym_octal_integer_literal] = ACTIONS(712),
    [sym_binary_integer_literal] = ACTIONS(712),
    [sym_decimal_floating_point_literal] = ACTIONS(712),
    [sym_hex_floating_point_literal] = ACTIONS(714),
    [sym_true] = ACTIONS(714),
    [sym_false] = ACTIONS(714),
    [sym_character_literal] = ACTIONS(712),
    [sym_string_literal] = ACTIONS(712),
    [sym_null_literal] = ACTIONS(714),
    [anon_sym_LPAREN] = ACTIONS(712),
    [anon_sym_PLUS] = ACTIONS(714),
    [anon_sym_DASH] = ACTIONS(714),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(712),
    [anon_sym_PLUS_PLUS] = ACTIONS(712),
    [anon_sym_DASH_DASH] = ACTIONS(712),
    [anon_sym_new] = ACTIONS(714),
    [anon_sym_class] = ACTIONS(714),
    [anon_sym_SEMI] = ACTIONS(712),
    [anon_sym_LBRACE] = ACTIONS(712),
    [anon_sym_RBRACE] = ACTIONS(712),
    [anon_sym_assert] = ACTIONS(714),
    [anon_sym_switch] = ACTIONS(714),
    [anon_sym_case] = ACTIONS(714),
    [anon_sym_default] = ACTIONS(714),
    [anon_sym_do] = ACTIONS(714),
    [anon_sym_while] = ACTIONS(714),
    [anon_sym_break] = ACTIONS(714),
    [anon_sym_continue] = ACTIONS(714),
    [anon_sym_return] = ACTIONS(714),
    [anon_sym_synchronized] = ACTIONS(714),
    [anon_sym_throw] = ACTIONS(714),
    [anon_sym_try] = ACTIONS(714),
    [anon_sym_if] = ACTIONS(714),
    [anon_sym_else] = ACTIONS(714),
    [anon_sym_for] = ACTIONS(714),
    [anon_sym_AT] = ACTIONS(714),
    [anon_sym_open] = ACTIONS(714),
    [anon_sym_module] = ACTIONS(714),
    [anon_sym_static] = ACTIONS(714),
    [anon_sym_package] = ACTIONS(714),
    [anon_sym_import] = ACTIONS(714),
    [anon_sym_enum] = ACTIONS(714),
    [anon_sym_public] = ACTIONS(714),
    [anon_sym_protected] = ACTIONS(714),
    [anon_sym_private] = ACTIONS(714),
    [anon_sym_abstract] = ACTIONS(714),
    [anon_sym_final] = ACTIONS(714),
    [anon_sym_strictfp] = ACTIONS(714),
    [anon_sym_native] = ACTIONS(714),
    [anon_sym_transient] = ACTIONS(714),
    [anon_sym_volatile] = ACTIONS(714),
    [anon_sym_ATinterface] = ACTIONS(712),
    [anon_sym_interface] = ACTIONS(714),
    [anon_sym_byte] = ACTIONS(714),
    [anon_sym_short] = ACTIONS(714),
    [anon_sym_int] = ACTIONS(714),
    [anon_sym_long] = ACTIONS(714),
    [anon_sym_char] = ACTIONS(714),
    [anon_sym_float] = ACTIONS(714),
    [anon_sym_double] = ACTIONS(714),
    [sym_boolean_type] = ACTIONS(714),
    [sym_void_type] = ACTIONS(714),
    [sym_this] = ACTIONS(714),
    [sym_super] = ACTIONS(714),
    [sym_comment] = ACTIONS(3),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(716),
    [sym_identifier] = ACTIONS(718),
    [sym_decimal_integer_literal] = ACTIONS(718),
    [sym_hex_integer_literal] = ACTIONS(718),
    [sym_octal_integer_literal] = ACTIONS(716),
    [sym_binary_integer_literal] = ACTIONS(716),
    [sym_decimal_floating_point_literal] = ACTIONS(716),
    [sym_hex_floating_point_literal] = ACTIONS(718),
    [sym_true] = ACTIONS(718),
    [sym_false] = ACTIONS(718),
    [sym_character_literal] = ACTIONS(716),
    [sym_string_literal] = ACTIONS(716),
    [sym_null_literal] = ACTIONS(718),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_PLUS] = ACTIONS(718),
    [anon_sym_DASH] = ACTIONS(718),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(716),
    [anon_sym_PLUS_PLUS] = ACTIONS(716),
    [anon_sym_DASH_DASH] = ACTIONS(716),
    [anon_sym_new] = ACTIONS(718),
    [anon_sym_class] = ACTIONS(718),
    [anon_sym_SEMI] = ACTIONS(716),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_RBRACE] = ACTIONS(716),
    [anon_sym_assert] = ACTIONS(718),
    [anon_sym_switch] = ACTIONS(718),
    [anon_sym_case] = ACTIONS(718),
    [anon_sym_default] = ACTIONS(718),
    [anon_sym_do] = ACTIONS(718),
    [anon_sym_while] = ACTIONS(718),
    [anon_sym_break] = ACTIONS(718),
    [anon_sym_continue] = ACTIONS(718),
    [anon_sym_return] = ACTIONS(718),
    [anon_sym_synchronized] = ACTIONS(718),
    [anon_sym_throw] = ACTIONS(718),
    [anon_sym_try] = ACTIONS(718),
    [anon_sym_if] = ACTIONS(718),
    [anon_sym_else] = ACTIONS(718),
    [anon_sym_for] = ACTIONS(718),
    [anon_sym_AT] = ACTIONS(718),
    [anon_sym_open] = ACTIONS(718),
    [anon_sym_module] = ACTIONS(718),
    [anon_sym_static] = ACTIONS(718),
    [anon_sym_package] = ACTIONS(718),
    [anon_sym_import] = ACTIONS(718),
    [anon_sym_enum] = ACTIONS(718),
    [anon_sym_public] = ACTIONS(718),
    [anon_sym_protected] = ACTIONS(718),
    [anon_sym_private] = ACTIONS(718),
    [anon_sym_abstract] = ACTIONS(718),
    [anon_sym_final] = ACTIONS(718),
    [anon_sym_strictfp] = ACTIONS(718),
    [anon_sym_native] = ACTIONS(718),
    [anon_sym_transient] = ACTIONS(718),
    [anon_sym_volatile] = ACTIONS(718),
    [anon_sym_ATinterface] = ACTIONS(716),
    [anon_sym_interface] = ACTIONS(718),
    [anon_sym_byte] = ACTIONS(718),
    [anon_sym_short] = ACTIONS(718),
    [anon_sym_int] = ACTIONS(718),
    [anon_sym_long] = ACTIONS(718),
    [anon_sym_char] = ACTIONS(718),
    [anon_sym_float] = ACTIONS(718),
    [anon_sym_double] = ACTIONS(718),
    [sym_boolean_type] = ACTIONS(718),
    [sym_void_type] = ACTIONS(718),
    [sym_this] = ACTIONS(718),
    [sym_super] = ACTIONS(718),
    [sym_comment] = ACTIONS(3),
  },
  [140] = {
    [ts_builtin_sym_end] = ACTIONS(720),
    [sym_identifier] = ACTIONS(722),
    [sym_decimal_integer_literal] = ACTIONS(722),
    [sym_hex_integer_literal] = ACTIONS(722),
    [sym_octal_integer_literal] = ACTIONS(720),
    [sym_binary_integer_literal] = ACTIONS(720),
    [sym_decimal_floating_point_literal] = ACTIONS(720),
    [sym_hex_floating_point_literal] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_character_literal] = ACTIONS(720),
    [sym_string_literal] = ACTIONS(720),
    [sym_null_literal] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(720),
    [anon_sym_PLUS] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(722),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_PLUS_PLUS] = ACTIONS(720),
    [anon_sym_DASH_DASH] = ACTIONS(720),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_class] = ACTIONS(722),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_RBRACE] = ACTIONS(720),
    [anon_sym_assert] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_case] = ACTIONS(722),
    [anon_sym_default] = ACTIONS(722),
    [anon_sym_do] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_break] = ACTIONS(722),
    [anon_sym_continue] = ACTIONS(722),
    [anon_sym_return] = ACTIONS(722),
    [anon_sym_synchronized] = ACTIONS(722),
    [anon_sym_throw] = ACTIONS(722),
    [anon_sym_try] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_AT] = ACTIONS(722),
    [anon_sym_open] = ACTIONS(722),
    [anon_sym_module] = ACTIONS(722),
    [anon_sym_static] = ACTIONS(722),
    [anon_sym_package] = ACTIONS(722),
    [anon_sym_import] = ACTIONS(722),
    [anon_sym_enum] = ACTIONS(722),
    [anon_sym_public] = ACTIONS(722),
    [anon_sym_protected] = ACTIONS(722),
    [anon_sym_private] = ACTIONS(722),
    [anon_sym_abstract] = ACTIONS(722),
    [anon_sym_final] = ACTIONS(722),
    [anon_sym_strictfp] = ACTIONS(722),
    [anon_sym_native] = ACTIONS(722),
    [anon_sym_transient] = ACTIONS(722),
    [anon_sym_volatile] = ACTIONS(722),
    [anon_sym_ATinterface] = ACTIONS(720),
    [anon_sym_interface] = ACTIONS(722),
    [anon_sym_byte] = ACTIONS(722),
    [anon_sym_short] = ACTIONS(722),
    [anon_sym_int] = ACTIONS(722),
    [anon_sym_long] = ACTIONS(722),
    [anon_sym_char] = ACTIONS(722),
    [anon_sym_float] = ACTIONS(722),
    [anon_sym_double] = ACTIONS(722),
    [sym_boolean_type] = ACTIONS(722),
    [sym_void_type] = ACTIONS(722),
    [sym_this] = ACTIONS(722),
    [sym_super] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
  },
  [141] = {
    [ts_builtin_sym_end] = ACTIONS(724),
    [sym_identifier] = ACTIONS(726),
    [sym_decimal_integer_literal] = ACTIONS(726),
    [sym_hex_integer_literal] = ACTIONS(726),
    [sym_octal_integer_literal] = ACTIONS(724),
    [sym_binary_integer_literal] = ACTIONS(724),
    [sym_decimal_floating_point_literal] = ACTIONS(724),
    [sym_hex_floating_point_literal] = ACTIONS(726),
    [sym_true] = ACTIONS(726),
    [sym_false] = ACTIONS(726),
    [sym_character_literal] = ACTIONS(724),
    [sym_string_literal] = ACTIONS(724),
    [sym_null_literal] = ACTIONS(726),
    [anon_sym_LPAREN] = ACTIONS(724),
    [anon_sym_PLUS] = ACTIONS(726),
    [anon_sym_DASH] = ACTIONS(726),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(724),
    [anon_sym_PLUS_PLUS] = ACTIONS(724),
    [anon_sym_DASH_DASH] = ACTIONS(724),
    [anon_sym_new] = ACTIONS(726),
    [anon_sym_class] = ACTIONS(726),
    [anon_sym_SEMI] = ACTIONS(724),
    [anon_sym_LBRACE] = ACTIONS(724),
    [anon_sym_RBRACE] = ACTIONS(724),
    [anon_sym_assert] = ACTIONS(726),
    [anon_sym_switch] = ACTIONS(726),
    [anon_sym_case] = ACTIONS(726),
    [anon_sym_default] = ACTIONS(726),
    [anon_sym_do] = ACTIONS(726),
    [anon_sym_while] = ACTIONS(726),
    [anon_sym_break] = ACTIONS(726),
    [anon_sym_continue] = ACTIONS(726),
    [anon_sym_return] = ACTIONS(726),
    [anon_sym_synchronized] = ACTIONS(726),
    [anon_sym_throw] = ACTIONS(726),
    [anon_sym_try] = ACTIONS(726),
    [anon_sym_if] = ACTIONS(726),
    [anon_sym_else] = ACTIONS(726),
    [anon_sym_for] = ACTIONS(726),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_open] = ACTIONS(726),
    [anon_sym_module] = ACTIONS(726),
    [anon_sym_static] = ACTIONS(726),
    [anon_sym_package] = ACTIONS(726),
    [anon_sym_import] = ACTIONS(726),
    [anon_sym_enum] = ACTIONS(726),
    [anon_sym_public] = ACTIONS(726),
    [anon_sym_protected] = ACTIONS(726),
    [anon_sym_private] = ACTIONS(726),
    [anon_sym_abstract] = ACTIONS(726),
    [anon_sym_final] = ACTIONS(726),
    [anon_sym_strictfp] = ACTIONS(726),
    [anon_sym_native] = ACTIONS(726),
    [anon_sym_transient] = ACTIONS(726),
    [anon_sym_volatile] = ACTIONS(726),
    [anon_sym_ATinterface] = ACTIONS(724),
    [anon_sym_interface] = ACTIONS(726),
    [anon_sym_byte] = ACTIONS(726),
    [anon_sym_short] = ACTIONS(726),
    [anon_sym_int] = ACTIONS(726),
    [anon_sym_long] = ACTIONS(726),
    [anon_sym_char] = ACTIONS(726),
    [anon_sym_float] = ACTIONS(726),
    [anon_sym_double] = ACTIONS(726),
    [sym_boolean_type] = ACTIONS(726),
    [sym_void_type] = ACTIONS(726),
    [sym_this] = ACTIONS(726),
    [sym_super] = ACTIONS(726),
    [sym_comment] = ACTIONS(3),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(728),
    [sym_identifier] = ACTIONS(730),
    [sym_decimal_integer_literal] = ACTIONS(730),
    [sym_hex_integer_literal] = ACTIONS(730),
    [sym_octal_integer_literal] = ACTIONS(728),
    [sym_binary_integer_literal] = ACTIONS(728),
    [sym_decimal_floating_point_literal] = ACTIONS(728),
    [sym_hex_floating_point_literal] = ACTIONS(730),
    [sym_true] = ACTIONS(730),
    [sym_false] = ACTIONS(730),
    [sym_character_literal] = ACTIONS(728),
    [sym_string_literal] = ACTIONS(728),
    [sym_null_literal] = ACTIONS(730),
    [anon_sym_LPAREN] = ACTIONS(728),
    [anon_sym_PLUS] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(730),
    [anon_sym_BANG] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(728),
    [anon_sym_PLUS_PLUS] = ACTIONS(728),
    [anon_sym_DASH_DASH] = ACTIONS(728),
    [anon_sym_new] = ACTIONS(730),
    [anon_sym_class] = ACTIONS(730),
    [anon_sym_SEMI] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_RBRACE] = ACTIONS(728),
    [anon_sym_assert] = ACTIONS(730),
    [anon_sym_switch] = ACTIONS(730),
    [anon_sym_case] = ACTIONS(730),
    [anon_sym_default] = ACTIONS(730),
    [anon_sym_do] = ACTIONS(730),
    [anon_sym_while] = ACTIONS(730),
    [anon_sym_break] = ACTIONS(730),
    [anon_sym_continue] = ACTIONS(730),
    [anon_sym_return] = ACTIONS(730),
    [anon_sym_synchronized] = ACTIONS(730),
    [anon_sym_throw] = ACTIONS(730),
    [anon_sym_try] = ACTIONS(730),
    [anon_sym_if] = ACTIONS(730),
    [anon_sym_else] = ACTIONS(730),
    [anon_sym_for] = ACTIONS(730),
    [anon_sym_AT] = ACTIONS(730),
    [anon_sym_open] = ACTIONS(730),
    [anon_sym_module] = ACTIONS(730),
    [anon_sym_static] = ACTIONS(730),
    [anon_sym_package] = ACTIONS(730),
    [anon_sym_import] = ACTIONS(730),
    [anon_sym_enum] = ACTIONS(730),
    [anon_sym_public] = ACTIONS(730),
    [anon_sym_protected] = ACTIONS(730),
    [anon_sym_private] = ACTIONS(730),
    [anon_sym_abstract] = ACTIONS(730),
    [anon_sym_final] = ACTIONS(730),
    [anon_sym_strictfp] = ACTIONS(730),
    [anon_sym_native] = ACTIONS(730),
    [anon_sym_transient] = ACTIONS(730),
    [anon_sym_volatile] = ACTIONS(730),
    [anon_sym_ATinterface] = ACTIONS(728),
    [anon_sym_interface] = ACTIONS(730),
    [anon_sym_byte] = ACTIONS(730),
    [anon_sym_short] = ACTIONS(730),
    [anon_sym_int] = ACTIONS(730),
    [anon_sym_long] = ACTIONS(730),
    [anon_sym_char] = ACTIONS(730),
    [anon_sym_float] = ACTIONS(730),
    [anon_sym_double] = ACTIONS(730),
    [sym_boolean_type] = ACTIONS(730),
    [sym_void_type] = ACTIONS(730),
    [sym_this] = ACTIONS(730),
    [sym_super] = ACTIONS(730),
    [sym_comment] = ACTIONS(3),
  },
  [143] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(416),
    [sym_cast_expression] = STATE(416),
    [sym_assignment_expression] = STATE(416),
    [sym_binary_expression] = STATE(416),
    [sym_instanceof_expression] = STATE(416),
    [sym_lambda_expression] = STATE(416),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(416),
    [sym_unary_expression] = STATE(416),
    [sym_update_expression] = STATE(416),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [144] = {
    [ts_builtin_sym_end] = ACTIONS(732),
    [sym_identifier] = ACTIONS(734),
    [sym_decimal_integer_literal] = ACTIONS(734),
    [sym_hex_integer_literal] = ACTIONS(734),
    [sym_octal_integer_literal] = ACTIONS(732),
    [sym_binary_integer_literal] = ACTIONS(732),
    [sym_decimal_floating_point_literal] = ACTIONS(732),
    [sym_hex_floating_point_literal] = ACTIONS(734),
    [sym_true] = ACTIONS(734),
    [sym_false] = ACTIONS(734),
    [sym_character_literal] = ACTIONS(732),
    [sym_string_literal] = ACTIONS(732),
    [sym_null_literal] = ACTIONS(734),
    [anon_sym_LPAREN] = ACTIONS(732),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_DASH] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(732),
    [anon_sym_PLUS_PLUS] = ACTIONS(732),
    [anon_sym_DASH_DASH] = ACTIONS(732),
    [anon_sym_new] = ACTIONS(734),
    [anon_sym_class] = ACTIONS(734),
    [anon_sym_SEMI] = ACTIONS(732),
    [anon_sym_LBRACE] = ACTIONS(732),
    [anon_sym_RBRACE] = ACTIONS(732),
    [anon_sym_assert] = ACTIONS(734),
    [anon_sym_switch] = ACTIONS(734),
    [anon_sym_case] = ACTIONS(734),
    [anon_sym_default] = ACTIONS(734),
    [anon_sym_do] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(734),
    [anon_sym_break] = ACTIONS(734),
    [anon_sym_continue] = ACTIONS(734),
    [anon_sym_return] = ACTIONS(734),
    [anon_sym_synchronized] = ACTIONS(734),
    [anon_sym_throw] = ACTIONS(734),
    [anon_sym_try] = ACTIONS(734),
    [anon_sym_if] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(734),
    [anon_sym_for] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(734),
    [anon_sym_open] = ACTIONS(734),
    [anon_sym_module] = ACTIONS(734),
    [anon_sym_static] = ACTIONS(734),
    [anon_sym_package] = ACTIONS(734),
    [anon_sym_import] = ACTIONS(734),
    [anon_sym_enum] = ACTIONS(734),
    [anon_sym_public] = ACTIONS(734),
    [anon_sym_protected] = ACTIONS(734),
    [anon_sym_private] = ACTIONS(734),
    [anon_sym_abstract] = ACTIONS(734),
    [anon_sym_final] = ACTIONS(734),
    [anon_sym_strictfp] = ACTIONS(734),
    [anon_sym_native] = ACTIONS(734),
    [anon_sym_transient] = ACTIONS(734),
    [anon_sym_volatile] = ACTIONS(734),
    [anon_sym_ATinterface] = ACTIONS(732),
    [anon_sym_interface] = ACTIONS(734),
    [anon_sym_byte] = ACTIONS(734),
    [anon_sym_short] = ACTIONS(734),
    [anon_sym_int] = ACTIONS(734),
    [anon_sym_long] = ACTIONS(734),
    [anon_sym_char] = ACTIONS(734),
    [anon_sym_float] = ACTIONS(734),
    [anon_sym_double] = ACTIONS(734),
    [sym_boolean_type] = ACTIONS(734),
    [sym_void_type] = ACTIONS(734),
    [sym_this] = ACTIONS(734),
    [sym_super] = ACTIONS(734),
    [sym_comment] = ACTIONS(3),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(736),
    [sym_identifier] = ACTIONS(738),
    [sym_decimal_integer_literal] = ACTIONS(738),
    [sym_hex_integer_literal] = ACTIONS(738),
    [sym_octal_integer_literal] = ACTIONS(736),
    [sym_binary_integer_literal] = ACTIONS(736),
    [sym_decimal_floating_point_literal] = ACTIONS(736),
    [sym_hex_floating_point_literal] = ACTIONS(738),
    [sym_true] = ACTIONS(738),
    [sym_false] = ACTIONS(738),
    [sym_character_literal] = ACTIONS(736),
    [sym_string_literal] = ACTIONS(736),
    [sym_null_literal] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_PLUS_PLUS] = ACTIONS(736),
    [anon_sym_DASH_DASH] = ACTIONS(736),
    [anon_sym_new] = ACTIONS(738),
    [anon_sym_class] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_assert] = ACTIONS(738),
    [anon_sym_switch] = ACTIONS(738),
    [anon_sym_case] = ACTIONS(738),
    [anon_sym_default] = ACTIONS(738),
    [anon_sym_do] = ACTIONS(738),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_break] = ACTIONS(738),
    [anon_sym_continue] = ACTIONS(738),
    [anon_sym_return] = ACTIONS(738),
    [anon_sym_synchronized] = ACTIONS(738),
    [anon_sym_throw] = ACTIONS(738),
    [anon_sym_try] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_else] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_open] = ACTIONS(738),
    [anon_sym_module] = ACTIONS(738),
    [anon_sym_static] = ACTIONS(738),
    [anon_sym_package] = ACTIONS(738),
    [anon_sym_import] = ACTIONS(738),
    [anon_sym_enum] = ACTIONS(738),
    [anon_sym_public] = ACTIONS(738),
    [anon_sym_protected] = ACTIONS(738),
    [anon_sym_private] = ACTIONS(738),
    [anon_sym_abstract] = ACTIONS(738),
    [anon_sym_final] = ACTIONS(738),
    [anon_sym_strictfp] = ACTIONS(738),
    [anon_sym_native] = ACTIONS(738),
    [anon_sym_transient] = ACTIONS(738),
    [anon_sym_volatile] = ACTIONS(738),
    [anon_sym_ATinterface] = ACTIONS(736),
    [anon_sym_interface] = ACTIONS(738),
    [anon_sym_byte] = ACTIONS(738),
    [anon_sym_short] = ACTIONS(738),
    [anon_sym_int] = ACTIONS(738),
    [anon_sym_long] = ACTIONS(738),
    [anon_sym_char] = ACTIONS(738),
    [anon_sym_float] = ACTIONS(738),
    [anon_sym_double] = ACTIONS(738),
    [sym_boolean_type] = ACTIONS(738),
    [sym_void_type] = ACTIONS(738),
    [sym_this] = ACTIONS(738),
    [sym_super] = ACTIONS(738),
    [sym_comment] = ACTIONS(3),
  },
  [146] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(359),
    [sym_cast_expression] = STATE(359),
    [sym_assignment_expression] = STATE(359),
    [sym_binary_expression] = STATE(359),
    [sym_instanceof_expression] = STATE(359),
    [sym_lambda_expression] = STATE(359),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(359),
    [sym_unary_expression] = STATE(359),
    [sym_update_expression] = STATE(359),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [147] = {
    [ts_builtin_sym_end] = ACTIONS(740),
    [sym_identifier] = ACTIONS(742),
    [sym_decimal_integer_literal] = ACTIONS(742),
    [sym_hex_integer_literal] = ACTIONS(742),
    [sym_octal_integer_literal] = ACTIONS(740),
    [sym_binary_integer_literal] = ACTIONS(740),
    [sym_decimal_floating_point_literal] = ACTIONS(740),
    [sym_hex_floating_point_literal] = ACTIONS(742),
    [sym_true] = ACTIONS(742),
    [sym_false] = ACTIONS(742),
    [sym_character_literal] = ACTIONS(740),
    [sym_string_literal] = ACTIONS(740),
    [sym_null_literal] = ACTIONS(742),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(742),
    [anon_sym_DASH] = ACTIONS(742),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_PLUS_PLUS] = ACTIONS(740),
    [anon_sym_DASH_DASH] = ACTIONS(740),
    [anon_sym_new] = ACTIONS(742),
    [anon_sym_class] = ACTIONS(742),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_assert] = ACTIONS(742),
    [anon_sym_switch] = ACTIONS(742),
    [anon_sym_case] = ACTIONS(742),
    [anon_sym_default] = ACTIONS(742),
    [anon_sym_do] = ACTIONS(742),
    [anon_sym_while] = ACTIONS(742),
    [anon_sym_break] = ACTIONS(742),
    [anon_sym_continue] = ACTIONS(742),
    [anon_sym_return] = ACTIONS(742),
    [anon_sym_synchronized] = ACTIONS(742),
    [anon_sym_throw] = ACTIONS(742),
    [anon_sym_try] = ACTIONS(742),
    [anon_sym_if] = ACTIONS(742),
    [anon_sym_else] = ACTIONS(742),
    [anon_sym_for] = ACTIONS(742),
    [anon_sym_AT] = ACTIONS(742),
    [anon_sym_open] = ACTIONS(742),
    [anon_sym_module] = ACTIONS(742),
    [anon_sym_static] = ACTIONS(742),
    [anon_sym_package] = ACTIONS(742),
    [anon_sym_import] = ACTIONS(742),
    [anon_sym_enum] = ACTIONS(742),
    [anon_sym_public] = ACTIONS(742),
    [anon_sym_protected] = ACTIONS(742),
    [anon_sym_private] = ACTIONS(742),
    [anon_sym_abstract] = ACTIONS(742),
    [anon_sym_final] = ACTIONS(742),
    [anon_sym_strictfp] = ACTIONS(742),
    [anon_sym_native] = ACTIONS(742),
    [anon_sym_transient] = ACTIONS(742),
    [anon_sym_volatile] = ACTIONS(742),
    [anon_sym_ATinterface] = ACTIONS(740),
    [anon_sym_interface] = ACTIONS(742),
    [anon_sym_byte] = ACTIONS(742),
    [anon_sym_short] = ACTIONS(742),
    [anon_sym_int] = ACTIONS(742),
    [anon_sym_long] = ACTIONS(742),
    [anon_sym_char] = ACTIONS(742),
    [anon_sym_float] = ACTIONS(742),
    [anon_sym_double] = ACTIONS(742),
    [sym_boolean_type] = ACTIONS(742),
    [sym_void_type] = ACTIONS(742),
    [sym_this] = ACTIONS(742),
    [sym_super] = ACTIONS(742),
    [sym_comment] = ACTIONS(3),
  },
  [148] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(436),
    [sym_cast_expression] = STATE(436),
    [sym_assignment_expression] = STATE(436),
    [sym_binary_expression] = STATE(436),
    [sym_instanceof_expression] = STATE(436),
    [sym_lambda_expression] = STATE(436),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(436),
    [sym_unary_expression] = STATE(436),
    [sym_update_expression] = STATE(436),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [149] = {
    [ts_builtin_sym_end] = ACTIONS(744),
    [sym_identifier] = ACTIONS(746),
    [sym_decimal_integer_literal] = ACTIONS(746),
    [sym_hex_integer_literal] = ACTIONS(746),
    [sym_octal_integer_literal] = ACTIONS(744),
    [sym_binary_integer_literal] = ACTIONS(744),
    [sym_decimal_floating_point_literal] = ACTIONS(744),
    [sym_hex_floating_point_literal] = ACTIONS(746),
    [sym_true] = ACTIONS(746),
    [sym_false] = ACTIONS(746),
    [sym_character_literal] = ACTIONS(744),
    [sym_string_literal] = ACTIONS(744),
    [sym_null_literal] = ACTIONS(746),
    [anon_sym_LPAREN] = ACTIONS(744),
    [anon_sym_PLUS] = ACTIONS(746),
    [anon_sym_DASH] = ACTIONS(746),
    [anon_sym_BANG] = ACTIONS(744),
    [anon_sym_TILDE] = ACTIONS(744),
    [anon_sym_PLUS_PLUS] = ACTIONS(744),
    [anon_sym_DASH_DASH] = ACTIONS(744),
    [anon_sym_new] = ACTIONS(746),
    [anon_sym_class] = ACTIONS(746),
    [anon_sym_SEMI] = ACTIONS(744),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_RBRACE] = ACTIONS(744),
    [anon_sym_assert] = ACTIONS(746),
    [anon_sym_switch] = ACTIONS(746),
    [anon_sym_case] = ACTIONS(746),
    [anon_sym_default] = ACTIONS(746),
    [anon_sym_do] = ACTIONS(746),
    [anon_sym_while] = ACTIONS(746),
    [anon_sym_break] = ACTIONS(746),
    [anon_sym_continue] = ACTIONS(746),
    [anon_sym_return] = ACTIONS(746),
    [anon_sym_synchronized] = ACTIONS(746),
    [anon_sym_throw] = ACTIONS(746),
    [anon_sym_try] = ACTIONS(746),
    [anon_sym_if] = ACTIONS(746),
    [anon_sym_else] = ACTIONS(746),
    [anon_sym_for] = ACTIONS(746),
    [anon_sym_AT] = ACTIONS(746),
    [anon_sym_open] = ACTIONS(746),
    [anon_sym_module] = ACTIONS(746),
    [anon_sym_static] = ACTIONS(746),
    [anon_sym_package] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(746),
    [anon_sym_enum] = ACTIONS(746),
    [anon_sym_public] = ACTIONS(746),
    [anon_sym_protected] = ACTIONS(746),
    [anon_sym_private] = ACTIONS(746),
    [anon_sym_abstract] = ACTIONS(746),
    [anon_sym_final] = ACTIONS(746),
    [anon_sym_strictfp] = ACTIONS(746),
    [anon_sym_native] = ACTIONS(746),
    [anon_sym_transient] = ACTIONS(746),
    [anon_sym_volatile] = ACTIONS(746),
    [anon_sym_ATinterface] = ACTIONS(744),
    [anon_sym_interface] = ACTIONS(746),
    [anon_sym_byte] = ACTIONS(746),
    [anon_sym_short] = ACTIONS(746),
    [anon_sym_int] = ACTIONS(746),
    [anon_sym_long] = ACTIONS(746),
    [anon_sym_char] = ACTIONS(746),
    [anon_sym_float] = ACTIONS(746),
    [anon_sym_double] = ACTIONS(746),
    [sym_boolean_type] = ACTIONS(746),
    [sym_void_type] = ACTIONS(746),
    [sym_this] = ACTIONS(746),
    [sym_super] = ACTIONS(746),
    [sym_comment] = ACTIONS(3),
  },
  [150] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(368),
    [sym_cast_expression] = STATE(368),
    [sym_assignment_expression] = STATE(368),
    [sym_binary_expression] = STATE(368),
    [sym_instanceof_expression] = STATE(368),
    [sym_lambda_expression] = STATE(368),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(368),
    [sym_unary_expression] = STATE(368),
    [sym_update_expression] = STATE(368),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(748),
    [sym_identifier] = ACTIONS(750),
    [sym_decimal_integer_literal] = ACTIONS(750),
    [sym_hex_integer_literal] = ACTIONS(750),
    [sym_octal_integer_literal] = ACTIONS(748),
    [sym_binary_integer_literal] = ACTIONS(748),
    [sym_decimal_floating_point_literal] = ACTIONS(748),
    [sym_hex_floating_point_literal] = ACTIONS(750),
    [sym_true] = ACTIONS(750),
    [sym_false] = ACTIONS(750),
    [sym_character_literal] = ACTIONS(748),
    [sym_string_literal] = ACTIONS(748),
    [sym_null_literal] = ACTIONS(750),
    [anon_sym_LPAREN] = ACTIONS(748),
    [anon_sym_PLUS] = ACTIONS(750),
    [anon_sym_DASH] = ACTIONS(750),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(748),
    [anon_sym_PLUS_PLUS] = ACTIONS(748),
    [anon_sym_DASH_DASH] = ACTIONS(748),
    [anon_sym_new] = ACTIONS(750),
    [anon_sym_class] = ACTIONS(750),
    [anon_sym_SEMI] = ACTIONS(748),
    [anon_sym_LBRACE] = ACTIONS(748),
    [anon_sym_RBRACE] = ACTIONS(748),
    [anon_sym_assert] = ACTIONS(750),
    [anon_sym_switch] = ACTIONS(750),
    [anon_sym_case] = ACTIONS(750),
    [anon_sym_default] = ACTIONS(750),
    [anon_sym_do] = ACTIONS(750),
    [anon_sym_while] = ACTIONS(750),
    [anon_sym_break] = ACTIONS(750),
    [anon_sym_continue] = ACTIONS(750),
    [anon_sym_return] = ACTIONS(750),
    [anon_sym_synchronized] = ACTIONS(750),
    [anon_sym_throw] = ACTIONS(750),
    [anon_sym_try] = ACTIONS(750),
    [anon_sym_if] = ACTIONS(750),
    [anon_sym_else] = ACTIONS(750),
    [anon_sym_for] = ACTIONS(750),
    [anon_sym_AT] = ACTIONS(750),
    [anon_sym_open] = ACTIONS(750),
    [anon_sym_module] = ACTIONS(750),
    [anon_sym_static] = ACTIONS(750),
    [anon_sym_package] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(750),
    [anon_sym_enum] = ACTIONS(750),
    [anon_sym_public] = ACTIONS(750),
    [anon_sym_protected] = ACTIONS(750),
    [anon_sym_private] = ACTIONS(750),
    [anon_sym_abstract] = ACTIONS(750),
    [anon_sym_final] = ACTIONS(750),
    [anon_sym_strictfp] = ACTIONS(750),
    [anon_sym_native] = ACTIONS(750),
    [anon_sym_transient] = ACTIONS(750),
    [anon_sym_volatile] = ACTIONS(750),
    [anon_sym_ATinterface] = ACTIONS(748),
    [anon_sym_interface] = ACTIONS(750),
    [anon_sym_byte] = ACTIONS(750),
    [anon_sym_short] = ACTIONS(750),
    [anon_sym_int] = ACTIONS(750),
    [anon_sym_long] = ACTIONS(750),
    [anon_sym_char] = ACTIONS(750),
    [anon_sym_float] = ACTIONS(750),
    [anon_sym_double] = ACTIONS(750),
    [sym_boolean_type] = ACTIONS(750),
    [sym_void_type] = ACTIONS(750),
    [sym_this] = ACTIONS(750),
    [sym_super] = ACTIONS(750),
    [sym_comment] = ACTIONS(3),
  },
  [152] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(411),
    [sym_cast_expression] = STATE(411),
    [sym_assignment_expression] = STATE(411),
    [sym_binary_expression] = STATE(411),
    [sym_instanceof_expression] = STATE(411),
    [sym_lambda_expression] = STATE(411),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(411),
    [sym_unary_expression] = STATE(411),
    [sym_update_expression] = STATE(411),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(752),
    [sym_identifier] = ACTIONS(754),
    [sym_decimal_integer_literal] = ACTIONS(754),
    [sym_hex_integer_literal] = ACTIONS(754),
    [sym_octal_integer_literal] = ACTIONS(752),
    [sym_binary_integer_literal] = ACTIONS(752),
    [sym_decimal_floating_point_literal] = ACTIONS(752),
    [sym_hex_floating_point_literal] = ACTIONS(754),
    [sym_true] = ACTIONS(754),
    [sym_false] = ACTIONS(754),
    [sym_character_literal] = ACTIONS(752),
    [sym_string_literal] = ACTIONS(752),
    [sym_null_literal] = ACTIONS(754),
    [anon_sym_LPAREN] = ACTIONS(752),
    [anon_sym_PLUS] = ACTIONS(754),
    [anon_sym_DASH] = ACTIONS(754),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_TILDE] = ACTIONS(752),
    [anon_sym_PLUS_PLUS] = ACTIONS(752),
    [anon_sym_DASH_DASH] = ACTIONS(752),
    [anon_sym_new] = ACTIONS(754),
    [anon_sym_class] = ACTIONS(754),
    [anon_sym_SEMI] = ACTIONS(752),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_RBRACE] = ACTIONS(752),
    [anon_sym_assert] = ACTIONS(754),
    [anon_sym_switch] = ACTIONS(754),
    [anon_sym_case] = ACTIONS(754),
    [anon_sym_default] = ACTIONS(754),
    [anon_sym_do] = ACTIONS(754),
    [anon_sym_while] = ACTIONS(754),
    [anon_sym_break] = ACTIONS(754),
    [anon_sym_continue] = ACTIONS(754),
    [anon_sym_return] = ACTIONS(754),
    [anon_sym_synchronized] = ACTIONS(754),
    [anon_sym_throw] = ACTIONS(754),
    [anon_sym_try] = ACTIONS(754),
    [anon_sym_if] = ACTIONS(754),
    [anon_sym_else] = ACTIONS(754),
    [anon_sym_for] = ACTIONS(754),
    [anon_sym_AT] = ACTIONS(754),
    [anon_sym_open] = ACTIONS(754),
    [anon_sym_module] = ACTIONS(754),
    [anon_sym_static] = ACTIONS(754),
    [anon_sym_package] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(754),
    [anon_sym_enum] = ACTIONS(754),
    [anon_sym_public] = ACTIONS(754),
    [anon_sym_protected] = ACTIONS(754),
    [anon_sym_private] = ACTIONS(754),
    [anon_sym_abstract] = ACTIONS(754),
    [anon_sym_final] = ACTIONS(754),
    [anon_sym_strictfp] = ACTIONS(754),
    [anon_sym_native] = ACTIONS(754),
    [anon_sym_transient] = ACTIONS(754),
    [anon_sym_volatile] = ACTIONS(754),
    [anon_sym_ATinterface] = ACTIONS(752),
    [anon_sym_interface] = ACTIONS(754),
    [anon_sym_byte] = ACTIONS(754),
    [anon_sym_short] = ACTIONS(754),
    [anon_sym_int] = ACTIONS(754),
    [anon_sym_long] = ACTIONS(754),
    [anon_sym_char] = ACTIONS(754),
    [anon_sym_float] = ACTIONS(754),
    [anon_sym_double] = ACTIONS(754),
    [sym_boolean_type] = ACTIONS(754),
    [sym_void_type] = ACTIONS(754),
    [sym_this] = ACTIONS(754),
    [sym_super] = ACTIONS(754),
    [sym_comment] = ACTIONS(3),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(756),
    [sym_identifier] = ACTIONS(758),
    [sym_decimal_integer_literal] = ACTIONS(758),
    [sym_hex_integer_literal] = ACTIONS(758),
    [sym_octal_integer_literal] = ACTIONS(756),
    [sym_binary_integer_literal] = ACTIONS(756),
    [sym_decimal_floating_point_literal] = ACTIONS(756),
    [sym_hex_floating_point_literal] = ACTIONS(758),
    [sym_true] = ACTIONS(758),
    [sym_false] = ACTIONS(758),
    [sym_character_literal] = ACTIONS(756),
    [sym_string_literal] = ACTIONS(756),
    [sym_null_literal] = ACTIONS(758),
    [anon_sym_LPAREN] = ACTIONS(756),
    [anon_sym_PLUS] = ACTIONS(758),
    [anon_sym_DASH] = ACTIONS(758),
    [anon_sym_BANG] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(756),
    [anon_sym_PLUS_PLUS] = ACTIONS(756),
    [anon_sym_DASH_DASH] = ACTIONS(756),
    [anon_sym_new] = ACTIONS(758),
    [anon_sym_class] = ACTIONS(758),
    [anon_sym_SEMI] = ACTIONS(756),
    [anon_sym_LBRACE] = ACTIONS(756),
    [anon_sym_RBRACE] = ACTIONS(756),
    [anon_sym_assert] = ACTIONS(758),
    [anon_sym_switch] = ACTIONS(758),
    [anon_sym_case] = ACTIONS(758),
    [anon_sym_default] = ACTIONS(758),
    [anon_sym_do] = ACTIONS(758),
    [anon_sym_while] = ACTIONS(758),
    [anon_sym_break] = ACTIONS(758),
    [anon_sym_continue] = ACTIONS(758),
    [anon_sym_return] = ACTIONS(758),
    [anon_sym_synchronized] = ACTIONS(758),
    [anon_sym_throw] = ACTIONS(758),
    [anon_sym_try] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(760),
    [anon_sym_for] = ACTIONS(758),
    [anon_sym_AT] = ACTIONS(758),
    [anon_sym_open] = ACTIONS(758),
    [anon_sym_module] = ACTIONS(758),
    [anon_sym_static] = ACTIONS(758),
    [anon_sym_package] = ACTIONS(758),
    [anon_sym_import] = ACTIONS(758),
    [anon_sym_enum] = ACTIONS(758),
    [anon_sym_public] = ACTIONS(758),
    [anon_sym_protected] = ACTIONS(758),
    [anon_sym_private] = ACTIONS(758),
    [anon_sym_abstract] = ACTIONS(758),
    [anon_sym_final] = ACTIONS(758),
    [anon_sym_strictfp] = ACTIONS(758),
    [anon_sym_native] = ACTIONS(758),
    [anon_sym_transient] = ACTIONS(758),
    [anon_sym_volatile] = ACTIONS(758),
    [anon_sym_ATinterface] = ACTIONS(756),
    [anon_sym_interface] = ACTIONS(758),
    [anon_sym_byte] = ACTIONS(758),
    [anon_sym_short] = ACTIONS(758),
    [anon_sym_int] = ACTIONS(758),
    [anon_sym_long] = ACTIONS(758),
    [anon_sym_char] = ACTIONS(758),
    [anon_sym_float] = ACTIONS(758),
    [anon_sym_double] = ACTIONS(758),
    [sym_boolean_type] = ACTIONS(758),
    [sym_void_type] = ACTIONS(758),
    [sym_this] = ACTIONS(758),
    [sym_super] = ACTIONS(758),
    [sym_comment] = ACTIONS(3),
  },
  [155] = {
    [ts_builtin_sym_end] = ACTIONS(762),
    [sym_identifier] = ACTIONS(764),
    [sym_decimal_integer_literal] = ACTIONS(764),
    [sym_hex_integer_literal] = ACTIONS(764),
    [sym_octal_integer_literal] = ACTIONS(762),
    [sym_binary_integer_literal] = ACTIONS(762),
    [sym_decimal_floating_point_literal] = ACTIONS(762),
    [sym_hex_floating_point_literal] = ACTIONS(764),
    [sym_true] = ACTIONS(764),
    [sym_false] = ACTIONS(764),
    [sym_character_literal] = ACTIONS(762),
    [sym_string_literal] = ACTIONS(762),
    [sym_null_literal] = ACTIONS(764),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_PLUS] = ACTIONS(764),
    [anon_sym_DASH] = ACTIONS(764),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(762),
    [anon_sym_PLUS_PLUS] = ACTIONS(762),
    [anon_sym_DASH_DASH] = ACTIONS(762),
    [anon_sym_new] = ACTIONS(764),
    [anon_sym_class] = ACTIONS(764),
    [anon_sym_SEMI] = ACTIONS(762),
    [anon_sym_LBRACE] = ACTIONS(762),
    [anon_sym_RBRACE] = ACTIONS(762),
    [anon_sym_assert] = ACTIONS(764),
    [anon_sym_switch] = ACTIONS(764),
    [anon_sym_case] = ACTIONS(764),
    [anon_sym_default] = ACTIONS(764),
    [anon_sym_do] = ACTIONS(764),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_break] = ACTIONS(764),
    [anon_sym_continue] = ACTIONS(764),
    [anon_sym_return] = ACTIONS(764),
    [anon_sym_synchronized] = ACTIONS(764),
    [anon_sym_throw] = ACTIONS(764),
    [anon_sym_try] = ACTIONS(764),
    [anon_sym_if] = ACTIONS(764),
    [anon_sym_else] = ACTIONS(764),
    [anon_sym_for] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(764),
    [anon_sym_open] = ACTIONS(764),
    [anon_sym_module] = ACTIONS(764),
    [anon_sym_static] = ACTIONS(764),
    [anon_sym_package] = ACTIONS(764),
    [anon_sym_import] = ACTIONS(764),
    [anon_sym_enum] = ACTIONS(764),
    [anon_sym_public] = ACTIONS(764),
    [anon_sym_protected] = ACTIONS(764),
    [anon_sym_private] = ACTIONS(764),
    [anon_sym_abstract] = ACTIONS(764),
    [anon_sym_final] = ACTIONS(764),
    [anon_sym_strictfp] = ACTIONS(764),
    [anon_sym_native] = ACTIONS(764),
    [anon_sym_transient] = ACTIONS(764),
    [anon_sym_volatile] = ACTIONS(764),
    [anon_sym_ATinterface] = ACTIONS(762),
    [anon_sym_interface] = ACTIONS(764),
    [anon_sym_byte] = ACTIONS(764),
    [anon_sym_short] = ACTIONS(764),
    [anon_sym_int] = ACTIONS(764),
    [anon_sym_long] = ACTIONS(764),
    [anon_sym_char] = ACTIONS(764),
    [anon_sym_float] = ACTIONS(764),
    [anon_sym_double] = ACTIONS(764),
    [sym_boolean_type] = ACTIONS(764),
    [sym_void_type] = ACTIONS(764),
    [sym_this] = ACTIONS(764),
    [sym_super] = ACTIONS(764),
    [sym_comment] = ACTIONS(3),
  },
  [156] = {
    [ts_builtin_sym_end] = ACTIONS(439),
    [sym_identifier] = ACTIONS(441),
    [sym_decimal_integer_literal] = ACTIONS(441),
    [sym_hex_integer_literal] = ACTIONS(441),
    [sym_octal_integer_literal] = ACTIONS(439),
    [sym_binary_integer_literal] = ACTIONS(439),
    [sym_decimal_floating_point_literal] = ACTIONS(439),
    [sym_hex_floating_point_literal] = ACTIONS(441),
    [sym_true] = ACTIONS(441),
    [sym_false] = ACTIONS(441),
    [sym_character_literal] = ACTIONS(439),
    [sym_string_literal] = ACTIONS(439),
    [sym_null_literal] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(439),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_new] = ACTIONS(441),
    [anon_sym_class] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_RBRACE] = ACTIONS(439),
    [anon_sym_assert] = ACTIONS(441),
    [anon_sym_switch] = ACTIONS(441),
    [anon_sym_case] = ACTIONS(441),
    [anon_sym_default] = ACTIONS(441),
    [anon_sym_do] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(441),
    [anon_sym_return] = ACTIONS(441),
    [anon_sym_synchronized] = ACTIONS(441),
    [anon_sym_throw] = ACTIONS(441),
    [anon_sym_try] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_else] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(441),
    [anon_sym_module] = ACTIONS(441),
    [anon_sym_static] = ACTIONS(441),
    [anon_sym_package] = ACTIONS(441),
    [anon_sym_import] = ACTIONS(441),
    [anon_sym_enum] = ACTIONS(441),
    [anon_sym_public] = ACTIONS(441),
    [anon_sym_protected] = ACTIONS(441),
    [anon_sym_private] = ACTIONS(441),
    [anon_sym_abstract] = ACTIONS(441),
    [anon_sym_final] = ACTIONS(441),
    [anon_sym_strictfp] = ACTIONS(441),
    [anon_sym_native] = ACTIONS(441),
    [anon_sym_transient] = ACTIONS(441),
    [anon_sym_volatile] = ACTIONS(441),
    [anon_sym_ATinterface] = ACTIONS(439),
    [anon_sym_interface] = ACTIONS(441),
    [anon_sym_byte] = ACTIONS(441),
    [anon_sym_short] = ACTIONS(441),
    [anon_sym_int] = ACTIONS(441),
    [anon_sym_long] = ACTIONS(441),
    [anon_sym_char] = ACTIONS(441),
    [anon_sym_float] = ACTIONS(441),
    [anon_sym_double] = ACTIONS(441),
    [sym_boolean_type] = ACTIONS(441),
    [sym_void_type] = ACTIONS(441),
    [sym_this] = ACTIONS(441),
    [sym_super] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
  },
  [157] = {
    [ts_builtin_sym_end] = ACTIONS(766),
    [sym_identifier] = ACTIONS(768),
    [sym_decimal_integer_literal] = ACTIONS(768),
    [sym_hex_integer_literal] = ACTIONS(768),
    [sym_octal_integer_literal] = ACTIONS(766),
    [sym_binary_integer_literal] = ACTIONS(766),
    [sym_decimal_floating_point_literal] = ACTIONS(766),
    [sym_hex_floating_point_literal] = ACTIONS(768),
    [sym_true] = ACTIONS(768),
    [sym_false] = ACTIONS(768),
    [sym_character_literal] = ACTIONS(766),
    [sym_string_literal] = ACTIONS(766),
    [sym_null_literal] = ACTIONS(768),
    [anon_sym_LPAREN] = ACTIONS(766),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(766),
    [anon_sym_TILDE] = ACTIONS(766),
    [anon_sym_PLUS_PLUS] = ACTIONS(766),
    [anon_sym_DASH_DASH] = ACTIONS(766),
    [anon_sym_new] = ACTIONS(768),
    [anon_sym_class] = ACTIONS(768),
    [anon_sym_SEMI] = ACTIONS(766),
    [anon_sym_LBRACE] = ACTIONS(766),
    [anon_sym_RBRACE] = ACTIONS(766),
    [anon_sym_assert] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(768),
    [anon_sym_case] = ACTIONS(768),
    [anon_sym_default] = ACTIONS(768),
    [anon_sym_do] = ACTIONS(768),
    [anon_sym_while] = ACTIONS(768),
    [anon_sym_break] = ACTIONS(768),
    [anon_sym_continue] = ACTIONS(768),
    [anon_sym_return] = ACTIONS(768),
    [anon_sym_synchronized] = ACTIONS(768),
    [anon_sym_throw] = ACTIONS(768),
    [anon_sym_try] = ACTIONS(768),
    [anon_sym_if] = ACTIONS(768),
    [anon_sym_else] = ACTIONS(768),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_AT] = ACTIONS(768),
    [anon_sym_open] = ACTIONS(768),
    [anon_sym_module] = ACTIONS(768),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_package] = ACTIONS(768),
    [anon_sym_import] = ACTIONS(768),
    [anon_sym_enum] = ACTIONS(768),
    [anon_sym_public] = ACTIONS(768),
    [anon_sym_protected] = ACTIONS(768),
    [anon_sym_private] = ACTIONS(768),
    [anon_sym_abstract] = ACTIONS(768),
    [anon_sym_final] = ACTIONS(768),
    [anon_sym_strictfp] = ACTIONS(768),
    [anon_sym_native] = ACTIONS(768),
    [anon_sym_transient] = ACTIONS(768),
    [anon_sym_volatile] = ACTIONS(768),
    [anon_sym_ATinterface] = ACTIONS(766),
    [anon_sym_interface] = ACTIONS(768),
    [anon_sym_byte] = ACTIONS(768),
    [anon_sym_short] = ACTIONS(768),
    [anon_sym_int] = ACTIONS(768),
    [anon_sym_long] = ACTIONS(768),
    [anon_sym_char] = ACTIONS(768),
    [anon_sym_float] = ACTIONS(768),
    [anon_sym_double] = ACTIONS(768),
    [sym_boolean_type] = ACTIONS(768),
    [sym_void_type] = ACTIONS(768),
    [sym_this] = ACTIONS(768),
    [sym_super] = ACTIONS(768),
    [sym_comment] = ACTIONS(3),
  },
  [158] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(429),
    [sym_cast_expression] = STATE(429),
    [sym_assignment_expression] = STATE(429),
    [sym_binary_expression] = STATE(429),
    [sym_instanceof_expression] = STATE(429),
    [sym_lambda_expression] = STATE(429),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(429),
    [sym_unary_expression] = STATE(429),
    [sym_update_expression] = STATE(429),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [159] = {
    [ts_builtin_sym_end] = ACTIONS(770),
    [sym_identifier] = ACTIONS(772),
    [sym_decimal_integer_literal] = ACTIONS(772),
    [sym_hex_integer_literal] = ACTIONS(772),
    [sym_octal_integer_literal] = ACTIONS(770),
    [sym_binary_integer_literal] = ACTIONS(770),
    [sym_decimal_floating_point_literal] = ACTIONS(770),
    [sym_hex_floating_point_literal] = ACTIONS(772),
    [sym_true] = ACTIONS(772),
    [sym_false] = ACTIONS(772),
    [sym_character_literal] = ACTIONS(770),
    [sym_string_literal] = ACTIONS(770),
    [sym_null_literal] = ACTIONS(772),
    [anon_sym_LPAREN] = ACTIONS(770),
    [anon_sym_PLUS] = ACTIONS(772),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_BANG] = ACTIONS(770),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_PLUS_PLUS] = ACTIONS(770),
    [anon_sym_DASH_DASH] = ACTIONS(770),
    [anon_sym_new] = ACTIONS(772),
    [anon_sym_class] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(770),
    [anon_sym_RBRACE] = ACTIONS(770),
    [anon_sym_assert] = ACTIONS(772),
    [anon_sym_switch] = ACTIONS(772),
    [anon_sym_case] = ACTIONS(772),
    [anon_sym_default] = ACTIONS(772),
    [anon_sym_do] = ACTIONS(772),
    [anon_sym_while] = ACTIONS(772),
    [anon_sym_break] = ACTIONS(772),
    [anon_sym_continue] = ACTIONS(772),
    [anon_sym_return] = ACTIONS(772),
    [anon_sym_synchronized] = ACTIONS(772),
    [anon_sym_throw] = ACTIONS(772),
    [anon_sym_try] = ACTIONS(772),
    [anon_sym_if] = ACTIONS(772),
    [anon_sym_else] = ACTIONS(772),
    [anon_sym_for] = ACTIONS(772),
    [anon_sym_AT] = ACTIONS(772),
    [anon_sym_open] = ACTIONS(772),
    [anon_sym_module] = ACTIONS(772),
    [anon_sym_static] = ACTIONS(772),
    [anon_sym_package] = ACTIONS(772),
    [anon_sym_import] = ACTIONS(772),
    [anon_sym_enum] = ACTIONS(772),
    [anon_sym_public] = ACTIONS(772),
    [anon_sym_protected] = ACTIONS(772),
    [anon_sym_private] = ACTIONS(772),
    [anon_sym_abstract] = ACTIONS(772),
    [anon_sym_final] = ACTIONS(772),
    [anon_sym_strictfp] = ACTIONS(772),
    [anon_sym_native] = ACTIONS(772),
    [anon_sym_transient] = ACTIONS(772),
    [anon_sym_volatile] = ACTIONS(772),
    [anon_sym_ATinterface] = ACTIONS(770),
    [anon_sym_interface] = ACTIONS(772),
    [anon_sym_byte] = ACTIONS(772),
    [anon_sym_short] = ACTIONS(772),
    [anon_sym_int] = ACTIONS(772),
    [anon_sym_long] = ACTIONS(772),
    [anon_sym_char] = ACTIONS(772),
    [anon_sym_float] = ACTIONS(772),
    [anon_sym_double] = ACTIONS(772),
    [sym_boolean_type] = ACTIONS(772),
    [sym_void_type] = ACTIONS(772),
    [sym_this] = ACTIONS(772),
    [sym_super] = ACTIONS(772),
    [sym_comment] = ACTIONS(3),
  },
  [160] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(426),
    [sym_cast_expression] = STATE(426),
    [sym_assignment_expression] = STATE(426),
    [sym_binary_expression] = STATE(426),
    [sym_instanceof_expression] = STATE(426),
    [sym_lambda_expression] = STATE(426),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(426),
    [sym_unary_expression] = STATE(426),
    [sym_update_expression] = STATE(426),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [161] = {
    [ts_builtin_sym_end] = ACTIONS(774),
    [sym_identifier] = ACTIONS(776),
    [sym_decimal_integer_literal] = ACTIONS(776),
    [sym_hex_integer_literal] = ACTIONS(776),
    [sym_octal_integer_literal] = ACTIONS(774),
    [sym_binary_integer_literal] = ACTIONS(774),
    [sym_decimal_floating_point_literal] = ACTIONS(774),
    [sym_hex_floating_point_literal] = ACTIONS(776),
    [sym_true] = ACTIONS(776),
    [sym_false] = ACTIONS(776),
    [sym_character_literal] = ACTIONS(774),
    [sym_string_literal] = ACTIONS(774),
    [sym_null_literal] = ACTIONS(776),
    [anon_sym_LPAREN] = ACTIONS(774),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(774),
    [anon_sym_TILDE] = ACTIONS(774),
    [anon_sym_PLUS_PLUS] = ACTIONS(774),
    [anon_sym_DASH_DASH] = ACTIONS(774),
    [anon_sym_new] = ACTIONS(776),
    [anon_sym_class] = ACTIONS(776),
    [anon_sym_SEMI] = ACTIONS(774),
    [anon_sym_LBRACE] = ACTIONS(774),
    [anon_sym_RBRACE] = ACTIONS(774),
    [anon_sym_assert] = ACTIONS(776),
    [anon_sym_switch] = ACTIONS(776),
    [anon_sym_case] = ACTIONS(776),
    [anon_sym_default] = ACTIONS(776),
    [anon_sym_do] = ACTIONS(776),
    [anon_sym_while] = ACTIONS(776),
    [anon_sym_break] = ACTIONS(776),
    [anon_sym_continue] = ACTIONS(776),
    [anon_sym_return] = ACTIONS(776),
    [anon_sym_synchronized] = ACTIONS(776),
    [anon_sym_throw] = ACTIONS(776),
    [anon_sym_try] = ACTIONS(776),
    [anon_sym_if] = ACTIONS(776),
    [anon_sym_else] = ACTIONS(776),
    [anon_sym_for] = ACTIONS(776),
    [anon_sym_AT] = ACTIONS(776),
    [anon_sym_open] = ACTIONS(776),
    [anon_sym_module] = ACTIONS(776),
    [anon_sym_static] = ACTIONS(776),
    [anon_sym_package] = ACTIONS(776),
    [anon_sym_import] = ACTIONS(776),
    [anon_sym_enum] = ACTIONS(776),
    [anon_sym_public] = ACTIONS(776),
    [anon_sym_protected] = ACTIONS(776),
    [anon_sym_private] = ACTIONS(776),
    [anon_sym_abstract] = ACTIONS(776),
    [anon_sym_final] = ACTIONS(776),
    [anon_sym_strictfp] = ACTIONS(776),
    [anon_sym_native] = ACTIONS(776),
    [anon_sym_transient] = ACTIONS(776),
    [anon_sym_volatile] = ACTIONS(776),
    [anon_sym_ATinterface] = ACTIONS(774),
    [anon_sym_interface] = ACTIONS(776),
    [anon_sym_byte] = ACTIONS(776),
    [anon_sym_short] = ACTIONS(776),
    [anon_sym_int] = ACTIONS(776),
    [anon_sym_long] = ACTIONS(776),
    [anon_sym_char] = ACTIONS(776),
    [anon_sym_float] = ACTIONS(776),
    [anon_sym_double] = ACTIONS(776),
    [sym_boolean_type] = ACTIONS(776),
    [sym_void_type] = ACTIONS(776),
    [sym_this] = ACTIONS(776),
    [sym_super] = ACTIONS(776),
    [sym_comment] = ACTIONS(3),
  },
  [162] = {
    [ts_builtin_sym_end] = ACTIONS(778),
    [sym_identifier] = ACTIONS(780),
    [sym_decimal_integer_literal] = ACTIONS(780),
    [sym_hex_integer_literal] = ACTIONS(780),
    [sym_octal_integer_literal] = ACTIONS(778),
    [sym_binary_integer_literal] = ACTIONS(778),
    [sym_decimal_floating_point_literal] = ACTIONS(778),
    [sym_hex_floating_point_literal] = ACTIONS(780),
    [sym_true] = ACTIONS(780),
    [sym_false] = ACTIONS(780),
    [sym_character_literal] = ACTIONS(778),
    [sym_string_literal] = ACTIONS(778),
    [sym_null_literal] = ACTIONS(780),
    [anon_sym_LPAREN] = ACTIONS(778),
    [anon_sym_PLUS] = ACTIONS(780),
    [anon_sym_DASH] = ACTIONS(780),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(778),
    [anon_sym_PLUS_PLUS] = ACTIONS(778),
    [anon_sym_DASH_DASH] = ACTIONS(778),
    [anon_sym_new] = ACTIONS(780),
    [anon_sym_class] = ACTIONS(780),
    [anon_sym_SEMI] = ACTIONS(778),
    [anon_sym_LBRACE] = ACTIONS(778),
    [anon_sym_RBRACE] = ACTIONS(778),
    [anon_sym_assert] = ACTIONS(780),
    [anon_sym_switch] = ACTIONS(780),
    [anon_sym_case] = ACTIONS(780),
    [anon_sym_default] = ACTIONS(780),
    [anon_sym_do] = ACTIONS(780),
    [anon_sym_while] = ACTIONS(780),
    [anon_sym_break] = ACTIONS(780),
    [anon_sym_continue] = ACTIONS(780),
    [anon_sym_return] = ACTIONS(780),
    [anon_sym_synchronized] = ACTIONS(780),
    [anon_sym_throw] = ACTIONS(780),
    [anon_sym_try] = ACTIONS(780),
    [anon_sym_if] = ACTIONS(780),
    [anon_sym_else] = ACTIONS(780),
    [anon_sym_for] = ACTIONS(780),
    [anon_sym_AT] = ACTIONS(780),
    [anon_sym_open] = ACTIONS(780),
    [anon_sym_module] = ACTIONS(780),
    [anon_sym_static] = ACTIONS(780),
    [anon_sym_package] = ACTIONS(780),
    [anon_sym_import] = ACTIONS(780),
    [anon_sym_enum] = ACTIONS(780),
    [anon_sym_public] = ACTIONS(780),
    [anon_sym_protected] = ACTIONS(780),
    [anon_sym_private] = ACTIONS(780),
    [anon_sym_abstract] = ACTIONS(780),
    [anon_sym_final] = ACTIONS(780),
    [anon_sym_strictfp] = ACTIONS(780),
    [anon_sym_native] = ACTIONS(780),
    [anon_sym_transient] = ACTIONS(780),
    [anon_sym_volatile] = ACTIONS(780),
    [anon_sym_ATinterface] = ACTIONS(778),
    [anon_sym_interface] = ACTIONS(780),
    [anon_sym_byte] = ACTIONS(780),
    [anon_sym_short] = ACTIONS(780),
    [anon_sym_int] = ACTIONS(780),
    [anon_sym_long] = ACTIONS(780),
    [anon_sym_char] = ACTIONS(780),
    [anon_sym_float] = ACTIONS(780),
    [anon_sym_double] = ACTIONS(780),
    [sym_boolean_type] = ACTIONS(780),
    [sym_void_type] = ACTIONS(780),
    [sym_this] = ACTIONS(780),
    [sym_super] = ACTIONS(780),
    [sym_comment] = ACTIONS(3),
  },
  [163] = {
    [ts_builtin_sym_end] = ACTIONS(782),
    [sym_identifier] = ACTIONS(784),
    [sym_decimal_integer_literal] = ACTIONS(784),
    [sym_hex_integer_literal] = ACTIONS(784),
    [sym_octal_integer_literal] = ACTIONS(782),
    [sym_binary_integer_literal] = ACTIONS(782),
    [sym_decimal_floating_point_literal] = ACTIONS(782),
    [sym_hex_floating_point_literal] = ACTIONS(784),
    [sym_true] = ACTIONS(784),
    [sym_false] = ACTIONS(784),
    [sym_character_literal] = ACTIONS(782),
    [sym_string_literal] = ACTIONS(782),
    [sym_null_literal] = ACTIONS(784),
    [anon_sym_LPAREN] = ACTIONS(782),
    [anon_sym_PLUS] = ACTIONS(784),
    [anon_sym_DASH] = ACTIONS(784),
    [anon_sym_BANG] = ACTIONS(782),
    [anon_sym_TILDE] = ACTIONS(782),
    [anon_sym_PLUS_PLUS] = ACTIONS(782),
    [anon_sym_DASH_DASH] = ACTIONS(782),
    [anon_sym_new] = ACTIONS(784),
    [anon_sym_class] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [anon_sym_LBRACE] = ACTIONS(782),
    [anon_sym_RBRACE] = ACTIONS(782),
    [anon_sym_assert] = ACTIONS(784),
    [anon_sym_switch] = ACTIONS(784),
    [anon_sym_case] = ACTIONS(784),
    [anon_sym_default] = ACTIONS(784),
    [anon_sym_do] = ACTIONS(784),
    [anon_sym_while] = ACTIONS(784),
    [anon_sym_break] = ACTIONS(784),
    [anon_sym_continue] = ACTIONS(784),
    [anon_sym_return] = ACTIONS(784),
    [anon_sym_synchronized] = ACTIONS(784),
    [anon_sym_throw] = ACTIONS(784),
    [anon_sym_try] = ACTIONS(784),
    [anon_sym_if] = ACTIONS(784),
    [anon_sym_else] = ACTIONS(784),
    [anon_sym_for] = ACTIONS(784),
    [anon_sym_AT] = ACTIONS(784),
    [anon_sym_open] = ACTIONS(784),
    [anon_sym_module] = ACTIONS(784),
    [anon_sym_static] = ACTIONS(784),
    [anon_sym_package] = ACTIONS(784),
    [anon_sym_import] = ACTIONS(784),
    [anon_sym_enum] = ACTIONS(784),
    [anon_sym_public] = ACTIONS(784),
    [anon_sym_protected] = ACTIONS(784),
    [anon_sym_private] = ACTIONS(784),
    [anon_sym_abstract] = ACTIONS(784),
    [anon_sym_final] = ACTIONS(784),
    [anon_sym_strictfp] = ACTIONS(784),
    [anon_sym_native] = ACTIONS(784),
    [anon_sym_transient] = ACTIONS(784),
    [anon_sym_volatile] = ACTIONS(784),
    [anon_sym_ATinterface] = ACTIONS(782),
    [anon_sym_interface] = ACTIONS(784),
    [anon_sym_byte] = ACTIONS(784),
    [anon_sym_short] = ACTIONS(784),
    [anon_sym_int] = ACTIONS(784),
    [anon_sym_long] = ACTIONS(784),
    [anon_sym_char] = ACTIONS(784),
    [anon_sym_float] = ACTIONS(784),
    [anon_sym_double] = ACTIONS(784),
    [sym_boolean_type] = ACTIONS(784),
    [sym_void_type] = ACTIONS(784),
    [sym_this] = ACTIONS(784),
    [sym_super] = ACTIONS(784),
    [sym_comment] = ACTIONS(3),
  },
  [164] = {
    [ts_builtin_sym_end] = ACTIONS(786),
    [sym_identifier] = ACTIONS(788),
    [sym_decimal_integer_literal] = ACTIONS(788),
    [sym_hex_integer_literal] = ACTIONS(788),
    [sym_octal_integer_literal] = ACTIONS(786),
    [sym_binary_integer_literal] = ACTIONS(786),
    [sym_decimal_floating_point_literal] = ACTIONS(786),
    [sym_hex_floating_point_literal] = ACTIONS(788),
    [sym_true] = ACTIONS(788),
    [sym_false] = ACTIONS(788),
    [sym_character_literal] = ACTIONS(786),
    [sym_string_literal] = ACTIONS(786),
    [sym_null_literal] = ACTIONS(788),
    [anon_sym_LPAREN] = ACTIONS(786),
    [anon_sym_PLUS] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(788),
    [anon_sym_BANG] = ACTIONS(786),
    [anon_sym_TILDE] = ACTIONS(786),
    [anon_sym_PLUS_PLUS] = ACTIONS(786),
    [anon_sym_DASH_DASH] = ACTIONS(786),
    [anon_sym_new] = ACTIONS(788),
    [anon_sym_class] = ACTIONS(788),
    [anon_sym_SEMI] = ACTIONS(786),
    [anon_sym_LBRACE] = ACTIONS(786),
    [anon_sym_RBRACE] = ACTIONS(786),
    [anon_sym_assert] = ACTIONS(788),
    [anon_sym_switch] = ACTIONS(788),
    [anon_sym_case] = ACTIONS(788),
    [anon_sym_default] = ACTIONS(788),
    [anon_sym_do] = ACTIONS(788),
    [anon_sym_while] = ACTIONS(788),
    [anon_sym_break] = ACTIONS(788),
    [anon_sym_continue] = ACTIONS(788),
    [anon_sym_return] = ACTIONS(788),
    [anon_sym_synchronized] = ACTIONS(788),
    [anon_sym_throw] = ACTIONS(788),
    [anon_sym_try] = ACTIONS(788),
    [anon_sym_if] = ACTIONS(788),
    [anon_sym_else] = ACTIONS(788),
    [anon_sym_for] = ACTIONS(788),
    [anon_sym_AT] = ACTIONS(788),
    [anon_sym_open] = ACTIONS(788),
    [anon_sym_module] = ACTIONS(788),
    [anon_sym_static] = ACTIONS(788),
    [anon_sym_package] = ACTIONS(788),
    [anon_sym_import] = ACTIONS(788),
    [anon_sym_enum] = ACTIONS(788),
    [anon_sym_public] = ACTIONS(788),
    [anon_sym_protected] = ACTIONS(788),
    [anon_sym_private] = ACTIONS(788),
    [anon_sym_abstract] = ACTIONS(788),
    [anon_sym_final] = ACTIONS(788),
    [anon_sym_strictfp] = ACTIONS(788),
    [anon_sym_native] = ACTIONS(788),
    [anon_sym_transient] = ACTIONS(788),
    [anon_sym_volatile] = ACTIONS(788),
    [anon_sym_ATinterface] = ACTIONS(786),
    [anon_sym_interface] = ACTIONS(788),
    [anon_sym_byte] = ACTIONS(788),
    [anon_sym_short] = ACTIONS(788),
    [anon_sym_int] = ACTIONS(788),
    [anon_sym_long] = ACTIONS(788),
    [anon_sym_char] = ACTIONS(788),
    [anon_sym_float] = ACTIONS(788),
    [anon_sym_double] = ACTIONS(788),
    [sym_boolean_type] = ACTIONS(788),
    [sym_void_type] = ACTIONS(788),
    [sym_this] = ACTIONS(788),
    [sym_super] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(790),
    [sym_identifier] = ACTIONS(792),
    [sym_decimal_integer_literal] = ACTIONS(792),
    [sym_hex_integer_literal] = ACTIONS(792),
    [sym_octal_integer_literal] = ACTIONS(790),
    [sym_binary_integer_literal] = ACTIONS(790),
    [sym_decimal_floating_point_literal] = ACTIONS(790),
    [sym_hex_floating_point_literal] = ACTIONS(792),
    [sym_true] = ACTIONS(792),
    [sym_false] = ACTIONS(792),
    [sym_character_literal] = ACTIONS(790),
    [sym_string_literal] = ACTIONS(790),
    [sym_null_literal] = ACTIONS(792),
    [anon_sym_LPAREN] = ACTIONS(790),
    [anon_sym_PLUS] = ACTIONS(792),
    [anon_sym_DASH] = ACTIONS(792),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(790),
    [anon_sym_PLUS_PLUS] = ACTIONS(790),
    [anon_sym_DASH_DASH] = ACTIONS(790),
    [anon_sym_new] = ACTIONS(792),
    [anon_sym_class] = ACTIONS(792),
    [anon_sym_SEMI] = ACTIONS(790),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_RBRACE] = ACTIONS(790),
    [anon_sym_assert] = ACTIONS(792),
    [anon_sym_switch] = ACTIONS(792),
    [anon_sym_case] = ACTIONS(792),
    [anon_sym_default] = ACTIONS(792),
    [anon_sym_do] = ACTIONS(792),
    [anon_sym_while] = ACTIONS(792),
    [anon_sym_break] = ACTIONS(792),
    [anon_sym_continue] = ACTIONS(792),
    [anon_sym_return] = ACTIONS(792),
    [anon_sym_synchronized] = ACTIONS(792),
    [anon_sym_throw] = ACTIONS(792),
    [anon_sym_try] = ACTIONS(792),
    [anon_sym_if] = ACTIONS(792),
    [anon_sym_else] = ACTIONS(792),
    [anon_sym_for] = ACTIONS(792),
    [anon_sym_AT] = ACTIONS(792),
    [anon_sym_open] = ACTIONS(792),
    [anon_sym_module] = ACTIONS(792),
    [anon_sym_static] = ACTIONS(792),
    [anon_sym_package] = ACTIONS(792),
    [anon_sym_import] = ACTIONS(792),
    [anon_sym_enum] = ACTIONS(792),
    [anon_sym_public] = ACTIONS(792),
    [anon_sym_protected] = ACTIONS(792),
    [anon_sym_private] = ACTIONS(792),
    [anon_sym_abstract] = ACTIONS(792),
    [anon_sym_final] = ACTIONS(792),
    [anon_sym_strictfp] = ACTIONS(792),
    [anon_sym_native] = ACTIONS(792),
    [anon_sym_transient] = ACTIONS(792),
    [anon_sym_volatile] = ACTIONS(792),
    [anon_sym_ATinterface] = ACTIONS(790),
    [anon_sym_interface] = ACTIONS(792),
    [anon_sym_byte] = ACTIONS(792),
    [anon_sym_short] = ACTIONS(792),
    [anon_sym_int] = ACTIONS(792),
    [anon_sym_long] = ACTIONS(792),
    [anon_sym_char] = ACTIONS(792),
    [anon_sym_float] = ACTIONS(792),
    [anon_sym_double] = ACTIONS(792),
    [sym_boolean_type] = ACTIONS(792),
    [sym_void_type] = ACTIONS(792),
    [sym_this] = ACTIONS(792),
    [sym_super] = ACTIONS(792),
    [sym_comment] = ACTIONS(3),
  },
  [166] = {
    [ts_builtin_sym_end] = ACTIONS(794),
    [sym_identifier] = ACTIONS(796),
    [sym_decimal_integer_literal] = ACTIONS(796),
    [sym_hex_integer_literal] = ACTIONS(796),
    [sym_octal_integer_literal] = ACTIONS(794),
    [sym_binary_integer_literal] = ACTIONS(794),
    [sym_decimal_floating_point_literal] = ACTIONS(794),
    [sym_hex_floating_point_literal] = ACTIONS(796),
    [sym_true] = ACTIONS(796),
    [sym_false] = ACTIONS(796),
    [sym_character_literal] = ACTIONS(794),
    [sym_string_literal] = ACTIONS(794),
    [sym_null_literal] = ACTIONS(796),
    [anon_sym_LPAREN] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(796),
    [anon_sym_DASH] = ACTIONS(796),
    [anon_sym_BANG] = ACTIONS(794),
    [anon_sym_TILDE] = ACTIONS(794),
    [anon_sym_PLUS_PLUS] = ACTIONS(794),
    [anon_sym_DASH_DASH] = ACTIONS(794),
    [anon_sym_new] = ACTIONS(796),
    [anon_sym_class] = ACTIONS(796),
    [anon_sym_SEMI] = ACTIONS(794),
    [anon_sym_LBRACE] = ACTIONS(794),
    [anon_sym_RBRACE] = ACTIONS(794),
    [anon_sym_assert] = ACTIONS(796),
    [anon_sym_switch] = ACTIONS(796),
    [anon_sym_case] = ACTIONS(796),
    [anon_sym_default] = ACTIONS(796),
    [anon_sym_do] = ACTIONS(796),
    [anon_sym_while] = ACTIONS(796),
    [anon_sym_break] = ACTIONS(796),
    [anon_sym_continue] = ACTIONS(796),
    [anon_sym_return] = ACTIONS(796),
    [anon_sym_synchronized] = ACTIONS(796),
    [anon_sym_throw] = ACTIONS(796),
    [anon_sym_try] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(796),
    [anon_sym_else] = ACTIONS(796),
    [anon_sym_for] = ACTIONS(796),
    [anon_sym_AT] = ACTIONS(796),
    [anon_sym_open] = ACTIONS(796),
    [anon_sym_module] = ACTIONS(796),
    [anon_sym_static] = ACTIONS(796),
    [anon_sym_package] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(796),
    [anon_sym_enum] = ACTIONS(796),
    [anon_sym_public] = ACTIONS(796),
    [anon_sym_protected] = ACTIONS(796),
    [anon_sym_private] = ACTIONS(796),
    [anon_sym_abstract] = ACTIONS(796),
    [anon_sym_final] = ACTIONS(796),
    [anon_sym_strictfp] = ACTIONS(796),
    [anon_sym_native] = ACTIONS(796),
    [anon_sym_transient] = ACTIONS(796),
    [anon_sym_volatile] = ACTIONS(796),
    [anon_sym_ATinterface] = ACTIONS(794),
    [anon_sym_interface] = ACTIONS(796),
    [anon_sym_byte] = ACTIONS(796),
    [anon_sym_short] = ACTIONS(796),
    [anon_sym_int] = ACTIONS(796),
    [anon_sym_long] = ACTIONS(796),
    [anon_sym_char] = ACTIONS(796),
    [anon_sym_float] = ACTIONS(796),
    [anon_sym_double] = ACTIONS(796),
    [sym_boolean_type] = ACTIONS(796),
    [sym_void_type] = ACTIONS(796),
    [sym_this] = ACTIONS(796),
    [sym_super] = ACTIONS(796),
    [sym_comment] = ACTIONS(3),
  },
  [167] = {
    [ts_builtin_sym_end] = ACTIONS(798),
    [sym_identifier] = ACTIONS(800),
    [sym_decimal_integer_literal] = ACTIONS(800),
    [sym_hex_integer_literal] = ACTIONS(800),
    [sym_octal_integer_literal] = ACTIONS(798),
    [sym_binary_integer_literal] = ACTIONS(798),
    [sym_decimal_floating_point_literal] = ACTIONS(798),
    [sym_hex_floating_point_literal] = ACTIONS(800),
    [sym_true] = ACTIONS(800),
    [sym_false] = ACTIONS(800),
    [sym_character_literal] = ACTIONS(798),
    [sym_string_literal] = ACTIONS(798),
    [sym_null_literal] = ACTIONS(800),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_PLUS] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(798),
    [anon_sym_TILDE] = ACTIONS(798),
    [anon_sym_PLUS_PLUS] = ACTIONS(798),
    [anon_sym_DASH_DASH] = ACTIONS(798),
    [anon_sym_new] = ACTIONS(800),
    [anon_sym_class] = ACTIONS(800),
    [anon_sym_SEMI] = ACTIONS(798),
    [anon_sym_LBRACE] = ACTIONS(798),
    [anon_sym_RBRACE] = ACTIONS(798),
    [anon_sym_assert] = ACTIONS(800),
    [anon_sym_switch] = ACTIONS(800),
    [anon_sym_case] = ACTIONS(800),
    [anon_sym_default] = ACTIONS(800),
    [anon_sym_do] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(800),
    [anon_sym_break] = ACTIONS(800),
    [anon_sym_continue] = ACTIONS(800),
    [anon_sym_return] = ACTIONS(800),
    [anon_sym_synchronized] = ACTIONS(800),
    [anon_sym_throw] = ACTIONS(800),
    [anon_sym_try] = ACTIONS(800),
    [anon_sym_if] = ACTIONS(800),
    [anon_sym_else] = ACTIONS(800),
    [anon_sym_for] = ACTIONS(800),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_open] = ACTIONS(800),
    [anon_sym_module] = ACTIONS(800),
    [anon_sym_static] = ACTIONS(800),
    [anon_sym_package] = ACTIONS(800),
    [anon_sym_import] = ACTIONS(800),
    [anon_sym_enum] = ACTIONS(800),
    [anon_sym_public] = ACTIONS(800),
    [anon_sym_protected] = ACTIONS(800),
    [anon_sym_private] = ACTIONS(800),
    [anon_sym_abstract] = ACTIONS(800),
    [anon_sym_final] = ACTIONS(800),
    [anon_sym_strictfp] = ACTIONS(800),
    [anon_sym_native] = ACTIONS(800),
    [anon_sym_transient] = ACTIONS(800),
    [anon_sym_volatile] = ACTIONS(800),
    [anon_sym_ATinterface] = ACTIONS(798),
    [anon_sym_interface] = ACTIONS(800),
    [anon_sym_byte] = ACTIONS(800),
    [anon_sym_short] = ACTIONS(800),
    [anon_sym_int] = ACTIONS(800),
    [anon_sym_long] = ACTIONS(800),
    [anon_sym_char] = ACTIONS(800),
    [anon_sym_float] = ACTIONS(800),
    [anon_sym_double] = ACTIONS(800),
    [sym_boolean_type] = ACTIONS(800),
    [sym_void_type] = ACTIONS(800),
    [sym_this] = ACTIONS(800),
    [sym_super] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [168] = {
    [ts_builtin_sym_end] = ACTIONS(802),
    [sym_identifier] = ACTIONS(804),
    [sym_decimal_integer_literal] = ACTIONS(804),
    [sym_hex_integer_literal] = ACTIONS(804),
    [sym_octal_integer_literal] = ACTIONS(802),
    [sym_binary_integer_literal] = ACTIONS(802),
    [sym_decimal_floating_point_literal] = ACTIONS(802),
    [sym_hex_floating_point_literal] = ACTIONS(804),
    [sym_true] = ACTIONS(804),
    [sym_false] = ACTIONS(804),
    [sym_character_literal] = ACTIONS(802),
    [sym_string_literal] = ACTIONS(802),
    [sym_null_literal] = ACTIONS(804),
    [anon_sym_LPAREN] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(804),
    [anon_sym_DASH] = ACTIONS(804),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_TILDE] = ACTIONS(802),
    [anon_sym_PLUS_PLUS] = ACTIONS(802),
    [anon_sym_DASH_DASH] = ACTIONS(802),
    [anon_sym_new] = ACTIONS(804),
    [anon_sym_class] = ACTIONS(804),
    [anon_sym_SEMI] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(802),
    [anon_sym_RBRACE] = ACTIONS(802),
    [anon_sym_assert] = ACTIONS(804),
    [anon_sym_switch] = ACTIONS(804),
    [anon_sym_case] = ACTIONS(804),
    [anon_sym_default] = ACTIONS(804),
    [anon_sym_do] = ACTIONS(804),
    [anon_sym_while] = ACTIONS(804),
    [anon_sym_break] = ACTIONS(804),
    [anon_sym_continue] = ACTIONS(804),
    [anon_sym_return] = ACTIONS(804),
    [anon_sym_synchronized] = ACTIONS(804),
    [anon_sym_throw] = ACTIONS(804),
    [anon_sym_try] = ACTIONS(804),
    [anon_sym_if] = ACTIONS(804),
    [anon_sym_else] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(804),
    [anon_sym_AT] = ACTIONS(804),
    [anon_sym_open] = ACTIONS(804),
    [anon_sym_module] = ACTIONS(804),
    [anon_sym_static] = ACTIONS(804),
    [anon_sym_package] = ACTIONS(804),
    [anon_sym_import] = ACTIONS(804),
    [anon_sym_enum] = ACTIONS(804),
    [anon_sym_public] = ACTIONS(804),
    [anon_sym_protected] = ACTIONS(804),
    [anon_sym_private] = ACTIONS(804),
    [anon_sym_abstract] = ACTIONS(804),
    [anon_sym_final] = ACTIONS(804),
    [anon_sym_strictfp] = ACTIONS(804),
    [anon_sym_native] = ACTIONS(804),
    [anon_sym_transient] = ACTIONS(804),
    [anon_sym_volatile] = ACTIONS(804),
    [anon_sym_ATinterface] = ACTIONS(802),
    [anon_sym_interface] = ACTIONS(804),
    [anon_sym_byte] = ACTIONS(804),
    [anon_sym_short] = ACTIONS(804),
    [anon_sym_int] = ACTIONS(804),
    [anon_sym_long] = ACTIONS(804),
    [anon_sym_char] = ACTIONS(804),
    [anon_sym_float] = ACTIONS(804),
    [anon_sym_double] = ACTIONS(804),
    [sym_boolean_type] = ACTIONS(804),
    [sym_void_type] = ACTIONS(804),
    [sym_this] = ACTIONS(804),
    [sym_super] = ACTIONS(804),
    [sym_comment] = ACTIONS(3),
  },
  [169] = {
    [ts_builtin_sym_end] = ACTIONS(806),
    [sym_identifier] = ACTIONS(808),
    [sym_decimal_integer_literal] = ACTIONS(808),
    [sym_hex_integer_literal] = ACTIONS(808),
    [sym_octal_integer_literal] = ACTIONS(806),
    [sym_binary_integer_literal] = ACTIONS(806),
    [sym_decimal_floating_point_literal] = ACTIONS(806),
    [sym_hex_floating_point_literal] = ACTIONS(808),
    [sym_true] = ACTIONS(808),
    [sym_false] = ACTIONS(808),
    [sym_character_literal] = ACTIONS(806),
    [sym_string_literal] = ACTIONS(806),
    [sym_null_literal] = ACTIONS(808),
    [anon_sym_LPAREN] = ACTIONS(806),
    [anon_sym_PLUS] = ACTIONS(808),
    [anon_sym_DASH] = ACTIONS(808),
    [anon_sym_BANG] = ACTIONS(806),
    [anon_sym_TILDE] = ACTIONS(806),
    [anon_sym_PLUS_PLUS] = ACTIONS(806),
    [anon_sym_DASH_DASH] = ACTIONS(806),
    [anon_sym_new] = ACTIONS(808),
    [anon_sym_class] = ACTIONS(808),
    [anon_sym_SEMI] = ACTIONS(806),
    [anon_sym_LBRACE] = ACTIONS(806),
    [anon_sym_RBRACE] = ACTIONS(806),
    [anon_sym_assert] = ACTIONS(808),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_case] = ACTIONS(808),
    [anon_sym_default] = ACTIONS(808),
    [anon_sym_do] = ACTIONS(808),
    [anon_sym_while] = ACTIONS(808),
    [anon_sym_break] = ACTIONS(808),
    [anon_sym_continue] = ACTIONS(808),
    [anon_sym_return] = ACTIONS(808),
    [anon_sym_synchronized] = ACTIONS(808),
    [anon_sym_throw] = ACTIONS(808),
    [anon_sym_try] = ACTIONS(808),
    [anon_sym_if] = ACTIONS(808),
    [anon_sym_else] = ACTIONS(808),
    [anon_sym_for] = ACTIONS(808),
    [anon_sym_AT] = ACTIONS(808),
    [anon_sym_open] = ACTIONS(808),
    [anon_sym_module] = ACTIONS(808),
    [anon_sym_static] = ACTIONS(808),
    [anon_sym_package] = ACTIONS(808),
    [anon_sym_import] = ACTIONS(808),
    [anon_sym_enum] = ACTIONS(808),
    [anon_sym_public] = ACTIONS(808),
    [anon_sym_protected] = ACTIONS(808),
    [anon_sym_private] = ACTIONS(808),
    [anon_sym_abstract] = ACTIONS(808),
    [anon_sym_final] = ACTIONS(808),
    [anon_sym_strictfp] = ACTIONS(808),
    [anon_sym_native] = ACTIONS(808),
    [anon_sym_transient] = ACTIONS(808),
    [anon_sym_volatile] = ACTIONS(808),
    [anon_sym_ATinterface] = ACTIONS(806),
    [anon_sym_interface] = ACTIONS(808),
    [anon_sym_byte] = ACTIONS(808),
    [anon_sym_short] = ACTIONS(808),
    [anon_sym_int] = ACTIONS(808),
    [anon_sym_long] = ACTIONS(808),
    [anon_sym_char] = ACTIONS(808),
    [anon_sym_float] = ACTIONS(808),
    [anon_sym_double] = ACTIONS(808),
    [sym_boolean_type] = ACTIONS(808),
    [sym_void_type] = ACTIONS(808),
    [sym_this] = ACTIONS(808),
    [sym_super] = ACTIONS(808),
    [sym_comment] = ACTIONS(3),
  },
  [170] = {
    [ts_builtin_sym_end] = ACTIONS(810),
    [sym_identifier] = ACTIONS(812),
    [sym_decimal_integer_literal] = ACTIONS(812),
    [sym_hex_integer_literal] = ACTIONS(812),
    [sym_octal_integer_literal] = ACTIONS(810),
    [sym_binary_integer_literal] = ACTIONS(810),
    [sym_decimal_floating_point_literal] = ACTIONS(810),
    [sym_hex_floating_point_literal] = ACTIONS(812),
    [sym_true] = ACTIONS(812),
    [sym_false] = ACTIONS(812),
    [sym_character_literal] = ACTIONS(810),
    [sym_string_literal] = ACTIONS(810),
    [sym_null_literal] = ACTIONS(812),
    [anon_sym_LPAREN] = ACTIONS(810),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_BANG] = ACTIONS(810),
    [anon_sym_TILDE] = ACTIONS(810),
    [anon_sym_PLUS_PLUS] = ACTIONS(810),
    [anon_sym_DASH_DASH] = ACTIONS(810),
    [anon_sym_new] = ACTIONS(812),
    [anon_sym_class] = ACTIONS(812),
    [anon_sym_SEMI] = ACTIONS(810),
    [anon_sym_LBRACE] = ACTIONS(810),
    [anon_sym_RBRACE] = ACTIONS(810),
    [anon_sym_assert] = ACTIONS(812),
    [anon_sym_switch] = ACTIONS(812),
    [anon_sym_case] = ACTIONS(812),
    [anon_sym_default] = ACTIONS(812),
    [anon_sym_do] = ACTIONS(812),
    [anon_sym_while] = ACTIONS(812),
    [anon_sym_break] = ACTIONS(812),
    [anon_sym_continue] = ACTIONS(812),
    [anon_sym_return] = ACTIONS(812),
    [anon_sym_synchronized] = ACTIONS(812),
    [anon_sym_throw] = ACTIONS(812),
    [anon_sym_try] = ACTIONS(812),
    [anon_sym_if] = ACTIONS(812),
    [anon_sym_else] = ACTIONS(812),
    [anon_sym_for] = ACTIONS(812),
    [anon_sym_AT] = ACTIONS(812),
    [anon_sym_open] = ACTIONS(812),
    [anon_sym_module] = ACTIONS(812),
    [anon_sym_static] = ACTIONS(812),
    [anon_sym_package] = ACTIONS(812),
    [anon_sym_import] = ACTIONS(812),
    [anon_sym_enum] = ACTIONS(812),
    [anon_sym_public] = ACTIONS(812),
    [anon_sym_protected] = ACTIONS(812),
    [anon_sym_private] = ACTIONS(812),
    [anon_sym_abstract] = ACTIONS(812),
    [anon_sym_final] = ACTIONS(812),
    [anon_sym_strictfp] = ACTIONS(812),
    [anon_sym_native] = ACTIONS(812),
    [anon_sym_transient] = ACTIONS(812),
    [anon_sym_volatile] = ACTIONS(812),
    [anon_sym_ATinterface] = ACTIONS(810),
    [anon_sym_interface] = ACTIONS(812),
    [anon_sym_byte] = ACTIONS(812),
    [anon_sym_short] = ACTIONS(812),
    [anon_sym_int] = ACTIONS(812),
    [anon_sym_long] = ACTIONS(812),
    [anon_sym_char] = ACTIONS(812),
    [anon_sym_float] = ACTIONS(812),
    [anon_sym_double] = ACTIONS(812),
    [sym_boolean_type] = ACTIONS(812),
    [sym_void_type] = ACTIONS(812),
    [sym_this] = ACTIONS(812),
    [sym_super] = ACTIONS(812),
    [sym_comment] = ACTIONS(3),
  },
  [171] = {
    [ts_builtin_sym_end] = ACTIONS(814),
    [sym_identifier] = ACTIONS(816),
    [sym_decimal_integer_literal] = ACTIONS(816),
    [sym_hex_integer_literal] = ACTIONS(816),
    [sym_octal_integer_literal] = ACTIONS(814),
    [sym_binary_integer_literal] = ACTIONS(814),
    [sym_decimal_floating_point_literal] = ACTIONS(814),
    [sym_hex_floating_point_literal] = ACTIONS(816),
    [sym_true] = ACTIONS(816),
    [sym_false] = ACTIONS(816),
    [sym_character_literal] = ACTIONS(814),
    [sym_string_literal] = ACTIONS(814),
    [sym_null_literal] = ACTIONS(816),
    [anon_sym_LPAREN] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(816),
    [anon_sym_DASH] = ACTIONS(816),
    [anon_sym_BANG] = ACTIONS(814),
    [anon_sym_TILDE] = ACTIONS(814),
    [anon_sym_PLUS_PLUS] = ACTIONS(814),
    [anon_sym_DASH_DASH] = ACTIONS(814),
    [anon_sym_new] = ACTIONS(816),
    [anon_sym_class] = ACTIONS(816),
    [anon_sym_SEMI] = ACTIONS(814),
    [anon_sym_LBRACE] = ACTIONS(814),
    [anon_sym_RBRACE] = ACTIONS(814),
    [anon_sym_assert] = ACTIONS(816),
    [anon_sym_switch] = ACTIONS(816),
    [anon_sym_case] = ACTIONS(816),
    [anon_sym_default] = ACTIONS(816),
    [anon_sym_do] = ACTIONS(816),
    [anon_sym_while] = ACTIONS(816),
    [anon_sym_break] = ACTIONS(816),
    [anon_sym_continue] = ACTIONS(816),
    [anon_sym_return] = ACTIONS(816),
    [anon_sym_synchronized] = ACTIONS(816),
    [anon_sym_throw] = ACTIONS(816),
    [anon_sym_try] = ACTIONS(816),
    [anon_sym_if] = ACTIONS(816),
    [anon_sym_else] = ACTIONS(816),
    [anon_sym_for] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(816),
    [anon_sym_open] = ACTIONS(816),
    [anon_sym_module] = ACTIONS(816),
    [anon_sym_static] = ACTIONS(816),
    [anon_sym_package] = ACTIONS(816),
    [anon_sym_import] = ACTIONS(816),
    [anon_sym_enum] = ACTIONS(816),
    [anon_sym_public] = ACTIONS(816),
    [anon_sym_protected] = ACTIONS(816),
    [anon_sym_private] = ACTIONS(816),
    [anon_sym_abstract] = ACTIONS(816),
    [anon_sym_final] = ACTIONS(816),
    [anon_sym_strictfp] = ACTIONS(816),
    [anon_sym_native] = ACTIONS(816),
    [anon_sym_transient] = ACTIONS(816),
    [anon_sym_volatile] = ACTIONS(816),
    [anon_sym_ATinterface] = ACTIONS(814),
    [anon_sym_interface] = ACTIONS(816),
    [anon_sym_byte] = ACTIONS(816),
    [anon_sym_short] = ACTIONS(816),
    [anon_sym_int] = ACTIONS(816),
    [anon_sym_long] = ACTIONS(816),
    [anon_sym_char] = ACTIONS(816),
    [anon_sym_float] = ACTIONS(816),
    [anon_sym_double] = ACTIONS(816),
    [sym_boolean_type] = ACTIONS(816),
    [sym_void_type] = ACTIONS(816),
    [sym_this] = ACTIONS(816),
    [sym_super] = ACTIONS(816),
    [sym_comment] = ACTIONS(3),
  },
  [172] = {
    [ts_builtin_sym_end] = ACTIONS(818),
    [sym_identifier] = ACTIONS(820),
    [sym_decimal_integer_literal] = ACTIONS(820),
    [sym_hex_integer_literal] = ACTIONS(820),
    [sym_octal_integer_literal] = ACTIONS(818),
    [sym_binary_integer_literal] = ACTIONS(818),
    [sym_decimal_floating_point_literal] = ACTIONS(818),
    [sym_hex_floating_point_literal] = ACTIONS(820),
    [sym_true] = ACTIONS(820),
    [sym_false] = ACTIONS(820),
    [sym_character_literal] = ACTIONS(818),
    [sym_string_literal] = ACTIONS(818),
    [sym_null_literal] = ACTIONS(820),
    [anon_sym_LPAREN] = ACTIONS(818),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(818),
    [anon_sym_TILDE] = ACTIONS(818),
    [anon_sym_PLUS_PLUS] = ACTIONS(818),
    [anon_sym_DASH_DASH] = ACTIONS(818),
    [anon_sym_new] = ACTIONS(820),
    [anon_sym_class] = ACTIONS(820),
    [anon_sym_SEMI] = ACTIONS(818),
    [anon_sym_LBRACE] = ACTIONS(818),
    [anon_sym_RBRACE] = ACTIONS(818),
    [anon_sym_assert] = ACTIONS(820),
    [anon_sym_switch] = ACTIONS(820),
    [anon_sym_case] = ACTIONS(820),
    [anon_sym_default] = ACTIONS(820),
    [anon_sym_do] = ACTIONS(820),
    [anon_sym_while] = ACTIONS(820),
    [anon_sym_break] = ACTIONS(820),
    [anon_sym_continue] = ACTIONS(820),
    [anon_sym_return] = ACTIONS(820),
    [anon_sym_synchronized] = ACTIONS(820),
    [anon_sym_throw] = ACTIONS(820),
    [anon_sym_try] = ACTIONS(820),
    [anon_sym_if] = ACTIONS(820),
    [anon_sym_else] = ACTIONS(820),
    [anon_sym_for] = ACTIONS(820),
    [anon_sym_AT] = ACTIONS(820),
    [anon_sym_open] = ACTIONS(820),
    [anon_sym_module] = ACTIONS(820),
    [anon_sym_static] = ACTIONS(820),
    [anon_sym_package] = ACTIONS(820),
    [anon_sym_import] = ACTIONS(820),
    [anon_sym_enum] = ACTIONS(820),
    [anon_sym_public] = ACTIONS(820),
    [anon_sym_protected] = ACTIONS(820),
    [anon_sym_private] = ACTIONS(820),
    [anon_sym_abstract] = ACTIONS(820),
    [anon_sym_final] = ACTIONS(820),
    [anon_sym_strictfp] = ACTIONS(820),
    [anon_sym_native] = ACTIONS(820),
    [anon_sym_transient] = ACTIONS(820),
    [anon_sym_volatile] = ACTIONS(820),
    [anon_sym_ATinterface] = ACTIONS(818),
    [anon_sym_interface] = ACTIONS(820),
    [anon_sym_byte] = ACTIONS(820),
    [anon_sym_short] = ACTIONS(820),
    [anon_sym_int] = ACTIONS(820),
    [anon_sym_long] = ACTIONS(820),
    [anon_sym_char] = ACTIONS(820),
    [anon_sym_float] = ACTIONS(820),
    [anon_sym_double] = ACTIONS(820),
    [sym_boolean_type] = ACTIONS(820),
    [sym_void_type] = ACTIONS(820),
    [sym_this] = ACTIONS(820),
    [sym_super] = ACTIONS(820),
    [sym_comment] = ACTIONS(3),
  },
  [173] = {
    [ts_builtin_sym_end] = ACTIONS(822),
    [sym_identifier] = ACTIONS(824),
    [sym_decimal_integer_literal] = ACTIONS(824),
    [sym_hex_integer_literal] = ACTIONS(824),
    [sym_octal_integer_literal] = ACTIONS(822),
    [sym_binary_integer_literal] = ACTIONS(822),
    [sym_decimal_floating_point_literal] = ACTIONS(822),
    [sym_hex_floating_point_literal] = ACTIONS(824),
    [sym_true] = ACTIONS(824),
    [sym_false] = ACTIONS(824),
    [sym_character_literal] = ACTIONS(822),
    [sym_string_literal] = ACTIONS(822),
    [sym_null_literal] = ACTIONS(824),
    [anon_sym_LPAREN] = ACTIONS(822),
    [anon_sym_PLUS] = ACTIONS(824),
    [anon_sym_DASH] = ACTIONS(824),
    [anon_sym_BANG] = ACTIONS(822),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_PLUS_PLUS] = ACTIONS(822),
    [anon_sym_DASH_DASH] = ACTIONS(822),
    [anon_sym_new] = ACTIONS(824),
    [anon_sym_class] = ACTIONS(824),
    [anon_sym_SEMI] = ACTIONS(822),
    [anon_sym_LBRACE] = ACTIONS(822),
    [anon_sym_RBRACE] = ACTIONS(822),
    [anon_sym_assert] = ACTIONS(824),
    [anon_sym_switch] = ACTIONS(824),
    [anon_sym_case] = ACTIONS(824),
    [anon_sym_default] = ACTIONS(824),
    [anon_sym_do] = ACTIONS(824),
    [anon_sym_while] = ACTIONS(824),
    [anon_sym_break] = ACTIONS(824),
    [anon_sym_continue] = ACTIONS(824),
    [anon_sym_return] = ACTIONS(824),
    [anon_sym_synchronized] = ACTIONS(824),
    [anon_sym_throw] = ACTIONS(824),
    [anon_sym_try] = ACTIONS(824),
    [anon_sym_if] = ACTIONS(824),
    [anon_sym_else] = ACTIONS(824),
    [anon_sym_for] = ACTIONS(824),
    [anon_sym_AT] = ACTIONS(824),
    [anon_sym_open] = ACTIONS(824),
    [anon_sym_module] = ACTIONS(824),
    [anon_sym_static] = ACTIONS(824),
    [anon_sym_package] = ACTIONS(824),
    [anon_sym_import] = ACTIONS(824),
    [anon_sym_enum] = ACTIONS(824),
    [anon_sym_public] = ACTIONS(824),
    [anon_sym_protected] = ACTIONS(824),
    [anon_sym_private] = ACTIONS(824),
    [anon_sym_abstract] = ACTIONS(824),
    [anon_sym_final] = ACTIONS(824),
    [anon_sym_strictfp] = ACTIONS(824),
    [anon_sym_native] = ACTIONS(824),
    [anon_sym_transient] = ACTIONS(824),
    [anon_sym_volatile] = ACTIONS(824),
    [anon_sym_ATinterface] = ACTIONS(822),
    [anon_sym_interface] = ACTIONS(824),
    [anon_sym_byte] = ACTIONS(824),
    [anon_sym_short] = ACTIONS(824),
    [anon_sym_int] = ACTIONS(824),
    [anon_sym_long] = ACTIONS(824),
    [anon_sym_char] = ACTIONS(824),
    [anon_sym_float] = ACTIONS(824),
    [anon_sym_double] = ACTIONS(824),
    [sym_boolean_type] = ACTIONS(824),
    [sym_void_type] = ACTIONS(824),
    [sym_this] = ACTIONS(824),
    [sym_super] = ACTIONS(824),
    [sym_comment] = ACTIONS(3),
  },
  [174] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(362),
    [sym_cast_expression] = STATE(362),
    [sym_assignment_expression] = STATE(362),
    [sym_binary_expression] = STATE(362),
    [sym_instanceof_expression] = STATE(362),
    [sym_lambda_expression] = STATE(362),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(362),
    [sym_unary_expression] = STATE(362),
    [sym_update_expression] = STATE(362),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [175] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(399),
    [sym_cast_expression] = STATE(399),
    [sym_assignment_expression] = STATE(399),
    [sym_binary_expression] = STATE(399),
    [sym_instanceof_expression] = STATE(399),
    [sym_lambda_expression] = STATE(399),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(399),
    [sym_unary_expression] = STATE(399),
    [sym_update_expression] = STATE(399),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [176] = {
    [ts_builtin_sym_end] = ACTIONS(826),
    [sym_identifier] = ACTIONS(828),
    [sym_decimal_integer_literal] = ACTIONS(828),
    [sym_hex_integer_literal] = ACTIONS(828),
    [sym_octal_integer_literal] = ACTIONS(826),
    [sym_binary_integer_literal] = ACTIONS(826),
    [sym_decimal_floating_point_literal] = ACTIONS(826),
    [sym_hex_floating_point_literal] = ACTIONS(828),
    [sym_true] = ACTIONS(828),
    [sym_false] = ACTIONS(828),
    [sym_character_literal] = ACTIONS(826),
    [sym_string_literal] = ACTIONS(826),
    [sym_null_literal] = ACTIONS(828),
    [anon_sym_LPAREN] = ACTIONS(826),
    [anon_sym_PLUS] = ACTIONS(828),
    [anon_sym_DASH] = ACTIONS(828),
    [anon_sym_BANG] = ACTIONS(826),
    [anon_sym_TILDE] = ACTIONS(826),
    [anon_sym_PLUS_PLUS] = ACTIONS(826),
    [anon_sym_DASH_DASH] = ACTIONS(826),
    [anon_sym_new] = ACTIONS(828),
    [anon_sym_class] = ACTIONS(828),
    [anon_sym_SEMI] = ACTIONS(826),
    [anon_sym_LBRACE] = ACTIONS(826),
    [anon_sym_RBRACE] = ACTIONS(826),
    [anon_sym_assert] = ACTIONS(828),
    [anon_sym_switch] = ACTIONS(828),
    [anon_sym_case] = ACTIONS(828),
    [anon_sym_default] = ACTIONS(828),
    [anon_sym_do] = ACTIONS(828),
    [anon_sym_while] = ACTIONS(828),
    [anon_sym_break] = ACTIONS(828),
    [anon_sym_continue] = ACTIONS(828),
    [anon_sym_return] = ACTIONS(828),
    [anon_sym_synchronized] = ACTIONS(828),
    [anon_sym_throw] = ACTIONS(828),
    [anon_sym_try] = ACTIONS(828),
    [anon_sym_if] = ACTIONS(828),
    [anon_sym_else] = ACTIONS(828),
    [anon_sym_for] = ACTIONS(828),
    [anon_sym_AT] = ACTIONS(828),
    [anon_sym_open] = ACTIONS(828),
    [anon_sym_module] = ACTIONS(828),
    [anon_sym_static] = ACTIONS(828),
    [anon_sym_package] = ACTIONS(828),
    [anon_sym_import] = ACTIONS(828),
    [anon_sym_enum] = ACTIONS(828),
    [anon_sym_public] = ACTIONS(828),
    [anon_sym_protected] = ACTIONS(828),
    [anon_sym_private] = ACTIONS(828),
    [anon_sym_abstract] = ACTIONS(828),
    [anon_sym_final] = ACTIONS(828),
    [anon_sym_strictfp] = ACTIONS(828),
    [anon_sym_native] = ACTIONS(828),
    [anon_sym_transient] = ACTIONS(828),
    [anon_sym_volatile] = ACTIONS(828),
    [anon_sym_ATinterface] = ACTIONS(826),
    [anon_sym_interface] = ACTIONS(828),
    [anon_sym_byte] = ACTIONS(828),
    [anon_sym_short] = ACTIONS(828),
    [anon_sym_int] = ACTIONS(828),
    [anon_sym_long] = ACTIONS(828),
    [anon_sym_char] = ACTIONS(828),
    [anon_sym_float] = ACTIONS(828),
    [anon_sym_double] = ACTIONS(828),
    [sym_boolean_type] = ACTIONS(828),
    [sym_void_type] = ACTIONS(828),
    [sym_this] = ACTIONS(828),
    [sym_super] = ACTIONS(828),
    [sym_comment] = ACTIONS(3),
  },
  [177] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(421),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [178] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(406),
    [sym_cast_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_instanceof_expression] = STATE(406),
    [sym_lambda_expression] = STATE(406),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [179] = {
    [ts_builtin_sym_end] = ACTIONS(830),
    [sym_identifier] = ACTIONS(832),
    [sym_decimal_integer_literal] = ACTIONS(832),
    [sym_hex_integer_literal] = ACTIONS(832),
    [sym_octal_integer_literal] = ACTIONS(830),
    [sym_binary_integer_literal] = ACTIONS(830),
    [sym_decimal_floating_point_literal] = ACTIONS(830),
    [sym_hex_floating_point_literal] = ACTIONS(832),
    [sym_true] = ACTIONS(832),
    [sym_false] = ACTIONS(832),
    [sym_character_literal] = ACTIONS(830),
    [sym_string_literal] = ACTIONS(830),
    [sym_null_literal] = ACTIONS(832),
    [anon_sym_LPAREN] = ACTIONS(830),
    [anon_sym_PLUS] = ACTIONS(832),
    [anon_sym_DASH] = ACTIONS(832),
    [anon_sym_BANG] = ACTIONS(830),
    [anon_sym_TILDE] = ACTIONS(830),
    [anon_sym_PLUS_PLUS] = ACTIONS(830),
    [anon_sym_DASH_DASH] = ACTIONS(830),
    [anon_sym_new] = ACTIONS(832),
    [anon_sym_class] = ACTIONS(832),
    [anon_sym_SEMI] = ACTIONS(830),
    [anon_sym_LBRACE] = ACTIONS(830),
    [anon_sym_RBRACE] = ACTIONS(830),
    [anon_sym_assert] = ACTIONS(832),
    [anon_sym_switch] = ACTIONS(832),
    [anon_sym_case] = ACTIONS(832),
    [anon_sym_default] = ACTIONS(832),
    [anon_sym_do] = ACTIONS(832),
    [anon_sym_while] = ACTIONS(832),
    [anon_sym_break] = ACTIONS(832),
    [anon_sym_continue] = ACTIONS(832),
    [anon_sym_return] = ACTIONS(832),
    [anon_sym_synchronized] = ACTIONS(832),
    [anon_sym_throw] = ACTIONS(832),
    [anon_sym_try] = ACTIONS(832),
    [anon_sym_if] = ACTIONS(832),
    [anon_sym_else] = ACTIONS(832),
    [anon_sym_for] = ACTIONS(832),
    [anon_sym_AT] = ACTIONS(832),
    [anon_sym_open] = ACTIONS(832),
    [anon_sym_module] = ACTIONS(832),
    [anon_sym_static] = ACTIONS(832),
    [anon_sym_package] = ACTIONS(832),
    [anon_sym_import] = ACTIONS(832),
    [anon_sym_enum] = ACTIONS(832),
    [anon_sym_public] = ACTIONS(832),
    [anon_sym_protected] = ACTIONS(832),
    [anon_sym_private] = ACTIONS(832),
    [anon_sym_abstract] = ACTIONS(832),
    [anon_sym_final] = ACTIONS(832),
    [anon_sym_strictfp] = ACTIONS(832),
    [anon_sym_native] = ACTIONS(832),
    [anon_sym_transient] = ACTIONS(832),
    [anon_sym_volatile] = ACTIONS(832),
    [anon_sym_ATinterface] = ACTIONS(830),
    [anon_sym_interface] = ACTIONS(832),
    [anon_sym_byte] = ACTIONS(832),
    [anon_sym_short] = ACTIONS(832),
    [anon_sym_int] = ACTIONS(832),
    [anon_sym_long] = ACTIONS(832),
    [anon_sym_char] = ACTIONS(832),
    [anon_sym_float] = ACTIONS(832),
    [anon_sym_double] = ACTIONS(832),
    [sym_boolean_type] = ACTIONS(832),
    [sym_void_type] = ACTIONS(832),
    [sym_this] = ACTIONS(832),
    [sym_super] = ACTIONS(832),
    [sym_comment] = ACTIONS(3),
  },
  [180] = {
    [ts_builtin_sym_end] = ACTIONS(834),
    [sym_identifier] = ACTIONS(836),
    [sym_decimal_integer_literal] = ACTIONS(836),
    [sym_hex_integer_literal] = ACTIONS(836),
    [sym_octal_integer_literal] = ACTIONS(834),
    [sym_binary_integer_literal] = ACTIONS(834),
    [sym_decimal_floating_point_literal] = ACTIONS(834),
    [sym_hex_floating_point_literal] = ACTIONS(836),
    [sym_true] = ACTIONS(836),
    [sym_false] = ACTIONS(836),
    [sym_character_literal] = ACTIONS(834),
    [sym_string_literal] = ACTIONS(834),
    [sym_null_literal] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(834),
    [anon_sym_PLUS] = ACTIONS(836),
    [anon_sym_DASH] = ACTIONS(836),
    [anon_sym_BANG] = ACTIONS(834),
    [anon_sym_TILDE] = ACTIONS(834),
    [anon_sym_PLUS_PLUS] = ACTIONS(834),
    [anon_sym_DASH_DASH] = ACTIONS(834),
    [anon_sym_new] = ACTIONS(836),
    [anon_sym_class] = ACTIONS(836),
    [anon_sym_SEMI] = ACTIONS(834),
    [anon_sym_LBRACE] = ACTIONS(834),
    [anon_sym_RBRACE] = ACTIONS(834),
    [anon_sym_assert] = ACTIONS(836),
    [anon_sym_switch] = ACTIONS(836),
    [anon_sym_case] = ACTIONS(836),
    [anon_sym_default] = ACTIONS(836),
    [anon_sym_do] = ACTIONS(836),
    [anon_sym_while] = ACTIONS(836),
    [anon_sym_break] = ACTIONS(836),
    [anon_sym_continue] = ACTIONS(836),
    [anon_sym_return] = ACTIONS(836),
    [anon_sym_synchronized] = ACTIONS(836),
    [anon_sym_throw] = ACTIONS(836),
    [anon_sym_try] = ACTIONS(836),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_else] = ACTIONS(836),
    [anon_sym_for] = ACTIONS(836),
    [anon_sym_AT] = ACTIONS(836),
    [anon_sym_open] = ACTIONS(836),
    [anon_sym_module] = ACTIONS(836),
    [anon_sym_static] = ACTIONS(836),
    [anon_sym_package] = ACTIONS(836),
    [anon_sym_import] = ACTIONS(836),
    [anon_sym_enum] = ACTIONS(836),
    [anon_sym_public] = ACTIONS(836),
    [anon_sym_protected] = ACTIONS(836),
    [anon_sym_private] = ACTIONS(836),
    [anon_sym_abstract] = ACTIONS(836),
    [anon_sym_final] = ACTIONS(836),
    [anon_sym_strictfp] = ACTIONS(836),
    [anon_sym_native] = ACTIONS(836),
    [anon_sym_transient] = ACTIONS(836),
    [anon_sym_volatile] = ACTIONS(836),
    [anon_sym_ATinterface] = ACTIONS(834),
    [anon_sym_interface] = ACTIONS(836),
    [anon_sym_byte] = ACTIONS(836),
    [anon_sym_short] = ACTIONS(836),
    [anon_sym_int] = ACTIONS(836),
    [anon_sym_long] = ACTIONS(836),
    [anon_sym_char] = ACTIONS(836),
    [anon_sym_float] = ACTIONS(836),
    [anon_sym_double] = ACTIONS(836),
    [sym_boolean_type] = ACTIONS(836),
    [sym_void_type] = ACTIONS(836),
    [sym_this] = ACTIONS(836),
    [sym_super] = ACTIONS(836),
    [sym_comment] = ACTIONS(3),
  },
  [181] = {
    [ts_builtin_sym_end] = ACTIONS(838),
    [sym_identifier] = ACTIONS(840),
    [sym_decimal_integer_literal] = ACTIONS(840),
    [sym_hex_integer_literal] = ACTIONS(840),
    [sym_octal_integer_literal] = ACTIONS(838),
    [sym_binary_integer_literal] = ACTIONS(838),
    [sym_decimal_floating_point_literal] = ACTIONS(838),
    [sym_hex_floating_point_literal] = ACTIONS(840),
    [sym_true] = ACTIONS(840),
    [sym_false] = ACTIONS(840),
    [sym_character_literal] = ACTIONS(838),
    [sym_string_literal] = ACTIONS(838),
    [sym_null_literal] = ACTIONS(840),
    [anon_sym_LPAREN] = ACTIONS(838),
    [anon_sym_PLUS] = ACTIONS(840),
    [anon_sym_DASH] = ACTIONS(840),
    [anon_sym_BANG] = ACTIONS(838),
    [anon_sym_TILDE] = ACTIONS(838),
    [anon_sym_PLUS_PLUS] = ACTIONS(838),
    [anon_sym_DASH_DASH] = ACTIONS(838),
    [anon_sym_new] = ACTIONS(840),
    [anon_sym_class] = ACTIONS(840),
    [anon_sym_SEMI] = ACTIONS(838),
    [anon_sym_LBRACE] = ACTIONS(838),
    [anon_sym_RBRACE] = ACTIONS(838),
    [anon_sym_assert] = ACTIONS(840),
    [anon_sym_switch] = ACTIONS(840),
    [anon_sym_case] = ACTIONS(840),
    [anon_sym_default] = ACTIONS(840),
    [anon_sym_do] = ACTIONS(840),
    [anon_sym_while] = ACTIONS(840),
    [anon_sym_break] = ACTIONS(840),
    [anon_sym_continue] = ACTIONS(840),
    [anon_sym_return] = ACTIONS(840),
    [anon_sym_synchronized] = ACTIONS(840),
    [anon_sym_throw] = ACTIONS(840),
    [anon_sym_try] = ACTIONS(840),
    [anon_sym_if] = ACTIONS(840),
    [anon_sym_else] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(840),
    [anon_sym_AT] = ACTIONS(840),
    [anon_sym_open] = ACTIONS(840),
    [anon_sym_module] = ACTIONS(840),
    [anon_sym_static] = ACTIONS(840),
    [anon_sym_package] = ACTIONS(840),
    [anon_sym_import] = ACTIONS(840),
    [anon_sym_enum] = ACTIONS(840),
    [anon_sym_public] = ACTIONS(840),
    [anon_sym_protected] = ACTIONS(840),
    [anon_sym_private] = ACTIONS(840),
    [anon_sym_abstract] = ACTIONS(840),
    [anon_sym_final] = ACTIONS(840),
    [anon_sym_strictfp] = ACTIONS(840),
    [anon_sym_native] = ACTIONS(840),
    [anon_sym_transient] = ACTIONS(840),
    [anon_sym_volatile] = ACTIONS(840),
    [anon_sym_ATinterface] = ACTIONS(838),
    [anon_sym_interface] = ACTIONS(840),
    [anon_sym_byte] = ACTIONS(840),
    [anon_sym_short] = ACTIONS(840),
    [anon_sym_int] = ACTIONS(840),
    [anon_sym_long] = ACTIONS(840),
    [anon_sym_char] = ACTIONS(840),
    [anon_sym_float] = ACTIONS(840),
    [anon_sym_double] = ACTIONS(840),
    [sym_boolean_type] = ACTIONS(840),
    [sym_void_type] = ACTIONS(840),
    [sym_this] = ACTIONS(840),
    [sym_super] = ACTIONS(840),
    [sym_comment] = ACTIONS(3),
  },
  [182] = {
    [ts_builtin_sym_end] = ACTIONS(842),
    [sym_identifier] = ACTIONS(844),
    [sym_decimal_integer_literal] = ACTIONS(844),
    [sym_hex_integer_literal] = ACTIONS(844),
    [sym_octal_integer_literal] = ACTIONS(842),
    [sym_binary_integer_literal] = ACTIONS(842),
    [sym_decimal_floating_point_literal] = ACTIONS(842),
    [sym_hex_floating_point_literal] = ACTIONS(844),
    [sym_true] = ACTIONS(844),
    [sym_false] = ACTIONS(844),
    [sym_character_literal] = ACTIONS(842),
    [sym_string_literal] = ACTIONS(842),
    [sym_null_literal] = ACTIONS(844),
    [anon_sym_LPAREN] = ACTIONS(842),
    [anon_sym_PLUS] = ACTIONS(844),
    [anon_sym_DASH] = ACTIONS(844),
    [anon_sym_BANG] = ACTIONS(842),
    [anon_sym_TILDE] = ACTIONS(842),
    [anon_sym_PLUS_PLUS] = ACTIONS(842),
    [anon_sym_DASH_DASH] = ACTIONS(842),
    [anon_sym_new] = ACTIONS(844),
    [anon_sym_class] = ACTIONS(844),
    [anon_sym_SEMI] = ACTIONS(842),
    [anon_sym_LBRACE] = ACTIONS(842),
    [anon_sym_RBRACE] = ACTIONS(842),
    [anon_sym_assert] = ACTIONS(844),
    [anon_sym_switch] = ACTIONS(844),
    [anon_sym_case] = ACTIONS(844),
    [anon_sym_default] = ACTIONS(844),
    [anon_sym_do] = ACTIONS(844),
    [anon_sym_while] = ACTIONS(844),
    [anon_sym_break] = ACTIONS(844),
    [anon_sym_continue] = ACTIONS(844),
    [anon_sym_return] = ACTIONS(844),
    [anon_sym_synchronized] = ACTIONS(844),
    [anon_sym_throw] = ACTIONS(844),
    [anon_sym_try] = ACTIONS(844),
    [anon_sym_if] = ACTIONS(844),
    [anon_sym_else] = ACTIONS(844),
    [anon_sym_for] = ACTIONS(844),
    [anon_sym_AT] = ACTIONS(844),
    [anon_sym_open] = ACTIONS(844),
    [anon_sym_module] = ACTIONS(844),
    [anon_sym_static] = ACTIONS(844),
    [anon_sym_package] = ACTIONS(844),
    [anon_sym_import] = ACTIONS(844),
    [anon_sym_enum] = ACTIONS(844),
    [anon_sym_public] = ACTIONS(844),
    [anon_sym_protected] = ACTIONS(844),
    [anon_sym_private] = ACTIONS(844),
    [anon_sym_abstract] = ACTIONS(844),
    [anon_sym_final] = ACTIONS(844),
    [anon_sym_strictfp] = ACTIONS(844),
    [anon_sym_native] = ACTIONS(844),
    [anon_sym_transient] = ACTIONS(844),
    [anon_sym_volatile] = ACTIONS(844),
    [anon_sym_ATinterface] = ACTIONS(842),
    [anon_sym_interface] = ACTIONS(844),
    [anon_sym_byte] = ACTIONS(844),
    [anon_sym_short] = ACTIONS(844),
    [anon_sym_int] = ACTIONS(844),
    [anon_sym_long] = ACTIONS(844),
    [anon_sym_char] = ACTIONS(844),
    [anon_sym_float] = ACTIONS(844),
    [anon_sym_double] = ACTIONS(844),
    [sym_boolean_type] = ACTIONS(844),
    [sym_void_type] = ACTIONS(844),
    [sym_this] = ACTIONS(844),
    [sym_super] = ACTIONS(844),
    [sym_comment] = ACTIONS(3),
  },
  [183] = {
    [ts_builtin_sym_end] = ACTIONS(435),
    [sym_identifier] = ACTIONS(437),
    [sym_decimal_integer_literal] = ACTIONS(437),
    [sym_hex_integer_literal] = ACTIONS(437),
    [sym_octal_integer_literal] = ACTIONS(435),
    [sym_binary_integer_literal] = ACTIONS(435),
    [sym_decimal_floating_point_literal] = ACTIONS(435),
    [sym_hex_floating_point_literal] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_character_literal] = ACTIONS(435),
    [sym_string_literal] = ACTIONS(435),
    [sym_null_literal] = ACTIONS(437),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_PLUS] = ACTIONS(437),
    [anon_sym_DASH] = ACTIONS(437),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(435),
    [anon_sym_DASH_DASH] = ACTIONS(435),
    [anon_sym_new] = ACTIONS(437),
    [anon_sym_class] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_assert] = ACTIONS(437),
    [anon_sym_switch] = ACTIONS(437),
    [anon_sym_case] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(437),
    [anon_sym_do] = ACTIONS(437),
    [anon_sym_while] = ACTIONS(437),
    [anon_sym_break] = ACTIONS(437),
    [anon_sym_continue] = ACTIONS(437),
    [anon_sym_return] = ACTIONS(437),
    [anon_sym_synchronized] = ACTIONS(437),
    [anon_sym_throw] = ACTIONS(437),
    [anon_sym_try] = ACTIONS(437),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_else] = ACTIONS(437),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_open] = ACTIONS(437),
    [anon_sym_module] = ACTIONS(437),
    [anon_sym_static] = ACTIONS(437),
    [anon_sym_package] = ACTIONS(437),
    [anon_sym_import] = ACTIONS(437),
    [anon_sym_enum] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(437),
    [anon_sym_protected] = ACTIONS(437),
    [anon_sym_private] = ACTIONS(437),
    [anon_sym_abstract] = ACTIONS(437),
    [anon_sym_final] = ACTIONS(437),
    [anon_sym_strictfp] = ACTIONS(437),
    [anon_sym_native] = ACTIONS(437),
    [anon_sym_transient] = ACTIONS(437),
    [anon_sym_volatile] = ACTIONS(437),
    [anon_sym_ATinterface] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(437),
    [anon_sym_byte] = ACTIONS(437),
    [anon_sym_short] = ACTIONS(437),
    [anon_sym_int] = ACTIONS(437),
    [anon_sym_long] = ACTIONS(437),
    [anon_sym_char] = ACTIONS(437),
    [anon_sym_float] = ACTIONS(437),
    [anon_sym_double] = ACTIONS(437),
    [sym_boolean_type] = ACTIONS(437),
    [sym_void_type] = ACTIONS(437),
    [sym_this] = ACTIONS(437),
    [sym_super] = ACTIONS(437),
    [sym_comment] = ACTIONS(3),
  },
  [184] = {
    [sym__literal] = STATE(326),
    [sym__expression] = STATE(433),
    [sym_cast_expression] = STATE(433),
    [sym_assignment_expression] = STATE(433),
    [sym_binary_expression] = STATE(433),
    [sym_instanceof_expression] = STATE(433),
    [sym_lambda_expression] = STATE(433),
    [sym_inferred_parameters] = STATE(945),
    [sym_ternary_expression] = STATE(433),
    [sym_unary_expression] = STATE(433),
    [sym_update_expression] = STATE(433),
    [sym__primary] = STATE(326),
    [sym_array_creation_expression] = STATE(326),
    [sym_parenthesized_expression] = STATE(326),
    [sym_class_literal] = STATE(326),
    [sym_object_creation_expression] = STATE(326),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(228),
    [sym_array_access] = STATE(228),
    [sym_method_invocation] = STATE(326),
    [sym_method_reference] = STATE(326),
    [sym__annotation] = STATE(451),
    [sym_marker_annotation] = STATE(451),
    [sym_annotation] = STATE(451),
    [sym_scoped_identifier] = STATE(224),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(483),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(483),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [sym_formal_parameters] = STATE(945),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [sym_identifier] = ACTIONS(423),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [185] = {
    [ts_builtin_sym_end] = ACTIONS(846),
    [sym_identifier] = ACTIONS(848),
    [sym_decimal_integer_literal] = ACTIONS(848),
    [sym_hex_integer_literal] = ACTIONS(848),
    [sym_octal_integer_literal] = ACTIONS(846),
    [sym_binary_integer_literal] = ACTIONS(846),
    [sym_decimal_floating_point_literal] = ACTIONS(846),
    [sym_hex_floating_point_literal] = ACTIONS(848),
    [sym_true] = ACTIONS(848),
    [sym_false] = ACTIONS(848),
    [sym_character_literal] = ACTIONS(846),
    [sym_string_literal] = ACTIONS(846),
    [sym_null_literal] = ACTIONS(848),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(848),
    [anon_sym_DASH] = ACTIONS(848),
    [anon_sym_BANG] = ACTIONS(846),
    [anon_sym_TILDE] = ACTIONS(846),
    [anon_sym_PLUS_PLUS] = ACTIONS(846),
    [anon_sym_DASH_DASH] = ACTIONS(846),
    [anon_sym_new] = ACTIONS(848),
    [anon_sym_class] = ACTIONS(848),
    [anon_sym_SEMI] = ACTIONS(846),
    [anon_sym_LBRACE] = ACTIONS(846),
    [anon_sym_RBRACE] = ACTIONS(846),
    [anon_sym_assert] = ACTIONS(848),
    [anon_sym_switch] = ACTIONS(848),
    [anon_sym_case] = ACTIONS(848),
    [anon_sym_default] = ACTIONS(848),
    [anon_sym_do] = ACTIONS(848),
    [anon_sym_while] = ACTIONS(848),
    [anon_sym_break] = ACTIONS(848),
    [anon_sym_continue] = ACTIONS(848),
    [anon_sym_return] = ACTIONS(848),
    [anon_sym_synchronized] = ACTIONS(848),
    [anon_sym_throw] = ACTIONS(848),
    [anon_sym_try] = ACTIONS(848),
    [anon_sym_if] = ACTIONS(848),
    [anon_sym_else] = ACTIONS(848),
    [anon_sym_for] = ACTIONS(848),
    [anon_sym_AT] = ACTIONS(848),
    [anon_sym_open] = ACTIONS(848),
    [anon_sym_module] = ACTIONS(848),
    [anon_sym_static] = ACTIONS(848),
    [anon_sym_package] = ACTIONS(848),
    [anon_sym_import] = ACTIONS(848),
    [anon_sym_enum] = ACTIONS(848),
    [anon_sym_public] = ACTIONS(848),
    [anon_sym_protected] = ACTIONS(848),
    [anon_sym_private] = ACTIONS(848),
    [anon_sym_abstract] = ACTIONS(848),
    [anon_sym_final] = ACTIONS(848),
    [anon_sym_strictfp] = ACTIONS(848),
    [anon_sym_native] = ACTIONS(848),
    [anon_sym_transient] = ACTIONS(848),
    [anon_sym_volatile] = ACTIONS(848),
    [anon_sym_ATinterface] = ACTIONS(846),
    [anon_sym_interface] = ACTIONS(848),
    [anon_sym_byte] = ACTIONS(848),
    [anon_sym_short] = ACTIONS(848),
    [anon_sym_int] = ACTIONS(848),
    [anon_sym_long] = ACTIONS(848),
    [anon_sym_char] = ACTIONS(848),
    [anon_sym_float] = ACTIONS(848),
    [anon_sym_double] = ACTIONS(848),
    [sym_boolean_type] = ACTIONS(848),
    [sym_void_type] = ACTIONS(848),
    [sym_this] = ACTIONS(848),
    [sym_super] = ACTIONS(848),
    [sym_comment] = ACTIONS(3),
  },
  [186] = {
    [ts_builtin_sym_end] = ACTIONS(850),
    [sym_identifier] = ACTIONS(852),
    [sym_decimal_integer_literal] = ACTIONS(852),
    [sym_hex_integer_literal] = ACTIONS(852),
    [sym_octal_integer_literal] = ACTIONS(850),
    [sym_binary_integer_literal] = ACTIONS(850),
    [sym_decimal_floating_point_literal] = ACTIONS(850),
    [sym_hex_floating_point_literal] = ACTIONS(852),
    [sym_true] = ACTIONS(852),
    [sym_false] = ACTIONS(852),
    [sym_character_literal] = ACTIONS(850),
    [sym_string_literal] = ACTIONS(850),
    [sym_null_literal] = ACTIONS(852),
    [anon_sym_LPAREN] = ACTIONS(850),
    [anon_sym_PLUS] = ACTIONS(852),
    [anon_sym_DASH] = ACTIONS(852),
    [anon_sym_BANG] = ACTIONS(850),
    [anon_sym_TILDE] = ACTIONS(850),
    [anon_sym_PLUS_PLUS] = ACTIONS(850),
    [anon_sym_DASH_DASH] = ACTIONS(850),
    [anon_sym_new] = ACTIONS(852),
    [anon_sym_class] = ACTIONS(852),
    [anon_sym_SEMI] = ACTIONS(850),
    [anon_sym_LBRACE] = ACTIONS(850),
    [anon_sym_RBRACE] = ACTIONS(850),
    [anon_sym_assert] = ACTIONS(852),
    [anon_sym_switch] = ACTIONS(852),
    [anon_sym_case] = ACTIONS(852),
    [anon_sym_default] = ACTIONS(852),
    [anon_sym_do] = ACTIONS(852),
    [anon_sym_while] = ACTIONS(852),
    [anon_sym_break] = ACTIONS(852),
    [anon_sym_continue] = ACTIONS(852),
    [anon_sym_return] = ACTIONS(852),
    [anon_sym_synchronized] = ACTIONS(852),
    [anon_sym_throw] = ACTIONS(852),
    [anon_sym_try] = ACTIONS(852),
    [anon_sym_if] = ACTIONS(852),
    [anon_sym_else] = ACTIONS(852),
    [anon_sym_for] = ACTIONS(852),
    [anon_sym_AT] = ACTIONS(852),
    [anon_sym_open] = ACTIONS(852),
    [anon_sym_module] = ACTIONS(852),
    [anon_sym_static] = ACTIONS(852),
    [anon_sym_package] = ACTIONS(852),
    [anon_sym_import] = ACTIONS(852),
    [anon_sym_enum] = ACTIONS(852),
    [anon_sym_public] = ACTIONS(852),
    [anon_sym_protected] = ACTIONS(852),
    [anon_sym_private] = ACTIONS(852),
    [anon_sym_abstract] = ACTIONS(852),
    [anon_sym_final] = ACTIONS(852),
    [anon_sym_strictfp] = ACTIONS(852),
    [anon_sym_native] = ACTIONS(852),
    [anon_sym_transient] = ACTIONS(852),
    [anon_sym_volatile] = ACTIONS(852),
    [anon_sym_ATinterface] = ACTIONS(850),
    [anon_sym_interface] = ACTIONS(852),
    [anon_sym_byte] = ACTIONS(852),
    [anon_sym_short] = ACTIONS(852),
    [anon_sym_int] = ACTIONS(852),
    [anon_sym_long] = ACTIONS(852),
    [anon_sym_char] = ACTIONS(852),
    [anon_sym_float] = ACTIONS(852),
    [anon_sym_double] = ACTIONS(852),
    [sym_boolean_type] = ACTIONS(852),
    [sym_void_type] = ACTIONS(852),
    [sym_this] = ACTIONS(852),
    [sym_super] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
  },
  [187] = {
    [ts_builtin_sym_end] = ACTIONS(854),
    [sym_identifier] = ACTIONS(856),
    [sym_decimal_integer_literal] = ACTIONS(856),
    [sym_hex_integer_literal] = ACTIONS(856),
    [sym_octal_integer_literal] = ACTIONS(854),
    [sym_binary_integer_literal] = ACTIONS(854),
    [sym_decimal_floating_point_literal] = ACTIONS(854),
    [sym_hex_floating_point_literal] = ACTIONS(856),
    [sym_true] = ACTIONS(856),
    [sym_false] = ACTIONS(856),
    [sym_character_literal] = ACTIONS(854),
    [sym_string_literal] = ACTIONS(854),
    [sym_null_literal] = ACTIONS(856),
    [anon_sym_LPAREN] = ACTIONS(854),
    [anon_sym_PLUS] = ACTIONS(856),
    [anon_sym_DASH] = ACTIONS(856),
    [anon_sym_BANG] = ACTIONS(854),
    [anon_sym_TILDE] = ACTIONS(854),
    [anon_sym_PLUS_PLUS] = ACTIONS(854),
    [anon_sym_DASH_DASH] = ACTIONS(854),
    [anon_sym_new] = ACTIONS(856),
    [anon_sym_class] = ACTIONS(856),
    [anon_sym_SEMI] = ACTIONS(854),
    [anon_sym_LBRACE] = ACTIONS(854),
    [anon_sym_RBRACE] = ACTIONS(854),
    [anon_sym_assert] = ACTIONS(856),
    [anon_sym_switch] = ACTIONS(856),
    [anon_sym_case] = ACTIONS(856),
    [anon_sym_default] = ACTIONS(856),
    [anon_sym_do] = ACTIONS(856),
    [anon_sym_while] = ACTIONS(856),
    [anon_sym_break] = ACTIONS(856),
    [anon_sym_continue] = ACTIONS(856),
    [anon_sym_return] = ACTIONS(856),
    [anon_sym_synchronized] = ACTIONS(856),
    [anon_sym_throw] = ACTIONS(856),
    [anon_sym_try] = ACTIONS(856),
    [anon_sym_if] = ACTIONS(856),
    [anon_sym_else] = ACTIONS(856),
    [anon_sym_for] = ACTIONS(856),
    [anon_sym_AT] = ACTIONS(856),
    [anon_sym_open] = ACTIONS(856),
    [anon_sym_module] = ACTIONS(856),
    [anon_sym_static] = ACTIONS(856),
    [anon_sym_package] = ACTIONS(856),
    [anon_sym_import] = ACTIONS(856),
    [anon_sym_enum] = ACTIONS(856),
    [anon_sym_public] = ACTIONS(856),
    [anon_sym_protected] = ACTIONS(856),
    [anon_sym_private] = ACTIONS(856),
    [anon_sym_abstract] = ACTIONS(856),
    [anon_sym_final] = ACTIONS(856),
    [anon_sym_strictfp] = ACTIONS(856),
    [anon_sym_native] = ACTIONS(856),
    [anon_sym_transient] = ACTIONS(856),
    [anon_sym_volatile] = ACTIONS(856),
    [anon_sym_ATinterface] = ACTIONS(854),
    [anon_sym_interface] = ACTIONS(856),
    [anon_sym_byte] = ACTIONS(856),
    [anon_sym_short] = ACTIONS(856),
    [anon_sym_int] = ACTIONS(856),
    [anon_sym_long] = ACTIONS(856),
    [anon_sym_char] = ACTIONS(856),
    [anon_sym_float] = ACTIONS(856),
    [anon_sym_double] = ACTIONS(856),
    [sym_boolean_type] = ACTIONS(856),
    [sym_void_type] = ACTIONS(856),
    [sym_this] = ACTIONS(856),
    [sym_super] = ACTIONS(856),
    [sym_comment] = ACTIONS(3),
  },
  [188] = {
    [sym__literal] = STATE(728),
    [sym__primary] = STATE(728),
    [sym_array_creation_expression] = STATE(728),
    [sym_parenthesized_expression] = STATE(728),
    [sym_class_literal] = STATE(728),
    [sym_object_creation_expression] = STATE(728),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(632),
    [sym_array_access] = STATE(728),
    [sym_method_invocation] = STATE(728),
    [sym_method_reference] = STATE(728),
    [sym_resource] = STATE(849),
    [sym__annotation] = STATE(438),
    [sym_marker_annotation] = STATE(438),
    [sym_annotation] = STATE(438),
    [sym_modifiers] = STATE(481),
    [sym_scoped_identifier] = STATE(581),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(520),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(520),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(390),
    [sym_identifier] = ACTIONS(858),
    [sym_decimal_integer_literal] = ACTIONS(860),
    [sym_hex_integer_literal] = ACTIONS(860),
    [sym_octal_integer_literal] = ACTIONS(862),
    [sym_binary_integer_literal] = ACTIONS(862),
    [sym_decimal_floating_point_literal] = ACTIONS(862),
    [sym_hex_floating_point_literal] = ACTIONS(860),
    [sym_true] = ACTIONS(860),
    [sym_false] = ACTIONS(860),
    [sym_character_literal] = ACTIONS(862),
    [sym_string_literal] = ACTIONS(862),
    [sym_null_literal] = ACTIONS(860),
    [anon_sym_LPAREN] = ACTIONS(864),
    [anon_sym_RPAREN] = ACTIONS(866),
    [anon_sym_new] = ACTIONS(868),
    [anon_sym_default] = ACTIONS(417),
    [anon_sym_synchronized] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(870),
    [anon_sym_module] = ACTIONS(870),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_public] = ACTIONS(417),
    [anon_sym_protected] = ACTIONS(417),
    [anon_sym_private] = ACTIONS(417),
    [anon_sym_abstract] = ACTIONS(417),
    [anon_sym_final] = ACTIONS(417),
    [anon_sym_strictfp] = ACTIONS(417),
    [anon_sym_native] = ACTIONS(417),
    [anon_sym_transient] = ACTIONS(417),
    [anon_sym_volatile] = ACTIONS(417),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(860),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [189] = {
    [sym__literal] = STATE(728),
    [sym__primary] = STATE(728),
    [sym_array_creation_expression] = STATE(728),
    [sym_parenthesized_expression] = STATE(728),
    [sym_class_literal] = STATE(728),
    [sym_object_creation_expression] = STATE(728),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(632),
    [sym_array_access] = STATE(728),
    [sym_method_invocation] = STATE(728),
    [sym_method_reference] = STATE(728),
    [sym_resource] = STATE(849),
    [sym__annotation] = STATE(438),
    [sym_marker_annotation] = STATE(438),
    [sym_annotation] = STATE(438),
    [sym_modifiers] = STATE(481),
    [sym_scoped_identifier] = STATE(581),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(520),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(520),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(390),
    [sym_identifier] = ACTIONS(858),
    [sym_decimal_integer_literal] = ACTIONS(860),
    [sym_hex_integer_literal] = ACTIONS(860),
    [sym_octal_integer_literal] = ACTIONS(862),
    [sym_binary_integer_literal] = ACTIONS(862),
    [sym_decimal_floating_point_literal] = ACTIONS(862),
    [sym_hex_floating_point_literal] = ACTIONS(860),
    [sym_true] = ACTIONS(860),
    [sym_false] = ACTIONS(860),
    [sym_character_literal] = ACTIONS(862),
    [sym_string_literal] = ACTIONS(862),
    [sym_null_literal] = ACTIONS(860),
    [anon_sym_LPAREN] = ACTIONS(864),
    [anon_sym_RPAREN] = ACTIONS(872),
    [anon_sym_new] = ACTIONS(868),
    [anon_sym_default] = ACTIONS(417),
    [anon_sym_synchronized] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(870),
    [anon_sym_module] = ACTIONS(870),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_public] = ACTIONS(417),
    [anon_sym_protected] = ACTIONS(417),
    [anon_sym_private] = ACTIONS(417),
    [anon_sym_abstract] = ACTIONS(417),
    [anon_sym_final] = ACTIONS(417),
    [anon_sym_strictfp] = ACTIONS(417),
    [anon_sym_native] = ACTIONS(417),
    [anon_sym_transient] = ACTIONS(417),
    [anon_sym_volatile] = ACTIONS(417),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(860),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [190] = {
    [sym__literal] = STATE(728),
    [sym__primary] = STATE(728),
    [sym_array_creation_expression] = STATE(728),
    [sym_parenthesized_expression] = STATE(728),
    [sym_class_literal] = STATE(728),
    [sym_object_creation_expression] = STATE(728),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(632),
    [sym_array_access] = STATE(728),
    [sym_method_invocation] = STATE(728),
    [sym_method_reference] = STATE(728),
    [sym_resource] = STATE(726),
    [sym__annotation] = STATE(438),
    [sym_marker_annotation] = STATE(438),
    [sym_annotation] = STATE(438),
    [sym_modifiers] = STATE(481),
    [sym_scoped_identifier] = STATE(581),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(520),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(520),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(390),
    [sym_identifier] = ACTIONS(858),
    [sym_decimal_integer_literal] = ACTIONS(860),
    [sym_hex_integer_literal] = ACTIONS(860),
    [sym_octal_integer_literal] = ACTIONS(862),
    [sym_binary_integer_literal] = ACTIONS(862),
    [sym_decimal_floating_point_literal] = ACTIONS(862),
    [sym_hex_floating_point_literal] = ACTIONS(860),
    [sym_true] = ACTIONS(860),
    [sym_false] = ACTIONS(860),
    [sym_character_literal] = ACTIONS(862),
    [sym_string_literal] = ACTIONS(862),
    [sym_null_literal] = ACTIONS(860),
    [anon_sym_LPAREN] = ACTIONS(864),
    [anon_sym_new] = ACTIONS(868),
    [anon_sym_default] = ACTIONS(417),
    [anon_sym_synchronized] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(870),
    [anon_sym_module] = ACTIONS(870),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_public] = ACTIONS(417),
    [anon_sym_protected] = ACTIONS(417),
    [anon_sym_private] = ACTIONS(417),
    [anon_sym_abstract] = ACTIONS(417),
    [anon_sym_final] = ACTIONS(417),
    [anon_sym_strictfp] = ACTIONS(417),
    [anon_sym_native] = ACTIONS(417),
    [anon_sym_transient] = ACTIONS(417),
    [anon_sym_volatile] = ACTIONS(417),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(860),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [191] = {
    [sym_identifier] = ACTIONS(874),
    [sym_decimal_integer_literal] = ACTIONS(874),
    [sym_hex_integer_literal] = ACTIONS(874),
    [sym_octal_integer_literal] = ACTIONS(876),
    [sym_binary_integer_literal] = ACTIONS(876),
    [sym_decimal_floating_point_literal] = ACTIONS(876),
    [sym_hex_floating_point_literal] = ACTIONS(874),
    [sym_true] = ACTIONS(874),
    [sym_false] = ACTIONS(874),
    [sym_character_literal] = ACTIONS(876),
    [sym_string_literal] = ACTIONS(876),
    [sym_null_literal] = ACTIONS(874),
    [anon_sym_LPAREN] = ACTIONS(876),
    [anon_sym_PLUS] = ACTIONS(874),
    [anon_sym_DASH] = ACTIONS(874),
    [anon_sym_BANG] = ACTIONS(876),
    [anon_sym_TILDE] = ACTIONS(876),
    [anon_sym_PLUS_PLUS] = ACTIONS(876),
    [anon_sym_DASH_DASH] = ACTIONS(876),
    [anon_sym_new] = ACTIONS(874),
    [anon_sym_class] = ACTIONS(874),
    [anon_sym_SEMI] = ACTIONS(876),
    [anon_sym_LBRACE] = ACTIONS(876),
    [anon_sym_RBRACE] = ACTIONS(876),
    [anon_sym_assert] = ACTIONS(874),
    [anon_sym_switch] = ACTIONS(874),
    [anon_sym_case] = ACTIONS(874),
    [anon_sym_default] = ACTIONS(874),
    [anon_sym_do] = ACTIONS(874),
    [anon_sym_while] = ACTIONS(874),
    [anon_sym_break] = ACTIONS(874),
    [anon_sym_continue] = ACTIONS(874),
    [anon_sym_return] = ACTIONS(874),
    [anon_sym_synchronized] = ACTIONS(874),
    [anon_sym_throw] = ACTIONS(874),
    [anon_sym_try] = ACTIONS(874),
    [anon_sym_if] = ACTIONS(874),
    [anon_sym_for] = ACTIONS(874),
    [anon_sym_AT] = ACTIONS(874),
    [anon_sym_open] = ACTIONS(874),
    [anon_sym_module] = ACTIONS(874),
    [anon_sym_static] = ACTIONS(874),
    [anon_sym_package] = ACTIONS(874),
    [anon_sym_import] = ACTIONS(874),
    [anon_sym_enum] = ACTIONS(874),
    [anon_sym_public] = ACTIONS(874),
    [anon_sym_protected] = ACTIONS(874),
    [anon_sym_private] = ACTIONS(874),
    [anon_sym_abstract] = ACTIONS(874),
    [anon_sym_final] = ACTIONS(874),
    [anon_sym_strictfp] = ACTIONS(874),
    [anon_sym_native] = ACTIONS(874),
    [anon_sym_transient] = ACTIONS(874),
    [anon_sym_volatile] = ACTIONS(874),
    [anon_sym_ATinterface] = ACTIONS(876),
    [anon_sym_interface] = ACTIONS(874),
    [anon_sym_byte] = ACTIONS(874),
    [anon_sym_short] = ACTIONS(874),
    [anon_sym_int] = ACTIONS(874),
    [anon_sym_long] = ACTIONS(874),
    [anon_sym_char] = ACTIONS(874),
    [anon_sym_float] = ACTIONS(874),
    [anon_sym_double] = ACTIONS(874),
    [sym_boolean_type] = ACTIONS(874),
    [sym_void_type] = ACTIONS(874),
    [sym_this] = ACTIONS(874),
    [sym_super] = ACTIONS(874),
    [sym_comment] = ACTIONS(3),
  },
  [192] = {
    [sym_identifier] = ACTIONS(878),
    [sym_decimal_integer_literal] = ACTIONS(878),
    [sym_hex_integer_literal] = ACTIONS(878),
    [sym_octal_integer_literal] = ACTIONS(880),
    [sym_binary_integer_literal] = ACTIONS(880),
    [sym_decimal_floating_point_literal] = ACTIONS(880),
    [sym_hex_floating_point_literal] = ACTIONS(878),
    [sym_true] = ACTIONS(878),
    [sym_false] = ACTIONS(878),
    [sym_character_literal] = ACTIONS(880),
    [sym_string_literal] = ACTIONS(880),
    [sym_null_literal] = ACTIONS(878),
    [anon_sym_LPAREN] = ACTIONS(880),
    [anon_sym_PLUS] = ACTIONS(878),
    [anon_sym_DASH] = ACTIONS(878),
    [anon_sym_BANG] = ACTIONS(880),
    [anon_sym_TILDE] = ACTIONS(880),
    [anon_sym_PLUS_PLUS] = ACTIONS(880),
    [anon_sym_DASH_DASH] = ACTIONS(880),
    [anon_sym_new] = ACTIONS(878),
    [anon_sym_class] = ACTIONS(878),
    [anon_sym_SEMI] = ACTIONS(880),
    [anon_sym_LBRACE] = ACTIONS(880),
    [anon_sym_RBRACE] = ACTIONS(880),
    [anon_sym_assert] = ACTIONS(878),
    [anon_sym_switch] = ACTIONS(878),
    [anon_sym_case] = ACTIONS(878),
    [anon_sym_default] = ACTIONS(878),
    [anon_sym_do] = ACTIONS(878),
    [anon_sym_while] = ACTIONS(878),
    [anon_sym_break] = ACTIONS(878),
    [anon_sym_continue] = ACTIONS(878),
    [anon_sym_return] = ACTIONS(878),
    [anon_sym_synchronized] = ACTIONS(878),
    [anon_sym_throw] = ACTIONS(878),
    [anon_sym_try] = ACTIONS(878),
    [anon_sym_if] = ACTIONS(878),
    [anon_sym_for] = ACTIONS(878),
    [anon_sym_AT] = ACTIONS(878),
    [anon_sym_open] = ACTIONS(878),
    [anon_sym_module] = ACTIONS(878),
    [anon_sym_static] = ACTIONS(878),
    [anon_sym_package] = ACTIONS(878),
    [anon_sym_import] = ACTIONS(878),
    [anon_sym_enum] = ACTIONS(878),
    [anon_sym_public] = ACTIONS(878),
    [anon_sym_protected] = ACTIONS(878),
    [anon_sym_private] = ACTIONS(878),
    [anon_sym_abstract] = ACTIONS(878),
    [anon_sym_final] = ACTIONS(878),
    [anon_sym_strictfp] = ACTIONS(878),
    [anon_sym_native] = ACTIONS(878),
    [anon_sym_transient] = ACTIONS(878),
    [anon_sym_volatile] = ACTIONS(878),
    [anon_sym_ATinterface] = ACTIONS(880),
    [anon_sym_interface] = ACTIONS(878),
    [anon_sym_byte] = ACTIONS(878),
    [anon_sym_short] = ACTIONS(878),
    [anon_sym_int] = ACTIONS(878),
    [anon_sym_long] = ACTIONS(878),
    [anon_sym_char] = ACTIONS(878),
    [anon_sym_float] = ACTIONS(878),
    [anon_sym_double] = ACTIONS(878),
    [sym_boolean_type] = ACTIONS(878),
    [sym_void_type] = ACTIONS(878),
    [sym_this] = ACTIONS(878),
    [sym_super] = ACTIONS(878),
    [sym_comment] = ACTIONS(3),
  },
  [193] = {
    [sym__literal] = STATE(728),
    [sym__primary] = STATE(728),
    [sym_array_creation_expression] = STATE(728),
    [sym_parenthesized_expression] = STATE(728),
    [sym_class_literal] = STATE(728),
    [sym_object_creation_expression] = STATE(728),
    [sym__unqualified_object_creation_expression] = STATE(330),
    [sym_field_access] = STATE(632),
    [sym_array_access] = STATE(728),
    [sym_method_invocation] = STATE(728),
    [sym_method_reference] = STATE(728),
    [sym_resource] = STATE(849),
    [sym__annotation] = STATE(438),
    [sym_marker_annotation] = STATE(438),
    [sym_annotation] = STATE(438),
    [sym_modifiers] = STATE(481),
    [sym_scoped_identifier] = STATE(581),
    [sym__type] = STATE(943),
    [sym__unannotated_type] = STATE(520),
    [sym_annotated_type] = STATE(943),
    [sym_scoped_type_identifier] = STATE(463),
    [sym_generic_type] = STATE(473),
    [sym_array_type] = STATE(520),
    [sym_integral_type] = STATE(527),
    [sym_floating_point_type] = STATE(527),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(390),
    [sym_identifier] = ACTIONS(858),
    [sym_decimal_integer_literal] = ACTIONS(860),
    [sym_hex_integer_literal] = ACTIONS(860),
    [sym_octal_integer_literal] = ACTIONS(862),
    [sym_binary_integer_literal] = ACTIONS(862),
    [sym_decimal_floating_point_literal] = ACTIONS(862),
    [sym_hex_floating_point_literal] = ACTIONS(860),
    [sym_true] = ACTIONS(860),
    [sym_false] = ACTIONS(860),
    [sym_character_literal] = ACTIONS(862),
    [sym_string_literal] = ACTIONS(862),
    [sym_null_literal] = ACTIONS(860),
    [anon_sym_LPAREN] = ACTIONS(864),
    [anon_sym_new] = ACTIONS(868),
    [anon_sym_default] = ACTIONS(417),
    [anon_sym_synchronized] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_open] = ACTIONS(870),
    [anon_sym_module] = ACTIONS(870),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_public] = ACTIONS(417),
    [anon_sym_protected] = ACTIONS(417),
    [anon_sym_private] = ACTIONS(417),
    [anon_sym_abstract] = ACTIONS(417),
    [anon_sym_final] = ACTIONS(417),
    [anon_sym_strictfp] = ACTIONS(417),
    [anon_sym_native] = ACTIONS(417),
    [anon_sym_transient] = ACTIONS(417),
    [anon_sym_volatile] = ACTIONS(417),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(860),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [194] = {
    [sym_identifier] = ACTIONS(882),
    [sym_decimal_integer_literal] = ACTIONS(882),
    [sym_hex_integer_literal] = ACTIONS(882),
    [sym_octal_integer_literal] = ACTIONS(884),
    [sym_binary_integer_literal] = ACTIONS(884),
    [sym_decimal_floating_point_literal] = ACTIONS(884),
    [sym_hex_floating_point_literal] = ACTIONS(882),
    [sym_true] = ACTIONS(882),
    [sym_false] = ACTIONS(882),
    [sym_character_literal] = ACTIONS(884),
    [sym_string_literal] = ACTIONS(884),
    [sym_null_literal] = ACTIONS(882),
    [anon_sym_LPAREN] = ACTIONS(884),
    [anon_sym_PLUS] = ACTIONS(882),
    [anon_sym_DASH] = ACTIONS(882),
    [anon_sym_BANG] = ACTIONS(884),
    [anon_sym_TILDE] = ACTIONS(884),
    [anon_sym_PLUS_PLUS] = ACTIONS(884),
    [anon_sym_DASH_DASH] = ACTIONS(884),
    [anon_sym_new] = ACTIONS(882),
    [anon_sym_class] = ACTIONS(882),
    [anon_sym_SEMI] = ACTIONS(884),
    [anon_sym_LBRACE] = ACTIONS(884),
    [anon_sym_RBRACE] = ACTIONS(884),
    [anon_sym_assert] = ACTIONS(882),
    [anon_sym_switch] = ACTIONS(882),
    [anon_sym_default] = ACTIONS(882),
    [anon_sym_do] = ACTIONS(882),
    [anon_sym_while] = ACTIONS(882),
    [anon_sym_break] = ACTIONS(882),
    [anon_sym_continue] = ACTIONS(882),
    [anon_sym_return] = ACTIONS(882),
    [anon_sym_synchronized] = ACTIONS(882),
    [anon_sym_throw] = ACTIONS(882),
    [anon_sym_try] = ACTIONS(882),
    [anon_sym_if] = ACTIONS(882),
    [anon_sym_for] = ACTIONS(882),
    [anon_sym_AT] = ACTIONS(882),
    [anon_sym_open] = ACTIONS(882),
    [anon_sym_module] = ACTIONS(882),
    [anon_sym_static] = ACTIONS(882),
    [anon_sym_package] = ACTIONS(882),
    [anon_sym_import] = ACTIONS(882),
    [anon_sym_enum] = ACTIONS(882),
    [anon_sym_public] = ACTIONS(882),
    [anon_sym_protected] = ACTIONS(882),
    [anon_sym_private] = ACTIONS(882),
    [anon_sym_abstract] = ACTIONS(882),
    [anon_sym_final] = ACTIONS(882),
    [anon_sym_strictfp] = ACTIONS(882),
    [anon_sym_native] = ACTIONS(882),
    [anon_sym_transient] = ACTIONS(882),
    [anon_sym_volatile] = ACTIONS(882),
    [anon_sym_ATinterface] = ACTIONS(884),
    [anon_sym_interface] = ACTIONS(882),
    [anon_sym_byte] = ACTIONS(882),
    [anon_sym_short] = ACTIONS(882),
    [anon_sym_int] = ACTIONS(882),
    [anon_sym_long] = ACTIONS(882),
    [anon_sym_char] = ACTIONS(882),
    [anon_sym_float] = ACTIONS(882),
    [anon_sym_double] = ACTIONS(882),
    [sym_boolean_type] = ACTIONS(882),
    [sym_void_type] = ACTIONS(882),
    [sym_this] = ACTIONS(882),
    [sym_super] = ACTIONS(882),
    [sym_comment] = ACTIONS(3),
  },
  [195] = {
    [sym_identifier] = ACTIONS(886),
    [sym_decimal_integer_literal] = ACTIONS(886),
    [sym_hex_integer_literal] = ACTIONS(886),
    [sym_octal_integer_literal] = ACTIONS(888),
    [sym_binary_integer_literal] = ACTIONS(888),
    [sym_decimal_floating_point_literal] = ACTIONS(888),
    [sym_hex_floating_point_literal] = ACTIONS(886),
    [sym_true] = ACTIONS(886),
    [sym_false] = ACTIONS(886),
    [sym_character_literal] = ACTIONS(888),
    [sym_string_literal] = ACTIONS(888),
    [sym_null_literal] = ACTIONS(886),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_PLUS] = ACTIONS(886),
    [anon_sym_DASH] = ACTIONS(886),
    [anon_sym_BANG] = ACTIONS(888),
    [anon_sym_TILDE] = ACTIONS(888),
    [anon_sym_PLUS_PLUS] = ACTIONS(888),
    [anon_sym_DASH_DASH] = ACTIONS(888),
    [anon_sym_new] = ACTIONS(886),
    [anon_sym_class] = ACTIONS(886),
    [anon_sym_SEMI] = ACTIONS(888),
    [anon_sym_LBRACE] = ACTIONS(888),
    [anon_sym_RBRACE] = ACTIONS(888),
    [anon_sym_assert] = ACTIONS(886),
    [anon_sym_switch] = ACTIONS(886),
    [anon_sym_default] = ACTIONS(886),
    [anon_sym_do] = ACTIONS(886),
    [anon_sym_while] = ACTIONS(886),
    [anon_sym_break] = ACTIONS(886),
    [anon_sym_continue] = ACTIONS(886),
    [anon_sym_return] = ACTIONS(886),
    [anon_sym_synchronized] = ACTIONS(886),
    [anon_sym_throw] = ACTIONS(886),
    [anon_sym_try] = ACTIONS(886),
    [anon_sym_if] = ACTIONS(886),
    [anon_sym_for] = ACTIONS(886),
    [anon_sym_AT] = ACTIONS(886),
    [anon_sym_open] = ACTIONS(886),
    [anon_sym_module] = ACTIONS(886),
    [anon_sym_static] = ACTIONS(886),
    [anon_sym_package] = ACTIONS(886),
    [anon_sym_import] = ACTIONS(886),
    [anon_sym_enum] = ACTIONS(886),
    [anon_sym_public] = ACTIONS(886),
    [anon_sym_protected] = ACTIONS(886),
    [anon_sym_private] = ACTIONS(886),
    [anon_sym_abstract] = ACTIONS(886),
    [anon_sym_final] = ACTIONS(886),
    [anon_sym_strictfp] = ACTIONS(886),
    [anon_sym_native] = ACTIONS(886),
    [anon_sym_transient] = ACTIONS(886),
    [anon_sym_volatile] = ACTIONS(886),
    [anon_sym_ATinterface] = ACTIONS(888),
    [anon_sym_interface] = ACTIONS(886),
    [anon_sym_byte] = ACTIONS(886),
    [anon_sym_short] = ACTIONS(886),
    [anon_sym_int] = ACTIONS(886),
    [anon_sym_long] = ACTIONS(886),
    [anon_sym_char] = ACTIONS(886),
    [anon_sym_float] = ACTIONS(886),
    [anon_sym_double] = ACTIONS(886),
    [sym_boolean_type] = ACTIONS(886),
    [sym_void_type] = ACTIONS(886),
    [sym_this] = ACTIONS(886),
    [sym_super] = ACTIONS(886),
    [sym_comment] = ACTIONS(3),
  },
  [196] = {
    [sym_identifier] = ACTIONS(890),
    [sym_decimal_integer_literal] = ACTIONS(890),
    [sym_hex_integer_literal] = ACTIONS(890),
    [sym_octal_integer_literal] = ACTIONS(892),
    [sym_binary_integer_literal] = ACTIONS(892),
    [sym_decimal_floating_point_literal] = ACTIONS(892),
    [sym_hex_floating_point_literal] = ACTIONS(890),
    [sym_true] = ACTIONS(890),
    [sym_false] = ACTIONS(890),
    [sym_character_literal] = ACTIONS(892),
    [sym_string_literal] = ACTIONS(892),
    [sym_null_literal] = ACTIONS(890),
    [anon_sym_LPAREN] = ACTIONS(892),
    [anon_sym_PLUS] = ACTIONS(890),
    [anon_sym_DASH] = ACTIONS(890),
    [anon_sym_BANG] = ACTIONS(892),
    [anon_sym_TILDE] = ACTIONS(892),
    [anon_sym_PLUS_PLUS] = ACTIONS(892),
    [anon_sym_DASH_DASH] = ACTIONS(892),
    [anon_sym_new] = ACTIONS(890),
    [anon_sym_class] = ACTIONS(890),
    [anon_sym_SEMI] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(892),
    [anon_sym_RBRACE] = ACTIONS(892),
    [anon_sym_assert] = ACTIONS(890),
    [anon_sym_switch] = ACTIONS(890),
    [anon_sym_default] = ACTIONS(890),
    [anon_sym_do] = ACTIONS(890),
    [anon_sym_while] = ACTIONS(890),
    [anon_sym_break] = ACTIONS(890),
    [anon_sym_continue] = ACTIONS(890),
    [anon_sym_return] = ACTIONS(890),
    [anon_sym_synchronized] = ACTIONS(890),
    [anon_sym_throw] = ACTIONS(890),
    [anon_sym_try] = ACTIONS(890),
    [anon_sym_if] = ACTIONS(890),
    [anon_sym_for] = ACTIONS(890),
    [anon_sym_AT] = ACTIONS(890),
    [anon_sym_open] = ACTIONS(890),
    [anon_sym_module] = ACTIONS(890),
    [anon_sym_static] = ACTIONS(890),
    [anon_sym_package] = ACTIONS(890),
    [anon_sym_import] = ACTIONS(890),
    [anon_sym_enum] = ACTIONS(890),
    [anon_sym_public] = ACTIONS(890),
    [anon_sym_protected] = ACTIONS(890),
    [anon_sym_private] = ACTIONS(890),
    [anon_sym_abstract] = ACTIONS(890),
    [anon_sym_final] = ACTIONS(890),
    [anon_sym_strictfp] = ACTIONS(890),
    [anon_sym_native] = ACTIONS(890),
    [anon_sym_transient] = ACTIONS(890),
    [anon_sym_volatile] = ACTIONS(890),
    [anon_sym_ATinterface] = ACTIONS(892),
    [anon_sym_interface] = ACTIONS(890),
    [anon_sym_byte] = ACTIONS(890),
    [anon_sym_short] = ACTIONS(890),
    [anon_sym_int] = ACTIONS(890),
    [anon_sym_long] = ACTIONS(890),
    [anon_sym_char] = ACTIONS(890),
    [anon_sym_float] = ACTIONS(890),
    [anon_sym_double] = ACTIONS(890),
    [sym_boolean_type] = ACTIONS(890),
    [sym_void_type] = ACTIONS(890),
    [sym_this] = ACTIONS(890),
    [sym_super] = ACTIONS(890),
    [sym_comment] = ACTIONS(3),
  },
  [197] = {
    [sym_identifier] = ACTIONS(894),
    [sym_decimal_integer_literal] = ACTIONS(894),
    [sym_hex_integer_literal] = ACTIONS(894),
    [sym_octal_integer_literal] = ACTIONS(896),
    [sym_binary_integer_literal] = ACTIONS(896),
    [sym_decimal_floating_point_literal] = ACTIONS(896),
    [sym_hex_floating_point_literal] = ACTIONS(894),
    [sym_true] = ACTIONS(894),
    [sym_false] = ACTIONS(894),
    [sym_character_literal] = ACTIONS(896),
    [sym_string_literal] = ACTIONS(896),
    [sym_null_literal] = ACTIONS(894),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_PLUS] = ACTIONS(894),
    [anon_sym_DASH] = ACTIONS(894),
    [anon_sym_BANG] = ACTIONS(896),
    [anon_sym_TILDE] = ACTIONS(896),
    [anon_sym_PLUS_PLUS] = ACTIONS(896),
    [anon_sym_DASH_DASH] = ACTIONS(896),
    [anon_sym_new] = ACTIONS(894),
    [anon_sym_class] = ACTIONS(894),
    [anon_sym_SEMI] = ACTIONS(896),
    [anon_sym_LBRACE] = ACTIONS(896),
    [anon_sym_RBRACE] = ACTIONS(896),
    [anon_sym_assert] = ACTIONS(894),
    [anon_sym_switch] = ACTIONS(894),
    [anon_sym_default] = ACTIONS(894),
    [anon_sym_do] = ACTIONS(894),
    [anon_sym_while] = ACTIONS(894),
    [anon_sym_break] = ACTIONS(894),
    [anon_sym_continue] = ACTIONS(894),
    [anon_sym_return] = ACTIONS(894),
    [anon_sym_synchronized] = ACTIONS(894),
    [anon_sym_throw] = ACTIONS(894),
    [anon_sym_try] = ACTIONS(894),
    [anon_sym_if] = ACTIONS(894),
    [anon_sym_for] = ACTIONS(894),
    [anon_sym_AT] = ACTIONS(894),
    [anon_sym_open] = ACTIONS(894),
    [anon_sym_module] = ACTIONS(894),
    [anon_sym_static] = ACTIONS(894),
    [anon_sym_package] = ACTIONS(894),
    [anon_sym_import] = ACTIONS(894),
    [anon_sym_enum] = ACTIONS(894),
    [anon_sym_public] = ACTIONS(894),
    [anon_sym_protected] = ACTIONS(894),
    [anon_sym_private] = ACTIONS(894),
    [anon_sym_abstract] = ACTIONS(894),
    [anon_sym_final] = ACTIONS(894),
    [anon_sym_strictfp] = ACTIONS(894),
    [anon_sym_native] = ACTIONS(894),
    [anon_sym_transient] = ACTIONS(894),
    [anon_sym_volatile] = ACTIONS(894),
    [anon_sym_ATinterface] = ACTIONS(896),
    [anon_sym_interface] = ACTIONS(894),
    [anon_sym_byte] = ACTIONS(894),
    [anon_sym_short] = ACTIONS(894),
    [anon_sym_int] = ACTIONS(894),
    [anon_sym_long] = ACTIONS(894),
    [anon_sym_char] = ACTIONS(894),
    [anon_sym_float] = ACTIONS(894),
    [anon_sym_double] = ACTIONS(894),
    [sym_boolean_type] = ACTIONS(894),
    [sym_void_type] = ACTIONS(894),
    [sym_this] = ACTIONS(894),
    [sym_super] = ACTIONS(894),
    [sym_comment] = ACTIONS(3),
  },
  [198] = {
    [sym_identifier] = ACTIONS(898),
    [sym_decimal_integer_literal] = ACTIONS(898),
    [sym_hex_integer_literal] = ACTIONS(898),
    [sym_octal_integer_literal] = ACTIONS(900),
    [sym_binary_integer_literal] = ACTIONS(900),
    [sym_decimal_floating_point_literal] = ACTIONS(900),
    [sym_hex_floating_point_literal] = ACTIONS(898),
    [sym_true] = ACTIONS(898),
    [sym_false] = ACTIONS(898),
    [sym_character_literal] = ACTIONS(900),
    [sym_string_literal] = ACTIONS(900),
    [sym_null_literal] = ACTIONS(898),
    [anon_sym_LPAREN] = ACTIONS(900),
    [anon_sym_PLUS] = ACTIONS(898),
    [anon_sym_DASH] = ACTIONS(898),
    [anon_sym_BANG] = ACTIONS(900),
    [anon_sym_TILDE] = ACTIONS(900),
    [anon_sym_PLUS_PLUS] = ACTIONS(900),
    [anon_sym_DASH_DASH] = ACTIONS(900),
    [anon_sym_new] = ACTIONS(898),
    [anon_sym_class] = ACTIONS(898),
    [anon_sym_SEMI] = ACTIONS(900),
    [anon_sym_LBRACE] = ACTIONS(900),
    [anon_sym_RBRACE] = ACTIONS(900),
    [anon_sym_assert] = ACTIONS(898),
    [anon_sym_switch] = ACTIONS(898),
    [anon_sym_default] = ACTIONS(898),
    [anon_sym_do] = ACTIONS(898),
    [anon_sym_while] = ACTIONS(898),
    [anon_sym_break] = ACTIONS(898),
    [anon_sym_continue] = ACTIONS(898),
    [anon_sym_return] = ACTIONS(898),
    [anon_sym_synchronized] = ACTIONS(898),
    [anon_sym_throw] = ACTIONS(898),
    [anon_sym_try] = ACTIONS(898),
    [anon_sym_if] = ACTIONS(898),
    [anon_sym_for] = ACTIONS(898),
    [anon_sym_AT] = ACTIONS(898),
    [anon_sym_open] = ACTIONS(898),
    [anon_sym_module] = ACTIONS(898),
    [anon_sym_static] = ACTIONS(898),
    [anon_sym_package] = ACTIONS(898),
    [anon_sym_import] = ACTIONS(898),
    [anon_sym_enum] = ACTIONS(898),
    [anon_sym_public] = ACTIONS(898),
    [anon_sym_protected] = ACTIONS(898),
    [anon_sym_private] = ACTIONS(898),
    [anon_sym_abstract] = ACTIONS(898),
    [anon_sym_final] = ACTIONS(898),
    [anon_sym_strictfp] = ACTIONS(898),
    [anon_sym_native] = ACTIONS(898),
    [anon_sym_transient] = ACTIONS(898),
    [anon_sym_volatile] = ACTIONS(898),
    [anon_sym_ATinterface] = ACTIONS(900),
    [anon_sym_interface] = ACTIONS(898),
    [anon_sym_byte] = ACTIONS(898),
    [anon_sym_short] = ACTIONS(898),
    [anon_sym_int] = ACTIONS(898),
    [anon_sym_long] = ACTIONS(898),
    [anon_sym_char] = ACTIONS(898),
    [anon_sym_float] = ACTIONS(898),
    [anon_sym_double] = ACTIONS(898),
    [sym_boolean_type] = ACTIONS(898),
    [sym_void_type] = ACTIONS(898),
    [sym_this] = ACTIONS(898),
    [sym_super] = ACTIONS(898),
    [sym_comment] = ACTIONS(3),
  },
  [199] = {
    [sym_identifier] = ACTIONS(902),
    [sym_decimal_integer_literal] = ACTIONS(902),
    [sym_hex_integer_literal] = ACTIONS(902),
    [sym_octal_integer_literal] = ACTIONS(904),
    [sym_binary_integer_literal] = ACTIONS(904),
    [sym_decimal_floating_point_literal] = ACTIONS(904),
    [sym_hex_floating_point_literal] = ACTIONS(902),
    [sym_true] = ACTIONS(902),
    [sym_false] = ACTIONS(902),
    [sym_character_literal] = ACTIONS(904),
    [sym_string_literal] = ACTIONS(904),
    [sym_null_literal] = ACTIONS(902),
    [anon_sym_LPAREN] = ACTIONS(904),
    [anon_sym_PLUS] = ACTIONS(902),
    [anon_sym_DASH] = ACTIONS(902),
    [anon_sym_BANG] = ACTIONS(904),
    [anon_sym_TILDE] = ACTIONS(904),
    [anon_sym_PLUS_PLUS] = ACTIONS(904),
    [anon_sym_DASH_DASH] = ACTIONS(904),
    [anon_sym_new] = ACTIONS(902),
    [anon_sym_class] = ACTIONS(902),
    [anon_sym_SEMI] = ACTIONS(904),
    [anon_sym_LBRACE] = ACTIONS(904),
    [anon_sym_RBRACE] = ACTIONS(904),
    [anon_sym_assert] = ACTIONS(902),
    [anon_sym_switch] = ACTIONS(902),
    [anon_sym_default] = ACTIONS(902),
    [anon_sym_do] = ACTIONS(902),
    [anon_sym_while] = ACTIONS(902),
    [anon_sym_break] = ACTIONS(902),
    [anon_sym_continue] = ACTIONS(902),
    [anon_sym_return] = ACTIONS(902),
    [anon_sym_synchronized] = ACTIONS(902),
    [anon_sym_throw] = ACTIONS(902),
    [anon_sym_try] = ACTIONS(902),
    [anon_sym_if] = ACTIONS(902),
    [anon_sym_for] = ACTIONS(902),
    [anon_sym_AT] = ACTIONS(902),
    [anon_sym_open] = ACTIONS(902),
    [anon_sym_module] = ACTIONS(902),
    [anon_sym_static] = ACTIONS(902),
    [anon_sym_package] = ACTIONS(902),
    [anon_sym_import] = ACTIONS(902),
    [anon_sym_enum] = ACTIONS(902),
    [anon_sym_public] = ACTIONS(902),
    [anon_sym_protected] = ACTIONS(902),
    [anon_sym_private] = ACTIONS(902),
    [anon_sym_abstract] = ACTIONS(902),
    [anon_sym_final] = ACTIONS(902),
    [anon_sym_strictfp] = ACTIONS(902),
    [anon_sym_native] = ACTIONS(902),
    [anon_sym_transient] = ACTIONS(902),
    [anon_sym_volatile] = ACTIONS(902),
    [anon_sym_ATinterface] = ACTIONS(904),
    [anon_sym_interface] = ACTIONS(902),
    [anon_sym_byte] = ACTIONS(902),
    [anon_sym_short] = ACTIONS(902),
    [anon_sym_int] = ACTIONS(902),
    [anon_sym_long] = ACTIONS(902),
    [anon_sym_char] = ACTIONS(902),
    [anon_sym_float] = ACTIONS(902),
    [anon_sym_double] = ACTIONS(902),
    [sym_boolean_type] = ACTIONS(902),
    [sym_void_type] = ACTIONS(902),
    [sym_this] = ACTIONS(902),
    [sym_super] = ACTIONS(902),
    [sym_comment] = ACTIONS(3),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(906), 1,
      sym_identifier,
    ACTIONS(908), 1,
      anon_sym_LT,
    ACTIONS(910), 1,
      anon_sym_SEMI,
    ACTIONS(912), 1,
      anon_sym_RBRACE,
    ACTIONS(914), 1,
      anon_sym_static,
    STATE(423), 1,
      sym_modifiers,
    STATE(454), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(651), 1,
      sym__constructor_declarator,
    STATE(762), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(916), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(496), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(204), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [107] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(906), 1,
      sym_identifier,
    ACTIONS(908), 1,
      anon_sym_LT,
    ACTIONS(914), 1,
      anon_sym_static,
    ACTIONS(918), 1,
      anon_sym_SEMI,
    ACTIONS(920), 1,
      anon_sym_RBRACE,
    STATE(423), 1,
      sym_modifiers,
    STATE(454), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(651), 1,
      sym__constructor_declarator,
    STATE(762), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(916), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(496), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(202), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [214] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(906), 1,
      sym_identifier,
    ACTIONS(908), 1,
      anon_sym_LT,
    ACTIONS(914), 1,
      anon_sym_static,
    ACTIONS(922), 1,
      anon_sym_SEMI,
    ACTIONS(924), 1,
      anon_sym_RBRACE,
    STATE(423), 1,
      sym_modifiers,
    STATE(454), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(651), 1,
      sym__constructor_declarator,
    STATE(762), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(916), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(496), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(203), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [321] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 1,
      sym_identifier,
    ACTIONS(929), 1,
      anon_sym_LT,
    ACTIONS(932), 1,
      anon_sym_class,
    ACTIONS(935), 1,
      anon_sym_SEMI,
    ACTIONS(938), 1,
      anon_sym_LBRACE,
    ACTIONS(941), 1,
      anon_sym_RBRACE,
    ACTIONS(946), 1,
      anon_sym_AT,
    ACTIONS(949), 1,
      anon_sym_static,
    ACTIONS(952), 1,
      anon_sym_enum,
    ACTIONS(955), 1,
      anon_sym_ATinterface,
    ACTIONS(958), 1,
      anon_sym_interface,
    STATE(423), 1,
      sym_modifiers,
    STATE(454), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(651), 1,
      sym__constructor_declarator,
    STATE(762), 1,
      sym__method_header,
    ACTIONS(964), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(967), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(496), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(961), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(203), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(943), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [428] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(906), 1,
      sym_identifier,
    ACTIONS(908), 1,
      anon_sym_LT,
    ACTIONS(914), 1,
      anon_sym_static,
    ACTIONS(922), 1,
      anon_sym_SEMI,
    ACTIONS(970), 1,
      anon_sym_RBRACE,
    STATE(423), 1,
      sym_modifiers,
    STATE(454), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(651), 1,
      sym__constructor_declarator,
    STATE(762), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(916), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(496), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(203), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [535] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(980), 1,
      anon_sym_EQ,
    ACTIONS(984), 1,
      anon_sym_LT,
    ACTIONS(987), 1,
      anon_sym_DASH_GT,
    ACTIONS(989), 1,
      anon_sym_LBRACK,
    ACTIONS(992), 1,
      anon_sym_DOT,
    ACTIONS(994), 1,
      anon_sym_COLON_COLON,
    ACTIONS(997), 1,
      anon_sym_AT,
    STATE(296), 1,
      sym_argument_list,
    STATE(468), 1,
      sym_type_arguments,
    STATE(752), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(972), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(982), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(976), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COLON,
    ACTIONS(978), 14,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [622] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(980), 1,
      anon_sym_EQ,
    ACTIONS(984), 1,
      anon_sym_LT,
    ACTIONS(987), 1,
      anon_sym_DASH_GT,
    ACTIONS(989), 1,
      anon_sym_LBRACK,
    ACTIONS(994), 1,
      anon_sym_COLON_COLON,
    ACTIONS(999), 1,
      anon_sym_AMP,
    ACTIONS(1002), 1,
      anon_sym_RPAREN,
    ACTIONS(1006), 1,
      anon_sym_COMMA,
    ACTIONS(1008), 1,
      anon_sym_DOT,
    STATE(296), 1,
      sym_argument_list,
    STATE(468), 1,
      sym_type_arguments,
    STATE(734), 1,
      aux_sym_inferred_parameters_repeat1,
    STATE(752), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(997), 2,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(972), 4,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_identifier,
    ACTIONS(978), 9,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(982), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(976), 12,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [716] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(908), 1,
      anon_sym_LT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1012), 1,
      anon_sym_SEMI,
    ACTIONS(1014), 1,
      anon_sym_RBRACE,
    STATE(446), 1,
      sym_modifiers,
    STATE(456), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(762), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1016), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(497), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(209), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [812] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(908), 1,
      anon_sym_LT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1018), 1,
      anon_sym_SEMI,
    ACTIONS(1020), 1,
      anon_sym_RBRACE,
    STATE(446), 1,
      sym_modifiers,
    STATE(456), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(762), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1016), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(497), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(207), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [908] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 1,
      sym_identifier,
    ACTIONS(1025), 1,
      anon_sym_LT,
    ACTIONS(1028), 1,
      anon_sym_class,
    ACTIONS(1031), 1,
      anon_sym_SEMI,
    ACTIONS(1034), 1,
      anon_sym_RBRACE,
    ACTIONS(1039), 1,
      anon_sym_AT,
    ACTIONS(1042), 1,
      anon_sym_enum,
    ACTIONS(1045), 1,
      anon_sym_ATinterface,
    ACTIONS(1048), 1,
      anon_sym_interface,
    STATE(446), 1,
      sym_modifiers,
    STATE(456), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(762), 1,
      sym__method_header,
    ACTIONS(1054), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1057), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(497), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(1051), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(209), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(1036), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [1004] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(1066), 1,
      anon_sym_LT,
    ACTIONS(1072), 1,
      anon_sym_AT,
    STATE(315), 1,
      sym_argument_list,
    ACTIONS(1060), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(1069), 3,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
    ACTIONS(1062), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COLON,
    ACTIONS(1064), 25,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1074] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(980), 1,
      anon_sym_EQ,
    ACTIONS(984), 1,
      anon_sym_LT,
    ACTIONS(987), 1,
      anon_sym_DASH_GT,
    ACTIONS(989), 1,
      anon_sym_LBRACK,
    ACTIONS(994), 1,
      anon_sym_COLON_COLON,
    ACTIONS(997), 1,
      anon_sym_AT,
    ACTIONS(1074), 1,
      anon_sym_COLON,
    ACTIONS(1076), 1,
      anon_sym_DOT,
    STATE(296), 1,
      sym_argument_list,
    STATE(468), 1,
      sym_type_arguments,
    STATE(752), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(972), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(978), 10,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(982), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(976), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [1159] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(980), 1,
      anon_sym_EQ,
    ACTIONS(984), 1,
      anon_sym_LT,
    ACTIONS(987), 1,
      anon_sym_DASH_GT,
    ACTIONS(989), 1,
      anon_sym_LBRACK,
    ACTIONS(992), 1,
      anon_sym_DOT,
    ACTIONS(994), 1,
      anon_sym_COLON_COLON,
    ACTIONS(997), 1,
      anon_sym_AT,
    ACTIONS(1074), 1,
      anon_sym_COLON,
    STATE(296), 1,
      sym_argument_list,
    STATE(468), 1,
      sym_type_arguments,
    STATE(752), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(972), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(978), 10,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(982), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(976), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [1244] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    STATE(315), 1,
      sym_argument_list,
    ACTIONS(1072), 2,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1066), 3,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_DOT,
    ACTIONS(1069), 3,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1060), 4,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_identifier,
    ACTIONS(1062), 13,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
    ACTIONS(1064), 20,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [1311] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(1082), 1,
      anon_sym_EQ,
    ACTIONS(1086), 1,
      anon_sym_LBRACK,
    ACTIONS(1088), 1,
      anon_sym_DOT,
    ACTIONS(1090), 1,
      anon_sym_COLON_COLON,
    STATE(312), 1,
      sym_argument_list,
    STATE(760), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(1084), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1078), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1080), 15,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1382] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(1082), 1,
      anon_sym_EQ,
    ACTIONS(1086), 1,
      anon_sym_LBRACK,
    ACTIONS(1088), 1,
      anon_sym_DOT,
    ACTIONS(1090), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1092), 1,
      sym_identifier,
    STATE(312), 1,
      sym_argument_list,
    STATE(760), 1,
      aux_sym_class_literal_repeat1,
    STATE(808), 1,
      sym_scoped_identifier,
    ACTIONS(1094), 2,
      anon_sym_open,
      anon_sym_module,
    ACTIONS(1080), 10,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(1084), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1078), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [1458] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    STATE(315), 1,
      sym_argument_list,
    ACTIONS(1062), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1064), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1516] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    STATE(315), 1,
      sym_argument_list,
    ACTIONS(1096), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1098), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1574] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    STATE(303), 1,
      sym_argument_list,
    ACTIONS(1100), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1102), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1632] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1108), 1,
      anon_sym_LBRACK,
    STATE(222), 1,
      aux_sym_dimensions_repeat1,
    STATE(579), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1106), 10,
      anon_sym_AMP,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1104), 29,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_implements,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      anon_sym_throws,
      sym_this,
      sym_identifier,
  [1694] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    STATE(288), 1,
      sym_argument_list,
    ACTIONS(1110), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1112), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1752] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(1082), 1,
      anon_sym_EQ,
    ACTIONS(1086), 1,
      anon_sym_LBRACK,
    ACTIONS(1090), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1092), 1,
      sym_identifier,
    ACTIONS(1114), 1,
      anon_sym_DOT,
    STATE(312), 1,
      sym_argument_list,
    STATE(760), 1,
      aux_sym_class_literal_repeat1,
    STATE(808), 1,
      sym_scoped_identifier,
    ACTIONS(1094), 2,
      anon_sym_open,
      anon_sym_module,
    ACTIONS(1080), 10,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(1084), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1078), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [1828] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1120), 1,
      anon_sym_LBRACK,
    ACTIONS(1123), 1,
      anon_sym_AT,
    STATE(222), 1,
      aux_sym_dimensions_repeat1,
    STATE(579), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1118), 10,
      anon_sym_AMP,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1116), 29,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_implements,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      anon_sym_throws,
      sym_this,
      sym_identifier,
  [1890] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    STATE(328), 1,
      sym_argument_list,
    ACTIONS(1126), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1128), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1948] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 1,
      anon_sym_EQ,
    ACTIONS(1130), 1,
      anon_sym_LBRACK,
    ACTIONS(1132), 1,
      anon_sym_DOT,
    ACTIONS(1134), 1,
      anon_sym_COLON_COLON,
    STATE(752), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(982), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(976), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(978), 15,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2013] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(984), 1,
      anon_sym_LT,
    ACTIONS(987), 1,
      anon_sym_DASH_GT,
    ACTIONS(989), 1,
      anon_sym_LBRACK,
    ACTIONS(992), 1,
      anon_sym_DOT,
    ACTIONS(994), 1,
      anon_sym_COLON_COLON,
    ACTIONS(997), 1,
      anon_sym_AT,
    ACTIONS(1136), 1,
      anon_sym_EQ,
    STATE(296), 1,
      sym_argument_list,
    STATE(468), 1,
      sym_type_arguments,
    STATE(752), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(978), 11,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(982), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(976), 12,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
  [2090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1140), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2142] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 1,
      sym_identifier,
    ACTIONS(1145), 1,
      anon_sym_class,
    ACTIONS(1148), 1,
      anon_sym_RBRACE,
    ACTIONS(1153), 1,
      anon_sym_AT,
    ACTIONS(1156), 1,
      anon_sym_ATinterface,
    ACTIONS(1159), 1,
      anon_sym_interface,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(465), 1,
      sym_modifiers,
    STATE(473), 1,
      sym_generic_type,
    ACTIONS(1165), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1168), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(500), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(1162), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(227), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(1150), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2222] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 1,
      anon_sym_EQ,
    ACTIONS(982), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1171), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1173), 18,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1098), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2330] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1175), 1,
      anon_sym_RBRACE,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(465), 1,
      sym_modifiers,
    STATE(473), 1,
      sym_generic_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1177), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(500), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(233), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1179), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1181), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1183), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1185), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2514] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1187), 1,
      anon_sym_RBRACE,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(465), 1,
      sym_modifiers,
    STATE(473), 1,
      sym_generic_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1177), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(285), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(500), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(227), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2594] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(1082), 1,
      anon_sym_EQ,
    ACTIONS(1086), 1,
      anon_sym_LBRACK,
    ACTIONS(1088), 1,
      anon_sym_DOT,
    ACTIONS(1090), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1189), 1,
      anon_sym_module,
    STATE(312), 1,
      sym_argument_list,
    STATE(760), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(1080), 11,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(1084), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1078), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
  [2663] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(1082), 1,
      anon_sym_EQ,
    ACTIONS(1086), 1,
      anon_sym_LBRACK,
    ACTIONS(1090), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1114), 1,
      anon_sym_DOT,
    ACTIONS(1189), 1,
      anon_sym_module,
    STATE(312), 1,
      sym_argument_list,
    STATE(760), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(1080), 11,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(1084), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1078), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
  [2732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 12,
      anon_sym_AMP,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1116), 29,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_implements,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      anon_sym_throws,
      sym_this,
      sym_identifier,
  [2781] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    STATE(248), 1,
      aux_sym_dimensions_repeat1,
    STATE(290), 1,
      sym_dimensions,
    STATE(242), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(582), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1191), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1193), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1199), 12,
      anon_sym_AMP,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1197), 29,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_implements,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      anon_sym_throws,
      sym_this,
      sym_identifier,
  [2891] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    STATE(248), 1,
      aux_sym_dimensions_repeat1,
    STATE(300), 1,
      sym_dimensions,
    STATE(242), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(582), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1201), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1203), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2952] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 1,
      anon_sym_RPAREN,
    ACTIONS(415), 1,
      anon_sym_COMMA,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    STATE(245), 1,
      sym_receiver_parameter,
    STATE(251), 1,
      sym_formal_parameter,
    STATE(390), 1,
      aux_sym_modifiers_repeat1,
    STATE(457), 1,
      aux_sym_dimensions_expr_repeat1,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(485), 1,
      sym_modifiers,
    STATE(939), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1205), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(438), 3,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
    STATE(499), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3032] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 1,
      anon_sym_EQ,
    ACTIONS(1130), 1,
      anon_sym_LBRACK,
    ACTIONS(1134), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1207), 1,
      anon_sym_DOT,
    STATE(752), 1,
      aux_sym_class_literal_repeat1,
    ACTIONS(978), 11,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(982), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(976), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
  [3092] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      anon_sym_LBRACK,
    ACTIONS(1216), 1,
      anon_sym_AT,
    STATE(242), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(599), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1209), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1211), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [3147] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
    ACTIONS(1221), 1,
      anon_sym_COMMA,
    STATE(246), 1,
      aux_sym_formal_parameters_repeat1,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(477), 1,
      sym_modifiers,
    STATE(947), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1223), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(544), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1102), 7,
      anon_sym_LPAREN,
      anon_sym_LT,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_ATinterface,
    ACTIONS(1100), 31,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_to,
      anon_sym_with,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [3265] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1225), 1,
      anon_sym_RPAREN,
    ACTIONS(1227), 1,
      anon_sym_COMMA,
    STATE(243), 1,
      sym_formal_parameter,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(485), 1,
      sym_modifiers,
    STATE(905), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1229), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(512), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3337] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1231), 1,
      anon_sym_RPAREN,
    ACTIONS(1233), 1,
      anon_sym_COMMA,
    STATE(400), 1,
      aux_sym_formal_parameters_repeat1,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(477), 1,
      sym_modifiers,
    STATE(894), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1223), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(544), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3409] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 1,
      anon_sym_AT,
    ACTIONS(1235), 1,
      anon_sym_LBRACK,
    STATE(247), 1,
      aux_sym_dimensions_repeat1,
    STATE(588), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1116), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1118), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [3463] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1238), 1,
      anon_sym_LBRACK,
    STATE(247), 1,
      aux_sym_dimensions_repeat1,
    STATE(588), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1104), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1106), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [3517] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 7,
      anon_sym_LPAREN,
      anon_sym_LT,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_ATinterface,
    ACTIONS(1062), 31,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_to,
      anon_sym_with,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [3563] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
    ACTIONS(1221), 1,
      anon_sym_COMMA,
    STATE(400), 1,
      aux_sym_formal_parameters_repeat1,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(477), 1,
      sym_modifiers,
    STATE(947), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1223), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(544), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3635] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1225), 1,
      anon_sym_RPAREN,
    ACTIONS(1240), 1,
      anon_sym_COMMA,
    STATE(250), 1,
      aux_sym_formal_parameters_repeat1,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(477), 1,
      sym_modifiers,
    STATE(905), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1223), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(544), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3707] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1231), 1,
      anon_sym_RPAREN,
    STATE(409), 1,
      sym_formal_parameter,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(485), 1,
      sym_modifiers,
    STATE(894), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1229), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(512), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3776] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1242), 1,
      anon_sym_RPAREN,
    STATE(409), 1,
      sym_formal_parameter,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(485), 1,
      sym_modifiers,
    STATE(938), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1229), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(512), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3845] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1238), 1,
      anon_sym_LBRACK,
    STATE(248), 1,
      aux_sym_dimensions_repeat1,
    STATE(339), 1,
      sym_dimensions,
    STATE(588), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1244), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1246), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [3900] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
    STATE(409), 1,
      sym_formal_parameter,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(485), 1,
      sym_modifiers,
    STATE(947), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1229), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(512), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [3969] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1238), 1,
      anon_sym_LBRACK,
    STATE(248), 1,
      aux_sym_dimensions_repeat1,
    STATE(339), 1,
      sym_dimensions,
    STATE(588), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1248), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1250), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [4024] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1225), 1,
      anon_sym_RPAREN,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(477), 1,
      sym_modifiers,
    STATE(905), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1223), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(544), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [4090] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(472), 1,
      sym_modifiers,
    STATE(473), 1,
      sym_generic_type,
    STATE(673), 1,
      sym_catch_type,
    STATE(896), 1,
      sym_catch_formal_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1252), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(519), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [4156] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(477), 1,
      sym_modifiers,
    STATE(947), 1,
      sym_spread_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1223), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(544), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [4222] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1256), 1,
      anon_sym_LPAREN,
    ACTIONS(1260), 1,
      anon_sym_DOT,
    STATE(286), 1,
      sym_annotation_argument_list,
    ACTIONS(1258), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1254), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [4271] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    STATE(409), 1,
      sym_formal_parameter,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(475), 1,
      sym_modifiers,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1262), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(535), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [4334] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 1,
      anon_sym_LBRACE,
    STATE(325), 1,
      sym_class_body,
    ACTIONS(1264), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1266), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [4380] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 1,
      anon_sym_LBRACE,
    STATE(295), 1,
      sym_class_body,
    ACTIONS(1270), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1272), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [4426] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1102), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1100), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [4468] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 1,
      anon_sym_LBRACE,
    STATE(322), 1,
      sym_class_body,
    ACTIONS(1274), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1276), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [4514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1062), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [4556] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1278), 1,
      anon_sym_LPAREN,
    ACTIONS(1280), 1,
      anon_sym_DOT,
    STATE(336), 1,
      sym_annotation_argument_list,
    ACTIONS(1258), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    ACTIONS(1254), 29,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [4604] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 1,
      anon_sym_LBRACE,
    STATE(280), 1,
      sym_class_body,
    ACTIONS(1282), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1284), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [4650] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1286), 1,
      anon_sym_LT,
    ACTIONS(1289), 1,
      anon_sym_DOT,
    STATE(329), 1,
      sym_type_arguments,
    ACTIONS(972), 7,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(997), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [4697] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1108), 1,
      anon_sym_LBRACK,
    ACTIONS(1295), 1,
      anon_sym_DOT,
    ACTIONS(1297), 1,
      anon_sym_AT,
    STATE(219), 1,
      aux_sym_dimensions_repeat1,
    STATE(379), 1,
      sym_dimensions,
    ACTIONS(1293), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    STATE(579), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1291), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [4750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1300), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1302), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [4791] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1304), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1306), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [4832] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1312), 1,
      anon_sym_LT,
    ACTIONS(1315), 1,
      anon_sym_DOT,
    STATE(294), 1,
      sym_type_arguments,
    ACTIONS(1308), 7,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1310), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [4879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1116), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1118), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [4920] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1317), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1319), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [4961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1197), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1199), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1321), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1323), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1325), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1327), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [5084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1331), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5124] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1335), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1339), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1343), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1347), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1351), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5324] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(1355), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    STATE(307), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(1357), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
    ACTIONS(1353), 13,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [5370] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1359), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [5410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1363), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1365), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1367), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1369), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1072), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5530] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1371), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1373), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1375), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1377), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1379), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1381), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5650] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1383), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [5690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1387), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1389), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5730] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1391), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1393), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5770] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1395), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1397), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1399), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1401), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1403), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1405), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5890] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      anon_sym_DOT,
    ACTIONS(1308), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1310), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [5932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1407), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1409), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [5972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1413), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1415), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1417), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6052] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1419), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1421), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6092] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1423), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1425), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1427), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1429), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6172] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1431), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [6212] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_AT,
    ACTIONS(1437), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    STATE(307), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(1439), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
    ACTIONS(1435), 13,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [6258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1445), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1447), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1449), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1451), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1453), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1455), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6378] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1459), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6418] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1463), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6458] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1467), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6498] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1471), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [6538] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1473), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1475), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1477), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1479), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6618] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1481), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1483), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6658] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1108), 1,
      anon_sym_LBRACK,
    ACTIONS(1297), 1,
      anon_sym_AT,
    STATE(219), 1,
      aux_sym_dimensions_repeat1,
    STATE(379), 1,
      sym_dimensions,
    ACTIONS(1293), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    STATE(579), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1291), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [6708] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1485), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [6748] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1108), 1,
      anon_sym_LBRACK,
    ACTIONS(1493), 1,
      anon_sym_AT,
    STATE(219), 1,
      aux_sym_dimensions_repeat1,
    STATE(377), 1,
      sym_dimensions,
    ACTIONS(1491), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    STATE(579), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1489), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [6798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1496), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1498), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1500), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1502), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6878] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1504), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1506), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [6918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1508), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1510), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6958] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1512), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1514), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [6998] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1520), 1,
      anon_sym_LBRACK,
    ACTIONS(1522), 1,
      anon_sym_DOT,
    ACTIONS(1516), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1518), 20,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [7044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1526), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [7084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1528), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1530), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [7124] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1532), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1534), 24,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [7164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1536), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1538), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [7204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1542), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1540), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7243] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1546), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1544), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7282] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1550), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1548), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7321] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    ACTIONS(1485), 29,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1554), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1552), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    ACTIONS(1359), 29,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1558), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1556), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    ACTIONS(1431), 29,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1560), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1562), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [7555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1566), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1564), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7594] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    ACTIONS(1383), 29,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1570), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1568), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7672] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1574), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1572), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7711] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1578), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1576), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1582), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1580), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7789] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1586), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [7828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1590), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1588), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1594), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1592), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1596), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1598), 23,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
  [7945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1602), 5,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1600), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [7984] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    STATE(342), 1,
      sym_block,
    ACTIONS(1606), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    ACTIONS(1604), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [8026] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1606), 1,
      anon_sym_ATinterface,
    ACTIONS(1611), 3,
      anon_sym_open,
      anon_sym_module,
      anon_sym_package,
    ACTIONS(1608), 11,
      anon_sym_AT,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
    ACTIONS(1604), 15,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
  [8068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1615), 4,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1613), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [8106] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1619), 4,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1617), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [8144] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1623), 6,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8203] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1649), 1,
      anon_sym_PIPE,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1647), 9,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8258] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1649), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1647), 10,
      anon_sym_RPAREN,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8309] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1649), 6,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
    ACTIONS(1647), 15,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8352] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1651), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1653), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1655), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1657), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8426] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1657), 6,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1659), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1661), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8522] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1663), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1665), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1663), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1665), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8596] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1649), 4,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
    ACTIONS(1647), 10,
      anon_sym_RPAREN,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8645] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1667), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1669), 19,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 12,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_RPAREN,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1379), 17,
      anon_sym_new,
      anon_sym_DOT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_implements,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_this,
      sym_super,
      sym_identifier,
  [8721] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1667), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1669), 19,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8760] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1649), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1647), 19,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1339), 12,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_RPAREN,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1337), 17,
      anon_sym_new,
      anon_sym_DOT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_implements,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_this,
      sym_super,
      sym_identifier,
  [8836] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1671), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1673), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8873] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1675), 6,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [8932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1506), 12,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_RPAREN,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1504), 17,
      anon_sym_new,
      anon_sym_DOT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_implements,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_this,
      sym_super,
      sym_identifier,
  [8969] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    STATE(967), 1,
      sym_argument_list,
    ACTIONS(1171), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1173), 19,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
  [9010] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1677), 6,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [9069] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1606), 1,
      anon_sym_ATinterface,
    ACTIONS(1679), 1,
      anon_sym_COLON,
    ACTIONS(1604), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1683), 6,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_AT,
    ACTIONS(1681), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9143] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1606), 1,
      anon_sym_ATinterface,
    ACTIONS(1685), 1,
      anon_sym_LPAREN,
    ACTIONS(1604), 26,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9181] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1689), 6,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_AT,
    ACTIONS(1687), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9217] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1693), 2,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1691), 25,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1697), 2,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1695), 25,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9287] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1702), 1,
      anon_sym_AT,
    STATE(382), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(1435), 10,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
    ACTIONS(1699), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [9326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1707), 2,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1705), 25,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1711), 2,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1709), 25,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9396] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
    ACTIONS(1713), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [9453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1717), 2,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1715), 25,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9488] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1721), 2,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1719), 25,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9523] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1725), 2,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1723), 25,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1729), 2,
      anon_sym_RBRACE,
      anon_sym_ATinterface,
    ACTIONS(1727), 25,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [9593] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    STATE(382), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(1353), 10,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
    ACTIONS(1731), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [9632] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1520), 1,
      anon_sym_LBRACK,
    ACTIONS(1733), 1,
      anon_sym_DOT,
    ACTIONS(1516), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1518), 16,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
  [9673] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1735), 1,
      anon_sym_GT,
    ACTIONS(1737), 1,
      anon_sym_QMARK,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1739), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(769), 3,
      sym_wildcard,
      sym__type,
      sym_annotated_type,
    STATE(450), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    STATE(483), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
  [9727] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1741), 1,
      anon_sym_COMMA,
    ACTIONS(1743), 1,
      anon_sym_SEMI,
    STATE(771), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [9787] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1745), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [9843] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(616), 1,
      anon_sym_RPAREN,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1741), 1,
      anon_sym_COMMA,
    STATE(755), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [9903] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1747), 1,
      anon_sym_COMMA,
    ACTIONS(1749), 1,
      anon_sym_RBRACE,
    STATE(756), 1,
      aux_sym_array_initializer_repeat1,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [9963] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_RPAREN,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1741), 1,
      anon_sym_COMMA,
    STATE(704), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10023] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1737), 1,
      anon_sym_QMARK,
    ACTIONS(1751), 1,
      anon_sym_GT,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1739), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(731), 3,
      sym_wildcard,
      sym__type,
      sym_annotated_type,
    STATE(450), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    STATE(483), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
  [10077] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1753), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10133] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1759), 1,
      anon_sym_COMMA,
    STATE(400), 1,
      aux_sym_formal_parameters_repeat1,
    ACTIONS(1757), 2,
      anon_sym_RPAREN,
      anon_sym_AT,
    ACTIONS(1755), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [10171] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1741), 1,
      anon_sym_COMMA,
    ACTIONS(1762), 1,
      anon_sym_RPAREN,
    STATE(712), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10231] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1741), 1,
      anon_sym_COMMA,
    ACTIONS(1764), 1,
      anon_sym_RPAREN,
    STATE(767), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10291] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1737), 1,
      anon_sym_QMARK,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1739), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(852), 3,
      sym_wildcard,
      sym__type,
      sym_annotated_type,
    STATE(450), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    STATE(483), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
  [10342] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1766), 1,
      anon_sym_COLON,
    ACTIONS(1768), 1,
      anon_sym_SEMI,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1772), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_AT,
    ACTIONS(1770), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [10432] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1774), 2,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1778), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_AT,
    ACTIONS(1776), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [10520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1782), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_AT,
    ACTIONS(1780), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [10553] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1757), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_AT,
    ACTIONS(1755), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [10586] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1786), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_AT,
    ACTIONS(1784), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [10619] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1788), 2,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1792), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_AT,
    ACTIONS(1790), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [10707] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1794), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10762] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1713), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1798), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_AT,
    ACTIONS(1796), 22,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [10850] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1800), 1,
      anon_sym_RPAREN,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [10904] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1802), 1,
      sym_identifier,
    ACTIONS(1804), 1,
      anon_sym_COMMA,
    ACTIONS(1806), 1,
      anon_sym_SEMI,
    ACTIONS(1808), 1,
      anon_sym_RBRACE,
    STATE(629), 1,
      sym_enum_constant,
    STATE(933), 1,
      sym_modifiers,
    STATE(957), 1,
      sym_enum_body_declarations,
    STATE(390), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(417), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [10952] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 1,
      anon_sym_SEMI,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [11006] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1810), 1,
      anon_sym_SEMI,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [11060] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1812), 1,
      anon_sym_RPAREN,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [11114] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1814), 1,
      anon_sym_SEMI,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [11168] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_AT,
    ACTIONS(1010), 1,
      sym_identifier,
    ACTIONS(1816), 1,
      anon_sym_open,
    ACTIONS(1818), 1,
      anon_sym_module,
    ACTIONS(1820), 1,
      anon_sym_package,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1822), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(460), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    STATE(480), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
  [11220] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 1,
      sym_identifier,
    ACTIONS(908), 1,
      anon_sym_LT,
    ACTIONS(1824), 1,
      anon_sym_class,
    ACTIONS(1826), 1,
      anon_sym_enum,
    ACTIONS(1828), 1,
      anon_sym_ATinterface,
    ACTIONS(1830), 1,
      anon_sym_interface,
    STATE(454), 1,
      sym_type_parameters,
    STATE(463), 1,
      sym_scoped_type_identifier,
    STATE(473), 1,
      sym_generic_type,
    STATE(686), 1,
      sym__constructor_declarator,
    STATE(694), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1832), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(495), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
  [11278] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1834), 1,
      anon_sym_SEMI,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [11332] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1836), 1,
      anon_sym_SEMI,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [11386] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1838), 1,
      anon_sym_RPAREN,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [11440] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1840), 1,
      anon_sym_COLON,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1637), 2,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1645), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1627), 4,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1635), 4,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
  [11494] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_AMP,
    ACTIONS(1629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1639), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 1,
      anon_sym_instanceof,
    ACTIONS(1643), 1,
      anon_sym_QMARK,
    ACTIONS(1842), 1,
      anon_sym_RBRACK,
    ACTIONS(1625), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1631), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1633), 2