#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 1285
#define LARGE_STATE_COUNT 242
#define SYMBOL_COUNT 178
#define ALIAS_COUNT 0
#define TOKEN_COUNT 82
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 9
#define MAX_ALIAS_SEQUENCE_LENGTH 10

enum {
  sym__lower_id = 1,
  anon_sym_module = 2,
  anon_sym_LBRACE = 3,
  anon_sym_RBRACE = 4,
  anon_sym_SEMI = 5,
  anon_sym_LPAREN = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  anon_sym_or = 9,
  anon_sym_from = 10,
  anon_sym_where = 11,
  anon_sym_select = 12,
  anon_sym_if = 13,
  anon_sym_then = 14,
  anon_sym_else = 15,
  anon_sym_and = 16,
  anon_sym_implies = 17,
  anon_sym_PIPE = 18,
  anon_sym_DOT = 19,
  anon_sym_LBRACK = 20,
  anon_sym_RBRACK = 21,
  anon_sym_DOT_DOT = 22,
  anon_sym_order = 23,
  anon_sym_by = 24,
  sym_qldoc = 25,
  anon_sym_COLON_COLON = 26,
  anon_sym_float = 27,
  anon_sym_int = 28,
  anon_sym_string = 29,
  sym__upper_id = 30,
  sym__at_lower_id = 31,
  sym_integer = 32,
  sym_float = 33,
  sym_string = 34,
  sym_line_comment = 35,
  sym_block_comment = 36,
  sym_any = 37,
  sym_as = 38,
  sym_asc = 39,
  sym_avg = 40,
  sym_boolean = 41,
  sym_class = 42,
  sym_newtype = 43,
  sym_count = 44,
  sym_date = 45,
  sym_desc = 46,
  sym_exists = 47,
  sym_extends = 48,
  sym_false = 49,
  sym_forall = 50,
  sym_forex = 51,
  sym_import = 52,
  sym_in = 53,
  sym_instanceof = 54,
  sym_max = 55,
  sym_min = 56,
  sym_not = 57,
  sym_none = 58,
  sym_predicate = 59,
  sym_rank = 60,
  sym_result = 61,
  sym_strictcount = 62,
  sym_strictsum = 63,
  sym_strictconcat = 64,
  sym_concat = 65,
  sym_sum = 66,
  sym_super = 67,
  sym_this = 68,
  sym_true = 69,
  sym_lt = 70,
  sym_le = 71,
  sym_eq = 72,
  sym_gt = 73,
  sym_ge = 74,
  sym_underscore = 75,
  sym_minus = 76,
  sym_ne = 77,
  sym_slash = 78,
  sym_star = 79,
  sym_mod = 80,
  sym_plus = 81,
  sym_ql = 82,
  sym_module = 83,
  sym_moduleMember = 84,
  sym_imprt = 85,
  sym_moduleAliasBody = 86,
  sym_predicateAliasBody = 87,
  sym_typeAliasBody = 88,
  sym_classlessPredicate = 89,
  sym_datatype = 90,
  sym_datatypeBranches = 91,
  sym_datatypeBranch = 92,
  sym_select = 93,
  sym_dataclass = 94,
  sym_classMember = 95,
  sym_charpred = 96,
  sym_memberPredicate = 97,
  sym_field = 98,
  sym__optbody = 99,
  sym_empty = 100,
  sym_body = 101,
  sym_higherOrderTerm = 102,
  sym_special_call = 103,
  sym_prefix_cast = 104,
  sym_unary_expr = 105,
  sym_mul_expr = 106,
  sym_add_expr = 107,
  sym_in_expr = 108,
  sym_comp_term = 109,
  sym_instance_of = 110,
  sym_negation = 111,
  sym_if_term = 112,
  sym_conjunction = 113,
  sym_disjunction = 114,
  sym_implication = 115,
  sym_quantified = 116,
  sym_specialId = 117,
  sym_quantifier = 118,
  sym__call_arg = 119,
  sym_qualifiedRhs = 120,
  sym_classless_predicate_call = 121,
  sym_qualified_expr = 122,
  sym_super_ref = 123,
  sym_full_aggregate_body = 124,
  sym_expr_aggregate_body = 125,
  sym_aggregate = 126,
  sym_range = 127,
  sym_par_expr = 128,
  sym__exprOrTerm = 129,
  sym__primary = 130,
  sym_literal = 131,
  sym_bool = 132,
  sym_variable = 133,
  sym_compop = 134,
  sym_unop = 135,
  sym_mulop = 136,
  sym_addop = 137,
  sym_closure = 138,
  sym_direction = 139,
  sym_varDecl = 140,
  sym_asExprs = 141,
  sym_asExpr = 142,
  sym_orderBys = 143,
  sym_orderBy = 144,
  sym_literalId = 145,
  sym_annotation = 146,
  sym_annotName = 147,
  sym_annotArg = 148,
  sym_moduleName = 149,
  sym_qualModuleExpr = 150,
  sym_importModuleExpr = 151,
  sym_moduleExpr = 152,
  sym_typeLiteral = 153,
  sym_simpleId = 154,
  sym_className = 155,
  sym_dbtype = 156,
  sym_returnType = 157,
  sym_typeExpr = 158,
  sym_predicateName = 159,
  sym_aritylessPredicateExpr = 160,
  sym_predicateExpr = 161,
  sym_varName = 162,
  sym_aggId = 163,
  aux_sym_ql_repeat1 = 164,
  aux_sym_moduleMember_repeat1 = 165,
  aux_sym_classlessPredicate_repeat1 = 166,
  aux_sym_datatypeBranches_repeat1 = 167,
  aux_sym_dataclass_repeat1 = 168,
  aux_sym_dataclass_repeat2 = 169,
  aux_sym_higherOrderTerm_repeat1 = 170,
  aux_sym_higherOrderTerm_repeat2 = 171,
  aux_sym_aggregate_repeat1 = 172,
  aux_sym_asExprs_repeat1 = 173,
  aux_sym_orderBys_repeat1 = 174,
  aux_sym_annotation_repeat1 = 175,
  aux_sym_qualModuleExpr_repeat1 = 176,
  aux_sym_importModuleExpr_repeat1 = 177,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__lower_id] = "_lower_id",
  [anon_sym_module] = "module",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SEMI] = ";",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_or] = "or",
  [anon_sym_from] = "from",
  [anon_sym_where] = "where",
  [anon_sym_select] = "select",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_and] = "and",
  [anon_sym_implies] = "implies",
  [anon_sym_PIPE] = "|",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_order] = "order",
  [anon_sym_by] = "by",
  [sym_qldoc] = "qldoc",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_float] = "float",
  [anon_sym_int] = "int",
  [anon_sym_string] = "string",
  [sym__upper_id] = "_upper_id",
  [sym__at_lower_id] = "_at_lower_id",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [sym_string] = "string",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_any] = "any",
  [sym_as] = "as",
  [sym_asc] = "asc",
  [sym_avg] = "avg",
  [sym_boolean] = "boolean",
  [sym_class] = "class",
  [sym_newtype] = "newtype",
  [sym_count] = "count",
  [sym_date] = "date",
  [sym_desc] = "desc",
  [sym_exists] = "exists",
  [sym_extends] = "extends",
  [sym_false] = "false",
  [sym_forall] = "forall",
  [sym_forex] = "forex",
  [sym_import] = "import",
  [sym_in] = "in",
  [sym_instanceof] = "instanceof",
  [sym_max] = "max",
  [sym_min] = "min",
  [sym_not] = "not",
  [sym_none] = "none",
  [sym_predicate] = "predicate",
  [sym_rank] = "rank",
  [sym_result] = "result",
  [sym_strictcount] = "strictcount",
  [sym_strictsum] = "strictsum",
  [sym_strictconcat] = "strictconcat",
  [sym_concat] = "concat",
  [sym_sum] = "sum",
  [sym_super] = "super",
  [sym_this] = "this",
  [sym_true] = "true",
  [sym_lt] = "lt",
  [sym_le] = "le",
  [sym_eq] = "eq",
  [sym_gt] = "gt",
  [sym_ge] = "ge",
  [sym_underscore] = "underscore",
  [sym_minus] = "minus",
  [sym_ne] = "ne",
  [sym_slash] = "slash",
  [sym_star] = "star",
  [sym_mod] = "mod",
  [sym_plus] = "plus",
  [sym_ql] = "ql",
  [sym_module] = "module",
  [sym_moduleMember] = "moduleMember",
  [sym_imprt] = "imprt",
  [sym_moduleAliasBody] = "moduleAliasBody",
  [sym_predicateAliasBody] = "predicateAliasBody",
  [sym_typeAliasBody] = "typeAliasBody",
  [sym_classlessPredicate] = "classlessPredicate",
  [sym_datatype] = "datatype",
  [sym_datatypeBranches] = "datatypeBranches",
  [sym_datatypeBranch] = "datatypeBranch",
  [sym_select] = "select",
  [sym_dataclass] = "dataclass",
  [sym_classMember] = "classMember",
  [sym_charpred] = "charpred",
  [sym_memberPredicate] = "memberPredicate",
  [sym_field] = "field",
  [sym__optbody] = "_optbody",
  [sym_empty] = "empty",
  [sym_body] = "body",
  [sym_higherOrderTerm] = "higherOrderTerm",
  [sym_special_call] = "special_call",
  [sym_prefix_cast] = "prefix_cast",
  [sym_unary_expr] = "unary_expr",
  [sym_mul_expr] = "mul_expr",
  [sym_add_expr] = "add_expr",
  [sym_in_expr] = "in_expr",
  [sym_comp_term] = "comp_term",
  [sym_instance_of] = "instance_of",
  [sym_negation] = "negation",
  [sym_if_term] = "if_term",
  [sym_conjunction] = "conjunction",
  [sym_disjunction] = "disjunction",
  [sym_implication] = "implication",
  [sym_quantified] = "quantified",
  [sym_specialId] = "specialId",
  [sym_quantifier] = "quantifier",
  [sym__call_arg] = "_call_arg",
  [sym_qualifiedRhs] = "qualifiedRhs",
  [sym_classless_predicate_call] = "classless_predicate_call",
  [sym_qualified_expr] = "qualified_expr",
  [sym_super_ref] = "super_ref",
  [sym_full_aggregate_body] = "full_aggregate_body",
  [sym_expr_aggregate_body] = "expr_aggregate_body",
  [sym_aggregate] = "aggregate",
  [sym_range] = "range",
  [sym_par_expr] = "par_expr",
  [sym__exprOrTerm] = "_exprOrTerm",
  [sym__primary] = "_primary",
  [sym_literal] = "literal",
  [sym_bool] = "bool",
  [sym_variable] = "variable",
  [sym_compop] = "compop",
  [sym_unop] = "unop",
  [sym_mulop] = "mulop",
  [sym_addop] = "addop",
  [sym_closure] = "closure",
  [sym_direction] = "direction",
  [sym_varDecl] = "varDecl",
  [sym_asExprs] = "asExprs",
  [sym_asExpr] = "asExpr",
  [sym_orderBys] = "orderBys",
  [sym_orderBy] = "orderBy",
  [sym_literalId] = "literalId",
  [sym_annotation] = "annotation",
  [sym_annotName] = "annotName",
  [sym_annotArg] = "annotArg",
  [sym_moduleName] = "moduleName",
  [sym_qualModuleExpr] = "qualModuleExpr",
  [sym_importModuleExpr] = "importModuleExpr",
  [sym_moduleExpr] = "moduleExpr",
  [sym_typeLiteral] = "typeLiteral",
  [sym_simpleId] = "simpleId",
  [sym_className] = "className",
  [sym_dbtype] = "dbtype",
  [sym_returnType] = "returnType",
  [sym_typeExpr] = "typeExpr",
  [sym_predicateName] = "predicateName",
  [sym_aritylessPredicateExpr] = "aritylessPredicateExpr",
  [sym_predicateExpr] = "predicateExpr",
  [sym_varName] = "varName",
  [sym_aggId] = "aggId",
  [aux_sym_ql_repeat1] = "ql_repeat1",
  [aux_sym_moduleMember_repeat1] = "moduleMember_repeat1",
  [aux_sym_classlessPredicate_repeat1] = "classlessPredicate_repeat1",
  [aux_sym_datatypeBranches_repeat1] = "datatypeBranches_repeat1",
  [aux_sym_dataclass_repeat1] = "dataclass_repeat1",
  [aux_sym_dataclass_repeat2] = "dataclass_repeat2",
  [aux_sym_higherOrderTerm_repeat1] = "higherOrderTerm_repeat1",
  [aux_sym_higherOrderTerm_repeat2] = "higherOrderTerm_repeat2",
  [aux_sym_aggregate_repeat1] = "aggregate_repeat1",
  [aux_sym_asExprs_repeat1] = "asExprs_repeat1",
  [aux_sym_orderBys_repeat1] = "orderBys_repeat1",
  [aux_sym_annotation_repeat1] = "annotation_repeat1",
  [aux_sym_qualModuleExpr_repeat1] = "qualModuleExpr_repeat1",
  [aux_sym_importModuleExpr_repeat1] = "importModuleExpr_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__lower_id] = sym__lower_id,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_where] = anon_sym_where,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_implies] = anon_sym_implies,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_order] = anon_sym_order,
  [anon_sym_by] = anon_sym_by,
  [sym_qldoc] = sym_qldoc,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_string] = anon_sym_string,
  [sym__upper_id] = sym__upper_id,
  [sym__at_lower_id] = sym__at_lower_id,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [sym_string] = sym_string,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_any] = sym_any,
  [sym_as] = sym_as,
  [sym_asc] = sym_asc,
  [sym_avg] = sym_avg,
  [sym_boolean] = sym_boolean,
  [sym_class] = sym_class,
  [sym_newtype] = sym_newtype,
  [sym_count] = sym_count,
  [sym_date] = sym_date,
  [sym_desc] = sym_desc,
  [sym_exists] = sym_exists,
  [sym_extends] = sym_extends,
  [sym_false] = sym_false,
  [sym_forall] = sym_forall,
  [sym_forex] = sym_forex,
  [sym_import] = sym_import,
  [sym_in] = sym_in,
  [sym_instanceof] = sym_instanceof,
  [sym_max] = sym_max,
  [sym_min] = sym_min,
  [sym_not] = sym_not,
  [sym_none] = sym_none,
  [sym_predicate] = sym_predicate,
  [sym_rank] = sym_rank,
  [sym_result] = sym_result,
  [sym_strictcount] = sym_strictcount,
  [sym_strictsum] = sym_strictsum,
  [sym_strictconcat] = sym_strictconcat,
  [sym_concat] = sym_concat,
  [sym_sum] = sym_sum,
  [sym_super] = sym_super,
  [sym_this] = sym_this,
  [sym_true] = sym_true,
  [sym_lt] = sym_lt,
  [sym_le] = sym_le,
  [sym_eq] = sym_eq,
  [sym_gt] = sym_gt,
  [sym_ge] = sym_ge,
  [sym_underscore] = sym_underscore,
  [sym_minus] = sym_minus,
  [sym_ne] = sym_ne,
  [sym_slash] = sym_slash,
  [sym_star] = sym_star,
  [sym_mod] = sym_mod,
  [sym_plus] = sym_plus,
  [sym_ql] = sym_ql,
  [sym_module] = sym_module,
  [sym_moduleMember] = sym_moduleMember,
  [sym_imprt] = sym_imprt,
  [sym_moduleAliasBody] = sym_moduleAliasBody,
  [sym_predicateAliasBody] = sym_predicateAliasBody,
  [sym_typeAliasBody] = sym_typeAliasBody,
  [sym_classlessPredicate] = sym_classlessPredicate,
  [sym_datatype] = sym_datatype,
  [sym_datatypeBranches] = sym_datatypeBranches,
  [sym_datatypeBranch] = sym_datatypeBranch,
  [sym_select] = sym_select,
  [sym_dataclass] = sym_dataclass,
  [sym_classMember] = sym_classMember,
  [sym_charpred] = sym_charpred,
  [sym_memberPredicate] = sym_memberPredicate,
  [sym_field] = sym_field,
  [sym__optbody] = sym__optbody,
  [sym_empty] = sym_empty,
  [sym_body] = sym_body,
  [sym_higherOrderTerm] = sym_higherOrderTerm,
  [sym_special_call] = sym_special_call,
  [sym_prefix_cast] = sym_prefix_cast,
  [sym_unary_expr] = sym_unary_expr,
  [sym_mul_expr] = sym_mul_expr,
  [sym_add_expr] = sym_add_expr,
  [sym_in_expr] = sym_in_expr,
  [sym_comp_term] = sym_comp_term,
  [sym_instance_of] = sym_instance_of,
  [sym_negation] = sym_negation,
  [sym_if_term] = sym_if_term,
  [sym_conjunction] = sym_conjunction,
  [sym_disjunction] = sym_disjunction,
  [sym_implication] = sym_implication,
  [sym_quantified] = sym_quantified,
  [sym_specialId] = sym_specialId,
  [sym_quantifier] = sym_quantifier,
  [sym__call_arg] = sym__call_arg,
  [sym_qualifiedRhs] = sym_qualifiedRhs,
  [sym_classless_predicate_call] = sym_classless_predicate_call,
  [sym_qualified_expr] = sym_qualified_expr,
  [sym_super_ref] = sym_super_ref,
  [sym_full_aggregate_body] = sym_full_aggregate_body,
  [sym_expr_aggregate_body] = sym_expr_aggregate_body,
  [sym_aggregate] = sym_aggregate,
  [sym_range] = sym_range,
  [sym_par_expr] = sym_par_expr,
  [sym__exprOrTerm] = sym__exprOrTerm,
  [sym__primary] = sym__primary,
  [sym_literal] = sym_literal,
  [sym_bool] = sym_bool,
  [sym_variable] = sym_variable,
  [sym_compop] = sym_compop,
  [sym_unop] = sym_unop,
  [sym_mulop] = sym_mulop,
  [sym_addop] = sym_addop,
  [sym_closure] = sym_closure,
  [sym_direction] = sym_direction,
  [sym_varDecl] = sym_varDecl,
  [sym_asExprs] = sym_asExprs,
  [sym_asExpr] = sym_asExpr,
  [sym_orderBys] = sym_orderBys,
  [sym_orderBy] = sym_orderBy,
  [sym_literalId] = sym_literalId,
  [sym_annotation] = sym_annotation,
  [sym_annotName] = sym_annotName,
  [sym_annotArg] = sym_annotArg,
  [sym_moduleName] = sym_moduleName,
  [sym_qualModuleExpr] = sym_qualModuleExpr,
  [sym_importModuleExpr] = sym_importModuleExpr,
  [sym_moduleExpr] = sym_moduleExpr,
  [sym_typeLiteral] = sym_typeLiteral,
  [sym_simpleId] = sym_simpleId,
  [sym_className] = sym_className,
  [sym_dbtype] = sym_dbtype,
  [sym_returnType] = sym_returnType,
  [sym_typeExpr] = sym_typeExpr,
  [sym_predicateName] = sym_predicateName,
  [sym_aritylessPredicateExpr] = sym_aritylessPredicateExpr,
  [sym_predicateExpr] = sym_predicateExpr,
  [sym_varName] = sym_varName,
  [sym_aggId] = sym_aggId,
  [aux_sym_ql_repeat1] = aux_sym_ql_repeat1,
  [aux_sym_moduleMember_repeat1] = aux_sym_moduleMember_repeat1,
  [aux_sym_classlessPredicate_repeat1] = aux_sym_classlessPredicate_repeat1,
  [aux_sym_datatypeBranches_repeat1] = aux_sym_datatypeBranches_repeat1,
  [aux_sym_dataclass_repeat1] = aux_sym_dataclass_repeat1,
  [aux_sym_dataclass_repeat2] = aux_sym_dataclass_repeat2,
  [aux_sym_higherOrderTerm_repeat1] = aux_sym_higherOrderTerm_repeat1,
  [aux_sym_higherOrderTerm_repeat2] = aux_sym_higherOrderTerm_repeat2,
  [aux_sym_aggregate_repeat1] = aux_sym_aggregate_repeat1,
  [aux_sym_asExprs_repeat1] = aux_sym_asExprs_repeat1,
  [aux_sym_orderBys_repeat1] = aux_sym_orderBys_repeat1,
  [aux_sym_annotation_repeat1] = aux_sym_annotation_repeat1,
  [aux_sym_qualModuleExpr_repeat1] = aux_sym_qualModuleExpr_repeat1,
  [aux_sym_importModuleExpr_repeat1] = aux_sym_importModuleExpr_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__lower_id] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_where] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_order] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_by] = {
    .visible = true,
    .named = false,
  },
  [sym_qldoc] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [sym__upper_id] = {
    .visible = false,
    .named = true,
  },
  [sym__at_lower_id] = {
    .visible = false,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_any] = {
    .visible = true,
    .named = true,
  },
  [sym_as] = {
    .visible = true,
    .named = true,
  },
  [sym_asc] = {
    .visible = true,
    .named = true,
  },
  [sym_avg] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_newtype] = {
    .visible = true,
    .named = true,
  },
  [sym_count] = {
    .visible = true,
    .named = true,
  },
  [sym_date] = {
    .visible = true,
    .named = true,
  },
  [sym_desc] = {
    .visible = true,
    .named = true,
  },
  [sym_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_extends] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_forex] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof] = {
    .visible = true,
    .named = true,
  },
  [sym_max] = {
    .visible = true,
    .named = true,
  },
  [sym_min] = {
    .visible = true,
    .named = true,
  },
  [sym_not] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_rank] = {
    .visible = true,
    .named = true,
  },
  [sym_result] = {
    .visible = true,
    .named = true,
  },
  [sym_strictcount] = {
    .visible = true,
    .named = true,
  },
  [sym_strictsum] = {
    .visible = true,
    .named = true,
  },
  [sym_strictconcat] = {
    .visible = true,
    .named = true,
  },
  [sym_concat] = {
    .visible = true,
    .named = true,
  },
  [sym_sum] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_lt] = {
    .visible = true,
    .named = true,
  },
  [sym_le] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_gt] = {
    .visible = true,
    .named = true,
  },
  [sym_ge] = {
    .visible = true,
    .named = true,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_ne] = {
    .visible = true,
    .named = true,
  },
  [sym_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_ql] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleMember] = {
    .visible = true,
    .named = true,
  },
  [sym_imprt] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_typeAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_classlessPredicate] = {
    .visible = true,
    .named = true,
  },
  [sym_datatype] = {
    .visible = true,
    .named = true,
  },
  [sym_datatypeBranches] = {
    .visible = true,
    .named = true,
  },
  [sym_datatypeBranch] = {
    .visible = true,
    .named = true,
  },
  [sym_select] = {
    .visible = true,
    .named = true,
  },
  [sym_dataclass] = {
    .visible = true,
    .named = true,
  },
  [sym_classMember] = {
    .visible = true,
    .named = true,
  },
  [sym_charpred] = {
    .visible = true,
    .named = true,
  },
  [sym_memberPredicate] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__optbody] = {
    .visible = false,
    .named = true,
  },
  [sym_empty] = {
    .visible = true,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym_higherOrderTerm] = {
    .visible = true,
    .named = true,
  },
  [sym_special_call] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_mul_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_add_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_in_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_comp_term] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_of] = {
    .visible = true,
    .named = true,
  },
  [sym_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_if_term] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_implication] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified] = {
    .visible = true,
    .named = true,
  },
  [sym_specialId] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier] = {
    .visible = true,
    .named = true,
  },
  [sym__call_arg] = {
    .visible = false,
    .named = true,
  },
  [sym_qualifiedRhs] = {
    .visible = true,
    .named = true,
  },
  [sym_classless_predicate_call] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_super_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_full_aggregate_body] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_aggregate_body] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_par_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__exprOrTerm] = {
    .visible = false,
    .named = true,
  },
  [sym__primary] = {
    .visible = false,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_compop] = {
    .visible = true,
    .named = true,
  },
  [sym_unop] = {
    .visible = true,
    .named = true,
  },
  [sym_mulop] = {
    .visible = true,
    .named = true,
  },
  [sym_addop] = {
    .visible = true,
    .named = true,
  },
  [sym_closure] = {
    .visible = true,
    .named = true,
  },
  [sym_direction] = {
    .visible = true,
    .named = true,
  },
  [sym_varDecl] = {
    .visible = true,
    .named = true,
  },
  [sym_asExprs] = {
    .visible = true,
    .named = true,
  },
  [sym_asExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_orderBys] = {
    .visible = true,
    .named = true,
  },
  [sym_orderBy] = {
    .visible = true,
    .named = true,
  },
  [sym_literalId] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotName] = {
    .visible = true,
    .named = true,
  },
  [sym_annotArg] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleName] = {
    .visible = true,
    .named = true,
  },
  [sym_qualModuleExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_importModuleExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_typeLiteral] = {
    .visible = true,
    .named = true,
  },
  [sym_simpleId] = {
    .visible = true,
    .named = true,
  },
  [sym_className] = {
    .visible = true,
    .named = true,
  },
  [sym_dbtype] = {
    .visible = true,
    .named = true,
  },
  [sym_returnType] = {
    .visible = true,
    .named = true,
  },
  [sym_typeExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateName] = {
    .visible = true,
    .named = true,
  },
  [sym_aritylessPredicateExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_varName] = {
    .visible = true,
    .named = true,
  },
  [sym_aggId] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_ql_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_moduleMember_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_classlessPredicate_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_datatypeBranches_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dataclass_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dataclass_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_higherOrderTerm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_higherOrderTerm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_aggregate_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_asExprs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_orderBys_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_qualModuleExpr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_importModuleExpr_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_args = 1,
  field_cond = 2,
  field_first = 3,
  field_left = 4,
  field_lower = 5,
  field_name = 6,
  field_right = 7,
  field_second = 8,
  field_upper = 9,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_args] = "args",
  [field_cond] = "cond",
  [field_first] = "first",
  [field_left] = "left",
  [field_lower] = "lower",
  [field_name] = "name",
  [field_right] = "right",
  [field_second] = "second",
  [field_upper] = "upper",
};

static const TSFieldMapSlice ts_field_map_slices[12] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 2},
  [8] = {.index = 10, .length = 2},
  [9] = {.index = 12, .length = 3},
  [10] = {.index = 15, .length = 2},
  [11] = {.index = 17, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 1},
  [2] =
    {field_name, 1, .inherited = true},
  [3] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [5] =
    {field_name, 2},
  [6] =
    {field_left, 0},
    {field_right, 2},
  [8] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [10] =
    {field_args, 2},
    {field_name, 0},
  [12] =
    {field_args, 2},
    {field_args, 3},
    {field_name, 0},
  [15] =
    {field_lower, 1},
    {field_upper, 3},
  [17] =
    {field_cond, 1},
    {field_first, 3},
    {field_second, 5},
};

static TSSymbol ts_alias_sequences[12][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(18);
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '%') ADVANCE(53);
      if (lookahead == '(') ADVANCE(22);
      if (lookahead == ')') ADVANCE(24);
      if (lookahead == '*') ADVANCE(52);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(23);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(50);
      if (lookahead == ':') ADVANCE(12);
      if (lookahead == ';') ADVANCE(21);
      if (lookahead == '<') ADVANCE(42);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(45);
      if (lookahead == '@') ADVANCE(16);
      if (lookahead == '[') ADVANCE(27);
      if (lookahead == ']') ADVANCE(28);
      if (lookahead == '_') ADVANCE(47);
      if (lookahead == '{') ADVANCE(19);
      if (lookahead == '|') ADVANCE(25);
      if (lookahead == '}') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(32);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(33);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 3:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 4:
      if (lookahead == '*') ADVANCE(3);
      if (lookahead == '/') ADVANCE(39);
      END_STATE();
    case 5:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(41);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(30);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 12:
      if (lookahead == ':') ADVANCE(31);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(49);
      END_STATE();
    case 14:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(1);
      END_STATE();
    case 15:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      END_STATE();
    case 16:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 17:
      if (eof) ADVANCE(18);
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '%') ADVANCE(53);
      if (lookahead == '(') ADVANCE(22);
      if (lookahead == ')') ADVANCE(24);
      if (lookahead == '*') ADVANCE(52);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(23);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(51);
      if (lookahead == ':') ADVANCE(12);
      if (lookahead == ';') ADVANCE(21);
      if (lookahead == '<') ADVANCE(42);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(45);
      if (lookahead == '@') ADVANCE(16);
      if (lookahead == '[') ADVANCE(27);
      if (lookahead == ']') ADVANCE(28);
      if (lookahead == '_') ADVANCE(47);
      if (lookahead == '{') ADVANCE(19);
      if (lookahead == '|') ADVANCE(25);
      if (lookahead == '}') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(32);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(33);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(29);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_qldoc);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym__upper_id);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym__lower_id);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(33);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym__at_lower_id);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_block_comment);
      if (lookahead == '*') ADVANCE(6);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_lt);
      if (lookahead == '=') ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_le);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_eq);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_ge);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_underscore);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_minus);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_ne);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_slash);
      if (lookahead == '*') ADVANCE(2);
      if (lookahead == '/') ADVANCE(39);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_slash);
      if (lookahead == '*') ADVANCE(3);
      if (lookahead == '/') ADVANCE(39);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_star);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_mod);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_plus);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'm') ADVANCE(8);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(10);
      if (lookahead == 'p') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'w') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 's') ADVANCE(17);
      if (lookahead == 'v') ADVANCE(18);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(19);
      if (lookahead == 'y') ADVANCE(20);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(23);
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(25);
      if (lookahead == 'x') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(27);
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(31);
      if (lookahead == 'm') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(41);
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(48);
      END_STATE();
    case 16:
      if (lookahead == 'd') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(sym_as);
      if (lookahead == 'c') ADVANCE(51);
      END_STATE();
    case 18:
      if (lookahead == 'g') ADVANCE(52);
      END_STATE();
    case 19:
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_by);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 28:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 29:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 32:
      if (lookahead == 'p') ADVANCE(66);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym_in);
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 34:
      if (lookahead == 'x') ADVANCE(69);
      END_STATE();
    case 35:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 36:
      if (lookahead == 'd') ADVANCE(71);
      END_STATE();
    case 37:
      if (lookahead == 'w') ADVANCE(72);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(73);
      if (lookahead == 't') ADVANCE(74);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'd') ADVANCE(75);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 42:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 43:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 44:
      if (lookahead == 'r') ADVANCE(80);
      END_STATE();
    case 45:
      if (lookahead == 'm') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(83);
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(85);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_any);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_asc);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_avg);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(87);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 55:
      if (lookahead == 'c') ADVANCE(89);
      END_STATE();
    case 56:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 58:
      if (lookahead == 'c') ADVANCE(92);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 60:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(97);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(98);
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 65:
      if (lookahead == 'm') ADVANCE(100);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(101);
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_max);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_min);
      END_STATE();
    case 71:
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_not);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 76:
      if (lookahead == 'd') ADVANCE(108);
      END_STATE();
    case 77:
      if (lookahead == 'k') ADVANCE(109);
      END_STATE();
    case 78:
      if (lookahead == 'u') ADVANCE(110);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 80:
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_sum);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(119);
      END_STATE();
    case 89:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_date);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_desc);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(123);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 97:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(126);
      END_STATE();
    case 99:
      if (lookahead == 'x') ADVANCE(127);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(131);
      END_STATE();
    case 105:
      if (lookahead == 'y') ADVANCE(132);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 107:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 108:
      if (lookahead == 'i') ADVANCE(134);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_rank);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(135);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(136);
      END_STATE();
    case 112:
      if (lookahead == 'c') ADVANCE(137);
      if (lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(139);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(140);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_class);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_count);
      END_STATE();
    case 122:
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(144);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_forex);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(146);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 132:
      if (lookahead == 'p') ADVANCE(150);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_order);
      END_STATE();
    case 134:
      if (lookahead == 'c') ADVANCE(151);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(153);
      END_STATE();
    case 137:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 138:
      if (lookahead == 'g') ADVANCE(155);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_where);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_concat);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_exists);
      END_STATE();
    case 144:
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_forall);
      END_STATE();
    case 146:
      if (lookahead == 's') ADVANCE(158);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_import);
      END_STATE();
    case 148:
      if (lookahead == 'c') ADVANCE(159);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(160);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(161);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_result);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 154:
      if (lookahead == 'c') ADVANCE(162);
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_boolean);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_extends);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_implies);
      END_STATE();
    case 159:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_newtype);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 162:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 163:
      if (lookahead == 'u') ADVANCE(167);
      END_STATE();
    case 164:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 166:
      if (lookahead == 'n') ADVANCE(170);
      if (lookahead == 'u') ADVANCE(171);
      END_STATE();
    case 167:
      if (lookahead == 'm') ADVANCE(172);
      END_STATE();
    case 168:
      if (lookahead == 'f') ADVANCE(173);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_predicate);
      END_STATE();
    case 170:
      if (lookahead == 'c') ADVANCE(174);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(175);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_strictsum);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_instanceof);
      END_STATE();
    case 174:
      if (lookahead == 'a') ADVANCE(176);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_strictcount);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_strictconcat);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 17},
  [3] = {.lex_state = 17},
  [4] = {.lex_state = 17},
  [5] = {.lex_state = 17},
  [6] = {.lex_state = 17},
  [7] = {.lex_state = 17},
  [8] = {.lex_state = 17},
  [9] = {.lex_state = 17},
  [10] = {.lex_state = 17},
  [11] = {.lex_state = 17},
  [12] = {.lex_state = 17},
  [13] = {.lex_state = 17},
  [14] = {.lex_state = 17},
  [15] = {.lex_state = 17},
  [16] = {.lex_state = 17},
  [17] = {.lex_state = 17},
  [18] = {.lex_state = 17},
  [19] = {.lex_state = 17},
  [20] = {.lex_state = 17},
  [21] = {.lex_state = 17},
  [22] = {.lex_state = 17},
  [23] = {.lex_state = 17},
  [24] = {.lex_state = 17},
  [25] = {.lex_state = 17},
  [26] = {.lex_state = 17},
  [27] = {.lex_state = 17},
  [28] = {.lex_state = 17},
  [29] = {.lex_state = 17},
  [30] = {.lex_state = 17},
  [31] = {.lex_state = 17},
  [32] = {.lex_state = 17},
  [33] = {.lex_state = 17},
  [34] = {.lex_state = 17},
  [35] = {.lex_state = 17},
  [36] = {.lex_state = 17},
  [37] = {.lex_state = 17},
  [38] = {.lex_state = 17},
  [39] = {.lex_state = 17},
  [40] = {.lex_state = 17},
  [41] = {.lex_state = 17},
  [42] = {.lex_state = 17},
  [43] = {.lex_state = 17},
  [44] = {.lex_state = 17},
  [45] = {.lex_state = 17},
  [46] = {.lex_state = 17},
  [47] = {.lex_state = 17},
  [48] = {.lex_state = 17},
  [49] = {.lex_state = 17},
  [50] = {.lex_state = 17},
  [51] = {.lex_state = 17},
  [52] = {.lex_state = 17},
  [53] = {.lex_state = 17},
  [54] = {.lex_state = 17},
  [55] = {.lex_state = 17},
  [56] = {.lex_state = 17},
  [57] = {.lex_state = 17},
  [58] = {.lex_state = 17},
  [59] = {.lex_state = 17},
  [60] = {.lex_state = 17},
  [61] = {.lex_state = 17},
  [62] = {.lex_state = 17},
  [63] = {.lex_state = 17},
  [64] = {.lex_state = 17},
  [65] = {.lex_state = 17},
  [66] = {.lex_state = 17},
  [67] = {.lex_state = 17},
  [68] = {.lex_state = 17},
  [69] = {.lex_state = 17},
  [70] = {.lex_state = 17},
  [71] = {.lex_state = 17},
  [72] = {.lex_state = 17},
  [73] = {.lex_state = 17},
  [74] = {.lex_state = 17},
  [75] = {.lex_state = 17},
  [76] = {.lex_state = 17},
  [77] = {.lex_state = 17},
  [78] = {.lex_state = 17},
  [79] = {.lex_state = 17},
  [80] = {.lex_state = 17},
  [81] = {.lex_state = 17},
  [82] = {.lex_state = 17},
  [83] = {.lex_state = 17},
  [84] = {.lex_state = 17},
  [85] = {.lex_state = 17},
  [86] = {.lex_state = 17},
  [87] = {.lex_state = 17},
  [88] = {.lex_state = 17},
  [89] = {.lex_state = 17},
  [90] = {.lex_state = 17},
  [91] = {.lex_state = 17},
  [92] = {.lex_state = 17},
  [93] = {.lex_state = 17},
  [94] = {.lex_state = 17},
  [95] = {.lex_state = 17},
  [96] = {.lex_state = 17},
  [97] = {.lex_state = 17},
  [98] = {.lex_state = 17},
  [99] = {.lex_state = 17},
  [100] = {.lex_state = 17},
  [101] = {.lex_state = 17},
  [102] = {.lex_state = 17},
  [103] = {.lex_state = 17},
  [104] = {.lex_state = 17},
  [105] = {.lex_state = 17},
  [106] = {.lex_state = 17},
  [107] = {.lex_state = 17},
  [108] = {.lex_state = 17},
  [109] = {.lex_state = 17},
  [110] = {.lex_state = 17},
  [111] = {.lex_state = 17},
  [112] = {.lex_state = 17},
  [113] = {.lex_state = 17},
  [114] = {.lex_state = 17},
  [115] = {.lex_state = 17},
  [116] = {.lex_state = 17},
  [117] = {.lex_state = 17},
  [118] = {.lex_state = 17},
  [119] = {.lex_state = 17},
  [120] = {.lex_state = 17},
  [121] = {.lex_state = 17},
  [122] = {.lex_state = 17},
  [123] = {.lex_state = 17},
  [124] = {.lex_state = 17},
  [125] = {.lex_state = 17},
  [126] = {.lex_state = 17},
  [127] = {.lex_state = 17},
  [128] = {.lex_state = 17},
  [129] = {.lex_state = 17},
  [130] = {.lex_state = 17},
  [131] = {.lex_state = 17},
  [132] = {.lex_state = 17},
  [133] = {.lex_state = 17},
  [134] = {.lex_state = 17},
  [135] = {.lex_state = 17},
  [136] = {.lex_state = 17},
  [137] = {.lex_state = 17},
  [138] = {.lex_state = 17},
  [139] = {.lex_state = 17},
  [140] = {.lex_state = 17},
  [141] = {.lex_state = 17},
  [142] = {.lex_state = 17},
  [143] = {.lex_state = 17},
  [144] = {.lex_state = 17},
  [145] = {.lex_state = 17},
  [146] = {.lex_state = 17},
  [147] = {.lex_state = 17},
  [148] = {.lex_state = 17},
  [149] = {.lex_state = 17},
  [150] = {.lex_state = 17},
  [151] = {.lex_state = 17},
  [152] = {.lex_state = 17},
  [153] = {.lex_state = 17},
  [154] = {.lex_state = 17},
  [155] = {.lex_state = 17},
  [156] = {.lex_state = 17},
  [157] = {.lex_state = 17},
  [158] = {.lex_state = 17},
  [159] = {.lex_state = 17},
  [160] = {.lex_state = 17},
  [161] = {.lex_state = 17},
  [162] = {.lex_state = 17},
  [163] = {.lex_state = 17},
  [164] = {.lex_state = 17},
  [165] = {.lex_state = 17},
  [166] = {.lex_state = 17},
  [167] = {.lex_state = 17},
  [168] = {.lex_state = 17},
  [169] = {.lex_state = 17},
  [170] = {.lex_state = 17},
  [171] = {.lex_state = 17},
  [172] = {.lex_state = 17},
  [173] = {.lex_state = 17},
  [174] = {.lex_state = 17},
  [175] = {.lex_state = 17},
  [176] = {.lex_state = 17},
  [177] = {.lex_state = 17},
  [178] = {.lex_state = 17},
  [179] = {.lex_state = 17},
  [180] = {.lex_state = 17},
  [181] = {.lex_state = 17},
  [182] = {.lex_state = 17},
  [183] = {.lex_state = 17},
  [184] = {.lex_state = 17},
  [185] = {.lex_state = 17},
  [186] = {.lex_state = 17},
  [187] = {.lex_state = 17},
  [188] = {.lex_state = 17},
  [189] = {.lex_state = 17},
  [190] = {.lex_state = 17},
  [191] = {.lex_state = 17},
  [192] = {.lex_state = 17},
  [193] = {.lex_state = 17},
  [194] = {.lex_state = 17},
  [195] = {.lex_state = 17},
  [196] = {.lex_state = 17},
  [197] = {.lex_state = 17},
  [198] = {.lex_state = 17},
  [199] = {.lex_state = 17},
  [200] = {.lex_state = 17},
  [201] = {.lex_state = 17},
  [202] = {.lex_state = 17},
  [203] = {.lex_state = 17},
  [204] = {.lex_state = 17},
  [205] = {.lex_state = 17},
  [206] = {.lex_state = 17},
  [207] = {.lex_state = 17},
  [208] = {.lex_state = 17},
  [209] = {.lex_state = 17},
  [210] = {.lex_state = 17},
  [211] = {.lex_state = 17},
  [212] = {.lex_state = 17},
  [213] = {.lex_state = 17},
  [214] = {.lex_state = 17},
  [215] = {.lex_state = 17},
  [216] = {.lex_state = 17},
  [217] = {.lex_state = 17},
  [218] = {.lex_state = 17},
  [219] = {.lex_state = 17},
  [220] = {.lex_state = 17},
  [221] = {.lex_state = 17},
  [222] = {.lex_state = 17},
  [223] = {.lex_state = 17},
  [224] = {.lex_state = 17},
  [225] = {.lex_state = 17},
  [226] = {.lex_state = 17},
  [227] = {.lex_state = 17},
  [228] = {.lex_state = 17},
  [229] = {.lex_state = 17},
  [230] = {.lex_state = 17},
  [231] = {.lex_state = 17},
  [232] = {.lex_state = 17},
  [233] = {.lex_state = 17},
  [234] = {.lex_state = 17},
  [235] = {.lex_state = 17},
  [236] = {.lex_state = 17},
  [237] = {.lex_state = 17},
  [238] = {.lex_state = 17},
  [239] = {.lex_state = 17},
  [240] = {.lex_state = 17},
  [241] = {.lex_state = 17},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 17},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 0},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 0},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 17},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 17},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 17},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 17},
  [466] = {.lex_state = 17},
  [467] = {.lex_state = 17},
  [468] = {.lex_state = 17},
  [469] = {.lex_state = 17},
  [470] = {.lex_state = 17},
  [471] = {.lex_state = 17},
  [472] = {.lex_state = 17},
  [473] = {.lex_state = 17},
  [474] = {.lex_state = 17},
  [475] = {.lex_state = 17},
  [476] = {.lex_state = 17},
  [477] = {.lex_state = 17},
  [478] = {.lex_state = 17},
  [479] = {.lex_state = 17},
  [480] = {.lex_state = 17},
  [481] = {.lex_state = 17},
  [482] = {.lex_state = 17},
  [483] = {.lex_state = 17},
  [484] = {.lex_state = 17},
  [485] = {.lex_state = 17},
  [486] = {.lex_state = 17},
  [487] = {.lex_state = 17},
  [488] = {.lex_state = 17},
  [489] = {.lex_state = 17},
  [490] = {.lex_state = 17},
  [491] = {.lex_state = 17},
  [492] = {.lex_state = 17},
  [493] = {.lex_state = 17},
  [494] = {.lex_state = 17},
  [495] = {.lex_state = 17},
  [496] = {.lex_state = 17},
  [497] = {.lex_state = 17},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 17},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 17},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 17},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 17},
  [509] = {.lex_state = 17},
  [510] = {.lex_state = 17},
  [511] = {.lex_state = 17},
  [512] = {.lex_state = 17},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 17},
  [516] = {.lex_state = 17},
  [517] = {.lex_state = 17},
  [518] = {.lex_state = 17},
  [519] = {.lex_state = 17},
  [520] = {.lex_state = 17},
  [521] = {.lex_state = 17},
  [522] = {.lex_state = 17},
  [523] = {.lex_state = 17},
  [524] = {.lex_state = 17},
  [525] = {.lex_state = 17},
  [526] = {.lex_state = 17},
  [527] = {.lex_state = 17},
  [528] = {.lex_state = 17},
  [529] = {.lex_state = 17},
  [530] = {.lex_state = 17},
  [531] = {.lex_state = 17},
  [532] = {.lex_state = 17},
  [533] = {.lex_state = 17},
  [534] = {.lex_state = 17},
  [535] = {.lex_state = 17},
  [536] = {.lex_state = 17},
  [537] = {.lex_state = 17},
  [538] = {.lex_state = 17},
  [539] = {.lex_state = 17},
  [540] = {.lex_state = 17},
  [541] = {.lex_state = 17},
  [542] = {.lex_state = 17},
  [543] = {.lex_state = 17},
  [544] = {.lex_state = 17},
  [545] = {.lex_state = 17},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 17},
  [548] = {.lex_state = 17},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 17},
  [551] = {.lex_state = 17},
  [552] = {.lex_state = 17},
  [553] = {.lex_state = 17},
  [554] = {.lex_state = 17},
  [555] = {.lex_state = 17},
  [556] = {.lex_state = 17},
  [557] = {.lex_state = 17},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 17},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 17},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 17},
  [566] = {.lex_state = 17},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 17},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 17},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 17},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 17},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 17},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 17},
  [586] = {.lex_state = 17},
  [587] = {.lex_state = 17},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 17},
  [590] = {.lex_state = 17},
  [591] = {.lex_state = 17},
  [592] = {.lex_state = 17},
  [593] = {.lex_state = 17},
  [594] = {.lex_state = 17},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 17},
  [601] = {.lex_state = 17},
  [602] = {.lex_state = 17},
  [603] = {.lex_state = 17},
  [604] = {.lex_state = 17},
  [605] = {.lex_state = 17},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 17},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 17},
  [613] = {.lex_state = 17},
  [614] = {.lex_state = 17},
  [615] = {.lex_state = 17},
  [616] = {.lex_state = 17},
  [617] = {.lex_state = 17},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 17},
  [620] = {.lex_state = 17},
  [621] = {.lex_state = 17},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 17},
  [624] = {.lex_state = 17},
  [625] = {.lex_state = 17},
  [626] = {.lex_state = 17},
  [627] = {.lex_state = 17},
  [628] = {.lex_state = 17},
  [629] = {.lex_state = 17},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 17},
  [633] = {.lex_state = 17},
  [634] = {.lex_state = 17},
  [635] = {.lex_state = 17},
  [636] = {.lex_state = 17},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 17},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 17},
  [641] = {.lex_state = 17},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 17},
  [644] = {.lex_state = 17},
  [645] = {.lex_state = 17},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 17},
  [649] = {.lex_state = 17},
  [650] = {.lex_state = 17},
  [651] = {.lex_state = 17},
  [652] = {.lex_state = 17},
  [653] = {.lex_state = 17},
  [654] = {.lex_state = 17},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 17},
  [657] = {.lex_state = 17},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 17},
  [660] = {.lex_state = 17},
  [661] = {.lex_state = 17},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 17},
  [665] = {.lex_state = 17},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 17},
  [668] = {.lex_state = 17},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 17},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 17},
  [673] = {.lex_state = 17},
  [674] = {.lex_state = 17},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 17},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 17},
  [680] = {.lex_state = 17},
  [681] = {.lex_state = 17},
  [682] = {.lex_state = 17},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 17},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 17},
  [688] = {.lex_state = 17},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 17},
  [692] = {.lex_state = 17},
  [693] = {.lex_state = 17},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 17},
  [699] = {.lex_state = 17},
  [700] = {.lex_state = 17},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 17},
  [704] = {.lex_state = 17},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 17},
  [707] = {.lex_state = 17},
  [708] = {.lex_state = 17},
  [709] = {.lex_state = 17},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 17},
  [712] = {.lex_state = 17},
  [713] = {.lex_state = 17},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 17},
  [716] = {.lex_state = 17},
  [717] = {.lex_state = 17},
  [718] = {.lex_state = 17},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 17},
  [721] = {.lex_state = 17},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 17},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 17},
  [727] = {.lex_state = 17},
  [728] = {.lex_state = 17},
  [729] = {.lex_state = 17},
  [730] = {.lex_state = 17},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 17},
  [733] = {.lex_state = 17},
  [734] = {.lex_state = 17},
  [735] = {.lex_state = 17},
  [736] = {.lex_state = 17},
  [737] = {.lex_state = 17},
  [738] = {.lex_state = 17},
  [739] = {.lex_state = 17},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 17},
  [743] = {.lex_state = 17},
  [744] = {.lex_state = 17},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 17},
  [747] = {.lex_state = 17},
  [748] = {.lex_state = 17},
  [749] = {.lex_state = 17},
  [750] = {.lex_state = 17},
  [751] = {.lex_state = 17},
  [752] = {.lex_state = 17},
  [753] = {.lex_state = 17},
  [754] = {.lex_state = 17},
  [755] = {.lex_state = 17},
  [756] = {.lex_state = 17},
  [757] = {.lex_state = 17},
  [758] = {.lex_state = 17},
  [759] = {.lex_state = 17},
  [760] = {.lex_state = 17},
  [761] = {.lex_state = 17},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 17},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 17},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 17},
  [857] = {.lex_state = 17},
  [858] = {.lex_state = 17},
  [859] = {.lex_state = 17},
  [860] = {.lex_state = 17},
  [861] = {.lex_state = 17},
  [862] = {.lex_state = 17},
  [863] = {.lex_state = 17},
  [864] = {.lex_state = 17},
  [865] = {.lex_state = 17},
  [866] = {.lex_state = 17},
  [867] = {.lex_state = 17},
  [868] = {.lex_state = 17},
  [869] = {.lex_state = 17},
  [870] = {.lex_state = 17},
  [871] = {.lex_state = 17},
  [872] = {.lex_state = 17},
  [873] = {.lex_state = 17},
  [874] = {.lex_state = 17},
  [875] = {.lex_state = 17},
  [876] = {.lex_state = 17},
  [877] = {.lex_state = 17},
  [878] = {.lex_state = 17},
  [879] = {.lex_state = 17},
  [880] = {.lex_state = 17},
  [881] = {.lex_state = 17},
  [882] = {.lex_state = 17},
  [883] = {.lex_state = 17},
  [884] = {.lex_state = 17},
  [885] = {.lex_state = 17},
  [886] = {.lex_state = 17},
  [887] = {.lex_state = 17},
  [888] = {.lex_state = 17},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 17},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 17},
  [899] = {.lex_state = 17},
  [900] = {.lex_state = 17},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 17},
  [903] = {.lex_state = 17},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 17},
  [906] = {.lex_state = 17},
  [907] = {.lex_state = 17},
  [908] = {.lex_state = 17},
  [909] = {.lex_state = 17},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 17},
  [912] = {.lex_state = 17},
  [913] = {.lex_state = 17},
  [914] = {.lex_state = 17},
  [915] = {.lex_state = 17},
  [916] = {.lex_state = 17},
  [917] = {.lex_state = 17},
  [918] = {.lex_state = 17},
  [919] = {.lex_state = 17},
  [920] = {.lex_state = 17},
  [921] = {.lex_state = 17},
  [922] = {.lex_state = 17},
  [923] = {.lex_state = 17},
  [924] = {.lex_state = 17},
  [925] = {.lex_state = 17},
  [926] = {.lex_state = 17},
  [927] = {.lex_state = 17},
  [928] = {.lex_state = 17},
  [929] = {.lex_state = 17},
  [930] = {.lex_state = 17},
  [931] = {.lex_state = 17},
  [932] = {.lex_state = 17},
  [933] = {.lex_state = 17},
  [934] = {.lex_state = 17},
  [935] = {.lex_state = 17},
  [936] = {.lex_state = 17},
  [937] = {.lex_state = 17},
  [938] = {.lex_state = 17},
  [939] = {.lex_state = 17},
  [940] = {.lex_state = 17},
  [941] = {.lex_state = 17},
  [942] = {.lex_state = 17},
  [943] = {.lex_state = 17},
  [944] = {.lex_state = 17},
  [945] = {.lex_state = 17},
  [946] = {.lex_state = 17},
  [947] = {.lex_state = 17},
  [948] = {.lex_state = 17},
  [949] = {.lex_state = 17},
  [950] = {.lex_state = 17},
  [951] = {.lex_state = 17},
  [952] = {.lex_state = 17},
  [953] = {.lex_state = 17},
  [954] = {.lex_state = 17},
  [955] = {.lex_state = 17},
  [956] = {.lex_state = 17},
  [957] = {.lex_state = 17},
  [958] = {.lex_state = 17},
  [959] = {.lex_state = 17},
  [960] = {.lex_state = 17},
  [961] = {.lex_state = 17},
  [962] = {.lex_state = 17},
  [963] = {.lex_state = 17},
  [964] = {.lex_state = 17},
  [965] = {.lex_state = 17},
  [966] = {.lex_state = 17},
  [967] = {.lex_state = 17},
  [968] = {.lex_state = 17},
  [969] = {.lex_state = 17},
  [970] = {.lex_state = 17},
  [971] = {.lex_state = 17},
  [972] = {.lex_state = 17},
  [973] = {.lex_state = 17},
  [974] = {.lex_state = 17},
  [975] = {.lex_state = 17},
  [976] = {.lex_state = 17},
  [977] = {.lex_state = 17},
  [978] = {.lex_state = 17},
  [979] = {.lex_state = 17},
  [980] = {.lex_state = 17},
  [981] = {.lex_state = 17},
  [982] = {.lex_state = 17},
  [983] = {.lex_state = 17},
  [984] = {.lex_state = 17},
  [985] = {.lex_state = 17},
  [986] = {.lex_state = 17},
  [987] = {.lex_state = 17},
  [988] = {.lex_state = 17},
  [989] = {.lex_state = 17},
  [990] = {.lex_state = 17},
  [991] = {.lex_state = 17},
  [992] = {.lex_state = 17},
  [993] = {.lex_state = 17},
  [994] = {.lex_state = 17},
  [995] = {.lex_state = 17},
  [996] = {.lex_state = 17},
  [997] = {.lex_state = 17},
  [998] = {.lex_state = 17},
  [999] = {.lex_state = 17},
  [1000] = {.lex_state = 17},
  [1001] = {.lex_state = 17},
  [1002] = {.lex_state = 17},
  [1003] = {.lex_state = 17},
  [1004] = {.lex_state = 17},
  [1005] = {.lex_state = 17},
  [1006] = {.lex_state = 17},
  [1007] = {.lex_state = 17},
  [1008] = {.lex_state = 17},
  [1009] = {.lex_state = 17},
  [1010] = {.lex_state = 17},
  [1011] = {.lex_state = 17},
  [1012] = {.lex_state = 17},
  [1013] = {.lex_state = 17},
  [1014] = {.lex_state = 17},
  [1015] = {.lex_state = 17},
  [1016] = {.lex_state = 17},
  [1017] = {.lex_state = 17},
  [1018] = {.lex_state = 17},
  [1019] = {.lex_state = 17},
  [1020] = {.lex_state = 17},
  [1021] = {.lex_state = 17},
  [1022] = {.lex_state = 17},
  [1023] = {.lex_state = 17},
  [1024] = {.lex_state = 17},
  [1025] = {.lex_state = 17},
  [1026] = {.lex_state = 17},
  [1027] = {.lex_state = 17},
  [1028] = {.lex_state = 17},
  [1029] = {.lex_state = 17},
  [1030] = {.lex_state = 17},
  [1031] = {.lex_state = 17},
  [1032] = {.lex_state = 17},
  [1033] = {.lex_state = 17},
  [1034] = {.lex_state = 17},
  [1035] = {.lex_state = 17},
  [1036] = {.lex_state = 17},
  [1037] = {.lex_state = 17},
  [1038] = {.lex_state = 17},
  [1039] = {.lex_state = 17},
  [1040] = {.lex_state = 17},
  [1041] = {.lex_state = 17},
  [1042] = {.lex_state = 17},
  [1043] = {.lex_state = 17},
  [1044] = {.lex_state = 17},
  [1045] = {.lex_state = 17},
  [1046] = {.lex_state = 17},
  [1047] = {.lex_state = 17},
  [1048] = {.lex_state = 17},
  [1049] = {.lex_state = 17},
  [1050] = {.lex_state = 17},
  [1051] = {.lex_state = 17},
  [1052] = {.lex_state = 17},
  [1053] = {.lex_state = 17},
  [1054] = {.lex_state = 17},
  [1055] = {.lex_state = 17},
  [1056] = {.lex_state = 17},
  [1057] = {.lex_state = 17},
  [1058] = {.lex_state = 17},
  [1059] = {.lex_state = 17},
  [1060] = {.lex_state = 17},
  [1061] = {.lex_state = 17},
  [1062] = {.lex_state = 17},
  [1063] = {.lex_state = 17},
  [1064] = {.lex_state = 17},
  [1065] = {.lex_state = 17},
  [1066] = {.lex_state = 17},
  [1067] = {.lex_state = 17},
  [1068] = {.lex_state = 17},
  [1069] = {.lex_state = 17},
  [1070] = {.lex_state = 17},
  [1071] = {.lex_state = 17},
  [1072] = {.lex_state = 17},
  [1073] = {.lex_state = 17},
  [1074] = {.lex_state = 17},
  [1075] = {.lex_state = 17},
  [1076] = {.lex_state = 17},
  [1077] = {.lex_state = 17},
  [1078] = {.lex_state = 17},
  [1079] = {.lex_state = 17},
  [1080] = {.lex_state = 17},
  [1081] = {.lex_state = 17},
  [1082] = {.lex_state = 17},
  [1083] = {.lex_state = 17},
  [1084] = {.lex_state = 17},
  [1085] = {.lex_state = 17},
  [1086] = {.lex_state = 17},
  [1087] = {.lex_state = 17},
  [1088] = {.lex_state = 17},
  [1089] = {.lex_state = 17},
  [1090] = {.lex_state = 17},
  [1091] = {.lex_state = 17},
  [1092] = {.lex_state = 17},
  [1093] = {.lex_state = 17},
  [1094] = {.lex_state = 17},
  [1095] = {.lex_state = 17},
  [1096] = {.lex_state = 17},
  [1097] = {.lex_state = 17},
  [1098] = {.lex_state = 17},
  [1099] = {.lex_state = 17},
  [1100] = {.lex_state = 17},
  [1101] = {.lex_state = 17},
  [1102] = {.lex_state = 17},
  [1103] = {.lex_state = 17},
  [1104] = {.lex_state = 17},
  [1105] = {.lex_state = 17},
  [1106] = {.lex_state = 17},
  [1107] = {.lex_state = 17},
  [1108] = {.lex_state = 17},
  [1109] = {.lex_state = 17},
  [1110] = {.lex_state = 17},
  [1111] = {.lex_state = 17},
  [1112] = {.lex_state = 17},
  [1113] = {.lex_state = 17},
  [1114] = {.lex_state = 17},
  [1115] = {.lex_state = 17},
  [1116] = {.lex_state = 17},
  [1117] = {.lex_state = 17},
  [1118] = {.lex_state = 17},
  [1119] = {.lex_state = 17},
  [1120] = {.lex_state = 17},
  [1121] = {.lex_state = 17},
  [1122] = {.lex_state = 17},
  [1123] = {.lex_state = 17},
  [1124] = {.lex_state = 17},
  [1125] = {.lex_state = 17},
  [1126] = {.lex_state = 17},
  [1127] = {.lex_state = 17},
  [1128] = {.lex_state = 17},
  [1129] = {.lex_state = 17},
  [1130] = {.lex_state = 17},
  [1131] = {.lex_state = 17},
  [1132] = {.lex_state = 17},
  [1133] = {.lex_state = 17},
  [1134] = {.lex_state = 17},
  [1135] = {.lex_state = 17},
  [1136] = {.lex_state = 17},
  [1137] = {.lex_state = 17},
  [1138] = {.lex_state = 17},
  [1139] = {.lex_state = 17},
  [1140] = {.lex_state = 17},
  [1141] = {.lex_state = 17},
  [1142] = {.lex_state = 17},
  [1143] = {.lex_state = 17},
  [1144] = {.lex_state = 17},
  [1145] = {.lex_state = 17},
  [1146] = {.lex_state = 17},
  [1147] = {.lex_state = 17},
  [1148] = {.lex_state = 17},
  [1149] = {.lex_state = 17},
  [1150] = {.lex_state = 17},
  [1151] = {.lex_state = 17},
  [1152] = {.lex_state = 17},
  [1153] = {.lex_state = 17},
  [1154] = {.lex_state = 17},
  [1155] = {.lex_state = 17},
  [1156] = {.lex_state = 17},
  [1157] = {.lex_state = 17},
  [1158] = {.lex_state = 17},
  [1159] = {.lex_state = 17},
  [1160] = {.lex_state = 17},
  [1161] = {.lex_state = 17},
  [1162] = {.lex_state = 17},
  [1163] = {.lex_state = 17},
  [1164] = {.lex_state = 17},
  [1165] = {.lex_state = 17},
  [1166] = {.lex_state = 17},
  [1167] = {.lex_state = 17},
  [1168] = {.lex_state = 17},
  [1169] = {.lex_state = 17},
  [1170] = {.lex_state = 17},
  [1171] = {.lex_state = 17},
  [1172] = {.lex_state = 17},
  [1173] = {.lex_state = 17},
  [1174] = {.lex_state = 17},
  [1175] = {.lex_state = 17},
  [1176] = {.lex_state = 17},
  [1177] = {.lex_state = 17},
  [1178] = {.lex_state = 17},
  [1179] = {.lex_state = 17},
  [1180] = {.lex_state = 17},
  [1181] = {.lex_state = 17},
  [1182] = {.lex_state = 17},
  [1183] = {.lex_state = 17},
  [1184] = {.lex_state = 17},
  [1185] = {.lex_state = 17},
  [1186] = {.lex_state = 17},
  [1187] = {.lex_state = 17},
  [1188] = {.lex_state = 17},
  [1189] = {.lex_state = 17},
  [1190] = {.lex_state = 17},
  [1191] = {.lex_state = 17},
  [1192] = {.lex_state = 17},
  [1193] = {.lex_state = 17},
  [1194] = {.lex_state = 17},
  [1195] = {.lex_state = 17},
  [1196] = {.lex_state = 17},
  [1197] = {.lex_state = 17},
  [1198] = {.lex_state = 17},
  [1199] = {.lex_state = 17},
  [1200] = {.lex_state = 17},
  [1201] = {.lex_state = 17},
  [1202] = {.lex_state = 17},
  [1203] = {.lex_state = 17},
  [1204] = {.lex_state = 17},
  [1205] = {.lex_state = 17},
  [1206] = {.lex_state = 17},
  [1207] = {.lex_state = 17},
  [1208] = {.lex_state = 17},
  [1209] = {.lex_state = 17},
  [1210] = {.lex_state = 17},
  [1211] = {.lex_state = 17},
  [1212] = {.lex_state = 17},
  [1213] = {.lex_state = 17},
  [1214] = {.lex_state = 17},
  [1215] = {.lex_state = 17},
  [1216] = {.lex_state = 17},
  [1217] = {.lex_state = 17},
  [1218] = {.lex_state = 17},
  [1219] = {.lex_state = 17},
  [1220] = {.lex_state = 17},
  [1221] = {.lex_state = 17},
  [1222] = {.lex_state = 17},
  [1223] = {.lex_state = 17},
  [1224] = {.lex_state = 17},
  [1225] = {.lex_state = 17},
  [1226] = {.lex_state = 17},
  [1227] = {.lex_state = 17},
  [1228] = {.lex_state = 17},
  [1229] = {.lex_state = 17},
  [1230] = {.lex_state = 17},
  [1231] = {.lex_state = 17},
  [1232] = {.lex_state = 17},
  [1233] = {.lex_state = 17},
  [1234] = {.lex_state = 17},
  [1235] = {.lex_state = 11},
  [1236] = {.lex_state = 17},
  [1237] = {.lex_state = 17},
  [1238] = {.lex_state = 17},
  [1239] = {.lex_state = 17},
  [1240] = {.lex_state = 17},
  [1241] = {.lex_state = 17},
  [1242] = {.lex_state = 17},
  [1243] = {.lex_state = 17},
  [1244] = {.lex_state = 17},
  [1245] = {.lex_state = 17},
  [1246] = {.lex_state = 17},
  [1247] = {.lex_state = 17},
  [1248] = {.lex_state = 17},
  [1249] = {.lex_state = 17},
  [1250] = {.lex_state = 17},
  [1251] = {.lex_state = 17},
  [1252] = {.lex_state = 17},
  [1253] = {.lex_state = 17},
  [1254] = {.lex_state = 17},
  [1255] = {.lex_state = 17},
  [1256] = {.lex_state = 17},
  [1257] = {.lex_state = 17},
  [1258] = {.lex_state = 17},
  [1259] = {.lex_state = 17},
  [1260] = {.lex_state = 17},
  [1261] = {.lex_state = 17},
  [1262] = {.lex_state = 17},
  [1263] = {.lex_state = 17},
  [1264] = {.lex_state = 17},
  [1265] = {.lex_state = 17},
  [1266] = {.lex_state = 17},
  [1267] = {.lex_state = 17},
  [1268] = {.lex_state = 17},
  [1269] = {.lex_state = 17},
  [1270] = {.lex_state = 17},
  [1271] = {.lex_state = 17},
  [1272] = {.lex_state = 17},
  [1273] = {.lex_state = 17},
  [1274] = {.lex_state = 17},
  [1275] = {.lex_state = 17},
  [1276] = {.lex_state = 17},
  [1277] = {.lex_state = 17},
  [1278] = {.lex_state = 17},
  [1279] = {.lex_state = 17},
  [1280] = {.lex_state = 17},
  [1281] = {.lex_state = 17},
  [1282] = {.lex_state = 17},
  [1283] = {.lex_state = 17},
  [1284] = {.lex_state = 17},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__lower_id] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_where] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_implies] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_order] = ACTIONS(1),
    [anon_sym_by] = ACTIONS(1),
    [sym_qldoc] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [sym__upper_id] = ACTIONS(1),
    [sym__at_lower_id] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(5),
    [sym_any] = ACTIONS(1),
    [sym_as] = ACTIONS(1),
    [sym_asc] = ACTIONS(1),
    [sym_avg] = ACTIONS(1),
    [sym_boolean] = ACTIONS(1),
    [sym_class] = ACTIONS(1),
    [sym_newtype] = ACTIONS(1),
    [sym_count] = ACTIONS(1),
    [sym_date] = ACTIONS(1),
    [sym_desc] = ACTIONS(1),
    [sym_exists] = ACTIONS(1),
    [sym_extends] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_forall] = ACTIONS(1),
    [sym_forex] = ACTIONS(1),
    [sym_import] = ACTIONS(1),
    [sym_in] = ACTIONS(1),
    [sym_instanceof] = ACTIONS(1),
    [sym_max] = ACTIONS(1),
    [sym_min] = ACTIONS(1),
    [sym_not] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_predicate] = ACTIONS(1),
    [sym_rank] = ACTIONS(1),
    [sym_result] = ACTIONS(1),
    [sym_strictcount] = ACTIONS(1),
    [sym_strictsum] = ACTIONS(1),
    [sym_strictconcat] = ACTIONS(1),
    [sym_concat] = ACTIONS(1),
    [sym_sum] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_lt] = ACTIONS(1),
    [sym_le] = ACTIONS(1),
    [sym_eq] = ACTIONS(1),
    [sym_gt] = ACTIONS(1),
    [sym_ge] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [sym_minus] = ACTIONS(1),
    [sym_ne] = ACTIONS(1),
    [sym_slash] = ACTIONS(1),
    [sym_star] = ACTIONS(1),
    [sym_mod] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
  },
  [1] = {
    [sym_ql] = STATE(1276),
    [sym_module] = STATE(855),
    [sym_moduleMember] = STATE(461),
    [sym_imprt] = STATE(855),
    [sym_classlessPredicate] = STATE(855),
    [sym_datatype] = STATE(855),
    [sym_select] = STATE(855),
    [sym_dataclass] = STATE(855),
    [sym_annotation] = STATE(471),
    [sym_annotName] = STATE(858),
    [sym_moduleExpr] = STATE(1274),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(1144),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_returnType] = STATE(1143),
    [sym_typeExpr] = STATE(1277),
    [aux_sym_ql_repeat1] = STATE(461),
    [aux_sym_moduleMember_repeat1] = STATE(471),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym__lower_id] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_where] = ACTIONS(15),
    [anon_sym_select] = ACTIONS(17),
    [sym_qldoc] = ACTIONS(19),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(23),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(5),
    [sym_boolean] = ACTIONS(21),
    [sym_class] = ACTIONS(27),
    [sym_newtype] = ACTIONS(29),
    [sym_date] = ACTIONS(21),
    [sym_import] = ACTIONS(31),
    [sym_predicate] = ACTIONS(33),
  },
  [2] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1267),
    [sym_expr_aggregate_body] = STATE(1267),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(39),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [3] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1180),
    [sym_expr_aggregate_body] = STATE(1180),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [4] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1196),
    [sym_expr_aggregate_body] = STATE(1196),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [5] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1197),
    [sym_expr_aggregate_body] = STATE(1197),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [6] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1210),
    [sym_expr_aggregate_body] = STATE(1210),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [7] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1221),
    [sym_expr_aggregate_body] = STATE(1221),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [8] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1224),
    [sym_expr_aggregate_body] = STATE(1224),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [9] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1230),
    [sym_expr_aggregate_body] = STATE(1230),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [10] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1234),
    [sym_expr_aggregate_body] = STATE(1234),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [11] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1275),
    [sym_expr_aggregate_body] = STATE(1275),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [12] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1159),
    [sym_expr_aggregate_body] = STATE(1159),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [13] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1254),
    [sym_expr_aggregate_body] = STATE(1254),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(89),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [14] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1238),
    [sym_expr_aggregate_body] = STATE(1238),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(91),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [15] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1265),
    [sym_expr_aggregate_body] = STATE(1265),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [16] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1244),
    [sym_expr_aggregate_body] = STATE(1244),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(95),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [17] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1264),
    [sym_expr_aggregate_body] = STATE(1264),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [18] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1245),
    [sym_expr_aggregate_body] = STATE(1245),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [19] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_full_aggregate_body] = STATE(1250),
    [sym_expr_aggregate_body] = STATE(1250),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_varDecl] = STATE(943),
    [sym_asExprs] = STATE(1069),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(927),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [20] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1001),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(127),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [21] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1061),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(131),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [22] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1048),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(133),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(135),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [23] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1068),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(137),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(139),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [24] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1110),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(143),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [25] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1098),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(145),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(147),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [26] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1091),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(151),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [27] = {
    [sym_special_call] = STATE(684),
    [sym_prefix_cast] = STATE(684),
    [sym_unary_expr] = STATE(684),
    [sym_mul_expr] = STATE(684),
    [sym_add_expr] = STATE(684),
    [sym_in_expr] = STATE(684),
    [sym_comp_term] = STATE(684),
    [sym_instance_of] = STATE(684),
    [sym_negation] = STATE(684),
    [sym_if_term] = STATE(684),
    [sym_conjunction] = STATE(684),
    [sym_disjunction] = STATE(684),
    [sym_implication] = STATE(684),
    [sym_quantified] = STATE(684),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(684),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_varDecl] = STATE(935),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(925),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(155),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [28] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1089),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(159),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [29] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1035),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(161),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(163),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [30] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1066),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(167),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [31] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1079),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(169),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(171),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [32] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1083),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(173),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(175),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [33] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1012),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(179),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [34] = {
    [sym_special_call] = STATE(708),
    [sym_prefix_cast] = STATE(708),
    [sym_unary_expr] = STATE(708),
    [sym_mul_expr] = STATE(708),
    [sym_add_expr] = STATE(708),
    [sym_in_expr] = STATE(708),
    [sym_comp_term] = STATE(708),
    [sym_instance_of] = STATE(708),
    [sym_negation] = STATE(708),
    [sym_if_term] = STATE(708),
    [sym_conjunction] = STATE(708),
    [sym_disjunction] = STATE(708),
    [sym_implication] = STATE(708),
    [sym_quantified] = STATE(708),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(708),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_varDecl] = STATE(930),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(925),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [35] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1078),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(187),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [36] = {
    [sym_special_call] = STATE(732),
    [sym_prefix_cast] = STATE(732),
    [sym_unary_expr] = STATE(732),
    [sym_mul_expr] = STATE(732),
    [sym_add_expr] = STATE(732),
    [sym_in_expr] = STATE(732),
    [sym_comp_term] = STATE(732),
    [sym_instance_of] = STATE(732),
    [sym_negation] = STATE(732),
    [sym_if_term] = STATE(732),
    [sym_conjunction] = STATE(732),
    [sym_disjunction] = STATE(732),
    [sym_implication] = STATE(732),
    [sym_quantified] = STATE(732),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(732),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_varDecl] = STATE(962),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(925),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(191),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [37] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1103),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(195),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [38] = {
    [sym_special_call] = STATE(756),
    [sym_prefix_cast] = STATE(756),
    [sym_unary_expr] = STATE(756),
    [sym_mul_expr] = STATE(756),
    [sym_add_expr] = STATE(756),
    [sym_in_expr] = STATE(756),
    [sym_comp_term] = STATE(756),
    [sym_instance_of] = STATE(756),
    [sym_negation] = STATE(756),
    [sym_if_term] = STATE(756),
    [sym_conjunction] = STATE(756),
    [sym_disjunction] = STATE(756),
    [sym_implication] = STATE(756),
    [sym_quantified] = STATE(756),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(756),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_varDecl] = STATE(975),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(925),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(197),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(199),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [39] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1047),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(201),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(203),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [40] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(997),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(205),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(207),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [41] = {
    [sym_special_call] = STATE(672),
    [sym_prefix_cast] = STATE(672),
    [sym_unary_expr] = STATE(672),
    [sym_mul_expr] = STATE(672),
    [sym_add_expr] = STATE(672),
    [sym_in_expr] = STATE(672),
    [sym_comp_term] = STATE(672),
    [sym_instance_of] = STATE(672),
    [sym_negation] = STATE(672),
    [sym_if_term] = STATE(672),
    [sym_conjunction] = STATE(672),
    [sym_disjunction] = STATE(672),
    [sym_implication] = STATE(672),
    [sym_quantified] = STATE(672),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(672),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_varDecl] = STATE(988),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(925),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(211),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [42] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1013),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(215),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [43] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1038),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(217),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(219),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [44] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1114),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(221),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(223),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [45] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1021),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(225),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(227),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [46] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1060),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(229),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(231),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [47] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1053),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(233),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(235),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [48] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1051),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(237),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(239),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [49] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1023),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(241),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(243),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [50] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1087),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(245),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(247),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [51] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1029),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(249),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(251),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [52] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1067),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(253),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(255),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [53] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1109),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(257),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(259),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [54] = {
    [sym_special_call] = STATE(664),
    [sym_prefix_cast] = STATE(664),
    [sym_unary_expr] = STATE(664),
    [sym_mul_expr] = STATE(664),
    [sym_add_expr] = STATE(664),
    [sym_in_expr] = STATE(664),
    [sym_comp_term] = STATE(664),
    [sym_instance_of] = STATE(664),
    [sym_negation] = STATE(664),
    [sym_if_term] = STATE(664),
    [sym_conjunction] = STATE(664),
    [sym_disjunction] = STATE(664),
    [sym_implication] = STATE(664),
    [sym_quantified] = STATE(664),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(664),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_varDecl] = STATE(931),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(925),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(261),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [55] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1042),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(267),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [56] = {
    [sym_special_call] = STATE(250),
    [sym_prefix_cast] = STATE(250),
    [sym_unary_expr] = STATE(250),
    [sym_mul_expr] = STATE(250),
    [sym_add_expr] = STATE(250),
    [sym_in_expr] = STATE(250),
    [sym_comp_term] = STATE(250),
    [sym_instance_of] = STATE(250),
    [sym_negation] = STATE(250),
    [sym_if_term] = STATE(250),
    [sym_conjunction] = STATE(250),
    [sym_disjunction] = STATE(250),
    [sym_implication] = STATE(250),
    [sym_quantified] = STATE(250),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(250),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_asExprs] = STATE(710),
    [sym_asExpr] = STATE(598),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [57] = {
    [sym_special_call] = STATE(250),
    [sym_prefix_cast] = STATE(250),
    [sym_unary_expr] = STATE(250),
    [sym_mul_expr] = STATE(250),
    [sym_add_expr] = STATE(250),
    [sym_in_expr] = STATE(250),
    [sym_comp_term] = STATE(250),
    [sym_instance_of] = STATE(250),
    [sym_negation] = STATE(250),
    [sym_if_term] = STATE(250),
    [sym_conjunction] = STATE(250),
    [sym_disjunction] = STATE(250),
    [sym_implication] = STATE(250),
    [sym_quantified] = STATE(250),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(250),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_asExprs] = STATE(671),
    [sym_asExpr] = STATE(598),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [58] = {
    [sym_special_call] = STATE(264),
    [sym_prefix_cast] = STATE(264),
    [sym_unary_expr] = STATE(264),
    [sym_mul_expr] = STATE(264),
    [sym_add_expr] = STATE(264),
    [sym_in_expr] = STATE(264),
    [sym_comp_term] = STATE(264),
    [sym_instance_of] = STATE(264),
    [sym_negation] = STATE(264),
    [sym_if_term] = STATE(264),
    [sym_conjunction] = STATE(264),
    [sym_disjunction] = STATE(264),
    [sym_implication] = STATE(264),
    [sym_quantified] = STATE(264),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(264),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_asExprs] = STATE(745),
    [sym_asExpr] = STATE(597),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [59] = {
    [sym_special_call] = STATE(264),
    [sym_prefix_cast] = STATE(264),
    [sym_unary_expr] = STATE(264),
    [sym_mul_expr] = STATE(264),
    [sym_add_expr] = STATE(264),
    [sym_in_expr] = STATE(264),
    [sym_comp_term] = STATE(264),
    [sym_instance_of] = STATE(264),
    [sym_negation] = STATE(264),
    [sym_if_term] = STATE(264),
    [sym_conjunction] = STATE(264),
    [sym_disjunction] = STATE(264),
    [sym_implication] = STATE(264),
    [sym_quantified] = STATE(264),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(264),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_asExprs] = STATE(685),
    [sym_asExpr] = STATE(597),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [60] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_asExprs] = STATE(991),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [61] = {
    [sym_special_call] = STATE(600),
    [sym_prefix_cast] = STATE(600),
    [sym_unary_expr] = STATE(600),
    [sym_mul_expr] = STATE(600),
    [sym_add_expr] = STATE(600),
    [sym_in_expr] = STATE(600),
    [sym_comp_term] = STATE(600),
    [sym_instance_of] = STATE(600),
    [sym_negation] = STATE(600),
    [sym_if_term] = STATE(600),
    [sym_conjunction] = STATE(600),
    [sym_disjunction] = STATE(600),
    [sym_implication] = STATE(600),
    [sym_quantified] = STATE(600),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(600),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(313),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(315),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [62] = {
    [sym_special_call] = STATE(264),
    [sym_prefix_cast] = STATE(264),
    [sym_unary_expr] = STATE(264),
    [sym_mul_expr] = STATE(264),
    [sym_add_expr] = STATE(264),
    [sym_in_expr] = STATE(264),
    [sym_comp_term] = STATE(264),
    [sym_instance_of] = STATE(264),
    [sym_negation] = STATE(264),
    [sym_if_term] = STATE(264),
    [sym_conjunction] = STATE(264),
    [sym_disjunction] = STATE(264),
    [sym_implication] = STATE(264),
    [sym_quantified] = STATE(264),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(264),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_asExprs] = STATE(694),
    [sym_asExpr] = STATE(597),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [63] = {
    [sym_special_call] = STATE(250),
    [sym_prefix_cast] = STATE(250),
    [sym_unary_expr] = STATE(250),
    [sym_mul_expr] = STATE(250),
    [sym_add_expr] = STATE(250),
    [sym_in_expr] = STATE(250),
    [sym_comp_term] = STATE(250),
    [sym_instance_of] = STATE(250),
    [sym_negation] = STATE(250),
    [sym_if_term] = STATE(250),
    [sym_conjunction] = STATE(250),
    [sym_disjunction] = STATE(250),
    [sym_implication] = STATE(250),
    [sym_quantified] = STATE(250),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(250),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_asExprs] = STATE(731),
    [sym_asExpr] = STATE(598),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [64] = {
    [sym_special_call] = STATE(624),
    [sym_prefix_cast] = STATE(624),
    [sym_unary_expr] = STATE(624),
    [sym_mul_expr] = STATE(624),
    [sym_add_expr] = STATE(624),
    [sym_in_expr] = STATE(624),
    [sym_comp_term] = STATE(624),
    [sym_instance_of] = STATE(624),
    [sym_negation] = STATE(624),
    [sym_if_term] = STATE(624),
    [sym_conjunction] = STATE(624),
    [sym_disjunction] = STATE(624),
    [sym_implication] = STATE(624),
    [sym_quantified] = STATE(624),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(624),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [65] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_asExprs] = STATE(1017),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [66] = {
    [sym_special_call] = STATE(645),
    [sym_prefix_cast] = STATE(645),
    [sym_unary_expr] = STATE(645),
    [sym_mul_expr] = STATE(645),
    [sym_add_expr] = STATE(645),
    [sym_in_expr] = STATE(645),
    [sym_comp_term] = STATE(645),
    [sym_instance_of] = STATE(645),
    [sym_negation] = STATE(645),
    [sym_if_term] = STATE(645),
    [sym_conjunction] = STATE(645),
    [sym_disjunction] = STATE(645),
    [sym_implication] = STATE(645),
    [sym_quantified] = STATE(645),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym__call_arg] = STATE(1145),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(645),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_underscore] = ACTIONS(321),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [67] = {
    [sym_special_call] = STATE(264),
    [sym_prefix_cast] = STATE(264),
    [sym_unary_expr] = STATE(264),
    [sym_mul_expr] = STATE(264),
    [sym_add_expr] = STATE(264),
    [sym_in_expr] = STATE(264),
    [sym_comp_term] = STATE(264),
    [sym_instance_of] = STATE(264),
    [sym_negation] = STATE(264),
    [sym_if_term] = STATE(264),
    [sym_conjunction] = STATE(264),
    [sym_disjunction] = STATE(264),
    [sym_implication] = STATE(264),
    [sym_quantified] = STATE(264),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(264),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_asExprs] = STATE(669),
    [sym_asExpr] = STATE(597),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [68] = {
    [sym_special_call] = STATE(250),
    [sym_prefix_cast] = STATE(250),
    [sym_unary_expr] = STATE(250),
    [sym_mul_expr] = STATE(250),
    [sym_add_expr] = STATE(250),
    [sym_in_expr] = STATE(250),
    [sym_comp_term] = STATE(250),
    [sym_instance_of] = STATE(250),
    [sym_negation] = STATE(250),
    [sym_if_term] = STATE(250),
    [sym_conjunction] = STATE(250),
    [sym_disjunction] = STATE(250),
    [sym_implication] = STATE(250),
    [sym_quantified] = STATE(250),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(250),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_asExprs] = STATE(690),
    [sym_asExpr] = STATE(598),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [69] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_asExprs] = STATE(1007),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [70] = {
    [sym_special_call] = STATE(264),
    [sym_prefix_cast] = STATE(264),
    [sym_unary_expr] = STATE(264),
    [sym_mul_expr] = STATE(264),
    [sym_add_expr] = STATE(264),
    [sym_in_expr] = STATE(264),
    [sym_comp_term] = STATE(264),
    [sym_instance_of] = STATE(264),
    [sym_negation] = STATE(264),
    [sym_if_term] = STATE(264),
    [sym_conjunction] = STATE(264),
    [sym_disjunction] = STATE(264),
    [sym_implication] = STATE(264),
    [sym_quantified] = STATE(264),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(264),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_asExprs] = STATE(722),
    [sym_asExpr] = STATE(597),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [71] = {
    [sym_special_call] = STATE(578),
    [sym_prefix_cast] = STATE(578),
    [sym_unary_expr] = STATE(578),
    [sym_mul_expr] = STATE(578),
    [sym_add_expr] = STATE(578),
    [sym_in_expr] = STATE(578),
    [sym_comp_term] = STATE(578),
    [sym_instance_of] = STATE(578),
    [sym_negation] = STATE(578),
    [sym_if_term] = STATE(578),
    [sym_conjunction] = STATE(578),
    [sym_disjunction] = STATE(578),
    [sym_implication] = STATE(578),
    [sym_quantified] = STATE(578),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(578),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_PIPE] = ACTIONS(325),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [72] = {
    [sym_special_call] = STATE(250),
    [sym_prefix_cast] = STATE(250),
    [sym_unary_expr] = STATE(250),
    [sym_mul_expr] = STATE(250),
    [sym_add_expr] = STATE(250),
    [sym_in_expr] = STATE(250),
    [sym_comp_term] = STATE(250),
    [sym_instance_of] = STATE(250),
    [sym_negation] = STATE(250),
    [sym_if_term] = STATE(250),
    [sym_conjunction] = STATE(250),
    [sym_disjunction] = STATE(250),
    [sym_implication] = STATE(250),
    [sym_quantified] = STATE(250),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(250),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_asExprs] = STATE(714),
    [sym_asExpr] = STATE(598),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [73] = {
    [sym_special_call] = STATE(264),
    [sym_prefix_cast] = STATE(264),
    [sym_unary_expr] = STATE(264),
    [sym_mul_expr] = STATE(264),
    [sym_add_expr] = STATE(264),
    [sym_in_expr] = STATE(264),
    [sym_comp_term] = STATE(264),
    [sym_instance_of] = STATE(264),
    [sym_negation] = STATE(264),
    [sym_if_term] = STATE(264),
    [sym_conjunction] = STATE(264),
    [sym_disjunction] = STATE(264),
    [sym_implication] = STATE(264),
    [sym_quantified] = STATE(264),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(264),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_asExprs] = STATE(741),
    [sym_asExpr] = STATE(597),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [74] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_asExprs] = STATE(1040),
    [sym_asExpr] = STATE(946),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [75] = {
    [sym_special_call] = STATE(250),
    [sym_prefix_cast] = STATE(250),
    [sym_unary_expr] = STATE(250),
    [sym_mul_expr] = STATE(250),
    [sym_add_expr] = STATE(250),
    [sym_in_expr] = STATE(250),
    [sym_comp_term] = STATE(250),
    [sym_instance_of] = STATE(250),
    [sym_negation] = STATE(250),
    [sym_if_term] = STATE(250),
    [sym_conjunction] = STATE(250),
    [sym_disjunction] = STATE(250),
    [sym_implication] = STATE(250),
    [sym_quantified] = STATE(250),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(250),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_asExprs] = STATE(725),
    [sym_asExpr] = STATE(598),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [76] = {
    [sym_special_call] = STATE(243),
    [sym_prefix_cast] = STATE(243),
    [sym_unary_expr] = STATE(243),
    [sym_mul_expr] = STATE(243),
    [sym_add_expr] = STATE(243),
    [sym_in_expr] = STATE(243),
    [sym_comp_term] = STATE(243),
    [sym_instance_of] = STATE(243),
    [sym_negation] = STATE(243),
    [sym_if_term] = STATE(243),
    [sym_conjunction] = STATE(243),
    [sym_disjunction] = STATE(243),
    [sym_implication] = STATE(243),
    [sym_quantified] = STATE(243),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(243),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_orderBy] = STATE(766),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [77] = {
    [sym_special_call] = STATE(242),
    [sym_prefix_cast] = STATE(242),
    [sym_unary_expr] = STATE(242),
    [sym_mul_expr] = STATE(242),
    [sym_add_expr] = STATE(242),
    [sym_in_expr] = STATE(242),
    [sym_comp_term] = STATE(242),
    [sym_instance_of] = STATE(242),
    [sym_negation] = STATE(242),
    [sym_if_term] = STATE(242),
    [sym_conjunction] = STATE(242),
    [sym_disjunction] = STATE(242),
    [sym_implication] = STATE(242),
    [sym_quantified] = STATE(242),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(242),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_orderBy] = STATE(666),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [78] = {
    [sym_special_call] = STATE(544),
    [sym_prefix_cast] = STATE(544),
    [sym_unary_expr] = STATE(544),
    [sym_mul_expr] = STATE(544),
    [sym_add_expr] = STATE(544),
    [sym_in_expr] = STATE(544),
    [sym_comp_term] = STATE(544),
    [sym_instance_of] = STATE(544),
    [sym_negation] = STATE(544),
    [sym_if_term] = STATE(544),
    [sym_conjunction] = STATE(544),
    [sym_disjunction] = STATE(544),
    [sym_implication] = STATE(544),
    [sym_quantified] = STATE(544),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(544),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_asExpr] = STATE(1024),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [79] = {
    [sym_special_call] = STATE(264),
    [sym_prefix_cast] = STATE(264),
    [sym_unary_expr] = STATE(264),
    [sym_mul_expr] = STATE(264),
    [sym_add_expr] = STATE(264),
    [sym_in_expr] = STATE(264),
    [sym_comp_term] = STATE(264),
    [sym_instance_of] = STATE(264),
    [sym_negation] = STATE(264),
    [sym_if_term] = STATE(264),
    [sym_conjunction] = STATE(264),
    [sym_disjunction] = STATE(264),
    [sym_implication] = STATE(264),
    [sym_quantified] = STATE(264),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(264),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_asExpr] = STATE(695),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [80] = {
    [sym_special_call] = STATE(530),
    [sym_prefix_cast] = STATE(530),
    [sym_unary_expr] = STATE(530),
    [sym_mul_expr] = STATE(530),
    [sym_add_expr] = STATE(530),
    [sym_in_expr] = STATE(530),
    [sym_comp_term] = STATE(530),
    [sym_instance_of] = STATE(530),
    [sym_negation] = STATE(530),
    [sym_if_term] = STATE(530),
    [sym_conjunction] = STATE(530),
    [sym_disjunction] = STATE(530),
    [sym_implication] = STATE(530),
    [sym_quantified] = STATE(530),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(530),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_orderBy] = STATE(1014),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [81] = {
    [sym_special_call] = STATE(242),
    [sym_prefix_cast] = STATE(242),
    [sym_unary_expr] = STATE(242),
    [sym_mul_expr] = STATE(242),
    [sym_add_expr] = STATE(242),
    [sym_in_expr] = STATE(242),
    [sym_comp_term] = STATE(242),
    [sym_instance_of] = STATE(242),
    [sym_negation] = STATE(242),
    [sym_if_term] = STATE(242),
    [sym_conjunction] = STATE(242),
    [sym_disjunction] = STATE(242),
    [sym_implication] = STATE(242),
    [sym_quantified] = STATE(242),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(242),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_orderBy] = STATE(762),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [82] = {
    [sym_special_call] = STATE(243),
    [sym_prefix_cast] = STATE(243),
    [sym_unary_expr] = STATE(243),
    [sym_mul_expr] = STATE(243),
    [sym_add_expr] = STATE(243),
    [sym_in_expr] = STATE(243),
    [sym_comp_term] = STATE(243),
    [sym_instance_of] = STATE(243),
    [sym_negation] = STATE(243),
    [sym_if_term] = STATE(243),
    [sym_conjunction] = STATE(243),
    [sym_disjunction] = STATE(243),
    [sym_implication] = STATE(243),
    [sym_quantified] = STATE(243),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(243),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_orderBy] = STATE(683),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [83] = {
    [sym_special_call] = STATE(530),
    [sym_prefix_cast] = STATE(530),
    [sym_unary_expr] = STATE(530),
    [sym_mul_expr] = STATE(530),
    [sym_add_expr] = STATE(530),
    [sym_in_expr] = STATE(530),
    [sym_comp_term] = STATE(530),
    [sym_instance_of] = STATE(530),
    [sym_negation] = STATE(530),
    [sym_if_term] = STATE(530),
    [sym_conjunction] = STATE(530),
    [sym_disjunction] = STATE(530),
    [sym_implication] = STATE(530),
    [sym_quantified] = STATE(530),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(530),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_orderBy] = STATE(1152),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [84] = {
    [sym_special_call] = STATE(250),
    [sym_prefix_cast] = STATE(250),
    [sym_unary_expr] = STATE(250),
    [sym_mul_expr] = STATE(250),
    [sym_add_expr] = STATE(250),
    [sym_in_expr] = STATE(250),
    [sym_comp_term] = STATE(250),
    [sym_instance_of] = STATE(250),
    [sym_negation] = STATE(250),
    [sym_if_term] = STATE(250),
    [sym_conjunction] = STATE(250),
    [sym_disjunction] = STATE(250),
    [sym_implication] = STATE(250),
    [sym_quantified] = STATE(250),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(250),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_asExpr] = STATE(662),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [85] = {
    [sym_special_call] = STATE(522),
    [sym_prefix_cast] = STATE(522),
    [sym_unary_expr] = STATE(522),
    [sym_mul_expr] = STATE(522),
    [sym_add_expr] = STATE(522),
    [sym_in_expr] = STATE(522),
    [sym_comp_term] = STATE(522),
    [sym_instance_of] = STATE(522),
    [sym_negation] = STATE(522),
    [sym_if_term] = STATE(522),
    [sym_conjunction] = STATE(522),
    [sym_disjunction] = STATE(522),
    [sym_implication] = STATE(522),
    [sym_quantified] = STATE(522),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(522),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [86] = {
    [sym_special_call] = STATE(267),
    [sym_prefix_cast] = STATE(267),
    [sym_unary_expr] = STATE(267),
    [sym_mul_expr] = STATE(267),
    [sym_add_expr] = STATE(267),
    [sym_in_expr] = STATE(267),
    [sym_comp_term] = STATE(267),
    [sym_instance_of] = STATE(267),
    [sym_negation] = STATE(267),
    [sym_if_term] = STATE(267),
    [sym_conjunction] = STATE(267),
    [sym_disjunction] = STATE(267),
    [sym_implication] = STATE(267),
    [sym_quantified] = STATE(267),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(267),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [87] = {
    [sym_special_call] = STATE(557),
    [sym_prefix_cast] = STATE(557),
    [sym_unary_expr] = STATE(557),
    [sym_mul_expr] = STATE(557),
    [sym_add_expr] = STATE(557),
    [sym_in_expr] = STATE(557),
    [sym_comp_term] = STATE(557),
    [sym_instance_of] = STATE(557),
    [sym_negation] = STATE(557),
    [sym_if_term] = STATE(557),
    [sym_conjunction] = STATE(557),
    [sym_disjunction] = STATE(557),
    [sym_implication] = STATE(557),
    [sym_quantified] = STATE(557),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(557),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [88] = {
    [sym_special_call] = STATE(717),
    [sym_prefix_cast] = STATE(717),
    [sym_unary_expr] = STATE(717),
    [sym_mul_expr] = STATE(717),
    [sym_add_expr] = STATE(717),
    [sym_in_expr] = STATE(717),
    [sym_comp_term] = STATE(717),
    [sym_instance_of] = STATE(717),
    [sym_negation] = STATE(717),
    [sym_if_term] = STATE(717),
    [sym_conjunction] = STATE(717),
    [sym_disjunction] = STATE(717),
    [sym_implication] = STATE(717),
    [sym_quantified] = STATE(717),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(717),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [89] = {
    [sym_special_call] = STATE(287),
    [sym_prefix_cast] = STATE(287),
    [sym_unary_expr] = STATE(287),
    [sym_mul_expr] = STATE(287),
    [sym_add_expr] = STATE(287),
    [sym_in_expr] = STATE(287),
    [sym_comp_term] = STATE(287),
    [sym_instance_of] = STATE(287),
    [sym_negation] = STATE(287),
    [sym_if_term] = STATE(287),
    [sym_conjunction] = STATE(287),
    [sym_disjunction] = STATE(287),
    [sym_implication] = STATE(287),
    [sym_quantified] = STATE(287),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(287),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [90] = {
    [sym_special_call] = STATE(736),
    [sym_prefix_cast] = STATE(736),
    [sym_unary_expr] = STATE(736),
    [sym_mul_expr] = STATE(736),
    [sym_add_expr] = STATE(736),
    [sym_in_expr] = STATE(736),
    [sym_comp_term] = STATE(736),
    [sym_instance_of] = STATE(736),
    [sym_negation] = STATE(736),
    [sym_if_term] = STATE(736),
    [sym_conjunction] = STATE(736),
    [sym_disjunction] = STATE(736),
    [sym_implication] = STATE(736),
    [sym_quantified] = STATE(736),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(736),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [91] = {
    [sym_special_call] = STATE(246),
    [sym_prefix_cast] = STATE(246),
    [sym_unary_expr] = STATE(246),
    [sym_mul_expr] = STATE(246),
    [sym_add_expr] = STATE(246),
    [sym_in_expr] = STATE(246),
    [sym_comp_term] = STATE(246),
    [sym_instance_of] = STATE(246),
    [sym_negation] = STATE(246),
    [sym_if_term] = STATE(246),
    [sym_conjunction] = STATE(246),
    [sym_disjunction] = STATE(246),
    [sym_implication] = STATE(246),
    [sym_quantified] = STATE(246),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(246),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [92] = {
    [sym_special_call] = STATE(721),
    [sym_prefix_cast] = STATE(721),
    [sym_unary_expr] = STATE(721),
    [sym_mul_expr] = STATE(721),
    [sym_add_expr] = STATE(721),
    [sym_in_expr] = STATE(721),
    [sym_comp_term] = STATE(721),
    [sym_instance_of] = STATE(721),
    [sym_negation] = STATE(721),
    [sym_if_term] = STATE(721),
    [sym_conjunction] = STATE(721),
    [sym_disjunction] = STATE(721),
    [sym_implication] = STATE(721),
    [sym_quantified] = STATE(721),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(721),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [93] = {
    [sym_special_call] = STATE(528),
    [sym_prefix_cast] = STATE(528),
    [sym_unary_expr] = STATE(528),
    [sym_mul_expr] = STATE(528),
    [sym_add_expr] = STATE(528),
    [sym_in_expr] = STATE(528),
    [sym_comp_term] = STATE(528),
    [sym_instance_of] = STATE(528),
    [sym_negation] = STATE(528),
    [sym_if_term] = STATE(528),
    [sym_conjunction] = STATE(528),
    [sym_disjunction] = STATE(528),
    [sym_implication] = STATE(528),
    [sym_quantified] = STATE(528),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(528),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [94] = {
    [sym_special_call] = STATE(527),
    [sym_prefix_cast] = STATE(527),
    [sym_unary_expr] = STATE(527),
    [sym_mul_expr] = STATE(527),
    [sym_add_expr] = STATE(527),
    [sym_in_expr] = STATE(527),
    [sym_comp_term] = STATE(527),
    [sym_instance_of] = STATE(527),
    [sym_negation] = STATE(527),
    [sym_if_term] = STATE(527),
    [sym_conjunction] = STATE(527),
    [sym_disjunction] = STATE(527),
    [sym_implication] = STATE(527),
    [sym_quantified] = STATE(527),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(527),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [95] = {
    [sym_special_call] = STATE(525),
    [sym_prefix_cast] = STATE(525),
    [sym_unary_expr] = STATE(525),
    [sym_mul_expr] = STATE(525),
    [sym_add_expr] = STATE(525),
    [sym_in_expr] = STATE(525),
    [sym_comp_term] = STATE(525),
    [sym_instance_of] = STATE(525),
    [sym_negation] = STATE(525),
    [sym_if_term] = STATE(525),
    [sym_conjunction] = STATE(525),
    [sym_disjunction] = STATE(525),
    [sym_implication] = STATE(525),
    [sym_quantified] = STATE(525),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(525),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [96] = {
    [sym_special_call] = STATE(648),
    [sym_prefix_cast] = STATE(648),
    [sym_unary_expr] = STATE(648),
    [sym_mul_expr] = STATE(648),
    [sym_add_expr] = STATE(648),
    [sym_in_expr] = STATE(648),
    [sym_comp_term] = STATE(648),
    [sym_instance_of] = STATE(648),
    [sym_negation] = STATE(648),
    [sym_if_term] = STATE(648),
    [sym_conjunction] = STATE(648),
    [sym_disjunction] = STATE(648),
    [sym_implication] = STATE(648),
    [sym_quantified] = STATE(648),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(648),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1130),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [97] = {
    [sym_special_call] = STATE(757),
    [sym_prefix_cast] = STATE(757),
    [sym_unary_expr] = STATE(757),
    [sym_mul_expr] = STATE(757),
    [sym_add_expr] = STATE(757),
    [sym_in_expr] = STATE(757),
    [sym_comp_term] = STATE(757),
    [sym_instance_of] = STATE(757),
    [sym_negation] = STATE(757),
    [sym_if_term] = STATE(757),
    [sym_conjunction] = STATE(757),
    [sym_disjunction] = STATE(757),
    [sym_implication] = STATE(757),
    [sym_quantified] = STATE(757),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(757),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [98] = {
    [sym_special_call] = STATE(747),
    [sym_prefix_cast] = STATE(747),
    [sym_unary_expr] = STATE(747),
    [sym_mul_expr] = STATE(747),
    [sym_add_expr] = STATE(747),
    [sym_in_expr] = STATE(747),
    [sym_comp_term] = STATE(747),
    [sym_instance_of] = STATE(747),
    [sym_negation] = STATE(747),
    [sym_if_term] = STATE(747),
    [sym_conjunction] = STATE(747),
    [sym_disjunction] = STATE(747),
    [sym_implication] = STATE(747),
    [sym_quantified] = STATE(747),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(747),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [99] = {
    [sym_special_call] = STATE(284),
    [sym_prefix_cast] = STATE(284),
    [sym_unary_expr] = STATE(284),
    [sym_mul_expr] = STATE(284),
    [sym_add_expr] = STATE(284),
    [sym_in_expr] = STATE(284),
    [sym_comp_term] = STATE(284),
    [sym_instance_of] = STATE(284),
    [sym_negation] = STATE(284),
    [sym_if_term] = STATE(284),
    [sym_conjunction] = STATE(284),
    [sym_disjunction] = STATE(284),
    [sym_implication] = STATE(284),
    [sym_quantified] = STATE(284),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(284),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [100] = {
    [sym_special_call] = STATE(283),
    [sym_prefix_cast] = STATE(283),
    [sym_unary_expr] = STATE(283),
    [sym_mul_expr] = STATE(283),
    [sym_add_expr] = STATE(283),
    [sym_in_expr] = STATE(283),
    [sym_comp_term] = STATE(283),
    [sym_instance_of] = STATE(283),
    [sym_negation] = STATE(283),
    [sym_if_term] = STATE(283),
    [sym_conjunction] = STATE(283),
    [sym_disjunction] = STATE(283),
    [sym_implication] = STATE(283),
    [sym_quantified] = STATE(283),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(283),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [101] = {
    [sym_special_call] = STATE(519),
    [sym_prefix_cast] = STATE(519),
    [sym_unary_expr] = STATE(519),
    [sym_mul_expr] = STATE(519),
    [sym_add_expr] = STATE(519),
    [sym_in_expr] = STATE(519),
    [sym_comp_term] = STATE(519),
    [sym_instance_of] = STATE(519),
    [sym_negation] = STATE(519),
    [sym_if_term] = STATE(519),
    [sym_conjunction] = STATE(519),
    [sym_disjunction] = STATE(519),
    [sym_implication] = STATE(519),
    [sym_quantified] = STATE(519),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(519),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [102] = {
    [sym_special_call] = STATE(280),
    [sym_prefix_cast] = STATE(280),
    [sym_unary_expr] = STATE(280),
    [sym_mul_expr] = STATE(280),
    [sym_add_expr] = STATE(280),
    [sym_in_expr] = STATE(280),
    [sym_comp_term] = STATE(280),
    [sym_instance_of] = STATE(280),
    [sym_negation] = STATE(280),
    [sym_if_term] = STATE(280),
    [sym_conjunction] = STATE(280),
    [sym_disjunction] = STATE(280),
    [sym_implication] = STATE(280),
    [sym_quantified] = STATE(280),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(280),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [103] = {
    [sym_special_call] = STATE(526),
    [sym_prefix_cast] = STATE(526),
    [sym_unary_expr] = STATE(526),
    [sym_mul_expr] = STATE(526),
    [sym_add_expr] = STATE(526),
    [sym_in_expr] = STATE(526),
    [sym_comp_term] = STATE(526),
    [sym_instance_of] = STATE(526),
    [sym_negation] = STATE(526),
    [sym_if_term] = STATE(526),
    [sym_conjunction] = STATE(526),
    [sym_disjunction] = STATE(526),
    [sym_implication] = STATE(526),
    [sym_quantified] = STATE(526),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(526),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [104] = {
    [sym_special_call] = STATE(758),
    [sym_prefix_cast] = STATE(758),
    [sym_unary_expr] = STATE(758),
    [sym_mul_expr] = STATE(758),
    [sym_add_expr] = STATE(758),
    [sym_in_expr] = STATE(758),
    [sym_comp_term] = STATE(758),
    [sym_instance_of] = STATE(758),
    [sym_negation] = STATE(758),
    [sym_if_term] = STATE(758),
    [sym_conjunction] = STATE(758),
    [sym_disjunction] = STATE(758),
    [sym_implication] = STATE(758),
    [sym_quantified] = STATE(758),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(758),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [105] = {
    [sym_special_call] = STATE(249),
    [sym_prefix_cast] = STATE(249),
    [sym_unary_expr] = STATE(249),
    [sym_mul_expr] = STATE(249),
    [sym_add_expr] = STATE(249),
    [sym_in_expr] = STATE(249),
    [sym_comp_term] = STATE(249),
    [sym_instance_of] = STATE(249),
    [sym_negation] = STATE(249),
    [sym_if_term] = STATE(249),
    [sym_conjunction] = STATE(249),
    [sym_disjunction] = STATE(249),
    [sym_implication] = STATE(249),
    [sym_quantified] = STATE(249),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(249),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [106] = {
    [sym_special_call] = STATE(574),
    [sym_prefix_cast] = STATE(574),
    [sym_unary_expr] = STATE(574),
    [sym_mul_expr] = STATE(574),
    [sym_add_expr] = STATE(574),
    [sym_in_expr] = STATE(574),
    [sym_comp_term] = STATE(574),
    [sym_instance_of] = STATE(574),
    [sym_negation] = STATE(574),
    [sym_if_term] = STATE(574),
    [sym_conjunction] = STATE(574),
    [sym_disjunction] = STATE(574),
    [sym_implication] = STATE(574),
    [sym_quantified] = STATE(574),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(574),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [107] = {
    [sym_special_call] = STATE(761),
    [sym_prefix_cast] = STATE(761),
    [sym_unary_expr] = STATE(761),
    [sym_mul_expr] = STATE(761),
    [sym_add_expr] = STATE(761),
    [sym_in_expr] = STATE(761),
    [sym_comp_term] = STATE(761),
    [sym_instance_of] = STATE(761),
    [sym_negation] = STATE(761),
    [sym_if_term] = STATE(761),
    [sym_conjunction] = STATE(761),
    [sym_disjunction] = STATE(761),
    [sym_implication] = STATE(761),
    [sym_quantified] = STATE(761),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(761),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [108] = {
    [sym_special_call] = STATE(570),
    [sym_prefix_cast] = STATE(570),
    [sym_unary_expr] = STATE(570),
    [sym_mul_expr] = STATE(570),
    [sym_add_expr] = STATE(570),
    [sym_in_expr] = STATE(570),
    [sym_comp_term] = STATE(570),
    [sym_instance_of] = STATE(570),
    [sym_negation] = STATE(570),
    [sym_if_term] = STATE(570),
    [sym_conjunction] = STATE(570),
    [sym_disjunction] = STATE(570),
    [sym_implication] = STATE(570),
    [sym_quantified] = STATE(570),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(570),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [109] = {
    [sym_special_call] = STATE(638),
    [sym_prefix_cast] = STATE(638),
    [sym_unary_expr] = STATE(638),
    [sym_mul_expr] = STATE(638),
    [sym_add_expr] = STATE(638),
    [sym_in_expr] = STATE(638),
    [sym_comp_term] = STATE(638),
    [sym_instance_of] = STATE(638),
    [sym_negation] = STATE(638),
    [sym_if_term] = STATE(638),
    [sym_conjunction] = STATE(638),
    [sym_disjunction] = STATE(638),
    [sym_implication] = STATE(638),
    [sym_quantified] = STATE(638),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(638),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [110] = {
    [sym_special_call] = STATE(559),
    [sym_prefix_cast] = STATE(559),
    [sym_unary_expr] = STATE(559),
    [sym_mul_expr] = STATE(559),
    [sym_add_expr] = STATE(559),
    [sym_in_expr] = STATE(559),
    [sym_comp_term] = STATE(559),
    [sym_instance_of] = STATE(559),
    [sym_negation] = STATE(559),
    [sym_if_term] = STATE(559),
    [sym_conjunction] = STATE(559),
    [sym_disjunction] = STATE(559),
    [sym_implication] = STATE(559),
    [sym_quantified] = STATE(559),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(559),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [111] = {
    [sym_special_call] = STATE(654),
    [sym_prefix_cast] = STATE(654),
    [sym_unary_expr] = STATE(654),
    [sym_mul_expr] = STATE(654),
    [sym_add_expr] = STATE(654),
    [sym_in_expr] = STATE(654),
    [sym_comp_term] = STATE(654),
    [sym_instance_of] = STATE(654),
    [sym_negation] = STATE(654),
    [sym_if_term] = STATE(654),
    [sym_conjunction] = STATE(654),
    [sym_disjunction] = STATE(654),
    [sym_implication] = STATE(654),
    [sym_quantified] = STATE(654),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(654),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [112] = {
    [sym_special_call] = STATE(656),
    [sym_prefix_cast] = STATE(656),
    [sym_unary_expr] = STATE(656),
    [sym_mul_expr] = STATE(656),
    [sym_add_expr] = STATE(656),
    [sym_in_expr] = STATE(656),
    [sym_comp_term] = STATE(656),
    [sym_instance_of] = STATE(656),
    [sym_negation] = STATE(656),
    [sym_if_term] = STATE(656),
    [sym_conjunction] = STATE(656),
    [sym_disjunction] = STATE(656),
    [sym_implication] = STATE(656),
    [sym_quantified] = STATE(656),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(656),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [113] = {
    [sym_special_call] = STATE(687),
    [sym_prefix_cast] = STATE(687),
    [sym_unary_expr] = STATE(687),
    [sym_mul_expr] = STATE(687),
    [sym_add_expr] = STATE(687),
    [sym_in_expr] = STATE(687),
    [sym_comp_term] = STATE(687),
    [sym_instance_of] = STATE(687),
    [sym_negation] = STATE(687),
    [sym_if_term] = STATE(687),
    [sym_conjunction] = STATE(687),
    [sym_disjunction] = STATE(687),
    [sym_implication] = STATE(687),
    [sym_quantified] = STATE(687),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(687),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1142),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [114] = {
    [sym_special_call] = STATE(746),
    [sym_prefix_cast] = STATE(746),
    [sym_unary_expr] = STATE(746),
    [sym_mul_expr] = STATE(746),
    [sym_add_expr] = STATE(746),
    [sym_in_expr] = STATE(746),
    [sym_comp_term] = STATE(746),
    [sym_instance_of] = STATE(746),
    [sym_negation] = STATE(746),
    [sym_if_term] = STATE(746),
    [sym_conjunction] = STATE(746),
    [sym_disjunction] = STATE(746),
    [sym_implication] = STATE(746),
    [sym_quantified] = STATE(746),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(746),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [115] = {
    [sym_special_call] = STATE(667),
    [sym_prefix_cast] = STATE(667),
    [sym_unary_expr] = STATE(667),
    [sym_mul_expr] = STATE(667),
    [sym_add_expr] = STATE(667),
    [sym_in_expr] = STATE(667),
    [sym_comp_term] = STATE(667),
    [sym_instance_of] = STATE(667),
    [sym_negation] = STATE(667),
    [sym_if_term] = STATE(667),
    [sym_conjunction] = STATE(667),
    [sym_disjunction] = STATE(667),
    [sym_implication] = STATE(667),
    [sym_quantified] = STATE(667),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(667),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [116] = {
    [sym_special_call] = STATE(668),
    [sym_prefix_cast] = STATE(668),
    [sym_unary_expr] = STATE(668),
    [sym_mul_expr] = STATE(668),
    [sym_add_expr] = STATE(668),
    [sym_in_expr] = STATE(668),
    [sym_comp_term] = STATE(668),
    [sym_instance_of] = STATE(668),
    [sym_negation] = STATE(668),
    [sym_if_term] = STATE(668),
    [sym_conjunction] = STATE(668),
    [sym_disjunction] = STATE(668),
    [sym_implication] = STATE(668),
    [sym_quantified] = STATE(668),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(668),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [117] = {
    [sym_special_call] = STATE(633),
    [sym_prefix_cast] = STATE(633),
    [sym_unary_expr] = STATE(633),
    [sym_mul_expr] = STATE(633),
    [sym_add_expr] = STATE(633),
    [sym_in_expr] = STATE(633),
    [sym_comp_term] = STATE(633),
    [sym_instance_of] = STATE(633),
    [sym_negation] = STATE(633),
    [sym_if_term] = STATE(633),
    [sym_conjunction] = STATE(633),
    [sym_disjunction] = STATE(633),
    [sym_implication] = STATE(633),
    [sym_quantified] = STATE(633),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(633),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [118] = {
    [sym_special_call] = STATE(670),
    [sym_prefix_cast] = STATE(670),
    [sym_unary_expr] = STATE(670),
    [sym_mul_expr] = STATE(670),
    [sym_add_expr] = STATE(670),
    [sym_in_expr] = STATE(670),
    [sym_comp_term] = STATE(670),
    [sym_instance_of] = STATE(670),
    [sym_negation] = STATE(670),
    [sym_if_term] = STATE(670),
    [sym_conjunction] = STATE(670),
    [sym_disjunction] = STATE(670),
    [sym_implication] = STATE(670),
    [sym_quantified] = STATE(670),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(670),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [119] = {
    [sym_special_call] = STATE(619),
    [sym_prefix_cast] = STATE(619),
    [sym_unary_expr] = STATE(619),
    [sym_mul_expr] = STATE(619),
    [sym_add_expr] = STATE(619),
    [sym_in_expr] = STATE(619),
    [sym_comp_term] = STATE(619),
    [sym_instance_of] = STATE(619),
    [sym_negation] = STATE(619),
    [sym_if_term] = STATE(619),
    [sym_conjunction] = STATE(619),
    [sym_disjunction] = STATE(619),
    [sym_implication] = STATE(619),
    [sym_quantified] = STATE(619),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(619),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [120] = {
    [sym_special_call] = STATE(565),
    [sym_prefix_cast] = STATE(565),
    [sym_unary_expr] = STATE(565),
    [sym_mul_expr] = STATE(565),
    [sym_add_expr] = STATE(565),
    [sym_in_expr] = STATE(565),
    [sym_comp_term] = STATE(565),
    [sym_instance_of] = STATE(565),
    [sym_negation] = STATE(565),
    [sym_if_term] = STATE(565),
    [sym_conjunction] = STATE(565),
    [sym_disjunction] = STATE(565),
    [sym_implication] = STATE(565),
    [sym_quantified] = STATE(565),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(565),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [121] = {
    [sym_special_call] = STATE(626),
    [sym_prefix_cast] = STATE(626),
    [sym_unary_expr] = STATE(626),
    [sym_mul_expr] = STATE(626),
    [sym_add_expr] = STATE(626),
    [sym_in_expr] = STATE(626),
    [sym_comp_term] = STATE(626),
    [sym_instance_of] = STATE(626),
    [sym_negation] = STATE(626),
    [sym_if_term] = STATE(626),
    [sym_conjunction] = STATE(626),
    [sym_disjunction] = STATE(626),
    [sym_implication] = STATE(626),
    [sym_quantified] = STATE(626),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(626),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [122] = {
    [sym_special_call] = STATE(679),
    [sym_prefix_cast] = STATE(679),
    [sym_unary_expr] = STATE(679),
    [sym_mul_expr] = STATE(679),
    [sym_add_expr] = STATE(679),
    [sym_in_expr] = STATE(679),
    [sym_comp_term] = STATE(679),
    [sym_instance_of] = STATE(679),
    [sym_negation] = STATE(679),
    [sym_if_term] = STATE(679),
    [sym_conjunction] = STATE(679),
    [sym_disjunction] = STATE(679),
    [sym_implication] = STATE(679),
    [sym_quantified] = STATE(679),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(679),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [123] = {
    [sym_special_call] = STATE(266),
    [sym_prefix_cast] = STATE(266),
    [sym_unary_expr] = STATE(266),
    [sym_mul_expr] = STATE(266),
    [sym_add_expr] = STATE(266),
    [sym_in_expr] = STATE(266),
    [sym_comp_term] = STATE(266),
    [sym_instance_of] = STATE(266),
    [sym_negation] = STATE(266),
    [sym_if_term] = STATE(266),
    [sym_conjunction] = STATE(266),
    [sym_disjunction] = STATE(266),
    [sym_implication] = STATE(266),
    [sym_quantified] = STATE(266),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(266),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [124] = {
    [sym_special_call] = STATE(682),
    [sym_prefix_cast] = STATE(682),
    [sym_unary_expr] = STATE(682),
    [sym_mul_expr] = STATE(682),
    [sym_add_expr] = STATE(682),
    [sym_in_expr] = STATE(682),
    [sym_comp_term] = STATE(682),
    [sym_instance_of] = STATE(682),
    [sym_negation] = STATE(682),
    [sym_if_term] = STATE(682),
    [sym_conjunction] = STATE(682),
    [sym_disjunction] = STATE(682),
    [sym_implication] = STATE(682),
    [sym_quantified] = STATE(682),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(682),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [125] = {
    [sym_special_call] = STATE(716),
    [sym_prefix_cast] = STATE(716),
    [sym_unary_expr] = STATE(716),
    [sym_mul_expr] = STATE(716),
    [sym_add_expr] = STATE(716),
    [sym_in_expr] = STATE(716),
    [sym_comp_term] = STATE(716),
    [sym_instance_of] = STATE(716),
    [sym_negation] = STATE(716),
    [sym_if_term] = STATE(716),
    [sym_conjunction] = STATE(716),
    [sym_disjunction] = STATE(716),
    [sym_implication] = STATE(716),
    [sym_quantified] = STATE(716),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(716),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1149),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [126] = {
    [sym_special_call] = STATE(688),
    [sym_prefix_cast] = STATE(688),
    [sym_unary_expr] = STATE(688),
    [sym_mul_expr] = STATE(688),
    [sym_add_expr] = STATE(688),
    [sym_in_expr] = STATE(688),
    [sym_comp_term] = STATE(688),
    [sym_instance_of] = STATE(688),
    [sym_negation] = STATE(688),
    [sym_if_term] = STATE(688),
    [sym_conjunction] = STATE(688),
    [sym_disjunction] = STATE(688),
    [sym_implication] = STATE(688),
    [sym_quantified] = STATE(688),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(688),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [127] = {
    [sym_special_call] = STATE(738),
    [sym_prefix_cast] = STATE(738),
    [sym_unary_expr] = STATE(738),
    [sym_mul_expr] = STATE(738),
    [sym_add_expr] = STATE(738),
    [sym_in_expr] = STATE(738),
    [sym_comp_term] = STATE(738),
    [sym_instance_of] = STATE(738),
    [sym_negation] = STATE(738),
    [sym_if_term] = STATE(738),
    [sym_conjunction] = STATE(738),
    [sym_disjunction] = STATE(738),
    [sym_implication] = STATE(738),
    [sym_quantified] = STATE(738),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(738),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [128] = {
    [sym_special_call] = STATE(691),
    [sym_prefix_cast] = STATE(691),
    [sym_unary_expr] = STATE(691),
    [sym_mul_expr] = STATE(691),
    [sym_add_expr] = STATE(691),
    [sym_in_expr] = STATE(691),
    [sym_comp_term] = STATE(691),
    [sym_instance_of] = STATE(691),
    [sym_negation] = STATE(691),
    [sym_if_term] = STATE(691),
    [sym_conjunction] = STATE(691),
    [sym_disjunction] = STATE(691),
    [sym_implication] = STATE(691),
    [sym_quantified] = STATE(691),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(691),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [129] = {
    [sym_special_call] = STATE(617),
    [sym_prefix_cast] = STATE(617),
    [sym_unary_expr] = STATE(617),
    [sym_mul_expr] = STATE(617),
    [sym_add_expr] = STATE(617),
    [sym_in_expr] = STATE(617),
    [sym_comp_term] = STATE(617),
    [sym_instance_of] = STATE(617),
    [sym_negation] = STATE(617),
    [sym_if_term] = STATE(617),
    [sym_conjunction] = STATE(617),
    [sym_disjunction] = STATE(617),
    [sym_implication] = STATE(617),
    [sym_quantified] = STATE(617),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(617),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [130] = {
    [sym_special_call] = STATE(693),
    [sym_prefix_cast] = STATE(693),
    [sym_unary_expr] = STATE(693),
    [sym_mul_expr] = STATE(693),
    [sym_add_expr] = STATE(693),
    [sym_in_expr] = STATE(693),
    [sym_comp_term] = STATE(693),
    [sym_instance_of] = STATE(693),
    [sym_negation] = STATE(693),
    [sym_if_term] = STATE(693),
    [sym_conjunction] = STATE(693),
    [sym_disjunction] = STATE(693),
    [sym_implication] = STATE(693),
    [sym_quantified] = STATE(693),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(693),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [131] = {
    [sym_special_call] = STATE(616),
    [sym_prefix_cast] = STATE(616),
    [sym_unary_expr] = STATE(616),
    [sym_mul_expr] = STATE(616),
    [sym_add_expr] = STATE(616),
    [sym_in_expr] = STATE(616),
    [sym_comp_term] = STATE(616),
    [sym_instance_of] = STATE(616),
    [sym_negation] = STATE(616),
    [sym_if_term] = STATE(616),
    [sym_conjunction] = STATE(616),
    [sym_disjunction] = STATE(616),
    [sym_implication] = STATE(616),
    [sym_quantified] = STATE(616),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(616),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [132] = {
    [sym_special_call] = STATE(604),
    [sym_prefix_cast] = STATE(604),
    [sym_unary_expr] = STATE(604),
    [sym_mul_expr] = STATE(604),
    [sym_add_expr] = STATE(604),
    [sym_in_expr] = STATE(604),
    [sym_comp_term] = STATE(604),
    [sym_instance_of] = STATE(604),
    [sym_negation] = STATE(604),
    [sym_if_term] = STATE(604),
    [sym_conjunction] = STATE(604),
    [sym_disjunction] = STATE(604),
    [sym_implication] = STATE(604),
    [sym_quantified] = STATE(604),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(604),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [133] = {
    [sym_special_call] = STATE(737),
    [sym_prefix_cast] = STATE(737),
    [sym_unary_expr] = STATE(737),
    [sym_mul_expr] = STATE(737),
    [sym_add_expr] = STATE(737),
    [sym_in_expr] = STATE(737),
    [sym_comp_term] = STATE(737),
    [sym_instance_of] = STATE(737),
    [sym_negation] = STATE(737),
    [sym_if_term] = STATE(737),
    [sym_conjunction] = STATE(737),
    [sym_disjunction] = STATE(737),
    [sym_implication] = STATE(737),
    [sym_quantified] = STATE(737),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(737),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [134] = {
    [sym_special_call] = STATE(649),
    [sym_prefix_cast] = STATE(649),
    [sym_unary_expr] = STATE(649),
    [sym_mul_expr] = STATE(649),
    [sym_add_expr] = STATE(649),
    [sym_in_expr] = STATE(649),
    [sym_comp_term] = STATE(649),
    [sym_instance_of] = STATE(649),
    [sym_negation] = STATE(649),
    [sym_if_term] = STATE(649),
    [sym_conjunction] = STATE(649),
    [sym_disjunction] = STATE(649),
    [sym_implication] = STATE(649),
    [sym_quantified] = STATE(649),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(649),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [135] = {
    [sym_special_call] = STATE(603),
    [sym_prefix_cast] = STATE(603),
    [sym_unary_expr] = STATE(603),
    [sym_mul_expr] = STATE(603),
    [sym_add_expr] = STATE(603),
    [sym_in_expr] = STATE(603),
    [sym_comp_term] = STATE(603),
    [sym_instance_of] = STATE(603),
    [sym_negation] = STATE(603),
    [sym_if_term] = STATE(603),
    [sym_conjunction] = STATE(603),
    [sym_disjunction] = STATE(603),
    [sym_implication] = STATE(603),
    [sym_quantified] = STATE(603),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(603),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [136] = {
    [sym_special_call] = STATE(707),
    [sym_prefix_cast] = STATE(707),
    [sym_unary_expr] = STATE(707),
    [sym_mul_expr] = STATE(707),
    [sym_add_expr] = STATE(707),
    [sym_in_expr] = STATE(707),
    [sym_comp_term] = STATE(707),
    [sym_instance_of] = STATE(707),
    [sym_negation] = STATE(707),
    [sym_if_term] = STATE(707),
    [sym_conjunction] = STATE(707),
    [sym_disjunction] = STATE(707),
    [sym_implication] = STATE(707),
    [sym_quantified] = STATE(707),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(707),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [137] = {
    [sym_special_call] = STATE(713),
    [sym_prefix_cast] = STATE(713),
    [sym_unary_expr] = STATE(713),
    [sym_mul_expr] = STATE(713),
    [sym_add_expr] = STATE(713),
    [sym_in_expr] = STATE(713),
    [sym_comp_term] = STATE(713),
    [sym_instance_of] = STATE(713),
    [sym_negation] = STATE(713),
    [sym_if_term] = STATE(713),
    [sym_conjunction] = STATE(713),
    [sym_disjunction] = STATE(713),
    [sym_implication] = STATE(713),
    [sym_quantified] = STATE(713),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(713),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1120),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [138] = {
    [sym_special_call] = STATE(554),
    [sym_prefix_cast] = STATE(554),
    [sym_unary_expr] = STATE(554),
    [sym_mul_expr] = STATE(554),
    [sym_add_expr] = STATE(554),
    [sym_in_expr] = STATE(554),
    [sym_comp_term] = STATE(554),
    [sym_instance_of] = STATE(554),
    [sym_negation] = STATE(554),
    [sym_if_term] = STATE(554),
    [sym_conjunction] = STATE(554),
    [sym_disjunction] = STATE(554),
    [sym_implication] = STATE(554),
    [sym_quantified] = STATE(554),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(554),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [139] = {
    [sym_special_call] = STATE(247),
    [sym_prefix_cast] = STATE(247),
    [sym_unary_expr] = STATE(247),
    [sym_mul_expr] = STATE(247),
    [sym_add_expr] = STATE(247),
    [sym_in_expr] = STATE(247),
    [sym_comp_term] = STATE(247),
    [sym_instance_of] = STATE(247),
    [sym_negation] = STATE(247),
    [sym_if_term] = STATE(247),
    [sym_conjunction] = STATE(247),
    [sym_disjunction] = STATE(247),
    [sym_implication] = STATE(247),
    [sym_quantified] = STATE(247),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(247),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [140] = {
    [sym_special_call] = STATE(733),
    [sym_prefix_cast] = STATE(733),
    [sym_unary_expr] = STATE(733),
    [sym_mul_expr] = STATE(733),
    [sym_add_expr] = STATE(733),
    [sym_in_expr] = STATE(733),
    [sym_comp_term] = STATE(733),
    [sym_instance_of] = STATE(733),
    [sym_negation] = STATE(733),
    [sym_if_term] = STATE(733),
    [sym_conjunction] = STATE(733),
    [sym_disjunction] = STATE(733),
    [sym_implication] = STATE(733),
    [sym_quantified] = STATE(733),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(733),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [141] = {
    [sym_special_call] = STATE(727),
    [sym_prefix_cast] = STATE(727),
    [sym_unary_expr] = STATE(727),
    [sym_mul_expr] = STATE(727),
    [sym_add_expr] = STATE(727),
    [sym_in_expr] = STATE(727),
    [sym_comp_term] = STATE(727),
    [sym_instance_of] = STATE(727),
    [sym_negation] = STATE(727),
    [sym_if_term] = STATE(727),
    [sym_conjunction] = STATE(727),
    [sym_disjunction] = STATE(727),
    [sym_implication] = STATE(727),
    [sym_quantified] = STATE(727),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(727),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [142] = {
    [sym_special_call] = STATE(556),
    [sym_prefix_cast] = STATE(556),
    [sym_unary_expr] = STATE(556),
    [sym_mul_expr] = STATE(556),
    [sym_add_expr] = STATE(556),
    [sym_in_expr] = STATE(556),
    [sym_comp_term] = STATE(556),
    [sym_instance_of] = STATE(556),
    [sym_negation] = STATE(556),
    [sym_if_term] = STATE(556),
    [sym_conjunction] = STATE(556),
    [sym_disjunction] = STATE(556),
    [sym_implication] = STATE(556),
    [sym_quantified] = STATE(556),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(556),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [143] = {
    [sym_special_call] = STATE(523),
    [sym_prefix_cast] = STATE(523),
    [sym_unary_expr] = STATE(523),
    [sym_mul_expr] = STATE(523),
    [sym_add_expr] = STATE(523),
    [sym_in_expr] = STATE(523),
    [sym_comp_term] = STATE(523),
    [sym_instance_of] = STATE(523),
    [sym_negation] = STATE(523),
    [sym_if_term] = STATE(523),
    [sym_conjunction] = STATE(523),
    [sym_disjunction] = STATE(523),
    [sym_implication] = STATE(523),
    [sym_quantified] = STATE(523),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(523),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [144] = {
    [sym_special_call] = STATE(735),
    [sym_prefix_cast] = STATE(735),
    [sym_unary_expr] = STATE(735),
    [sym_mul_expr] = STATE(735),
    [sym_add_expr] = STATE(735),
    [sym_in_expr] = STATE(735),
    [sym_comp_term] = STATE(735),
    [sym_instance_of] = STATE(735),
    [sym_negation] = STATE(735),
    [sym_if_term] = STATE(735),
    [sym_conjunction] = STATE(735),
    [sym_disjunction] = STATE(735),
    [sym_implication] = STATE(735),
    [sym_quantified] = STATE(735),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(735),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [145] = {
    [sym_special_call] = STATE(744),
    [sym_prefix_cast] = STATE(744),
    [sym_unary_expr] = STATE(744),
    [sym_mul_expr] = STATE(744),
    [sym_add_expr] = STATE(744),
    [sym_in_expr] = STATE(744),
    [sym_comp_term] = STATE(744),
    [sym_instance_of] = STATE(744),
    [sym_negation] = STATE(744),
    [sym_if_term] = STATE(744),
    [sym_conjunction] = STATE(744),
    [sym_disjunction] = STATE(744),
    [sym_implication] = STATE(744),
    [sym_quantified] = STATE(744),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(744),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [146] = {
    [sym_special_call] = STATE(248),
    [sym_prefix_cast] = STATE(248),
    [sym_unary_expr] = STATE(248),
    [sym_mul_expr] = STATE(248),
    [sym_add_expr] = STATE(248),
    [sym_in_expr] = STATE(248),
    [sym_comp_term] = STATE(248),
    [sym_instance_of] = STATE(248),
    [sym_negation] = STATE(248),
    [sym_if_term] = STATE(248),
    [sym_conjunction] = STATE(248),
    [sym_disjunction] = STATE(248),
    [sym_implication] = STATE(248),
    [sym_quantified] = STATE(248),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(248),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [147] = {
    [sym_special_call] = STATE(273),
    [sym_prefix_cast] = STATE(273),
    [sym_unary_expr] = STATE(273),
    [sym_mul_expr] = STATE(273),
    [sym_add_expr] = STATE(273),
    [sym_in_expr] = STATE(273),
    [sym_comp_term] = STATE(273),
    [sym_instance_of] = STATE(273),
    [sym_negation] = STATE(273),
    [sym_if_term] = STATE(273),
    [sym_conjunction] = STATE(273),
    [sym_disjunction] = STATE(273),
    [sym_implication] = STATE(273),
    [sym_quantified] = STATE(273),
    [sym_specialId] = STATE(1213),
    [sym_quantifier] = STATE(1214),
    [sym_classless_predicate_call] = STATE(368),
    [sym_qualified_expr] = STATE(368),
    [sym_super_ref] = STATE(368),
    [sym_aggregate] = STATE(368),
    [sym_range] = STATE(368),
    [sym_par_expr] = STATE(368),
    [sym__exprOrTerm] = STATE(273),
    [sym__primary] = STATE(368),
    [sym_literal] = STATE(368),
    [sym_bool] = STATE(349),
    [sym_variable] = STATE(368),
    [sym_unop] = STATE(146),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(297),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1215),
    [sym_aritylessPredicateExpr] = STATE(968),
    [sym_varName] = STATE(356),
    [sym_aggId] = STATE(1116),
    [sym__lower_id] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(335),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(341),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(343),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(345),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(347),
    [sym_this] = ACTIONS(345),
    [sym_true] = ACTIONS(341),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [148] = {
    [sym_special_call] = STATE(586),
    [sym_prefix_cast] = STATE(586),
    [sym_unary_expr] = STATE(586),
    [sym_mul_expr] = STATE(586),
    [sym_add_expr] = STATE(586),
    [sym_in_expr] = STATE(586),
    [sym_comp_term] = STATE(586),
    [sym_instance_of] = STATE(586),
    [sym_negation] = STATE(586),
    [sym_if_term] = STATE(586),
    [sym_conjunction] = STATE(586),
    [sym_disjunction] = STATE(586),
    [sym_implication] = STATE(586),
    [sym_quantified] = STATE(586),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(586),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [149] = {
    [sym_special_call] = STATE(760),
    [sym_prefix_cast] = STATE(760),
    [sym_unary_expr] = STATE(760),
    [sym_mul_expr] = STATE(760),
    [sym_add_expr] = STATE(760),
    [sym_in_expr] = STATE(760),
    [sym_comp_term] = STATE(760),
    [sym_instance_of] = STATE(760),
    [sym_negation] = STATE(760),
    [sym_if_term] = STATE(760),
    [sym_conjunction] = STATE(760),
    [sym_disjunction] = STATE(760),
    [sym_implication] = STATE(760),
    [sym_quantified] = STATE(760),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(760),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [150] = {
    [sym_special_call] = STATE(729),
    [sym_prefix_cast] = STATE(729),
    [sym_unary_expr] = STATE(729),
    [sym_mul_expr] = STATE(729),
    [sym_add_expr] = STATE(729),
    [sym_in_expr] = STATE(729),
    [sym_comp_term] = STATE(729),
    [sym_instance_of] = STATE(729),
    [sym_negation] = STATE(729),
    [sym_if_term] = STATE(729),
    [sym_conjunction] = STATE(729),
    [sym_disjunction] = STATE(729),
    [sym_implication] = STATE(729),
    [sym_quantified] = STATE(729),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(729),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [151] = {
    [sym_special_call] = STATE(589),
    [sym_prefix_cast] = STATE(589),
    [sym_unary_expr] = STATE(589),
    [sym_mul_expr] = STATE(589),
    [sym_add_expr] = STATE(589),
    [sym_in_expr] = STATE(589),
    [sym_comp_term] = STATE(589),
    [sym_instance_of] = STATE(589),
    [sym_negation] = STATE(589),
    [sym_if_term] = STATE(589),
    [sym_conjunction] = STATE(589),
    [sym_disjunction] = STATE(589),
    [sym_implication] = STATE(589),
    [sym_quantified] = STATE(589),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(589),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [152] = {
    [sym_special_call] = STATE(730),
    [sym_prefix_cast] = STATE(730),
    [sym_unary_expr] = STATE(730),
    [sym_mul_expr] = STATE(730),
    [sym_add_expr] = STATE(730),
    [sym_in_expr] = STATE(730),
    [sym_comp_term] = STATE(730),
    [sym_instance_of] = STATE(730),
    [sym_negation] = STATE(730),
    [sym_if_term] = STATE(730),
    [sym_conjunction] = STATE(730),
    [sym_disjunction] = STATE(730),
    [sym_implication] = STATE(730),
    [sym_quantified] = STATE(730),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(730),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [153] = {
    [sym_special_call] = STATE(728),
    [sym_prefix_cast] = STATE(728),
    [sym_unary_expr] = STATE(728),
    [sym_mul_expr] = STATE(728),
    [sym_add_expr] = STATE(728),
    [sym_in_expr] = STATE(728),
    [sym_comp_term] = STATE(728),
    [sym_instance_of] = STATE(728),
    [sym_negation] = STATE(728),
    [sym_if_term] = STATE(728),
    [sym_conjunction] = STATE(728),
    [sym_disjunction] = STATE(728),
    [sym_implication] = STATE(728),
    [sym_quantified] = STATE(728),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(728),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [154] = {
    [sym_special_call] = STATE(568),
    [sym_prefix_cast] = STATE(568),
    [sym_unary_expr] = STATE(568),
    [sym_mul_expr] = STATE(568),
    [sym_add_expr] = STATE(568),
    [sym_in_expr] = STATE(568),
    [sym_comp_term] = STATE(568),
    [sym_instance_of] = STATE(568),
    [sym_negation] = STATE(568),
    [sym_if_term] = STATE(568),
    [sym_conjunction] = STATE(568),
    [sym_disjunction] = STATE(568),
    [sym_implication] = STATE(568),
    [sym_quantified] = STATE(568),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(568),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [155] = {
    [sym_special_call] = STATE(269),
    [sym_prefix_cast] = STATE(269),
    [sym_unary_expr] = STATE(269),
    [sym_mul_expr] = STATE(269),
    [sym_add_expr] = STATE(269),
    [sym_in_expr] = STATE(269),
    [sym_comp_term] = STATE(269),
    [sym_instance_of] = STATE(269),
    [sym_negation] = STATE(269),
    [sym_if_term] = STATE(269),
    [sym_conjunction] = STATE(269),
    [sym_disjunction] = STATE(269),
    [sym_implication] = STATE(269),
    [sym_quantified] = STATE(269),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(269),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [156] = {
    [sym_special_call] = STATE(244),
    [sym_prefix_cast] = STATE(244),
    [sym_unary_expr] = STATE(244),
    [sym_mul_expr] = STATE(244),
    [sym_add_expr] = STATE(244),
    [sym_in_expr] = STATE(244),
    [sym_comp_term] = STATE(244),
    [sym_instance_of] = STATE(244),
    [sym_negation] = STATE(244),
    [sym_if_term] = STATE(244),
    [sym_conjunction] = STATE(244),
    [sym_disjunction] = STATE(244),
    [sym_implication] = STATE(244),
    [sym_quantified] = STATE(244),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(244),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [157] = {
    [sym_special_call] = STATE(543),
    [sym_prefix_cast] = STATE(543),
    [sym_unary_expr] = STATE(543),
    [sym_mul_expr] = STATE(543),
    [sym_add_expr] = STATE(543),
    [sym_in_expr] = STATE(543),
    [sym_comp_term] = STATE(543),
    [sym_instance_of] = STATE(543),
    [sym_negation] = STATE(543),
    [sym_if_term] = STATE(543),
    [sym_conjunction] = STATE(543),
    [sym_disjunction] = STATE(543),
    [sym_implication] = STATE(543),
    [sym_quantified] = STATE(543),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(543),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [158] = {
    [sym_special_call] = STATE(726),
    [sym_prefix_cast] = STATE(726),
    [sym_unary_expr] = STATE(726),
    [sym_mul_expr] = STATE(726),
    [sym_add_expr] = STATE(726),
    [sym_in_expr] = STATE(726),
    [sym_comp_term] = STATE(726),
    [sym_instance_of] = STATE(726),
    [sym_negation] = STATE(726),
    [sym_if_term] = STATE(726),
    [sym_conjunction] = STATE(726),
    [sym_disjunction] = STATE(726),
    [sym_implication] = STATE(726),
    [sym_quantified] = STATE(726),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(726),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [159] = {
    [sym_special_call] = STATE(550),
    [sym_prefix_cast] = STATE(550),
    [sym_unary_expr] = STATE(550),
    [sym_mul_expr] = STATE(550),
    [sym_add_expr] = STATE(550),
    [sym_in_expr] = STATE(550),
    [sym_comp_term] = STATE(550),
    [sym_instance_of] = STATE(550),
    [sym_negation] = STATE(550),
    [sym_if_term] = STATE(550),
    [sym_conjunction] = STATE(550),
    [sym_disjunction] = STATE(550),
    [sym_implication] = STATE(550),
    [sym_quantified] = STATE(550),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(550),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [160] = {
    [sym_special_call] = STATE(734),
    [sym_prefix_cast] = STATE(734),
    [sym_unary_expr] = STATE(734),
    [sym_mul_expr] = STATE(734),
    [sym_add_expr] = STATE(734),
    [sym_in_expr] = STATE(734),
    [sym_comp_term] = STATE(734),
    [sym_instance_of] = STATE(734),
    [sym_negation] = STATE(734),
    [sym_if_term] = STATE(734),
    [sym_conjunction] = STATE(734),
    [sym_disjunction] = STATE(734),
    [sym_implication] = STATE(734),
    [sym_quantified] = STATE(734),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(734),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [161] = {
    [sym_special_call] = STATE(547),
    [sym_prefix_cast] = STATE(547),
    [sym_unary_expr] = STATE(547),
    [sym_mul_expr] = STATE(547),
    [sym_add_expr] = STATE(547),
    [sym_in_expr] = STATE(547),
    [sym_comp_term] = STATE(547),
    [sym_instance_of] = STATE(547),
    [sym_negation] = STATE(547),
    [sym_if_term] = STATE(547),
    [sym_conjunction] = STATE(547),
    [sym_disjunction] = STATE(547),
    [sym_implication] = STATE(547),
    [sym_quantified] = STATE(547),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(547),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [162] = {
    [sym_special_call] = STATE(739),
    [sym_prefix_cast] = STATE(739),
    [sym_unary_expr] = STATE(739),
    [sym_mul_expr] = STATE(739),
    [sym_add_expr] = STATE(739),
    [sym_in_expr] = STATE(739),
    [sym_comp_term] = STATE(739),
    [sym_instance_of] = STATE(739),
    [sym_negation] = STATE(739),
    [sym_if_term] = STATE(739),
    [sym_conjunction] = STATE(739),
    [sym_disjunction] = STATE(739),
    [sym_implication] = STATE(739),
    [sym_quantified] = STATE(739),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(739),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [163] = {
    [sym_special_call] = STATE(587),
    [sym_prefix_cast] = STATE(587),
    [sym_unary_expr] = STATE(587),
    [sym_mul_expr] = STATE(587),
    [sym_add_expr] = STATE(587),
    [sym_in_expr] = STATE(587),
    [sym_comp_term] = STATE(587),
    [sym_instance_of] = STATE(587),
    [sym_negation] = STATE(587),
    [sym_if_term] = STATE(587),
    [sym_conjunction] = STATE(587),
    [sym_disjunction] = STATE(587),
    [sym_implication] = STATE(587),
    [sym_quantified] = STATE(587),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(587),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [164] = {
    [sym_special_call] = STATE(548),
    [sym_prefix_cast] = STATE(548),
    [sym_unary_expr] = STATE(548),
    [sym_mul_expr] = STATE(548),
    [sym_add_expr] = STATE(548),
    [sym_in_expr] = STATE(548),
    [sym_comp_term] = STATE(548),
    [sym_instance_of] = STATE(548),
    [sym_negation] = STATE(548),
    [sym_if_term] = STATE(548),
    [sym_conjunction] = STATE(548),
    [sym_disjunction] = STATE(548),
    [sym_implication] = STATE(548),
    [sym_quantified] = STATE(548),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(548),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [165] = {
    [sym_special_call] = STATE(542),
    [sym_prefix_cast] = STATE(542),
    [sym_unary_expr] = STATE(542),
    [sym_mul_expr] = STATE(542),
    [sym_add_expr] = STATE(542),
    [sym_in_expr] = STATE(542),
    [sym_comp_term] = STATE(542),
    [sym_instance_of] = STATE(542),
    [sym_negation] = STATE(542),
    [sym_if_term] = STATE(542),
    [sym_conjunction] = STATE(542),
    [sym_disjunction] = STATE(542),
    [sym_implication] = STATE(542),
    [sym_quantified] = STATE(542),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(542),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [166] = {
    [sym_special_call] = STATE(555),
    [sym_prefix_cast] = STATE(555),
    [sym_unary_expr] = STATE(555),
    [sym_mul_expr] = STATE(555),
    [sym_add_expr] = STATE(555),
    [sym_in_expr] = STATE(555),
    [sym_comp_term] = STATE(555),
    [sym_instance_of] = STATE(555),
    [sym_negation] = STATE(555),
    [sym_if_term] = STATE(555),
    [sym_conjunction] = STATE(555),
    [sym_disjunction] = STATE(555),
    [sym_implication] = STATE(555),
    [sym_quantified] = STATE(555),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(555),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [167] = {
    [sym_special_call] = STATE(551),
    [sym_prefix_cast] = STATE(551),
    [sym_unary_expr] = STATE(551),
    [sym_mul_expr] = STATE(551),
    [sym_add_expr] = STATE(551),
    [sym_in_expr] = STATE(551),
    [sym_comp_term] = STATE(551),
    [sym_instance_of] = STATE(551),
    [sym_negation] = STATE(551),
    [sym_if_term] = STATE(551),
    [sym_conjunction] = STATE(551),
    [sym_disjunction] = STATE(551),
    [sym_implication] = STATE(551),
    [sym_quantified] = STATE(551),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(551),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [168] = {
    [sym_special_call] = STATE(723),
    [sym_prefix_cast] = STATE(723),
    [sym_unary_expr] = STATE(723),
    [sym_mul_expr] = STATE(723),
    [sym_add_expr] = STATE(723),
    [sym_in_expr] = STATE(723),
    [sym_comp_term] = STATE(723),
    [sym_instance_of] = STATE(723),
    [sym_negation] = STATE(723),
    [sym_if_term] = STATE(723),
    [sym_conjunction] = STATE(723),
    [sym_disjunction] = STATE(723),
    [sym_implication] = STATE(723),
    [sym_quantified] = STATE(723),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(723),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [169] = {
    [sym_special_call] = STATE(755),
    [sym_prefix_cast] = STATE(755),
    [sym_unary_expr] = STATE(755),
    [sym_mul_expr] = STATE(755),
    [sym_add_expr] = STATE(755),
    [sym_in_expr] = STATE(755),
    [sym_comp_term] = STATE(755),
    [sym_instance_of] = STATE(755),
    [sym_negation] = STATE(755),
    [sym_if_term] = STATE(755),
    [sym_conjunction] = STATE(755),
    [sym_disjunction] = STATE(755),
    [sym_implication] = STATE(755),
    [sym_quantified] = STATE(755),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(755),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [170] = {
    [sym_special_call] = STATE(712),
    [sym_prefix_cast] = STATE(712),
    [sym_unary_expr] = STATE(712),
    [sym_mul_expr] = STATE(712),
    [sym_add_expr] = STATE(712),
    [sym_in_expr] = STATE(712),
    [sym_comp_term] = STATE(712),
    [sym_instance_of] = STATE(712),
    [sym_negation] = STATE(712),
    [sym_if_term] = STATE(712),
    [sym_conjunction] = STATE(712),
    [sym_disjunction] = STATE(712),
    [sym_implication] = STATE(712),
    [sym_quantified] = STATE(712),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(712),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [171] = {
    [sym_special_call] = STATE(583),
    [sym_prefix_cast] = STATE(583),
    [sym_unary_expr] = STATE(583),
    [sym_mul_expr] = STATE(583),
    [sym_add_expr] = STATE(583),
    [sym_in_expr] = STATE(583),
    [sym_comp_term] = STATE(583),
    [sym_instance_of] = STATE(583),
    [sym_negation] = STATE(583),
    [sym_if_term] = STATE(583),
    [sym_conjunction] = STATE(583),
    [sym_disjunction] = STATE(583),
    [sym_implication] = STATE(583),
    [sym_quantified] = STATE(583),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(583),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [172] = {
    [sym_special_call] = STATE(750),
    [sym_prefix_cast] = STATE(750),
    [sym_unary_expr] = STATE(750),
    [sym_mul_expr] = STATE(750),
    [sym_add_expr] = STATE(750),
    [sym_in_expr] = STATE(750),
    [sym_comp_term] = STATE(750),
    [sym_instance_of] = STATE(750),
    [sym_negation] = STATE(750),
    [sym_if_term] = STATE(750),
    [sym_conjunction] = STATE(750),
    [sym_disjunction] = STATE(750),
    [sym_implication] = STATE(750),
    [sym_quantified] = STATE(750),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(750),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [173] = {
    [sym_special_call] = STATE(751),
    [sym_prefix_cast] = STATE(751),
    [sym_unary_expr] = STATE(751),
    [sym_mul_expr] = STATE(751),
    [sym_add_expr] = STATE(751),
    [sym_in_expr] = STATE(751),
    [sym_comp_term] = STATE(751),
    [sym_instance_of] = STATE(751),
    [sym_negation] = STATE(751),
    [sym_if_term] = STATE(751),
    [sym_conjunction] = STATE(751),
    [sym_disjunction] = STATE(751),
    [sym_implication] = STATE(751),
    [sym_quantified] = STATE(751),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(751),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [174] = {
    [sym_special_call] = STATE(272),
    [sym_prefix_cast] = STATE(272),
    [sym_unary_expr] = STATE(272),
    [sym_mul_expr] = STATE(272),
    [sym_add_expr] = STATE(272),
    [sym_in_expr] = STATE(272),
    [sym_comp_term] = STATE(272),
    [sym_instance_of] = STATE(272),
    [sym_negation] = STATE(272),
    [sym_if_term] = STATE(272),
    [sym_conjunction] = STATE(272),
    [sym_disjunction] = STATE(272),
    [sym_implication] = STATE(272),
    [sym_quantified] = STATE(272),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(272),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [175] = {
    [sym_special_call] = STATE(553),
    [sym_prefix_cast] = STATE(553),
    [sym_unary_expr] = STATE(553),
    [sym_mul_expr] = STATE(553),
    [sym_add_expr] = STATE(553),
    [sym_in_expr] = STATE(553),
    [sym_comp_term] = STATE(553),
    [sym_instance_of] = STATE(553),
    [sym_negation] = STATE(553),
    [sym_if_term] = STATE(553),
    [sym_conjunction] = STATE(553),
    [sym_disjunction] = STATE(553),
    [sym_implication] = STATE(553),
    [sym_quantified] = STATE(553),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(553),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [176] = {
    [sym_special_call] = STATE(653),
    [sym_prefix_cast] = STATE(653),
    [sym_unary_expr] = STATE(653),
    [sym_mul_expr] = STATE(653),
    [sym_add_expr] = STATE(653),
    [sym_in_expr] = STATE(653),
    [sym_comp_term] = STATE(653),
    [sym_instance_of] = STATE(653),
    [sym_negation] = STATE(653),
    [sym_if_term] = STATE(653),
    [sym_conjunction] = STATE(653),
    [sym_disjunction] = STATE(653),
    [sym_implication] = STATE(653),
    [sym_quantified] = STATE(653),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(653),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [177] = {
    [sym_special_call] = STATE(293),
    [sym_prefix_cast] = STATE(293),
    [sym_unary_expr] = STATE(293),
    [sym_mul_expr] = STATE(293),
    [sym_add_expr] = STATE(293),
    [sym_in_expr] = STATE(293),
    [sym_comp_term] = STATE(293),
    [sym_instance_of] = STATE(293),
    [sym_negation] = STATE(293),
    [sym_if_term] = STATE(293),
    [sym_conjunction] = STATE(293),
    [sym_disjunction] = STATE(293),
    [sym_implication] = STATE(293),
    [sym_quantified] = STATE(293),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(293),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [178] = {
    [sym_special_call] = STATE(290),
    [sym_prefix_cast] = STATE(290),
    [sym_unary_expr] = STATE(290),
    [sym_mul_expr] = STATE(290),
    [sym_add_expr] = STATE(290),
    [sym_in_expr] = STATE(290),
    [sym_comp_term] = STATE(290),
    [sym_instance_of] = STATE(290),
    [sym_negation] = STATE(290),
    [sym_if_term] = STATE(290),
    [sym_conjunction] = STATE(290),
    [sym_disjunction] = STATE(290),
    [sym_implication] = STATE(290),
    [sym_quantified] = STATE(290),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(290),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [179] = {
    [sym_special_call] = STATE(288),
    [sym_prefix_cast] = STATE(288),
    [sym_unary_expr] = STATE(288),
    [sym_mul_expr] = STATE(288),
    [sym_add_expr] = STATE(288),
    [sym_in_expr] = STATE(288),
    [sym_comp_term] = STATE(288),
    [sym_instance_of] = STATE(288),
    [sym_negation] = STATE(288),
    [sym_if_term] = STATE(288),
    [sym_conjunction] = STATE(288),
    [sym_disjunction] = STATE(288),
    [sym_implication] = STATE(288),
    [sym_quantified] = STATE(288),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(288),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [180] = {
    [sym_special_call] = STATE(545),
    [sym_prefix_cast] = STATE(545),
    [sym_unary_expr] = STATE(545),
    [sym_mul_expr] = STATE(545),
    [sym_add_expr] = STATE(545),
    [sym_in_expr] = STATE(545),
    [sym_comp_term] = STATE(545),
    [sym_instance_of] = STATE(545),
    [sym_negation] = STATE(545),
    [sym_if_term] = STATE(545),
    [sym_conjunction] = STATE(545),
    [sym_disjunction] = STATE(545),
    [sym_implication] = STATE(545),
    [sym_quantified] = STATE(545),
    [sym_specialId] = STATE(1164),
    [sym_quantifier] = STATE(1163),
    [sym_classless_predicate_call] = STATE(594),
    [sym_qualified_expr] = STATE(594),
    [sym_super_ref] = STATE(594),
    [sym_aggregate] = STATE(594),
    [sym_range] = STATE(594),
    [sym_par_expr] = STATE(594),
    [sym__exprOrTerm] = STATE(545),
    [sym__primary] = STATE(594),
    [sym_literal] = STATE(594),
    [sym_bool] = STATE(590),
    [sym_variable] = STATE(594),
    [sym_unop] = STATE(175),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(562),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1175),
    [sym_aritylessPredicateExpr] = STATE(932),
    [sym_varName] = STATE(592),
    [sym_aggId] = STATE(1157),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(47),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(49),
    [sym_float] = ACTIONS(51),
    [sym_string] = ACTIONS(51),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(57),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(59),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(63),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(65),
    [sym_this] = ACTIONS(63),
    [sym_true] = ACTIONS(57),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [181] = {
    [sym_special_call] = STATE(282),
    [sym_prefix_cast] = STATE(282),
    [sym_unary_expr] = STATE(282),
    [sym_mul_expr] = STATE(282),
    [sym_add_expr] = STATE(282),
    [sym_in_expr] = STATE(282),
    [sym_comp_term] = STATE(282),
    [sym_instance_of] = STATE(282),
    [sym_negation] = STATE(282),
    [sym_if_term] = STATE(282),
    [sym_conjunction] = STATE(282),
    [sym_disjunction] = STATE(282),
    [sym_implication] = STATE(282),
    [sym_quantified] = STATE(282),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(282),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [182] = {
    [sym_special_call] = STATE(759),
    [sym_prefix_cast] = STATE(759),
    [sym_unary_expr] = STATE(759),
    [sym_mul_expr] = STATE(759),
    [sym_add_expr] = STATE(759),
    [sym_in_expr] = STATE(759),
    [sym_comp_term] = STATE(759),
    [sym_instance_of] = STATE(759),
    [sym_negation] = STATE(759),
    [sym_if_term] = STATE(759),
    [sym_conjunction] = STATE(759),
    [sym_disjunction] = STATE(759),
    [sym_implication] = STATE(759),
    [sym_quantified] = STATE(759),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(759),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1125),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [183] = {
    [sym_special_call] = STATE(253),
    [sym_prefix_cast] = STATE(253),
    [sym_unary_expr] = STATE(253),
    [sym_mul_expr] = STATE(253),
    [sym_add_expr] = STATE(253),
    [sym_in_expr] = STATE(253),
    [sym_comp_term] = STATE(253),
    [sym_instance_of] = STATE(253),
    [sym_negation] = STATE(253),
    [sym_if_term] = STATE(253),
    [sym_conjunction] = STATE(253),
    [sym_disjunction] = STATE(253),
    [sym_implication] = STATE(253),
    [sym_quantified] = STATE(253),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(253),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [184] = {
    [sym_special_call] = STATE(566),
    [sym_prefix_cast] = STATE(566),
    [sym_unary_expr] = STATE(566),
    [sym_mul_expr] = STATE(566),
    [sym_add_expr] = STATE(566),
    [sym_in_expr] = STATE(566),
    [sym_comp_term] = STATE(566),
    [sym_instance_of] = STATE(566),
    [sym_negation] = STATE(566),
    [sym_if_term] = STATE(566),
    [sym_conjunction] = STATE(566),
    [sym_disjunction] = STATE(566),
    [sym_implication] = STATE(566),
    [sym_quantified] = STATE(566),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(566),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [185] = {
    [sym_special_call] = STATE(720),
    [sym_prefix_cast] = STATE(720),
    [sym_unary_expr] = STATE(720),
    [sym_mul_expr] = STATE(720),
    [sym_add_expr] = STATE(720),
    [sym_in_expr] = STATE(720),
    [sym_comp_term] = STATE(720),
    [sym_instance_of] = STATE(720),
    [sym_negation] = STATE(720),
    [sym_if_term] = STATE(720),
    [sym_conjunction] = STATE(720),
    [sym_disjunction] = STATE(720),
    [sym_implication] = STATE(720),
    [sym_quantified] = STATE(720),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(720),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [186] = {
    [sym_special_call] = STATE(718),
    [sym_prefix_cast] = STATE(718),
    [sym_unary_expr] = STATE(718),
    [sym_mul_expr] = STATE(718),
    [sym_add_expr] = STATE(718),
    [sym_in_expr] = STATE(718),
    [sym_comp_term] = STATE(718),
    [sym_instance_of] = STATE(718),
    [sym_negation] = STATE(718),
    [sym_if_term] = STATE(718),
    [sym_conjunction] = STATE(718),
    [sym_disjunction] = STATE(718),
    [sym_implication] = STATE(718),
    [sym_quantified] = STATE(718),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(718),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [187] = {
    [sym_special_call] = STATE(533),
    [sym_prefix_cast] = STATE(533),
    [sym_unary_expr] = STATE(533),
    [sym_mul_expr] = STATE(533),
    [sym_add_expr] = STATE(533),
    [sym_in_expr] = STATE(533),
    [sym_comp_term] = STATE(533),
    [sym_instance_of] = STATE(533),
    [sym_negation] = STATE(533),
    [sym_if_term] = STATE(533),
    [sym_conjunction] = STATE(533),
    [sym_disjunction] = STATE(533),
    [sym_implication] = STATE(533),
    [sym_quantified] = STATE(533),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(533),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [188] = {
    [sym_special_call] = STATE(715),
    [sym_prefix_cast] = STATE(715),
    [sym_unary_expr] = STATE(715),
    [sym_mul_expr] = STATE(715),
    [sym_add_expr] = STATE(715),
    [sym_in_expr] = STATE(715),
    [sym_comp_term] = STATE(715),
    [sym_instance_of] = STATE(715),
    [sym_negation] = STATE(715),
    [sym_if_term] = STATE(715),
    [sym_conjunction] = STATE(715),
    [sym_disjunction] = STATE(715),
    [sym_implication] = STATE(715),
    [sym_quantified] = STATE(715),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(715),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [189] = {
    [sym_special_call] = STATE(534),
    [sym_prefix_cast] = STATE(534),
    [sym_unary_expr] = STATE(534),
    [sym_mul_expr] = STATE(534),
    [sym_add_expr] = STATE(534),
    [sym_in_expr] = STATE(534),
    [sym_comp_term] = STATE(534),
    [sym_instance_of] = STATE(534),
    [sym_negation] = STATE(534),
    [sym_if_term] = STATE(534),
    [sym_conjunction] = STATE(534),
    [sym_disjunction] = STATE(534),
    [sym_implication] = STATE(534),
    [sym_quantified] = STATE(534),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(534),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [190] = {
    [sym_special_call] = STATE(539),
    [sym_prefix_cast] = STATE(539),
    [sym_unary_expr] = STATE(539),
    [sym_mul_expr] = STATE(539),
    [sym_add_expr] = STATE(539),
    [sym_in_expr] = STATE(539),
    [sym_comp_term] = STATE(539),
    [sym_instance_of] = STATE(539),
    [sym_negation] = STATE(539),
    [sym_if_term] = STATE(539),
    [sym_conjunction] = STATE(539),
    [sym_disjunction] = STATE(539),
    [sym_implication] = STATE(539),
    [sym_quantified] = STATE(539),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(539),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [191] = {
    [sym_special_call] = STATE(605),
    [sym_prefix_cast] = STATE(605),
    [sym_unary_expr] = STATE(605),
    [sym_mul_expr] = STATE(605),
    [sym_add_expr] = STATE(605),
    [sym_in_expr] = STATE(605),
    [sym_comp_term] = STATE(605),
    [sym_instance_of] = STATE(605),
    [sym_negation] = STATE(605),
    [sym_if_term] = STATE(605),
    [sym_conjunction] = STATE(605),
    [sym_disjunction] = STATE(605),
    [sym_implication] = STATE(605),
    [sym_quantified] = STATE(605),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(605),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [192] = {
    [sym_special_call] = STATE(532),
    [sym_prefix_cast] = STATE(532),
    [sym_unary_expr] = STATE(532),
    [sym_mul_expr] = STATE(532),
    [sym_add_expr] = STATE(532),
    [sym_in_expr] = STATE(532),
    [sym_comp_term] = STATE(532),
    [sym_instance_of] = STATE(532),
    [sym_negation] = STATE(532),
    [sym_if_term] = STATE(532),
    [sym_conjunction] = STATE(532),
    [sym_disjunction] = STATE(532),
    [sym_implication] = STATE(532),
    [sym_quantified] = STATE(532),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(532),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [193] = {
    [sym_special_call] = STATE(538),
    [sym_prefix_cast] = STATE(538),
    [sym_unary_expr] = STATE(538),
    [sym_mul_expr] = STATE(538),
    [sym_add_expr] = STATE(538),
    [sym_in_expr] = STATE(538),
    [sym_comp_term] = STATE(538),
    [sym_instance_of] = STATE(538),
    [sym_negation] = STATE(538),
    [sym_if_term] = STATE(538),
    [sym_conjunction] = STATE(538),
    [sym_disjunction] = STATE(538),
    [sym_implication] = STATE(538),
    [sym_quantified] = STATE(538),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(538),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [194] = {
    [sym_special_call] = STATE(251),
    [sym_prefix_cast] = STATE(251),
    [sym_unary_expr] = STATE(251),
    [sym_mul_expr] = STATE(251),
    [sym_add_expr] = STATE(251),
    [sym_in_expr] = STATE(251),
    [sym_comp_term] = STATE(251),
    [sym_instance_of] = STATE(251),
    [sym_negation] = STATE(251),
    [sym_if_term] = STATE(251),
    [sym_conjunction] = STATE(251),
    [sym_disjunction] = STATE(251),
    [sym_implication] = STATE(251),
    [sym_quantified] = STATE(251),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(251),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [195] = {
    [sym_special_call] = STATE(289),
    [sym_prefix_cast] = STATE(289),
    [sym_unary_expr] = STATE(289),
    [sym_mul_expr] = STATE(289),
    [sym_add_expr] = STATE(289),
    [sym_in_expr] = STATE(289),
    [sym_comp_term] = STATE(289),
    [sym_instance_of] = STATE(289),
    [sym_negation] = STATE(289),
    [sym_if_term] = STATE(289),
    [sym_conjunction] = STATE(289),
    [sym_disjunction] = STATE(289),
    [sym_implication] = STATE(289),
    [sym_quantified] = STATE(289),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(289),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [196] = {
    [sym_special_call] = STATE(536),
    [sym_prefix_cast] = STATE(536),
    [sym_unary_expr] = STATE(536),
    [sym_mul_expr] = STATE(536),
    [sym_add_expr] = STATE(536),
    [sym_in_expr] = STATE(536),
    [sym_comp_term] = STATE(536),
    [sym_instance_of] = STATE(536),
    [sym_negation] = STATE(536),
    [sym_if_term] = STATE(536),
    [sym_conjunction] = STATE(536),
    [sym_disjunction] = STATE(536),
    [sym_implication] = STATE(536),
    [sym_quantified] = STATE(536),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(536),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [197] = {
    [sym_special_call] = STATE(681),
    [sym_prefix_cast] = STATE(681),
    [sym_unary_expr] = STATE(681),
    [sym_mul_expr] = STATE(681),
    [sym_add_expr] = STATE(681),
    [sym_in_expr] = STATE(681),
    [sym_comp_term] = STATE(681),
    [sym_instance_of] = STATE(681),
    [sym_negation] = STATE(681),
    [sym_if_term] = STATE(681),
    [sym_conjunction] = STATE(681),
    [sym_disjunction] = STATE(681),
    [sym_implication] = STATE(681),
    [sym_quantified] = STATE(681),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(681),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [198] = {
    [sym_special_call] = STATE(540),
    [sym_prefix_cast] = STATE(540),
    [sym_unary_expr] = STATE(540),
    [sym_mul_expr] = STATE(540),
    [sym_add_expr] = STATE(540),
    [sym_in_expr] = STATE(540),
    [sym_comp_term] = STATE(540),
    [sym_instance_of] = STATE(540),
    [sym_negation] = STATE(540),
    [sym_if_term] = STATE(540),
    [sym_conjunction] = STATE(540),
    [sym_disjunction] = STATE(540),
    [sym_implication] = STATE(540),
    [sym_quantified] = STATE(540),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(540),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [199] = {
    [sym_special_call] = STATE(537),
    [sym_prefix_cast] = STATE(537),
    [sym_unary_expr] = STATE(537),
    [sym_mul_expr] = STATE(537),
    [sym_add_expr] = STATE(537),
    [sym_in_expr] = STATE(537),
    [sym_comp_term] = STATE(537),
    [sym_instance_of] = STATE(537),
    [sym_negation] = STATE(537),
    [sym_if_term] = STATE(537),
    [sym_conjunction] = STATE(537),
    [sym_disjunction] = STATE(537),
    [sym_implication] = STATE(537),
    [sym_quantified] = STATE(537),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(537),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [200] = {
    [sym_special_call] = STATE(713),
    [sym_prefix_cast] = STATE(713),
    [sym_unary_expr] = STATE(713),
    [sym_mul_expr] = STATE(713),
    [sym_add_expr] = STATE(713),
    [sym_in_expr] = STATE(713),
    [sym_comp_term] = STATE(713),
    [sym_instance_of] = STATE(713),
    [sym_negation] = STATE(713),
    [sym_if_term] = STATE(713),
    [sym_conjunction] = STATE(713),
    [sym_disjunction] = STATE(713),
    [sym_implication] = STATE(713),
    [sym_quantified] = STATE(713),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(713),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1134),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [201] = {
    [sym_special_call] = STATE(677),
    [sym_prefix_cast] = STATE(677),
    [sym_unary_expr] = STATE(677),
    [sym_mul_expr] = STATE(677),
    [sym_add_expr] = STATE(677),
    [sym_in_expr] = STATE(677),
    [sym_comp_term] = STATE(677),
    [sym_instance_of] = STATE(677),
    [sym_negation] = STATE(677),
    [sym_if_term] = STATE(677),
    [sym_conjunction] = STATE(677),
    [sym_disjunction] = STATE(677),
    [sym_implication] = STATE(677),
    [sym_quantified] = STATE(677),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(677),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [202] = {
    [sym_special_call] = STATE(709),
    [sym_prefix_cast] = STATE(709),
    [sym_unary_expr] = STATE(709),
    [sym_mul_expr] = STATE(709),
    [sym_add_expr] = STATE(709),
    [sym_in_expr] = STATE(709),
    [sym_comp_term] = STATE(709),
    [sym_instance_of] = STATE(709),
    [sym_negation] = STATE(709),
    [sym_if_term] = STATE(709),
    [sym_conjunction] = STATE(709),
    [sym_disjunction] = STATE(709),
    [sym_implication] = STATE(709),
    [sym_quantified] = STATE(709),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(709),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [203] = {
    [sym_special_call] = STATE(706),
    [sym_prefix_cast] = STATE(706),
    [sym_unary_expr] = STATE(706),
    [sym_mul_expr] = STATE(706),
    [sym_add_expr] = STATE(706),
    [sym_in_expr] = STATE(706),
    [sym_comp_term] = STATE(706),
    [sym_instance_of] = STATE(706),
    [sym_negation] = STATE(706),
    [sym_if_term] = STATE(706),
    [sym_conjunction] = STATE(706),
    [sym_disjunction] = STATE(706),
    [sym_implication] = STATE(706),
    [sym_quantified] = STATE(706),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(706),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [204] = {
    [sym_special_call] = STATE(535),
    [sym_prefix_cast] = STATE(535),
    [sym_unary_expr] = STATE(535),
    [sym_mul_expr] = STATE(535),
    [sym_add_expr] = STATE(535),
    [sym_in_expr] = STATE(535),
    [sym_comp_term] = STATE(535),
    [sym_instance_of] = STATE(535),
    [sym_negation] = STATE(535),
    [sym_if_term] = STATE(535),
    [sym_conjunction] = STATE(535),
    [sym_disjunction] = STATE(535),
    [sym_implication] = STATE(535),
    [sym_quantified] = STATE(535),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(535),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [205] = {
    [sym_special_call] = STATE(531),
    [sym_prefix_cast] = STATE(531),
    [sym_unary_expr] = STATE(531),
    [sym_mul_expr] = STATE(531),
    [sym_add_expr] = STATE(531),
    [sym_in_expr] = STATE(531),
    [sym_comp_term] = STATE(531),
    [sym_instance_of] = STATE(531),
    [sym_negation] = STATE(531),
    [sym_if_term] = STATE(531),
    [sym_conjunction] = STATE(531),
    [sym_disjunction] = STATE(531),
    [sym_implication] = STATE(531),
    [sym_quantified] = STATE(531),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(531),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [206] = {
    [sym_special_call] = STATE(742),
    [sym_prefix_cast] = STATE(742),
    [sym_unary_expr] = STATE(742),
    [sym_mul_expr] = STATE(742),
    [sym_add_expr] = STATE(742),
    [sym_in_expr] = STATE(742),
    [sym_comp_term] = STATE(742),
    [sym_instance_of] = STATE(742),
    [sym_negation] = STATE(742),
    [sym_if_term] = STATE(742),
    [sym_conjunction] = STATE(742),
    [sym_disjunction] = STATE(742),
    [sym_implication] = STATE(742),
    [sym_quantified] = STATE(742),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(742),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [207] = {
    [sym_special_call] = STATE(252),
    [sym_prefix_cast] = STATE(252),
    [sym_unary_expr] = STATE(252),
    [sym_mul_expr] = STATE(252),
    [sym_add_expr] = STATE(252),
    [sym_in_expr] = STATE(252),
    [sym_comp_term] = STATE(252),
    [sym_instance_of] = STATE(252),
    [sym_negation] = STATE(252),
    [sym_if_term] = STATE(252),
    [sym_conjunction] = STATE(252),
    [sym_disjunction] = STATE(252),
    [sym_implication] = STATE(252),
    [sym_quantified] = STATE(252),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(252),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [208] = {
    [sym_special_call] = STATE(521),
    [sym_prefix_cast] = STATE(521),
    [sym_unary_expr] = STATE(521),
    [sym_mul_expr] = STATE(521),
    [sym_add_expr] = STATE(521),
    [sym_in_expr] = STATE(521),
    [sym_comp_term] = STATE(521),
    [sym_instance_of] = STATE(521),
    [sym_negation] = STATE(521),
    [sym_if_term] = STATE(521),
    [sym_conjunction] = STATE(521),
    [sym_disjunction] = STATE(521),
    [sym_implication] = STATE(521),
    [sym_quantified] = STATE(521),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(521),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [209] = {
    [sym_special_call] = STATE(256),
    [sym_prefix_cast] = STATE(256),
    [sym_unary_expr] = STATE(256),
    [sym_mul_expr] = STATE(256),
    [sym_add_expr] = STATE(256),
    [sym_in_expr] = STATE(256),
    [sym_comp_term] = STATE(256),
    [sym_instance_of] = STATE(256),
    [sym_negation] = STATE(256),
    [sym_if_term] = STATE(256),
    [sym_conjunction] = STATE(256),
    [sym_disjunction] = STATE(256),
    [sym_implication] = STATE(256),
    [sym_quantified] = STATE(256),
    [sym_specialId] = STATE(1191),
    [sym_quantifier] = STATE(1190),
    [sym_classless_predicate_call] = STATE(353),
    [sym_qualified_expr] = STATE(353),
    [sym_super_ref] = STATE(353),
    [sym_aggregate] = STATE(353),
    [sym_range] = STATE(353),
    [sym_par_expr] = STATE(353),
    [sym__exprOrTerm] = STATE(256),
    [sym__primary] = STATE(353),
    [sym_literal] = STATE(353),
    [sym_bool] = STATE(360),
    [sym_variable] = STATE(353),
    [sym_unop] = STATE(156),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(296),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1188),
    [sym_aritylessPredicateExpr] = STATE(953),
    [sym_varName] = STATE(355),
    [sym_aggId] = STATE(1135),
    [sym__lower_id] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(277),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(279),
    [sym_float] = ACTIONS(281),
    [sym_string] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(283),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(285),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(287),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(289),
    [sym_this] = ACTIONS(287),
    [sym_true] = ACTIONS(283),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [210] = {
    [sym_special_call] = STATE(270),
    [sym_prefix_cast] = STATE(270),
    [sym_unary_expr] = STATE(270),
    [sym_mul_expr] = STATE(270),
    [sym_add_expr] = STATE(270),
    [sym_in_expr] = STATE(270),
    [sym_comp_term] = STATE(270),
    [sym_instance_of] = STATE(270),
    [sym_negation] = STATE(270),
    [sym_if_term] = STATE(270),
    [sym_conjunction] = STATE(270),
    [sym_disjunction] = STATE(270),
    [sym_implication] = STATE(270),
    [sym_quantified] = STATE(270),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(270),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [211] = {
    [sym_special_call] = STATE(632),
    [sym_prefix_cast] = STATE(632),
    [sym_unary_expr] = STATE(632),
    [sym_mul_expr] = STATE(632),
    [sym_add_expr] = STATE(632),
    [sym_in_expr] = STATE(632),
    [sym_comp_term] = STATE(632),
    [sym_instance_of] = STATE(632),
    [sym_negation] = STATE(632),
    [sym_if_term] = STATE(632),
    [sym_conjunction] = STATE(632),
    [sym_disjunction] = STATE(632),
    [sym_implication] = STATE(632),
    [sym_quantified] = STATE(632),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(632),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [212] = {
    [sym_special_call] = STATE(754),
    [sym_prefix_cast] = STATE(754),
    [sym_unary_expr] = STATE(754),
    [sym_mul_expr] = STATE(754),
    [sym_add_expr] = STATE(754),
    [sym_in_expr] = STATE(754),
    [sym_comp_term] = STATE(754),
    [sym_instance_of] = STATE(754),
    [sym_negation] = STATE(754),
    [sym_if_term] = STATE(754),
    [sym_conjunction] = STATE(754),
    [sym_disjunction] = STATE(754),
    [sym_implication] = STATE(754),
    [sym_quantified] = STATE(754),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(754),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1122),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [213] = {
    [sym_special_call] = STATE(657),
    [sym_prefix_cast] = STATE(657),
    [sym_unary_expr] = STATE(657),
    [sym_mul_expr] = STATE(657),
    [sym_add_expr] = STATE(657),
    [sym_in_expr] = STATE(657),
    [sym_comp_term] = STATE(657),
    [sym_instance_of] = STATE(657),
    [sym_negation] = STATE(657),
    [sym_if_term] = STATE(657),
    [sym_conjunction] = STATE(657),
    [sym_disjunction] = STATE(657),
    [sym_implication] = STATE(657),
    [sym_quantified] = STATE(657),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(657),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [214] = {
    [sym_special_call] = STATE(520),
    [sym_prefix_cast] = STATE(520),
    [sym_unary_expr] = STATE(520),
    [sym_mul_expr] = STATE(520),
    [sym_add_expr] = STATE(520),
    [sym_in_expr] = STATE(520),
    [sym_comp_term] = STATE(520),
    [sym_instance_of] = STATE(520),
    [sym_negation] = STATE(520),
    [sym_if_term] = STATE(520),
    [sym_conjunction] = STATE(520),
    [sym_disjunction] = STATE(520),
    [sym_implication] = STATE(520),
    [sym_quantified] = STATE(520),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(520),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [215] = {
    [sym_special_call] = STATE(659),
    [sym_prefix_cast] = STATE(659),
    [sym_unary_expr] = STATE(659),
    [sym_mul_expr] = STATE(659),
    [sym_add_expr] = STATE(659),
    [sym_in_expr] = STATE(659),
    [sym_comp_term] = STATE(659),
    [sym_instance_of] = STATE(659),
    [sym_negation] = STATE(659),
    [sym_if_term] = STATE(659),
    [sym_conjunction] = STATE(659),
    [sym_disjunction] = STATE(659),
    [sym_implication] = STATE(659),
    [sym_quantified] = STATE(659),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(659),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [216] = {
    [sym_special_call] = STATE(660),
    [sym_prefix_cast] = STATE(660),
    [sym_unary_expr] = STATE(660),
    [sym_mul_expr] = STATE(660),
    [sym_add_expr] = STATE(660),
    [sym_in_expr] = STATE(660),
    [sym_comp_term] = STATE(660),
    [sym_instance_of] = STATE(660),
    [sym_negation] = STATE(660),
    [sym_if_term] = STATE(660),
    [sym_conjunction] = STATE(660),
    [sym_disjunction] = STATE(660),
    [sym_implication] = STATE(660),
    [sym_quantified] = STATE(660),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(660),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [217] = {
    [sym_special_call] = STATE(753),
    [sym_prefix_cast] = STATE(753),
    [sym_unary_expr] = STATE(753),
    [sym_mul_expr] = STATE(753),
    [sym_add_expr] = STATE(753),
    [sym_in_expr] = STATE(753),
    [sym_comp_term] = STATE(753),
    [sym_instance_of] = STATE(753),
    [sym_negation] = STATE(753),
    [sym_if_term] = STATE(753),
    [sym_conjunction] = STATE(753),
    [sym_disjunction] = STATE(753),
    [sym_implication] = STATE(753),
    [sym_quantified] = STATE(753),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(753),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [218] = {
    [sym_special_call] = STATE(260),
    [sym_prefix_cast] = STATE(260),
    [sym_unary_expr] = STATE(260),
    [sym_mul_expr] = STATE(260),
    [sym_add_expr] = STATE(260),
    [sym_in_expr] = STATE(260),
    [sym_comp_term] = STATE(260),
    [sym_instance_of] = STATE(260),
    [sym_negation] = STATE(260),
    [sym_if_term] = STATE(260),
    [sym_conjunction] = STATE(260),
    [sym_disjunction] = STATE(260),
    [sym_implication] = STATE(260),
    [sym_quantified] = STATE(260),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(260),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [219] = {
    [sym_special_call] = STATE(271),
    [sym_prefix_cast] = STATE(271),
    [sym_unary_expr] = STATE(271),
    [sym_mul_expr] = STATE(271),
    [sym_add_expr] = STATE(271),
    [sym_in_expr] = STATE(271),
    [sym_comp_term] = STATE(271),
    [sym_instance_of] = STATE(271),
    [sym_negation] = STATE(271),
    [sym_if_term] = STATE(271),
    [sym_conjunction] = STATE(271),
    [sym_disjunction] = STATE(271),
    [sym_implication] = STATE(271),
    [sym_quantified] = STATE(271),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(271),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [220] = {
    [sym_special_call] = STATE(661),
    [sym_prefix_cast] = STATE(661),
    [sym_unary_expr] = STATE(661),
    [sym_mul_expr] = STATE(661),
    [sym_add_expr] = STATE(661),
    [sym_in_expr] = STATE(661),
    [sym_comp_term] = STATE(661),
    [sym_instance_of] = STATE(661),
    [sym_negation] = STATE(661),
    [sym_if_term] = STATE(661),
    [sym_conjunction] = STATE(661),
    [sym_disjunction] = STATE(661),
    [sym_implication] = STATE(661),
    [sym_quantified] = STATE(661),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(661),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [221] = {
    [sym_special_call] = STATE(261),
    [sym_prefix_cast] = STATE(261),
    [sym_unary_expr] = STATE(261),
    [sym_mul_expr] = STATE(261),
    [sym_add_expr] = STATE(261),
    [sym_in_expr] = STATE(261),
    [sym_comp_term] = STATE(261),
    [sym_instance_of] = STATE(261),
    [sym_negation] = STATE(261),
    [sym_if_term] = STATE(261),
    [sym_conjunction] = STATE(261),
    [sym_disjunction] = STATE(261),
    [sym_implication] = STATE(261),
    [sym_quantified] = STATE(261),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(261),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [222] = {
    [sym_special_call] = STATE(262),
    [sym_prefix_cast] = STATE(262),
    [sym_unary_expr] = STATE(262),
    [sym_mul_expr] = STATE(262),
    [sym_add_expr] = STATE(262),
    [sym_in_expr] = STATE(262),
    [sym_comp_term] = STATE(262),
    [sym_instance_of] = STATE(262),
    [sym_negation] = STATE(262),
    [sym_if_term] = STATE(262),
    [sym_conjunction] = STATE(262),
    [sym_disjunction] = STATE(262),
    [sym_implication] = STATE(262),
    [sym_quantified] = STATE(262),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(262),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [223] = {
    [sym_special_call] = STATE(268),
    [sym_prefix_cast] = STATE(268),
    [sym_unary_expr] = STATE(268),
    [sym_mul_expr] = STATE(268),
    [sym_add_expr] = STATE(268),
    [sym_in_expr] = STATE(268),
    [sym_comp_term] = STATE(268),
    [sym_instance_of] = STATE(268),
    [sym_negation] = STATE(268),
    [sym_if_term] = STATE(268),
    [sym_conjunction] = STATE(268),
    [sym_disjunction] = STATE(268),
    [sym_implication] = STATE(268),
    [sym_quantified] = STATE(268),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(268),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [224] = {
    [sym_special_call] = STATE(291),
    [sym_prefix_cast] = STATE(291),
    [sym_unary_expr] = STATE(291),
    [sym_mul_expr] = STATE(291),
    [sym_add_expr] = STATE(291),
    [sym_in_expr] = STATE(291),
    [sym_comp_term] = STATE(291),
    [sym_instance_of] = STATE(291),
    [sym_negation] = STATE(291),
    [sym_if_term] = STATE(291),
    [sym_conjunction] = STATE(291),
    [sym_disjunction] = STATE(291),
    [sym_implication] = STATE(291),
    [sym_quantified] = STATE(291),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(291),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [225] = {
    [sym_special_call] = STATE(601),
    [sym_prefix_cast] = STATE(601),
    [sym_unary_expr] = STATE(601),
    [sym_mul_expr] = STATE(601),
    [sym_add_expr] = STATE(601),
    [sym_in_expr] = STATE(601),
    [sym_comp_term] = STATE(601),
    [sym_instance_of] = STATE(601),
    [sym_negation] = STATE(601),
    [sym_if_term] = STATE(601),
    [sym_conjunction] = STATE(601),
    [sym_disjunction] = STATE(601),
    [sym_implication] = STATE(601),
    [sym_quantified] = STATE(601),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(601),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [226] = {
    [sym_special_call] = STATE(623),
    [sym_prefix_cast] = STATE(623),
    [sym_unary_expr] = STATE(623),
    [sym_mul_expr] = STATE(623),
    [sym_add_expr] = STATE(623),
    [sym_in_expr] = STATE(623),
    [sym_comp_term] = STATE(623),
    [sym_instance_of] = STATE(623),
    [sym_negation] = STATE(623),
    [sym_if_term] = STATE(623),
    [sym_conjunction] = STATE(623),
    [sym_disjunction] = STATE(623),
    [sym_implication] = STATE(623),
    [sym_quantified] = STATE(623),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(623),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [227] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [228] = {
    [sym_special_call] = STATE(524),
    [sym_prefix_cast] = STATE(524),
    [sym_unary_expr] = STATE(524),
    [sym_mul_expr] = STATE(524),
    [sym_add_expr] = STATE(524),
    [sym_in_expr] = STATE(524),
    [sym_comp_term] = STATE(524),
    [sym_instance_of] = STATE(524),
    [sym_negation] = STATE(524),
    [sym_if_term] = STATE(524),
    [sym_conjunction] = STATE(524),
    [sym_disjunction] = STATE(524),
    [sym_implication] = STATE(524),
    [sym_quantified] = STATE(524),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(524),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [229] = {
    [sym_special_call] = STATE(279),
    [sym_prefix_cast] = STATE(279),
    [sym_unary_expr] = STATE(279),
    [sym_mul_expr] = STATE(279),
    [sym_add_expr] = STATE(279),
    [sym_in_expr] = STATE(279),
    [sym_comp_term] = STATE(279),
    [sym_instance_of] = STATE(279),
    [sym_negation] = STATE(279),
    [sym_if_term] = STATE(279),
    [sym_conjunction] = STATE(279),
    [sym_disjunction] = STATE(279),
    [sym_implication] = STATE(279),
    [sym_quantified] = STATE(279),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(279),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [230] = {
    [sym_special_call] = STATE(257),
    [sym_prefix_cast] = STATE(257),
    [sym_unary_expr] = STATE(257),
    [sym_mul_expr] = STATE(257),
    [sym_add_expr] = STATE(257),
    [sym_in_expr] = STATE(257),
    [sym_comp_term] = STATE(257),
    [sym_instance_of] = STATE(257),
    [sym_negation] = STATE(257),
    [sym_if_term] = STATE(257),
    [sym_conjunction] = STATE(257),
    [sym_disjunction] = STATE(257),
    [sym_implication] = STATE(257),
    [sym_quantified] = STATE(257),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(257),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [231] = {
    [sym_special_call] = STATE(263),
    [sym_prefix_cast] = STATE(263),
    [sym_unary_expr] = STATE(263),
    [sym_mul_expr] = STATE(263),
    [sym_add_expr] = STATE(263),
    [sym_in_expr] = STATE(263),
    [sym_comp_term] = STATE(263),
    [sym_instance_of] = STATE(263),
    [sym_negation] = STATE(263),
    [sym_if_term] = STATE(263),
    [sym_conjunction] = STATE(263),
    [sym_disjunction] = STATE(263),
    [sym_implication] = STATE(263),
    [sym_quantified] = STATE(263),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(263),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [232] = {
    [sym_special_call] = STATE(286),
    [sym_prefix_cast] = STATE(286),
    [sym_unary_expr] = STATE(286),
    [sym_mul_expr] = STATE(286),
    [sym_add_expr] = STATE(286),
    [sym_in_expr] = STATE(286),
    [sym_comp_term] = STATE(286),
    [sym_instance_of] = STATE(286),
    [sym_negation] = STATE(286),
    [sym_if_term] = STATE(286),
    [sym_conjunction] = STATE(286),
    [sym_disjunction] = STATE(286),
    [sym_implication] = STATE(286),
    [sym_quantified] = STATE(286),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(286),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [233] = {
    [sym_special_call] = STATE(245),
    [sym_prefix_cast] = STATE(245),
    [sym_unary_expr] = STATE(245),
    [sym_mul_expr] = STATE(245),
    [sym_add_expr] = STATE(245),
    [sym_in_expr] = STATE(245),
    [sym_comp_term] = STATE(245),
    [sym_instance_of] = STATE(245),
    [sym_negation] = STATE(245),
    [sym_if_term] = STATE(245),
    [sym_conjunction] = STATE(245),
    [sym_disjunction] = STATE(245),
    [sym_implication] = STATE(245),
    [sym_quantified] = STATE(245),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(245),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [234] = {
    [sym_special_call] = STATE(281),
    [sym_prefix_cast] = STATE(281),
    [sym_unary_expr] = STATE(281),
    [sym_mul_expr] = STATE(281),
    [sym_add_expr] = STATE(281),
    [sym_in_expr] = STATE(281),
    [sym_comp_term] = STATE(281),
    [sym_instance_of] = STATE(281),
    [sym_negation] = STATE(281),
    [sym_if_term] = STATE(281),
    [sym_conjunction] = STATE(281),
    [sym_disjunction] = STATE(281),
    [sym_implication] = STATE(281),
    [sym_quantified] = STATE(281),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(281),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [235] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [236] = {
    [sym_special_call] = STATE(276),
    [sym_prefix_cast] = STATE(276),
    [sym_unary_expr] = STATE(276),
    [sym_mul_expr] = STATE(276),
    [sym_add_expr] = STATE(276),
    [sym_in_expr] = STATE(276),
    [sym_comp_term] = STATE(276),
    [sym_instance_of] = STATE(276),
    [sym_negation] = STATE(276),
    [sym_if_term] = STATE(276),
    [sym_conjunction] = STATE(276),
    [sym_disjunction] = STATE(276),
    [sym_implication] = STATE(276),
    [sym_quantified] = STATE(276),
    [sym_specialId] = STATE(1173),
    [sym_quantifier] = STATE(1174),
    [sym_classless_predicate_call] = STATE(337),
    [sym_qualified_expr] = STATE(337),
    [sym_super_ref] = STATE(337),
    [sym_aggregate] = STATE(337),
    [sym_range] = STATE(337),
    [sym_par_expr] = STATE(337),
    [sym__exprOrTerm] = STATE(276),
    [sym__primary] = STATE(337),
    [sym_literal] = STATE(337),
    [sym_bool] = STATE(332),
    [sym_variable] = STATE(337),
    [sym_unop] = STATE(86),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(294),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1162),
    [sym_aritylessPredicateExpr] = STATE(940),
    [sym_varName] = STATE(334),
    [sym_aggId] = STATE(1138),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(299),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(301),
    [sym_float] = ACTIONS(303),
    [sym_string] = ACTIONS(303),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(305),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(307),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(309),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(311),
    [sym_this] = ACTIONS(309),
    [sym_true] = ACTIONS(305),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [237] = {
    [sym_special_call] = STATE(703),
    [sym_prefix_cast] = STATE(703),
    [sym_unary_expr] = STATE(703),
    [sym_mul_expr] = STATE(703),
    [sym_add_expr] = STATE(703),
    [sym_in_expr] = STATE(703),
    [sym_comp_term] = STATE(703),
    [sym_instance_of] = STATE(703),
    [sym_negation] = STATE(703),
    [sym_if_term] = STATE(703),
    [sym_conjunction] = STATE(703),
    [sym_disjunction] = STATE(703),
    [sym_implication] = STATE(703),
    [sym_quantified] = STATE(703),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(703),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(214),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(375),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(377),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [238] = {
    [sym_special_call] = STATE(265),
    [sym_prefix_cast] = STATE(265),
    [sym_unary_expr] = STATE(265),
    [sym_mul_expr] = STATE(265),
    [sym_add_expr] = STATE(265),
    [sym_in_expr] = STATE(265),
    [sym_comp_term] = STATE(265),
    [sym_instance_of] = STATE(265),
    [sym_negation] = STATE(265),
    [sym_if_term] = STATE(265),
    [sym_conjunction] = STATE(265),
    [sym_disjunction] = STATE(265),
    [sym_implication] = STATE(265),
    [sym_quantified] = STATE(265),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(265),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [239] = {
    [sym_special_call] = STATE(278),
    [sym_prefix_cast] = STATE(278),
    [sym_unary_expr] = STATE(278),
    [sym_mul_expr] = STATE(278),
    [sym_add_expr] = STATE(278),
    [sym_in_expr] = STATE(278),
    [sym_comp_term] = STATE(278),
    [sym_instance_of] = STATE(278),
    [sym_negation] = STATE(278),
    [sym_if_term] = STATE(278),
    [sym_conjunction] = STATE(278),
    [sym_disjunction] = STATE(278),
    [sym_implication] = STATE(278),
    [sym_quantified] = STATE(278),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(278),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [240] = {
    [sym_special_call] = STATE(602),
    [sym_prefix_cast] = STATE(602),
    [sym_unary_expr] = STATE(602),
    [sym_mul_expr] = STATE(602),
    [sym_add_expr] = STATE(602),
    [sym_in_expr] = STATE(602),
    [sym_comp_term] = STATE(602),
    [sym_instance_of] = STATE(602),
    [sym_negation] = STATE(602),
    [sym_if_term] = STATE(602),
    [sym_conjunction] = STATE(602),
    [sym_disjunction] = STATE(602),
    [sym_implication] = STATE(602),
    [sym_quantified] = STATE(602),
    [sym_specialId] = STATE(1260),
    [sym_quantifier] = STATE(1259),
    [sym_classless_predicate_call] = STATE(487),
    [sym_qualified_expr] = STATE(487),
    [sym_super_ref] = STATE(487),
    [sym_aggregate] = STATE(487),
    [sym_range] = STATE(487),
    [sym_par_expr] = STATE(487),
    [sym__exprOrTerm] = STATE(602),
    [sym__primary] = STATE(487),
    [sym_literal] = STATE(487),
    [sym_bool] = STATE(495),
    [sym_variable] = STATE(487),
    [sym_unop] = STATE(204),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(474),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1255),
    [sym_aritylessPredicateExpr] = STATE(950),
    [sym_varName] = STATE(491),
    [sym_aggId] = STATE(1119),
    [sym__lower_id] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(113),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_string] = ACTIONS(117),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(119),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(121),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(123),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(125),
    [sym_this] = ACTIONS(123),
    [sym_true] = ACTIONS(119),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
  [241] = {
    [sym_special_call] = STATE(277),
    [sym_prefix_cast] = STATE(277),
    [sym_unary_expr] = STATE(277),
    [sym_mul_expr] = STATE(277),
    [sym_add_expr] = STATE(277),
    [sym_in_expr] = STATE(277),
    [sym_comp_term] = STATE(277),
    [sym_instance_of] = STATE(277),
    [sym_negation] = STATE(277),
    [sym_if_term] = STATE(277),
    [sym_conjunction] = STATE(277),
    [sym_disjunction] = STATE(277),
    [sym_implication] = STATE(277),
    [sym_quantified] = STATE(277),
    [sym_specialId] = STATE(1193),
    [sym_quantifier] = STATE(1194),
    [sym_classless_predicate_call] = STATE(389),
    [sym_qualified_expr] = STATE(389),
    [sym_super_ref] = STATE(389),
    [sym_aggregate] = STATE(389),
    [sym_range] = STATE(389),
    [sym_par_expr] = STATE(389),
    [sym__exprOrTerm] = STATE(277),
    [sym__primary] = STATE(389),
    [sym_literal] = STATE(389),
    [sym_bool] = STATE(318),
    [sym_variable] = STATE(389),
    [sym_unop] = STATE(230),
    [sym_literalId] = STATE(939),
    [sym_moduleExpr] = STATE(1256),
    [sym_typeLiteral] = STATE(469),
    [sym_simpleId] = STATE(295),
    [sym_className] = STATE(470),
    [sym_dbtype] = STATE(472),
    [sym_typeExpr] = STATE(1195),
    [sym_aritylessPredicateExpr] = STATE(957),
    [sym_varName] = STATE(362),
    [sym_aggId] = STATE(1124),
    [sym__lower_id] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_float] = ACTIONS(21),
    [anon_sym_int] = ACTIONS(21),
    [anon_sym_string] = ACTIONS(21),
    [sym__upper_id] = ACTIONS(357),
    [sym__at_lower_id] = ACTIONS(25),
    [sym_integer] = ACTIONS(359),
    [sym_float] = ACTIONS(361),
    [sym_string] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_any] = ACTIONS(53),
    [sym_avg] = ACTIONS(53),
    [sym_boolean] = ACTIONS(21),
    [sym_count] = ACTIONS(53),
    [sym_date] = ACTIONS(21),
    [sym_exists] = ACTIONS(55),
    [sym_false] = ACTIONS(363),
    [sym_forall] = ACTIONS(55),
    [sym_forex] = ACTIONS(55),
    [sym_max] = ACTIONS(53),
    [sym_min] = ACTIONS(53),
    [sym_not] = ACTIONS(365),
    [sym_none] = ACTIONS(61),
    [sym_rank] = ACTIONS(53),
    [sym_result] = ACTIONS(367),
    [sym_strictcount] = ACTIONS(53),
    [sym_strictsum] = ACTIONS(53),
    [sym_strictconcat] = ACTIONS(53),
    [sym_concat] = ACTIONS(53),
    [sym_sum] = ACTIONS(53),
    [sym_super] = ACTIONS(369),
    [sym_this] = ACTIONS(367),
    [sym_true] = ACTIONS(363),
    [sym_minus] = ACTIONS(67),
    [sym_plus] = ACTIONS(67),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 19,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(383), 1,
      anon_sym_or,
    ACTIONS(385), 1,
      anon_sym_and,
    ACTIONS(387), 1,
      anon_sym_implies,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(393), 1,
      sym_instanceof,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    STATE(779), 1,
      sym_direction,
    ACTIONS(389), 2,
      sym_asc,
      sym_desc,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(379), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(381), 14,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [82] = 19,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(405), 1,
      anon_sym_or,
    ACTIONS(407), 1,
      anon_sym_and,
    ACTIONS(409), 1,
      anon_sym_implies,
    ACTIONS(413), 1,
      sym_in,
    ACTIONS(415), 1,
      sym_instanceof,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    STATE(767), 1,
      sym_direction,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(411), 2,
      sym_asc,
      sym_desc,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(379), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(381), 14,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [164] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(421), 1,
      anon_sym_or,
    ACTIONS(423), 1,
      anon_sym_and,
    ACTIONS(425), 1,
      anon_sym_implies,
    ACTIONS(427), 1,
      sym_in,
    ACTIONS(429), 1,
      sym_instanceof,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(417), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(419), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [241] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(431), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(433), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [298] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(405), 1,
      anon_sym_or,
    ACTIONS(407), 1,
      anon_sym_and,
    ACTIONS(409), 1,
      anon_sym_implies,
    ACTIONS(413), 1,
      sym_in,
    ACTIONS(415), 1,
      sym_instanceof,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(437), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(435), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [375] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(407), 1,
      anon_sym_and,
    ACTIONS(413), 1,
      sym_in,
    ACTIONS(415), 1,
      sym_instanceof,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(441), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(439), 18,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [448] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(405), 1,
      anon_sym_or,
    ACTIONS(407), 1,
      anon_sym_and,
    ACTIONS(409), 1,
      anon_sym_implies,
    ACTIONS(413), 1,
      sym_in,
    ACTIONS(415), 1,
      sym_instanceof,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(417), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(419), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [525] = 16,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(405), 1,
      anon_sym_or,
    ACTIONS(407), 1,
      anon_sym_and,
    ACTIONS(413), 1,
      sym_in,
    ACTIONS(415), 1,
      sym_instanceof,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(445), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(443), 17,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [600] = 18,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(421), 1,
      anon_sym_or,
    ACTIONS(423), 1,
      anon_sym_and,
    ACTIONS(425), 1,
      anon_sym_implies,
    ACTIONS(427), 1,
      sym_in,
    ACTIONS(429), 1,
      sym_instanceof,
    ACTIONS(451), 1,
      sym_as,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(447), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(449), 15,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [679] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    ACTIONS(459), 1,
      sym_instanceof,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(455), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(453), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [750] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(393), 1,
      sym_instanceof,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(455), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(453), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [821] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(461), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_plus,
    ACTIONS(463), 23,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
  [882] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [937] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(474), 1,
      anon_sym_DOT,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 12,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [994] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(427), 1,
      sym_in,
    ACTIONS(429), 1,
      sym_instanceof,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(455), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(453), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [1065] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(383), 1,
      anon_sym_or,
    ACTIONS(385), 1,
      anon_sym_and,
    ACTIONS(387), 1,
      anon_sym_implies,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(393), 1,
      sym_instanceof,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(417), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(419), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [1142] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(474), 1,
      anon_sym_DOT,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 12,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [1199] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [1254] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(461), 11,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_plus,
    ACTIONS(463), 23,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
  [1315] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(431), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(433), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [1372] = 11,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(479), 9,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(477), 22,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
  [1437] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    ACTIONS(459), 1,
      sym_instanceof,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(483), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(481), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [1508] = 18,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    ACTIONS(459), 1,
      sym_instanceof,
    ACTIONS(485), 1,
      anon_sym_or,
    ACTIONS(487), 1,
      anon_sym_and,
    ACTIONS(489), 1,
      anon_sym_implies,
    ACTIONS(491), 1,
      sym_as,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(447), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(449), 15,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [1587] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(385), 1,
      anon_sym_and,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(393), 1,
      sym_instanceof,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(441), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(439), 18,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [1660] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(413), 1,
      sym_in,
    ACTIONS(415), 1,
      sym_instanceof,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(483), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(481), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [1731] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    ACTIONS(459), 1,
      sym_instanceof,
    ACTIONS(485), 1,
      anon_sym_or,
    ACTIONS(487), 1,
      anon_sym_and,
    ACTIONS(489), 1,
      anon_sym_implies,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(417), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(419), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [1808] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    ACTIONS(459), 1,
      sym_instanceof,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(495), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(493), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [1879] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(427), 1,
      sym_in,
    ACTIONS(429), 1,
      sym_instanceof,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(495), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(493), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [1950] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    ACTIONS(459), 1,
      sym_instanceof,
    ACTIONS(485), 1,
      anon_sym_or,
    ACTIONS(487), 1,
      anon_sym_and,
    ACTIONS(489), 1,
      anon_sym_implies,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(437), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(435), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [2027] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(393), 1,
      sym_instanceof,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(495), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(493), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [2098] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(423), 1,
      anon_sym_and,
    ACTIONS(427), 1,
      sym_in,
    ACTIONS(429), 1,
      sym_instanceof,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(441), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(439), 18,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [2171] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(413), 1,
      sym_in,
    ACTIONS(415), 1,
      sym_instanceof,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(495), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(493), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [2242] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [2297] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(474), 1,
      anon_sym_DOT,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 12,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [2354] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    ACTIONS(459), 1,
      sym_instanceof,
    ACTIONS(487), 1,
      anon_sym_and,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(441), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(439), 18,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [2427] = 16,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(383), 1,
      anon_sym_or,
    ACTIONS(385), 1,
      anon_sym_and,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(393), 1,
      sym_instanceof,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(445), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(443), 17,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [2502] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(393), 1,
      sym_instanceof,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(483), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(481), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [2573] = 16,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(457), 1,
      sym_in,
    ACTIONS(459), 1,
      sym_instanceof,
    ACTIONS(485), 1,
      anon_sym_or,
    ACTIONS(487), 1,
      anon_sym_and,
    STATE(218), 1,
      sym_addop,
    STATE(221), 1,
      sym_mulop,
    STATE(222), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(445), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(443), 17,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [2648] = 11,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(413), 1,
      sym_in,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(479), 9,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(477), 22,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
  [2713] = 11,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(479), 9,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(477), 22,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
  [2778] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(431), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(433), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [2835] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(431), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(433), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [2892] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(461), 11,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_plus,
    ACTIONS(463), 23,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
  [2953] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(474), 1,
      anon_sym_DOT,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 12,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3010] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(461), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_plus,
    ACTIONS(463), 23,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
  [3071] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(413), 1,
      sym_in,
    ACTIONS(415), 1,
      sym_instanceof,
    STATE(99), 1,
      sym_addop,
    STATE(100), 1,
      sym_mulop,
    STATE(102), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(455), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(453), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [3142] = 11,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(427), 1,
      sym_in,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(479), 9,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(477), 22,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
  [3207] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(421), 1,
      anon_sym_or,
    ACTIONS(423), 1,
      anon_sym_and,
    ACTIONS(425), 1,
      anon_sym_implies,
    ACTIONS(427), 1,
      sym_in,
    ACTIONS(429), 1,
      sym_instanceof,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(437), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(435), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [3284] = 16,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(421), 1,
      anon_sym_or,
    ACTIONS(423), 1,
      anon_sym_and,
    ACTIONS(427), 1,
      sym_in,
    ACTIONS(429), 1,
      sym_instanceof,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(445), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(443), 17,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [3359] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(383), 1,
      anon_sym_or,
    ACTIONS(385), 1,
      anon_sym_and,
    ACTIONS(387), 1,
      anon_sym_implies,
    ACTIONS(391), 1,
      sym_in,
    ACTIONS(393), 1,
      sym_instanceof,
    ACTIONS(401), 1,
      sym_slash,
    STATE(232), 1,
      sym_addop,
    STATE(233), 1,
      sym_mulop,
    STATE(234), 1,
      sym_compop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(437), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(435), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_predicate,
  [3436] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3491] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(427), 1,
      sym_in,
    ACTIONS(429), 1,
      sym_instanceof,
    STATE(179), 1,
      sym_compop,
    STATE(181), 1,
      sym_mulop,
    STATE(183), 1,
      sym_addop,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(483), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(481), 19,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [3562] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(501), 1,
      anon_sym_COLON_COLON,
    ACTIONS(499), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(497), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3614] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(501), 1,
      anon_sym_COLON_COLON,
    ACTIONS(499), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(497), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3666] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(501), 1,
      anon_sym_COLON_COLON,
    ACTIONS(499), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(497), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3718] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(501), 1,
      anon_sym_COLON_COLON,
    ACTIONS(499), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(497), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3770] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(503), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(505), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3819] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(507), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(509), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3868] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(511), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(513), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3917] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(517), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(515), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [3966] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(521), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(519), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4015] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(467), 1,
      anon_sym_COLON_COLON,
    ACTIONS(525), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(523), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4066] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(527), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(529), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4115] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(533), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(531), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4164] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(511), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(513), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4213] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(517), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(515), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4262] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(537), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(535), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4311] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(521), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(519), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4360] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(539), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(541), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4409] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(533), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(531), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4458] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(533), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(531), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4507] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(521), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(519), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4556] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(517), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(515), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4605] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(527), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(529), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4654] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(543), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(545), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4703] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(511), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(513), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4752] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(547), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(549), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4801] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(551), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(553), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4850] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(537), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(535), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4899] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(555), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(557), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4948] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(527), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(529), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [4997] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(561), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(559), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5046] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(563), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(565), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5095] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(555), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(557), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5144] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(507), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(509), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5193] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(569), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(567), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5242] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(573), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(571), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5291] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(561), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(559), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5340] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(551), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(553), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5389] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(467), 1,
      anon_sym_COLON_COLON,
    ACTIONS(525), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(523), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5440] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(547), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(549), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5489] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(577), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(575), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5538] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(581), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(579), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5587] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(585), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(583), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5636] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(589), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(587), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5685] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(595), 1,
      anon_sym_DOT,
    ACTIONS(593), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(591), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5736] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(507), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(509), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5785] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(577), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(575), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5834] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(561), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(559), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5883] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(599), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(597), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5932] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(539), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(541), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [5981] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(569), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(567), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6030] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(555), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(557), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6079] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(537), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(535), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6128] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(573), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(571), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6177] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(563), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(565), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6226] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(569), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(567), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6275] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(547), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(549), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6324] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(551), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(553), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6373] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(577), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(575), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6422] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(573), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(571), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6471] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(601), 1,
      anon_sym_DOT,
    ACTIONS(593), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(591), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6522] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(589), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(587), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6571] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(581), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(579), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6620] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(581), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(579), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6669] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(577), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(575), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6718] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(589), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(587), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6767] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(543), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(545), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6816] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(547), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(549), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6865] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(527), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(529), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6914] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(581), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(579), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [6963] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(551), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(553), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7012] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(467), 1,
      anon_sym_COLON_COLON,
    ACTIONS(525), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(523), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7063] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(503), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(505), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7112] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(543), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(545), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7161] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(503), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(505), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7210] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(603), 1,
      anon_sym_DOT,
    ACTIONS(593), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(591), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7261] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(517), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(515), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7310] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(521), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(519), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7359] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(533), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(531), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7408] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(511), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(513), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7457] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(537), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(535), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7506] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(561), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(559), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7555] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(507), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(509), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7604] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(569), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(567), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7653] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(573), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(571), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7702] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(585), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(583), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7751] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(599), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(597), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7800] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(585), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(583), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7849] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(585), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(583), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7898] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(539), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(541), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7947] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(599), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(597), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [7996] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(539), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(541), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8045] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(599), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(597), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8094] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(589), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(587), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8143] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(555), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(557), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8192] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(563), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(565), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8241] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(605), 1,
      anon_sym_DOT,
    ACTIONS(593), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(591), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8292] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(503), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(505), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8341] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(543), 14,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(545), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8390] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(563), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(565), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8439] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(467), 1,
      anon_sym_COLON_COLON,
    ACTIONS(525), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(523), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8490] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(609), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(607), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8538] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(613), 8,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym__upper_id,
      sym__at_lower_id,
      sym_float,
      sym_string,
      sym_minus,
      sym_plus,
    ACTIONS(611), 29,
      anon_sym_if,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_integer,
      sym_any,
      sym_avg,
      sym_boolean,
      sym_count,
      sym_date,
      sym_exists,
      sym_false,
      sym_forall,
      sym_forex,
      sym_max,
      sym_min,
      sym_not,
      sym_none,
      sym_rank,
      sym_result,
      sym_strictcount,
      sym_strictsum,
      sym_strictconcat,
      sym_concat,
      sym_sum,
      sym_super,
      sym_this,
      sym_true,
  [8584] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(617), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(615), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8632] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(621), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(619), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8680] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(625), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(623), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8728] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(627), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(629), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8776] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(631), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(633), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8824] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(635), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(637), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8872] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(627), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(629), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8920] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(635), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(637), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [8968] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(639), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(641), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9016] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(621), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(619), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9064] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(617), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(615), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9112] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(643), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(645), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9160] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(639), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(641), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9208] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(609), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(607), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9256] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(627), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(629), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9304] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(625), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(623), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9352] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(631), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(633), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9400] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(621), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(619), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9448] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(649), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(647), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9496] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(617), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(615), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9544] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(643), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(645), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9592] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(609), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(607), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9640] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(653), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(651), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9688] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(635), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(637), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9736] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(655), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(657), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9784] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(649), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(647), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9832] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(653), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(651), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9880] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(661), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(659), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9928] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(665), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(663), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [9976] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(655), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(657), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10024] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(667), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(669), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10072] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(661), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(659), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10120] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(665), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(663), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10168] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(667), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(669), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10216] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(667), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(669), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10264] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(655), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(657), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10312] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(631), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(633), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10360] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(673), 8,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym__upper_id,
      sym__at_lower_id,
      sym_float,
      sym_string,
      sym_minus,
      sym_plus,
    ACTIONS(671), 29,
      anon_sym_if,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_integer,
      sym_any,
      sym_avg,
      sym_boolean,
      sym_count,
      sym_date,
      sym_exists,
      sym_false,
      sym_forall,
      sym_forex,
      sym_max,
      sym_min,
      sym_not,
      sym_none,
      sym_rank,
      sym_result,
      sym_strictcount,
      sym_strictsum,
      sym_strictconcat,
      sym_concat,
      sym_sum,
      sym_super,
      sym_this,
      sym_true,
  [10406] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(639), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(641), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10454] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(667), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(669), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10502] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(639), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(641), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10550] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(643), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(645), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10598] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(655), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(657), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10646] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(677), 8,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym__upper_id,
      sym__at_lower_id,
      sym_float,
      sym_string,
      sym_minus,
      sym_plus,
    ACTIONS(675), 29,
      anon_sym_if,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_integer,
      sym_any,
      sym_avg,
      sym_boolean,
      sym_count,
      sym_date,
      sym_exists,
      sym_false,
      sym_forall,
      sym_forex,
      sym_max,
      sym_min,
      sym_not,
      sym_none,
      sym_rank,
      sym_result,
      sym_strictcount,
      sym_strictsum,
      sym_strictconcat,
      sym_concat,
      sym_sum,
      sym_super,
      sym_this,
      sym_true,
  [10692] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(665), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(663), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10740] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(661), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(659), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10788] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(643), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(645), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10836] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(635), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(637), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10884] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(617), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(615), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10932] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(653), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(651), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [10980] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(681), 8,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym__upper_id,
      sym__at_lower_id,
      sym_float,
      sym_string,
      sym_minus,
      sym_plus,
    ACTIONS(679), 29,
      anon_sym_if,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_integer,
      sym_any,
      sym_avg,
      sym_boolean,
      sym_count,
      sym_date,
      sym_exists,
      sym_false,
      sym_forall,
      sym_forex,
      sym_max,
      sym_min,
      sym_not,
      sym_none,
      sym_rank,
      sym_result,
      sym_strictcount,
      sym_strictsum,
      sym_strictconcat,
      sym_concat,
      sym_sum,
      sym_super,
      sym_this,
      sym_true,
  [11026] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(649), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(647), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11074] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(649), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(647), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11122] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(653), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(651), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11170] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(625), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(623), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11218] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(631), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(633), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11266] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(621), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(619), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11314] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(609), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(607), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_asc,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_desc,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11362] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(627), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(629), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11410] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(661), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(659), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11458] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(665), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(663), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11506] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(625), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym__upper_id,
      sym__at_lower_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
    ACTIONS(623), 24,
      anon_sym_module,
      anon_sym_or,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_in,
      sym_instanceof,
      sym_predicate,
      sym_lt,
      sym_gt,
      sym_slash,
  [11554] = 27,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(683), 1,
      sym__lower_id,
    ACTIONS(686), 1,
      anon_sym_module,
    ACTIONS(689), 1,
      anon_sym_RBRACE,
    ACTIONS(691), 1,
      anon_sym_from,
    ACTIONS(694), 1,
      anon_sym_where,
    ACTIONS(697), 1,
      anon_sym_select,
    ACTIONS(700), 1,
      sym_qldoc,
    ACTIONS(706), 1,
      sym__upper_id,
    ACTIONS(709), 1,
      sym__at_lower_id,
    ACTIONS(712), 1,
      sym_class,
    ACTIONS(715), 1,
      sym_newtype,
    ACTIONS(718), 1,
      sym_import,
    ACTIONS(721), 1,
      sym_predicate,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1117), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    STATE(458), 2,
      sym_moduleMember,
      aux_sym_ql_repeat1,
    STATE(468), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(703), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(829), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [11647] = 27,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(724), 1,
      anon_sym_module,
    ACTIONS(726), 1,
      anon_sym_RBRACE,
    ACTIONS(728), 1,
      anon_sym_from,
    ACTIONS(730), 1,
      anon_sym_where,
    ACTIONS(732), 1,
      anon_sym_select,
    ACTIONS(734), 1,
      sym_qldoc,
    ACTIONS(736), 1,
      sym_class,
    ACTIONS(738), 1,
      sym_newtype,
    ACTIONS(740), 1,
      sym_import,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1117), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    STATE(460), 2,
      sym_moduleMember,
      aux_sym_ql_repeat1,
    STATE(468), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(829), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [11740] = 27,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(724), 1,
      anon_sym_module,
    ACTIONS(728), 1,
      anon_sym_from,
    ACTIONS(730), 1,
      anon_sym_where,
    ACTIONS(732), 1,
      anon_sym_select,
    ACTIONS(734), 1,
      sym_qldoc,
    ACTIONS(736), 1,
      sym_class,
    ACTIONS(738), 1,
      sym_newtype,
    ACTIONS(740), 1,
      sym_import,
    ACTIONS(742), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1117), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    STATE(458), 2,
      sym_moduleMember,
      aux_sym_ql_repeat1,
    STATE(468), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(829), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [11833] = 27,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(13), 1,
      anon_sym_from,
    ACTIONS(15), 1,
      anon_sym_where,
    ACTIONS(17), 1,
      anon_sym_select,
    ACTIONS(19), 1,
      sym_qldoc,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(27), 1,
      sym_class,
    ACTIONS(29), 1,
      sym_newtype,
    ACTIONS(31), 1,
      sym_import,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(744), 1,
      ts_builtin_sym_end,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1143), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    STATE(464), 2,
      sym_moduleMember,
      aux_sym_ql_repeat1,
    STATE(471), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(855), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [11926] = 27,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(724), 1,
      anon_sym_module,
    ACTIONS(728), 1,
      anon_sym_from,
    ACTIONS(730), 1,
      anon_sym_where,
    ACTIONS(732), 1,
      anon_sym_select,
    ACTIONS(734), 1,
      sym_qldoc,
    ACTIONS(736), 1,
      sym_class,
    ACTIONS(738), 1,
      sym_newtype,
    ACTIONS(740), 1,
      sym_import,
    ACTIONS(746), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1117), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    STATE(463), 2,
      sym_moduleMember,
      aux_sym_ql_repeat1,
    STATE(468), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(829), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [12019] = 27,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(724), 1,
      anon_sym_module,
    ACTIONS(728), 1,
      anon_sym_from,
    ACTIONS(730), 1,
      anon_sym_where,
    ACTIONS(732), 1,
      anon_sym_select,
    ACTIONS(734), 1,
      sym_qldoc,
    ACTIONS(736), 1,
      sym_class,
    ACTIONS(738), 1,
      sym_newtype,
    ACTIONS(740), 1,
      sym_import,
    ACTIONS(748), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1117), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    STATE(458), 2,
      sym_moduleMember,
      aux_sym_ql_repeat1,
    STATE(468), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(829), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [12112] = 27,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(683), 1,
      sym__lower_id,
    ACTIONS(689), 1,
      ts_builtin_sym_end,
    ACTIONS(706), 1,
      sym__upper_id,
    ACTIONS(709), 1,
      sym__at_lower_id,
    ACTIONS(721), 1,
      sym_predicate,
    ACTIONS(750), 1,
      anon_sym_module,
    ACTIONS(753), 1,
      anon_sym_from,
    ACTIONS(756), 1,
      anon_sym_where,
    ACTIONS(759), 1,
      anon_sym_select,
    ACTIONS(762), 1,
      sym_qldoc,
    ACTIONS(765), 1,
      sym_class,
    ACTIONS(768), 1,
      sym_newtype,
    ACTIONS(771), 1,
      sym_import,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1143), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    STATE(464), 2,
      sym_moduleMember,
      aux_sym_ql_repeat1,
    STATE(471), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(703), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(855), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [12205] = 4,
    ACTIONS(467), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(523), 14,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      sym__lower_id,
      sym_asc,
      sym_desc,
      sym_in,
      sym_instanceof,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(525), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym__upper_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12249] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(623), 15,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_DOT,
      sym__lower_id,
      sym_asc,
      sym_desc,
      sym_in,
      sym_instanceof,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(625), 17,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym__upper_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12290] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(615), 15,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_DOT,
      sym__lower_id,
      sym_asc,
      sym_desc,
      sym_in,
      sym_instanceof,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(617), 17,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym__upper_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12331] = 23,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(724), 1,
      anon_sym_module,
    ACTIONS(728), 1,
      anon_sym_from,
    ACTIONS(730), 1,
      anon_sym_where,
    ACTIONS(732), 1,
      anon_sym_select,
    ACTIONS(736), 1,
      sym_class,
    ACTIONS(738), 1,
      sym_newtype,
    ACTIONS(740), 1,
      sym_import,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1117), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    STATE(765), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(827), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [12412] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(645), 15,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_DOT,
      sym__lower_id,
      sym_asc,
      sym_desc,
      sym_in,
      sym_instanceof,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(643), 17,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym__upper_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12453] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(607), 15,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_DOT,
      sym__lower_id,
      sym_asc,
      sym_desc,
      sym_in,
      sym_instanceof,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(609), 17,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym__upper_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12494] = 23,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(13), 1,
      anon_sym_from,
    ACTIONS(15), 1,
      anon_sym_where,
    ACTIONS(17), 1,
      anon_sym_select,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(27), 1,
      sym_class,
    ACTIONS(29), 1,
      sym_newtype,
    ACTIONS(31), 1,
      sym_import,
    ACTIONS(33), 1,
      sym_predicate,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(470), 1,
      sym_className,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(1143), 1,
      sym_returnType,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(1277), 1,
      sym_typeExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    STATE(765), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
    STATE(800), 6,
      sym_module,
      sym_imprt,
      sym_classlessPredicate,
      sym_datatype,
      sym_select,
      sym_dataclass,
  [12575] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(619), 15,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_DOT,
      sym__lower_id,
      sym_asc,
      sym_desc,
      sym_in,
      sym_instanceof,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(621), 17,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym__upper_id,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12616] = 5,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(465), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(467), 22,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_COLON_COLON,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
  [12659] = 4,
    ACTIONS(501), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(497), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(499), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12699] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(545), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(543), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12736] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(553), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(551), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12773] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(515), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(517), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12810] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(529), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(527), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12847] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(559), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(561), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12884] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(513), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(511), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12921] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(541), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(539), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12958] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(597), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(599), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [12995] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(585), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13032] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(505), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(503), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13069] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(509), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(507), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13106] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(531), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(533), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13143] = 4,
    ACTIONS(774), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(591), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(593), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13182] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(587), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(589), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13219] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(567), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(569), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13256] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(557), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(555), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13293] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(579), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(581), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13330] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(573), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13367] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(535), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(537), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13404] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(565), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(563), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13441] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(549), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(547), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13478] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(575), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(577), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13515] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(519), 5,
      anon_sym_DOT,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(521), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13552] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(776), 1,
      anon_sym_RBRACE,
    ACTIONS(778), 1,
      sym_qldoc,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(503), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [13624] = 7,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(474), 1,
      anon_sym_RPAREN,
    ACTIONS(780), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(465), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(467), 18,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_COLON_COLON,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
  [13668] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(778), 1,
      sym_qldoc,
    ACTIONS(783), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(503), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [13740] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(778), 1,
      sym_qldoc,
    ACTIONS(785), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(513), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [13812] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(647), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(649), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [13848] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(787), 1,
      sym__lower_id,
    ACTIONS(790), 1,
      anon_sym_RBRACE,
    ACTIONS(792), 1,
      sym_qldoc,
    ACTIONS(798), 1,
      sym__upper_id,
    ACTIONS(801), 1,
      sym__at_lower_id,
    ACTIONS(804), 1,
      sym_predicate,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(503), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(795), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [13920] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(778), 1,
      sym_qldoc,
    ACTIONS(807), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(505), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [13992] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(778), 1,
      sym_qldoc,
    ACTIONS(809), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(503), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [14064] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(651), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(653), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14100] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(778), 1,
      sym_qldoc,
    ACTIONS(809), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(500), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [14172] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(669), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(667), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14208] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(633), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(631), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14244] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(629), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(627), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14280] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(659), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(661), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14316] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(663), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(665), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14352] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(778), 1,
      sym_qldoc,
    ACTIONS(811), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(503), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [14424] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(9), 1,
      sym__lower_id,
    ACTIONS(23), 1,
      sym__upper_id,
    ACTIONS(25), 1,
      sym__at_lower_id,
    ACTIONS(33), 1,
      sym_predicate,
    ACTIONS(778), 1,
      sym_qldoc,
    ACTIONS(811), 1,
      anon_sym_RBRACE,
    STATE(469), 1,
      sym_typeLiteral,
    STATE(472), 1,
      sym_dbtype,
    STATE(858), 1,
      sym_annotName,
    STATE(985), 1,
      sym_typeExpr,
    STATE(1005), 1,
      sym_className,
    STATE(1144), 1,
      sym_simpleId,
    STATE(1153), 1,
      sym_returnType,
    STATE(1240), 1,
      sym_varDecl,
    STATE(1274), 1,
      sym_moduleExpr,
    STATE(498), 2,
      sym_classMember,
      aux_sym_dataclass_repeat2,
    STATE(552), 2,
      sym_annotation,
      aux_sym_moduleMember_repeat1,
    STATE(895), 3,
      sym_charpred,
      sym_memberPredicate,
      sym_field,
    ACTIONS(21), 5,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym_boolean,
      sym_date,
  [14496] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(641), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(639), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14532] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(657), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(655), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14568] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(637), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(635), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14604] = 8,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(474), 1,
      anon_sym_DOT,
    ACTIONS(523), 1,
      sym__lower_id,
    ACTIONS(525), 1,
      sym__upper_id,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(465), 10,
      anon_sym_or,
      anon_sym_and,
      anon_sym_implies,
      sym_asc,
      sym_desc,
      sym_in,
      sym_instanceof,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(467), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_COLON_COLON,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
  [14649] = 10,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(477), 2,
      sym_lt,
      sym_gt,
    ACTIONS(479), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
  [14698] = 15,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(815), 1,
      anon_sym_or,
    ACTIONS(817), 1,
      anon_sym_and,
    ACTIONS(819), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(417), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [14757] = 12,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(495), 10,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [14810] = 6,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(433), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(431), 19,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [14851] = 15,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(815), 1,
      anon_sym_or,
    ACTIONS(817), 1,
      anon_sym_and,
    ACTIONS(819), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(437), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [14910] = 12,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(455), 10,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [14963] = 14,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(815), 1,
      anon_sym_or,
    ACTIONS(817), 1,
      anon_sym_and,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(445), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [15020] = 8,
    ACTIONS(401), 1,
      sym_slash,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(463), 3,
      sym_in,
      sym_lt,
      sym_gt,
    ACTIONS(461), 17,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_plus,
  [15065] = 12,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(483), 10,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [15118] = 13,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(817), 1,
      anon_sym_and,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(85), 1,
      sym_mulop,
    STATE(101), 1,
      sym_compop,
    STATE(103), 1,
      sym_addop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(441), 9,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_select,
      anon_sym_then,
      anon_sym_else,
      anon_sym_implies,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [15173] = 8,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(474), 1,
      anon_sym_DOT,
    ACTIONS(523), 1,
      sym__lower_id,
    ACTIONS(525), 1,
      sym__upper_id,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(467), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
    ACTIONS(465), 10,
      anon_sym_or,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      sym_as,
      sym_in,
      sym_instanceof,
      sym_lt,
      sym_gt,
      sym_slash,
  [15217] = 17,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    ACTIONS(823), 1,
      anon_sym_or,
    ACTIONS(825), 1,
      anon_sym_and,
    ACTIONS(827), 1,
      anon_sym_implies,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    STATE(1158), 1,
      sym_direction,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(379), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(829), 2,
      sym_asc,
      sym_desc,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
  [15278] = 12,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(495), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
  [15329] = 6,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(433), 4,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(431), 17,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [15368] = 12,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(455), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
  [15419] = 15,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    ACTIONS(823), 1,
      anon_sym_or,
    ACTIONS(825), 1,
      anon_sym_and,
    ACTIONS(827), 1,
      anon_sym_implies,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(437), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
  [15476] = 15,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    ACTIONS(823), 1,
      anon_sym_or,
    ACTIONS(825), 1,
      anon_sym_and,
    ACTIONS(827), 1,
      anon_sym_implies,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(417), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
  [15533] = 14,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    ACTIONS(823), 1,
      anon_sym_or,
    ACTIONS(825), 1,
      anon_sym_and,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(445), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_implies,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
  [15588] = 13,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    ACTIONS(825), 1,
      anon_sym_and,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(441), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_implies,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
  [15641] = 10,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(477), 2,
      sym_lt,
      sym_gt,
    ACTIONS(479), 13,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
  [15688] = 8,
    ACTIONS(401), 1,
      sym_slash,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(463), 3,
      sym_in,
      sym_lt,
      sym_gt,
    ACTIONS(461), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_plus,
  [15731] = 12,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(813), 1,
      sym_in,
    ACTIONS(821), 1,
      sym_instanceof,
    STATE(190), 1,
      sym_addop,
    STATE(192), 1,
      sym_mulop,
    STATE(193), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(483), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_PIPE,
      sym_asc,
      sym_desc,
  [15782] = 5,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(471), 2,
      sym_star,
      sym_plus,
    ACTIONS(465), 5,
      anon_sym_or,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(467), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_DOT,
      anon_sym_order,
      anon_sym_COLON_COLON,
      sym_as,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_mod,
  [15818] = 14,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(831), 1,
      anon_sym_or,
    ACTIONS(833), 1,
      anon_sym_and,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(837), 1,
      sym_instanceof,
    STATE(159), 1,
      sym_addop,
    STATE(161), 1,
      sym_mulop,
    STATE(164), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(445), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_implies,
      anon_sym_order,
      sym_as,
  [15872] = 15,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(831), 1,
      anon_sym_or,
    ACTIONS(833), 1,
      anon_sym_and,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(837), 1,
      sym_instanceof,
    ACTIONS(839), 1,
      anon_sym_implies,
    STATE(159), 1,
      sym_addop,
    STATE(161), 1,
      sym_mulop,
    STATE(164), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(437), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_order,
      sym_as,
  [15928] = 16,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(831), 1,
      anon_sym_or,
    ACTIONS(833), 1,
      anon_sym_and,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(837), 1,
      sym_instanceof,
    ACTIONS(839), 1,
      anon_sym_implies,
    ACTIONS(841), 1,
      sym_as,
    STATE(159), 1,
      sym_addop,
    STATE(161), 1,
      sym_mulop,
    STATE(164), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(447), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_order,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
  [15986] = 13,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(493), 1,
      anon_sym_or,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(837), 1,
      sym_instanceof,
    STATE(159), 1,
      sym_addop,
    STATE(161), 1,
      sym_mulop,
    STATE(164), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(395), 2,
      sym_lt,
      sym_gt,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    ACTIONS(397), 4,
      sym_le,
      sym_eq,
      sym_ge,
      sym_ne,
    ACTIONS(495), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      sym_as,
  [16038] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(467), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT,
      sym_qldoc,
      anon_sym_COLON_COLON,
      sym__upper_id,
      sym__at_lower_id,
    ACTIONS(465), 16,
      anon_sym_module,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_order,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_as,
      sym_boolean,
      sym_class,
      sym_newtype,
      sym_date,
      sym_import,
      sym_predicate,
  [16072] = 6,
    STATE(159), 1,
      sym_addop,
    STATE(161), 1,
      sym_mulop,
    STATE(164), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(433), 5,
      anon_sym_or,
      sym_in,
      sym_lt,
      sym_gt,
      sym_slash,
    ACTIONS(431), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      sym_as,
      sym_instanceof,
      sym_le,
      sym_eq,
      sym_ge,
      sym_minus,
      sym_ne,
      sym_star,
      sym_mod,
      sym_plus,
  [16110] = 10,
    ACTIONS(401), 1,
      sym_slash,
    ACTIONS(835), 1,
      sym_in,
    STATE(159), 1,
      sym_addop,
    STATE(161), 1,
      sym_mulop,
    STATE(164), 1,
      sym_compop,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(399), 2,
      sym_minus,
      sym_plus,
    ACTIONS(403), 2,
      sym_star,
      sym_mod,
    AC