{-# LANGUAGE QuasiQuotes #-}
{-# LANGUAGE TemplateHaskell #-}

{- |
Module: TREXIO.LowLevel
Description: Generated direct low-level bindings to the TREXIO library
Copyright: Phillip Seeber 2024
License: BSD-3-Clause
Maintainer: phillip.seeber@uni-jena.de
Stability: experimental
Portability: POSIX

These are the low-level bindings to the TREXIO library.
They are generated by the Template Haskell and provide direct access to the C functions in the TREXIO library.
Consequently, they are unsafe and require manual memory management.
-}
module TREXIO.LowLevel where

import Data.Int
import Data.Map qualified as Map
import Foreign.C.ConstPtr
import Foreign.C.Types
import Foreign.Ptr
import TREXIO.Internal.Base
import TREXIO.Internal.TH
import TREXIO.LowLevel.Scheme

$( do
    let TrexioScheme trexioScheme = scheme
        groups = Map.toList trexioScheme

    -- Import all C functions for all fields and operations
    concat <$> traverse (uncurry mkCBindings) groups
 )

-- | 'Int64's required per determinant
foreign import capi "trexio.h trexio_get_int64_num"
    trexio_get_int64_num ::
        Trexio ->
        Ptr CInt ->
        IO ExitCodeC

-- | Take a list of occupied orbital indices and create a bitfield from it
foreign import capi "trexio.h trexio_to_bitfield_list"
    trexio_to_bitfield_list ::
        -- | @orb_list@
        ConstPtr Int32 ->
        -- | @occupied_num@
        Int32 ->
        -- | Preallocated, zeroed bit array representing a determinant
        ConstPtr Int64 ->
        -- | Number of Int64 required per determinant as obtained by 'trexio_get_int64_num'
        Int32 ->
        IO ExitCodeC
