{-# LANGUAGE OverloadedStrings #-}
module Typst.Symbols (
  typstSymbols
)
where
import Data.Text (Text)

-- | A list of triples, each consisting of the symbol name,
-- a Boolean indicating whether the symbol is an accent, and
-- the resolved symbol.
typstSymbols :: [(Text, Bool, Text)]
typstSymbols =
-- autogenerated by make update-symbols
  [ ( "AA" , False , "\120120" )
  , ( "Alpha" , False , "\913" )
  , ( "BB" , False , "\120121" )
  , ( "Beta" , False , "\914" )
  , ( "CC" , False , "\8450" )
  , ( "Chi" , False , "\935" )
  , ( "DD" , False , "\120123" )
  , ( "Delta" , False , "\916" )
  , ( "Digamma" , False , "\988" )
  , ( "EE" , False , "\120124" )
  , ( "Epsilon" , False , "\917" )
  , ( "Eta" , False , "\919" )
  , ( "FF" , False , "\120125" )
  , ( "GG" , False , "\120126" )
  , ( "Gamma" , False , "\915" )
  , ( "HH" , False , "\8461" )
  , ( "II" , False , "\120128" )
  , ( "Im" , False , "\8465" )
  , ( "Iota" , False , "\921" )
  , ( "JJ" , False , "\120129" )
  , ( "KK" , False , "\120130" )
  , ( "Kai" , False , "\975" )
  , ( "Kappa" , False , "\922" )
  , ( "LL" , False , "\120131" )
  , ( "Lambda" , False , "\923" )
  , ( "MM" , False , "\120132" )
  , ( "Mu" , False , "\924" )
  , ( "NN" , False , "\8469" )
  , ( "Nu" , False , "\925" )
  , ( "OO" , False , "\120134" )
  , ( "Omega" , False , "\937" )
  , ( "Omega.inv" , False , "\8487" )
  , ( "Omicron" , False , "\927" )
  , ( "PP" , False , "\8473" )
  , ( "Phi" , False , "\934" )
  , ( "Pi" , False , "\928" )
  , ( "Psi" , False , "\936" )
  , ( "QQ" , False , "\8474" )
  , ( "RR" , False , "\8477" )
  , ( "Re" , False , "\8476" )
  , ( "Rho" , False , "\929" )
  , ( "SS" , False , "\120138" )
  , ( "Sha" , False , "\1064" )
  , ( "Sigma" , False , "\931" )
  , ( "TT" , False , "\120139" )
  , ( "Tau" , False , "\932" )
  , ( "Theta" , False , "\920" )
  , ( "Theta.alt" , False , "\1012" )
  , ( "UU" , False , "\120140" )
  , ( "Upsilon" , False , "\933" )
  , ( "VV" , False , "\120141" )
  , ( "WW" , False , "\120142" )
  , ( "XX" , False , "\120143" )
  , ( "Xi" , False , "\926" )
  , ( "YY" , False , "\120144" )
  , ( "ZZ" , False , "\8484" )
  , ( "Zeta" , False , "\918" )
  , ( "acute" , True , "\180" )
  , ( "acute.double" , True , "\733" )
  , ( "afghani" , False , "\1547" )
  , ( "alef" , False , "\1488" )
  , ( "aleph" , False , "\1488" )
  , ( "alpha" , False , "\945" )
  , ( "amp" , False , "&" )
  , ( "amp.inv" , False , "\8523" )
  , ( "and" , False , "\8743" )
  , ( "and.big" , False , "\8896" )
  , ( "and.curly" , False , "\8911" )
  , ( "and.dot" , False , "\10193" )
  , ( "and.double" , False , "\10835" )
  , ( "angle" , False , "\8736" )
  , ( "angle.l" , False , "\10216" )
  , ( "angle.l.curly" , False , "\10748" )
  , ( "angle.l.dot" , False , "\10641" )
  , ( "angle.l.double" , False , "\10218" )
  , ( "angle.r" , False , "\10217" )
  , ( "angle.r.curly" , False , "\10749" )
  , ( "angle.r.dot" , False , "\10642" )
  , ( "angle.r.double" , False , "\10219" )
  , ( "angle.acute" , False , "\10655" )
  , ( "angle.arc" , False , "\8737" )
  , ( "angle.arc.rev" , False , "\10651" )
  , ( "angle.azimuth" , False , "\9084" )
  , ( "angle.obtuse" , False , "\10662" )
  , ( "angle.oblique" , False , "\10662" )
  , ( "angle.rev" , False , "\10659" )
  , ( "angle.right" , False , "\8735" )
  , ( "angle.right.rev" , False , "\11262" )
  , ( "angle.right.arc" , False , "\8894" )
  , ( "angle.right.dot" , False , "\10653" )
  , ( "angle.right.square" , False , "\10652" )
  , ( "angle.right.sq" , False , "\10652" )
  , ( "angle.s" , False , "\10654" )
  , ( "angle.spatial" , False , "\10176" )
  , ( "angle.spheric" , False , "\8738" )
  , ( "angle.spheric.rev" , False , "\10656" )
  , ( "angle.spheric.t" , False , "\10657" )
  , ( "angle.spheric.top" , False , "\10657" )
  , ( "angstrom" , False , "\197" )
  , ( "angzarr" , False , "\9084" )
  , ( "approx" , False , "\8776" )
  , ( "approx.eq" , False , "\8778" )
  , ( "approx.not" , False , "\8777" )
  , ( "arrow.r" , True , "\8594" )
  , ( "arrow.r.long.bar" , False , "\10236" )
  , ( "arrow.r.bar" , False , "\8614" )
  , ( "arrow.r.curve" , False , "\10551" )
  , ( "arrow.r.turn" , False , "\11150" )
  , ( "arrow.r.dashed" , False , "\8674" )
  , ( "arrow.r.dotted" , False , "\10513" )
  , ( "arrow.r.double" , False , "\8658" )
  , ( "arrow.r.double.bar" , False , "\10503" )
  , ( "arrow.r.double.long" , False , "\10233" )
  , ( "arrow.r.double.long.bar" , False , "\10238" )
  , ( "arrow.r.double.not" , False , "\8655" )
  , ( "arrow.r.double.struck" , False , "\10499" )
  , ( "arrow.r.filled" , False , "\10145\65038" )
  , ( "arrow.r.hook" , False , "\8618\65038" )
  , ( "arrow.r.long" , True , "\10230" )
  , ( "arrow.r.long.squiggly" , False , "\10239" )
  , ( "arrow.r.loop" , False , "\8620" )
  , ( "arrow.r.not" , False , "\8603" )
  , ( "arrow.r.quad" , False , "\11078" )
  , ( "arrow.r.squiggly" , False , "\8669" )
  , ( "arrow.r.stop" , False , "\8677" )
  , ( "arrow.r.stroked" , False , "\8680" )
  , ( "arrow.r.struck" , False , "\8696" )
  , ( "arrow.r.dstruck" , False , "\8699" )
  , ( "arrow.r.tail" , False , "\8611" )
  , ( "arrow.r.tail.struck" , False , "\10516" )
  , ( "arrow.r.tail.dstruck" , False , "\10517" )
  , ( "arrow.r.tilde" , False , "\10610" )
  , ( "arrow.r.triple" , False , "\8667" )
  , ( "arrow.r.twohead" , False , "\8608" )
  , ( "arrow.r.twohead.bar" , False , "\10501" )
  , ( "arrow.r.twohead.struck" , False , "\10496" )
  , ( "arrow.r.twohead.dstruck" , False , "\10497" )
  , ( "arrow.r.twohead.tail" , False , "\10518" )
  , ( "arrow.r.twohead.tail.struck" , False , "\10519" )
  , ( "arrow.r.twohead.tail.dstruck" , False , "\10520" )
  , ( "arrow.r.open" , False , "\8702" )
  , ( "arrow.r.wave" , False , "\8605" )
  , ( "arrow.l" , True , "\8592" )
  , ( "arrow.l.bar" , False , "\8612" )
  , ( "arrow.l.curve" , False , "\10550" )
  , ( "arrow.l.turn" , False , "\11148" )
  , ( "arrow.l.dashed" , False , "\8672" )
  , ( "arrow.l.dotted" , False , "\11064" )
  , ( "arrow.l.double" , False , "\8656" )
  , ( "arrow.l.double.bar" , False , "\10502" )
  , ( "arrow.l.double.long" , False , "\10232" )
  , ( "arrow.l.double.long.bar" , False , "\10237" )
  , ( "arrow.l.double.not" , False , "\8653" )
  , ( "arrow.l.double.struck" , False , "\10498" )
  , ( "arrow.l.filled" , False , "\11013\65038" )
  , ( "arrow.l.hook" , False , "\8617\65038" )
  , ( "arrow.l.long" , False , "\10229" )
  , ( "arrow.l.long.bar" , False , "\10235" )
  , ( "arrow.l.long.squiggly" , False , "\11059" )
  , ( "arrow.l.loop" , False , "\8619" )
  , ( "arrow.l.not" , False , "\8602" )
  , ( "arrow.l.quad" , False , "\11077" )
  , ( "arrow.l.squiggly" , False , "\8668" )
  , ( "arrow.l.stop" , False , "\8676" )
  , ( "arrow.l.stroked" , False , "\8678" )
  , ( "arrow.l.struck" , False , "\8695" )
  , ( "arrow.l.dstruck" , False , "\8698" )
  , ( "arrow.l.tail" , False , "\8610" )
  , ( "arrow.l.tail.struck" , False , "\11065" )
  , ( "arrow.l.tail.dstruck" , False , "\11066" )
  , ( "arrow.l.tilde" , False , "\11081" )
  , ( "arrow.l.triple" , False , "\8666" )
  , ( "arrow.l.twohead" , False , "\8606" )
  , ( "arrow.l.twohead.bar" , False , "\11062" )
  , ( "arrow.l.twohead.struck" , False , "\11060" )
  , ( "arrow.l.twohead.dstruck" , False , "\11061" )
  , ( "arrow.l.twohead.tail" , False , "\11067" )
  , ( "arrow.l.twohead.tail.struck" , False , "\11068" )
  , ( "arrow.l.twohead.tail.dstruck" , False , "\11069" )
  , ( "arrow.l.open" , False , "\8701" )
  , ( "arrow.l.wave" , False , "\8604" )
  , ( "arrow.t" , False , "\8593" )
  , ( "arrow.t.bar" , False , "\8613" )
  , ( "arrow.t.curve" , False , "\10548\65038" )
  , ( "arrow.t.turn" , False , "\11149" )
  , ( "arrow.t.dashed" , False , "\8673" )
  , ( "arrow.t.double" , False , "\8657" )
  , ( "arrow.t.filled" , False , "\11014\65038" )
  , ( "arrow.t.quad" , False , "\10224" )
  , ( "arrow.t.stop" , False , "\10514" )
  , ( "arrow.t.stroked" , False , "\8679" )
  , ( "arrow.t.struck" , False , "\10505" )
  , ( "arrow.t.dstruck" , False , "\8670" )
  , ( "arrow.t.triple" , False , "\10506" )
  , ( "arrow.t.twohead" , False , "\8607" )
  , ( "arrow.b" , False , "\8595" )
  , ( "arrow.b.bar" , False , "\8615" )
  , ( "arrow.b.curve" , False , "\10549\65038" )
  , ( "arrow.b.turn" , False , "\11151" )
  , ( "arrow.b.dashed" , False , "\8675" )
  , ( "arrow.b.double" , False , "\8659" )
  , ( "arrow.b.filled" , False , "\11015\65038" )
  , ( "arrow.b.quad" , False , "\10225" )
  , ( "arrow.b.stop" , False , "\10515" )
  , ( "arrow.b.stroked" , False , "\8681" )
  , ( "arrow.b.struck" , False , "\10504" )
  , ( "arrow.b.dstruck" , False , "\8671" )
  , ( "arrow.b.triple" , False , "\10507" )
  , ( "arrow.b.twohead" , False , "\8609" )
  , ( "arrow.l.r" , False , "\8596\65038" )
  , ( "arrow.l.r.double" , False , "\8660" )
  , ( "arrow.l.r.double.long" , False , "\10234" )
  , ( "arrow.l.r.double.not" , False , "\8654" )
  , ( "arrow.l.r.double.struck" , False , "\10500" )
  , ( "arrow.l.r.filled" , False , "\11020" )
  , ( "arrow.l.r.long" , True , "\10231" )
  , ( "arrow.l.r.not" , False , "\8622" )
  , ( "arrow.l.r.stroked" , False , "\11012" )
  , ( "arrow.l.r.struck" , False , "\8697" )
  , ( "arrow.l.r.dstruck" , False , "\8700" )
  , ( "arrow.l.r.open" , False , "\8703" )
  , ( "arrow.l.r.wave" , False , "\8621" )
  , ( "arrow.t.b" , False , "\8597\65038" )
  , ( "arrow.t.b.double" , False , "\8661" )
  , ( "arrow.t.b.filled" , False , "\11021" )
  , ( "arrow.t.b.stroked" , False , "\8691" )
  , ( "arrow.tr" , False , "\8599\65038" )
  , ( "arrow.tr.double" , False , "\8663" )
  , ( "arrow.tr.filled" , False , "\11016" )
  , ( "arrow.tr.hook" , False , "\10532" )
  , ( "arrow.tr.stroked" , False , "\11008" )
  , ( "arrow.br" , False , "\8600\65038" )
  , ( "arrow.br.double" , False , "\8664" )
  , ( "arrow.br.filled" , False , "\11018" )
  , ( "arrow.br.hook" , False , "\10533" )
  , ( "arrow.br.stroked" , False , "\11010" )
  , ( "arrow.tl" , False , "\8598\65038" )
  , ( "arrow.tl.double" , False , "\8662" )
  , ( "arrow.tl.filled" , False , "\11017" )
  , ( "arrow.tl.hook" , False , "\10531" )
  , ( "arrow.tl.stroked" , False , "\11009" )
  , ( "arrow.bl" , False , "\8601\65038" )
  , ( "arrow.bl.double" , False , "\8665" )
  , ( "arrow.bl.filled" , False , "\11019" )
  , ( "arrow.bl.hook" , False , "\10534" )
  , ( "arrow.bl.stroked" , False , "\11011" )
  , ( "arrow.tl.br" , False , "\10529" )
  , ( "arrow.tr.bl" , False , "\10530" )
  , ( "arrow.ccw" , False , "\8634" )
  , ( "arrow.ccw.half" , False , "\8630" )
  , ( "arrow.cw" , False , "\8635" )
  , ( "arrow.cw.half" , False , "\8631" )
  , ( "arrow.zigzag" , False , "\8623" )
  , ( "arrowhead.t" , False , "\8963" )
  , ( "arrowhead.b" , False , "\8964" )
  , ( "arrows.rr" , False , "\8649" )
  , ( "arrows.ll" , False , "\8647" )
  , ( "arrows.tt" , False , "\8648" )
  , ( "arrows.bb" , False , "\8650" )
  , ( "arrows.lr" , False , "\8646" )
  , ( "arrows.lr.stop" , False , "\8633" )
  , ( "arrows.rl" , False , "\8644" )
  , ( "arrows.tb" , False , "\8645" )
  , ( "arrows.bt" , False , "\8693" )
  , ( "arrows.rrr" , False , "\8694" )
  , ( "arrows.lll" , False , "\11057" )
  , ( "ast.op" , False , "\8727" )
  , ( "ast.op.o" , False , "\8859" )
  , ( "ast.basic" , False , "*\65038" )
  , ( "ast.low" , False , "\8270" )
  , ( "ast.double" , False , "\8273" )
  , ( "ast.triple" , False , "\8258" )
  , ( "ast.small" , False , "\65121" )
  , ( "ast.circle" , False , "\8859" )
  , ( "ast.square" , False , "\10694" )
  , ( "asymp" , False , "\8781" )
  , ( "asymp.not" , False , "\8813" )
  , ( "at" , False , "@" )
  , ( "backslash" , False , "\\" )
  , ( "backslash.o" , False , "\10680" )
  , ( "backslash.circle" , False , "\10680" )
  , ( "backslash.not" , False , "\10743" )
  , ( "bag.l" , False , "\10181" )
  , ( "bag.r" , False , "\10182" )
  , ( "baht" , False , "\3647" )
  , ( "ballot" , False , "\9744" )
  , ( "ballot.cross" , False , "\9746" )
  , ( "ballot.check" , False , "\9745\65038" )
  , ( "ballot.check.heavy" , False , "\128505" )
  , ( "bar.v" , False , "|" )
  , ( "bar.v.double" , False , "\8214" )
  , ( "bar.v.triple" , False , "\10624" )
  , ( "bar.v.broken" , False , "\166" )
  , ( "bar.v.o" , False , "\10678" )
  , ( "bar.v.circle" , False , "\10678" )
  , ( "bar.h" , False , "\8213" )
  , ( "because" , False , "\8757" )
  , ( "bet" , False , "\1489" )
  , ( "beta" , False , "\946" )
  , ( "beta.alt" , False , "\976" )
  , ( "beth" , False , "\1489" )
  , ( "bitcoin" , False , "\8383" )
  , ( "bot" , False , "\8869" )
  , ( "brace.l" , False , "{" )
  , ( "brace.l.stroked" , False , "\10627" )
  , ( "brace.l.double" , False , "\10627" )
  , ( "brace.r" , False , "}" )
  , ( "brace.r.stroked" , False , "\10628" )
  , ( "brace.r.double" , False , "\10628" )
  , ( "brace.t" , False , "\9182" )
  , ( "brace.b" , False , "\9183" )
  , ( "bracket.l" , False , "[" )
  , ( "bracket.l.tick.t" , False , "\10637" )
  , ( "bracket.l.tick.b" , False , "\10639" )
  , ( "bracket.l.stroked" , False , "\10214" )
  , ( "bracket.l.double" , False , "\10214" )
  , ( "bracket.r" , False , "]" )
  , ( "bracket.r.tick.t" , False , "\10640" )
  , ( "bracket.r.tick.b" , False , "\10638" )
  , ( "bracket.r.stroked" , False , "\10215" )
  , ( "bracket.r.double" , False , "\10215" )
  , ( "bracket.t" , False , "\9140" )
  , ( "bracket.b" , False , "\9141" )
  , ( "breve" , True , "\728" )
  , ( "bullet" , False , "\8226" )
  , ( "bullet.op" , False , "\8729" )
  , ( "bullet.o" , False , "\10687" )
  , ( "bullet.stroked" , False , "\9702" )
  , ( "bullet.stroked.o" , False , "\10686" )
  , ( "bullet.hole" , False , "\9688" )
  , ( "bullet.hyph" , False , "\8259" )
  , ( "bullet.tri" , False , "\8227" )
  , ( "bullet.l" , False , "\8268" )
  , ( "bullet.r" , False , "\8269" )
  , ( "caret" , False , "\8248" )
  , ( "caron" , True , "\711" )
  , ( "cc" , False , "\127341" )
  , ( "cc.by" , False , "\127343" )
  , ( "cc.nc" , False , "\127247" )
  , ( "cc.nd" , False , "\8860" )
  , ( "cc.public" , False , "\127342" )
  , ( "cc.sa" , False , "\127246" )
  , ( "cc.zero" , False , "\127245" )
  , ( "cedi" , False , "\8373" )
  , ( "ceil.l" , False , "\8968" )
  , ( "ceil.r" , False , "\8969" )
  , ( "cent" , False , "\162" )
  , ( "checkmark" , False , "\10003" )
  , ( "checkmark.light" , False , "\128504" )
  , ( "checkmark.heavy" , False , "\10004\65038" )
  , ( "chevron.l" , False , "\10216" )
  , ( "chevron.l.curly" , False , "\10748" )
  , ( "chevron.l.dot" , False , "\10641" )
  , ( "chevron.l.closed" , False , "\10633" )
  , ( "chevron.l.double" , False , "\10218" )
  , ( "chevron.r" , False , "\10217" )
  , ( "chevron.r.curly" , False , "\10749" )
  , ( "chevron.r.dot" , False , "\10642" )
  , ( "chevron.r.closed" , False , "\10634" )
  , ( "chevron.r.double" , False , "\10219" )
  , ( "chi" , False , "\967" )
  , ( "circle.stroked" , True , "\9675" )
  , ( "circle.stroked.tiny" , True , "\8728" )
  , ( "circle.stroked.small" , False , "\9900" )
  , ( "circle.stroked.big" , False , "\9711" )
  , ( "circle.filled" , False , "\9679" )
  , ( "circle.filled.tiny" , False , "\10625" )
  , ( "circle.filled.small" , False , "\8729" )
  , ( "circle.filled.big" , False , "\11044" )
  , ( "circle.dotted" , False , "\9676" )
  , ( "circle.nested" , False , "\8858" )
  , ( "co" , False , "\8453" )
  , ( "colon" , False , ":" )
  , ( "colon.currency" , False , "\8353" )
  , ( "colon.double" , False , "\8759" )
  , ( "colon.tri" , False , "\8285" )
  , ( "colon.tri.op" , False , "\10998" )
  , ( "colon.eq" , False , "\8788" )
  , ( "colon.double.eq" , False , "\10868" )
  , ( "comma" , False , "," )
  , ( "comma.inv" , False , "\11826" )
  , ( "comma.rev" , False , "\11841" )
  , ( "complement" , False , "\8705" )
  , ( "compose" , True , "\8728" )
  , ( "compose.o" , False , "\8858" )
  , ( "convolve" , False , "\8727" )
  , ( "convolve.o" , False , "\8859" )
  , ( "copyleft" , False , "\127279" )
  , ( "copyright" , False , "\169\65038" )
  , ( "copyright.sound" , False , "\8471" )
  , ( "corner.l.t" , False , "\8988" )
  , ( "corner.l.b" , False , "\8990" )
  , ( "corner.r.t" , False , "\8989" )
  , ( "corner.r.b" , False , "\8991" )
  , ( "crossmark" , False , "\10007" )
  , ( "crossmark.heavy" , False , "\10008" )
  , ( "currency" , False , "\164" )
  , ( "dagger" , False , "\8224" )
  , ( "dagger.double" , False , "\8225" )
  , ( "dagger.triple" , False , "\11851" )
  , ( "dagger.l" , False , "\11830" )
  , ( "dagger.r" , False , "\11831" )
  , ( "dagger.inv" , False , "\11832" )
  , ( "dalet" , False , "\1491" )
  , ( "daleth" , False , "\1491" )
  , ( "dash.en" , False , "\8211" )
  , ( "dash.em" , False , "\8212" )
  , ( "dash.em.two" , False , "\11834" )
  , ( "dash.em.three" , False , "\11835" )
  , ( "dash.fig" , False , "\8210" )
  , ( "dash.colon" , False , "\8761" )
  , ( "dash.o" , False , "\8861" )
  , ( "dash.circle" , False , "\8861" )
  , ( "dash.wave" , False , "\12316" )
  , ( "dash.wave.double" , False , "\12336\65038" )
  , ( "degree" , False , "\176" )
  , ( "delta" , False , "\948" )
  , ( "diaer" , True , "\168" )
  , ( "diameter" , False , "\8960" )
  , ( "diamond.stroked" , False , "\9671" )
  , ( "diamond.stroked.small" , False , "\8900" )
  , ( "diamond.stroked.medium" , False , "\11046" )
  , ( "diamond.stroked.dot" , False , "\10192" )
  , ( "diamond.filled" , False , "\9670" )
  , ( "diamond.filled.medium" , False , "\11045" )
  , ( "diamond.filled.small" , False , "\11049" )
  , ( "die.six" , False , "\9861" )
  , ( "die.five" , False , "\9860" )
  , ( "die.four" , False , "\9859" )
  , ( "die.three" , False , "\9858" )
  , ( "die.two" , False , "\9857" )
  , ( "die.one" , False , "\9856" )
  , ( "diff" , False , "\8706" )
  , ( "digamma" , False , "\989" )
  , ( "div" , False , "\247" )
  , ( "div.o" , False , "\10808" )
  , ( "div.slanted.o" , False , "\10684" )
  , ( "div.circle" , False , "\10808" )
  , ( "divides" , False , "\8739" )
  , ( "divides.not" , False , "\8740" )
  , ( "divides.not.rev" , False , "\10990" )
  , ( "divides.struck" , False , "\10186" )
  , ( "dollar" , False , "$" )
  , ( "dong" , False , "\8363" )
  , ( "dorome" , False , "\2046" )
  , ( "dot.op" , True , "\8901" )
  , ( "dot.basic" , True , "." )
  , ( "dot.c" , False , "\183" )
  , ( "dot.o" , False , "\8857" )
  , ( "dot.o.big" , False , "\10752" )
  , ( "dot.circle" , False , "\8857" )
  , ( "dot.circle.big" , False , "\10752" )
  , ( "dot.square" , False , "\8865" )
  , ( "dot.double" , True , "\168" )
  , ( "dot.triple" , True , "\8411" )
  , ( "dot.quad" , True , "\8412" )
  , ( "dotless.i" , False , "\305" )
  , ( "dotless.j" , False , "\567" )
  , ( "dots.h.c" , False , "\8943" )
  , ( "dots.h" , False , "\8230" )
  , ( "dots.v" , False , "\8942" )
  , ( "dots.down" , False , "\8945" )
  , ( "dots.up" , False , "\8944" )
  , ( "dram" , False , "\1423" )
  , ( "earth" , False , "\128808" )
  , ( "earth.alt" , False , "\9793" )
  , ( "ell" , False , "\8467" )
  , ( "ellipse.stroked.h" , False , "\11053" )
  , ( "ellipse.stroked.v" , False , "\11055" )
  , ( "ellipse.filled.h" , False , "\11052" )
  , ( "ellipse.filled.v" , False , "\11054" )
  , ( "emptyset" , False , "\8709" )
  , ( "emptyset.arrow.r" , False , "\10675" )
  , ( "emptyset.arrow.l" , False , "\10676" )
  , ( "emptyset.bar" , False , "\10673" )
  , ( "emptyset.circle" , False , "\10674" )
  , ( "emptyset.rev" , False , "\10672" )
  , ( "epsilon" , False , "\949" )
  , ( "epsilon.alt" , False , "\1013" )
  , ( "epsilon.alt.rev" , False , "\1014" )
  , ( "eq" , False , "=" )
  , ( "eq.star" , False , "\8795" )
  , ( "eq.o" , False , "\8860" )
  , ( "eq.circle" , False , "\8860" )
  , ( "eq.colon" , False , "\8789" )
  , ( "eq.dots" , False , "\8785" )
  , ( "eq.dots.down" , False , "\8786" )
  , ( "eq.dots.up" , False , "\8787" )
  , ( "eq.def" , False , "\8797" )
  , ( "eq.delta" , False , "\8796" )
  , ( "eq.equi" , False , "\8794" )
  , ( "eq.est" , False , "\8793" )
  , ( "eq.gt" , False , "\8925" )
  , ( "eq.lt" , False , "\8924" )
  , ( "eq.m" , False , "\8798" )
  , ( "eq.not" , False , "\8800" )
  , ( "eq.prec" , False , "\8926" )
  , ( "eq.quest" , False , "\8799" )
  , ( "eq.small" , False , "\65126" )
  , ( "eq.succ" , False , "\8927" )
  , ( "eq.triple" , False , "\8801" )
  , ( "eq.triple.not" , False , "\8802" )
  , ( "eq.quad" , False , "\8803" )
  , ( "equiv" , False , "\8801" )
  , ( "equiv.not" , False , "\8802" )
  , ( "errorbar.square.stroked" , False , "\10734" )
  , ( "errorbar.square.filled" , False , "\10735" )
  , ( "errorbar.diamond.stroked" , False , "\10736" )
  , ( "errorbar.diamond.filled" , False , "\10737" )
  , ( "errorbar.circle.stroked" , False , "\10738" )
  , ( "errorbar.circle.filled" , False , "\10739" )
  , ( "eta" , False , "\951" )
  , ( "euro" , False , "\8364" )
  , ( "excl" , False , "!" )
  , ( "excl.double" , False , "\8252\65038" )
  , ( "excl.inv" , False , "\161" )
  , ( "excl.quest" , False , "\8265\65038" )
  , ( "exists" , False , "\8707" )
  , ( "exists.not" , False , "\8708" )
  , ( "fence.l" , False , "\10712" )
  , ( "fence.l.double" , False , "\10714" )
  , ( "fence.r" , False , "\10713" )
  , ( "fence.r.double" , False , "\10715" )
  , ( "fence.dotted" , False , "\10649" )
  , ( "flat" , False , "\9837" )
  , ( "flat.t" , False , "\119084" )
  , ( "flat.b" , False , "\119085" )
  , ( "flat.double" , False , "\119083" )
  , ( "flat.quarter" , False , "\119091" )
  , ( "floor.l" , False , "\8970" )
  , ( "floor.r" , False , "\8971" )
  , ( "floral" , False , "\10086" )
  , ( "floral.l" , False , "\9753" )
  , ( "floral.r" , False , "\10087" )
  , ( "forall" , False , "\8704" )
  , ( "forces" , False , "\8873" )
  , ( "forces.not" , False , "\8878" )
  , ( "franc" , False , "\8355" )
  , ( "frown" , False , "\8994" )
  , ( "gamma" , False , "\947" )
  , ( "gimel" , False , "\1490" )
  , ( "gimmel" , False , "\1490" )
  , ( "gradient" , False , "\8711" )
  , ( "grave" , True , "`" )
  , ( "gt" , False , ">" )
  , ( "gt.o" , False , "\10689" )
  , ( "gt.circle" , False , "\10689" )
  , ( "gt.dot" , False , "\8919" )
  , ( "gt.approx" , False , "\10886" )
  , ( "gt.double" , False , "\8811" )
  , ( "gt.eq" , False , "\8805" )
  , ( "gt.eq.slant" , False , "\10878" )
  , ( "gt.eq.lt" , False , "\8923" )
  , ( "gt.eq.not" , False , "\8817" )
  , ( "gt.equiv" , False , "\8807" )
  , ( "gt.lt" , False , "\8823" )
  , ( "gt.lt.not" , False , "\8825" )
  , ( "gt.neq" , False , "\10888" )
  , ( "gt.napprox" , False , "\10890" )
  , ( "gt.nequiv" , False , "\8809" )
  , ( "gt.not" , False , "\8815" )
  , ( "gt.ntilde" , False , "\8935" )
  , ( "gt.small" , False , "\65125" )
  , ( "gt.tilde" , False , "\8819" )
  , ( "gt.tilde.not" , False , "\8821" )
  , ( "gt.tri" , False , "\8883" )
  , ( "gt.tri.eq" , False , "\8885" )
  , ( "gt.tri.eq.not" , False , "\8941" )
  , ( "gt.tri.not" , False , "\8939" )
  , ( "gt.triple" , False , "\8921" )
  , ( "gt.triple.nested" , False , "\11000" )
  , ( "guarani" , False , "\8370" )
  , ( "harpoon.rt" , True , "\8640" )
  , ( "harpoon.rt.bar" , False , "\10587" )
  , ( "harpoon.rt.stop" , False , "\10579" )
  , ( "harpoon.rb" , False , "\8641" )
  , ( "harpoon.rb.bar" , False , "\10591" )
  , ( "harpoon.rb.stop" , False , "\10583" )
  , ( "harpoon.lt" , True , "\8636" )
  , ( "harpoon.lt.bar" , False , "\10586" )
  , ( "harpoon.lt.stop" , False , "\10578" )
  , ( "harpoon.lb" , False , "\8637" )
  , ( "harpoon.lb.bar" , False , "\10590" )
  , ( "harpoon.lb.stop" , False , "\10582" )
  , ( "harpoon.tl" , False , "\8639" )
  , ( "harpoon.tl.bar" , False , "\10592" )
  , ( "harpoon.tl.stop" , False , "\10584" )
  , ( "harpoon.tr" , False , "\8638" )
  , ( "harpoon.tr.bar" , False , "\10588" )
  , ( "harpoon.tr.stop" , False , "\10580" )
  , ( "harpoon.bl" , False , "\8643" )
  , ( "harpoon.bl.bar" , False , "\10593" )
  , ( "harpoon.bl.stop" , False , "\10585" )
  , ( "harpoon.br" , False , "\8642" )
  , ( "harpoon.br.bar" , False , "\10589" )
  , ( "harpoon.br.stop" , False , "\10581" )
  , ( "harpoon.lt.rt" , False , "\10574" )
  , ( "harpoon.lb.rb" , False , "\10576" )
  , ( "harpoon.lb.rt" , False , "\10571" )
  , ( "harpoon.lt.rb" , False , "\10570" )
  , ( "harpoon.tl.bl" , False , "\10577" )
  , ( "harpoon.tr.br" , False , "\10575" )
  , ( "harpoon.tl.br" , False , "\10573" )
  , ( "harpoon.tr.bl" , False , "\10572" )
  , ( "harpoons.rtrb" , False , "\10596" )
  , ( "harpoons.blbr" , False , "\10597" )
  , ( "harpoons.bltr" , False , "\10607" )
  , ( "harpoons.lbrb" , False , "\10599" )
  , ( "harpoons.ltlb" , False , "\10594" )
  , ( "harpoons.ltrb" , False , "\8651" )
  , ( "harpoons.ltrt" , False , "\10598" )
  , ( "harpoons.rblb" , False , "\10601" )
  , ( "harpoons.rtlb" , False , "\8652" )
  , ( "harpoons.rtlt" , False , "\10600" )
  , ( "harpoons.tlbr" , False , "\10606" )
  , ( "harpoons.tltr" , False , "\10595" )
  , ( "hash" , False , "#\65038" )
  , ( "hat" , True , "^" )
  , ( "hexa.stroked" , False , "\11041" )
  , ( "hexa.filled" , False , "\11042" )
  , ( "hourglass.stroked" , False , "\10710" )
  , ( "hourglass.filled" , False , "\10711" )
  , ( "hryvnia" , False , "\8372" )
  , ( "hyph" , False , "\8208" )
  , ( "hyph.minus" , True , "-" )
  , ( "hyph.nobreak" , False , "\8209" )
  , ( "hyph.point" , False , "\8231" )
  , ( "hyph.soft" , False , "\173" )
  , ( "image" , False , "\8887" )
  , ( "in" , False , "\8712" )
  , ( "in.not" , False , "\8713" )
  , ( "in.rev" , False , "\8715" )
  , ( "in.rev.not" , False , "\8716" )
  , ( "in.rev.small" , False , "\8717" )
  , ( "in.small" , False , "\8714" )
  , ( "infinity" , False , "\8734" )
  , ( "infinity.bar" , False , "\10718" )
  , ( "infinity.incomplete" , False , "\10716" )
  , ( "infinity.tie" , False , "\10717" )
  , ( "integral" , False , "\8747" )
  , ( "integral.arrow.hook" , False , "\10775" )
  , ( "integral.ccw" , False , "\10769" )
  , ( "integral.cont" , False , "\8750" )
  , ( "integral.cont.ccw" , False , "\8755" )
  , ( "integral.cont.cw" , False , "\8754" )
  , ( "integral.cw" , False , "\8753" )
  , ( "integral.dash" , False , "\10765" )
  , ( "integral.dash.double" , False , "\10766" )
  , ( "integral.double" , False , "\8748" )
  , ( "integral.quad" , False , "\10764" )
  , ( "integral.inter" , False , "\10777" )
  , ( "integral.sect" , False , "\10777" )
  , ( "integral.slash" , False , "\10767" )
  , ( "integral.square" , False , "\10774" )
  , ( "integral.surf" , False , "\8751" )
  , ( "integral.times" , False , "\10776" )
  , ( "integral.triple" , False , "\8749" )
  , ( "integral.union" , False , "\10778" )
  , ( "integral.vol" , False , "\8752" )
  , ( "inter" , False , "\8745" )
  , ( "inter.and" , False , "\10820" )
  , ( "inter.big" , False , "\8898" )
  , ( "inter.dot" , False , "\10816" )
  , ( "inter.double" , False , "\8914" )
  , ( "inter.sq" , False , "\8851" )
  , ( "inter.sq.big" , False , "\10757" )
  , ( "inter.sq.double" , False , "\10830" )
  , ( "interleave" , False , "\10996" )
  , ( "interleave.big" , False , "\11004" )
  , ( "interleave.struck" , False , "\10997" )
  , ( "interrobang" , False , "\8253" )
  , ( "interrobang.inv" , False , "\11800" )
  , ( "iota" , False , "\953" )
  , ( "iota.inv" , False , "\8489" )
  , ( "join" , False , "\10781" )
  , ( "join.r" , False , "\10198" )
  , ( "join.l" , False , "\10197" )
  , ( "join.l.r" , False , "\10199" )
  , ( "jupiter" , False , "\9795" )
  , ( "kai" , False , "\983" )
  , ( "kappa" , False , "\954" )
  , ( "kappa.alt" , False , "\1008" )
  , ( "kip" , False , "\8365" )
  , ( "lambda" , False , "\955" )
  , ( "laplace" , False , "\8710" )
  , ( "lari" , False , "\8382" )
  , ( "lat" , False , "\10923" )
  , ( "lat.eq" , False , "\10925" )
  , ( "lira" , False , "\8378" )
  , ( "lozenge.stroked" , False , "\9674" )
  , ( "lozenge.stroked.small" , False , "\11051" )
  , ( "lozenge.stroked.medium" , False , "\11048" )
  , ( "lozenge.filled" , False , "\10731" )
  , ( "lozenge.filled.small" , False , "\11050" )
  , ( "lozenge.filled.medium" , False , "\11047" )
  , ( "lrm" , False , "\8206" )
  , ( "lt" , False , "<" )
  , ( "lt.o" , False , "\10688" )
  , ( "lt.circle" , False , "\10688" )
  , ( "lt.dot" , False , "\8918" )
  , ( "lt.approx" , False , "\10885" )
  , ( "lt.double" , False , "\8810" )
  , ( "lt.eq" , False , "\8804" )
  , ( "lt.eq.slant" , False , "\10877" )
  , ( "lt.eq.gt" , False , "\8922" )
  , ( "lt.eq.not" , False , "\8816" )
  , ( "lt.equiv" , False , "\8806" )
  , ( "lt.gt" , False , "\8822" )
  , ( "lt.gt.not" , False , "\8824" )
  , ( "lt.neq" , False , "\10887" )
  , ( "lt.napprox" , False , "\10889" )
  , ( "lt.nequiv" , False , "\8808" )
  , ( "lt.not" , False , "\8814" )
  , ( "lt.ntilde" , False , "\8934" )
  , ( "lt.small" , False , "\65124" )
  , ( "lt.tilde" , False , "\8818" )
  , ( "lt.tilde.not" , False , "\8820" )
  , ( "lt.tri" , False , "\8882" )
  , ( "lt.tri.eq" , False , "\8884" )
  , ( "lt.tri.eq.not" , False , "\8940" )
  , ( "lt.tri.not" , False , "\8938" )
  , ( "lt.triple" , False , "\8920" )
  , ( "lt.triple.nested" , False , "\10999" )
  , ( "macron" , True , "\175" )
  , ( "maltese" , False , "\10016" )
  , ( "manat" , False , "\8380" )
  , ( "mapsto" , False , "\8614" )
  , ( "mapsto.long" , False , "\10236" )
  , ( "mars" , False , "\9794\65038" )
  , ( "mercury" , False , "\9791" )
  , ( "minus" , True , "\8722" )
  , ( "minus.o" , False , "\8854" )
  , ( "minus.circle" , False , "\8854" )
  , ( "minus.dot" , False , "\8760" )
  , ( "minus.plus" , False , "\8723" )
  , ( "minus.square" , False , "\8863" )
  , ( "minus.tilde" , False , "\8770" )
  , ( "minus.triangle" , False , "\10810" )
  , ( "miny" , False , "\10751" )
  , ( "models" , False , "\8871" )
  , ( "mu" , False , "\956" )
  , ( "multimap" , False , "\8888" )
  , ( "multimap.double" , False , "\10719" )
  , ( "mustache.l" , False , "\9136" )
  , ( "mustache.r" , False , "\9137" )
  , ( "nabla" , False , "\8711" )
  , ( "naira" , False , "\8358" )
  , ( "natural" , False , "\9838" )
  , ( "natural.t" , False , "\119086" )
  , ( "natural.b" , False , "\119087" )
  , ( "neptune" , False , "\9798" )
  , ( "neptune.alt" , False , "\11209" )
  , ( "not" , False , "\172" )
  , ( "note.up" , False , "\127900" )
  , ( "note.down" , False , "\127901" )
  , ( "note.whole" , False , "\119133" )
  , ( "note.half" , False , "\119134" )
  , ( "note.quarter" , False , "\119135" )
  , ( "note.quarter.alt" , False , "\9833" )
  , ( "note.eighth" , False , "\119136" )
  , ( "note.eighth.alt" , False , "\9834" )
  , ( "note.eighth.beamed" , False , "\9835" )
  , ( "note.sixteenth" , False , "\119137" )
  , ( "note.sixteenth.beamed" , False , "\9836" )
  , ( "note.grace" , False , "\119189" )
  , ( "note.grace.slash" , False , "\119188" )
  , ( "nothing" , False , "\8709" )
  , ( "nothing.arrow.r" , False , "\10675" )
  , ( "nothing.arrow.l" , False , "\10676" )
  , ( "nothing.bar" , False , "\10673" )
  , ( "nothing.circle" , False , "\10674" )
  , ( "nothing.rev" , False , "\10672" )
  , ( "nu" , False , "\957" )
  , ( "numero" , False , "\8470" )
  , ( "omega" , False , "\969" )
  , ( "omicron" , False , "\959" )
  , ( "oo" , False , "\8734" )
  , ( "or" , False , "\8744" )
  , ( "or.big" , False , "\8897" )
  , ( "or.curly" , False , "\8910" )
  , ( "or.dot" , False , "\10183" )
  , ( "or.double" , False , "\10836" )
  , ( "original" , False , "\8886" )
  , ( "parallel" , False , "\8741" )
  , ( "parallel.struck" , False , "\10994" )
  , ( "parallel.o" , False , "\10679" )
  , ( "parallel.circle" , False , "\10679" )
  , ( "parallel.eq" , False , "\8917" )
  , ( "parallel.equiv" , False , "\10856" )
  , ( "parallel.not" , False , "\8742" )
  , ( "parallel.slanted.eq" , False , "\10723" )
  , ( "parallel.slanted.eq.tilde" , False , "\10724" )
  , ( "parallel.slanted.equiv" , False , "\10725" )
  , ( "parallel.tilde" , False , "\10995" )
  , ( "parallelogram.stroked" , False , "\9649" )
  , ( "parallelogram.filled" , False , "\9648" )
  , ( "paren.l" , False , "(" )
  , ( "paren.l.flat" , False , "\10222" )
  , ( "paren.l.closed" , False , "\10631" )
  , ( "paren.l.stroked" , False , "\10629" )
  , ( "paren.l.double" , False , "\10629" )
  , ( "paren.r" , False , ")" )
  , ( "paren.r.flat" , False , "\10223" )
  , ( "paren.r.closed" , False , "\10632" )
  , ( "paren.r.stroked" , False , "\10630" )
  , ( "paren.r.double" , False , "\10630" )
  , ( "paren.t" , False , "\9180" )
  , ( "paren.b" , False , "\9181" )
  , ( "partial" , False , "\8706" )
  , ( "pataca" , False , "$" )
  , ( "penta.stroked" , False , "\11040" )
  , ( "penta.filled" , False , "\11039" )
  , ( "percent" , False , "%" )
  , ( "permille" , False , "\8240" )
  , ( "permyriad" , False , "\8241" )
  , ( "perp" , False , "\10178" )
  , ( "perp.o" , False , "\10681" )
  , ( "perp.circle" , False , "\10681" )
  , ( "peso" , False , "$" )
  , ( "peso.philippine" , False , "\8369" )
  , ( "phi" , False , "\966" )
  , ( "phi.alt" , False , "\981" )
  , ( "pi" , False , "\960" )
  , ( "pi.alt" , False , "\982" )
  , ( "pilcrow" , False , "\182" )
  , ( "pilcrow.rev" , False , "\8267" )
  , ( "planck" , False , "\295" )
  , ( "planck.reduce" , False , "\295" )
  , ( "plus" , False , "+" )
  , ( "plus.o" , False , "\8853" )
  , ( "plus.o.l" , False , "\10797" )
  , ( "plus.o.r" , False , "\10798" )
  , ( "plus.o.arrow" , False , "\10228" )
  , ( "plus.o.big" , False , "\10753" )
  , ( "plus.circle" , False , "\8853" )
  , ( "plus.circle.arrow" , False , "\10228" )
  , ( "plus.circle.big" , False , "\10753" )
  , ( "plus.dot" , False , "\8724" )
  , ( "plus.double" , False , "\10746" )
  , ( "plus.minus" , False , "\177" )
  , ( "plus.small" , False , "\65122" )
  , ( "plus.square" , False , "\8862" )
  , ( "plus.triangle" , False , "\10809" )
  , ( "plus.triple" , False , "\10747" )
  , ( "pound" , False , "\163" )
  , ( "power.standby" , False , "\9211" )
  , ( "power.on" , False , "\9213" )
  , ( "power.off" , False , "\11096" )
  , ( "power.on.off" , False , "\9212" )
  , ( "power.sleep" , False , "\9214" )
  , ( "prec" , False , "\8826" )
  , ( "prec.approx" , False , "\10935" )
  , ( "prec.curly.eq" , False , "\8828" )
  , ( "prec.curly.eq.not" , False , "\8928" )
  , ( "prec.double" , False , "\10939" )
  , ( "prec.eq" , False , "\10927" )
  , ( "prec.equiv" , False , "\10931" )
  , ( "prec.napprox" , False , "\10937" )
  , ( "prec.neq" , False , "\10929" )
  , ( "prec.nequiv" , False , "\10933" )
  , ( "prec.not" , False , "\8832" )
  , ( "prec.ntilde" , False , "\8936" )
  , ( "prec.tilde" , False , "\8830" )
  , ( "prime" , False , "\8242" )
  , ( "prime.rev" , False , "\8245" )
  , ( "prime.double" , False , "\8243" )
  , ( "prime.double.rev" , False , "\8246" )
  , ( "prime.triple" , False , "\8244" )
  , ( "prime.triple.rev" , False , "\8247" )
  , ( "prime.quad" , False , "\8279" )
  , ( "product" , False , "\8719" )
  , ( "product.co" , False , "\8720" )
  , ( "prop" , False , "\8733" )
  , ( "psi" , False , "\968" )
  , ( "qed" , False , "\8718" )
  , ( "quest" , False , "?" )
  , ( "quest.double" , False , "\8263" )
  , ( "quest.excl" , False , "\8264" )
  , ( "quest.inv" , False , "\191" )
  , ( "quote.double" , False , "\"" )
  , ( "quote.single" , False , "'" )
  , ( "quote.l.double" , False , "\8220" )
  , ( "quote.l.single" , False , "\8216" )
  , ( "quote.r.double" , False , "\8221" )
  , ( "quote.r.single" , False , "\8217" )
  , ( "quote.chevron.l.double" , False , "\171" )
  , ( "quote.chevron.l.single" , False , "\8249" )
  , ( "quote.chevron.r.double" , False , "\187" )
  , ( "quote.chevron.r.single" , False , "\8250" )
  , ( "quote.angle.l.double" , False , "\171" )
  , ( "quote.angle.l.single" , False , "\8249" )
  , ( "quote.angle.r.double" , False , "\187" )
  , ( "quote.angle.r.single" , False , "\8250" )
  , ( "quote.high.double" , False , "\8223" )
  , ( "quote.high.single" , False , "\8219" )
  , ( "quote.low.double" , False , "\8222" )
  , ( "quote.low.single" , False , "\8218" )
  , ( "ratio" , False , "\8758" )
  , ( "rect.stroked.h" , False , "\9645" )
  , ( "rect.stroked.v" , False , "\9647" )
  , ( "rect.filled.h" , False , "\9644" )
  , ( "rect.filled.v" , False , "\9646" )
  , ( "refmark" , False , "\8251" )
  , ( "rest.whole" , False , "\119099" )
  , ( "rest.multiple" , False , "\119098" )
  , ( "rest.multiple.measure" , False , "\119081" )
  , ( "rest.half" , False , "\119100" )
  , ( "rest.quarter" , False , "\119101" )
  , ( "rest.eighth" , False , "\119102" )
  , ( "rest.sixteenth" , False , "\119103" )
  , ( "rho" , False , "\961" )
  , ( "rho.alt" , False , "\1009" )
  , ( "riel" , False , "\6107" )
  , ( "rlm" , False , "\8207" )
  , ( "ruble" , False , "\8381" )
  , ( "rupee.indian" , False , "\8377" )
  , ( "rupee.generic" , False , "\8360" )
  , ( "rupee.tamil" , False , "\3065" )
  , ( "rupee.wancho" , False , "\123647" )
  , ( "saturn" , False , "\9796" )
  , ( "sect" , False , "\8745" )
  , ( "sect.and" , False , "\10820" )
  , ( "sect.big" , False , "\8898" )
  , ( "sect.dot" , False , "\10816" )
  , ( "sect.double" , False , "\8914" )
  , ( "sect.sq" , False , "\8851" )
  , ( "sect.sq.big" , False , "\10757" )
  , ( "sect.sq.double" , False , "\10830" )
  , ( "section" , False , "\167" )
  , ( "semi" , False , ";" )
  , ( "semi.inv" , False , "\11829" )
  , ( "semi.rev" , False , "\8271" )
  , ( "sha" , False , "\1096" )
  , ( "sharp" , False , "\9839" )
  , ( "sharp.t" , False , "\119088" )
  , ( "sharp.b" , False , "\119089" )
  , ( "sharp.double" , False , "\119082" )
  , ( "sharp.quarter" , False , "\119090" )
  , ( "shekel" , False , "\8362" )
  , ( "shell.l" , False , "\10098" )
  , ( "shell.l.stroked" , False , "\10220" )
  , ( "shell.l.filled" , False , "\10647" )
  , ( "shell.l.double" , False , "\10220" )
  , ( "shell.r" , False , "\10099" )
  , ( "shell.r.stroked" , False , "\10221" )
  , ( "shell.r.filled" , False , "\10648" )
  , ( "shell.r.double" , False , "\10221" )
  , ( "shell.t" , False , "\9184" )
  , ( "shell.b" , False , "\9185" )
  , ( "shin" , False , "\1513" )
  , ( "sigma" , False , "\963" )
  , ( "sigma.alt" , False , "\962" )
  , ( "slash" , False , "/" )
  , ( "slash.o" , False , "\8856" )
  , ( "slash.double" , False , "\11005" )
  , ( "slash.triple" , False , "\11003" )
  , ( "slash.big" , False , "\10744" )
  , ( "smash" , False , "\10803" )
  , ( "smile" , False , "\8995" )
  , ( "smt" , False , "\10922" )
  , ( "smt.eq" , False , "\10924" )
  , ( "som" , False , "\8384" )
  , ( "space" , False , " " )
  , ( "space.nobreak" , False , "\160" )
  , ( "space.nobreak.narrow" , False , "\8239" )
  , ( "space.en" , False , "\8194" )
  , ( "space.quad" , False , "\8195" )
  , ( "space.third" , False , "\8196" )
  , ( "space.quarter" , False , "\8197" )
  , ( "space.sixth" , False , "\8198" )
  , ( "space.med" , False , "\8287" )
  , ( "space.fig" , False , "\8199" )
  , ( "space.punct" , False , "\8200" )
  , ( "space.thin" , False , "\8201" )
  , ( "space.hair" , False , "\8202" )
  , ( "square.stroked" , False , "\9633" )
  , ( "square.stroked.tiny" , False , "\9643\65038" )
  , ( "square.stroked.small" , False , "\9725\65038" )
  , ( "square.stroked.medium" , False , "\9723\65038" )
  , ( "square.stroked.big" , False , "\11036\65038" )
  , ( "square.stroked.dotted" , False , "\11034" )
  , ( "square.stroked.rounded" , False , "\9634" )
  , ( "square.filled" , False , "\9632" )
  , ( "square.filled.tiny" , False , "\9642\65038" )
  , ( "square.filled.small" , False , "\9726\65038" )
  , ( "square.filled.medium" , False , "\9724\65038" )
  , ( "square.filled.big" , False , "\11035\65038" )
  , ( "star.op" , False , "\8902" )
  , ( "star.stroked" , False , "\9734" )
  , ( "star.filled" , False , "\9733" )
  , ( "subset" , False , "\8834" )
  , ( "subset.dot" , False , "\10941" )
  , ( "subset.double" , False , "\8912" )
  , ( "subset.eq" , False , "\8838" )
  , ( "subset.eq.not" , False , "\8840" )
  , ( "subset.eq.sq" , False , "\8849" )
  , ( "subset.eq.sq.not" , False , "\8930" )
  , ( "subset.neq" , False , "\8842" )
  , ( "subset.not" , False , "\8836" )
  , ( "subset.sq" , False , "\8847" )
  , ( "subset.sq.neq" , False , "\8932" )
  , ( "succ" , False , "\8827" )
  , ( "succ.approx" , False , "\10936" )
  , ( "succ.curly.eq" , False , "\8829" )
  , ( "succ.curly.eq.not" , False , "\8929" )
  , ( "succ.double" , False , "\10940" )
  , ( "succ.eq" , False , "\10928" )
  , ( "succ.equiv" , False , "\10932" )
  , ( "succ.napprox" , False , "\10938" )
  , ( "succ.neq" , False , "\10930" )
  , ( "succ.nequiv" , False , "\10934" )
  , ( "succ.not" , False , "\8833" )
  , ( "succ.ntilde" , False , "\8937" )
  , ( "succ.tilde" , False , "\8831" )
  , ( "suit.club.filled" , False , "\9827\65038" )
  , ( "suit.club.stroked" , False , "\9831" )
  , ( "suit.diamond.filled" , False , "\9830\65038" )
  , ( "suit.diamond.stroked" , False , "\9826" )
  , ( "suit.heart.filled" , False , "\9829\65038" )
  , ( "suit.heart.stroked" , False , "\9825" )
  , ( "suit.spade.filled" , False , "\9824\65038" )
  , ( "suit.spade.stroked" , False , "\9828" )
  , ( "sum" , False , "\8721" )
  , ( "sum.integral" , False , "\10763" )
  , ( "sun" , False , "\9737" )
  , ( "supset" , False , "\8835" )
  , ( "supset.dot" , False , "\10942" )
  , ( "supset.double" , False , "\8913" )
  , ( "supset.eq" , False , "\8839" )
  , ( "supset.eq.not" , False , "\8841" )
  , ( "supset.eq.sq" , False , "\8850" )
  , ( "supset.eq.sq.not" , False , "\8931" )
  , ( "supset.neq" , False , "\8843" )
  , ( "supset.not" , False , "\8837" )
  , ( "supset.sq" , False , "\8848" )
  , ( "supset.sq.neq" , False , "\8933" )
  , ( "tack.r" , False , "\8866" )
  , ( "tack.r.not" , False , "\8876" )
  , ( "tack.r.long" , False , "\10205" )
  , ( "tack.r.short" , False , "\8870" )
  , ( "tack.r.double" , False , "\8872" )
  , ( "tack.r.double.not" , False , "\8877" )
  , ( "tack.l" , False , "\8867" )
  , ( "tack.l.long" , False , "\10206" )
  , ( "tack.l.short" , False , "\10974" )
  , ( "tack.l.double" , False , "\10980" )
  , ( "tack.t" , False , "\8869" )
  , ( "tack.t.big" , False , "\10200" )
  , ( "tack.t.double" , False , "\10987" )
  , ( "tack.t.short" , False , "\10976" )
  , ( "tack.b" , False , "\8868" )
  , ( "tack.b.big" , False , "\10201" )
  , ( "tack.b.double" , False , "\10986" )
  , ( "tack.b.short" , False , "\10975" )
  , ( "tack.l.r" , False , "\10203" )
  , ( "taka" , False , "\2547" )
  , ( "taman" , False , "\2047" )
  , ( "tau" , False , "\964" )
  , ( "tenge" , False , "\8376" )
  , ( "therefore" , False , "\8756" )
  , ( "theta" , False , "\952" )
  , ( "theta.alt" , False , "\977" )
  , ( "tilde.op" , True , "\8764" )
  , ( "tilde.basic" , True , "~" )
  , ( "tilde.dot" , False , "\10858" )
  , ( "tilde.eq" , False , "\8771" )
  , ( "tilde.eq.not" , False , "\8772" )
  , ( "tilde.eq.rev" , False , "\8909" )
  , ( "tilde.equiv" , False , "\8773" )
  , ( "tilde.equiv.not" , False , "\8775" )
  , ( "tilde.nequiv" , False , "\8774" )
  , ( "tilde.not" , False , "\8769" )
  , ( "tilde.rev" , False , "\8765" )
  , ( "tilde.rev.equiv" , False , "\8780" )
  , ( "tilde.triple" , False , "\8779" )
  , ( "times" , False , "\215" )
  , ( "times.big" , False , "\10761" )
  , ( "times.o" , False , "\8855" )
  , ( "times.o.l" , False , "\10804" )
  , ( "times.o.r" , False , "\10805" )
  , ( "times.o.hat" , False , "\10806" )
  , ( "times.o.big" , False , "\10754" )
  , ( "times.circle" , False , "\8855" )
  , ( "times.circle.big" , False , "\10754" )
  , ( "times.div" , False , "\8903" )
  , ( "times.three.l" , False , "\8907" )
  , ( "times.three.r" , False , "\8908" )
  , ( "times.l" , False , "\8905" )
  , ( "times.r" , False , "\8906" )
  , ( "times.square" , False , "\8864" )
  , ( "times.triangle" , False , "\10811" )
  , ( "tiny" , False , "\10750" )
  , ( "togrog" , False , "\8366" )
  , ( "top" , False , "\8868" )
  , ( "trademark" , False , "\8482\65038" )
  , ( "trademark.registered" , False , "\174\65038" )
  , ( "trademark.service" , False , "\8480" )
  , ( "triangle.stroked.t" , False , "\9651" )
  , ( "triangle.stroked.b" , False , "\9661" )
  , ( "triangle.stroked.r" , False , "\9655" )
  , ( "triangle.stroked.l" , False , "\9665" )
  , ( "triangle.stroked.bl" , False , "\9722" )
  , ( "triangle.stroked.br" , False , "\9727" )
  , ( "triangle.stroked.tl" , False , "\9720" )
  , ( "triangle.stroked.tr" , False , "\9721" )
  , ( "triangle.stroked.small.t" , False , "\9653" )
  , ( "triangle.stroked.small.b" , False , "\9663" )
  , ( "triangle.stroked.small.r" , False , "\9657" )
  , ( "triangle.stroked.small.l" , False , "\9667" )
  , ( "triangle.stroked.rounded" , False , "\128710" )
  , ( "triangle.stroked.nested" , False , "\10177" )
  , ( "triangle.stroked.dot" , False , "\9708" )
  , ( "triangle.filled.t" , False , "\9650" )
  , ( "triangle.filled.b" , False , "\9660" )
  , ( "triangle.filled.r" , False , "\9654\65038" )
  , ( "triangle.filled.l" , False , "\9664\65038" )
  , ( "triangle.filled.bl" , False , "\9699" )
  , ( "triangle.filled.br" , False , "\9698" )
  , ( "triangle.filled.tl" , False , "\9700" )
  , ( "triangle.filled.tr" , False , "\9701" )
  , ( "triangle.filled.small.t" , False , "\9652" )
  , ( "triangle.filled.small.b" , False , "\9662" )
  , ( "triangle.filled.small.r" , False , "\9656" )
  , ( "triangle.filled.small.l" , False , "\9666" )
  , ( "union" , False , "\8746" )
  , ( "union.arrow" , False , "\8844" )
  , ( "union.big" , False , "\8899" )
  , ( "union.dot" , False , "\8845" )
  , ( "union.dot.big" , False , "\10755" )
  , ( "union.double" , False , "\8915" )
  , ( "union.minus" , False , "\10817" )
  , ( "union.or" , False , "\10821" )
  , ( "union.plus" , False , "\8846" )
  , ( "union.plus.big" , False , "\10756" )
  , ( "union.sq" , False , "\8852" )
  , ( "union.sq.big" , False , "\10758" )
  , ( "union.sq.double" , False , "\10831" )
  , ( "upsilon" , False , "\965" )
  , ( "uranus" , False , "\9954" )
  , ( "uranus.alt" , False , "\9797" )
  , ( "venus" , False , "\9792\65038" )
  , ( "without" , False , "\8726" )
  , ( "wj" , False , "\8288" )
  , ( "won" , False , "\8361" )
  , ( "wreath" , False , "\8768" )
  , ( "xi" , False , "\958" )
  , ( "xor" , False , "\8853" )
  , ( "xor.big" , False , "\10753" )
  , ( "yen" , False , "\165" )
  , ( "yuan" , False , "\165" )
  , ( "zeta" , False , "\950" )
  , ( "zwj" , False , "\8205" )
  , ( "zwnj" , False , "\8204" )
  , ( "zws" , False , "\8203" )
  ]
