{- |
Copyright : (c) 2024 Pierre Le Marre
Maintainer: dev@wismill.eu
Stability : experimental

[Default values](https://www.unicode.org/reports/tr44/#Default_Values)
for properties.
-}
module Unicode.CharacterDatabase.Parser.Properties.Defaults (
  defaultAge,
  defaultGeneralCategory,
  defaultScript,
) where

import Data.ByteString.Short qualified as BS

-- | Default age
defaultAge ∷ BS.ShortByteString
defaultAge = "Unassigned"

-- | Default general category
defaultGeneralCategory ∷ BS.ShortByteString
defaultGeneralCategory = "Cn"

-- | Default script
defaultScript ∷ BS.ShortByteString
defaultScript = "Unknown"
