{-# LANGUAGE StandaloneKindSignatures #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE NoImportQualifiedPost #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE TypeApplications #-}
{-# LANGUAGE FlexibleContexts #-}
{-# LANGUAGE FunctionalDependencies #-}
{-# LANGUAGE ConstraintKinds #-}
{-# LANGUAGE DataKinds #-}
{-# LANGUAGE TypeFamilies #-}
{-# LANGUAGE UndecidableInstances #-}
{-# LANGUAGE AllowAmbiguousTypes #-}
{-# LANGUAGE DerivingStrategies #-}
{-# LANGUAGE NoGeneralisedNewtypeDeriving #-}
{-# LANGUAGE RequiredTypeArguments #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE Safe #-}
module Dimensions.Units (
    Dimension(..)
    , (!*)
    , (!/)
    , (!-)
    , (!+)
    , type (!*)
    , type (!/)
    , type (!^^)
    , type (!^)
    , type RT
    , type RTN
    , Replace
    , Isos
    , Delete
    , Format
    , ValidDimension
    , ValidParse
    , mkisos
    , applyPos
    , applyNeg
    , apply
    , same
    , transformPos
    , transformNeg
    , transform
    , validateDimension
    , undimension
    , dimensions
    , dimension
    , dimensionsPoly
    , dimensionPoly
    , divD
    , combineD2
    , liftD2
    , dimNPs
    , dimNP
    , getDimensionNP
    , getDimension 
    , dims 
    , dim 
    , combineInvD2
    , rtn 
    , rt 
    , (!^)
    , (!^^)
    , inject
    , replace
    , match 
    , ReadTypeDimension
    , ToDimension
    , FromTypeDimension
    , FromDimension
    , (!<*>)
    ) where 
import Dimensions.Printer (FromDimension,FromTypeDimension)
import Dimensions.Parser (ReadTypeDimension,ToDimension)
import qualified GHC.TypeLits as TL
import GHC.TypeLits (Symbol,Nat)
import qualified Dimensions.TypeLevelInt as TI
import Dimensions.TypeLevelInt (Int')
import Dimensions.Parser (Parse)
import Dimensions.Order (Sort,Merge)
import Data.Kind (Constraint)
import Dimensions.DimensionalMisc (Isos',Delete,UnZero,Replace',LookupD0,Invert)
import Dimensions.Data (Dimension(MkDimension),liftD2,(!<*>))
import qualified Dimensions.GetTermLevel as TT
import Dimensions.Match (MatchAll,ChangeMatch,HowManyMatches,convert,unconvert)
type Replace :: k -> k -> [(k, Int')] -> [(k, Int')]
type Replace s t x = Sort (Replace' s t x)
type Isos :: [(a, a)] -> [(a, k)] -> [(k, Int')]
type Isos a b = Sort (Isos' a b)
type Format :: [(k, Int')] -> [(k, Int')]
type Format a = Sort (UnZero a)
type ValidDimension :: [(k, Int')] -> Constraint
type ValidDimension a = (a ~ Format a)
type ValidParse :: forall k. Symbol -> [(k,Int')]
type ValidParse a = Sort (Parse a)
type (!*) :: [(k,Int')] -> [(k,Int')] -> [(k,Int')]
type (!*) a b = UnZero (Merge a b)
type (!/) :: [(k,Int')] -> [(k,Int')] -> [(k,Int')]
type (!/) a b = UnZero (Merge a (Invert b))
type (!^^) :: [(a,Int')] -> Int' -> [(a,Int')]
type family (!^^) a b where 
  '[] !^^ _ = '[]
  ('(a,b)':xs) !^^ e = '(a,b TI.* e) ': xs !^^ e 
type (!^) :: [(a,Int')] -> Nat -> [(a,Int')]
type a !^ b = a !^^ ('TI.Pos b)
type RT :: [(a,Int')] ->  Int' -> [(a,Int')]
type family RT a b where 
  '[] `RT` _ = '[]
  ('(a,e)':xs) `RT` b = '(a, e TI./ b) ': xs `RT` b
type RTN :: [(a,Int')] -> Nat -> [(a,Int')]
type RTN a b = RT a ('TI.Pos b) 
(!^^) :: Fractional n => Dimension a n -> forall b-> TT.ToInt b => Dimension (a !^^ b) n
(MkDimension a) !^^ b = MkDimension (a ^^ (TT.intval b))
infixr 8 !^^
(!^) :: Num n => Dimension a n -> forall b-> TL.KnownNat b => Dimension (a !^ b) n
(MkDimension a) !^ b = MkDimension (a ^ (TT.natVal b))
{-# INLINE (!^) #-}
rt :: Floating n => Dimension a n -> forall b-> TT.ToInt b => Dimension (RT a b) n
rt (MkDimension a) b = MkDimension (a ** (recip (fromInteger (TT.intval b))))
{-# INLINE rt #-}
rtn :: Floating n => Dimension a n -> forall b-> TL.KnownNat b => Dimension (RTN a b) n
rtn (MkDimension a) b = MkDimension (a ** (recip (fromInteger (TT.natVal b))))
{-# INLINE rtn #-}
(!+) :: Num n => Dimension a n -> Dimension a n -> Dimension a n
(!+) = liftD2 (+)
infixl 6 !+
{-# INLINE (!+) #-}

(!-) :: Num n => Dimension a n -> Dimension a n -> Dimension a n
(!-) = liftD2 (-)
infixl 6 !-
{-# INLINE (!-) #-}
dim :: forall b. b -> forall a -> Dimension (ValidParse @Symbol a) b 
dim b _ = MkDimension b  
{-# INLINE dim #-}
dims :: forall f b. Functor f => f b -> forall a ->  f (Dimension (ValidParse @Symbol a) b) 
dims b _ = fmap MkDimension b  
{-# INLINE dims #-}

dimension :: forall a -> forall b. b -> Dimension (ValidParse @Symbol a)  b
dimension _ = MkDimension
{-# INLINE dimension #-}

dimensions :: forall a -> forall f b. Functor f => f b -> f (Dimension (ValidParse @Symbol a) b)
dimensions _ = fmap MkDimension
{-# INLINE dimensions #-}

dimensionPoly :: forall a -> forall b.  b -> Dimension (ValidParse a) b
dimensionPoly _ = MkDimension
{-# INLINE dimensionPoly #-}

dimensionsPoly :: forall a -> forall f b. Functor f => f b -> f (Dimension (ValidParse a) b)
dimensionsPoly _ = fmap MkDimension
{-# INLINE dimensionsPoly #-}

dimNP :: forall a -> forall b. b -> Dimension (Format a) b
dimNP _ = MkDimension
{-# INLINE dimNP #-}

dimNPs :: forall a -> forall f b. Functor f => f b -> f (Dimension (Format a) b)
dimNPs _ = fmap MkDimension
{-# INLINE dimNPs #-}

validateDimension :: Dimension a b -> Dimension (Format a) b
validateDimension (MkDimension a) = MkDimension a
{-# INLINE validateDimension #-}

combineD2 :: (a -> b -> c) -> Dimension tag1 a -> Dimension tag2 b -> Dimension (tag1 !* tag2) c
combineD2 f (MkDimension a) (MkDimension b) = MkDimension (f a b)
{-# INLINE combineD2 #-}
combineInvD2 :: (a -> b -> c) -> Dimension tag1 a -> Dimension tag2 b -> Dimension (tag1 !/ tag2) c
combineInvD2 f (MkDimension a) (MkDimension b) = MkDimension (f a b)
{-# INLINE combineInvD2 #-}

(!*) :: Num n => Dimension a n -> Dimension b n -> Dimension (a !* b) n
(MkDimension a) !* (MkDimension b) = MkDimension (a * b)
infixl 7 !*
{-# INLINE (!*) #-}
(!/) :: Fractional n => Dimension a n -> Dimension b n -> Dimension (a !/ b) n
(MkDimension a) !/ (MkDimension b) = MkDimension (a / b)
infixl 7 !/
recipD :: Fractional n => Dimension a n -> Dimension (Invert a) n
recipD (MkDimension a) = MkDimension $ recip a
{-# INLINE (!/) #-}
divD :: Integral n => Dimension a n -> Dimension b n -> Dimension (a !/ b) n
divD (MkDimension a) (MkDimension b) = MkDimension (a `div` b)
{-# INLINE divD #-}
undimension :: Dimension '[] a -> a
undimension (MkDimension a) = a
{-# INLINE undimension #-}
getDimension :: forall a -> Dimension (Parse a) c -> c 
getDimension _ (MkDimension c) = c
{-# INLINE getDimension #-}
getDimensionNP :: forall a -> Dimension a c -> c 
getDimensionNP _ (MkDimension c) = c
{-# INLINE getDimensionNP #-}
doN :: (Eq a, Num a) => (t -> t) -> a -> t -> t
doN f = go where 
    go 0 a  = a
    go x a = f (go (x - 1) a)
{-# INLINE doN #-}
transform :: forall x a. forall s t -> TT.ToInt (LookupD0 s x) => (a -> a, a -> a) -> Dimension x a -> Dimension (Replace s t x) a
transform s _ (fun,invfun) (MkDimension a) = let times = TT.intval (LookupD0 s x) in
    case compare times 0 of 
        EQ -> MkDimension a
        GT -> MkDimension $ doN fun times a
        LT -> MkDimension $ doN invfun (negate times) a
{-# INLINE transform #-}

transformPos :: forall x a. forall s t -> (TL.KnownNat (TI.ToNatural (LookupD0 s x))) => (a -> a) -> Dimension x a -> Dimension (Replace s t x) a
transformPos s _ fun (MkDimension a) = let times = TT.natVal (TI.ToNatural (LookupD0 s x)) in
    MkDimension $ doN fun times a
{-# INLINE transformPos #-}

transformNeg :: forall x a. forall s t -> (TL.KnownNat (TI.ToNatural (TI.Negate (LookupD0 s x)))) => (a -> a) -> Dimension x a -> Dimension (Replace s t x) a
transformNeg s _ fun (MkDimension a) = let times = TT.natVal (TI.ToNatural (TI.Negate (LookupD0 s x))) in
    MkDimension $ doN fun times a
{-# INLINE transformNeg #-}

same :: forall x a. forall s t -> Dimension x a -> Dimension (Replace s t x) a
same _ _ (MkDimension a) = MkDimension a
{-# INLINE same #-}

apply :: forall x a. forall s -> TT.ToInt (LookupD0 s x) => (a -> a, a -> a) -> Dimension x a -> Dimension (Delete s x) a
apply s (fun,invfun) (MkDimension a) = let times = TT.intval (LookupD0 s x) in
    case compare times 0 of
        EQ -> MkDimension a
        GT -> MkDimension $ doN fun times  a
        LT -> MkDimension $ doN invfun (negate times) a
{-# INLINE apply #-}

applyPos :: forall x a. forall s -> (TL.KnownNat (TI.ToNatural (LookupD0 s x))) => (a -> a) -> Dimension x a -> Dimension (Delete s x) a
applyPos s fun (MkDimension a) = let times = TT.natVal (TI.ToNatural (LookupD0 s x)) in
    MkDimension $ doN fun times  a
{-# INLINE applyPos #-}

applyNeg :: forall x a. forall s -> (TL.KnownNat (TI.ToNatural (TI.Negate (LookupD0 s x)))) => (a -> a) -> Dimension x a -> Dimension (Delete s x) a
applyNeg s fun (MkDimension a) = let times = TT.natVal (TI.ToNatural (TI.Negate (LookupD0 s x))) in
    MkDimension $ doN fun times a
{-# INLINE applyNeg #-}
--mkisos is the same as repeated use of same
mkisos :: forall y -> forall x a. Dimension x a -> Dimension (Isos y x) a
mkisos _ (MkDimension a) = MkDimension a
{-# INLINE mkisos #-}

inject :: (n -> n) -> forall a -> Dimension b n -> Dimension (a !* b) n
inject f _ (MkDimension a) = MkDimension (f a)
{-# INLINE inject #-}
replace :: forall a -> Dimension b n -> Dimension (a !* b) n
replace = inject id
{-# INLINE replace #-}

match :: forall x b k. forall identifier -> (MatchAll identifier k b,TT.ToInt (HowManyMatches identifier x)) => Dimension x b -> Dimension (ChangeMatch identifier x) b
match identifier (MkDimension a) = let times = TT.intval (HowManyMatches identifier x) in 
    case compare times 0 of
        EQ -> MkDimension a
        GT -> MkDimension $ doN (convert @_ @identifier) times a
        LT -> MkDimension $ doN (unconvert @_ @identifier) (negate times) a
{-# INLINE match #-}
