-- -*- haskell -*- File generated by the BNF Converter (bnfc 2.9.6).

-- Parser definition for use with Happy
{
{-# OPTIONS_GHC -fno-warn-incomplete-patterns -fno-warn-overlapping-patterns #-}
{-# LANGUAGE PatternSynonyms #-}

module Lam.Par
  ( happyError
  , myLexer
  , pExp
  ) where

import Prelude

import qualified Lam.Abs
import Lam.Lex

}

%name pExp Exp
-- no lexer declaration
%monad { Err } { (>>=) } { return }
%tokentype {Token}
%token
  '('      { PT _ (TS _ 1)      }
  ')'      { PT _ (TS _ 2)      }
  L_Ident  { PT _ (TV $$)       }
  L_Lambda { PT _ (T_Lambda $$) }
  L_Arrow  { PT _ (T_Arrow $$)  }

%%

Ident :: { Lam.Abs.Ident }
Ident  : L_Ident { Lam.Abs.Ident $1 }

Lambda :: { Lam.Abs.Lambda }
Lambda  : L_Lambda { Lam.Abs.Lambda $1 }

Arrow :: { Lam.Abs.Arrow }
Arrow  : L_Arrow { Lam.Abs.Arrow $1 }

Exp3 :: { Lam.Abs.Exp }
Exp3 : Ident { Lam.Abs.EId $1 } | '(' Exp ')' { $2 }

Exp2 :: { Lam.Abs.Exp }
Exp2 : Exp2 Exp3 { Lam.Abs.EApp $1 $2 } | Exp3 { $1 }

Exp :: { Lam.Abs.Exp }
Exp
  : Lambda Ident Arrow Exp { Lam.Abs.EAbs $1 $2 $3 $4 } | Exp1 { $1 }

Exp1 :: { Lam.Abs.Exp }
Exp1 : Exp2 { $1 }

Ty1 :: { Lam.Abs.Ty }
Ty1 : Ident { Lam.Abs.TId $1 } | '(' Ty ')' { $2 }

Ty :: { Lam.Abs.Ty }
Ty : Ty1 Arrow Ty { Lam.Abs.TArr $1 $2 $3 } | Ty1 { $1 }

{

type Err = Either String

happyError :: [Token] -> Err a
happyError ts = Left $
  "syntax error at " ++ tokenPos ts ++
  case ts of
    []      -> []
    [Err _] -> " due to lexer error"
    t:_     -> " before `" ++ (prToken t) ++ "'"

myLexer :: String -> [Token]
myLexer = tokens

}

