#include "vulkan/vulkan.h"

{-# LANGUAGE DataKinds             #-}
{-# LANGUAGE FlexibleContexts      #-}
{-# LANGUAGE FlexibleInstances     #-}
{-# LANGUAGE MagicHash             #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE PatternSynonyms       #-}
{-# LANGUAGE ScopedTypeVariables   #-}
{-# LANGUAGE Strict                #-}
{-# LANGUAGE TypeApplications      #-}
{-# LANGUAGE TypeFamilies          #-}
{-# LANGUAGE UndecidableInstances  #-}
module Graphics.Vulkan.Types.Struct.PhysicalDevice
       (VkPhysicalDevice16BitStorageFeatures(..),
        VkPhysicalDevice16BitStorageFeaturesKHR,
        VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT(..),
        VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT(..),
        VkPhysicalDeviceConservativeRasterizationPropertiesEXT(..),
        VkPhysicalDeviceDescriptorIndexingFeaturesEXT(..),
        VkPhysicalDeviceDescriptorIndexingPropertiesEXT(..),
        VkPhysicalDeviceDiscardRectanglePropertiesEXT(..),
        VkPhysicalDeviceExternalBufferInfo(..),
        VkPhysicalDeviceExternalBufferInfoKHR,
        VkPhysicalDeviceExternalFenceInfo(..),
        VkPhysicalDeviceExternalFenceInfoKHR,
        VkPhysicalDeviceExternalImageFormatInfo(..),
        VkPhysicalDeviceExternalImageFormatInfoKHR,
        VkPhysicalDeviceExternalMemoryHostPropertiesEXT(..),
        VkPhysicalDeviceExternalSemaphoreInfo(..),
        VkPhysicalDeviceExternalSemaphoreInfoKHR,
        VkPhysicalDeviceFeatures2(..), VkPhysicalDeviceFeatures2KHR,
        VkPhysicalDeviceGroupProperties(..),
        VkPhysicalDeviceGroupPropertiesKHR,
        VkPhysicalDeviceIDProperties(..), VkPhysicalDeviceIDPropertiesKHR,
        VkPhysicalDeviceImageFormatInfo2(..),
        VkPhysicalDeviceImageFormatInfo2KHR, VkPhysicalDeviceLimits(..),
        VkPhysicalDeviceMaintenance3Properties(..),
        VkPhysicalDeviceMaintenance3PropertiesKHR,
        VkPhysicalDeviceMemoryProperties(..),
        VkPhysicalDeviceMemoryProperties2(..),
        VkPhysicalDeviceMemoryProperties2KHR,
        VkPhysicalDeviceMultiviewFeatures(..),
        VkPhysicalDeviceMultiviewFeaturesKHR,
        VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX(..),
        VkPhysicalDeviceMultiviewProperties(..),
        VkPhysicalDeviceMultiviewPropertiesKHR,
        VkPhysicalDevicePointClippingProperties(..),
        VkPhysicalDevicePointClippingPropertiesKHR,
        VkPhysicalDeviceProperties(..), VkPhysicalDeviceProperties2(..),
        VkPhysicalDeviceProperties2KHR,
        VkPhysicalDeviceProtectedMemoryFeatures(..),
        VkPhysicalDeviceProtectedMemoryProperties(..),
        VkPhysicalDevicePushDescriptorPropertiesKHR(..),
        VkPhysicalDeviceSampleLocationsPropertiesEXT(..),
        VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT(..),
        VkPhysicalDeviceSamplerYcbcrConversionFeatures(..),
        VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR,
        VkPhysicalDeviceShaderCorePropertiesAMD(..),
        VkPhysicalDeviceShaderDrawParameterFeatures(..),
        VkPhysicalDeviceSparseImageFormatInfo2(..),
        VkPhysicalDeviceSparseImageFormatInfo2KHR,
        VkPhysicalDeviceSparseProperties(..),
        VkPhysicalDeviceSubgroupProperties(..),
        VkPhysicalDeviceSurfaceInfo2KHR(..),
        VkPhysicalDeviceVariablePointerFeatures(..),
        VkPhysicalDeviceVariablePointerFeaturesKHR,
        VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(..))
       where
import           Foreign.Storable                                    (Storable (..))
import           GHC.Base                                            (Addr##,
                                                                      ByteArray##,
                                                                      Proxy##,
                                                                      byteArrayContents##,
                                                                      plusAddr##,
                                                                      proxy##)
import           GHC.TypeLits                                        (KnownNat,
                                                                      natVal') -- ' closing tick for hsc2hs
import           Graphics.Vulkan.Constants                           (VK_LUID_SIZE,
                                                                      pattern VK_LUID_SIZE,
                                                                      VK_MAX_DEVICE_GROUP_SIZE,
                                                                      pattern VK_MAX_DEVICE_GROUP_SIZE,
                                                                      VK_MAX_MEMORY_HEAPS,
                                                                      pattern VK_MAX_MEMORY_HEAPS,
                                                                      VK_MAX_MEMORY_TYPES,
                                                                      pattern VK_MAX_MEMORY_TYPES,
                                                                      VK_MAX_PHYSICAL_DEVICE_NAME_SIZE,
                                                                      pattern VK_MAX_PHYSICAL_DEVICE_NAME_SIZE,
                                                                      VK_UUID_SIZE,
                                                                      pattern VK_UUID_SIZE)
import           Graphics.Vulkan.Marshal
import           Graphics.Vulkan.Marshal.Internal
import           Graphics.Vulkan.Types.BaseTypes                     (VkBool32, VkDeviceSize)
import           Graphics.Vulkan.Types.Enum.Buffer                   (VkBufferCreateFlags,
                                                                      VkBufferUsageFlags)
import           Graphics.Vulkan.Types.Enum.External                 (VkExternalFenceHandleTypeFlagBits,
                                                                      VkExternalMemoryHandleTypeFlagBits,
                                                                      VkExternalSemaphoreHandleTypeFlagBits)
import           Graphics.Vulkan.Types.Enum.Format                   (VkFormat)
import           Graphics.Vulkan.Types.Enum.Image                    (VkImageCreateFlags,
                                                                      VkImageTiling,
                                                                      VkImageType,
                                                                      VkImageUsageFlags)
import           Graphics.Vulkan.Types.Enum.PhysicalDeviceType       (VkPhysicalDeviceType)
import           Graphics.Vulkan.Types.Enum.PointClippingBehavior    (VkPointClippingBehavior)
import           Graphics.Vulkan.Types.Enum.SampleCountFlags         (VkSampleCountFlagBits,
                                                                      VkSampleCountFlags)
import           Graphics.Vulkan.Types.Enum.Shader                   (VkShaderStageFlags)
import           Graphics.Vulkan.Types.Enum.StructureType            (VkStructureType)
import           Graphics.Vulkan.Types.Enum.SubgroupFeatureFlags     (VkSubgroupFeatureFlags)
import           Graphics.Vulkan.Types.Handles                       (VkPhysicalDevice,
                                                                      VkSurfaceKHR)
import           Graphics.Vulkan.Types.Struct.Device                 (VkDeviceCreateInfo)
import           Graphics.Vulkan.Types.Struct.Extent                 (VkExtent2D)
import           Graphics.Vulkan.Types.Struct.Memory                 (VkMemoryHeap,
                                                                      VkMemoryType)
import           Graphics.Vulkan.Types.Struct.PhysicalDeviceFeatures (VkPhysicalDeviceFeatures)
import           System.IO.Unsafe                                    (unsafeDupablePerformIO)

-- | > typedef struct VkPhysicalDevice16BitStorageFeatures {
--   >     VkStructureType sType;
--   >     void*      pNext;
--   >     VkBool32                         storageBuffer16BitAccess;
--   >     VkBool32                         uniformAndStorageBuffer16BitAccess;
--   >     VkBool32                         storagePushConstant16;
--   >     VkBool32                         storageInputOutput16;
--   > } VkPhysicalDevice16BitStorageFeatures;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDevice16BitStorageFeatures VkPhysicalDevice16BitStorageFeatures registry at www.khronos.org>
data VkPhysicalDevice16BitStorageFeatures = VkPhysicalDevice16BitStorageFeatures## Addr##
                                                                                  ByteArray##

instance Eq VkPhysicalDevice16BitStorageFeatures where
        (VkPhysicalDevice16BitStorageFeatures## a _) ==
          x@(VkPhysicalDevice16BitStorageFeatures## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDevice16BitStorageFeatures where
        (VkPhysicalDevice16BitStorageFeatures## a _) `compare`
          x@(VkPhysicalDevice16BitStorageFeatures## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDevice16BitStorageFeatures where
        sizeOf ~_
          = #{size VkPhysicalDevice16BitStorageFeatures}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDevice16BitStorageFeatures}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDevice16BitStorageFeatures
         where
        unsafeAddr (VkPhysicalDevice16BitStorageFeatures## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDevice16BitStorageFeatures## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDevice16BitStorageFeatures##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDevice16BitStorageFeatures where
        type StructFields VkPhysicalDevice16BitStorageFeatures =
             '["sType", "pNext", "storageBuffer16BitAccess", -- ' closing tick for hsc2hs
               "uniformAndStorageBuffer16BitAccess", "storagePushConstant16",
               "storageInputOutput16"]
        type CUnionType VkPhysicalDevice16BitStorageFeatures = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDevice16BitStorageFeatures = 'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDevice16BitStorageFeatures =
             '[VkPhysicalDeviceFeatures2, VkDeviceCreateInfo] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDevice16BitStorageFeatures where
        type FieldType "sType" VkPhysicalDevice16BitStorageFeatures =
             VkStructureType
        type FieldOptional "sType" VkPhysicalDevice16BitStorageFeatures =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDevice16BitStorageFeatures =
             #{offset VkPhysicalDevice16BitStorageFeatures, sType}
        type FieldIsArray "sType" VkPhysicalDevice16BitStorageFeatures =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDevice16BitStorageFeatures, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDevice16BitStorageFeatures where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDevice16BitStorageFeatures, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDevice16BitStorageFeatures where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDevice16BitStorageFeatures where
        type FieldType "pNext" VkPhysicalDevice16BitStorageFeatures =
             Ptr Void
        type FieldOptional "pNext" VkPhysicalDevice16BitStorageFeatures =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDevice16BitStorageFeatures =
             #{offset VkPhysicalDevice16BitStorageFeatures, pNext}
        type FieldIsArray "pNext" VkPhysicalDevice16BitStorageFeatures =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDevice16BitStorageFeatures, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDevice16BitStorageFeatures where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDevice16BitStorageFeatures, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDevice16BitStorageFeatures where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, pNext}

instance {-# OVERLAPPING #-}
         HasField "storageBuffer16BitAccess"
           VkPhysicalDevice16BitStorageFeatures
         where
        type FieldType "storageBuffer16BitAccess"
               VkPhysicalDevice16BitStorageFeatures
             = VkBool32
        type FieldOptional "storageBuffer16BitAccess"
               VkPhysicalDevice16BitStorageFeatures
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "storageBuffer16BitAccess"
               VkPhysicalDevice16BitStorageFeatures
             =
             #{offset VkPhysicalDevice16BitStorageFeatures, storageBuffer16BitAccess}
        type FieldIsArray "storageBuffer16BitAccess"
               VkPhysicalDevice16BitStorageFeatures
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDevice16BitStorageFeatures, storageBuffer16BitAccess}

instance {-# OVERLAPPING #-}
         CanReadField "storageBuffer16BitAccess"
           VkPhysicalDevice16BitStorageFeatures
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDevice16BitStorageFeatures, storageBuffer16BitAccess})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, storageBuffer16BitAccess}

instance {-# OVERLAPPING #-}
         CanWriteField "storageBuffer16BitAccess"
           VkPhysicalDevice16BitStorageFeatures
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, storageBuffer16BitAccess}

instance {-# OVERLAPPING #-}
         HasField "uniformAndStorageBuffer16BitAccess"
           VkPhysicalDevice16BitStorageFeatures
         where
        type FieldType "uniformAndStorageBuffer16BitAccess"
               VkPhysicalDevice16BitStorageFeatures
             = VkBool32
        type FieldOptional "uniformAndStorageBuffer16BitAccess"
               VkPhysicalDevice16BitStorageFeatures
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "uniformAndStorageBuffer16BitAccess"
               VkPhysicalDevice16BitStorageFeatures
             =
             #{offset VkPhysicalDevice16BitStorageFeatures, uniformAndStorageBuffer16BitAccess}
        type FieldIsArray "uniformAndStorageBuffer16BitAccess"
               VkPhysicalDevice16BitStorageFeatures
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDevice16BitStorageFeatures, uniformAndStorageBuffer16BitAccess}

instance {-# OVERLAPPING #-}
         CanReadField "uniformAndStorageBuffer16BitAccess"
           VkPhysicalDevice16BitStorageFeatures
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDevice16BitStorageFeatures, uniformAndStorageBuffer16BitAccess})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, uniformAndStorageBuffer16BitAccess}

instance {-# OVERLAPPING #-}
         CanWriteField "uniformAndStorageBuffer16BitAccess"
           VkPhysicalDevice16BitStorageFeatures
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, uniformAndStorageBuffer16BitAccess}

instance {-# OVERLAPPING #-}
         HasField "storagePushConstant16"
           VkPhysicalDevice16BitStorageFeatures
         where
        type FieldType "storagePushConstant16"
               VkPhysicalDevice16BitStorageFeatures
             = VkBool32
        type FieldOptional "storagePushConstant16"
               VkPhysicalDevice16BitStorageFeatures
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "storagePushConstant16"
               VkPhysicalDevice16BitStorageFeatures
             =
             #{offset VkPhysicalDevice16BitStorageFeatures, storagePushConstant16}
        type FieldIsArray "storagePushConstant16"
               VkPhysicalDevice16BitStorageFeatures
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDevice16BitStorageFeatures, storagePushConstant16}

instance {-# OVERLAPPING #-}
         CanReadField "storagePushConstant16"
           VkPhysicalDevice16BitStorageFeatures
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDevice16BitStorageFeatures, storagePushConstant16})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, storagePushConstant16}

instance {-# OVERLAPPING #-}
         CanWriteField "storagePushConstant16"
           VkPhysicalDevice16BitStorageFeatures
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, storagePushConstant16}

instance {-# OVERLAPPING #-}
         HasField "storageInputOutput16"
           VkPhysicalDevice16BitStorageFeatures
         where
        type FieldType "storageInputOutput16"
               VkPhysicalDevice16BitStorageFeatures
             = VkBool32
        type FieldOptional "storageInputOutput16"
               VkPhysicalDevice16BitStorageFeatures
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "storageInputOutput16"
               VkPhysicalDevice16BitStorageFeatures
             =
             #{offset VkPhysicalDevice16BitStorageFeatures, storageInputOutput16}
        type FieldIsArray "storageInputOutput16"
               VkPhysicalDevice16BitStorageFeatures
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDevice16BitStorageFeatures, storageInputOutput16}

instance {-# OVERLAPPING #-}
         CanReadField "storageInputOutput16"
           VkPhysicalDevice16BitStorageFeatures
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDevice16BitStorageFeatures, storageInputOutput16})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, storageInputOutput16}

instance {-# OVERLAPPING #-}
         CanWriteField "storageInputOutput16"
           VkPhysicalDevice16BitStorageFeatures
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDevice16BitStorageFeatures, storageInputOutput16}

instance Show VkPhysicalDevice16BitStorageFeatures where
        showsPrec d x
          = showString "VkPhysicalDevice16BitStorageFeatures {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "storageBuffer16BitAccess = " .
                            showsPrec d (getField @"storageBuffer16BitAccess" x) .
                              showString ", " .
                                showString "uniformAndStorageBuffer16BitAccess = " .
                                  showsPrec d (getField @"uniformAndStorageBuffer16BitAccess" x) .
                                    showString ", " .
                                      showString "storagePushConstant16 = " .
                                        showsPrec d (getField @"storagePushConstant16" x) .
                                          showString ", " .
                                            showString "storageInputOutput16 = " .
                                              showsPrec d (getField @"storageInputOutput16" x) .
                                                showChar '}'

-- | Alias for `VkPhysicalDevice16BitStorageFeatures`
type VkPhysicalDevice16BitStorageFeaturesKHR =
     VkPhysicalDevice16BitStorageFeatures

-- | > typedef struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT {
--   >     VkStructureType sType;
--   >     void*                            pNext;
--   >     VkBool32                         advancedBlendCoherentOperations;
--   > } VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT registry at www.khronos.org>
data VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT = VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT## Addr##
                                                                                                            ByteArray##

instance Eq VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT where
        (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT## a _) ==
          x@(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT## a _) `compare`
          x@(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        sizeOf ~_
          = #{size VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        unsafeAddr (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT## a _)
          = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray
          (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        type StructFields VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = '["sType", "pNext", "advancedBlendCoherentOperations"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT =
             'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type StructExtends
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = '[VkPhysicalDeviceFeatures2] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        type FieldType "sType"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = VkStructureType
        type FieldOptional "sType"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, sType}
        type FieldIsArray "sType"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType"
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType"
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        type FieldType "pNext"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = Ptr Void
        type FieldOptional "pNext"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, pNext}
        type FieldIsArray "pNext"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext"
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext"
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, pNext}

instance {-# OVERLAPPING #-}
         HasField "advancedBlendCoherentOperations"
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        type FieldType "advancedBlendCoherentOperations"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = VkBool32
        type FieldOptional "advancedBlendCoherentOperations"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "advancedBlendCoherentOperations"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, advancedBlendCoherentOperations}
        type FieldIsArray "advancedBlendCoherentOperations"
               VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, advancedBlendCoherentOperations}

instance {-# OVERLAPPING #-}
         CanReadField "advancedBlendCoherentOperations"
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, advancedBlendCoherentOperations})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, advancedBlendCoherentOperations}

instance {-# OVERLAPPING #-}
         CanWriteField "advancedBlendCoherentOperations"
           VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, advancedBlendCoherentOperations}

instance Show VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT
         where
        showsPrec d x
          = showString "VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT {"
              .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "advancedBlendCoherentOperations = " .
                            showsPrec d (getField @"advancedBlendCoherentOperations" x) .
                              showChar '}'

-- | > typedef struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT {
--   >     VkStructureType sType;
--   >     void*                            pNext;
--   >     uint32_t                         advancedBlendMaxColorAttachments;
--   >     VkBool32                         advancedBlendIndependentBlend;
--   >     VkBool32                         advancedBlendNonPremultipliedSrcColor;
--   >     VkBool32                         advancedBlendNonPremultipliedDstColor;
--   >     VkBool32                         advancedBlendCorrelatedOverlap;
--   >     VkBool32                         advancedBlendAllOperations;
--   > } VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT registry at www.khronos.org>
data VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT = VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT## Addr##
                                                                                                                ByteArray##

instance Eq VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        (VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT## a _) ==
          x@(VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        (VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT## a _)
          `compare`
          x@(VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        sizeOf ~_
          = #{size VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        unsafeAddr
          (VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray
          (VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type StructFields
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             '["sType", "pNext", "advancedBlendMaxColorAttachments", -- ' closing tick for hsc2hs
               "advancedBlendIndependentBlend",
               "advancedBlendNonPremultipliedSrcColor",
               "advancedBlendNonPremultipliedDstColor",
               "advancedBlendCorrelatedOverlap", "advancedBlendAllOperations"]
        type CUnionType VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'True -- ' closing tick for hsc2hs
        type StructExtends
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = '[VkPhysicalDeviceProperties2] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type FieldType "sType"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = VkStructureType
        type FieldOptional "sType"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, sType}
        type FieldIsArray "sType"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type FieldType "pNext"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = Ptr Void
        type FieldOptional "pNext"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, pNext}
        type FieldIsArray "pNext"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         HasField "advancedBlendMaxColorAttachments"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type FieldType "advancedBlendMaxColorAttachments"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = Word32
        type FieldOptional "advancedBlendMaxColorAttachments"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "advancedBlendMaxColorAttachments"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendMaxColorAttachments}
        type FieldIsArray "advancedBlendMaxColorAttachments"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendMaxColorAttachments}

instance {-# OVERLAPPING #-}
         CanReadField "advancedBlendMaxColorAttachments"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendMaxColorAttachments})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendMaxColorAttachments}

instance {-# OVERLAPPING #-}
         CanWriteField "advancedBlendMaxColorAttachments"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendMaxColorAttachments}

instance {-# OVERLAPPING #-}
         HasField "advancedBlendIndependentBlend"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type FieldType "advancedBlendIndependentBlend"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = VkBool32
        type FieldOptional "advancedBlendIndependentBlend"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "advancedBlendIndependentBlend"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendIndependentBlend}
        type FieldIsArray "advancedBlendIndependentBlend"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendIndependentBlend}

instance {-# OVERLAPPING #-}
         CanReadField "advancedBlendIndependentBlend"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendIndependentBlend})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendIndependentBlend}

instance {-# OVERLAPPING #-}
         CanWriteField "advancedBlendIndependentBlend"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendIndependentBlend}

instance {-# OVERLAPPING #-}
         HasField "advancedBlendNonPremultipliedSrcColor"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type FieldType "advancedBlendNonPremultipliedSrcColor"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = VkBool32
        type FieldOptional "advancedBlendNonPremultipliedSrcColor"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "advancedBlendNonPremultipliedSrcColor"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedSrcColor}
        type FieldIsArray "advancedBlendNonPremultipliedSrcColor"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedSrcColor}

instance {-# OVERLAPPING #-}
         CanReadField "advancedBlendNonPremultipliedSrcColor"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedSrcColor})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedSrcColor}

instance {-# OVERLAPPING #-}
         CanWriteField "advancedBlendNonPremultipliedSrcColor"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedSrcColor}

instance {-# OVERLAPPING #-}
         HasField "advancedBlendNonPremultipliedDstColor"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type FieldType "advancedBlendNonPremultipliedDstColor"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = VkBool32
        type FieldOptional "advancedBlendNonPremultipliedDstColor"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "advancedBlendNonPremultipliedDstColor"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedDstColor}
        type FieldIsArray "advancedBlendNonPremultipliedDstColor"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedDstColor}

instance {-# OVERLAPPING #-}
         CanReadField "advancedBlendNonPremultipliedDstColor"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedDstColor})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedDstColor}

instance {-# OVERLAPPING #-}
         CanWriteField "advancedBlendNonPremultipliedDstColor"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedDstColor}

instance {-# OVERLAPPING #-}
         HasField "advancedBlendCorrelatedOverlap"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type FieldType "advancedBlendCorrelatedOverlap"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = VkBool32
        type FieldOptional "advancedBlendCorrelatedOverlap"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "advancedBlendCorrelatedOverlap"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendCorrelatedOverlap}
        type FieldIsArray "advancedBlendCorrelatedOverlap"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendCorrelatedOverlap}

instance {-# OVERLAPPING #-}
         CanReadField "advancedBlendCorrelatedOverlap"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendCorrelatedOverlap})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendCorrelatedOverlap}

instance {-# OVERLAPPING #-}
         CanWriteField "advancedBlendCorrelatedOverlap"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendCorrelatedOverlap}

instance {-# OVERLAPPING #-}
         HasField "advancedBlendAllOperations"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        type FieldType "advancedBlendAllOperations"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = VkBool32
        type FieldOptional "advancedBlendAllOperations"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "advancedBlendAllOperations"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             =
             #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendAllOperations}
        type FieldIsArray "advancedBlendAllOperations"
               VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendAllOperations}

instance {-# OVERLAPPING #-}
         CanReadField "advancedBlendAllOperations"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendAllOperations})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendAllOperations}

instance {-# OVERLAPPING #-}
         CanWriteField "advancedBlendAllOperations"
           VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendAllOperations}

instance Show VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT
         where
        showsPrec d x
          = showString
              "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT {"
              .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "advancedBlendMaxColorAttachments = " .
                            showsPrec d (getField @"advancedBlendMaxColorAttachments" x) .
                              showString ", " .
                                showString "advancedBlendIndependentBlend = " .
                                  showsPrec d (getField @"advancedBlendIndependentBlend" x) .
                                    showString ", " .
                                      showString "advancedBlendNonPremultipliedSrcColor = " .
                                        showsPrec d
                                          (getField @"advancedBlendNonPremultipliedSrcColor" x)
                                          .
                                          showString ", " .
                                            showString "advancedBlendNonPremultipliedDstColor = " .
                                              showsPrec d
                                                (getField @"advancedBlendNonPremultipliedDstColor"
                                                   x)
                                                .
                                                showString ", " .
                                                  showString "advancedBlendCorrelatedOverlap = " .
                                                    showsPrec d
                                                      (getField @"advancedBlendCorrelatedOverlap" x)
                                                      .
                                                      showString ", " .
                                                        showString "advancedBlendAllOperations = " .
                                                          showsPrec d
                                                            (getField @"advancedBlendAllOperations"
                                                               x)
                                                            . showChar '}'

-- | > typedef struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT {
--   >     VkStructureType sType;
--   >     void*                  pNext;
--   >     float                  primitiveOverestimationSize;
--   >     float                  maxExtraPrimitiveOverestimationSize;
--   >     float                  extraPrimitiveOverestimationSizeGranularity;
--   >     VkBool32               primitiveUnderestimation;
--   >     VkBool32               conservativePointAndLineRasterization;
--   >     VkBool32               degenerateTrianglesRasterized;
--   >     VkBool32               degenerateLinesRasterized;
--   >     VkBool32               fullyCoveredFragmentShaderInputVariable;
--   >     VkBool32               conservativeRasterizationPostDepthCoverage;
--   > } VkPhysicalDeviceConservativeRasterizationPropertiesEXT;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceConservativeRasterizationPropertiesEXT VkPhysicalDeviceConservativeRasterizationPropertiesEXT registry at www.khronos.org>
data VkPhysicalDeviceConservativeRasterizationPropertiesEXT = VkPhysicalDeviceConservativeRasterizationPropertiesEXT## Addr##
                                                                                                                      ByteArray##

instance Eq VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        (VkPhysicalDeviceConservativeRasterizationPropertiesEXT## a _) ==
          x@(VkPhysicalDeviceConservativeRasterizationPropertiesEXT## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        (VkPhysicalDeviceConservativeRasterizationPropertiesEXT## a _)
          `compare`
          x@(VkPhysicalDeviceConservativeRasterizationPropertiesEXT## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        sizeOf ~_
          = #{size VkPhysicalDeviceConservativeRasterizationPropertiesEXT}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceConservativeRasterizationPropertiesEXT}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        unsafeAddr
          (VkPhysicalDeviceConservativeRasterizationPropertiesEXT## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray
          (VkPhysicalDeviceConservativeRasterizationPropertiesEXT## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceConservativeRasterizationPropertiesEXT##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type StructFields
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             '["sType", "pNext", "primitiveOverestimationSize", -- ' closing tick for hsc2hs
               "maxExtraPrimitiveOverestimationSize",
               "extraPrimitiveOverestimationSizeGranularity",
               "primitiveUnderestimation",
               "conservativePointAndLineRasterization",
               "degenerateTrianglesRasterized", "degenerateLinesRasterized",
               "fullyCoveredFragmentShaderInputVariable",
               "conservativeRasterizationPostDepthCoverage"]
        type CUnionType
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type StructExtends
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = '[VkPhysicalDeviceProperties2] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "sType"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = VkStructureType
        type FieldOptional "sType"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, sType}
        type FieldIsArray "sType"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "pNext"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = Ptr Void
        type FieldOptional "pNext"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, pNext}
        type FieldIsArray "pNext"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         HasField "primitiveOverestimationSize"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "primitiveOverestimationSize"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = #{type float}
        type FieldOptional "primitiveOverestimationSize"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "primitiveOverestimationSize"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveOverestimationSize}
        type FieldIsArray "primitiveOverestimationSize"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveOverestimationSize}

instance {-# OVERLAPPING #-}
         CanReadField "primitiveOverestimationSize"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveOverestimationSize})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveOverestimationSize}

instance {-# OVERLAPPING #-}
         CanWriteField "primitiveOverestimationSize"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveOverestimationSize}

instance {-# OVERLAPPING #-}
         HasField "maxExtraPrimitiveOverestimationSize"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "maxExtraPrimitiveOverestimationSize"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = #{type float}
        type FieldOptional "maxExtraPrimitiveOverestimationSize"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxExtraPrimitiveOverestimationSize"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, maxExtraPrimitiveOverestimationSize}
        type FieldIsArray "maxExtraPrimitiveOverestimationSize"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, maxExtraPrimitiveOverestimationSize}

instance {-# OVERLAPPING #-}
         CanReadField "maxExtraPrimitiveOverestimationSize"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, maxExtraPrimitiveOverestimationSize})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, maxExtraPrimitiveOverestimationSize}

instance {-# OVERLAPPING #-}
         CanWriteField "maxExtraPrimitiveOverestimationSize"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, maxExtraPrimitiveOverestimationSize}

instance {-# OVERLAPPING #-}
         HasField "extraPrimitiveOverestimationSizeGranularity"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "extraPrimitiveOverestimationSizeGranularity"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = #{type float}
        type FieldOptional "extraPrimitiveOverestimationSizeGranularity"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "extraPrimitiveOverestimationSizeGranularity"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, extraPrimitiveOverestimationSizeGranularity}
        type FieldIsArray "extraPrimitiveOverestimationSizeGranularity"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, extraPrimitiveOverestimationSizeGranularity}

instance {-# OVERLAPPING #-}
         CanReadField "extraPrimitiveOverestimationSizeGranularity"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, extraPrimitiveOverestimationSizeGranularity})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, extraPrimitiveOverestimationSizeGranularity}

instance {-# OVERLAPPING #-}
         CanWriteField "extraPrimitiveOverestimationSizeGranularity"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, extraPrimitiveOverestimationSizeGranularity}

instance {-# OVERLAPPING #-}
         HasField "primitiveUnderestimation"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "primitiveUnderestimation"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = VkBool32
        type FieldOptional "primitiveUnderestimation"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "primitiveUnderestimation"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveUnderestimation}
        type FieldIsArray "primitiveUnderestimation"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveUnderestimation}

instance {-# OVERLAPPING #-}
         CanReadField "primitiveUnderestimation"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveUnderestimation})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveUnderestimation}

instance {-# OVERLAPPING #-}
         CanWriteField "primitiveUnderestimation"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveUnderestimation}

instance {-# OVERLAPPING #-}
         HasField "conservativePointAndLineRasterization"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "conservativePointAndLineRasterization"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = VkBool32
        type FieldOptional "conservativePointAndLineRasterization"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "conservativePointAndLineRasterization"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativePointAndLineRasterization}
        type FieldIsArray "conservativePointAndLineRasterization"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativePointAndLineRasterization}

instance {-# OVERLAPPING #-}
         CanReadField "conservativePointAndLineRasterization"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativePointAndLineRasterization})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativePointAndLineRasterization}

instance {-# OVERLAPPING #-}
         CanWriteField "conservativePointAndLineRasterization"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativePointAndLineRasterization}

instance {-# OVERLAPPING #-}
         HasField "degenerateTrianglesRasterized"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "degenerateTrianglesRasterized"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = VkBool32
        type FieldOptional "degenerateTrianglesRasterized"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "degenerateTrianglesRasterized"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateTrianglesRasterized}
        type FieldIsArray "degenerateTrianglesRasterized"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateTrianglesRasterized}

instance {-# OVERLAPPING #-}
         CanReadField "degenerateTrianglesRasterized"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateTrianglesRasterized})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateTrianglesRasterized}

instance {-# OVERLAPPING #-}
         CanWriteField "degenerateTrianglesRasterized"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateTrianglesRasterized}

instance {-# OVERLAPPING #-}
         HasField "degenerateLinesRasterized"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "degenerateLinesRasterized"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = VkBool32
        type FieldOptional "degenerateLinesRasterized"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "degenerateLinesRasterized"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateLinesRasterized}
        type FieldIsArray "degenerateLinesRasterized"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateLinesRasterized}

instance {-# OVERLAPPING #-}
         CanReadField "degenerateLinesRasterized"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateLinesRasterized})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateLinesRasterized}

instance {-# OVERLAPPING #-}
         CanWriteField "degenerateLinesRasterized"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateLinesRasterized}

instance {-# OVERLAPPING #-}
         HasField "fullyCoveredFragmentShaderInputVariable"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "fullyCoveredFragmentShaderInputVariable"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = VkBool32
        type FieldOptional "fullyCoveredFragmentShaderInputVariable"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "fullyCoveredFragmentShaderInputVariable"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, fullyCoveredFragmentShaderInputVariable}
        type FieldIsArray "fullyCoveredFragmentShaderInputVariable"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, fullyCoveredFragmentShaderInputVariable}

instance {-# OVERLAPPING #-}
         CanReadField "fullyCoveredFragmentShaderInputVariable"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, fullyCoveredFragmentShaderInputVariable})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, fullyCoveredFragmentShaderInputVariable}

instance {-# OVERLAPPING #-}
         CanWriteField "fullyCoveredFragmentShaderInputVariable"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, fullyCoveredFragmentShaderInputVariable}

instance {-# OVERLAPPING #-}
         HasField "conservativeRasterizationPostDepthCoverage"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        type FieldType "conservativeRasterizationPostDepthCoverage"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = VkBool32
        type FieldOptional "conservativeRasterizationPostDepthCoverage"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "conservativeRasterizationPostDepthCoverage"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             =
             #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativeRasterizationPostDepthCoverage}
        type FieldIsArray "conservativeRasterizationPostDepthCoverage"
               VkPhysicalDeviceConservativeRasterizationPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativeRasterizationPostDepthCoverage}

instance {-# OVERLAPPING #-}
         CanReadField "conservativeRasterizationPostDepthCoverage"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativeRasterizationPostDepthCoverage})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativeRasterizationPostDepthCoverage}

instance {-# OVERLAPPING #-}
         CanWriteField "conservativeRasterizationPostDepthCoverage"
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativeRasterizationPostDepthCoverage}

instance Show
           VkPhysicalDeviceConservativeRasterizationPropertiesEXT
         where
        showsPrec d x
          = showString
              "VkPhysicalDeviceConservativeRasterizationPropertiesEXT {"
              .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "primitiveOverestimationSize = " .
                            showsPrec d (getField @"primitiveOverestimationSize" x) .
                              showString ", " .
                                showString "maxExtraPrimitiveOverestimationSize = " .
                                  showsPrec d (getField @"maxExtraPrimitiveOverestimationSize" x) .
                                    showString ", " .
                                      showString "extraPrimitiveOverestimationSizeGranularity = " .
                                        showsPrec d
                                          (getField @"extraPrimitiveOverestimationSizeGranularity"
                                             x)
                                          .
                                          showString ", " .
                                            showString "primitiveUnderestimation = " .
                                              showsPrec d (getField @"primitiveUnderestimation" x) .
                                                showString ", " .
                                                  showString
                                                    "conservativePointAndLineRasterization = "
                                                    .
                                                    showsPrec d
                                                      (getField
                                                         @"conservativePointAndLineRasterization"
                                                         x)
                                                      .
                                                      showString ", " .
                                                        showString
                                                          "degenerateTrianglesRasterized = "
                                                          .
                                                          showsPrec d
                                                            (getField
                                                               @"degenerateTrianglesRasterized"
                                                               x)
                                                            .
                                                            showString ", " .
                                                              showString
                                                                "degenerateLinesRasterized = "
                                                                .
                                                                showsPrec d
                                                                  (getField
                                                                     @"degenerateLinesRasterized"
                                                                     x)
                                                                  .
                                                                  showString ", " .
                                                                    showString
                                                                      "fullyCoveredFragmentShaderInputVariable = "
                                                                      .
                                                                      showsPrec d
                                                                        (getField
                                                                           @"fullyCoveredFragmentShaderInputVariable"
                                                                           x)
                                                                        .
                                                                        showString ", " .
                                                                          showString
                                                                            "conservativeRasterizationPostDepthCoverage = "
                                                                            .
                                                                            showsPrec d
                                                                              (getField
                                                                                 @"conservativeRasterizationPostDepthCoverage"
                                                                                 x)
                                                                              . showChar '}'

-- | > typedef struct VkPhysicalDeviceDescriptorIndexingFeaturesEXT {
--   >     VkStructureType sType;
--   >     void*                            pNext;
--   >     VkBool32               shaderInputAttachmentArrayDynamicIndexing;
--   >     VkBool32               shaderUniformTexelBufferArrayDynamicIndexing;
--   >     VkBool32               shaderStorageTexelBufferArrayDynamicIndexing;
--   >     VkBool32               shaderUniformBufferArrayNonUniformIndexing;
--   >     VkBool32               shaderSampledImageArrayNonUniformIndexing;
--   >     VkBool32               shaderStorageBufferArrayNonUniformIndexing;
--   >     VkBool32               shaderStorageImageArrayNonUniformIndexing;
--   >     VkBool32               shaderInputAttachmentArrayNonUniformIndexing;
--   >     VkBool32               shaderUniformTexelBufferArrayNonUniformIndexing;
--   >     VkBool32               shaderStorageTexelBufferArrayNonUniformIndexing;
--   >     VkBool32               descriptorBindingUniformBufferUpdateAfterBind;
--   >     VkBool32               descriptorBindingSampledImageUpdateAfterBind;
--   >     VkBool32               descriptorBindingStorageImageUpdateAfterBind;
--   >     VkBool32               descriptorBindingStorageBufferUpdateAfterBind;
--   >     VkBool32               descriptorBindingUniformTexelBufferUpdateAfterBind;
--   >     VkBool32               descriptorBindingStorageTexelBufferUpdateAfterBind;
--   >     VkBool32               descriptorBindingUpdateUnusedWhilePending;
--   >     VkBool32               descriptorBindingPartiallyBound;
--   >     VkBool32               descriptorBindingVariableDescriptorCount;
--   >     VkBool32               runtimeDescriptorArray;
--   > } VkPhysicalDeviceDescriptorIndexingFeaturesEXT;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceDescriptorIndexingFeaturesEXT VkPhysicalDeviceDescriptorIndexingFeaturesEXT registry at www.khronos.org>
data VkPhysicalDeviceDescriptorIndexingFeaturesEXT = VkPhysicalDeviceDescriptorIndexingFeaturesEXT## Addr##
                                                                                                    ByteArray##

instance Eq VkPhysicalDeviceDescriptorIndexingFeaturesEXT where
        (VkPhysicalDeviceDescriptorIndexingFeaturesEXT## a _) ==
          x@(VkPhysicalDeviceDescriptorIndexingFeaturesEXT## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceDescriptorIndexingFeaturesEXT where
        (VkPhysicalDeviceDescriptorIndexingFeaturesEXT## a _) `compare`
          x@(VkPhysicalDeviceDescriptorIndexingFeaturesEXT## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        sizeOf ~_
          = #{size VkPhysicalDeviceDescriptorIndexingFeaturesEXT}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceDescriptorIndexingFeaturesEXT}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        unsafeAddr (VkPhysicalDeviceDescriptorIndexingFeaturesEXT## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray
          (VkPhysicalDeviceDescriptorIndexingFeaturesEXT## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceDescriptorIndexingFeaturesEXT##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type StructFields VkPhysicalDeviceDescriptorIndexingFeaturesEXT =
             '["sType", "pNext", "shaderInputAttachmentArrayDynamicIndexing", -- ' closing tick for hsc2hs
               "shaderUniformTexelBufferArrayDynamicIndexing",
               "shaderStorageTexelBufferArrayDynamicIndexing",
               "shaderUniformBufferArrayNonUniformIndexing",
               "shaderSampledImageArrayNonUniformIndexing",
               "shaderStorageBufferArrayNonUniformIndexing",
               "shaderStorageImageArrayNonUniformIndexing",
               "shaderInputAttachmentArrayNonUniformIndexing",
               "shaderUniformTexelBufferArrayNonUniformIndexing",
               "shaderStorageTexelBufferArrayNonUniformIndexing",
               "descriptorBindingUniformBufferUpdateAfterBind",
               "descriptorBindingSampledImageUpdateAfterBind",
               "descriptorBindingStorageImageUpdateAfterBind",
               "descriptorBindingStorageBufferUpdateAfterBind",
               "descriptorBindingUniformTexelBufferUpdateAfterBind",
               "descriptorBindingStorageTexelBufferUpdateAfterBind",
               "descriptorBindingUpdateUnusedWhilePending",
               "descriptorBindingPartiallyBound",
               "descriptorBindingVariableDescriptorCount",
               "runtimeDescriptorArray"]
        type CUnionType VkPhysicalDeviceDescriptorIndexingFeaturesEXT =
             'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceDescriptorIndexingFeaturesEXT =
             'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceDescriptorIndexingFeaturesEXT =
             '[VkPhysicalDeviceFeatures2KHR, VkDeviceCreateInfo] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "sType"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkStructureType
        type FieldOptional "sType"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, sType}
        type FieldIsArray "sType"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "pNext"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = Ptr Void
        type FieldOptional "pNext"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, pNext}
        type FieldIsArray "pNext"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, pNext}

instance {-# OVERLAPPING #-}
         HasField "shaderInputAttachmentArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderInputAttachmentArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "shaderInputAttachmentArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderInputAttachmentArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayDynamicIndexing}
        type FieldIsArray "shaderInputAttachmentArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderInputAttachmentArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayDynamicIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderInputAttachmentArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderUniformTexelBufferArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderUniformTexelBufferArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "shaderUniformTexelBufferArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderUniformTexelBufferArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayDynamicIndexing}
        type FieldIsArray "shaderUniformTexelBufferArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderUniformTexelBufferArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayDynamicIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderUniformTexelBufferArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderStorageTexelBufferArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderStorageTexelBufferArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "shaderStorageTexelBufferArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderStorageTexelBufferArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayDynamicIndexing}
        type FieldIsArray "shaderStorageTexelBufferArrayDynamicIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderStorageTexelBufferArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayDynamicIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderStorageTexelBufferArrayDynamicIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayDynamicIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderUniformBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderUniformBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "shaderUniformBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderUniformBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformBufferArrayNonUniformIndexing}
        type FieldIsArray "shaderUniformBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderUniformBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformBufferArrayNonUniformIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderUniformBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderSampledImageArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderSampledImageArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "shaderSampledImageArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderSampledImageArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderSampledImageArrayNonUniformIndexing}
        type FieldIsArray "shaderSampledImageArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderSampledImageArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderSampledImageArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderSampledImageArrayNonUniformIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderSampledImageArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderSampledImageArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderSampledImageArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderStorageBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderStorageBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "shaderStorageBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderStorageBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageBufferArrayNonUniformIndexing}
        type FieldIsArray "shaderStorageBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderStorageBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageBufferArrayNonUniformIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderStorageBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderStorageImageArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderStorageImageArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "shaderStorageImageArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderStorageImageArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageImageArrayNonUniformIndexing}
        type FieldIsArray "shaderStorageImageArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageImageArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderStorageImageArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageImageArrayNonUniformIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageImageArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderStorageImageArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageImageArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderInputAttachmentArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderInputAttachmentArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "shaderInputAttachmentArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderInputAttachmentArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayNonUniformIndexing}
        type FieldIsArray "shaderInputAttachmentArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderInputAttachmentArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayNonUniformIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderInputAttachmentArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderInputAttachmentArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderUniformTexelBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderUniformTexelBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional
               "shaderUniformTexelBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderUniformTexelBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayNonUniformIndexing}
        type FieldIsArray "shaderUniformTexelBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderUniformTexelBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayNonUniformIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderUniformTexelBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderUniformTexelBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         HasField "shaderStorageTexelBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "shaderStorageTexelBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional
               "shaderStorageTexelBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderStorageTexelBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayNonUniformIndexing}
        type FieldIsArray "shaderStorageTexelBufferArrayNonUniformIndexing"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanReadField "shaderStorageTexelBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayNonUniformIndexing})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderStorageTexelBufferArrayNonUniformIndexing"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, shaderStorageTexelBufferArrayNonUniformIndexing}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingUniformBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingUniformBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "descriptorBindingUniformBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "descriptorBindingUniformBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformBufferUpdateAfterBind}
        type FieldIsArray "descriptorBindingUniformBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingUniformBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformBufferUpdateAfterBind})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingUniformBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingSampledImageUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingSampledImageUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "descriptorBindingSampledImageUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "descriptorBindingSampledImageUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingSampledImageUpdateAfterBind}
        type FieldIsArray "descriptorBindingSampledImageUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingSampledImageUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingSampledImageUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingSampledImageUpdateAfterBind})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingSampledImageUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingSampledImageUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingSampledImageUpdateAfterBind}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingStorageImageUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingStorageImageUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "descriptorBindingStorageImageUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "descriptorBindingStorageImageUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageImageUpdateAfterBind}
        type FieldIsArray "descriptorBindingStorageImageUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageImageUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingStorageImageUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageImageUpdateAfterBind})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageImageUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingStorageImageUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageImageUpdateAfterBind}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingStorageBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingStorageBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "descriptorBindingStorageBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "descriptorBindingStorageBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageBufferUpdateAfterBind}
        type FieldIsArray "descriptorBindingStorageBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingStorageBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageBufferUpdateAfterBind})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingStorageBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingUniformTexelBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingUniformTexelBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional
               "descriptorBindingUniformTexelBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "descriptorBindingUniformTexelBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformTexelBufferUpdateAfterBind}
        type FieldIsArray
               "descriptorBindingUniformTexelBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformTexelBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingUniformTexelBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformTexelBufferUpdateAfterBind})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformTexelBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingUniformTexelBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUniformTexelBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingStorageTexelBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingStorageTexelBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional
               "descriptorBindingStorageTexelBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "descriptorBindingStorageTexelBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageTexelBufferUpdateAfterBind}
        type FieldIsArray
               "descriptorBindingStorageTexelBufferUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageTexelBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingStorageTexelBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageTexelBufferUpdateAfterBind})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageTexelBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingStorageTexelBufferUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingStorageTexelBufferUpdateAfterBind}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingUpdateUnusedWhilePending"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingUpdateUnusedWhilePending"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "descriptorBindingUpdateUnusedWhilePending"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "descriptorBindingUpdateUnusedWhilePending"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUpdateUnusedWhilePending}
        type FieldIsArray "descriptorBindingUpdateUnusedWhilePending"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUpdateUnusedWhilePending}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingUpdateUnusedWhilePending"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUpdateUnusedWhilePending})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUpdateUnusedWhilePending}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingUpdateUnusedWhilePending"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingUpdateUnusedWhilePending}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingPartiallyBound"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingPartiallyBound"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "descriptorBindingPartiallyBound"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "descriptorBindingPartiallyBound"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingPartiallyBound}
        type FieldIsArray "descriptorBindingPartiallyBound"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingPartiallyBound}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingPartiallyBound"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingPartiallyBound})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingPartiallyBound}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingPartiallyBound"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingPartiallyBound}

instance {-# OVERLAPPING #-}
         HasField "descriptorBindingVariableDescriptorCount"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "descriptorBindingVariableDescriptorCount"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "descriptorBindingVariableDescriptorCount"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "descriptorBindingVariableDescriptorCount"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingVariableDescriptorCount}
        type FieldIsArray "descriptorBindingVariableDescriptorCount"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingVariableDescriptorCount}

instance {-# OVERLAPPING #-}
         CanReadField "descriptorBindingVariableDescriptorCount"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingVariableDescriptorCount})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingVariableDescriptorCount}

instance {-# OVERLAPPING #-}
         CanWriteField "descriptorBindingVariableDescriptorCount"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, descriptorBindingVariableDescriptorCount}

instance {-# OVERLAPPING #-}
         HasField "runtimeDescriptorArray"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        type FieldType "runtimeDescriptorArray"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = VkBool32
        type FieldOptional "runtimeDescriptorArray"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "runtimeDescriptorArray"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, runtimeDescriptorArray}
        type FieldIsArray "runtimeDescriptorArray"
               VkPhysicalDeviceDescriptorIndexingFeaturesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, runtimeDescriptorArray}

instance {-# OVERLAPPING #-}
         CanReadField "runtimeDescriptorArray"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, runtimeDescriptorArray})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, runtimeDescriptorArray}

instance {-# OVERLAPPING #-}
         CanWriteField "runtimeDescriptorArray"
           VkPhysicalDeviceDescriptorIndexingFeaturesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingFeaturesEXT, runtimeDescriptorArray}

instance Show VkPhysicalDeviceDescriptorIndexingFeaturesEXT where
        showsPrec d x
          = showString "VkPhysicalDeviceDescriptorIndexingFeaturesEXT {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "shaderInputAttachmentArrayDynamicIndexing = " .
                            showsPrec d
                              (getField @"shaderInputAttachmentArrayDynamicIndexing" x)
                              .
                              showString ", " .
                                showString "shaderUniformTexelBufferArrayDynamicIndexing = " .
                                  showsPrec d
                                    (getField @"shaderUniformTexelBufferArrayDynamicIndexing" x)
                                    .
                                    showString ", " .
                                      showString "shaderStorageTexelBufferArrayDynamicIndexing = " .
                                        showsPrec d
                                          (getField @"shaderStorageTexelBufferArrayDynamicIndexing"
                                             x)
                                          .
                                          showString ", " .
                                            showString
                                              "shaderUniformBufferArrayNonUniformIndexing = "
                                              .
                                              showsPrec d
                                                (getField
                                                   @"shaderUniformBufferArrayNonUniformIndexing"
                                                   x)
                                                .
                                                showString ", " .
                                                  showString
                                                    "shaderSampledImageArrayNonUniformIndexing = "
                                                    .
                                                    showsPrec d
                                                      (getField
                                                         @"shaderSampledImageArrayNonUniformIndexing"
                                                         x)
                                                      .
                                                      showString ", " .
                                                        showString
                                                          "shaderStorageBufferArrayNonUniformIndexing = "
                                                          .
                                                          showsPrec d
                                                            (getField
                                                               @"shaderStorageBufferArrayNonUniformIndexing"
                                                               x)
                                                            .
                                                            showString ", " .
                                                              showString
                                                                "shaderStorageImageArrayNonUniformIndexing = "
                                                                .
                                                                showsPrec d
                                                                  (getField
                                                                     @"shaderStorageImageArrayNonUniformIndexing"
                                                                     x)
                                                                  .
                                                                  showString ", " .
                                                                    showString
                                                                      "shaderInputAttachmentArrayNonUniformIndexing = "
                                                                      .
                                                                      showsPrec d
                                                                        (getField
                                                                           @"shaderInputAttachmentArrayNonUniformIndexing"
                                                                           x)
                                                                        .
                                                                        showString ", " .
                                                                          showString
                                                                            "shaderUniformTexelBufferArrayNonUniformIndexing = "
                                                                            .
                                                                            showsPrec d
                                                                              (getField
                                                                                 @"shaderUniformTexelBufferArrayNonUniformIndexing"
                                                                                 x)
                                                                              .
                                                                              showString ", " .
                                                                                showString
                                                                                  "shaderStorageTexelBufferArrayNonUniformIndexing = "
                                                                                  .
                                                                                  showsPrec d
                                                                                    (getField
                                                                                       @"shaderStorageTexelBufferArrayNonUniformIndexing"
                                                                                       x)
                                                                                    .
                                                                                    showString ", "
                                                                                      .
                                                                                      showString
                                                                                        "descriptorBindingUniformBufferUpdateAfterBind = "
                                                                                        .
                                                                                        showsPrec d
                                                                                          (getField
                                                                                             @"descriptorBindingUniformBufferUpdateAfterBind"
                                                                                             x)
                                                                                          .
                                                                                          showString
                                                                                            ", "
                                                                                            .
                                                                                            showString
                                                                                              "descriptorBindingSampledImageUpdateAfterBind = "
                                                                                              .
                                                                                              showsPrec
                                                                                                d
                                                                                                (getField
                                                                                                   @"descriptorBindingSampledImageUpdateAfterBind"
                                                                                                   x)
                                                                                                .
                                                                                                showString
                                                                                                  ", "
                                                                                                  .
                                                                                                  showString
                                                                                                    "descriptorBindingStorageImageUpdateAfterBind = "
                                                                                                    .
                                                                                                    showsPrec
                                                                                                      d
                                                                                                      (getField
                                                                                                         @"descriptorBindingStorageImageUpdateAfterBind"
                                                                                                         x)
                                                                                                      .
                                                                                                      showString
                                                                                                        ", "
                                                                                                        .
                                                                                                        showString
                                                                                                          "descriptorBindingStorageBufferUpdateAfterBind = "
                                                                                                          .
                                                                                                          showsPrec
                                                                                                            d
                                                                                                            (getField
                                                                                                               @"descriptorBindingStorageBufferUpdateAfterBind"
                                                                                                               x)
                                                                                                            .
                                                                                                            showString
                                                                                                              ", "
                                                                                                              .
                                                                                                              showString
                                                                                                                "descriptorBindingUniformTexelBufferUpdateAfterBind = "
                                                                                                                .
                                                                                                                showsPrec
                                                                                                                  d
                                                                                                                  (getField
                                                                                                                     @"descriptorBindingUniformTexelBufferUpdateAfterBind"
                                                                                                                     x)
                                                                                                                  .
                                                                                                                  showString
                                                                                                                    ", "
                                                                                                                    .
                                                                                                                    showString
                                                                                                                      "descriptorBindingStorageTexelBufferUpdateAfterBind = "
                                                                                                                      .
                                                                                                                      showsPrec
                                                                                                                        d
                                                                                                                        (getField
                                                                                                                           @"descriptorBindingStorageTexelBufferUpdateAfterBind"
                                                                                                                           x)
                                                                                                                        .
                                                                                                                        showString
                                                                                                                          ", "
                                                                                                                          .
                                                                                                                          showString
                                                                                                                            "descriptorBindingUpdateUnusedWhilePending = "
                                                                                                                            .
                                                                                                                            showsPrec
                                                                                                                              d
                                                                                                                              (getField
                                                                                                                                 @"descriptorBindingUpdateUnusedWhilePending"
                                                                                                                                 x)
                                                                                                                              .
                                                                                                                              showString
                                                                                                                                ", "
                                                                                                                                .
                                                                                                                                showString
                                                                                                                                  "descriptorBindingPartiallyBound = "
                                                                                                                                  .
                                                                                                                                  showsPrec
                                                                                                                                    d
                                                                                                                                    (getField
                                                                                                                                       @"descriptorBindingPartiallyBound"
                                                                                                                                       x)
                                                                                                                                    .
                                                                                                                                    showString
                                                                                                                                      ", "
                                                                                                                                      .
                                                                                                                                      showString
                                                                                                                                        "descriptorBindingVariableDescriptorCount = "
                                                                                                                                        .
                                                                                                                                        showsPrec
                                                                                                                                          d
                                                                                                                                          (getField
                                                                                                                                             @"descriptorBindingVariableDescriptorCount"
                                                                                                                                             x)
                                                                                                                                          .
                                                                                                                                          showString
                                                                                                                                            ", "
                                                                                                                                            .
                                                                                                                                            showString
                                                                                                                                              "runtimeDescriptorArray = "
                                                                                                                                              .
                                                                                                                                              showsPrec
                                                                                                                                                d
                                                                                                                                                (getField
                                                                                                                                                   @"runtimeDescriptorArray"
                                                                                                                                                   x)
                                                                                                                                                .
                                                                                                                                                showChar
                                                                                                                                                  '}'

-- | > typedef struct VkPhysicalDeviceDescriptorIndexingPropertiesEXT {
--   >     VkStructureType sType;
--   >     void*                            pNext;
--   >     uint32_t               maxUpdateAfterBindDescriptorsInAllPools;
--   >     VkBool32               shaderUniformBufferArrayNonUniformIndexingNative;
--   >     VkBool32               shaderSampledImageArrayNonUniformIndexingNative;
--   >     VkBool32               shaderStorageBufferArrayNonUniformIndexingNative;
--   >     VkBool32               shaderStorageImageArrayNonUniformIndexingNative;
--   >     VkBool32               shaderInputAttachmentArrayNonUniformIndexingNative;
--   >     VkBool32               robustBufferAccessUpdateAfterBind;
--   >     VkBool32               quadDivergentImplicitLod;
--   >     uint32_t               maxPerStageDescriptorUpdateAfterBindSamplers;
--   >     uint32_t               maxPerStageDescriptorUpdateAfterBindUniformBuffers;
--   >     uint32_t               maxPerStageDescriptorUpdateAfterBindStorageBuffers;
--   >     uint32_t               maxPerStageDescriptorUpdateAfterBindSampledImages;
--   >     uint32_t               maxPerStageDescriptorUpdateAfterBindStorageImages;
--   >     uint32_t               maxPerStageDescriptorUpdateAfterBindInputAttachments;
--   >     uint32_t               maxPerStageUpdateAfterBindResources;
--   >     uint32_t               maxDescriptorSetUpdateAfterBindSamplers;
--   >     uint32_t               maxDescriptorSetUpdateAfterBindUniformBuffers;
--   >     uint32_t               maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
--   >     uint32_t               maxDescriptorSetUpdateAfterBindStorageBuffers;
--   >     uint32_t               maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
--   >     uint32_t               maxDescriptorSetUpdateAfterBindSampledImages;
--   >     uint32_t               maxDescriptorSetUpdateAfterBindStorageImages;
--   >     uint32_t               maxDescriptorSetUpdateAfterBindInputAttachments;
--   > } VkPhysicalDeviceDescriptorIndexingPropertiesEXT;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceDescriptorIndexingPropertiesEXT VkPhysicalDeviceDescriptorIndexingPropertiesEXT registry at www.khronos.org>
data VkPhysicalDeviceDescriptorIndexingPropertiesEXT = VkPhysicalDeviceDescriptorIndexingPropertiesEXT## Addr##
                                                                                                        ByteArray##

instance Eq VkPhysicalDeviceDescriptorIndexingPropertiesEXT where
        (VkPhysicalDeviceDescriptorIndexingPropertiesEXT## a _) ==
          x@(VkPhysicalDeviceDescriptorIndexingPropertiesEXT## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceDescriptorIndexingPropertiesEXT where
        (VkPhysicalDeviceDescriptorIndexingPropertiesEXT## a _) `compare`
          x@(VkPhysicalDeviceDescriptorIndexingPropertiesEXT## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        sizeOf ~_
          = #{size VkPhysicalDeviceDescriptorIndexingPropertiesEXT}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceDescriptorIndexingPropertiesEXT}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        unsafeAddr (VkPhysicalDeviceDescriptorIndexingPropertiesEXT## a _)
          = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray
          (VkPhysicalDeviceDescriptorIndexingPropertiesEXT## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceDescriptorIndexingPropertiesEXT##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type StructFields VkPhysicalDeviceDescriptorIndexingPropertiesEXT =
             '["sType", "pNext", "maxUpdateAfterBindDescriptorsInAllPools", -- ' closing tick for hsc2hs
               "shaderUniformBufferArrayNonUniformIndexingNative",
               "shaderSampledImageArrayNonUniformIndexingNative",
               "shaderStorageBufferArrayNonUniformIndexingNative",
               "shaderStorageImageArrayNonUniformIndexingNative",
               "shaderInputAttachmentArrayNonUniformIndexingNative",
               "robustBufferAccessUpdateAfterBind", "quadDivergentImplicitLod",
               "maxPerStageDescriptorUpdateAfterBindSamplers",
               "maxPerStageDescriptorUpdateAfterBindUniformBuffers",
               "maxPerStageDescriptorUpdateAfterBindStorageBuffers",
               "maxPerStageDescriptorUpdateAfterBindSampledImages",
               "maxPerStageDescriptorUpdateAfterBindStorageImages",
               "maxPerStageDescriptorUpdateAfterBindInputAttachments",
               "maxPerStageUpdateAfterBindResources",
               "maxDescriptorSetUpdateAfterBindSamplers",
               "maxDescriptorSetUpdateAfterBindUniformBuffers",
               "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic",
               "maxDescriptorSetUpdateAfterBindStorageBuffers",
               "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic",
               "maxDescriptorSetUpdateAfterBindSampledImages",
               "maxDescriptorSetUpdateAfterBindStorageImages",
               "maxDescriptorSetUpdateAfterBindInputAttachments"]
        type CUnionType VkPhysicalDeviceDescriptorIndexingPropertiesEXT =
             'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceDescriptorIndexingPropertiesEXT =
             'True -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = '[VkPhysicalDeviceProperties2KHR] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "sType"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = VkStructureType
        type FieldOptional "sType"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, sType}
        type FieldIsArray "sType"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "pNext"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Ptr Void
        type FieldOptional "pNext"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, pNext}
        type FieldIsArray "pNext"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         HasField "maxUpdateAfterBindDescriptorsInAllPools"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxUpdateAfterBindDescriptorsInAllPools"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional "maxUpdateAfterBindDescriptorsInAllPools"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxUpdateAfterBindDescriptorsInAllPools"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxUpdateAfterBindDescriptorsInAllPools}
        type FieldIsArray "maxUpdateAfterBindDescriptorsInAllPools"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxUpdateAfterBindDescriptorsInAllPools}

instance {-# OVERLAPPING #-}
         CanReadField "maxUpdateAfterBindDescriptorsInAllPools"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxUpdateAfterBindDescriptorsInAllPools})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxUpdateAfterBindDescriptorsInAllPools}

instance {-# OVERLAPPING #-}
         CanWriteField "maxUpdateAfterBindDescriptorsInAllPools"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxUpdateAfterBindDescriptorsInAllPools}

instance {-# OVERLAPPING #-}
         HasField "shaderUniformBufferArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "shaderUniformBufferArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = VkBool32
        type FieldOptional
               "shaderUniformBufferArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderUniformBufferArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderUniformBufferArrayNonUniformIndexingNative}
        type FieldIsArray
               "shaderUniformBufferArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderUniformBufferArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanReadField "shaderUniformBufferArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderUniformBufferArrayNonUniformIndexingNative})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderUniformBufferArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderUniformBufferArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderUniformBufferArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         HasField "shaderSampledImageArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "shaderSampledImageArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = VkBool32
        type FieldOptional
               "shaderSampledImageArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderSampledImageArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderSampledImageArrayNonUniformIndexingNative}
        type FieldIsArray "shaderSampledImageArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderSampledImageArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanReadField "shaderSampledImageArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderSampledImageArrayNonUniformIndexingNative})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderSampledImageArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderSampledImageArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderSampledImageArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         HasField "shaderStorageBufferArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "shaderStorageBufferArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = VkBool32
        type FieldOptional
               "shaderStorageBufferArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderStorageBufferArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageBufferArrayNonUniformIndexingNative}
        type FieldIsArray
               "shaderStorageBufferArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageBufferArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanReadField "shaderStorageBufferArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageBufferArrayNonUniformIndexingNative})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageBufferArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderStorageBufferArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageBufferArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         HasField "shaderStorageImageArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "shaderStorageImageArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = VkBool32
        type FieldOptional
               "shaderStorageImageArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "shaderStorageImageArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageImageArrayNonUniformIndexingNative}
        type FieldIsArray "shaderStorageImageArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageImageArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanReadField "shaderStorageImageArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageImageArrayNonUniformIndexingNative})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageImageArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderStorageImageArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderStorageImageArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         HasField "shaderInputAttachmentArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "shaderInputAttachmentArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = VkBool32
        type FieldOptional
               "shaderInputAttachmentArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "shaderInputAttachmentArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderInputAttachmentArrayNonUniformIndexingNative}
        type FieldIsArray
               "shaderInputAttachmentArrayNonUniformIndexingNative"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderInputAttachmentArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanReadField "shaderInputAttachmentArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderInputAttachmentArrayNonUniformIndexingNative})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderInputAttachmentArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         CanWriteField "shaderInputAttachmentArrayNonUniformIndexingNative"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, shaderInputAttachmentArrayNonUniformIndexingNative}

instance {-# OVERLAPPING #-}
         HasField "robustBufferAccessUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "robustBufferAccessUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = VkBool32
        type FieldOptional "robustBufferAccessUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "robustBufferAccessUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, robustBufferAccessUpdateAfterBind}
        type FieldIsArray "robustBufferAccessUpdateAfterBind"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, robustBufferAccessUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanReadField "robustBufferAccessUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, robustBufferAccessUpdateAfterBind})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, robustBufferAccessUpdateAfterBind}

instance {-# OVERLAPPING #-}
         CanWriteField "robustBufferAccessUpdateAfterBind"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, robustBufferAccessUpdateAfterBind}

instance {-# OVERLAPPING #-}
         HasField "quadDivergentImplicitLod"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "quadDivergentImplicitLod"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = VkBool32
        type FieldOptional "quadDivergentImplicitLod"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "quadDivergentImplicitLod"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, quadDivergentImplicitLod}
        type FieldIsArray "quadDivergentImplicitLod"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, quadDivergentImplicitLod}

instance {-# OVERLAPPING #-}
         CanReadField "quadDivergentImplicitLod"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, quadDivergentImplicitLod})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, quadDivergentImplicitLod}

instance {-# OVERLAPPING #-}
         CanWriteField "quadDivergentImplicitLod"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, quadDivergentImplicitLod}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorUpdateAfterBindSamplers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxPerStageDescriptorUpdateAfterBindSamplers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional "maxPerStageDescriptorUpdateAfterBindSamplers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageDescriptorUpdateAfterBindSamplers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSamplers}
        type FieldIsArray "maxPerStageDescriptorUpdateAfterBindSamplers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSamplers}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorUpdateAfterBindSamplers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSamplers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSamplers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorUpdateAfterBindSamplers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSamplers}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorUpdateAfterBindUniformBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxPerStageDescriptorUpdateAfterBindUniformBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional
               "maxPerStageDescriptorUpdateAfterBindUniformBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "maxPerStageDescriptorUpdateAfterBindUniformBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindUniformBuffers}
        type FieldIsArray
               "maxPerStageDescriptorUpdateAfterBindUniformBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindUniformBuffers}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorUpdateAfterBindUniformBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindUniformBuffers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindUniformBuffers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorUpdateAfterBindUniformBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindUniformBuffers}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorUpdateAfterBindStorageBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxPerStageDescriptorUpdateAfterBindStorageBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional
               "maxPerStageDescriptorUpdateAfterBindStorageBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "maxPerStageDescriptorUpdateAfterBindStorageBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageBuffers}
        type FieldIsArray
               "maxPerStageDescriptorUpdateAfterBindStorageBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageBuffers}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorUpdateAfterBindStorageBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageBuffers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageBuffers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorUpdateAfterBindStorageBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageBuffers}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorUpdateAfterBindSampledImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxPerStageDescriptorUpdateAfterBindSampledImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional
               "maxPerStageDescriptorUpdateAfterBindSampledImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "maxPerStageDescriptorUpdateAfterBindSampledImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSampledImages}
        type FieldIsArray
               "maxPerStageDescriptorUpdateAfterBindSampledImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSampledImages}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorUpdateAfterBindSampledImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSampledImages})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSampledImages}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorUpdateAfterBindSampledImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindSampledImages}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorUpdateAfterBindStorageImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxPerStageDescriptorUpdateAfterBindStorageImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional
               "maxPerStageDescriptorUpdateAfterBindStorageImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "maxPerStageDescriptorUpdateAfterBindStorageImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageImages}
        type FieldIsArray
               "maxPerStageDescriptorUpdateAfterBindStorageImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageImages}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorUpdateAfterBindStorageImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageImages})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageImages}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorUpdateAfterBindStorageImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindStorageImages}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorUpdateAfterBindInputAttachments"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType
               "maxPerStageDescriptorUpdateAfterBindInputAttachments"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional
               "maxPerStageDescriptorUpdateAfterBindInputAttachments"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "maxPerStageDescriptorUpdateAfterBindInputAttachments"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindInputAttachments}
        type FieldIsArray
               "maxPerStageDescriptorUpdateAfterBindInputAttachments"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindInputAttachments}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorUpdateAfterBindInputAttachments"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindInputAttachments})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindInputAttachments}

instance {-# OVERLAPPING #-}
         CanWriteField
           "maxPerStageDescriptorUpdateAfterBindInputAttachments"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageDescriptorUpdateAfterBindInputAttachments}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageUpdateAfterBindResources"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxPerStageUpdateAfterBindResources"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional "maxPerStageUpdateAfterBindResources"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageUpdateAfterBindResources"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageUpdateAfterBindResources}
        type FieldIsArray "maxPerStageUpdateAfterBindResources"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageUpdateAfterBindResources}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageUpdateAfterBindResources"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageUpdateAfterBindResources})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageUpdateAfterBindResources}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageUpdateAfterBindResources"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxPerStageUpdateAfterBindResources}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUpdateAfterBindSamplers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxDescriptorSetUpdateAfterBindSamplers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional "maxDescriptorSetUpdateAfterBindSamplers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetUpdateAfterBindSamplers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSamplers}
        type FieldIsArray "maxDescriptorSetUpdateAfterBindSamplers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSamplers}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUpdateAfterBindSamplers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSamplers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSamplers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetUpdateAfterBindSamplers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSamplers}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUpdateAfterBindUniformBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxDescriptorSetUpdateAfterBindUniformBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional "maxDescriptorSetUpdateAfterBindUniformBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetUpdateAfterBindUniformBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffers}
        type FieldIsArray "maxDescriptorSetUpdateAfterBindUniformBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffers}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUpdateAfterBindUniformBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetUpdateAfterBindUniformBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffers}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType
               "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional
               "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffersDynamic}
        type FieldIsArray
               "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffersDynamic}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffersDynamic})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffersDynamic}

instance {-# OVERLAPPING #-}
         CanWriteField
           "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindUniformBuffersDynamic}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUpdateAfterBindStorageBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxDescriptorSetUpdateAfterBindStorageBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional "maxDescriptorSetUpdateAfterBindStorageBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetUpdateAfterBindStorageBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffers}
        type FieldIsArray "maxDescriptorSetUpdateAfterBindStorageBuffers"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffers}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUpdateAfterBindStorageBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetUpdateAfterBindStorageBuffers"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffers}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType
               "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional
               "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset
               "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffersDynamic}
        type FieldIsArray
               "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffersDynamic}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffersDynamic})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffersDynamic}

instance {-# OVERLAPPING #-}
         CanWriteField
           "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageBuffersDynamic}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUpdateAfterBindSampledImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxDescriptorSetUpdateAfterBindSampledImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional "maxDescriptorSetUpdateAfterBindSampledImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetUpdateAfterBindSampledImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSampledImages}
        type FieldIsArray "maxDescriptorSetUpdateAfterBindSampledImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSampledImages}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUpdateAfterBindSampledImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSampledImages})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSampledImages}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetUpdateAfterBindSampledImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindSampledImages}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUpdateAfterBindStorageImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxDescriptorSetUpdateAfterBindStorageImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional "maxDescriptorSetUpdateAfterBindStorageImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetUpdateAfterBindStorageImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageImages}
        type FieldIsArray "maxDescriptorSetUpdateAfterBindStorageImages"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageImages}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUpdateAfterBindStorageImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageImages})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageImages}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetUpdateAfterBindStorageImages"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindStorageImages}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUpdateAfterBindInputAttachments"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        type FieldType "maxDescriptorSetUpdateAfterBindInputAttachments"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = Word32
        type FieldOptional
               "maxDescriptorSetUpdateAfterBindInputAttachments"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetUpdateAfterBindInputAttachments"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             =
             #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindInputAttachments}
        type FieldIsArray "maxDescriptorSetUpdateAfterBindInputAttachments"
               VkPhysicalDeviceDescriptorIndexingPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindInputAttachments}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUpdateAfterBindInputAttachments"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindInputAttachments})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindInputAttachments}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetUpdateAfterBindInputAttachments"
           VkPhysicalDeviceDescriptorIndexingPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDescriptorIndexingPropertiesEXT, maxDescriptorSetUpdateAfterBindInputAttachments}

instance Show VkPhysicalDeviceDescriptorIndexingPropertiesEXT where
        showsPrec d x
          = showString "VkPhysicalDeviceDescriptorIndexingPropertiesEXT {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "maxUpdateAfterBindDescriptorsInAllPools = " .
                            showsPrec d (getField @"maxUpdateAfterBindDescriptorsInAllPools" x)
                              .
                              showString ", " .
                                showString "shaderUniformBufferArrayNonUniformIndexingNative = " .
                                  showsPrec d
                                    (getField @"shaderUniformBufferArrayNonUniformIndexingNative" x)
                                    .
                                    showString ", " .
                                      showString
                                        "shaderSampledImageArrayNonUniformIndexingNative = "
                                        .
                                        showsPrec d
                                          (getField
                                             @"shaderSampledImageArrayNonUniformIndexingNative"
                                             x)
                                          .
                                          showString ", " .
                                            showString
                                              "shaderStorageBufferArrayNonUniformIndexingNative = "
                                              .
                                              showsPrec d
                                                (getField
                                                   @"shaderStorageBufferArrayNonUniformIndexingNative"
                                                   x)
                                                .
                                                showString ", " .
                                                  showString
                                                    "shaderStorageImageArrayNonUniformIndexingNative = "
                                                    .
                                                    showsPrec d
                                                      (getField
                                                         @"shaderStorageImageArrayNonUniformIndexingNative"
                                                         x)
                                                      .
                                                      showString ", " .
                                                        showString
                                                          "shaderInputAttachmentArrayNonUniformIndexingNative = "
                                                          .
                                                          showsPrec d
                                                            (getField
                                                               @"shaderInputAttachmentArrayNonUniformIndexingNative"
                                                               x)
                                                            .
                                                            showString ", " .
                                                              showString
                                                                "robustBufferAccessUpdateAfterBind = "
                                                                .
                                                                showsPrec d
                                                                  (getField
                                                                     @"robustBufferAccessUpdateAfterBind"
                                                                     x)
                                                                  .
                                                                  showString ", " .
                                                                    showString
                                                                      "quadDivergentImplicitLod = "
                                                                      .
                                                                      showsPrec d
                                                                        (getField
                                                                           @"quadDivergentImplicitLod"
                                                                           x)
                                                                        .
                                                                        showString ", " .
                                                                          showString
                                                                            "maxPerStageDescriptorUpdateAfterBindSamplers = "
                                                                            .
                                                                            showsPrec d
                                                                              (getField
                                                                                 @"maxPerStageDescriptorUpdateAfterBindSamplers"
                                                                                 x)
                                                                              .
                                                                              showString ", " .
                                                                                showString
                                                                                  "maxPerStageDescriptorUpdateAfterBindUniformBuffers = "
                                                                                  .
                                                                                  showsPrec d
                                                                                    (getField
                                                                                       @"maxPerStageDescriptorUpdateAfterBindUniformBuffers"
                                                                                       x)
                                                                                    .
                                                                                    showString ", "
                                                                                      .
                                                                                      showString
                                                                                        "maxPerStageDescriptorUpdateAfterBindStorageBuffers = "
                                                                                        .
                                                                                        showsPrec d
                                                                                          (getField
                                                                                             @"maxPerStageDescriptorUpdateAfterBindStorageBuffers"
                                                                                             x)
                                                                                          .
                                                                                          showString
                                                                                            ", "
                                                                                            .
                                                                                            showString
                                                                                              "maxPerStageDescriptorUpdateAfterBindSampledImages = "
                                                                                              .
                                                                                              showsPrec
                                                                                                d
                                                                                                (getField
                                                                                                   @"maxPerStageDescriptorUpdateAfterBindSampledImages"
                                                                                                   x)
                                                                                                .
                                                                                                showString
                                                                                                  ", "
                                                                                                  .
                                                                                                  showString
                                                                                                    "maxPerStageDescriptorUpdateAfterBindStorageImages = "
                                                                                                    .
                                                                                                    showsPrec
                                                                                                      d
                                                                                                      (getField
                                                                                                         @"maxPerStageDescriptorUpdateAfterBindStorageImages"
                                                                                                         x)
                                                                                                      .
                                                                                                      showString
                                                                                                        ", "
                                                                                                        .
                                                                                                        showString
                                                                                                          "maxPerStageDescriptorUpdateAfterBindInputAttachments = "
                                                                                                          .
                                                                                                          showsPrec
                                                                                                            d
                                                                                                            (getField
                                                                                                               @"maxPerStageDescriptorUpdateAfterBindInputAttachments"
                                                                                                               x)
                                                                                                            .
                                                                                                            showString
                                                                                                              ", "
                                                                                                              .
                                                                                                              showString
                                                                                                                "maxPerStageUpdateAfterBindResources = "
                                                                                                                .
                                                                                                                showsPrec
                                                                                                                  d
                                                                                                                  (getField
                                                                                                                     @"maxPerStageUpdateAfterBindResources"
                                                                                                                     x)
                                                                                                                  .
                                                                                                                  showString
                                                                                                                    ", "
                                                                                                                    .
                                                                                                                    showString
                                                                                                                      "maxDescriptorSetUpdateAfterBindSamplers = "
                                                                                                                      .
                                                                                                                      showsPrec
                                                                                                                        d
                                                                                                                        (getField
                                                                                                                           @"maxDescriptorSetUpdateAfterBindSamplers"
                                                                                                                           x)
                                                                                                                        .
                                                                                                                        showString
                                                                                                                          ", "
                                                                                                                          .
                                                                                                                          showString
                                                                                                                            "maxDescriptorSetUpdateAfterBindUniformBuffers = "
                                                                                                                            .
                                                                                                                            showsPrec
                                                                                                                              d
                                                                                                                              (getField
                                                                                                                                 @"maxDescriptorSetUpdateAfterBindUniformBuffers"
                                                                                                                                 x)
                                                                                                                              .
                                                                                                                              showString
                                                                                                                                ", "
                                                                                                                                .
                                                                                                                                showString
                                                                                                                                  "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = "
                                                                                                                                  .
                                                                                                                                  showsPrec
                                                                                                                                    d
                                                                                                                                    (getField
                                                                                                                                       @"maxDescriptorSetUpdateAfterBindUniformBuffersDynamic"
                                                                                                                                       x)
                                                                                                                                    .
                                                                                                                                    showString
                                                                                                                                      ", "
                                                                                                                                      .
                                                                                                                                      showString
                                                                                                                                        "maxDescriptorSetUpdateAfterBindStorageBuffers = "
                                                                                                                                        .
                                                                                                                                        showsPrec
                                                                                                                                          d
                                                                                                                                          (getField
                                                                                                                                             @"maxDescriptorSetUpdateAfterBindStorageBuffers"
                                                                                                                                             x)
                                                                                                                                          .
                                                                                                                                          showString
                                                                                                                                            ", "
                                                                                                                                            .
                                                                                                                                            showString
                                                                                                                                              "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = "
                                                                                                                                              .
                                                                                                                                              showsPrec
                                                                                                                                                d
                                                                                                                                                (getField
                                                                                                                                                   @"maxDescriptorSetUpdateAfterBindStorageBuffersDynamic"
                                                                                                                                                   x)
                                                                                                                                                .
                                                                                                                                                showString
                                                                                                                                                  ", "
                                                                                                                                                  .
                                                                                                                                                  showString
                                                                                                                                                    "maxDescriptorSetUpdateAfterBindSampledImages = "
                                                                                                                                                    .
                                                                                                                                                    showsPrec
                                                                                                                                                      d
                                                                                                                                                      (getField
                                                                                                                                                         @"maxDescriptorSetUpdateAfterBindSampledImages"
                                                                                                                                                         x)
                                                                                                                                                      .
                                                                                                                                                      showString
                                                                                                                                                        ", "
                                                                                                                                                        .
                                                                                                                                                        showString
                                                                                                                                                          "maxDescriptorSetUpdateAfterBindStorageImages = "
                                                                                                                                                          .
                                                                                                                                                          showsPrec
                                                                                                                                                            d
                                                                                                                                                            (getField
                                                                                                                                                               @"maxDescriptorSetUpdateAfterBindStorageImages"
                                                                                                                                                               x)
                                                                                                                                                            .
                                                                                                                                                            showString
                                                                                                                                                              ", "
                                                                                                                                                              .
                                                                                                                                                              showString
                                                                                                                                                                "maxDescriptorSetUpdateAfterBindInputAttachments = "
                                                                                                                                                                .
                                                                                                                                                                showsPrec
                                                                                                                                                                  d
                                                                                                                                                                  (getField
                                                                                                                                                                     @"maxDescriptorSetUpdateAfterBindInputAttachments"
                                                                                                                                                                     x)
                                                                                                                                                                  .
                                                                                                                                                                  showChar
                                                                                                                                                                    '}'

-- | > typedef struct VkPhysicalDeviceDiscardRectanglePropertiesEXT {
--   >     VkStructureType sType;
--   >     void*                  pNext;
--   >     uint32_t               maxDiscardRectangles;
--   > } VkPhysicalDeviceDiscardRectanglePropertiesEXT;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceDiscardRectanglePropertiesEXT VkPhysicalDeviceDiscardRectanglePropertiesEXT registry at www.khronos.org>
data VkPhysicalDeviceDiscardRectanglePropertiesEXT = VkPhysicalDeviceDiscardRectanglePropertiesEXT## Addr##
                                                                                                    ByteArray##

instance Eq VkPhysicalDeviceDiscardRectanglePropertiesEXT where
        (VkPhysicalDeviceDiscardRectanglePropertiesEXT## a _) ==
          x@(VkPhysicalDeviceDiscardRectanglePropertiesEXT## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceDiscardRectanglePropertiesEXT where
        (VkPhysicalDeviceDiscardRectanglePropertiesEXT## a _) `compare`
          x@(VkPhysicalDeviceDiscardRectanglePropertiesEXT## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        sizeOf ~_
          = #{size VkPhysicalDeviceDiscardRectanglePropertiesEXT}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceDiscardRectanglePropertiesEXT}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim
           VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        unsafeAddr (VkPhysicalDeviceDiscardRectanglePropertiesEXT## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray
          (VkPhysicalDeviceDiscardRectanglePropertiesEXT## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceDiscardRectanglePropertiesEXT##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal
           VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        type StructFields VkPhysicalDeviceDiscardRectanglePropertiesEXT =
             '["sType", "pNext", "maxDiscardRectangles"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceDiscardRectanglePropertiesEXT =
             'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceDiscardRectanglePropertiesEXT =
             'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceDiscardRectanglePropertiesEXT =
             '[VkPhysicalDeviceProperties2] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        type FieldType "sType"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = VkStructureType
        type FieldOptional "sType"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             =
             #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, sType}
        type FieldIsArray "sType"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        type FieldType "pNext"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = Ptr Void
        type FieldOptional "pNext"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             =
             #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, pNext}
        type FieldIsArray "pNext"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         HasField "maxDiscardRectangles"
           VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        type FieldType "maxDiscardRectangles"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = Word32
        type FieldOptional "maxDiscardRectangles"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDiscardRectangles"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             =
             #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, maxDiscardRectangles}
        type FieldIsArray "maxDiscardRectangles"
               VkPhysicalDeviceDiscardRectanglePropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, maxDiscardRectangles}

instance {-# OVERLAPPING #-}
         CanReadField "maxDiscardRectangles"
           VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, maxDiscardRectangles})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, maxDiscardRectangles}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDiscardRectangles"
           VkPhysicalDeviceDiscardRectanglePropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceDiscardRectanglePropertiesEXT, maxDiscardRectangles}

instance Show VkPhysicalDeviceDiscardRectanglePropertiesEXT where
        showsPrec d x
          = showString "VkPhysicalDeviceDiscardRectanglePropertiesEXT {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "maxDiscardRectangles = " .
                            showsPrec d (getField @"maxDiscardRectangles" x) . showChar '}'

-- | > typedef struct VkPhysicalDeviceExternalBufferInfo {
--   >     VkStructureType sType;
--   >     const void*                      pNext;
--   >     VkBufferCreateFlags flags;
--   >     VkBufferUsageFlags               usage;
--   >     VkExternalMemoryHandleTypeFlagBits handleType;
--   > } VkPhysicalDeviceExternalBufferInfo;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceExternalBufferInfo VkPhysicalDeviceExternalBufferInfo registry at www.khronos.org>
data VkPhysicalDeviceExternalBufferInfo = VkPhysicalDeviceExternalBufferInfo## Addr##
                                                                              ByteArray##

instance Eq VkPhysicalDeviceExternalBufferInfo where
        (VkPhysicalDeviceExternalBufferInfo## a _) ==
          x@(VkPhysicalDeviceExternalBufferInfo## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceExternalBufferInfo where
        (VkPhysicalDeviceExternalBufferInfo## a _) `compare`
          x@(VkPhysicalDeviceExternalBufferInfo## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceExternalBufferInfo where
        sizeOf ~_ = #{size VkPhysicalDeviceExternalBufferInfo}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceExternalBufferInfo}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceExternalBufferInfo where
        unsafeAddr (VkPhysicalDeviceExternalBufferInfo## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceExternalBufferInfo## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceExternalBufferInfo##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceExternalBufferInfo where
        type StructFields VkPhysicalDeviceExternalBufferInfo =
             '["sType", "pNext", "flags", "usage", "handleType"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceExternalBufferInfo = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceExternalBufferInfo = 'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceExternalBufferInfo = '[] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceExternalBufferInfo where
        type FieldType "sType" VkPhysicalDeviceExternalBufferInfo =
             VkStructureType
        type FieldOptional "sType" VkPhysicalDeviceExternalBufferInfo =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDeviceExternalBufferInfo =
             #{offset VkPhysicalDeviceExternalBufferInfo, sType}
        type FieldIsArray "sType" VkPhysicalDeviceExternalBufferInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalBufferInfo, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceExternalBufferInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalBufferInfo, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceExternalBufferInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceExternalBufferInfo where
        type FieldType "pNext" VkPhysicalDeviceExternalBufferInfo =
             Ptr Void
        type FieldOptional "pNext" VkPhysicalDeviceExternalBufferInfo =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDeviceExternalBufferInfo =
             #{offset VkPhysicalDeviceExternalBufferInfo, pNext}
        type FieldIsArray "pNext" VkPhysicalDeviceExternalBufferInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalBufferInfo, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceExternalBufferInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalBufferInfo, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceExternalBufferInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, pNext}

instance {-# OVERLAPPING #-}
         HasField "flags" VkPhysicalDeviceExternalBufferInfo where
        type FieldType "flags" VkPhysicalDeviceExternalBufferInfo =
             VkBufferCreateFlags
        type FieldOptional "flags" VkPhysicalDeviceExternalBufferInfo =
             'True -- ' closing tick for hsc2hs
        type FieldOffset "flags" VkPhysicalDeviceExternalBufferInfo =
             #{offset VkPhysicalDeviceExternalBufferInfo, flags}
        type FieldIsArray "flags" VkPhysicalDeviceExternalBufferInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalBufferInfo, flags}

instance {-# OVERLAPPING #-}
         CanReadField "flags" VkPhysicalDeviceExternalBufferInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalBufferInfo, flags})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, flags}

instance {-# OVERLAPPING #-}
         CanWriteField "flags" VkPhysicalDeviceExternalBufferInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, flags}

instance {-# OVERLAPPING #-}
         HasField "usage" VkPhysicalDeviceExternalBufferInfo where
        type FieldType "usage" VkPhysicalDeviceExternalBufferInfo =
             VkBufferUsageFlags
        type FieldOptional "usage" VkPhysicalDeviceExternalBufferInfo =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "usage" VkPhysicalDeviceExternalBufferInfo =
             #{offset VkPhysicalDeviceExternalBufferInfo, usage}
        type FieldIsArray "usage" VkPhysicalDeviceExternalBufferInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalBufferInfo, usage}

instance {-# OVERLAPPING #-}
         CanReadField "usage" VkPhysicalDeviceExternalBufferInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalBufferInfo, usage})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, usage}

instance {-# OVERLAPPING #-}
         CanWriteField "usage" VkPhysicalDeviceExternalBufferInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, usage}

instance {-# OVERLAPPING #-}
         HasField "handleType" VkPhysicalDeviceExternalBufferInfo where
        type FieldType "handleType" VkPhysicalDeviceExternalBufferInfo =
             VkExternalMemoryHandleTypeFlagBits
        type FieldOptional "handleType" VkPhysicalDeviceExternalBufferInfo
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "handleType" VkPhysicalDeviceExternalBufferInfo =
             #{offset VkPhysicalDeviceExternalBufferInfo, handleType}
        type FieldIsArray "handleType" VkPhysicalDeviceExternalBufferInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalBufferInfo, handleType}

instance {-# OVERLAPPING #-}
         CanReadField "handleType" VkPhysicalDeviceExternalBufferInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalBufferInfo, handleType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, handleType}

instance {-# OVERLAPPING #-}
         CanWriteField "handleType" VkPhysicalDeviceExternalBufferInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalBufferInfo, handleType}

instance Show VkPhysicalDeviceExternalBufferInfo where
        showsPrec d x
          = showString "VkPhysicalDeviceExternalBufferInfo {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "flags = " .
                            showsPrec d (getField @"flags" x) .
                              showString ", " .
                                showString "usage = " .
                                  showsPrec d (getField @"usage" x) .
                                    showString ", " .
                                      showString "handleType = " .
                                        showsPrec d (getField @"handleType" x) . showChar '}'

-- | Alias for `VkPhysicalDeviceExternalBufferInfo`
type VkPhysicalDeviceExternalBufferInfoKHR =
     VkPhysicalDeviceExternalBufferInfo

-- | > typedef struct VkPhysicalDeviceExternalFenceInfo {
--   >     VkStructureType sType;
--   >     const void*                      pNext;
--   >     VkExternalFenceHandleTypeFlagBits handleType;
--   > } VkPhysicalDeviceExternalFenceInfo;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceExternalFenceInfo VkPhysicalDeviceExternalFenceInfo registry at www.khronos.org>
data VkPhysicalDeviceExternalFenceInfo = VkPhysicalDeviceExternalFenceInfo## Addr##
                                                                            ByteArray##

instance Eq VkPhysicalDeviceExternalFenceInfo where
        (VkPhysicalDeviceExternalFenceInfo## a _) ==
          x@(VkPhysicalDeviceExternalFenceInfo## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceExternalFenceInfo where
        (VkPhysicalDeviceExternalFenceInfo## a _) `compare`
          x@(VkPhysicalDeviceExternalFenceInfo## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceExternalFenceInfo where
        sizeOf ~_ = #{size VkPhysicalDeviceExternalFenceInfo}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceExternalFenceInfo}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceExternalFenceInfo where
        unsafeAddr (VkPhysicalDeviceExternalFenceInfo## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceExternalFenceInfo## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceExternalFenceInfo##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceExternalFenceInfo where
        type StructFields VkPhysicalDeviceExternalFenceInfo =
             '["sType", "pNext", "handleType"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceExternalFenceInfo = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceExternalFenceInfo = 'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceExternalFenceInfo = '[] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceExternalFenceInfo where
        type FieldType "sType" VkPhysicalDeviceExternalFenceInfo =
             VkStructureType
        type FieldOptional "sType" VkPhysicalDeviceExternalFenceInfo =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDeviceExternalFenceInfo =
             #{offset VkPhysicalDeviceExternalFenceInfo, sType}
        type FieldIsArray "sType" VkPhysicalDeviceExternalFenceInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalFenceInfo, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceExternalFenceInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalFenceInfo, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalFenceInfo, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceExternalFenceInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalFenceInfo, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceExternalFenceInfo where
        type FieldType "pNext" VkPhysicalDeviceExternalFenceInfo = Ptr Void
        type FieldOptional "pNext" VkPhysicalDeviceExternalFenceInfo =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDeviceExternalFenceInfo =
             #{offset VkPhysicalDeviceExternalFenceInfo, pNext}
        type FieldIsArray "pNext" VkPhysicalDeviceExternalFenceInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalFenceInfo, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceExternalFenceInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalFenceInfo, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalFenceInfo, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceExternalFenceInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalFenceInfo, pNext}

instance {-# OVERLAPPING #-}
         HasField "handleType" VkPhysicalDeviceExternalFenceInfo where
        type FieldType "handleType" VkPhysicalDeviceExternalFenceInfo =
             VkExternalFenceHandleTypeFlagBits
        type FieldOptional "handleType" VkPhysicalDeviceExternalFenceInfo =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "handleType" VkPhysicalDeviceExternalFenceInfo =
             #{offset VkPhysicalDeviceExternalFenceInfo, handleType}
        type FieldIsArray "handleType" VkPhysicalDeviceExternalFenceInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalFenceInfo, handleType}

instance {-# OVERLAPPING #-}
         CanReadField "handleType" VkPhysicalDeviceExternalFenceInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalFenceInfo, handleType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalFenceInfo, handleType}

instance {-# OVERLAPPING #-}
         CanWriteField "handleType" VkPhysicalDeviceExternalFenceInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalFenceInfo, handleType}

instance Show VkPhysicalDeviceExternalFenceInfo where
        showsPrec d x
          = showString "VkPhysicalDeviceExternalFenceInfo {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "handleType = " .
                            showsPrec d (getField @"handleType" x) . showChar '}'

-- | Alias for `VkPhysicalDeviceExternalFenceInfo`
type VkPhysicalDeviceExternalFenceInfoKHR =
     VkPhysicalDeviceExternalFenceInfo

-- | > typedef struct VkPhysicalDeviceExternalImageFormatInfo {
--   >     VkStructureType sType;
--   >     const void*                      pNext;
--   >     VkExternalMemoryHandleTypeFlagBits handleType;
--   > } VkPhysicalDeviceExternalImageFormatInfo;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceExternalImageFormatInfo VkPhysicalDeviceExternalImageFormatInfo registry at www.khronos.org>
data VkPhysicalDeviceExternalImageFormatInfo = VkPhysicalDeviceExternalImageFormatInfo## Addr##
                                                                                        ByteArray##

instance Eq VkPhysicalDeviceExternalImageFormatInfo where
        (VkPhysicalDeviceExternalImageFormatInfo## a _) ==
          x@(VkPhysicalDeviceExternalImageFormatInfo## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceExternalImageFormatInfo where
        (VkPhysicalDeviceExternalImageFormatInfo## a _) `compare`
          x@(VkPhysicalDeviceExternalImageFormatInfo## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceExternalImageFormatInfo where
        sizeOf ~_
          = #{size VkPhysicalDeviceExternalImageFormatInfo}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceExternalImageFormatInfo}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceExternalImageFormatInfo
         where
        unsafeAddr (VkPhysicalDeviceExternalImageFormatInfo## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceExternalImageFormatInfo## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceExternalImageFormatInfo##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceExternalImageFormatInfo
         where
        type StructFields VkPhysicalDeviceExternalImageFormatInfo =
             '["sType", "pNext", "handleType"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceExternalImageFormatInfo = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceExternalImageFormatInfo = 'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceExternalImageFormatInfo =
             '[VkPhysicalDeviceImageFormatInfo2] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceExternalImageFormatInfo where
        type FieldType "sType" VkPhysicalDeviceExternalImageFormatInfo =
             VkStructureType
        type FieldOptional "sType" VkPhysicalDeviceExternalImageFormatInfo
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDeviceExternalImageFormatInfo =
             #{offset VkPhysicalDeviceExternalImageFormatInfo, sType}
        type FieldIsArray "sType" VkPhysicalDeviceExternalImageFormatInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalImageFormatInfo, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceExternalImageFormatInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalImageFormatInfo, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalImageFormatInfo, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceExternalImageFormatInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalImageFormatInfo, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceExternalImageFormatInfo where
        type FieldType "pNext" VkPhysicalDeviceExternalImageFormatInfo =
             Ptr Void
        type FieldOptional "pNext" VkPhysicalDeviceExternalImageFormatInfo
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDeviceExternalImageFormatInfo =
             #{offset VkPhysicalDeviceExternalImageFormatInfo, pNext}
        type FieldIsArray "pNext" VkPhysicalDeviceExternalImageFormatInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalImageFormatInfo, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceExternalImageFormatInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalImageFormatInfo, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalImageFormatInfo, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceExternalImageFormatInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalImageFormatInfo, pNext}

instance {-# OVERLAPPING #-}
         HasField "handleType" VkPhysicalDeviceExternalImageFormatInfo where
        type FieldType "handleType" VkPhysicalDeviceExternalImageFormatInfo
             = VkExternalMemoryHandleTypeFlagBits
        type FieldOptional "handleType"
               VkPhysicalDeviceExternalImageFormatInfo
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "handleType"
               VkPhysicalDeviceExternalImageFormatInfo
             =
             #{offset VkPhysicalDeviceExternalImageFormatInfo, handleType}
        type FieldIsArray "handleType"
               VkPhysicalDeviceExternalImageFormatInfo
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalImageFormatInfo, handleType}

instance {-# OVERLAPPING #-}
         CanReadField "handleType" VkPhysicalDeviceExternalImageFormatInfo
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalImageFormatInfo, handleType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalImageFormatInfo, handleType}

instance {-# OVERLAPPING #-}
         CanWriteField "handleType" VkPhysicalDeviceExternalImageFormatInfo
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalImageFormatInfo, handleType}

instance Show VkPhysicalDeviceExternalImageFormatInfo where
        showsPrec d x
          = showString "VkPhysicalDeviceExternalImageFormatInfo {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "handleType = " .
                            showsPrec d (getField @"handleType" x) . showChar '}'

-- | Alias for `VkPhysicalDeviceExternalImageFormatInfo`
type VkPhysicalDeviceExternalImageFormatInfoKHR =
     VkPhysicalDeviceExternalImageFormatInfo

-- | > typedef struct VkPhysicalDeviceExternalMemoryHostPropertiesEXT {
--   >     VkStructureType sType;
--   >     void* pNext;
--   >     VkDeviceSize minImportedHostPointerAlignment;
--   > } VkPhysicalDeviceExternalMemoryHostPropertiesEXT;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceExternalMemoryHostPropertiesEXT VkPhysicalDeviceExternalMemoryHostPropertiesEXT registry at www.khronos.org>
data VkPhysicalDeviceExternalMemoryHostPropertiesEXT = VkPhysicalDeviceExternalMemoryHostPropertiesEXT## Addr##
                                                                                                        ByteArray##

instance Eq VkPhysicalDeviceExternalMemoryHostPropertiesEXT where
        (VkPhysicalDeviceExternalMemoryHostPropertiesEXT## a _) ==
          x@(VkPhysicalDeviceExternalMemoryHostPropertiesEXT## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceExternalMemoryHostPropertiesEXT where
        (VkPhysicalDeviceExternalMemoryHostPropertiesEXT## a _) `compare`
          x@(VkPhysicalDeviceExternalMemoryHostPropertiesEXT## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        sizeOf ~_
          = #{size VkPhysicalDeviceExternalMemoryHostPropertiesEXT}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceExternalMemoryHostPropertiesEXT}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        unsafeAddr (VkPhysicalDeviceExternalMemoryHostPropertiesEXT## a _)
          = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray
          (VkPhysicalDeviceExternalMemoryHostPropertiesEXT## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceExternalMemoryHostPropertiesEXT##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        type StructFields VkPhysicalDeviceExternalMemoryHostPropertiesEXT =
             '["sType", "pNext", "minImportedHostPointerAlignment"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceExternalMemoryHostPropertiesEXT =
             'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceExternalMemoryHostPropertiesEXT =
             'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = '[VkPhysicalDeviceProperties2] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        type FieldType "sType"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = VkStructureType
        type FieldOptional "sType"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             =
             #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, sType}
        type FieldIsArray "sType"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType"
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType"
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        type FieldType "pNext"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = Ptr Void
        type FieldOptional "pNext"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             =
             #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, pNext}
        type FieldIsArray "pNext"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext"
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext"
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, pNext}

instance {-# OVERLAPPING #-}
         HasField "minImportedHostPointerAlignment"
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        type FieldType "minImportedHostPointerAlignment"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = VkDeviceSize
        type FieldOptional "minImportedHostPointerAlignment"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "minImportedHostPointerAlignment"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             =
             #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, minImportedHostPointerAlignment}
        type FieldIsArray "minImportedHostPointerAlignment"
               VkPhysicalDeviceExternalMemoryHostPropertiesEXT
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, minImportedHostPointerAlignment}

instance {-# OVERLAPPING #-}
         CanReadField "minImportedHostPointerAlignment"
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, minImportedHostPointerAlignment})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, minImportedHostPointerAlignment}

instance {-# OVERLAPPING #-}
         CanWriteField "minImportedHostPointerAlignment"
           VkPhysicalDeviceExternalMemoryHostPropertiesEXT
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalMemoryHostPropertiesEXT, minImportedHostPointerAlignment}

instance Show VkPhysicalDeviceExternalMemoryHostPropertiesEXT where
        showsPrec d x
          = showString "VkPhysicalDeviceExternalMemoryHostPropertiesEXT {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "minImportedHostPointerAlignment = " .
                            showsPrec d (getField @"minImportedHostPointerAlignment" x) .
                              showChar '}'

-- | > typedef struct VkPhysicalDeviceExternalSemaphoreInfo {
--   >     VkStructureType sType;
--   >     const void*                      pNext;
--   >     VkExternalSemaphoreHandleTypeFlagBits handleType;
--   > } VkPhysicalDeviceExternalSemaphoreInfo;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceExternalSemaphoreInfo VkPhysicalDeviceExternalSemaphoreInfo registry at www.khronos.org>
data VkPhysicalDeviceExternalSemaphoreInfo = VkPhysicalDeviceExternalSemaphoreInfo## Addr##
                                                                                    ByteArray##

instance Eq VkPhysicalDeviceExternalSemaphoreInfo where
        (VkPhysicalDeviceExternalSemaphoreInfo## a _) ==
          x@(VkPhysicalDeviceExternalSemaphoreInfo## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceExternalSemaphoreInfo where
        (VkPhysicalDeviceExternalSemaphoreInfo## a _) `compare`
          x@(VkPhysicalDeviceExternalSemaphoreInfo## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceExternalSemaphoreInfo where
        sizeOf ~_
          = #{size VkPhysicalDeviceExternalSemaphoreInfo}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceExternalSemaphoreInfo}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceExternalSemaphoreInfo
         where
        unsafeAddr (VkPhysicalDeviceExternalSemaphoreInfo## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceExternalSemaphoreInfo## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceExternalSemaphoreInfo##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceExternalSemaphoreInfo where
        type StructFields VkPhysicalDeviceExternalSemaphoreInfo =
             '["sType", "pNext", "handleType"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceExternalSemaphoreInfo = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceExternalSemaphoreInfo = 'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceExternalSemaphoreInfo = '[] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceExternalSemaphoreInfo where
        type FieldType "sType" VkPhysicalDeviceExternalSemaphoreInfo =
             VkStructureType
        type FieldOptional "sType" VkPhysicalDeviceExternalSemaphoreInfo =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDeviceExternalSemaphoreInfo =
             #{offset VkPhysicalDeviceExternalSemaphoreInfo, sType}
        type FieldIsArray "sType" VkPhysicalDeviceExternalSemaphoreInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalSemaphoreInfo, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceExternalSemaphoreInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalSemaphoreInfo, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalSemaphoreInfo, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceExternalSemaphoreInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalSemaphoreInfo, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceExternalSemaphoreInfo where
        type FieldType "pNext" VkPhysicalDeviceExternalSemaphoreInfo =
             Ptr Void
        type FieldOptional "pNext" VkPhysicalDeviceExternalSemaphoreInfo =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDeviceExternalSemaphoreInfo =
             #{offset VkPhysicalDeviceExternalSemaphoreInfo, pNext}
        type FieldIsArray "pNext" VkPhysicalDeviceExternalSemaphoreInfo =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalSemaphoreInfo, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceExternalSemaphoreInfo where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalSemaphoreInfo, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalSemaphoreInfo, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceExternalSemaphoreInfo where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalSemaphoreInfo, pNext}

instance {-# OVERLAPPING #-}
         HasField "handleType" VkPhysicalDeviceExternalSemaphoreInfo where
        type FieldType "handleType" VkPhysicalDeviceExternalSemaphoreInfo =
             VkExternalSemaphoreHandleTypeFlagBits
        type FieldOptional "handleType"
               VkPhysicalDeviceExternalSemaphoreInfo
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "handleType" VkPhysicalDeviceExternalSemaphoreInfo
             =
             #{offset VkPhysicalDeviceExternalSemaphoreInfo, handleType}
        type FieldIsArray "handleType"
               VkPhysicalDeviceExternalSemaphoreInfo
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceExternalSemaphoreInfo, handleType}

instance {-# OVERLAPPING #-}
         CanReadField "handleType" VkPhysicalDeviceExternalSemaphoreInfo
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceExternalSemaphoreInfo, handleType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceExternalSemaphoreInfo, handleType}

instance {-# OVERLAPPING #-}
         CanWriteField "handleType" VkPhysicalDeviceExternalSemaphoreInfo
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceExternalSemaphoreInfo, handleType}

instance Show VkPhysicalDeviceExternalSemaphoreInfo where
        showsPrec d x
          = showString "VkPhysicalDeviceExternalSemaphoreInfo {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "handleType = " .
                            showsPrec d (getField @"handleType" x) . showChar '}'

-- | Alias for `VkPhysicalDeviceExternalSemaphoreInfo`
type VkPhysicalDeviceExternalSemaphoreInfoKHR =
     VkPhysicalDeviceExternalSemaphoreInfo

-- | > typedef struct VkPhysicalDeviceFeatures2 {
--   >     VkStructureType sType;
--   >     void*                            pNext;
--   >     VkPhysicalDeviceFeatures         features;
--   > } VkPhysicalDeviceFeatures2;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceFeatures2 VkPhysicalDeviceFeatures2 registry at www.khronos.org>
data VkPhysicalDeviceFeatures2 = VkPhysicalDeviceFeatures2## Addr##
                                                            ByteArray##

instance Eq VkPhysicalDeviceFeatures2 where
        (VkPhysicalDeviceFeatures2## a _) ==
          x@(VkPhysicalDeviceFeatures2## b _) = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceFeatures2 where
        (VkPhysicalDeviceFeatures2## a _) `compare`
          x@(VkPhysicalDeviceFeatures2## b _) = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceFeatures2 where
        sizeOf ~_ = #{size VkPhysicalDeviceFeatures2}

        {-# INLINE sizeOf #-}
        alignment ~_ = #{alignment VkPhysicalDeviceFeatures2}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceFeatures2 where
        unsafeAddr (VkPhysicalDeviceFeatures2## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceFeatures2## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceFeatures2## (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceFeatures2 where
        type StructFields VkPhysicalDeviceFeatures2 =
             '["sType", "pNext", "features"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceFeatures2 = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceFeatures2 = 'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceFeatures2 =
             '[VkDeviceCreateInfo] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceFeatures2 where
        type FieldType "sType" VkPhysicalDeviceFeatures2 = VkStructureType
        type FieldOptional "sType" VkPhysicalDeviceFeatures2 = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDeviceFeatures2 =
             #{offset VkPhysicalDeviceFeatures2, sType}
        type FieldIsArray "sType" VkPhysicalDeviceFeatures2 = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceFeatures2, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceFeatures2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceFeatures2, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceFeatures2, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceFeatures2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceFeatures2, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceFeatures2 where
        type FieldType "pNext" VkPhysicalDeviceFeatures2 = Ptr Void
        type FieldOptional "pNext" VkPhysicalDeviceFeatures2 = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDeviceFeatures2 =
             #{offset VkPhysicalDeviceFeatures2, pNext}
        type FieldIsArray "pNext" VkPhysicalDeviceFeatures2 = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceFeatures2, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceFeatures2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceFeatures2, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceFeatures2, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceFeatures2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceFeatures2, pNext}

instance {-# OVERLAPPING #-}
         HasField "features" VkPhysicalDeviceFeatures2 where
        type FieldType "features" VkPhysicalDeviceFeatures2 =
             VkPhysicalDeviceFeatures
        type FieldOptional "features" VkPhysicalDeviceFeatures2 = 'False -- ' closing tick for hsc2hs
        type FieldOffset "features" VkPhysicalDeviceFeatures2 =
             #{offset VkPhysicalDeviceFeatures2, features}
        type FieldIsArray "features" VkPhysicalDeviceFeatures2 = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceFeatures2, features}

instance {-# OVERLAPPING #-}
         CanReadField "features" VkPhysicalDeviceFeatures2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceFeatures2, features})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceFeatures2, features}

instance {-# OVERLAPPING #-}
         CanWriteField "features" VkPhysicalDeviceFeatures2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceFeatures2, features}

instance Show VkPhysicalDeviceFeatures2 where
        showsPrec d x
          = showString "VkPhysicalDeviceFeatures2 {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "features = " .
                            showsPrec d (getField @"features" x) . showChar '}'

-- | Alias for `VkPhysicalDeviceFeatures2`
type VkPhysicalDeviceFeatures2KHR = VkPhysicalDeviceFeatures2

-- | > typedef struct VkPhysicalDeviceGroupProperties {
--   >     VkStructureType sType;
--   >     void*                            pNext;
--   >     uint32_t                         physicalDeviceCount;
--   >     VkPhysicalDevice                 physicalDevices[VK_MAX_DEVICE_GROUP_SIZE];
--   >     VkBool32                         subsetAllocation;
--   > } VkPhysicalDeviceGroupProperties;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceGroupProperties VkPhysicalDeviceGroupProperties registry at www.khronos.org>
data VkPhysicalDeviceGroupProperties = VkPhysicalDeviceGroupProperties## Addr##
                                                                        ByteArray##

instance Eq VkPhysicalDeviceGroupProperties where
        (VkPhysicalDeviceGroupProperties## a _) ==
          x@(VkPhysicalDeviceGroupProperties## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceGroupProperties where
        (VkPhysicalDeviceGroupProperties## a _) `compare`
          x@(VkPhysicalDeviceGroupProperties## b _) = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceGroupProperties where
        sizeOf ~_ = #{size VkPhysicalDeviceGroupProperties}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceGroupProperties}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceGroupProperties where
        unsafeAddr (VkPhysicalDeviceGroupProperties## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceGroupProperties## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceGroupProperties##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceGroupProperties where
        type StructFields VkPhysicalDeviceGroupProperties =
             '["sType", "pNext", "physicalDeviceCount", "physicalDevices", -- ' closing tick for hsc2hs
               "subsetAllocation"]
        type CUnionType VkPhysicalDeviceGroupProperties = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceGroupProperties = 'True -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceGroupProperties = '[] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceGroupProperties where
        type FieldType "sType" VkPhysicalDeviceGroupProperties =
             VkStructureType
        type FieldOptional "sType" VkPhysicalDeviceGroupProperties = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDeviceGroupProperties =
             #{offset VkPhysicalDeviceGroupProperties, sType}
        type FieldIsArray "sType" VkPhysicalDeviceGroupProperties = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceGroupProperties, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceGroupProperties where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceGroupProperties, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceGroupProperties, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceGroupProperties where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceGroupProperties, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceGroupProperties where
        type FieldType "pNext" VkPhysicalDeviceGroupProperties = Ptr Void
        type FieldOptional "pNext" VkPhysicalDeviceGroupProperties = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDeviceGroupProperties =
             #{offset VkPhysicalDeviceGroupProperties, pNext}
        type FieldIsArray "pNext" VkPhysicalDeviceGroupProperties = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceGroupProperties, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceGroupProperties where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceGroupProperties, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceGroupProperties, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceGroupProperties where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceGroupProperties, pNext}

instance {-# OVERLAPPING #-}
         HasField "physicalDeviceCount" VkPhysicalDeviceGroupProperties
         where
        type FieldType "physicalDeviceCount"
               VkPhysicalDeviceGroupProperties
             = Word32
        type FieldOptional "physicalDeviceCount"
               VkPhysicalDeviceGroupProperties
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "physicalDeviceCount"
               VkPhysicalDeviceGroupProperties
             =
             #{offset VkPhysicalDeviceGroupProperties, physicalDeviceCount}
        type FieldIsArray "physicalDeviceCount"
               VkPhysicalDeviceGroupProperties
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceGroupProperties, physicalDeviceCount}

instance {-# OVERLAPPING #-}
         CanReadField "physicalDeviceCount" VkPhysicalDeviceGroupProperties
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceGroupProperties, physicalDeviceCount})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceGroupProperties, physicalDeviceCount}

instance {-# OVERLAPPING #-}
         CanWriteField "physicalDeviceCount" VkPhysicalDeviceGroupProperties
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceGroupProperties, physicalDeviceCount}

instance {-# OVERLAPPING #-}
         HasField "physicalDevices" VkPhysicalDeviceGroupProperties where
        type FieldType "physicalDevices" VkPhysicalDeviceGroupProperties =
             VkPhysicalDevice
        type FieldOptional "physicalDevices"
               VkPhysicalDeviceGroupProperties
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "physicalDevices" VkPhysicalDeviceGroupProperties
             =
             #{offset VkPhysicalDeviceGroupProperties, physicalDevices}
        type FieldIsArray "physicalDevices" VkPhysicalDeviceGroupProperties
             = 'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceGroupProperties, physicalDevices}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "physicalDevices" idx
            VkPhysicalDeviceGroupProperties) =>
         CanReadFieldArray "physicalDevices" idx
           VkPhysicalDeviceGroupProperties
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "physicalDevices" 0
                         VkPhysicalDeviceGroupProperties
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "physicalDevices" 1
                         VkPhysicalDeviceGroupProperties
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "physicalDevices" 2
                         VkPhysicalDeviceGroupProperties
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "physicalDevices" 3
                         VkPhysicalDeviceGroupProperties
                       #-}
        type FieldArrayLength "physicalDevices"
               VkPhysicalDeviceGroupProperties
             = VK_MAX_DEVICE_GROUP_SIZE

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = VK_MAX_DEVICE_GROUP_SIZE

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceGroupProperties, physicalDevices}
                      +
                      sizeOf (undefined :: VkPhysicalDevice) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceGroupProperties, physicalDevices}
                 +
                 sizeOf (undefined :: VkPhysicalDevice) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "physicalDevices" idx
            VkPhysicalDeviceGroupProperties) =>
         CanWriteFieldArray "physicalDevices" idx
           VkPhysicalDeviceGroupProperties
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "physicalDevices" 0
                         VkPhysicalDeviceGroupProperties
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "physicalDevices" 1
                         VkPhysicalDeviceGroupProperties
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "physicalDevices" 2
                         VkPhysicalDeviceGroupProperties
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "physicalDevices" 3
                         VkPhysicalDeviceGroupProperties
                       #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceGroupProperties, physicalDevices}
                 +
                 sizeOf (undefined :: VkPhysicalDevice) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "subsetAllocation" VkPhysicalDeviceGroupProperties where
        type FieldType "subsetAllocation" VkPhysicalDeviceGroupProperties =
             VkBool32
        type FieldOptional "subsetAllocation"
               VkPhysicalDeviceGroupProperties
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "subsetAllocation" VkPhysicalDeviceGroupProperties
             =
             #{offset VkPhysicalDeviceGroupProperties, subsetAllocation}
        type FieldIsArray "subsetAllocation"
               VkPhysicalDeviceGroupProperties
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceGroupProperties, subsetAllocation}

instance {-# OVERLAPPING #-}
         CanReadField "subsetAllocation" VkPhysicalDeviceGroupProperties
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceGroupProperties, subsetAllocation})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceGroupProperties, subsetAllocation}

instance {-# OVERLAPPING #-}
         CanWriteField "subsetAllocation" VkPhysicalDeviceGroupProperties
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceGroupProperties, subsetAllocation}

instance Show VkPhysicalDeviceGroupProperties where
        showsPrec d x
          = showString "VkPhysicalDeviceGroupProperties {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "physicalDeviceCount = " .
                            showsPrec d (getField @"physicalDeviceCount" x) .
                              showString ", " .
                                (showString "physicalDevices = [" .
                                   showsPrec d
                                     (let s = sizeOf
                                                (undefined ::
                                                   FieldType "physicalDevices"
                                                     VkPhysicalDeviceGroupProperties)
                                          o = fieldOffset @"physicalDevices"
                                                @VkPhysicalDeviceGroupProperties
                                          f i
                                            = peekByteOff (unsafePtr x) i ::
                                                IO
                                                  (FieldType "physicalDevices"
                                                     VkPhysicalDeviceGroupProperties)
                                        in
                                        unsafeDupablePerformIO . mapM f $
                                          map (\ i -> o + i * s)
                                            [0 .. VK_MAX_DEVICE_GROUP_SIZE - 1])
                                     . showChar ']')
                                  .
                                  showString ", " .
                                    showString "subsetAllocation = " .
                                      showsPrec d (getField @"subsetAllocation" x) . showChar '}'

-- | Alias for `VkPhysicalDeviceGroupProperties`
type VkPhysicalDeviceGroupPropertiesKHR =
     VkPhysicalDeviceGroupProperties

-- | > typedef struct VkPhysicalDeviceIDProperties {
--   >     VkStructureType sType;
--   >     void*                            pNext;
--   >     uint8_t                          deviceUUID[VK_UUID_SIZE];
--   >     uint8_t                          driverUUID[VK_UUID_SIZE];
--   >     uint8_t                          deviceLUID[VK_LUID_SIZE];
--   >     uint32_t                         deviceNodeMask;
--   >     VkBool32                         deviceLUIDValid;
--   > } VkPhysicalDeviceIDProperties;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceIDProperties VkPhysicalDeviceIDProperties registry at www.khronos.org>
data VkPhysicalDeviceIDProperties = VkPhysicalDeviceIDProperties## Addr##
                                                                  ByteArray##

instance Eq VkPhysicalDeviceIDProperties where
        (VkPhysicalDeviceIDProperties## a _) ==
          x@(VkPhysicalDeviceIDProperties## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceIDProperties where
        (VkPhysicalDeviceIDProperties## a _) `compare`
          x@(VkPhysicalDeviceIDProperties## b _) = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceIDProperties where
        sizeOf ~_ = #{size VkPhysicalDeviceIDProperties}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceIDProperties}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceIDProperties where
        unsafeAddr (VkPhysicalDeviceIDProperties## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceIDProperties## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceIDProperties##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceIDProperties where
        type StructFields VkPhysicalDeviceIDProperties =
             '["sType", "pNext", "deviceUUID", "driverUUID", "deviceLUID", -- ' closing tick for hsc2hs
               "deviceNodeMask", "deviceLUIDValid"]
        type CUnionType VkPhysicalDeviceIDProperties = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceIDProperties = 'True -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceIDProperties =
             '[VkPhysicalDeviceProperties2] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceIDProperties where
        type FieldType "sType" VkPhysicalDeviceIDProperties =
             VkStructureType
        type FieldOptional "sType" VkPhysicalDeviceIDProperties = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDeviceIDProperties =
             #{offset VkPhysicalDeviceIDProperties, sType}
        type FieldIsArray "sType" VkPhysicalDeviceIDProperties = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceIDProperties, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceIDProperties where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceIDProperties, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceIDProperties, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceIDProperties where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceIDProperties, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceIDProperties where
        type FieldType "pNext" VkPhysicalDeviceIDProperties = Ptr Void
        type FieldOptional "pNext" VkPhysicalDeviceIDProperties = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDeviceIDProperties =
             #{offset VkPhysicalDeviceIDProperties, pNext}
        type FieldIsArray "pNext" VkPhysicalDeviceIDProperties = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceIDProperties, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceIDProperties where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceIDProperties, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceIDProperties, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceIDProperties where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceIDProperties, pNext}

instance {-# OVERLAPPING #-}
         HasField "deviceUUID" VkPhysicalDeviceIDProperties where
        type FieldType "deviceUUID" VkPhysicalDeviceIDProperties = Word8
        type FieldOptional "deviceUUID" VkPhysicalDeviceIDProperties =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "deviceUUID" VkPhysicalDeviceIDProperties =
             #{offset VkPhysicalDeviceIDProperties, deviceUUID}
        type FieldIsArray "deviceUUID" VkPhysicalDeviceIDProperties = 'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceIDProperties, deviceUUID}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "deviceUUID" idx VkPhysicalDeviceIDProperties) =>
         CanReadFieldArray "deviceUUID" idx VkPhysicalDeviceIDProperties
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "deviceUUID" 0 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "deviceUUID" 1 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "deviceUUID" 2 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "deviceUUID" 3 VkPhysicalDeviceIDProperties #-}
        type FieldArrayLength "deviceUUID" VkPhysicalDeviceIDProperties =
             VK_UUID_SIZE

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = VK_UUID_SIZE

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceIDProperties, deviceUUID} +
                      sizeOf (undefined :: Word8) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceIDProperties, deviceUUID} +
                 sizeOf (undefined :: Word8) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "deviceUUID" idx VkPhysicalDeviceIDProperties) =>
         CanWriteFieldArray "deviceUUID" idx VkPhysicalDeviceIDProperties
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "deviceUUID" 0 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "deviceUUID" 1 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "deviceUUID" 2 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "deviceUUID" 3 VkPhysicalDeviceIDProperties #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceIDProperties, deviceUUID} +
                 sizeOf (undefined :: Word8) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "driverUUID" VkPhysicalDeviceIDProperties where
        type FieldType "driverUUID" VkPhysicalDeviceIDProperties = Word8
        type FieldOptional "driverUUID" VkPhysicalDeviceIDProperties =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "driverUUID" VkPhysicalDeviceIDProperties =
             #{offset VkPhysicalDeviceIDProperties, driverUUID}
        type FieldIsArray "driverUUID" VkPhysicalDeviceIDProperties = 'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceIDProperties, driverUUID}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "driverUUID" idx VkPhysicalDeviceIDProperties) =>
         CanReadFieldArray "driverUUID" idx VkPhysicalDeviceIDProperties
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "driverUUID" 0 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "driverUUID" 1 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "driverUUID" 2 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "driverUUID" 3 VkPhysicalDeviceIDProperties #-}
        type FieldArrayLength "driverUUID" VkPhysicalDeviceIDProperties =
             VK_UUID_SIZE

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = VK_UUID_SIZE

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceIDProperties, driverUUID} +
                      sizeOf (undefined :: Word8) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceIDProperties, driverUUID} +
                 sizeOf (undefined :: Word8) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "driverUUID" idx VkPhysicalDeviceIDProperties) =>
         CanWriteFieldArray "driverUUID" idx VkPhysicalDeviceIDProperties
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "driverUUID" 0 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "driverUUID" 1 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "driverUUID" 2 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "driverUUID" 3 VkPhysicalDeviceIDProperties #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceIDProperties, driverUUID} +
                 sizeOf (undefined :: Word8) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "deviceLUID" VkPhysicalDeviceIDProperties where
        type FieldType "deviceLUID" VkPhysicalDeviceIDProperties = Word8
        type FieldOptional "deviceLUID" VkPhysicalDeviceIDProperties =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "deviceLUID" VkPhysicalDeviceIDProperties =
             #{offset VkPhysicalDeviceIDProperties, deviceLUID}
        type FieldIsArray "deviceLUID" VkPhysicalDeviceIDProperties = 'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceIDProperties, deviceLUID}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "deviceLUID" idx VkPhysicalDeviceIDProperties) =>
         CanReadFieldArray "deviceLUID" idx VkPhysicalDeviceIDProperties
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "deviceLUID" 0 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "deviceLUID" 1 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "deviceLUID" 2 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "deviceLUID" 3 VkPhysicalDeviceIDProperties #-}
        type FieldArrayLength "deviceLUID" VkPhysicalDeviceIDProperties =
             VK_LUID_SIZE

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = VK_LUID_SIZE

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceIDProperties, deviceLUID} +
                      sizeOf (undefined :: Word8) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceIDProperties, deviceLUID} +
                 sizeOf (undefined :: Word8) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "deviceLUID" idx VkPhysicalDeviceIDProperties) =>
         CanWriteFieldArray "deviceLUID" idx VkPhysicalDeviceIDProperties
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "deviceLUID" 0 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "deviceLUID" 1 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "deviceLUID" 2 VkPhysicalDeviceIDProperties #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "deviceLUID" 3 VkPhysicalDeviceIDProperties #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceIDProperties, deviceLUID} +
                 sizeOf (undefined :: Word8) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "deviceNodeMask" VkPhysicalDeviceIDProperties where
        type FieldType "deviceNodeMask" VkPhysicalDeviceIDProperties =
             Word32
        type FieldOptional "deviceNodeMask" VkPhysicalDeviceIDProperties =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "deviceNodeMask" VkPhysicalDeviceIDProperties =
             #{offset VkPhysicalDeviceIDProperties, deviceNodeMask}
        type FieldIsArray "deviceNodeMask" VkPhysicalDeviceIDProperties =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceIDProperties, deviceNodeMask}

instance {-# OVERLAPPING #-}
         CanReadField "deviceNodeMask" VkPhysicalDeviceIDProperties where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceIDProperties, deviceNodeMask})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceIDProperties, deviceNodeMask}

instance {-# OVERLAPPING #-}
         CanWriteField "deviceNodeMask" VkPhysicalDeviceIDProperties where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceIDProperties, deviceNodeMask}

instance {-# OVERLAPPING #-}
         HasField "deviceLUIDValid" VkPhysicalDeviceIDProperties where
        type FieldType "deviceLUIDValid" VkPhysicalDeviceIDProperties =
             VkBool32
        type FieldOptional "deviceLUIDValid" VkPhysicalDeviceIDProperties =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "deviceLUIDValid" VkPhysicalDeviceIDProperties =
             #{offset VkPhysicalDeviceIDProperties, deviceLUIDValid}
        type FieldIsArray "deviceLUIDValid" VkPhysicalDeviceIDProperties =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceIDProperties, deviceLUIDValid}

instance {-# OVERLAPPING #-}
         CanReadField "deviceLUIDValid" VkPhysicalDeviceIDProperties where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceIDProperties, deviceLUIDValid})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceIDProperties, deviceLUIDValid}

instance {-# OVERLAPPING #-}
         CanWriteField "deviceLUIDValid" VkPhysicalDeviceIDProperties where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceIDProperties, deviceLUIDValid}

instance Show VkPhysicalDeviceIDProperties where
        showsPrec d x
          = showString "VkPhysicalDeviceIDProperties {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          (showString "deviceUUID = [" .
                             showsPrec d
                               (let s = sizeOf
                                          (undefined ::
                                             FieldType "deviceUUID" VkPhysicalDeviceIDProperties)
                                    o = fieldOffset @"deviceUUID" @VkPhysicalDeviceIDProperties
                                    f i
                                      = peekByteOff (unsafePtr x) i ::
                                          IO (FieldType "deviceUUID" VkPhysicalDeviceIDProperties)
                                  in
                                  unsafeDupablePerformIO . mapM f $
                                    map (\ i -> o + i * s) [0 .. VK_UUID_SIZE - 1])
                               . showChar ']')
                            .
                            showString ", " .
                              (showString "driverUUID = [" .
                                 showsPrec d
                                   (let s = sizeOf
                                              (undefined ::
                                                 FieldType "driverUUID"
                                                   VkPhysicalDeviceIDProperties)
                                        o = fieldOffset @"driverUUID" @VkPhysicalDeviceIDProperties
                                        f i
                                          = peekByteOff (unsafePtr x) i ::
                                              IO
                                                (FieldType "driverUUID"
                                                   VkPhysicalDeviceIDProperties)
                                      in
                                      unsafeDupablePerformIO . mapM f $
                                        map (\ i -> o + i * s) [0 .. VK_UUID_SIZE - 1])
                                   . showChar ']')
                                .
                                showString ", " .
                                  (showString "deviceLUID = [" .
                                     showsPrec d
                                       (let s = sizeOf
                                                  (undefined ::
                                                     FieldType "deviceLUID"
                                                       VkPhysicalDeviceIDProperties)
                                            o = fieldOffset @"deviceLUID"
                                                  @VkPhysicalDeviceIDProperties
                                            f i
                                              = peekByteOff (unsafePtr x) i ::
                                                  IO
                                                    (FieldType "deviceLUID"
                                                       VkPhysicalDeviceIDProperties)
                                          in
                                          unsafeDupablePerformIO . mapM f $
                                            map (\ i -> o + i * s) [0 .. VK_LUID_SIZE - 1])
                                       . showChar ']')
                                    .
                                    showString ", " .
                                      showString "deviceNodeMask = " .
                                        showsPrec d (getField @"deviceNodeMask" x) .
                                          showString ", " .
                                            showString "deviceLUIDValid = " .
                                              showsPrec d (getField @"deviceLUIDValid" x) .
                                                showChar '}'

-- | Alias for `VkPhysicalDeviceIDProperties`
type VkPhysicalDeviceIDPropertiesKHR = VkPhysicalDeviceIDProperties

-- | > typedef struct VkPhysicalDeviceImageFormatInfo2 {
--   >     VkStructureType sType;
--   >     const void* pNext;
--   >     VkFormat                         format;
--   >     VkImageType                      type;
--   >     VkImageTiling                    tiling;
--   >     VkImageUsageFlags                usage;
--   >     VkImageCreateFlags flags;
--   > } VkPhysicalDeviceImageFormatInfo2;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceImageFormatInfo2 VkPhysicalDeviceImageFormatInfo2 registry at www.khronos.org>
data VkPhysicalDeviceImageFormatInfo2 = VkPhysicalDeviceImageFormatInfo2## Addr##
                                                                          ByteArray##

instance Eq VkPhysicalDeviceImageFormatInfo2 where
        (VkPhysicalDeviceImageFormatInfo2## a _) ==
          x@(VkPhysicalDeviceImageFormatInfo2## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceImageFormatInfo2 where
        (VkPhysicalDeviceImageFormatInfo2## a _) `compare`
          x@(VkPhysicalDeviceImageFormatInfo2## b _)
          = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceImageFormatInfo2 where
        sizeOf ~_ = #{size VkPhysicalDeviceImageFormatInfo2}

        {-# INLINE sizeOf #-}
        alignment ~_
          = #{alignment VkPhysicalDeviceImageFormatInfo2}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceImageFormatInfo2 where
        unsafeAddr (VkPhysicalDeviceImageFormatInfo2## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceImageFormatInfo2## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceImageFormatInfo2##
              (plusAddr## (byteArrayContents## b) off)
              b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceImageFormatInfo2 where
        type StructFields VkPhysicalDeviceImageFormatInfo2 =
             '["sType", "pNext", "format", "type", "tiling", "usage", "flags"] -- ' closing tick for hsc2hs
        type CUnionType VkPhysicalDeviceImageFormatInfo2 = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceImageFormatInfo2 = 'False -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceImageFormatInfo2 = '[] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "sType" VkPhysicalDeviceImageFormatInfo2 where
        type FieldType "sType" VkPhysicalDeviceImageFormatInfo2 =
             VkStructureType
        type FieldOptional "sType" VkPhysicalDeviceImageFormatInfo2 =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "sType" VkPhysicalDeviceImageFormatInfo2 =
             #{offset VkPhysicalDeviceImageFormatInfo2, sType}
        type FieldIsArray "sType" VkPhysicalDeviceImageFormatInfo2 = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceImageFormatInfo2, sType}

instance {-# OVERLAPPING #-}
         CanReadField "sType" VkPhysicalDeviceImageFormatInfo2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceImageFormatInfo2, sType})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, sType}

instance {-# OVERLAPPING #-}
         CanWriteField "sType" VkPhysicalDeviceImageFormatInfo2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, sType}

instance {-# OVERLAPPING #-}
         HasField "pNext" VkPhysicalDeviceImageFormatInfo2 where
        type FieldType "pNext" VkPhysicalDeviceImageFormatInfo2 = Ptr Void
        type FieldOptional "pNext" VkPhysicalDeviceImageFormatInfo2 =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "pNext" VkPhysicalDeviceImageFormatInfo2 =
             #{offset VkPhysicalDeviceImageFormatInfo2, pNext}
        type FieldIsArray "pNext" VkPhysicalDeviceImageFormatInfo2 = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceImageFormatInfo2, pNext}

instance {-# OVERLAPPING #-}
         CanReadField "pNext" VkPhysicalDeviceImageFormatInfo2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceImageFormatInfo2, pNext})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, pNext}

instance {-# OVERLAPPING #-}
         CanWriteField "pNext" VkPhysicalDeviceImageFormatInfo2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, pNext}

instance {-# OVERLAPPING #-}
         HasField "format" VkPhysicalDeviceImageFormatInfo2 where
        type FieldType "format" VkPhysicalDeviceImageFormatInfo2 = VkFormat
        type FieldOptional "format" VkPhysicalDeviceImageFormatInfo2 =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "format" VkPhysicalDeviceImageFormatInfo2 =
             #{offset VkPhysicalDeviceImageFormatInfo2, format}
        type FieldIsArray "format" VkPhysicalDeviceImageFormatInfo2 =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceImageFormatInfo2, format}

instance {-# OVERLAPPING #-}
         CanReadField "format" VkPhysicalDeviceImageFormatInfo2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceImageFormatInfo2, format})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, format}

instance {-# OVERLAPPING #-}
         CanWriteField "format" VkPhysicalDeviceImageFormatInfo2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, format}

instance {-# OVERLAPPING #-}
         HasField "type" VkPhysicalDeviceImageFormatInfo2 where
        type FieldType "type" VkPhysicalDeviceImageFormatInfo2 =
             VkImageType
        type FieldOptional "type" VkPhysicalDeviceImageFormatInfo2 = 'False -- ' closing tick for hsc2hs
        type FieldOffset "type" VkPhysicalDeviceImageFormatInfo2 =
             #{offset VkPhysicalDeviceImageFormatInfo2, type}
        type FieldIsArray "type" VkPhysicalDeviceImageFormatInfo2 = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceImageFormatInfo2, type}

instance {-# OVERLAPPING #-}
         CanReadField "type" VkPhysicalDeviceImageFormatInfo2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceImageFormatInfo2, type})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, type}

instance {-# OVERLAPPING #-}
         CanWriteField "type" VkPhysicalDeviceImageFormatInfo2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, type}

instance {-# OVERLAPPING #-}
         HasField "tiling" VkPhysicalDeviceImageFormatInfo2 where
        type FieldType "tiling" VkPhysicalDeviceImageFormatInfo2 =
             VkImageTiling
        type FieldOptional "tiling" VkPhysicalDeviceImageFormatInfo2 =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "tiling" VkPhysicalDeviceImageFormatInfo2 =
             #{offset VkPhysicalDeviceImageFormatInfo2, tiling}
        type FieldIsArray "tiling" VkPhysicalDeviceImageFormatInfo2 =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceImageFormatInfo2, tiling}

instance {-# OVERLAPPING #-}
         CanReadField "tiling" VkPhysicalDeviceImageFormatInfo2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceImageFormatInfo2, tiling})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, tiling}

instance {-# OVERLAPPING #-}
         CanWriteField "tiling" VkPhysicalDeviceImageFormatInfo2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, tiling}

instance {-# OVERLAPPING #-}
         HasField "usage" VkPhysicalDeviceImageFormatInfo2 where
        type FieldType "usage" VkPhysicalDeviceImageFormatInfo2 =
             VkImageUsageFlags
        type FieldOptional "usage" VkPhysicalDeviceImageFormatInfo2 =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "usage" VkPhysicalDeviceImageFormatInfo2 =
             #{offset VkPhysicalDeviceImageFormatInfo2, usage}
        type FieldIsArray "usage" VkPhysicalDeviceImageFormatInfo2 = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceImageFormatInfo2, usage}

instance {-# OVERLAPPING #-}
         CanReadField "usage" VkPhysicalDeviceImageFormatInfo2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceImageFormatInfo2, usage})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, usage}

instance {-# OVERLAPPING #-}
         CanWriteField "usage" VkPhysicalDeviceImageFormatInfo2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, usage}

instance {-# OVERLAPPING #-}
         HasField "flags" VkPhysicalDeviceImageFormatInfo2 where
        type FieldType "flags" VkPhysicalDeviceImageFormatInfo2 =
             VkImageCreateFlags
        type FieldOptional "flags" VkPhysicalDeviceImageFormatInfo2 = 'True -- ' closing tick for hsc2hs
        type FieldOffset "flags" VkPhysicalDeviceImageFormatInfo2 =
             #{offset VkPhysicalDeviceImageFormatInfo2, flags}
        type FieldIsArray "flags" VkPhysicalDeviceImageFormatInfo2 = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceImageFormatInfo2, flags}

instance {-# OVERLAPPING #-}
         CanReadField "flags" VkPhysicalDeviceImageFormatInfo2 where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceImageFormatInfo2, flags})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, flags}

instance {-# OVERLAPPING #-}
         CanWriteField "flags" VkPhysicalDeviceImageFormatInfo2 where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceImageFormatInfo2, flags}

instance Show VkPhysicalDeviceImageFormatInfo2 where
        showsPrec d x
          = showString "VkPhysicalDeviceImageFormatInfo2 {" .
              showString "sType = " .
                showsPrec d (getField @"sType" x) .
                  showString ", " .
                    showString "pNext = " .
                      showsPrec d (getField @"pNext" x) .
                        showString ", " .
                          showString "format = " .
                            showsPrec d (getField @"format" x) .
                              showString ", " .
                                showString "type = " .
                                  showsPrec d (getField @"type" x) .
                                    showString ", " .
                                      showString "tiling = " .
                                        showsPrec d (getField @"tiling" x) .
                                          showString ", " .
                                            showString "usage = " .
                                              showsPrec d (getField @"usage" x) .
                                                showString ", " .
                                                  showString "flags = " .
                                                    showsPrec d (getField @"flags" x) . showChar '}'

-- | Alias for `VkPhysicalDeviceImageFormatInfo2`
type VkPhysicalDeviceImageFormatInfo2KHR =
     VkPhysicalDeviceImageFormatInfo2

-- | > typedef struct VkPhysicalDeviceLimits {
--   >     uint32_t               maxImageDimension1D;
--   >     uint32_t               maxImageDimension2D;
--   >     uint32_t               maxImageDimension3D;
--   >     uint32_t               maxImageDimensionCube;
--   >     uint32_t               maxImageArrayLayers;
--   >     uint32_t               maxTexelBufferElements;
--   >     uint32_t               maxUniformBufferRange;
--   >     uint32_t               maxStorageBufferRange;
--   >     uint32_t               maxPushConstantsSize;
--   >     uint32_t               maxMemoryAllocationCount;
--   >     uint32_t               maxSamplerAllocationCount;
--   >     VkDeviceSize           bufferImageGranularity;
--   >     VkDeviceSize           sparseAddressSpaceSize;
--   >     uint32_t               maxBoundDescriptorSets;
--   >     uint32_t               maxPerStageDescriptorSamplers;
--   >     uint32_t               maxPerStageDescriptorUniformBuffers;
--   >     uint32_t               maxPerStageDescriptorStorageBuffers;
--   >     uint32_t               maxPerStageDescriptorSampledImages;
--   >     uint32_t               maxPerStageDescriptorStorageImages;
--   >     uint32_t               maxPerStageDescriptorInputAttachments;
--   >     uint32_t               maxPerStageResources;
--   >     uint32_t               maxDescriptorSetSamplers;
--   >     uint32_t               maxDescriptorSetUniformBuffers;
--   >     uint32_t               maxDescriptorSetUniformBuffersDynamic;
--   >     uint32_t               maxDescriptorSetStorageBuffers;
--   >     uint32_t               maxDescriptorSetStorageBuffersDynamic;
--   >     uint32_t               maxDescriptorSetSampledImages;
--   >     uint32_t               maxDescriptorSetStorageImages;
--   >     uint32_t               maxDescriptorSetInputAttachments;
--   >     uint32_t               maxVertexInputAttributes;
--   >     uint32_t               maxVertexInputBindings;
--   >     uint32_t               maxVertexInputAttributeOffset;
--   >     uint32_t               maxVertexInputBindingStride;
--   >     uint32_t               maxVertexOutputComponents;
--   >     uint32_t               maxTessellationGenerationLevel;
--   >     uint32_t               maxTessellationPatchSize;
--   >     uint32_t               maxTessellationControlPerVertexInputComponents;
--   >     uint32_t               maxTessellationControlPerVertexOutputComponents;
--   >     uint32_t               maxTessellationControlPerPatchOutputComponents;
--   >     uint32_t               maxTessellationControlTotalOutputComponents;
--   >     uint32_t               maxTessellationEvaluationInputComponents;
--   >     uint32_t               maxTessellationEvaluationOutputComponents;
--   >     uint32_t               maxGeometryShaderInvocations;
--   >     uint32_t               maxGeometryInputComponents;
--   >     uint32_t               maxGeometryOutputComponents;
--   >     uint32_t               maxGeometryOutputVertices;
--   >     uint32_t               maxGeometryTotalOutputComponents;
--   >     uint32_t               maxFragmentInputComponents;
--   >     uint32_t               maxFragmentOutputAttachments;
--   >     uint32_t               maxFragmentDualSrcAttachments;
--   >     uint32_t               maxFragmentCombinedOutputResources;
--   >     uint32_t               maxComputeSharedMemorySize;
--   >     uint32_t               maxComputeWorkGroupCount[3];
--   >     uint32_t               maxComputeWorkGroupInvocations;
--   >     uint32_t               maxComputeWorkGroupSize[3];
--   >     uint32_t               subPixelPrecisionBits;
--   >     uint32_t               subTexelPrecisionBits;
--   >     uint32_t               mipmapPrecisionBits;
--   >     uint32_t               maxDrawIndexedIndexValue;
--   >     uint32_t               maxDrawIndirectCount;
--   >     float                  maxSamplerLodBias;
--   >     float                  maxSamplerAnisotropy;
--   >     uint32_t               maxViewports;
--   >     uint32_t               maxViewportDimensions[2];
--   >     float                  viewportBoundsRange[2];
--   >     uint32_t               viewportSubPixelBits;
--   >     size_t                 minMemoryMapAlignment;
--   >     VkDeviceSize           minTexelBufferOffsetAlignment;
--   >     VkDeviceSize           minUniformBufferOffsetAlignment;
--   >     VkDeviceSize           minStorageBufferOffsetAlignment;
--   >     int32_t                minTexelOffset;
--   >     uint32_t               maxTexelOffset;
--   >     int32_t                minTexelGatherOffset;
--   >     uint32_t               maxTexelGatherOffset;
--   >     float                  minInterpolationOffset;
--   >     float                  maxInterpolationOffset;
--   >     uint32_t               subPixelInterpolationOffsetBits;
--   >     uint32_t               maxFramebufferWidth;
--   >     uint32_t               maxFramebufferHeight;
--   >     uint32_t               maxFramebufferLayers;
--   >     VkSampleCountFlags     framebufferColorSampleCounts;
--   >     VkSampleCountFlags     framebufferDepthSampleCounts;
--   >     VkSampleCountFlags     framebufferStencilSampleCounts;
--   >     VkSampleCountFlags     framebufferNoAttachmentsSampleCounts;
--   >     uint32_t               maxColorAttachments;
--   >     VkSampleCountFlags     sampledImageColorSampleCounts;
--   >     VkSampleCountFlags     sampledImageIntegerSampleCounts;
--   >     VkSampleCountFlags     sampledImageDepthSampleCounts;
--   >     VkSampleCountFlags     sampledImageStencilSampleCounts;
--   >     VkSampleCountFlags     storageImageSampleCounts;
--   >     uint32_t               maxSampleMaskWords;
--   >     VkBool32               timestampComputeAndGraphics;
--   >     float                  timestampPeriod;
--   >     uint32_t               maxClipDistances;
--   >     uint32_t               maxCullDistances;
--   >     uint32_t               maxCombinedClipAndCullDistances;
--   >     uint32_t               discreteQueuePriorities;
--   >     float                  pointSizeRange[2];
--   >     float                  lineWidthRange[2];
--   >     float                  pointSizeGranularity;
--   >     float                  lineWidthGranularity;
--   >     VkBool32               strictLines;
--   >     VkBool32               standardSampleLocations;
--   >     VkDeviceSize           optimalBufferCopyOffsetAlignment;
--   >     VkDeviceSize           optimalBufferCopyRowPitchAlignment;
--   >     VkDeviceSize           nonCoherentAtomSize;
--   > } VkPhysicalDeviceLimits;
--
--   <https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VkPhysicalDeviceLimits VkPhysicalDeviceLimits registry at www.khronos.org>
data VkPhysicalDeviceLimits = VkPhysicalDeviceLimits## Addr##
                                                      ByteArray##

instance Eq VkPhysicalDeviceLimits where
        (VkPhysicalDeviceLimits## a _) == x@(VkPhysicalDeviceLimits## b _)
          = EQ == cmpBytes## (sizeOf x) a b

        {-# INLINE (==) #-}

instance Ord VkPhysicalDeviceLimits where
        (VkPhysicalDeviceLimits## a _) `compare`
          x@(VkPhysicalDeviceLimits## b _) = cmpBytes## (sizeOf x) a b

        {-# INLINE compare #-}

instance Storable VkPhysicalDeviceLimits where
        sizeOf ~_ = #{size VkPhysicalDeviceLimits}

        {-# INLINE sizeOf #-}
        alignment ~_ = #{alignment VkPhysicalDeviceLimits}

        {-# INLINE alignment #-}
        peek = peekVkData##

        {-# INLINE peek #-}
        poke = pokeVkData##

        {-# INLINE poke #-}

instance VulkanMarshalPrim VkPhysicalDeviceLimits where
        unsafeAddr (VkPhysicalDeviceLimits## a _) = a

        {-# INLINE unsafeAddr #-}
        unsafeByteArray (VkPhysicalDeviceLimits## _ b) = b

        {-# INLINE unsafeByteArray #-}
        unsafeFromByteArrayOffset off b
          = VkPhysicalDeviceLimits## (plusAddr## (byteArrayContents## b) off) b

        {-# INLINE unsafeFromByteArrayOffset #-}

instance VulkanMarshal VkPhysicalDeviceLimits where
        type StructFields VkPhysicalDeviceLimits =
             '["maxImageDimension1D", "maxImageDimension2D", -- ' closing tick for hsc2hs
               "maxImageDimension3D", "maxImageDimensionCube",
               "maxImageArrayLayers", "maxTexelBufferElements",
               "maxUniformBufferRange", "maxStorageBufferRange",
               "maxPushConstantsSize", "maxMemoryAllocationCount",
               "maxSamplerAllocationCount", "bufferImageGranularity",
               "sparseAddressSpaceSize", "maxBoundDescriptorSets",
               "maxPerStageDescriptorSamplers",
               "maxPerStageDescriptorUniformBuffers",
               "maxPerStageDescriptorStorageBuffers",
               "maxPerStageDescriptorSampledImages",
               "maxPerStageDescriptorStorageImages",
               "maxPerStageDescriptorInputAttachments", "maxPerStageResources",
               "maxDescriptorSetSamplers", "maxDescriptorSetUniformBuffers",
               "maxDescriptorSetUniformBuffersDynamic",
               "maxDescriptorSetStorageBuffers",
               "maxDescriptorSetStorageBuffersDynamic",
               "maxDescriptorSetSampledImages", "maxDescriptorSetStorageImages",
               "maxDescriptorSetInputAttachments", "maxVertexInputAttributes",
               "maxVertexInputBindings", "maxVertexInputAttributeOffset",
               "maxVertexInputBindingStride", "maxVertexOutputComponents",
               "maxTessellationGenerationLevel", "maxTessellationPatchSize",
               "maxTessellationControlPerVertexInputComponents",
               "maxTessellationControlPerVertexOutputComponents",
               "maxTessellationControlPerPatchOutputComponents",
               "maxTessellationControlTotalOutputComponents",
               "maxTessellationEvaluationInputComponents",
               "maxTessellationEvaluationOutputComponents",
               "maxGeometryShaderInvocations", "maxGeometryInputComponents",
               "maxGeometryOutputComponents", "maxGeometryOutputVertices",
               "maxGeometryTotalOutputComponents", "maxFragmentInputComponents",
               "maxFragmentOutputAttachments", "maxFragmentDualSrcAttachments",
               "maxFragmentCombinedOutputResources", "maxComputeSharedMemorySize",
               "maxComputeWorkGroupCount", "maxComputeWorkGroupInvocations",
               "maxComputeWorkGroupSize", "subPixelPrecisionBits",
               "subTexelPrecisionBits", "mipmapPrecisionBits",
               "maxDrawIndexedIndexValue", "maxDrawIndirectCount",
               "maxSamplerLodBias", "maxSamplerAnisotropy", "maxViewports",
               "maxViewportDimensions", "viewportBoundsRange",
               "viewportSubPixelBits", "minMemoryMapAlignment",
               "minTexelBufferOffsetAlignment", "minUniformBufferOffsetAlignment",
               "minStorageBufferOffsetAlignment", "minTexelOffset",
               "maxTexelOffset", "minTexelGatherOffset", "maxTexelGatherOffset",
               "minInterpolationOffset", "maxInterpolationOffset",
               "subPixelInterpolationOffsetBits", "maxFramebufferWidth",
               "maxFramebufferHeight", "maxFramebufferLayers",
               "framebufferColorSampleCounts", "framebufferDepthSampleCounts",
               "framebufferStencilSampleCounts",
               "framebufferNoAttachmentsSampleCounts", "maxColorAttachments",
               "sampledImageColorSampleCounts", "sampledImageIntegerSampleCounts",
               "sampledImageDepthSampleCounts", "sampledImageStencilSampleCounts",
               "storageImageSampleCounts", "maxSampleMaskWords",
               "timestampComputeAndGraphics", "timestampPeriod",
               "maxClipDistances", "maxCullDistances",
               "maxCombinedClipAndCullDistances", "discreteQueuePriorities",
               "pointSizeRange", "lineWidthRange", "pointSizeGranularity",
               "lineWidthGranularity", "strictLines", "standardSampleLocations",
               "optimalBufferCopyOffsetAlignment",
               "optimalBufferCopyRowPitchAlignment", "nonCoherentAtomSize"]
        type CUnionType VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs
        type ReturnedOnly VkPhysicalDeviceLimits = 'True -- ' closing tick for hsc2hs
        type StructExtends VkPhysicalDeviceLimits = '[] -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "maxImageDimension1D" VkPhysicalDeviceLimits where
        type FieldType "maxImageDimension1D" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxImageDimension1D" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxImageDimension1D" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxImageDimension1D}
        type FieldIsArray "maxImageDimension1D" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxImageDimension1D}

instance {-# OVERLAPPING #-}
         CanReadField "maxImageDimension1D" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxImageDimension1D})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxImageDimension1D}

instance {-# OVERLAPPING #-}
         CanWriteField "maxImageDimension1D" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxImageDimension1D}

instance {-# OVERLAPPING #-}
         HasField "maxImageDimension2D" VkPhysicalDeviceLimits where
        type FieldType "maxImageDimension2D" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxImageDimension2D" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxImageDimension2D" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxImageDimension2D}
        type FieldIsArray "maxImageDimension2D" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxImageDimension2D}

instance {-# OVERLAPPING #-}
         CanReadField "maxImageDimension2D" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxImageDimension2D})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxImageDimension2D}

instance {-# OVERLAPPING #-}
         CanWriteField "maxImageDimension2D" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxImageDimension2D}

instance {-# OVERLAPPING #-}
         HasField "maxImageDimension3D" VkPhysicalDeviceLimits where
        type FieldType "maxImageDimension3D" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxImageDimension3D" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxImageDimension3D" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxImageDimension3D}
        type FieldIsArray "maxImageDimension3D" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxImageDimension3D}

instance {-# OVERLAPPING #-}
         CanReadField "maxImageDimension3D" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxImageDimension3D})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxImageDimension3D}

instance {-# OVERLAPPING #-}
         CanWriteField "maxImageDimension3D" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxImageDimension3D}

instance {-# OVERLAPPING #-}
         HasField "maxImageDimensionCube" VkPhysicalDeviceLimits where
        type FieldType "maxImageDimensionCube" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxImageDimensionCube" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxImageDimensionCube" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxImageDimensionCube}
        type FieldIsArray "maxImageDimensionCube" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxImageDimensionCube}

instance {-# OVERLAPPING #-}
         CanReadField "maxImageDimensionCube" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxImageDimensionCube})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxImageDimensionCube}

instance {-# OVERLAPPING #-}
         CanWriteField "maxImageDimensionCube" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxImageDimensionCube}

instance {-# OVERLAPPING #-}
         HasField "maxImageArrayLayers" VkPhysicalDeviceLimits where
        type FieldType "maxImageArrayLayers" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxImageArrayLayers" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxImageArrayLayers" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxImageArrayLayers}
        type FieldIsArray "maxImageArrayLayers" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxImageArrayLayers}

instance {-# OVERLAPPING #-}
         CanReadField "maxImageArrayLayers" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxImageArrayLayers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxImageArrayLayers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxImageArrayLayers" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxImageArrayLayers}

instance {-# OVERLAPPING #-}
         HasField "maxTexelBufferElements" VkPhysicalDeviceLimits where
        type FieldType "maxTexelBufferElements" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxTexelBufferElements" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTexelBufferElements" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxTexelBufferElements}
        type FieldIsArray "maxTexelBufferElements" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTexelBufferElements}

instance {-# OVERLAPPING #-}
         CanReadField "maxTexelBufferElements" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTexelBufferElements})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTexelBufferElements}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTexelBufferElements" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTexelBufferElements}

instance {-# OVERLAPPING #-}
         HasField "maxUniformBufferRange" VkPhysicalDeviceLimits where
        type FieldType "maxUniformBufferRange" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxUniformBufferRange" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxUniformBufferRange" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxUniformBufferRange}
        type FieldIsArray "maxUniformBufferRange" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxUniformBufferRange}

instance {-# OVERLAPPING #-}
         CanReadField "maxUniformBufferRange" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxUniformBufferRange})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxUniformBufferRange}

instance {-# OVERLAPPING #-}
         CanWriteField "maxUniformBufferRange" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxUniformBufferRange}

instance {-# OVERLAPPING #-}
         HasField "maxStorageBufferRange" VkPhysicalDeviceLimits where
        type FieldType "maxStorageBufferRange" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxStorageBufferRange" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxStorageBufferRange" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxStorageBufferRange}
        type FieldIsArray "maxStorageBufferRange" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxStorageBufferRange}

instance {-# OVERLAPPING #-}
         CanReadField "maxStorageBufferRange" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxStorageBufferRange})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxStorageBufferRange}

instance {-# OVERLAPPING #-}
         CanWriteField "maxStorageBufferRange" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxStorageBufferRange}

instance {-# OVERLAPPING #-}
         HasField "maxPushConstantsSize" VkPhysicalDeviceLimits where
        type FieldType "maxPushConstantsSize" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxPushConstantsSize" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPushConstantsSize" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxPushConstantsSize}
        type FieldIsArray "maxPushConstantsSize" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxPushConstantsSize}

instance {-# OVERLAPPING #-}
         CanReadField "maxPushConstantsSize" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxPushConstantsSize})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxPushConstantsSize}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPushConstantsSize" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxPushConstantsSize}

instance {-# OVERLAPPING #-}
         HasField "maxMemoryAllocationCount" VkPhysicalDeviceLimits where
        type FieldType "maxMemoryAllocationCount" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxMemoryAllocationCount"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxMemoryAllocationCount" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxMemoryAllocationCount}
        type FieldIsArray "maxMemoryAllocationCount" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxMemoryAllocationCount}

instance {-# OVERLAPPING #-}
         CanReadField "maxMemoryAllocationCount" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxMemoryAllocationCount})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxMemoryAllocationCount}

instance {-# OVERLAPPING #-}
         CanWriteField "maxMemoryAllocationCount" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxMemoryAllocationCount}

instance {-# OVERLAPPING #-}
         HasField "maxSamplerAllocationCount" VkPhysicalDeviceLimits where
        type FieldType "maxSamplerAllocationCount" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxSamplerAllocationCount"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxSamplerAllocationCount" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxSamplerAllocationCount}
        type FieldIsArray "maxSamplerAllocationCount"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxSamplerAllocationCount}

instance {-# OVERLAPPING #-}
         CanReadField "maxSamplerAllocationCount" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxSamplerAllocationCount})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxSamplerAllocationCount}

instance {-# OVERLAPPING #-}
         CanWriteField "maxSamplerAllocationCount" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxSamplerAllocationCount}

instance {-# OVERLAPPING #-}
         HasField "bufferImageGranularity" VkPhysicalDeviceLimits where
        type FieldType "bufferImageGranularity" VkPhysicalDeviceLimits =
             VkDeviceSize
        type FieldOptional "bufferImageGranularity" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "bufferImageGranularity" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, bufferImageGranularity}
        type FieldIsArray "bufferImageGranularity" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, bufferImageGranularity}

instance {-# OVERLAPPING #-}
         CanReadField "bufferImageGranularity" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, bufferImageGranularity})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, bufferImageGranularity}

instance {-# OVERLAPPING #-}
         CanWriteField "bufferImageGranularity" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, bufferImageGranularity}

instance {-# OVERLAPPING #-}
         HasField "sparseAddressSpaceSize" VkPhysicalDeviceLimits where
        type FieldType "sparseAddressSpaceSize" VkPhysicalDeviceLimits =
             VkDeviceSize
        type FieldOptional "sparseAddressSpaceSize" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "sparseAddressSpaceSize" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, sparseAddressSpaceSize}
        type FieldIsArray "sparseAddressSpaceSize" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, sparseAddressSpaceSize}

instance {-# OVERLAPPING #-}
         CanReadField "sparseAddressSpaceSize" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, sparseAddressSpaceSize})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, sparseAddressSpaceSize}

instance {-# OVERLAPPING #-}
         CanWriteField "sparseAddressSpaceSize" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, sparseAddressSpaceSize}

instance {-# OVERLAPPING #-}
         HasField "maxBoundDescriptorSets" VkPhysicalDeviceLimits where
        type FieldType "maxBoundDescriptorSets" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxBoundDescriptorSets" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxBoundDescriptorSets" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxBoundDescriptorSets}
        type FieldIsArray "maxBoundDescriptorSets" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxBoundDescriptorSets}

instance {-# OVERLAPPING #-}
         CanReadField "maxBoundDescriptorSets" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxBoundDescriptorSets})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxBoundDescriptorSets}

instance {-# OVERLAPPING #-}
         CanWriteField "maxBoundDescriptorSets" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxBoundDescriptorSets}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorSamplers" VkPhysicalDeviceLimits
         where
        type FieldType "maxPerStageDescriptorSamplers"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxPerStageDescriptorSamplers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageDescriptorSamplers"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSamplers}
        type FieldIsArray "maxPerStageDescriptorSamplers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSamplers}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorSamplers" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSamplers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSamplers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorSamplers"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSamplers}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorUniformBuffers"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxPerStageDescriptorUniformBuffers"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxPerStageDescriptorUniformBuffers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageDescriptorUniformBuffers"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorUniformBuffers}
        type FieldIsArray "maxPerStageDescriptorUniformBuffers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorUniformBuffers}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorUniformBuffers"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorUniformBuffers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorUniformBuffers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorUniformBuffers"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorUniformBuffers}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorStorageBuffers"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxPerStageDescriptorStorageBuffers"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxPerStageDescriptorStorageBuffers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageDescriptorStorageBuffers"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageBuffers}
        type FieldIsArray "maxPerStageDescriptorStorageBuffers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageBuffers}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorStorageBuffers"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageBuffers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageBuffers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorStorageBuffers"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageBuffers}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorSampledImages"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxPerStageDescriptorSampledImages"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxPerStageDescriptorSampledImages"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageDescriptorSampledImages"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSampledImages}
        type FieldIsArray "maxPerStageDescriptorSampledImages"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSampledImages}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorSampledImages"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSampledImages})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSampledImages}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorSampledImages"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorSampledImages}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorStorageImages"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxPerStageDescriptorStorageImages"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxPerStageDescriptorStorageImages"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageDescriptorStorageImages"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageImages}
        type FieldIsArray "maxPerStageDescriptorStorageImages"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageImages}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorStorageImages"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageImages})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageImages}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorStorageImages"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorStorageImages}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageDescriptorInputAttachments"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxPerStageDescriptorInputAttachments"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxPerStageDescriptorInputAttachments"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageDescriptorInputAttachments"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorInputAttachments}
        type FieldIsArray "maxPerStageDescriptorInputAttachments"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorInputAttachments}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageDescriptorInputAttachments"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorInputAttachments})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorInputAttachments}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageDescriptorInputAttachments"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageDescriptorInputAttachments}

instance {-# OVERLAPPING #-}
         HasField "maxPerStageResources" VkPhysicalDeviceLimits where
        type FieldType "maxPerStageResources" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxPerStageResources" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxPerStageResources" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxPerStageResources}
        type FieldIsArray "maxPerStageResources" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxPerStageResources}

instance {-# OVERLAPPING #-}
         CanReadField "maxPerStageResources" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxPerStageResources})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageResources}

instance {-# OVERLAPPING #-}
         CanWriteField "maxPerStageResources" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxPerStageResources}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetSamplers" VkPhysicalDeviceLimits where
        type FieldType "maxDescriptorSetSamplers" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxDescriptorSetSamplers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetSamplers" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDescriptorSetSamplers}
        type FieldIsArray "maxDescriptorSetSamplers" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDescriptorSetSamplers}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetSamplers" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDescriptorSetSamplers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetSamplers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetSamplers" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetSamplers}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUniformBuffers" VkPhysicalDeviceLimits
         where
        type FieldType "maxDescriptorSetUniformBuffers"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxDescriptorSetUniformBuffers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetUniformBuffers"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffers}
        type FieldIsArray "maxDescriptorSetUniformBuffers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffers}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUniformBuffers"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetUniformBuffers"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffers}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetUniformBuffersDynamic"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxDescriptorSetUniformBuffersDynamic"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxDescriptorSetUniformBuffersDynamic"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetUniformBuffersDynamic"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffersDynamic}
        type FieldIsArray "maxDescriptorSetUniformBuffersDynamic"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffersDynamic}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetUniformBuffersDynamic"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffersDynamic})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffersDynamic}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetUniformBuffersDynamic"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffersDynamic}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetStorageBuffers" VkPhysicalDeviceLimits
         where
        type FieldType "maxDescriptorSetStorageBuffers"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxDescriptorSetStorageBuffers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetStorageBuffers"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffers}
        type FieldIsArray "maxDescriptorSetStorageBuffers"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffers}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetStorageBuffers"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetStorageBuffers"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffers}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetStorageBuffersDynamic"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxDescriptorSetStorageBuffersDynamic"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxDescriptorSetStorageBuffersDynamic"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetStorageBuffersDynamic"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffersDynamic}
        type FieldIsArray "maxDescriptorSetStorageBuffersDynamic"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffersDynamic}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetStorageBuffersDynamic"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffersDynamic})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffersDynamic}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetStorageBuffersDynamic"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffersDynamic}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetSampledImages" VkPhysicalDeviceLimits
         where
        type FieldType "maxDescriptorSetSampledImages"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxDescriptorSetSampledImages"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetSampledImages"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDescriptorSetSampledImages}
        type FieldIsArray "maxDescriptorSetSampledImages"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDescriptorSetSampledImages}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetSampledImages" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDescriptorSetSampledImages})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetSampledImages}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetSampledImages"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetSampledImages}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetStorageImages" VkPhysicalDeviceLimits
         where
        type FieldType "maxDescriptorSetStorageImages"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxDescriptorSetStorageImages"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetStorageImages"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageImages}
        type FieldIsArray "maxDescriptorSetStorageImages"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageImages}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetStorageImages" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageImages})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageImages}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetStorageImages"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetStorageImages}

instance {-# OVERLAPPING #-}
         HasField "maxDescriptorSetInputAttachments" VkPhysicalDeviceLimits
         where
        type FieldType "maxDescriptorSetInputAttachments"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxDescriptorSetInputAttachments"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDescriptorSetInputAttachments"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDescriptorSetInputAttachments}
        type FieldIsArray "maxDescriptorSetInputAttachments"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDescriptorSetInputAttachments}

instance {-# OVERLAPPING #-}
         CanReadField "maxDescriptorSetInputAttachments"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDescriptorSetInputAttachments})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetInputAttachments}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDescriptorSetInputAttachments"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDescriptorSetInputAttachments}

instance {-# OVERLAPPING #-}
         HasField "maxVertexInputAttributes" VkPhysicalDeviceLimits where
        type FieldType "maxVertexInputAttributes" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxVertexInputAttributes"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxVertexInputAttributes" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxVertexInputAttributes}
        type FieldIsArray "maxVertexInputAttributes" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxVertexInputAttributes}

instance {-# OVERLAPPING #-}
         CanReadField "maxVertexInputAttributes" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxVertexInputAttributes})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxVertexInputAttributes}

instance {-# OVERLAPPING #-}
         CanWriteField "maxVertexInputAttributes" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxVertexInputAttributes}

instance {-# OVERLAPPING #-}
         HasField "maxVertexInputBindings" VkPhysicalDeviceLimits where
        type FieldType "maxVertexInputBindings" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxVertexInputBindings" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxVertexInputBindings" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxVertexInputBindings}
        type FieldIsArray "maxVertexInputBindings" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxVertexInputBindings}

instance {-# OVERLAPPING #-}
         CanReadField "maxVertexInputBindings" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxVertexInputBindings})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxVertexInputBindings}

instance {-# OVERLAPPING #-}
         CanWriteField "maxVertexInputBindings" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxVertexInputBindings}

instance {-# OVERLAPPING #-}
         HasField "maxVertexInputAttributeOffset" VkPhysicalDeviceLimits
         where
        type FieldType "maxVertexInputAttributeOffset"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxVertexInputAttributeOffset"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxVertexInputAttributeOffset"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxVertexInputAttributeOffset}
        type FieldIsArray "maxVertexInputAttributeOffset"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxVertexInputAttributeOffset}

instance {-# OVERLAPPING #-}
         CanReadField "maxVertexInputAttributeOffset" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxVertexInputAttributeOffset})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxVertexInputAttributeOffset}

instance {-# OVERLAPPING #-}
         CanWriteField "maxVertexInputAttributeOffset"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxVertexInputAttributeOffset}

instance {-# OVERLAPPING #-}
         HasField "maxVertexInputBindingStride" VkPhysicalDeviceLimits where
        type FieldType "maxVertexInputBindingStride" VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxVertexInputBindingStride"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxVertexInputBindingStride"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxVertexInputBindingStride}
        type FieldIsArray "maxVertexInputBindingStride"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxVertexInputBindingStride}

instance {-# OVERLAPPING #-}
         CanReadField "maxVertexInputBindingStride" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxVertexInputBindingStride})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxVertexInputBindingStride}

instance {-# OVERLAPPING #-}
         CanWriteField "maxVertexInputBindingStride" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxVertexInputBindingStride}

instance {-# OVERLAPPING #-}
         HasField "maxVertexOutputComponents" VkPhysicalDeviceLimits where
        type FieldType "maxVertexOutputComponents" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxVertexOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxVertexOutputComponents" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxVertexOutputComponents}
        type FieldIsArray "maxVertexOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxVertexOutputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxVertexOutputComponents" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxVertexOutputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxVertexOutputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxVertexOutputComponents" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxVertexOutputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxTessellationGenerationLevel" VkPhysicalDeviceLimits
         where
        type FieldType "maxTessellationGenerationLevel"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxTessellationGenerationLevel"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTessellationGenerationLevel"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxTessellationGenerationLevel}
        type FieldIsArray "maxTessellationGenerationLevel"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTessellationGenerationLevel}

instance {-# OVERLAPPING #-}
         CanReadField "maxTessellationGenerationLevel"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTessellationGenerationLevel})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationGenerationLevel}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTessellationGenerationLevel"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationGenerationLevel}

instance {-# OVERLAPPING #-}
         HasField "maxTessellationPatchSize" VkPhysicalDeviceLimits where
        type FieldType "maxTessellationPatchSize" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxTessellationPatchSize"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTessellationPatchSize" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxTessellationPatchSize}
        type FieldIsArray "maxTessellationPatchSize" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTessellationPatchSize}

instance {-# OVERLAPPING #-}
         CanReadField "maxTessellationPatchSize" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTessellationPatchSize})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationPatchSize}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTessellationPatchSize" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationPatchSize}

instance {-# OVERLAPPING #-}
         HasField "maxTessellationControlPerVertexInputComponents"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxTessellationControlPerVertexInputComponents"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxTessellationControlPerVertexInputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTessellationControlPerVertexInputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexInputComponents}
        type FieldIsArray "maxTessellationControlPerVertexInputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexInputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxTessellationControlPerVertexInputComponents"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexInputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexInputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTessellationControlPerVertexInputComponents"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexInputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxTessellationControlPerVertexOutputComponents"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxTessellationControlPerVertexOutputComponents"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional
               "maxTessellationControlPerVertexOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTessellationControlPerVertexOutputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexOutputComponents}
        type FieldIsArray "maxTessellationControlPerVertexOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexOutputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxTessellationControlPerVertexOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexOutputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexOutputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTessellationControlPerVertexOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationControlPerVertexOutputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxTessellationControlPerPatchOutputComponents"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxTessellationControlPerPatchOutputComponents"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxTessellationControlPerPatchOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTessellationControlPerPatchOutputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxTessellationControlPerPatchOutputComponents}
        type FieldIsArray "maxTessellationControlPerPatchOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTessellationControlPerPatchOutputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxTessellationControlPerPatchOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTessellationControlPerPatchOutputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationControlPerPatchOutputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTessellationControlPerPatchOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationControlPerPatchOutputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxTessellationControlTotalOutputComponents"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxTessellationControlTotalOutputComponents"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxTessellationControlTotalOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTessellationControlTotalOutputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxTessellationControlTotalOutputComponents}
        type FieldIsArray "maxTessellationControlTotalOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTessellationControlTotalOutputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxTessellationControlTotalOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTessellationControlTotalOutputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationControlTotalOutputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTessellationControlTotalOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationControlTotalOutputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxTessellationEvaluationInputComponents"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxTessellationEvaluationInputComponents"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxTessellationEvaluationInputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTessellationEvaluationInputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationInputComponents}
        type FieldIsArray "maxTessellationEvaluationInputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationInputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxTessellationEvaluationInputComponents"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationInputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationInputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTessellationEvaluationInputComponents"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationInputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxTessellationEvaluationOutputComponents"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxTessellationEvaluationOutputComponents"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxTessellationEvaluationOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTessellationEvaluationOutputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationOutputComponents}
        type FieldIsArray "maxTessellationEvaluationOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationOutputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxTessellationEvaluationOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationOutputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationOutputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTessellationEvaluationOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTessellationEvaluationOutputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxGeometryShaderInvocations" VkPhysicalDeviceLimits
         where
        type FieldType "maxGeometryShaderInvocations"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxGeometryShaderInvocations"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxGeometryShaderInvocations"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxGeometryShaderInvocations}
        type FieldIsArray "maxGeometryShaderInvocations"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxGeometryShaderInvocations}

instance {-# OVERLAPPING #-}
         CanReadField "maxGeometryShaderInvocations" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxGeometryShaderInvocations})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryShaderInvocations}

instance {-# OVERLAPPING #-}
         CanWriteField "maxGeometryShaderInvocations" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryShaderInvocations}

instance {-# OVERLAPPING #-}
         HasField "maxGeometryInputComponents" VkPhysicalDeviceLimits where
        type FieldType "maxGeometryInputComponents" VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxGeometryInputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxGeometryInputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxGeometryInputComponents}
        type FieldIsArray "maxGeometryInputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxGeometryInputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxGeometryInputComponents" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxGeometryInputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryInputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxGeometryInputComponents" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryInputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxGeometryOutputComponents" VkPhysicalDeviceLimits where
        type FieldType "maxGeometryOutputComponents" VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxGeometryOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxGeometryOutputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxGeometryOutputComponents}
        type FieldIsArray "maxGeometryOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxGeometryOutputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxGeometryOutputComponents" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxGeometryOutputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryOutputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxGeometryOutputComponents" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryOutputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxGeometryOutputVertices" VkPhysicalDeviceLimits where
        type FieldType "maxGeometryOutputVertices" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxGeometryOutputVertices"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxGeometryOutputVertices" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxGeometryOutputVertices}
        type FieldIsArray "maxGeometryOutputVertices"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxGeometryOutputVertices}

instance {-# OVERLAPPING #-}
         CanReadField "maxGeometryOutputVertices" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxGeometryOutputVertices})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryOutputVertices}

instance {-# OVERLAPPING #-}
         CanWriteField "maxGeometryOutputVertices" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryOutputVertices}

instance {-# OVERLAPPING #-}
         HasField "maxGeometryTotalOutputComponents" VkPhysicalDeviceLimits
         where
        type FieldType "maxGeometryTotalOutputComponents"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxGeometryTotalOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxGeometryTotalOutputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxGeometryTotalOutputComponents}
        type FieldIsArray "maxGeometryTotalOutputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxGeometryTotalOutputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxGeometryTotalOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxGeometryTotalOutputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryTotalOutputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxGeometryTotalOutputComponents"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxGeometryTotalOutputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxFragmentInputComponents" VkPhysicalDeviceLimits where
        type FieldType "maxFragmentInputComponents" VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxFragmentInputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxFragmentInputComponents"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxFragmentInputComponents}
        type FieldIsArray "maxFragmentInputComponents"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxFragmentInputComponents}

instance {-# OVERLAPPING #-}
         CanReadField "maxFragmentInputComponents" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxFragmentInputComponents})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxFragmentInputComponents}

instance {-# OVERLAPPING #-}
         CanWriteField "maxFragmentInputComponents" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxFragmentInputComponents}

instance {-# OVERLAPPING #-}
         HasField "maxFragmentOutputAttachments" VkPhysicalDeviceLimits
         where
        type FieldType "maxFragmentOutputAttachments"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxFragmentOutputAttachments"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxFragmentOutputAttachments"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxFragmentOutputAttachments}
        type FieldIsArray "maxFragmentOutputAttachments"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxFragmentOutputAttachments}

instance {-# OVERLAPPING #-}
         CanReadField "maxFragmentOutputAttachments" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxFragmentOutputAttachments})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxFragmentOutputAttachments}

instance {-# OVERLAPPING #-}
         CanWriteField "maxFragmentOutputAttachments" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxFragmentOutputAttachments}

instance {-# OVERLAPPING #-}
         HasField "maxFragmentDualSrcAttachments" VkPhysicalDeviceLimits
         where
        type FieldType "maxFragmentDualSrcAttachments"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxFragmentDualSrcAttachments"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxFragmentDualSrcAttachments"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxFragmentDualSrcAttachments}
        type FieldIsArray "maxFragmentDualSrcAttachments"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxFragmentDualSrcAttachments}

instance {-# OVERLAPPING #-}
         CanReadField "maxFragmentDualSrcAttachments" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxFragmentDualSrcAttachments})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxFragmentDualSrcAttachments}

instance {-# OVERLAPPING #-}
         CanWriteField "maxFragmentDualSrcAttachments"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxFragmentDualSrcAttachments}

instance {-# OVERLAPPING #-}
         HasField "maxFragmentCombinedOutputResources"
           VkPhysicalDeviceLimits
         where
        type FieldType "maxFragmentCombinedOutputResources"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxFragmentCombinedOutputResources"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxFragmentCombinedOutputResources"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxFragmentCombinedOutputResources}
        type FieldIsArray "maxFragmentCombinedOutputResources"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxFragmentCombinedOutputResources}

instance {-# OVERLAPPING #-}
         CanReadField "maxFragmentCombinedOutputResources"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxFragmentCombinedOutputResources})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxFragmentCombinedOutputResources}

instance {-# OVERLAPPING #-}
         CanWriteField "maxFragmentCombinedOutputResources"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxFragmentCombinedOutputResources}

instance {-# OVERLAPPING #-}
         HasField "maxComputeSharedMemorySize" VkPhysicalDeviceLimits where
        type FieldType "maxComputeSharedMemorySize" VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxComputeSharedMemorySize"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxComputeSharedMemorySize"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxComputeSharedMemorySize}
        type FieldIsArray "maxComputeSharedMemorySize"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxComputeSharedMemorySize}

instance {-# OVERLAPPING #-}
         CanReadField "maxComputeSharedMemorySize" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxComputeSharedMemorySize})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxComputeSharedMemorySize}

instance {-# OVERLAPPING #-}
         CanWriteField "maxComputeSharedMemorySize" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxComputeSharedMemorySize}

instance {-# OVERLAPPING #-}
         HasField "maxComputeWorkGroupCount" VkPhysicalDeviceLimits where
        type FieldType "maxComputeWorkGroupCount" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxComputeWorkGroupCount"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxComputeWorkGroupCount" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupCount}
        type FieldIsArray "maxComputeWorkGroupCount" VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupCount}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "maxComputeWorkGroupCount" idx
            VkPhysicalDeviceLimits) =>
         CanReadFieldArray "maxComputeWorkGroupCount" idx
           VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "maxComputeWorkGroupCount" 0
                         VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "maxComputeWorkGroupCount" 1
                         VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "maxComputeWorkGroupCount" 2
                         VkPhysicalDeviceLimits
                       #-}
        type FieldArrayLength "maxComputeWorkGroupCount"
               VkPhysicalDeviceLimits
             = 3

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = 3

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupCount}
                      +
                      sizeOf (undefined :: Word32) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceLimits, maxComputeWorkGroupCount}
                 +
                 sizeOf (undefined :: Word32) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "maxComputeWorkGroupCount" idx
            VkPhysicalDeviceLimits) =>
         CanWriteFieldArray "maxComputeWorkGroupCount" idx
           VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "maxComputeWorkGroupCount" 0
                         VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "maxComputeWorkGroupCount" 1
                         VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "maxComputeWorkGroupCount" 2
                         VkPhysicalDeviceLimits
                       #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceLimits, maxComputeWorkGroupCount}
                 +
                 sizeOf (undefined :: Word32) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "maxComputeWorkGroupInvocations" VkPhysicalDeviceLimits
         where
        type FieldType "maxComputeWorkGroupInvocations"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxComputeWorkGroupInvocations"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxComputeWorkGroupInvocations"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupInvocations}
        type FieldIsArray "maxComputeWorkGroupInvocations"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupInvocations}

instance {-# OVERLAPPING #-}
         CanReadField "maxComputeWorkGroupInvocations"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupInvocations})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupInvocations}

instance {-# OVERLAPPING #-}
         CanWriteField "maxComputeWorkGroupInvocations"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupInvocations}

instance {-# OVERLAPPING #-}
         HasField "maxComputeWorkGroupSize" VkPhysicalDeviceLimits where
        type FieldType "maxComputeWorkGroupSize" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxComputeWorkGroupSize" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxComputeWorkGroupSize" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupSize}
        type FieldIsArray "maxComputeWorkGroupSize" VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupSize}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "maxComputeWorkGroupSize" idx
            VkPhysicalDeviceLimits) =>
         CanReadFieldArray "maxComputeWorkGroupSize" idx
           VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "maxComputeWorkGroupSize" 0
                         VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "maxComputeWorkGroupSize" 1
                         VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "maxComputeWorkGroupSize" 2
                         VkPhysicalDeviceLimits
                       #-}
        type FieldArrayLength "maxComputeWorkGroupSize"
               VkPhysicalDeviceLimits
             = 3

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = 3

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceLimits, maxComputeWorkGroupSize}
                      +
                      sizeOf (undefined :: Word32) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceLimits, maxComputeWorkGroupSize}
                 +
                 sizeOf (undefined :: Word32) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "maxComputeWorkGroupSize" idx
            VkPhysicalDeviceLimits) =>
         CanWriteFieldArray "maxComputeWorkGroupSize" idx
           VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "maxComputeWorkGroupSize" 0
                         VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "maxComputeWorkGroupSize" 1
                         VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "maxComputeWorkGroupSize" 2
                         VkPhysicalDeviceLimits
                       #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceLimits, maxComputeWorkGroupSize}
                 +
                 sizeOf (undefined :: Word32) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "subPixelPrecisionBits" VkPhysicalDeviceLimits where
        type FieldType "subPixelPrecisionBits" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "subPixelPrecisionBits" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "subPixelPrecisionBits" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, subPixelPrecisionBits}
        type FieldIsArray "subPixelPrecisionBits" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, subPixelPrecisionBits}

instance {-# OVERLAPPING #-}
         CanReadField "subPixelPrecisionBits" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, subPixelPrecisionBits})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, subPixelPrecisionBits}

instance {-# OVERLAPPING #-}
         CanWriteField "subPixelPrecisionBits" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, subPixelPrecisionBits}

instance {-# OVERLAPPING #-}
         HasField "subTexelPrecisionBits" VkPhysicalDeviceLimits where
        type FieldType "subTexelPrecisionBits" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "subTexelPrecisionBits" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "subTexelPrecisionBits" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, subTexelPrecisionBits}
        type FieldIsArray "subTexelPrecisionBits" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, subTexelPrecisionBits}

instance {-# OVERLAPPING #-}
         CanReadField "subTexelPrecisionBits" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, subTexelPrecisionBits})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, subTexelPrecisionBits}

instance {-# OVERLAPPING #-}
         CanWriteField "subTexelPrecisionBits" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, subTexelPrecisionBits}

instance {-# OVERLAPPING #-}
         HasField "mipmapPrecisionBits" VkPhysicalDeviceLimits where
        type FieldType "mipmapPrecisionBits" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "mipmapPrecisionBits" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "mipmapPrecisionBits" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, mipmapPrecisionBits}
        type FieldIsArray "mipmapPrecisionBits" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, mipmapPrecisionBits}

instance {-# OVERLAPPING #-}
         CanReadField "mipmapPrecisionBits" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, mipmapPrecisionBits})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, mipmapPrecisionBits}

instance {-# OVERLAPPING #-}
         CanWriteField "mipmapPrecisionBits" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, mipmapPrecisionBits}

instance {-# OVERLAPPING #-}
         HasField "maxDrawIndexedIndexValue" VkPhysicalDeviceLimits where
        type FieldType "maxDrawIndexedIndexValue" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxDrawIndexedIndexValue"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDrawIndexedIndexValue" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxDrawIndexedIndexValue}
        type FieldIsArray "maxDrawIndexedIndexValue" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDrawIndexedIndexValue}

instance {-# OVERLAPPING #-}
         CanReadField "maxDrawIndexedIndexValue" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDrawIndexedIndexValue})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDrawIndexedIndexValue}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDrawIndexedIndexValue" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDrawIndexedIndexValue}

instance {-# OVERLAPPING #-}
         HasField "maxDrawIndirectCount" VkPhysicalDeviceLimits where
        type FieldType "maxDrawIndirectCount" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxDrawIndirectCount" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxDrawIndirectCount" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxDrawIndirectCount}
        type FieldIsArray "maxDrawIndirectCount" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxDrawIndirectCount}

instance {-# OVERLAPPING #-}
         CanReadField "maxDrawIndirectCount" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxDrawIndirectCount})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxDrawIndirectCount}

instance {-# OVERLAPPING #-}
         CanWriteField "maxDrawIndirectCount" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxDrawIndirectCount}

instance {-# OVERLAPPING #-}
         HasField "maxSamplerLodBias" VkPhysicalDeviceLimits where
        type FieldType "maxSamplerLodBias" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "maxSamplerLodBias" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxSamplerLodBias" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxSamplerLodBias}
        type FieldIsArray "maxSamplerLodBias" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxSamplerLodBias}

instance {-# OVERLAPPING #-}
         CanReadField "maxSamplerLodBias" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxSamplerLodBias})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxSamplerLodBias}

instance {-# OVERLAPPING #-}
         CanWriteField "maxSamplerLodBias" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxSamplerLodBias}

instance {-# OVERLAPPING #-}
         HasField "maxSamplerAnisotropy" VkPhysicalDeviceLimits where
        type FieldType "maxSamplerAnisotropy" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "maxSamplerAnisotropy" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxSamplerAnisotropy" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxSamplerAnisotropy}
        type FieldIsArray "maxSamplerAnisotropy" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxSamplerAnisotropy}

instance {-# OVERLAPPING #-}
         CanReadField "maxSamplerAnisotropy" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxSamplerAnisotropy})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxSamplerAnisotropy}

instance {-# OVERLAPPING #-}
         CanWriteField "maxSamplerAnisotropy" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxSamplerAnisotropy}

instance {-# OVERLAPPING #-}
         HasField "maxViewports" VkPhysicalDeviceLimits where
        type FieldType "maxViewports" VkPhysicalDeviceLimits = Word32
        type FieldOptional "maxViewports" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxViewports" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxViewports}
        type FieldIsArray "maxViewports" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxViewports}

instance {-# OVERLAPPING #-}
         CanReadField "maxViewports" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxViewports})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxViewports}

instance {-# OVERLAPPING #-}
         CanWriteField "maxViewports" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxViewports}

instance {-# OVERLAPPING #-}
         HasField "maxViewportDimensions" VkPhysicalDeviceLimits where
        type FieldType "maxViewportDimensions" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxViewportDimensions" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxViewportDimensions" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxViewportDimensions}
        type FieldIsArray "maxViewportDimensions" VkPhysicalDeviceLimits =
             'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxViewportDimensions}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "maxViewportDimensions" idx
            VkPhysicalDeviceLimits) =>
         CanReadFieldArray "maxViewportDimensions" idx
           VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "maxViewportDimensions" 0 VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "maxViewportDimensions" 1 VkPhysicalDeviceLimits
                       #-}
        type FieldArrayLength "maxViewportDimensions"
               VkPhysicalDeviceLimits
             = 2

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = 2

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceLimits, maxViewportDimensions}
                      +
                      sizeOf (undefined :: Word32) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceLimits, maxViewportDimensions}
                 +
                 sizeOf (undefined :: Word32) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "maxViewportDimensions" idx
            VkPhysicalDeviceLimits) =>
         CanWriteFieldArray "maxViewportDimensions" idx
           VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "maxViewportDimensions" 0 VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "maxViewportDimensions" 1 VkPhysicalDeviceLimits
                       #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceLimits, maxViewportDimensions}
                 +
                 sizeOf (undefined :: Word32) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "viewportBoundsRange" VkPhysicalDeviceLimits where
        type FieldType "viewportBoundsRange" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "viewportBoundsRange" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "viewportBoundsRange" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, viewportBoundsRange}
        type FieldIsArray "viewportBoundsRange" VkPhysicalDeviceLimits =
             'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, viewportBoundsRange}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "viewportBoundsRange" idx VkPhysicalDeviceLimits) =>
         CanReadFieldArray "viewportBoundsRange" idx VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "viewportBoundsRange" 0 VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "viewportBoundsRange" 1 VkPhysicalDeviceLimits
                       #-}
        type FieldArrayLength "viewportBoundsRange" VkPhysicalDeviceLimits
             = 2

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = 2

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceLimits, viewportBoundsRange}
                      +
                      sizeOf (undefined :: #{type float}) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceLimits, viewportBoundsRange}
                 +
                 sizeOf (undefined :: #{type float}) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "viewportBoundsRange" idx VkPhysicalDeviceLimits) =>
         CanWriteFieldArray "viewportBoundsRange" idx VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "viewportBoundsRange" 0 VkPhysicalDeviceLimits
                       #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "viewportBoundsRange" 1 VkPhysicalDeviceLimits
                       #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceLimits, viewportBoundsRange}
                 +
                 sizeOf (undefined :: #{type float}) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "viewportSubPixelBits" VkPhysicalDeviceLimits where
        type FieldType "viewportSubPixelBits" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "viewportSubPixelBits" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "viewportSubPixelBits" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, viewportSubPixelBits}
        type FieldIsArray "viewportSubPixelBits" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, viewportSubPixelBits}

instance {-# OVERLAPPING #-}
         CanReadField "viewportSubPixelBits" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, viewportSubPixelBits})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, viewportSubPixelBits}

instance {-# OVERLAPPING #-}
         CanWriteField "viewportSubPixelBits" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, viewportSubPixelBits}

instance {-# OVERLAPPING #-}
         HasField "minMemoryMapAlignment" VkPhysicalDeviceLimits where
        type FieldType "minMemoryMapAlignment" VkPhysicalDeviceLimits =
             CSize
        type FieldOptional "minMemoryMapAlignment" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "minMemoryMapAlignment" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, minMemoryMapAlignment}
        type FieldIsArray "minMemoryMapAlignment" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, minMemoryMapAlignment}

instance {-# OVERLAPPING #-}
         CanReadField "minMemoryMapAlignment" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, minMemoryMapAlignment})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, minMemoryMapAlignment}

instance {-# OVERLAPPING #-}
         CanWriteField "minMemoryMapAlignment" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, minMemoryMapAlignment}

instance {-# OVERLAPPING #-}
         HasField "minTexelBufferOffsetAlignment" VkPhysicalDeviceLimits
         where
        type FieldType "minTexelBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = VkDeviceSize
        type FieldOptional "minTexelBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "minTexelBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, minTexelBufferOffsetAlignment}
        type FieldIsArray "minTexelBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, minTexelBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         CanReadField "minTexelBufferOffsetAlignment" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, minTexelBufferOffsetAlignment})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, minTexelBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         CanWriteField "minTexelBufferOffsetAlignment"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, minTexelBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         HasField "minUniformBufferOffsetAlignment" VkPhysicalDeviceLimits
         where
        type FieldType "minUniformBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = VkDeviceSize
        type FieldOptional "minUniformBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "minUniformBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, minUniformBufferOffsetAlignment}
        type FieldIsArray "minUniformBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, minUniformBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         CanReadField "minUniformBufferOffsetAlignment"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, minUniformBufferOffsetAlignment})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, minUniformBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         CanWriteField "minUniformBufferOffsetAlignment"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, minUniformBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         HasField "minStorageBufferOffsetAlignment" VkPhysicalDeviceLimits
         where
        type FieldType "minStorageBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = VkDeviceSize
        type FieldOptional "minStorageBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "minStorageBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, minStorageBufferOffsetAlignment}
        type FieldIsArray "minStorageBufferOffsetAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, minStorageBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         CanReadField "minStorageBufferOffsetAlignment"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, minStorageBufferOffsetAlignment})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, minStorageBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         CanWriteField "minStorageBufferOffsetAlignment"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, minStorageBufferOffsetAlignment}

instance {-# OVERLAPPING #-}
         HasField "minTexelOffset" VkPhysicalDeviceLimits where
        type FieldType "minTexelOffset" VkPhysicalDeviceLimits = Int32
        type FieldOptional "minTexelOffset" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs
        type FieldOffset "minTexelOffset" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, minTexelOffset}
        type FieldIsArray "minTexelOffset" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, minTexelOffset}

instance {-# OVERLAPPING #-}
         CanReadField "minTexelOffset" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, minTexelOffset})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, minTexelOffset}

instance {-# OVERLAPPING #-}
         CanWriteField "minTexelOffset" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, minTexelOffset}

instance {-# OVERLAPPING #-}
         HasField "maxTexelOffset" VkPhysicalDeviceLimits where
        type FieldType "maxTexelOffset" VkPhysicalDeviceLimits = Word32
        type FieldOptional "maxTexelOffset" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTexelOffset" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxTexelOffset}
        type FieldIsArray "maxTexelOffset" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTexelOffset}

instance {-# OVERLAPPING #-}
         CanReadField "maxTexelOffset" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTexelOffset})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTexelOffset}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTexelOffset" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTexelOffset}

instance {-# OVERLAPPING #-}
         HasField "minTexelGatherOffset" VkPhysicalDeviceLimits where
        type FieldType "minTexelGatherOffset" VkPhysicalDeviceLimits =
             Int32
        type FieldOptional "minTexelGatherOffset" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "minTexelGatherOffset" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, minTexelGatherOffset}
        type FieldIsArray "minTexelGatherOffset" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, minTexelGatherOffset}

instance {-# OVERLAPPING #-}
         CanReadField "minTexelGatherOffset" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, minTexelGatherOffset})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, minTexelGatherOffset}

instance {-# OVERLAPPING #-}
         CanWriteField "minTexelGatherOffset" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, minTexelGatherOffset}

instance {-# OVERLAPPING #-}
         HasField "maxTexelGatherOffset" VkPhysicalDeviceLimits where
        type FieldType "maxTexelGatherOffset" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxTexelGatherOffset" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxTexelGatherOffset" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxTexelGatherOffset}
        type FieldIsArray "maxTexelGatherOffset" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxTexelGatherOffset}

instance {-# OVERLAPPING #-}
         CanReadField "maxTexelGatherOffset" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxTexelGatherOffset})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxTexelGatherOffset}

instance {-# OVERLAPPING #-}
         CanWriteField "maxTexelGatherOffset" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxTexelGatherOffset}

instance {-# OVERLAPPING #-}
         HasField "minInterpolationOffset" VkPhysicalDeviceLimits where
        type FieldType "minInterpolationOffset" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "minInterpolationOffset" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "minInterpolationOffset" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, minInterpolationOffset}
        type FieldIsArray "minInterpolationOffset" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, minInterpolationOffset}

instance {-# OVERLAPPING #-}
         CanReadField "minInterpolationOffset" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, minInterpolationOffset})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, minInterpolationOffset}

instance {-# OVERLAPPING #-}
         CanWriteField "minInterpolationOffset" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, minInterpolationOffset}

instance {-# OVERLAPPING #-}
         HasField "maxInterpolationOffset" VkPhysicalDeviceLimits where
        type FieldType "maxInterpolationOffset" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "maxInterpolationOffset" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxInterpolationOffset" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxInterpolationOffset}
        type FieldIsArray "maxInterpolationOffset" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxInterpolationOffset}

instance {-# OVERLAPPING #-}
         CanReadField "maxInterpolationOffset" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxInterpolationOffset})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxInterpolationOffset}

instance {-# OVERLAPPING #-}
         CanWriteField "maxInterpolationOffset" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxInterpolationOffset}

instance {-# OVERLAPPING #-}
         HasField "subPixelInterpolationOffsetBits" VkPhysicalDeviceLimits
         where
        type FieldType "subPixelInterpolationOffsetBits"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "subPixelInterpolationOffsetBits"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "subPixelInterpolationOffsetBits"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, subPixelInterpolationOffsetBits}
        type FieldIsArray "subPixelInterpolationOffsetBits"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, subPixelInterpolationOffsetBits}

instance {-# OVERLAPPING #-}
         CanReadField "subPixelInterpolationOffsetBits"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, subPixelInterpolationOffsetBits})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, subPixelInterpolationOffsetBits}

instance {-# OVERLAPPING #-}
         CanWriteField "subPixelInterpolationOffsetBits"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, subPixelInterpolationOffsetBits}

instance {-# OVERLAPPING #-}
         HasField "maxFramebufferWidth" VkPhysicalDeviceLimits where
        type FieldType "maxFramebufferWidth" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxFramebufferWidth" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxFramebufferWidth" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxFramebufferWidth}
        type FieldIsArray "maxFramebufferWidth" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxFramebufferWidth}

instance {-# OVERLAPPING #-}
         CanReadField "maxFramebufferWidth" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxFramebufferWidth})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxFramebufferWidth}

instance {-# OVERLAPPING #-}
         CanWriteField "maxFramebufferWidth" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxFramebufferWidth}

instance {-# OVERLAPPING #-}
         HasField "maxFramebufferHeight" VkPhysicalDeviceLimits where
        type FieldType "maxFramebufferHeight" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxFramebufferHeight" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxFramebufferHeight" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxFramebufferHeight}
        type FieldIsArray "maxFramebufferHeight" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxFramebufferHeight}

instance {-# OVERLAPPING #-}
         CanReadField "maxFramebufferHeight" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxFramebufferHeight})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxFramebufferHeight}

instance {-# OVERLAPPING #-}
         CanWriteField "maxFramebufferHeight" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxFramebufferHeight}

instance {-# OVERLAPPING #-}
         HasField "maxFramebufferLayers" VkPhysicalDeviceLimits where
        type FieldType "maxFramebufferLayers" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxFramebufferLayers" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxFramebufferLayers" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxFramebufferLayers}
        type FieldIsArray "maxFramebufferLayers" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxFramebufferLayers}

instance {-# OVERLAPPING #-}
         CanReadField "maxFramebufferLayers" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxFramebufferLayers})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxFramebufferLayers}

instance {-# OVERLAPPING #-}
         CanWriteField "maxFramebufferLayers" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxFramebufferLayers}

instance {-# OVERLAPPING #-}
         HasField "framebufferColorSampleCounts" VkPhysicalDeviceLimits
         where
        type FieldType "framebufferColorSampleCounts"
               VkPhysicalDeviceLimits
             = VkSampleCountFlags
        type FieldOptional "framebufferColorSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "framebufferColorSampleCounts"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, framebufferColorSampleCounts}
        type FieldIsArray "framebufferColorSampleCounts"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, framebufferColorSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "framebufferColorSampleCounts" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, framebufferColorSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, framebufferColorSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "framebufferColorSampleCounts" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, framebufferColorSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "framebufferDepthSampleCounts" VkPhysicalDeviceLimits
         where
        type FieldType "framebufferDepthSampleCounts"
               VkPhysicalDeviceLimits
             = VkSampleCountFlags
        type FieldOptional "framebufferDepthSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "framebufferDepthSampleCounts"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, framebufferDepthSampleCounts}
        type FieldIsArray "framebufferDepthSampleCounts"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, framebufferDepthSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "framebufferDepthSampleCounts" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, framebufferDepthSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, framebufferDepthSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "framebufferDepthSampleCounts" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, framebufferDepthSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "framebufferStencilSampleCounts" VkPhysicalDeviceLimits
         where
        type FieldType "framebufferStencilSampleCounts"
               VkPhysicalDeviceLimits
             = VkSampleCountFlags
        type FieldOptional "framebufferStencilSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "framebufferStencilSampleCounts"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, framebufferStencilSampleCounts}
        type FieldIsArray "framebufferStencilSampleCounts"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, framebufferStencilSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "framebufferStencilSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, framebufferStencilSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, framebufferStencilSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "framebufferStencilSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, framebufferStencilSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "framebufferNoAttachmentsSampleCounts"
           VkPhysicalDeviceLimits
         where
        type FieldType "framebufferNoAttachmentsSampleCounts"
               VkPhysicalDeviceLimits
             = VkSampleCountFlags
        type FieldOptional "framebufferNoAttachmentsSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "framebufferNoAttachmentsSampleCounts"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, framebufferNoAttachmentsSampleCounts}
        type FieldIsArray "framebufferNoAttachmentsSampleCounts"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, framebufferNoAttachmentsSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "framebufferNoAttachmentsSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, framebufferNoAttachmentsSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, framebufferNoAttachmentsSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "framebufferNoAttachmentsSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, framebufferNoAttachmentsSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "maxColorAttachments" VkPhysicalDeviceLimits where
        type FieldType "maxColorAttachments" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "maxColorAttachments" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxColorAttachments" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxColorAttachments}
        type FieldIsArray "maxColorAttachments" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxColorAttachments}

instance {-# OVERLAPPING #-}
         CanReadField "maxColorAttachments" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxColorAttachments})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxColorAttachments}

instance {-# OVERLAPPING #-}
         CanWriteField "maxColorAttachments" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxColorAttachments}

instance {-# OVERLAPPING #-}
         HasField "sampledImageColorSampleCounts" VkPhysicalDeviceLimits
         where
        type FieldType "sampledImageColorSampleCounts"
               VkPhysicalDeviceLimits
             = VkSampleCountFlags
        type FieldOptional "sampledImageColorSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "sampledImageColorSampleCounts"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, sampledImageColorSampleCounts}
        type FieldIsArray "sampledImageColorSampleCounts"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, sampledImageColorSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "sampledImageColorSampleCounts" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, sampledImageColorSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, sampledImageColorSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "sampledImageColorSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, sampledImageColorSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "sampledImageIntegerSampleCounts" VkPhysicalDeviceLimits
         where
        type FieldType "sampledImageIntegerSampleCounts"
               VkPhysicalDeviceLimits
             = VkSampleCountFlags
        type FieldOptional "sampledImageIntegerSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "sampledImageIntegerSampleCounts"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, sampledImageIntegerSampleCounts}
        type FieldIsArray "sampledImageIntegerSampleCounts"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, sampledImageIntegerSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "sampledImageIntegerSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, sampledImageIntegerSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, sampledImageIntegerSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "sampledImageIntegerSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, sampledImageIntegerSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "sampledImageDepthSampleCounts" VkPhysicalDeviceLimits
         where
        type FieldType "sampledImageDepthSampleCounts"
               VkPhysicalDeviceLimits
             = VkSampleCountFlags
        type FieldOptional "sampledImageDepthSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "sampledImageDepthSampleCounts"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, sampledImageDepthSampleCounts}
        type FieldIsArray "sampledImageDepthSampleCounts"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, sampledImageDepthSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "sampledImageDepthSampleCounts" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, sampledImageDepthSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, sampledImageDepthSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "sampledImageDepthSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, sampledImageDepthSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "sampledImageStencilSampleCounts" VkPhysicalDeviceLimits
         where
        type FieldType "sampledImageStencilSampleCounts"
               VkPhysicalDeviceLimits
             = VkSampleCountFlags
        type FieldOptional "sampledImageStencilSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "sampledImageStencilSampleCounts"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, sampledImageStencilSampleCounts}
        type FieldIsArray "sampledImageStencilSampleCounts"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, sampledImageStencilSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "sampledImageStencilSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, sampledImageStencilSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, sampledImageStencilSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "sampledImageStencilSampleCounts"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, sampledImageStencilSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "storageImageSampleCounts" VkPhysicalDeviceLimits where
        type FieldType "storageImageSampleCounts" VkPhysicalDeviceLimits =
             VkSampleCountFlags
        type FieldOptional "storageImageSampleCounts"
               VkPhysicalDeviceLimits
             = 'True -- ' closing tick for hsc2hs
        type FieldOffset "storageImageSampleCounts" VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, storageImageSampleCounts}
        type FieldIsArray "storageImageSampleCounts" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = True

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, storageImageSampleCounts}

instance {-# OVERLAPPING #-}
         CanReadField "storageImageSampleCounts" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, storageImageSampleCounts})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, storageImageSampleCounts}

instance {-# OVERLAPPING #-}
         CanWriteField "storageImageSampleCounts" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, storageImageSampleCounts}

instance {-# OVERLAPPING #-}
         HasField "maxSampleMaskWords" VkPhysicalDeviceLimits where
        type FieldType "maxSampleMaskWords" VkPhysicalDeviceLimits = Word32
        type FieldOptional "maxSampleMaskWords" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxSampleMaskWords" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxSampleMaskWords}
        type FieldIsArray "maxSampleMaskWords" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxSampleMaskWords}

instance {-# OVERLAPPING #-}
         CanReadField "maxSampleMaskWords" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxSampleMaskWords})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxSampleMaskWords}

instance {-# OVERLAPPING #-}
         CanWriteField "maxSampleMaskWords" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxSampleMaskWords}

instance {-# OVERLAPPING #-}
         HasField "timestampComputeAndGraphics" VkPhysicalDeviceLimits where
        type FieldType "timestampComputeAndGraphics" VkPhysicalDeviceLimits
             = VkBool32
        type FieldOptional "timestampComputeAndGraphics"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "timestampComputeAndGraphics"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, timestampComputeAndGraphics}
        type FieldIsArray "timestampComputeAndGraphics"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, timestampComputeAndGraphics}

instance {-# OVERLAPPING #-}
         CanReadField "timestampComputeAndGraphics" VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, timestampComputeAndGraphics})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, timestampComputeAndGraphics}

instance {-# OVERLAPPING #-}
         CanWriteField "timestampComputeAndGraphics" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, timestampComputeAndGraphics}

instance {-# OVERLAPPING #-}
         HasField "timestampPeriod" VkPhysicalDeviceLimits where
        type FieldType "timestampPeriod" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "timestampPeriod" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "timestampPeriod" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, timestampPeriod}
        type FieldIsArray "timestampPeriod" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, timestampPeriod}

instance {-# OVERLAPPING #-}
         CanReadField "timestampPeriod" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, timestampPeriod})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, timestampPeriod}

instance {-# OVERLAPPING #-}
         CanWriteField "timestampPeriod" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, timestampPeriod}

instance {-# OVERLAPPING #-}
         HasField "maxClipDistances" VkPhysicalDeviceLimits where
        type FieldType "maxClipDistances" VkPhysicalDeviceLimits = Word32
        type FieldOptional "maxClipDistances" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxClipDistances" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxClipDistances}
        type FieldIsArray "maxClipDistances" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxClipDistances}

instance {-# OVERLAPPING #-}
         CanReadField "maxClipDistances" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxClipDistances})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxClipDistances}

instance {-# OVERLAPPING #-}
         CanWriteField "maxClipDistances" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxClipDistances}

instance {-# OVERLAPPING #-}
         HasField "maxCullDistances" VkPhysicalDeviceLimits where
        type FieldType "maxCullDistances" VkPhysicalDeviceLimits = Word32
        type FieldOptional "maxCullDistances" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "maxCullDistances" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, maxCullDistances}
        type FieldIsArray "maxCullDistances" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxCullDistances}

instance {-# OVERLAPPING #-}
         CanReadField "maxCullDistances" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxCullDistances})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxCullDistances}

instance {-# OVERLAPPING #-}
         CanWriteField "maxCullDistances" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxCullDistances}

instance {-# OVERLAPPING #-}
         HasField "maxCombinedClipAndCullDistances" VkPhysicalDeviceLimits
         where
        type FieldType "maxCombinedClipAndCullDistances"
               VkPhysicalDeviceLimits
             = Word32
        type FieldOptional "maxCombinedClipAndCullDistances"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "maxCombinedClipAndCullDistances"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, maxCombinedClipAndCullDistances}
        type FieldIsArray "maxCombinedClipAndCullDistances"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, maxCombinedClipAndCullDistances}

instance {-# OVERLAPPING #-}
         CanReadField "maxCombinedClipAndCullDistances"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, maxCombinedClipAndCullDistances})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, maxCombinedClipAndCullDistances}

instance {-# OVERLAPPING #-}
         CanWriteField "maxCombinedClipAndCullDistances"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, maxCombinedClipAndCullDistances}

instance {-# OVERLAPPING #-}
         HasField "discreteQueuePriorities" VkPhysicalDeviceLimits where
        type FieldType "discreteQueuePriorities" VkPhysicalDeviceLimits =
             Word32
        type FieldOptional "discreteQueuePriorities" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "discreteQueuePriorities" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, discreteQueuePriorities}
        type FieldIsArray "discreteQueuePriorities" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, discreteQueuePriorities}

instance {-# OVERLAPPING #-}
         CanReadField "discreteQueuePriorities" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, discreteQueuePriorities})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, discreteQueuePriorities}

instance {-# OVERLAPPING #-}
         CanWriteField "discreteQueuePriorities" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, discreteQueuePriorities}

instance {-# OVERLAPPING #-}
         HasField "pointSizeRange" VkPhysicalDeviceLimits where
        type FieldType "pointSizeRange" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "pointSizeRange" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs
        type FieldOffset "pointSizeRange" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, pointSizeRange}
        type FieldIsArray "pointSizeRange" VkPhysicalDeviceLimits = 'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, pointSizeRange}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "pointSizeRange" idx VkPhysicalDeviceLimits) =>
         CanReadFieldArray "pointSizeRange" idx VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "pointSizeRange" 0 VkPhysicalDeviceLimits #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "pointSizeRange" 1 VkPhysicalDeviceLimits #-}
        type FieldArrayLength "pointSizeRange" VkPhysicalDeviceLimits = 2

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = 2

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceLimits, pointSizeRange} +
                      sizeOf (undefined :: #{type float}) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceLimits, pointSizeRange} +
                 sizeOf (undefined :: #{type float}) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "pointSizeRange" idx VkPhysicalDeviceLimits) =>
         CanWriteFieldArray "pointSizeRange" idx VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "pointSizeRange" 0 VkPhysicalDeviceLimits #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "pointSizeRange" 1 VkPhysicalDeviceLimits #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceLimits, pointSizeRange} +
                 sizeOf (undefined :: #{type float}) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "lineWidthRange" VkPhysicalDeviceLimits where
        type FieldType "lineWidthRange" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "lineWidthRange" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs
        type FieldOffset "lineWidthRange" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, lineWidthRange}
        type FieldIsArray "lineWidthRange" VkPhysicalDeviceLimits = 'True -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, lineWidthRange}

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "lineWidthRange" idx VkPhysicalDeviceLimits) =>
         CanReadFieldArray "lineWidthRange" idx VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanReadFieldArray "lineWidthRange" 0 VkPhysicalDeviceLimits #-}

        {-# SPECIALISE instance
                       CanReadFieldArray "lineWidthRange" 1 VkPhysicalDeviceLimits #-}
        type FieldArrayLength "lineWidthRange" VkPhysicalDeviceLimits = 2

        {-# INLINE fieldArrayLength #-}
        fieldArrayLength = 2

        {-# INLINE getFieldArray #-}
        getFieldArray = f
          where {-# NOINLINE f #-}
                f x = unsafeDupablePerformIO (peekByteOff (unsafePtr x) off)
                off
                  = #{offset VkPhysicalDeviceLimits, lineWidthRange} +
                      sizeOf (undefined :: #{type float}) *
                        fromInteger (natVal' (proxy## :: Proxy## idx)) -- ' closing tick for hsc2hs

        {-# INLINE readFieldArray #-}
        readFieldArray p
          = peekByteOff p
              (#{offset VkPhysicalDeviceLimits, lineWidthRange} +
                 sizeOf (undefined :: #{type float}) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         (KnownNat idx,
          IndexInBounds "lineWidthRange" idx VkPhysicalDeviceLimits) =>
         CanWriteFieldArray "lineWidthRange" idx VkPhysicalDeviceLimits
         where
        {-# SPECIALISE instance
                       CanWriteFieldArray "lineWidthRange" 0 VkPhysicalDeviceLimits #-}

        {-# SPECIALISE instance
                       CanWriteFieldArray "lineWidthRange" 1 VkPhysicalDeviceLimits #-}

        {-# INLINE writeFieldArray #-}
        writeFieldArray p
          = pokeByteOff p
              (#{offset VkPhysicalDeviceLimits, lineWidthRange} +
                 sizeOf (undefined :: #{type float}) *
                   fromInteger (natVal' (proxy## :: Proxy## idx))) -- ' closing tick for hsc2hs

instance {-# OVERLAPPING #-}
         HasField "pointSizeGranularity" VkPhysicalDeviceLimits where
        type FieldType "pointSizeGranularity" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "pointSizeGranularity" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "pointSizeGranularity" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, pointSizeGranularity}
        type FieldIsArray "pointSizeGranularity" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, pointSizeGranularity}

instance {-# OVERLAPPING #-}
         CanReadField "pointSizeGranularity" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, pointSizeGranularity})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, pointSizeGranularity}

instance {-# OVERLAPPING #-}
         CanWriteField "pointSizeGranularity" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, pointSizeGranularity}

instance {-# OVERLAPPING #-}
         HasField "lineWidthGranularity" VkPhysicalDeviceLimits where
        type FieldType "lineWidthGranularity" VkPhysicalDeviceLimits =
             #{type float}
        type FieldOptional "lineWidthGranularity" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "lineWidthGranularity" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, lineWidthGranularity}
        type FieldIsArray "lineWidthGranularity" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, lineWidthGranularity}

instance {-# OVERLAPPING #-}
         CanReadField "lineWidthGranularity" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, lineWidthGranularity})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, lineWidthGranularity}

instance {-# OVERLAPPING #-}
         CanWriteField "lineWidthGranularity" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, lineWidthGranularity}

instance {-# OVERLAPPING #-}
         HasField "strictLines" VkPhysicalDeviceLimits where
        type FieldType "strictLines" VkPhysicalDeviceLimits = VkBool32
        type FieldOptional "strictLines" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs
        type FieldOffset "strictLines" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, strictLines}
        type FieldIsArray "strictLines" VkPhysicalDeviceLimits = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, strictLines}

instance {-# OVERLAPPING #-}
         CanReadField "strictLines" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, strictLines})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, strictLines}

instance {-# OVERLAPPING #-}
         CanWriteField "strictLines" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, strictLines}

instance {-# OVERLAPPING #-}
         HasField "standardSampleLocations" VkPhysicalDeviceLimits where
        type FieldType "standardSampleLocations" VkPhysicalDeviceLimits =
             VkBool32
        type FieldOptional "standardSampleLocations" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "standardSampleLocations" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, standardSampleLocations}
        type FieldIsArray "standardSampleLocations" VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, standardSampleLocations}

instance {-# OVERLAPPING #-}
         CanReadField "standardSampleLocations" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, standardSampleLocations})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, standardSampleLocations}

instance {-# OVERLAPPING #-}
         CanWriteField "standardSampleLocations" VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, standardSampleLocations}

instance {-# OVERLAPPING #-}
         HasField "optimalBufferCopyOffsetAlignment" VkPhysicalDeviceLimits
         where
        type FieldType "optimalBufferCopyOffsetAlignment"
               VkPhysicalDeviceLimits
             = VkDeviceSize
        type FieldOptional "optimalBufferCopyOffsetAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "optimalBufferCopyOffsetAlignment"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, optimalBufferCopyOffsetAlignment}
        type FieldIsArray "optimalBufferCopyOffsetAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, optimalBufferCopyOffsetAlignment}

instance {-# OVERLAPPING #-}
         CanReadField "optimalBufferCopyOffsetAlignment"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, optimalBufferCopyOffsetAlignment})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, optimalBufferCopyOffsetAlignment}

instance {-# OVERLAPPING #-}
         CanWriteField "optimalBufferCopyOffsetAlignment"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, optimalBufferCopyOffsetAlignment}

instance {-# OVERLAPPING #-}
         HasField "optimalBufferCopyRowPitchAlignment"
           VkPhysicalDeviceLimits
         where
        type FieldType "optimalBufferCopyRowPitchAlignment"
               VkPhysicalDeviceLimits
             = VkDeviceSize
        type FieldOptional "optimalBufferCopyRowPitchAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs
        type FieldOffset "optimalBufferCopyRowPitchAlignment"
               VkPhysicalDeviceLimits
             =
             #{offset VkPhysicalDeviceLimits, optimalBufferCopyRowPitchAlignment}
        type FieldIsArray "optimalBufferCopyRowPitchAlignment"
               VkPhysicalDeviceLimits
             = 'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, optimalBufferCopyRowPitchAlignment}

instance {-# OVERLAPPING #-}
         CanReadField "optimalBufferCopyRowPitchAlignment"
           VkPhysicalDeviceLimits
         where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, optimalBufferCopyRowPitchAlignment})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, optimalBufferCopyRowPitchAlignment}

instance {-# OVERLAPPING #-}
         CanWriteField "optimalBufferCopyRowPitchAlignment"
           VkPhysicalDeviceLimits
         where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, optimalBufferCopyRowPitchAlignment}

instance {-# OVERLAPPING #-}
         HasField "nonCoherentAtomSize" VkPhysicalDeviceLimits where
        type FieldType "nonCoherentAtomSize" VkPhysicalDeviceLimits =
             VkDeviceSize
        type FieldOptional "nonCoherentAtomSize" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs
        type FieldOffset "nonCoherentAtomSize" VkPhysicalDeviceLimits =
             #{offset VkPhysicalDeviceLimits, nonCoherentAtomSize}
        type FieldIsArray "nonCoherentAtomSize" VkPhysicalDeviceLimits =
             'False -- ' closing tick for hsc2hs

        {-# INLINE fieldOptional #-}
        fieldOptional = False

        {-# INLINE fieldOffset #-}
        fieldOffset
          = #{offset VkPhysicalDeviceLimits, nonCoherentAtomSize}

instance {-# OVERLAPPING #-}
         CanReadField "nonCoherentAtomSize" VkPhysicalDeviceLimits where
        {-# NOINLINE getField #-}
        getField x
          = unsafeDupablePerformIO
              (peekByteOff (unsafePtr x) #{offset VkPhysicalDeviceLimits, nonCoherentAtomSize})

        {-# INLINE readField #-}
        readField p
          = peekByteOff p #{offset VkPhysicalDeviceLimits, nonCoherentAtomSize}

instance {-# OVERLAPPING #-}
         CanWriteField "nonCoherentAtomSize" VkPhysicalDeviceLimits where
        {-# INLINE writeField #-}
        writeField p
          = pokeByteOff p #{offset VkPhysicalDeviceLimits, nonCoherentAtomSize}

instance Show VkPhysicalDeviceLimits where
        showsPrec d x
          = showString "VkPhysicalDeviceLimits {" .
              showString "maxImageDimension1D = " .
                showsPrec d (getField @"maxImageDimension1D" x) .
                  showString ", " .
                    showString "maxImageDimension2D = " .
                      showsPrec d (getField @"maxImageDimension2D" x) .
                        showString ", " .
                          showString "maxImageDimension3D = " .
                            showsPrec d (getField @"maxImageDimension3D" x) .
                              showString ", " .
                                showString "maxImageDimensionCube = " .
                                  showsPrec d (getField @"maxImageDimensionCube" x) .
                                    showString ", " .
                                      showString "maxImageArrayLayers = " .
                                        showsPrec d (getField @"maxImageArrayLayers" x) .
                                          showString ", " .
                                            showString "maxTexelBufferElements = " .
                                              showsPrec d (getField @"maxTexelBufferElements" x) .
                                                showString ", " .
                                                  showString "maxUniformBufferRange = " .
                                                    showsPrec d
                                                      (getField @"maxUniformBufferRange" x)
                                                      .
                                                      showString ", " .
                                                        showString "maxStorageBufferRange = " .
                                                          showsPrec d
                                                            (getField @"maxStorageBufferRange" x)
                                                            .
                                                            showString ", " .
                                                              showString "maxPushConstantsSize = " .
                                                                showsPrec d
                                                                  (getField @"maxPushConstantsSize"
                                                                     x)
                                                                  .
                                                                  showString ", " .
                                                                    showString
                                                                      "maxMemoryAllocationCount = "
                                                                      .
                                                                      showsPrec d
                                                                        (getField
                                                                           @"maxMemoryAllocationCount"
                                                                           x)
                                                                        .
                                                                        showString ", " .
                                                                          showString
                                                                            "maxSamplerAllocationCount = "
                                                                            .
                                                                            showsPrec d
                                                                              (getField
                                                                                 @"maxSamplerAllocationCount"
                                                                                 x)
                                                                              .
                                                                              showString ", " .
                                                                                showString
                                                                                  "bufferImageGranularity = "
                                                                                  .
                                                                                  showsPrec d
                                                                                    (getField
                                                                                       @"bufferImageGranularity"
                                                                                       x)
                                                                                    .
                                                                                    showString ", "
                                                                                      .
                                                                                      showString
                                                                                        "sparseAddressSpaceSize = "
                                                                                        .
                                                                                        showsPrec d
                                                                                          (getField
                                                                                             @"sparseAddressSpaceSize"
                                                                                             x)
                                                                                          .
                                                                                          showString
                                                                                            ", "
                                                                                            .
                                                                                            showString
                                                                                              "maxBoundDescriptorSets = "
                                                                                              .
                                                                                              showsPrec
                                                                                                d
                                                                                                (getField
                                                                                                   @"maxBoundDescriptorSets"
                                                                                                   x)
                                                                                                .
                                                                                                showString
                                                                                                  ", "
                                                                                                  .
                                                                                                  showString
                                                                                                    "maxPerStageDescriptorSamplers = "
                                                                                                    .
                                                                                                    showsPrec
                                                                                                      d
                                                                                                      (getField
                                                                                                         @"maxPerStageDescriptorSamplers"
                                                                                                         x)
                                                                                                      .
                                                                                                      showString
                                                                                                        ", "
                                                                                                        .
                                                                                                        showString
                                                                                                          "maxPerStageDescriptorUniformBuffers = "
                                                                                                          .
                                                                                                          showsPrec
                                                                                                            d
                                                                                                            (getField
                                                                                                               @"maxPerStageDescriptorUniformBuffers"
                                                                                                               x)
                                                                                                            .
                                                                                                            showString
                                                                                                              ", "
                                                                                                              .
                                                                                                              showString
                                                                                                                "maxPerStageDescriptorStorageBuffers = "
                                                                                                                .
                                                                                                                showsPrec
                                                                                                                  d
                                                                                                                  (getField
                                                                                                                     @"maxPerStageDescriptorStorageBuffers"
                                                                                                                     x)
                                                                                                                  .
                                                                                                                  showString
                                                                                                                    ", "
                                                                                                                    .
                                                                                                                    showString
                                                                                                                      "maxPerStageDescriptorSampledImages = "
                                                                                                                      .
                                                                                                                      showsPrec
                                                                                                                        d
                                                                                                                        (getField
                                                                                                                           @"maxPerStageDescriptorSampledImages"
                                                                                                                           x)
                                                                                                                        .
                                                                                                                        showString
                                                                                                                          ", "
                                                                                                                          .
                                                                                                                          showString
                                                                                                                            "maxPerStageDescriptorStorageImages = "
                                                                                                                            .
                                                                                                                            showsPrec
                                                                                                                              d
                                                                                                                              (getField
                                                                                                                                 @"maxPerStageDescriptorStorageImages"
                                                                                                                                 x)
                                                                                                                              .
                                                                                                                              showString
                                                                                                                                ", "
                                                                                                                                .
                                                                                                                                showString
                                                                                                                                  "maxPerStageDescriptorInputAttachments = "
                                                                                                                                  .
                                                                                                                                  showsPrec
                                                                                                                                    d
                                                                                                                                    (getField
                                                                                                                                       @"maxPerStageDescriptorInputAttachments"
                                                                                                                                       x)
                                                                                                                                    .
                                                                                                                                    showString
                                                                                                                                      ", "
                                                                                                                                      .
                                                                                                                                      showString
                                                                                                                                        "maxPerStageResources = "
                                                                                                                                        .
                                                                                                                                        showsPrec
                                                                                                                                          d
                                                                                                                                          (getField
                                                                                                                                             @"maxPerStageResources"
                                                                                                                                             x)
                                                                                                                                          .
                                                                                                                                          showString
                                                                                                                                            ", "
                                                                                                                                            .
                                                                                                                                            showString
                                                                                                                                              "maxDescriptorSetSamplers = "
                                                                                                                                              .
                                                                                                                                              showsPrec
                                                                                                                                                d
                                                                                                                                                (getField
                                                                                                                                                   @"maxDescriptorSetSamplers"
                                                                                                                                                   x)
                                                                                                                                                .
                                                                                                                                                showString
                                                                                                                                                  ", "
                                                                                                                                                  .
                                                                                                                                                  showString
                                                                                                                                                    "maxDescriptorSetUniformBuffers = "
                                                                                                                                                    .
                                                                                                                                                    showsPrec
                                                                                                                                                      d
                                                                                                                                                      (getField
                                                                                                                                                         @"maxDescriptorSetUniformBuffers"
                                                                                                                                                         x)
                                                                                                                                                      .
                                                                                                                                                      showString
                                                                                                                                                        ", "
                                                                                                                                                        .
                                                                                                                                                        showString
                                                                                                                                                          "maxDescriptorSetUniformBuffersDynamic = "
                                                                                                                                                          .
                                                                                                                                                          showsPrec
                                                                                                                                                            d
                                                                                                                                                            (getField
                                                                                                                                                               @"maxDescriptorSetUniformBuffersDynamic"
                                                                                                                                                               x)
                                                                                                                                                            .
                                                                                                                                                            showString
                                                                                                                                                              ", "
                                                                                                                                                              .
                                                                                                                                                              showString
                                                                                                                                                                "maxDescriptorSetStorageBuffers = "
                                                                                                                                                                .
                                                                                                                                                                showsPrec
                                                                                                                                                                  d
                                                                                                                                                                  (getField
                                                                                                                                                                     @"maxDescriptorSetStorageBuffers"
                                                                                                                                                                     x)
                                                                                                                                                                  .
                                                                                                                                                                  showString
                                                                                                                                                                    ", "
                                                                                                                                                                    .
                                                                                                                                                                    showString
                                                                                                                                                                      "maxDescriptorSetStorageBuffersDynamic = "
                                                                                                                                                                      .
                                                                                                                                                                      showsPrec
                                                                                                                                                                        d
                                                                                                                                                                        (getField
                                                                                                                                                                           @"maxDescriptorSetStorageBuffersDynamic"
                                                                                                                                                                           x)
                                                                                                                                                                        .
                                                                                                                                                                        showString
                                                                                                                                                                          ", "
                                                                                                                                                                          .
                                                                                                                                                                          showString
                                                                                                                                                                            "maxDescriptorSetSampledImages = "
                                                                                                                                                                            .
                                                                                                                                                                            showsPrec
                                                                                                                                                                              d
                                                                                                                                                                              (getField
                                                                                                                                                                                 @"maxDescriptorSetSampledImages"
                                                                                                                                                                                 x)
                                                                                                                                                                              .
                                                                                                                                                                              showString
                                                                                                                                                                                ", "
                                                                                                                                                                                .
                                                                                                                                                                                showString
                                                                                                                                                                                  "maxDescriptorSetStorageImages = "
                                                                                                                                                                                  .
                                                                                                                                                                                  showsPrec
                                                                                                                                                                                    d
                                                                                                                                                                                    (getField
                                                                                                                                                                                       @"maxDescriptorSetStorageImages"
                                                                                                                                                                                       x)
                                                                                                                                                                                    .
                                                                                                                                                                                    showString
                                                                                                                                                                                      ", "
                                                                                                                                                                                      .
                                                                                                                                                                                      showString
                                                                                                                                                                                        "maxDescriptorSetInputAttachments = "
                                                                                                                                                                                        .
                                                                                                                                                                                        showsPrec
                                                                                                                                                                                          d
                                                                                                                                                                                          (getField
                                                                                                                                                                                             @"maxDescriptorSetInputAttachments"
                                                                                                                                                                                             x)
                                                                                                                                                                                          .
                                                                                                                                                                                          showString
                                                                                                                                                                                            ", "
                                                                                                                                                                                            .
                                                                                                                                                                                            showString
                                                                                                                                                                                              "maxVertexInputAttributes = "
                                                                                                                                                                                              .
                                                                                                                                                                                              showsPrec
                                                                                                                                                                                                d
                                                                                                                                                                                                (getField
                                                                                                                                                                                                   @"maxVertexInputAttributes"
                                                                                                                                                                                                   x)
                                                                                                                                                                                                .
                                                                                                                                                                                                showString
                                                                                                                                                                                                  ", "
                                                                                                                                                                                                  .
                                                                                                                                                                                                  showString
                                                                                                                                                                                                    "maxVertexInputBindings = "
                                                                                                                                                                                                    .
                                                                                                                                                                                                    showsPrec
                                                                                                                                                                                                      d
                                                                                                                                                                                                      (getField
                                                                                                                                                                                                         @"maxVertexInputBindings"
                                                                                                                                                                                                         x)
                                                                                                                                                                                                      .
                                                                                                                                                                                                      showString
                                                                                                                                                                                                        ", "
                                                                                                                                                                                                        .
                                                                                                                                                                                                        showString
                                                                                                                                                                                                          "maxVertexInputAttributeOffset = "
                                                                                                                                                                                                          .
                                                                                                                                                                                                          showsPrec
                                                                                                                                                                                                            d
                                                                                                                                                                                                            (getField
                                                                                                                                                                                                               @"maxVertexInputAttributeOffset"
                                                                                                                                                                                                               x)
                                                                                                                                                                                                            .
                                                                                                                                                                                                            showString
                                                                                                                                                                                                              ", "
                                                                                                                                                                                                              .
                                                                                                                                                                                                              showString
                                                                                                                                                                                                                "maxVertexInputBindingStride = "
                                                                                                                                                                                                                .
                                                                                                                                                                                                                showsPrec
                                                                                                                                                                                                                  d
                                                                                                                                                                                                                  (getField
                                                                                                                                                                                                                     @"maxVertexInputBindingStride"
                                                                                                                                                                                                                     x)
                                                                                                                                                                                                                  .
                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                    .
                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                      "maxVertexOutputComponents = "
                                                                                                                                                                                                                      .
                                                                                                                                                                                                                      showsPrec
                                                                                                                                                                                                                        d
                                                                                                                                                                                                                        (getField
                                                                                                                                                                                                                           @"maxVertexOutputComponents"
                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                        .
                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                          .
                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                            "maxTessellationGenerationLevel = "
                                                                                                                                                                                                                            .
                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                              d
                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                 @"maxTessellationGenerationLevel"
                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                              .
                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                  "maxTessellationPatchSize = "
                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                  showsPrec
                                                                                                                                                                                                                                    d
                                                                                                                                                                                                                                    (getField
                                                                                                                                                                                                                                       @"maxTessellationPatchSize"
                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                      ", "
                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                        "maxTessellationControlPerVertexInputComponents = "
                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                        showsPrec
                                                                                                                                                                                                                                          d
                                                                                                                                                                                                                                          (getField
                                                                                                                                                                                                                                             @"maxTessellationControlPerVertexInputComponents"
                                                                                                                                                                                                                                             x)
                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                            ", "
                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                              "maxTessellationControlPerVertexOutputComponents = "
                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                              showsPrec
                                                                                                                                                                                                                                                d
                                                                                                                                                                                                                                                (getField
                                                                                                                                                                                                                                                   @"maxTessellationControlPerVertexOutputComponents"
                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                  ", "
                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                    "maxTessellationControlPerPatchOutputComponents = "
                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                    showsPrec
                                                                                                                                                                                                                                                      d
                                                                                                                                                                                                                                                      (getField
                                                                                                                                                                                                                                                         @"maxTessellationControlPerPatchOutputComponents"
                                                                                                                                                                                                                                                         x)
                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                        ", "
                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                          "maxTessellationControlTotalOutputComponents = "
                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                          showsPrec
                                                                                                                                                                                                                                                            d
                                                                                                                                                                                                                                                            (getField
                                                                                                                                                                                                                                                               @"maxTessellationControlTotalOutputComponents"
                                                                                                                                                                                                                                                               x)
                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                              ", "
                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                "maxTessellationEvaluationInputComponents = "
                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                showsPrec
                                                                                                                                                                                                                                                                  d
                                                                                                                                                                                                                                                                  (getField
                                                                                                                                                                                                                                                                     @"maxTessellationEvaluationInputComponents"
                                                                                                                                                                                                                                                                     x)
                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                      "maxTessellationEvaluationOutputComponents = "
                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                      showsPrec
                                                                                                                                                                                                                                                                        d
                                                                                                                                                                                                                                                                        (getField
                                                                                                                                                                                                                                                                           @"maxTessellationEvaluationOutputComponents"
                                                                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                            "maxGeometryShaderInvocations = "
                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                                                                              d
                                                                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                                                                 @"maxGeometryShaderInvocations"
                                                                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                  "maxGeometryInputComponents = "
                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                  showsPrec
                                                                                                                                                                                                                                                                                    d
                                                                                                                                                                                                                                                                                    (getField
                                                                                                                                                                                                                                                                                       @"maxGeometryInputComponents"
                                                                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                      ", "
                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                        "maxGeometryOutputComponents = "
                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                        showsPrec
                                                                                                                                                                                                                                                                                          d
                                                                                                                                                                                                                                                                                          (getField
                                                                                                                                                                                                                                                                                             @"maxGeometryOutputComponents"
                                                                                                                                                                                                                                                                                             x)
                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                            ", "
                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                              "maxGeometryOutputVertices = "
                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                              showsPrec
                                                                                                                                                                                                                                                                                                d
                                                                                                                                                                                                                                                                                                (getField
                                                                                                                                                                                                                                                                                                   @"maxGeometryOutputVertices"
                                                                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                  ", "
                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                    "maxGeometryTotalOutputComponents = "
                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                    showsPrec
                                                                                                                                                                                                                                                                                                      d
                                                                                                                                                                                                                                                                                                      (getField
                                                                                                                                                                                                                                                                                                         @"maxGeometryTotalOutputComponents"
                                                                                                                                                                                                                                                                                                         x)
                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                        ", "
                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                          "maxFragmentInputComponents = "
                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                          showsPrec
                                                                                                                                                                                                                                                                                                            d
                                                                                                                                                                                                                                                                                                            (getField
                                                                                                                                                                                                                                                                                                               @"maxFragmentInputComponents"
                                                                                                                                                                                                                                                                                                               x)
                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                              ", "
                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                "maxFragmentOutputAttachments = "
                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                showsPrec
                                                                                                                                                                                                                                                                                                                  d
                                                                                                                                                                                                                                                                                                                  (getField
                                                                                                                                                                                                                                                                                                                     @"maxFragmentOutputAttachments"
                                                                                                                                                                                                                                                                                                                     x)
                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                      "maxFragmentDualSrcAttachments = "
                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                      showsPrec
                                                                                                                                                                                                                                                                                                                        d
                                                                                                                                                                                                                                                                                                                        (getField
                                                                                                                                                                                                                                                                                                                           @"maxFragmentDualSrcAttachments"
                                                                                                                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                            "maxFragmentCombinedOutputResources = "
                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                                                                                                                              d
                                                                                                                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                                                                                                                 @"maxFragmentCombinedOutputResources"
                                                                                                                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                  "maxComputeSharedMemorySize = "
                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                  showsPrec
                                                                                                                                                                                                                                                                                                                                    d
                                                                                                                                                                                                                                                                                                                                    (getField
                                                                                                                                                                                                                                                                                                                                       @"maxComputeSharedMemorySize"
                                                                                                                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                      ", "
                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                      (showString
                                                                                                                                                                                                                                                                                                                                         "maxComputeWorkGroupCount = ["
                                                                                                                                                                                                                                                                                                                                         .
                                                                                                                                                                                                                                                                                                                                         showsPrec
                                                                                                                                                                                                                                                                                                                                           d
                                                                                                                                                                                                                                                                                                                                           (let s = sizeOf
                                                                                                                                                                                                                                                                                                                                                      (undefined
                                                                                                                                                                                                                                                                                                                                                         ::
                                                                                                                                                                                                                                                                                                                                                         FieldType
                                                                                                                                                                                                                                                                                                                                                           "maxComputeWorkGroupCount"
                                                                                                                                                                                                                                                                                                                                                           VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                o = fieldOffset
                                                                                                                                                                                                                                                                                                                                                      @"maxComputeWorkGroupCount"
                                                                                                                                                                                                                                                                                                                                                      @VkPhysicalDeviceLimits
                                                                                                                                                                                                                                                                                                                                                f i
                                                                                                                                                                                                                                                                                                                                                  = peekByteOff
                                                                                                                                                                                                                                                                                                                                                      (unsafePtr
                                                                                                                                                                                                                                                                                                                                                         x)
                                                                                                                                                                                                                                                                                                                                                      i
                                                                                                                                                                                                                                                                                                                                                      ::
                                                                                                                                                                                                                                                                                                                                                      IO
                                                                                                                                                                                                                                                                                                                                                        (FieldType
                                                                                                                                                                                                                                                                                                                                                           "maxComputeWorkGroupCount"
                                                                                                                                                                                                                                                                                                                                                           VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                              in
                                                                                                                                                                                                                                                                                                                                              unsafeDupablePerformIO
                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                mapM
                                                                                                                                                                                                                                                                                                                                                  f
                                                                                                                                                                                                                                                                                                                                                $
                                                                                                                                                                                                                                                                                                                                                map
                                                                                                                                                                                                                                                                                                                                                  (\ i
                                                                                                                                                                                                                                                                                                                                                     ->
                                                                                                                                                                                                                                                                                                                                                     o +
                                                                                                                                                                                                                                                                                                                                                       i *
                                                                                                                                                                                                                                                                                                                                                         s)
                                                                                                                                                                                                                                                                                                                                                  [0
                                                                                                                                                                                                                                                                                                                                                   ..
                                                                                                                                                                                                                                                                                                                                                   3 -
                                                                                                                                                                                                                                                                                                                                                     1])
                                                                                                                                                                                                                                                                                                                                           .
                                                                                                                                                                                                                                                                                                                                           showChar
                                                                                                                                                                                                                                                                                                                                             ']')
                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                            "maxComputeWorkGroupInvocations = "
                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                                                                                                                                              d
                                                                                                                                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                                                                                                                                 @"maxComputeWorkGroupInvocations"
                                                                                                                                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                (showString
                                                                                                                                                                                                                                                                                                                                                   "maxComputeWorkGroupSize = ["
                                                                                                                                                                                                                                                                                                                                                   .
                                                                                                                                                                                                                                                                                                                                                   showsPrec
                                                                                                                                                                                                                                                                                                                                                     d
                                                                                                                                                                                                                                                                                                                                                     (let s = sizeOf
                                                                                                                                                                                                                                                                                                                                                                (undefined
                                                                                                                                                                                                                                                                                                                                                                   ::
                                                                                                                                                                                                                                                                                                                                                                   FieldType
                                                                                                                                                                                                                                                                                                                                                                     "maxComputeWorkGroupSize"
                                                                                                                                                                                                                                                                                                                                                                     VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                          o = fieldOffset
                                                                                                                                                                                                                                                                                                                                                                @"maxComputeWorkGroupSize"
                                                                                                                                                                                                                                                                                                                                                                @VkPhysicalDeviceLimits
                                                                                                                                                                                                                                                                                                                                                          f i
                                                                                                                                                                                                                                                                                                                                                            = peekByteOff
                                                                                                                                                                                                                                                                                                                                                                (unsafePtr
                                                                                                                                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                                                                                                                                i
                                                                                                                                                                                                                                                                                                                                                                ::
                                                                                                                                                                                                                                                                                                                                                                IO
                                                                                                                                                                                                                                                                                                                                                                  (FieldType
                                                                                                                                                                                                                                                                                                                                                                     "maxComputeWorkGroupSize"
                                                                                                                                                                                                                                                                                                                                                                     VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                        in
                                                                                                                                                                                                                                                                                                                                                        unsafeDupablePerformIO
                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                          mapM
                                                                                                                                                                                                                                                                                                                                                            f
                                                                                                                                                                                                                                                                                                                                                          $
                                                                                                                                                                                                                                                                                                                                                          map
                                                                                                                                                                                                                                                                                                                                                            (\ i
                                                                                                                                                                                                                                                                                                                                                               ->
                                                                                                                                                                                                                                                                                                                                                               o +
                                                                                                                                                                                                                                                                                                                                                                 i *
                                                                                                                                                                                                                                                                                                                                                                   s)
                                                                                                                                                                                                                                                                                                                                                            [0
                                                                                                                                                                                                                                                                                                                                                             ..
                                                                                                                                                                                                                                                                                                                                                             3 -
                                                                                                                                                                                                                                                                                                                                                               1])
                                                                                                                                                                                                                                                                                                                                                     .
                                                                                                                                                                                                                                                                                                                                                     showChar
                                                                                                                                                                                                                                                                                                                                                       ']')
                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                      "subPixelPrecisionBits = "
                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                      showsPrec
                                                                                                                                                                                                                                                                                                                                                        d
                                                                                                                                                                                                                                                                                                                                                        (getField
                                                                                                                                                                                                                                                                                                                                                           @"subPixelPrecisionBits"
                                                                                                                                                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                            "subTexelPrecisionBits = "
                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                                                                                                                                                              d
                                                                                                                                                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                                                                                                                                                 @"subTexelPrecisionBits"
                                                                                                                                                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                  "mipmapPrecisionBits = "
                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                  showsPrec
                                                                                                                                                                                                                                                                                                                                                                    d
                                                                                                                                                                                                                                                                                                                                                                    (getField
                                                                                                                                                                                                                                                                                                                                                                       @"mipmapPrecisionBits"
                                                                                                                                                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                      ", "
                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                        "maxDrawIndexedIndexValue = "
                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                        showsPrec
                                                                                                                                                                                                                                                                                                                                                                          d
                                                                                                                                                                                                                                                                                                                                                                          (getField
                                                                                                                                                                                                                                                                                                                                                                             @"maxDrawIndexedIndexValue"
                                                                                                                                                                                                                                                                                                                                                                             x)
                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                            ", "
                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                              "maxDrawIndirectCount = "
                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                              showsPrec
                                                                                                                                                                                                                                                                                                                                                                                d
                                                                                                                                                                                                                                                                                                                                                                                (getField
                                                                                                                                                                                                                                                                                                                                                                                   @"maxDrawIndirectCount"
                                                                                                                                                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                  ", "
                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                    "maxSamplerLodBias = "
                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                    showsPrec
                                                                                                                                                                                                                                                                                                                                                                                      d
                                                                                                                                                                                                                                                                                                                                                                                      (getField
                                                                                                                                                                                                                                                                                                                                                                                         @"maxSamplerLodBias"
                                                                                                                                                                                                                                                                                                                                                                                         x)
                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                        ", "
                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                          "maxSamplerAnisotropy = "
                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                          showsPrec
                                                                                                                                                                                                                                                                                                                                                                                            d
                                                                                                                                                                                                                                                                                                                                                                                            (getField
                                                                                                                                                                                                                                                                                                                                                                                               @"maxSamplerAnisotropy"
                                                                                                                                                                                                                                                                                                                                                                                               x)
                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                              ", "
                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                "maxViewports = "
                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                  d
                                                                                                                                                                                                                                                                                                                                                                                                  (getField
                                                                                                                                                                                                                                                                                                                                                                                                     @"maxViewports"
                                                                                                                                                                                                                                                                                                                                                                                                     x)
                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                    (showString
                                                                                                                                                                                                                                                                                                                                                                                                       "maxViewportDimensions = ["
                                                                                                                                                                                                                                                                                                                                                                                                       .
                                                                                                                                                                                                                                                                                                                                                                                                       showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                         d
                                                                                                                                                                                                                                                                                                                                                                                                         (let s = sizeOf
                                                                                                                                                                                                                                                                                                                                                                                                                    (undefined
                                                                                                                                                                                                                                                                                                                                                                                                                       ::
                                                                                                                                                                                                                                                                                                                                                                                                                       FieldType
                                                                                                                                                                                                                                                                                                                                                                                                                         "maxViewportDimensions"
                                                                                                                                                                                                                                                                                                                                                                                                                         VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                                                                              o = fieldOffset
                                                                                                                                                                                                                                                                                                                                                                                                                    @"maxViewportDimensions"
                                                                                                                                                                                                                                                                                                                                                                                                                    @VkPhysicalDeviceLimits
                                                                                                                                                                                                                                                                                                                                                                                                              f i
                                                                                                                                                                                                                                                                                                                                                                                                                = peekByteOff
                                                                                                                                                                                                                                                                                                                                                                                                                    (unsafePtr
                                                                                                                                                                                                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                                                                                                                                                                                                    i
                                                                                                                                                                                                                                                                                                                                                                                                                    ::
                                                                                                                                                                                                                                                                                                                                                                                                                    IO
                                                                                                                                                                                                                                                                                                                                                                                                                      (FieldType
                                                                                                                                                                                                                                                                                                                                                                                                                         "maxViewportDimensions"
                                                                                                                                                                                                                                                                                                                                                                                                                         VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                                                                            in
                                                                                                                                                                                                                                                                                                                                                                                                            unsafeDupablePerformIO
                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                              mapM
                                                                                                                                                                                                                                                                                                                                                                                                                f
                                                                                                                                                                                                                                                                                                                                                                                                              $
                                                                                                                                                                                                                                                                                                                                                                                                              map
                                                                                                                                                                                                                                                                                                                                                                                                                (\ i
                                                                                                                                                                                                                                                                                                                                                                                                                   ->
                                                                                                                                                                                                                                                                                                                                                                                                                   o +
                                                                                                                                                                                                                                                                                                                                                                                                                     i *
                                                                                                                                                                                                                                                                                                                                                                                                                       s)
                                                                                                                                                                                                                                                                                                                                                                                                                [0
                                                                                                                                                                                                                                                                                                                                                                                                                 ..
                                                                                                                                                                                                                                                                                                                                                                                                                 2 -
                                                                                                                                                                                                                                                                                                                                                                                                                   1])
                                                                                                                                                                                                                                                                                                                                                                                                         .
                                                                                                                                                                                                                                                                                                                                                                                                         showChar
                                                                                                                                                                                                                                                                                                                                                                                                           ']')
                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                        ", "
                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                        (showString
                                                                                                                                                                                                                                                                                                                                                                                                           "viewportBoundsRange = ["
                                                                                                                                                                                                                                                                                                                                                                                                           .
                                                                                                                                                                                                                                                                                                                                                                                                           showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                             d
                                                                                                                                                                                                                                                                                                                                                                                                             (let s = sizeOf
                                                                                                                                                                                                                                                                                                                                                                                                                        (undefined
                                                                                                                                                                                                                                                                                                                                                                                                                           ::
                                                                                                                                                                                                                                                                                                                                                                                                                           FieldType
                                                                                                                                                                                                                                                                                                                                                                                                                             "viewportBoundsRange"
                                                                                                                                                                                                                                                                                                                                                                                                                             VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                                                                                  o = fieldOffset
                                                                                                                                                                                                                                                                                                                                                                                                                        @"viewportBoundsRange"
                                                                                                                                                                                                                                                                                                                                                                                                                        @VkPhysicalDeviceLimits
                                                                                                                                                                                                                                                                                                                                                                                                                  f i
                                                                                                                                                                                                                                                                                                                                                                                                                    = peekByteOff
                                                                                                                                                                                                                                                                                                                                                                                                                        (unsafePtr
                                                                                                                                                                                                                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                                                                                                                                                                                                                        i
                                                                                                                                                                                                                                                                                                                                                                                                                        ::
                                                                                                                                                                                                                                                                                                                                                                                                                        IO
                                                                                                                                                                                                                                                                                                                                                                                                                          (FieldType
                                                                                                                                                                                                                                                                                                                                                                                                                             "viewportBoundsRange"
                                                                                                                                                                                                                                                                                                                                                                                                                             VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                                                                                in
                                                                                                                                                                                                                                                                                                                                                                                                                unsafeDupablePerformIO
                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                  mapM
                                                                                                                                                                                                                                                                                                                                                                                                                    f
                                                                                                                                                                                                                                                                                                                                                                                                                  $
                                                                                                                                                                                                                                                                                                                                                                                                                  map
                                                                                                                                                                                                                                                                                                                                                                                                                    (\ i
                                                                                                                                                                                                                                                                                                                                                                                                                       ->
                                                                                                                                                                                                                                                                                                                                                                                                                       o +
                                                                                                                                                                                                                                                                                                                                                                                                                         i *
                                                                                                                                                                                                                                                                                                                                                                                                                           s)
                                                                                                                                                                                                                                                                                                                                                                                                                    [0
                                                                                                                                                                                                                                                                                                                                                                                                                     ..
                                                                                                                                                                                                                                                                                                                                                                                                                     2 -
                                                                                                                                                                                                                                                                                                                                                                                                                       1])
                                                                                                                                                                                                                                                                                                                                                                                                             .
                                                                                                                                                                                                                                                                                                                                                                                                             showChar
                                                                                                                                                                                                                                                                                                                                                                                                               ']')
                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                            ", "
                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                                              "viewportSubPixelBits = "
                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                              showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                d
                                                                                                                                                                                                                                                                                                                                                                                                                (getField
                                                                                                                                                                                                                                                                                                                                                                                                                   @"viewportSubPixelBits"
                                                                                                                                                                                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                                                  ", "
                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                                    "minMemoryMapAlignment = "
                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                    showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                      d
                                                                                                                                                                                                                                                                                                                                                                                                                      (getField
                                                                                                                                                                                                                                                                                                                                                                                                                         @"minMemoryMapAlignment"
                                                                                                                                                                                                                                                                                                                                                                                                                         x)
                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                                        ", "
                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                                                          "minTexelBufferOffsetAlignment = "
                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                          showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                            d
                                                                                                                                                                                                                                                                                                                                                                                                                            (getField
                                                                                                                                                                                                                                                                                                                                                                                                                               @"minTexelBufferOffsetAlignment"
                                                                                                                                                                                                                                                                                                                                                                                                                               x)
                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                                                              ", "
                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                "minUniformBufferOffsetAlignment = "
                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                  d
                                                                                                                                                                                                                                                                                                                                                                                                                                  (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                     @"minUniformBufferOffsetAlignment"
                                                                                                                                                                                                                                                                                                                                                                                                                                     x)
                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                                                                                      "minStorageBufferOffsetAlignment = "
                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                      showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                        d
                                                                                                                                                                                                                                                                                                                                                                                                                                        (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                           @"minStorageBufferOffsetAlignment"
                                                                                                                                                                                                                                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                                                            "minTexelOffset = "
                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                              d
                                                                                                                                                                                                                                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                 @"minTexelOffset"
                                                                                                                                                                                                                                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                  "maxTexelOffset = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                  showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                    d
                                                                                                                                                                                                                                                                                                                                                                                                                                                    (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                       @"maxTexelOffset"
                                                                                                                                                                                                                                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                      ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                        "minTexelGatherOffset = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                        showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                          d
                                                                                                                                                                                                                                                                                                                                                                                                                                                          (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                             @"minTexelGatherOffset"
                                                                                                                                                                                                                                                                                                                                                                                                                                                             x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                            ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                              "maxTexelGatherOffset = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                              showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @"maxTexelGatherOffset"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    "minInterpolationOffset = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                      d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                      (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @"minInterpolationOffset"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                         x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          "maxInterpolationOffset = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @"maxInterpolationOffset"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                               x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "subPixelInterpolationOffsetBits = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @"subPixelInterpolationOffsetBits"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      "maxFramebufferWidth = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @"maxFramebufferWidth"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            "maxFramebufferHeight = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @"maxFramebufferHeight"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  "maxFramebufferLayers = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @"maxFramebufferLayers"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        "framebufferColorSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             @"framebufferColorSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              "framebufferDepthSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @"framebufferDepthSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    "framebufferStencilSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @"framebufferStencilSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          "framebufferNoAttachmentsSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @"framebufferNoAttachmentsSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "maxColorAttachments = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @"maxColorAttachments"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      "sampledImageColorSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @"sampledImageColorSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            "sampledImageIntegerSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @"sampledImageIntegerSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  "sampledImageDepthSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @"sampledImageDepthSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        "sampledImageStencilSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             @"sampledImageStencilSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              "storageImageSampleCounts = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @"storageImageSampleCounts"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    "maxSampleMaskWords = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @"maxSampleMaskWords"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          "timestampComputeAndGraphics = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @"timestampComputeAndGraphics"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "timestampPeriod = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @"timestampPeriod"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      "maxClipDistances = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @"maxClipDistances"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            "maxCullDistances = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @"maxCullDistances"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  "maxCombinedClipAndCullDistances = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @"maxCombinedClipAndCullDistances"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        "discreteQueuePriorities = "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          (getField
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             @"discreteQueuePriorities"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "pointSizeRange = ["
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 (let s = sizeOf
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (undefined
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ::
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               FieldType
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 "pointSizeRange"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      o = fieldOffset
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @"pointSizeRange"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @VkPhysicalDeviceLimits
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      f i
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        = peekByteOff
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (unsafePtr
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            i
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ::
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            IO
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              (FieldType
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 "pointSizeRange"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    in
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    unsafeDupablePerformIO
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      mapM
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        f
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      $
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      map
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        (\ i
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ->
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           o +
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             i *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               s)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        [0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ..
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         2 -
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           1])
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 showChar
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ']')
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ", "
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                (showString
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   "lineWidthRange = ["
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   .
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   showsPrec
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     (let s = sizeOf
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                (undefined
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ::
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   FieldType
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     "lineWidthRange"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     VkPhysicalDeviceLimits)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          o = fieldOffset
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @"lineWidthRange"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @VkPhysicalDeviceLimits
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          f i
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            = peekByteOff
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                (unsafePtr
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                i
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ::
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         