# web3-tools

[![CI](https://github.com/gtollini/web3-tools/actions/workflows/ci.yml/badge.svg)](https://github.com/gtollini/web3-tools/actions/workflows/ci.yml)

A Haskell library providing simple, reusable cryptographic utilities for Web3 development.

This is a small, focused library that I maintain and expand as needed. Contributions, feature requests, and suggestions are always welcome!

## Features

- **Ethereum signature verification** - Verify ECDSA signatures against addresses
- **Address recovery** - Recover Ethereum addresses from message signatures
- **Secp256k1 operations** - Low-level elliptic curve cryptography via FFI
- **Keccak256 hashing** - Ethereum-compatible hash function

## Module Structure

The library is organized to separate chain-agnostic crypto primitives from blockchain-specific implementations:

```
Crypto.*              -- Shared cryptographic primitives
  Crypto.Hash.Keccak  -- Keccak256 hashing
  Crypto.Secp256k1.*  -- Elliptic curve operations

Eth.*                 -- Ethereum-specific functionality
  Eth.Address         -- Signature verification and address recovery
```

This makes it easy to add support for other blockchains while reusing common cryptographic building blocks.

## Installation

**Requirements:**
- libsecp256k1-devel (or libsecp256k1-dev on Debian/Ubuntu)

**Using Stack:**
```bash
stack build
```

## Usage Example

```haskell
{-# LANGUAGE OverloadedStrings #-}
import Eth.Address (verifySignature)

-- Verify an Ethereum signature
main :: IO ()
main = do
  let message = "Hello, Web3!"
      signature = ... -- 65-byte signature (r || s || v)
      address = ...   -- 20-byte Ethereum address

  isValid <- verifySignature message signature address
  print isValid
```

## Contributing

This library grows based on practical needs. If you:
- Need a specific feature for your project
- Found a bug or issue
- Have suggestions for improvements
- Want to add support for another blockchain

Feel free to open an issue or submit a PR!

## License

MIT - See LICENSE file for details
