module Tests.Regressions
  ( tests,
  )
where

import qualified Test.Framework as F
import qualified Test.Framework.Providers.HUnit as F
import Tests.BoardTest
import Tests.FormedWordsTest
import Tests.FullGameTest
import Tests.Internationalisation.Spanish.LetterBagTest (makeSpanishBagTestSuccess)
import Tests.LetterBagTest
import Tests.MoveTest
import Tests.Internationalisation.Spanish.MoveTest (playSpanishMoveTest)
import Tests.Internationalisation.SpanishExtraRuleTest (testCannotPlayCandHOnOwn, testCanPlayCHtile, testCannotPlayCNextToExistingH)

tests :: F.Test
tests =
  F.testGroup
    "Regressions"
    [ F.testGroup
        "LetterBag"
        [ F.testCase "Letter bag returns error when makeBag file is invalidly formatted" makeBagInvalidlyFormattedBag,
          F.testCase "Letter bag from file parsed correctly" makeBagTestSuccess,
          F.testCase "Letter bag returns error when makeBag file path invalid" makeBagInvalidPath
        ],
      F.testGroup
        "Board"
        [ F.testCase "allSquares function behaves as expected" allSquaresTest,
          F.testCase "Board letters left function behaves as expected" lettersLeftTest,
          F.testCase "Board letters right function behaves as expected" lettersRightTest,
          F.testCase "Board letters above function behaves as expected" lettersAboveTest,
          F.testCase "Board letters below function behaves as expected" lettersBelowTest,
          F.testCase "Tiles can not be placed on empty squares" tilesPlacedConsecutivelyTest,
          F.testCase "occupiedSquareAt function behaves as expected" occupiedSquareAtTest,
          F.testCase "occupiedSquareAt function behaves as expected where the square is unoccupied" occupiedSquareAtUnoccupiedTest,
          F.testCase "unoccupiedSquareAt function behaves as expected where the square is unoccupied" unoccupiedSquareAtTest,
          F.testCase "unoccupiedSquareAt function behaves as expected where the square is occupied" unoccupiedSquareAtTestOccupied,
          F.testCase "Bonus squres and normal squares are where they are expected on the board" boardCorrectlyFormed,
          F.testCase "Text representation of empty board is 224 commas" textRepresentationEmptyBoardTest,
          F.testCase "Text representation of board with tiles contains expected letters" textRepresentationWithTilesTest,
          F.testCase "Text representation of board with blank tile uses square brackets" textRepresentationWithBlankTileTest,
          F.testCase "Loading empty text representation yields empty board" loadFromTextRepresentationEmptyBoardTest,
          F.testCase "Loading text representation with single tile works correctly" loadFromTextRepresentationSingleTileTest,
          F.testCase "Round-tripping board through text representation preserves tiles" textRepresentationRoundTripTest,
          F.testCase "Loading invalid text representation returns Nothing" loadFromTextRepresentationInvalidTileTest
        ],
      F.testGroup
        "FormedWord"
        [ F.testCase "Where placed tiles are prepended to other tiles on the board, they can be pretty printed" testPrettyPrintIntersectionPrepend,
          F.testCase "Where placed tiles are appended to other tiles on the board, they can be pretty printed" testPrettyPrintIntersectionAppend,
          F.testCase "Where placed tiles are placed in the middle of existing tiles the board, they can be pretty printed" testPrettyPrintThroughPlacedLetters,
          F.testCase "Words can be attached to the left of an existing word" attachLeftWord,
          F.testCase "Words can be attached to the right of an existing word" attachRightWord,
          F.testCase "Words can be attached to the top of an existing word" attachWordBelow,
          F.testCase "Words can be attached to the bottom of an existing word" attachAboveWord,
          F.testCase "Words can be attached to the top and bottom of an existing word" attachAboveAndBelow,
          F.testCase "Words can be attached to the left and right of an existing word" attachLeftAndRight,
          F.testCase "Words can be attached with adjacent words starting from the left" adjacentWordsLeft,
          F.testCase "Words can be attached with adjacent words starting from the right" adjacentWordsRight,
          F.testCase "Words can be attached with adjacent words starting from above" adjacentWordsAbove,
          F.testCase "Words can be attached with adjacent words starting from above" adjacentWordsBelow,
          F.testCase "Words can be formed from one letter starting from above" placedOneTileAbove,
          F.testCase "Words can be formed from one letter placed below" placedOneTileBelow,
          F.testCase "Words can be formed from one letter placed to the right of a word" placedOneTileRight,
          F.testCase "Words can be formed from one letter placed to the left of a word" placedOneTileLeft,
          F.testCase "Words can be formed by 'brushing' an existing word from the top" passesAbove,
          F.testCase "Words can be formed by 'brushing' an existing word from the bottom" passesBelow,
          F.testCase "Words formed can pass through two existing words" passesThroughTwoWords,
          F.testCase "A first word is valid if it passes through the star" firstWordThroughStar,
          F.testCase "A first word is invalid if it does not pass through the star" firstWordNotThroughStar,
          F.testCase "If a word does not connect with any words on the board, the expected error is returned" doesNotConnectWithWord,
          F.testCase "If a word forms a horizontal line, with one placed tile in the middle not in the line, the expected error is returned" nonContigiousHorizontal,
          F.testCase "If a word forms a vertical line, with one placed tile in the middle not in the line, the expected error is returned" nonContigiousVertical,
          F.testCase "Cannot placed a tile on a square which is already occupied" placeOnOccupiedSquare,
          F.testCase "Blah" testPrettyPrintIntersectionFirstWord
        ],
      F.testGroup
        "PlayGameTest"
        [ F.testCase "The full game playthrough test succeeds as expected" playThroughTest,
          F.testCase "The game is ended if all players skip twice consecutively" gameEndsOnConsecutiveSkips,
          F.testCase "The game is not ended if skips are not consecutive twice" gameDoesNotEndOnNonConsecutiveSkips,
          F.testCase "An exchange move behaves as expected" exchangeMoveExchangesLetters,
          F.testCase "A player is as expected in the returned MoveTransition" playerInMoveTransitionIsAsExpected
        ],
      F.testGroup
        "MoveTest"
        [ F.testCase "Cannot place a blank tile without an assigned level" movePlayedWithEmptyBlankTile,
          F.testCase "Cannot place a blank tile with an invalid letter" movePlayedWithInvalidBlankTileAssignment,
          F.testCase "Can place a blank tile with a valid assignment" movePlayedWithInvalidBlankTileAssignment
        ],
      F.testGroup
        "Internationalisation LetterBag"
        [ F.testCase "Can construct a spanish letter bag" makeSpanishBagTestSuccess,
          F.testCase "Can play a move in a game setup with a spanish dictionary and letter bag" playSpanishMoveTest
        ],
      F.testGroup "Extra Rules Tests (Spanish)" [
        F.testCase "Cannot play C and H tiles from a hand on their own" testCannotPlayCandHOnOwn,
        F.testCase  "Test can play CH tile" testCanPlayCHtile,
        F.testCase "Cannot play C next to existing H" testCannotPlayCNextToExistingH
      ]
    ]