{- |
We do not define a tag data type here,
since this is too much bound to the particular use
(e.g. list or tree structure).
However we define a tag name and some special names.
-}
module Text.XML.Basic.Tag (
   Name(..),
   doctype, doctypeString,
   cdata, cdataString,
   ) where

import Text.XML.Basic.Name as Name


newtype Name ident = Name {unname :: ident}
   deriving (Eq, Ord)

instance Show ident => Show (Name ident) where
   showsPrec p = showsPrec p . unname

instance Name.Tag ident => Name.C (Name ident) where
   fromString = Name . Name.tagFromString
   toString = Name.tagToString . unname




doctype :: (Name.Tag name) => Name name
doctype = Name.fromString doctypeString

cdata :: (Name.Tag name) => Name name
cdata = Name.fromString cdataString


doctypeString :: String
doctypeString = "DOCTYPE"

cdataString :: String
cdataString = "[CDATA["
