import Control.Exception (finally)
import Control.Monad (forever)
import XNobar.Internal.Scroller () -- import Show instance for XNobar.Internal.Notification.Notification
import XNobar.Server (fetch, startServer)
import Control.Concurrent (threadDelay)

main :: IO ()
main = do
  putStrLn "Starting the server"
  startServer >>= \case Left reply -> print reply
                        Right notifs -> do
                          putStrLn "Fetching notifications"
                          forever $ do
                            ns <- fetch notifs
                            threadDelay 100000
                            print $ show . snd <$> ns
