import Control.Concurrent (threadDelay)
import Control.Exception (finally)
import Control.Monad (forever)
import Data.Bifunctor (first)
import Data.Semigroup (Max(getMax))
import XNobar.Internal.Positive32 (Positive32(toWord32))
import XNobar.Internal.Scroller () -- import Show instance for XNobar.Internal.Notification.Notification
import XNobar.Server (fetch, startServer)

main :: IO ()
main = do
  putStrLn "Starting the server"
  startServer >>= \case Left reply -> print reply
                        Right notifs -> do
                          putStrLn "Fetching notifications"
                          forever $ do
                            ns <- fetch notifs
                            threadDelay 100000
                            print $ first (getMax . toWord32) <$> ns
