{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE RecordWildCards #-}

module Main (main) where

import Data.Semigroup ((<>))
import Options.Applicative
import System.Random (initStdGen, mkStdGen)

import Data.ByteString qualified as B
import Data.Text qualified as T
import Data.Text.IO qualified as TIO

import Game.ZY.Divination (Req (Req), divine)
import Paths_yiyd

-- | cli arguments
data Arguments = Arguments
  { quiet :: Bool
  , yao :: Bool
  , seed :: Maybe Int
  }

arguments :: Parser Arguments
arguments =
  Arguments
    <$> switch
      ( long "quiet"
          <> short 'q'
          <> help "Whether to be quiet. This will rewrite verbose options."
      )
    <*> switch
      ( long "yao"
          <> short 'y'
          <> help "Whether to print yao after the result. This is only used under quiet."
      )
    <*> option
      auto
      ( long "seed"
          <> short 's'
          <> help "Seed for generation. if omitted, a random one is generated."
          <> value Nothing
      )

main :: IO ()
main = do
  Arguments {..} <- execParser opts
  dataPath <- getDataFileName "zy.yml"
  strData <- B.readFile dataPath
  finalSeed <- maybe initStdGen (pure . mkStdGen) seed
  putStrLn $ "Seed is " ++ show finalSeed
  let req = Req quiet yao strData finalSeed
  TIO.putStrLn $ either handleError id $ divine req
  where
    handleError msg =
      T.concat
        [ "error: "
        , msg
        , "\n"
        , "Please contact to author about the issue."
        ]

opts :: ParserInfo Arguments
opts =
  info
    (arguments <**> helper)
    ( fullDesc
        <> progDesc "Print a greeting for TARGET"
        <> header "hello - a test for optparse-applicative"
    )
