module Game.ZY.DivinationSpec (spec) where

import System.Random (initStdGen)
import Test.Hspec

import Data.ByteString qualified as BS
import Data.Either (isRight)

import Game.ZY.Divination (Req (..), divine)
import Paths_yiyd

spec :: Spec
spec =
  it "divine" $ do
    zhouyiData <- getDataFileName "zy.yml" >>= BS.readFile
    seed <- initStdGen
    let req =
          Req
            { quiet = True
            , yao = False
            , zhouyiText = zhouyiData
            , seed = seed
            }
    isRight (divine req) `shouldBe` True
